import numpy
from numpy import array, nan, inf

version = '1.5.0'
cuda    = '7.0'
device  = 'Kepler K40c'
cpu     = '2x8 core Sandy Bridge E5-2670'

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/cgeev.txt
# numactl --interleave=all ./testing_cgeev -RN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cgeev_RN = array([
	[    10,  nan,    0.00 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.00 ],
	[    60,  nan,    0.00 ],
	[    70,  nan,    0.01 ],
	[    80,  nan,    0.01 ],
	[    90,  nan,    0.01 ],
	[   100,  nan,    0.01 ],
	[   200,  nan,    0.06 ],
	[   300,  nan,    0.10 ],
	[   400,  nan,    0.15 ],
	[   500,  nan,    0.21 ],
	[   600,  nan,    0.37 ],
	[   700,  nan,    0.48 ],
	[   800,  nan,    0.56 ],
	[   900,  nan,    0.71 ],
	[  1000,  nan,    0.80 ],
	[  2000,  nan,    2.55 ],
	[  3000,  nan,    7.55 ],
	[  4000,  nan,   11.85 ],
	[  5000,  nan,   17.77 ],
	[  6000,  nan,   35.12 ],
	[  7000,  nan,   48.50 ],
	[  8000,  nan,   61.36 ],
	[  9000,  nan,   76.84 ],
	[ 10000,  nan,   92.36 ],
	[ 12000,  nan,  139.43 ],
	[ 14000,  nan,  187.10 ],
	[ 16000,  nan,  255.98 ],
	[ 18000,  nan,  320.73 ],
	[ 20000,  nan,  414.22 ],
])

# numactl --interleave=all ./testing_cgeev -RV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cgeev_RV = array([
	[    10,  nan,    0.00 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.01 ],
	[    60,  nan,    0.01 ],
	[    70,  nan,    0.01 ],
	[    80,  nan,    0.01 ],
	[    90,  nan,    0.01 ],
	[   100,  nan,    0.02 ],
	[   200,  nan,    0.07 ],
	[   300,  nan,    0.13 ],
	[   400,  nan,    0.24 ],
	[   500,  nan,    0.25 ],
	[   600,  nan,    0.45 ],
	[   700,  nan,    0.55 ],
	[   800,  nan,    0.68 ],
	[   900,  nan,    0.88 ],
	[  1000,  nan,    0.97 ],
	[  2000,  nan,    3.69 ],
	[  3000,  nan,    9.72 ],
	[  4000,  nan,   17.47 ],
	[  5000,  nan,   29.46 ],
	[  6000,  nan,   54.10 ],
	[  7000,  nan,   71.11 ],
	[  8000,  nan,   97.69 ],
	[  9000,  nan,  127.25 ],
	[ 10000,  nan,  161.01 ],
	[ 12000,  nan,  251.55 ],
	[ 14000,  nan,  353.10 ],
	[ 16000,  nan,  486.33 ],
	[ 18000,  nan,  659.73 ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/cgeqrf.txt
# numactl --interleave=all ./testing_cgeqrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cgeqrf = array([
	[    10,     10,  nan,  nan,     0.24,   0.00,  nan ],
	[    20,     20,  nan,  nan,     1.15,   0.00,  nan ],
	[    30,     30,  nan,  nan,     2.70,   0.00,  nan ],
	[    40,     40,  nan,  nan,     4.49,   0.00,  nan ],
	[    50,     50,  nan,  nan,     5.93,   0.00,  nan ],
	[    60,     60,  nan,  nan,     7.25,   0.00,  nan ],
	[    70,     70,  nan,  nan,     1.77,   0.00,  nan ],
	[    80,     80,  nan,  nan,     2.55,   0.00,  nan ],
	[    90,     90,  nan,  nan,     3.33,   0.00,  nan ],
	[   100,    100,  nan,  nan,     4.34,   0.00,  nan ],
	[   200,    200,  nan,  nan,    11.87,   0.00,  nan ],
	[   300,    300,  nan,  nan,    25.62,   0.01,  nan ],
	[   400,    400,  nan,  nan,    39.15,   0.01,  nan ],
	[   500,    500,  nan,  nan,    57.54,   0.01,  nan ],
	[   600,    600,  nan,  nan,    74.58,   0.02,  nan ],
	[   700,    700,  nan,  nan,    92.93,   0.02,  nan ],
	[   800,    800,  nan,  nan,   119.90,   0.02,  nan ],
	[   900,    900,  nan,  nan,   139.50,   0.03,  nan ],
	[  1000,   1000,  nan,  nan,   160.19,   0.03,  nan ],
	[  2000,   2000,  nan,  nan,   464.97,   0.09,  nan ],
	[  3000,   3000,  nan,  nan,   805.28,   0.18,  nan ],
	[  4000,   4000,  nan,  nan,  1171.38,   0.29,  nan ],
	[  5000,   5000,  nan,  nan,  1312.35,   0.51,  nan ],
	[  6000,   6000,  nan,  nan,  1615.34,   0.71,  nan ],
	[  7000,   7000,  nan,  nan,  1814.43,   1.01,  nan ],
	[  8000,   8000,  nan,  nan,  1963.68,   1.39,  nan ],
	[  9000,   9000,  nan,  nan,  2086.49,   1.86,  nan ],
	[ 10000,  10000,  nan,  nan,  2160.64,   2.47,  nan ],
	[ 12000,  12000,  nan,  nan,  2245.60,   4.10,  nan ],
	[ 14000,  14000,  nan,  nan,  2348.00,   6.23,  nan ],
	[ 16000,  16000,  nan,  nan,  2360.41,   9.26,  nan ],
	[ 18000,  18000,  nan,  nan,  2375.64,  13.09,  nan ],
	[ 20000,  20000,  nan,  nan,  2423.19,  17.61,  nan ],
])

# numactl --interleave=all ./testing_cgeqrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cgeqrf_gpu = array([
	[    10,     10,  nan,  nan,     0.01,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.05,   0.00,  nan ],
	[    30,     30,  nan,  nan,     0.17,   0.00,  nan ],
	[    40,     40,  nan,  nan,     0.33,   0.00,  nan ],
	[    50,     50,  nan,  nan,     0.62,   0.00,  nan ],
	[    60,     60,  nan,  nan,     1.03,   0.00,  nan ],
	[    70,     70,  nan,  nan,     0.99,   0.00,  nan ],
	[    80,     80,  nan,  nan,     1.48,   0.00,  nan ],
	[    90,     90,  nan,  nan,     2.18,   0.00,  nan ],
	[   100,    100,  nan,  nan,     5.44,   0.00,  nan ],
	[   200,    200,  nan,  nan,     8.58,   0.01,  nan ],
	[   300,    300,  nan,  nan,    21.61,   0.01,  nan ],
	[   400,    400,  nan,  nan,    34.58,   0.01,  nan ],
	[   500,    500,  nan,  nan,    53.53,   0.01,  nan ],
	[   600,    600,  nan,  nan,    72.98,   0.02,  nan ],
	[   700,    700,  nan,  nan,    95.55,   0.02,  nan ],
	[   800,    800,  nan,  nan,   116.02,   0.02,  nan ],
	[   900,    900,  nan,  nan,   142.03,   0.03,  nan ],
	[  1000,   1000,  nan,  nan,   168.84,   0.03,  nan ],
	[  2000,   2000,  nan,  nan,   468.10,   0.09,  nan ],
	[  3000,   3000,  nan,  nan,   816.00,   0.18,  nan ],
	[  4000,   4000,  nan,  nan,  1188.32,   0.29,  nan ],
	[  5000,   5000,  nan,  nan,  1246.02,   0.54,  nan ],
	[  6000,   6000,  nan,  nan,  1466.15,   0.79,  nan ],
	[  7000,   7000,  nan,  nan,  1648.23,   1.11,  nan ],
	[  8000,   8000,  nan,  nan,  1914.82,   1.43,  nan ],
	[  9000,   9000,  nan,  nan,  1910.97,   2.03,  nan ],
	[ 10000,  10000,  nan,  nan,  1955.22,   2.73,  nan ],
	[ 12000,  12000,  nan,  nan,  2176.58,   4.23,  nan ],
	[ 14000,  14000,  nan,  nan,  2303.54,   6.35,  nan ],
	[ 16000,  16000,  nan,  nan,  2341.02,   9.33,  nan ],
	[ 18000,  18000,  nan,  nan,  2359.87,  13.18,  nan ],
	[ 20000,  20000,  nan,  nan,  2435.09,  17.52,  nan ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/cgetrf.txt
# numactl --interleave=all ./testing_cgetrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cgetrf = array([
	[    10,     10,  nan,  nan,     0.27,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.77,  0.00,  nan ],
	[    30,     30,  nan,  nan,     1.87,  0.00,  nan ],
	[    40,     40,  nan,  nan,     3.38,  0.00,  nan ],
	[    50,     50,  nan,  nan,     4.54,  0.00,  nan ],
	[    60,     60,  nan,  nan,     2.66,  0.00,  nan ],
	[    70,     70,  nan,  nan,     1.03,  0.00,  nan ],
	[    80,     80,  nan,  nan,     1.36,  0.00,  nan ],
	[    90,     90,  nan,  nan,     1.82,  0.00,  nan ],
	[   100,    100,  nan,  nan,     2.61,  0.00,  nan ],
	[   200,    200,  nan,  nan,    12.00,  0.00,  nan ],
	[   300,    300,  nan,  nan,    26.88,  0.00,  nan ],
	[   400,    400,  nan,  nan,    45.57,  0.00,  nan ],
	[   500,    500,  nan,  nan,    66.94,  0.00,  nan ],
	[   600,    600,  nan,  nan,    89.86,  0.01,  nan ],
	[   700,    700,  nan,  nan,   113.42,  0.01,  nan ],
	[   800,    800,  nan,  nan,   141.16,  0.01,  nan ],
	[   900,    900,  nan,  nan,   167.06,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,   193.47,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,   492.24,  0.04,  nan ],
	[  3000,   3000,  nan,  nan,   840.60,  0.09,  nan ],
	[  4000,   4000,  nan,  nan,  1069.88,  0.16,  nan ],
	[  5000,   5000,  nan,  nan,  1106.83,  0.30,  nan ],
	[  6000,   6000,  nan,  nan,  1360.64,  0.42,  nan ],
	[  7000,   7000,  nan,  nan,  1568.24,  0.58,  nan ],
	[  8000,   8000,  nan,  nan,  1735.00,  0.79,  nan ],
	[  9000,   9000,  nan,  nan,  1734.47,  1.12,  nan ],
	[ 10000,  10000,  nan,  nan,  1866.15,  1.43,  nan ],
	[ 12000,  12000,  nan,  nan,  2075.12,  2.22,  nan ],
	[ 14000,  14000,  nan,  nan,  2247.80,  3.26,  nan ],
	[ 16000,  16000,  nan,  nan,  2360.83,  4.63,  nan ],
	[ 18000,  18000,  nan,  nan,  2433.14,  6.39,  nan ],
	[ 20000,  20000,  nan,  nan,  2501.32,  8.53,  nan ],
])

# numactl --interleave=all ./testing_cgetrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cgetrf_gpu = array([
	[    10,     10,  nan,  nan,     0.06,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.31,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.94,  0.00,  nan ],
	[    40,     40,  nan,  nan,     2.02,  0.00,  nan ],
	[    50,     50,  nan,  nan,     2.85,  0.00,  nan ],
	[    60,     60,  nan,  nan,     2.22,  0.00,  nan ],
	[    70,     70,  nan,  nan,     0.57,  0.00,  nan ],
	[    80,     80,  nan,  nan,     0.86,  0.00,  nan ],
	[    90,     90,  nan,  nan,     1.11,  0.00,  nan ],
	[   100,    100,  nan,  nan,     1.49,  0.00,  nan ],
	[   200,    200,  nan,  nan,     7.60,  0.00,  nan ],
	[   300,    300,  nan,  nan,    19.35,  0.00,  nan ],
	[   400,    400,  nan,  nan,    34.59,  0.00,  nan ],
	[   500,    500,  nan,  nan,    54.02,  0.01,  nan ],
	[   600,    600,  nan,  nan,    72.22,  0.01,  nan ],
	[   700,    700,  nan,  nan,    95.06,  0.01,  nan ],
	[   800,    800,  nan,  nan,   120.81,  0.01,  nan ],
	[   900,    900,  nan,  nan,   153.90,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,   211.21,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,   563.96,  0.04,  nan ],
	[  3000,   3000,  nan,  nan,  1001.87,  0.07,  nan ],
	[  4000,   4000,  nan,  nan,  1309.50,  0.13,  nan ],
	[  5000,   5000,  nan,  nan,  1080.90,  0.31,  nan ],
	[  6000,   6000,  nan,  nan,  1378.62,  0.42,  nan ],
	[  7000,   7000,  nan,  nan,  1610.78,  0.57,  nan ],
	[  8000,   8000,  nan,  nan,  1847.55,  0.74,  nan ],
	[  9000,   9000,  nan,  nan,  1967.49,  0.99,  nan ],
	[ 10000,  10000,  nan,  nan,  2114.02,  1.26,  nan ],
	[ 12000,  12000,  nan,  nan,  2345.70,  1.96,  nan ],
	[ 14000,  14000,  nan,  nan,  2469.35,  2.96,  nan ],
	[ 16000,  16000,  nan,  nan,  2570.63,  4.25,  nan ],
	[ 18000,  18000,  nan,  nan,  2630.74,  5.91,  nan ],
	[ 20000,  20000,  nan,  nan,  2679.95,  7.96,  nan ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/cheevd.txt
# numactl --interleave=all ./testing_cheevd -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cheevd_JN = array([
	[    10,  nan,    0.00 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.00 ],
	[    60,  nan,    0.00 ],
	[    70,  nan,    0.00 ],
	[    80,  nan,    0.00 ],
	[    90,  nan,    0.00 ],
	[   100,  nan,    0.00 ],
	[   200,  nan,    0.01 ],
	[   300,  nan,    0.01 ],
	[   400,  nan,    0.02 ],
	[   500,  nan,    0.03 ],
	[   600,  nan,    0.04 ],
	[   700,  nan,    0.06 ],
	[   800,  nan,    0.08 ],
	[   900,  nan,    0.10 ],
	[  1000,  nan,    0.12 ],
	[  2000,  nan,    0.43 ],
	[  3000,  nan,    2.68 ],
	[  4000,  nan,    5.64 ],
	[  5000,  nan,   10.13 ],
	[  6000,  nan,   16.74 ],
	[  7000,  nan,   24.72 ],
	[  8000,  nan,   35.34 ],
	[  9000,  nan,   49.54 ],
	[ 10000,  nan,   65.21 ],
	[ 12000,  nan,  108.43 ],
	[ 14000,  nan,  166.69 ],
	[ 16000,  nan,  243.66 ],
	[ 18000,  nan,  340.31 ],
	[ 20000,  nan,  463.44 ],
])

# numactl --interleave=all ./testing_cheevd -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cheevd_JV = array([
	[    10,  nan,    0.00 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.00 ],
	[    60,  nan,    0.00 ],
	[    70,  nan,    0.00 ],
	[    80,  nan,    0.01 ],
	[    90,  nan,    0.00 ],
	[   100,  nan,    0.00 ],
	[   200,  nan,    0.01 ],
	[   300,  nan,    0.02 ],
	[   400,  nan,    0.03 ],
	[   500,  nan,    0.04 ],
	[   600,  nan,    0.05 ],
	[   700,  nan,    0.06 ],
	[   800,  nan,    0.09 ],
	[   900,  nan,    0.11 ],
	[  1000,  nan,    0.13 ],
	[  2000,  nan,    0.51 ],
	[  3000,  nan,    2.90 ],
	[  4000,  nan,    6.00 ],
	[  5000,  nan,   10.78 ],
	[  6000,  nan,   17.72 ],
	[  7000,  nan,   26.22 ],
	[  8000,  nan,   37.45 ],
	[  9000,  nan,   52.33 ],
	[ 10000,  nan,   68.75 ],
	[ 12000,  nan,  114.34 ],
	[ 14000,  nan,  175.81 ],
	[ 16000,  nan,  256.62 ],
	[ 18000,  nan,  359.28 ],
	[ 20000,  nan,  488.53 ],
])

# numactl --interleave=all ./testing_cheevd_gpu -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cheevd_gpu_JN = array([
	[    10,  nan,    0.00 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.00 ],
	[    60,  nan,    0.00 ],
	[    70,  nan,    0.00 ],
	[    80,  nan,    0.00 ],
	[    90,  nan,    0.00 ],
	[   100,  nan,    0.00 ],
	[   200,  nan,    0.01 ],
	[   300,  nan,    0.01 ],
	[   400,  nan,    0.02 ],
	[   500,  nan,    0.03 ],
	[   600,  nan,    0.04 ],
	[   700,  nan,    0.05 ],
	[   800,  nan,    0.07 ],
	[   900,  nan,    0.08 ],
	[  1000,  nan,    0.10 ],
	[  2000,  nan,    0.43 ],
	[  3000,  nan,    2.66 ],
	[  4000,  nan,    5.65 ],
	[  5000,  nan,   10.11 ],
	[  6000,  nan,   16.32 ],
	[  7000,  nan,   24.67 ],
	[  8000,  nan,   35.28 ],
	[  9000,  nan,   48.63 ],
	[ 10000,  nan,   65.22 ],
	[ 12000,  nan,  108.32 ],
	[ 14000,  nan,  166.87 ],
	[ 16000,  nan,  243.29 ],
	[ 18000,  nan,  341.62 ],
	[ 20000,  nan,  462.73 ],
])

# numactl --interleave=all ./testing_cheevd_gpu -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cheevd_gpu_JV = array([
	[    10,  nan,    0.00 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.00 ],
	[    60,  nan,    0.00 ],
	[    70,  nan,    0.00 ],
	[    80,  nan,    0.00 ],
	[    90,  nan,    0.00 ],
	[   100,  nan,    0.00 ],
	[   200,  nan,    0.01 ],
	[   300,  nan,    0.02 ],
	[   400,  nan,    0.03 ],
	[   500,  nan,    0.05 ],
	[   600,  nan,    0.05 ],
	[   700,  nan,    0.07 ],
	[   800,  nan,    0.08 ],
	[   900,  nan,    0.11 ],
	[  1000,  nan,    0.13 ],
	[  2000,  nan,    0.49 ],
	[  3000,  nan,    2.84 ],
	[  4000,  nan,    5.98 ],
	[  5000,  nan,   10.74 ],
	[  6000,  nan,   17.35 ],
	[  7000,  nan,   26.12 ],
	[  8000,  nan,   37.52 ],
	[  9000,  nan,   51.59 ],
	[ 10000,  nan,   69.22 ],
	[ 12000,  nan,  114.89 ],
	[ 14000,  nan,  177.08 ],
	[ 16000,  nan,  258.34 ],
	[ 18000,  nan,  363.04 ],
	[ 20000,  nan,  492.99 ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/cheevd_2stage.txt
# numactl --interleave=all ./testing_cheevdx_2stage -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cheevdx_2stage_JN = array([
	[   200,    200,   0.00 ],
	[   300,    300,   0.02 ],
	[   400,    400,   0.04 ],
	[   500,    500,   0.07 ],
	[   600,    600,   0.08 ],
	[   700,    700,   0.12 ],
	[   800,    800,   0.13 ],
	[   900,    900,   0.16 ],
	[  1000,   1000,   0.18 ],
	[  2000,   2000,   0.50 ],
	[  3000,   3000,   0.94 ],
	[  4000,   4000,   1.56 ],
	[  5000,   5000,   2.16 ],
	[  6000,   6000,   2.88 ],
	[  7000,   7000,   4.03 ],
	[  8000,   8000,   5.05 ],
	[  9000,   9000,   5.91 ],
	[ 10000,  10000,   7.42 ],
	[ 12000,  12000,  10.74 ],
	[ 14000,  14000,  14.85 ],
	[ 16000,  16000,  20.26 ],
	[ 18000,  18000,  26.59 ],
	[ 20000,  20000,  34.08 ],
])

# numactl --interleave=all ./testing_cheevdx_2stage -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cheevdx_2stage_JV = array([
	[    10,     10,    0.00 ],
	[    20,     20,    0.00 ],
	[    30,     30,    0.00 ],
	[    40,     40,    0.00 ],
	[    50,     50,    0.00 ],
	[    60,     60,    0.00 ],
	[    70,     70,    0.00 ],
	[    80,     80,    0.00 ],
	[    90,     90,    0.00 ],
	[   100,    100,    0.00 ],
	[   200,    200,    0.01 ],
	[   300,    300,    0.03 ],
	[   400,    400,    0.05 ],
	[   500,    500,    0.08 ],
	[   600,    600,    0.10 ],
	[   700,    700,    0.13 ],
	[   800,    800,    0.16 ],
	[   900,    900,    0.20 ],
	[  1000,   1000,    0.23 ],
	[  2000,   2000,    0.64 ],
	[  3000,   3000,    1.30 ],
	[  4000,   4000,    2.26 ],
	[  5000,   5000,    3.46 ],
	[  6000,   6000,    5.19 ],
	[  7000,   7000,    6.99 ],
	[  8000,   8000,    9.80 ],
	[  9000,   9000,   13.58 ],
	[ 10000,  10000,   17.03 ],
	[ 12000,  12000,   27.32 ],
	[ 14000,  14000,   40.81 ],
	[ 16000,  16000,   59.43 ],
	[ 18000,  18000,   86.75 ],
	[ 20000,  20000,  115.12 ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/chemv.txt
# numactl --interleave=all ./testing_chemv -N 100 -N 1000 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000
chemv_L = array([
	[    10,    0.03,   0.03,    0.03,   0.03,   0.04,   0.02,   0.48,    0.00,  1.43e-07,  1.92e-07,  1.43e-07,  nan ],
	[    11,    0.04,   0.03,    0.05,   0.02,   0.05,   0.02,   0.51,    0.00,  2.45e-07,  3.13e-07,  2.45e-07,  nan ],
	[    12,    0.04,   0.03,    0.05,   0.03,   0.06,   0.02,   1.36,    0.00,  2.87e-07,  1.59e-07,  2.51e-07,  nan ],
	[    13,    0.05,   0.03,    0.06,   0.03,   0.07,   0.02,   0.70,    0.00,  1.73e-07,  1.64e-07,  1.47e-07,  nan ],
	[    14,    0.06,   0.03,    0.07,   0.03,   0.08,   0.02,   0.81,    0.00,  1.52e-07,  1.52e-07,  2.04e-07,  nan ],
	[    15,    0.07,   0.03,    0.08,   0.03,   0.09,   0.02,   0.92,    0.00,  2.17e-07,  1.91e-07,  2.29e-07,  nan ],
	[    16,    0.07,   0.03,    0.09,   0.02,   0.11,   0.02,   0.72,    0.00,  1.69e-07,  2.46e-07,  1.69e-07,  nan ],
	[    17,    0.08,   0.03,    0.10,   0.03,   0.10,   0.02,   1.17,    0.00,  1.16e-07,  1.68e-07,  1.25e-07,  nan ],
	[    18,    0.09,   0.03,    0.11,   0.03,   0.12,   0.02,   1.31,    0.00,  2.18e-07,  3.35e-07,  2.12e-07,  nan ],
	[    19,    0.10,   0.03,    0.12,   0.03,   0.12,   0.03,   1.01,    0.00,  2.07e-07,  2.07e-07,  2.01e-07,  nan ],
	[    20,    0.11,   0.03,    0.13,   0.03,   0.14,   0.03,   1.80,    0.00,  1.91e-07,  1.91e-07,  2.13e-07,  nan ],
	[    21,    0.12,   0.03,    0.14,   0.03,   0.16,   0.02,   1.22,    0.00,  3.27e-07,  2.72e-07,  2.03e-07,  nan ],
	[    22,    0.11,   0.04,    0.15,   0.03,   0.17,   0.02,   1.45,    0.00,  2.74e-07,  2.60e-07,  1.94e-07,  nan ],
	[    23,    0.15,   0.03,    0.17,   0.03,   0.18,   0.03,   1.58,    0.00,  1.96e-07,  2.07e-07,  2.23e-07,  nan ],
	[    24,    0.16,   0.03,    0.18,   0.03,   0.20,   0.03,   1.58,    0.00,  2.51e-07,  2.51e-07,  2.51e-07,  nan ],
	[    25,    0.17,   0.03,    0.20,   0.03,   0.19,   0.03,   1.71,    0.00,  2.41e-07,  2.56e-07,  1.71e-07,  nan ],
	[    26,    0.18,   0.03,    0.21,   0.03,   0.22,   0.03,   2.00,    0.00,  2.20e-07,  1.64e-07,  2.20e-07,  nan ],
	[    27,    0.19,   0.03,    0.22,   0.03,   0.25,   0.02,   2.15,    0.00,  1.58e-07,  1.58e-07,  1.58e-07,  nan ],
	[    28,    0.21,   0.03,    0.24,   0.03,   0.25,   0.03,   2.13,    0.00,  3.41e-07,  2.81e-07,  3.41e-07,  nan ],
	[    29,    0.22,   0.03,    0.25,   0.03,   0.27,   0.03,   2.28,    0.00,  2.10e-07,  1.47e-07,  2.25e-07,  nan ],
	[    30,    0.24,   0.03,    0.27,   0.03,   0.30,   0.03,   2.44,    0.00,  3.18e-07,  2.01e-07,  1.59e-07,  nan ],
	[    31,    0.25,   0.03,    0.28,   0.03,   0.31,   0.03,   2.11,    0.00,  1.74e-07,  2.48e-07,  2.63e-07,  nan ],
	[    32,    0.28,   0.03,    0.29,   0.03,   0.32,   0.03,   2.77,    0.00,  1.88e-07,  1.69e-07,  2.67e-07,  nan ],
	[    33,    0.29,   0.03,    0.27,   0.03,   0.34,   0.03,   2.39,    0.00,  2.38e-07,  1.73e-07,  2.31e-07,  nan ],
	[    34,    0.30,   0.03,    0.28,   0.03,   0.36,   0.03,   2.38,    0.00,  2.65e-07,  1.91e-07,  2.80e-07,  nan ],
	[    35,    0.32,   0.03,    0.31,   0.03,   0.38,   0.03,   2.68,    0.00,  1.96e-07,  2.18e-07,  1.74e-07,  nan ],
	[    36,    0.35,   0.03,    0.33,   0.03,   0.40,   0.03,   3.77,    0.00,  2.28e-07,  1.91e-07,  3.22e-07,  nan ],
	[    37,    0.37,   0.03,    0.33,   0.03,   0.41,   0.03,   2.81,    0.00,  2.58e-07,  3.10e-07,  2.43e-07,  nan ],
	[    38,    0.37,   0.03,    0.36,   0.03,   0.43,   0.03,   2.96,    0.00,  3.05e-07,  3.02e-07,  1.81e-07,  nan ],
	[    39,    0.40,   0.03,    0.37,   0.03,   0.46,   0.03,   3.12,    0.00,  2.19e-07,  2.94e-07,  3.28e-07,  nan ],
	[    40,    0.42,   0.03,    0.42,   0.03,   0.51,   0.03,   3.48,    0.00,  2.90e-07,  2.86e-07,  3.02e-07,  nan ],
	[    41,    0.45,   0.03,    0.44,   0.03,   0.54,   0.03,   2.78,    0.01,  2.08e-07,  1.95e-07,  2.08e-07,  nan ],
	[    42,    0.47,   0.03,    0.44,   0.03,   0.56,   0.03,   2.92,    0.01,  2.95e-07,  2.76e-07,  3.05e-07,  nan ],
	[    43,    0.47,   0.03,    0.48,   0.03,   0.58,   0.03,   3.78,    0.00,  3.20e-07,  3.76e-07,  3.20e-07,  nan ],
	[    44,    0.52,   0.03,    0.50,   0.03,   0.62,   0.03,   3.20,    0.01,  2.91e-07,  3.13e-07,  2.74e-07,  nan ],
	[    45,    0.52,   0.03,    0.51,   0.03,   0.60,   0.03,   3.34,    0.01,  2.68e-07,  2.40e-07,  2.68e-07,  nan ],
	[    46,    0.56,   0.03,    0.55,   0.03,   0.70,   0.03,   3.49,    0.01,  2.78e-07,  3.42e-07,  2.99e-07,  nan ],
	[    47,    0.57,   0.03,    0.57,   0.03,   0.73,   0.03,   3.06,    0.01,  2.03e-07,  2.47e-07,  1.81e-07,  nan ],
	[    48,    0.61,   0.03,    0.59,   0.03,   0.77,   0.02,   3.80,    0.01,  2.46e-07,  3.28e-07,  2.42e-07,  nan ],
	[    49,    0.62,   0.03,    0.60,   0.03,   0.71,   0.03,   3.95,    0.01,  3.11e-07,  3.97e-07,  3.21e-07,  nan ],
	[    50,    0.64,   0.03,    0.63,   0.03,   0.74,   0.03,   4.11,    0.01,  3.15e-07,  3.41e-07,  3.41e-07,  nan ],
	[    51,    0.69,   0.03,    0.63,   0.03,   0.77,   0.03,   3.59,    0.01,  2.70e-07,  3.35e-07,  2.70e-07,  nan ],
	[    52,    0.70,   0.03,    0.64,   0.04,   0.77,   0.03,   5.49,    0.00,  3.67e-07,  3.02e-07,  3.02e-07,  nan ],
	[    53,    0.72,   0.03,    0.66,   0.04,   0.78,   0.03,   3.88,    0.01,  2.52e-07,  2.88e-07,  2.16e-07,  nan ],
	[    54,    0.75,   0.03,    0.68,   0.04,   0.86,   0.03,   4.79,    0.01,  3.00e-07,  2.23e-07,  2.23e-07,  nan ],
	[    55,    0.75,   0.03,    0.71,   0.04,   0.85,   0.03,   4.17,    0.01,  3.10e-07,  2.22e-07,  2.19e-07,  nan ],
	[    56,    0.81,   0.03,    0.74,   0.04,   0.92,   0.03,   5.15,    0.01,  2.46e-07,  2.72e-07,  2.15e-07,  nan ],
	[    57,    0.83,   0.03,    0.79,   0.03,   0.92,   0.03,   4.48,    0.01,  3.35e-07,  2.99e-07,  2.99e-07,  nan ],
	[    58,    0.86,   0.03,    0.77,   0.04,   0.96,   0.03,   3.99,    0.01,  2.79e-07,  4.00e-07,  3.54e-07,  nan ],
	[    59,    0.86,   0.03,    0.81,   0.04,   0.95,   0.03,   4.79,    0.01,  3.23e-07,  2.74e-07,  2.74e-07,  nan ],
	[    60,    0.90,   0.03,    0.87,   0.03,   0.98,   0.03,   4.95,    0.01,  2.62e-07,  2.62e-07,  2.01e-07,  nan ],
	[    61,    0.93,   0.03,    0.87,   0.04,   1.06,   0.03,   4.41,    0.01,  3.54e-07,  3.13e-07,  3.96e-07,  nan ],
	[    62,    0.95,   0.03,    0.87,   0.04,   1.09,   0.03,   4.40,    0.01,  3.08e-07,  2.54e-07,  2.54e-07,  nan ],
	[    63,    0.99,   0.03,    0.90,   0.04,   1.08,   0.03,   4.01,    0.01,  2.57e-07,  2.18e-07,  2.44e-07,  nan ],
	[    64,    1.05,   0.03,    0.96,   0.03,   1.12,   0.03,   4.69,    0.01,  3.63e-07,  3.63e-07,  3.58e-07,  nan ],
	[    65,    0.91,   0.04,    0.94,   0.04,   1.08,   0.03,   4.83,    0.01,  3.63e-07,  3.71e-07,  2.62e-07,  nan ],
	[    66,    0.93,   0.04,    1.02,   0.04,   1.15,   0.03,   4.53,    0.01,  2.89e-07,  3.57e-07,  3.52e-07,  nan ],
	[    67,    0.94,   0.04,    1.05,   0.03,   1.14,   0.03,   4.67,    0.01,  2.85e-07,  3.46e-07,  3.60e-07,  nan ],
	[    68,    0.97,   0.04,    1.09,   0.03,   1.18,   0.03,   4.66,    0.01,  4.05e-07,  2.80e-07,  3.37e-07,  nan ],
	[    69,    1.03,   0.04,    1.08,   0.04,   1.05,   0.04,   4.95,    0.01,  3.50e-07,  2.47e-07,  3.36e-07,  nan ],
	[    70,    1.05,   0.04,    1.14,   0.04,   1.25,   0.03,   6.72,    0.01,  3.93e-07,  2.72e-07,  2.72e-07,  nan ],
	[    71,    1.09,   0.04,    1.11,   0.04,   1.28,   0.03,   5.96,    0.01,  5.40e-07,  5.37e-07,  4.33e-07,  nan ],
	[    72,    0.62,   0.07,    1.15,   0.04,   1.33,   0.03,   5.38,    0.01,  2.69e-07,  3.33e-07,  2.65e-07,  nan ],
	[    73,    1.18,   0.04,    1.24,   0.04,   1.45,   0.03,   4.93,    0.01,  3.51e-07,  4.31e-07,  3.30e-07,  nan ],
	[    74,    1.20,   0.04,    1.31,   0.03,   1.49,   0.03,   4.46,    0.01,  2.58e-07,  3.26e-07,  3.14e-07,  nan ],
	[    75,    1.24,   0.04,    1.35,   0.03,   1.48,   0.03,   4.58,    0.01,  4.44e-07,  3.31e-07,  3.22e-07,  nan ],
	[    76,    1.28,   0.04,    1.34,   0.04,   1.52,   0.03,   5.20,    0.01,  3.62e-07,  3.17e-07,  3.05e-07,  nan ],
	[    77,    1.31,   0.04,    1.39,   0.03,   1.51,   0.03,   5.34,    0.01,  2.22e-07,  2.48e-07,  3.13e-07,  nan ],
	[    78,    1.30,   0.04,    1.38,   0.04,   1.55,   0.03,   4.95,    0.01,  3.28e-07,  3.94e-07,  3.28e-07,  nan ],
	[    79,    1.33,   0.04,    1.46,   0.03,   1.59,   0.03,   5.62,    0.01,  3.98e-07,  4.85e-07,  3.89e-07,  nan ],
	[    80,    1.38,   0.04,    1.45,   0.04,   1.63,   0.03,   5.76,    0.01,  2.95e-07,  2.95e-07,  2.86e-07,  nan ],
	[    81,    1.38,   0.04,    1.45,   0.04,   1.57,   0.03,   5.34,    0.01,  4.21e-07,  2.98e-07,  4.02e-07,  nan ],
	[    82,    1.41,   0.04,    1.52,   0.04,   1.62,   0.03,   4.99,    0.01,  3.75e-07,  3.63e-07,  2.98e-07,  nan ],
	[    83,    1.43,   0.04,    1.56,   0.04,   1.65,   0.03,   5.12,    0.01,  4.34e-07,  3.79e-07,  3.79e-07,  nan ],
	[    84,    1.48,   0.04,    1.52,   0.04,   1.69,   0.03,   6.34,    0.01,  4.06e-07,  3.27e-07,  3.27e-07,  nan ],
	[    85,    1.51,   0.04,    1.55,   0.04,   1.73,   0.03,   5.87,    0.01,  3.83e-07,  3.70e-07,  4.51e-07,  nan ],
	[    86,    1.59,   0.04,    1.63,   0.04,   1.82,   0.03,   5.49,    0.01,  4.78e-07,  2.81e-07,  3.58e-07,  nan ],
	[    87,    1.58,   0.04,    1.61,   0.04,   1.81,   0.03,   6.15,    0.01,  2.67e-07,  2.77e-07,  2.36e-07,  nan ],
	[    88,    1.61,   0.04,    1.69,   0.04,   1.80,   0.04,   6.29,    0.01,  3.70e-07,  3.13e-07,  3.47e-07,  nan ],
	[    89,    1.70,   0.04,    1.74,   0.04,   1.84,   0.04,   6.43,    0.01,  3.66e-07,  4.37e-07,  3.53e-07,  nan ],
	[    90,    1.74,   0.04,    1.84,   0.04,   2.00,   0.03,   7.27,    0.01,  2.71e-07,  3.40e-07,  2.71e-07,  nan ],
	[   100,    2.14,   0.04,    2.20,   0.04,   2.32,   0.04,   6.81,    0.01,  4.83e-07,  3.15e-07,  3.81e-07,  nan ],
	[   110,    2.51,   0.04,    2.66,   0.04,   2.80,   0.04,   7.48,    0.01,  4.65e-07,  4.86e-07,  4.39e-07,  nan ],
	[   120,    2.91,   0.04,    3.08,   0.04,   3.16,   0.04,   9.06,    0.01,  4.02e-07,  5.13e-07,  2.84e-07,  nan ],
	[   130,    2.97,   0.05,    3.52,   0.04,   3.43,   0.04,   9.10,    0.02,  3.76e-07,  3.71e-07,  3.52e-07,  nan ],
	[   140,    3.52,   0.05,    4.08,   0.04,   3.96,   0.04,  12.09,    0.01,  3.97e-07,  4.49e-07,  3.31e-07,  nan ],
	[   150,    4.03,   0.05,    4.43,   0.04,   4.24,   0.04,  10.17,    0.02,  5.48e-07,  4.55e-07,  4.55e-07,  nan ],
	[   160,    4.49,   0.05,    5.32,   0.04,   4.79,   0.04,  11.41,    0.02,  6.11e-07,  5.16e-07,  5.56e-07,  nan ],
	[   170,    5.07,   0.05,    5.53,   0.04,   5.18,   0.05,  13.59,    0.02,  4.12e-07,  3.70e-07,  4.69e-07,  nan ],
	[   180,    5.56,   0.05,    6.23,   0.04,   5.56,   0.05,  15.44,    0.02,  5.24e-07,  6.90e-07,  5.16e-07,  nan ],
	[   190,    6.46,   0.05,    6.78,   0.04,   6.33,   0.05,  14.53,    0.02,  5.62e-07,  6.47e-07,  4.89e-07,  nan ],
	[   200,    6.20,   0.05,    7.51,   0.04,   6.56,   0.05,  15.37,    0.02,  6.56e-07,  5.50e-07,  4.72e-07,  nan ],
	[   210,    6.24,   0.06,    8.10,   0.04,   7.10,   0.05,  13.67,    0.03,  5.82e-07,  5.40e-07,  5.14e-07,  nan ],
	[   220,    7.20,   0.05,    8.65,   0.05,   7.64,   0.05,  15.00,    0.03,  4.86e-07,  4.87e-07,  4.97e-07,  nan ],
	[   230,    8.05,   0.05,    8.05,   0.05,   8.01,   0.05,  14.64,    0.03,  6.63e-07,  6.63e-07,  5.97e-07,  nan ],
	[   240,    8.92,   0.05,   10.51,   0.04,   8.92,   0.05,  14.09,    0.03,  6.39e-07,  7.63e-07,  7.66e-07,  nan ],
	[   250,    9.34,   0.05,   10.93,   0.05,   9.13,   0.06,  15.29,    0.03,  8.54e-07,  7.43e-07,  7.35e-07,  nan ],
	[   260,    9.05,   0.06,   11.58,   0.05,   9.55,   0.06,  16.53,    0.03,  7.42e-07,  7.26e-07,  7.87e-07,  nan ],
	[   270,    9.76,   0.06,   12.49,   0.05,  10.12,   0.06,  16.29,    0.04,  9.11e-07,  7.93e-07,  7.93e-07,  nan ],
	[   280,   10.66,   0.06,   13.43,   0.05,  10.88,   0.06,  16.63,    0.04,  5.87e-07,  7.63e-07,  6.54e-07,  nan ],
	[   290,   11.30,   0.06,   13.84,   0.05,  11.08,   0.06,  16.88,    0.04,  7.66e-07,  9.53e-07,  9.56e-07,  nan ],
	[   300,   11.86,   0.06,   14.73,   0.05,  11.67,   0.06,  17.65,    0.04,  1.12e-06,  1.22e-06,  1.22e-06,  nan ],
	[   310,   12.66,   0.06,   15.14,   0.05,  12.09,   0.06,  17.61,    0.04,  7.45e-07,  7.94e-07,  7.94e-07,  nan ],
	[   320,   13.70,   0.06,   17.52,   0.05,  11.43,   0.07,  19.61,    0.04,  6.74e-07,  6.88e-07,  7.69e-07,  nan ],
	[   330,   13.25,   0.07,   17.15,   0.05,  13.45,   0.07,  18.17,    0.05,  6.87e-07,  7.63e-07,  8.37e-07,  nan ],
	[   340,   14.07,   0.07,   17.87,   0.05,  13.86,   0.07,  18.21,    0.05,  7.18e-07,  8.38e-07,  8.38e-07,  nan ],
	[   350,   15.12,   0.07,   18.94,   0.05,  14.69,   0.07,  19.29,    0.05,  6.99e-07,  6.06e-07,  6.10e-07,  nan ],
	[   360,   15.54,   0.07,   19.67,   0.05,  14.85,   0.07,  20.03,    0.05,  8.23e-07,  9.56e-07,  7.92e-07,  nan ],
	[   370,   16.18,   0.07,   20.41,   0.05,  15.27,   0.07,  19.30,    0.06,  7.78e-07,  7.47e-07,  7.00e-07,  nan ],
	[   380,   17.31,   0.07,   21.15,   0.05,  16.11,   0.07,  20.02,    0.06,  8.03e-07,  7.40e-07,  7.27e-07,  nan ],
	[   390,   16.74,   0.07,   22.57,   0.05,  16.47,   0.07,  17.49,    0.07,  8.64e-07,  7.83e-07,  7.83e-07,  nan ],
	[   400,   17.84,   0.07,   23.84,   0.05,  17.84,   0.07,  19.45,    0.07,  7.97e-07,  8.53e-07,  7.24e-07,  nan ],
	[   410,   18.26,   0.07,   23.69,   0.06,  17.97,   0.08,  17.97,    0.08,  1.04e-06,  1.13e-06,  9.70e-07,  nan ],
	[   420,   18.86,   0.08,   25.28,   0.06,  18.17,   0.08,  18.39,    0.08,  9.47e-07,  1.02e-06,  9.47e-07,  nan ],
	[   430,   19.52,   0.08,   25.21,   0.06,  18.53,   0.08,  19.58,    0.08,  7.11e-07,  9.40e-07,  8.01e-07,  nan ],
	[   440,   20.76,   0.07,   26.82,   0.06,  19.46,   0.08,  20.43,    0.08,  1.18e-06,  1.25e-06,  1.04e-06,  nan ],
	[   450,   20.05,   0.08,   27.05,   0.06,  19.59,   0.08,  19.15,    0.08,  9.71e-07,  9.59e-07,  9.71e-07,  nan ],
	[   460,   20.95,   0.08,   29.31,   0.06,  20.47,   0.08,  20.24,    0.08,  1.08e-06,  1.07e-06,  1.08e-06,  nan ],
	[   470,   21.62,   0.08,   29.05,   0.06,  19.72,   0.09,  21.12,    0.08,  7.82e-07,  7.66e-07,  7.93e-07,  nan ],
	[   480,   22.81,   0.08,   31.27,   0.06,  22.03,   0.08,  21.54,    0.09,  9.45e-07,  1.03e-06,  9.26e-07,  nan ],
	[   490,   23.49,   0.08,   31.08,   0.06,  22.14,   0.09,  20.51,    0.09,  8.72e-07,  7.80e-07,  9.07e-07,  nan ],
	[   500,   24.46,   0.08,   31.87,   0.06,  22.26,   0.09,  20.47,    0.10,  1.01e-06,  9.94e-07,  8.89e-07,  nan ],
	[   510,   25.45,   0.08,   33.03,   0.06,  23.16,   0.09,  20.69,    0.10,  9.95e-07,  7.78e-07,  1.02e-06,  nan ],
	[   520,   24.93,   0.09,   33.83,   0.06,  23.33,   0.09,  21.31,    0.10,  9.68e-07,  1.06e-06,  9.75e-07,  nan ],
	[   530,   25.34,   0.09,   34.75,   0.06,  23.69,   0.10,  19.98,    0.11,  1.16e-06,  1.16e-06,  1.05e-06,  nan ],
	[   540,   26.88,   0.09,   36.61,   0.06,  24.84,   0.09,  21.28,    0.11,  1.14e-06,  1.06e-06,  1.15e-06,  nan ],
	[   550,   26.71,   0.09,   36.22,   0.07,  25.01,   0.10,  21.29,    0.11,  7.85e-07,  8.08e-07,  8.25e-07,  nan ],
	[   560,   27.33,   0.09,   37.02,   0.07,  25.92,   0.10,  21.89,    0.11,  1.10e-06,  1.10e-06,  1.16e-06,  nan ],
	[   570,   27.74,   0.09,   37.18,   0.07,  26.34,   0.10,  21.02,    0.12,  1.62e-06,  1.73e-06,  1.73e-06,  nan ],
	[   580,   27.54,   0.10,   39.16,   0.07,  26.44,   0.10,  21.43,    0.13,  9.66e-07,  1.15e-06,  9.41e-07,  nan ],
	[   590,   27.95,   0.10,   40.52,   0.07,  27.36,   0.10,  21.85,    0.13,  1.14e-06,  1.26e-06,  1.16e-06,  nan ],
	[   600,   29.18,   0.10,   41.33,   0.07,  27.46,   0.11,  20.77,    0.14,  9.50e-07,  1.16e-06,  9.65e-07,  nan ],
	[   610,   29.52,   0.10,   41.44,   0.07,  27.39,   0.11,  20.72,    0.14,  1.39e-06,  1.30e-06,  1.44e-06,  nan ],
	[   620,   29.93,   0.10,   42.81,   0.07,  28.54,   0.11,  21.73,    0.14,  1.15e-06,  1.15e-06,  1.15e-06,  nan ],
	[   630,   31.19,   0.10,   43.06,   0.07,  28.65,   0.11,  21.67,    0.15,  1.46e-06,  1.17e-06,  1.16e-06,  nan ],
	[   640,   32.19,   0.10,   45.62,   0.07,  29.56,   0.11,  21.90,    0.15,  1.25e-06,  1.34e-06,  1.24e-06,  nan ],
	[   650,   30.82,   0.11,   44.54,   0.08,  29.73,   0.11,  21.43,    0.16,  1.22e-06,  1.05e-06,  9.58e-07,  nan ],
	[   660,   32.06,   0.11,   46.07,   0.08,  30.08,   0.12,  21.70,    0.16,  1.58e-06,  1.55e-06,  1.46e-06,  nan ],
	[   670,   32.40,   0.11,   45.61,   0.08,  30.81,   0.12,  21.69,    0.17,  1.28e-06,  1.28e-06,  1.19e-06,  nan ],
	[   680,   32.81,   0.11,   46.84,   0.08,  31.16,   0.12,  22.18,    0.17,  1.35e-06,  1.17e-06,  1.35e-06,  nan ],
	[   690,   33.15,   0.12,   47.79,   0.08,  31.27,   0.12,  20.98,    0.18,  1.29e-06,  1.27e-06,  1.19e-06,  nan ],
	[   700,   33.90,   0.12,   48.46,   0.08,  32.18,   0.12,  21.85,    0.18,  1.57e-06,  1.13e-06,  1.19e-06,  nan ],
	[   710,   33.97,   0.12,   49.85,   0.08,  32.35,   0.12,  21.70,    0.19,  1.23e-06,  1.32e-06,  1.16e-06,  nan ],
	[   720,   34.93,   0.12,   50.67,   0.08,  33.20,   0.13,  21.90,    0.19,  1.50e-06,  1.45e-06,  1.38e-06,  nan ],
	[   730,   35.55,   0.12,   52.09,   0.08,  33.12,   0.13,  22.01,    0.19,  1.06e-06,  1.34e-06,  1.09e-06,  nan ],
	[   740,   36.24,   0.12,   51.57,   0.09,  33.78,   0.13,  22.05,    0.20,  1.16e-06,  1.33e-06,  1.32e-06,  nan ],
	[   750,   37.01,   0.12,   53.58,   0.08,  34.14,   0.13,  21.89,    0.21,  1.35e-06,  1.17e-06,  1.17e-06,  nan ],
	[   760,   37.63,   0.12,   55.80,   0.08,  34.55,   0.13,  22.17,    0.21,  1.39e-06,  1.37e-06,  1.36e-06,  nan ],
	[   770,   37.40,   0.13,   55.22,   0.09,  34.91,   0.14,  22.30,    0.21,  1.42e-06,  1.22e-06,  1.33e-06,  nan ],
	[   780,   38.74,   0.13,   57.45,   0.08,  35.82,   0.14,  21.97,    0.22,  1.66e-06,  1.61e-06,  1.61e-06,  nan ],
	[   790,   39.07,   0.13,   56.86,   0.09,  35.74,   0.14,  21.48,    0.23,  1.35e-06,  1.26e-06,  1.56e-06,  nan ],
	[   800,   39.48,   0.13,   58.95,   0.09,  36.90,   0.14,  22.20,    0.23,  1.18e-06,  1.22e-06,  1.15e-06,  nan ],
	[   810,   40.47,   0.13,   58.35,   0.09,  36.52,   0.14,  22.10,    0.24,  1.58e-06,  1.43e-06,  1.30e-06,  nan ],
	[   820,   41.10,   0.13,   59.96,   0.09,  37.42,   0.14,  22.45,    0.24,  1.42e-06,  1.34e-06,  1.27e-06,  nan ],
	[   830,   42.10,   0.13,   60.62,   0.09,  38.03,   0.15,  22.08,    0.25,  1.18e-06,  1.11e-06,  1.09e-06,  nan ],
	[   840,   41.54,   0.14,   62.09,   0.09,  38.69,   0.15,  22.00,    0.26,  1.37e-06,  1.31e-06,  1.24e-06,  nan ],
	[   850,   42.24,   0.14,   63.58,   0.09,  38.86,   0.15,  22.18,    0.26,  1.59e-06,  1.52e-06,  1.59e-06,  nan ],
	[   860,   42.94,   0.14,   63.10,   0.09,  39.78,   0.15,  21.94,    0.27,  1.14e-06,  1.14e-06,  1.07e-06,  nan ],
	[   870,   43.05,   0.14,   64.57,   0.09,  39.63,   0.15,  22.40,    0.27,  1.39e-06,  1.38e-06,  1.39e-06,  nan ],
	[   880,   43.67,   0.14,   66.06,   0.09,  40.54,   0.15,  22.25,    0.28,  1.39e-06,  1.33e-06,  1.27e-06,  nan ],
	[   890,   44.67,   0.14,   66.89,   0.09,  40.46,   0.16,  22.13,    0.29,  1.26e-06,  1.24e-06,  1.18e-06,  nan ],
	[   900,   44.48,   0.15,   66.89,   0.10,  41.31,   0.16,  22.24,    0.29,  1.26e-06,  1.34e-06,  1.34e-06,  nan ],
	[  1000,   49.49,   0.16,   77.08,   0.10,  46.03,   0.17,  22.71,    0.35,  1.49e-06,  1.60e-06,  1.64e-06,  nan ],
	[  1100,   54.14,   0.18,   84.35,   0.11,  29.74,   0.33,  23.09,    0.42,  1.83e-06,  1.80e-06,  1.62e-06,  nan ],
	[  1200,   60.78,   0.19,   95.42,   0.12,  33.43,   0.34,  23.02,    0.50,  1.83e-06,  1.83e-06,  2.04e-06,  nan ],
	[  1300,   65.41,   0.21,  104.94,   0.13,  35.53,   0.38,  23.18,    0.58,  1.80e-06,  1.44e-06,  1.60e-06,  nan ],
	[  1400,   71.33,   0.22,  114.50,   0.14,  38.08,   0.41,  22.81,    0.69,  1.42e-06,  1.49e-06,  1.51e-06,  nan ],
	[  1500,   75.72,   0.24,  120.15,   0.15,  40.67,   0.44,  22.69,    0.79,  1.96e-06,  2.04e-06,  2.03e-06,  nan ],
	[  1600,   80.43,   0.25,  129.68,   0.16,  42.11,   0.49,  20.75,    0.99,  1.81e-06,  2.06e-06,  1.95e-06,  nan ],
	[  1700,   86.04,   0.27,  132.23,   0.17,  43.74,   0.53,  18.51,    1.25,  1.98e-06,  2.25e-06,  1.96e-06,  nan ],
	[  1800,   91.67,   0.28,  144.12,   0.18,  46.40,   0.56,  16.84,    1.54,  2.09e-06,  2.04e-06,  1.90e-06,  nan ],
	[  1900,   94.78,   0.30,  152.10,   0.19,  49.16,   0.59,  16.54,    1.75,  2.22e-06,  1.96e-06,  1.98e-06,  nan ],
	[  2000,   98.55,   0.32,  156.18,   0.21,  51.33,   0.62,  16.30,    1.97,  1.91e-06,  1.95e-06,  1.93e-06,  nan ],
	[  2100,   94.92,   0.37,  159.06,   0.22,  38.49,   0.92,  16.28,    2.17,  2.56e-06,  2.68e-06,  2.67e-06,  nan ],
	[  2200,  109.81,   0.35,  164.99,   0.23,  40.66,   0.95,  15.87,    2.44,  2.13e-06,  2.19e-06,  2.24e-06,  nan ],
	[  2300,  116.39,   0.36,  172.78,   0.25,  42.43,   1.00,  16.64,    2.54,  2.87e-06,  2.99e-06,  2.98e-06,  nan ],
	[  2400,  120.72,   0.38,  180.24,   0.26,  43.79,   1.05,  15.83,    2.91,  2.99e-06,  3.08e-06,  3.06e-06,  nan ],
	[  2500,  125.73,   0.40,  186.03,   0.27,  45.73,   1.09,  16.35,    3.06,  2.64e-06,  2.58e-06,  2.77e-06,  nan ],
	[  2600,  128.52,   0.42,  192.01,   0.28,  46.49,   1.16,  16.30,    3.32,  2.55e-06,  2.38e-06,  2.36e-06,  nan ],
	[  2700,  135.07,   0.43,  199.14,   0.29,  49.08,   1.19,  16.55,    3.53,  2.39e-06,  2.38e-06,  2.37e-06,  nan ],
	[  2800,  138.24,   0.45,  202.47,   0.31,  51.02,   1.23,  16.61,    3.78,  2.93e-06,  3.13e-06,  3.05e-06,  nan ],
	[  2900,  142.31,   0.47,  214.38,   0.31,  52.34,   1.29,  17.35,    3.88,  2.95e-06,  2.53e-06,  2.78e-06,  nan ],
	[  3000,  145.82,   0.49,  220.22,   0.33,  53.49,   1.35,  16.66,    4.32,  3.20e-06,  2.67e-06,  3.14e-06,  nan ],
	[  3100,  151.39,   0.51,  224.35,   0.34,  43.21,   1.78,  15.88,    4.85,  2.46e-06,  2.55e-06,  2.78e-06,  nan ],
	[  3200,  156.68,   0.52,  234.81,   0.35,  44.81,   1.83,  16.89,    4.85,  2.75e-06,  2.92e-06,  2.90e-06,  nan ],
	[  3300,  161.40,   0.54,  231.82,   0.38,  46.07,   1.89,  16.83,    5.18,  3.11e-06,  2.96e-06,  2.96e-06,  nan ],
	[  3400,  165.55,   0.56,  245.45,   0.38,  47.16,   1.96,  16.85,    5.49,  2.59e-06,  2.88e-06,  2.93e-06,  nan ],
	[  3500,  168.19,   0.58,  243.90,   0.40,  48.73,   2.01,  16.71,    5.87,  3.18e-06,  3.71e-06,  3.05e-06,  nan ],
	[  3600,  173.19,   0.60,  251.62,   0.41,  49.77,   2.08,  15.37,    6.75,  3.40e-06,  3.27e-06,  3.43e-06,  nan ],
	[  3700,  177.29,   0.62,  255.87,   0.43,  50.87,   2.15,  16.82,    6.51,  3.51e-06,  3.65e-06,  4.19e-06,  nan ],
	[  3800,  179.39,   0.64,  257.28,   0.45,  52.27,   2.21,  16.66,    6.94,  2.91e-06,  3.01e-06,  2.70e-06,  nan ],
	[  3900,  180.03,   0.68,  254.64,   0.48,  53.53,   2.27,  16.92,    7.19,  3.17e-06,  2.72e-06,  2.64e-06,  nan ],
	[  4000,  179.80,   0.71,  259.71,   0.49,  54.37,   2.36,  16.03,    7.99,  4.09e-06,  3.94e-06,  3.83e-06,  nan ],
	[  4100,  178.45,   0.75,  267.93,   0.50,  46.34,   2.90,  17.03,    7.90,  3.14e-06,  3.31e-06,  3.47e-06,  nan ],
	[  4200,  178.24,   0.79,  258.56,   0.55,  47.27,   2.99,  16.80,    8.40,  3.37e-06,  3.49e-06,  3.17e-06,  nan ],
	[  4300,  179.79,   0.82,  260.12,   0.57,  48.22,   3.07,  16.88,    8.77,  3.20e-06,  3.37e-06,  3.02e-06,  nan ],
	[  4400,  184.66,   0.84,  261.71,   0.59,  49.25,   3.15,  16.86,    9.19,  3.44e-06,  3.55e-06,  3.33e-06,  nan ],
	[  4500,  183.55,   0.88,  259.33,   0.62,  50.25,   3.22,  16.92,    9.58,  3.62e-06,  3.52e-06,  3.62e-06,  nan ],
	[  4600,  187.10,   0.91,  258.93,   0.65,  50.62,   3.35,  15.75,   10.75,  3.91e-06,  3.50e-06,  3.63e-06,  nan ],
	[  4700,  187.43,   0.94,  258.08,   0.68,  52.29,   3.38,  16.85,   10.49,  3.99e-06,  4.17e-06,  4.08e-06,  nan ],
	[  4800,  188.11,   0.98,  263.04,   0.70,  53.38,   3.45,  17.03,   10.82,  4.05e-06,  3.51e-06,  3.55e-06,  nan ],
	[  4900,  187.24,   1.03,  258.96,   0.74,  53.91,   3.56,  16.94,   11.35,  3.57e-06,  3.64e-06,  3.63e-06,  nan ],
	[  5000,  190.36,   1.05,  260.51,   0.77,  54.89,   3.64,  16.92,   11.82,  4.27e-06,  4.90e-06,  4.54e-06,  nan ],
	[  5100,  192.00,   1.08,  261.14,   0.80,  55.37,   3.76,  16.75,   12.43,  4.20e-06,  4.50e-06,  4.56e-06,  nan ],
	[  5200,  192.53,   1.12,  259.75,   0.83,  49.09,   4.41,  16.99,   12.74,  3.88e-06,  3.88e-06,  3.98e-06,  nan ],
	[  5300,  194.11,   1.16,  265.43,   0.85,  49.64,   4.53,  16.79,   13.39,  3.67e-06,  3.55e-06,  3.59e-06,  nan ],
	[  5400,  195.12,   1.20,  263.66,   0.89,  50.53,   4.62,  16.81,   13.88,  4.65e-06,  4.40e-06,  4.52e-06,  nan ],
	[  5500,  196.65,   1.23,  262.83,   0.92,  50.37,   4.81,  16.94,   14.29,  3.96e-06,  3.73e-06,  4.04e-06,  nan ],
	[  5600,  198.82,   1.26,  266.13,   0.94,  52.30,   4.80,  16.83,   14.91,  4.03e-06,  4.28e-06,  4.28e-06,  nan ],
	[  5700,  198.77,   1.31,  268.06,   0.97,  52.90,   4.91,  16.97,   15.32,  4.19e-06,  4.61e-06,  4.25e-06,  nan ],
	[  5800,  198.95,   1.35,  268.38,   1.00,  53.87,   5.00,  17.00,   15.83,  4.50e-06,  4.40e-06,  3.97e-06,  nan ],
	[  5900,  202.17,   1.38,  269.39,   1.03,  54.73,   5.09,  17.18,   16.21,  4.33e-06,  4.35e-06,  4.10e-06,  nan ],
	[  6000,  202.15,   1.43,  269.70,   1.07,  55.34,   5.21,  17.20,   16.75,  4.16e-06,  4.41e-06,  3.87e-06,  nan ],
	[  6100,  205.07,   1.45,  269.68,   1.10,  55.69,   5.35,  17.11,   17.40,  4.37e-06,  4.55e-06,  4.64e-06,  nan ],
	[  6200,  205.34,   1.50,  270.53,   1.14,  49.81,   6.18,  16.82,   18.29,  3.80e-06,  3.64e-06,  3.95e-06,  nan ],
	[  6300,  207.98,   1.53,  273.08,   1.16,  50.38,   6.30,  17.04,   18.64,  4.89e-06,  4.27e-06,  4.90e-06,  nan ],
	[  6400,  207.32,   1.58,  273.79,   1.20,  50.53,   6.49,  18.87,   17.37,  4.76e-06,  4.43e-06,  4.00e-06,  nan ],
	[  6500,  210.64,   1.61,  276.68,   1.22,  51.54,   6.56,  17.19,   19.67,  4.80e-06,  4.15e-06,  4.82e-06,  nan ],
	[  6600,  212.93,   1.64,  274.50,   1.27,  52.88,   6.59,  17.17,   20.30,  4.36e-06,  4.63e-06,  4.36e-06,  nan ],
	[  6700,  215.88,   1.66,  275.68,   1.30,  52.67,   6.82,  17.13,   20.97,  5.18e-06,  4.38e-06,  4.96e-06,  nan ],
	[  6800,  212.27,   1.74,  278.42,   1.33,  53.81,   6.88,  17.29,   21.40,  4.36e-06,  3.81e-06,  4.12e-06,  nan ],
	[  6900,  214.97,   1.77,  276.64,   1.38,  53.84,   7.08,  17.10,   22.28,  4.06e-06,  3.64e-06,  3.67e-06,  nan ],
	[  7000,  216.27,   1.81,  275.37,   1.42,  55.37,   7.08,  17.15,   22.86,  4.19e-06,  4.06e-06,  3.98e-06,  nan ],
	[  7100,  218.50,   1.85,  281.08,   1.44,  55.20,   7.31,  17.14,   23.53,  4.30e-06,  4.02e-06,  3.72e-06,  nan ],
	[  7200,  219.59,   1.89,  280.48,   1.48,  50.30,   8.25,  16.81,   24.67,  4.07e-06,  4.35e-06,  4.07e-06,  nan ],
	[  7300,  221.05,   1.93,  281.30,   1.52,  51.13,   8.34,  16.75,   25.45,  4.46e-06,  4.42e-06,  4.82e-06,  nan ],
	[  7400,  222.31,   1.97,  282.87,   1.55,  51.17,   8.56,  16.91,   25.92,  4.27e-06,  4.18e-06,  4.19e-06,  nan ],
	[  7500,  221.39,   2.03,  284.52,   1.58,  51.73,   8.70,  16.94,   26.56,  4.63e-06,  4.19e-06,  4.21e-06,  nan ],
	[  7600,  227.23,   2.03,  284.24,   1.63,  52.62,   8.78,  17.12,   26.99,  3.98e-06,  3.88e-06,  4.11e-06,  nan ],
	[  7700,  226.25,   2.10,  282.21,   1.68,  53.59,   8.85,  15.59,   30.44,  5.22e-06,  4.58e-06,  4.71e-06,  nan ],
	[  7800,  225.59,   2.16,  283.71,   1.72,  53.94,   9.03,  16.66,   29.22,  4.48e-06,  5.09e-06,  4.49e-06,  nan ],
	[  7900,  224.23,   2.23,  280.99,   1.78,  54.77,   9.12,  16.88,   29.58,  4.67e-06,  4.82e-06,  4.71e-06,  nan ],
	[  8000,  225.00,   2.28,  280.88,   1.82,  54.97,   9.32,  16.96,   30.20,  4.53e-06,  4.92e-06,  5.02e-06,  nan ],
	[  8100,  226.09,   2.32,  283.75,   1.85,  55.18,   9.51,  16.48,   31.86,  5.05e-06,  5.03e-06,  4.86e-06,  nan ],
	[  8200,  226.07,   2.38,  284.49,   1.89,  50.04,  10.75,  15.77,   34.12,  5.15e-06,  5.52e-06,  5.26e-06,  nan ],
	[  8300,  228.05,   2.42,  284.73,   1.94,  51.09,  10.79,  16.50,   33.41,  6.48e-06,  6.03e-06,  5.85e-06,  nan ],
	[  8400,  224.05,   2.52,  288.19,   1.96,  51.85,  10.89,  16.84,   33.53,  4.66e-06,  4.62e-06,  4.62e-06,  nan ],
	[  8500,  230.05,   2.51,  283.40,   2.04,  52.72,  10.97,  16.86,   34.28,  5.47e-06,  5.63e-06,  5.71e-06,  nan ],
	[  8600,  227.53,   2.60,  284.39,   2.08,  52.71,  11.23,  16.62,   35.60,  5.47e-06,  5.26e-06,  5.11e-06,  nan ],
	[  8700,  227.00,   2.67,  285.67,   2.12,  53.78,  11.26,  17.43,   34.75,  5.47e-06,  5.42e-06,  5.24e-06,  nan ],
	[  8800,  224.51,   2.76,  286.06,   2.17,  53.89,  11.50,  17.01,   36.43,  5.95e-06,  5.68e-06,  5.54e-06,  nan ],
	[  8900,  226.60,   2.80,  282.80,   2.24,  54.13,  11.71,  17.02,   37.24,  5.69e-06,  5.32e-06,  5.20e-06,  nan ],
	[  9000,  228.20,   2.84,  285.90,   2.27,  54.74,  11.84,  16.81,   38.54,  5.18e-06,  5.31e-06,  5.85e-06,  nan ],
	[ 10000,  234.58,   3.41,  286.59,   2.79,  55.16,  14.50,  17.31,   46.22,  5.70e-06,  5.45e-06,  4.72e-06,  nan ],
	[ 12000,  238.73,   4.83,  291.08,   3.96,  54.73,  21.05,  16.68,   69.06,  6.72e-06,  6.68e-06,  6.45e-06,  nan ],
	[ 14000,  248.25,   6.32,  294.22,   5.33,  54.90,  28.56,  16.98,   92.38,  7.49e-06,  8.12e-06,  7.83e-06,  nan ],
	[ 16000,  252.89,   8.10,  292.60,   7.00,  55.42,  36.96,  15.68,  130.59,  6.96e-06,  6.64e-06,  6.85e-06,  nan ],
	[ 18000,  253.37,  10.23,  296.15,   8.75,  54.93,  47.19,  16.46,  157.47,  7.60e-06,  7.60e-06,  7.93e-06,  nan ],
	[ 20000,  258.88,  12.36,  293.49,  10.90,  53.98,  59.28,  16.81,  190.36,  9.59e-06,  9.18e-06,  9.30e-06,  nan ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/cpotrf.txt
# numactl --interleave=all ./testing_cpotrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cpotrf = array([
	[    10,  nan,  nan,     0.01,  0.00,  nan ],
	[    20,  nan,  nan,     0.04,  0.00,  nan ],
	[    30,  nan,  nan,     0.13,  0.00,  nan ],
	[    40,  nan,  nan,     1.80,  0.00,  nan ],
	[    50,  nan,  nan,     2.52,  0.00,  nan ],
	[    60,  nan,  nan,     3.64,  0.00,  nan ],
	[    70,  nan,  nan,     4.63,  0.00,  nan ],
	[    80,  nan,  nan,     5.48,  0.00,  nan ],
	[    90,  nan,  nan,     2.37,  0.00,  nan ],
	[   100,  nan,  nan,     2.98,  0.00,  nan ],
	[   200,  nan,  nan,    16.15,  0.00,  nan ],
	[   300,  nan,  nan,    17.43,  0.00,  nan ],
	[   400,  nan,  nan,    33.32,  0.00,  nan ],
	[   500,  nan,  nan,    56.26,  0.00,  nan ],
	[   600,  nan,  nan,    66.67,  0.00,  nan ],
	[   700,  nan,  nan,    94.95,  0.00,  nan ],
	[   800,  nan,  nan,   107.84,  0.01,  nan ],
	[   900,  nan,  nan,   138.10,  0.01,  nan ],
	[  1000,  nan,  nan,   177.33,  0.01,  nan ],
	[  2000,  nan,  nan,   536.00,  0.02,  nan ],
	[  3000,  nan,  nan,   980.86,  0.04,  nan ],
	[  4000,  nan,  nan,  1311.34,  0.07,  nan ],
	[  5000,  nan,  nan,  1552.25,  0.11,  nan ],
	[  6000,  nan,  nan,  1740.62,  0.17,  nan ],
	[  7000,  nan,  nan,  1873.41,  0.24,  nan ],
	[  8000,  nan,  nan,  1947.42,  0.35,  nan ],
	[  9000,  nan,  nan,  2041.71,  0.48,  nan ],
	[ 10000,  nan,  nan,  2234.32,  0.60,  nan ],
	[ 12000,  nan,  nan,  2392.91,  0.96,  nan ],
	[ 14000,  nan,  nan,  2513.31,  1.46,  nan ],
	[ 16000,  nan,  nan,  2601.37,  2.10,  nan ],
	[ 18000,  nan,  nan,  2652.01,  2.93,  nan ],
	[ 20000,  nan,  nan,  2716.00,  3.93,  nan ],
])

# numactl --interleave=all ./testing_cpotrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cpotrf_gpu = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.01,  0.00,  nan ],
	[    30,  nan,  nan,     0.04,  0.00,  nan ],
	[    40,  nan,  nan,     0.10,  0.00,  nan ],
	[    50,  nan,  nan,     0.19,  0.00,  nan ],
	[    60,  nan,  nan,     0.33,  0.00,  nan ],
	[    70,  nan,  nan,     0.51,  0.00,  nan ],
	[    80,  nan,  nan,     0.74,  0.00,  nan ],
	[    90,  nan,  nan,     1.00,  0.00,  nan ],
	[   100,  nan,  nan,     1.32,  0.00,  nan ],
	[   200,  nan,  nan,    24.80,  0.00,  nan ],
	[   300,  nan,  nan,    13.07,  0.00,  nan ],
	[   400,  nan,  nan,    25.46,  0.00,  nan ],
	[   500,  nan,  nan,    46.26,  0.00,  nan ],
	[   600,  nan,  nan,    59.42,  0.00,  nan ],
	[   700,  nan,  nan,    85.50,  0.01,  nan ],
	[   800,  nan,  nan,   100.59,  0.01,  nan ],
	[   900,  nan,  nan,   134.55,  0.01,  nan ],
	[  1000,  nan,  nan,   173.41,  0.01,  nan ],
	[  2000,  nan,  nan,   612.80,  0.02,  nan ],
	[  3000,  nan,  nan,  1121.08,  0.03,  nan ],
	[  4000,  nan,  nan,  1484.99,  0.06,  nan ],
	[  5000,  nan,  nan,  1773.60,  0.09,  nan ],
	[  6000,  nan,  nan,  2000.86,  0.14,  nan ],
	[  7000,  nan,  nan,  2149.19,  0.21,  nan ],
	[  8000,  nan,  nan,  2291.75,  0.30,  nan ],
	[  9000,  nan,  nan,  2373.50,  0.41,  nan ],
	[ 10000,  nan,  nan,  2450.20,  0.54,  nan ],
	[ 12000,  nan,  nan,  2584.08,  0.89,  nan ],
	[ 14000,  nan,  nan,  2694.42,  1.36,  nan ],
	[ 16000,  nan,  nan,  2773.94,  1.97,  nan ],
	[ 18000,  nan,  nan,  2807.46,  2.77,  nan ],
	[ 20000,  nan,  nan,  2852.81,  3.74,  nan ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/dgeev.txt
# numactl --interleave=all ./testing_dgeev -RN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dgeev_RN = array([
	[    10,  nan,     0.00 ],
	[    20,  nan,     0.00 ],
	[    30,  nan,     0.00 ],
	[    40,  nan,     0.00 ],
	[    50,  nan,     0.00 ],
	[    60,  nan,     0.00 ],
	[    70,  nan,     0.00 ],
	[    80,  nan,     0.01 ],
	[    90,  nan,     0.01 ],
	[   100,  nan,     0.01 ],
	[   200,  nan,     0.05 ],
	[   300,  nan,     0.09 ],
	[   400,  nan,     0.15 ],
	[   500,  nan,     0.20 ],
	[   600,  nan,     0.47 ],
	[   700,  nan,     0.58 ],
	[   800,  nan,     0.73 ],
	[   900,  nan,     0.86 ],
	[  1000,  nan,     1.00 ],
	[  2000,  nan,     3.09 ],
	[  3000,  nan,     9.82 ],
	[  4000,  nan,    15.28 ],
	[  5000,  nan,    22.85 ],
	[  6000,  nan,    38.81 ],
	[  7000,  nan,    51.29 ],
	[  8000,  nan,    66.77 ],
	[  9000,  nan,    81.80 ],
	[ 10000,  nan,    95.69 ],
	[ 12000,  nan,   143.64 ],
	[ 14000,  nan,   193.14 ],
	[ 16000,  nan,   261.41 ],
	[ 18000,  nan,  1005.35 ],
])

# numactl --interleave=all ./testing_dgeev -RV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dgeev_RV = array([
	[    10,  nan,    0.00 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.01 ],
	[    60,  nan,    0.00 ],
	[    70,  nan,    0.01 ],
	[    80,  nan,    0.01 ],
	[    90,  nan,    0.01 ],
	[   100,  nan,    0.01 ],
	[   200,  nan,    0.07 ],
	[   300,  nan,    0.15 ],
	[   400,  nan,    0.21 ],
	[   500,  nan,    0.34 ],
	[   600,  nan,    0.58 ],
	[   700,  nan,    0.71 ],
	[   800,  nan,    0.95 ],
	[   900,  nan,    1.11 ],
	[  1000,  nan,    1.24 ],
	[  2000,  nan,    4.51 ],
	[  3000,  nan,   11.88 ],
	[  4000,  nan,   20.30 ],
	[  5000,  nan,   31.82 ],
	[  6000,  nan,   49.37 ],
	[  7000,  nan,   66.09 ],
	[  8000,  nan,   86.38 ],
	[  9000,  nan,  111.28 ],
	[ 10000,  nan,  137.85 ],
	[ 12000,  nan,  214.66 ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/dgeqrf.txt
# numactl --interleave=all ./testing_dgeqrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dgeqrf = array([
	[    10,     10,  nan,  nan,    0.06,   0.00,  nan ],
	[    20,     20,  nan,  nan,    0.32,   0.00,  nan ],
	[    30,     30,  nan,  nan,    0.85,   0.00,  nan ],
	[    40,     40,  nan,  nan,    1.43,   0.00,  nan ],
	[    50,     50,  nan,  nan,    2.04,   0.00,  nan ],
	[    60,     60,  nan,  nan,    2.59,   0.00,  nan ],
	[    70,     70,  nan,  nan,    0.51,   0.00,  nan ],
	[    80,     80,  nan,  nan,    0.74,   0.00,  nan ],
	[    90,     90,  nan,  nan,    0.98,   0.00,  nan ],
	[   100,    100,  nan,  nan,    1.26,   0.00,  nan ],
	[   200,    200,  nan,  nan,    3.42,   0.00,  nan ],
	[   300,    300,  nan,  nan,    7.40,   0.00,  nan ],
	[   400,    400,  nan,  nan,   11.77,   0.01,  nan ],
	[   500,    500,  nan,  nan,   14.00,   0.01,  nan ],
	[   600,    600,  nan,  nan,   18.91,   0.02,  nan ],
	[   700,    700,  nan,  nan,   24.23,   0.02,  nan ],
	[   800,    800,  nan,  nan,   31.25,   0.02,  nan ],
	[   900,    900,  nan,  nan,   37.05,   0.03,  nan ],
	[  1000,   1000,  nan,  nan,   47.93,   0.03,  nan ],
	[  2000,   2000,  nan,  nan,  137.30,   0.08,  nan ],
	[  3000,   3000,  nan,  nan,  250.71,   0.14,  nan ],
	[  4000,   4000,  nan,  nan,  358.98,   0.24,  nan ],
	[  5000,   5000,  nan,  nan,  463.81,   0.36,  nan ],
	[  6000,   6000,  nan,  nan,  540.45,   0.53,  nan ],
	[  7000,   7000,  nan,  nan,  659.29,   0.69,  nan ],
	[  8000,   8000,  nan,  nan,  719.53,   0.95,  nan ],
	[  9000,   9000,  nan,  nan,  748.15,   1.30,  nan ],
	[ 10000,  10000,  nan,  nan,  820.70,   1.62,  nan ],
	[ 12000,  12000,  nan,  nan,  904.15,   2.55,  nan ],
	[ 14000,  14000,  nan,  nan,  952.76,   3.84,  nan ],
	[ 16000,  16000,  nan,  nan,  962.27,   5.68,  nan ],
	[ 18000,  18000,  nan,  nan,  986.77,   7.88,  nan ],
	[ 20000,  20000,  nan,  nan,  991.35,  10.76,  nan ],
])

# numactl --interleave=all ./testing_dgeqrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dgeqrf_gpu = array([
	[    10,     10,  nan,  nan,    0.00,   0.00,  nan ],
	[    20,     20,  nan,  nan,    0.01,   0.00,  nan ],
	[    30,     30,  nan,  nan,    0.04,   0.00,  nan ],
	[    40,     40,  nan,  nan,    0.08,   0.00,  nan ],
	[    50,     50,  nan,  nan,    0.16,   0.00,  nan ],
	[    60,     60,  nan,  nan,    0.27,   0.00,  nan ],
	[    70,     70,  nan,  nan,    0.28,   0.00,  nan ],
	[    80,     80,  nan,  nan,    0.41,   0.00,  nan ],
	[    90,     90,  nan,  nan,    0.62,   0.00,  nan ],
	[   100,    100,  nan,  nan,    1.66,   0.00,  nan ],
	[   200,    200,  nan,  nan,    2.60,   0.00,  nan ],
	[   300,    300,  nan,  nan,    5.10,   0.01,  nan ],
	[   400,    400,  nan,  nan,    8.58,   0.01,  nan ],
	[   500,    500,  nan,  nan,   10.89,   0.02,  nan ],
	[   600,    600,  nan,  nan,   15.45,   0.02,  nan ],
	[   700,    700,  nan,  nan,   20.47,   0.02,  nan ],
	[   800,    800,  nan,  nan,   26.64,   0.03,  nan ],
	[   900,    900,  nan,  nan,   33.42,   0.03,  nan ],
	[  1000,   1000,  nan,  nan,   38.91,   0.03,  nan ],
	[  2000,   2000,  nan,  nan,  116.22,   0.09,  nan ],
	[  3000,   3000,  nan,  nan,  229.03,   0.16,  nan ],
	[  4000,   4000,  nan,  nan,  340.90,   0.25,  nan ],
	[  5000,   5000,  nan,  nan,  442.02,   0.38,  nan ],
	[  6000,   6000,  nan,  nan,  527.46,   0.55,  nan ],
	[  7000,   7000,  nan,  nan,  547.89,   0.83,  nan ],
	[  8000,   8000,  nan,  nan,  601.78,   1.13,  nan ],
	[  9000,   9000,  nan,  nan,  668.38,   1.45,  nan ],
	[ 10000,  10000,  nan,  nan,  784.30,   1.70,  nan ],
	[ 12000,  12000,  nan,  nan,  885.57,   2.60,  nan ],
	[ 14000,  14000,  nan,  nan,  928.90,   3.94,  nan ],
	[ 16000,  16000,  nan,  nan,  939.45,   5.81,  nan ],
	[ 18000,  18000,  nan,  nan,  981.59,   7.92,  nan ],
	[ 20000,  20000,  nan,  nan,  985.86,  10.82,  nan ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/dgetrf.txt
# numactl --interleave=all ./testing_dgetrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dgetrf = array([
	[    10,     10,  nan,  nan,    0.03,  0.00,  nan ],
	[    20,     20,  nan,  nan,    0.21,  0.00,  nan ],
	[    30,     30,  nan,  nan,    0.37,  0.00,  nan ],
	[    40,     40,  nan,  nan,    0.96,  0.00,  nan ],
	[    50,     50,  nan,  nan,    1.30,  0.00,  nan ],
	[    60,     60,  nan,  nan,    1.85,  0.00,  nan ],
	[    70,     70,  nan,  nan,    1.09,  0.00,  nan ],
	[    80,     80,  nan,  nan,    2.21,  0.00,  nan ],
	[    90,     90,  nan,  nan,    2.34,  0.00,  nan ],
	[   100,    100,  nan,  nan,    3.12,  0.00,  nan ],
	[   200,    200,  nan,  nan,    1.57,  0.00,  nan ],
	[   300,    300,  nan,  nan,    2.93,  0.01,  nan ],
	[   400,    400,  nan,  nan,    5.34,  0.01,  nan ],
	[   500,    500,  nan,  nan,    6.85,  0.01,  nan ],
	[   600,    600,  nan,  nan,   11.65,  0.01,  nan ],
	[   700,    700,  nan,  nan,   13.60,  0.02,  nan ],
	[   800,    800,  nan,  nan,   15.60,  0.02,  nan ],
	[   900,    900,  nan,  nan,   24.71,  0.02,  nan ],
	[  1000,   1000,  nan,  nan,   28.77,  0.02,  nan ],
	[  2000,   2000,  nan,  nan,   81.33,  0.07,  nan ],
	[  3000,   3000,  nan,  nan,  160.16,  0.11,  nan ],
	[  4000,   4000,  nan,  nan,  230.79,  0.18,  nan ],
	[  5000,   5000,  nan,  nan,  307.33,  0.27,  nan ],
	[  6000,   6000,  nan,  nan,  401.87,  0.36,  nan ],
	[  7000,   7000,  nan,  nan,  484.96,  0.47,  nan ],
	[  8000,   8000,  nan,  nan,  556.84,  0.61,  nan ],
	[  9000,   9000,  nan,  nan,  465.87,  1.04,  nan ],
	[ 10000,  10000,  nan,  nan,  537.38,  1.24,  nan ],
	[ 12000,  12000,  nan,  nan,  666.13,  1.73,  nan ],
	[ 14000,  14000,  nan,  nan,  734.33,  2.49,  nan ],
	[ 16000,  16000,  nan,  nan,  800.74,  3.41,  nan ],
	[ 18000,  18000,  nan,  nan,  849.48,  4.58,  nan ],
	[ 20000,  20000,  nan,  nan,  884.50,  6.03,  nan ],
])

# numactl --interleave=all ./testing_dgetrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dgetrf_gpu = array([
	[    10,     10,  nan,  nan,     0.01,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.08,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.20,  0.00,  nan ],
	[    40,     40,  nan,  nan,     0.47,  0.00,  nan ],
	[    50,     50,  nan,  nan,     0.72,  0.00,  nan ],
	[    60,     60,  nan,  nan,     1.06,  0.00,  nan ],
	[    70,     70,  nan,  nan,     0.78,  0.00,  nan ],
	[    80,     80,  nan,  nan,     1.43,  0.00,  nan ],
	[    90,     90,  nan,  nan,     1.76,  0.00,  nan ],
	[   100,    100,  nan,  nan,     1.94,  0.00,  nan ],
	[   200,    200,  nan,  nan,     2.13,  0.00,  nan ],
	[   300,    300,  nan,  nan,     6.02,  0.00,  nan ],
	[   400,    400,  nan,  nan,    11.28,  0.00,  nan ],
	[   500,    500,  nan,  nan,    17.43,  0.00,  nan ],
	[   600,    600,  nan,  nan,    25.38,  0.01,  nan ],
	[   700,    700,  nan,  nan,    33.92,  0.01,  nan ],
	[   800,    800,  nan,  nan,    42.64,  0.01,  nan ],
	[   900,    900,  nan,  nan,    52.44,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,    59.67,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,   148.62,  0.04,  nan ],
	[  3000,   3000,  nan,  nan,   208.77,  0.09,  nan ],
	[  4000,   4000,  nan,  nan,   211.33,  0.20,  nan ],
	[  5000,   5000,  nan,  nan,   285.97,  0.29,  nan ],
	[  6000,   6000,  nan,  nan,   394.14,  0.37,  nan ],
	[  7000,   7000,  nan,  nan,   470.15,  0.49,  nan ],
	[  8000,   8000,  nan,  nan,   542.20,  0.63,  nan ],
	[  9000,   9000,  nan,  nan,   729.40,  0.67,  nan ],
	[ 10000,  10000,  nan,  nan,   764.43,  0.87,  nan ],
	[ 12000,  12000,  nan,  nan,   854.70,  1.35,  nan ],
	[ 14000,  14000,  nan,  nan,   930.72,  1.97,  nan ],
	[ 16000,  16000,  nan,  nan,   969.89,  2.82,  nan ],
	[ 18000,  18000,  nan,  nan,   997.58,  3.90,  nan ],
	[ 20000,  20000,  nan,  nan,  1022.62,  5.22,  nan ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/dpotrf.txt
# numactl --interleave=all ./testing_dpotrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dpotrf = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.01,  0.00,  nan ],
	[    30,  nan,  nan,     0.03,  0.00,  nan ],
	[    40,  nan,  nan,     0.46,  0.00,  nan ],
	[    50,  nan,  nan,     0.86,  0.00,  nan ],
	[    60,  nan,  nan,     1.21,  0.00,  nan ],
	[    70,  nan,  nan,     1.49,  0.00,  nan ],
	[    80,  nan,  nan,     1.91,  0.00,  nan ],
	[    90,  nan,  nan,     0.64,  0.00,  nan ],
	[   100,  nan,  nan,     0.82,  0.00,  nan ],
	[   200,  nan,  nan,     4.48,  0.00,  nan ],
	[   300,  nan,  nan,     4.93,  0.00,  nan ],
	[   400,  nan,  nan,     9.16,  0.00,  nan ],
	[   500,  nan,  nan,    16.00,  0.00,  nan ],
	[   600,  nan,  nan,    19.26,  0.00,  nan ],
	[   700,  nan,  nan,    26.48,  0.00,  nan ],
	[   800,  nan,  nan,    31.13,  0.01,  nan ],
	[   900,  nan,  nan,    39.17,  0.01,  nan ],
	[  1000,  nan,  nan,    51.41,  0.01,  nan ],
	[  2000,  nan,  nan,   161.35,  0.02,  nan ],
	[  3000,  nan,  nan,   284.74,  0.03,  nan ],
	[  4000,  nan,  nan,   483.60,  0.04,  nan ],
	[  5000,  nan,  nan,   577.91,  0.07,  nan ],
	[  6000,  nan,  nan,   632.40,  0.11,  nan ],
	[  7000,  nan,  nan,   654.92,  0.17,  nan ],
	[  8000,  nan,  nan,   711.04,  0.24,  nan ],
	[  9000,  nan,  nan,   779.55,  0.31,  nan ],
	[ 10000,  nan,  nan,   865.84,  0.39,  nan ],
	[ 12000,  nan,  nan,   935.37,  0.62,  nan ],
	[ 14000,  nan,  nan,   985.07,  0.93,  nan ],
	[ 16000,  nan,  nan,  1026.17,  1.33,  nan ],
	[ 18000,  nan,  nan,  1048.12,  1.85,  nan ],
	[ 20000,  nan,  nan,  1075.29,  2.48,  nan ],
])

# numactl --interleave=all ./testing_dpotrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dpotrf_gpu = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.00,  0.00,  nan ],
	[    30,  nan,  nan,     0.01,  0.00,  nan ],
	[    40,  nan,  nan,     0.03,  0.00,  nan ],
	[    50,  nan,  nan,     0.05,  0.00,  nan ],
	[    60,  nan,  nan,     0.08,  0.00,  nan ],
	[    70,  nan,  nan,     0.13,  0.00,  nan ],
	[    80,  nan,  nan,     0.19,  0.00,  nan ],
	[    90,  nan,  nan,     0.25,  0.00,  nan ],
	[   100,  nan,  nan,     0.33,  0.00,  nan ],
	[   200,  nan,  nan,     6.99,  0.00,  nan ],
	[   300,  nan,  nan,     3.60,  0.00,  nan ],
	[   400,  nan,  nan,     7.11,  0.00,  nan ],
	[   500,  nan,  nan,    13.00,  0.00,  nan ],
	[   600,  nan,  nan,    17.03,  0.00,  nan ],
	[   700,  nan,  nan,    24.19,  0.00,  nan ],
	[   800,  nan,  nan,    29.11,  0.01,  nan ],
	[   900,  nan,  nan,    39.30,  0.01,  nan ],
	[  1000,  nan,  nan,    52.32,  0.01,  nan ],
	[  2000,  nan,  nan,   201.45,  0.01,  nan ],
	[  3000,  nan,  nan,   350.96,  0.03,  nan ],
	[  4000,  nan,  nan,   591.63,  0.04,  nan ],
	[  5000,  nan,  nan,   693.56,  0.06,  nan ],
	[  6000,  nan,  nan,   809.99,  0.09,  nan ],
	[  7000,  nan,  nan,   865.10,  0.13,  nan ],
	[  8000,  nan,  nan,   939.83,  0.18,  nan ],
	[  9000,  nan,  nan,   970.93,  0.25,  nan ],
	[ 10000,  nan,  nan,  1002.95,  0.33,  nan ],
	[ 12000,  nan,  nan,  1057.61,  0.54,  nan ],
	[ 14000,  nan,  nan,  1099.66,  0.83,  nan ],
	[ 16000,  nan,  nan,  1131.51,  1.21,  nan ],
	[ 18000,  nan,  nan,  1142.81,  1.70,  nan ],
	[ 20000,  nan,  nan,  1162.36,  2.29,  nan ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/dsyevd.txt
# numactl --interleave=all ./testing_dsyevd -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dsyevd_JN = array([
	[    10,  nan,    0.01 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.00 ],
	[    60,  nan,    0.00 ],
	[    70,  nan,    0.00 ],
	[    80,  nan,    0.00 ],
	[    90,  nan,    0.00 ],
	[   100,  nan,    0.00 ],
	[   200,  nan,    0.01 ],
	[   300,  nan,    0.01 ],
	[   400,  nan,    0.02 ],
	[   500,  nan,    0.03 ],
	[   600,  nan,    0.04 ],
	[   700,  nan,    0.05 ],
	[   800,  nan,    0.06 ],
	[   900,  nan,    0.08 ],
	[  1000,  nan,    0.09 ],
	[  2000,  nan,    0.36 ],
	[  3000,  nan,    2.04 ],
	[  4000,  nan,    4.21 ],
	[  5000,  nan,    7.35 ],
	[  6000,  nan,   11.76 ],
	[  7000,  nan,   17.39 ],
	[  8000,  nan,   24.66 ],
	[  9000,  nan,   33.89 ],
	[ 10000,  nan,   44.64 ],
	[ 12000,  nan,   73.61 ],
	[ 14000,  nan,  112.02 ],
	[ 16000,  nan,  161.95 ],
	[ 18000,  nan,  225.21 ],
	[ 20000,  nan,  304.77 ],
])

# numactl --interleave=all ./testing_dsyevd -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dsyevd_JV = array([
	[    10,  nan,    0.00 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.00 ],
	[    60,  nan,    0.00 ],
	[    70,  nan,    0.00 ],
	[    80,  nan,    0.00 ],
	[    90,  nan,    0.00 ],
	[   100,  nan,    0.00 ],
	[   200,  nan,    0.01 ],
	[   300,  nan,    0.02 ],
	[   400,  nan,    0.03 ],
	[   500,  nan,    0.04 ],
	[   600,  nan,    0.04 ],
	[   700,  nan,    0.06 ],
	[   800,  nan,    0.07 ],
	[   900,  nan,    0.10 ],
	[  1000,  nan,    0.12 ],
	[  2000,  nan,    0.47 ],
	[  3000,  nan,    2.77 ],
	[  4000,  nan,    5.87 ],
	[  5000,  nan,   10.39 ],
	[  6000,  nan,   16.12 ],
	[  7000,  nan,   21.12 ],
	[  8000,  nan,   33.04 ],
	[  9000,  nan,   43.53 ],
	[ 10000,  nan,   56.81 ],
	[ 12000,  nan,   90.11 ],
	[ 14000,  nan,  132.02 ],
	[ 16000,  nan,  185.74 ],
	[ 18000,  nan,  254.75 ],
	[ 20000,  nan,  342.53 ],
])

# numactl --interleave=all ./testing_dsyevd_gpu -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dsyevd_gpu_JN = array([
	[    10,  nan,    0.00 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.00 ],
	[    60,  nan,    0.00 ],
	[    70,  nan,    0.00 ],
	[    80,  nan,    0.00 ],
	[    90,  nan,    0.00 ],
	[   100,  nan,    0.00 ],
	[   200,  nan,    0.01 ],
	[   300,  nan,    0.01 ],
	[   400,  nan,    0.02 ],
	[   500,  nan,    0.03 ],
	[   600,  nan,    0.04 ],
	[   700,  nan,    0.05 ],
	[   800,  nan,    0.06 ],
	[   900,  nan,    0.08 ],
	[  1000,  nan,    0.09 ],
	[  2000,  nan,    0.37 ],
	[  3000,  nan,    2.03 ],
	[  4000,  nan,    4.19 ],
	[  5000,  nan,    7.34 ],
	[  6000,  nan,   11.63 ],
	[  7000,  nan,   17.35 ],
	[  8000,  nan,   24.59 ],
	[  9000,  nan,   33.76 ],
	[ 10000,  nan,   44.59 ],
	[ 12000,  nan,   73.53 ],
	[ 14000,  nan,  112.06 ],
	[ 16000,  nan,  161.73 ],
	[ 18000,  nan,  224.80 ],
	[ 20000,  nan,  304.29 ],
])

# numactl --interleave=all ./testing_dsyevd_gpu -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dsyevd_gpu_JV = array([
	[    10,  nan,    0.00 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.00 ],
	[    60,  nan,    0.00 ],
	[    70,  nan,    0.00 ],
	[    80,  nan,    0.00 ],
	[    90,  nan,    0.00 ],
	[   100,  nan,    0.00 ],
	[   200,  nan,    0.01 ],
	[   300,  nan,    0.02 ],
	[   400,  nan,    0.02 ],
	[   500,  nan,    0.03 ],
	[   600,  nan,    0.04 ],
	[   700,  nan,    0.06 ],
	[   800,  nan,    0.07 ],
	[   900,  nan,    0.09 ],
	[  1000,  nan,    0.11 ],
	[  2000,  nan,    0.40 ],
	[  3000,  nan,    2.16 ],
	[  4000,  nan,    4.46 ],
	[  5000,  nan,    7.79 ],
	[  6000,  nan,   12.29 ],
	[  7000,  nan,   18.50 ],
	[  8000,  nan,   26.56 ],
	[  9000,  nan,   36.40 ],
	[ 10000,  nan,   48.31 ],
	[ 12000,  nan,   79.68 ],
	[ 14000,  nan,  122.36 ],
	[ 16000,  nan,  175.97 ],
	[ 18000,  nan,  246.83 ],
	[ 20000,  nan,  334.30 ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/dsyevd_2stage.txt
# numactl --interleave=all ./testing_dsyevdx_2stage -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dsyevdx_2stage_JN = array([
	[    60,      0,   0.00 ],
	[    70,     70,   0.00 ],
	[    80,     80,   0.00 ],
	[    90,     90,   0.00 ],
	[   100,    100,   0.00 ],
	[   200,    200,   0.00 ],
	[   300,    300,   0.02 ],
	[   400,    400,   0.03 ],
	[   500,    500,   0.05 ],
	[   600,    600,   0.07 ],
	[   700,    700,   0.09 ],
	[   800,    800,   0.11 ],
	[   900,    900,   0.13 ],
	[  1000,   1000,   0.15 ],
	[  2000,   2000,   0.45 ],
	[  3000,   3000,   0.88 ],
	[  4000,   4000,   1.41 ],
	[  5000,   5000,   2.06 ],
	[  6000,   6000,   2.83 ],
	[  7000,   7000,   3.79 ],
	[  8000,   8000,   4.78 ],
	[  9000,   9000,   6.16 ],
	[ 10000,  10000,   7.41 ],
	[ 12000,  12000,  10.51 ],
	[ 14000,  14000,  14.72 ],
	[ 16000,  16000,  19.46 ],
	[ 18000,  18000,  25.18 ],
	[ 20000,  20000,  32.12 ],
])

# numactl --interleave=all ./testing_dsyevdx_2stage -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dsyevdx_2stage_JV = array([
	[    10,     10,   0.00 ],
	[    20,     20,   0.00 ],
	[    30,     30,   0.00 ],
	[    40,     40,   0.00 ],
	[    50,     50,   0.00 ],
	[    60,     60,   0.00 ],
	[    70,     70,   0.00 ],
	[    80,     80,   0.00 ],
	[    90,     90,   0.00 ],
	[   100,    100,   0.00 ],
	[   200,    200,   0.01 ],
	[   300,    300,   0.03 ],
	[   400,    400,   0.05 ],
	[   500,    500,   0.07 ],
	[   600,    600,   0.09 ],
	[   700,    700,   0.12 ],
	[   800,    800,   0.15 ],
	[   900,    900,   0.17 ],
	[  1000,   1000,   0.20 ],
	[  2000,   2000,   0.57 ],
	[  3000,   3000,   1.16 ],
	[  4000,   4000,   1.99 ],
	[  5000,   5000,   2.98 ],
	[  6000,   6000,   4.40 ],
	[  7000,   7000,   5.99 ],
	[  8000,   8000,   8.16 ],
	[  9000,   9000,  10.76 ],
	[ 10000,  10000,  13.61 ],
	[ 12000,  12000,  21.88 ],
	[ 14000,  14000,  33.25 ],
	[ 16000,  16000,  48.10 ],
	[ 18000,  18000,  63.35 ],
	[ 20000,  20000,  85.80 ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/dsymv.txt
# numactl --interleave=all ./testing_dsymv -N 100 -N 1000 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000
dsymv_L = array([
	[    10,   0.01,   0.03,   0.01,   0.03,   0.01,   0.02,   0.12,   0.00,  8.88e-17,  8.88e-17,  8.88e-17,  nan ],
	[    11,   0.01,   0.03,   0.01,   0.03,   0.01,   0.02,   0.12,   0.00,  8.07e-17,  8.07e-17,  8.07e-17,  nan ],
	[    12,   0.01,   0.03,   0.01,   0.03,   0.01,   0.02,   0.15,   0.00,  7.40e-17,  7.40e-17,  7.40e-17,  nan ],
	[    13,   0.01,   0.03,   0.01,   0.03,   0.02,   0.02,   0.19,   0.00,  6.83e-17,  1.37e-16,  6.83e-17,  nan ],
	[    14,   0.01,   0.03,   0.02,   0.03,   0.02,   0.02,   0.20,   0.00,  1.27e-16,  1.27e-16,  1.27e-16,  nan ],
	[    15,   0.02,   0.03,   0.02,   0.03,   0.02,   0.02,   0.17,   0.00,  5.92e-17,  5.92e-17,  5.92e-17,  nan ],
	[    16,   0.02,   0.03,   0.02,   0.03,   0.03,   0.02,   0.29,   0.00,  1.11e-16,  1.11e-16,  5.55e-17,  nan ],
	[    17,   0.02,   0.03,   0.02,   0.03,   0.03,   0.02,   0.32,   0.00,  1.04e-16,  1.04e-16,  2.09e-16,  nan ],
	[    18,   0.02,   0.03,   0.03,   0.03,   0.03,   0.02,   0.22,   0.00,  9.87e-17,  9.87e-17,  9.87e-17,  nan ],
	[    19,   0.03,   0.03,   0.03,   0.03,   0.04,   0.02,   0.35,   0.00,  1.40e-16,  9.35e-17,  1.40e-16,  nan ],
	[    20,   0.03,   0.03,   0.03,   0.03,   0.04,   0.02,   0.44,   0.00,  8.88e-17,  8.88e-17,  8.88e-17,  nan ],
	[    21,   0.03,   0.03,   0.04,   0.03,   0.05,   0.02,   0.48,   0.00,  8.46e-17,  1.27e-16,  1.69e-16,  nan ],
	[    22,   0.03,   0.03,   0.04,   0.03,   0.05,   0.02,   0.53,   0.00,  8.07e-17,  8.07e-17,  8.07e-17,  nan ],
	[    23,   0.04,   0.03,   0.04,   0.03,   0.06,   0.02,   0.39,   0.00,  7.72e-17,  1.16e-16,  1.16e-16,  nan ],
	[    24,   0.04,   0.03,   0.05,   0.03,   0.06,   0.02,   0.63,   0.00,  1.11e-16,  7.40e-17,  1.11e-16,  nan ],
	[    25,   0.04,   0.03,   0.05,   0.03,   0.06,   0.02,   0.45,   0.00,  1.42e-16,  1.42e-16,  7.11e-17,  nan ],
	[    26,   0.05,   0.03,   0.05,   0.03,   0.07,   0.02,   0.45,   0.00,  1.37e-16,  1.37e-16,  1.37e-16,  nan ],
	[    27,   0.05,   0.03,   0.06,   0.03,   0.07,   0.02,   0.49,   0.00,  1.32e-16,  1.32e-16,  1.32e-16,  nan ],
	[    28,   0.05,   0.03,   0.06,   0.03,   0.07,   0.02,   0.76,   0.00,  1.90e-16,  1.27e-16,  1.27e-16,  nan ],
	[    29,   0.06,   0.03,   0.06,   0.03,   0.08,   0.02,   0.56,   0.00,  1.84e-16,  1.84e-16,  1.23e-16,  nan ],
	[    30,   0.06,   0.03,   0.07,   0.03,   0.08,   0.02,   0.60,   0.00,  5.92e-17,  1.18e-16,  1.18e-16,  nan ],
	[    31,   0.06,   0.03,   0.07,   0.03,   0.09,   0.02,   0.69,   0.00,  1.15e-16,  1.15e-16,  1.15e-16,  nan ],
	[    32,   0.07,   0.03,   0.07,   0.03,   0.10,   0.02,   0.74,   0.00,  1.67e-16,  1.11e-16,  1.67e-16,  nan ],
	[    33,   0.07,   0.03,   0.06,   0.03,   0.09,   0.02,   0.78,   0.00,  1.08e-16,  1.08e-16,  1.08e-16,  nan ],
	[    34,   0.08,   0.03,   0.07,   0.03,   0.10,   0.02,   1.25,   0.00,  2.09e-16,  1.57e-16,  1.04e-16,  nan ],
	[    35,   0.08,   0.03,   0.07,   0.03,   0.11,   0.02,   0.81,   0.00,  2.03e-16,  1.52e-16,  1.02e-16,  nan ],
	[    36,   0.09,   0.03,   0.08,   0.03,   0.12,   0.02,   1.40,   0.00,  9.87e-17,  9.87e-17,  1.48e-16,  nan ],
	[    37,   0.09,   0.03,   0.08,   0.03,   0.12,   0.02,   1.47,   0.00,  9.60e-17,  1.44e-16,  9.60e-17,  nan ],
	[    38,   0.09,   0.03,   0.09,   0.03,   0.13,   0.02,   1.55,   0.00,  1.87e-16,  1.40e-16,  1.40e-16,  nan ],
	[    39,   0.10,   0.03,   0.09,   0.03,   0.14,   0.02,   1.64,   0.00,  9.11e-17,  1.37e-16,  9.11e-17,  nan ],
	[    40,   0.10,   0.03,   0.10,   0.03,   0.14,   0.02,   1.53,   0.00,  1.78e-16,  1.33e-16,  1.33e-16,  nan ],
	[    41,   0.11,   0.03,   0.10,   0.03,   0.15,   0.02,   1.81,   0.00,  1.30e-16,  1.30e-16,  1.30e-16,  nan ],
	[    42,   0.11,   0.03,   0.11,   0.03,   0.16,   0.02,   1.89,   0.00,  1.69e-16,  1.27e-16,  1.27e-16,  nan ],
	[    43,   0.12,   0.03,   0.11,   0.03,   0.17,   0.02,   1.98,   0.00,  2.48e-16,  1.24e-16,  1.65e-16,  nan ],
	[    44,   0.13,   0.03,   0.12,   0.03,   0.17,   0.02,   1.38,   0.00,  1.61e-16,  1.61e-16,  1.61e-16,  nan ],
	[    45,   0.13,   0.03,   0.12,   0.03,   0.17,   0.03,   1.34,   0.00,  1.58e-16,  1.58e-16,  1.58e-16,  nan ],
	[    46,   0.14,   0.03,   0.12,   0.04,   0.19,   0.02,   2.02,   0.00,  1.54e-16,  1.54e-16,  1.54e-16,  nan ],
	[    47,   0.14,   0.03,   0.13,   0.03,   0.20,   0.02,   2.37,   0.00,  1.51e-16,  1.51e-16,  1.13e-16,  nan ],
	[    48,   0.15,   0.03,   0.14,   0.03,   0.21,   0.02,   2.47,   0.00,  1.48e-16,  1.48e-16,  1.48e-16,  nan ],
	[    49,   0.15,   0.03,   0.14,   0.03,   0.21,   0.02,   1.58,   0.00,  1.45e-16,  1.45e-16,  1.45e-16,  nan ],
	[    50,   0.16,   0.03,   0.15,   0.03,   0.22,   0.02,   1.65,   0.00,  1.42e-16,  1.42e-16,  1.42e-16,  nan ],
	[    51,   0.17,   0.03,   0.15,   0.04,   0.23,   0.02,   1.39,   0.00,  1.39e-16,  1.39e-16,  1.39e-16,  nan ],
	[    52,   0.17,   0.03,   0.16,   0.03,   0.24,   0.02,   1.44,   0.00,  2.05e-16,  1.37e-16,  1.37e-16,  nan ],
	[    53,   0.18,   0.03,   0.17,   0.03,   0.25,   0.02,   1.41,   0.00,  1.34e-16,  2.01e-16,  1.34e-16,  nan ],
	[    54,   0.19,   0.03,   0.16,   0.04,   0.26,   0.02,   0.75,   0.01,  1.32e-16,  1.32e-16,  1.32e-16,  nan ],
	[    55,   0.19,   0.03,   0.18,   0.04,   0.26,   0.02,   1.52,   0.00,  1.94e-16,  1.94e-16,  1.29e-16,  nan ],
	[    56,   0.20,   0.03,   0.18,   0.04,   0.26,   0.02,   1.58,   0.00,  1.90e-16,  1.27e-16,  1.27e-16,  nan ],
	[    57,   0.21,   0.03,   0.19,   0.04,   0.27,   0.02,   1.32,   0.01,  1.25e-16,  1.87e-16,  1.87e-16,  nan ],
	[    58,   0.21,   0.03,   0.20,   0.04,   0.29,   0.02,   1.37,   0.01,  1.23e-16,  1.23e-16,  1.23e-16,  nan ],
	[    59,   0.22,   0.03,   0.20,   0.04,   0.31,   0.02,   1.41,   0.01,  1.20e-16,  1.81e-16,  1.20e-16,  nan ],
	[    60,   0.24,   0.03,   0.21,   0.04,   0.32,   0.02,   1.92,   0.00,  1.18e-16,  1.18e-16,  1.78e-16,  nan ],
	[    61,   0.25,   0.03,   0.22,   0.03,   0.34,   0.02,   1.51,   0.01,  1.75e-16,  2.33e-16,  2.91e-16,  nan ],
	[    62,   0.25,   0.03,   0.23,   0.03,   0.34,   0.02,   1.56,   0.01,  1.72e-16,  1.15e-16,  1.72e-16,  nan ],
	[    63,   0.26,   0.03,   0.23,   0.04,   0.35,   0.02,   1.61,   0.01,  1.13e-16,  1.69e-16,  2.26e-16,  nan ],
	[    64,   0.29,   0.03,   0.24,   0.03,   0.36,   0.02,   1.66,   0.01,  2.22e-16,  1.67e-16,  1.11e-16,  nan ],
	[    65,   0.25,   0.03,   0.24,   0.04,   0.33,   0.03,   1.71,   0.01,  2.73e-16,  2.19e-16,  3.28e-16,  nan ],
	[    66,   0.25,   0.04,   0.25,   0.04,   0.34,   0.03,   1.77,   0.01,  1.61e-16,  2.15e-16,  2.15e-16,  nan ],
	[    67,   0.25,   0.04,   0.25,   0.04,   0.36,   0.03,   1.53,   0.01,  1.59e-16,  1.59e-16,  1.59e-16,  nan ],
	[    68,   0.26,   0.04,   0.26,   0.04,   0.36,   0.03,   1.87,   0.01,  1.57e-16,  2.09e-16,  2.09e-16,  nan ],
	[    69,   0.26,   0.04,   0.27,   0.04,   0.36,   0.03,   1.93,   0.01,  2.06e-16,  2.06e-16,  2.06e-16,  nan ],
	[    70,   0.22,   0.05,   0.19,   0.05,   0.38,   0.03,   1.99,   0.01,  1.52e-16,  2.03e-16,  2.03e-16,  nan ],
	[    71,   0.27,   0.04,   0.27,   0.04,   0.39,   0.03,   2.04,   0.01,  3.00e-16,  2.50e-16,  2.50e-16,  nan ],
	[    72,   0.15,   0.07,   0.28,   0.04,   0.40,   0.03,   2.10,   0.01,  1.48e-16,  1.48e-16,  9.87e-17,  nan ],
	[    73,   0.28,   0.04,   0.28,   0.04,   0.40,   0.03,   1.81,   0.01,  1.46e-16,  1.46e-16,  1.46e-16,  nan ],
	[    74,   0.30,   0.04,   0.30,   0.04,   0.43,   0.03,   2.22,   0.01,  2.40e-16,  2.88e-16,  2.40e-16,  nan ],
	[    75,   0.30,   0.04,   0.30,   0.04,   0.42,   0.03,   1.65,   0.01,  1.42e-16,  1.42e-16,  1.42e-16,  nan ],
	[    76,   0.31,   0.04,   0.31,   0.04,   0.36,   0.03,   1.89,   0.01,  1.40e-16,  1.87e-16,  1.40e-16,  nan ],
	[    77,   0.33,   0.04,   0.33,   0.04,   0.43,   0.03,   2.02,   0.01,  1.85e-16,  1.85e-16,  2.31e-16,  nan ],
	[    78,   0.33,   0.04,   0.32,   0.04,   0.44,   0.03,   1.99,   0.01,  2.28e-16,  1.37e-16,  1.37e-16,  nan ],
	[    79,   0.33,   0.04,   0.34,   0.04,   0.47,   0.03,   1.83,   0.01,  1.80e-16,  1.80e-16,  1.80e-16,  nan ],
	[    80,   0.34,   0.04,   0.35,   0.04,   0.48,   0.03,   2.17,   0.01,  1.78e-16,  1.33e-16,  1.78e-16,  nan ],
	[    81,   0.35,   0.04,   0.36,   0.04,   0.49,   0.03,   2.23,   0.01,  1.75e-16,  1.75e-16,  1.75e-16,  nan ],
	[    82,   0.36,   0.04,   0.36,   0.04,   0.51,   0.03,   2.28,   0.01,  2.60e-16,  2.60e-16,  2.60e-16,  nan ],
	[    83,   0.37,   0.04,   0.37,   0.04,   0.52,   0.03,   2.02,   0.01,  1.71e-16,  2.57e-16,  1.71e-16,  nan ],
	[    84,   0.37,   0.04,   0.37,   0.04,   0.53,   0.03,   2.40,   0.01,  1.69e-16,  1.69e-16,  1.69e-16,  nan ],
	[    85,   0.40,   0.04,   0.39,   0.04,   0.56,   0.03,   2.04,   0.01,  2.51e-16,  2.51e-16,  2.51e-16,  nan ],
	[    86,   0.40,   0.04,   0.40,   0.04,   0.58,   0.03,   2.41,   0.01,  2.07e-16,  2.07e-16,  1.65e-16,  nan ],
	[    87,   0.41,   0.04,   0.40,   0.04,   0.48,   0.03,   2.14,   0.01,  2.04e-16,  2.04e-16,  2.04e-16,  nan ],
	[    88,   0.44,   0.04,   0.41,   0.04,   0.60,   0.03,   2.19,   0.01,  2.02e-16,  1.61e-16,  1.21e-16,  nan ],
	[    89,   0.44,   0.04,   0.42,   0.04,   0.59,   0.03,   2.32,   0.01,  2.00e-16,  3.19e-16,  1.60e-16,  nan ],
	[    90,   0.43,   0.04,   0.42,   0.04,   0.61,   0.03,   2.02,   0.01,  1.58e-16,  2.37e-16,  2.37e-16,  nan ],
	[   100,   0.52,   0.04,   0.49,   0.04,   0.67,   0.03,   2.57,   0.01,  2.13e-16,  1.42e-16,  2.13e-16,  nan ],
	[   110,   0.63,   0.04,   0.61,   0.04,   0.79,   0.03,   3.41,   0.01,  3.23e-16,  3.23e-16,  3.23e-16,  nan ],
	[   120,   0.75,   0.04,   0.71,   0.04,   0.97,   0.03,   2.65,   0.01,  3.55e-16,  4.74e-16,  3.55e-16,  nan ],
	[   130,   0.77,   0.04,   0.79,   0.04,   1.04,   0.03,   4.33,   0.01,  3.28e-16,  2.19e-16,  2.73e-16,  nan ],
	[   140,   0.90,   0.04,   0.92,   0.04,   1.24,   0.03,   3.31,   0.01,  4.06e-16,  4.06e-16,  3.55e-16,  nan ],
	[   150,   1.03,   0.04,   1.03,   0.04,   1.42,   0.03,   0.42,   0.11,  1.42e-16,  1.42e-16,  1.42e-16,  nan ],
	[   160,   1.17,   0.04,   1.23,   0.04,   1.61,   0.03,   0.65,   0.08,  1.78e-16,  1.33e-16,  1.33e-16,  nan ],
	[   170,   1.32,   0.04,   1.39,   0.04,   1.77,   0.03,   2.94,   0.02,  1.67e-16,  1.67e-16,  1.67e-16,  nan ],
	[   180,   1.49,   0.04,   1.49,   0.04,   2.04,   0.03,   3.11,   0.02,  1.58e-16,  1.58e-16,  1.58e-16,  nan ],
	[   190,   1.48,   0.05,   1.62,   0.04,   2.27,   0.03,   3.31,   0.02,  2.24e-16,  1.50e-16,  1.50e-16,  nan ],
	[   200,   1.64,   0.05,   1.71,   0.05,   2.18,   0.04,   0.87,   0.09,  2.13e-16,  1.42e-16,  1.42e-16,  nan ],
	[   210,   1.77,   0.05,   1.88,   0.05,   2.46,   0.04,   3.18,   0.03,  2.03e-16,  2.03e-16,  1.35e-16,  nan ],
	[   220,   1.94,   0.05,   2.03,   0.05,   2.63,   0.04,   1.52,   0.06,  1.94e-16,  1.94e-16,  1.29e-16,  nan ],
	[   230,   2.08,   0.05,   2.22,   0.05,   2.80,   0.04,   0.98,   0.11,  1.85e-16,  1.85e-16,  1.85e-16,  nan ],
	[   240,   2.27,   0.05,   2.36,   0.05,   3.05,   0.04,   1.96,   0.06,  1.78e-16,  1.78e-16,  1.18e-16,  nan ],
	[   250,   2.51,   0.05,   2.56,   0.05,   3.21,   0.04,   2.13,   0.06,  1.71e-16,  1.71e-16,  2.27e-16,  nan ],
	[   260,   2.48,   0.05,   2.71,   0.05,   3.47,   0.04,   0.11,   1.22,  2.19e-16,  1.64e-16,  1.09e-16,  nan ],
	[   270,   2.61,   0.06,   2.87,   0.05,   3.32,   0.04,   1.76,   0.08,  1.58e-16,  2.11e-16,  1.58e-16,  nan ],
	[   280,   2.81,   0.06,   3.03,   0.05,   3.84,   0.04,   1.92,   0.08,  1.52e-16,  1.52e-16,  1.52e-16,  nan ],
	[   290,   2.96,   0.06,   3.19,   0.05,   3.91,   0.04,   0.52,   0.33,  2.45e-16,  1.96e-16,  1.96e-16,  nan ],
	[   300,   3.22,   0.06,   3.41,   0.05,   4.09,   0.04,   2.25,   0.08,  1.89e-16,  1.42e-16,  1.89e-16,  nan ],
	[   310,   3.31,   0.06,   3.71,   0.05,   4.47,   0.04,   2.38,   0.08,  2.29e-16,  2.29e-16,  2.29e-16,  nan ],
	[   320,   3.61,   0.06,   3.86,   0.05,   4.66,   0.04,   0.10,   2.10,  1.78e-16,  1.78e-16,  1.78e-16,  nan ],
	[   330,   3.52,   0.06,   3.90,   0.06,   4.65,   0.05,   3.64,   0.06,  2.15e-16,  1.72e-16,  2.15e-16,  nan ],
	[   340,   3.74,   0.06,   4.21,   0.06,   5.17,   0.04,   2.79,   0.08,  1.67e-16,  2.51e-16,  2.09e-16,  nan ],
	[   350,   3.90,   0.06,   4.31,   0.06,   5.13,   0.05,   2.67,   0.09,  1.62e-16,  1.62e-16,  1.62e-16,  nan ],
	[   360,   4.13,   0.06,   4.47,   0.06,   5.32,   0.05,   0.12,   2.16,  1.58e-16,  2.37e-16,  1.97e-16,  nan ],
	[   370,   4.35,   0.06,   4.82,   0.06,   5.73,   0.05,   3.43,   0.08,  1.54e-16,  2.30e-16,  2.30e-16,  nan ],
	[   380,   4.51,   0.06,   4.84,   0.06,   5.92,   0.05,   3.26,   0.09,  2.24e-16,  2.24e-16,  2.24e-16,  nan ],
	[   390,   4.49,   0.07,   5.00,   0.06,   5.98,   0.05,   0.16,   1.97,  2.19e-16,  2.19e-16,  2.19e-16,  nan ],
	[   400,   4.70,   0.07,   5.28,   0.06,   6.41,   0.05,   3.31,   0.10,  2.13e-16,  2.13e-16,  2.84e-16,  nan ],
	[   410,   4.87,   0.07,   5.35,   0.06,   6.61,   0.05,   3.66,   0.09,  2.77e-16,  2.08e-16,  2.08e-16,  nan ],
	[   420,   5.06,   0.07,   5.51,   0.06,   6.53,   0.05,   0.14,   2.56,  2.03e-16,  2.71e-16,  2.03e-16,  nan ],
	[   430,   5.22,   0.07,   5.87,   0.06,   6.88,   0.05,   0.15,   2.43,  1.98e-16,  2.64e-16,  1.98e-16,  nan ],
	[   440,   5.46,   0.07,   6.07,   0.06,   7.20,   0.05,   0.16,   2.49,  1.94e-16,  1.94e-16,  1.94e-16,  nan ],
	[   450,   5.40,   0.08,   5.97,   0.07,   6.86,   0.06,   0.16,   2.54,  1.89e-16,  1.89e-16,  1.89e-16,  nan ],
	[   460,   5.65,   0.08,   6.22,   0.07,   7.06,   0.06,   4.61,   0.09,  2.47e-16,  1.85e-16,  1.85e-16,  nan ],
	[   470,   5.99,   0.07,   6.52,   0.07,   7.49,   0.06,   4.22,   0.10,  2.42e-16,  1.81e-16,  2.42e-16,  nan ],
	[   480,   6.15,   0.08,   6.70,   0.07,   7.84,   0.06,   0.21,   2.15,  2.37e-16,  2.37e-16,  2.37e-16,  nan ],
	[   490,   6.33,   0.08,   6.98,   0.07,   7.53,   0.06,   3.19,   0.15,  2.32e-16,  2.32e-16,  1.74e-16,  nan ],
	[   500,   6.43,   0.08,   7.17,   0.07,   7.81,   0.06,   3.41,   0.15,  2.27e-16,  2.84e-16,  1.71e-16,  nan ],
	[   510,   6.77,   0.08,   7.46,   0.07,   8.16,   0.06,   3.26,   0.16,  2.23e-16,  2.23e-16,  2.23e-16,  nan ],
	[   520,   6.53,   0.08,   7.53,   0.07,   8.09,   0.07,   0.21,   2.63,  2.19e-16,  2.19e-16,  2.19e-16,  nan ],
	[   530,   6.86,   0.08,   7.82,   0.07,   8.52,   0.07,   0.22,   2.56,  2.15e-16,  2.68e-16,  2.15e-16,  nan ],
	[   540,   7.02,   0.08,   7.88,   0.07,   8.60,   0.07,   0.13,   4.48,  2.63e-16,  2.63e-16,  1.58e-16,  nan ],
	[   550,   7.12,   0.09,   8.07,   0.08,   8.68,   0.07,   5.14,   0.12,  2.58e-16,  2.58e-16,  2.07e-16,  nan ],
	[   560,   7.38,   0.09,   8.47,   0.07,   9.09,   0.07,   3.83,   0.16,  2.03e-16,  2.03e-16,  3.05e-16,  nan ],
	[   570,   7.48,   0.09,   8.35,   0.08,   9.16,   0.07,   3.92,   0.17,  2.99e-16,  1.99e-16,  1.99e-16,  nan ],
	[   580,   7.42,   0.09,   8.64,   0.08,   9.36,   0.07,   4.04,   0.17,  2.94e-16,  1.96e-16,  1.96e-16,  nan ],
	[   590,   7.48,   0.09,   8.71,   0.08,   9.56,   0.07,   4.20,   0.17,  2.89e-16,  2.89e-16,  2.89e-16,  nan ],
	[   600,   7.84,   0.09,   8.92,   0.08,   9.85,   0.07,   4.22,   0.17,  2.37e-16,  2.37e-16,  1.89e-16,  nan ],
	[   610,   7.86,   0.09,   8.98,   0.08,   9.96,   0.07,   4.28,   0.17,  2.80e-16,  1.86e-16,  2.33e-16,  nan ],
	[   620,   8.09,   0.10,   9.18,   0.08,  10.12,   0.08,   4.48,   0.17,  2.29e-16,  1.83e-16,  2.75e-16,  nan ],
	[   630,   8.44,   0.09,   9.24,   0.09,  10.59,   0.08,   4.68,   0.17,  2.71e-16,  2.26e-16,  2.71e-16,  nan ],
	[   640,   8.56,   0.10,   9.64,   0.09,  10.96,   0.07,   4.51,   0.18,  2.66e-16,  2.66e-16,  3.11e-16,  nan ],
	[   650,   8.37,   0.10,   9.62,   0.09,  10.72,   0.08,   5.01,   0.17,  2.62e-16,  2.62e-16,  2.62e-16,  nan ],
	[   660,   8.55,   0.10,   9.92,   0.09,  11.06,   0.08,   4.99,   0.17,  2.58e-16,  2.58e-16,  2.15e-16,  nan ],
	[   670,   8.89,   0.10,  10.19,   0.09,  11.53,   0.08,   4.92,   0.18,  2.55e-16,  2.55e-16,  2.55e-16,  nan ],
	[   680,   8.99,   0.10,  10.20,   0.09,  10.88,   0.09,   4.85,   0.19,  2.51e-16,  2.51e-16,  2.51e-16,  nan ],
	[   690,   8.99,   0.11,  10.36,   0.09,  11.76,   0.08,   5.08,   0.19,  3.30e-16,  3.30e-16,  2.47e-16,  nan ],
	[   700,   9.25,   0.11,  10.02,   0.10,  11.83,   0.08,   5.14,   0.19,  2.44e-16,  2.44e-16,  3.25e-16,  nan ],
	[   710,   9.27,   0.11,  10.97,   0.09,  12.31,   0.08,   5.31,   0.19,  2.40e-16,  2.40e-16,  2.40e-16,  nan ],
	[   720,   9.61,   0.11,  11.17,   0.09,  12.81,   0.08,   5.44,   0.19,  2.37e-16,  2.37e-16,  2.37e-16,  nan ],
	[   730,   9.71,   0.11,  11.11,   0.10,  12.26,   0.09,   5.62,   0.19,  2.34e-16,  3.11e-16,  2.34e-16,  nan ],
	[   740,   9.87,   0.11,  11.08,   0.10,  12.60,   0.09,   5.65,   0.19,  3.07e-16,  3.07e-16,  2.30e-16,  nan ],
	[   750,  10.05,   0.11,  11.75,   0.10,  12.37,   0.09,   5.72,   0.20,  3.03e-16,  3.79e-16,  3.79e-16,  nan ],
	[   760,  10.07,   0.11,  11.80,   0.10,  13.11,   0.09,   6.03,   0.19,  2.99e-16,  2.24e-16,  2.24e-16,  nan ],
	[   770,  10.16,   0.12,  12.00,   0.10,  13.04,   0.09,   6.16,   0.19,  2.95e-16,  2.95e-16,  2.95e-16,  nan ],
	[   780,  10.49,   0.12,  12.20,   0.10,  13.27,   0.09,   5.80,   0.21,  2.19e-16,  2.19e-16,  2.19e-16,  nan ],
	[   790,  10.70,   0.12,  12.39,   0.10,  13.44,   0.09,   5.92,   0.21,  2.88e-16,  2.16e-16,  2.88e-16,  nan ],
	[   800,  10.97,   0.12,  12.56,   0.10,  13.93,   0.09,   6.07,   0.21,  2.84e-16,  2.84e-16,  3.55e-16,  nan ],
	[   810,  10.93,   0.12,  12.88,   0.10,  13.54,   0.10,   6.17,   0.21,  2.81e-16,  2.81e-16,  2.11e-16,  nan ],
	[   820,  11.23,   0.12,  13.07,   0.10,  14.33,   0.09,   6.23,   0.22,  2.77e-16,  2.77e-16,  2.77e-16,  nan ],
	[   830,  11.50,   0.12,  13.15,   0.10,  14.22,   0.10,   6.41,   0.22,  2.74e-16,  2.74e-16,  2.74e-16,  nan ],
	[   840,  11.51,   0.12,  13.56,   0.10,  14.89,   0.09,   8.36,   0.17,  2.71e-16,  3.38e-16,  2.71e-16,  nan ],
	[   850,  11.76,   0.12,  13.64,   0.11,  15.25,   0.09,   6.61,   0.22,  2.67e-16,  2.67e-16,  2.67e-16,  nan ],
	[   860,  11.85,   0.12,  13.83,   0.11,  15.30,   0.10,   6.56,   0.23,  2.64e-16,  2.64e-16,  2.64e-16,  nan ],
	[   870,  11.84,   0.13,  13.91,   0.11,  15.47,   0.10,   6.65,   0.23,  3.27e-16,  3.27e-16,  3.92e-16,  nan ],
	[   880,  12.02,   0.13,  14.36,   0.11,  15.48,   0.10,   6.99,   0.22,  3.23e-16,  2.58e-16,  2.58e-16,  nan ],
	[   890,  12.48,   0.13,  14.56,   0.11,  15.58,   0.10,   7.08,   0.22,  3.19e-16,  2.55e-16,  2.55e-16,  nan ],
	[   900,  12.19,   0.13,  14.60,   0.11,  16.04,   0.10,   7.02,   0.23,  2.53e-16,  2.53e-16,  2.53e-16,  nan ],
	[  1000,  13.90,   0.14,  17.00,   0.12,  17.72,   0.11,   8.07,   0.25,  2.84e-16,  2.84e-16,  2.84e-16,  nan ],
	[  1100,  14.79,   0.16,  18.78,   0.13,  11.81,   0.21,   8.35,   0.29,  3.10e-16,  3.10e-16,  3.10e-16,  nan ],
	[  1200,  16.74,   0.17,  20.74,   0.14,  12.99,   0.22,   9.12,   0.32,  3.32e-16,  2.84e-16,  2.84e-16,  nan ],
	[  1300,  18.28,   0.19,  22.99,   0.15,  14.03,   0.24,  10.13,   0.33,  3.50e-16,  2.62e-16,  3.06e-16,  nan ],
	[  1400,  19.70,   0.20,  24.67,   0.16,  14.86,   0.26,  10.40,   0.38,  3.25e-16,  3.25e-16,  3.25e-16,  nan ],
	[  1500,  21.06,   0.21,  26.79,   0.17,  15.97,   0.28,  10.80,   0.42,  3.79e-16,  3.03e-16,  3.79e-16,  nan ],
	[  1600,  22.27,   0.23,  28.46,   0.18,  16.17,   0.32,  11.26,   0.45,  3.55e-16,  3.55e-16,  3.55e-16,  nan ],
	[  1700,  23.51,   0.25,  29.84,   0.19,  17.01,   0.34,  11.41,   0.51,  3.34e-16,  3.34e-16,  4.01e-16,  nan ],
	[  1800,  25.13,   0.26,  31.62,   0.21,  18.01,   0.36,  13.37,   0.48,  3.79e-16,  3.79e-16,  3.79e-16,  nan ],
	[  1900,  25.99,   0.28,  33.59,   0.22,  19.16,   0.38,  13.18,   0.55,  3.59e-16,  3.59e-16,  2.99e-16,  nan ],
	[  2000,  27.14,   0.29,  34.36,   0.23,  20.02,   0.40,  15.42,   0.52,  3.98e-16,  4.55e-16,  3.41e-16,  nan ],
	[  2100,  25.86,   0.34,  36.32,   0.24,  15.27,   0.58,  13.96,   0.63,  4.33e-16,  3.25e-16,  3.25e-16,  nan ],
	[  2200,  30.07,   0.32,  37.54,   0.26,  16.06,   0.60,  10.83,   0.89,  5.17e-16,  3.62e-16,  3.62e-16,  nan ],
	[  2300,  31.71,   0.33,  38.94,   0.27,  16.61,   0.64,  13.18,   0.80,  3.95e-16,  4.45e-16,  3.95e-16,  nan ],
	[  2400,  33.31,   0.35,  40.28,   0.29,  17.46,   0.66,  12.58,   0.92,  4.26e-16,  4.26e-16,  3.79e-16,  nan ],
	[  2500,  34.17,   0.37,  40.88,   0.31,  18.15,   0.69,  13.34,   0.94,  4.55e-16,  4.09e-16,  4.09e-16,  nan ],
	[  2600,  34.68,   0.39,  43.21,   0.31,  18.76,   0.72,  12.44,   1.09,  5.25e-16,  3.94e-16,  4.81e-16,  nan ],
	[  2700,  36.63,   0.40,  44.75,   0.33,  19.50,   0.75,  14.93,   0.98,  4.21e-16,  4.21e-16,  4.63e-16,  nan ],
	[  2800,  37.17,   0.42,  44.42,   0.35,  19.93,   0.79,  10.21,   1.54,  4.06e-16,  4.47e-16,  4.06e-16,  nan ],
	[  2900,  38.95,   0.43,  47.40,   0.36,  20.87,   0.81,  15.55,   1.08,  5.49e-16,  4.70e-16,  4.70e-16,  nan ],
	[  3000,  39.50,   0.46,  48.54,   0.37,  21.53,   0.84,  11.15,   1.62,  5.31e-16,  4.55e-16,  5.31e-16,  nan ],
	[  3100,  41.25,   0.47,  49.53,   0.39,  17.35,   1.11,  14.85,   1.30,  5.13e-16,  5.13e-16,  5.87e-16,  nan ],
	[  3200,  42.50,   0.48,  50.46,   0.41,  17.89,   1.15,  11.21,   1.83,  4.97e-16,  4.97e-16,  5.68e-16,  nan ],
	[  3300,  43.85,   0.50,  51.74,   0.42,  18.52,   1.18,  15.61,   1.40,  4.82e-16,  4.82e-16,  4.82e-16,  nan ],
	[  3400,  44.64,   0.52,  53.03,   0.44,  19.03,   1.21,  11.62,   1.99,  5.35e-16,  4.68e-16,  5.35e-16,  nan ],
	[  3500,  45.46,   0.54,  55.06,   0.45,  19.50,   1.26,  16.14,   1.52,  5.20e-16,  5.85e-16,  5.20e-16,  nan ],
	[  3600,  46.45,   0.56,  56.23,   0.46,  20.05,   1.29,  16.76,   1.55,  5.68e-16,  4.42e-16,  4.42e-16,  nan ],
	[  3700,  47.57,   0.58,  58.40,   0.47,  20.64,   1.33,  16.96,   1.62,  6.76e-16,  6.15e-16,  5.53e-16,  nan ],
	[  3800,  48.97,   0.59,  57.45,   0.50,  20.95,   1.38,  16.38,   1.76,  5.39e-16,  5.98e-16,  4.79e-16,  nan ],
	[  3900,  49.31,   0.62,  58.52,   0.52,  21.55,   1.41,  18.60,   1.64,  4.66e-16,  6.41e-16,  4.66e-16,  nan ],
	[  4000,  48.94,   0.65,  60.07,   0.53,  22.01,   1.45,  16.91,   1.89,  5.12e-16,  5.68e-16,  5.12e-16,  nan ],
	[  4100,  47.89,   0.70,  60.48,   0.56,  18.10,   1.86,  18.27,   1.84,  4.99e-16,  5.55e-16,  5.55e-16,  nan ],
	[  4200,  47.68,   0.74,  61.06,   0.58,  18.89,   1.87,  17.10,   2.06,  7.04e-16,  5.41e-16,  4.87e-16,  nan ],
	[  4300,  48.68,   0.76,  62.38,   0.59,  19.38,   1.91,  18.58,   1.99,  6.35e-16,  6.35e-16,  4.76e-16,  nan ],
	[  4400,  49.65,   0.78,  64.87,   0.60,  19.82,   1.95,  17.28,   2.24,  5.68e-16,  5.17e-16,  5.68e-16,  nan ],
	[  4500,  50.08,   0.81,  64.51,   0.63,  20.22,   2.00,  17.38,   2.33,  6.06e-16,  6.57e-16,  5.56e-16,  nan ],
	[  4600,  50.70,   0.83,  64.94,   0.65,  20.65,   2.05,  18.35,   2.31,  4.94e-16,  6.43e-16,  5.93e-16,  nan ],
	[  4700,  50.63,   0.87,  65.68,   0.67,  21.15,   2.09,  18.01,   2.45,  5.81e-16,  5.32e-16,  5.81e-16,  nan ],
	[  4800,  50.87,   0.91,  66.71,   0.69,  21.43,   2.15,  17.28,   2.67,  6.16e-16,  5.68e-16,  5.68e-16,  nan ],
	[  4900,  50.72,   0.95,  65.51,   0.73,  21.83,   2.20,  18.80,   2.55,  6.50e-16,  6.50e-16,  6.03e-16,  nan ],
	[  5000,  51.40,   0.97,  66.07,   0.76,  22.24,   2.25,  18.17,   2.75,  6.37e-16,  5.46e-16,  6.37e-16,  nan ],
	[  5100,  51.76,   1.01,  66.45,   0.78,  22.37,   2.33,  18.53,   2.81,  8.47e-16,  7.58e-16,  6.24e-16,  nan ],
	[  5200,  51.95,   1.04,  66.63,   0.81,  19.67,   2.75,  19.10,   2.83,  7.00e-16,  6.12e-16,  7.43e-16,  nan ],
	[  5300,  52.33,   1.07,  66.97,   0.84,  20.10,   2.80,  18.90,   2.97,  6.44e-16,  6.44e-16,  5.58e-16,  nan ],
	[  5400,  52.65,   1.11,  66.52,   0.88,  20.32,   2.87,  18.85,   3.09,  8.42e-16,  6.74e-16,  7.58e-16,  nan ],
	[  5500,  52.44,   1.15,  67.46,   0.90,  20.74,   2.92,  19.67,   3.08,  8.27e-16,  6.61e-16,  6.61e-16,  nan ],
	[  5600,  54.03,   1.16,  67.74,   0.93,  21.10,   2.97,  18.71,   3.35,  7.31e-16,  6.50e-16,  7.31e-16,  nan ],
	[  5700,  54.16,   1.20,  66.73,   0.97,  21.42,   3.03,  19.60,   3.32,  7.18e-16,  6.38e-16,  5.58e-16,  nan ],
	[  5800,  53.50,   1.26,  67.30,   1.00,  21.45,   3.14,  19.65,   3.43,  7.84e-16,  7.84e-16,  7.84e-16,  nan ],
	[  5900,  54.57,   1.28,  67.54,   1.03,  21.96,   3.17,  19.87,   3.50,  7.71e-16,  7.71e-16,  6.94e-16,  nan ],
	[  6000,  54.63,   1.32,  66.91,   1.08,  22.39,   3.22,  19.54,   3.68,  6.82e-16,  6.82e-16,  6.06e-16,  nan ],
	[  6100,  55.76,   1.33,  67.60,   1.10,  22.73,   3.28,  21.32,   3.49,  7.45e-16,  6.71e-16,  7.45e-16,  nan ],
	[  6200,  55.48,   1.39,  67.27,   1.14,  20.12,   3.82,  21.35,   3.60,  8.07e-16,  7.33e-16,  6.60e-16,  nan ],
	[  6300,  55.98,   1.42,  66.99,   1.19,  20.54,   3.87,  20.76,   3.82,  8.66e-16,  7.22e-16,  8.66e-16,  nan ],
	[  6400,  55.85,   1.47,  66.99,   1.22,  20.74,   3.95,  20.84,   3.93,  7.11e-16,  8.53e-16,  7.11e-16,  nan ],
	[  6500,  57.04,   1.48,  67.93,   1.24,  20.51,   4.12,  20.09,   4.21,  7.70e-16,  8.40e-16,  7.70e-16,  nan ],
	[  6600,  57.59,   1.51,  68.55,   1.27,  21.37,   4.08,  21.12,   4.12,  8.27e-16,  7.58e-16,  6.89e-16,  nan ],
	[  6700,  58.16,   1.54,  67.68,   1.33,  21.62,   4.15,  21.57,   4.16,  8.14e-16,  7.47e-16,  6.79e-16,  nan ],
	[  6800,  57.45,   1.61,  68.22,   1.36,  21.87,   4.23,  21.25,   4.35,  7.36e-16,  6.69e-16,  6.69e-16,  nan ],
	[  6900,  58.21,   1.64,  67.83,   1.40,  22.01,   4.33,  20.25,   4.70,  7.25e-16,  7.25e-16,  7.25e-16,  nan ],
	[  7000,  58.20,   1.68,  68.21,   1.44,  22.44,   4.37,  21.41,   4.58,  8.45e-16,  8.45e-16,  8.45e-16,  nan ],
	[  7100,  58.49,   1.72,  68.23,   1.48,  22.44,   4.49,  21.09,   4.78,  7.69e-16,  8.97e-16,  7.05e-16,  nan ],
	[  7200,  59.52,   1.74,  68.76,   1.51,  20.38,   5.09,  20.66,   5.02,  7.58e-16,  9.47e-16,  8.21e-16,  nan ],
	[  7300,  60.02,   1.78,  68.72,   1.55,  20.47,   5.21,  20.72,   5.14,  8.72e-16,  9.34e-16,  8.10e-16,  nan ],
	[  7400,  60.25,   1.82,  68.77,   1.59,  20.45,   5.36,  20.70,   5.29,  7.37e-16,  8.60e-16,  7.37e-16,  nan ],
	[  7500,  59.98,   1.88,  68.82,   1.63,  21.24,   5.30,  20.76,   5.42,  8.49e-16,  8.49e-16,  6.67e-16,  nan ],
	[  7600,  60.55,   1.91,  69.22,   1.67,  21.46,   5.38,  20.60,   5.61,  8.38e-16,  7.78e-16,  7.18e-16,  nan ],
	[  7700,  60.63,   1.96,  69.03,   1.72,  21.77,   5.45,  20.78,   5.71,  9.45e-16,  7.68e-16,  8.27e-16,  nan ],
	[  7800,  60.51,   2.01,  69.07,   1.76,  22.07,   5.52,  21.24,   5.73,  8.16e-16,  7.58e-16,  7.00e-16,  nan ],
	[  7900,  60.05,   2.08,  69.20,   1.80,  22.34,   5.59,  20.49,   6.09,  8.63e-16,  8.63e-16,  6.91e-16,  nan ],
	[  8000,  60.24,   2.13,  69.24,   1.85,  22.57,   5.67,  20.79,   6.16,  8.53e-16,  8.53e-16,  7.39e-16,  nan ],
	[  8100,  60.84,   2.16,  70.14,   1.87,  22.74,   5.77,  21.07,   6.23,  7.86e-16,  7.86e-16,  7.30e-16,  nan ],
	[  8200,  61.03,   2.20,  71.43,   1.88,  20.52,   6.55,  21.05,   6.39,  7.21e-16,  9.43e-16,  7.76e-16,  nan ],
	[  8300,  61.32,   2.25,  70.92,   1.94,  20.97,   6.57,  21.31,   6.47,  9.31e-16,  8.22e-16,  7.12e-16,  nan ],
	[  8400,  60.34,   2.34,  71.89,   1.96,  21.20,   6.66,  21.24,   6.64,  8.12e-16,  7.58e-16,  6.50e-16,  nan ],
	[  8500,  61.84,   2.34,  71.47,   2.02,  21.39,   6.76,  20.83,   6.94,  8.02e-16,  8.56e-16,  6.95e-16,  nan ],
	[  8600,  60.62,   2.44,  71.53,   2.07,  21.69,   6.82,  21.16,   6.99,  9.52e-16,  1.22e-15,  1.00e-15,  nan ],
	[  8700,  61.19,   2.47,  72.13,   2.10,  21.39,   7.08,  20.93,   7.24,  8.89e-16,  7.84e-16,  6.27e-16,  nan ],
	[  8800,  60.44,   2.56,  71.85,   2.16,  22.05,   7.03,  20.99,   7.38,  9.30e-16,  7.75e-16,  9.82e-16,  nan ],
	[  8900,  60.75,   2.61,  71.62,   2.21,  22.04,   7.19,  21.57,   7.35,  1.02e-15,  9.20e-16,  7.66e-16,  nan ],
	[  9000,  61.25,   2.65,  72.27,   2.24,  22.45,   7.22,  21.06,   7.69,  8.59e-16,  8.08e-16,  8.08e-16,  nan ],
	[ 10000,  62.64,   3.19,  72.87,   2.74,  22.49,   8.90,  21.31,   9.39,  1.14e-15,  9.09e-16,  8.64e-16,  nan ],
	[ 12000,  63.75,   4.52,  72.74,   3.96,  22.11,  13.02,  22.08,  13.04,  1.14e-15,  9.09e-16,  9.09e-16,  nan ],
	[ 14000,  66.44,   5.90,  74.27,   5.28,  21.88,  17.92,  22.28,  17.60,  1.30e-15,  1.10e-15,  1.17e-15,  nan ],
	[ 16000,  67.66,   7.57,  73.71,   6.95,  22.52,  22.74,  21.19,  24.17,  1.14e-15,  1.08e-15,  1.02e-15,  nan ],
	[ 18000,  67.42,   9.61,  75.57,   8.57,  22.27,  29.09,  23.38,  27.71,  1.26e-15,  1.52e-15,  1.16e-15,  nan ],
	[ 20000,  68.20,  11.73,  74.19,  10.78,  21.28,  37.60,  24.34,  32.87,  1.50e-15,  1.27e-15,  1.27e-15,  nan ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/log.txt
# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/setup.txt
# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/sgeev.txt
# numactl --interleave=all ./testing_sgeev -RN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
sgeev_RN = array([
	[    10,  nan,    0.00 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.00 ],
	[    60,  nan,    0.00 ],
	[    70,  nan,    0.00 ],
	[    80,  nan,    0.01 ],
	[    90,  nan,    0.01 ],
	[   100,  nan,    0.01 ],
	[   200,  nan,    0.04 ],
	[   300,  nan,    0.07 ],
	[   400,  nan,    0.10 ],
	[   500,  nan,    0.13 ],
	[   600,  nan,    0.27 ],
	[   700,  nan,    0.32 ],
	[   800,  nan,    0.40 ],
	[   900,  nan,    0.50 ],
	[  1000,  nan,    0.57 ],
	[  2000,  nan,    1.67 ],
	[  3000,  nan,    5.13 ],
	[  4000,  nan,    7.70 ],
	[  5000,  nan,   11.80 ],
	[  6000,  nan,   22.48 ],
	[  7000,  nan,   28.24 ],
	[  8000,  nan,   38.10 ],
	[  9000,  nan,   46.18 ],
	[ 10000,  nan,   53.97 ],
	[ 12000,  nan,   76.20 ],
	[ 14000,  nan,  104.01 ],
	[ 16000,  nan,  141.66 ],
	[ 18000,  nan,  175.12 ],
	[ 20000,  nan,  227.11 ],
])

# numactl --interleave=all ./testing_sgeev -RV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
sgeev_RV = array([
	[    10,  nan,    0.00 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.01 ],
	[    50,  nan,    0.01 ],
	[    60,  nan,    0.01 ],
	[    70,  nan,    0.01 ],
	[    80,  nan,    0.01 ],
	[    90,  nan,    0.01 ],
	[   100,  nan,    0.01 ],
	[   200,  nan,    0.05 ],
	[   300,  nan,    0.09 ],
	[   400,  nan,    0.13 ],
	[   500,  nan,    0.22 ],
	[   600,  nan,    0.27 ],
	[   700,  nan,    0.38 ],
	[   800,  nan,    0.46 ],
	[   900,  nan,    0.62 ],
	[  1000,  nan,    0.72 ],
	[  2000,  nan,    2.13 ],
	[  3000,  nan,    6.30 ],
	[  4000,  nan,    9.90 ],
	[  5000,  nan,   15.47 ],
	[  6000,  nan,   28.43 ],
	[  7000,  nan,   36.67 ],
	[  8000,  nan,   49.95 ],
	[  9000,  nan,   60.88 ],
	[ 10000,  nan,   77.42 ],
	[ 12000,  nan,  109.19 ],
	[ 14000,  nan,  157.43 ],
	[ 16000,  nan,  208.72 ],
	[ 18000,  nan,  282.98 ],
	[ 20000,  nan,  356.12 ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/sgeqrf.txt
# numactl --interleave=all ./testing_sgeqrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
sgeqrf = array([
	[    10,     10,  nan,  nan,     0.01,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.04,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.11,  0.00,  nan ],
	[    40,     40,  nan,  nan,     1.32,  0.00,  nan ],
	[    50,     50,  nan,  nan,     1.72,  0.00,  nan ],
	[    60,     60,  nan,  nan,     2.48,  0.00,  nan ],
	[    70,     70,  nan,  nan,     2.75,  0.00,  nan ],
	[    80,     80,  nan,  nan,     1.46,  0.00,  nan ],
	[    90,     90,  nan,  nan,     1.83,  0.00,  nan ],
	[   100,    100,  nan,  nan,     1.18,  0.00,  nan ],
	[   200,    200,  nan,  nan,     3.94,  0.00,  nan ],
	[   300,    300,  nan,  nan,     9.71,  0.00,  nan ],
	[   400,    400,  nan,  nan,    16.82,  0.01,  nan ],
	[   500,    500,  nan,  nan,    24.98,  0.01,  nan ],
	[   600,    600,  nan,  nan,    36.01,  0.01,  nan ],
	[   700,    700,  nan,  nan,    44.60,  0.01,  nan ],
	[   800,    800,  nan,  nan,    58.72,  0.01,  nan ],
	[   900,    900,  nan,  nan,    69.96,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,    80.92,  0.02,  nan ],
	[  2000,   2000,  nan,  nan,   254.06,  0.04,  nan ],
	[  3000,   3000,  nan,  nan,   459.42,  0.08,  nan ],
	[  4000,   4000,  nan,  nan,   642.42,  0.13,  nan ],
	[  5000,   5000,  nan,  nan,   840.02,  0.20,  nan ],
	[  6000,   6000,  nan,  nan,   975.75,  0.30,  nan ],
	[  7000,   7000,  nan,  nan,  1049.40,  0.44,  nan ],
	[  8000,   8000,  nan,  nan,  1096.80,  0.62,  nan ],
	[  9000,   9000,  nan,  nan,  1178.64,  0.82,  nan ],
	[ 10000,  10000,  nan,  nan,  1330.88,  1.00,  nan ],
	[ 12000,  12000,  nan,  nan,  1579.32,  1.46,  nan ],
	[ 14000,  14000,  nan,  nan,  1648.08,  2.22,  nan ],
	[ 16000,  16000,  nan,  nan,  1836.83,  2.97,  nan ],
	[ 18000,  18000,  nan,  nan,  1874.69,  4.15,  nan ],
	[ 20000,  20000,  nan,  nan,  2000.40,  5.33,  nan ],
])

# numactl --interleave=all ./testing_sgeqrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
sgeqrf_gpu = array([
	[    10,     10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.01,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.04,  0.00,  nan ],
	[    40,     40,  nan,  nan,     0.10,  0.00,  nan ],
	[    50,     50,  nan,  nan,     0.18,  0.00,  nan ],
	[    60,     60,  nan,  nan,     0.26,  0.00,  nan ],
	[    70,     70,  nan,  nan,     0.39,  0.00,  nan ],
	[    80,     80,  nan,  nan,     0.58,  0.00,  nan ],
	[    90,     90,  nan,  nan,     0.77,  0.00,  nan ],
	[   100,    100,  nan,  nan,     0.74,  0.00,  nan ],
	[   200,    200,  nan,  nan,     4.16,  0.00,  nan ],
	[   300,    300,  nan,  nan,     9.37,  0.00,  nan ],
	[   400,    400,  nan,  nan,    15.92,  0.01,  nan ],
	[   500,    500,  nan,  nan,    21.00,  0.01,  nan ],
	[   600,    600,  nan,  nan,    28.25,  0.01,  nan ],
	[   700,    700,  nan,  nan,    38.42,  0.01,  nan ],
	[   800,    800,  nan,  nan,    51.51,  0.01,  nan ],
	[   900,    900,  nan,  nan,    61.32,  0.02,  nan ],
	[  1000,   1000,  nan,  nan,    77.78,  0.02,  nan ],
	[  2000,   2000,  nan,  nan,   234.69,  0.05,  nan ],
	[  3000,   3000,  nan,  nan,   426.35,  0.08,  nan ],
	[  4000,   4000,  nan,  nan,   610.00,  0.14,  nan ],
	[  5000,   5000,  nan,  nan,   764.07,  0.22,  nan ],
	[  6000,   6000,  nan,  nan,   903.23,  0.32,  nan ],
	[  7000,   7000,  nan,  nan,  1024.07,  0.45,  nan ],
	[  8000,   8000,  nan,  nan,  1015.64,  0.67,  nan ],
	[  9000,   9000,  nan,  nan,  1156.30,  0.84,  nan ],
	[ 10000,  10000,  nan,  nan,  1307.39,  1.02,  nan ],
	[ 12000,  12000,  nan,  nan,  1517.86,  1.52,  nan ],
	[ 14000,  14000,  nan,  nan,  1611.28,  2.27,  nan ],
	[ 16000,  16000,  nan,  nan,  1775.17,  3.08,  nan ],
	[ 18000,  18000,  nan,  nan,  1838.88,  4.23,  nan ],
	[ 20000,  20000,  nan,  nan,  1971.05,  5.41,  nan ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/sgetrf.txt
# numactl --interleave=all ./testing_sgetrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
sgetrf = array([
	[    10,     10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.00,  0.03,  nan ],
	[    30,     30,  nan,  nan,     0.48,  0.00,  nan ],
	[    40,     40,  nan,  nan,     0.79,  0.00,  nan ],
	[    50,     50,  nan,  nan,     1.68,  0.00,  nan ],
	[    60,     60,  nan,  nan,     2.58,  0.00,  nan ],
	[    70,     70,  nan,  nan,     0.32,  0.00,  nan ],
	[    80,     80,  nan,  nan,     0.37,  0.00,  nan ],
	[    90,     90,  nan,  nan,     0.77,  0.00,  nan ],
	[   100,    100,  nan,  nan,     0.66,  0.00,  nan ],
	[   200,    200,  nan,  nan,     7.18,  0.00,  nan ],
	[   300,    300,  nan,  nan,     3.37,  0.01,  nan ],
	[   400,    400,  nan,  nan,     6.23,  0.01,  nan ],
	[   500,    500,  nan,  nan,    11.65,  0.01,  nan ],
	[   600,    600,  nan,  nan,     9.18,  0.02,  nan ],
	[   700,    700,  nan,  nan,    14.91,  0.02,  nan ],
	[   800,    800,  nan,  nan,    21.16,  0.02,  nan ],
	[   900,    900,  nan,  nan,    20.55,  0.02,  nan ],
	[  1000,   1000,  nan,  nan,    32.34,  0.02,  nan ],
	[  2000,   2000,  nan,  nan,    91.28,  0.06,  nan ],
	[  3000,   3000,  nan,  nan,   182.74,  0.10,  nan ],
	[  4000,   4000,  nan,  nan,   327.78,  0.13,  nan ],
	[  5000,   5000,  nan,  nan,   312.03,  0.27,  nan ],
	[  6000,   6000,  nan,  nan,   419.37,  0.34,  nan ],
	[  7000,   7000,  nan,  nan,   550.91,  0.42,  nan ],
	[  8000,   8000,  nan,  nan,   662.21,  0.52,  nan ],
	[  9000,   9000,  nan,  nan,   779.23,  0.62,  nan ],
	[ 10000,  10000,  nan,  nan,   918.79,  0.73,  nan ],
	[ 12000,  12000,  nan,  nan,  1094.32,  1.05,  nan ],
	[ 14000,  14000,  nan,  nan,  1312.91,  1.39,  nan ],
	[ 16000,  16000,  nan,  nan,  1451.99,  1.88,  nan ],
	[ 18000,  18000,  nan,  nan,  1603.99,  2.42,  nan ],
	[ 20000,  20000,  nan,  nan,  1780.21,  3.00,  nan ],
])

# numactl --interleave=all ./testing_sgetrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
sgetrf_gpu = array([
	[    10,     10,  nan,  nan,     0.01,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.04,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.24,  0.00,  nan ],
	[    40,     40,  nan,  nan,     0.45,  0.00,  nan ],
	[    50,     50,  nan,  nan,     0.83,  0.00,  nan ],
	[    60,     60,  nan,  nan,     1.24,  0.00,  nan ],
	[    70,     70,  nan,  nan,     0.71,  0.00,  nan ],
	[    80,     80,  nan,  nan,     1.29,  0.00,  nan ],
	[    90,     90,  nan,  nan,     1.39,  0.00,  nan ],
	[   100,    100,  nan,  nan,     2.34,  0.00,  nan ],
	[   200,    200,  nan,  nan,     1.19,  0.00,  nan ],
	[   300,    300,  nan,  nan,     2.29,  0.01,  nan ],
	[   400,    400,  nan,  nan,     4.77,  0.01,  nan ],
	[   500,    500,  nan,  nan,     7.56,  0.01,  nan ],
	[   600,    600,  nan,  nan,     8.09,  0.02,  nan ],
	[   700,    700,  nan,  nan,    15.40,  0.01,  nan ],
	[   800,    800,  nan,  nan,    22.63,  0.02,  nan ],
	[   900,    900,  nan,  nan,    24.18,  0.02,  nan ],
	[  1000,   1000,  nan,  nan,    23.55,  0.03,  nan ],
	[  2000,   2000,  nan,  nan,   104.50,  0.05,  nan ],
	[  3000,   3000,  nan,  nan,   190.84,  0.09,  nan ],
	[  4000,   4000,  nan,  nan,   315.29,  0.14,  nan ],
	[  5000,   5000,  nan,  nan,   283.66,  0.29,  nan ],
	[  6000,   6000,  nan,  nan,   359.76,  0.40,  nan ],
	[  7000,   7000,  nan,  nan,   480.49,  0.48,  nan ],
	[  8000,   8000,  nan,  nan,   659.01,  0.52,  nan ],
	[  9000,   9000,  nan,  nan,   822.41,  0.59,  nan ],
	[ 10000,  10000,  nan,  nan,   909.64,  0.73,  nan ],
	[ 12000,  12000,  nan,  nan,  1208.28,  0.95,  nan ],
	[ 14000,  14000,  nan,  nan,  1361.20,  1.34,  nan ],
	[ 16000,  16000,  nan,  nan,  1482.36,  1.84,  nan ],
	[ 18000,  18000,  nan,  nan,  1657.14,  2.35,  nan ],
	[ 20000,  20000,  nan,  nan,  1836.71,  2.90,  nan ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/spotrf.txt
# numactl --interleave=all ./testing_spotrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
spotrf = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.01,  0.00,  nan ],
	[    30,  nan,  nan,     0.03,  0.00,  nan ],
	[    40,  nan,  nan,     0.07,  0.00,  nan ],
	[    50,  nan,  nan,     0.14,  0.00,  nan ],
	[    60,  nan,  nan,     0.24,  0.00,  nan ],
	[    70,  nan,  nan,     1.70,  0.00,  nan ],
	[    80,  nan,  nan,     2.23,  0.00,  nan ],
	[    90,  nan,  nan,     2.71,  0.00,  nan ],
	[   100,  nan,  nan,     3.23,  0.00,  nan ],
	[   200,  nan,  nan,     4.63,  0.00,  nan ],
	[   300,  nan,  nan,     5.58,  0.00,  nan ],
	[   400,  nan,  nan,    12.58,  0.00,  nan ],
	[   500,  nan,  nan,    22.05,  0.00,  nan ],
	[   600,  nan,  nan,    23.18,  0.00,  nan ],
	[   700,  nan,  nan,    34.87,  0.00,  nan ],
	[   800,  nan,  nan,    37.36,  0.00,  nan ],
	[   900,  nan,  nan,    50.85,  0.00,  nan ],
	[  1000,  nan,  nan,    66.51,  0.01,  nan ],
	[  2000,  nan,  nan,   266.57,  0.01,  nan ],
	[  3000,  nan,  nan,   497.85,  0.02,  nan ],
	[  4000,  nan,  nan,   798.97,  0.03,  nan ],
	[  5000,  nan,  nan,  1020.80,  0.04,  nan ],
	[  6000,  nan,  nan,  1207.32,  0.06,  nan ],
	[  7000,  nan,  nan,  1352.62,  0.08,  nan ],
	[  8000,  nan,  nan,  1464.16,  0.12,  nan ],
	[  9000,  nan,  nan,  1537.12,  0.16,  nan ],
	[ 10000,  nan,  nan,  1550.92,  0.21,  nan ],
	[ 12000,  nan,  nan,  1785.69,  0.32,  nan ],
	[ 14000,  nan,  nan,  1841.99,  0.50,  nan ],
	[ 16000,  nan,  nan,  2086.90,  0.65,  nan ],
	[ 18000,  nan,  nan,  2178.93,  0.89,  nan ],
	[ 20000,  nan,  nan,  2266.23,  1.18,  nan ],
])

# numactl --interleave=all ./testing_spotrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
spotrf_gpu = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.00,  0.00,  nan ],
	[    30,  nan,  nan,     0.01,  0.00,  nan ],
	[    40,  nan,  nan,     0.03,  0.00,  nan ],
	[    50,  nan,  nan,     0.05,  0.00,  nan ],
	[    60,  nan,  nan,     0.08,  0.00,  nan ],
	[    70,  nan,  nan,     0.13,  0.00,  nan ],
	[    80,  nan,  nan,     0.19,  0.00,  nan ],
	[    90,  nan,  nan,     0.26,  0.00,  nan ],
	[   100,  nan,  nan,     0.36,  0.00,  nan ],
	[   200,  nan,  nan,     8.48,  0.00,  nan ],
	[   300,  nan,  nan,     4.82,  0.00,  nan ],
	[   400,  nan,  nan,    10.44,  0.00,  nan ],
	[   500,  nan,  nan,    18.53,  0.00,  nan ],
	[   600,  nan,  nan,    22.19,  0.00,  nan ],
	[   700,  nan,  nan,    33.41,  0.00,  nan ],
	[   800,  nan,  nan,    38.75,  0.00,  nan ],
	[   900,  nan,  nan,    51.15,  0.00,  nan ],
	[  1000,  nan,  nan,    66.93,  0.00,  nan ],
	[  2000,  nan,  nan,   309.27,  0.01,  nan ],
	[  3000,  nan,  nan,   600.71,  0.01,  nan ],
	[  4000,  nan,  nan,   920.53,  0.02,  nan ],
	[  5000,  nan,  nan,  1176.91,  0.04,  nan ],
	[  6000,  nan,  nan,  1412.73,  0.05,  nan ],
	[  7000,  nan,  nan,  1580.69,  0.07,  nan ],
	[  8000,  nan,  nan,  1764.73,  0.10,  nan ],
	[  9000,  nan,  nan,  1869.67,  0.13,  nan ],
	[ 10000,  nan,  nan,  1962.66,  0.17,  nan ],
	[ 12000,  nan,  nan,  2125.37,  0.27,  nan ],
	[ 14000,  nan,  nan,  2257.65,  0.41,  nan ],
	[ 16000,  nan,  nan,  2353.06,  0.58,  nan ],
	[ 18000,  nan,  nan,  2412.05,  0.81,  nan ],
	[ 20000,  nan,  nan,  2486.48,  1.07,  nan ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/ssyevd.txt
# numactl --interleave=all ./testing_ssyevd -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
ssyevd_JN = array([
	[    10,  nan,    0.01 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.00 ],
	[    60,  nan,    0.00 ],
	[    70,  nan,    0.00 ],
	[    80,  nan,    0.00 ],
	[    90,  nan,    0.00 ],
	[   100,  nan,    0.00 ],
	[   200,  nan,    0.00 ],
	[   300,  nan,    0.01 ],
	[   400,  nan,    0.01 ],
	[   500,  nan,    0.02 ],
	[   600,  nan,    0.02 ],
	[   700,  nan,    0.03 ],
	[   800,  nan,    0.04 ],
	[   900,  nan,    0.05 ],
	[  1000,  nan,    0.06 ],
	[  2000,  nan,    0.22 ],
	[  3000,  nan,    1.15 ],
	[  4000,  nan,    2.11 ],
	[  5000,  nan,    4.19 ],
	[  6000,  nan,    6.76 ],
	[  7000,  nan,   10.23 ],
	[  8000,  nan,   14.28 ],
	[  9000,  nan,   19.76 ],
	[ 10000,  nan,   25.78 ],
	[ 12000,  nan,   42.17 ],
	[ 14000,  nan,   63.48 ],
	[ 16000,  nan,   91.47 ],
	[ 18000,  nan,  126.96 ],
	[ 20000,  nan,  169.03 ],
])

# numactl --interleave=all ./testing_ssyevd -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
ssyevd_JV = array([
	[    10,  nan,    0.00 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.00 ],
	[    60,  nan,    0.00 ],
	[    70,  nan,    0.00 ],
	[    80,  nan,    0.00 ],
	[    90,  nan,    0.00 ],
	[   100,  nan,    0.00 ],
	[   200,  nan,    0.01 ],
	[   300,  nan,    0.01 ],
	[   400,  nan,    0.02 ],
	[   500,  nan,    0.03 ],
	[   600,  nan,    0.03 ],
	[   700,  nan,    0.04 ],
	[   800,  nan,    0.05 ],
	[   900,  nan,    0.07 ],
	[  1000,  nan,    0.08 ],
	[  2000,  nan,    0.25 ],
	[  3000,  nan,    1.20 ],
	[  4000,  nan,    2.24 ],
	[  5000,  nan,    4.34 ],
	[  6000,  nan,    7.09 ],
	[  7000,  nan,   10.61 ],
	[  8000,  nan,   14.51 ],
	[  9000,  nan,   20.19 ],
	[ 10000,  nan,   26.49 ],
	[ 12000,  nan,   43.38 ],
	[ 14000,  nan,   65.35 ],
	[ 16000,  nan,   94.15 ],
	[ 18000,  nan,  130.38 ],
	[ 20000,  nan,  173.70 ],
])

# numactl --interleave=all ./testing_ssyevd_gpu -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
ssyevd_gpu_JN = array([
	[    10,  nan,    0.00 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.00 ],
	[    60,  nan,    0.00 ],
	[    70,  nan,    0.00 ],
	[    80,  nan,    0.00 ],
	[    90,  nan,    0.00 ],
	[   100,  nan,    0.00 ],
	[   200,  nan,    0.00 ],
	[   300,  nan,    0.01 ],
	[   400,  nan,    0.01 ],
	[   500,  nan,    0.02 ],
	[   600,  nan,    0.03 ],
	[   700,  nan,    0.03 ],
	[   800,  nan,    0.04 ],
	[   900,  nan,    0.05 ],
	[  1000,  nan,    0.07 ],
	[  2000,  nan,    0.27 ],
	[  3000,  nan,    1.11 ],
	[  4000,  nan,    2.11 ],
	[  5000,  nan,    4.18 ],
	[  6000,  nan,    6.74 ],
	[  7000,  nan,   10.19 ],
	[  8000,  nan,   14.26 ],
	[  9000,  nan,   19.59 ],
	[ 10000,  nan,   25.79 ],
	[ 12000,  nan,   42.22 ],
	[ 14000,  nan,   63.46 ],
	[ 16000,  nan,   91.34 ],
	[ 18000,  nan,  127.23 ],
	[ 20000,  nan,  168.77 ],
])

# numactl --interleave=all ./testing_ssyevd_gpu -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
ssyevd_gpu_JV = array([
	[    10,  nan,    0.00 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.00 ],
	[    60,  nan,    0.00 ],
	[    70,  nan,    0.00 ],
	[    80,  nan,    0.00 ],
	[    90,  nan,    0.00 ],
	[   100,  nan,    0.00 ],
	[   200,  nan,    0.01 ],
	[   300,  nan,    0.01 ],
	[   400,  nan,    0.02 ],
	[   500,  nan,    0.03 ],
	[   600,  nan,    0.03 ],
	[   700,  nan,    0.04 ],
	[   800,  nan,    0.05 ],
	[   900,  nan,    0.07 ],
	[  1000,  nan,    0.08 ],
	[  2000,  nan,    0.25 ],
	[  3000,  nan,    1.18 ],
	[  4000,  nan,    2.23 ],
	[  5000,  nan,    4.38 ],
	[  6000,  nan,    7.09 ],
	[  7000,  nan,   10.66 ],
	[  8000,  nan,   14.98 ],
	[  9000,  nan,   20.68 ],
	[ 10000,  nan,   27.27 ],
	[ 12000,  nan,   44.73 ],
	[ 14000,  nan,   67.47 ],
	[ 16000,  nan,   97.36 ],
	[ 18000,  nan,  136.12 ],
	[ 20000,  nan,  181.41 ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/ssyevd_2stage.txt
# numactl --interleave=all ./testing_ssyevdx_2stage -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
ssyevdx_2stage_JN = array([
	[    60,      0,   0.00 ],
	[    70,     70,   0.00 ],
	[    80,     80,   0.00 ],
	[    90,     90,   0.00 ],
	[   100,    100,   0.00 ],
	[   200,    200,   0.00 ],
	[   300,    300,   0.01 ],
	[   400,    400,   0.02 ],
	[   500,    500,   0.04 ],
	[   600,    600,   0.05 ],
	[   700,    700,   0.06 ],
	[   800,    800,   0.07 ],
	[   900,    900,   0.09 ],
	[  1000,   1000,   0.10 ],
	[  2000,   2000,   0.28 ],
	[  3000,   3000,   0.55 ],
	[  4000,   4000,   0.90 ],
	[  5000,   5000,   1.27 ],
	[  6000,   6000,   1.76 ],
	[  7000,   7000,   2.32 ],
	[  8000,   8000,   2.94 ],
	[  9000,   9000,   3.69 ],
	[ 10000,  10000,   4.58 ],
	[ 12000,  12000,   6.53 ],
	[ 14000,  14000,   9.17 ],
	[ 16000,  16000,  12.18 ],
	[ 18000,  18000,  16.07 ],
	[ 20000,  20000,  20.25 ],
])

# numactl --interleave=all ./testing_ssyevdx_2stage -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
ssyevdx_2stage_JV = array([
	[    10,     10,   0.00 ],
	[    20,     20,   0.00 ],
	[    30,     30,   0.00 ],
	[    40,     40,   0.00 ],
	[    50,     50,   0.00 ],
	[    60,     60,   0.00 ],
	[    70,     70,   0.00 ],
	[    80,     80,   0.00 ],
	[    90,     90,   0.00 ],
	[   100,    100,   0.00 ],
	[   200,    200,   0.00 ],
	[   300,    300,   0.02 ],
	[   400,    400,   0.03 ],
	[   500,    500,   0.05 ],
	[   600,    600,   0.07 ],
	[   700,    700,   0.08 ],
	[   800,    800,   0.10 ],
	[   900,    900,   0.12 ],
	[  1000,   1000,   0.14 ],
	[  2000,   2000,   0.37 ],
	[  3000,   3000,   0.72 ],
	[  4000,   4000,   1.21 ],
	[  5000,   5000,   1.82 ],
	[  6000,   6000,   2.78 ],
	[  7000,   7000,   3.90 ],
	[  8000,   8000,   5.21 ],
	[  9000,   9000,   6.83 ],
	[ 10000,  10000,   8.68 ],
	[ 12000,  12000,  13.92 ],
	[ 14000,  14000,  21.00 ],
	[ 16000,  16000,  30.13 ],
	[ 18000,  18000,  40.83 ],
	[ 20000,  20000,  54.02 ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/ssymv.txt
# numactl --interleave=all ./testing_ssymv -N 100 -N 1000 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000
ssymv_L = array([
	[    10,    0.01,  0.03,    0.01,  0.03,   0.01,   0.03,   0.10,   0.00,  4.77e-08,  4.77e-08,  4.77e-08,  nan ],
	[    11,    0.01,  0.03,    0.01,  0.03,   0.01,   0.02,   0.14,   0.00,  4.33e-08,  4.33e-08,  4.33e-08,  nan ],
	[    12,    0.01,  0.03,    0.01,  0.03,   0.01,   0.02,   0.15,   0.00,  3.97e-08,  1.99e-08,  1.99e-08,  nan ],
	[    13,    0.01,  0.03,    0.01,  0.03,   0.02,   0.02,   0.17,   0.00,  7.34e-08,  7.34e-08,  7.34e-08,  nan ],
	[    14,    0.02,  0.03,    0.02,  0.03,   0.02,   0.02,   0.22,   0.00,  6.81e-08,  6.81e-08,  6.81e-08,  nan ],
	[    15,    0.02,  0.03,    0.02,  0.03,   0.03,   0.02,   0.25,   0.00,  3.18e-08,  4.77e-08,  6.36e-08,  nan ],
	[    16,    0.02,  0.03,    0.02,  0.03,   0.03,   0.02,   0.29,   0.00,  5.96e-08,  5.96e-08,  5.96e-08,  nan ],
	[    17,    0.02,  0.03,    0.02,  0.03,   0.03,   0.02,   0.32,   0.00,  5.61e-08,  2.80e-08,  5.61e-08,  nan ],
	[    18,    0.03,  0.03,    0.03,  0.03,   0.03,   0.02,   0.24,   0.00,  7.95e-08,  2.65e-08,  5.30e-08,  nan ],
	[    19,    0.03,  0.03,    0.03,  0.03,   0.03,   0.02,   0.40,   0.00,  5.02e-08,  5.02e-08,  5.02e-08,  nan ],
	[    20,    0.03,  0.03,    0.03,  0.03,   0.04,   0.02,   0.29,   0.00,  4.77e-08,  4.77e-08,  4.77e-08,  nan ],
	[    21,    0.03,  0.03,    0.03,  0.03,   0.04,   0.02,   0.48,   0.00,  9.08e-08,  6.81e-08,  4.54e-08,  nan ],
	[    22,    0.04,  0.03,    0.04,  0.03,   0.05,   0.02,   0.35,   0.00,  6.50e-08,  4.33e-08,  6.50e-08,  nan ],
	[    23,    0.04,  0.03,    0.04,  0.03,   0.05,   0.02,   0.39,   0.00,  4.15e-08,  8.29e-08,  4.15e-08,  nan ],
	[    24,    0.04,  0.03,    0.04,  0.03,   0.06,   0.02,   0.56,   0.00,  7.95e-08,  3.97e-08,  3.97e-08,  nan ],
	[    25,    0.05,  0.03,    0.05,  0.03,   0.06,   0.02,   0.45,   0.00,  7.63e-08,  7.63e-08,  5.72e-08,  nan ],
	[    26,    0.05,  0.03,    0.04,  0.03,   0.06,   0.02,   0.45,   0.00,  7.34e-08,  7.34e-08,  7.34e-08,  nan ],
	[    27,    0.05,  0.03,    0.05,  0.03,   0.07,   0.02,   0.49,   0.00,  7.06e-08,  7.06e-08,  7.06e-08,  nan ],
	[    28,    0.06,  0.03,    0.06,  0.03,   0.07,   0.02,   0.52,   0.00,  6.81e-08,  6.81e-08,  1.02e-07,  nan ],
	[    29,    0.06,  0.03,    0.06,  0.03,   0.08,   0.02,   0.43,   0.00,  6.58e-08,  6.58e-08,  9.87e-08,  nan ],
	[    30,    0.07,  0.03,    0.06,  0.03,   0.08,   0.02,   0.60,   0.00,  9.54e-08,  9.54e-08,  1.27e-07,  nan ],
	[    31,    0.07,  0.03,    0.07,  0.03,   0.09,   0.02,   0.64,   0.00,  9.23e-08,  6.15e-08,  9.23e-08,  nan ],
	[    32,    0.08,  0.03,    0.07,  0.03,   0.10,   0.02,   0.68,   0.00,  5.96e-08,  5.96e-08,  5.96e-08,  nan ],
	[    33,    0.08,  0.03,    0.07,  0.03,   0.10,   0.02,   0.72,   0.00,  8.67e-08,  1.16e-07,  5.78e-08,  nan ],
	[    34,    0.09,  0.03,    0.08,  0.03,   0.10,   0.02,   0.62,   0.00,  5.61e-08,  8.41e-08,  5.61e-08,  nan ],
	[    35,    0.09,  0.03,    0.08,  0.03,   0.10,   0.02,   0.62,   0.00,  5.45e-08,  5.45e-08,  5.45e-08,  nan ],
	[    36,    0.09,  0.03,    0.09,  0.03,   0.11,   0.02,   0.86,   0.00,  7.95e-08,  5.30e-08,  5.30e-08,  nan ],
	[    37,    0.10,  0.03,    0.09,  0.03,   0.12,   0.02,   0.98,   0.00,  1.03e-07,  1.03e-07,  1.03e-07,  nan ],
	[    38,    0.11,  0.03,    0.10,  0.03,   0.12,   0.02,   0.73,   0.00,  7.53e-08,  5.02e-08,  7.53e-08,  nan ],
	[    39,    0.12,  0.03,    0.11,  0.03,   0.14,   0.02,   1.01,   0.00,  4.89e-08,  4.89e-08,  4.89e-08,  nan ],
	[    40,    0.12,  0.03,    0.12,  0.03,   0.14,   0.02,   1.06,   0.00,  7.15e-08,  9.54e-08,  7.15e-08,  nan ],
	[    41,    0.13,  0.03,    0.12,  0.03,   0.16,   0.02,   0.85,   0.00,  6.98e-08,  6.98e-08,  6.98e-08,  nan ],
	[    42,    0.13,  0.03,    0.13,  0.03,   0.13,   0.03,   1.26,   0.00,  9.08e-08,  9.08e-08,  9.08e-08,  nan ],
	[    43,    0.14,  0.03,    0.13,  0.03,   0.16,   0.02,   0.93,   0.00,  8.87e-08,  8.87e-08,  8.87e-08,  nan ],
	[    44,    0.14,  0.03,    0.14,  0.03,   0.17,   0.02,   0.98,   0.00,  8.67e-08,  8.67e-08,  8.67e-08,  nan ],
	[    45,    0.15,  0.03,    0.15,  0.03,   0.19,   0.02,   1.09,   0.00,  8.48e-08,  8.48e-08,  8.48e-08,  nan ],
	[    46,    0.15,  0.03,    0.15,  0.03,   0.18,   0.02,   1.07,   0.00,  8.29e-08,  1.24e-07,  8.29e-08,  nan ],
	[    47,    0.13,  0.03,    0.15,  0.03,   0.19,   0.02,   0.90,   0.01,  8.12e-08,  8.12e-08,  8.12e-08,  nan ],
	[    48,    0.17,  0.03,    0.16,  0.03,   0.20,   0.02,   1.16,   0.00,  7.95e-08,  3.97e-08,  7.95e-08,  nan ],
	[    49,    0.18,  0.03,    0.17,  0.03,   0.20,   0.03,   1.21,   0.00,  7.79e-08,  7.79e-08,  7.79e-08,  nan ],
	[    50,    0.18,  0.03,    0.17,  0.03,   0.20,   0.03,   1.26,   0.00,  3.81e-08,  5.72e-08,  5.72e-08,  nan ],
	[    51,    0.19,  0.03,    0.17,  0.03,   0.21,   0.03,   1.31,   0.00,  7.48e-08,  5.61e-08,  7.48e-08,  nan ],
	[    52,    0.20,  0.03,    0.18,  0.03,   0.22,   0.03,   1.36,   0.00,  1.10e-07,  1.10e-07,  1.10e-07,  nan ],
	[    53,    0.20,  0.03,    0.19,  0.03,   0.23,   0.03,   1.14,   0.01,  9.00e-08,  1.08e-07,  7.20e-08,  nan ],
	[    54,    0.20,  0.03,    0.20,  0.03,   0.24,   0.03,   1.19,   0.01,  1.06e-07,  1.06e-07,  1.06e-07,  nan ],
	[    55,    0.22,  0.03,    0.21,  0.03,   0.25,   0.03,   1.23,   0.01,  6.94e-08,  6.94e-08,  6.94e-08,  nan ],
	[    56,    0.23,  0.03,    0.21,  0.03,   0.26,   0.03,   1.67,   0.00,  6.81e-08,  6.81e-08,  3.41e-08,  nan ],
	[    57,    0.20,  0.03,    0.22,  0.03,   0.25,   0.03,   1.63,   0.00,  6.69e-08,  6.69e-08,  6.69e-08,  nan ],
	[    58,    0.24,  0.03,    0.23,  0.03,   0.26,   0.03,   1.37,   0.01,  9.87e-08,  1.32e-07,  9.87e-08,  nan ],
	[    59,    0.25,  0.03,    0.23,  0.03,   0.27,   0.03,   1.86,   0.00,  9.70e-08,  6.47e-08,  6.47e-08,  nan ],
	[    60,    0.25,  0.03,    0.24,  0.03,   0.28,   0.03,   1.46,   0.01,  1.27e-07,  9.54e-08,  9.54e-08,  nan ],
	[    61,    0.27,  0.03,    0.24,  0.03,   0.28,   0.03,   1.51,   0.01,  1.25e-07,  1.25e-07,  9.38e-08,  nan ],
	[    62,    0.27,  0.03,    0.25,  0.03,   0.30,   0.03,   1.93,   0.00,  9.23e-08,  9.23e-08,  1.23e-07,  nan ],
	[    63,    0.29,  0.03,    0.27,  0.03,   0.30,   0.03,   1.61,   0.01,  9.08e-08,  9.08e-08,  1.51e-07,  nan ],
	[    64,    0.32,  0.03,    0.28,  0.03,   0.33,   0.03,   2.05,   0.00,  8.94e-08,  5.96e-08,  8.94e-08,  nan ],
	[    65,    0.27,  0.03,    0.24,  0.04,   0.32,   0.03,   1.71,   0.01,  5.87e-08,  5.87e-08,  8.80e-08,  nan ],
	[    66,    0.28,  0.03,    0.25,  0.04,   0.33,   0.03,   1.77,   0.01,  8.67e-08,  8.67e-08,  8.67e-08,  nan ],
	[    67,    0.29,  0.03,    0.26,  0.04,   0.34,   0.03,   1.82,   0.01,  1.14e-07,  1.14e-07,  1.14e-07,  nan ],
	[    68,    0.30,  0.03,    0.26,  0.04,   0.35,   0.03,   1.87,   0.01,  1.40e-07,  1.12e-07,  1.40e-07,  nan ],
	[    69,    0.31,  0.03,    0.28,  0.04,   0.36,   0.03,   1.93,   0.01,  8.29e-08,  8.29e-08,  1.11e-07,  nan ],
	[    70,    0.32,  0.03,    0.28,  0.04,   0.37,   0.03,   1.67,   0.01,  1.36e-07,  1.63e-07,  1.63e-07,  nan ],
	[    71,    0.32,  0.03,    0.29,  0.04,   0.38,   0.03,   1.72,   0.01,  8.06e-08,  1.61e-07,  1.07e-07,  nan ],
	[    72,    0.34,  0.03,    0.30,  0.04,   0.39,   0.03,   2.10,   0.01,  1.06e-07,  1.06e-07,  1.32e-07,  nan ],
	[    73,    0.35,  0.03,    0.30,  0.04,   0.40,   0.03,   2.16,   0.01,  1.05e-07,  7.84e-08,  1.05e-07,  nan ],
	[    74,    0.36,  0.03,    0.32,  0.04,   0.41,   0.03,   2.22,   0.01,  1.29e-07,  1.29e-07,  1.29e-07,  nan ],
	[    75,    0.36,  0.03,    0.31,  0.04,   0.42,   0.03,   2.81,   0.00,  1.27e-07,  7.63e-08,  7.63e-08,  nan ],
	[    76,    0.37,  0.03,    0.32,  0.04,   0.42,   0.03,   2.89,   0.00,  1.00e-07,  1.00e-07,  7.53e-08,  nan ],
	[    77,    0.38,  0.03,    0.32,  0.04,   0.43,   0.03,   2.02,   0.01,  9.91e-08,  9.91e-08,  9.91e-08,  nan ],
	[    78,    0.38,  0.03,    0.34,  0.04,   0.44,   0.03,   1.99,   0.01,  7.34e-08,  7.34e-08,  7.34e-08,  nan ],
	[    79,    0.38,  0.03,    0.35,  0.04,   0.45,   0.03,   2.12,   0.01,  9.66e-08,  1.45e-07,  1.21e-07,  nan ],
	[    80,    0.41,  0.03,    0.36,  0.04,   0.46,   0.03,   2.59,   0.01,  9.54e-08,  9.54e-08,  9.54e-08,  nan ],
	[    81,    0.42,  0.03,    0.37,  0.04,   0.47,   0.03,   2.65,   0.01,  9.42e-08,  1.18e-07,  1.18e-07,  nan ],
	[    82,    0.41,  0.03,    0.37,  0.04,   0.47,   0.03,   2.20,   0.01,  1.40e-07,  1.40e-07,  9.30e-08,  nan ],
	[    83,    0.42,  0.03,    0.38,  0.04,   0.51,   0.03,   2.34,   0.01,  1.15e-07,  9.19e-08,  9.19e-08,  nan ],
	[    84,    0.43,  0.03,    0.40,  0.04,   0.51,   0.03,   2.07,   0.01,  9.08e-08,  9.08e-08,  9.08e-08,  nan ],
	[    85,    0.44,  0.03,    0.41,  0.04,   0.52,   0.03,   2.11,   0.01,  8.98e-08,  8.98e-08,  1.35e-07,  nan ],
	[    86,    0.45,  0.03,    0.42,  0.04,   0.54,   0.03,   2.16,   0.01,  1.33e-07,  1.33e-07,  8.87e-08,  nan ],
	[    87,    0.46,  0.03,    0.41,  0.04,   0.54,   0.03,   2.47,   0.01,  8.77e-08,  6.58e-08,  8.77e-08,  nan ],
	[    88,    0.49,  0.03,    0.44,  0.04,   0.56,   0.03,   3.13,   0.01,  1.30e-07,  8.67e-08,  8.67e-08,  nan ],
	[    89,    0.49,  0.03,    0.39,  0.04,   0.55,   0.03,   3.20,   0.01,  1.29e-07,  1.29e-07,  1.29e-07,  nan ],
	[    90,    0.51,  0.03,    0.45,  0.04,   0.58,   0.03,   2.75,   0.01,  1.27e-07,  1.27e-07,  1.27e-07,  nan ],
	[   100,    0.60,  0.03,    0.53,  0.04,   0.67,   0.03,   1.84,   0.01,  1.14e-07,  1.14e-07,  1.14e-07,  nan ],
	[   110,    0.72,  0.03,    0.64,  0.04,   0.81,   0.03,   3.01,   0.01,  1.39e-07,  1.39e-07,  1.04e-07,  nan ],
	[   120,    0.73,  0.04,    0.78,  0.04,   0.97,   0.03,   3.69,   0.01,  9.54e-08,  1.27e-07,  1.27e-07,  nan ],
	[   130,    0.90,  0.04,    0.90,  0.04,   1.06,   0.03,   3.86,   0.01,  1.47e-07,  1.47e-07,  1.47e-07,  nan ],
	[   140,    1.04,  0.04,    0.90,  0.04,   1.19,   0.03,   4.87,   0.01,  2.18e-07,  1.63e-07,  1.63e-07,  nan ],
	[   150,    1.22,  0.04,    1.19,  0.04,   1.42,   0.03,   5.00,   0.01,  1.53e-07,  1.27e-07,  1.53e-07,  nan ],
	[   160,    1.43,  0.04,    1.36,  0.04,   1.61,   0.03,   5.15,   0.01,  1.43e-07,  1.43e-07,  1.43e-07,  nan ],
	[   170,    1.56,  0.04,    1.53,  0.04,   1.71,   0.03,   6.42,   0.01,  1.35e-07,  1.35e-07,  1.35e-07,  nan ],
	[   180,    1.67,  0.04,    1.63,  0.04,   1.86,   0.04,   5.94,   0.01,  1.70e-07,  1.27e-07,  1.27e-07,  nan ],
	[   190,    1.86,  0.04,    1.77,  0.04,   2.07,   0.04,   7.25,   0.01,  2.41e-07,  2.01e-07,  1.61e-07,  nan ],
	[   200,    1.92,  0.04,    2.01,  0.04,   2.11,   0.04,   7.33,   0.01,  1.53e-07,  1.53e-07,  1.53e-07,  nan ],
	[   210,    2.11,  0.04,    2.21,  0.04,   2.40,   0.04,   5.24,   0.02,  1.82e-07,  1.82e-07,  1.82e-07,  nan ],
	[   220,    2.25,  0.04,    2.37,  0.04,   2.63,   0.04,   8.87,   0.01,  1.73e-07,  2.08e-07,  1.73e-07,  nan ],
	[   230,    2.48,  0.04,    2.53,  0.04,   2.73,   0.04,   7.55,   0.01,  2.32e-07,  1.66e-07,  1.66e-07,  nan ],
	[   240,    2.70,  0.04,    2.76,  0.04,   2.98,   0.04,   8.99,   0.01,  2.23e-07,  2.54e-07,  2.23e-07,  nan ],
	[   250,    2.99,  0.04,    3.06,  0.04,   3.29,   0.04,   8.92,   0.01,  2.75e-07,  2.75e-07,  3.05e-07,  nan ],
	[   260,    3.01,  0.05,    3.23,  0.04,   3.39,   0.04,   1.86,   0.07,  1.17e-07,  8.80e-08,  8.80e-08,  nan ],
	[   270,    3.12,  0.05,    3.49,  0.04,   3.57,   0.04,   2.61,   0.06,  1.13e-07,  5.65e-08,  8.48e-08,  nan ],
	[   280,    3.33,  0.05,    3.73,  0.04,   3.75,   0.04,   2.49,   0.06,  8.17e-08,  5.45e-08,  8.17e-08,  nan ],
	[   290,    3.52,  0.05,    3.83,  0.04,   3.85,   0.04,   1.41,   0.12,  1.05e-07,  7.89e-08,  1.05e-07,  nan ],
	[   300,    3.77,  0.05,    4.12,  0.04,   4.19,   0.04,   2.66,   0.07,  1.02e-07,  7.63e-08,  1.02e-07,  nan ],
	[   310,    4.11,  0.05,    4.49,  0.04,   4.57,   0.04,   2.84,   0.07,  9.84e-08,  7.38e-08,  1.23e-07,  nan ],
	[   320,    4.46,  0.05,    4.90,  0.04,   4.90,   0.04,   0.10,   2.05,  9.54e-08,  9.54e-08,  1.43e-07,  nan ],
	[   330,    4.28,  0.05,    4.85,  0.05,   4.75,   0.05,   3.03,   0.07,  1.16e-07,  9.25e-08,  9.25e-08,  nan ],
	[   340,    4.54,  0.05,    5.17,  0.04,   5.04,   0.05,   3.32,   0.07,  1.12e-07,  8.98e-08,  1.12e-07,  nan ],
	[   350,    4.93,  0.05,    5.60,  0.04,   5.34,   0.05,   3.23,   0.08,  8.72e-08,  8.72e-08,  8.72e-08,  nan ],
	[   360,    5.12,  0.05,    5.92,  0.04,   5.42,   0.05,   0.13,   1.94,  1.48e-07,  1.06e-07,  8.48e-08,  nan ],
	[   370,    5.19,  0.05,    6.09,  0.05,   5.73,   0.05,   3.57,   0.08,  1.24e-07,  1.65e-07,  1.24e-07,  nan ],
	[   380,    5.57,  0.05,    6.46,  0.04,   6.16,   0.05,   3.57,   0.08,  1.20e-07,  1.20e-07,  1.20e-07,  nan ],
	[   390,    5.35,  0.06,    6.63,  0.05,   6.24,   0.05,   0.14,   2.14,  1.17e-07,  1.17e-07,  1.17e-07,  nan ],
	[   400,    5.73,  0.06,    6.97,  0.05,   6.41,   0.05,   4.07,   0.08,  1.14e-07,  1.14e-07,  1.14e-07,  nan ],
	[   410,    6.15,  0.05,    7.68,  0.04,   6.86,   0.05,   4.16,   0.08,  1.12e-07,  1.12e-07,  1.12e-07,  nan ],
	[   420,    6.21,  0.06,    7.53,  0.05,   6.93,   0.05,   0.14,   2.55,  1.09e-07,  1.45e-07,  1.09e-07,  nan ],
	[   430,    6.50,  0.06,    8.06,  0.05,   7.26,   0.05,   0.18,   2.04,  1.42e-07,  1.06e-07,  1.06e-07,  nan ],
	[   440,    6.81,  0.06,    8.10,  0.05,   7.47,   0.05,   4.86,   0.08,  1.04e-07,  1.04e-07,  1.04e-07,  nan ],
	[   450,    6.65,  0.06,    8.43,  0.05,   7.67,   0.05,   0.16,   2.59,  1.02e-07,  1.36e-07,  1.02e-07,  nan ],
	[   460,    6.95,  0.06,    8.85,  0.05,   7.70,   0.06,   4.43,   0.10,  9.95e-08,  1.33e-07,  9.95e-08,  nan ],
	[   470,    7.40,  0.06,    9.19,  0.05,   8.22,   0.05,   5.14,   0.09,  9.74e-08,  9.74e-08,  9.74e-08,  nan ],
	[   480,    7.81,  0.06,    9.83,  0.05,   8.88,   0.05,   0.22,   2.10,  9.54e-08,  9.54e-08,  9.54e-08,  nan ],
	[   490,    7.76,  0.06,    9.84,  0.05,   8.77,   0.05,   6.01,   0.08,  9.34e-08,  1.25e-07,  1.25e-07,  nan ],
	[   500,    8.34,  0.06,   10.01,  0.05,   8.94,   0.06,   6.04,   0.08,  9.16e-08,  1.22e-07,  1.53e-07,  nan ],
	[   510,    8.54,  0.06,   10.66,  0.05,   8.85,   0.06,   6.28,   0.08,  8.98e-08,  8.98e-08,  8.98e-08,  nan ],
	[   520,    8.36,  0.06,   10.82,  0.05,   9.02,   0.06,   2.39,   0.23,  1.47e-07,  8.80e-08,  1.17e-07,  nan ],
	[   530,    8.55,  0.07,   10.83,  0.05,   9.22,   0.06,   4.17,   0.13,  1.44e-07,  1.15e-07,  1.15e-07,  nan ],
	[   540,    8.85,  0.07,   11.51,  0.05,   9.43,   0.06,   4.23,   0.14,  1.13e-07,  1.13e-07,  1.13e-07,  nan ],
	[   550,    9.18,  0.07,   12.16,  0.05,   9.78,   0.06,   0.67,   0.91,  1.39e-07,  1.11e-07,  1.11e-07,  nan ],
	[   560,    9.55,  0.07,   12.31,  0.05,   9.98,   0.06,   4.76,   0.13,  1.36e-07,  1.09e-07,  1.09e-07,  nan ],
	[   570,    9.86,  0.07,   12.76,  0.05,  10.30,   0.06,   4.90,   0.13,  1.34e-07,  1.07e-07,  1.07e-07,  nan ],
	[   580,    9.65,  0.07,   12.68,  0.05,  10.06,   0.07,   4.58,   0.15,  1.05e-07,  1.05e-07,  1.05e-07,  nan ],
	[   590,    9.82,  0.07,    9.32,  0.07,  10.56,   0.07,   5.05,   0.14,  1.29e-07,  1.03e-07,  1.29e-07,  nan ],
	[   600,   10.15,  0.07,   13.56,  0.05,  10.92,   0.07,   5.42,   0.13,  1.27e-07,  1.53e-07,  1.27e-07,  nan ],
	[   610,   10.05,  0.07,   13.83,  0.05,  10.82,   0.07,   5.49,   0.14,  1.25e-07,  1.00e-07,  1.25e-07,  nan ],
	[   620,   10.69,  0.07,   14.29,  0.05,  11.14,   0.07,   5.54,   0.14,  1.23e-07,  9.84e-08,  1.23e-07,  nan ],
	[   630,   11.34,  0.07,   15.30,  0.05,  11.70,   0.07,   8.44,   0.09,  1.21e-07,  1.21e-07,  1.21e-07,  nan ],
	[   640,   11.40,  0.07,   15.23,  0.05,  10.92,   0.08,   5.90,   0.14,  9.54e-08,  1.19e-07,  1.19e-07,  nan ],
	[   650,   11.27,  0.08,   15.43,  0.05,  11.75,   0.07,   6.05,   0.14,  1.17e-07,  1.17e-07,  1.41e-07,  nan ],
	[   660,   11.47,  0.08,   15.64,  0.06,  11.81,   0.07,   6.38,   0.14,  1.39e-07,  1.16e-07,  1.16e-07,  nan ],
	[   670,   11.82,  0.08,   16.05,  0.06,  12.32,   0.07,   6.47,   0.14,  1.37e-07,  9.11e-08,  9.11e-08,  nan ],
	[   680,   12.03,  0.08,   16.60,  0.06,  12.53,   0.07,   6.39,   0.14,  1.12e-07,  1.35e-07,  1.35e-07,  nan ],
	[   690,   12.38,  0.08,   17.02,  0.06,  12.54,   0.08,   6.62,   0.14,  1.33e-07,  1.33e-07,  1.33e-07,  nan ],
	[   700,   13.07,  0.08,   17.52,  0.06,  12.90,   0.08,   6.71,   0.15,  1.31e-07,  1.31e-07,  1.31e-07,  nan ],
	[   710,   12.45,  0.08,   17.36,  0.06,  13.11,   0.08,   7.06,   0.14,  1.29e-07,  1.29e-07,  1.29e-07,  nan ],
	[   720,   12.96,  0.08,   17.92,  0.06,  13.32,   0.08,   7.07,   0.15,  1.27e-07,  1.27e-07,  1.27e-07,  nan ],
	[   730,   13.36,  0.08,   18.73,  0.06,  13.52,   0.08,   7.07,   0.15,  1.25e-07,  1.25e-07,  1.25e-07,  nan ],
	[   740,   13.22,  0.08,   18.62,  0.06,  13.73,   0.08,   7.78,   0.14,  1.24e-07,  1.24e-07,  1.24e-07,  nan ],
	[   750,   13.58,  0.08,   19.44,  0.06,  13.90,   0.08,   7.41,   0.15,  1.22e-07,  1.22e-07,  1.63e-07,  nan ],
	[   760,   13.78,  0.08,   19.97,  0.06,  14.31,   0.08,   7.71,   0.15,  1.20e-07,  1.20e-07,  1.20e-07,  nan ],
	[   770,   13.95,  0.09,   20.16,  0.06,  14.52,   0.08,   7.71,   0.15,  1.19e-07,  1.19e-07,  1.59e-07,  nan ],
	[   780,   14.31,  0.09,   20.28,  0.06,  14.86,   0.08,   8.01,   0.15,  1.57e-07,  1.17e-07,  1.57e-07,  nan ],
	[   790,   14.52,  0.09,   20.80,  0.06,  15.24,   0.08,   7.97,   0.16,  1.55e-07,  1.55e-07,  1.16e-07,  nan ],
	[   800,   14.93,  0.09,   21.68,  0.06,  15.63,   0.08,   7.95,   0.16,  1.53e-07,  1.14e-07,  1.53e-07,  nan ],
	[   810,   14.93,  0.09,   21.87,  0.06,  15.10,   0.09,   8.71,   0.15,  1.13e-07,  1.13e-07,  1.51e-07,  nan ],
	[   820,   15.30,  0.09,   22.06,  0.06,  15.82,   0.09,   8.80,   0.15,  1.49e-07,  1.12e-07,  1.49e-07,  nan ],
	[   830,   15.90,  0.09,   22.96,  0.06,  16.44,   0.08,   8.56,   0.16,  1.47e-07,  1.10e-07,  1.10e-07,  nan ],
	[   840,   15.04,  0.09,   22.79,  0.06,  16.46,   0.09,   8.51,   0.17,  1.45e-07,  1.45e-07,  1.09e-07,  nan ],
	[   850,   15.56,  0.09,   23.34,  0.06,  16.81,   0.09,   8.87,   0.16,  1.08e-07,  1.44e-07,  1.08e-07,  nan ],
	[   860,   15.73,  0.09,   23.89,  0.06,  17.02,   0.09,   9.26,   0.16,  1.42e-07,  1.42e-07,  1.06e-07,  nan ],
	[   870,   16.13,  0.09,   24.08,  0.06,  17.42,   0.09,   9.19,   0.16,  1.40e-07,  1.40e-07,  1.40e-07,  nan ],
	[   880,   16.14,  0.10,   24.63,  0.06,  17.62,   0.09,   9.34,   0.17,  1.39e-07,  1.39e-07,  1.39e-07,  nan ],
	[   890,   16.71,  0.09,   24.73,  0.06,  17.83,   0.09,   9.67,   0.16,  1.03e-07,  1.37e-07,  1.03e-07,  nan ],
	[   900,   16.08,  0.10,   24.21,  0.07,  17.62,   0.09,  10.00,   0.16,  1.36e-07,  1.36e-07,  1.36e-07,  nan ],
	[  1000,   17.87,  0.11,   28.56,  0.07,  19.08,   0.10,  11.01,   0.18,  1.22e-07,  1.22e-07,  1.53e-07,  nan ],
	[  1100,   19.54,  0.12,   31.85,  0.08,  21.08,   0.11,  12.05,   0.20,  1.66e-07,  1.39e-07,  1.39e-07,  nan ],
	[  1200,   21.70,  0.13,   36.09,  0.08,  23.99,   0.12,  13.27,   0.22,  1.78e-07,  1.27e-07,  1.27e-07,  nan ],
	[  1300,   23.80,  0.14,   39.41,  0.09,  26.03,   0.13,  14.70,   0.23,  1.64e-07,  1.17e-07,  1.64e-07,  nan ],
	[  1400,   26.16,  0.15,   44.59,  0.09,  28.61,   0.14,  16.36,   0.24,  1.74e-07,  1.74e-07,  1.31e-07,  nan ],
	[  1500,   27.98,  0.16,   49.57,  0.09,  29.24,   0.15,  17.25,   0.26,  2.03e-07,  1.63e-07,  1.63e-07,  nan ],
	[  1600,   30.14,  0.17,   53.99,  0.09,  31.65,   0.16,  17.66,   0.29,  1.91e-07,  1.53e-07,  1.53e-07,  nan ],
	[  1700,   31.63,  0.18,   55.13,  0.10,  33.64,   0.17,  18.91,   0.31,  1.80e-07,  2.15e-07,  1.80e-07,  nan ],
	[  1800,   33.41,  0.19,   60.57,  0.11,  34.86,   0.19,  20.07,   0.32,  1.70e-07,  1.70e-07,  1.70e-07,  nan ],
	[  1900,   35.60,  0.20,   62.22,  0.12,  37.83,   0.19,  20.13,   0.36,  2.25e-07,  1.61e-07,  1.61e-07,  nan ],
	[  2000,   36.02,  0.22,   60.60,  0.13,  34.05,   0.24,  20.26,   0.40,  2.14e-07,  1.53e-07,  1.53e-07,  nan ],
	[  2100,   39.42,  0.22,   64.93,  0.14,  24.45,   0.36,  22.23,   0.40,  2.03e-07,  1.74e-07,  1.74e-07,  nan ],
	[  2200,   40.50,  0.24,   68.73,  0.14,  25.15,   0.39,  21.32,   0.45,  2.50e-07,  1.66e-07,  1.39e-07,  nan ],
	[  2300,   43.02,  0.25,   71.03,  0.15,  25.83,   0.41,  23.00,   0.46,  2.92e-07,  1.86e-07,  1.86e-07,  nan ],
	[  2400,   44.84,  0.26,   73.80,  0.16,  26.56,   0.43,  24.27,   0.47,  2.29e-07,  1.78e-07,  1.78e-07,  nan ],
	[  2500,   45.81,  0.27,   77.13,  0.16,  28.03,   0.45,  24.47,   0.51,  2.69e-07,  1.71e-07,  1.46e-07,  nan ],
	[  2600,   47.95,  0.28,   79.56,  0.17,  28.67,   0.47,  26.58,   0.51,  2.11e-07,  1.88e-07,  1.88e-07,  nan ],
	[  2700,   49.30,  0.30,   86.28,  0.17,  29.89,   0.49,  26.37,   0.55,  2.26e-07,  1.81e-07,  1.58e-07,  nan ],
	[  2800,   51.93,  0.30,   87.14,  0.18,  31.30,   0.50,  27.76,   0.57,  2.62e-07,  1.74e-07,  1.74e-07,  nan ],
	[  2900,   52.39,  0.32,   92.49,  0.18,  32.18,   0.52,  27.68,   0.61,  2.53e-07,  2.10e-07,  2.10e-07,  nan ],
	[  3000,   54.53,  0.33,   94.29,  0.19,  33.28,   0.54,  32.39,   0.56,  3.26e-07,  2.44e-07,  2.03e-07,  nan ],
	[  3100,   56.39,  0.34,   97.51,  0.20,  34.27,   0.56,  30.24,   0.64,  2.36e-07,  2.36e-07,  1.97e-07,  nan ],
	[  3200,   57.55,  0.36,  102.42,  0.20,  35.32,   0.58,  32.88,   0.62,  2.67e-07,  1.91e-07,  1.53e-07,  nan ],
	[  3300,   60.04,  0.36,  103.72,  0.21,  36.19,   0.60,  31.21,   0.70,  2.96e-07,  2.22e-07,  1.85e-07,  nan ],
	[  3400,   60.85,  0.38,  106.13,  0.22,  37.42,   0.62,  36.48,   0.63,  2.87e-07,  2.15e-07,  1.80e-07,  nan ],
	[  3500,   63.49,  0.39,  109.82,  0.22,  38.53,   0.64,  31.91,   0.77,  3.14e-07,  2.09e-07,  1.74e-07,  nan ],
	[  3600,   65.47,  0.40,  111.76,  0.23,  39.40,   0.66,  41.08,   0.63,  2.71e-07,  2.37e-07,  1.70e-07,  nan ],
	[  3700,   66.63,  0.41,  112.73,  0.24,  40.28,   0.68,  32.45,   0.84,  2.64e-07,  2.31e-07,  1.98e-07,  nan ],
	[  3800,   68.30,  0.42,  113.24,  0.26,  41.40,   0.70,  37.82,   0.76,  2.89e-07,  2.89e-07,  1.93e-07,  nan ],
	[  3900,   69.93,  0.44,  112.34,  0.27,  42.61,   0.71,  37.06,   0.82,  2.50e-07,  2.19e-07,  2.19e-07,  nan ],
	[  4000,   71.30,  0.45,  114.35,  0.28,  43.38,   0.74,  35.53,   0.90,  3.05e-07,  2.14e-07,  1.53e-07,  nan ],
	[  4100,   70.07,  0.48,  114.39,  0.29,  31.25,   1.08,  40.32,   0.83,  3.28e-07,  2.08e-07,  2.08e-07,  nan ],
	[  4200,   72.48,  0.49,  113.07,  0.31,  32.59,   1.08,  16.73,   2.11,  2.91e-07,  2.33e-07,  2.03e-07,  nan ],
	[  4300,   75.31,  0.49,  115.52,  0.32,  33.54,   1.10,  29.13,   1.27,  3.41e-07,  2.55e-07,  2.27e-07,  nan ],
	[  4400,   77.43,  0.50,  113.59,  0.34,  34.45,   1.12,  28.54,   1.36,  2.77e-07,  2.77e-07,  2.22e-07,  nan ],
	[  4500,   77.62,  0.52,  115.74,  0.35,  34.95,   1.16,  29.85,   1.36,  2.71e-07,  2.44e-07,  1.90e-07,  nan ],
	[  4600,   80.96,  0.52,  116.88,  0.36,  35.87,   1.18,  31.17,   1.36,  3.18e-07,  2.39e-07,  2.12e-07,  nan ],
	[  4700,   81.97,  0.54,  116.94,  0.38,  36.46,   1.21,  31.47,   1.40,  3.12e-07,  2.60e-07,  2.08e-07,  nan ],
	[  4800,   82.47,  0.56,  116.95,  0.39,  37.54,   1.23,  29.55,   1.56,  3.05e-07,  2.29e-07,  2.29e-07,  nan ],
	[  4900,   81.26,  0.59,  114.07,  0.42,  38.09,   1.26,  32.59,   1.47,  3.99e-07,  2.24e-07,  2.49e-07,  nan ],
	[  5000,   81.21,  0.62,  116.02,  0.43,  39.19,   1.28,  32.14,   1.56,  3.17e-07,  2.44e-07,  2.20e-07,  nan ],
	[  5100,   81.55,  0.64,  117.71,  0.44,  39.24,   1.33,  31.23,   1.67,  3.35e-07,  2.15e-07,  2.15e-07,  nan ],
	[  5200,   81.70,  0.66,  117.86,  0.46,  40.13,   1.35,  31.23,   1.73,  3.29e-07,  2.58e-07,  2.35e-07,  nan ],
	[  5300,   82.87,  0.68,  120.06,  0.47,  40.87,   1.37,  32.77,   1.71,  3.92e-07,  2.53e-07,  2.53e-07,  nan ],
	[  5400,   82.96,  0.70,  119.99,  0.49,  41.43,   1.41,  34.95,   1.67,  3.84e-07,  2.49e-07,  2.03e-07,  nan ],
	[  5500,   82.64,  0.73,  118.16,  0.51,  42.41,   1.43,  35.45,   1.71,  3.11e-07,  2.66e-07,  2.22e-07,  nan ],
	[  5600,   84.77,  0.74,  123.53,  0.51,  42.82,   1.47,  35.74,   1.75,  4.36e-07,  3.05e-07,  2.18e-07,  nan ],
	[  5700,   83.54,  0.78,  122.40,  0.53,  43.01,   1.51,  33.57,   1.94,  3.43e-07,  2.57e-07,  3.00e-07,  nan ],
	[  5800,   82.55,  0.82,  121.50,  0.55,  43.84,   1.53,  33.44,   2.01,  3.79e-07,  2.53e-07,  2.53e-07,  nan ],
	[  5900,   84.41,  0.82,  122.15,  0.57,  43.99,   1.58,  34.00,   2.05,  3.72e-07,  3.31e-07,  2.48e-07,  nan ],
	[  6000,   84.63,  0.85,  122.09,  0.59,  45.21,   1.59,  35.41,   2.03,  4.07e-07,  2.85e-07,  2.44e-07,  nan ],
	[  6100,   85.16,  0.87,  125.13,  0.59,  46.12,   1.61,  36.59,   2.03,  4.00e-07,  2.80e-07,  2.40e-07,  nan ],
	[  6200,   86.58,  0.89,  126.47,  0.61,  36.44,   2.11,  36.72,   2.09,  3.94e-07,  2.76e-07,  2.76e-07,  nan ],
	[  6300,   87.42,  0.91,  125.42,  0.63,  37.55,   2.11,  35.63,   2.23,  3.49e-07,  2.71e-07,  2.33e-07,  nan ],
	[  6400,   87.91,  0.93,  127.18,  0.64,  37.39,   2.19,  35.48,   2.31,  3.43e-07,  2.67e-07,  2.67e-07,  nan ],
	[  6500,   87.96,  0.96,  126.55,  0.67,  38.41,   2.20,  36.76,   2.30,  3.76e-07,  3.00e-07,  3.00e-07,  nan ],
	[  6600,   89.93,  0.97,  127.92,  0.68,  39.12,   2.23,  37.44,   2.33,  3.70e-07,  2.96e-07,  2.59e-07,  nan ],
	[  6700,   89.44,  1.00,  128.10,  0.70,  39.80,   2.26,  36.47,   2.46,  3.64e-07,  2.55e-07,  2.55e-07,  nan ],
	[  6800,   89.20,  1.04,  127.78,  0.72,  39.11,   2.37,  35.68,   2.59,  3.59e-07,  3.95e-07,  2.87e-07,  nan ],
	[  6900,   89.94,  1.06,  131.35,  0.73,  40.65,   2.34,  37.46,   2.54,  3.54e-07,  3.18e-07,  2.83e-07,  nan ],
	[  7000,   88.77,  1.10,  129.48,  0.76,  41.42,   2.37,  36.71,   2.67,  4.53e-07,  3.14e-07,  2.44e-07,  nan ],
	[  7100,   90.68,  1.11,  130.29,  0.77,  42.29,   2.38,  36.88,   2.73,  4.47e-07,  3.09e-07,  2.75e-07,  nan ],
	[  7200,   92.34,  1.12,  131.60,  0.79,  42.44,   2.44,  37.76,   2.75,  3.73e-07,  2.71e-07,  3.05e-07,  nan ],
	[  7300,   91.97,  1.16,  130.96,  0.81,  42.54,   2.51,  38.11,   2.80,  4.68e-07,  3.01e-07,  2.68e-07,  nan ],
	[  7400,   91.74,  1.19,  133.24,  0.82,  43.35,   2.53,  29.19,   3.75,  3.96e-07,  2.97e-07,  2.64e-07,  nan ],
	[  7500,   93.84,  1.20,  132.53,  0.85,  42.94,   2.62,  40.26,   2.79,  3.91e-07,  2.93e-07,  2.93e-07,  nan ],
	[  7600,   93.93,  1.23,  132.80,  0.87,  44.20,   2.61,  38.93,   2.97,  4.50e-07,  3.21e-07,  2.89e-07,  nan ],
	[  7700,   94.05,  1.26,  131.91,  0.90,  43.96,   2.70,  38.82,   3.05,  4.12e-07,  3.17e-07,  3.17e-07,  nan ],
	[  7800,   95.30,  1.28,  131.55,  0.93,  45.39,   2.68,  38.31,   3.18,  4.38e-07,  3.13e-07,  3.44e-07,  nan ],
	[  7900,   95.30,  1.31,  132.39,  0.94,  45.85,   2.72,  39.38,   3.17,  4.02e-07,  3.09e-07,  2.78e-07,  nan ],
	[  8000,   94.76,  1.35,  133.07,  0.96,  46.44,   2.76,  38.60,   3.32,  3.97e-07,  3.36e-07,  2.75e-07,  nan ],
	[  8100,   94.95,  1.38,  133.93,  0.98,  46.49,   2.82,  39.16,   3.35,  4.22e-07,  3.92e-07,  3.01e-07,  nan ],
	[  8200,   97.62,  1.38,  134.63,  1.00,  38.65,   3.48,  38.81,   3.47,  3.87e-07,  2.98e-07,  2.68e-07,  nan ],
	[  8300,   96.84,  1.42,  133.26,  1.03,  39.67,   3.47,  40.24,   3.42,  4.12e-07,  3.53e-07,  2.94e-07,  nan ],
	[  8400,   98.56,  1.43,  134.54,  1.05,  38.49,   3.67,  39.80,   3.55,  4.36e-07,  3.78e-07,  2.62e-07,  nan ],
	[  8500,   98.18,  1.47,  134.31,  1.08,  40.43,   3.57,  39.06,   3.70,  5.17e-07,  3.45e-07,  2.87e-07,  nan ],
	[  8600,   99.55,  1.49,  135.60,  1.09,  40.41,   3.66,  40.72,   3.63,  4.26e-07,  3.12e-07,  3.12e-07,  nan ],
	[  8700,   99.16,  1.53,  135.17,  1.12,  41.45,   3.65,  41.68,   3.63,  4.21e-07,  3.37e-07,  2.81e-07,  nan ],
	[  8800,   98.66,  1.57,  134.46,  1.15,  41.92,   3.70,  37.69,   4.11,  3.88e-07,  3.05e-07,  3.05e-07,  nan ],
	[  8900,   99.04,  1.60,  134.71,  1.18,  40.72,   3.89,  40.74,   3.89,  4.11e-07,  3.29e-07,  2.74e-07,  nan ],
	[  9000,  100.14,  1.62,  134.25,  1.21,  42.94,   3.77,  40.17,   4.03,  4.88e-07,  3.80e-07,  3.53e-07,  nan ],
	[ 10000,  102.62,  1.95,  135.62,  1.47,  45.82,   4.37,  41.73,   4.79,  4.88e-07,  3.91e-07,  3.66e-07,  nan ],
	[ 12000,  104.70,  2.75,  139.97,  2.06,  46.11,   6.25,  41.29,   6.97,  5.70e-07,  4.48e-07,  3.26e-07,  nan ],
	[ 14000,  110.59,  3.54,  141.07,  2.78,  45.55,   8.61,  42.01,   9.33,  5.58e-07,  4.19e-07,  4.19e-07,  nan ],
	[ 16000,  112.61,  4.55,  139.86,  3.66,  45.26,  11.31,  41.94,  12.21,  5.49e-07,  4.27e-07,  3.97e-07,  nan ],
	[ 18000,  114.23,  5.67,  143.27,  4.52,  45.42,  14.27,  43.02,  15.07,  6.51e-07,  5.70e-07,  4.34e-07,  nan ],
	[ 20000,  117.20,  6.83,  144.33,  5.54,  46.01,  17.39,  46.15,  17.34,  7.08e-07,  5.13e-07,  4.39e-07,  nan ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/zgeev.txt
# numactl --interleave=all ./testing_zgeev -RN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zgeev_RN = array([
	[    10,  nan,    0.00 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.00 ],
	[    60,  nan,    0.00 ],
	[    70,  nan,    0.01 ],
	[    80,  nan,    0.01 ],
	[    90,  nan,    0.01 ],
	[   100,  nan,    0.02 ],
	[   200,  nan,    0.09 ],
	[   300,  nan,    0.18 ],
	[   400,  nan,    0.30 ],
	[   500,  nan,    0.45 ],
	[   600,  nan,    1.01 ],
	[   700,  nan,    1.25 ],
	[   800,  nan,    1.51 ],
	[   900,  nan,    1.79 ],
	[  1000,  nan,    2.25 ],
	[  2000,  nan,    7.05 ],
	[  3000,  nan,   19.89 ],
	[  4000,  nan,   32.61 ],
	[  5000,  nan,   49.02 ],
	[  6000,  nan,   89.19 ],
	[  7000,  nan,  116.04 ],
	[  8000,  nan,  148.99 ],
	[  9000,  nan,  185.23 ],
	[ 10000,  nan,  229.80 ],
	[ 12000,  nan,  330.63 ],
	[ 14000,  nan,  461.91 ],
])

# numactl --interleave=all ./testing_zgeev -RV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zgeev_RV = array([
	[    10,  nan,    0.00 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.01 ],
	[    50,  nan,    0.01 ],
	[    60,  nan,    0.01 ],
	[    70,  nan,    0.01 ],
	[    80,  nan,    0.02 ],
	[    90,  nan,    0.02 ],
	[   100,  nan,    0.03 ],
	[   200,  nan,    0.13 ],
	[   300,  nan,    0.25 ],
	[   400,  nan,    0.45 ],
	[   500,  nan,    0.67 ],
	[   600,  nan,    1.22 ],
	[   700,  nan,    1.46 ],
	[   800,  nan,    1.83 ],
	[   900,  nan,    2.23 ],
	[  1000,  nan,    2.66 ],
	[  2000,  nan,   10.07 ],
	[  3000,  nan,   27.04 ],
	[  4000,  nan,   46.86 ],
	[  5000,  nan,   76.28 ],
	[  6000,  nan,  124.99 ],
	[  7000,  nan,  176.31 ],
	[  8000,  nan,  225.31 ],
	[  9000,  nan,  284.72 ],
	[ 10000,  nan,  377.54 ],
	[ 12000,  nan,  551.92 ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/zgeqrf.txt
# numactl --interleave=all ./testing_zgeqrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zgeqrf = array([
	[    10,     10,  nan,  nan,     0.24,   0.00,  nan ],
	[    20,     20,  nan,  nan,     1.07,   0.00,  nan ],
	[    30,     30,  nan,  nan,     2.33,   0.00,  nan ],
	[    40,     40,  nan,  nan,     0.97,   0.00,  nan ],
	[    50,     50,  nan,  nan,     1.63,   0.00,  nan ],
	[    60,     60,  nan,  nan,     2.36,   0.00,  nan ],
	[    70,     70,  nan,  nan,     1.47,   0.00,  nan ],
	[    80,     80,  nan,  nan,     2.06,   0.00,  nan ],
	[    90,     90,  nan,  nan,     2.70,   0.00,  nan ],
	[   100,    100,  nan,  nan,     3.40,   0.00,  nan ],
	[   200,    200,  nan,  nan,     8.72,   0.00,  nan ],
	[   300,    300,  nan,  nan,    18.35,   0.01,  nan ],
	[   400,    400,  nan,  nan,    27.97,   0.01,  nan ],
	[   500,    500,  nan,  nan,    36.66,   0.02,  nan ],
	[   600,    600,  nan,  nan,    50.74,   0.02,  nan ],
	[   700,    700,  nan,  nan,    64.94,   0.03,  nan ],
	[   800,    800,  nan,  nan,    81.21,   0.03,  nan ],
	[   900,    900,  nan,  nan,    89.07,   0.04,  nan ],
	[  1000,   1000,  nan,  nan,   110.37,   0.05,  nan ],
	[  2000,   2000,  nan,  nan,   293.42,   0.15,  nan ],
	[  3000,   3000,  nan,  nan,   466.57,   0.31,  nan ],
	[  4000,   4000,  nan,  nan,   663.10,   0.51,  nan ],
	[  5000,   5000,  nan,  nan,   752.24,   0.89,  nan ],
	[  6000,   6000,  nan,  nan,   860.12,   1.34,  nan ],
	[  7000,   7000,  nan,  nan,   913.74,   2.00,  nan ],
	[  8000,   8000,  nan,  nan,   954.73,   2.86,  nan ],
	[  9000,   9000,  nan,  nan,   959.48,   4.05,  nan ],
	[ 10000,  10000,  nan,  nan,  1007.62,   5.29,  nan ],
	[ 12000,  12000,  nan,  nan,  1041.11,   8.85,  nan ],
	[ 14000,  14000,  nan,  nan,  1043.04,  14.03,  nan ],
	[ 16000,  16000,  nan,  nan,  1039.25,  21.02,  nan ],
	[ 18000,  18000,  nan,  nan,  1023.93,  30.38,  nan ],
	[ 20000,  20000,  nan,  nan,  1041.20,  40.98,  nan ],
])

# numactl --interleave=all ./testing_zgeqrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zgeqrf_gpu = array([
	[    10,     10,  nan,  nan,     0.01,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.05,   0.00,  nan ],
	[    30,     30,  nan,  nan,     0.14,   0.00,  nan ],
	[    40,     40,  nan,  nan,     0.33,   0.00,  nan ],
	[    50,     50,  nan,  nan,     0.59,   0.00,  nan ],
	[    60,     60,  nan,  nan,     0.96,   0.00,  nan ],
	[    70,     70,  nan,  nan,     1.71,   0.00,  nan ],
	[    80,     80,  nan,  nan,     2.52,   0.00,  nan ],
	[    90,     90,  nan,  nan,     2.93,   0.00,  nan ],
	[   100,    100,  nan,  nan,     2.30,   0.00,  nan ],
	[   200,    200,  nan,  nan,     6.33,   0.01,  nan ],
	[   300,    300,  nan,  nan,    13.84,   0.01,  nan ],
	[   400,    400,  nan,  nan,    21.73,   0.02,  nan ],
	[   500,    500,  nan,  nan,    33.95,   0.02,  nan ],
	[   600,    600,  nan,  nan,    44.45,   0.03,  nan ],
	[   700,    700,  nan,  nan,    59.51,   0.03,  nan ],
	[   800,    800,  nan,  nan,    69.87,   0.04,  nan ],
	[   900,    900,  nan,  nan,    82.77,   0.05,  nan ],
	[  1000,   1000,  nan,  nan,    97.31,   0.05,  nan ],
	[  2000,   2000,  nan,  nan,   270.59,   0.16,  nan ],
	[  3000,   3000,  nan,  nan,   462.65,   0.31,  nan ],
	[  4000,   4000,  nan,  nan,   634.22,   0.54,  nan ],
	[  5000,   5000,  nan,  nan,   725.87,   0.92,  nan ],
	[  6000,   6000,  nan,  nan,   830.85,   1.39,  nan ],
	[  7000,   7000,  nan,  nan,   895.92,   2.04,  nan ],
	[  8000,   8000,  nan,  nan,   944.58,   2.89,  nan ],
	[  9000,   9000,  nan,  nan,   968.73,   4.01,  nan ],
	[ 10000,  10000,  nan,  nan,   993.62,   5.37,  nan ],
	[ 12000,  12000,  nan,  nan,  1037.57,   8.88,  nan ],
	[ 14000,  14000,  nan,  nan,  1056.01,  13.86,  nan ],
	[ 16000,  16000,  nan,  nan,  1079.60,  20.24,  nan ],
	[ 18000,  18000,  nan,  nan,  1044.17,  29.79,  nan ],
	[ 20000,  20000,  nan,  nan,  1066.96,  39.99,  nan ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/zgetrf.txt
# numactl --interleave=all ./testing_zgetrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zgetrf = array([
	[    10,     10,  nan,  nan,     0.26,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.81,   0.00,  nan ],
	[    30,     30,  nan,  nan,     1.27,   0.00,  nan ],
	[    40,     40,  nan,  nan,     3.07,   0.00,  nan ],
	[    50,     50,  nan,  nan,     1.40,   0.00,  nan ],
	[    60,     60,  nan,  nan,     3.84,   0.00,  nan ],
	[    70,     70,  nan,  nan,     1.11,   0.00,  nan ],
	[    80,     80,  nan,  nan,     1.61,   0.00,  nan ],
	[    90,     90,  nan,  nan,     2.03,   0.00,  nan ],
	[   100,    100,  nan,  nan,     2.70,   0.00,  nan ],
	[   200,    200,  nan,  nan,     9.96,   0.00,  nan ],
	[   300,    300,  nan,  nan,    21.81,   0.00,  nan ],
	[   400,    400,  nan,  nan,    34.99,   0.00,  nan ],
	[   500,    500,  nan,  nan,    50.09,   0.01,  nan ],
	[   600,    600,  nan,  nan,    66.18,   0.01,  nan ],
	[   700,    700,  nan,  nan,    82.78,   0.01,  nan ],
	[   800,    800,  nan,  nan,    99.49,   0.01,  nan ],
	[   900,    900,  nan,  nan,   117.49,   0.02,  nan ],
	[  1000,   1000,  nan,  nan,   135.68,   0.02,  nan ],
	[  2000,   2000,  nan,  nan,   312.96,   0.07,  nan ],
	[  3000,   3000,  nan,  nan,   514.04,   0.14,  nan ],
	[  4000,   4000,  nan,  nan,   621.55,   0.27,  nan ],
	[  5000,   5000,  nan,  nan,   632.14,   0.53,  nan ],
	[  6000,   6000,  nan,  nan,   730.46,   0.79,  nan ],
	[  7000,   7000,  nan,  nan,   797.13,   1.15,  nan ],
	[  8000,   8000,  nan,  nan,   854.10,   1.60,  nan ],
	[  9000,   9000,  nan,  nan,   872.96,   2.23,  nan ],
	[ 10000,  10000,  nan,  nan,   919.01,   2.90,  nan ],
	[ 12000,  12000,  nan,  nan,   977.03,   4.72,  nan ],
	[ 14000,  14000,  nan,  nan,  1016.30,   7.20,  nan ],
	[ 16000,  16000,  nan,  nan,  1044.21,  10.46,  nan ],
	[ 18000,  18000,  nan,  nan,  1054.19,  14.75,  nan ],
	[ 20000,  20000,  nan,  nan,  1060.55,  20.12,  nan ],
])

# numactl --interleave=all ./testing_zgetrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zgetrf_gpu = array([
	[    10,     10,  nan,  nan,     0.05,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.36,   0.00,  nan ],
	[    30,     30,  nan,  nan,     0.69,   0.00,  nan ],
	[    40,     40,  nan,  nan,     1.61,   0.00,  nan ],
	[    50,     50,  nan,  nan,     1.00,   0.00,  nan ],
	[    60,     60,  nan,  nan,     2.14,   0.00,  nan ],
	[    70,     70,  nan,  nan,     0.52,   0.00,  nan ],
	[    80,     80,  nan,  nan,     0.77,   0.00,  nan ],
	[    90,     90,  nan,  nan,     1.03,   0.00,  nan ],
	[   100,    100,  nan,  nan,     1.36,   0.00,  nan ],
	[   200,    200,  nan,  nan,     6.69,   0.00,  nan ],
	[   300,    300,  nan,  nan,    16.01,   0.00,  nan ],
	[   400,    400,  nan,  nan,    27.44,   0.01,  nan ],
	[   500,    500,  nan,  nan,    43.05,   0.01,  nan ],
	[   600,    600,  nan,  nan,    57.49,   0.01,  nan ],
	[   700,    700,  nan,  nan,    74.59,   0.01,  nan ],
	[   800,    800,  nan,  nan,    92.11,   0.01,  nan ],
	[   900,    900,  nan,  nan,   110.37,   0.02,  nan ],
	[  1000,   1000,  nan,  nan,   133.01,   0.02,  nan ],
	[  2000,   2000,  nan,  nan,   326.91,   0.07,  nan ],
	[  3000,   3000,  nan,  nan,   631.40,   0.11,  nan ],
	[  4000,   4000,  nan,  nan,   757.78,   0.23,  nan ],
	[  5000,   5000,  nan,  nan,   678.83,   0.49,  nan ],
	[  6000,   6000,  nan,  nan,   853.12,   0.68,  nan ],
	[  7000,   7000,  nan,  nan,   927.37,   0.99,  nan ],
	[  8000,   8000,  nan,  nan,   976.26,   1.40,  nan ],
	[  9000,   9000,  nan,  nan,   952.66,   2.04,  nan ],
	[ 10000,  10000,  nan,  nan,  1007.00,   2.65,  nan ],
	[ 12000,  12000,  nan,  nan,  1054.80,   4.37,  nan ],
	[ 14000,  14000,  nan,  nan,  1096.53,   6.67,  nan ],
	[ 16000,  16000,  nan,  nan,  1114.59,   9.80,  nan ],
	[ 18000,  18000,  nan,  nan,  1123.62,  13.84,  nan ],
	[ 20000,  20000,  nan,  nan,  1115.41,  19.13,  nan ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/zheevd.txt
# numactl --interleave=all ./testing_zheevd -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zheevd_JN = array([
	[    10,  nan,    0.00 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.00 ],
	[    60,  nan,    0.00 ],
	[    70,  nan,    0.00 ],
	[    80,  nan,    0.00 ],
	[    90,  nan,    0.00 ],
	[   100,  nan,    0.00 ],
	[   200,  nan,    0.01 ],
	[   300,  nan,    0.02 ],
	[   400,  nan,    0.03 ],
	[   500,  nan,    0.05 ],
	[   600,  nan,    0.06 ],
	[   700,  nan,    0.09 ],
	[   800,  nan,    0.12 ],
	[   900,  nan,    0.15 ],
	[  1000,  nan,    0.19 ],
	[  2000,  nan,    0.84 ],
	[  3000,  nan,    3.47 ],
	[  4000,  nan,    7.10 ],
	[  5000,  nan,   12.64 ],
	[  6000,  nan,   20.77 ],
	[  7000,  nan,   30.39 ],
	[  8000,  nan,   43.31 ],
	[  9000,  nan,   59.43 ],
	[ 10000,  nan,   78.97 ],
	[ 12000,  nan,  131.90 ],
	[ 14000,  nan,  200.80 ],
	[ 16000,  nan,  293.85 ],
	[ 18000,  nan,  412.45 ],
	[ 20000,  nan,  558.43 ],
])

# numactl --interleave=all ./testing_zheevd -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zheevd_JV = array([
	[    10,  nan,    0.03 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.00 ],
	[    60,  nan,    0.00 ],
	[    70,  nan,    0.00 ],
	[    80,  nan,    0.01 ],
	[    90,  nan,    0.00 ],
	[   100,  nan,    0.00 ],
	[   200,  nan,    0.01 ],
	[   300,  nan,    0.02 ],
	[   400,  nan,    0.03 ],
	[   500,  nan,    0.05 ],
	[   600,  nan,    0.07 ],
	[   700,  nan,    0.09 ],
	[   800,  nan,    0.12 ],
	[   900,  nan,    0.15 ],
	[  1000,  nan,    0.20 ],
	[  2000,  nan,    0.79 ],
	[  3000,  nan,    3.87 ],
	[  4000,  nan,    7.86 ],
	[  5000,  nan,   14.04 ],
	[  6000,  nan,   22.89 ],
	[  7000,  nan,   33.87 ],
	[  8000,  nan,   48.23 ],
	[  9000,  nan,   66.43 ],
	[ 10000,  nan,   88.34 ],
	[ 12000,  nan,  147.52 ],
	[ 14000,  nan,  225.06 ],
	[ 16000,  nan,  329.76 ],
	[ 18000,  nan,  464.36 ],
	[ 20000,  nan,  625.79 ],
])

# numactl --interleave=all ./testing_zheevd_gpu -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zheevd_gpu_JN = array([
	[    10,  nan,    0.00 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.00 ],
	[    60,  nan,    0.00 ],
	[    70,  nan,    0.00 ],
	[    80,  nan,    0.00 ],
	[    90,  nan,    0.00 ],
	[   100,  nan,    0.00 ],
	[   200,  nan,    0.01 ],
	[   300,  nan,    0.02 ],
	[   400,  nan,    0.03 ],
	[   500,  nan,    0.04 ],
	[   600,  nan,    0.06 ],
	[   700,  nan,    0.08 ],
	[   800,  nan,    0.10 ],
	[   900,  nan,    0.12 ],
	[  1000,  nan,    0.16 ],
	[  2000,  nan,    0.67 ],
	[  3000,  nan,    5.53 ],
	[  4000,  nan,   11.58 ],
	[  5000,  nan,   19.20 ],
	[  6000,  nan,   28.93 ],
	[  7000,  nan,   41.79 ],
	[  8000,  nan,   56.64 ],
	[  9000,  nan,   75.79 ],
	[ 10000,  nan,   97.05 ],
	[ 12000,  nan,  154.13 ],
	[ 14000,  nan,  230.00 ],
	[ 16000,  nan,  325.21 ],
	[ 18000,  nan,  447.97 ],
	[ 20000,  nan,    0.00 ],
])

# numactl --interleave=all ./testing_zheevd_gpu -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zheevd_gpu_JV = array([
	[    10,  nan,    0.00 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.00 ],
	[    60,  nan,    0.00 ],
	[    70,  nan,    0.00 ],
	[    80,  nan,    0.00 ],
	[    90,  nan,    0.00 ],
	[   100,  nan,    0.00 ],
	[   200,  nan,    0.01 ],
	[   300,  nan,    0.03 ],
	[   400,  nan,    0.04 ],
	[   500,  nan,    0.07 ],
	[   600,  nan,    0.20 ],
	[   700,  nan,    0.37 ],
	[   800,  nan,    0.26 ],
	[   900,  nan,    9.35 ],
	[  1000,  nan,    0.33 ],
	[  2000,  nan,   11.87 ],
	[  3000,  nan,    3.81 ],
	[  4000,  nan,    7.83 ],
	[  5000,  nan,   14.02 ],
	[  6000,  nan,   22.43 ],
	[  7000,  nan,   34.20 ],
	[  8000,  nan,   48.43 ],
	[  9000,  nan,   67.44 ],
	[ 10000,  nan,   89.21 ],
	[ 12000,  nan,  147.54 ],
	[ 14000,  nan,  228.14 ],
	[ 16000,  nan,  330.58 ],
	[ 18000,  nan,  464.52 ],
	[ 20000,  nan,    0.00 ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/zheevd_2stage.txt
# numactl --interleave=all ./testing_zheevdx_2stage -JN -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zheevdx_2stage_JN = array([
	[   200,    200,   0.01 ],
	[   300,    300,   0.04 ],
	[   400,    400,   0.08 ],
	[   500,    500,   0.13 ],
	[   600,    600,   0.17 ],
	[   700,    700,   0.23 ],
	[   800,    800,   0.32 ],
	[   900,    900,   0.35 ],
	[  1000,   1000,   0.42 ],
	[  2000,   2000,   1.31 ],
	[  3000,   3000,   2.09 ],
	[  4000,   4000,   3.76 ],
	[  5000,   5000,  12.71 ],
	[  6000,   6000,   7.84 ],
	[  7000,   7000,   7.84 ],
	[  8000,   8000,   9.60 ],
	[  9000,   9000,  28.38 ],
	[ 10000,  10000,  14.05 ],
	[ 12000,  12000,  21.18 ],
	[ 14000,  14000,  46.21 ],
	[ 16000,  16000,  42.50 ],
	[ 18000,  18000,  79.63 ],
	[ 20000,  20000,  77.40 ],
])

# numactl --interleave=all ./testing_zheevdx_2stage -JV -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zheevdx_2stage_JV = array([
	[    10,     10,    0.00 ],
	[    20,     20,    0.00 ],
	[    30,     30,    0.00 ],
	[    40,     40,    0.00 ],
	[    50,     50,    0.00 ],
	[    60,     60,    0.00 ],
	[    70,     70,    0.00 ],
	[    80,     80,    0.00 ],
	[    90,     90,    0.00 ],
	[   100,    100,    0.00 ],
	[   200,    200,    0.01 ],
	[   300,    300,    0.05 ],
	[   400,    400,    0.08 ],
	[   500,    500,    0.12 ],
	[   600,    600,    0.17 ],
	[   700,    700,    0.22 ],
	[   800,    800,    0.29 ],
	[   900,    900,    0.36 ],
	[  1000,   1000,    0.41 ],
	[  2000,   2000,    1.21 ],
	[  3000,   3000,    2.43 ],
	[  4000,   4000,    3.90 ],
	[  5000,   5000,    7.77 ],
	[  6000,   6000,   13.40 ],
	[  7000,   7000,   13.84 ],
	[  8000,   8000,   18.87 ],
	[  9000,   9000,   29.79 ],
	[ 10000,  10000,   34.73 ],
	[ 12000,  12000,   62.32 ],
	[ 14000,  14000,   88.87 ],
	[ 16000,  16000,  129.35 ],
	[ 18000,  18000,  192.90 ],
	[ 20000,  20000,     nan ],  # failed? 82.94 ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/zhemv.txt
# numactl --interleave=all ./testing_zhemv -N 100 -N 1000 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000
zhemv_L = array([
	[    10,    0.02,   0.04,   0.03,   0.03,   0.04,   0.02,   0.43,    0.00,  1.99e-16,  2.51e-16,  3.20e-16,  nan ],
	[    11,    0.03,   0.03,   0.04,   0.03,   0.05,   0.02,   0.51,    0.00,  3.61e-16,  3.33e-16,  2.28e-16,  nan ],
	[    12,    0.04,   0.03,   0.05,   0.03,   0.06,   0.02,   0.68,    0.00,  3.70e-16,  3.70e-16,  4.74e-16,  nan ],
	[    13,    0.05,   0.03,   0.06,   0.03,   0.07,   0.02,   0.79,    0.00,  1.93e-16,  3.06e-16,  1.93e-16,  nan ],
	[    14,    0.05,   0.03,   0.07,   0.03,   0.08,   0.02,   0.81,    0.00,  2.54e-16,  3.92e-16,  2.84e-16,  nan ],
	[    15,    0.06,   0.03,   0.07,   0.03,   0.08,   0.02,   1.04,    0.00,  2.65e-16,  2.65e-16,  2.65e-16,  nan ],
	[    16,    0.07,   0.03,   0.08,   0.03,   0.10,   0.02,   1.04,    0.00,  3.14e-16,  4.45e-16,  4.74e-16,  nan ],
	[    17,    0.07,   0.03,   0.09,   0.03,   0.10,   0.03,   0.81,    0.00,  4.31e-16,  4.21e-16,  4.46e-16,  nan ],
	[    18,    0.08,   0.03,   0.10,   0.03,   0.11,   0.03,   1.31,    0.00,  3.21e-16,  4.02e-16,  2.96e-16,  nan ],
	[    19,    0.09,   0.03,   0.11,   0.03,   0.13,   0.02,   1.01,    0.00,  4.67e-16,  5.91e-16,  4.41e-16,  nan ],
	[    20,    0.10,   0.03,   0.12,   0.03,   0.14,   0.03,   1.11,    0.00,  3.97e-16,  4.87e-16,  3.97e-16,  nan ],
	[    21,    0.11,   0.03,   0.13,   0.03,   0.16,   0.02,   1.32,    0.00,  5.08e-16,  3.61e-16,  4.79e-16,  nan ],
	[    22,    0.12,   0.03,   0.15,   0.03,   0.17,   0.03,   1.33,    0.00,  3.61e-16,  3.23e-16,  4.04e-16,  nan ],
	[    23,    0.13,   0.03,   0.16,   0.03,   0.18,   0.03,   1.58,    0.00,  5.36e-16,  3.45e-16,  4.37e-16,  nan ],
	[    24,    0.14,   0.03,   0.18,   0.03,   0.19,   0.03,   1.58,    0.00,  5.92e-16,  5.34e-16,  4.44e-16,  nan ],
	[    25,    0.16,   0.03,   0.19,   0.03,   0.19,   0.03,   1.31,    0.00,  3.18e-16,  3.18e-16,  3.18e-16,  nan ],
	[    26,    0.17,   0.03,   0.21,   0.03,   0.21,   0.03,   1.85,    0.00,  3.86e-16,  5.63e-16,  3.86e-16,  nan ],
	[    27,    0.18,   0.04,   0.21,   0.03,   0.23,   0.03,   1.61,    0.00,  3.72e-16,  4.00e-16,  3.72e-16,  nan ],
	[    28,    0.20,   0.03,   0.23,   0.03,   0.25,   0.03,   2.13,    0.00,  3.81e-16,  2.84e-16,  4.26e-16,  nan ],
	[    29,    0.20,   0.03,   0.24,   0.03,   0.26,   0.03,   2.28,    0.00,  3.47e-16,  3.73e-16,  3.47e-16,  nan ],
	[    30,    0.22,   0.03,   0.26,   0.03,   0.29,   0.03,   1.87,    0.00,  4.27e-16,  2.65e-16,  2.65e-16,  nan ],
	[    31,    0.24,   0.03,   0.28,   0.03,   0.30,   0.03,   1.99,    0.00,  4.90e-16,  4.73e-16,  3.05e-16,  nan ],
	[    32,    0.26,   0.03,   0.31,   0.03,   0.33,   0.03,   2.12,    0.00,  3.55e-16,  4.58e-16,  5.39e-16,  nan ],
	[    33,    0.27,   0.03,   0.23,   0.04,   0.34,   0.03,   2.39,    0.00,  3.05e-16,  3.88e-16,  4.81e-16,  nan ],
	[    34,    0.29,   0.03,   0.27,   0.04,   0.37,   0.03,   1.93,    0.01,  3.35e-16,  4.67e-16,  3.77e-16,  nan ],
	[    35,    0.28,   0.04,   0.28,   0.04,   0.38,   0.03,   2.52,    0.00,  4.06e-16,  4.19e-16,  4.19e-16,  nan ],
	[    36,    0.33,   0.03,   0.30,   0.04,   0.42,   0.03,   2.16,    0.01,  4.93e-16,  4.02e-16,  3.98e-16,  nan ],
	[    37,    0.34,   0.03,   0.30,   0.04,   0.44,   0.03,   2.81,    0.00,  4.80e-16,  4.80e-16,  3.84e-16,  nan ],
	[    38,    0.32,   0.04,   0.32,   0.04,   0.45,   0.03,   2.40,    0.01,  3.92e-16,  3.74e-16,  4.18e-16,  nan ],
	[    39,    0.38,   0.03,   0.33,   0.04,   0.49,   0.03,   2.52,    0.01,  5.15e-16,  6.57e-16,  5.83e-16,  nan ],
	[    40,    0.40,   0.03,   0.36,   0.04,   0.51,   0.03,   2.65,    0.01,  3.20e-16,  3.97e-16,  3.55e-16,  nan ],
	[    41,    0.41,   0.03,   0.39,   0.04,   0.52,   0.03,   2.78,    0.01,  4.90e-16,  5.48e-16,  5.20e-16,  nan ],
	[    42,    0.44,   0.03,   0.39,   0.04,   0.54,   0.03,   2.92,    0.01,  5.42e-16,  4.23e-16,  4.79e-16,  nan ],
	[    43,    0.45,   0.03,   0.43,   0.04,   0.59,   0.03,   2.57,    0.01,  6.61e-16,  3.69e-16,  3.41e-16,  nan ],
	[    44,    0.47,   0.03,   0.38,   0.04,   0.62,   0.03,   2.69,    0.01,  5.42e-16,  6.51e-16,  5.42e-16,  nan ],
	[    45,    0.51,   0.03,   0.44,   0.04,   0.62,   0.03,   2.81,    0.01,  4.80e-16,  4.74e-16,  5.69e-16,  nan ],
	[    46,    0.50,   0.04,   0.45,   0.04,   0.63,   0.03,   2.93,    0.01,  5.57e-16,  4.78e-16,  4.52e-16,  nan ],
	[    47,    0.52,   0.04,   0.47,   0.04,   0.65,   0.03,   3.64,    0.01,  6.76e-16,  6.76e-16,  4.78e-16,  nan ],
	[    48,    0.56,   0.03,   0.49,   0.04,   0.68,   0.03,   2.66,    0.01,  5.34e-16,  4.68e-16,  4.50e-16,  nan ],
	[    49,    0.57,   0.03,   0.51,   0.04,   0.66,   0.03,   2.52,    0.01,  5.23e-16,  5.23e-16,  4.86e-16,  nan ],
	[    50,    0.59,   0.04,   0.53,   0.04,   0.71,   0.03,   2.98,    0.01,  5.86e-16,  5.86e-16,  6.36e-16,  nan ],
	[    51,    0.61,   0.04,   0.53,   0.04,   0.74,   0.03,   2.99,    0.01,  4.67e-16,  3.12e-16,  3.94e-16,  nan ],
	[    52,    0.62,   0.04,   0.54,   0.04,   0.74,   0.03,   3.11,    0.01,  5.47e-16,  5.63e-16,  5.63e-16,  nan ],
	[    53,    0.66,   0.04,   0.58,   0.04,   0.77,   0.03,   3.34,    0.01,  5.69e-16,  5.40e-16,  4.83e-16,  nan ],
	[    54,    0.67,   0.04,   0.60,   0.04,   0.80,   0.03,   3.05,    0.01,  4.74e-16,  4.00e-16,  4.00e-16,  nan ],
	[    55,    0.71,   0.04,   0.62,   0.04,   0.83,   0.03,   3.16,    0.01,  4.09e-16,  3.93e-16,  2.89e-16,  nan ],
	[    56,    0.76,   0.03,   0.63,   0.04,   0.89,   0.03,   3.18,    0.01,  5.23e-16,  6.34e-16,  4.57e-16,  nan ],
	[    57,    0.76,   0.04,   0.65,   0.04,   0.86,   0.03,   2.94,    0.01,  5.57e-16,  5.14e-16,  3.94e-16,  nan ],
	[    58,    0.82,   0.03,   0.69,   0.04,   0.96,   0.03,   3.05,    0.01,  5.05e-16,  6.93e-16,  4.78e-16,  nan ],
	[    59,    0.79,   0.04,   0.71,   0.04,   0.99,   0.03,   2.85,    0.01,  6.02e-16,  4.97e-16,  4.85e-16,  nan ],
	[    60,    0.84,   0.04,   0.72,   0.04,   0.98,   0.03,   3.26,    0.01,  4.74e-16,  4.75e-16,  4.77e-16,  nan ],
	[    61,    0.85,   0.04,   0.74,   0.04,   1.02,   0.03,   3.05,    0.01,  5.21e-16,  4.80e-16,  4.80e-16,  nan ],
	[    62,    0.90,   0.04,   0.77,   0.04,   1.05,   0.03,   3.15,    0.01,  4.73e-16,  6.88e-16,  5.13e-16,  nan ],
	[    63,    0.93,   0.04,   0.79,   0.04,   1.08,   0.03,   3.25,    0.01,  5.64e-16,  4.07e-16,  4.07e-16,  nan ],
	[    64,    0.98,   0.03,   0.80,   0.04,   1.08,   0.03,   5.41,    0.01,  5.55e-16,  7.02e-16,  4.00e-16,  nan ],
	[    65,    0.78,   0.04,   0.82,   0.04,   1.08,   0.03,   3.92,    0.01,  4.89e-16,  4.89e-16,  4.89e-16,  nan ],
	[    66,    0.81,   0.04,   0.85,   0.04,   1.12,   0.03,   3.56,    0.01,  6.55e-16,  4.44e-16,  5.62e-16,  nan ],
	[    67,    0.81,   0.05,   0.86,   0.04,   0.97,   0.04,   3.08,    0.01,  4.53e-16,  5.00e-16,  7.65e-16,  nan ],
	[    68,    0.88,   0.04,   0.80,   0.05,   1.18,   0.03,   4.17,    0.01,  7.53e-16,  5.22e-16,  5.22e-16,  nan ],
	[    69,    0.93,   0.04,   0.95,   0.04,   1.21,   0.03,   3.89,    0.01,  6.26e-16,  6.26e-16,  6.18e-16,  nan ],
	[    70,    0.95,   0.04,   0.95,   0.04,   0.95,   0.04,   3.65,    0.01,  6.11e-16,  6.42e-16,  8.18e-16,  nan ],
	[    71,    0.95,   0.04,   0.95,   0.04,   1.33,   0.03,   3.75,    0.01,  8.01e-16,  1.00e-15,  8.01e-16,  nan ],
	[    72,    0.99,   0.04,   1.01,   0.04,   1.29,   0.03,   3.48,    0.01,  7.12e-16,  4.41e-16,  8.83e-16,  nan ],
	[    73,    0.99,   0.04,   1.04,   0.04,   1.36,   0.03,   3.65,    0.01,  6.16e-16,  7.79e-16,  8.03e-16,  nan ],
	[    74,    1.04,   0.04,   1.07,   0.04,   1.40,   0.03,   3.68,    0.01,  6.44e-16,  9.06e-16,  6.92e-16,  nan ],
	[    75,    1.05,   0.04,   1.06,   0.04,   1.44,   0.03,   3.85,    0.01,  5.36e-16,  6.36e-16,  5.10e-16,  nan ],
	[    76,    1.10,   0.04,   1.09,   0.04,   1.42,   0.03,   3.95,    0.01,  6.27e-16,  5.69e-16,  5.63e-16,  nan ],
	[    77,    1.10,   0.04,   1.13,   0.04,   1.43,   0.03,   4.06,    0.01,  5.61e-16,  4.61e-16,  4.61e-16,  nan ],
	[    78,    1.13,   0.04,   1.16,   0.04,   1.51,   0.03,   4.16,    0.01,  8.59e-16,  7.78e-16,  6.11e-16,  nan ],
	[    79,    1.15,   0.04,   1.19,   0.04,   1.55,   0.03,   4.27,    0.01,  7.42e-16,  7.68e-16,  9.17e-16,  nan ],
	[    80,    1.18,   0.04,   1.22,   0.04,   1.57,   0.03,   4.38,    0.01,  5.40e-16,  9.06e-16,  9.06e-16,  nan ],
	[    81,    1.21,   0.04,   1.21,   0.04,   1.57,   0.03,   4.48,    0.01,  6.85e-16,  5.34e-16,  5.62e-16,  nan ],
	[    82,    1.28,   0.04,   1.17,   0.05,   1.65,   0.03,   4.25,    0.01,  7.35e-16,  5.48e-16,  6.25e-16,  nan ],
	[    83,    1.25,   0.04,   1.25,   0.04,   1.60,   0.04,   3.99,    0.01,  6.69e-16,  6.17e-16,  7.66e-16,  nan ],
	[    84,    1.31,   0.04,   1.30,   0.04,   1.64,   0.04,   4.08,    0.01,  9.11e-16,  6.10e-16,  5.35e-16,  nan ],
	[    85,    1.31,   0.05,   1.28,   0.05,   1.74,   0.03,   4.57,    0.01,  8.52e-16,  7.14e-16,  8.52e-16,  nan ],
	[    86,    1.34,   0.05,   1.36,   0.04,   1.77,   0.03,   4.59,    0.01,  7.01e-16,  7.39e-16,  6.81e-16,  nan ],
	[    87,    1.40,   0.04,   1.37,   0.04,   1.81,   0.03,   4.70,    0.01,  6.93e-16,  5.89e-16,  5.89e-16,  nan ],
	[    88,    1.43,   0.04,   1.43,   0.04,   1.86,   0.03,   4.19,    0.02,  5.82e-16,  5.42e-16,  6.51e-16,  nan ],
	[    89,    1.47,   0.04,   1.40,   0.05,   1.84,   0.04,   4.29,    0.02,  5.76e-16,  6.77e-16,  6.82e-16,  nan ],
	[    90,    1.49,   0.04,   1.46,   0.05,   1.88,   0.04,   4.68,    0.01,  7.93e-16,  9.60e-16,  7.93e-16,  nan ],
	[   100,    1.88,   0.04,   1.77,   0.05,   2.33,   0.03,   5.08,    0.02,  7.65e-16,  7.42e-16,  6.07e-16,  nan ],
	[   110,    2.22,   0.04,   2.13,   0.05,   2.80,   0.04,   5.49,    0.02,  7.86e-16,  7.31e-16,  6.46e-16,  nan ],
	[   120,    2.53,   0.05,   2.47,   0.05,   3.16,   0.04,   5.82,    0.02,  6.70e-16,  8.34e-16,  7.49e-16,  nan ],
	[   130,    2.58,   0.05,   2.68,   0.05,   3.52,   0.04,   6.23,    0.02,  7.88e-16,  9.16e-16,  9.28e-16,  nan ],
	[   140,    2.98,   0.05,   3.11,   0.05,   3.86,   0.04,   6.65,    0.02,  8.37e-16,  8.67e-16,  7.32e-16,  nan ],
	[   150,    3.30,   0.06,   3.42,   0.05,   4.33,   0.04,   7.00,    0.03,  8.47e-16,  7.64e-16,  8.47e-16,  nan ],
	[   160,    3.77,   0.05,   4.05,   0.05,   4.93,   0.04,   7.67,    0.03,  7.59e-16,  9.10e-16,  7.19e-16,  nan ],
	[   170,    4.23,   0.06,   4.16,   0.06,   5.29,   0.04,   7.53,    0.03,  1.00e-15,  8.52e-16,  8.52e-16,  nan ],
	[   180,    4.83,   0.05,   4.66,   0.06,   5.32,   0.05,   7.67,    0.03,  1.11e-15,  8.24e-16,  9.87e-16,  nan ],
	[   190,    5.29,   0.06,   5.11,   0.06,   6.46,   0.05,   8.09,    0.04,  8.72e-16,  6.69e-16,  7.48e-16,  nan ],
	[   200,    5.05,   0.06,   5.39,   0.06,   6.73,   0.05,   8.45,    0.04,  9.53e-16,  9.10e-16,  8.64e-16,  nan ],
	[   210,    5.56,   0.06,   5.82,   0.06,   7.27,   0.05,   8.66,    0.04,  1.03e-15,  1.22e-15,  1.08e-15,  nan ],
	[   220,    6.08,   0.06,   6.39,   0.06,   7.82,   0.05,   8.65,    0.05,  9.32e-16,  1.19e-15,  1.04e-15,  nan ],
	[   230,    6.54,   0.07,   6.77,   0.06,   8.20,   0.05,   8.72,    0.05,  1.11e-15,  1.04e-15,  9.91e-16,  nan ],
	[   240,    7.26,   0.06,   7.37,   0.06,   9.13,   0.05,   8.76,    0.05,  1.12e-15,  1.38e-15,  1.39e-15,  nan ],
	[   250,    7.62,   0.07,   7.62,   0.07,   9.13,   0.06,   9.13,    0.06,  1.14e-15,  1.16e-15,  1.02e-15,  nan ],
	[   260,    7.36,   0.07,   8.12,   0.07,   9.71,   0.06,   9.24,    0.06,  1.10e-15,  1.03e-15,  1.14e-15,  nan ],
	[   270,    8.04,   0.07,   8.51,   0.07,  10.29,   0.06,   9.32,    0.06,  1.13e-15,  1.23e-15,  1.13e-15,  nan ],
	[   280,    8.64,   0.07,   9.25,   0.07,  10.71,   0.06,   9.55,    0.07,  1.06e-15,  1.08e-15,  1.02e-15,  nan ],
	[   290,    9.03,   0.07,   9.52,   0.07,  11.08,   0.06,   9.55,    0.07,  1.57e-15,  1.39e-15,  1.57e-15,  nan ],
	[   300,    9.40,   0.08,   9.92,   0.07,  11.67,   0.06,   9.92,    0.07,  1.33e-15,  1.33e-15,  1.33e-15,  nan ],
	[   310,   10.32,   0.07,  10.59,   0.07,  12.27,   0.06,   9.64,    0.08,  1.65e-15,  1.54e-15,  1.51e-15,  nan ],
	[   320,   10.82,   0.08,  11.10,   0.07,  12.64,   0.07,  10.04,    0.08,  1.79e-15,  1.97e-15,  1.96e-15,  nan ],
	[   330,   10.40,   0.08,  11.36,   0.08,  13.06,   0.07,   9.84,    0.09,  1.22e-15,  1.25e-15,  1.12e-15,  nan ],
	[   340,   11.33,   0.08,  12.06,   0.08,  13.67,   0.07,  10.20,    0.09,  1.35e-15,  1.40e-15,  1.24e-15,  nan ],
	[   350,   11.56,   0.09,  12.32,   0.08,  14.09,   0.07,   9.95,    0.10,  1.32e-15,  1.32e-15,  1.30e-15,  nan ],
	[   360,   12.13,   0.09,  12.55,   0.08,  14.46,   0.07,   9.73,    0.11,  1.59e-15,  1.43e-15,  1.61e-15,  nan ],
	[   370,   12.64,   0.09,  13.25,   0.08,  15.27,   0.07,  10.09,    0.11,  1.55e-15,  1.38e-15,  1.24e-15,  nan ],
	[   380,   13.04,   0.09,  13.63,   0.09,  15.69,   0.07,   9.91,    0.12,  1.50e-15,  1.50e-15,  1.35e-15,  nan ],
	[   390,   12.87,   0.09,  14.19,   0.09,  15.62,   0.08,   9.93,    0.12,  1.46e-15,  1.61e-15,  1.49e-15,  nan ],
	[   400,   12.95,   0.10,  14.45,   0.09,  15.85,   0.08,  10.13,    0.13,  1.53e-15,  1.37e-15,  1.48e-15,  nan ],
	[   410,   13.77,   0.10,  14.98,   0.09,  17.10,   0.08,  10.15,    0.13,  1.45e-15,  1.37e-15,  1.19e-15,  nan ],
	[   420,   14.01,   0.10,  15.23,   0.09,  17.73,   0.08,  10.12,    0.14,  1.64e-15,  1.70e-15,  1.67e-15,  nan ],
	[   430,   14.55,   0.10,  15.64,   0.09,  18.53,   0.08,  10.03,    0.15,  1.72e-15,  1.77e-15,  1.80e-15,  nan ],
	[   440,   14.95,   0.10,  16.38,   0.09,  19.00,   0.08,  10.15,    0.15,  1.40e-15,  1.51e-15,  1.37e-15,  nan ],
	[   450,   14.79,   0.11,  16.75,   0.10,  19.37,   0.08,  10.04,    0.16,  1.58e-15,  1.54e-15,  1.52e-15,  nan ],
	[   460,   15.19,   0.11,  17.16,   0.10,  19.73,   0.09,  10.18,    0.17,  1.29e-15,  1.26e-15,  1.36e-15,  nan ],
	[   470,   15.56,   0.11,  17.37,   0.10,  20.37,   0.09,  10.37,    0.17,  1.94e-15,  1.85e-15,  1.88e-15,  nan ],
	[   480,   16.09,   0.11,  18.29,   0.10,  21.25,   0.09,  10.45,    0.18,  1.59e-15,  1.76e-15,  1.95e-15,  nan ],
	[   490,   16.59,   0.12,  18.53,   0.10,  20.72,   0.09,   9.98,    0.19,  2.79e-15,  2.35e-15,  2.81e-15,  nan ],
	[   500,   17.00,   0.12,  18.57,   0.11,  21.35,   0.09,  10.12,    0.20,  1.89e-15,  1.82e-15,  1.82e-15,  nan ],
	[   510,   17.83,   0.12,  19.32,   0.11,  21.99,   0.09,   9.62,    0.22,  1.79e-15,  2.01e-15,  1.79e-15,  nan ],
	[   520,   17.23,   0.13,  19.53,   0.11,  22.36,   0.10,  10.19,    0.21,  1.96e-15,  1.63e-15,  1.63e-15,  nan ],
	[   530,   17.60,   0.13,  20.50,   0.11,  23.00,   0.10,  10.30,    0.22,  2.21e-15,  2.03e-15,  2.19e-15,  nan ],
	[   540,   18.27,   0.13,  20.88,   0.11,  23.42,   0.10,  10.45,    0.22,  1.99e-15,  1.91e-15,  1.70e-15,  nan ],
	[   550,   18.99,   0.13,  21.29,   0.11,  24.00,   0.10,  10.42,    0.23,  1.68e-15,  1.89e-15,  1.67e-15,  nan ],
	[   560,   19.22,   0.13,  22.07,   0.11,  25.18,   0.10,  10.39,    0.24,  1.82e-15,  1.69e-15,  1.91e-15,  nan ],
	[   570,   19.91,   0.13,  22.49,   0.12,  25.07,   0.10,  10.30,    0.25,  1.88e-15,  2.01e-15,  1.78e-15,  nan ],
	[   580,   19.41,   0.14,  22.68,   0.12,  25.66,   0.11,  10.26,    0.26,  2.23e-15,  2.40e-15,  2.02e-15,  nan ],
	[   590,   19.81,   0.14,  23.28,   0.12,  26.08,   0.11,  10.50,    0.27,  2.50e-15,  2.51e-15,  2.52e-15,  nan ],
	[   600,   20.49,   0.14,  24.03,   0.12,  26.73,   0.11,  10.49,    0.28,  1.84e-15,  1.75e-15,  1.84e-15,  nan ],
	[   610,   20.72,   0.14,  24.07,   0.12,  27.09,   0.11,  10.44,    0.29,  2.13e-15,  2.67e-15,  2.71e-15,  nan ],
	[   620,   20.96,   0.15,  24.49,   0.13,  27.05,   0.11,  10.52,    0.29,  2.39e-15,  2.20e-15,  2.42e-15,  nan ],
	[   630,   21.96,   0.14,  25.05,   0.13,  28.46,   0.11,  10.33,    0.31,  1.95e-15,  2.04e-15,  2.04e-15,  nan ],
	[   640,   22.47,   0.15,  26.09,   0.13,  29.06,   0.11,  10.70,    0.31,  2.18e-15,  2.39e-15,  2.22e-15,  nan ],
	[   650,   22.00,   0.15,  25.84,   0.13,  29.48,   0.11,  10.46,    0.32,  2.28e-15,  2.31e-15,  2.32e-15,  nan ],
	[   660,   22.40,   0.16,  26.30,   0.13,  29.90,   0.12,  10.55,    0.33,  2.10e-15,  2.10e-15,  1.78e-15,  nan ],
	[   670,   23.08,   0.16,  26.86,   0.13,  30.50,   0.12,  10.68,    0.34,  2.04e-15,  2.06e-15,  2.10e-15,  nan ],
	[   680,   23.17,   0.16,  27.28,   0.14,  31.41,   0.12,  10.59,    0.35,  2.36e-15,  2.34e-15,  2.21e-15,  nan ],
	[   690,   23.68,   0.16,  27.84,   0.14,  31.03,   0.12,  10.46,    0.37,  2.49e-15,  2.48e-15,  2.33e-15,  nan ],
	[   700,   24.23,   0.16,  28.26,   0.14,  31.93,   0.12,  10.59,    0.37,  2.77e-15,  2.44e-15,  2.28e-15,  nan ],
	[   710,   24.64,   0.16,  28.88,   0.14,  32.60,   0.12,  10.57,    0.38,  2.25e-15,  2.40e-15,  2.40e-15,  nan ],
	[   720,   24.72,   0.17,  29.49,   0.14,  33.26,   0.12,  10.63,    0.39,  2.08e-15,  1.90e-15,  1.95e-15,  nan ],
	[   730,   25.60,   0.17,  30.06,   0.14,  32.11,   0.13,  10.55,    0.41,  1.99e-15,  1.85e-15,  2.03e-15,  nan ],
	[   740,   25.68,   0.17,  30.04,   0.15,  32.76,   0.13,  10.50,    0.42,  2.16e-15,  2.16e-15,  2.00e-15,  nan ],
	[   750,   25.63,   0.18,  30.90,   0.15,  33.41,   0.13,  10.66,    0.42,  2.04e-15,  2.13e-15,  2.11e-15,  nan ],
	[   760,   26.46,   0.17,  31.27,   0.15,  34.07,   0.14,  10.40,    0.45,  2.70e-15,  2.25e-15,  2.29e-15,  nan ],
	[   770,   27.31,   0.17,  31.69,   0.15,  34.19,   0.14,  10.51,    0.45,  2.44e-15,  2.38e-15,  2.06e-15,  nan ],
	[   780,   27.57,   0.18,  32.31,   0.15,  35.08,   0.14,  10.77,    0.45,  2.60e-15,  2.21e-15,  2.21e-15,  nan ],
	[   790,   28.09,   0.18,  32.48,   0.15,  35.44,   0.14,  10.69,    0.47,  2.00e-15,  2.19e-15,  2.25e-15,  nan ],
	[   800,   28.20,   0.18,  33.51,   0.15,  36.10,   0.14,  10.73,    0.48,  2.11e-15,  2.15e-15,  2.01e-15,  nan ],
	[   810,   28.42,   0.19,  33.47,   0.16,  36.76,   0.14,  10.71,    0.49,  2.16e-15,  1.98e-15,  2.11e-15,  nan ],
	[   820,   29.28,   0.18,  34.35,   0.16,  36.87,   0.15,  10.63,    0.51,  2.23e-15,  2.21e-15,  2.10e-15,  nan ],
	[   830,   29.69,   0.19,  34.93,   0.16,  37.84,   0.15,  10.70,    0.52,  2.17e-15,  2.30e-15,  2.43e-15,  nan ],
	[   840,   29.32,   0.19,  35.09,   0.16,  37.71,   0.15,  10.73,    0.53,  2.00e-15,  2.19e-15,  2.10e-15,  nan ],
	[   850,   29.98,   0.19,  35.30,   0.16,  37.59,   0.15,  10.70,    0.54,  2.78e-15,  2.56e-15,  2.56e-15,  nan ],
	[   860,   30.10,   0.20,  36.13,   0.16,  38.19,   0.16,  10.55,    0.56,  2.25e-15,  2.66e-15,  2.31e-15,  nan ],
	[   870,   31.25,   0.19,  36.50,   0.17,  39.44,   0.15,  10.55,    0.58,  2.03e-15,  2.28e-15,  2.03e-15,  nan ],
	[   880,   31.02,   0.20,  37.61,   0.16,  40.54,   0.15,  10.68,    0.58,  2.34e-15,  2.34e-15,  2.33e-15,  nan ],
	[   890,   31.25,   0.20,  37.82,   0.17,  40.16,   0.16,  10.63,    0.60,  2.43e-15,  2.33e-15,  2.31e-15,  nan ],
	[   900,   31.69,   0.20,  37.09,   0.17,  40.09,   0.16,  10.59,    0.61,  2.84e-15,  2.38e-15,  2.49e-15,  nan ],
	[  1000,   34.54,   0.23,  41.69,   0.19,  43.31,   0.19,  10.06,    0.80,  3.31e-15,  2.96e-15,  3.23e-15,  nan ],
	[  1100,   36.99,   0.26,  45.94,   0.21,  27.54,   0.35,  10.19,    0.95,  3.19e-15,  3.24e-15,  3.24e-15,  nan ],
	[  1200,   41.35,   0.28,  50.19,   0.23,  29.20,   0.40,   9.13,    1.26,  3.04e-15,  3.44e-15,  3.22e-15,  nan ],
	[  1300,   44.99,   0.30,  54.12,   0.25,  30.56,   0.44,   8.54,    1.59,  3.33e-15,  3.15e-15,  3.33e-15,  nan ],
	[  1400,   48.45,   0.32,  59.64,   0.26,  33.83,   0.46,   8.15,    1.93,  3.45e-15,  4.07e-15,  3.90e-15,  nan ],
	[  1500,   51.94,   0.35,  63.88,   0.28,  37.01,   0.49,   8.03,    2.24,  3.54e-15,  2.77e-15,  3.04e-15,  nan ],
	[  1600,   55.69,   0.37,  69.28,   0.30,  38.18,   0.54,   8.06,    2.54,  3.14e-15,  3.04e-15,  2.99e-15,  nan ],
	[  1700,   59.18,   0.39,  73.70,   0.31,  39.36,   0.59,   8.16,    2.84,  3.76e-15,  3.66e-15,  3.13e-15,  nan ],
	[  1800,   63.11,   0.41,  74.99,   0.35,  42.89,   0.60,   7.64,    3.40,  3.33e-15,  3.62e-15,  3.54e-15,  nan ],
	[  1900,   64.93,   0.45,  77.07,   0.38,  43.39,   0.67,   8.07,    3.58,  5.07e-15,  5.00e-15,  4.77e-15,  nan ],
	[  2000,   64.83,   0.49,  76.97,   0.42,  45.75,   0.70,   7.93,    4.04,  3.93e-15,  4.00e-15,  3.50e-15,  nan ],
	[  2100,   65.99,   0.54,  77.94,   0.45,  34.88,   1.01,   8.05,    4.38,  3.76e-15,  3.51e-15,  3.78e-15,  nan ],
	[  2200,   66.80,   0.58,  77.94,   0.50,  36.94,   1.05,   8.05,    4.81,  4.15e-15,  4.37e-15,  4.18e-15,  nan ],
	[  2300,   68.53,   0.62,  78.56,   0.54,  38.26,   1.11,   7.58,    5.59,  4.35e-15,  4.95e-15,  4.35e-15,  nan ],
	[  2400,   69.97,   0.66,  79.36,   0.58,  40.23,   1.15,   8.08,    5.71,  5.39e-15,  5.73e-15,  5.86e-15,  nan ],
	[  2500,   70.56,   0.71,  78.18,   0.64,  40.61,   1.23,   8.12,    6.16,  5.28e-15,  5.28e-15,  5.09e-15,  nan ],
	[  2600,   71.57,   0.76,  78.75,   0.69,  41.03,   1.32,   8.13,    6.65,  5.84e-15,  4.69e-15,  5.07e-15,  nan ],
	[  2700,   74.05,   0.79,  78.75,   0.74,  43.29,   1.35,   8.12,    7.18,  4.90e-15,  4.24e-15,  4.48e-15,  nan ],
	[  2800,   74.80,   0.84,  80.34,   0.78,  39.59,   1.59,   8.50,    7.39,  6.08e-15,  5.87e-15,  5.38e-15,  nan ],
	[  2900,   75.31,   0.89,  81.51,   0.83,  45.86,   1.47,   8.19,    8.22,  4.26e-15,  4.58e-15,  4.71e-15,  nan ],
	[  3000,   76.39,   0.94,  82.51,   0.87,  46.48,   1.55,   8.21,    8.77,  5.07e-15,  4.46e-15,  5.07e-15,  nan ],
	[  3100,   78.49,   0.98,  83.60,   0.92,  38.79,   1.98,   8.04,    9.56,  4.85e-15,  5.16e-15,  4.86e-15,  nan ],
	[  3200,   80.20,   1.02,  84.67,   0.97,  40.92,   2.00,   8.91,    9.20,  5.78e-15,  5.55e-15,  5.52e-15,  nan ],
	[  3300,   81.77,   1.07,  85.04,   1.02,  41.54,   2.10,   8.15,   10.70,  5.83e-15,  6.03e-15,  5.92e-15,  nan ],
	[  3400,   82.83,   1.12,  85.97,   1.08,  42.48,   2.18,   8.25,   11.21,  6.40e-15,  5.89e-15,  5.98e-15,  nan ],
	[  3500,   83.94,   1.17,  87.46,   1.12,  43.11,   2.27,   8.14,   12.05,  5.33e-15,  4.88e-15,  4.68e-15,  nan ],
	[  3600,   85.88,   1.21,  87.75,   1.18,  44.67,   2.32,   8.00,   12.96,  4.98e-15,  5.08e-15,  5.40e-15,  nan ],
	[  3700,   87.38,   1.25,  87.93,   1.25,  44.90,   2.44,   8.07,   13.58,  7.14e-15,  6.15e-15,  6.22e-15,  nan ],
	[  3800,   88.42,   1.31,  88.42,   1.31,  45.78,   2.52,   8.18,   14.13,  4.79e-15,  5.35e-15,  5.03e-15,  nan ],
	[  3900,   88.09,   1.38,  88.47,   1.38,  46.87,   2.60,   8.04,   15.13,  6.18e-15,  6.43e-15,  5.37e-15,  nan ],
	[  4000,   88.26,   1.45,  88.92,   1.44,  46.94,   2.73,   8.06,   15.88,  8.13e-15,  7.03e-15,  7.16e-15,  nan ],
	[  4100,   87.54,   1.54,  88.57,   1.52,  39.51,   3.40,   7.61,   17.67,  6.49e-15,  6.29e-15,  6.55e-15,  nan ],
	[  4200,   87.68,   1.61,  89.24,   1.58,  41.74,   3.38,   8.07,   17.50,  7.64e-15,  7.16e-15,  7.00e-15,  nan ],
	[  4300,   90.39,   1.64,  88.60,   1.67,  42.62,   3.47,   8.06,   18.35,  6.87e-15,  7.02e-15,  7.44e-15,  nan ],
	[  4400,   90.08,   1.72,  88.84,   1.74,  43.48,   3.56,   8.13,   19.06,  6.15e-15,  6.33e-15,  6.46e-15,  nan ],
	[  4500,   90.58,   1.79,  88.56,   1.83,  44.45,   3.65,   8.11,   19.97,  6.38e-15,  6.61e-15,  6.14e-15,  nan ],
	[  4600,   90.56,   1.87,  89.55,   1.89,  46.34,   3.65,   8.03,   21.09,  7.94e-15,  7.22e-15,  6.93e-15,  nan ],
	[  4700,   92.46,   1.91,  89.33,   1.98,  45.95,   3.85,   8.21,   21.52,  6.17e-15,  6.62e-15,  6.39e-15,  nan ],
	[  4800,   92.20,   2.00,  89.72,   2.05,  46.24,   3.99,   8.26,   22.33,  7.29e-15,  6.77e-15,  6.41e-15,  nan ],
	[  4900,   91.67,   2.10,  89.74,   2.14,  46.43,   4.14,   8.21,   23.40,  8.60e-15,  7.83e-15,  7.27e-15,  nan ],
	[  5000,   93.14,   2.15,  90.20,   2.22,  48.00,   4.17,   8.30,   24.12,  7.46e-15,  6.79e-15,  6.79e-15,  nan ],
	[  5100,   93.00,   2.24,  90.65,   2.30,  47.91,   4.34,   8.18,   25.46,  8.21e-15,  7.87e-15,  7.52e-15,  nan ],
	[  5200,   94.98,   2.28,  91.54,   2.36,  43.71,   4.95,   8.25,   26.22,  7.62e-15,  8.81e-15,  8.15e-15,  nan ],
	[  5300,   95.33,   2.36,  91.78,   2.45,  42.96,   5.23,   8.27,   27.19,  8.09e-15,  7.39e-15,  7.59e-15,  nan ],
	[  5400,   96.39,   2.42,  91.76,   2.54,  44.58,   5.23,   8.25,   28.29,  7.52e-15,  7.13e-15,  7.19e-15,  nan ],
	[  5500,   96.29,   2.51,  91.66,   2.64,  44.19,   5.48,   8.23,   29.43,  7.80e-15,  7.50e-15,  7.36e-15,  nan ],
	[  5600,   98.64,   2.54,  91.12,   2.75,  45.78,   5.48,   8.19,   30.65,  6.73e-15,  6.82e-15,  8.45e-15,  nan ],
	[  5700,   98.48,   2.64,  91.51,   2.84,  46.16,   5.63,   8.28,   31.39,  7.51e-15,  7.66e-15,  7.82e-15,  nan ],
	[  5800,   97.70,   2.76,  92.06,   2.92,  46.38,   5.80,   8.23,   32.70,  9.77e-15,  9.50e-15,  8.95e-15,  nan ],
	[  5900,   97.67,   2.85,  91.81,   3.03,  47.49,   5.86,   8.26,   33.72,  7.59e-15,  6.96e-15,  7.12e-15,  nan ],
	[  6000,   98.05,   2.94,  92.96,   3.10,  47.83,   6.02,   8.32,   34.61,  7.65e-15,  8.34e-15,  9.07e-15,  nan ],
	[  6100,   98.17,   3.03,  92.24,   3.23,  48.99,   6.08,   8.31,   35.85,  8.56e-15,  8.41e-15,  7.94e-15,  nan ],
	[  6200,   98.59,   3.12,  93.38,   3.29,  43.81,   7.02,   8.36,   36.79,  8.77e-15,  7.33e-15,  7.28e-15,  nan ],
	[  6300,   99.13,   3.20,  92.40,   3.44,  44.97,   7.06,   8.27,   38.41,  7.80e-15,  7.06e-15,  7.78e-15,  nan ],
	[  6400,   99.08,   3.31,  91.68,   3.58,  45.33,   7.23,   8.65,   37.89,  7.25e-15,  7.02e-15,  6.61e-15,  nan ],
	[  6500,  100.11,   3.38,  91.25,   3.70,  45.30,   7.46,   8.20,   41.21,  8.65e-15,  8.89e-15,  8.58e-15,  nan ],
	[  6600,  100.40,   3.47,  92.43,   3.77,  45.77,   7.61,   8.28,   42.10,  7.22e-15,  7.57e-15,  7.52e-15,  nan ],
	[  6700,   99.78,   3.60,  92.82,   3.87,  46.07,   7.80,   8.29,   43.32,  8.01e-15,  9.00e-15,  9.25e-15,  nan ],
	[  6800,   99.39,   3.72,  92.73,   3.99,  46.69,   7.92,   8.27,   44.73,  9.13e-15,  8.55e-15,  8.73e-15,  nan ],
	[  6900,  100.73,   3.78,  92.74,   4.11,  47.35,   8.05,   8.21,   46.43,  8.09e-15,  8.61e-15,  7.79e-15,  nan ],
	[  7000,  100.84,   3.89,  93.11,   4.21,  47.54,   8.25,   8.21,   47.76,  7.82e-15,  7.37e-15,  7.67e-15,  nan ],
	[  7100,   99.84,   4.04,  93.37,   4.32,  47.84,   8.43,   8.20,   49.20,  8.14e-15,  8.94e-15,  7.90e-15,  nan ],
	[  7200,  101.89,   4.07,  92.65,   4.48,  44.65,   9.29,   8.11,   51.14,  7.41e-15,  8.43e-15,  7.95e-15,  nan ],
	[  7300,  102.90,   4.14,  93.53,   4.56,  45.21,   9.43,   7.83,   54.49,  7.77e-15,  7.85e-15,  7.38e-15,  nan ],
	[  7400,  103.07,   4.25,  93.19,   4.70,  44.39,   9.87,   8.10,   54.12,  7.64e-15,  7.63e-15,  7.50e-15,  nan ],
	[  7500,  103.78,   4.34,  93.38,   4.82,  44.83,  10.04,   8.06,   55.81,  8.62e-15,  8.71e-15,  8.94e-15,  nan ],
	[  7600,  104.38,   4.43,  93.05,   4.97,  46.23,  10.00,   8.06,   57.31,  7.76e-15,  8.67e-15,  7.84e-15,  nan ],
	[  7700,  102.68,   4.62,  93.19,   5.09,  46.07,  10.30,   7.96,   59.63,  9.77e-15,  1.01e-14,  1.06e-14,  nan ],
	[  7800,  101.95,   4.77,  93.65,   5.20,  47.36,  10.28,   7.59,   64.14,  8.48e-15,  8.56e-15,  8.45e-15,  nan ],
	[  7900,  102.61,   4.87,  93.34,   5.35,  46.65,  10.70,   7.64,   65.33,  8.30e-15,  9.71e-15,  9.05e-15,  nan ],
	[  8000,  103.35,   4.96,  93.16,   5.50,  47.09,  10.87,   7.65,   66.92,  8.46e-15,  9.30e-15,  9.18e-15,  nan ],
	[  8100,  104.35,   5.03,  93.18,   5.63,  49.08,  10.70,   7.52,   69.77,  8.61e-15,  8.64e-15,  8.83e-15,  nan ],
	[  8200,  103.67,   5.19,  93.29,   5.77,  44.70,  12.03,   7.38,   72.85,  8.71e-15,  8.97e-15,  9.21e-15,  nan ],
	[  8300,  104.18,   5.29,  93.90,   5.87,  44.89,  12.28,   7.23,   76.22,  1.17e-14,  9.67e-15,  9.54e-15,  nan ],
	[  8400,  103.72,   5.44,  93.89,   6.01,  45.40,  12.44,   7.57,   74.62,  8.88e-15,  9.15e-15,  9.60e-15,  nan ],
	[  8500,  104.73,   5.52,  94.11,   6.14,  46.10,  12.54,   7.56,   76.49,  8.81e-15,  8.94e-15,  9.20e-15,  nan ],
	[  8600,  104.69,   5.65,  93.44,   6.33,  46.63,  12.69,   7.68,   77.06,  9.75e-15,  8.71e-15,  8.47e-15,  nan ],
	[  8700,  104.08,   5.82,  94.11,   6.44,  45.88,  13.20,   7.58,   79.86,  1.13e-14,  1.08e-14,  1.11e-14,  nan ],
	[  8800,  105.29,   5.89,  92.63,   6.69,  46.99,  13.19,   7.94,   78.02,  1.13e-14,  1.15e-14,  1.21e-14,  nan ],
	[  8900,  104.76,   6.05,  94.02,   6.74,  47.11,  13.45,   8.07,   78.49,  1.01e-14,  1.07e-14,  1.08e-14,  nan ],
	[  9000,  105.59,   6.14,  93.91,   6.90,  47.81,  13.56,   8.07,   80.27,  1.03e-14,  1.01e-14,  1.04e-14,  nan ],
	[ 10000,  106.73,   7.50,  94.46,   8.47,  47.55,  16.83,   8.32,   96.18,  1.04e-14,  1.00e-14,  9.42e-15,  nan ],
	[ 12000,  110.05,  10.47,  93.66,  12.30,  47.63,  24.19,   8.33,  138.30,  1.17e-14,  1.09e-14,  1.15e-14,  nan ],
	[ 14000,  108.69,  14.43,  95.17,  16.48,  47.84,  32.78,   8.44,  185.73,  1.12e-14,  1.11e-14,  1.25e-14,  nan ],
	[ 16000,  112.98,  18.13,  94.16,  21.75,  47.26,  43.34,   8.73,  234.66,  1.50e-14,  1.39e-14,  1.40e-14,  nan ],
	[ 18000,  108.58,  23.87,  94.99,  27.29,  47.51,  54.56,   8.32,  311.52,  1.40e-14,  1.48e-14,  1.44e-14,  nan ],
	[ 20000,  110.06,  29.08,  94.10,  34.01,  47.06,  68.01,   8.39,  381.24,  1.77e-14,  1.88e-14,  1.89e-14,  nan ],
])

# ------------------------------------------------------------
# file: v1.5.0/cuda7.0-k40c/zpotrf.txt
# numactl --interleave=all ./testing_zpotrf -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zpotrf = array([
	[    10,  nan,  nan,     0.01,  0.00,  nan ],
	[    20,  nan,  nan,     0.04,  0.00,  nan ],
	[    30,  nan,  nan,     0.13,  0.00,  nan ],
	[    40,  nan,  nan,     1.41,  0.00,  nan ],
	[    50,  nan,  nan,     2.36,  0.00,  nan ],
	[    60,  nan,  nan,     3.28,  0.00,  nan ],
	[    70,  nan,  nan,     1.25,  0.00,  nan ],
	[    80,  nan,  nan,     1.66,  0.00,  nan ],
	[    90,  nan,  nan,     2.16,  0.00,  nan ],
	[   100,  nan,  nan,     2.60,  0.00,  nan ],
	[   200,  nan,  nan,    14.62,  0.00,  nan ],
	[   300,  nan,  nan,    12.69,  0.00,  nan ],
	[   400,  nan,  nan,    27.16,  0.00,  nan ],
	[   500,  nan,  nan,    43.15,  0.00,  nan ],
	[   600,  nan,  nan,    51.60,  0.01,  nan ],
	[   700,  nan,  nan,    72.09,  0.01,  nan ],
	[   800,  nan,  nan,    76.18,  0.01,  nan ],
	[   900,  nan,  nan,   102.64,  0.01,  nan ],
	[  1000,  nan,  nan,   131.67,  0.01,  nan ],
	[  2000,  nan,  nan,   382.35,  0.03,  nan ],
	[  3000,  nan,  nan,   556.76,  0.06,  nan ],
	[  4000,  nan,  nan,   679.48,  0.13,  nan ],
	[  5000,  nan,  nan,   744.86,  0.22,  nan ],
	[  6000,  nan,  nan,   818.34,  0.35,  nan ],
	[  7000,  nan,  nan,   862.40,  0.53,  nan ],
	[  8000,  nan,  nan,   926.74,  0.74,  nan ],
	[  9000,  nan,  nan,   955.35,  1.02,  nan ],
	[ 10000,  nan,  nan,   985.20,  1.35,  nan ],
	[ 12000,  nan,  nan,  1035.49,  2.23,  nan ],
	[ 14000,  nan,  nan,  1061.16,  3.45,  nan ],
	[ 16000,  nan,  nan,  1051.81,  5.19,  nan ],
	[ 18000,  nan,  nan,  1049.16,  7.41,  nan ],
	[ 20000,  nan,  nan,  1074.26,  9.93,  nan ],
])

# numactl --interleave=all ./testing_zpotrf_gpu -N 100 -N 1000 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zpotrf_gpu = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.01,  0.00,  nan ],
	[    30,  nan,  nan,     0.05,  0.00,  nan ],
	[    40,  nan,  nan,     0.10,  0.00,  nan ],
	[    50,  nan,  nan,     0.19,  0.00,  nan ],
	[    60,  nan,  nan,     0.32,  0.00,  nan ],
	[    70,  nan,  nan,     0.49,  0.00,  nan ],
	[    80,  nan,  nan,     0.70,  0.00,  nan ],
	[    90,  nan,  nan,     0.94,  0.00,  nan ],
	[   100,  nan,  nan,     1.19,  0.00,  nan ],
	[   200,  nan,  nan,     7.64,  0.00,  nan ],
	[   300,  nan,  nan,    11.78,  0.00,  nan ],
	[   400,  nan,  nan,    25.07,  0.00,  nan ],
	[   500,  nan,  nan,    42.71,  0.00,  nan ],
	[   600,  nan,  nan,    54.11,  0.01,  nan ],
	[   700,  nan,  nan,    76.94,  0.01,  nan ],
	[   800,  nan,  nan,    84.50,  0.01,  nan ],
	[   900,  nan,  nan,   115.39,  0.01,  nan ],
	[  1000,  nan,  nan,   143.67,  0.01,  nan ],
	[  2000,  nan,  nan,   432.67,  0.02,  nan ],
	[  3000,  nan,  nan,   648.64,  0.06,  nan ],
	[  4000,  nan,  nan,   786.19,  0.11,  nan ],
	[  5000,  nan,  nan,   861.50,  0.19,  nan ],
	[  6000,  nan,  nan,   924.07,  0.31,  nan ],
	[  7000,  nan,  nan,   973.44,  0.47,  nan ],
	[  8000,  nan,  nan,  1011.88,  0.67,  nan ],
	[  9000,  nan,  nan,  1034.74,  0.94,  nan ],
	[ 10000,  nan,  nan,  1059.33,  1.26,  nan ],
	[ 12000,  nan,  nan,  1100.62,  2.09,  nan ],
	[ 14000,  nan,  nan,  1121.24,  3.26,  nan ],
	[ 16000,  nan,  nan,  1141.62,  4.78,  nan ],
	[ 18000,  nan,  nan,  1149.84,  6.76,  nan ],
	[ 20000,  nan,  nan,  1151.90,  9.26,  nan ],
])

