#include <sys/mman.h>
#include <fcntl.h>
#include <stddef.h>
#include <sys/stat.h>
#include <stdio.h>
#include <unistd.h>
#include <stdint.h>
#include <string.h>

typedef struct {
    char magic[8];

    uint32_t format;
    uint32_t words_positions_offset;
    uint32_t words_position_size;

    uint32_t letters_offset;
    uint32_t letters_size;

    uint32_t name_offset;

} header_t;

typedef struct {
    char letter[6];
    uint8_t score;
    uint8_t vowel;
} letter_t;



int main() {
    int fd = open("language_data/italian.bin", 0, O_RDONLY);
    if (fd == -1) goto err;

    printf("fd:%d\n", fd);

    struct stat statbuf;
    int r = fstat(fd, &statbuf);
    if (r == -1) goto err;


    printf("size: %d\n", statbuf.st_size);

    void* ptr = mmap(NULL ,statbuf.st_size, PROT_READ, MAP_PRIVATE, fd, 0);

    if (ptr == MAP_FAILED) {
        perror("mmap");
        goto err;
    }
    close(fd);

    r = madvise(ptr, statbuf.st_size,MADV_RANDOM );
    if (r == -1) goto err;

    printf("%d\n", ptr);


// BinaryHeader(header=b'PARODICT', format=0, words_positions_position=3029592, words_position_size=278016, letters_position=4141656, letters_size=21, name_position=32)

    header_t* header = ptr;

    printf("check magic %d\nformat %d\n",
        memcmp("PARADICT", header->magic, 8), header->format);

    printf("Name %s\nof%d\n", ptr + header->name_offset, header->name_offset);

    uint32_t *values = ptr + header->words_positions_offset;

    for (int i=0; i < 15; i++) {
        printf("%s\n" , ptr + values[i]);
    }

    letter_t* letters = ptr + header->letters_offset;
    for (int i=0; i < header->letters_size; i++) {
        printf("letter %s score %d vowel %d\n", letters[i].letter, letters[i].score, letters[i].vowel);
    }




    return 0;
    err:
    return 1;
}
