#!/bin/sh

set -x -e

UID_GID=$1

cd /tmp

MOD_PREFIX=$PWD/build/install
CXXFLAGS="-g -Wall -Wextra -Wpedantic -Wshadow -Wsuggest-override -Werror" ${ARCH}-w64-mingw32-cmake \
  -DCMAKE_INSTALL_PREFIX=${MOD_PREFIX} \
  -DCMAKE_LINKER_TYPE=LLD \
  -DPython_INCLUDE_DIR=${MINGW_PREFIX}/include/python${PYMAJMIN} \
  -DPython_LIBRARY=${MINGW_PREFIX}/lib/libpython${PYMAJMIN}.dll.a \
  -DPython_EXECUTABLE=/usr/bin/${ARCH}-w64-mingw32-python${PYMAJMIN}-bin \
  -DSWIG_COMPILE_FLAGS="-Wno-unused-parameter -Wno-shadow -Wno-suggest-override" \
  -DPERSALYS_BUILD_NSIS=ON \
  -DUSE_STACKTRACE=ON \
  -DCMAKE_UNITY_BUILD=ON -DCMAKE_UNITY_BUILD_BATCH_SIZE=32 -B build /io
cd build
make install
${ARCH}-w64-mingw32-strip --strip-unneeded ${MOD_PREFIX}/Lib/site-packages/persalys/*.pyd
make tests
cp ${MOD_PREFIX}/bin/*.dll ${MOD_PREFIX}/Lib/site-packages/persalys/
cp ${MINGW_PREFIX}/bin/*.dll ${MOD_PREFIX}/bin
OPENTURNS_NUM_THREADS=2 WINEPATH="${MINGW_PREFIX}/bin;${MOD_PREFIX}/bin" xvfb-run -s "-screen 0 1024x768x24" ctest --output-on-failure --timeout 200 ${MAKEFLAGS}

cp -r ${MINGW_PREFIX}/lib/qt/plugins/{platforms,imageformats} ${MOD_PREFIX}/lib
cp -rv ${MINGW_PREFIX}/bin/paraview*/plugins/BagPlotViewsAndFilters ${MOD_PREFIX}/bin
cp /usr/${ARCH}-w64-mingw32/etc/openturns/openturns.conf ${MOD_PREFIX}/Lib/site-packages/persalys/
VERSION=`cat /io/VERSION`
cp /io/distro/windows/* .
bsdtar -xf persalys-doc.zip

# bundle installer
cd /tmp
PYVER=`${ARCH}-w64-mingw32-python${PYMAJMIN}-bin -V|sed "s|.*Python \([0-9\.]*\).*|\1|g"`
mkdir -p python_root/Lib/site-packages && cd python_root
curl -fSsL https://www.python.org/ftp/python/${PYVER}/python-${PYVER}-embed-amd64.zip | bsdtar -xf-
echo 'Lib\\site-packages' >> python${PYMAJMIN}._pth
echo 'import site' >> python${PYMAJMIN}._pth        # required to be able to install modules in user mode
curl -fSsL https://anaconda.org/conda-forge/vs2015_runtime/14.16.27012/download/win-64/vs2015_runtime-14.16.27012-h30e32a0_2.tar.bz2 | tar xj
cp -r /usr/${ARCH}-w64-mingw32/Lib/site-packages/openturns Lib/site-packages
cp /usr/${ARCH}-w64-mingw32/bin/*.dll Lib/site-packages/openturns
cp /usr/${ARCH}-w64-mingw32/etc/openturns/openturns.conf Lib/site-packages/openturns
rm Lib/site-packages/openturns/{libvtk,libboost,Qt,python}*.dll
cp -rv /usr/${ARCH}-w64-mingw32/Lib/site-packages/otmorris Lib/site-packages

curl -fSsL https://anaconda.org/conda-forge/pyfmi/2.19.0/download/win-64/pyfmi-2.19.0-py313h0591002_2.conda | bsdtar -x && tar -xf pkg-pyfmi-2.19.0-py313h0591002_2.tar.zst
curl -fSsL https://anaconda.org/conda-forge/assimulo/3.7.2/download/win-64/assimulo-3.7.2-py313habcb892_1.conda | bsdtar -x && tar -xf pkg-assimulo-3.7.2-py313habcb892_1.tar.zst
curl -fSsL https://anaconda.org/conda-forge/sundials/7.4.0/download/win-64/sundials-7.4.0-h59e65cd_0.conda | bsdtar -x && tar -xf pkg-sundials-7.4.0-h59e65cd_0.tar.zst
cp -r Library/bin/*.dll . && rm -r Library info pkg-*.zst info-*.zst

cd Lib
curl -fSsL https://anaconda.org/conda-forge/otfmi/0.17/download/noarch/otfmi-0.17-pyhd8ed1ab_0.conda | bsdtar -x && tar -xf pkg-otfmi-0.17-pyhd8ed1ab_0.tar.zst
cd site-packages

python -m pip install --target . --platform win_amd64 --python-version ${PYMAJMIN:0:1}.${PYMAJMIN:1} --only-binary=:all: \
  pip scipy pandas openpyxl jinja2 pythonfmu nopip paramiko
cd ../..
mkdir Scripts && echo -e 'import sys\nfrom pip import main\nsys.exit(main())\n' > Scripts/pip.py && echo -e 'python %~dp0pip.py %*' > Scripts/pip.bat
cd /tmp/build
makensis -DMODULE_PREFIX=${MOD_PREFIX} -DMODULE_VERSION=${VERSION} -DPYTHON_PREFIX=/tmp/python_root -DPYBASEVER=${PYMAJMIN:0:1}.${PYMAJMIN:1} -DARCH=${ARCH} installer_bundle.nsi

# copy to host with same permission
if test -n "${UID_GID}"
then
  sudo cp persalys-${VERSION}-*.exe /io
  sudo chown ${UID_GID} /io/persalys-${VERSION}-*.exe
fi
