# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.datafactory import DataFactoryManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataFactoryManagementManagedPrivateEndpointsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataFactoryManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_private_endpoints_list_by_factory(self, resource_group):
        response = self.client.managed_private_endpoints.list_by_factory(
            resource_group_name=resource_group.name,
            factory_name="str",
            managed_virtual_network_name="str",
            api_version="2018-06-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_private_endpoints_create_or_update(self, resource_group):
        response = self.client.managed_private_endpoints.create_or_update(
            resource_group_name=resource_group.name,
            factory_name="str",
            managed_virtual_network_name="str",
            managed_private_endpoint_name="str",
            managed_private_endpoint={
                "properties": {
                    "connectionState": {"actionsRequired": "str", "description": "str", "status": "str"},
                    "fqdns": ["str"],
                    "groupId": "str",
                    "isReserved": bool,
                    "privateLinkResourceId": "str",
                    "provisioningState": "str",
                },
                "etag": "str",
                "id": "str",
                "name": "str",
                "type": "str",
            },
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_private_endpoints_get(self, resource_group):
        response = self.client.managed_private_endpoints.get(
            resource_group_name=resource_group.name,
            factory_name="str",
            managed_virtual_network_name="str",
            managed_private_endpoint_name="str",
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_private_endpoints_delete(self, resource_group):
        response = self.client.managed_private_endpoints.delete(
            resource_group_name=resource_group.name,
            factory_name="str",
            managed_virtual_network_name="str",
            managed_private_endpoint_name="str",
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...
