# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.durabletask.aio import DurableTaskMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDurableTaskMgmtRetentionPoliciesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DurableTaskMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_retention_policies_get(self, resource_group):
        response = await self.client.retention_policies.get(
            resource_group_name=resource_group.name,
            scheduler_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_retention_policies_begin_create_or_replace(self, resource_group):
        response = await (
            await self.client.retention_policies.begin_create_or_replace(
                resource_group_name=resource_group.name,
                scheduler_name="str",
                resource={
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "provisioningState": "str",
                        "retentionPolicies": [{"retentionPeriodInDays": 0, "orchestrationState": "str"}],
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_retention_policies_begin_update(self, resource_group):
        response = await (
            await self.client.retention_policies.begin_update(
                resource_group_name=resource_group.name,
                scheduler_name="str",
                properties={
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "provisioningState": "str",
                        "retentionPolicies": [{"retentionPeriodInDays": 0, "orchestrationState": "str"}],
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_retention_policies_begin_delete(self, resource_group):
        response = await (
            await self.client.retention_policies.begin_delete(
                resource_group_name=resource_group.name,
                scheduler_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_retention_policies_list_by_scheduler(self, resource_group):
        response = self.client.retention_policies.list_by_scheduler(
            resource_group_name=resource_group.name,
            scheduler_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
