% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/projectReducedDim.R
\name{projectReducedDim}
\alias{projectReducedDim}
\alias{projectReducedDim,matrix-method}
\alias{projectReducedDim,SummarizedExperiment-method}
\title{Project cells into an arbitrary dimensionality reduction space.}
\usage{
projectReducedDim(x, ...)

\S4method{projectReducedDim}{matrix}(x, old.embedding, ...)

\S4method{projectReducedDim}{SummarizedExperiment}(
  x,
  old.sce,
  dimred.embed = "TSNE",
  dimred.knn = "PCA",
  dimred.name = dimred.embed,
  k = 5
)
}
\arguments{
\item{x}{A numeric matrix of a dimensionality reduction containing the cells that should be projected into the existing embedding defined in either \code{old.embedding} or \code{old.sce}.
Alternatively, a \linkS4class{SummarizedExperiment} or \linkS4class{SingleCellExperiment} containing such a matrix.}

\item{...}{Passed to methods.}

\item{old.embedding}{If \code{x} is a matrix and \code{old} is given, then \code{old.embedding} is the existing dimensionality reduction embedding that \code{x} should be projected into.}

\item{old.sce}{The object containing the original dimensionality points. If \code{x} is a matrix, then \code{old.points} must be supplied as a matrix of}

\item{dimred.embed}{The name of the target dimensionality reduction that points should be embedded into, if \code{}.}

\item{dimred.knn}{The name of the dimensionality reduction to use to identify the K-nearest neighbours from \code{x} in the dimensionality reduction slot of the same name defined in either \code{old} or \code{old.sce}.}

\item{dimred.name}{The name of the dimensionality reduction that the projected embedding will be saved as, for the \linkS4class{SummarizedExperiment} method.}

\item{k}{The number of nearest neighours to use to project points into the embedding.}
}
\value{
When \code{x} is a matrix, a matrix is returned. When \code{x} is a
\code{\linkS4class{SummarizedExperiment}}
(or \code{\linkS4class{SingleCellExperiment}}), the return value is of
the same class as the input, but the projected dimensionality reduction
is added as a \code{reducedDim} field.
}
\description{
Projects observations into arbitrary dimensionality reduction space (e.g., t-SNE, UMAP) using a tricube weighted average of the k nearest neighbours.
}
\examples{
example_sce <- mockSCE() 
example_sce <- logNormCounts(example_sce)
example_sce <- runUMAP(example_sce)
example_sce <- runPCA(example_sce)

example_sce_new <- mockSCE() 
example_sce_new <- logNormCounts(example_sce_new)
example_sce_new <- runPCA(example_sce_new)

## sce method
projectReducedDim(
    example_sce_new,
    old.sce = example_sce,
    dimred.embed="UMAP",
    dimred.knn="PCA"
)

## matrix method
projectReducedDim(
    reducedDim(example_sce, "PCA"),
    new.points = reducedDim(example_sce_new, "PCA"),
    old.embedding = reducedDim(example_sce, "UMAP")
)
}
