% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural.properties.R
\name{reciprocity}
\alias{reciprocity}
\title{Reciprocity of graphs}
\usage{
reciprocity(graph, ignore.loops = TRUE, mode = c("default", "ratio"))
}
\arguments{
\item{graph}{The graph object.}

\item{ignore.loops}{Logical constant, whether to ignore loop edges.}

\item{mode}{See below.}
}
\value{
A numeric scalar between zero and one.
}
\description{
Calculates the reciprocity of a directed graph.
}
\details{
The measure of reciprocity defines the proportion of mutual connections, in
a directed graph. It is most commonly defined as the probability that the
opposite counterpart of a directed edge is also included in the graph. Or in
adjacency matrix notation:
\eqn{1 - \left(\sum_{i,j} |A_{ij} - A_{ji}|\right) / \left(2\sum_{i,j} A_{ij}\right)}{1 - (sum_ij |A_ij - A_ji|) / (2 sum_ij A_ij)}.
This measure is calculated if the \code{mode} argument is \code{default}.

Prior to igraph version 0.6, another measure was implemented, defined as the
probability of mutual connection between a vertex pair, if we know that
there is a (possibly non-mutual) connection between them. In other words,
(unordered) vertex pairs are classified into three groups: (1)
not-connected, (2) non-reciprocally connected, (3) reciprocally connected.
The result is the size of group (3), divided by the sum of group sizes
(2)+(3). This measure is calculated if \code{mode} is \code{ratio}.
}
\examples{

g <- sample_gnp(20, 5 / 20, directed = TRUE)
reciprocity(g)

}
\seealso{
Other structural.properties: 
\code{\link{bfs}()},
\code{\link{component_distribution}()},
\code{\link{connect}()},
\code{\link{constraint}()},
\code{\link{coreness}()},
\code{\link{degree}()},
\code{\link{dfs}()},
\code{\link{distance_table}()},
\code{\link{edge_density}()},
\code{\link{feedback_arc_set}()},
\code{\link{girth}()},
\code{\link{is_acyclic}()},
\code{\link{is_dag}()},
\code{\link{is_matching}()},
\code{\link{k_shortest_paths}()},
\code{\link{knn}()},
\code{\link{subcomponent}()},
\code{\link{subgraph}()},
\code{\link{topo_sort}()},
\code{\link{transitivity}()},
\code{\link{unfold_tree}()},
\code{\link{which_multiple}()},
\code{\link{which_mutual}()}
}
\author{
Tamas Nepusz \email{ntamas@gmail.com} and Gabor Csardi
\email{csardi.gabor@gmail.com}
}
\concept{structural.properties}
\keyword{graphs}
\section{Related documentation in the C library}{\href{https://igraph.org/c/html/latest/igraph-Structural.html#igraph_reciprocity}{\code{igraph_reciprocity()}}.}

