% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survplot.orm.r
\name{survplot.orm}
\alias{survplot.orm}
\title{Title Survival Curve Plotting}
\usage{
\method{survplot}{orm}(
  fit,
  ...,
  xlab,
  ylab = "Survival Probability",
  conf.int = FALSE,
  conf = c("bands", "bars"),
  facet = FALSE,
  nrow = NULL,
  alpha = 0.15,
  adj.subtitle = TRUE,
  onlydata = FALSE
)
}
\arguments{
\item{fit}{a fit produced by [orm()]; also works for [psm()] fits}

\item{...}{list of factors with names used in model. The first factor listed is the factor used to determine different survival curves.  Any other factors are used to specify single constants to be adjusted to, when defaults given to fitting routine (through `limits`) are not used.  The value given to factors is the original coding of data given to fit, except that for categorical factors the text string levels may be specified.  The form of values given to the first factor are none (omit the equal sign to use default range or list of all values if variable is discrete), `"text"` if factor is categorical, `c(value1, value2, \dots)`, or a function which returns a vector, such as `seq(low,high,by=increment)`.  Only the first factor may have the values omitted.  In this case the `Low effect`, `Adjust to`, and `High effect` values will be used from `datadist` if the variable is continuous.  For variables not defined to `datadist`, you must specify non-missing constant settings (or a vector of settings for the one displayed variable).}

\item{xlab}{character string label for x-axis; uses the `plotmath`-style `yplabel` for the `y` variable stored in the fit if `xlab` is absent}

\item{ylab}{y-axis label, defaulting to `"Survival Probability"`}

\item{conf.int}{defaults to `FALSE` (same as specifying `0`); specify a positive value less than 1 to get two-sided confidence intervals utilizing approximate normality of linear predictors}

\item{conf}{not currently used}

\item{facet}{set to `TRUE` to have the first varying variable appear as a facet instead of as different colored step functions}

\item{nrow}{when faceting on one varying variable using `facet_wrap` specifies the number of rows to create}

\item{alpha}{transparency for confidence bands}

\item{adj.subtitle}{set to `FALSE` to not show a caption with the values of non-varying values (adjustment variables)}

\item{onlydata}{set to `TRUE` to return the data used in `ggplot2` plotting instead of the graphics object}
}
\value{
if `onlydata` is left at its default value, a `ggplot2` graphics object for which additional layers may later be added
}
\description{
Plots predicted survival curves with easy specification of predictor settings, with optional confidence bands.  For `orm` fits these are step functions, and for `psm` fits they are smooth curves.
}
\examples{
set.seed(1)
d <- expand.grid(x1=c('a', 'b', 'c'), x2=c('A','B'), x3=1:2, irep=1:20)
y <- sample(1:10, nrow(d), TRUE)
dd <- datadist(d); options(datadist='dd')
f <- orm(y ~ x1 + x2 + x3, data=d)

survplot(f, x1='a')
survplot(f, x1='a', conf.int=.95)
survplot(f, x1=c('a','b'), x2='A')
survplot(f, x1=c('a', 'b'), x2='A', conf.int=.95)
survplot(f, x1=c('a','b'), x2='A', facet=TRUE)
survplot(f, x1=c('a','b'), x2='A', facet=TRUE, conf.int=.95)

survplot(f, x1=c('a', 'b'), x2=c('A', 'B'))
survplot(f, x1=c('a', 'b'), x2=c('A', 'B'), conf.int=.95)
survplot(f, x1=c('a', 'b'), x2=c('A', 'B'), facet=TRUE)

survplot(f, x1=c('a', 'b'), x2=c('A', 'B'), x3=1:2)

g <- psm(Surv(y) ~ x1 + x2 + x3, data=d)
survplot(g, x1=c('a','b'), x2=c('A', 'B'), ggplot=TRUE)  # calls survplot.orm
# See https://hbiostat.org/rmsc/parsurv#sec-parsurv-assess
# where nonparametric and parametric estimates are combined into one ggplot
options(datadist=NULL)
}
\seealso{
[Hmisc::geom_stepconfint()]
}
\author{
Frank Harrell
md
}
