#!/bin/bash

# $1 - action
# $2 - type of file

action=$1
filetype=$2

[ -n "${MC_XDG_OPEN}" ] || MC_XDG_OPEN="_xdg_open"

_xdg_open()
{
    if [ -n "$DISPLAY" ] && type -p gmplayer ; then
        gmplayer "${MC_EXT_FILENAME}"
    elif type -p mplayer ; then
        mplayer "${MC_EXT_FILENAME}"
    else
        xdg-open "${MC_EXT_FILENAME}"
    fi
}

do_view_action() {
    filetype=$1

    if type -p mediainfo >/dev/null 2>&1 ; then
        mediainfo "${MC_EXT_FILENAME}"
        return $?
    fi

    case "${filetype}" in
    mp3)
        if type -p mpg123 ; then
            mpg123 -vtn1 "${MC_EXT_FILENAME}" 2>&1 | \
                sed -n '/^Title/,/^Comment/p;/^MPEG/,/^Audio/p'
            return 0
        fi
        ;;
    ogg)
        type -p ogginfo && ogginfo "${MC_EXT_FILENAME}" && return 0
        ;;
    wma)
        mplayer -quiet -slave -frames 0 -vo null -ao null -identify "${MC_EXT_FILENAME}" 2>/dev/null | \
            tail +13 || file "${MC_EXT_FILENAME}"
        return $?
        ;;
    esac

    mplayer -identify -vo null -ao null -frames 0 "${MC_EXT_FILENAME}" 2>&1 | sed -n '/^ID_/p'
}

do_open_action() {
    filetype=$1

    case "${filetype}" in
    common)
        if [ -n "$DISPLAY" ]; then
            (xmms  "${MC_EXT_FILENAME}" >/dev/null 2>&1 &)
        else
            play "${MC_EXT_FILENAME}"
        fi
        ;;
    mod)
        mikmod "${MC_EXT_FILENAME}"
        #tracker "${MC_EXT_FILENAME}"
        ;;
    wav22)
        vplay -s 22 "${MC_EXT_FILENAME}"
        ;;
    mp3)
        if [ -n "$DISPLAY" ]; then
            (xmms "${MC_EXT_FILENAME}" >/dev/null 2>&1 &)
        else
            mpg123 "${MC_EXT_FILENAME}"
        fi
        ;;
    ogg)
        if [ -n "$DISPLAY" ]; then
            (xmms "${MC_EXT_FILENAME}" >/dev/null 2>&1 &)
        else
            ogg123 "${MC_EXT_FILENAME}"
        fi
        ;;
    midi)
        timidity "${MC_EXT_FILENAME}"
        ;;
    wma)
        mplayer -vo null "${MC_EXT_FILENAME}"
        ;;
    playlist)
        if [ -n "$DISPLAY" ]; then
            (xmms -p "${MC_EXT_FILENAME}" >/dev/null 2>&1 &)
        else
            mplayer -vo null -playlist "${MC_EXT_FILENAME}"
        fi
        ;;
    *)
        ;;
    esac
}

case "${action}" in
view)
    do_view_action "${filetype}"
    ;;
open)
    test -n "$DISPLAY" && ("${MC_XDG_OPEN}" "${MC_EXT_FILENAME}" >/dev/null 2>&1) || \
        do_open_action "${filetype}"
    ;;
*)
    ;;
esac
