package net.crystallography.vector.space;

import org.junit.Assert;
import org.junit.Before;

import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

import java.util.ArrayList;
import java.util.Arrays;

import static net.crystallography.vector.space.ChangeOfBasis.changeOfBaseMatrix;
import static net.crystallography.vector.space.ChangeOfBasis.mpMultiply;

public class ChangeOfBasisTest {

    private final Vector3d a = new Vector3d(1,2,3);
    private final Vector3d b = new Vector3d(1.5,2.0,3.5);
    private final Vector3d c = new Vector3d(4,2,1);
    private final Matrix3d M = changeOfBaseMatrix(a,b,c);

    @org.junit.Test
    public void changeOfBaseMatrixTest() throws Exception {
        Matrix3d m = changeOfBaseMatrix(a,b,c);
        Assert.assertEquals(1,m.m00,1E-10);
        Assert.assertEquals(2,m.m10,1E-10);
        Assert.assertEquals(3,m.m20,1E-10);

        Assert.assertEquals(1.5,m.m01,1E-10);
        Assert.assertEquals(2.0,m.m11,1E-10);
        Assert.assertEquals(3.5,m.m21,1E-10);

        Assert.assertEquals(4.0,m.m02,1E-10);
        Assert.assertEquals(2.0,m.m12,1E-10);
        Assert.assertEquals(1.0,m.m22,1E-10);
    }

    @org.junit.Test
    public void mpMultiplyTest() throws Exception {
        Point3d p = new Point3d(1,0,0);
        Assert.assertEquals(1.0, mpMultiply(M,p).x,1E-10);
        Assert.assertEquals(2.0, mpMultiply(M,p).y,1E-10);
        Assert.assertEquals(3.0, mpMultiply(M,p).z,1E-10);
    }

    @org.junit.Test
    public void mpMultiplyTest2() throws Exception {
        Point3d p = new Point3d(1,2,0);
        Assert.assertEquals(4.0, mpMultiply(M,p).x,1E-10);
        Assert.assertEquals(6.0, mpMultiply(M,p).y,1E-10);
        Assert.assertEquals(10.0, mpMultiply(M,p).z,1E-10);
    }

    @org.junit.Test
    public void mpMultiplyTest3() throws Exception {
        Point3d p = new Point3d(1,2,4);
        Assert.assertEquals(20.0, mpMultiply(M,p).x,1E-10);
        Assert.assertEquals(14.0, mpMultiply(M,p).y,1E-10);
        Assert.assertEquals(14.0, mpMultiply(M,p).z,1E-10);
    }

}
