#define XERR "sshcron"
#include "sshcron.ih"

    // by tocron.cc

void SSHCron::reload()
{
    char const *cronFile = d_options.arg(0);
    if (not FileSystem{ cronFile }.exists())
    {
        emsg << '`' << cronFile << "': not found" << endl;
        return;
    }

    askPassphrase();                    // in d_passphrase

    *d_out << name(RELOAD) << '\n' <<
              d_passphrase << '\n' <<
              cronFile << endl;

    string line;
    getline(*d_in, line);

    if (line == "NOK")
        emsg << "invalid passphrase" << endl;
    else if (line != "OK")
        emsg << line << endl;
    else
        idmsg() << "reloaded crontab file `" << cronFile << '\'' << endl;
}






