INCLUDE(AssertDefined)
INCLUDE(AppendSet)
INCLUDE(SetNotFound)

# Search for all MUMPS libraries if they are not explicitly stated.
IF (NOT MUMPS_LIBRARY_NAMES AND NOT TPL_MUMPS_LIBRARIES)

  IF (MUMPS_LIBRARY_DIRS)
    SET(PATHS_ARG PATHS ${MUMPS_LIBRARY_DIRS})
  ELSE()
    SET(PATHS_ARG PATHS)
  ENDIF()

  SET(MUMPS_LIBRARIES
    smumps dmumps cmumps zmumps mumps_common pord)
  SET(MUMPS_LIBRARIES_FOUND)
  SET(MUMPS_HEADERS)

  FOREACH(LIBNAME ${MUMPS_LIBRARIES})

    SET_NOTFOUND( _MUMPS_${LIBNAME}_LIBRARY )
    FIND_LIBRARY( _MUMPS_${LIBNAME}_LIBRARY
      NAMES ${LIBNAME}
      ${PATHS_ARG} NO_DEFAULT_PATH )
    FIND_LIBRARY( _MUMPS_${LIBNAME}_LIBRARY
      NAMES ${LIBNAME} )

    IF (_MUMPS_${LIBNAME}_LIBRARY)
      APPEND_SET(MUMPS_LIBRARIES_FOUND ${LIBNAME})
      APPEND_SET(MUMPS_HEADERS ${LIBNAME}_c.h)
    ENDIF()
 
  ENDFOREACH()

  #Add ordering and common library
  SET(MUMPS_COMMON_LIBRARIES
    pord mumps_common)
  FOREACH(LIBNAME ${MUMPS_COMMON_LIBRARIES})

    SET_NOTFOUND( _MUMPS_${LIBNAME}_LIBRARY )
    FIND_LIBRARY( _MUMPS_${LIBNAME}_LIBRARY
      NAMES ${LIBNAME}
      ${PATHS_ARG} NO_DEFAULT_PATH )
    FIND_LIBRARY( _MUMPS_${LIBNAME}_LIBRARY
      NAMES ${LIBNAME} )

    IF (_MUMPS_${LIBNAME}_LIBRARY)
      APPEND_SET(MUMPS_LIBRARIES_FOUND ${LIBNAME})
    ENDIF()
 
  ENDFOREACH()

  IF (NOT MUMPS_LIBRARIES_FOUND)
    MESSAGE(
      "-- ERROR: Did not find a lib in the lib set \"${MUMPS_LIBRARIES}\""
      " for the TPL 'MUMPS'!")
  ENDIF()

  TRIBITS_TPL_FIND_INCLUDE_DIRS_AND_LIBRARIES( MUMPS
    REQUIRED_HEADERS ${MUMPS_HEADERS}
    REQUIRED_LIBS_NAMES ${MUMPS_LIBRARIES_FOUND}
  )

ELSE()

  # Check the given library names in the standard way.
  TRIBITS_TPL_FIND_INCLUDE_DIRS_AND_LIBRARIES( MUMPS
    REQUIRED_HEADERS dmumps_c.h
    REQUIRED_LIBS_NAMES dmumps libmumps_common pord
  )

ENDIF()

