/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.Atom;
import org.jmol.symmetry.PointGroup;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.SymmetryInfo;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.Logger;

public class Symmetry
implements SymmetryInterface {
    private PointGroup pointGroup;
    private SpaceGroup spaceGroup;
    private SymmetryInfo symmetryInfo;
    private UnitCell unitCell;

    public SymmetryInterface setPointGroup(SymmetryInterface symmetryInterface, Atom[] atomArray, BitSet bitSet, boolean bl, float f, float f2) {
        this.pointGroup = PointGroup.getPointGroup(symmetryInterface == null ? null : ((Symmetry)symmetryInterface).pointGroup, atomArray, bitSet, bl, f, f2);
        return this;
    }

    public String getPointGroupName() {
        return this.pointGroup.getName();
    }

    public Object getPointGroupInfo(int n, boolean bl, boolean bl2, String string, int n2, float f) {
        if (!bl && !bl2 && this.pointGroup.textInfo != null) {
            return this.pointGroup.textInfo;
        }
        if (bl && this.pointGroup.isDrawType(string, n2)) {
            return this.pointGroup.drawInfo;
        }
        if (bl2 && this.pointGroup.info != null) {
            return this.pointGroup.info;
        }
        return this.pointGroup.getInfo(n, bl, bl2, string, n2, f);
    }

    public void setSpaceGroup(boolean bl) {
        if (this.spaceGroup == null) {
            this.spaceGroup = new SpaceGroup(bl);
        }
    }

    public int addSpaceGroupOperation(String string, int n) {
        return this.spaceGroup.addSymmetry(string, n);
    }

    public void setLattice(int n) {
        this.spaceGroup.setLattice(n);
    }

    public String getSpaceGroupName() {
        return this.symmetryInfo != null ? this.symmetryInfo.spaceGroup : (this.spaceGroup != null ? this.spaceGroup.getName() : "");
    }

    public Object getSpaceGroup() {
        return this.spaceGroup;
    }

    public void setSpaceGroup(SymmetryInterface symmetryInterface) {
        this.spaceGroup = symmetryInterface == null ? null : (SpaceGroup)symmetryInterface.getSpaceGroup();
    }

    public boolean createSpaceGroup(int n, String string, float[] fArray, boolean bl) {
        this.spaceGroup = SpaceGroup.createSpaceGroup(n, string, fArray, bl);
        if (this.spaceGroup != null && Logger.debugging) {
            Logger.debug("using generated space group " + this.spaceGroup.dumpInfo(null));
        }
        return this.spaceGroup != null;
    }

    public boolean haveSpaceGroup() {
        return this.spaceGroup != null;
    }

    public String getSpaceGroupInfo(String string, SymmetryInterface symmetryInterface) {
        return SpaceGroup.getInfo(string, symmetryInterface);
    }

    public Object getLatticeDesignation() {
        return this.spaceGroup.getLatticeDesignation();
    }

    public void setFinalOperations(Point3f[] point3fArray, int n, int n2, boolean bl) {
        this.spaceGroup.setFinalOperations(point3fArray, n, n2, bl);
    }

    public int getSpaceGroupOperationCount() {
        return this.spaceGroup.finalOperations.length;
    }

    public Matrix4f getSpaceGroupOperation(int n) {
        return this.spaceGroup.finalOperations[n];
    }

    public String getSpaceGroupXyz(int n, boolean bl) {
        return this.spaceGroup.finalOperations[n].getXyz(bl);
    }

    public void newSpaceGroupPoint(int n, Point3f point3f, Point3f point3f2, int n2, int n3, int n4) {
        if (this.spaceGroup.finalOperations == null) {
            if (!this.spaceGroup.operations[n].isFinalized) {
                this.spaceGroup.operations[n].doFinalize();
            }
            this.spaceGroup.operations[n].newPoint(point3f, point3f2, n2, n3, n4);
            return;
        }
        this.spaceGroup.finalOperations[n].newPoint(point3f, point3f2, n2, n3, n4);
    }

    public Object rotateEllipsoid(int n, Point3f point3f, Vector3f[] vector3fArray, Point3f point3f2, Point3f point3f3) {
        return this.spaceGroup.finalOperations[n].rotateEllipsoid(point3f, vector3fArray, this.unitCell, point3f2, point3f3);
    }

    public boolean haveUnitCell() {
        return this.unitCell != null;
    }

    public String getUnitsymmetryInfo() {
        return this.unitCell == null ? "no unit cell information" : this.unitCell.dumpInfo(false);
    }

    public void setUnitCell(float[] fArray) {
        this.unitCell = new UnitCell(fArray);
    }

    public void toCartesian(Point3f point3f) {
        if (this.unitCell == null) {
            return;
        }
        this.unitCell.toCartesian(point3f);
    }

    public Object[] getEllipsoid(float[] fArray) {
        return this.unitCell.getEllipsoid(fArray);
    }

    public Point3f ijkToPoint3f(int n) {
        return UnitCell.ijkToPoint3f(n);
    }

    public void toFractional(Point3f point3f) {
        if (this.unitCell != null) {
            this.unitCell.toFractional(point3f);
        }
    }

    public Point3f[] getUnitCellVertices() {
        return this.unitCell.getVertices();
    }

    public Point3f getCartesianOffset() {
        return this.unitCell.getCartesianOffset();
    }

    public float[] getNotionalUnitCell() {
        return this.unitCell == null ? null : this.unitCell.getNotionalUnitCell();
    }

    public void toUnitCell(Point3f point3f, Point3f point3f2) {
        if (this.unitCell != null) {
            this.unitCell.toUnitCell(point3f, point3f2);
        }
    }

    public void setUnitCellOffset(Point3f point3f) {
        this.unitCell.setOffset(point3f);
    }

    public void setOffset(int n) {
        this.unitCell.setOffset(n);
    }

    public Point3f getFractionalOffset() {
        return this.unitCell.getFractionalOffset();
    }

    public Point3f[] getCanonicalCopy(float f) {
        return this.unitCell.getCanonicalCopy(f);
    }

    public float getUnitsymmetryInfo(int n) {
        return this.unitCell.getInfo(n);
    }

    public int getModelIndex() {
        return this.symmetryInfo.modelIndex;
    }

    public void setModelIndex(int n) {
        this.symmetryInfo.modelIndex = n;
    }

    public boolean getCoordinatesAreFractional() {
        return this.symmetryInfo.coordinatesAreFractional;
    }

    public int[] getCellRange() {
        return this.symmetryInfo.cellRange;
    }

    public String getSymmetryInfoString() {
        return this.symmetryInfo.symmetryInfoString;
    }

    public String[] getSymmetryOperations() {
        return this.symmetryInfo.symmetryOperations;
    }

    public boolean isPeriodic() {
        return this.symmetryInfo.isPeriodic();
    }

    public void setSymmetryInfo(int n, Hashtable hashtable) {
        this.symmetryInfo = new SymmetryInfo();
        float[] fArray = this.symmetryInfo.setSymmetryInfo(n, hashtable);
        if (fArray == null) {
            return;
        }
        this.setUnitCell(fArray);
        if (Logger.debugging) {
            Logger.debug("symmetryInfos[" + n + "]:\n" + this.unitCell.dumpInfo(true));
        }
    }

    public float getUnitCellInfo(int n) {
        return this.unitCell.getInfo(n);
    }

    public String getUnitCellInfo() {
        return this.unitCell == null ? "no unit cell information" : this.unitCell.dumpInfo(false);
    }

    public Object[] getSymmetryOperationDescription(int n, SymmetryInterface symmetryInterface, Point3f point3f, Point3f point3f2, String string) {
        return this.spaceGroup.operations[n].getDescription(n, symmetryInterface, point3f, point3f2, string);
    }

    public boolean isSlab() {
        return this.unitCell == null ? false : this.unitCell.isSlab();
    }

    public boolean isPolymer() {
        return this.unitCell == null ? false : this.unitCell.isPolymer();
    }
}

