/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.macro;

import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.StringTokenizer;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.DepList;
import rene.zirkel.construction.Selector;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.macro.Macro;
import rene.zirkel.macro.MacroPrompt;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.AreaObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ExpressionObject;
import rene.zirkel.objects.FixedAngleObject;
import rene.zirkel.objects.FixedCircleObject;
import rene.zirkel.objects.FunctionObject;
import rene.zirkel.objects.LineObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.RayObject;
import rene.zirkel.objects.SegmentObject;
import rene.zirkel.objects.TwoPointLineObject;
import rene.zirkel.objects.UserFunctionObject;

public class MacroRunner
extends ObjectConstructor
implements Selector {
    String[] S;
    int Param;
    Macro M;
    ConstructionObject[] Params;
    boolean[] NewPoint;
    boolean[] Fixed;
    static DepList DL = new DepList();

    public void setMacro(Macro macro, ZirkelCanvas zirkelCanvas) {
        this.S = macro.getPrompts();
        this.Param = 0;
        this.M = macro;
        this.Params = new ConstructionObject[this.S.length];
        this.Fixed = new boolean[this.S.length];
        this.NewPoint = new boolean[this.S.length];
        for (int i = 0; i < this.S.length; ++i) {
            this.Fixed[i] = false;
        }
    }

    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (!zirkelCanvas.Visual) {
            return;
        }
        ConstructionObject constructionObject = null;
        ConstructionObject[] constructionObjectArray = this.M.getParams();
        constructionObject = constructionObjectArray[this.Param] instanceof PointObject ? zirkelCanvas.selectCreatePoint(mouseEvent.getX(), mouseEvent.getY()) : zirkelCanvas.selectWithSelector(mouseEvent.getX(), mouseEvent.getY(), this);
        if (constructionObject == null) {
            return;
        }
        int n = this.Param;
        if (!this.setNextParameter(constructionObject, zirkelCanvas, mouseEvent.isShiftDown())) {
            return;
        }
        boolean bl = this.NewPoint[n] = constructionObject instanceof PointObject && zirkelCanvas.isNewPoint();
        if (this.Param >= this.S.length) {
            this.doMacro(zirkelCanvas);
            this.reset(zirkelCanvas);
        } else {
            this.getFixed(zirkelCanvas);
        }
    }

    public boolean isAdmissible(ZirkelCanvas zirkelCanvas, ConstructionObject constructionObject) {
        ConstructionObject[] constructionObjectArray = this.M.getParams();
        if (constructionObjectArray[this.Param] instanceof PointObject) {
            return constructionObject instanceof PointObject;
        }
        if (constructionObjectArray[this.Param] instanceof FixedAngleObject) {
            return constructionObject instanceof FixedAngleObject;
        }
        if (constructionObjectArray[this.Param] instanceof SegmentObject) {
            return constructionObject instanceof SegmentObject;
        }
        if (constructionObjectArray[this.Param] instanceof RayObject) {
            return constructionObject instanceof RayObject;
        }
        if (constructionObjectArray[this.Param] instanceof TwoPointLineObject) {
            return constructionObject instanceof TwoPointLineObject;
        }
        if (constructionObjectArray[this.Param] instanceof PrimitiveLineObject) {
            return constructionObject instanceof PrimitiveLineObject;
        }
        if (constructionObjectArray[this.Param] instanceof PrimitiveCircleObject) {
            return constructionObject instanceof PrimitiveCircleObject;
        }
        if (constructionObjectArray[this.Param] instanceof FunctionObject) {
            return constructionObject instanceof FunctionObject;
        }
        if (constructionObjectArray[this.Param] instanceof UserFunctionObject) {
            return constructionObject instanceof UserFunctionObject;
        }
        if (constructionObjectArray[this.Param] instanceof AngleObject) {
            return constructionObject instanceof AngleObject;
        }
        if (constructionObjectArray[this.Param] instanceof ExpressionObject) {
            return constructionObject instanceof ExpressionObject || constructionObject instanceof AngleObject || constructionObject instanceof FixedAngleObject || constructionObject instanceof AreaObject;
        }
        if (constructionObjectArray[this.Param] instanceof AreaObject) {
            return constructionObject instanceof AreaObject;
        }
        return false;
    }

    public void mouseMoved(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas, boolean bl) {
        ConstructionObject[] constructionObjectArray = this.M.getParams();
        if (!(constructionObjectArray[this.Param] instanceof PointObject) && this.Param == constructionObjectArray.length - 1) {
            zirkelCanvas.clearPreview();
            zirkelCanvas.repaint();
            ConstructionObject constructionObject = zirkelCanvas.selectWithSelector(mouseEvent.getX(), mouseEvent.getY(), (Selector)this, false);
            if (constructionObject != null) {
                zirkelCanvas.prepareForPreview(mouseEvent);
                this.Params[this.Param] = constructionObject;
                this.runMacroPreview(zirkelCanvas);
                zirkelCanvas.indicateWithSelector(mouseEvent.getX(), mouseEvent.getY(), this);
                return;
            }
        }
        if (!bl && this.waitForLastPoint()) {
            if (zirkelCanvas.isPreview()) {
                zirkelCanvas.movePreview(mouseEvent);
            } else {
                zirkelCanvas.prepareForPreview(mouseEvent);
                this.finishConstruction(mouseEvent, zirkelCanvas);
                return;
            }
        }
        if (constructionObjectArray[this.Param] instanceof PointObject) {
            zirkelCanvas.indicateCreatePoint(mouseEvent.getX(), mouseEvent.getY(), true);
        } else {
            zirkelCanvas.indicateWithSelector(mouseEvent.getX(), mouseEvent.getY(), this);
        }
    }

    public boolean waitForLastPoint() {
        if (this.M.countPrompts() > 0) {
            return false;
        }
        ConstructionObject[] constructionObjectArray = this.M.getParams();
        return constructionObjectArray[this.Param] instanceof PointObject && this.Param == constructionObjectArray.length - 1;
    }

    public void finishConstruction(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        ConstructionObject[] constructionObjectArray = this.M.getParams();
        if (!(constructionObjectArray[this.Param] instanceof PointObject)) {
            return;
        }
        PointObject pointObject = zirkelCanvas.selectCreatePoint(mouseEvent.getX(), mouseEvent.getY());
        this.NewPoint[this.Param] = true;
        this.Params[this.Param] = pointObject;
        this.runMacroPreview(zirkelCanvas);
    }

    public void reset(ZirkelCanvas zirkelCanvas) {
        if (zirkelCanvas.Visual) {
            super.reset(zirkelCanvas);
            this.Param = 0;
            if (this.M != null && this.M.hasFixed()) {
                this.getFixed(zirkelCanvas);
            }
            this.showStatus(zirkelCanvas);
        } else if (this.M != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('=');
            String string = this.M.getName();
            if (string.indexOf("(") > 0) {
                stringBuffer.append("\"" + this.M.getName() + "\"");
            } else {
                stringBuffer.append(this.M.getName());
            }
            stringBuffer.append('(');
            for (int i = 0; i < this.M.getParams().length - 1; ++i) {
                stringBuffer.append(',');
            }
            stringBuffer.append(')');
            zirkelCanvas.setPrompt(stringBuffer.toString());
        }
    }

    public void getFixed(ZirkelCanvas zirkelCanvas) {
        boolean bl;
        if (this.M == null || !zirkelCanvas.Visual) {
            return;
        }
        boolean bl2 = bl = this.Param == 0;
        while ((this.M.isFixed(this.Param) || this.M.getPrompts()[this.Param].startsWith("=")) && this.Param < (bl ? this.S.length - 1 : this.S.length)) {
            String string = this.M.isFixed(this.Param) ? this.M.getLast(this.Param) : this.M.getPrompts()[this.Param].substring(1);
            if (string.equals("")) {
                this.M.setFixed(this.Param, false);
                break;
            }
            ConstructionObject constructionObject = zirkelCanvas.getConstruction().find(string);
            if (constructionObject == null) {
                this.M.setFixed(this.Param, false);
                break;
            }
            if (!this.setNextParameter(constructionObject, zirkelCanvas, false)) {
                return;
            }
            if (this.Param < this.S.length) continue;
            this.doMacro(zirkelCanvas);
            this.reset(zirkelCanvas);
            break;
        }
        this.showStatus(zirkelCanvas);
    }

    public void returnPressed(ZirkelCanvas zirkelCanvas) {
        if (this.M == null || !zirkelCanvas.Visual) {
            return;
        }
        String string = this.M.getLast(this.Param);
        if (string.equals("")) {
            return;
        }
        ConstructionObject constructionObject = zirkelCanvas.getConstruction().find(string);
        if (!this.setNextParameter(constructionObject, zirkelCanvas, false)) {
            return;
        }
        if (this.Param >= this.S.length) {
            this.doMacro(zirkelCanvas);
            this.reset(zirkelCanvas);
        } else {
            this.getFixed(zirkelCanvas);
        }
    }

    public boolean setNextParameter(ConstructionObject constructionObject, ZirkelCanvas zirkelCanvas, boolean bl) {
        if (!this.isAdmissible(zirkelCanvas, constructionObject)) {
            return false;
        }
        this.Params[this.Param] = constructionObject;
        constructionObject.setSelected(true);
        if (bl) {
            this.Fixed[this.Param] = true;
        }
        zirkelCanvas.getConstruction().addParameter(constructionObject);
        zirkelCanvas.repaint();
        ++this.Param;
        return true;
    }

    public void doMacro(ZirkelCanvas zirkelCanvas) {
        String[] stringArray = new String[]{};
        this.runMacro(zirkelCanvas, stringArray);
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        if (this.M != null) {
            ConstructionObject[] constructionObjectArray = this.M.getParams();
            String string = "???";
            if (constructionObjectArray[this.Param] instanceof PointObject) {
                string = Zirkel.name("name.Point");
            } else if (constructionObjectArray[this.Param] instanceof FixedAngleObject) {
                string = Zirkel.name("name.FixedAngle");
            } else if (constructionObjectArray[this.Param] instanceof SegmentObject) {
                string = Zirkel.name("name.Segment");
            } else if (constructionObjectArray[this.Param] instanceof LineObject) {
                string = Zirkel.name("name.TwoPointLine");
            } else if (constructionObjectArray[this.Param] instanceof RayObject) {
                string = Zirkel.name("name.Ray");
            } else if (constructionObjectArray[this.Param] instanceof PrimitiveLineObject) {
                string = Zirkel.name("name.Line");
            } else if (constructionObjectArray[this.Param] instanceof PrimitiveCircleObject) {
                string = Zirkel.name("name.Circle");
            } else if (constructionObjectArray[this.Param] instanceof ExpressionObject) {
                string = Zirkel.name("name.Expression");
            } else if (constructionObjectArray[this.Param] instanceof AreaObject) {
                string = Zirkel.name("name.Polygon");
            } else if (constructionObjectArray[this.Param] instanceof AngleObject) {
                string = Zirkel.name("name.Angle");
            }
            String string2 = this.M.getLast(this.Param);
            String string3 = string2.equals("") ? ConstructionObject.text4(Zirkel.name("message.runmacro"), this.M.getName(), "" + (this.Param + 1), string, this.S[this.Param]) : ConstructionObject.text4(Zirkel.name("message.runmacro"), this.M.getName(), "" + (this.Param + 1), string, this.S[this.Param]) + " " + ConstructionObject.text1(Zirkel.name("message.runmacro.return"), this.M.getLast(this.Param));
            zirkelCanvas.showStatus(string3);
        }
    }

    public void runMacro(ZirkelCanvas zirkelCanvas, Construction construction, String[] stringArray) {
        Object object;
        Object object2;
        int n;
        ConstructionObject[] constructionObjectArray;
        this.M.setTranslation(construction);
        ConstructionObject constructionObject = construction.last();
        int n2 = this.Params.length;
        Enumeration enumeration = this.M.elements();
        while (enumeration.hasMoreElements()) {
            constructionObjectArray = (ConstructionObject[])enumeration.nextElement();
            constructionObjectArray.clearParameter();
            constructionObjectArray.setTranslation(null);
        }
        this.M.clearTranslations();
        construction.clearTranslators();
        constructionObjectArray = this.M.getParams();
        this.M.initLast();
        for (n = 0; n < n2; ++n) {
            ConstructionObject constructionObject2;
            this.M.setLast(this.Params[n].getName(), n);
            constructionObjectArray[n].setTranslation(this.Params[n]);
            constructionObjectArray[n].setMainParameter();
            if (this.NewPoint[n] && constructionObjectArray[n].isHidden()) {
                this.Params[n].setHidden(true);
            }
            if (this.Params[n] instanceof PointObject && constructionObjectArray[n] instanceof PointObject && this.NewPoint[n]) {
                object2 = (PointObject)this.Params[n];
                constructionObject2 = (PointObject)constructionObjectArray[n];
                ((PointObject)object2).setIncrement(((PointObject)constructionObject2).getIncrement());
                if (((PointObject)constructionObject2).getBound() != null) {
                    ((PointObject)object2).setBound(((PointObject)constructionObject2).getBound());
                    ((PointObject)object2).setInside(((PointObject)constructionObject2).isInside());
                    ((PointObject)object2).translate();
                }
            }
            if (this.Params[n] instanceof PointObject && constructionObjectArray[n] instanceof PointObject && ((PointObject)constructionObjectArray[n]).dependsOnItselfOnly() && !((PointObject)(object2 = (PointObject)this.Params[n])).depending().hasMoreElements()) {
                ((ConstructionObject)object2).setConstruction(this.M);
                ((PointObject)object2).setFixed(((PointObject)constructionObjectArray[n]).getEX(), ((PointObject)constructionObjectArray[n]).getEY());
                ((ConstructionObject)object2).translateConditionals();
                ((PointObject)object2).translate();
                ((ConstructionObject)object2).setConstruction(construction);
            }
            if (!constructionObjectArray[n].isMainParameter()) continue;
            enumeration = constructionObjectArray[n].secondaryParams();
            DL.reset();
            while (enumeration.hasMoreElements()) {
                object2 = (ConstructionObject)enumeration.nextElement();
                DL.add((ConstructionObject)object2);
                ((ConstructionObject)object2).setParameter();
            }
            enumeration = DL.elements();
            object2 = this.Params[n].secondaryParams();
            while (object2.hasMoreElements() && enumeration.hasMoreElements()) {
                constructionObject2 = (ConstructionObject)enumeration.nextElement();
                object = (ConstructionObject)object2.nextElement();
                if (constructionObject2.getTranslation() != object && constructionObject2.getTranslation() != null) {
                    zirkelCanvas.warning(Zirkel.name("macro.usage"));
                    return;
                }
                constructionObject2.setTranslation((ConstructionObject)object);
            }
        }
        enumeration = this.M.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject3 = (ConstructionObject)enumeration.nextElement();
            if (constructionObject3.isParameter()) continue;
            object2 = constructionObject3.copy();
            ((ConstructionObject)object2).setKeep(false);
            ((ConstructionObject)object2).setTarget(false);
            construction.addNoCheck((ConstructionObject)object2);
            constructionObject3.setTranslation((ConstructionObject)object2);
            ((ConstructionObject)object2).validate();
            construction.added((ConstructionObject)object2);
            if (constructionObject3.isTarget()) {
                ((ConstructionObject)object2).setTargetDefaults();
            }
            if (((ConstructionObject)object2).getColorIndex() == 0) {
                ((ConstructionObject)object2).setColor(construction.DefaultColor);
            }
            if (!(object2 instanceof FixedCircleObject) && !(object2 instanceof FixedAngleObject) && !(object2 instanceof ExpressionObject) || !this.M.promptFor(constructionObject3.getName())) continue;
            construction.updateCircleDep();
            construction.dovalidate();
            zirkelCanvas.repaint();
            int n3 = this.M.getPromptFor(constructionObject3.getName());
            object = "";
            if (n3 >= stringArray.length || stringArray[n3].equals("")) {
                MacroPrompt macroPrompt = new MacroPrompt(zirkelCanvas.getFrame(), this.M.getPromptName(constructionObject3.getName()));
                macroPrompt.setVisible(true);
                if (macroPrompt.isValid()) {
                    object = macroPrompt.getValue();
                }
            } else {
                object = stringArray[n3];
            }
            if (!((String)object).equals("")) {
                ((ConstructionObject)object2).setFixed((String)object);
                zirkelCanvas.check();
                continue;
            }
            zirkelCanvas.warning(Zirkel.name("macro.prompt.illegal"));
        }
        enumeration = this.M.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject4 = (ConstructionObject)enumeration.nextElement();
            if (constructionObject4.isParameter()) continue;
            constructionObject4.laterTranslate(this.M);
        }
        construction.updateCircleDep();
        construction.runTranslators(this.M);
        construction.dovalidate();
        zirkelCanvas.repaint();
        n = 0;
        for (int i = 0; i < this.Fixed.length; ++i) {
            if (!this.Fixed[i]) continue;
            ++n;
        }
        if (n > 0 && n < this.Fixed.length && !this.M.hasFixed()) {
            int n4;
            String string = this.M.getName() + " -";
            for (n4 = 0; n4 < this.Fixed.length; ++n4) {
                if (!this.Fixed[n4]) continue;
                string = string + " " + this.M.LastParams[n4];
            }
            this.M = zirkelCanvas.copyMacro(this.M, string, this.Fixed);
            for (n4 = 0; n4 < this.Fixed.length; ++n4) {
                this.Fixed[n4] = false;
            }
            this.reset(zirkelCanvas);
        }
        if (constructionObject != null && this.M.hideDuplicates()) {
            zirkelCanvas.hideDuplicates(constructionObject);
        }
    }

    public void runMacro(ZirkelCanvas zirkelCanvas, String[] stringArray) {
        this.runMacro(zirkelCanvas, zirkelCanvas.getConstruction(), stringArray);
    }

    public void runMacroPreview(ZirkelCanvas zirkelCanvas) {
        Object object;
        ConstructionObject[] constructionObjectArray;
        Construction construction = zirkelCanvas.getConstruction();
        this.M.setTranslation(construction);
        int n = this.Params.length;
        Enumeration enumeration = this.M.elements();
        while (enumeration.hasMoreElements()) {
            constructionObjectArray = (ConstructionObject[])enumeration.nextElement();
            constructionObjectArray.clearParameter();
            constructionObjectArray.setTranslation(null);
        }
        this.M.clearTranslations();
        construction.clearTranslators();
        constructionObjectArray = this.M.getParams();
        for (int i = 0; i < n; ++i) {
            this.M.setLast(this.Params[i].getName(), i);
            constructionObjectArray[i].setTranslation(this.Params[i]);
            constructionObjectArray[i].setMainParameter();
            if (this.NewPoint[i] && constructionObjectArray[i].isHidden()) {
                this.Params[i].setHidden(true);
            }
            if (!constructionObjectArray[i].isMainParameter()) continue;
            enumeration = constructionObjectArray[i].secondaryParams();
            DL.reset();
            while (enumeration.hasMoreElements()) {
                object = (ConstructionObject)enumeration.nextElement();
                DL.add((ConstructionObject)object);
                ((ConstructionObject)object).setParameter();
            }
            enumeration = DL.elements();
            object = this.Params[i].secondaryParams();
            while (object.hasMoreElements() && enumeration.hasMoreElements()) {
                ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
                ConstructionObject constructionObject2 = (ConstructionObject)object.nextElement();
                if (constructionObject.getTranslation() != constructionObject2 && constructionObject.getTranslation() != null) {
                    return;
                }
                if (constructionObject == null) continue;
                constructionObject.setTranslation(constructionObject2);
            }
        }
        enumeration = this.M.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (constructionObject.isParameter()) continue;
            object = constructionObject.copy();
            ((ConstructionObject)object).setKeep(false);
            ((ConstructionObject)object).setTarget(false);
            ((ConstructionObject)object).setSelectable(false);
            ((ConstructionObject)object).setIndicated(true);
            construction.addNoCheck((ConstructionObject)object);
            constructionObject.setTranslation((ConstructionObject)object);
            ((ConstructionObject)object).validate();
            construction.added((ConstructionObject)object);
            if (constructionObject.isTarget()) {
                ((ConstructionObject)object).setTargetDefaults();
            }
            if (constructionObject.isHidden()) {
                ((ConstructionObject)object).setHidden(true);
            }
            if (((ConstructionObject)object).getColorIndex() != 0) continue;
            ((ConstructionObject)object).setColor(construction.DefaultColor);
        }
        enumeration = this.M.elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (constructionObject.isParameter()) continue;
            constructionObject.laterTranslate(this.M);
        }
        construction.updateCircleDep();
        construction.runTranslators(this.M);
        construction.dovalidate();
        zirkelCanvas.repaint();
    }

    public void run(ZirkelCanvas zirkelCanvas, Construction construction, String string, String[] stringArray, int n) throws ConstructionException {
        Object object;
        int n2;
        ConstructionObject[] constructionObjectArray = this.M.getParams();
        if (n != constructionObjectArray.length + this.M.countPrompts()) {
            throw new ConstructionException(Zirkel.name("exception.nparams"));
        }
        String[] stringArray2 = new String[this.M.countPrompts()];
        for (n2 = 0; n2 < this.M.countPrompts(); ++n2) {
            stringArray2[n2] = stringArray[constructionObjectArray.length + n2];
        }
        for (n2 = 0; n2 < constructionObjectArray.length; ++n2) {
            object = construction.find(stringArray[n2]);
            if (object == null) {
                throw new ConstructionException(Zirkel.name("exception.notfound"));
            }
            if (constructionObjectArray[this.Param] instanceof PointObject) {
                if (!(object instanceof PointObject)) {
                    throw new ConstructionException(Zirkel.name("exception.type"));
                }
                if (constructionObjectArray[this.Param] instanceof SegmentObject) {
                    if (!(object instanceof SegmentObject)) {
                        throw new ConstructionException(Zirkel.name("exception.type"));
                    }
                    if (constructionObjectArray[this.Param] instanceof LineObject) {
                        if (!(object instanceof LineObject)) {
                            throw new ConstructionException(Zirkel.name("exception.type"));
                        }
                        if (constructionObjectArray[this.Param] instanceof RayObject) {
                            if (!(object instanceof RayObject)) {
                                throw new ConstructionException(Zirkel.name("exception.type"));
                            }
                            if (constructionObjectArray[this.Param] instanceof PrimitiveLineObject) {
                                if (!(object instanceof PrimitiveLineObject)) {
                                    throw new ConstructionException(Zirkel.name("exception.type"));
                                }
                                if (constructionObjectArray[this.Param] instanceof PrimitiveCircleObject) {
                                    if (!(object instanceof PrimitiveCircleObject)) {
                                        throw new ConstructionException(Zirkel.name("exception.type"));
                                    }
                                    throw new ConstructionException(Zirkel.name("exception.type"));
                                }
                            }
                        }
                    }
                }
            }
            this.Params[n2] = object;
        }
        this.runMacro(zirkelCanvas, construction, stringArray2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        object = this.M.getTargets().elements();
        while (object.hasMoreElements() && stringTokenizer.hasMoreTokens()) {
            ConstructionObject constructionObject = (ConstructionObject)object.nextElement();
            constructionObject.getTranslation().setName(stringTokenizer.nextToken().trim());
        }
        zirkelCanvas.repaint();
    }
}

