; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
;; Test the strict-align feature which is similar to AArch64/arm64-strict-align.ll.

; RUN: llc --mtriple=mipsisa32r6 < %s | FileCheck %s --check-prefix=MIPS32R6-UNALIGNED
; RUN: llc --mtriple=mipsisa32r6 --mattr=-strict-align < %s | FileCheck %s --check-prefix=MIPS32R6-UNALIGNED
; RUN: llc --mtriple=mipsisa32r6 --mattr=+strict-align < %s | FileCheck %s --check-prefix=MIPS32R6-ALIGNED

; RUN: llc --mtriple=mipsisa64r6 < %s | FileCheck %s --check-prefix=MIPS64R6-UNALIGNED
; RUN: llc --mtriple=mipsisa64r6 --mattr=-strict-align < %s | FileCheck %s --check-prefix=MIPS64R6-UNALIGNED
; RUN: llc --mtriple=mipsisa64r6 --mattr=+strict-align < %s | FileCheck %s --check-prefix=MIPS64R6-ALIGNED

define i32 @f0(ptr %p) nounwind {
; MIPS32R6-UNALIGNED-LABEL: f0:
; MIPS32R6-UNALIGNED:       # %bb.0:
; MIPS32R6-UNALIGNED-NEXT:    lw $2, 0($4)
; MIPS32R6-UNALIGNED-NEXT:    jrc $ra
;
; MIPS32R6-ALIGNED-LABEL: f0:
; MIPS32R6-ALIGNED:       # %bb.0:
; MIPS32R6-ALIGNED-NEXT:    lhu $1, 2($4)
; MIPS32R6-ALIGNED-NEXT:    lhu $2, 0($4)
; MIPS32R6-ALIGNED-NEXT:    sll $2, $2, 16
; MIPS32R6-ALIGNED-NEXT:    jr $ra
; MIPS32R6-ALIGNED-NEXT:    or $2, $2, $1
;
; MIPS64R6-UNALIGNED-LABEL: f0:
; MIPS64R6-UNALIGNED:       # %bb.0:
; MIPS64R6-UNALIGNED-NEXT:    lw $2, 0($4)
; MIPS64R6-UNALIGNED-NEXT:    jrc $ra
;
; MIPS64R6-ALIGNED-LABEL: f0:
; MIPS64R6-ALIGNED:       # %bb.0:
; MIPS64R6-ALIGNED-NEXT:    lhu $1, 2($4)
; MIPS64R6-ALIGNED-NEXT:    lhu $2, 0($4)
; MIPS64R6-ALIGNED-NEXT:    sll $2, $2, 16
; MIPS64R6-ALIGNED-NEXT:    jr $ra
; MIPS64R6-ALIGNED-NEXT:    or $2, $2, $1
  %tmp = load i32, ptr %p, align 2
  ret i32 %tmp
}

define i64 @f1(ptr %p) nounwind {
; MIPS32R6-UNALIGNED-LABEL: f1:
; MIPS32R6-UNALIGNED:       # %bb.0:
; MIPS32R6-UNALIGNED-NEXT:    lw $2, 0($4)
; MIPS32R6-UNALIGNED-NEXT:    lw $3, 4($4)
; MIPS32R6-UNALIGNED-NEXT:    jrc $ra
;
; MIPS32R6-ALIGNED-LABEL: f1:
; MIPS32R6-ALIGNED:       # %bb.0:
; MIPS32R6-ALIGNED-NEXT:    lw $2, 0($4)
; MIPS32R6-ALIGNED-NEXT:    lw $3, 4($4)
; MIPS32R6-ALIGNED-NEXT:    jrc $ra
;
; MIPS64R6-UNALIGNED-LABEL: f1:
; MIPS64R6-UNALIGNED:       # %bb.0:
; MIPS64R6-UNALIGNED-NEXT:    ld $2, 0($4)
; MIPS64R6-UNALIGNED-NEXT:    jrc $ra
;
; MIPS64R6-ALIGNED-LABEL: f1:
; MIPS64R6-ALIGNED:       # %bb.0:
; MIPS64R6-ALIGNED-NEXT:    lwu $1, 4($4)
; MIPS64R6-ALIGNED-NEXT:    lwu $2, 0($4)
; MIPS64R6-ALIGNED-NEXT:    dsll $2, $2, 32
; MIPS64R6-ALIGNED-NEXT:    jr $ra
; MIPS64R6-ALIGNED-NEXT:    or $2, $2, $1
  %tmp = load i64, ptr %p, align 4
  ret i64 %tmp
}
