; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=thumbv6m-none-unknown-eabi -mcpu=cortex-m0 | FileCheck %s --check-prefix=ARM

declare  i4  @llvm.umul.fix.sat.i4   (i4,  i4, i32)
declare  i32 @llvm.umul.fix.sat.i32  (i32, i32, i32)
declare  i64 @llvm.umul.fix.sat.i64  (i64, i64, i32)

define i32 @func(i32 %x, i32 %y) nounwind {
; ARM-LABEL: func:
; ARM:       @ %bb.0:
; ARM-NEXT:    .save {r4, lr}
; ARM-NEXT:    push {r4, lr}
; ARM-NEXT:    mov r2, r1
; ARM-NEXT:    movs r4, #0
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    mov r3, r4
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    cmp r1, #3
; ARM-NEXT:    bhi .LBB0_2
; ARM-NEXT:  @ %bb.1:
; ARM-NEXT:    lsrs r0, r0, #2
; ARM-NEXT:    lsls r1, r1, #30
; ARM-NEXT:    adds r0, r1, r0
; ARM-NEXT:    pop {r4, pc}
; ARM-NEXT:  .LBB0_2:
; ARM-NEXT:    mvns r0, r4
; ARM-NEXT:    pop {r4, pc}
  %tmp = call i32 @llvm.umul.fix.sat.i32(i32 %x, i32 %y, i32 2)
  ret i32 %tmp
}

define i64 @func2(i64 %x, i64 %y) nounwind {
; ARM-LABEL: func2:
; ARM:       @ %bb.0:
; ARM-NEXT:    .save {r4, r5, r6, r7, lr}
; ARM-NEXT:    push {r4, r5, r6, r7, lr}
; ARM-NEXT:    .pad #20
; ARM-NEXT:    sub sp, #20
; ARM-NEXT:    str r3, [sp, #12] @ 4-byte Spill
; ARM-NEXT:    mov r6, r2
; ARM-NEXT:    mov r7, r1
; ARM-NEXT:    str r1, [sp, #8] @ 4-byte Spill
; ARM-NEXT:    mov r5, r0
; ARM-NEXT:    movs r4, #0
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    mov r3, r4
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    str r0, [sp, #16] @ 4-byte Spill
; ARM-NEXT:    str r1, [sp, #4] @ 4-byte Spill
; ARM-NEXT:    mov r0, r7
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    mov r2, r6
; ARM-NEXT:    mov r3, r4
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    mov r6, r1
; ARM-NEXT:    ldr r1, [sp, #4] @ 4-byte Reload
; ARM-NEXT:    adds r7, r0, r1
; ARM-NEXT:    adcs r6, r4
; ARM-NEXT:    mov r0, r5
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    ldr r5, [sp, #12] @ 4-byte Reload
; ARM-NEXT:    mov r2, r5
; ARM-NEXT:    mov r3, r4
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    adds r0, r0, r7
; ARM-NEXT:    str r0, [sp, #4] @ 4-byte Spill
; ARM-NEXT:    adcs r1, r4
; ARM-NEXT:    adds r6, r6, r1
; ARM-NEXT:    mov r7, r4
; ARM-NEXT:    adcs r7, r4
; ARM-NEXT:    ldr r0, [sp, #8] @ 4-byte Reload
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    mov r2, r5
; ARM-NEXT:    mov r3, r4
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    adds r0, r0, r6
; ARM-NEXT:    adcs r1, r7
; ARM-NEXT:    lsrs r6, r0, #2
; ARM-NEXT:    orrs r6, r1
; ARM-NEXT:    lsls r0, r0, #30
; ARM-NEXT:    ldr r3, [sp, #4] @ 4-byte Reload
; ARM-NEXT:    lsrs r1, r3, #2
; ARM-NEXT:    adds r2, r0, r1
; ARM-NEXT:    lsls r0, r3, #30
; ARM-NEXT:    ldr r1, [sp, #16] @ 4-byte Reload
; ARM-NEXT:    lsrs r1, r1, #2
; ARM-NEXT:    adds r3, r0, r1
; ARM-NEXT:    mvns r1, r4
; ARM-NEXT:    cmp r6, #0
; ARM-NEXT:    mov r0, r1
; ARM-NEXT:    beq .LBB1_3
; ARM-NEXT:  @ %bb.1:
; ARM-NEXT:    beq .LBB1_4
; ARM-NEXT:  .LBB1_2:
; ARM-NEXT:    add sp, #20
; ARM-NEXT:    pop {r4, r5, r6, r7, pc}
; ARM-NEXT:  .LBB1_3:
; ARM-NEXT:    mov r0, r3
; ARM-NEXT:    bne .LBB1_2
; ARM-NEXT:  .LBB1_4:
; ARM-NEXT:    mov r1, r2
; ARM-NEXT:    add sp, #20
; ARM-NEXT:    pop {r4, r5, r6, r7, pc}
  %tmp = call i64 @llvm.umul.fix.sat.i64(i64 %x, i64 %y, i32 2)
  ret i64 %tmp
}

define i4 @func3(i4 %x, i4 %y) nounwind {
; ARM-LABEL: func3:
; ARM:       @ %bb.0:
; ARM-NEXT:    .save {r4, lr}
; ARM-NEXT:    push {r4, lr}
; ARM-NEXT:    movs r2, #15
; ARM-NEXT:    ands r2, r1
; ARM-NEXT:    lsls r0, r0, #28
; ARM-NEXT:    movs r4, #0
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    mov r3, r4
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    cmp r1, #3
; ARM-NEXT:    bhi .LBB2_2
; ARM-NEXT:  @ %bb.1:
; ARM-NEXT:    lsrs r0, r0, #2
; ARM-NEXT:    lsls r1, r1, #30
; ARM-NEXT:    adds r0, r1, r0
; ARM-NEXT:    lsrs r0, r0, #28
; ARM-NEXT:    pop {r4, pc}
; ARM-NEXT:  .LBB2_2:
; ARM-NEXT:    mvns r0, r4
; ARM-NEXT:    lsrs r0, r0, #28
; ARM-NEXT:    pop {r4, pc}
  %tmp = call i4 @llvm.umul.fix.sat.i4(i4 %x, i4 %y, i32 2)
  ret i4 %tmp
}

;; These result in regular integer multiplication with a saturation check.
define i32 @func4(i32 %x, i32 %y) nounwind {
; ARM-LABEL: func4:
; ARM:       @ %bb.0:
; ARM-NEXT:    .save {r4, lr}
; ARM-NEXT:    push {r4, lr}
; ARM-NEXT:    mov r2, r1
; ARM-NEXT:    movs r4, #0
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    mov r3, r4
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    cmp r1, #0
; ARM-NEXT:    bls .LBB3_2
; ARM-NEXT:  @ %bb.1:
; ARM-NEXT:    mvns r0, r4
; ARM-NEXT:  .LBB3_2:
; ARM-NEXT:    pop {r4, pc}
  %tmp = call i32 @llvm.umul.fix.sat.i32(i32 %x, i32 %y, i32 0)
  ret i32 %tmp
}

define i64 @func5(i64 %x, i64 %y) {
; ARM-LABEL: func5:
; ARM:       @ %bb.0:
; ARM-NEXT:    .save {r4, r5, r6, r7, lr}
; ARM-NEXT:    push {r4, r5, r6, r7, lr}
; ARM-NEXT:    .pad #12
; ARM-NEXT:    sub sp, #12
; ARM-NEXT:    mov r6, r3
; ARM-NEXT:    str r2, [sp, #8] @ 4-byte Spill
; ARM-NEXT:    mov r4, r1
; ARM-NEXT:    mov r2, r0
; ARM-NEXT:    str r0, [sp, #4] @ 4-byte Spill
; ARM-NEXT:    movs r5, #0
; ARM-NEXT:    mov r0, r3
; ARM-NEXT:    mov r1, r5
; ARM-NEXT:    mov r3, r5
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    str r0, [sp] @ 4-byte Spill
; ARM-NEXT:    mov r7, r1
; ARM-NEXT:    subs r0, r1, #1
; ARM-NEXT:    sbcs r7, r0
; ARM-NEXT:    mov r0, r4
; ARM-NEXT:    mov r1, r5
; ARM-NEXT:    ldr r2, [sp, #8] @ 4-byte Reload
; ARM-NEXT:    mov r3, r5
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    subs r2, r1, #1
; ARM-NEXT:    sbcs r1, r2
; ARM-NEXT:    subs r2, r6, #1
; ARM-NEXT:    sbcs r6, r2
; ARM-NEXT:    subs r2, r4, #1
; ARM-NEXT:    sbcs r4, r2
; ARM-NEXT:    ands r4, r6
; ARM-NEXT:    orrs r4, r1
; ARM-NEXT:    orrs r4, r7
; ARM-NEXT:    ldr r1, [sp] @ 4-byte Reload
; ARM-NEXT:    adds r6, r0, r1
; ARM-NEXT:    ldr r0, [sp, #4] @ 4-byte Reload
; ARM-NEXT:    mov r1, r5
; ARM-NEXT:    ldr r2, [sp, #8] @ 4-byte Reload
; ARM-NEXT:    mov r3, r5
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    adds r3, r1, r6
; ARM-NEXT:    mov r2, r5
; ARM-NEXT:    adcs r2, r5
; ARM-NEXT:    orrs r2, r4
; ARM-NEXT:    mvns r1, r5
; ARM-NEXT:    cmp r2, #0
; ARM-NEXT:    mov r2, r1
; ARM-NEXT:    bne .LBB4_2
; ARM-NEXT:  @ %bb.1:
; ARM-NEXT:    mov r2, r0
; ARM-NEXT:  .LBB4_2:
; ARM-NEXT:    bne .LBB4_4
; ARM-NEXT:  @ %bb.3:
; ARM-NEXT:    mov r1, r3
; ARM-NEXT:  .LBB4_4:
; ARM-NEXT:    mov r0, r2
; ARM-NEXT:    add sp, #12
; ARM-NEXT:    pop {r4, r5, r6, r7, pc}
  %tmp = call i64 @llvm.umul.fix.sat.i64(i64 %x, i64 %y, i32 0)
  ret i64 %tmp
}

define i4 @func6(i4 %x, i4 %y) nounwind {
; ARM-LABEL: func6:
; ARM:       @ %bb.0:
; ARM-NEXT:    .save {r4, lr}
; ARM-NEXT:    push {r4, lr}
; ARM-NEXT:    movs r2, #15
; ARM-NEXT:    ands r2, r1
; ARM-NEXT:    lsls r0, r0, #28
; ARM-NEXT:    movs r4, #0
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    mov r3, r4
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    cmp r1, #0
; ARM-NEXT:    bls .LBB5_2
; ARM-NEXT:  @ %bb.1:
; ARM-NEXT:    mvns r0, r4
; ARM-NEXT:  .LBB5_2:
; ARM-NEXT:    lsrs r0, r0, #28
; ARM-NEXT:    pop {r4, pc}
  %tmp = call i4 @llvm.umul.fix.sat.i4(i4 %x, i4 %y, i32 0)
  ret i4 %tmp
}

define <4 x i32> @vec2(<4 x i32> %x, <4 x i32> %y) nounwind {
; ARM-LABEL: vec2:
; ARM:       @ %bb.0:
; ARM-NEXT:    .save {r4, r5, r6, r7, lr}
; ARM-NEXT:    push {r4, r5, r6, r7, lr}
; ARM-NEXT:    .pad #12
; ARM-NEXT:    sub sp, #12
; ARM-NEXT:    str r3, [sp, #8] @ 4-byte Spill
; ARM-NEXT:    mov r7, r2
; ARM-NEXT:    mov r5, r1
; ARM-NEXT:    ldr r2, [sp, #32]
; ARM-NEXT:    movs r6, #0
; ARM-NEXT:    mov r1, r6
; ARM-NEXT:    mov r3, r6
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    mvns r4, r6
; ARM-NEXT:    cmp r1, #0
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    bhi .LBB6_2
; ARM-NEXT:  @ %bb.1:
; ARM-NEXT:    mov r1, r0
; ARM-NEXT:  .LBB6_2:
; ARM-NEXT:    str r1, [sp, #4] @ 4-byte Spill
; ARM-NEXT:    ldr r2, [sp, #36]
; ARM-NEXT:    mov r0, r5
; ARM-NEXT:    mov r1, r6
; ARM-NEXT:    mov r3, r6
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    cmp r1, #0
; ARM-NEXT:    mov r5, r4
; ARM-NEXT:    bhi .LBB6_4
; ARM-NEXT:  @ %bb.3:
; ARM-NEXT:    mov r5, r0
; ARM-NEXT:  .LBB6_4:
; ARM-NEXT:    ldr r2, [sp, #40]
; ARM-NEXT:    mov r0, r7
; ARM-NEXT:    mov r1, r6
; ARM-NEXT:    mov r3, r6
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    cmp r1, #0
; ARM-NEXT:    mov r7, r4
; ARM-NEXT:    bhi .LBB6_6
; ARM-NEXT:  @ %bb.5:
; ARM-NEXT:    mov r7, r0
; ARM-NEXT:  .LBB6_6:
; ARM-NEXT:    ldr r2, [sp, #44]
; ARM-NEXT:    ldr r0, [sp, #8] @ 4-byte Reload
; ARM-NEXT:    mov r1, r6
; ARM-NEXT:    mov r3, r6
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    cmp r1, #0
; ARM-NEXT:    bhi .LBB6_8
; ARM-NEXT:  @ %bb.7:
; ARM-NEXT:    mov r4, r0
; ARM-NEXT:  .LBB6_8:
; ARM-NEXT:    ldr r0, [sp, #4] @ 4-byte Reload
; ARM-NEXT:    mov r1, r5
; ARM-NEXT:    mov r2, r7
; ARM-NEXT:    mov r3, r4
; ARM-NEXT:    add sp, #12
; ARM-NEXT:    pop {r4, r5, r6, r7, pc}
  %tmp = call <4 x i32> @llvm.umul.fix.sat.v4i32(<4 x i32> %x, <4 x i32> %y, i32 0)
  ret <4 x i32> %tmp
}

define i64 @func7(i64 %x, i64 %y) nounwind {
; ARM-LABEL: func7:
; ARM:       @ %bb.0:
; ARM-NEXT:    .save {r4, r5, r6, r7, lr}
; ARM-NEXT:    push {r4, r5, r6, r7, lr}
; ARM-NEXT:    .pad #12
; ARM-NEXT:    sub sp, #12
; ARM-NEXT:    str r3, [sp, #8] @ 4-byte Spill
; ARM-NEXT:    mov r5, r2
; ARM-NEXT:    mov r6, r1
; ARM-NEXT:    str r1, [sp, #4] @ 4-byte Spill
; ARM-NEXT:    mov r7, r0
; ARM-NEXT:    movs r4, #0
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    mov r3, r4
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    str r1, [sp] @ 4-byte Spill
; ARM-NEXT:    mov r0, r6
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    mov r2, r5
; ARM-NEXT:    mov r3, r4
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    mov r5, r1
; ARM-NEXT:    ldr r1, [sp] @ 4-byte Reload
; ARM-NEXT:    adds r0, r0, r1
; ARM-NEXT:    str r0, [sp] @ 4-byte Spill
; ARM-NEXT:    adcs r5, r4
; ARM-NEXT:    mov r0, r7
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    ldr r6, [sp, #8] @ 4-byte Reload
; ARM-NEXT:    mov r2, r6
; ARM-NEXT:    mov r3, r4
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    ldr r2, [sp] @ 4-byte Reload
; ARM-NEXT:    adds r0, r0, r2
; ARM-NEXT:    str r0, [sp] @ 4-byte Spill
; ARM-NEXT:    adcs r1, r4
; ARM-NEXT:    adds r5, r5, r1
; ARM-NEXT:    mov r7, r4
; ARM-NEXT:    adcs r7, r4
; ARM-NEXT:    ldr r0, [sp, #4] @ 4-byte Reload
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    mov r2, r6
; ARM-NEXT:    mov r3, r4
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    mov r2, r1
; ARM-NEXT:    adds r3, r0, r5
; ARM-NEXT:    adcs r2, r7
; ARM-NEXT:    mvns r1, r4
; ARM-NEXT:    cmp r2, #0
; ARM-NEXT:    mov r0, r1
; ARM-NEXT:    beq .LBB7_3
; ARM-NEXT:  @ %bb.1:
; ARM-NEXT:    beq .LBB7_4
; ARM-NEXT:  .LBB7_2:
; ARM-NEXT:    add sp, #12
; ARM-NEXT:    pop {r4, r5, r6, r7, pc}
; ARM-NEXT:  .LBB7_3:
; ARM-NEXT:    ldr r0, [sp] @ 4-byte Reload
; ARM-NEXT:    bne .LBB7_2
; ARM-NEXT:  .LBB7_4:
; ARM-NEXT:    mov r1, r3
; ARM-NEXT:    add sp, #12
; ARM-NEXT:    pop {r4, r5, r6, r7, pc}
  %tmp = call i64 @llvm.umul.fix.sat.i64(i64 %x, i64 %y, i32 32)
  ret i64 %tmp
}

define i64 @func8(i64 %x, i64 %y) nounwind {
; ARM-LABEL: func8:
; ARM:       @ %bb.0:
; ARM-NEXT:    .save {r4, r5, r6, r7, lr}
; ARM-NEXT:    push {r4, r5, r6, r7, lr}
; ARM-NEXT:    .pad #12
; ARM-NEXT:    sub sp, #12
; ARM-NEXT:    str r3, [sp, #8] @ 4-byte Spill
; ARM-NEXT:    mov r5, r2
; ARM-NEXT:    mov r6, r1
; ARM-NEXT:    str r1, [sp, #4] @ 4-byte Spill
; ARM-NEXT:    mov r7, r0
; ARM-NEXT:    movs r4, #0
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    mov r3, r4
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    str r1, [sp] @ 4-byte Spill
; ARM-NEXT:    mov r0, r6
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    mov r2, r5
; ARM-NEXT:    mov r3, r4
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    mov r5, r1
; ARM-NEXT:    ldr r1, [sp] @ 4-byte Reload
; ARM-NEXT:    adds r0, r0, r1
; ARM-NEXT:    str r0, [sp] @ 4-byte Spill
; ARM-NEXT:    adcs r5, r4
; ARM-NEXT:    mov r0, r7
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    ldr r6, [sp, #8] @ 4-byte Reload
; ARM-NEXT:    mov r2, r6
; ARM-NEXT:    mov r3, r4
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    ldr r2, [sp] @ 4-byte Reload
; ARM-NEXT:    adds r0, r0, r2
; ARM-NEXT:    str r0, [sp] @ 4-byte Spill
; ARM-NEXT:    adcs r1, r4
; ARM-NEXT:    adds r5, r5, r1
; ARM-NEXT:    mov r7, r4
; ARM-NEXT:    adcs r7, r4
; ARM-NEXT:    ldr r0, [sp, #4] @ 4-byte Reload
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    mov r2, r6
; ARM-NEXT:    mov r3, r4
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    adds r0, r0, r5
; ARM-NEXT:    adcs r1, r7
; ARM-NEXT:    lsls r1, r1, #1
; ARM-NEXT:    lsrs r5, r0, #31
; ARM-NEXT:    adds r2, r1, r5
; ARM-NEXT:    lsls r0, r0, #1
; ARM-NEXT:    ldr r1, [sp] @ 4-byte Reload
; ARM-NEXT:    lsrs r1, r1, #31
; ARM-NEXT:    adds r3, r0, r1
; ARM-NEXT:    mvns r1, r4
; ARM-NEXT:    cmp r5, #0
; ARM-NEXT:    mov r0, r1
; ARM-NEXT:    beq .LBB8_3
; ARM-NEXT:  @ %bb.1:
; ARM-NEXT:    beq .LBB8_4
; ARM-NEXT:  .LBB8_2:
; ARM-NEXT:    add sp, #12
; ARM-NEXT:    pop {r4, r5, r6, r7, pc}
; ARM-NEXT:  .LBB8_3:
; ARM-NEXT:    mov r0, r3
; ARM-NEXT:    bne .LBB8_2
; ARM-NEXT:  .LBB8_4:
; ARM-NEXT:    mov r1, r2
; ARM-NEXT:    add sp, #12
; ARM-NEXT:    pop {r4, r5, r6, r7, pc}
  %tmp = call i64 @llvm.umul.fix.sat.i64(i64 %x, i64 %y, i32 63)
  ret i64 %tmp
}
