#ifndef ICU4XCodePointSetData_H
#define ICU4XCodePointSetData_H
#include <stdio.h>
#include <stdint.h>
#include <stddef.h>
#include <stdbool.h>
#include "diplomat_runtime.h"

#ifdef __cplusplus
namespace capi {
#endif

typedef struct ICU4XCodePointSetData ICU4XCodePointSetData;
#ifdef __cplusplus
} // namespace capi
#endif
#include "CodePointRangeIterator.h"
#include "ICU4XDataProvider.h"
#include "diplomat_result_box_ICU4XCodePointSetData_ICU4XError.h"
#ifdef __cplusplus
namespace capi {
extern "C" {
#endif

bool ICU4XCodePointSetData_contains(const ICU4XCodePointSetData* self, char32_t cp);

bool ICU4XCodePointSetData_contains32(const ICU4XCodePointSetData* self, uint32_t cp);

CodePointRangeIterator* ICU4XCodePointSetData_iter_ranges(const ICU4XCodePointSetData* self);

CodePointRangeIterator* ICU4XCodePointSetData_iter_ranges_complemented(const ICU4XCodePointSetData* self);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_for_general_category_group(const ICU4XDataProvider* provider, uint32_t group);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_ascii_hex_digit(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_alnum(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_alphabetic(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_bidi_control(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_bidi_mirrored(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_blank(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_cased(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_case_ignorable(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_full_composition_exclusion(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_changes_when_casefolded(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_changes_when_casemapped(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_changes_when_nfkc_casefolded(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_changes_when_lowercased(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_changes_when_titlecased(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_changes_when_uppercased(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_dash(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_deprecated(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_default_ignorable_code_point(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_diacritic(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_emoji_modifier_base(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_emoji_component(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_emoji_modifier(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_emoji(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_emoji_presentation(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_extender(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_extended_pictographic(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_graph(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_grapheme_base(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_grapheme_extend(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_grapheme_link(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_hex_digit(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_hyphen(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_id_continue(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_ideographic(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_id_start(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_ids_binary_operator(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_ids_trinary_operator(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_join_control(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_logical_order_exception(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_lowercase(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_math(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_noncharacter_code_point(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_nfc_inert(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_nfd_inert(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_nfkc_inert(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_nfkd_inert(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_pattern_syntax(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_pattern_white_space(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_prepended_concatenation_mark(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_print(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_quotation_mark(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_radical(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_regional_indicator(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_soft_dotted(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_segment_starter(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_case_sensitive(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_sentence_terminal(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_terminal_punctuation(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_unified_ideograph(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_uppercase(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_variation_selector(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_white_space(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_xdigit(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_xid_continue(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_xid_start(const ICU4XDataProvider* provider);

diplomat_result_box_ICU4XCodePointSetData_ICU4XError ICU4XCodePointSetData_load_for_ecma262(const ICU4XDataProvider* provider, const char* property_name_data, size_t property_name_len);
void ICU4XCodePointSetData_destroy(ICU4XCodePointSetData* self);

#ifdef __cplusplus
} // extern "C"
} // namespace capi
#endif
#endif
