/* meta-cogl-drm-formats.h
 *
 * Copyright (C) 2020 Georges Basile Stavracas Neto <georges.stavracas@gmail.com>
 * Copyright (C) 2023 Collabora Ltd.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 */

#pragma once

#include <drm_fourcc.h>

#include "cogl/cogl.h"
#include "meta/meta-multi-texture-format.h"

/* Included in libdrm 2.4.125 */
#ifndef DRM_FORMAT_S010
#define DRM_FORMAT_S010 fourcc_code ('S', '0', '1', '0')
#endif
#ifndef DRM_FORMAT_S210
#define DRM_FORMAT_S210 fourcc_code ('S', '2', '1', '0')
#endif
#ifndef DRM_FORMAT_S410
#define DRM_FORMAT_S410 fourcc_code ('S', '4', '1', '0')
#endif
#ifndef DRM_FORMAT_S012
#define DRM_FORMAT_S012 fourcc_code ('S', '0', '1', '2')
#endif
#ifndef DRM_FORMAT_S212
#define DRM_FORMAT_S212 fourcc_code ('S', '2', '1', '2')
#endif
#ifndef DRM_FORMAT_S412
#define DRM_FORMAT_S412 fourcc_code ('S', '4', '1', '2')
#endif
#ifndef DRM_FORMAT_S016
#define DRM_FORMAT_S016 fourcc_code ('S', '0', '1', '6')
#endif
#ifndef DRM_FORMAT_S216
#define DRM_FORMAT_S216 fourcc_code ('S', '2', '1', '6')
#endif
#ifndef DRM_FORMAT_S416
#define DRM_FORMAT_S416 fourcc_code ('S', '4', '1', '6')
#endif

G_BEGIN_DECLS

typedef struct _MetaFormatInfo
{
  uint32_t drm_format;
  uint32_t opaque_substitute;
  CoglPixelFormat cogl_format;
  MetaMultiTextureFormat multi_texture_format;
} MetaFormatInfo;

static const MetaFormatInfo meta_format_info[] = {
/* DRM formats are defined as little-endian, not machine endian. */
#if G_BYTE_ORDER == G_LITTLE_ENDIAN
  { DRM_FORMAT_R8, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_R_8, META_MULTI_TEXTURE_FORMAT_INVALID },
  { DRM_FORMAT_R16, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_R_16, META_MULTI_TEXTURE_FORMAT_INVALID },
  { DRM_FORMAT_GR88, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_RG_88, META_MULTI_TEXTURE_FORMAT_INVALID },
  { DRM_FORMAT_GR1616, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_RG_1616, META_MULTI_TEXTURE_FORMAT_INVALID },
  { DRM_FORMAT_RGB565, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_RGB_565, META_MULTI_TEXTURE_FORMAT_SIMPLE },
  { DRM_FORMAT_RGBX8888, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_XBGR_8888, META_MULTI_TEXTURE_FORMAT_SIMPLE },
  { DRM_FORMAT_RGBA8888, DRM_FORMAT_RGBX8888, COGL_PIXEL_FORMAT_ABGR_8888_PRE, META_MULTI_TEXTURE_FORMAT_SIMPLE },
  { DRM_FORMAT_BGRX8888, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_XRGB_8888, META_MULTI_TEXTURE_FORMAT_SIMPLE },
  { DRM_FORMAT_BGRA8888, DRM_FORMAT_BGRX8888, COGL_PIXEL_FORMAT_ARGB_8888_PRE, META_MULTI_TEXTURE_FORMAT_SIMPLE },
  { DRM_FORMAT_XRGB8888, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_BGRX_8888, META_MULTI_TEXTURE_FORMAT_SIMPLE },
  { DRM_FORMAT_ARGB8888, DRM_FORMAT_XRGB8888, COGL_PIXEL_FORMAT_BGRA_8888_PRE, META_MULTI_TEXTURE_FORMAT_SIMPLE },
  { DRM_FORMAT_XBGR8888, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_RGBX_8888, META_MULTI_TEXTURE_FORMAT_SIMPLE },
  { DRM_FORMAT_ABGR8888, DRM_FORMAT_XBGR8888, COGL_PIXEL_FORMAT_RGBA_8888_PRE, META_MULTI_TEXTURE_FORMAT_SIMPLE },
  { DRM_FORMAT_XRGB2101010, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_XRGB_2101010, META_MULTI_TEXTURE_FORMAT_SIMPLE },
  { DRM_FORMAT_ARGB2101010, DRM_FORMAT_XRGB2101010, COGL_PIXEL_FORMAT_ARGB_2101010_PRE, META_MULTI_TEXTURE_FORMAT_SIMPLE },
  { DRM_FORMAT_XBGR2101010, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_XBGR_2101010, META_MULTI_TEXTURE_FORMAT_SIMPLE },
  { DRM_FORMAT_ABGR2101010, DRM_FORMAT_XBGR2101010, COGL_PIXEL_FORMAT_ABGR_2101010_PRE, META_MULTI_TEXTURE_FORMAT_SIMPLE },
  { DRM_FORMAT_XRGB16161616F, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_BGRX_FP_16161616, META_MULTI_TEXTURE_FORMAT_SIMPLE },
  { DRM_FORMAT_ARGB16161616F, DRM_FORMAT_XRGB16161616F, COGL_PIXEL_FORMAT_BGRA_FP_16161616_PRE, META_MULTI_TEXTURE_FORMAT_SIMPLE },
  { DRM_FORMAT_XBGR16161616F, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_RGBX_FP_16161616, META_MULTI_TEXTURE_FORMAT_SIMPLE },
  { DRM_FORMAT_ABGR16161616F, DRM_FORMAT_XBGR16161616F, COGL_PIXEL_FORMAT_RGBA_FP_16161616_PRE, META_MULTI_TEXTURE_FORMAT_SIMPLE },
  { DRM_FORMAT_YUYV, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_YUYV },
  { DRM_FORMAT_YVYU, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_YVYU },
  { DRM_FORMAT_UYVY, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_UYVY },
  { DRM_FORMAT_VYUY, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_VYUY },
  { DRM_FORMAT_NV12, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_NV12 },
  { DRM_FORMAT_NV21, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_NV21 },
  { DRM_FORMAT_NV16, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_NV16 },
  { DRM_FORMAT_NV61, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_NV61 },
  { DRM_FORMAT_NV24, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_NV24 },
  { DRM_FORMAT_NV42, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_NV42 },
  { DRM_FORMAT_P010, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_P010 },
  { DRM_FORMAT_P012, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_P012 },
  { DRM_FORMAT_P016, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_P016 },
  { DRM_FORMAT_YUV420, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_YUV420 },
  { DRM_FORMAT_YVU420, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_YVU420 },
  { DRM_FORMAT_YUV422, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_YUV422 },
  { DRM_FORMAT_YVU422, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_YVU422 },
  { DRM_FORMAT_YUV444, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_YUV444 },
  { DRM_FORMAT_YVU444, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_YVU444 },
  { DRM_FORMAT_S010, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_S010 },
  { DRM_FORMAT_S210, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_S210 },
  { DRM_FORMAT_S410, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_S410 },
  { DRM_FORMAT_S012, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_S012 },
  { DRM_FORMAT_S212, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_S212 },
  { DRM_FORMAT_S412, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_S412 },
  { DRM_FORMAT_S016, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_S016 },
  { DRM_FORMAT_S216, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_S216 },
  { DRM_FORMAT_S416, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_ANY, META_MULTI_TEXTURE_FORMAT_S416 },
#elif G_BYTE_ORDER == G_BIG_ENDIAN
  { DRM_FORMAT_RGBX8888, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_RGBX_8888, META_MULTI_TEXTURE_FORMAT_SIMPLE },
  { DRM_FORMAT_RGBA8888, DRM_FORMAT_RGBX8888, COGL_PIXEL_FORMAT_RGBA_8888_PRE, META_MULTI_TEXTURE_FORMAT_SIMPLE },
  { DRM_FORMAT_BGRX8888, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_BGRX_8888, META_MULTI_TEXTURE_FORMAT_SIMPLE },
  { DRM_FORMAT_BGRA8888, DRM_FORMAT_BGRX8888, COGL_PIXEL_FORMAT_BGRA_8888_PRE, META_MULTI_TEXTURE_FORMAT_SIMPLE },
  { DRM_FORMAT_XRGB8888, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_XRGB_8888, META_MULTI_TEXTURE_FORMAT_SIMPLE },
  { DRM_FORMAT_ARGB8888, DRM_FORMAT_XRGB8888, COGL_PIXEL_FORMAT_ARGB_8888_PRE, META_MULTI_TEXTURE_FORMAT_SIMPLE },
  { DRM_FORMAT_XBGR8888, DRM_FORMAT_INVALID, COGL_PIXEL_FORMAT_XBGR_8888, META_MULTI_TEXTURE_FORMAT_SIMPLE },
  { DRM_FORMAT_ABGR8888, DRM_FORMAT_XBGR8888, COGL_PIXEL_FORMAT_ABGR_8888_PRE, META_MULTI_TEXTURE_FORMAT_SIMPLE },
#else
#error "unexpected G_BYTE_ORDER"
#endif
};

const MetaFormatInfo *meta_format_info_from_drm_format (uint32_t drm_format);

const MetaFormatInfo *meta_format_info_from_cogl_format (CoglPixelFormat cogl_format);

G_END_DECLS
