.TH sane\-canon_pp 5 "11 Jul 2008" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane\-canon_pp
.SH NAME
sane\-canon_pp \- SANE backend for Canon CanoScan Parallel Port flatbed scanners
.SH DESCRIPTION
The
.B sane\-canon_pp
library implements a SANE (Scanner Access Now Easy) backend that provides
access to the following Canon flatbed scanners:
.PP
.RS
CanoScan FB320P
.br
CanoScan FB620P
.br
CanoScan FB330P
.br
CanoScan FB630P
.br
CanoScan N340P
.br
CanoScan N640P
.br
CanoScan N640P ex
.br
.RE
.PP
No USB scanners are supported and there are no plans to support them in the
future.  Other projects are working on support for USB scanners. See the
.I PROJECTS
file for more detail.  The FB310P and FB610P are re-badged Avision scanners
which use a different command set, so are unlikely to be supported by this
backend in the future.
.PP
IMPORTANT: this is alpha code. While we have made every effort to make it as
reliable as possible, it will not always work as expected.  Feedback is still
appreciated.  Please send any bug reports to the maintainers as listed on the
web page (listed in
.B SEE ALSO
below).

.SH "DEVICE NAMES"
This backend expects device names of the form presented by
.BR libieee1284 (3).
These names are highly dependent on operating system and version.

On Linux 2.4 kernels this will be of the form
.I "parport0"
or older (2.2 and before) kernels may produce names like
.IR "0x378"
(the base address of your port) or simply
.IR "0"
depending on your module configuration.  Check the contents of
.I /proc/parport
if it exists.  If you don't want to specify a default port (or don't know its
name), the backend should be able to detect which port your scanner is on.

.SH CONFIGURATION
The contents of the
.I canon_pp.conf
file is a list of options for the driver to use.  Empty lines and lines
starting with a hash mark (#) are ignored.
.PP
The supported options are currently
.BR ieee1284 ,
.BR calibrate ,
.BR init_mode ,
and
.BR force_nibble

.TP
.B ieee1284 port-name
Defines which port to use.  The format of port-name is OS dependent, based on
the names presented by
.BR libieee1284 (3).
Please only have one of these lines, or
all but one will be ignored.

.TP
.B calibrate cal-file [port-name]
Defines which calibration file to use on a per-port basis.  If you only have
one parport, the port-name argument may be omitted \- but be careful as this
will cause problems on multi-scanner systems.  You may have as many of these
lines as you like, as long as each has a unique port name.  The tilde (`~')
character is acceptable and will be expanded to the value of the
.B HOME
environment variable.

.TP
.B init_mode <AUTO|FB620P|FB630P> [port-name]
Defines which initialisation (wake-up) mode to use on a per-port basis.
If you only have one parport, the port-name argument may be omitted \- but
be careful as this may cause problems on multi-scanner systems.
You may have as many of these lines as you like, as long as each has a unique
port name.  The valid initialisation modes are FB620P (which strobes 10101010
and 01010101 on the data pins), FB630P (which strobes 11001100 and 00110011
on the data pins) and AUTO, which will try FB630P mode first then FB620P mode
second.  The FB620P mode is also used by the FB320P.  The FB630P mode is used
by the FB330P, N340P, and N640P.

.TP
.B force_nibble
Forces the driver to use nibble mode even if ECP mode is reported to work by
.BR libieee1284 (3).
This works-around the rare issue of ECP mode being reported to
work by the library, then not working.

.SH TIPS
.PP
Hit the "Calibrate" button before scanning.  It vastly improves the quality of
scans.
.PP
To enable automatic detection of your scanner, uncomment the "canon_pp" line
from
.I @CONFIGDIR@/dll.conf
.PP
.SH FILES
.TP
.I @CONFIGDIR@/canon_pp.conf
The backend configuration file (see also description of
.B SANE_CONFIG_DIR
below).
.TP
.I @LIBDIR@/libsane\-canon_pp.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane\-canon_pp.so
The shared library implementing this backend (present on systems that support
dynamic loading).
.SH ENVIRONMENT
.TP
.B SANE_CONFIG_DIR
This environment variable specifies the list of directories that may contain
the configuration file.  On *NIX systems, the directories are separated by a colon
(`:'), under OS/2, they are separated by a semi-colon (`;').  If this variable
is not set, the configuration file is searched in two default directories:
first, the current working directory (".") and then in
.IR @CONFIGDIR@ .
If the value of the environment variable ends with the directory separator
character, then the default directories are searched after the explicitly
specified directories. For example, setting
.B SANE_CONFIG_DIR
to "/tmp/config:" would result in directories
.IR tmp/config ,
.IR . ,
and
.I @CONFIGDIR@
being searched (in this order).
.TP
.B SANE_DEBUG_CANON_PP
If the library was compiled with debug support enabled, this environment
variable controls the debug level for this backend.  Higher debug levels
increase the verbosity of the output.

Example:
export SANE_DEBUG_CANON_PP=4
.SH NOTES
.B Features available in the Windows interface
.TP
.B Brightness and Contrast
These are not implemented, and probably never will be.  These appear to be
implemented entirely in software.  Use GIMP or a similar program if you need
these features.
.TP
.B Descreen Mode
This appears on our first analysis to be just oversampling with an
anti-aliasing filter.  Again, it seems to be implemented entirely in software,
so GIMP is your best bet for now.
.TP
.B Gamma Tables
This is under investigation, but for now only a simple gamma profile (ie: the
one returned during calibration) will be loaded.
.PP
.B Communication Problems
.PP
ECP mode in
.BR libieee1284 (3)
doesn't always work properly, even with new hardware.
We believe that this is a ppdev problem.  If you change the configuration file
to include
.B force_nibble
, the problem will go away, but you will only be able to scan in nibble mode.
.PP
Sometimes the scanner can be left in a state where our code cannot revive it.
If the backend reports no scanner present, try unplugging the power and
plugging it back in.  Also try unplugging printers from the pass-through port.
.PP
The scanner will not respond correctly to our commands when you first plug in
the power.  You may find if you try a scan very soon after plugging in the
power that the backend will incorrectly report that you have no scanner present.
To avoid this, give it about 10 seconds to reset itself before attempting any
scans.
.PP
.B Repeated Lines
.PP
Sometimes at high resolutions (ie. 600dpi) you will notice lines which appear
twice.  These lines correspond to points where the scanner head has stopped
during the scan (it stops every time the internal 64kb buffer is full).
Basically it's a mechanical problem inside the scanner, that the tolerance of
movement for a start/stop event is greater than 1/600 inches.  I've never tried
the windows driver so I'm not sure how (or if) it works around this problem,
but as we don't know how to rewind the scanner head to do these bits again,
there's currently no nice way to deal with the problem.
.PP
.B Grey-scale Scans
.PP
Be aware that the scanner uses the green LEDs to read grey-scale scans, meaning
green coloured things will appear lighter than normal, and red and blue
coloured items will appear darker than normal.  For high-accuracy grey-scale
scans of colour items, it's best just to scan in colour and convert to
grey-scale in graphics software such as the GIMP.
.PP
.B FB620P/FB320P Caveats
.PP
These models can not be reset in the same way as the others.  The windows driver
doesn't know how to reset them either \- when left with an inconsistent scanner,
it will start scanning half way down the page!
.PP
Aborting is known to work correctly on the FB*30P models, and is known to be
broken on the FB*20P models.  The FB620P which I tested on simply returns
garbage after a scan has been aborted using the method we know.
Aborting is able to leave the scanner in a state where it can be shut down,
but not where another scan can be made.


.SH "SEE ALSO"
.BR sane (7),
.BR sane\-dll(5),
.BR libieee1284 (3),
.br
.I http://canon\-fb330p.sourceforge.net/

.SH AUTHOR
This backend is primarily the work of Simon Krix (Reverse Engineering), and
Matthew Duggan (SANE interface).
.PP
Many thanks to Kevin Easton for his comments and help, and Kent A. Signorini
for his help with the N340P.
