#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Museum of Mechanics: Lockpicking
# send your bug reports to contact@dotslashplay.it
###

script_version=20241203.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='museum-of-mechanics-lockpicking'
GAME_NAME='Museum of Mechanics: Lockpicking'

ARCHIVE_BASE_1_NAME='museum-of-mechanics-lockpicking-linux.zip'
ARCHIVE_BASE_1_MD5='5b6d381d975867c75b797ec9ba3f45e1'
ARCHIVE_BASE_1_SIZE='282860'
ARCHIVE_BASE_1_VERSION='0.6.5-itch.2021.07.21'
ARCHIVE_BASE_1_URL='https://dimbulbgames.itch.io/museum-of-mechanics-lockpicking'

ARCHIVE_BASE_0_NAME='museum-of-mechanics-lockpicking-linux.zip'
ARCHIVE_BASE_0_MD5='6e47b913932abbba3d132c9d849b79fd'
ARCHIVE_BASE_0_SIZE='156246'
ARCHIVE_BASE_0_VERSION='0.2.2-itch.2020.08.29'

UNITY3D_NAME='Museum_Of_Mechanics'
## This game does not ship any Unity3D plugin.

CONTENT_PATH_DEFAULT='Museum of Mechanics - Linux'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libz.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
