; Documentation for the ACL2 Theorem Prover
; WARNING: GENERATED FILE, DO NOT HAND EDIT!
; The contents of this file are derived from ACL2 Community Book
; books/system/doc/acl2-doc.lisp.

; ACL2 Version 8.6 -- A Computational Logic for Applicative Common Lisp
; Copyright (C) 2024, Regents of the University of Texas

; This version of ACL2 is a descendent of ACL2 Version 1.9, Copyright
; (C) 1997 Computational Logic, Inc.  See the documentation topic NOTE-2-0.

; This program is free software; you can redistribute it and/or modify
; it under the terms of the LICENSE file distributed with ACL2.

; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; LICENSE for more details.

; Here are the original authors of books/system/doc/acl2-doc.lisp.
; Additional contributions may have been made to that file by members
; of the ACL2 community.

; Written by:  Matt Kaufmann               and J Strother Moore
; email:       Kaufmann@cs.utexas.edu      and Moore@cs.utexas.edu
; Department of Computer Science
; University of Texas at Austin
; Austin, TX 78701 U.S.A.

; WARNING: This file is generated from ACL2 Community Book
; books/system/doc/acl2-doc.lisp.  To edit ACL2 documentation modify
; that file, not this one!  Instructions are just above the in-package
; form in that book.

(in-package "ACL2")

(defconst *acl2-system-documentation* '
((&ALLOW-OTHER-KEYS (POINTERS)
                    "See [macro-args].")
 (&BODY (POINTERS) "See [macro-args].")
 (&KEY (POINTERS) "See [macro-args].")
 (&OPTIONAL (POINTERS)
            "See [macro-args].")
 (&REST (POINTERS) "See [macro-args].")
 (&WHOLE (POINTERS) "See [macro-args].")
 (*
  (NUMBERS ACL2-BUILT-INS)
  "Multiplication macro

  [47m*[0m is really a macro that expands to calls of the function [47m[binary-*][0m.
  So for example

    (* x y 4 z)

  represents the same term as

    (binary-* x (binary-* y (binary-* 4 z))).

  See [binary-*].

  [47m*[0m is a Common Lisp function.  See any Common Lisp documentation for
  more information.


Subtopics

  [Binary-*]
      Multiplication function")
 (*ACL2-EXPORTS*
  (PACKAGES ACL2-BUILT-INS)
  "Symbols that are often imported into new [packages] to provide easy
  access to ACL2 functionality.

  When you define a new package for your own work with [defpkg], you
  will usually want to import many symbols from the [47m\"ACL2\"[0m package;
  for instance you will usually want to be able to use symbols like
  [defthm], [in-theory], [xargs], [state], etc., without an [47macl2::[0m
  prefix.

  The constant [47m*acl2-exports*[0m lists [47m1659[0m symbols, including most
  documented ACL2 system constants, functions, and macros.  You will
  typically also want to import many symbols from Common Lisp; see
  [*common-lisp-symbols-from-main-lisp-package*].

  Those who write code using built-in ACL2 functions (see
  [ACL2-built-ins]) may wish to import symbols into their package
  from the large list [47m[*ACL2-system-exports*][0m.

    (& &allow-other-keys &aux &body &key
       &optional &rest &whole * *acl2-exports*
       *common-lisp-specials-and-constants*
       *common-lisp-symbols-from-main-lisp-package*
       *df-pi* *main-lisp-package-name*
       *standard-chars* *standard-ci*
       *standard-co* *standard-oi*
       + - / /= 1+ 1- < <-on-others
       <= = > >= ?-fn @ a! abort! abort-soft
       abs access accumulated-persistence
       accumulated-persistence-oops
       acl2-count acl2-input-channel-package
       acl2-number-listp acl2-numberp
       acl2-oracle acl2-output-channel-package
       acl2-package acl2-unwind-protect
       acons active-or-non-runep active-runep
       add-binop add-custom-keyword-hint
       add-default-hints add-default-hints!
       add-global-stobj add-include-book-dir
       add-include-book-dir!
       add-invisible-fns add-ld-keyword-alias
       add-ld-keyword-alias!
       add-macro-alias add-macro-fn
       add-match-free-override add-nth-alias
       add-override-hints add-override-hints!
       add-pair add-pair-preserves-all-boundp
       add-suffix add-suffix-to-fn add-timers
       add-to-set add-to-set-eq add-to-set-eql
       add-to-set-equal adjust-ld-history
       alistp alistp-forward-to-true-listp
       all-attachments
       all-boundp all-boundp-preserves-assoc
       all-vars all-vars1 all-vars1-lst
       allocate-fixnum-range alpha-char-p
       alpha-char-p-forward-to-characterp
       alphorder always$ always$+
       and and-macro append append$ append$+
       apply$ apply$-guard apply$-lambda
       apply$-lambda-guard apply$-userfn
       aref1 aref2 args arities-okp arity
       array1p array1p-cons array1p-forward
       array1p-linear array2p array2p-cons
       array2p-forward array2p-linear
       aset1 aset1-trusted aset2 ash assert$
       assert* assert-event assign assoc
       assoc-add-pair assoc-eq assoc-eq-equal
       assoc-eq-equal-alistp assoc-equal
       assoc-keyword assoc-string-equal assoc2
       associativity-of-* associativity-of-+
       assume atom atom-listp
       atom-listp-forward-to-true-listp
       attach-stobj backchain-limit
       badge badge-userfn binary-*
       binary-+ binary-append binary-df*
       binary-df+ binary-df-log binary-df/
       bind-free bit bitp boole$ boolean-listp
       boolean-listp-cons boolean-listp-forward
       boolean-listp-forward-to-symbol-listp
       booleanp booleanp-characterp
       booleanp-compound-recognizer
       bounded-integer-alistp
       bounded-integer-alistp-forward-to-eqlable-alistp
       bounded-integer-alistp2
       boundp-global boundp-global1 break$
       break-on-error brr brr-evisc-tuple
       brr-near-missp brr@ build-state1 butlast
       caaaar caaadr caaar caadar caaddr
       caadr caar cadaar cadadr cadar caddar
       cadddr caddr cadr canonical-pathname
       car car-cdr-elim car-cons case
       case-list case-list-check case-match
       case-split case-split-limitations
       case-test cbd cdaaar cdaadr
       cdaar cdadar cdaddr cdadr cdar cddaar
       cddadr cddar cdddar cddddr cdddr cddr
       cdr cdr-cons cdrn ceiling certify-book
       certify-book! change char char-code
       char-code-code-char-is-identity
       char-code-linear char-downcase
       char-equal char-upcase char< char<=
       char> char>= character character-alistp
       character-listp character-listp-append
       character-listp-coerce
       character-listp-forward-to-eqlable-listp
       character-listp-remove-duplicates-eql
       character-listp-revappend
       character-listp-string-downcase-1
       character-listp-string-upcase1-1
       characterp characterp-char-downcase
       characterp-char-upcase characterp-nth
       characterp-page characterp-return
       characterp-rubout characterp-tab
       check-invariant-risk check-vars-not-free
       checkpoint-forced-goals
       checkpoint-summary-limit
       clause clear-memoize-statistics
       clear-memoize-table clear-memoize-tables
       close-input-channel close-output-channel
       close-trace-file closure code-char
       code-char-char-code-is-identity
       code-char-type coerce coerce-inverse-1
       coerce-inverse-2 coerce-object-to-state
       coerce-state-to-object collect$
       collect$+ comment community-books
       commutativity-of-* commutativity-of-+
       comp compare-objects completion-of-*
       completion-of-+ completion-of-<
       completion-of-car completion-of-cdr
       completion-of-char-code
       completion-of-code-char
       completion-of-coerce
       completion-of-complex
       completion-of-denominator
       completion-of-imagpart
       completion-of-intern-in-package-of-symbol
       completion-of-numerator
       completion-of-realpart
       completion-of-symbol-name
       completion-of-symbol-package-name
       completion-of-unary-/
       completion-of-unary-minus
       complex complex-0
       complex-definition complex-equal
       complex-implies1 complex-rationalp
       complex/complex-rationalp
       compress1 compress11 compress2
       compress21 compress211 concatenate
       cond cond-clausesp cond-macro
       conjugate cons cons-equal cons-subtrees
       cons-with-hint consp consp-assoc-equal
       constraint-info corollary
       count-keys cpu-core-count ctx ctxp
       current-package current-theory cw cw!
       cw!+ cw+ cw-gstack cw-gstack-for-subterm
       cw-gstack-for-subterm*
       cw-gstack-for-term cw-gstack-for-term*
       cw-print-base-radix cw-print-base-radix!
       d< declare defabbrev
       defabsstobj defabsstobj-missing-events
       defattach defattach-system
       default default-*-1 default-*-2
       default-+-1 default-+-2 default-<-1
       default-<-2 default-backchain-limit
       default-car default-cdr
       default-char-code default-coerce-1
       default-coerce-2 default-coerce-3
       default-compile-fns default-complex-1
       default-complex-2 default-defun-mode
       default-defun-mode-from-state
       default-denominator
       default-hints default-imagpart
       default-measure-function
       default-numerator default-print-prompt
       default-realpart default-ruler-extenders
       default-state-vars default-symbol-name
       default-symbol-package-name
       default-total-parallelism-work-limit
       default-unary-/ default-unary-minus
       default-verify-guards-eagerness
       default-well-founded-relation
       defaxiom defbadge defchoose defcong
       defconst defequiv defevaluator defexec
       define-pc-atomic-macro define-pc-help
       define-pc-macro define-pc-meta
       define-trusted-clause-processor
       deflabel deflock defmacro defmacro-last
       defmacro-untouchable defn defnd defpkg
       defproxy defrec defrefinement defstobj
       defstub deftheory deftheory-static
       defthm defthm-std defthmd
       defthy defttag defun defun$ defun-df
       defun-inline defun-notinline defun-nx
       defun-sk defun-std defund defund-inline
       defund-notinline defund-nx defuns
       defuns-std defwarrant delete-assoc
       delete-assoc-eq delete-assoc-equal
       delete-file$ delete-include-book-dir
       delete-include-book-dir! denominator
       df* df+ df- df-abs df-abs-fn df-acos
       df-acos-fn df-acosh df-acosh-fn df-asin
       df-asin-fn df-asinh df-asinh-fn df-atan
       df-atan-fn df-atanh df-atanh-fn df-cos
       df-cos-fn df-cosh df-cosh-fn df-exp
       df-exp-fn df-expt df-expt-fn df-log
       df-minus-1 df-pi df-rationalize df-round
       df-sin df-sin-fn df-sinh df-sinh-fn
       df-sqrt df-sqrt-fn df-string df-tan
       df-tan-fn df-tanh df-tanh-fn df/ df/=-fn
       df0 df1 df< df<-fn df<= df= df=-fn
       df> df>= dfp digit-char-p digit-to-char
       dimensions disable disable-forcing
       disable-immediate-force-modep
       disable-ubt disabledp disassemble$
       distributivity dmr-start dmr-stop do$
       doc doc! docs doppelganger-apply$-userfn
       doppelganger-badge-userfn double-rewrite
       doublet-listp dumb-occur dumb-occur-var
       duplicates e/d e0-ord-< e0-ordinalp
       ec-call eighth eliminate-destructors
       eliminate-irrelevance
       enable enable-forcing
       enable-immediate-force-modep
       encapsulate endp eq eql eqlable-alistp
       eqlable-alistp-forward-to-alistp
       eqlable-listp
       eqlable-listp-forward-to-atom-listp
       eqlablep eqlablep-recog
       equal equal-char-code er er-cmp er-hard
       er-hard? er-let* er-let*-cmp er-progn
       er-progn-cmp er-progn-fn er-progn-fn@par
       er-progn@par er-soft er-soft-logic ev$
       ev$-list evenp evens event evisc-tuple
       executable-counterpart-theory
       exists exit
       explain-giant-lambda-object explode-atom
       explode-nonnegative-integer expt
       expt-type-prescription-non-zero-base
       extend-pathname
       extend-pe-table extend-world
       extra-info f-boundp-global f-get-global
       f-put-global fast-alist-clean
       fast-alist-clean! fast-alist-fork
       fast-alist-fork! fast-alist-free
       fast-alist-free-on-exit fast-alist-len
       fast-alist-summary fc-report fertilize
       fgetprop fifth file-clock file-clock-p
       file-clock-p-forward-to-integerp
       file-length$
       file-write-date$ finalize-event-user
       first first-n-ac fix fix-pkg
       fix-true-list flet floor flush-compress
       flush-hons-get-hash-table-link fms fms!
       fms!-to-string fms-to-string fmt fmt!
       fmt!-to-string fmt-hard-right-margin
       fmt-soft-right-margin
       fmt-to-comment-window
       fmt-to-comment-window!
       fmt-to-comment-window!+
       fmt-to-comment-window+
       fmt-to-string fmt1
       fmt1! fmt1!-to-string fmt1-to-string
       fmx fmx!-cw fmx-cw fn-equal
       fncall-term forall force formula fourth
       from-df function-symbolp function-theory
       gag-mode gc$ gc-strategy gc-verbose
       gcs generalize get-check-invariant-risk
       get-command-sequence
       get-cpu-time get-defun-event get-dwp
       get-enforce-redundancy get-event-data
       get-global get-guard-checking
       get-in-theory-redundant-okp
       get-output-stream-string$
       get-persistent-whs get-real-time
       get-register-invariant-risk
       get-serialize-character
       get-slow-alist-action get-timer
       get-wormhole-status getenv$ getprop
       getprop-default getpropc getprops
       getprops1 global-table global-table-cars
       global-table-cars1 global-val
       good-bye granularity ground-zero gthm
       guard guard-obligation guard-theorem
       hands-off-lambda-objects-theory
       hard-error
       has-propsp has-propsp1 header help
       hide hist hons hons-acons hons-acons!
       hons-assoc-equal hons-clear hons-clear!
       hons-copy hons-copy-persistent
       hons-equal hons-equal-lite
       hons-get hons-resize hons-resize-fn
       hons-shrink-alist hons-shrink-alist!
       hons-summary hons-wash
       hons-wash! i-am-here i-close i-large
       i-limited i-small id idates identity
       if if* iff iff-implies-equal-implies-1
       iff-implies-equal-implies-2
       iff-implies-equal-not
       iff-is-an-equivalence ifix ignorable
       ignore illegal imagpart imagpart-complex
       immediate-force-modep implies
       improper-consp in-arithmetic-theory
       in-package in-tau-intervalp in-theory
       include-book incompatible incompatible!
       increment-file-clock increment-timer
       induct induction-depth-limit
       initialize-event-user
       int= integer integer-0 integer-1
       integer-abs integer-implies-rational
       integer-length integer-listp
       integer-listp-forward-to-rational-listp
       integer-range-p
       integer-step integerp intern
       intern$ intern-in-package-of-symbol
       intern-in-package-of-symbol-symbol-name
       intersection$
       intersection-eq intersection-equal
       intersection-theories intersectp
       intersectp-eq intersectp-equal
       inverse-of-* inverse-of-+
       invisible-fns-table irrelevant
       keyword-package keyword-value-listp
       keyword-value-listp-assoc-keyword
       keyword-value-listp-forward-to-true-listp
       keywordp keywordp-forward-to-symbolp
       known-package-alist known-package-alistp
       known-package-alistp-forward-to-true-list-listp-and-alistp
       kwote kwote-lst l< lambda
       lambda$ last last-cdr last-prover-steps
       ld ld-always-skip-top-level-locals
       ld-error-action
       ld-error-triples ld-evisc-tuple
       ld-history ld-history-entry-error-flg
       ld-history-entry-input
       ld-history-entry-stobjs-out
       ld-history-entry-stobjs-out/value
       ld-history-entry-user-data
       ld-history-entry-value
       ld-keyword-aliases
       ld-missing-input-ok ld-post-eval-print
       ld-pre-eval-filter ld-pre-eval-print
       ld-prompt ld-query-control-alist
       ld-redefinition-action ld-skip-proofsp
       ld-user-stobjs-modified-warning
       ld-verbose
       legal-case-clausesp len len-update-nth
       length let let* let-mbe lex-fix lexorder
       lexp list list$ list* list*-macro
       list-macro listp local logand
       logandc1 logandc2 logbitp logcount
       logeqv logic logic-fns-list-listp
       logic-fns-listp logic-fnsp
       logic-term-list-listp logic-term-listp
       logic-termp logior lognand lognor lognot
       logorc1 logorc2 logtest logxor loop$
       lower-case-p lower-case-p-char-downcase
       lower-case-p-forward-to-alpha-char-p
       lowest-terms lp macro-aliases
       macro-args macrolet magic-ev-fncall
       main-timer main-timer-type-prescription
       make make-character-list
       make-character-list-make-character-list
       make-event
       make-fast-alist make-fmt-bindings
       make-input-channel make-list
       make-list-ac make-mv-nths make-ord
       make-output-channel make-summary-data
       make-tau-interval make-var-lst
       make-var-lst1 make-wormhole-status
       makunbound-global max maximum-length
       may-need-slashes maybe-convert-to-mv
       maybe-flush-and-compress1
       mbe mbt mbt* member member-eq
       member-equal member-symbol-name
       memoize memoize-partial memoize-summary
       memsum meta-extract-contextual-fact
       meta-extract-formula
       meta-extract-global-fact
       meta-extract-global-fact+
       meta-extract-rw+-term mfc mfc-ancestors
       mfc-ap mfc-clause mfc-rdepth
       mfc-relieve-hyp mfc-rw mfc-rw+ mfc-ts
       mfc-type-alist mfc-unify-subst mfc-world
       min minimal-theory minusp mod mod-expt
       monitor monitor! monitored-runes more
       more! more-doc msg msgp must-be-equal
       mutual-recursion mutual-recursion-guardp
       mv mv-let mv-list mv-nth mv? mv?-let
       nat-listp natp near-misses needs-slashes
       never-memoize newline nfix nfix-list nil
       nil-is-not-circular ninth no-duplicatesp
       no-duplicatesp-eq no-duplicatesp-equal
       non-exec nonnegative-integer-quotient
       nonnegative-product nonzero-imagpart
       not nqthm-to-acl2 nth nth-0-cons
       nth-0-read-run-time-type-prescription
       nth-add1 nth-aliases nth-update-nth
       nthcdr null number-subtrees
       numerator o-finp o-first-coeff
       o-first-expt o-infp o-p o-rst
       o< o<= o> o>= observation observation-cw
       oddp odds ok-if old-and-new-event-data
       oops open-channel-listp open-channel1
       open-channel1-forward-to-true-listp-and-consp
       open-channels-p open-channels-p-forward
       open-input-channel
       open-input-channel-any-p
       open-input-channel-any-p1
       open-input-channel-p
       open-input-channel-p1
       open-input-channels
       open-output-channel open-output-channel!
       open-output-channel-any-p
       open-output-channel-any-p1
       open-output-channel-p
       open-output-channel-p1
       open-output-channels
       open-trace-file optimize
       or or-macro ordered-symbol-alistp
       ordered-symbol-alistp-add-pair
       ordered-symbol-alistp-add-pair-forward
       ordered-symbol-alistp-forward-to-symbol-alistp
       ordered-symbol-alistp-getprops
       ordered-symbol-alistp-remove1-assoc-eq
       otherwise our-digit-char-p
       override-hints p! pairlis$
       pairlis2 pand pargs partial-encapsulate
       partition-rest-and-keyword-args
       pbt pc pcb pcb!
       pcs pe pe! peek-char$ pf pkg-imports
       pkg-witness pl pl2 plet plist-worldp
       plist-worldp-forward-to-assoc-eq-equal-alistp
       plusp pointers pop-timer por position
       position-ac position-eq position-eq-ac
       position-equal position-equal-ac
       positive posp power-eval pprogn pr
       pr! preprocess prin1$ prin1-with-slashes
       prin1-with-slashes1 princ$ print-base-p
       print-cl-cache print-gv print-object$
       print-object$+ print-object$-fn
       print-object$-preserving-case
       print-rational-as-decimal
       print-timer profile prog2$ progn
       progn! progn$ program project-dir-alist
       proof-tree proofs-co proper-consp
       props prove pseudo-term-listp
       pseudo-term-listp-forward-to-true-listp
       pseudo-termp
       pso pso! psof psog pspv pstack
       puff puff* push-timer push-untouchable
       put-assoc put-assoc-eq put-assoc-eql
       put-assoc-equal put-global putprop
       quick-and-dirty-subsumption-replacement-step
       quit quote quotep
       quote~ r-eqlable-alistp r-symbol-alistp
       random$ rassoc rassoc-eq rassoc-equal
       ratio rational rational-implies1
       rational-implies2 rational-listp
       rational-listp-forward-to-true-listp
       rationalp rationalp-* rationalp-+
       rationalp-expt-type-prescription
       rationalp-implies-acl2-numberp
       rationalp-unary--
       rationalp-unary-/ read-acl2-oracle
       read-acl2-oracle-preserves-state-p1
       read-byte$ read-char$
       read-file-into-string read-file-listp
       read-file-listp-forward-to-true-list-listp
       read-file-listp1
       read-file-listp1-forward-to-true-listp-and-consp
       read-files read-files-p
       read-files-p-forward-to-read-file-listp
       read-idate
       read-object read-object-suppress
       read-object-with-case read-run-time
       read-run-time-preserves-state-p1
       readable-file
       readable-file-forward-to-true-listp-and-consp
       readable-files readable-files-listp
       readable-files-listp-forward-to-true-list-listp-and-alistp
       readable-files-p
       readable-files-p-forward-to-readable-files-listp
       real-listp
       real/rationalp realfix realpart
       realpart-complex realpart-imagpart-elim
       rebuild redef redef! redef+
       redef- redo-flat regenerate-tau-database
       rem remove remove-assoc
       remove-assoc-eq remove-assoc-equal
       remove-binop remove-custom-keyword-hint
       remove-default-hints
       remove-default-hints!
       remove-duplicates remove-duplicates-eq
       remove-duplicates-eql
       remove-duplicates-equal
       remove-eq remove-equal
       remove-global-stobj remove-guard-holders
       remove-invisible-fns
       remove-macro-alias remove-macro-fn
       remove-nth-alias remove-override-hints
       remove-override-hints!
       remove-untouchable remove1 remove1-assoc
       remove1-assoc-eq remove1-assoc-equal
       remove1-eq remove1-equal
       reset-fc-reporting reset-kill-ring
       reset-ld-specials reset-prehistory
       reset-print-control resize-list
       rest restore-memoization-settings
       retract-world
       retrieve return-last return-last-table
       revappend reverse revert-world
       rewrite-equiv rewrite-lambda-modep
       rewrite-lambda-objects-theory
       rewrite-quoted-constant
       rewrite-stack-limit rfix
       rize round runes-diff rw-cache satisfies
       save-and-clear-memoization-settings
       save-exec saving-event-data
       search second serialize-read
       serialize-write set-absstobj-debug
       set-accumulated-persistence
       set-backchain-limit
       set-bad-lisp-consp-memoize
       set-body set-bogus-defun-hints-ok
       set-bogus-measure-ok
       set-bogus-mutual-recursion-ok
       set-brr-evisc-tuple
       set-case-split-limitations
       set-cbd set-check-invariant-risk
       set-checkpoint-summary-limit
       set-compile-fns
       set-compiler-enabled set-debugger-enable
       set-default-backchain-limit
       set-default-hints set-default-hints!
       set-deferred-ttag-notes set-difference$
       set-difference-eq set-difference-equal
       set-difference-theories
       set-duplicate-keys-action
       set-duplicate-keys-action!
       set-dwp set-dwp!
       set-enforce-redundancy set-equalp-equal
       set-evisc-tuple set-fast-cert
       set-fc-criteria set-fc-report-on-the-fly
       set-fmt-hard-right-margin
       set-fmt-soft-right-margin set-gag-mode
       set-gc-strategy set-guard-checking
       set-guard-msg set-ignore-ok
       set-in-theory-redundant-okp
       set-induction-depth-limit
       set-induction-depth-limit!
       set-inhibit-er
       set-inhibit-er! set-inhibit-output-lst
       set-inhibit-warnings
       set-inhibit-warnings!
       set-inhibited-summary-types
       set-invisible-fns-table
       set-iprint set-irrelevant-formals-ok
       set-ld-always-skip-top-level-locals
       set-ld-error-action
       set-ld-error-triples set-ld-evisc-tuple
       set-ld-keyword-aliases
       set-ld-keyword-aliases!
       set-ld-missing-input-ok
       set-ld-post-eval-print
       set-ld-pre-eval-filter
       set-ld-pre-eval-print
       set-ld-prompt set-ld-query-control-alist
       set-ld-redefinition-action
       set-ld-skip-proofs set-ld-skip-proofsp
       set-ld-user-stobjs-modified-warning
       set-ld-verbose set-let*-abstraction
       set-let*-abstractionp
       set-match-free-default
       set-match-free-error
       set-measure-function
       set-non-linear set-non-linearp
       set-override-hints set-override-hints!
       set-parallel-execution
       set-persistent-whs-and-ephemeral-whs
       set-print-base set-print-base-radix
       set-print-case set-print-circle
       set-print-clause-ids set-print-escape
       set-print-gv-defaults set-print-length
       set-print-level set-print-lines
       set-print-radix set-print-readably
       set-print-right-margin
       set-proofs-co set-prover-step-limit
       set-raw-mode set-raw-mode-on
       set-raw-mode-on! set-raw-proof-format
       set-raw-warning-format
       set-register-invariant-risk
       set-rewrite-stack-limit
       set-ruler-extenders
       set-rw-cache-state set-rw-cache-state!
       set-serialize-character
       set-serialize-character-system
       set-skip-meta-termp-checks
       set-skip-meta-termp-checks!
       set-slow-alist-action
       set-splitter-output
       set-standard-co set-standard-oi
       set-state-ok set-table-guard
       set-tau-auto-mode set-temp-touchable-fns
       set-temp-touchable-vars set-timer
       set-total-parallelism-work-limit
       set-total-parallelism-work-limit-error
       set-trace-co set-trace-evisc-tuple
       set-verify-guards-eagerness
       set-w set-warnings-as-errors
       set-waterfall-parallelism
       set-waterfall-parallelism-hacks-enabled
       set-waterfall-parallelism-hacks-enabled!
       set-waterfall-printing
       set-well-founded-relation
       set-wormhole-data
       set-wormhole-entry-code
       set-write-acl2x setenv$ seventh
       sgetprop show-accumulated-persistence
       show-bdd show-bodies
       show-custom-keyword-hint-expansion
       show-fc-criteria signed-byte
       signed-byte-p signum simplify
       sixth skip-proofs sleep some-slashable
       spec-mv-let splitter-output
       stable-under-simplificationp
       standard-char standard-char-listp
       standard-char-listp-append
       standard-char-listp-forward-to-character-listp
       standard-char-p standard-char-p+
       standard-char-p-nth standard-co
       standard-oi standard-part standardp
       start-proof-tree state state-global-let*
       state-global-let*-cleanup
       state-global-let*-get-globals
       state-global-let*-put-globals
       state-p state-p+
       state-p-implies-and-forward-to-state-p1
       state-p1 state-p1-forward
       state-p1-update-main-timer
       state-p1-update-nth-2-world
       step-limit stobj-let stobj-table
       stop-proof-tree string string-alistp
       string-append string-append-lst
       string-downcase string-downcase1
       string-equal string-equal1
       string-is-not-circular string-listp
       string-upcase string-upcase1
       string< string<-irreflexive
       string<-l string<-l-asymmetric
       string<-l-irreflexive
       string<-l-transitive
       string<-l-trichotomy
       string<= string> string>=
       stringp stringp-symbol-package-name
       strip-cars strip-cdrs sublis sublis-fn
       sublis-fn-lst-simple sublis-fn-simple
       subseq subseq-list subsequencep
       subsetp subsetp-eq subsetp-equal
       subst substitute substitute-ac
       suitably-tamep-listp sum$ sum$+
       summary swap-stobjs symbol symbol-alistp
       symbol-alistp-forward-to-eqlable-alistp
       symbol-doublet-listp
       symbol-equality symbol-listp
       symbol-listp-forward-to-true-listp
       symbol-name
       symbol-name-intern-in-package-of-symbol
       symbol-name-lst symbol-package-name
       symbol< symbol<-asymmetric
       symbol<-irreflexive symbol<-transitive
       symbol<-trichotomy symbolp
       symbolp-intern-in-package-of-symbol
       sync-ephemeral-whs-with-persistent-whs
       synp
       syntactically-clean-lambda-objects-theory
       syntaxp sys-call sys-call* sys-call+
       sys-call-status t table table-alist
       take tamep tamep-functionp tamep-lambdap
       tau-data tau-database tau-interval-dom
       tau-interval-hi tau-interval-hi-rel
       tau-interval-lo tau-interval-lo-rel
       tau-intervalp tau-status tau-system tc
       tca tcp tenth term-list-listp term-listp
       term-order termination-theorem
       termp the the-check the-fixnum
       the-fixnum! the-number the-true-list
       theory theory-invariant thereis$
       thereis$+ third thm time$ time-tracker
       time-tracker-tau timer-alistp
       timer-alistp-forward-to-true-list-listp-and-symbol-alistp
       to-df to-dfp
       toggle-inhibit-er toggle-inhibit-er!
       toggle-inhibit-warning
       toggle-inhibit-warning! toggle-pc-macro
       top-level trace! trace$ trace*
       trace-co trans trans! trans* trans*-
       trans-eval trans-eval-default-warning
       trans-eval-no-warning
       trans1 translam translate-and-test
       trichotomy true-list-fix true-list-listp
       true-list-listp-forward-to-true-listp
       true-list-listp-forward-to-true-listp-assoc-equal
       true-listp
       true-listp-cadr-assoc-eq-for-open-channels-p
       true-listp-update-nth truncate trust-mfc
       ttag ttags-seen tthm type typed-io-listp
       typed-io-listp-forward-to-true-listp
       typespec-check u ubt ubt! ubt-prehistory
       ubt? ubu ubu! ubu? unary--
       unary-/ unary-df- unary-df-log unary-df/
       unary-function-symbol-listp unicity-of-0
       unicity-of-1 union$ union-eq union-equal
       union-theories universal-theory
       unmemoize unmonitor unquote
       unsave unsigned-byte unsigned-byte-p
       until$ until$+ untouchable-marker
       untrace$ untrans-table
       untranslate update-acl2-oracle
       update-acl2-oracle-preserves-state-p1
       update-file-clock
       update-global-table update-idates
       update-nth update-nth-array
       update-open-input-channels
       update-open-output-channels
       update-read-files
       update-user-stobj-alist
       update-user-stobj-alist1
       update-written-files
       upper-case-p upper-case-p-char-upcase
       upper-case-p-forward-to-alpha-char-p
       user-stobj-alist user-stobj-alist1 value
       value-cmp value-triple verbose-pstack
       verify verify-guard-implication
       verify-guards verify-guards+
       verify-guards-formula verify-termination
       w walkabout warning! warrant
       waterfall-parallelism waterfall-printing
       weak-ld-history-entry-p
       well-formed-lambda-objectp
       wet when$ when$+ with-brr-data with-cbd
       with-current-package with-fast-alist
       with-global-stobj with-guard-checking
       with-guard-checking-error-triple
       with-guard-checking-event
       with-live-state
       with-local-state with-local-stobj
       with-output with-output!
       with-output-lock with-prover-step-limit
       with-prover-step-limit!
       with-prover-time-limit
       with-serialize-character
       with-stolen-alist without-evisc
       wof world wormhole wormhole-data
       wormhole-entry-code wormhole-eval
       wormhole-p wormhole-statusp
       wormhole1 writable-file-listp
       writable-file-listp-forward-to-true-list-listp
       writable-file-listp1
       writable-file-listp1-forward-to-true-listp-and-consp
       write-byte$
       writeable-files writeable-files-p
       writeable-files-p-forward-to-writable-file-listp
       written-file
       written-file-forward-to-true-listp-and-consp
       written-file-listp
       written-file-listp-forward-to-true-list-listp-and-alistp
       written-files written-files-p
       written-files-p-forward-to-written-file-listp
       xargs xor xxxjoin zero zerop zip zp zpf)")
 (*COMMON-LISP-SYMBOLS-FROM-MAIN-LISP-PACKAGE*
  (PACKAGES ACL2-BUILT-INS)
  "Symbols that are often imported into new packages to provide easy
  access to Common Lisp functionality.

  When you define a new package for your own work with [defpkg], you
  will usually want to import many symbols from the [47m\"COMMON-LISP\"[0m
  package so that you can access them without a [47mcommon-lisp::[0m or
  [47macl2::[0m prefix.

  The constant [47m*common-lisp-symbols-from-main-lisp-package*[0m lists the
  [47m978[0m symbols of the [47mCOMMON-LISP[0m package found in {dpAns |
  http://dx.doi.org/10.1145/147135.147249}.  You will typically also
  want to import many symbols from ACL2; see [*ACL2-exports*].

    (&allow-other-keys *print-miser-width*
                       &aux *print-pprint-dispatch*
                       &body *print-pretty*
                       &environment *print-radix*
                       &key *print-readably* &optional
                       *print-right-margin* &rest *query-io*
                       &whole *random-state* * *read-base*
                       ** *read-default-float-format*
                       *** *read-eval* *break-on-signals*
                       *read-suppress* *compile-file-pathname*
                       *readtable* *compile-file-truename*
                       *standard-input* *compile-print*
                       *standard-output* *compile-verbose*
                       *terminal-io* *debug-io*
                       *trace-output* *debugger-hook*
                       + *default-pathname-defaults*
                       ++ *error-output* +++ *features*
                       - *gensym-counter* / *load-pathname*
                       // *load-print* /// *load-truename*
                       /= *load-verbose* 1+ *macroexpand-hook*
                       1- *modules* < *package*
                       <= *print-array* = *print-base*
                       > *print-case* >= *print-circle*
                       abort *print-escape* abs *print-gensym*
                       acons *print-length* acos *print-level*
                       acosh *print-lines* add-method adjoin
                       atom boundp adjust-array base-char
                       break adjustable-array-p base-string
                       broadcast-stream allocate-instance
                       bignum broadcast-stream-streams
                       alpha-char-p bit built-in-class
                       alphanumericp bit-and butlast
                       and bit-andc1 byte append bit-andc2
                       byte-position apply bit-eqv byte-size
                       apropos bit-ior caaaar apropos-list
                       bit-nand caaadr aref bit-nor
                       caaar arithmetic-error bit-not caadar
                       arithmetic-error-operands bit-orc1
                       caaddr arithmetic-error-operation
                       bit-orc2 caadr array bit-vector
                       caar array-dimension bit-vector-p
                       cadaar array-dimension-limit
                       bit-xor cadadr array-dimensions
                       block cadar array-displacement
                       boole caddar array-element-type
                       boole-1 cadddr array-has-fill-pointer-p
                       boole-2 caddr array-in-bounds-p
                       boole-and cadr array-rank
                       boole-andc1 call-arguments-limit
                       array-rank-limit boole-andc2 call-method
                       array-row-major-index boole-c1
                       call-next-method array-total-size
                       boole-c2 car array-total-size-limit
                       boole-clr case arrayp
                       boole-eqv catch ash boole-ior ccase
                       asin boole-nand cdaaar asinh boole-nor
                       cdaadr assert boole-orc1 cdaar assoc
                       boole-orc2 cdadar assoc-if boole-set
                       cdaddr assoc-if-not boole-xor cdadr
                       atan boolean cdar atanh both-case-p
                       cddaar cddadr clear-input copy-tree
                       cddar clear-output cos cdddar close cosh
                       cddddr clrhash count cdddr code-char
                       count-if cddr coerce count-if-not
                       cdr compilation-speed ctypecase
                       ceiling compile debug cell-error
                       compile-file decf cell-error-name
                       compile-file-pathname declaim
                       cerror compiled-function declaration
                       change-class compiled-function-p
                       declare char compiler-macro decode-float
                       char-code compiler-macro-function
                       decode-universal-time
                       char-code-limit complement defclass
                       char-downcase complex defconstant
                       char-equal complexp defgeneric
                       char-greaterp compute-applicable-methods
                       define-compiler-macro
                       char-int compute-restarts
                       define-condition char-lessp
                       concatenate define-method-combination
                       char-name concatenated-stream
                       define-modify-macro char-not-equal
                       concatenated-stream-streams
                       define-setf-expander char-not-greaterp
                       cond define-symbol-macro char-not-lessp
                       condition defmacro char-upcase conjugate
                       defmethod char/= cons defpackage
                       char< consp defparameter char<=
                       constantly defsetf char= constantp
                       defstruct char> continue deftype
                       char>= control-error defun character
                       copy-alist defvar characterp copy-list
                       delete check-type copy-pprint-dispatch
                       delete-duplicates cis copy-readtable
                       delete-file class copy-seq delete-if
                       class-name copy-structure delete-if-not
                       class-of copy-symbol delete-package
                       denominator eq deposit-field
                       eql describe equal describe-object
                       equalp destructuring-bind
                       error digit-char etypecase
                       digit-char-p eval directory eval-when
                       directory-namestring evenp disassemble
                       every division-by-zero exp do export
                       do* expt do-all-symbols extended-char
                       do-external-symbols fboundp do-symbols
                       fceiling documentation fdefinition
                       dolist ffloor dotimes fifth double-float
                       file-author double-float-epsilon
                       file-error double-float-negative-epsilon
                       file-error-pathname dpb file-length
                       dribble file-namestring dynamic-extent
                       file-position ecase file-stream
                       echo-stream file-string-length
                       echo-stream-input-stream file-write-date
                       echo-stream-output-stream
                       fill ed fill-pointer
                       eighth find elt find-all-symbols
                       encode-universal-time find-class
                       end-of-file find-if endp find-if-not
                       enough-namestring find-method
                       ensure-directories-exist find-package
                       ensure-generic-function find-restart
                       find-symbol get-internal-run-time
                       finish-output get-macro-character
                       first get-output-stream-string fixnum
                       get-properties flet get-setf-expansion
                       float get-universal-time float-digits
                       getf float-precision gethash
                       float-radix go float-sign graphic-char-p
                       floating-point-inexact handler-bind
                       floating-point-invalid-operation
                       handler-case floating-point-overflow
                       hash-table floating-point-underflow
                       hash-table-count floatp hash-table-p
                       floor hash-table-rehash-size fmakunbound
                       hash-table-rehash-threshold force-output
                       hash-table-size format hash-table-test
                       formatter host-namestring
                       fourth identity fresh-line
                       if fround ignorable ftruncate ignore
                       ftype ignore-errors funcall imagpart
                       function import function-keywords
                       in-package function-lambda-expression
                       incf functionp initialize-instance
                       gcd inline generic-function
                       input-stream-p gensym inspect
                       gentemp integer get integer-decode-float
                       get-decoded-time integer-length
                       get-dispatch-macro-character
                       integerp get-internal-real-time
                       interactive-stream-p
                       intern lisp-implementation-type
                       internal-time-units-per-second
                       lisp-implementation-version
                       intersection list invalid-method-error
                       list* invoke-debugger
                       list-all-packages invoke-restart
                       list-length invoke-restart-interactively
                       listen isqrt listp keyword load keywordp
                       load-logical-pathname-translations
                       labels load-time-value
                       lambda locally lambda-list-keywords
                       log lambda-parameters-limit
                       logand last logandc1 lcm
                       logandc2 ldb logbitp ldb-test logcount
                       ldiff logeqv least-negative-double-float
                       logical-pathname
                       least-negative-long-float
                       logical-pathname-translations
                       least-negative-normalized-double-float
                       logior
                       least-negative-normalized-long-float
                       lognand
                       least-negative-normalized-short-float
                       lognor
                       least-negative-normalized-single-float
                       lognot least-negative-short-float
                       logorc1 least-negative-single-float
                       logorc2 least-positive-double-float
                       logtest least-positive-long-float logxor
                       least-positive-normalized-double-float
                       long-float
                       least-positive-normalized-long-float
                       long-float-epsilon
                       least-positive-normalized-short-float
                       long-float-negative-epsilon
                       least-positive-normalized-single-float
                       long-site-name
                       least-positive-short-float loop
                       least-positive-single-float loop-finish
                       length lower-case-p let machine-instance
                       let* machine-type machine-version
                       mask-field macro-function
                       max macroexpand member macroexpand-1
                       member-if macrolet member-if-not
                       make-array merge make-broadcast-stream
                       merge-pathnames make-concatenated-stream
                       method make-condition method-combination
                       make-dispatch-macro-character
                       method-combination-error
                       make-echo-stream method-qualifiers
                       make-hash-table min make-instance
                       minusp make-instances-obsolete
                       mismatch make-list mod make-load-form
                       most-negative-double-float
                       make-load-form-saving-slots
                       most-negative-fixnum
                       make-method most-negative-long-float
                       make-package most-negative-short-float
                       make-pathname most-negative-single-float
                       make-random-state
                       most-positive-double-float
                       make-sequence most-positive-fixnum
                       make-string most-positive-long-float
                       make-string-input-stream
                       most-positive-short-float
                       make-string-output-stream
                       most-positive-single-float
                       make-symbol muffle-warning
                       make-synonym-stream multiple-value-bind
                       make-two-way-stream multiple-value-call
                       makunbound multiple-value-list
                       map multiple-value-prog1
                       map-into multiple-value-setq mapc
                       multiple-values-limit mapcan name-char
                       mapcar namestring mapcon nbutlast
                       maphash nconc mapl next-method-p
                       maplist nil nintersection package-error
                       ninth package-error-package
                       no-applicable-method package-name
                       no-next-method package-nicknames
                       not package-shadowing-symbols
                       notany package-use-list notevery
                       package-used-by-list notinline packagep
                       nreconc pairlis nreverse parse-error
                       nset-difference parse-integer
                       nset-exclusive-or parse-namestring
                       nstring-capitalize pathname
                       nstring-downcase pathname-device
                       nstring-upcase pathname-directory
                       nsublis pathname-host nsubst
                       pathname-match-p nsubst-if pathname-name
                       nsubst-if-not pathname-type nsubstitute
                       pathname-version nsubstitute-if
                       pathnamep nsubstitute-if-not
                       peek-char nth phase nth-value pi nthcdr
                       plusp null pop number position numberp
                       position-if numerator position-if-not
                       nunion pprint oddp pprint-dispatch
                       open pprint-exit-if-list-exhausted
                       open-stream-p pprint-fill
                       optimize pprint-indent or pprint-linear
                       otherwise pprint-logical-block
                       output-stream-p pprint-newline
                       package pprint-pop pprint-tab read-char
                       pprint-tabular read-char-no-hang
                       prin1 read-delimited-list
                       prin1-to-string read-from-string
                       princ read-line princ-to-string
                       read-preserving-whitespace
                       print read-sequence print-not-readable
                       reader-error print-not-readable-object
                       readtable print-object
                       readtable-case print-unreadable-object
                       readtablep probe-file
                       real proclaim realp prog realpart
                       prog* reduce prog1 reinitialize-instance
                       prog2 rem progn remf program-error
                       remhash progv remove provide
                       remove-duplicates psetf remove-if
                       psetq remove-if-not push remove-method
                       pushnew remprop quote rename-file
                       random rename-package random-state
                       replace random-state-p require rassoc
                       rest rassoc-if restart rassoc-if-not
                       restart-bind ratio restart-case
                       rational restart-name rationalize return
                       rationalp return-from read revappend
                       read-byte reverse room simple-bit-vector
                       rotatef simple-bit-vector-p
                       round simple-condition row-major-aref
                       simple-condition-format-arguments
                       rplaca simple-condition-format-control
                       rplacd simple-error
                       safety simple-string satisfies
                       simple-string-p sbit simple-type-error
                       scale-float simple-vector schar
                       simple-vector-p search simple-warning
                       second sin sequence single-float
                       serious-condition single-float-epsilon
                       set single-float-negative-epsilon
                       set-difference
                       sinh set-dispatch-macro-character
                       sixth set-exclusive-or
                       sleep set-macro-character slot-boundp
                       set-pprint-dispatch slot-exists-p
                       set-syntax-from-char slot-makunbound
                       setf slot-missing setq slot-unbound
                       seventh slot-value shadow software-type
                       shadowing-import software-version
                       shared-initialize some shiftf sort
                       short-float space short-float-epsilon
                       special short-float-negative-epsilon
                       special-operator-p short-site-name
                       speed signal sqrt signed-byte
                       stable-sort signum standard simple-array
                       standard-char simple-base-string
                       standard-char-p standard-class
                       sublis standard-generic-function subseq
                       standard-method subsetp standard-object
                       subst step subst-if storage-condition
                       subst-if-not store-value substitute
                       stream substitute-if stream-element-type
                       substitute-if-not stream-error
                       subtypep stream-error-stream
                       svref stream-external-format
                       sxhash streamp symbol
                       string symbol-function string-capitalize
                       symbol-macrolet string-downcase
                       symbol-name string-equal symbol-package
                       string-greaterp symbol-plist
                       string-left-trim symbol-value
                       string-lessp symbolp string-not-equal
                       synonym-stream string-not-greaterp
                       synonym-stream-symbol string-not-lessp t
                       string-right-trim tagbody string-stream
                       tailp string-trim tan string-upcase
                       tanh string/= tenth string< terpri
                       string<= the string= third string>
                       throw string>= time stringp trace
                       structure translate-logical-pathname
                       structure-class
                       translate-pathname structure-object
                       tree-equal style-warning truename
                       truncate values-list two-way-stream
                       variable two-way-stream-input-stream
                       vector two-way-stream-output-stream
                       vector-pop type vector-push type-error
                       vector-push-extend type-error-datum
                       vectorp type-error-expected-type
                       warn type-of warning typecase
                       when typep wild-pathname-p unbound-slot
                       with-accessors unbound-slot-instance
                       with-compilation-unit
                       unbound-variable with-condition-restarts
                       undefined-function
                       with-hash-table-iterator
                       unexport with-input-from-string unintern
                       with-open-file union with-open-stream
                       unless with-output-to-string unread-char
                       with-package-iterator unsigned-byte
                       with-simple-restart untrace with-slots
                       unuse-package with-standard-io-syntax
                       unwind-protect write
                       update-instance-for-different-class
                       write-byte
                       update-instance-for-redefined-class
                       write-char upgraded-array-element-type
                       write-line upgraded-complex-part-type
                       write-sequence upper-case-p
                       write-string use-package write-to-string
                       use-value y-or-n-p user-homedir-pathname
                       yes-or-no-p values zerop)")
 (*DF-PI* (POINTERS) "See [df].")
 (*STANDARD-CI*
  (IO ACL2-BUILT-INS)
  "An ACL2 character-based analogue of CLTL's [47m*standard-input*[0m

  The value of the ACL2 constant [47m*standard-ci*[0m is an open character
  input channel that is synonymous to Common Lisp's [47m*standard-input*[0m.

  ACL2 character input from [47m*standard-ci*[0m is actually obtained by
  reading [characters] from the stream named by Common Lisp's
  [47m*standard-input*[0m.  That is, by changing the setting of
  [47m*standard-input*[0m in raw Common Lisp you can change the source from
  which ACL2 reads on the channel [47m*standard-ci*[0m.  See
  [*standard-co*].")
 (*STANDARD-CO*
  (IO ACL2-BUILT-INS)
  "The ACL2 analogue of CLTL's [47m*standard-output*[0m

  The value of the ACL2 constant [47m*standard-co*[0m is an open character
  output channel that is synonymous to Common Lisp's
  [47m*standard-output*[0m.

  ACL2 character output to [47m*standard-co*[0m will go to the stream named by
  Common Lisp's [47m*standard-output*[0m.  That is, by changing the setting
  of [47m*standard-output*[0m in raw Common Lisp you can change the actual
  destination of ACL2 output on the channel named by [47m*standard-co*[0m.
  Observe that this happens without changing the logical value of
  [47m*standard-co*[0m (which is some channel symbol).  Changing the setting
  of [47m*standard-output*[0m in raw Common Lisp essentially just changes
  the map that relates ACL2 to the physical world of terminals,
  files, etc.

  To see the value of this observation, consider the following.
  Suppose you write an ACL2 function which does character output to
  the constant channel [47m*standard-co*[0m.  During testing you see that
  the output actually goes to your terminal.  Can you use the
  function to output to a file?  Yes, if you are willing to do a
  little work in raw Common Lisp: open a stream to the file in
  question, set [47m*standard-output*[0m to that stream, call your ACL2
  function, and then close the stream and restore [47m*standard-output*[0m
  to its nominal value.  Similar observations can be made about the
  two ACL2 input channels, [47m[*standard-oi*][0m and [47m[*standard-ci*][0m, which
  are analogues of [47m*standard-input*[0m.

  Another reason you might have for wanting to change the actual
  streams associated with [47m[*standard-oi*][0m and [47m*standard-co*[0m is to
  drive the ACL2 top-level loop, [47m[ld][0m, on alternative input and
  output streams.  This end can be accomplished easily within ACL2 by
  either calling [47m[ld][0m on the desired channels or file names or by
  resetting the ACL2 [47m[state][0m global variables [47m'[0m[47m[standard-oi][0m and
  [47m'[0m[47m[standard-co][0m which are used by [47m[ld][0m.  See [standard-oi] and see
  [standard-co].")
 (*STANDARD-OI*
  (IO ACL2-BUILT-INS)
  "An ACL2 object-based analogue of CLTL's [47m*standard-input*[0m

  The value of the ACL2 constant [47m*standard-oi*[0m is an open object input
  channel that is synonymous to Common Lisp's [47m*standard-input*[0m.

  ACL2 object input from [47m*standard-oi*[0m is actually obtained by reading
  from the stream named by Common Lisp's [47m*standard-input*[0m.  That is,
  by changing the setting of [47m*standard-input*[0m in raw Common Lisp you
  can change the source from which ACL2 reads on the channel
  [47m*standard-oi*[0m.  See [*standard-co*].")
 (+
  (NUMBERS ACL2-BUILT-INS)
  "Addition macro

  [47m+[0m is really a macro that expands to calls of the function [47m[binary-+][0m.
  So for example

    (+ x y 4 z)

  represents the same term as

    (binary-+ x (binary-+ y (binary-+ 4 z))).

  See [binary-+].

  [31;1mMacro: [0m<+>

    (defmacro + (&rest rst)
      (if rst (if (cdr rst)
                  (xxxjoin 'binary-+ rst)
                (cons 'binary-+
                      (cons 0 (cons (car rst) nil))))
        0))


Subtopics

  [Binary-+]
      Addition function")
 (-
  (NUMBERS ACL2-BUILT-INS)
  "Macro for subtraction and negation

  See [binary-+] for addition and see [unary--] for negation.

  Note that [47m-[0m represents subtraction as follows:

    (- x y)

  represents the same term as

    (+ x (- y))

  which is really

    (binary-+ x (unary-- y)).

  Also note that [47m-[0m represents arithmetic negation as follows:

    (- x)

  expands to

    (unary-- x).

  [31;1mMacro: [0m<->

    (defmacro - (x &optional (y 'nil binary-casep))
     (if binary-casep (let ((y (if (and (consp y)
                                        (eq (car y) 'quote)
                                        (consp (cdr y))
                                        (acl2-numberp (car (cdr y)))
                                        (eq (cdr (cdr y)) nil))
                                   (car (cdr y))
                                 y)))
                        (if (acl2-numberp y)
                            (cons 'binary-+
                                  (cons (unary-- y) (cons x nil)))
                          (cons 'binary-+
                                (cons x
                                      (cons (cons 'unary-- (cons y nil))
                                            nil)))))
       (let ((x (if (and (consp x)
                         (eq (car x) 'quote)
                         (consp (cdr x))
                         (acl2-numberp (car (cdr x)))
                         (eq (cdr (cdr x)) nil))
                    (car (cdr x))
                  x)))
         (if (acl2-numberp x)
             (unary-- x)
           (cons 'unary-- (cons x nil))))))")
 (/
  (NUMBERS ACL2-BUILT-INS)
  "Macro for division and reciprocal

  See [binary-*] for multiplication and see [unary-/] for reciprocal.

  Note that [47m/[0m represents division as follows:

    (/ x y)

  represents the same term as

    (* x (/ y))

  which is really

    (binary-* x (unary-/ y)).

  Also note that [47m/[0m represents reciprocal as follows:

    (/ x)

  expands to

    (unary-/ x).

  [47m/[0m is a Common Lisp macro.  See any Common Lisp documentation for more
  information.

  [31;1mMacro: [0m</>

    (defmacro / (x &optional (y 'nil binary-casep))
      (cond (binary-casep (list 'binary-* x (list 'unary-/ y)))
            (t (list 'unary-/ x))))")
 (/=
  (NUMBERS ACL2-BUILT-INS)
  "Test inequality of two numbers

  [47m(/= x y)[0m is logically equivalent to [47m(not (equal x y))[0m.

  Unlike [47m[equal][0m, [47m/=[0m has a [guard] requiring both of its arguments to
  be numbers.  Generally, [47m/=[0m is executed more efficiently than a
  combination of [47m[not][0m and [47m[equal][0m.

  For a discussion of the various ways to test against 0, See
  [zero-test-idioms].

  [47m/=[0m is a Common Lisp function.  See any Common Lisp documentation for
  more information.

  [31;1mFunction: [0m</=>

    (defun /= (x y)
      (declare (xargs :guard (and (acl2-numberp x)
                                  (acl2-numberp y))))
      (not (equal x y)))")
 (1+
  (NUMBERS ACL2-BUILT-INS)
  "Increment by 1

  [47m(1+ x)[0m is the same as [47m(+ 1 x)[0m.  See [+].

  [47m1+[0m is a Common Lisp function.  See any Common Lisp documentation for
  more information.

  [31;1mMacro: [0m<1+>

    (defmacro 1+ (x) (list '+ 1 x))")
 (1-
  (NUMBERS ACL2-BUILT-INS)
  "Decrement by 1

  [47m(1- x)[0m is the same as [47m(- x 1)[0m.  See [-].

  [47m1-[0m is a Common Lisp function.  See any Common Lisp documentation for
  more information.

  [31;1mMacro: [0m<1->

    (defmacro 1- (x) (list '- x 1))")
 (<
  (NUMBERS ACL2-BUILT-INS)
  "Less-than

  Completion Axiom ([47mcompletion-of-<[0m):

    (equal (< x y)
           (if (and (rationalp x)
                    (rationalp y))
               (< x y)
             (let ((x1 (if (acl2-numberp x) x 0))
                   (y1 (if (acl2-numberp y) y 0)))
               (or (< (realpart x1) (realpart y1))
                   (and (equal (realpart x1) (realpart y1))
                        (< (imagpart x1) (imagpart y1)))))))

  [Guard] for [47m(< x y)[0m:

    (and (rationalp x) (rationalp y))

  Notice that like all arithmetic functions, [47m<[0m treats non-numeric
  inputs as [47m0[0m. Thus, the following are theorems.

    (thm (equal (< (fix x) y) (< x y)))
    (thm (equal (< x (fix y)) (< x y)))

  This function has the usual meaning on the rational numbers, but is
  extended to the complex rational numbers using the lexicographic
  order: first the real parts are compared, and if they are equal,
  then the imaginary parts are compared.")
 (<=
  (NUMBERS ACL2-BUILT-INS)
  "Less-than-or-equal test

  [47m<=[0m is a macro, and [47m(<= x y)[0m expands to the same thing as [47m(not (< y
  x))[0m.  See [<].

  [47m<=[0m is a Common Lisp function.  See any Common Lisp documentation for
  more information.

  [31;1mMacro: [0m<<=>

    (defmacro <= (x y)
      (list 'not (list '< y x)))")
 (=
  (NUMBERS EQUAL EQUALITY-VARIANTS ACL2-BUILT-INS)
  "Test equality of two numbers

  [47m(= x y)[0m is logically equivalent to [47m(equal x y)[0m.

  Unlike [47m[equal][0m, [47m=[0m has a [guard] requiring both of its arguments to be
  numbers.  Generally, [47m=[0m is executed more efficiently than [47m[equal][0m.

  For a discussion of the various ways to test against 0, See
  [zero-test-idioms].

  [47m=[0m is a Common Lisp function.  See any Common Lisp documentation for
  more information.

  [31;1mFunction: [0m<=>

    (defun = (x y)
      (declare (xargs :guard (and (acl2-numberp x)
                                  (acl2-numberp y))))
      (equal x y))")
 (>
  (NUMBERS ACL2-BUILT-INS)
  "Greater-than test

  [47m>[0m is a macro, and [47m(> x y)[0m expands to the same thing as [47m(< y x)[0m.  See
  [<].

  [47m>[0m is a Common Lisp function.  See any Common Lisp documentation for
  more information.

  [31;1mMacro: [0m<>>

    (defmacro > (x y) (list '< y x))")
 (>=
  (NUMBERS ACL2-BUILT-INS)
  "Greater-than-or-equal test

  [47m>=[0m is a macro, and [47m(>= x y)[0m expands to the same thing as [47m(not (< x
  y))[0m.  See [<].

  [47m>=[0m is a Common Lisp function.  See any Common Lisp documentation for
  more information.

  [31;1mMacro: [0m<>=>

    (defmacro >= (x y)
      (list 'not (list '< x y)))")
 (@
  (PROGRAMMING-WITH-STATE ACL2-BUILT-INS)
  "Get the value of a global variable in [47m[state][0m

    Examples:
    (+ (@ y) 1)
    (assign a (aset1 'ascii-map-array (@ a) 66 'Upper-case-B))

    General Form:
    (@ symbol)

  where [47msymbol[0m is any symbol to which you have [47m[assign][0med a global
  value.  This macro expands into [47m(f-get-global 'symbol state)[0m, which
  retrieves the stored value of the symbol.

  The macro [47mf-get-global[0m is closely related to [47m[@][0m: [47m(@ var)[0m
  macroexpands to [47m(f-get-global 'var state)[0m.

  The macro [47m[assign][0m makes it convenient to set the value of a symbol.
  The [47m:[0m[47m[ubt][0m operation has no effect on the [47mglobal-table[0m of [47m[state][0m.
  Thus, you may use these globals to hang onto useful data structures
  even though you may undo back past where you computed and saved
  them.")
 (A!
  (LD)
  "To return to the top-level of ACL2's command loop

  When [47m(a!)[0m is evaluated inside of ACL2's command loop, the current
  computation is aborted and control returns to the top of the
  command loop, exactly as though the user had interrupted and
  aborted the current computation.  (Note: Versions of ACL2 up to
  Version_3.4 provided `[47m#.[0m' for this purpose, but no longer; see
  [sharp-dot-reader].)

  If you are at an ACL2 prompt (as opposed to a raw Lisp break), then
  you may type [47m:a![0m in place of [47m(a!)[0m; see [keyword-commands].

  For a related feature that only pops up one level of [47m[ld][0m, see [47m[p!][0m.
  However, [47mp![0m behaves differently if you're typing to the interactive
  break caused by [break-rewrite].  Instead of popping up one level,
  [47mp![0m in break-rewrite prints a message and is otherwise a no-op.

  Logically speaking, [47m(a!) = nil[0m.  But imagine that it is defined in
  such a way that it causes a stack overflow or other resource
  exhaustion when called.")
 (ABORT!
  (LD)
  "To return to the top-level of ACL2's command loop

  This is an alias for [47ma![0m; see [a!].  For a related feature that only
  pops up one level, see [p!].")
 (ABORT-SOFT
  (MISCELLANEOUS)
  "Control how interrupts are handled in proofs

  ACL2 arranges by default that when a proof is interrupted (with
  [47mControl-C[0m), a ``soft'' abort occurs in the following sense: the
  message below is printed and then the proof attempt continues
  temporarily before ultimately failing (usually very soon
  thereafter).

    ***********************************************
    Note:  interrupt signal
      Will attempt to exit the proof in progress;
      otherwise, the next interrupt will abort the proof.
      For an immediate abort see :DOC abort-soft.
    ***********************************************

  This default behavior supports proper operation of the utility,
  [47m[redo-flat][0m, when a proof is interrupted.  It also supports more
  complete summaries than would be obtained with an immediate abort.
  If you nevertheless want proofs to abort immediately, you may
  evaluate the form [47m(assign abort-soft nil)[0m.  To restore the default
  behavior, evaluate [47m(assign abort-soft t)[0m.

  Remarks for system hackers.

    * An important effect of having evaluated [47m(assign abort-soft nil)[0m is
      that an interrupt will send you immediately back to the ACL2
      read-eval-print loop, in contrast to the default behavior where
      the prover returns an [error-triple] whose error component is
      non-[47mnil[0m.

    * It may be preferable to bind [state] global [47mabort-soft[0m rather than to
      assign it globally.  See the implementation of [prove$]
      (specifically, the definition of [47mprove$-fn[0m in [community-book]
      [47mbooks/tools/prove-dollar.lisp[0m) for an example.")
 (ABOUT-ACL2
  (START-HERE)
  "General information About ACL2

  This is ACL2 Version 8.6, [copyright] (C) 2025, Regents of the
  University of Texas, authored by Matt Kaufmann and J Strother
  Moore.

  See the {ACL2 home page | http://www.cs.utexas.edu/users/moore/acl2/}
  for additional information including tutorials, installation
  instructions, mailing lists, related publications, ACL2 workshops
  and seminars, acknowledgments, and other ACL2 releases.

  See [documentation] for how to access the ACL2 User's Manual.

  For statistics on ACL2 code size, see file [47mdoc/acl2-code-size.txt[0m.


Subtopics

  [Acknowledgments]
      Some contributors to the well-being of ACL2

  [ACL2-help]
      The acl2-help mailing list

  [Bibliography]
      Reports about ACL2

  [Building-ACL2]
      How to build an ACL2 executable

  [Common-lisp]
      Relation to Common Lisp, including deviations from the spec

  [Copyright]
      ACL2 copyright, license, sponsorship

  [Git-quick-start]
      Git quick start guide

  [Operational-semantics]
      Modeling State Machines

  [Pre-built-binary-distributions]
      Pre-built binary distributions of ACL2

  [Recursion-and-induction]
      Recursion and Induction

  [Release-notes]
      Pointers to what has changed

  [Soundness]
      Correctness property claimed for ACL2

  [Version]
      ACL2 Version Number")
 (ABOUT_MODELS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "About Models

  {IMAGE} (see [Models_of_Computer_Hardware_and_Software])

  ACL2 is used to construct mathematical models of computer hardware
  and software (i.e., ``digital systems'').

  {IMAGE}

  A [31;1mmathematical model[0m is a set of mathematical formulas used to
  predict the behavior of some artifact.

  The use of mathematical models allows [31;1mfaster[0m and [31;1mcheaper[0m delivery of
  [31;1mbetter[0m systems.

  Models need not be [31;1mcomplete[0m or [31;1mperfectly accurate[0m to be useful to the
  trained engineer.

  Click here (see [Models_in_Engineering]) for more discussion of these
  assertions in an engineering context.

  {IMAGE} (see [Models_of_Computer_Hardware_and_Software])")
 (ABOUT_THE_ACL2_HOME_PAGE
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "About the ACL2 Home Page

  {IMAGE} (see [What_Is_ACL2{Q}])

  The {ACL2 Home Page | http://www.cs.utexas.edu/users/moore/acl2/} on
  the web contains links to demos, publications, mailing lists,
  installation instructions, and more --- and, especially, to the
  extensive {online documentation |
  https://www.cs.utexas.edu/users/moore/acl2/v8-6/acl2-doc.html#User's-Manual}
  for ACL2 and its libraries, known as ``books''.

  For example, to use the online documentation to find out about
  [rewrite] {ICON} (see [A_Tiny_Warning_Sign]) rules you could click
  on the link.  (If you do that, remember to use your browser's [31;1mBack
  Button[0m to come back here.)

  The tiny warning signs {ICON} (see [A_Tiny_Warning_Sign]) mark links
  that lead out of the introductory-level material and into the user
  documentation.  We advise against following such links upon your
  first reading of the documentation.

  At the end of the tours you will have a chance to revisit them
  quickly to explore alternative paths more fully.

  {IMAGE} (see [What_Is_ACL2{Q}])")
 (ABOUT_THE_ADMISSION_OF_RECURSIVE_DEFINITIONS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "About the Admission of Recursive Definitions

  You can't just add any formula as an axiom or definition and expect
  the logic to stay sound!  For example, if we were permitted to
  define [47m(APP X Y)[0m so that it was equal to [47m(NOT (APP X Y))[0m then we
  could prove anything.  The purported ``definition'' of [47mAPP[0m must
  have several properties to be admitted to the logic as a new axiom.

  The key property a recursive definition must have is that the
  recursion terminate.  This, along with some syntactic criteria,
  ensures us that there exists a function satisfying the definition.

  Termination must be proved before the definition is admitted.  This
  is done in general by finding a measure of the arguments of the
  function and a well-founded relation such that the arguments ``get
  smaller'' every time a recursive branch is taken.

  For [47mapp[0m the measure is the ``size'' of the first argument, [47mx[0m, as
  determined by the primitive function [47m[ACL2-count][0m {ICON} (see
  [A_Tiny_Warning_Sign]).  The well-founded relation used in this
  example is [47m[o-p][0m {ICON} (see [A_Tiny_Warning_Sign]), which is the
  standard ordering on the ordinals less than ``epsilon naught.''
  These particular choices for [47mapp[0m were made ``automatically'' by
  ACL2.  But they are in fact determined by various ``default''
  settings.  The user of ACL2 can change the defaults or specify a
  ``hint'' to the [47m[defun][0m {ICON} (see [A_Tiny_Warning_Sign]) command
  to specify the measure and relation.

  You should now return to the Walking Tour (see
  [Revisiting_the_Admission_of_App]).")
 (ABOUT_THE_PROMPT
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "About the Prompt

  The string ``[47mACL2 !>[0m'' is the ACL2 prompt.

  The prompt tells the user that an ACL2 [command] {ICON} (see
  [A_Tiny_Warning_Sign]) is expected.  In addition, the prompt tells
  us a little about the current state of the ACL2 command
  interpreter.  We explain the prompt briefly below.  But first we
  talk about the command interpreter.

  An ACL2 command is generally a Lisp expression to be evaluated.
  There are some unusual commands (such as [47m:[0m[q] {ICON} (see
  [A_Tiny_Warning_Sign]) for [31;1mquitting[0m ACL2) which cause other
  behavior.  But most commands are read, evaluated, and then have
  their results printed.  Thus, we call the command interpreter a
  ``read-eval-print loop.'' The ACL2 command interpreter is named
  [47m[ld][0m {ICON} (see [A_Tiny_Warning_Sign]) (after Lisp's ``load'').

  When a command is read, all the symbols in it are converted to
  uppercase.  Thus, typing [47m(defun app ...)[0m is the same as typing
  [47m(DEFUN APP ...)[0m or [47m(defun App ...)[0m.  There are ways to force
  lowercase case characters into symbols but we won't discuss them
  here.  A consequence of Common Lisp's default uppercasing is that
  you'll see a general lack of concern over the case used when
  symbols are displayed in this documentation.

  In addition, symbols ``belong'' to ``packages'' which give the user a
  way to control namespaces.  The prompt tells us which package is
  the default one, namely [47m\"ACL2\"[0m.  That means when we call [47mcar[0m, for
  example, we are invoking the standard definition of that symbol.
  If the packager were [47m\"JONES\"[0m then [47mcar[0m would refer to the definition
  of that symbol in that package (which may or may not be different
  depending on what symbols were imported into that package.

  A command like [31;1m(defun app (x y) ...)[0m causes ACL2 to evaluate the
  [defun] {ICON} (see [A_Tiny_Warning_Sign]) function on [31;1mapp[0m, [31;1m(x y)[0m
  and [31;1m...[0m.  When that command is evaluated it prints some information
  to the terminal explaining the processing of the proposed
  definition.  It returns the symbol [47mAPP[0m as its value, which is
  printed by the command interpreter.  (Actually, [47mdefun[0m is not a
  function but a macro (see [DEFMACRO]) {ICON} (see
  [A_Tiny_Warning_Sign]) which expands to a form that involves
  [47m[state][0m {ICON} (see [A_Tiny_Warning_Sign]), a necessary
  precondition to printing output to the terminal and to ``changing''
  the set of axioms.  But we do not discuss this further here.)

  The [47mdefun[0m command is an example of a special kind of command called
  an ``event.'' [Events] {ICON} (see [A_Tiny_Warning_Sign]) are those
  commands that change the ``logical world'' by adding such things as
  axioms or theorems to ACL2's database.  See [world] {ICON} (see
  [A_Tiny_Warning_Sign]).  But not every command is an event command.

  A command like [31;1m(app '(1 2 3) '(4 5 6 7))[0m is an example of a
  non-event.  It is processed the same general way: the function [31;1mapp[0m
  is applied to the indicated arguments and the result is printed.
  The function [31;1mapp[0m does not print anything and does not change the
  ``world.''

  A third kind of command is one that displays information about the
  current logical world or that ``roll back'' to previous versions of
  the world.  Such commands are called ``[history]'' {ICON} (see
  [A_Tiny_Warning_Sign]) commands.

  What does the ACL2 prompt tell us about the read-eval-print loop?
  The prompt ``[47mACL2 !>[0m'' tells us that the command will be read with
  [47m[current-package][0m {ICON} (see [A_Tiny_Warning_Sign]) set to [47m\"ACL2\"[0m,
  that guard checking (see [set-guard-checking] {ICON} (see
  [A_Tiny_Warning_Sign])) is on (``[47m![0m''), and that we are at the
  top-level (there is only one ``[47m>[0m'').  For more about the prompt,
  see [default-print-prompt] {ICON} (see [A_Tiny_Warning_Sign]).

  You should now return to the Walking Tour (see
  [Revisiting_the_Admission_of_App]).")
 (ABOUT_TYPES
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "About Types

  The universe of ACL2 objects includes objects of many different
  types.  For example, [47mt[0m is a ``symbol'' and 3 is an ``integer.''
  Roughly speaking the objects of ACL2 can be partitioned into the
  following types:

    * Numbers (see [Numbers_in_ACL2]) such as [47m3, -22/7, #c(3 5/2)[0m.

    * Characters (see [ACL2_Characters]) such as [47m#\\A, #\\a, #\\Space[0m.

    * Strings (see [ACL2_Strings]) such as [47m\"This is a string.\"[0m.

    * Symbols (see [ACL2_Symbols]) such as [47m'abc, 'smith::abc[0m.

    * Conses (or Ordered Pairs) (see [ACL2_Conses_or_Ordered_Pairs]) such
      as [47m'((a . 1) (b . 2))[0m.

  When proving theorems it is important to know the types of object
  returned by a term.  ACL2 uses a complicated heuristic algorithm,
  called [47m[type-set][0m {ICON} (see [A_Tiny_Warning_Sign]), to determine
  what types of objects a term may produce.  The user can more or
  less program the [47mtype-set[0m algorithm by proving [47m[type-prescription][0m
  {ICON} (see [A_Tiny_Warning_Sign]) rules.

  ACL2 is an ``untyped'' logic in the sense that the syntax is not
  typed: It is legal to apply a function symbol of n arguments to any
  n terms, regardless of the types of the argument terms.  Thus, it
  is permitted to write such odd expressions as [47m(+ t 3)[0m which sums
  the symbol [47mt[0m and the integer 3.  Common Lisp does not prohibit such
  expressions.  We like untyped languages because they are simple to
  describe, though proving theorems about them can be awkward
  because, unless one is careful in the way one defines or states
  things, unusual cases (like [47m(+ t 3)[0m) can arise.

  To make theorem proving easier in ACL2, the axioms actually define a
  value for such terms.  The value of [47m(+ t 3)[0m is 3; under the ACL2
  axioms, non-numeric arguments to [47m+[0m are treated as though they were
  0.

  You might immediately wonder about our claim that ACL2 is Common
  Lisp, since [47m(+ t 3)[0m is ``an error'' (and will sometimes even
  ``signal an error'') in Common Lisp.  It is to handle this problem
  that ACL2 has [31;1mguards[0m.  We will discuss guards later in the Walking
  Tour.  However, many new users simply ignore the issue of guards
  entirely and that is what we recommend for now.

  You should now return to the Walking Tour (see
  [Revisiting_the_Admission_of_App]).")
 (ABS
  (NUMBERS ACL2-BUILT-INS)
  "The absolute value of a real number

  [47m(Abs x)[0m is [47m-x[0m if [47mx[0m is negative and is [47mx[0m otherwise.

  The [guard] for [47mabs[0m requires its argument to be a rational ([real],
  in ACL2(r)) number.

  [47mAbs[0m is a Common Lisp function.  See any Common Lisp documentation for
  more information.

  From ``Common Lisp the Language'' page 205, we must not allow complex
  [47mx[0m as an argument to [47mabs[0m in ACL2, because if we did we would have to
  return a number that might be a floating point number and hence not
  an ACL2 object.

  [31;1mFunction: [0m<abs>

    (defun abs (x)
      (declare (xargs :guard (real/rationalp x)))
      (if (minusp x) (- x) x))")
 (ABSTRACT-STOBJ (POINTERS)
                 "See [defabsstobj].")
 (ACCESS
  (DEFREC ACL2-BUILT-INS)
  "Accessor macro for [defrec] structures.

  The [47maccess[0m macro is built into ACL2, and allows you to access
  particular fields from structures that have been introduced with
  [defrec].  For instance:

    (access employee x :name)

  would return the [47mname[0m field from the employee [47mx[0m.  See [defrec] for
  more information.")
 (ACCUMULATED-PERSISTENCE
  (DEBUGGING)
  "To get statistics on which [rune]s are being tried

    Useful Forms:
    (accumulated-persistence t)              ; Activate statistics gathering.
    (accumulated-persistence :all)           ; As above, ``enhanced'' (see below)

    (show-accumulated-persistence :frames)   ; Display statistics ordered by
    (show-accumulated-persistence :tries)    ; frames built, times tried,
    (show-accumulated-persistence :ratio)    ; or their ratio.
    (show-accumulated-persistence)           ; Same as supplying :frames argument.

    (accumulated-persistence nil)            ; Deactivate.

    (accumulated-persistence-oops)           ; Undo the clearing effect of
                                             ; (accumulated-persistence t).

    Advanced forms:
    (show-accumulated-persistence :frames-s) ; The `s', `f', and `a' suffixes
    (show-accumulated-persistence :frames-f) ; stand for `success' (`useful'),
    (show-accumulated-persistence :frames-a) ; `failure' (`useless'), and `all',
    (show-accumulated-persistence :tries-s)  ; respectively.  The only effect of
    (show-accumulated-persistence :tries-f)  ; the `s' and `f' versions is to
    (show-accumulated-persistence :tries-a)  ; sort first by useful or useless
                                             ; applications, respectively (see
                                             ; below).  The `a' versions avoid
                                             ; showing the useful/useless
                                             ; breakdown.

    (show-accumulated-persistence :runes)    ; Just show runes alphabetically.
    (show-accumulated-persistence :useless)  ; Just show useless runes.
    (show-accumulated-persistence :useless :list)
                                             ; Just show useless runes as a list.

  In summary, [47m(accumulated-persistence t)[0m turns on fresh statistics
  gathering for rules, [47m(accumulated-persistence nil)[0m turns it off,
  [47m(show-accumulated-persistence)[0m displays the statistics that were
  gathered, and [47m(accumulated-persistence-oops)[0m restores the
  statistics, if any, that were cleared by [47m(accumulated-persistence
  t)[0m or [47m(accumulated-persistence :all)[0m.

  In general, if the optional second argument of
  [47mshow-accumulated-persistence[0m is supplied as [47m:list[0m, then instead of
  the result being displayed a ``pretty'' human-readable format, the
  result will be displayed as a corresponding list of entries of the
  form [47m(frames tries xrune)[0m.

  Note: [47mset-accumulated-persistence[0m is equivalent to
  [47maccumulated-persistence[0m.

  See the end of this item for a discussion of ``enhanced statistics
  gathering,'' which can be useful for more fine-grained proof
  debugging.

  Generally speaking, the more ACL2 knows, the slower it runs.  That is
  because the search space grows with the number of alternative
  rules.  Often, the system tries to apply rules that you have
  forgotten were even there, if you knew about them in the first
  place!  ``Accumulated-persistence'' is a statistic (originally
  developed for Nqthm) that helps you identify the rules that are
  causing ACL2's search space to explode.

  For other proof debugging utilities, see [break-rewrite],
  [with-brr-data], and [dmr].

  Accumulated persistence tracking can be turned on or off.  It is
  generally off.  When on, proofs may take a little more time than
  otherwise.  (We measured approximately 11% more time in a so-called
  ``everything'' regression run in May 2020.)  But some useful
  numbers are collected.  When it is turned on, by

    ACL2 !>(accumulated-persistence t)

  an accumulation site is initialized and henceforth data about which
  rules are being tried is accumulated into that site.  That
  accumulated data can be displayed with
  [47mshow-accumulated-persistence[0m, as described in detail below.  When
  accumulated persistence is turned off, with
  [47m(accumulated-persistence nil)[0m, the accumulation site is wiped out
  and the data in it is lost.

  The ``accumulated persistence'' of a [rune] is the number of [rune]s
  the system has attempted to apply (since accumulated persistence
  was last activated) while the given [rune] was being tried.

  Consider a [47m:[0m[47m[rewrite][0m rule named [47m[rune][0m.  For simplicity, let us
  imagine that [47m[rune][0m is tried only once in the period during which
  accumulated persistence is being monitored.  Recall that to apply a
  rewrite rule we must match the left-hand side of the conclusion to
  some term we are trying to rewrite, establish the hypotheses of
  [47m[rune][0m by rewriting, and, if successful, then rewrite the
  right-hand side of the conclusion.  We say [47m[rune][0m is ``being
  tried'' from the time we have matched its left-hand side to the
  time we have either abandoned the attempt or finished rewriting its
  right-hand side.  (By ``match'' we mean to include any loop-stopper
  requirement; see [loop-stopper].)  During that period of time other
  rules might be tried, e.g., to establish the hypotheses.  The rules
  tried while [47m[rune][0m is being tried are ``billed'' to [47m[rune][0m in the
  sense that they are being considered here only because of the
  demands of [47m[rune][0m.  Thus, if no other rules are tried during that
  period, the accumulated persistence of [47m[rune][0m is [47m1[0m --- we ``bill''
  [47m[rune][0m once for its own application attempt.  If, on the other
  hand, we tried [47m10[0m rules on behalf of that application of [47m[rune][0m,
  then [47m[rune][0m's accumulated persistence would be [47m11[0m.

  One way to envision accumulated persistence is to imagine that every
  time a [rune] is tried it is pushed onto a stack.  The rules tried
  on behalf of a given application of a [rune] are thus pushed and
  popped on the stack above that [rune].  A lot of work might be done
  on its behalf --- the stack above the [rune] grows and shrinks
  repeatedly as the search continues for a way to use the [rune].
  All the while, the [rune] itself ``persists'' in the stack, until
  we finish with the attempt to apply it, at which time we pop it
  off.  The accumulated persistence of a [rune] application is thus
  the number of stack frames built while that [rune] was on the
  stack.

  Note that accumulated persistence is tallied whether or not the
  attempt to apply a [rune] is successful.  Each of the rules tried
  on its behalf might have failed and the attempt to apply the [rune]
  might have also failed.  The ACL2 proof script would make no
  mention of the [rune] or the rules tried on its behalf because they
  did not contribute to the proof.  But time was spent pursuing the
  possible application of the [rune] and accumulated persistence is a
  measure of that time.

  A high accumulated persistence might come about in two extreme ways.
  One is that the rule causes a great deal of work every time it is
  tried.  The other is that the rule is ``cheap'' but is tried very
  often.  We therefore keep track of the number of times each rule is
  tried as well as its persistence.  The ratio between the two is the
  average amount of work done on behalf of the rule each time it is
  tried.

  We do not claim that tracking of runes for accumulated-persistence is
  perfect.  In practice, we believe it is quite reliable with the
  exception of [congruence] runes and, in some cases
  [executable-counterpart] runes. (For the latter, details are in a
  comment in the ACL2 source definition of function
  [47mprint-useless-runes[0m.)

  When the accumulated persistence totals are displayed by the function
  [47mshow-accumulated-persistence[0m we sort them so that the most
  expensive [rune]s are shown first.  We can sort according to one of
  three basic keys:

    :frames - the number of frames built on behalf of the rune
    :tries  - the number of times the rune was tried
    :ratio  - frames built per try

  The key simply determines the order in which the information is
  presented.  If no argument is supplied to
  [47mshow-accumulated-persistence[0m, [47m:frames[0m is used.

  The display breaks each total into ``useful'' and ``useless''
  subtotals.  A ``useful'' rule try is one that is viewed as
  contributing to the progress of the proof, and the rest are
  ``useless'' rule applications.  For example, if a [47m:[0m[47m[rewrite][0m rule
  is tried but its hypotheses are not successfully relieved, then
  that rule application and all work done on behalf of those
  hypotheses is ``useless'' work.  In general, an attempt to apply a
  [rune] is viewed as ``useful'' unless the attempt fails or the
  attempt is on the stack (as described above) for a [rune]
  application that ultimately fails.  A large number of ``useless''
  [47m:frames[0m or [47m:tries[0m along with correspondingly small ``useful''
  counts may suggest [rune]s to consider disabling (see [disable] and
  see [in-theory]).  Thus, here is a more complete list of the
  arguments that may be supplied to [47mshow-accumulated-persistence[0m.
  Suffixes ``s'', ``f'', and ``a'' are intended to suggest
  ``success'' (``useful''), ``failure'' (``useless''), and ``all''.

    :frames     - sort by the number of frames built on behalf of the rune
       :frames-s -   as above, but sort by useful applications
       :frames-f -   as above, but sort by useless applications
       :frames-a -   as above, but inhibit display of ``useful'' and
                     ``useless'' subtotals
    :tries      - sort by the number of times the rune was tried
       :tries-s  -   as above, but sort by useful applications
       :tries-f  -   as above, but sort by useless applications
       :tries-a  -   as above, but inhibit display of ``useful'' and
                     ``useless'' subtotals
    :ratio      - sort by frames built per try
    :useless    - show only the runes tried whose tries were all ``useless''

  For a given line of the report, every frame credited to a ``useful''
  (respectively, ``useless'') rule application is considered
  ``useful'' (respectively, ``useless'').  We illustrate with the
  following example.

    (progn
      (defstub hyp (x) t)
      (defstub concl (x) t)
      (defstub bad (x) t)
      (defstub good (x) t)
      (defaxiom good-ax
        (implies (good x) (hyp x)))
      (defaxiom bad-ax
        (implies (bad x) (hyp x)))
      (defaxiom hyp-implies-concl
        (implies (hyp x) (concl x)))
      )
    (accumulated-persistence t)
    (thm (implies (good x) (concl x)))
    (show-accumulated-persistence)

  To prove the [47m[thm][0m form, ACL2 attempts to rewrite [47m(concl x)[0m to true
  by applying rule [47mhyp-implies-concl[0m.  It then attempts to establish
  [47m(hyp x)[0m first by trying rule [47mbad-ax[0m, which fails, and second by
  trying rule [47mgood-ax[0m, which succeeds.  As expected, the report
  labels as ``useless'' the failure of the attempt to establish the
  hypothesis, [47m(bad x)[0m.

    --------------------------------
          1        1 (    1.00) (:REWRITE BAD-AX)
          0        0    [useful]
          1        1    [useless]
    --------------------------------

  Now consider the top-level application of rule [47mhyp-implies-concl[0m.
  Even though the above report shows the application of [47mbad-ax[0m as
  ``useless'', note that this rule was applied on behalf of the
  successful (``useful'') application of [47mhyp-implies-concl[0m, and hence
  is incorporated into the ``useful'' line for [47mhyp-implies-concl[0m, as
  follows.

    --------------------------------
          3        1 (    3.00) (:REWRITE HYP-IMPLIES-CONCL)
          3        1    [useful]
          0        0    [useless]
    --------------------------------

  In summary: categorization of [47m:frames[0m as ``useful'' or ``useless'' is
  based on whether they support ``useful'' or ``useless'' [47m:tries[0m.

  See [useless-runes] for a way to speed up proofs by automatically
  turning off useless rules.

  Note that a [rune] with high accumulated persistence may not actually
  be the ``culprit.'' For example, suppose [47mrune1[0m is reported to have
  a [47m:ratio[0m of [47m101[0m, meaning that on the average a hundred and one
  frames were built each time [47mrune1[0m was tried.  Suppose [47mrune2[0m has a
  [47m:ratio[0m of [47m100[0m.  It could be that the attempt to apply [47mrune1[0m
  resulted in the attempted application of [47mrune2[0m and no other [rune].
  Thus, in some sense, [47mrune1[0m is ``cheap'' and [47mrune2[0m is the
  ``culprit'' even though it is reported as costing less than [47mrune1[0m.

  If a proof is aborted, then in general,
  [47m[show-accumulated-persistence][0m will only display totals for runes
  whose attempted application is complete: that is, if the rewriter
  was in the process of relieving hypotheses for a rule, then
  information for that rule will not be included in the tally.  We
  say ``in general'' because, as indicated near the top of the output
  from [47m[show-accumulated-persistence][0m when such incomplete
  information is omitted, you can get this information by using
  argument [47m:frames-a[0m or [47m:tries-a[0m.

  There are other subtleties in how rune applications are tallied,
  documented elsewhere: see [accumulated-persistence-subtleties].

  We conclude with a discussion of ``enhanced'' statistics gathering,
  which is enabled by supplying [47maccumulated-persistence[0m the argument
  [47m:ALL[0m:

    (accumulated-persistence :all)

  At some additional performance expense (but probably well under a
  factor of 2 altogether), ACL2 then gathers additional statistics
  for individual hypotheses of rules as well as their conclusions.
  To understand how this works, suppose [47mrn[0m is a [rune].  Then we
  prepend the keyword [47m:CONC[0m to [47mrn[0m to form what we call its
  ``conclusion xrune'', and for its [47mI[0m-th hypothesis we prepend [47m:HYP I[0m
  to [47mrn[0m to form its [47mI[0m-th ``hypothesis xrune.'' Here, ``xrune'' is
  pronounced ``ex rune'', and is mnemonic for ``extended rune.'' For
  example, if [47m(REWRITE FOO)[0m is a [rune] then [47m(:CONC REWRITE FOO)[0m is
  its conclusion xrune, and [47m(:HYP 2 REWRITE FOO)[0m is a hypothesis
  xrune corresponding to the second hypothesis of the corresponding
  rewrite rule.

  With [47m(accumulated-persistence :all)[0m, we instruct ACL2 to track not
  only runes but also xrunes.  Then, [47m(show-accumulated-persistence)[0m
  will display information for all xrunes in a format that we
  consider to be ``raw'', in the sense that data for xrunes are
  displayed just as for runes.  But a ``merged'' format is also
  available.  Here is a summary of display commands, followed below
  by further discussion.

    (show-accumulated-persistence :frames t) ; t is optional, i.e., the default
       ; Display enhanced statistics sorted by frames, in a ``raw'' format.
    (show-accumulated-persistence :frames :merge)
       ; Display enhanced statistics sorted by frames, in a ``merged'' format.
    (show-accumulated-persistence :frames nil)
       ; Display regular statistics sorted by frames
       ; (runes only, that is, without the enhancements).
    (show-accumulated-persistence :frames :merge)
       ; Display a list of entries (frames tries xrune), sorted by frames

    ; More generally, the descriptions just above apply for any legal first
    ; argument:

    (show-accumulated-persistence KEY t)
    (show-accumulated-persistence KEY :merge)
    (show-accumulated-persistence KEY nil)
    (show-accumulated-persistence KEY :list)

    ; Note also these alternate forms, equivalent to the first of the two forms
    ; just above, i.e., the form with second argument of t:
    (show-accumulated-persistence KEY :raw)
    (show-accumulated-persistence KEY)

  There is a significant difference between how runes are tracked and
  how ACL2 tracks hypothesis and conclusion xrunes: unlike regular
  runes, these xrunes do not contribute to the accumulated [47m:frames[0m
  counts.  Rather, they serve as accumulation sites without
  contributing their [47m:tries[0m to any accumulation.  Consider for
  example the snippet below, taken from a report created with the
  [47m:merge[0m option (to be discussed further below), i.e., by evaluating
  the form [47m(show-accumulated-persistence :frames :merge)[0m.

    :frames   :tries    :ratio  rune
    --------------------------------
        462      211 (    2.18) (:REWRITE PERM-MEM)
         13        6    [useful]
        449      205    [useless]
       .............................
        251       47 (    5.34) (:HYP 2 :REWRITE PERM-MEM)
          6        6    [useful]
        245       41    [useless]
       .............................
          0      211 (    0.00) (:HYP 1 :REWRITE PERM-MEM)
          0        6    [useful]
          0      205    [useless]
       .............................
          0        7 (    0.00) (:CONC :REWRITE PERM-MEM)
          0        6    [useful]
          0        1    [useless]
    --------------------------------

  Notice that while [47m:tries[0m are recorded for the xrune [47m(:HYP 1 :REWRITE
  PERM-MEM)[0m, no [47m:frames[0m are recorded.  This is because no stack
  frames were built for runes while this xrune was on the stack ---
  only for the xrune itself, which as we explained above is not
  accumulated into the total [47m:frames[0m counts.  As it turns out, this
  lack of stack frames is explained by the fact that the rewrite rule
  [47mPERM-MEM[0m has a free variable in the first hypothesis.

    ACL2 !>:pe perm-mem
             18  (DEFTHM PERM-MEM
                         (IMPLIES (AND (PERM X Y) (MEM A X))
                                  (MEM A Y))
                         :RULE-CLASSES ((:REWRITE :MATCH-FREE :ONCE)))
    ACL2 !>

  The second hypothesis, however, does cause additional rewriting in
  order to rewrite it to true, resulting in 251 stack frames for
  runes.  We see that the conclusion does not lead to creation of any
  rune stack frames, which might seem to suggest that only 251 stack
  frames for runes were created on behalf of this rule application
  --- yet, we see that 462 frames were actually created.  The
  difference is the 211 frames created for the rewrite rule itself.
  Even if the total had been a bit more than 462, one need not be
  surprised, as there could be some work recorded during application
  of the rewrite rule, such as type reasoning (see [TYPE-REASONING]),
  that is not done during rewriting of a hypothesis or the
  conclusion.

  Now suppose we have executed [47m(accumulated-persistence :all)[0m and
  attempted some proofs, and now we are ready to see statistics.  The
  form [47m(show-accumulated-persistence)[0m displays statistics exactly as
  described above, treating these extra xrunes just as though they
  are runes; similarly for the form [47m(show-accumulated-persistence
  KEY)[0m, for any legal [47mKEY[0m.  A second optional argument may however be
  supplied to [47mshow-accumulated-persistence[0m.  The default for that
  second argument is [47mt[0m, and a second argument of [47m:raw[0m is treated the
  same as [47mt[0m; thus, these arguments provide the behavior just
  described, where data for xrunes are displayed just as for runes.
  You may restrict output to runes, ignoring hypothesis and
  conclusion xrunes, by giving a second argument of [47mnil[0m.  (This gives
  the same behavior as if we had started with the command
  [47m(accumulated-persistence t)[0m instead of the command
  [47m(accumulated-persistence :all)[0m.)  You may give a second argument of
  [47m:merge[0m, in which case output will be sorted and displayed as though
  only runes were tracked (not the extra xrunes), but each data item
  for a non-rune xrune will be merged so that it is displayed in
  suitable order just below its corresponding rune, as in the
  [47mPERM-MEM[0m example displayed above.  Finally, you may give a second
  argument of [47m:list[0m, which is equivalent to the default second
  argument of [47mt[0m, except that the results are printed as a list of
  entries [47m(frames tries xrune)[0m.

  We close by mentioning two aspects of enhanced statistics display for
  [47m:CONC[0m xrunes that have potential to be confusing.  First consider
  the following example.

      :frames   :tries    :ratio  rune
    --------------------------------
         14        4 (    3.50) (:REWRITE DEFAULT-+-2)
          0        0    [useful]
         14        4    [useless]
       .............................
         10        4 (    2.50) (:HYP 1 :REWRITE DEFAULT-+-2)
          0        0    [useful]
         10        4    [useless]
    --------------------------------

  It may be surprising that no data is displayed for the corresponding
  [47m:CONC[0m xrune.  The explanation, however, is simple: the hypothesis
  never rewrote to true, so the conclusion was never rewritten.  This
  is consistent with the marking as ``useless'' of all [47m:frames[0m and
  [47m:tries[0m for the rune and the hypothesis xrune.  Note by the way,
  once again, that the hypothesis xrune does not contribute to any
  [47m:frames[0m count.

  Another reason not to see data displayed for a [47m:CONC[0m xrune is that if
  a rule has no hypotheses, then no such data is collected.  This
  decision was made because in the case of no hypotheses, we expect
  it to be very rare that information for the [47m:CONC[0m xrune will add
  any useful insight.

  On a final note: [47m(show-accumulated-persistence :runes)[0m may be used
  simply to see a list of all [rune]s (or xrunes) displayed
  alphabetically.

  Users are encouraged to think about other meters we could install in
  ACL2 to help diagnose performance problems.


Subtopics

  [Accumulated-persistence-subtleties]
      Some subtle aspects of the counting done by
      [47m[accumulated-persistence][0m

  [Dmr]
      Dynamically monitor rewrites and other prover activity

  [Useless-runes]
      Speed up proofs by disabling useless [rune]s")
 (ACCUMULATED-PERSISTENCE-OOPS (POINTERS)
                               "See [accumulated-persistence].")
 (ACCUMULATED-PERSISTENCE-SUBTLETIES
  (ACCUMULATED-PERSISTENCE)
  "Some subtle aspects of the counting done by [47m[accumulated-persistence][0m

  In this topic we cover the overcounting of ``useful'' [rune]
  application attempts, and we describe how ``useless'' rune
  application attempts can actually be critical for a proof's
  success.  We conclude with a few words about counting frames when
  there are nested (recursive) applications of a rune.

  [3mOvercounting of ``useful'' rune application attempts.[0m Not every
  [rune] application may be necessary for a proof's success.
  Consider for example:

    (thm (equal (car (cons a (cdr (cons b x))))
                a))

  Then [47mshow-accumulated-persistence[0m will tell us that [47m:[0m[47m[rewrite][0m rules
  [47mcar-cons[0m and [47mcdr-cons[0m each had one useful application.  However,
  the rule [47mcdr-cons[0m is used to simplify [47m(cdr (cons b x))[0m to [47mx[0m, and
  this simplification is unnecessary for the proof.  Indeed, the
  proof succeeds even when preceded by the event: [47m(in-theory (disable
  cdr-cons))[0m.  We thus see that a [rune] application labeled as
  ``useful'' may be simplifying a term that is not relevant to the
  proof.

  As of this writing, we consider every [47m:[0m[47m[forward-chaining][0m rule
  application to be ``useful'', for simplicity of the implementation.
  Moreover, our counting of these rules is such that a single rule
  may be counted more than once.

  [3mHow ``useless'' attempts can be critical for a proof's success.[0m The
  command [47m(accumulated-persistence :useless[0m) will list rules that did
  not contribute directly to the proof (see
  [accumulated-persistence], in particular the discussion of
  ``useless'' there).  However, a ``useless'' rule can on rare
  occasions be critical to the success of a proof.  In the following
  example, we have a ``bad'' rule that can take the proof in the
  wrong direction, but a ``useless'' rule does a rewrite that
  prevents the successful relieving of a hypothesis of the ``bad''
  rule.  In summary:

    ; Assume p0.  We want to prove p1.

    ; Key rule:
    p0 -> p1 = t

    ; Bad rule that could ruin the proof:
    p3 -> p1 = p2

    ; But unfortunately, we know p3:
    p0 -> p3

    ; Important ``useless'' rule, preventing ``bad rule'' above from firing:
    p3 = p4

  The following event captures the rules described above.

    (encapsulate
     ((p0 (x) t)
      (p1 (x) t)
      (p2 (x) t)
      (p3 (x) t)
      (p4 (x) t))
     (local (defun p0 (x) x))
     (local (defun p1 (x) x))
     (local (defun p2 (x) x))
     (local (defun p3 (x) x))
     (local (defun p4 (x) x))

    ; Key rule:
     (defthm p0-implies-p1
       (implies (p0 x)
                (p1 x)))

    ; Bad rule that could ruin the proof:
     (defthm p3-implies-p1-is-p2
       (implies (p3 x)
                (equal (p1 x) (p2 x))))

    ; But unfortunately, we know p3:
     (defthm p0-implies-p3
       (implies (p0 x)
                (p3 x)))

    ; Important ``useless'' rule, preventing p3-implies-p1-is-p2 from firing:
     (defthm p3-is-p4
       (equal (p3 x) (p4 x))))

  Now we can see that [47mp3-is-p4[0m is labeled as ``useless'', by evaluating
  these commands.

    (accumulated-persistence t)
    (thm (implies (p0 x) (p1 x)))
    (show-accumulated-persistence)

  If instead we first evaluate [47m(in-theory (disable p3-is-p4))[0m before
  the [47mthm[0m above, then the proof fails, even though [47mp3-is-p4[0m was
  labeled as ``useless''!

  Nevertheless, in general it is probably safe to disable rules
  reported as ``useless'' by [47m(show-accumulated-persistence :useless)[0m,
  and doing so may speed up a proof considerably.

  Remark. The example above suggests a surprising fact: on rare
  occasions, a proof may fail when you give an [47m:[0m[47m[in-theory][0m hint
  consisting of exactly the [rune]s reported in a proof that
  succeeds.  For, imagine a rule R that is needed in part of the
  proof but is ``bad'' in a second part, and that some other,
  ``useless'' rule prevents the application of R in that second part.
  The example above suggests that disabling this ``useless'' rule can
  allow the second application of R, thus preventing the proof.

  Finally we discuss accumulation into frame counts in the case of a
  nested (recursive) application of a rule: that is, the case that
  during the application of a rule, the rule is applied again --- in
  particular, while relieving a hypothesis or rewriting the
  right-hand side from the original rule application.  Recall that
  the implementation of [accumulated-persistence] keeps a stack of
  [rune]s currently being applied; thus, we are considering here the
  case that a rune is pushed onto a stack on which it already
  resides.  In that case, we count tries as usual but we avoid
  accumulating until we reach the outermost (topmost) application of
  that rune.  Consider the following example.

    (defun mem (a x)
      (if (atom x)
          nil
        (or (equal a (car x)) (mem a (cdr x)))))

  Now suppose we consider the theorem [47m(mem a (list 1 2 3 a))[0m.  Each
  time the definition of [47mmem[0m is applied, a new stack frame is pushed.
  We avoid accumulating into the [47m:frames[0m count for that stack frame
  unless it is the topmost stack frame for that definition.
  Otherwise the final [47m:frames[0m count would be the sum of the counts
  for those individual frames, which form a linear sequence whose sum
  would therefore be quadratic in the number of applications of the
  definition of [47mmem[0m.")
 (ACKNOWLEDGMENTS
  (ABOUT-ACL2)
  "Some contributors to the well-being of ACL2

  The development of ACL2 was initially made possible by funding from
  the U. S. Department of Defense, including ARPA and ONR.  We thank
  all the organizations that have contributed support, including the
  following (in alphabetical order).

    * AMD, for providing significant time over several years for Matt
      Kaufmann to carry out ACL2 research, support, and development

    * Computational Logic, Inc. and its president, Don Good, where the
      first eight years of ACL2 development occurred

    * Centaur Technology

    * Collins Aerospace

    * DARPA

    * Digital Equipment Corporation

    * EDS, which provided some time for Matt Kaufmann's ACL2 work 1998-1999

    * ForrestHunt and, more generally, Warren A. Hunt, Jr. (see below)

    * IBM

    * Intel

    * Kestrel Institute

    * Kestrel Technology

    * NSF (see below)

    * ONR

    * SRC

    * Sun Microsystems

    * U.S. Army, in particular ARL

    * University of Texas at Austin (in particular support to J Moore
      through the Admiral B. R.  Inman Chair of Computing Theory)

  Regarding DARPA support: We thank DARPA for approving release of the
  following documentation topics and support with ``DISTRIBUTION
  STATEMENT A. Approved for public release. Distribution is
  unlimited.''

    * [Recursion-and-induction] together with its subtopics and its answer
      key ([community-books] files [47mdemos/r-and-i-answer-key-input.lsp[0m
      and [47mdemos/r-and-i-answer-key-log.txt[0m)

    * [Gentle-introduction-to-ACL2-programming]

    * [Loop$-primer] together with its subtopics and its answer key
      ([community-books] files [47mlp6.lisp[0m, [47mlp8.lisp[0m, [47mlp12.lisp[0m,
      [47mlp14.lisp[0m, [47mlp17-11-lemma2.lisp[0m, and [47mlp17.lisp[0m)

    * [Start-here]

  Regarding NSF support:

    * This material is based upon work supported by the National Science
      Foundation under Grant Nos. CCF-1526760, CNS-1525472,
      CCF-1153558, EIA-0303609, CNS-0429591, ISS-0417413,
      CCF-0945316, and CNS-0910913.

    * Any opinions, findings and conclusions or recommendations expressed
      in this material are those of the authors and do not
      necessarily reflect the views of the National Science
      Foundation.

  We are especially grateful to Warren A. Hunt, Jr. for his unrivaled
  efforts in securing support for the entire ACL2 research group at
  both Computational Logic, Inc., and the University of Texas at
  Austin.  Without his efforts, we would have spent less time working
  on the system and fewer students would have been funded to apply
  it.

  ACL2 was started in August, 1989 by Boyer and Moore working together.
  They co-authored the first versions of axioms.lisp and basis.lisp,
  with Boyer taking the lead in the formalization of ``[state]'' and
  the most primitive [io] functions.  Boyer also had a significant
  hand in the development of the early versions of the files
  interface-raw.lisp and translate.lisp.  For several years, Moore
  alone was responsible for developing the ACL2 system code, though
  he consulted often with both Boyer and Kaufmann.  In August, 1993,
  Kaufmann became jointly responsible with Moore for developing the
  system.  Boyer has continued to provide valuable consulting on an
  informal basis.

  Bishop Brock was the heaviest early user of ACL2, and provided many
  suggestions for improvements.  In particular, the [47m:cases[0m and
  [47m:restrict[0m [hints] were his idea; he developed an early version of
  congruence-based reasoning for Nqthm; and he helped in the
  development of some early [books] about arithmetic.  In a
  demonstration of his courage and faith in us, he pushed for
  Computational Logic, Inc., to agree to the Motorola CAP contract
  --- which required formalizing a commercial DSP in the untested
  ACL2 --- and moved to Scottsdale, AZ, to do the work with the
  Motorola design team.  His demonstration of ACL2's utility was an
  inspiration, even to those of us designing ACL2.

  John Cowles also helped in the development of some early [books]
  about arithmetic, and also provided valuable feedback and bug
  reports.

  Other early users of ACL2 at Computational Logic, Inc. helped
  influence its development.  In particular, Warren Hunt helped with
  the port to Macintosh Common Lisp, and Art Flatau and Mike Smith
  provided useful general feedback.

  Mike Smith helped develop the Emacs portion of the implementation of
  proof trees.

  ACL2 depends on the availability of robust Common Lisp
  implementations, so we are grateful to the developers of those
  implementations.  Early in ACL2's history, Bill Schelter made some
  enhancements to AKCL (now GCL) that helped to enhance ACL2
  performance in that Common Lisp implementation, and more generally,
  responded helpfully to our bug reports.  Camm Maguire has since
  provided wonderful GCL support, and has created a Debian package
  for ACL2 built on GCL.  Gary Byers and R. Matthew Emerson have
  continually improved Clozure Common Lisp (CCL), often based on
  feedback from the ACL2 community.  We are also grateful to
  developers of other Common Lisp implementations.

  Kent Pitman helped in our interaction with the ANSI Common Lisp
  standardization committee, X3J13.

  John Cowles helped with the port to Windows (98) by answering
  questions and running tests.

  Ruben Gamboa created a modification of ACL2 to allow reasoning about
  the real numbers using non-standard analysis.  His work has been
  incorporated into the ACL2 distribution; see [real].

  Rob Sumners has made numerous useful suggestions.  In particular, he
  has designed and implemented improvements for [stobj]s and been key
  in our development of locally-bound stobjs; see [note-2-6].

  Robert Krug has designed and implemented many changes in the vicinity
  of the linear arithmetic package and its connection to type-set and
  rewrite.  He was also instrumental in the development of
  [extended-metafunctions].

  Pete Manolios has made numerous useful suggestions.  In particular,
  Pete helped us to organize the first workshop and was a wonderful
  equal partner with the two of us (Kaufmann and Moore) in producing
  the books that arose from that workshop.  Pete and his student,
  Daron Vroon, provided the current implementation of [ordinals].

  Jared Davis, Sol Swords, and David Rager have our gratitude for
  starting the {ACL2+Books repository |
  https://github.com/acl2/acl2/}.

  We thank David L. Rager for contributing an initial version of the
  support for [parallelism] in an experimental extension of ACL2.

  Bob Boyer and Warren A. Hunt, Jr. developed a canonical
  representation for ACL2 data objects, applicative hash tables, and
  a function memoization mechanism to facilitate reuse of previously
  computed results.  Subsequently, Jared Davis and Sol Swords made
  further contributions.  We thank them all for this work, most of
  which has been incorporated into ACL2; see [hons-and-memoization].

  Other contributions to the ACL2 system continue to be made by members
  of the ACL2 community.  In particular, following the first
  Developers Workshop in May, 2017 through the time of this writing
  in November, 2019, such contributors include Alessandro Coglio,
  Keshav Kini, Mihir Mehta, Pete Manolios, and especially Sol Swords,
  while Eric Smith and many others have suggested changes that we
  have implemented, often by providing helpful examples.  The
  [release-notes] detail such contributions as well as many
  suggestions from the community for improvements that we ultimately
  implemented.

  We also thank the contributors to the ACL2 workshops for some
  suggested improvements and for the extensive collection of publicly
  distributed benchmark problems.  And we thank participants at the
  ACL2 seminar at the University of Texas for useful feedback.  More
  generally, we thank the ACL2 community for feedback, contributed
  [books] (see [community-books]), and their interest in the ACL2
  project.

  [3mRegarding the documentation:[0m

      Bill Young wrote significant portions of the original [47macl2-tutorial[0m
      section of the ACL2 documentation, including what is now called
      [alternative-introduction].  This was an especially important
      task in the early years when there was no guide for how to use
      ACL2 and we are very grateful.  He, Bishop Brock, Rich Cohen,
      and Noah Friedman read over considerable amounts of the
      documentation, and made many useful comments.  Others,
      particularly Bill Bevier and John Cowles, have also made useful
      comments on the [documentation].

      Art Flatau helped develop the ACL2 markup language in which ACL2
      [documentation] was originally developed, along with
      translators from that language to Texinfo and HTML.  Michael
      ``Bogo'' Bogomolny created a search engine, beginning with
      Version 2.6, and for that purpose modified the HTML translator
      to create one file per topic (a good idea in any case).

      Laura Lawless provided many hours of help in marking up appropriate
      parts of the [documentation] in typewriter font.

      Noah Friedman developed an Emacs tool that helped us insert
      ``invisible links'' into the [documentation], which improve the
      usability of that documentation under HTML readers such as
      Mosaic.

      Richard Stallman contributed a texinfo patch, to be found in the file
      [47mdoc/texinfo.tex[0m.

      Jared Davis created the [xdoc] system that is now the basis not only
      for the ACL2 system [documentation] (file
      [47mbooks/system/doc/acl2-doc.lisp[0m), but also for the
      [community-books] documentation.

  We thank Blake Grugett for designing the current version of the ACL2
  logo (which for example appears on the ACL2 home page), based on an
  original design created in the 1990s by Computational Logic, Inc.")
 (ACL2
  NIL
  "ACL2 documentation (system only, not including the community books)

  This is the ACL2 documentation.  For the ACL2+Books Manual, which
  that includes both the ACL2 documentation and the ACL2
  [community-books], see the {ACL2+Books Manual |
  http://www.cs.utexas.edu/users/moore/acl2/v8-6/combined-manual/index.html}.


Subtopics

  [Bdd]
      Ordered binary decision diagrams with rewriting

  [Books]
      [3mBooks[0m are files of ACL2 [events]---they are the main way to split up
      large ACL2 developments into separate modules.

  [Debugging]
      Tools for debugging failed or slow proofs, or misbehaving functions.

  [Documentation]
      Information about options for downloading and viewing the ACL2
      documentation, contributing documentation, and the available
      tools for documenting your own books.

  [Events]
      Functions that extend the logic

  [History]
      Functions to display or change contents of the logical [world]

  [Hons-and-memoization]
      Hash cons, function memoization, and applicative hash tables

  [Interfacing-tools]
      Libraries and tools for doing basic file i/o (see [STD/IO]), using
      raw Common Lisp libraries (see [QUICKLISP]), working with the
      operating system (see [OSLIB]), and interfacing with other
      programs (see [BRIDGE]).

  [Macros]
      Macros allow you to extend the syntax of ACL2.

  [Miscellaneous]
      A miscellany of documented functions and concepts (often cited in
      more accessible [documentation])

  [Operational-semantics]
      Modeling State Machines

  [Output-controls]
      Methods for controlling the output produced by the ACL2 prover

  [Parallelism]
      Experimental extension for parallel execution and proofs

  [Programming]
      Programming in ACL2

  [Proof-builder]
      An interactive tool for controlling ACL2's proof processes.

  [Real]
      ACL2(r) support for real numbers

  [Recursion-and-induction]
      Recursion and Induction

  [Rule-classes]
      Adding rules to the database

  [Start-here]
      Introductory information about ACL2

  [Theories]
      Sets of [rune]s to [enable]/[disable] in concert")
 (ACL2-AS-STANDALONE-PROGRAM
  (ACL2-TUTORIAL)
  "Calling ACL2 from another program

  ACL2 is intended for interactive use.  It is generally unrealistic to
  expect it to prove theorems fully automatically; see [the-method],
  and see [introduction-to-the-theorem-prover] for a more detailed
  tutorial.

  Nevertheless, here we describe an approach for how to call the ACL2
  theorem prover noninteractively.  These steps can of course be
  modified according to your needs.  Here, we illustrate how to call
  ACL2 from another Lisp program (or an arbitrary program) to attempt
  to prove an arithmetic theorem.

  See also [interfacing-tools].  In particular, if you want to make a
  command-line tool to ACL2 with options, you may be interested in
  [oslib::argv], [getopt], and especially [getopt-demo::demo2].
  Alternately, if you want to develop a server application on top of
  ACL2, you might consider [bridge].


Step 1

  Build a suitable ACL2 image by starting ACL2 and then executing the
  following forms.  In particular, these define a macro, [47mtry-thm[0m,
  that causes ACL2 to exit with an exit status indicating success or
  failure of a proof attempt.

    (include-book \"arithmetic-5/top\" :dir :system)
    (defmacro try-thm (&rest args)
      `(mv-let (erp val state)
               (with-prover-time-limit 3 (thm ,@args))
               (declare (ignore val))
               (prog2$ (if erp (exit 1) (exit 0)) state))))
    (reset-prehistory) ; optional
    :q
    (save-exec \"arith-acl2\" \"Included arithmetic-4/top\")

  If you prefer, above you can replace 3 by some other number of
  seconds as a time limit for the prover.  Also, you can replace

    (with-prover-time-limit 3 (thm ,@args))

  by

    (with-output :off :all (with-prover-time-limit 3 (thm ,@args)))

  if you want to turn off output.  It may be best to leave the output
  on, instead eliminating it in the calling program (see Step 3
  below).


Step 2

  Try a little test.  In that same directory try this:

    echo '(try-thm (equal x x))' | ./arith-acl2
    echo $?

  The exit status should be 0, indicating success.  Now try this:

    echo '(try-thm (not (equal x x)))' | ./arith-acl2
    echo $?

  The exit status should be 1, indicating failure.


Step 3

  Create a shell script that automates Step 2, for example:

    #!/bin/sh
    (echo \"(try-thm $1)\" | ./arith-acl2) >& /dev/null
    exit $?


Step 4

  Try your script from a Lisp program, if you like.  Here is how you
  can do it in SBCL, for example.  (Different Lisps have different
  ways to do this, as summarized in function [47msystem-call[0m in ACL2
  source file [47macl2-init.lisp[0m.)

    (defun provable? (x)
      (let ((status
             (process-exit-code
              (sb-ext:run-program \"./try-thm.sh\" (list (format nil \"~s\" x))
                                  :output t :search t))))
        (eql status 0)))

  Then here is a log:

    * (provable? '(equal x y))

    NIL
    * (provable? '(equal x x))

    T
    *

  Certainly refinements are possible --- for example the above doesn't
  distinguish between unprovable and ill-formed input.  But it's a
  start.")
 (ACL2-BUILT-INS
  (PROGRAMMING)
  "''Catch-all'' topic for built-in ACL2 functions

  This [documentation] topic is a parent topic under which we include
  documentation for built-in functions, macros, and special forms
  that are typically used in [programming].  For others, including
  those typically used as top-level commands or those that create
  [events] ([47m[defun][0m, [47m[defmacro][0m, [47m[defthm][0m, and so on), documentation
  may be found as a subtopic of some other parent topic.  We do not
  document some of the more obscure functions provided by ACL2 that
  do not correspond to functions of Common Lisp.

  If you are already familiar with Common Lisp (or even some other Lisp
  variant), then you may find it helpful to start with the topic,
  [introduction-to-programming-in-ACL2-for-those-who-know-lisp].

  See any documentation for Common Lisp for more details on many of
  these functions.


Subtopics

  [*]
      Multiplication macro

  [*ACL2-exports*]
      Symbols that are often imported into new [packages] to provide easy
      access to ACL2 functionality.

  [*common-lisp-symbols-from-main-lisp-package*]
      Symbols that are often imported into new packages to provide easy
      access to Common Lisp functionality.

  [*standard-ci*]
      An ACL2 character-based analogue of CLTL's [47m*standard-input*[0m

  [*standard-co*]
      The ACL2 analogue of CLTL's [47m*standard-output*[0m

  [*standard-oi*]
      An ACL2 object-based analogue of CLTL's [47m*standard-input*[0m

  [+]
      Addition macro

  [-]
      Macro for subtraction and negation

  [/]
      Macro for division and reciprocal

  [/=]
      Test inequality of two numbers

  [1+]
      Increment by 1

  [1-]
      Decrement by 1

  [<]
      Less-than

  [<=]
      Less-than-or-equal test

  [=]
      Test equality of two numbers

  [>]
      Greater-than test

  [>=]
      Greater-than-or-equal test

  [@]
      Get the value of a global variable in [47m[state][0m

  [Abs]
      The absolute value of a real number

  [Access]
      Accessor macro for [defrec] structures.

  [ACL2-count]
      A commonly used measure for justifying recursion

  [ACL2-number-listp]
      Recognizer for a true list of numbers

  [ACL2-numberp]
      Recognizer for numbers

  [Acons]
      Constructor for association lists

  [Add-to-set]
      Add a symbol to a list

  [Alist-keys-subsetp]
      Check that all keys of the alist belong to a given set

  [Alist-to-doublets]
      Convert an alist to a list of two-element lists

  [Alistp]
      Recognizer for association lists

  [Allocate-fixnum-range]
      Set aside fixnums in GCL

  [Alpha-char-p]
      Recognizer for alphabetic characters

  [Alphorder]
      Total order on atoms

  [And]
      Conjunction

  [Append]
      [concatenate] zero or more lists

  [Apply$]
      Apply a badged function or tame lambda to arguments

  [Aref1]
      Access the elements of a 1-dimensional array

  [Aref2]
      Access the elements of a 2-dimensional array

  [Arities-okp]
      check the arities of given function symbols

  [Arity]
      number of arguments of a function symbol

  [Array1p]
      Recognize a 1-dimensional array

  [Array2p]
      Recognize a 2-dimensional array

  [Aset1]
      Set the elements of a 1-dimensional array

  [Aset1-trusted]
      Set the elements of a 1-dimensional array without [invariant-risk]

  [Aset2]
      Set the elements of a 2-dimensional array

  [Ash]
      Arithmetic shift operation

  [Assert$]
      Cause a hard error if the given test is false

  [Assert*]
      Create a [guard] proof obligation that given test holds

  [Assign]
      Assign to a global variable in [47m[state][0m

  [Assoc]
      Look up key in association list

  [Assoc-keyword]
      Look up key in a [47m[keyword-value-listp][0m

  [Assoc-string-equal]
      Look up key, a string, in association list

  [Atom]
      Recognizer for atoms

  [Atom-listp]
      Recognizer for a true list of [atom]s

  [Binary-*]
      Multiplication function

  [Binary-+]
      Addition function

  [Binary-append]
      [concatenate] two lists

  [Bitp]
      A recognizer for the set of bits, {0,1}

  [Boole$]
      Perform a bit-wise logical operation on 2 two's complement integers

  [Boolean-listp]
      Recognizer for a true list of booleans

  [Booleanp]
      Recognizer for booleans

  [Break$]
      Cause an immediate Lisp break

  [Break-on-error]
      Break when encountering a hard or soft error caused by ACL2

  [Butlast]
      All but a final segment of a list

  [Caaaar]
      [47m[car][0m of the [47m[caaar][0m

  [Caaadr]
      [47m[car][0m of the [47m[caadr][0m

  [Caaar]
      [47m[car][0m of the [47m[caar][0m

  [Caadar]
      [47m[car][0m of the [47m[cadar][0m

  [Caaddr]
      [47m[car][0m of the [47m[caddr][0m

  [Caadr]
      [47m[car][0m of the [47m[cadr][0m

  [Caar]
      [47m[car][0m of the [47m[car][0m

  [Cadaar]
      [47m[car][0m of the [47m[cdaar][0m

  [Cadadr]
      [47m[car][0m of the [47m[cdadr][0m

  [Cadar]
      [47m[car][0m of the [47m[cdar][0m

  [Caddar]
      [47m[car][0m of the [47m[cddar][0m

  [Cadddr]
      [47m[car][0m of the [47m[cdddr][0m

  [Caddr]
      [47m[car][0m of the [47m[cddr][0m

  [Cadr]
      [47m[car][0m of the [47m[cdr][0m

  [Canonical-pathname]
      The true absolute filename, with soft links resolved

  [Car]
      Returns the first element of a non-empty list, else [47mnil[0m

  [Case]
      Conditional based on if-then-else using [47m[eql][0m

  [Case-match]
      Pattern matching or destructuring

  [Cbd]
      Connected book directory string

  [Cdaaar]
      [47m[cdr][0m of the [47m[caaar][0m

  [Cdaadr]
      [47m[cdr][0m of the [47m[caadr][0m

  [Cdaar]
      [47m[cdr][0m of the [47m[caar][0m

  [Cdadar]
      [47m[cdr][0m of the [47m[cadar][0m

  [Cdaddr]
      [47m[cdr][0m of the [47m[caddr][0m

  [Cdadr]
      [47m[cdr][0m of the [47m[cadr][0m

  [Cdar]
      [47m[cdr][0m of the [47m[car][0m

  [Cddaar]
      [47m[cdr][0m of the [47m[cdaar][0m

  [Cddadr]
      [47m[cdr][0m of the [47m[cdadr][0m

  [Cddar]
      [47m[cdr][0m of the [47m[cdar][0m

  [Cdddar]
      [47m[cdr][0m of the [47m[cddar][0m

  [Cddddr]
      [47m[cdr][0m of the [47m[cdddr][0m

  [Cdddr]
      [47m[cdr][0m of the [47m[cddr][0m

  [Cddr]
      [47m[cdr][0m of the [47m[cdr][0m

  [Cdr]
      Returns the second element of a [47m[cons][0m pair, else [47mnil[0m

  [Ceiling]
      Division returning an integer by truncating toward positive infinity

  [Change]
      Mutator macro for [defrec] structures.

  [Char]
      The [nth] element (zero-based) of a string

  [Char-code]
      The numeric code for a given character

  [Char-downcase]
      Turn upper-case [characters] into lower-case [characters]

  [Char-equal]
      Character equality without regard to case

  [Char-upcase]
      Turn lower-case [characters] into upper-case [characters]

  [Char<]
      Less-than test for [characters]

  [Char<=]
      Less-than-or-equal test for [characters]

  [Char>]
      Greater-than test for [characters]

  [Char>=]
      Greater-than-or-equal test for [characters]

  [Character-alistp]
      Recognizer for association lists with characters as keys

  [Character-listp]
      Recognizer for a true list of characters

  [Characterp]
      Recognizer for [characters]

  [Code-char]
      The character corresponding to a given numeric code

  [Coerce]
      Coerce a character list to a string and a string to a list

  [Comment]
      Variant of [47m[prog2$][0m to help debug evaluation failures during proofs

  [Comp]
      Compile some ACL2 functions

  [Comp-gcl]
      Compile some ACL2 functions leaving .c and .h files

  [Complex]
      Create an ACL2 number

  [Complex-rationalp]
      Recognizes complex rational numbers

  [Complex/complex-rationalp]
      Recognizer for complex numbers

  [Compress1]
      Remove irrelevant pairs from a 1-dimensional array

  [Compress2]
      Remove irrelevant pairs from a 2-dimensional array

  [Concatenate]
      Concatenate lists or strings together

  [Cond]
      Conditional based on if-then-else

  [Conjugate]
      Complex number conjugate

  [Cons]
      Pair and list constructor

  [Cons-count-bounded]
      Count the number of conses (up to a limit)

  [Cons-subtrees]
      Build a fast alist whose keys are the subtrees of X

  [Cons-with-hint]
      Alternative to [47m[cons][0m that tries to avoid consing when a suitable
      [47mcons[0m structure is provided as a hint.

  [Consp]
      Recognizer for [cons] pairs

  [Count]
      Count the number of occurrences of an item in a string or true-list

  [Count-keys]
      Count the number of keys in association list

  [Cpu-core-count]
      The number of cpu cores

  [Cw]
      Print to the comment window

  [Cw!]
      Print readably to the comment window

  [Cw!+]
      Print readably and uninhibited to the comment window

  [Cw+]
      Print uninhibited to the comment window

  [Cw-print-base-radix]
      Print to the comment window in a given print-base

  [Cw-print-base-radix!]
      Print to the comment window in a given print-base

  [Declare]
      Extra declarations that can occur in function definitions, [let]
      bindings, and so forth.

  [Default]
      Return the [47m:default[0m from the [header] of a 1- or 2-dimensional array

  [Defbadge]
      Issue a badge for a function so [47m[apply$][0m can evaluate with it

  [Defwarrant]
      Issue a warrant for a function so [47m[apply$][0m can use it in proofs

  [Delete-assoc]
      Deprecated version of [remove1-assoc]

  [Denominator]
      Divisor of a ratio in lowest terms

  [Df]
      Support for floating-point operations

  [Digit-char-p]
      The number, if any, corresponding to a given character

  [Digit-to-char]
      Map a digit to a character

  [Dimensions]
      Return the [47m:dimensions[0m from the [header] of a 1- or 2-dimensional
      array

  [Ec-call]
      Execute a call in the ACL2 logic instead of raw Lisp

  [Eighth]
      Eighth member of the list

  [Endp]
      Recognizer for empty lists

  [Eq]
      Equality of symbols

  [Eql]
      Test equality (of two numbers, symbols, or [characters])

  [Eqlable-alistp]
      Recognizer for a true list of pairs whose [47m[car][0ms are suitable for
      [47m[eql][0m

  [Eqlable-listp]
      Recognizer for a true list of objects each suitable for [47m[eql][0m

  [Eqlablep]
      The [guard] for the function [47m[eql][0m

  [Equal]
      True equality

  [Er]
      Print an error message and ``cause an error''

  [Er-hard]
      Print an error message and ``cause a hard error''

  [Er-hard?]
      Print an error message and ``cause a hard error''

  [Er-progn]
      Perform a sequence of state-changing ``error triples''

  [Er-soft]
      Print an error message and ``cause a soft error''

  [Error1]
      Print an error message and cause a ``soft error''

  [Evenp]
      Test whether an integer is even

  [Evens]
      The even-indexed members of a list

  [Explode-atom]
      Convert any [atom] into a [character-listp] that contains its
      printed representation, rendering numbers in your choice of
      print base.

  [Explode-nonnegative-integer]
      The list of [characters] in the radix-r form of a number

  [Expt]
      Exponential function

  [Extend-pathname]
      Extend a relative pathname to an absolute pathname

  [F-boundp-global]
      Check whether a global variable in [47m[state][0m has a value

  [F-get-global]
      Get the value of a global variable in [47m[state][0m

  [F-put-global]
      Assign to a global variable in [47m[state][0m

  [Fast-alist-clean]
      [47m(fast-alist-clean alist)[0m can be used to eliminate \"shadowed pairs\"
      from a fast alist.

  [Fast-alist-clean!]
      [47m(fast-alist-clean! alist)[0m is an alternative to [47m[fast-alist-clean][0m
      that produces a [normed] result.

  [Fast-alist-fork]
      [47m(fast-alist-fork alist ans)[0m can be used to eliminate \"shadowed
      pairs\" from an alist or to copy [fast-alists].

  [Fast-alist-fork!]
      [47m(fast-alist-fork! alist ans)[0m is an alternative to [47m[fast-alist-fork][0m
      that produces a [normed] result.

  [Fast-alist-free]
      [47m(fast-alist-free alist)[0m throws away the hash table associated with a
      fast alist.

  [Fast-alist-free-on-exit]
      Free a fast alist after the completion of some form.

  [Fast-alist-len]
      [47m(fast-alist-len alist)[0m counts the number of unique keys in a fast
      alist.

  [Fast-alist-summary]
      [47m(fast-alist-summary)[0m prints some basic statistics about any current
      fast alists.

  [Fifth]
      Fifth member of the list

  [First]
      First member of the list

  [Fix]
      Coerce to a number

  [Fix-true-list]
      Coerce to a true list

  [Flet]
      Local binding of function symbols

  [Floor]
      Division returning an integer by truncating toward negative infinity

  [Flush-compress]
      Flush the under-the-hood array for the given name

  [Flush-hons-get-hash-table-link]
      Deprecated feature

  [Fms]
      [47m(fms str alist co-channel state evisc) => state[0m

  [Fms!]
      [47m(fms! str alist co-channel state evisc) => state[0m

  [Fmt]
      Formatted printing

  [Fmt!]
      [47m(fmt! str alist co-channel state evisc) => state[0m

  [Fmt-to-comment-window]
      Print to the comment window

  [Fmt-to-comment-window!]
      Print readably to the comment window

  [Fmt-to-comment-window!+]
      Print readably and uninhibited to the comment window

  [Fmt-to-comment-window+]
      Print uninhibited to the comment window

  [Fmt1]
      [47m(fmt1 str alist col co-channel state evisc) => (mv col state)[0m

  [Fmt1!]
      [47m(fmt1! str alist col channel state evisc) => (mv col state)[0m

  [Fmx]
      [47m(fmx str &rest args) => state[0m

  [Fmx-cw]
      [47m(fmx-cw str &rest args) => state[0m

  [Formula]
      The formula of a name or [rune]

  [Fourth]
      Fourth member of the list

  [Gc$]
      Invoke the garbage collector

  [Gc-strategy]
      The garbage collection strategy

  [Get-cpu-time]
      Read elapsed cpu time

  [Get-internal-time]
      Runtime vs. realtime in ACL2 timings

  [Get-real-time]
      Read elapsed real time

  [Getenv$]
      Read an environment variable

  [Getprop]
      Access fast property lists

  [Getpropc]
      Access fast property lists

  [Good-bye]
      Quit entirely out of Lisp

  [Hard-error]
      Print an error message and stop execution

  [Header]
      Return the header of a 1- or 2-dimensional array

  [Hons]
      [47m(hons x y)[0m returns a [normed] object equal to [47m(cons x y)[0m.

  [Hons-acons]
      [47m(hons-acons key val alist)[0m is the main way to create or extend
      [fast-alists].

  [Hons-acons!]
      [47m(hons-acons! key val alist)[0m is an alternative to [47m[hons-acons][0m that
      produces [normed], fast alists.

  [Hons-assoc-equal]
      [47m(hons-assoc-equal key alist)[0m is [31;1mnot fast[0m; it serves as the logical
      definition for [47m[hons-get][0m.

  [Hons-clear]
      [47m(hons-clear gc)[0m is a drastic garbage collection mechanism that
      clears out the underlying Hons Space.

  [Hons-clear!]
      A version of [47m[hons-clear][0m for [parallel] execution

  [Hons-copy]
      [47m(hons-copy x)[0m returns a [normed] object that is equal to X.

  [Hons-copy-persistent]
      [47m(hons-copy-persistent x)[0m returns a [normed] object that is equal to
      X and which will be re-normed after any calls to [47m[hons-clear][0m.

  [Hons-equal]
      [47m(hons-equal x y)[0m is a recursive equality check that optimizes when
      parts of its arguments are [normed].

  [Hons-get]
      [47m(hons-get key alist)[0m is the efficient lookup operation for
      [fast-alists].

  [Hons-resize]
      [47m(hons-resize ...)[0m can be used to manually adjust the sizes of the
      hash tables that govern which ACL2 Objects are considered
      [normed].

  [Hons-shrink-alist]
      Deprecated feature

  [Hons-shrink-alist!]
      Deprecated feature

  [Hons-summary]
      [47m(hons-summary)[0m prints basic information about the sizes of the
      tables in the current Hons Space.

  [Hons-wash]
      [47m(hons-wash)[0m is like [47m[gc$][0m but can also garbage collect [normed]
      objects (CCL and GCL Only).

  [Hons-wash!]
      A version of [47m[hons-wash][0m for [parallel] execution

  [Identity]
      The identity function

  [If]
      If-then-else function

  [Iff]
      Logical ``if and only if''

  [Ifix]
      Coerce to an integer

  [Illegal]
      Print an error message and stop execution

  [Imagpart]
      Imaginary part of a complex number

  [Implies]
      Logical implication

  [Improper-consp]
      Recognizer for improper (non-[47mnil[0m-terminated) non-empty lists

  [In-package]
      Select current package

  [In-tau-intervalp]
      Boolean membership in a tau interval

  [Int=]
      Test equality of two integers

  [Integer-length]
      Number of bits in two's complement integer representation

  [Integer-listp]
      Recognizer for a true list of integers

  [Integer-range-p]
      Recognizer for integers between two bounds.

  [Integerp]
      Recognizer for whole numbers

  [Intern]
      Create a new symbol in a given package

  [Intern$]
      Create a new symbol in a given package

  [Intern-in-package-of-symbol]
      Create a symbol with a given name

  [Intersection$]
      Elements common to the given lists

  [Intersectp]
      Test whether two lists intersect

  [Keyword-listp]
      Recognizer for true lists of keywords

  [Keyword-value-listp]
      Recognizer for true lists whose even-position elements are keywords

  [Keywordp]
      Recognizer for keywords

  [Kwote]
      Quote an arbitrary object

  [Kwote-lst]
      Quote an arbitrary true list of objects

  [Last]
      The last [47m[cons][0m (not element) of a list

  [Last-cdr]
      The last [47m[cdr][0m of a list

  [Last-prover-steps]
      The number of prover steps most recently taken

  [Len]
      Length of a list

  [Length]
      Length of a string or proper list

  [Let]
      Binding of lexically scoped (local) variables

  [Let*]
      Binding of lexically scoped (local) variables

  [Lexorder]
      Total order on ACL2 objects

  [List]
      Build a list

  [List$]
      Build a list

  [List*]
      Build a list

  [Listp]
      Recognizer for (not necessarily proper) lists

  [Logand]
      Bitwise logical `and' of zero or more integers

  [Logandc1]
      Bitwise logical `and' of two ints, complementing the first

  [Logandc2]
      Bitwise logical `and' of two ints, complementing the second

  [Logbitp]
      The [47mi[0mth bit of an integer

  [Logcount]
      Number of ``on'' bits in a two's complement number

  [Logeqv]
      Bitwise logical equivalence of zero or more integers

  [Logic-fns-list-listp]
      Recognizer for when a given list of lists of [term]s calls only
      [47m:[0m[47m[logic][0m-mode function symbols

  [Logic-fns-listp]
      Recognizer for when a given list of [term]s calls only [47m:[0m[47m[logic][0m-mode
      function symbols

  [Logic-fnsp]
      Recognizer for when a given [term] calls only [47m:[0m[47m[logic][0m-mode function
      symbols

  [Logic-term-list-listp]
      Recognizer for lists of lists of [term]s that call only
      [47m:[0m[47m[logic][0m-mode function symbols

  [Logic-term-listp]
      Recognizer for lists of [term]s that call only [47m:[0m[47m[logic][0m-mode
      function symbols

  [Logic-termp]
      Recognizer for [term]s that call only [47m:[0m[47m[logic][0m-mode function symbols

  [Logior]
      Bitwise logical inclusive or of zero or more integers

  [Lognand]
      Bitwise logical `nand' of two integers

  [Lognor]
      Bitwise logical `nor' of two integers

  [Lognot]
      Bitwise not of a two's complement number

  [Logorc1]
      Bitwise logical inclusive or of two ints, complementing the first

  [Logorc2]
      Bitwise logical inclusive or of two ints, complementing the second

  [Logtest]
      Test if two integers share a `1' bit

  [Logxor]
      Bitwise logical exclusive or of zero or more integers

  [Loop$]
      Iteration with an analogue of the Common Lisp [47mloop[0m macro

  [Lower-case-p]
      Recognizer for lower case characters

  [Macrolet]
      Local binding of macro symbols

  [Make]
      Constructor macro for [defrec] structures.

  [Make-character-list]
      [coerce] to a list of characters

  [Make-fast-alist]
      [47m(make-fast-alist alist)[0m creates a fast-alist from the input alist,
      returning [47malist[0m itself or, in some cases, a new object equal to
      it.

  [Make-list]
      Make a list of a given size

  [Make-ord]
      A constructor for ordinals.

  [Make-tau-interval]
      Make a tau interval

  [Makunbound-global]
      Remove the value assigned to a global variable in [47m[state][0m

  [Max]
      The larger of two numbers

  [Maximum-length]
      Return the [47m:maximum-length[0m from the [header] of an array

  [Maybe-flush-and-compress1]
      Compress a one-dimensional array only if necessary

  [Mbe]
      Attach code for execution

  [Mbe1]
      Attach code for execution

  [Mbt]
      Introduce a test into the logic that, however, evaluates to [47mt[0m

  [Mbt*]
      Introduce a guard proof obligation

  [Member]
      Membership predicate

  [Merge-sort-lexorder]
      Sort a list

  [Min]
      The smaller of two numbers

  [Minusp]
      Test whether a number is negative

  [Mod]
      Remainder using [47m[floor][0m

  [Mod-expt]
      Exponential function

  [Msg]
      Construct a ``message'' suitable for the [47m~@[0m directive of [47m[fmt][0m

  [Msgp]
      Recognizer for a ``message''

  [Must-be-equal]
      Attach code for execution

  [Mv]
      Returning a multiple value

  [Mv-let]
      Calling multi-valued ACL2 functions

  [Mv-list]
      Converting [multiple-value] result to a single-value list

  [Mv-nth]
      The mv-nth element (zero-based) of a list

  [Mv?]
      Return one or more values

  [Mv?-let]
      Calling possibly multi-valued ACL2 functions

  [Nat-listp]
      Recognizer for a true list of natural numbers

  [Natp]
      A recognizer for the natural numbers

  [Nfix]
      Coerce to a natural number

  [Ninth]
      Ninth member of the list

  [No-duplicatesp]
      Check for duplicates in a list

  [Non-exec]
      Mark code as non-executable

  [Nonnegative-integer-quotient]
      Natural number division function

  [Not]
      Logical negation

  [Nth]
      The nth element (zero-based) of a list

  [Nthcdr]
      Final segment of a list

  [Null]
      Recognizer for the empty list

  [Number-subtrees]
      [47m(number-subtrees x)[0m returns the number of distinct subtrees of X, in
      the sense of [47m[equal][0m

  [Numerator]
      Dividend of a ratio in lowest terms

  [O-finp]
      Recognizes if an ordinal is finite

  [O-first-coeff]
      Returns the first coefficient of an ordinal

  [O-first-expt]
      The first exponent of an ordinal

  [O-infp]
      Recognizes if an ordinal is infinite

  [O-p]
      A recognizer for the ordinals up to epsilon-0

  [O-rst]
      Returns the rest of an infinite ordinal

  [O<]
      The well-founded less-than relation on ordinals up to [47mepsilon-0[0m

  [O<=]
      The less-than-or-equal relation for the ordinals

  [O>]
      The greater-than relation for the ordinals

  [O>=]
      The greater-than-or-equal relation for the ordinals

  [Observation]
      Print an observation

  [Oddp]
      Test whether an integer is odd

  [Odds]
      The odd-indexed members of a list

  [Open-output-channel!]
      When trust tags are needed to open output channels

  [Or]
      Disjunction

  [Packn]
      Build a symbol from a list

  [Packn-pos]
      Build a symbol in a specified package from a list

  [Pairlis$]
      Zipper together two lists

  [Pairlis-x1]
      Cons a given element to each member of a list

  [Pairlis-x2]
      Cons each element of a list with a given element

  [Pand]
      Parallel, Boolean version of [47m[and][0m

  [Pargs]
      Parallel evaluation of arguments in a function call

  [Pkg-witness]
      Return a specific symbol in the indicated package

  [Plet]
      Parallel version of [47m[let][0m

  [Plusp]
      Test whether a number is positive

  [Por]
      Parallel, Boolean version of [47m[or][0m

  [Pos-listp]
      Recognizer for a true list of positive integers

  [Position]
      Position of an item in a string or a list

  [Posp]
      A recognizer for the positive integers

  [Pprogn]
      Evaluate a sequence of forms that return [state]

  [Primitive]
      Primitive functions built into ACL2 without definitions

  [Princ$]
      Print an atom

  [Print-base-p]
      Recognizer for print bases that are understood by functions such as
      [explode-nonnegative-integer] and [explode-atom].

  [Print-object$]
      Print an object to an open object output channel

  [Print-object$+]
      Print an object to an open output channel in a specified manner

  [Prog2$]
      Execute two forms and return the value of the second one

  [Progn$]
      Execute a sequence of forms and return the value of the last one

  [Proofs-co]
      The proofs character output channel

  [Proper-consp]
      Recognizer for proper ([47mnil[0m-terminated) non-empty lists

  [Pseudo-term-listp]
      A predicate for recognizing lists of term-like s-expressions

  [Pseudo-termp]
      A predicate for recognizing term-like s-expressions

  [Put-assoc]
      Modify an association list by associating a value with a key

  [Putprop]
      Update fast property lists

  [Quote]
      Create a constant

  [R-eqlable-alistp]
      Recognizer for a true list of pairs whose [47m[cdr][0ms are suitable for
      [47m[eql][0m

  [R-symbol-alistp]
      Recognizer for association lists with symbols as values

  [Random$]
      Obtain a random value

  [Rassoc]
      Look up value in association list

  [Rational-listp]
      Recognizer for a true list of rational numbers

  [Rationalp]
      Recognizer for rational numbers (ratios and integers)

  [Read-ACL2-oracle]
      Pop the oracle field of the state

  [Read-run-time]
      Read elapsed runtime

  [Real-listp]
      ACL2(r) recognizer for a true list of real numbers

  [Real/rationalp]
      Recognizer for rational numbers (including real number in ACL2(r))

  [Realfix]
      Coerce to a real number

  [Realpart]
      Real part of a complex number

  [Rem]
      Remainder using [47m[truncate][0m

  [Remove]
      Remove all occurrences

  [Remove-assoc]
      Remove all pairs with a given key from an association list

  [Remove-duplicates]
      Remove duplicates from a string or a list

  [Remove1]
      Remove first occurrences, testing using [47m[eql][0m

  [Remove1-assoc]
      Remove the first pair with a given key from an association list

  [Resize-list]
      List resizer in support of [stobj]s

  [Rest]
      Rest ([47m[cdr][0m) of the list

  [Return-last]
      Return the last argument, perhaps with side effects

  [Revappend]
      Concatenate the [reverse] of one list to another

  [Reverse]
      Reverse a list or string

  [Rfix]
      Coerce to a rational number

  [Round]
      Division returning an integer by rounding off

  [Search]
      Search for a string or list in another string or list

  [Second]
      Second member of the list

  [Serialize-read]
      Read a serialized ACL2 object from a file

  [Serialize-write]
      Write an ACL2 object into a file

  [Set-difference$]
      Elements of one list that are not elements of another

  [Set-fmt-hard-right-margin]
      Set the right margin for formatted output

  [Set-fmt-soft-right-margin]
      Set the soft right margin for formatted output

  [Set-gc-strategy]
      Set the garbage collection strategy (CCL only)

  [Set-print-base]
      Control radix in which numbers are printed

  [Set-print-base-radix]
      Control radix in which numbers are printed and printing of the radix

  [Set-print-case]
      Control whether symbols are printed in upper case or in lower case

  [Set-print-radix]
      Control printing of the radix for numbers

  [Setenv$]
      Set an environment variable

  [Seventh]
      Seventh member of the list

  [Signed-byte-p]
      Recognizer for signed integers that fit in a specified bit width

  [Signum]
      Indicator for positive, negative, or zero

  [Sixth]
      Sixth member of the list

  [Spec-mv-let]
      Modification of [47m[mv-let][0m supporting speculative and parallel
      execution

  [Standard-char-listp]
      Recognizer for a true list of standard characters

  [Standard-char-p]
      Recognizer for standard characters

  [Standard-char-p+]
      Recognizer for standard characters whose guard is [47mt[0m

  [Standard-co]
      The character output channel to which [47m[ld][0m prints

  [Standard-oi]
      The standard object input ``channel''

  [State-global-let*]
      Bind [state] global variables

  [String]
      [coerce] to a string

  [String-alistp]
      Recognizer for association lists with strings as keys

  [String-append]
      [concatenate] two strings

  [String-downcase]
      In a given string, turn upper-case [characters] into lower-case

  [String-equal]
      String equality without regard to case

  [String-listp]
      Recognizer for a true list of strings

  [String-upcase]
      In a given string, turn lower-case [characters] into upper-case

  [String<]
      Less-than test for strings

  [String<=]
      Less-than-or-equal test for strings

  [String>]
      Greater-than test for strings

  [String>=]
      Less-than-or-equal test for strings

  [Stringp]
      Recognizer for strings

  [Strip-cars]
      Collect up all first components of pairs in a list

  [Strip-cdrs]
      Collect up all second components of pairs in a list

  [Sublis]
      Substitute an alist into a tree

  [Subseq]
      Subsequence of a string or list

  [Subsetp]
      Test if every [47m[member][0m of one list is a [47m[member][0m of the other

  [Subst]
      A single substitution into a tree

  [Substitute]
      Substitute into a string or a list, using [47m[eql][0m as test

  [Swap-stobjs]
      Swap two congruent [stobj]s

  [Symbol-alistp]
      Recognizer for association lists with symbols as keys

  [Symbol-listp]
      Recognizer for a true list of symbols

  [Symbol-name]
      The name of a symbol (a string)

  [Symbol-name-lst]
      Lift [47m[symbol-name][0m to lists

  [Symbol-package-name]
      The name of the package of a symbol (a string)

  [Symbol<]
      Less-than test for symbols

  [Symbolp]
      Recognizer for symbols

  [Sys-call]
      Make a system call to the host operating system

  [Sys-call*]
      Make a system call to the host OS, returning a status

  [Sys-call+]
      Make a system call to the host OS, returning status and output

  [Sys-call-status]
      Exit status from the preceding system call

  [Take]
      Initial segment (first n elements) of a list

  [Tenth]
      Tenth member of the list

  [Term-list-listp]
      recognizer for a list of [clause]s

  [Term-listp]
      recognizer for a list of quotations of terms and of [clause]s

  [Term-order]
      The ordering relation on terms used by ACL2

  [Termp]
      recognizer for the quotation of a [term]

  [The]
      Special form for execution efficiency or run-time type checks

  [The-number]
      Coerce an expected number to a number

  [The-true-list]
      Coerce an expected true list to a true list

  [Third]
      Third member of the list

  [Time$]
      Time the evaluation of a given form

  [Time-tracker]
      Display time spent during specified evaluation

  [Trace-co]
      The [trace] character output channel

  [True-list-fix]
      Coerce to a true list

  [True-list-listp]
      Recognizer for true (proper) lists of true lists

  [True-listp]
      Recognizer for proper ([47mnil[0m-terminated) lists

  [Truncate]
      Division returning an integer by truncating toward 0

  [Unary--]
      Arithmetic negation function

  [Unary-/]
      Reciprocal function

  [Union$]
      A list that contains exactly the elements of the given lists

  [Unquote]
      Obtain the object being quoted

  [Unsigned-byte-p]
      Recognizer for natural numbers that fit in a specified bit width

  [Update-nth]
      Modify a list by putting the given value at the given position

  [Update-nth-array]
      Update a stobj array

  [Upper-case-p]
      Recognizer for upper case characters

  [Value-triple]
      Compute a value, optionally checking that it is not [47mnil[0m

  [With-fast-alist]
      [47m(with-fast-alist name form)[0m causes [47mname[0m to be a fast alist for the
      execution of [47mform[0m.

  [With-global-stobj]
      Operate on a global single-threaded object

  [With-guard-checking]
      Suppress or enable guard-checking for a form

  [With-guard-checking-error-triple]
      Suppress or enable guard-checking for a form

  [With-guard-checking-event]
      Suppress or enable guard-checking for an event form

  [With-live-state]
      Allow a reference to [47mstate[0m in raw Lisp

  [With-local-state]
      Locally bind state

  [With-local-stobj]
      Locally bind a single-threaded object

  [With-output-lock]
      Provides a mutual-exclusion mechanism for performing output in
      parallel

  [With-serialize-character]
      Control output mode for [47mprint-object$[0m

  [With-stolen-alist]
      [47m(with-stolen-alist name form)[0m ensures that [47mname[0m is a fast alist at
      the start of the execution of [47mform[0m.  At the end of execution,
      it ensures that [47mname[0m is a fast alist if and only if it was
      originally.  That is, if [47mname[0m was not a fast alist originally,
      its hash table link is freed, and if it was a fast alist
      originally but its table was modified during the execution of
      [47mform[0m, that table is restored.  Note that any extended table
      created from the original fast alist during [47mform[0m must be
      manually freed.

  [Without-evisc]
      Print output in full

  [Xor]
      Logical ``exclusive or''

  [Zerop]
      Test an acl2-number against 0

  [Zip]
      Testing an ``integer'' against 0

  [Zp]
      Testing a ``natural'' against 0

  [Zpf]
      Testing a nonnegative fixnum against 0")
 (ACL2-COUNT
  (BASICS ACL2-BUILT-INS)
  "A commonly used measure for justifying recursion

  [47m(Acl2-count x)[0m returns a nonnegative integer that indicates the
  ``size'' of its argument [47mx[0m.

  All [characters] and symbols have [47macl2-count 0[0m.  The [47macl2-count[0m of a
  string is the number of [characters] in it, i.e., its length.  The
  [47macl2-count[0m of a [47m[cons][0m is one greater than the sum of the
  [47macl2-count[0ms of the [47m[car][0m and [47m[cdr][0m.  The [47macl2-count[0m of an integer
  is its absolute value.  The [47macl2-count[0m of a rational is the sum of
  the [47macl2-count[0ms of the numerator and denominator.  The [47macl2-count[0m
  of a complex rational is one greater than the sum of the
  [47macl2-count[0ms of the real and imaginary parts.

  [31;1mFunction: [0m<acl2-count>

    (defun acl2-count (x)
      (declare (xargs :guard t))
      (if (consp x)
          (+ 1 (acl2-count (car x))
             (acl2-count (cdr x)))
        (if (rationalp x)
            (if (integerp x)
                (integer-abs x)
              (+ (integer-abs (numerator x))
                 (denominator x)))
          (if (complex/complex-rationalp x)
              (+ 1 (acl2-count (realpart x))
                 (acl2-count (imagpart x)))
            (if (stringp x) (length x) 0)))))")
 (ACL2-CUSTOMIZATION
  (MISCELLANEOUS)
  "File of initial commands for ACL2 to run at [startup]

  ACL2 provides a mechanism to load automatically a so-called ``ACL2
  customization file,'' via [47m[ld][0m, the first time [47m[lp][0m is called in an
  ACL2 session.  ACL2 looks for this file as follows.

   1. If the host Lisp reads a non-empty value for the system's environment
      variable [47mACL2_CUSTOMIZATION[0m, then that string value is used for
      the customization file name.  In this case, if the file does
      not exist or if the string is \"NONE\" then there is no
      customization file.  Notes:

        * If the customization file name is a relative pathname (see
          [pathname]), then the pathname is considered relative to
          the connected book directory (see [cbd]).

        * If this variable is not already defined, then its value is set to
          [47mNONE[0m when books are certified using [build::cert.pl] or
          other, legacy Make-based certification tools.

   2. Otherwise (empty environment variable value), file
      [47m\"acl2-customization.lsp\"[0m or [47m\"acl2-customization.lisp\"[0m on the
      connected book directory (see [cbd]), generally the current
      directory, is the customization file (in that order) if either
      exists.

   3. Otherwise file [47m\"acl2-customization.lsp\"[0m or [47m\"acl2-customization.lisp\"[0m
      on your home directory is the customization file (in that
      order), if either exists (except, this case is skipped on
      Windows operating systems.

  Except for the fact that this [47m[ld][0m command is not typed explicitly by
  you, it is a standard [47m[ld][0m command except that any settings of [47m[ld][0m
  specials are remembered once this call of [47m[ld][0m has completed other
  than [47m[ld-error-action][0m, which will always be [47m:command-conventions[0m
  after that call of [47mld[0m completes.  For example, suppose that you
  start your customization file with [47m(set-ld-skip-proofsp t state)[0m,
  so that proofs are skipped as it is loaded with [47m[ld][0m.  Then the
  [47m[ld][0m special [47m[ld-skip-proofsp][0m will remain [47mt[0m after the [47m[ld][0m has
  completed, causing proofs to be skipped in your ACL2 session,
  unless your customization file sets this variable back to [47mnil[0m, say
  with [47m(set-ld-skip-proofsp nil state)[0m.

  If the customization file exists, it is loaded with [47m[ld][0m using the
  usual default values for the [47m[ld][0m specials (see [ld]) except that
  [47m:ld-error-action[0m is [47m:error[0m.  If an error is encountered, then no
  subsequent forms in the file will be evaluated and ACL2 will quit
  immediately.

  To create a customization file it is recommended that you first give
  it a name other than [47m\"acl2-customization.lsp\"[0m or
  [47m\"acl2-customization.lisp\"[0m so that ACL2 does not try to include it
  prematurely when you next enter [47m[lp][0m.  Then, while in the
  uncustomized [47m[lp][0m, explicitly invoke [47m[ld][0m on your evolving (but
  renamed) customization file until all forms are successfully
  evaluated.  The same procedure is recommended if for some reason
  ACL2 cannot successfully evaluate all forms in your customization
  file: temporarily rename your customization file so that ACL2 does
  not try to [47m[ld][0m it automatically and then debug the new file by
  explicit calls to [47m[ld][0m.

  WARNING!  If you certify a book after the (automatic) loading of a
  customization file, the forms in that file will be part of the
  [portcullis] of the [books] you certify!  That is, the forms in
  your customization file at certification time will be loaded
  whenever anybody uses the [books] you are certifying.  Since
  customization files generally contain idiosyncratic [command]s, you
  may not want yours to be part of the [books] you create for others.
  Thus, if you have a customization file then you may want to invoke
  [47m:[0m[47m[ubt][0m[47m 1[0m before certifying any [books]; alternatively, see
  [certify-book!] for automatic invocation of [47m[ubt][0m.

  On the other hand, if you wish to prevent undoing commands from the
  customization file, see [reset-prehistory].

  Note that except on Windows-based systems, if there is a file
  [47macl2-init.lsp[0m in your home directory, then it will be loaded into
  raw Lisp when ACL2 is invoked.


Silent loading of ACL2 customization files

  When the environment variable [47mACL2_CUSTOMIZATION_QUIET[0m is set and not
  [47m\"\"[0m, there will generally be no output from ACL2 customization.  A
  special value of [47m\"all\"[0m for this variable will cause continued
  minimal output after startup, as explained in the following remark.

  Technical Remark.  For quiet loading of acl2-customization files,
  [47m[ld][0m specials are bound to the following values.

    ld-verbose = nil
    ld-pre-eval-print = :never
    ld-post-eval-print = nil
    ld-prompt = nil

  These [47mld[0m specials are returned to their normal values after loading
  an ACL2 customization file, with one exception: if
  [47mACL2_CUSTOMIZATION_QUIET[0m has value [47m\"ALL\"[0m (or [47m\"all\"[0m; the case is
  irrelevant), then those values are retained in the ACL2 loop even
  after customization completes.")
 (ACL2-DEFAULTS-TABLE
  (TABLE)
  "A [table] specifying certain defaults, e.g., the default [defun-mode]

    Example Forms:
    (table acl2-defaults-table :defun-mode) ; current default defun-mode
    (table acl2-defaults-table :defun-mode :program)
               ; set default defun-mode to :program

  See [table] for a discussion of tables in general.  The legal keys
  for this [table] are shown below.  They may be accessed and changed
  via the general mechanisms provided by [table]s.  However, there
  are often more convenient ways to access and/or change the
  defaults.  (See also the note below.)

    :user

  The [47m:user[0m key is for ACL2 users; the system does not consult this key
  or set it (other than as part of general [47macl2-defaults-table [0m
  maintenance).  Its value is required to be an association list
  ([47m[alistp][0m), so that different users can read and write their
  ``own'' keys.  For example, suppose user Joe uses key [47m:j[0m while user
  Mary uses key [47m:m[0m; then we could see a value for [47m:user[0m of [47m((:j . 3)
  (:m . 4))[0m after Joe sets his value to 3 and Mary sets her value to
  4.

    :defun-mode

  the default [defun-mode], which must be [47m:[0m[47m[program][0m or [47m:[0m[47m[logic][0m.  See
  [defun-mode] for a general discussion of [defun-mode]s.  The
  [47m:[0m[47m[defun-mode][0m key may be conveniently set by keyword commands
  naming the new [defun-mode], [47m:[0m[47m[program][0m and [47m:[0m[47m[logic][0m.  See
  [program] and see [logic].

    :enforce-redundancy

  if [47mt[0m, cause ACL2 to insist that most events are redundant (see
  [redundant-events]); if [47m:warn[0m, cause a warning instead of an error
  for such non-redundant events; else, [47mnil[0m.  See
  [set-enforce-redundancy].

    :verify-guards-eagerness

  an integer between 0 and 3 indicating how eager the system is to
  verify the [guard]s of a [defun] event.  See
  [set-verify-guards-eagerness].

    :compile-fns

  When this key's value is [47mt[0m, functions are compiled when they are
  [47m[defun][0m'd; otherwise, the value is [47mnil[0m.  (Except, this key's value
  is ignored when explicit compilation is suppressed; see
  [compilation].)  To set the flag, see [set-compile-fns].

    :measure-function

  the default measure function used by [47m[defun][0m when no [47m:measure[0m is
  supplied in [47m[xargs][0m.  The default measure function must be a
  function symbol of one argument. Let [47mmfn[0m be the default measure
  function and suppose no [47m:measure[0m is supplied with some recursive
  function definition.  Then [47m[defun][0m finds the first formal, [47mvar[0m,
  that is tested along every branch and changed in each recursive
  call.  The system then ``guesses'' that [47m(mfn var)[0m is the [47m:measure[0m
  for that [47m[defun][0m.

    :well-founded-relation

  the default well-founded relation used by [47m[defun][0m when no
  [47m:well-founded-relation[0m is supplied in [47m[xargs][0m.  The default
  well-founded relation must be a function symbol, [47mrel[0m, of two
  arguments about which a [47m:well-founded-relation[0m rule has been
  proved.  See [well-founded-relation-rule].

    :bogus-defun-hints-ok

  When this key's value is [47mt[0m, ACL2 allows [47m:hints[0m and also [47m:measure[0m for
  nonrecursive function definitions.  Otherwise, the value is [47mnil[0m
  (the default) or [47m:warn[0m (which makes the check but merely warns when
  the check fails).  See [set-bogus-defun-hints-ok] and
  [set-bogus-measure-ok].

    :bogus-mutual-recursion-ok

  When this key's value is [47mt[0m, ACL2 skips the check that every function
  in a [47m[mutual-recursion][0m (or [47m[defuns][0m) ``clique'' calls at least one
  other function in that ``clique.'' Otherwise, the value is [47mnil[0m (the
  default) or [47m:warn[0m (which makes the check but merely warns when the
  check fails).  See [set-bogus-mutual-recursion-ok].

    :irrelevant-formals-ok

  When this key's value is [47mt[0m, the check for irrelevant formals is
  bypassed; otherwise, the value is the keyword [47mnil[0m (the default) or
  [47m:warn[0m (which makes the check but merely warns when the check
  fails).  See [irrelevant-formals] and see
  [set-irrelevant-formals-ok].

    :ignore-ok

  When this key's value is [47mt[0m, the check for ignored variables is
  bypassed; otherwise, the value is the keyword [47mnil[0m (the default) or
  [47m:warn[0m (which makes the check but merely warns when the check
  fails).  See [set-ignore-ok].

    :bdd-constructors

  This key's value is a list of function symbols used to define the
  notion of ``BDD normal form.'' See [bdd-algorithm] and see [hints].

    :ttag

  This key's value, when non-[47mnil[0m, allows certain operations that extend
  the trusted code base beyond what is provided by ACL2.  See
  [defttag].  See [defttag].

    :state-ok

  This key's value is either [47mt[0m or [47mnil[0m and indicates whether the user is
  aware of the syntactic restrictions on the variable symbol [47mSTATE[0m.
  See [set-state-ok].

    :backchain-limit

  This key's value is a list of two ``numbers.'' Either ``number'' may
  optionally be [47mnil[0m, which is treated like positive infinity.  The
  numbers control backchaining through hypotheses during
  [type-reasoning] and rewriting.  See [backchain-limit].

    :default-backchain-limit

  This key's value is a list of two ``numbers.'' Either ``number'' may
  optionally be [47mnil[0m, which is treated like positive infinity.  The
  numbers are used respectively to set the backchain limit of a rule
  if one has not been specified. See [backchain-limit].

    :step-limit

  This key's value is either [47mnil[0m or a natural number not exceeding the
  value of [47m*default-step-limit*[0m.  If the value is [47mnil[0m or the value of
  [47m*default-step-limit*[0m, there is no limit on the number of ``steps''
  that ACL2 counts during a proof: currently, the number of top-level
  rewriting calls.  Otherwise, the value is the maximum number of
  such calls allowed during evaluation of any event.  See
  [set-prover-step-limit].

    :rewrite-stack-limit

  This key's value is a nonnegative integer less than [47m(expt 2 28)[0m.  It
  is used to limit the depth of calls of ACL2 rewriter functions.
  See [rewrite-stack-limit].

    :let*-abstractionp

  This key affects how the system displays subgoals.  The value is
  either [47mt[0m or [47mnil[0m.  When t, let* expressions are introduced before
  printing to eliminate common subexpressions.  The actual goal being
  worked on is unchanged.

    :case-split-limitations

  This key's value is a list of two ``numbers.'' Either ``number'' may
  optionally be [47mnil[0m, which is treated like positive infinity.  The
  numbers control how the system handles case splits in the
  simplifier.  See [set-case-split-limitations].

    :include-book-dir-alist

  This key's value is used by [47m[include-book][0m's [47m:DIR[0m argument to
  associate a directory with a keyword.  It need not associate a
  value with [47m:SYSTEM[0m, to denote the [47mbooks/[0m directory (see
  [community-books]; see [include-book], in particular the section on
  ``Books Directory.'' Also see [47m[add-include-book-dir][0m,
  [47m[add-include-book-dir!][0m, and [47m[project-dir-alist][0m.

    :match-free-default

  This key's value is either [47m:all[0m, [47m:once[0m, or [47mnil[0m.  See
  [set-match-free-default].

    :match-free-override

  This key's value is a list of runes.  See [add-match-free-override].

    :match-free-override-nume

  This key's value is an integer used in the implementation of
  [add-match-free-override], so that only existing runes are affected
  by that event.

    :non-linearp

  This key's value is either [47mt[0m or [47mnil[0m and indicates whether the user
  wishes ACL2 to extend the linear arithmetic decision procedure to
  include non-linear reasoning.  See [non-linear-arithmetic].

    :tau-auto-modep

  This key's value is either [47mt[0m or [47mnil[0m and indicates whether the user
  wishes ACL2 to look for opportunities to create [47m:[0m[47m[tau-system][0m rules
  from all suitable [47mdefun[0ms and from all suitable [47mdefthm[0ms (with
  non-[47mnil[0m [47m:[0m[47m[rule-classes][0m).  See [set-tau-auto-mode].

    :ruler-extenders

  This key's value may be a list of symbols, indicating those function
  symbols that are not to block the collection of rulers; see
  [defun].  Otherwise the value is [47m:all[0m to indicate all function
  symbols, i.e., so that no function symbol blocks the collection of
  rulers.  If a list is specified (rather than [47m:all[0m), then it may
  contain the keyword [47m:lambdas[0m, which has the special role of
  specifying all [47mlambda[0m applications.  No other keyword is permitted
  in the list.  See [rulers].

    :memoize-ideal-okp

  This key's value must be either [47mt[0m, [47mnil[0m, or [47m:warn[0m.  If the value is
  [47mnil[0m or not present, then it is illegal by default to [memoize] a
  [47m:[0m[47m[logic][0m mode function that has not been [guard]-verified (see
  [verify-guards]), sometimes called an ``ideal-mode'' function.
  This illegality is the default because such calls of such functions
  in the ACL2 loop are generally evaluated in the logic (using
  executable counterpart definitions; see [evaluation]), rather than
  directly by executing calls of the corresponding (memoized) raw
  Lisp function.  However, such a raw Lisp call can be made when the
  function is called by a [47m:[0m[47m[program][0m mode function, so we allow you
  to override the default behavior by associating the value [47mt[0m or
  [47m:warn[0m with the key [47m:memoize-ideal-okp[0m, where with [47m:warn[0m you get a
  suitable warning.  Note that you can also allow memoization of
  ideal-mode functions by supplying argument [47m:ideal-okp[0m to your
  memoization event (see [memoize]), in which case the value of
  [47m:memoize-ideal-okp[0m in the [47macl2-defaults-table[0m is irrelevant.

    :check-invariant-risk

  For an explanation of this key, see [set-check-invariant-risk].

    :register-invariant-risk

  For an explanation of this key, see [set-register-invariant-risk].

    :in-theory-redundant-okp

  When this key's value is [47mt[0m, an [47m[in-theory][0m event may be redundant.
  See [47m[set-in-theory-redundant-okp][0m.

  Note: Unlike all other [table]s, [47macl2-defaults-table[0m can affect the
  soundness of the system.  The [table] mechanism therefore enforces
  on it a restriction not imposed on other [table]s: when [47m[table][0m is
  used to update the [47macl2-defaults-table[0m, the key and value must be
  variable-free forms.  Thus, while

    (table acl2-defaults-table :defun-mode :program),

    (table acl2-defaults-table :defun-mode ':program), and

    (table acl2-defaults-table :defun-mode (compute-mode *my-data*))

  are all examples of legal [events] (assuming [47mcompute-mode[0m is a
  function of one non-[47m[state][0m argument that produces a [defun-mode]
  as its single value),

    (table acl2-defaults-table :defun-mode (compute-mode (w state)))

  is not legal because the value form is [47m[state][0m-sensitive.

  Consider for example the following three [events] which one might
  make into the text of a book.

    (in-package \"ACL2\")

    (table acl2-defaults-table
      :defun-mode
      (if (ld-skip-proofsp state) :logic :program))

    (defun crash-and-burn (x) (car x))

  The second event is illegal because its value form is
  [47m[state][0m-sensitive.  If it were not illegal, then it would set the
  [47m:[0m[47m[defun-mode][0m to [47m:[0m[47m[program][0m when the book was being certified but
  would set the [defun-mode] to [47m:[0m[47m[logic][0m when the book was being
  loaded by [47m[include-book][0m.  That is because during certification,
  [47m[ld-skip-proofsp][0m is [47mnil[0m (proof obligations are generated and
  proved), but during book inclusion [47m[ld-skip-proofsp][0m is non-[47mnil[0m
  (those obligations are assumed to have been satisfied.)  Thus, the
  above book, when loaded, would create a function in [47m:[0m[47m[logic][0m mode
  that does not actually meet the conditions for such status.

  For similar reasons, [47m[table][0m [events] affecting [47macl2-defaults-table[0m
  are illegal within the scope of [47m[local][0m forms.  That is, the text

    (in-package \"ACL2\")

    (local (table acl2-defaults-table :defun-mode :program))

    (defun crash-and-burn (x) (car x))

  is illegal because [47macl2-defaults-table[0m is changed locally.  If this
  text were acceptable as a book, then when the book was certified,
  [47mcrash-and-burn[0m would be processed in [47m:[0m[47m[program][0m mode, but when the
  certified book was included later, [47mcrash-and-burn[0m would have
  [47m:[0m[47m[logic][0m mode because the [47m[local][0m event would be skipped.

  The text

    (in-package \"ACL2\")

    (program) ;which is (table acl2-defaults-table :defun-mode :program)

    (defun crash-and-burn (x) (car x))

  is acceptable and defines [47mcrash-and-burn[0m in [47m:[0m[47m[program][0m mode, both
  during certification and subsequent inclusion.

  We conclude with important observations about the interaction of the
  [47macl2-defaults-table[0m with [47m[include-book][0m, [47m[certify-book][0m, and
  [47m[encapsulate][0m.  If the [47macl2-defaults-table[0m has value [47mV[0m and you
  evaluate a call of [47m[include-book][0m, [47m[certify-book][0m, or
  [47m[encapsulate][0m, then the [47macl2-defaults-table[0m has value [47mV[0m when that
  call returns.  Thus, if you want to set the [47macl2-defaults-table[0m in
  a way that persists, you need to do so using [command]s that are
  not inside [books].  It may be useful to set your favorite defaults
  in your [47m[ACL2-customization][0m file; see [ACL2-customization].

  ACL2 disallows (for logical reasons) setting of the
  [47macl2-defaults-table[0m in the context of [47mLOCAL[0m.  Often it is easy
  simply to avoid wrapping an [47macl2-defaults-table[0m event, or a macro
  that generates such an event, inside a [47mLOCAL[0m; after all, a local
  context is not useful when setting the [47macl2-defaults-table[0m, since
  that table is restored as discussed above upon completion of
  [47m[include-book][0m, [47m[certify-book][0m, and [47m[encapsulate][0m forms.
  Occasionally a bit more thought is required to work around this
  restriction, but usually it's not difficult to do so.  Suppose for
  example that you attempt to put following event form into a book.

    (local (progn (defttag t) (defun foo (x) (sys-call x nil))))

  ACL2 responds with the following error message.

    ACL2 Error in ( PROGN (DEFTTAG T) ...):  The form (DEFTTAG T)
    is not an embedded event form in the context of LOCAL
    because it implicitly sets the acl2-defaults-table in
    a local context; see :DOC acl2-defaults-table, in particular
    the explanation about this error message.  See :DOC
    embedded-event-form.

  A solution is to use [47m[encapsulate][0m instead of (or in addition to)
  [47m[progn][0m, because [47m[encapsulate][0m establishes a new context that is
  not considered within a surrounding [47mLOCAL[0m.  For example, the
  following replacement for the form above is legal in a book.

    (local (encapsulate () (defttag t) (defun foo (x) (sys-call x nil))))

  To see that this works, try creating a file [47m\"foo.lisp\"[0m whose first
  form is [47m(in-package \"ACL2\")[0m and whose only other form is the one
  displayed just above.  Then the command [47m(certify-book \"foo\" 0 t
  :ttags :all)[0m will successfully certify that book.")
 (ACL2-DOC
  (DOCUMENTATION)
  "A custom Emacs browser for reading ACL2 [documentation]

  As discussed elsewhere (see [documentation]), the web-based
  {ACL2+Books Manual |
  http://www.cs.utexas.edu/users/moore/acl2/v8-6/combined-manual/index.html}
  provides a way to browse the combined documentation for the ACL2
  system and community books.  Such documentation can also be read at
  the terminal using the [47m:[0m[47m[doc][0m command, though documentation for
  [books] will only be included for those books that have been
  included in the session.  In this topic we describe how to browse
  the documentation using ACL2-Doc, a browser for reading
  documentation inside Emacs.  It supports reading the combined
  documentation (ACL2 plus books), but it also supports reading the
  ACL2-only manual as well as custom manuals.  We assume some
  familiarity with Emacs, for example, the notion of a ``prefix
  argument'': a numeric value given first with the [47mmeta[0m key (or,
  probably the [47mcontrol[0m key), for example, [47mmeta-0 control-t g[0m or
  [47mcontrol-3 control-t /[0m.

  Note: If you are not happy with the way text is displayed with
  ACL2-Doc, see [xdoc::terminal].

  While ACL2-Doc is much like Emacs Info, it is a separate system that
  provides some additional functionality.  ACL2-Doc is text-based.
  Any word that names a topic is a link: you can hit the [47m<Return>[0m key
  while standing on that topic to go to the page of documentation for
  that topic.  However, many links are shown explicitly, inside
  square brackets.  For example, here is a link that will take you to
  the BOOKS topic; it should show up surrounded by square brackets if
  you are now reading at the terminal or in ACL2-Doc, but there are
  no square brackets for this link if you are reading on the web.

      [books]

  It should be very rare for square brackets to be intended simply as
  square brackets, not as link indicators.

  In order to use ACL2-Doc, load into Emacs the distributed file
  [47macl2-doc.el[0m from an appropriate directory; see [emacs].  This will
  happen automatically if you load [47memacs-acl2.el[0m from an appropriate
  directory; again, see [emacs].  Then to start the browser at the
  top-level topic, either execute the Emacs command

    meta-x acl2-doc

  or else type:

    Control-t g

  Thus, you can put the following form in your [47m.emacs[0m file if you want
  [47macl2-doc[0m to run automatically when Emacs starts up.

    (acl2-doc)

  By default you will browse the ACL2+Books Manual, though if you are
  using a git version between ACL2 releases then you may be queried;
  more on that below.  Or, see below for how to set a variable in
  your [47m.emacs[0m file, [47m*acl2-doc-manual-name*[0m, so that you will browse a
  custom manual.  You can enter the ACL2-Doc browser at a specific
  documentation topic as follows (in analogy to Emacs command
  [47mMeta-.[0m):

    Control-t .

  In each of the cases above, you will now be in a buffer called
  \"[47macl2-doc[0m\", which will be displaying the top-level ACL2 topic in a
  special mode, the ACL2-Doc major mode.  That mode provides the
  following key bindings; you can also see these by typing [47mControl-h
  m[0m while in that buffer.

    <Return>        acl2-doc-go!
    Shift-<Return>  acl2-doc-go!-new-buffer
    g               acl2-doc-go
    G               acl2-doc-go-new-buffer
    h               acl2-doc-help
    ?               acl2-doc-summary
    i               acl2-doc-index
    ,               acl2-doc-index-next
    <               acl2-doc-index-previous
    K               acl2-doc-kill-buffers
    l               acl2-doc-last
    n               acl2-doc-search-next
    p               acl2-doc-search-previous
    q               acl2-doc-quit
    r               acl2-doc-return
    s               acl2-doc-search
    S               acl2-doc-re-search
    t               acl2-doc-top
    u               acl2-doc-up
    w               acl2-doc-where
    SPC             scroll-up
    TAB             acl2-doc-tab
    <backtab> (which often is Shift-TAB):
                    acl2-doc-tab-back
    D               acl2-doc-rendered-combined-download
    H               acl2-doc-history
    I               acl2-doc-initialize
    /               acl2-doc-definition
    Control-t /     acl2-doc-definition
    W               acl2-doc-where-definition

  You can see the documentation for each of these in the usual way,
  using [47mControl-h k {key}[0m or [47mControl-h f {command}[0m.  Here is what you
  will find in each case if you do that.

    <Return>      acl2-doc-go!
       Go to the topic occurring at the cursor position.  In the case
       of <NAME>, instead go to the source code definition of NAME for
       the current manual (as for `/', but without a minibuffer query).

    Shift-<Return>  acl2-doc-go!-new-buffer
       Go to the topic occurring at the cursor position in a new buffer.  In the
       case of <NAME>, instead go to the source code definition of NAME for the
       current manual (as for `/', but without a minibuffer query).  The new
       buffer's name reflects that topic name, but it stays the same even if the
       topic is subsequently changed there.

    g             acl2-doc-go
       Go to the specified topic; performs completion.  The new buffer's name
       reflects that topic name, but it stays the same even if the topic is
       subsequently changed there.

    G             acl2-doc-go-new-buffer
       Go to the specified topic in a new buffer; performs completion.

    h             acl2-doc-help
       Go to the ACL2-DOC topic to read about how to use the ACL2-Doc browser.

    ?             acl2-doc-summary
       Go to the ACL2-Doc-summary topic for one-line summaries of ACL2-Doc
       browser commands.

    i             acl2-doc-index
       Go to the specified topic or else one containing it as a substring;
       performs completion.  If the empty string is supplied, then go to the
       index buffer.  Otherwise, with prefix argument, consider only descendents
       of the topic supplied in response to a prompt.  Note that the index buffer
       is in ACL2-Doc mode; thus, in particular, you can type <RETURN> while
       standing on a topic in order to go directly to that topic.

    ,             acl2-doc-index-next
       Find the next topic containing, as a substring, the topic of the most
       recent i command.  Note: if this is the first \",\" or \"<\" after an
       exact match from \"i\", then start the topic search alphabetically from
       the beginning, but avoid a second hit on the original topic.  Also note
       that this command is buffer-local; it will follow the most recent i
       command executed in the current ACL2-Doc buffer.

    <             acl2-doc-index-previous
       Find the previous topic containing, as a substring, the topic of the most
       recent i command.  Note: if this is the first \",\" or \"<\" after an
       exact match from \"i\", then start the topic search alphabetically
       (backwards) from that exact match.  Also note that this command is
       buffer-local like the \",\" command.

    l             acl2-doc-last
       Go to the last topic visited in the current buffer.  This command is
       buffer-local.

    n             acl2-doc-search-next
       Find the next occurrence for the most recent search or regular expression
       search.  Note that this command is buffer-local; it will follow the most
       recent search initiated in the current buffer.

    p             acl2-doc-search-previous
       Find the previous occurrence for the most recent search or regular
       expression search.  Note: as for \"n\", the cursor will end up at the end
       of the match, and this command is buffer-local.

    q             acl2-doc-quit
       Quit the current ACL2-Doc buffer.

    K             acl2-doc-kill-buffers
       Kill all background ACL2-Doc buffers.  If invoked in an ACL2-Doc buffer,
       all ACL2-Doc buffers except the current one will be killed.  If invoked in
       any other buffer, all ACL2-Doc buffers will be killed.  With prefix
       argument, avoid a query that asks for confirmation.

    r             acl2-doc-return
       Return to the last topic visited in the current buffer, popping the stack
       of such topics.  This command is buffer-local.

    s             acl2-doc-search
       Search forward from the top of the manual for the input string.  If the
       search succeeds, then go to that topic with the cursor put immediately
       after the found text, with the topic name displayed in the minibuffer.
       With prefix argument, consider (also for subsequent \"n\" and \"p\"
       commands) only descendents of the topic supplied in response to a prompt.

    S             acl2-doc-re-search
       Perform a regular expression search, forward from the top of the manual,
       for the input string.  If the search succeeds, then go to that topic with
       the cursor put immediately after the found text, with the topic name
       displayed in the minibuffer.  With prefix argument, consider (also for
       subsequent \"n\" and \"p\" commands) only descendents of the topic
       supplied in response to a prompt.

    t             acl2-doc-top
       Go to the top topic.

    u             acl2-doc-up
       Go to the parent of the current topic.

    w             acl2-doc-where
       Display the topic name in the minibuffer, together with the manual name
       (ACL2+Books Manual or ACL2 User's Manual)

    SPC           scroll-up
       Scroll up (same as Control-v)

    TAB           acl2-doc-tab
       Visit the next link after the cursor on the current page, searching from
       the top if no link is below the cursor.

    <backtab> (which often is Shift-TAB):
                  acl2-doc-tab-back
       Visit the previous link before the cursor on the current page, searching
       from the bottom if no link is below the cursor.

    D
       Download the ``bleeding edge'' ACL2+Books Manual from the web; then
       restart the ACL2-Doc browser to view that manual.  If this fails,
       evaluate Emacs variable acl2-doc-download-error for information on
       how to perform the download without Emacs.

    H             acl2-doc-history
       Visit a buffer that displays the names of all topics visited (in any
       ACL2-Doc buffer) in order, newest at the bottom.  That buffer is in
       acl2-doc mode; thus the usual acl2-doc commands may be used.  In
       particular, you can visit a displayed topic name by putting your cursor on
       it and typing <RETURN>.

    I             acl2-doc-initialize
       Restart the ACL2-Doc browser, clearing its state.  With a prefix argument,
       a query asks you to select the name of an available manual, using
       completion.  See the section on \"Selecting a Manual\", below,
       for more information.

    /             acl2-doc-definition
    (also control-t /)
       Find an ACL2 definition (in analogy to built-in Emacs command meta-.).
       With numeric prefix argument, find the next matching definition;
       otherwise, the user is prompted, where the default is the name at
       the cursor, obtained after stripping off any enclosing square
       brackets ([..]), angle brackets (<..>) as from srclink tags, and
       package prefixes.  With control-u prefix argument, search only
       ACL2 source definitions; otherwise, books are searched as well.
       As with built-in Emacs command meta-. , exact matches are given
       priority.  For more information, see the Section on \"Selecting a
       Manual\" in the acl2-doc online XDOC-based documentation.

    W             acl2-doc-where-definition
       Find an ACL2 definition.  This is the same as
       acl2-doc-definition (the acl2-doc `/' command, as well as
       control-t /), except that the default comes from the name of the
       current page's topic instead of the cursor position.  Searches
       are continued identically when control-t / is given a numeric
       prefix argument, regardless of whether the first command was /,
       control-t /, or W; thus, a search started with W can be continued
       with, for example, meta-3 control-t /.

  Selecting a Manual, Tags Files, and Custom Manuals

  ACL2-Doc can display the ACL2 User's Manual, which includes
  documentation for the ACL2 system but not for the
  [community-books].  But by default, ACL2-Doc will display the
  ACL2+Books Manual, which includes documentation for those books as
  well.  To change which of these two manuals you display, just give
  a prefix argument to the `[47mI[0m' command, as described briefly above.

  For the `[47m/[0m' and `[47mW[0m' commands, you will need tags table files.  These
  come with the ACL2 gzipped tarfile distribution, but if you obtain
  ACL2 from github then you will need to build them.  The file [47m\"TAGS\"[0m
  is used when these commands are given a prefix argument (to search
  only the ACL2 sources), and is generated when building the
  [47msaved_acl2[0m executable with `[47mmake[0m'.  Without a prefix argument the
  file [47m\"TAGS-acl2-doc\"[0m is used for searching both the ACL2 sources
  and the books, and is created automatically if you build the manual
  by certifying community book [47mbooks/doc/top.lisp[0m.  You can also
  build [47m\"TAGS-acl2-doc\"[0m by running the command
  [47mbin/make-tags-acl2-doc.sh[0m, or by building the ACL2 executable after
  setting variable [47mTAGS_ACL2_DOC[0m to a non-empty value other than [47mSKIP[0m
  either on the command line with `[47mmake[0m' or, for example, by putting
  one of the following forms in your [47m~/.cshrc[0m or [47m~/.bashrc[0m,
  respectively.

    setenv TAGS_ACL2_DOC t

    export TAGS_ACL2_DOC=t

  If you are using a git version of ACL2 and the books, between
  releases, then you may need to download an extra file in order to
  browse the ACL2+Books Manual.  Most likely you will just answer [47my[0m
  when queried about downloading the file when first using ACL2-Doc.
  If you want more details, see the last of the notes in the
  ``Notes'' section below.

  As mentioned above, you can give the `[47mI[0m' command a prefix argument in
  order to select a specific manual.  You will be asked for a name,
  which by default will be the most recently selected such name, if
  any.  As noted above, the only two manuals initially known to
  acl2-doc are the ACL2+Books Manual and the ACL2 User's Manual.
  These have the names `[47mcombined[0m' and `[47macl2-only[0m', respectively.  You
  can also tell acl2-doc about a custom manual, by evaluating (in
  Emacs) the following form, e.g., by adding it to your [47m~/.emacs[0m file
  before starting Emacs.  Here, [47mfilename[0m is the pathname of a file
  typically created by calling [xdoc::save-rendered].

    (extend-acl2-doc-manual-alist
     'name          ; the name of the manual
     filename       ; documentation source, typically of the form *doc*.lsp
     'top           ; the top node name, typically TOP
     printname      ; optional print name (user-level name) of manual
     url            ; optional URL of gzipped file to download into filename
     tags-file-name ; optional tags filename (from output of etags)
     acl2-tags-file-name ; as above, but without files from books/ directory
     )

  For example, acl2-doc is initially built with the following two
  forms, which is why you can respond to the query mentioned above
  with `[47mcombined[0m' or `[47macl2-only[0m'.

    (extend-acl2-doc-manual-alist
     'combined
     (concat *acl2-sources-dir*
             \"books/system/doc/rendered-doc-combined.lsp\")
     'TOP
     \"ACL2+Books Manual\"
     \"http://www.cs.utexas.edu/users/moore/acl2/manuals/current/rendered-doc-combined.lsp.gz\"
     (concat *acl2-sources-dir* \"TAGS-acl2-doc\")
     (concat *acl2-sources-dir* \"TAGS\"))

    (extend-acl2-doc-manual-alist
     'acl2-only
     (concat *acl2-sources-dir* \"doc.lisp\")
     'ACL2
     \"ACL2 User's Manual\"
     nil
     nil
     (concat *acl2-sources-dir* \"TAGS\"))

  Note that the first of these forms specifies the location of the
  [47m\"TAGS-acl2-doc\"[0m and [47m\"TAGS\"[0m files mentioned above, but the second
  only specifies [47m\"TAGS\"[0m since the second form is for an ACL2-only
  manual (no books).

  If you want a specific manual to come up when you first run acl2-doc
  in an Emacs session, you can put the following into your [47m.emacs[0m
  file, where [47m'name[0m is the name a manual for which you have included
  a form [47m(extend-acl2-doc-manual-alist 'name ...)[0m in your [47m.emacs[0m
  file.

    (setq *acl2-doc-manual-name* 'name)

  Color

  By default, links (indeed, any text) in square brackets will be shown
  in blue.  You can customize this behavior by setting (e.g., in your
  [47m.emacs[0m file) the Emacs variable [47m*acl2-doc-link-color*[0m to the
  desired link color, or to [47mnil[0m if you don't want the links to be in
  color.  For example:

    (setq *acl2-doc-link-color* \"#FF0000\") ; red
    (setq *acl2-doc-link-color* \"Green\")   ; green
    (setq *acl2-doc-link-color* nil)         ; no special color for links

  Notes

    * You might find that when you attempt to follow some-broken-link, you
      find yourself at the [broken-link] topic.  If you are using the
      ACL2 User's Manual rather than the ACL2+Books Manual, the
      reason might be that [47msome-broken-link[0m is documented in a book,
      not in the ACL2 system.  In that case, the [47mbroken-link[0m page
      will show you where to find that book; but if you want to read
      the documentation for [47msome-broken-link[0m in the ACL2-Doc browser,
      you can do so by switching to the ACL2+Books Manual.  See the [47mI[0m
      command, documented above.

    * Files with names ending in [47m.acl2-doc[0m will come up in ACL2-Doc mode.
      Thus, you may wish to save a file with that extension, for
      example [47mbookmarks.acl2-doc[0m, that contains your favorite
      bookmarks.  You may wish to use the history command ([47mH[0m) to
      obtain a list of names of visited topics, in order to create an
      initial such file.

    * Many commands offer defaults, and many offer completion.  The default
      is determined by cursor position: if the cursor is sitting on a
      letter of a documentation topic name, or on a space character
      immediately after it, then that name will be offered as the
      default.  Completion tips:

        * Completion is carried out with the usual emacs ``[47mcompleting-read[0m'';
          thus, for example, the character `[47m?[0m' is a help key, so if
          you want that character as part of your topic name, prefix
          it with [47mcontrol-q[0m.  For example, after the `[47mg[0m' command you
          can go to the topic [47m[mv?][0m by typing the character sequence
          [47m<m,v,control-q ?>[0m.

        * To find completions that have package prefixes, type a colon (:) in
          the front, and completion will show matching topics.  For
          example, [47m\"g\"[0m followed by [47m\":rew\"[0m and then two tabs will
          show, at least in recent versions of Emacs, a list of
          topics that includes [47m\"ACL2-PC::REWRITE\"[0m.

    * Square brackets typically indicate documentation topic names, for
      example: [47m[acl2-doc][0m.  (As mentioned above, there are occasional
      exceptions, where square brackets are simply part of the
      intended documentation text.)  The square brackets are really
      there, for example when you are searching using \"s\", \"S\", or
      \"n\".  However, for purposes of determining the default name
      (see above), the only effect of the enclosing square brackets
      is to extend the region in which the default is offered.  For
      example, consider the string \"[47m[acl2-doc][0m\": the default name of
      \"[47macl2-doc[0m\" is offered if the cursor is on either square
      bracket.  But links have some idiosyncrasies.

       1. Topic names, including links `[47m[..][0m' to topic names, are printed
          relative to the ACL2 package.  Especially in the case of
          the ACL2+Books Manual, you may therefore see links that
          include package prefixes.  Here, for example, is a sentence
          from the documentation for [gl] in the ACL2+Books Manual.

              We call these structures [gl::symbolic-objects].

          The \"[47mgl[0m\" package prefix allows commands to pick up
          \"[47mgl::symbolic-objects[0m\" as the name to use as a default, so
          that for example, hitting [47m<Return>[0m will take you to that
          topic.  But when reading the sentence, for best results you
          should ignore package prefixes.  So for example, you would
          read the sentence above as follows.

              We call these structures symbolic-objects.

       2. Inside ACL2-Doc, topic names that originally contained spaces now
          have underscores in place of the spaces.  So for example,
          the topic [ACL2-tutorial] in the ACL2+Books Manual contains
          a link to the topic originally named as follows.
          [47m|Pages Written Especially for the Tours|[0m
          This link shows up in the ACL2-Doc browser as:
          [47m[Pages_Written_Especially_for_the_Tours][0m.

      Of course, the web-based browser avoids these idiosyncrasies (see
      [xdoc::save]); in particular, that browser is best for
      ``Tours'' pages like the one shown above and its subtopics, in
      part because that way you may see images.  Hence the web-based
      browser may be more appropriate for some topics, and for those
      who have no particular preference for using Emacs to browse the
      documentation.

    * Searching using the \"s\" or \"S\" command is carried out by searching
      top-to-bottom in a hidden Emacs buffer that contains all of the
      documentation.  The topics are listed in the following order
      according to topic name:

       1. All topics whose names reside in the \"[47mACL2[0m\" package;

       2. All topics whose names reside in the \"[47mACL2-PC[0m\" package; and, for the
          ACL2+Books Manual,

       3. All other topics, sorted by [47m[symbol-name][0m and then by
          [47m[symbol-package-name][0m.

    * You may be queried, regarding whether you want to browse the
      ACL2+Books Manual, which is preferred, or the ACL2 User's
      Manual, which omits documentation for the books.  Both of these
      manuals are based on files that you will have if you are using
      a released version of ACL2 (after Version 6.3).  But if you are
      using a {git version | https://github.com/acl2/acl2/}, then to
      use the ACL2+Books Manual you will need an extra file.  You can
      build this file yourself, as described below but you may prefer
      to download it: for example, when you start ACL2-Doc, you may
      be given the option of downloading {a tarball for the latest
      ``bleeding edge'' copy |
      http://www.cs.utexas.edu/users/moore/acl2/manuals/current/rendered-doc-combined.lsp.gz}
      and extracting into directory [47msystem/doc/[0m of your community
      books directory.  Indeed, the system will do all this for you
      if you answer [47my[0m to that query.  Alternatively, you can insist
      on a download of a ``bleeding edge'' version by using the `[47mD[0m'
      command.  However, if you prefer to browse the ACL2 User's
      Manual (without the books), you can put the following form into
      your [47m~/.emacs[0m file, above the form that loads the code for
      ACL2-Doc (see above).

          (defvar *acl2-doc-manual-name* 'acl2-only)

      If you prefer to build [47mrendered-doc-combined.lsp[0m yourself, you can
      do so as follows.

       1. Build ACL2:

              make

       2. Build the file [47mbooks/system/doc/rendered-doc-combined.lsp[0m while
          standing in the [47mbooks/[0m directory, as follows.  If \"[47macl2[0m\"
          invokes the ACL2 executable that you just built, then you
          may omit \"[47mACL2=acl2[0m\" below; otherwise replace \"[47macl2[0m\" by a
          suitable executable.  On a multi-core machine you may wish
          to use [47m-j[0m, e.g., [47mmake -j 4 ...[0m.

              cd books
              make doc/top.cert USE_QUICKLISP=1 ACL2=acl2")
 (ACL2-DOC-SUMMARY
  (DOCUMENTATION)
  "Summary of [ACL2-doc] commands

  See [ACL2-doc] for information about the custom Emacs browser for
  viewing ACL2 [documentation].  In the present topic we list the
  commands with extremely abbreviated documentation: only a single
  line for each.  For even briefer summaries, you can use the
  standard Emacs command, [47mControl-h m[0m.

    <Return>      acl2-doc-go!
       Go to the topic occurring at the cursor position.
    Shift-<Return>  acl2-doc-go!-new-buffer
       Go to the topic occurring at the cursor position in a new buffer.
    g             acl2-doc-go
       Go to the specified topic; performs completion.
    G             acl2-doc-go-new-buffer
       Go to the specified topic in a new buffer; performs completion.
    h             acl2-doc-help
       Go to the ACL2-Doc topic to read about how to use the ACL2-Doc browser.
    ?             acl2-doc-summary
       Go to the ACL2-Doc-summary topic for one-line summaries of commands.
    i             acl2-doc-index
       Go to the specified topic or else one containing it as a substring.
    ,             acl2-doc-index-next
       Continue to the next topic for the most recent i command.
    <             acl2-doc-index-previous
       Return to the preceding topic for the most recent i command.
    K             acl2-doc-kill-buffers
       Kill all background ACL2-Doc buffers.
    l             acl2-doc-last
       Go to the last topic visited.
    n             acl2-doc-search-next
       Find the next occurrence for the most recent search.
    p             acl2-doc-search-previous
       Find the previous occurrence for the most recent search.
    q             acl2-doc-quit
       Quit the ACL2-Doc browser.
    r             acl2-doc-return
       Return to the last topic visited, popping the stack of such topics.
    s             acl2-doc-search
       Search for the input string (with prefix arg: under a given topic).
    S             acl2-doc-re-search
       Regular-expression search (with prefix arg: under a given topic).
    t             acl2-doc-top
       Go to the top topic.
    u             acl2-doc-up
       Go to the parent of the current topic.
    w             acl2-doc-where
       Display the topic and manual name in the minibuffer.
    SPC           scroll-up
       Scroll up (same as Control-v)
    TAB           acl2-doc-tab
       Visit the next link on the current page.
    <backtab> (which often is Shift-TAB): acl2-doc-tab-back
       Visit the previous link on the current page.
    D
       Download the manual from the web; then restart ACL2-Doc.
    H             acl2-doc-history
       Visit the History buffer, with names of all visited topics in order.
    I             acl2-doc-initialize
       Restart ACL2-Doc.  With a prefix argument, choose which manual.
    /             acl2-doc-definition
    Control-t /   acl2-doc-definition
       Find an ACL2 definition (in analogy to built-in Emacs command meta-.).
    W             acl2-doc-where-definition
       Find an ACL2 definition, with default from current page's topic.")
 (ACL2-HELP
  (ABOUT-ACL2)
  "The acl2-help mailing list

  You can email questions about ACL2 usage to the acl2-help mailing
  list: [47macl2-help@utlists.utexas.edu[0m.  If you have more general
  questions about ACL2, for example, about projects completed using
  ACL2, you may prefer the acl2 mailing list,
  [47macl2@utlists.utexas.edu[0m, which tends to have wider distribution.

  The following mailing list pages include links to their archives.

    * acl2-help list:
      [47m{https://utlists.utexas.edu/sympa/info/acl2-help |
      https://utlists.utexas.edu/sympa/info/acl2-help}[0m

    * acl2 list:
      [47m{https://utlists.utexas.edu/sympa/info/acl2 |
      https://utlists.utexas.edu/sympa/info/acl2}[0m")
 (ACL2-NUMBER-LISTP
  (NUMBERS LISTS ACL2-BUILT-INS)
  "Recognizer for a true list of numbers

  The predicate [47macl2-number-listp[0m tests whether its argument is a true
  list of numbers.

  [31;1mFunction: [0m<acl2-number-listp>

    (defun acl2-number-listp (l)
      (declare (xargs :guard t))
      (cond ((atom l) (eq l nil))
            (t (and (acl2-numberp (car l))
                    (acl2-number-listp (cdr l))))))")
 (ACL2-NUMBERP
  (NUMBERS ACL2-BUILT-INS)
  "Recognizer for numbers

  [47m(acl2-numberp x)[0m is true if and only if [47mx[0m is a number, i.e., a
  rational or complex rational number.")
 (ACL2-SEDAN
  (ACL2-TUTORIAL)
  "ACL2 Sedan interface

  Many successful ACL2 users run in a shell under Emacs; see [emacs].
  However, those not familiar with Emacs may prefer to start with an
  Eclipse-based interface initially developed by Peter Dillinger and
  Pete Manolios called the ACL2 Sedan or ``ACL2s''.

  ACL2 sessions in the ACL2 Sedan can utilize non-standard extensions
  and enhancements, especially geared toward new users, termination
  reasoning, and attaching rich user interfaces.  These extensions
  are distributed with the ACL2 community books in
  [47mbooks/acl2s/distribution/acl2s-hooks/[0m.  Thanks to Peter Dillinger,
  Pete Manolios, Daron Vroon, and Harsh Raju Chamarthi for their work
  on the ACL2 Sedan and for making their books available to ACL2
  users.")
 (ACL2-TUTORIAL
  (START-HERE)
  "Tutorial introduction to ACL2

  To learn about ACL2, read at least the following two links.

    * Industrial Applications of ACL2 (see [INTERESTING-APPLICATIONS]) (10
      minutes) to help you understand what sophisticated users can
      do;

    * A Flying Tour (see [A_Flying_Tour_of_ACL2]) (10 minutes) to get an
      overview of the system and what skills the user must have.

  Alternatively, or in addition, there are [talks] that you can peruse,
  many of them introductory in nature.

  If you want to learn [3mhow to use[0m ACL2, we recommend that you read a
  selection of the materials referenced below, depending on your
  learning style, and do suggested exercises.

    * A Walking Tour (see [A_Walking_Tour_of_ACL2]) (1 hour) provides an
      overview of the theorem prover.

    * The {Try ACL2 | http://tryacl2.org} web site provides interactive
      lessons to get you started using ACL2.

    * See [introduction-to-the-theorem-prover] (10-40 hours) for
      instruction on how to interact with the system.  Unlike the
      three documents above, this document expects you to [3mthink[0m!  It
      cites the necessary background pages on programming in ACL2 and
      on the logic and then instructs you in [the-method], which is
      how expert users use ACL2.  It concludes with some challenge
      problems for the ACL2 beginner (including solutions) and an
      FAQ.  Most users will spend several hours a day for several
      days working through this material.

    * The book {Computer-Aided Reasoning: An Approach |
      http://www.cs.utexas.edu/users/moore/publications/acl2-books/car/index.html}
      is worth a careful read, as you work exercises and learn
      [the-method].

    * Annotated ACL2 Scripts and Demos (see [ANNOTATED-ACL2-SCRIPTS])
      contains relatively elementary proof scripts that have been
      annotated to help train the newcomer.

    * Many files (``books'') in the ACL2 community books (see
      [community-books]) are extensively annotated.

    * An Alternative Introduction (see [ALTERNATIVE-INTRODUCTION])
      document, while largely subsumed by the Introduction to the
      Theorem Prover (see [INTRODUCTION-TO-THE-THEOREM-PROVER])
      mentioned above, still might be useful because it covers much
      of the tutorial material in a different way.

  At this point you are probably ready to use ACL2 on your own [3msmall[0m
  projects.  A common mistake for beginners is to browse the
  documentation and then try to do something that is too big!  Think
  of a very small project and then simplify it!

  Note that ACL2 has a very supportive user network.  See the link to
  ``Mailing Lists'' on the {ACL2 home page |
  http://www.cs.utexas.edu/users/moore/acl2}.

  The topics listed below are a hodge podge, developed over time.
  Although some of these are not mentioned above, you might find some
  to be useful as well.


Subtopics

  [ACL2-as-standalone-program]
      Calling ACL2 from another program

  [ACL2-sedan]
      ACL2 Sedan interface

  [Advanced-features]
      Some advanced features of ACL2

  [Alternative-introduction]
      Introduction to ACL2

  [Annotated-ACL2-scripts]
      Examples of ACL2 scripts

  [Emacs]
      Emacs support for ACL2

  [Interesting-applications]
      Some industrial examples of ACL2 use

  [Introduction-to-the-theorem-prover]
      How the theorem prover works --- level 0

  [Nqthm-to-ACL2]
      ACL2 analogues of Nqthm functions and commands

  [Pages_Written_Especially_for_the_Tours]
      Pages Written Especially for the Tours

  [Startup]
      How to start using ACL2; the ACL2 [command] loop

  [Talks]
      Some talks about ACL2

  [The-method]
      How to find proofs

  [Tidbits]
      Some basic hints for using ACL2

  [Tips]
      Some hints for using the ACL2 prover")
 (ACL2-UNWIND-PROTECT (POINTERS)
                      "See [system-utilities].")
 (ACL2-USER
  (PACKAGES)
  "A package the ACL2 user may prefer

  This package imports the standard Common Lisp symbols that ACL2
  supports and also a few symbols from package [47m\"ACL2\"[0m that are
  commonly used when interacting with ACL2.  You may prefer to select
  this as your current package so as to avoid colliding with ACL2
  system names.

  This package imports the symbols listed in
  [47m*common-lisp-symbols-from-main-lisp-package*[0m, which contains
  hundreds of CLTL function and macro names including those supported
  by ACL2 such as [47m[cons][0m, [47m[car][0m, and [47m[cdr][0m.  It also imports the
  symbols in [47m*acl2-exports*[0m, which contains a few symbols that are
  frequently used while interacting with the ACL2 system, such as
  [47m[implies][0m, [47m[defthm][0m, and [47m[rewrite][0m.  It imports nothing else.

  Thus, names such as [47m[alistp][0m, [47m[member-equal][0m, and [47m[type-set][0m, which
  are defined in the [47m\"ACL2\"[0m package are not present here.  If you
  find yourself frequently colliding with names that are defined in
  [47m\"ACL2\"[0m you might consider selecting [47m\"ACL2-USER\"[0m as your current
  package (see [in-package]).  If you select [47m\"ACL2-USER\"[0m as the
  current package, you may then simply type [47m[member-equal][0m to refer
  to [47macl2-user::member-equal[0m, which you may define as you see fit.
  Of course, should you desire to refer to the [47m\"ACL2\"[0m version of
  [47m[member-equal][0m, you will have to use the [47m\"ACL2::\"[0m prefix, e.g.,
  [47macl2::member-equal[0m.

  If, while using [47m\"ACL2-USER\"[0m as the current package, you find that
  there are symbols from [47m\"ACL2\"[0m that you wish we had imported into it
  (because they are frequently used in interaction), please bring
  those symbols to our attention.  For example, should
  [47m[union-theories][0m and [47m[universal-theory][0m be imported?  Except for
  stabilizing on the ``frequently used'' names from [47m\"ACL2\"[0m, we intend
  never to define a symbol whose [47m[symbol-package-name][0m is
  [47m\"ACL2-USER\"[0m.")
 (ACL2P (POINTERS) "See [parallelism].")
 (ACL2P-KEY-CHECKPOINTS
  (PARALLEL-PROOF)
  "Key checkpoints in ACL2(p)

  This [documentation] topic relates to the experimental extension of
  ACL2 supporting parallel execution and proof; see [parallelism].

  For printing output, the parallel version of the waterfall follows
  the precedent of [47m[gag-mode][0m.  The idea behind gag mode is to print
  only the subgoals most relevant to debugging a failed proof
  attempt.  These subgoals are called 'key checkpoints' (see
  [set-gag-mode] for the definition of ``key'' and ``checkpoint''),
  and we restrict the default output mode for the parallel version of
  the waterfall to printing checkpoints similar to these key
  checkpoints.

  As of this writing, we are aware of exactly one discrepancy between
  gag mode's key checkpoints and the parallel version of the
  waterfall's checkpoints.  This discrepancy occurs when using ``by''
  hints (see [hints]).  As an example, take the following form, which
  attempts to prove a non-theorem:

    (thm (equal (append x y z) (append z (append y x)))
         :hints ((\"Subgoal *1/2'''\" :by nil)))

  With waterfall parallelism enabled, [47mSubgoal *1/2''[0m will be printed as
  a key checkpoint.  This is different from using [47m[gag-mode][0m while
  running the serial version of the waterfall, which skips printing
  the subgoal as a checkpoint.

  For those familiar with the ACL2 waterfall, we note that the parallel
  version of the waterfall prints key checkpoints that are unproved
  in the following sense: a subgoal is a key checkpoint if it leads,
  in the current call of the waterfall, to a goal that is pushed for
  induction.")
 (ACL2R (POINTERS) "See [real].")
 (ACL2S (POINTERS) "See [ACL2-sedan].")
 (ACL2_AS_AN_INTERACTIVE_THEOREM_PROVER
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "ACL2 as an Interactive Theorem Prover

  The ACL2 theorem prover finds proofs in the ACL2 logic.  It can be
  automatic.  But most often the user must help it.

  {IMAGE}

  The user usually guides ACL2 by suggesting that it first prove key
  [31;1mlemmas[0m.  Lemmas are just theorems used in the proofs of other
  theorems.")
 (ACL2_AS_AN_INTERACTIVE_THEOREM_PROVER_{CONT}
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "ACL2 as an Interactive Theorem Prover (cont)

  {IMAGE} (see [ACL2_System_Architecture])

  When ACL2 proves a lemma, it is converted into one or more [31;1mrules[0m and
  stored in a [31;1mdatabase[0m.  The theorem prover is [31;1mrule-driven[0m.  By
  proving lemmas you can configure ACL2 to behave in certain ways
  when it is trying to prove formulas in a certain problem domain.
  The expert user can make ACL2 do amazingly ``smart'' looking
  things.

  But it would be wrong to think that ACL2 [3mknows[0m the mathematical
  content of a formula just because it has proved it.  What ACL2
  knows --- all ACL2 knows --- is what is encoded in its rules.
  There are many types of rules (see [rule-classes] {ICON} (see
  [A_Tiny_Warning_Sign])).

  Many formulas can be effectively coded as rules.  But by the same
  token, it is possible to encode a formula as a rule that is so
  ineffective it cannot even prove itself!

  The way a formula is stored as a rule is entirely up to the user.
  That is, [31;1myou[0m determine how ACL2 should use each formula that it
  proves.

  The most common kind of rule is the [31;1mrewrite rule[0m.  It is so common
  that if you don't tell ACL2 how to store a formula, it stores it as
  a rewrite rule.

  {IMAGE} (see [ACL2_System_Architecture])")
 (ACL2_CHARACTERS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "ACL2 Characters

  ACL2 accepts 256 distinct characters, which are the characters
  obtained by applying the function [47m[code-char][0m {ICON} (see
  [A_Tiny_Warning_Sign]) to each integer from 0 to 255.  Among these,
  Common Lisp designates certain ones as [47m*standard-characters*[0m,
  namely those of the form [47m(code-char n)[0m where n is from 33 to 126,
  together with [47m#\\Newline[0m and [47m#\\Space[0m.  The actual standard
  characters may be viewed by evaluating the constant expression
  [47m*standard-chars*[0m.

  The standard character constants are written by writing a hash mark
  followed by a backslash (#\\) followed by the character.

  The function [47m[characterp][0m {ICON} (see [A_Tiny_Warning_Sign])
  recognizes characters.  For more details, See [characters] {ICON}
  (see [A_Tiny_Warning_Sign]).")
 (ACL2_CONSES_OR_ORDERED_PAIRS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "ACL2 Conses or Ordered Pairs

  The function [47m[cons][0m {ICON} (see [A_Tiny_Warning_Sign]) creates an
  ordered pair.  [47m[Car][0m {ICON} (see [A_Tiny_Warning_Sign]) and [47m[cdr][0m
  {ICON} (see [A_Tiny_Warning_Sign]) return the first and second
  components, respectively, of an ordered pair.  The function [47m[consp][0m
  {ICON} (see [A_Tiny_Warning_Sign]) recognizes ordered pairs.

  Ordered pairs are used to represent lists and trees.  See any Common
  Lisp documentation for a discussion of how list constants are
  written and for the many list processing functions available.
  Also, see [programming] {ICON} (see [A_Tiny_Warning_Sign]) where we
  list all the ACL2 primitive functions.

  Here are some examples of list constants to suggest their syntax.

    '(a . b)                ; a pair whose car is 'a and cdr is 'b
    '(a . nil)              ; a pair whose car is 'a and cdr is nil
    '(a)                    ; another way to write the same thing
    '(a b)                  ; a pair whose car is 'a and cdr is '(b)
    '(a b c)                ; a pair whose car is 'a and cdr is '(b c)
                            ;  i.e., a list of three symbols, a, b, and c.
    '((a . 1) (b . 2))      ; a list of two pairs

  It is useful to distinguish ``proper'' conses from ``improper'' ones,
  the former being those cons trees whose right-most branch
  terminates with [47mnil[0m.  A ``true list'' (see [true-listp] {ICON} (see
  [A_Tiny_Warning_Sign])) is either [47mnil[0m or a proper cons.  [47m(A b c .
  7)[0m is an improper cons and hence not a true list.")
 (ACL2_IS_AN_UNTYPED_LANGUAGE
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "ACL2 is an Untyped Language

  The example

    ACL2 !>[31;1m(app '(a b c) 27)[0m
    (A B C . 27)

  illustrates the fact that ACL2's logic is untyped (click here (see
  [About_Types]) for a brief discussion of the typed versus untyped
  nature of the logic).

  The definition of [47mapp[0m makes no restriction of the arguments to lists.
  The definition says that if the first argument satisfies [47m[endp][0m
  {ICON} (see [A_Tiny_Warning_Sign]) then return the second argument.
  In this example, when [47mapp[0m has recursed three times down the [47mcdr[0m of
  its first argument, [47m'(a b c)[0m, it reaches the final [47mnil[0m, which
  satisfies [47mendp[0m, and so 27 is returned.  It is naturally consed into
  the emerging list as the function returns from successive recursive
  calls (since [47mcons[0m does not require its arguments to be lists,
  either).  The result is an ``improper'' list, [47m(a b c . 27)[0m.

  You can think of [47m(app x y)[0m as building a binary tree by replacing the
  right-most tip of the tree [47mx[0m with the tree [47my[0m.")
 (ACL2_STRINGS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "ACL2 Strings

  Strings of ACL2 characters (see [ACL2_Characters]) are written as
  sequences of characters delimited by ``double quotation marks''
  (\").  To put a double quotation mark in a string (or, any other
  character such as backslash or newline that seems to cause
  problems), escape it by preceding it with a backslash (\\).

  The function [47m[stringp][0m {ICON} (see [A_Tiny_Warning_Sign]) recognizes
  strings and [47m[char][0m {ICON} (see [A_Tiny_Warning_Sign]) will fetch
  the nth character of a string.  There are many other primitives for
  handling strings, such as [47m[string<][0m {ICON} (see
  [A_Tiny_Warning_Sign]) for comparing two strings lexicographically.
  We suggest you See [programming] {ICON} (see [A_Tiny_Warning_Sign])
  where we list all of the primitive ACL2 functions.  Alternatively,
  see any Common Lisp language documentation.")
 (ACL2_SYMBOLS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "ACL2 Symbols

  Common Lisp's symbols are a data type representing words.  They are
  frequently regarded as atomic objects in the sense that they are
  not frequently broken down into their constituents.  Often the only
  important properties of symbols is that they are not numbers,
  characters, strings, or lists and that two symbols are not equal if
  they look different (!).  Examples of symbols include [47mPLUS[0m and
  [47mSMITH::ABC[0m.  All function and variable names in ACL2 are symbols.
  When symbols are used as constants they must be quoted, as in
  [47m'PLUS[0m.

  The symbol [47mT[0m is commonly used as the Boolean ``true.'' The symbol [47mNIL[0m
  is commonly used both as the Boolean ``false'' and as the ``empty
  list.'' Despite sometimes being called the ``empty list'' [47mNIL[0m is a
  [31;1msymbol[0m not an ``empty cons.'' Unlike other symbols, [47mT[0m and [47mNIL[0m may
  be used as constants without quoting them.

  Usually, symbols are written as sequences of alphanumeric characters
  other than those denoting numbers.  Thus, [47mA12[0m, [47m+1A[0m and [47m1+[0m are
  symbols but [47m+12[0m is a number.  Roughly speaking, when symbols are
  read lower case characters are converted to upper case, so we
  frequently do not distinguish [47mABC[0m from [47mAbc[0m or [47mabc[0m.  Click here (see
  [Conversion]) for information about case conversion when symbols
  are read.  However, any character can be used in a symbol, but some
  characters must be ``escaped'' to allow the Lisp reader to parse
  the sequence as a symbol.  For example, [47m|Abc|[0m is a symbol whose
  first character is capitalized and whose remaining characters are
  in lower case.  [47m|An odd duck|[0m is a symbol containing two #\\Space
  characters.  See any Common Lisp documentation for the syntactic
  rules for symbols.

  Technically, a symbol is a special kind of pair consisting of a
  package name (which is a string) and a symbol name (which is also a
  string).  (See [symbol-package-name] {ICON} (see
  [A_Tiny_Warning_Sign]) and see [symbol-name] {ICON} (see
  [A_Tiny_Warning_Sign]).)  The symbol SMITH::ABC is said to be in
  package \"SMITH\" and to have the symbol name \"ABC\".  The symbol [47mABC[0m
  in package \"SMITH\" is generally not equal to the symbol [47mABC[0m in
  package \"JONES\".  However, it is possible to ``import'' symbols
  from one package into another one, but in ACL2 this can only be
  done when the package is created.  (See [defpkg] {ICON} (see
  [A_Tiny_Warning_Sign]).)  If the [47m[current-package][0m {ICON} (see
  [A_Tiny_Warning_Sign]) is \"SMITH\" then [47mSMITH::ABC[0m may be more
  briefly written as just [47mABC[0m.  [47m[Intern][0m {ICON} (see
  [A_Tiny_Warning_Sign]) ``creates'' a symbol of a given name in a
  given package.")
 (ACL2_SYSTEM_ARCHITECTURE
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "ACL2 System Architecture

  {IMAGE} (see [Rewrite_Rules_are_Generated_from_DEFTHM_Events])

  {IMAGE}

  The user interacts with the theorem prover by giving it definitions,
  theorems and advice.  Most often the advice is about how to store
  each proved theorem as a rule.  Sometimes the advice is about how
  to prove a specific theorem.

  The database consists of all the rules ACL2 ``knows.'' It is possible
  to include in the database all of the rules in some certified file
  of other events.  Such certified files are called [books] {ICON}
  (see [A_Tiny_Warning_Sign]).

  Interesting proofs are usually built on top of many books, some of
  which are written especially for that problem domain and others of
  which are about oft-used domains, like arithmetic or list
  processing.  ACL2's distribution includes many books written by
  users.  See the ``books'' link under the [31;1mLemma Libraries and
  Utilities[0m {ICON} (see [A_Tiny_Warning_Sign]) link of the ACL2 home
  page.

  {IMAGE} (see [Rewrite_Rules_are_Generated_from_DEFTHM_Events])")
 (ACONS
  (ALISTS ACL2-BUILT-INS)
  "Constructor for association lists

  [47m(Acons key datum alist)[0m equals the result of consing the pair [47m(cons
  key datum)[0m to the front of the association list [47malist[0m.

  [47m(Acons key datum alist)[0m has a [guard] of [47m(alistp alist)[0m.  [47mAcons[0m is a
  Common Lisp function.  See any Common Lisp documentation for more
  information.

  [31;1mFunction: [0m<acons>

    (defun acons (key datum alist)
      (declare (xargs :guard (alistp alist)))
      (cons (cons key datum) alist))")
 (ACTIVE-OR-NON-RUNEP
  (THEORIES)
  "Require a [rune] to exist, and check that it is [enable]d

  This variant of [47mactive-runep[0m causes an error if its argument is not a
  [rune].  See [active-runep].")
 (ACTIVE-RUNEP
  (THEORIES)
  "Check that a [rune] exists and is [enable]d

    Example:
    (active-runep '(:rewrite left-to-right))

    General Form:
    (active-runep rune &optional strict)

  where [47mrune[0m has the shape of a [rune].  This macro expands to an
  expression using the variables [47mens[0m and [47mstate[0m, and returns non-[47mnil[0m
  when the given rune exists and is [enable]d (according to the given
  ``enabled structure,'' [47mens[0m, and the current logical [world] of the
  given [47m[state][0m).  See [theory-invariant] for how this macro can be
  of use.

  When the optional argument is [47mnil[0m or is omitted, then although the
  argument is required to have the shape of a [rune], it need not be
  a rune.  For example, if there is no rewrite rule named
  [47mleft-to-right[0m, then [47m(active-runep '(:rewrite left-to-right))[0m will
  simply return [47mnil[0m.  If instead you'd like this call to cause an
  error, use a non-nil optional argument or, equivalently, use
  [47m[active-or-non-runep][0m.")
 (ADD-BINOP
  (MACROS)
  "Associate a function name with a macro name

  The form [47m(add-binop macro macro-fn)[0m is an abbreviation for the form
  [47m(add-macro-fn macro macro-fn t)[0m.  See [add-macro-fn].")
 (ADD-CUSTOM-KEYWORD-HINT
  (EVENTS)
  "Add a new custom keyword hint

    Examples:
    (add-custom-keyword-hint :my-hint (my-hint-fn val ...))

    (add-custom-keyword-hint :my-hint
                             (my-hint-fn val ...)
                             :checker (my-hint-checker-fn val ...))

    General Form:
    (add-custom-keyword-hint :key term1 :checker term2)

  where [47m:key[0m is a [47m[keywordp][0m not among the primitive keyword hints
  listed in [47m*hint-keywords*[0m, the [47m:checker[0m argument is optional, and
  [47mterm1[0m and (if supplied) [47mterm2[0m are terms with certain free-variable
  and signature restrictions described below.  Henceforth, [47m:key[0m is
  treated as a custom keyword hint, e.g., the user can employ [47m:key[0m in
  hints to [47m[defthm][0m, such as:

    (defthm name ...
      :hints ((\"Subgoal *1/1'\" ... :key val ...))).

  Custom keyword hints are complicated.  To use them you must
  understand [47m[state][0m, multiple values (e.g., [47m[mv][0m and [47m[mv-let][0m),
  ACL2's notion of error triples (see [programming-with-state]), how
  to generate ``soft'' errors with [47m[er][0m, how to use [47m[fmt][0m-strings to
  control output, how to use computed hints (see [computed-hints])
  and some aspects of ACL2's internal event processing.  Furthermore,
  it is possible to implement a custom keyword hint that can make an
  event non-reproducible!  So we recommend that these hints be
  developed by ACL2 experts.  Basically the custom keyword feature
  allows the implementors and other experts to extend the hint
  facility without modifying the ACL2 sources.

  [47mTerm1[0m is called the ``generator'' term and [47mterm2[0m is called the
  ``checker'' term of the custom keyword hint [47m:key[0m.  Together they
  specify the semantics of the new custom keyword hint [47m:key[0m.  Roughly
  speaking, when a custom keyword hint is supplied by the user, as in

    (defthm name ...
      :hints ((\"Subgoal *1/1'\" ... :my-hint val ...))).

  the checker term is evaluated on [47mval[0m to check that [47mval[0m is of the
  expected shape.  Provided [47mval[0m passes the check, the generator term
  is used to compute a standard hint.  Like computed hints, the
  generator of a custom keyword hint is allowed to inspect the actual
  [clause] on which it is being fired.  Indeed, it is allowed to
  inspect the entire list of hints (standard and custom) supplied for
  that clause.  Thus, in the most general case, a custom keyword hint
  is just a very special kind of computed hint.

  The generator, [47mterm1[0m, must have no free variables other than:

    (val keyword-alist
     id clause world stable-under-simplificationp
     hist pspv ctx state).

  Moreover, either [47mterm1[0m must evaluate to a single non-[stobj] value,
  or else it must be single-threaded in [47mstate[0m and have the standard
  [error-triple] output signature, [47m(mv * * state)[0m.

  The restrictions on the checker, [47mterm2[0m, are that it be
  single-threaded in [47mstate[0m, have the standard [error-triple] output
  signature, [47m(mv * * state)[0m, and have no free variables other than:

    (val world ctx state).

  For examples, see the community books directory [47mbooks/hints/[0m, in
  particular [47mbasic-tests.lisp[0m.

  To delete a previously added custom keyword hint, see
  [remove-custom-keyword-hint].

  The community book [47mhints/merge-hint.lisp[0m can be useful in writing
  custom keyword hints.  See the examples near the of the file.

  Note: This is an event!  It does not print the usual event [summary]
  but nevertheless changes the ACL2 logical [world] and is so
  recorded.")
 (ADD-DEFAULT-HINTS
  (DEFAULT-HINTS)
  "Add to the default hints

    Examples:
    (add-default-hints '((computed-hint-1 clause)
                         (computed-hint-2 clause
                                          stable-under-simplificationp)))
    (add-default-hints '((computed-hint-3 id clause world))
                       :at-end t)

  Note: This is an event!  It does not print the usual event [summary]
  but nevertheless changes the ACL2 logical [world] and is so
  recorded.  It is [47m[local][0m to the book or [47m[encapsulate][0m form in which
  it occurs (see [add-default-hints!] for a corresponding non-[47m[local][0m
  event).

    General Forms:
    (add-default-hints lst)
    (add-default-hints lst :at-end flg)

  where [47mlst[0m is a list.  Generally speaking, the elements of [47mlst[0m should
  be suitable for use as [47m[computed-hints][0m.

  This event is completely analogous to [47m[set-default-hints][0m, the
  difference being that [47madd-default-hints[0m appends the indicated hints
  to the front of the list of default hints, so that they are tried
  first --- or, if [47mflg[0m is supplied and evaluates to other than [47mnil[0m,
  at the end of the list, so that they are tried last --- rather than
  [31;1mreplacing[0m the default hints with the indicated hints.  Each new
  hint is thus considered after each existing hint when both are
  applied to the same goal.  Also See [set-default-hints], see
  [remove-default-hints], and see [default-hints].

  Finally, note that the effects of [47mset-default-hints[0m,
  [47m[add-default-hints][0m, and [47m[remove-default-hints][0m are [47m[local][0m to the
  book in which they appear.  Thus, users who include a book with
  such forms will not have their default hints affected by such
  forms.  In order to export the effect of setting the default hints,
  use [47m[set-default-hints!][0m, [47m[add-default-hints!][0m, or
  [47m[remove-default-hints!][0m.

  For a related feature, which however is only for advanced system
  builders, see [override-hints].")
 (ADD-DEFAULT-HINTS!
  (DEFAULT-HINTS)
  "Add to the default hints non-[47m[local][0mly

  Please see [add-default-hints], which is the same as
  [47madd-default-hints![0m except that the latter is not [47m[local][0m to the
  [47m[encapsulate][0m or the book in which it occurs.  Probably
  [add-default-hints] is to be preferred unless you have a good
  reason for wanting to export the effect of this event outside the
  enclosing [47m[encapsulate][0m or book.")
 (ADD-DIVE-INTO-MACRO
  (DIVE-INTO-MACROS-TABLE)
  "Associate [proof-builder] diving function with macro name

    Examples:
    (add-dive-into-macro cat expand-address-cat)

  This feature is used so that the interactive [proof-builder]'s [47mDV[0m
  command and numeric diving commands (e.g., [47m3[0m) will dive properly
  into subterms.  Please see [dive-into-macros-table].")
 (ADD-GLOBAL-STOBJ
  (EVENTS STOBJ)
  "Add a global [stobj] with a given name

  See [stobj] for background on stobjs, and see [defstobj] and
  [defabsstobj] for further background.

  We start with the General Form and an Example Form, which are
  followed by discussions of global stobjs and the effect of this
  utility.

    General Form:
    (add-global-stobj x state)

  where [47mx[0m evaluates to the name of a stobj that does not already have a
  global value, either because it was introduced by [47m[defstobj][0m or
  [47m[defabsstobj][0m with keyword value [47m:non-executable t[0m or because
  [47m[remove-global-stobj][0m was previously applied to that name.

    Example Form:
    (add-global-stobj 'st state) ; st non-global from defstobj or defabsstobj

  By default, [47mdefstobj[0m and [47mdefabsstobj[0m create a ``live'', mutable
  object for the given name that can be referenced at the top level,
  which we call a ``global'' stobj.  This is illustrated by the
  following log.

    ACL2 !>(defstobj st fld)

    Summary
    Form:  ( DEFSTOBJ ST ...)
    Rules: NIL
    Time:  0.02 seconds (prove: 0.00, print: 0.00, other: 0.02)
     ST
    ACL2 !>st ; global stobj for the name, ST
    <st>
    ACL2 !>(fld st)
    NIL
    ACL2 !>(update-fld 3 st)
    <st>
    ACL2 !>(fld st)
    3
    ACL2 !>

  However, the following log shows that we can introduce a stobj
  without creating a global stobj, by using the keyword value
  [47m:non-executable t[0m.

    ACL2 !>(defstobj st2 fld2 :non-executable t)

    Summary
    Form:  ( DEFSTOBJ ST2 ...)
    Rules: NIL
    Time:  0.02 seconds (prove: 0.00, print: 0.00, other: 0.02)
     ST2
    ACL2 !>(fld2 st2)


    ACL2 Error [Evaluation] in TOP-LEVEL:  Unbound var ST2.  Note that
    ST2 is a non-executable stobj.

    ACL2 !>

  The function [47madd-global-stobj[0m creates a global stobj for a given
  stobj name when one does not already exist.  Let's continue the log
  started immediately above.

    ACL2 !>(add-global-stobj 'st2 state)
     ST2
    ACL2 !>(fld2 st2)
    NIL
    ACL2 !>(update-fld2 3 st2)
    <st2>
    ACL2 !>(fld2 st2)
    3
    ACL2 !>

  The function [47mremove-global-stobj[0m removes the indicated global stobj.
  We continue the log above.

    ACL2 !>(remove-global-stobj 'st2 state)
     ST2
    ACL2 !>(fld2 st2)


    ACL2 Error [Evaluation] in TOP-LEVEL:  Unbound var ST2.  Note that
    ST2 is a non-executable stobj.

    ACL2 !>

  If we remove a global stobj, as shown just above, and then add the
  corresponding global stobj, we get a fresh copy of that stobj; all
  previous updates are discarded.

    ACL2 !>(add-global-stobj 'st2 state)
     ST2
    ACL2 !>(fld2 st2)
    NIL
    ACL2 !>")
 (ADD-INCLUDE-BOOK-DIR
  (BOOKS-REFERENCE)
  "Link keyword for [47m:dir[0m argument of [47m[ld][0m and [47m[include-book][0m

    Example Forms:

    ; For (include-book \"foo\" :dir :smith), prepend to \"foo\" the absolute
    ; directory pathname \"/u/smith/\":
    (add-include-book-dir :smith \"/u/smith/\")

    ; For (include-book \"bar\" :dir :util), prepend to \"bar\" the absolute
    ; directory pathname corresponding to the interpretation of \"utilities/\"
    ; with respect to the current connected-book-directory (cbd):
    (add-include-book-dir :util \"utilities\")

    ; For (include-book \"lib/floor-mod/top\" :dir :arith), prepend to
    ; \"lib/floor-mod/top\" the string \"<dir>/arithmetic-5/\" where \"<dir>\"
    ; is the community books directory pathname string:
    (add-include-book-dir :arith (:system . \"arithmetic-5\"))

  Note: This is an event!  It does not print the usual event [summary]
  but nevertheless changes the ACL2 logical [world] and is so
  recorded.  It is [47m[local][0m to the book or [47m[encapsulate][0m form in which
  it occurs.  See [47m[add-include-book-dir!][0m for a corresponding
  non-[47m[local][0m event.

    General Form:
    (add-include-book-dir kwd dir)

  where [47mkwd[0m is a [47m[keywordp][0m and [47mdir[0m represents a directory: either a
  relative or absolute [pathname] string or a [sysfile].  If the
  final '[47m/[0m' is missing for the resulting directory, ACL2 will add it
  for you.  The effect of this event is to modify the meaning of the
  [47m:dir[0m keyword argument of [47m[include-book][0m and [47m[ld][0m as indicated by
  the examples above, that is, by associating the indicated directory
  with the indicated keyword for purposes of the [47m:dir[0m argument.  By
  the ``indicated directory'' we mean, when a relative pathname is
  supplied, the directory relative to the current connected book
  directory; see [cbd].  See [delete-include-book-dir] for how to
  undo this effect.

  For a keyword already associated with a directory string by a
  previous invocation of [47madd-include-book-dir[0m or
  [47m[add-include-book-dir!][0m, it is illegal to associate a different
  directory string until removing the existing association; see
  [delete-include-book-dir] (and see [delete-include-book-dir!] if
  the existing association was made by [47m[add-include-book-dir!][0m.  If
  however the new directory string is identical with the existing
  one, which was already assigned by [47madd-include-book-dir[0m, then the
  new call of [47madd-include-book-dir[0m will be redundant (see
  [redundant-events]).

  See [47m[project-dir-alist][0m for another way to associate keywords with
  directory names, to take place only at the time ACL2 starts up.
  Note that a keyword bound in the [47mproject-dir-alist[0m may also be
  bound by [47madd-include-book-dir[0m, but only if both bindings are to the
  same directory.

  The keyword [47m:system[0m can never be redefined.  It will always point to
  the absolute pathname of the [community-books] directory, which by
  default is the subdirectory [47m\"books/\"[0m of the directory where the
  ACL2 executable was built (see [include-book], in particular the
  discussion there of ``Books Directory'').

  This macro generates a [47m[table][0m event that updates the
  [47m[ACL2-defaults-table][0m and thus is automatically [local] to the book
  or [47m[encapsulate][0m event in which it occurs (and, it is thus illegal
  to call [47madd-include-book-dir[0m in an explicitly [47m[local][0m context).
  See [47m[add-include-book-dir!][0m for a corresponding non-[47m[local][0m event.

  As with [47m[add-include-book-dir!][0m, direct table updates are disallowed;
  you must use [47madd-include-book-dir[0m to add to the [47macl2-defaults-table[0m
  and [47m[delete-include-book-dir][0m to remove from it.")
 (ADD-INCLUDE-BOOK-DIR!
  (BOOKS-REFERENCE)
  "Non-[47m[local][0mly link keyword for [47m:dir[0m argument of [47m[ld][0m and
  [47m[include-book][0m

  This topic assumes familiarity with [add-include-book-dir], which has
  completely analogous syntax and semantics, except that
  [47madd-include-book-dir![0m is not [47m[local][0m to the [47m[encapsulate][0m or the
  book in which it occurs.  Probably [47m[add-include-book-dir][0m is to be
  preferred unless you have a good reason for wanting to export the
  effect of this event outside the enclosing [47m[encapsulate][0m or book.

  Note: This is an event!  It does not print the usual event [summary]
  but nevertheless changes the ACL2 logical [world] and is so
  recorded.

  This macro is essentially a [47m[table][0m event that updates the table
  [47minclude-book-dir!-table[0m, which associates keywords with absolute
  pathnames.  However, as with [47m[add-include-book-dir][0m, direct table
  updates are disallowed; you must use [47madd-include-book-dir![0m to add
  to the table and [47m[delete-include-book-dir!][0m to remove from the
  table.

  See [47m[project-dir-alist][0m for another way to associate keywords with
  directory names, to take place only at the time ACL2 starts up.
  Note that a keyword bound in the [47mproject-dir-alist[0m may also be
  bound by [47madd-include-book-dir![0m, but only if both bindings are to
  the same directory.

  It is illegal to call [47madd-include-book-dir![0m in a [47m[local][0m context.
  (If you are tempted to do that, consider using
  [47m[add-include-book-dir][0m instead.)  To understand this restriction,
  imagine a book that contains the following sequence of [events].

    (add-include-book-dir! :my-dir \"path/to/BAD/dir\")
    (local (delete-include-book-dir! :my-dir))
    (local (add-include-book-dir! :my-dir \"path/to/GOOD/dir\"))
    (include-book \"foo\" :dir :my-dir)
    (defthm f-def
      (equal (f x) x))

  During the first (proof) pass of [47m[certify-book][0m, the book
  [47mpath/to/GOOD/dir/foo.lisp[0m will be included.  But on the second
  pass, the book [47mpath/to/BAD/dir/foo.lisp[0m will be included.  Now
  imagine that the ``good'' version contains the event [47m(defun f (x)
  x)[0m but the ``bad'' version instead contains the event [47m(defun f (x)
  (not x))[0m.  Then we can easily prove [47mnil[0m from the theorem [47mf-def[0m!
  Although it is likely that [book-hash] values could catch this
  error at [47m[include-book][0m time, we prefer not to rely on these for
  soundness.")
 (ADD-INVISIBLE-FNS
  (LOOP-STOPPER)
  "Make some unary functions invisible to the [loop-stopper] algorithm

    Examples:
    (add-invisible-fns binary-+ unary-- foo)
    (add-invisible-fns + unary-- foo)

  Each of the [events] above makes unary functions [47m[unary--][0m and [47mfoo[0m
  ``invisible'' for the purposes of applying permutative [47m:[0m[47m[rewrite][0m
  rules to [47m[binary-+][0m trees.  Thus, [47marg[0m and [47m(unary-- arg)[0m will be
  given the same weight and will be permuted so as to be adjacent.

    General Form:
    (add-invisible-fns top-fn unary-fn1 ... unary-fnk)

  where [47mtop-fn[0m is a function symbol and the [47munary-fni[0m are unary
  function symbols, or more generally, these are all macro aliases
  for such function symbols (see [macro-aliases-table]).

  For more information see [invisible-fns-table].  Also see
  [set-invisible-fns-table], which explains how to set the entire
  table in a single event, and see [remove-invisible-fns].")
 (ADD-LD-KEYWORD-ALIAS (POINTERS)
                       "See [ld-keyword-aliases].")
 (ADD-LD-KEYWORD-ALIAS! (POINTERS)
                        "See [ld-keyword-aliases].")
 (ADD-MACRO-ALIAS
  (MACROS)
  "Associate a function name with a macro name

    Example:
    (add-macro-alias append binary-append)

  This example associates the function symbol [47m[binary-append][0m with the
  macro name [47m[append][0m.  As a result, the name [47m[append][0m may be used as
  a runic designator (see [theories]) by the various theory
  functions.  See [macro-aliases-table] for more details.  Also see
  [add-macro-fn] for an extension of this utility that also affects
  printing.

    General Form:
    (add-macro-alias macro-name function-name)

  This is a convenient way to add an entry to [47m[macro-aliases-table][0m.
  See [macro-aliases-table] and also see [remove-macro-alias].")
 (ADD-MACRO-FN
  (MACROS)
  "Associate a function name with a macro name

    Examples:
    (add-macro-fn append binary-append)
    (add-macro-fn append binary-append t)

  These examples each associate the function symbol [47m[binary-append][0m
  with the macro name [47m[append][0m.  As a result, theory functions will
  understand that [47mappend[0m refers to [47mbinary-append[0m --- see
  [add-macro-alias] --- and moreover, proof output will be printed
  using [47mappend[0m rather than [47mbinary-append[0m.  In the first case, [47m(append
  x (append y z))[0m is printed rather than [47m(append x y z)[0m.  In the
  second case, right-associated arguments are printed flat: [47m(append x
  y z)[0m.  Such right-association is considered only for binary
  function symbols; otherwise the optional third argument is ignored.

    General Forms:
    (add-macro-fn macro-name function-name)
    (add-macro-fn macro-name function-name nil) ; same as above
    (add-macro-fn macro-name function-name t)

  This is a convenient way to add an entry to [47m[macro-aliases-table][0m and
  at the same time extend the [47m[untrans-table][0m.  As suggested by the
  example above, calls of a function in this table will be printed as
  corresponding calls of macros, with right-associated arguments
  printed flat in the case of a binary function symbol if the
  optional third argument is t.  In that case, for a binary function
  symbol [47mfn[0m associated with macro name [47mmac[0m, then a call [47m(fn arg1 (fn
  arg2 (... (fn argk arg))))[0m will be displayed to the user as though
  the ``term'' were [47m(mac arg1 arg2 ... argk arg)[0m.  For a call [47m(f a1
  ... ak)[0m of a function symbol that is not binary, or the optional
  argument is not supplied as [47mt[0m, then the effect is simply to replace
  [47mf[0m by the corresponding macro symbol.  See [add-macro-alias], which
  is invoked on the first two arguments.  Also see
  [remove-macro-alias], see [untrans-table], and see
  [remove-macro-fn].")
 (ADD-MATCH-FREE-OVERRIDE
  (FREE-VARIABLES)
  "Set [47m:match-free[0m value to [47m:once[0m or [47m:all[0m in existing rules

    Example Forms:
    (add-match-free-override :once t)
        ; Try only the first binding of free variables when relieving hypotheses
        ; of any rule of class :rewrite, :linear, or :forward-chaining.
    (add-match-free-override :all (:rewrite foo) (:rewrite bar))
        ; For rewrite rules foo and bar, try all bindings of free variables when
        ; relieving hypotheses.
    (add-match-free-override :clear)
        ; Restore :match-free to what was originally stored for each rule (either
        ; :all or :once).

  As described elsewhere (see [free-variables]), a [rewrite], [linear],
  or [forward-chaining] rule may have free variables in its
  hypotheses, and ACL2 can be directed either to try all bindings
  (``[47m:all[0m'') or just the first (``[47m:once[0m'') when relieving a
  hypothesis, as a basis for relieving subsequent hypotheses.  This
  direction is generally provided by specifying either [47m:match-free
  :once[0m or [47m:match-free :all[0m in the [47m:[0m[47m[rule-classes][0m of the rule, or by
  using the most recent [47m[set-match-free-default][0m event.  Also see
  [rule-classes].

  However, if a proof is going slowly, you may want to modify the
  behavior of some such rules so that they use only the first match
  for free variables in a hypothesis when relieving subsequent
  hypotheses, rather than backtracking and trying additional matches
  as necessary.  (But note: [47madd-match-free-override[0m is not relevant
  for [type-prescription] rules.)  The event [47m(add-match-free-override
  :once t)[0m has that effect.  Or at the other extreme, perhaps you
  want to specify all rules as [47m:all[0m rules except for some specific
  exceptions.  Then you can execute [47m(add-match-free-override :all t)[0m
  followed by, say, [47m(add-match-free-override :once (:rewrite foo)
  (:linear bar))[0m.

    General Forms:
    (add-match-free-override :clear)
    (add-match-free-override flg t)
    (add-match-free-override flg rune1 rune2 ... runek)

  where [47mflg[0m is [47m:once[0m or [47m:all[0m and the [47mrunei[0m are [47m[rune][0ms.  If [47m:clear[0m is
  specified then all rules will have the [47m:all[0m/[47m:once[0m behavior from
  when they were first stored.  The second general form causes all
  [rewrite] [linear], and [forward-chaining] rules to have the
  behavior specified by [47mflg[0m ([47m:all[0m or [47m:once[0m).  Finally, the last of
  these, where runes are specified, is additive in the sense that
  only the indicated rules are affected; all others keep the behavior
  they had just before this event was executed (possible because of
  earlier [47madd-match-free-override[0m events).

  At the conclusion of this event, ACL2 prints out the list of all
  [47m:[0m[47m[linear][0m, [47m:[0m[47m[rewrite][0m, and [47m:[0m[47m[forward-chaining][0m runes whose rules
  contain free variables in hypotheses that are to be bound [47m:once[0m,
  except that if there are no overrides (value [47m:clear[0m was used), then
  [47m:clear[0m is printed.

  This event only affects rules that exist at the time it is executed.
  Future rules are not affected by the override.

  Note: This is an event!  It does not print the usual event [summary]
  but nevertheless changes the ACL2 logical [world] and is so
  recorded.  It uses the [47m[ACL2-defaults-table][0m, and hence its effect
  is [47m[local][0m to the book or [47m[encapsulate][0m form in which it occurs.

  [3mRemarks[0m

  Lists of the [47m:[0m[47m[rewrite][0m, [47m:[0m[47m[linear][0m, and [47m:[0m[47m[forward-chaining][0m [rune]s
  whose behavior was originally [47m:once[0m or [47m:all[0m are returned by the
  following forms, respectively.

    (free-var-runes :once (w state))
    (free-var-runes :all  (w state))

  The form

    (match-free-override (w state))

  evaluates to a pair, whose [47m[car][0m is a number used by ACL2 to
  determine whether a [rune] is sufficiently old to be affected by
  the override, and whose [47m[cdr][0m is the list of [rune]s whose behavior
  is specified as [47m:once[0m by [47madd-match-free-override[0m; except, if no
  runes have been overridden, then the keyword [47m:clear[0m is returned.")
 (ADD-NTH-ALIAS
  (NTH-ALIASES-TABLE)
  "Associate one symbol with another for printing of [47m[nth][0m/[47m[update-nth][0m
  terms

    Example:
    (add-nth-alias st0 st)

  This example associates the symbol [47mst0[0m with the symbol [47mst[0m for
  purposes of printing certain terms of the form [47m(nth n st0)[0m and
  [47m(update-nth n val st0)[0m.

    General Form:
    (add-nth-alias alias-name name)

  This is a convenient way to add an entry to [47m[nth-aliases-table][0m.  See
  [nth-aliases-table] and also see [remove-nth-alias].")
 (ADD-OVERRIDE-HINTS
  (OVERRIDE-HINTS)
  "Add to the [override-hints]

  See [override-hints] for a discussion of override-hints.  Here we
  describe how to extend the list of override-hints.  Note that the
  effects of [47madd-override-hints[0m [events] are [local] to the [books]
  or [47mencapsulate[0m [events] in which they reside; see
  [add-override-hints!] to avoid that restriction.  Also see
  [set-override-hints] to set a new list of override-hints to it,
  ignoring the present list rather than adding to it.

    General Forms:
    (add-override-hints form)
    (add-override-hints form :at-end t)
    (add-override-hints form :at-end nil) ; default for :at-end

  where [47mform[0m evaluates to a list of computed hint forms.  The effect of
  this event is to extend the current list of [override-hints] by
  appending the result of that evaluation.  The default is to append
  the evaluation result to the front of the current list of
  override-hints, but if [47m:at-end t[0m is specified, then the evaluation
  result is appended to the end of the current list.")
 (ADD-OVERRIDE-HINTS!
  (OVERRIDE-HINTS)
  "Add non-[local]ly to the [override-hints]

  [47mAdd-override-hints![0m is the same as [47m[add-override-hints][0m, except that
  the former is not [local] to [books] or [47m[encapsulate][0m [events] in
  which it occurs.  See [add-override-hints]; also see
  [set-override-hints].")
 (ADD-SUFFIX (POINTERS)
             "See [system-utilities].")
 (ADD-SUFFIX-TO-FN (POINTERS)
                   "See [system-utilities].")
 (ADD-TO-SET
  (LISTS SYMBOLS ACL2-BUILT-INS)
  "Add a symbol to a list

    General Forms:
    (add-to-set x lst)
    (add-to-set x lst :test 'eql)   ; same as above (eql as equality test)
    (add-to-set x lst :test 'eq)    ; same, but eq is equality test
    (add-to-set x lst :test 'equal) ; same, but equal is equality test

  For a symbol [47mx[0m and an object [47mlst[0m, [47m(add-to-set-eq x lst)[0m is the result
  of [47m[cons][0ming [47mx[0m on to the front of [47mlst[0m, unless [47mx[0m is already a
  [47m[member][0m of [47mlst[0m, in which case the result is [47mlst[0m. The optional
  keyword, [47m:TEST[0m, has no effect logically, but provides the test
  (default [47m[eql][0m) used for comparing [47mx[0m with successive elements of
  [47mlst[0m.

  The [guard] for a call of [47madd-to-set[0m depends on the test.  In all
  cases, the second argument must satisfy [47m[true-listp][0m.  If the test
  is [47m[eql][0m, then either the first argument must be suitable for [47m[eql][0m
  (see [eqlablep]) or the second argument must satisfy
  [47m[eqlable-listp][0m.  If the test is [47m[eq][0m, then either the first
  argument must be a symbol or the second argument must satisfy
  [47m[symbol-listp][0m.

  See [equality-variants] for a discussion of the relation between
  [47madd-to-set[0m and its variants:

      [47m(add-to-set-eq x lst)[0m is equivalent to [47m(add-to-set x lst :test 'eq)[0m;

      [47m(add-to-set-equal x lst)[0m is equivalent to [47m(add-to-set x lst :test
      'equal)[0m.

  In particular, reasoning about any of these primitives reduces to
  reasoning about the function [47madd-to-set-equal[0m.")
 (ADD-TO-SET-EQ (POINTERS)
                "See [add-to-set].")
 (ADD-TO-SET-EQL (POINTERS)
                 "See [add-to-set].")
 (ADD-TO-SET-EQUAL (POINTERS)
                   "See [add-to-set].")
 (ADJUST-LD-HISTORY (POINTERS)
                    "See [ld-history].")
 (ADVANCED-FEATURES
  (ACL2-TUTORIAL PROGRAMMING)
  "Some advanced features of ACL2

  Maybe you've been using ACL2 for awhile, and you wonder if there are
  lesser-known features that you might find useful.  Then this topic
  is for you.  We present below a ``laundry list'' of some such
  features, with brief descriptions and links to [documentation]
  topics.

  Although the list below is long, it is not intended to be complete,
  and indeed some topics have been deliberately excluded.  Some have
  fallen out of use, perhaps for good reason, such as [obdd].  Others
  are already likely to be discovered when needed, such as [47m[getenv$][0m
  and perhaps [47m[double-rewrite][0m.  Some topics are referenced by
  documentation for others in the list, such as [47m[mbt][0m, which is
  referenced by [47m[mbe][0m.  Some utilities such as [47m[pstack][0m and
  [47m[verbose-pstack][0m seem too low-level to be worthy of inclusion
  below.

  For an extensive introduction to using the prover, which may include
  some aspects new to you, see [introduction-to-the-theorem-prover].
  A shorter topic contains highlights for efficient prover usage: see
  [tips].  Also see [ACL2-sedan] for an extension of ACL2 (written by
  others), ACL2s, that includes an Eclipse-based interface, more
  powerful and automatic termination reasoning, and other features.

  We now move on to the list.


Top-level commands and utilities:

    * See [a!] and see [p!] to abort or pop.

    * See [ACL2-customization] for initial commands to run at startup.

    * See [keyword-commands] for how keyword commands are processed.

    * See [ld] for many ways to control the top-level loop.

    * See [compilation] for a discussion of [47mset-compiler-enabled[0m and other
      compiler-related utilities.

    * For useful reader macros `[47m#![0m', `[47m#.[0m', and `[47m#u[0m', see
      [sharp-bang-reader], see [sharp-dot-reader], and see
      [sharp-u-reader].

    * To save and use an ACL2 executable, see [ACL2-as-standalone-program]
      and see [save-exec].

    * For utilities related to timing, see [time$], see
      [with-prover-time-limit], see [with-prover-step-limit], and see
      [set-prover-step-limit].

    * To query and manage the database, see [history] (which discusses many
      useful utilities, such as [47m:[0m[47m[pbt][0m and [47m:[0m[47m[pl][0m), and see
      [dead-events].

    * See [add-include-book-dir], [add-include-book-dir!], and
      [project-dir-alist] for linking keyword for [47m:dir[0m argument of
      [47m[ld][0m and [47m[include-book][0m.

    * See [rebuild] for a fast way to load a file without waiting for
      proofs.

    * For parallel certification, see [books-certification] for use of the
      [47m-j[0m option of `make'; also see [provisional-certification].


Some relatively less common events

    * See [reset-prehistory] to reset the prehistory.

    * See [assert-event] to assert that a given form returns a non-nil
      value.

    * See [defattach] to execute constrained functions using corresponding
      attached functions.

    * See [defun-sk] to define a function whose body has an outermost
      quantifier.

    * See [defchoose] to define a Skolem (witnessing) function.

    * See [set-verify-guards-eagerness] to specify when [guard]
      verification is tried by default.


Output and its control (see [io] for additional information)

    * See [with-output] to suppress or turn on specified output for an
      event.

    * See [evisc-table] for support for abbreviated output.

    * See [nth-aliases-table] for a table used to associate names for
      [47m[nth][0m/[47m[update-nth][0m printing.

    * See [output-to-file] to redirect output to a file.

    * See [print-control] to control ACL2 printing.

    * See [set-evisc-tuple] to control suppression of details when
      printing.

    * See [set-inhibit-output-lst] to control output by type.

    * See [set-iprint] to allow abbreviated output to be read back in.

    * See [set-print-base-radix] (also [set-print-base] and
      [set-print-radix]) to control the radix in which numbers are
      printed.

    * See [set-print-case] to control whether symbols are printed in upper
      case or in lower case.


On proving termination for definitions:

    * See [ordinals] for a discussion of ordinals in ACL2.

    * See [ruler-extenders] for a control on ACL2's termination and
      induction analyses.

    * See [induction-coarse-v-fine-grained] for a discussion of how a
      well-chosen setting for [ruler-extenders] can improve an
      induction scheme, especially for a function containing [47m[let][0m
      and [47m[let*][0m bindings that contain conditional recursive calls.

    * See [set-well-founded-relation] to set the default well-founded
      relation for termination analysis.

    * See [ACL2-sedan] for a related tool that provides extra automation
      for termination proofs.


Proof debugging and output control:

    * See [accumulated-persistence] to get statistics on which runes are
      being tried.

    * See [add-macro-fn] and see [add-macro-alias] to associate a function
      name with a macro name.

    * See [break-rewrite] for how to monitor rewrite rules.

    * See [dmr] for dynamic monitoring of rewriting and other prover
      activity.

    * See [forward-chaining-reports] to see reports about the forward
      chaining process.

    * See [guard-debug] and [measure-debug] to generate markers to indicate
      sources of [guard] and termination proof obligations.

    * See [proof-builder] for support for low-level interaction.

    * See [redo-flat] for redo on failure of a [47m[progn][0m, [47m[encapsulate][0m, or
      [47m[certify-book][0m.

    * See [set-gag-mode] and see [pso] to abbreviate or restore proof
      output.

    * See [set-inhibit-output-lst], see [set-inhibit-warnings], see
      [set-inhibit-er], and see [set-inhibited-summary-types] to
      inhibit various types of output.

    * See [set-raw-proof-format] to make proof output display lists of
      [rune]s and, optionally, clausal form for goals.

    * See [set-raw-warning-format] to make some warnings display in a
      ``raw'' s-expression format.

    * See [skip-proofs] to skip proofs for a given form.

    * See [with-brr-data] for finding the source of a term in prover
      output.


Program debugging:

    * See [break$] to cause an immediate Lisp break.

    * See [break-on-error] to break when encountering a hard or soft error
      caused by ACL2.

    * See [disassemble$] to disassemble a function.

    * See [print-gv] to print a form whose evaluation caused a guard
      violation.

    * See [profile] to turn on profiling for one function.

    * See [trace$] and see [open-trace-file] to [trace] function
      evaluations, possibly sending trace output to a file.

    * See [wet] to evaluate a form and print a subsequent error trace.


Programming and evaluation idioms, support, utilities

  (also see [programming] for more utilities, e.g., [47m[random$][0m).

    * See [arrays] and See [defstobj] for introductions to ACL2 arrays and
      single-threaded objects (stobjs), respectively, each of which
      provides efficient destructive operations in an applicative
      setting.  Also see [with-local-stobj] for a way to create local
      stobjs.

    * See [assert$] to cause a hard error if the given test is false.

    * See [canonical-pathname] to obtain the true absolute filename, with
      soft links resolved.

    * See [case-match] for a utility providing pattern matching and
      destructuring.

    * See [defpun] to define a tail-recursive function symbol.

    * See [ec-call] to execute a call in the ACL2 logic instead of raw
      Lisp.

    * See [er] to print an error message and ``cause an error''.

    * See [flet] and [macrolet] to provide local binding of function and
      macro names.

    * See [gc$] to invoke the garbage collector.

    * See [mbe] to attach code for execution.

    * See [mv-list] to convert a [multiple-value] result to a single-value
      list.

    * See [mv?] to return one or more values.

    * For non-executable code, see [defun-nx] and see [non-exec].

    * See [prog2$] and see [progn$] to execute two or more forms and return
      the value of the last one.

    * See [programming-with-state] for how to program using the von
      Neumannesque ACL2 [state] object.

    * See [top-level] to evaluate a top-level form as a function body.

    * See [with-guard-checking] to suppress or enable guard-checking for a
      form.

    * For ways to fake access to the state see [wormhole], see
      [with-local-state], see [cw], see [cw!], see
      [printing-to-strings], see [observation-cw], and (dangerous!)
      see [with-live-state].


Connecting with the underlying host Lisp, and doing other evil:

    * See [defttag] to introduce a trust tag (ttag).

    * See [defmacro-last] to define a macro that returns its last argument,
      but with side effects.

    * See [progn!] to evaluate forms that are not necessarily [events].

    * See [return-last] to return the last argument, perhaps with side
      effects.

    * See [set-raw-mode] to enter or exit ``raw mode,'' a raw Lisp
      environment.

    * See [sys-call], [sys-call+], and [sys-call*] to make a system call to
      the host operating system.


Macros and related utilities:

    * See [defabbrev] for a convenient form of macro definition for simple
      expansions.

    * See [macro-args] for the formals list of a macro definition (see
      [defmacro]).

    * See [make-event] for a sort of extension of [47m[defmacro][0m that allows
      access to the [state], by evaluating (expanding) a given form
      and then evaluate the result of that expansion.

    * See [trans], see [trans!], and see [trans1] to print the
      macroexpansion of a form.


Additional capabilities:

    * See [hons-and-memoization] for a discussion of the [hons-enabled]
      features providing hash cons, function memoization, and
      applicative hash tables.  In particular, see [memoize] for
      efficient function memoization and see [profile] for profiling.

    * See [real] for ACL2(r), which supports the real numbers.

    * See [parallelism] for ACL2(p), which supports parallel evaluation and
      proof.


Database control and query:

    * See [disabledp] to determine whether a given name or rune is
      disabled.

    * For redefinition support see [redef], see [redef!], see [redef+], see
      [redef-], and see [redefined-names].

    * See [table] for user-managed tables.

    * See [guard-formula-utilities] for how to view a guard proof
      obligation without doing the proof.


Prover control

    * For congruence-based reasoning see [defcong], see [congruence], see
      [equivalence], see [defequiv], and see [defrefinement].

    * For meta rules and [clause] processors see [meta], see
      [defevaluator], see [clause-processor], see
      [define-trusted-clause-processor] (for connecting with external
      tools, such as SAT solvers), and See [extended-metafunctions]
      (for [state] and context-sensitive metafunctions).

    * For theory control, see [theories] for detailed information, but in
      particular see [deftheory], see [theory-functions], see
      [in-arithmetic-theory] (and see [non-linear-arithmetic]), and
      see [theory-invariant].

    * See [hints] for a complete list of prover hints, including some of
      the more obscure ones such as [47m:restrict[0m, [47m:[0m[47m[clause-processor][0m,
      [47m:nonlinearp[0m, [47m:backchain-limit-rw[0m, [47m:reorder[0m, and [47m:backtrack[0m.
      Also see [hints-and-the-waterfall] for an explanation of how
      hints interact with the ACL2 proof process.  For other topics
      related to hints, see [override-hints], see
      [add-custom-keyword-hint], see [default-hints], and see
      [computed-hints] and [using-computed-hints].

    * See [bind-free] to bind [free-variables] of a [rewrite] or [linear]
      rule.

    * See [case-split] for a utility like [47m[force][0m that immediately splits
      the top-level goal on the indicated hypothesis.

    * See [case-split-limitations] for a way to the number of cases
      produced at once

    * See [default-backchain-limit] to specify the backchain limit for a
      rule.

    * See [force] for an identity function used to force a hypothesis.

    * See [otf-flg] for a way to push more than one initial subgoal for
      induction.

    * See [rule-classes] to add various kinds of rules to the database,
      including more unusual sorts such as [47m:[0m[47m[built-in-clause][0m rules
      and [47m:[0m[47m[induction][0m rules.

    * See [set-backchain-limit] to set the backchain-limit used by the
      type-set and rewriting mechanisms.

    * See [set-body] to set an alternate definition body for [47m:expand[0m
      [hints].

    * See [set-rewrite-stack-limit] to set the [rewrite] stack depth used
      by the rewriter.

    * See [syntaxp] to attach a heuristic filter on a [47m:[0m[47m[rewrite][0m, [47m:[0m[47m[meta][0m,
      or [47m:[0m[47m[linear][0m rule.


Subtopics

  [Invariant-risk]
      Potential slowdown for [program]-mode updates to [stobj]s or
      [arrays]

  [Program-wrapper]
      Avoiding expensive [guard] checks using [program]-mode functions

  [Set-check-invariant-risk]
      Affect certain [program]-mode updates to [stobj]s or [arrays]

  [Set-duplicate-keys-action]
      Control action for macro calls with duplicate keyword arguments

  [Set-register-invariant-risk]
      Avoid [invariant-risk] checking for specified functions")
 (ALIST-KEYS-SUBSETP
  (ALISTS ACL2-BUILT-INS)
  "Check that all keys of the alist belong to a given set

  The call [47m(alist-keys-subsetp alist keys)[0m returns [47mt[0m when each key of
  the given alist belongs to the given list of keys; else it returns
  [47mnil[0m.  This is Boolean-equivalent to [47m(subsetp-eq (strip-cars alist)
  keys)[0m, but it avoids consing up the keys of [47malist[0m.")
 (ALIST-TO-DOUBLETS
  (ALISTS ACL2-BUILT-INS)
  "Convert an alist to a list of two-element lists

  The call [47m(alist-to-doublets alist)[0m returns the result of replacing
  each pair [47m(x . y)[0m in the given alist by the two-element list [47m(x y)[0m.
  The order is preserved, i.e., the following is a theorem.

    (implies (and (natp i) (< i (len alist)))
             (equal (nth i (alist-to-doublets alist))
                    (let ((pair (nth i alist)))
                      (list (car pair) (cdr pair)))))")
 (ALISTP
  (ALISTS ACL2-BUILT-INS)
  "Recognizer for association lists

  [47m(alistp x)[0m is true if and only if [47mx[0m is a list of [47m[cons][0m pairs.

  [47m(alistp x)[0m has a [guard] of [47mt[0m.

  [31;1mFunction: [0m<alistp>

    (defun alistp (l)
      (declare (xargs :guard t))
      (cond ((atom l) (eq l nil))
            (t (and (consp (car l))
                    (alistp (cdr l))))))")
 (ALISTS
  (PROGRAMMING)
  "Operations on association lists, which bind keys to values.


Subtopics

  [Acons]
      Constructor for association lists

  [Alist-keys-subsetp]
      Check that all keys of the alist belong to a given set

  [Alist-to-doublets]
      Convert an alist to a list of two-element lists

  [Alistp]
      Recognizer for association lists

  [Assoc]
      Look up key in association list

  [Assoc-string-equal]
      Look up key, a string, in association list

  [Character-alistp]
      Recognizer for association lists with characters as keys

  [Delete-assoc]
      Deprecated version of [remove1-assoc]

  [Eqlable-alistp]
      Recognizer for a true list of pairs whose [47m[car][0ms are suitable for
      [47m[eql][0m

  [Fast-alists]
      Alists with hidden hash tables for faster execution

  [Pairlis]
      See [pairlis$]

  [Pairlis$]
      Zipper together two lists

  [Pairlis-x1]
      Cons a given element to each member of a list

  [Pairlis-x2]
      Cons each element of a list with a given element

  [Put-assoc]
      Modify an association list by associating a value with a key

  [R-eqlable-alistp]
      Recognizer for a true list of pairs whose [47m[cdr][0ms are suitable for
      [47m[eql][0m

  [R-symbol-alistp]
      Recognizer for association lists with symbols as values

  [Rassoc]
      Look up value in association list

  [Remove-assoc]
      Remove all pairs with a given key from an association list

  [Remove1-assoc]
      Remove the first pair with a given key from an association list

  [String-alistp]
      Recognizer for association lists with strings as keys

  [Strip-cars]
      Collect up all first components of pairs in a list

  [Strip-cdrs]
      Collect up all second components of pairs in a list

  [Sublis]
      Substitute an alist into a tree

  [Symbol-alistp]
      Recognizer for association lists with symbols as keys")
 (ALL-ATTACHMENTS (POINTERS)
                  "See [system-utilities].")
 (ALL-CALLS (POINTERS)
            "See [system-utilities].")
 (ALL-FNNAMES (POINTERS)
              "See [system-utilities].")
 (ALL-FNNAMES-LST (POINTERS)
                  "See [system-utilities].")
 (ALL-FNNAMES1 (POINTERS)
               "See [system-utilities].")
 (ALL-VARS (POINTERS)
           "See [system-utilities].")
 (ALLOCATE-FIXNUM-RANGE
  (NUMBERS ACL2-BUILT-INS)
  "Set aside fixnums in GCL

  [47m(Allocate-fixnum-range fixnum-lo fixnum-hi)[0m causes Gnu Common Lisp
  (GCL), versions preceding 2.7, to create a persistent table for the
  integers between [47mfixnum-lo[0m and [47mfixnum-hi[0m (both bounds inclusive).
  This table is referenced first when any integer is boxed and the
  existing box in the table is used if the integer is in bounds.
  This can speed up GCL (again, for versions preceding 2.7)
  considerably by avoiding wasteful fixnum boxing.  Here, [47mfixnum-lo[0m
  and [47mfixnum-hi[0m should be fixnums.  On 32-bit machines it would be
  good for them to be of type [47m(signed-byte 30)[0m, with [47mfixnum-lo <=
  fixnum-hi[0m.

  When this function is executed in a Lisp implementation other than a
  GCL version preceding 2.7, it has no side effect other than to
  print a message.  This function always returns [47mnil[0m.

  In GCL versions starting with 2.7.0, allocation for the table would
  generally be a no-op other than to waste space, which is why
  [47mallocate-fixnum-range[0m is a no-op for those versions.")
 (ALPHA-CHAR-P
  (CHARACTERS ACL2-BUILT-INS)
  "Recognizer for alphabetic characters

  [47m(Alpha-char-p x)[0m is true for a character [47mx[0m if and only if [47mx[0m is
  alphabetic, i.e., one of the [characters] [47m#\\a[0m, [47m#\\b[0m, ..., [47m#\\z[0m, [47m#\\A[0m,
  [47m#\\B[0m, ..., [47m#\\Z[0m.

  The [guard] for [47malpha-char-p[0m states that its argument is a character.

  [47mAlpha-char-p[0m is a Common Lisp function.  See any Common Lisp
  documentation for more information.  Note that the value returned
  may depend on the host Lisp; see [soundness], specifically Example
  1 in the Section, ``Examples of divergence among Lisp
  implementations''.

  [31;1mFunction: [0m<alpha-char-p>

    (defun alpha-char-p (x)
      (declare (xargs :guard (characterp x)))
      (cond ((standard-char-p x)
             (and (member x
                          '(#\\a #\\b #\\c
                                #\\d #\\e #\\f #\\g #\\h #\\i #\\j #\\k #\\l #\\m
                                #\\n #\\o #\\p #\\q #\\r #\\s #\\t #\\u #\\v #\\w
                                #\\x #\\y #\\z #\\A #\\B #\\C #\\D #\\E #\\F #\\G
                                #\\H #\\I #\\J #\\K #\\L #\\M #\\N #\\O #\\P #\\Q
                                #\\R #\\S #\\T #\\U #\\V #\\W #\\X #\\Y #\\Z))
                  t))
            (t (alpha-char-p-non-standard x))))")
 (ALPHORDER
  (<< ACL2-BUILT-INS)
  "Total order on atoms

  [47mAlphorder[0m is a non-strict total order, a ``less than or equal,'' on
  atoms.  By ``non-strict total order'' we mean a function that
  always returns [47mt[0m or [47mnil[0m and satisfies the following properties.

    * Antisymmetry: [47mXrY & YrX -> X=Y[0m

    * Transitivity: [47mXrY & YrZ -> XrZ[0m

    * Trichotomy: [47mXrY v YrX[0m

  Also see [lexorder], which extends [47malphorder[0m to all objects.

  [47m(Alphorder x y)[0m has a guard of [47m(and (atom x) (atom y))[0m.

  Within a single type: rationals are compared arithmetically, complex
  rationals are compared lexicographically, characters are compared
  via their char-codes, and strings and symbols are compared with
  alphabetic ordering.  Across types, rationals come before
  complexes, complexes come before characters, characters before
  strings, and strings before symbols.  We also allow for ``bad
  atoms,'' i.e., atoms that are not legal Lisp objects but make sense
  in the ACL2 logic; these come at the end, after symbols.

  [31;1mFunction: [0m<alphorder>

    (defun alphorder (x y)
      (declare (xargs :guard (and (atom x) (atom y))))
      (cond ((real/rationalp x)
             (cond ((real/rationalp y) (<= x y))
                   (t t)))
            ((real/rationalp y) nil)
            ((complex/complex-rationalp x)
             (cond ((complex/complex-rationalp y)
                    (or (< (realpart x) (realpart y))
                        (and (= (realpart x) (realpart y))
                             (<= (imagpart x) (imagpart y)))))
                   (t t)))
            ((complex/complex-rationalp y) nil)
            ((characterp x)
             (cond ((characterp y)
                    (<= (char-code x) (char-code y)))
                   (t t)))
            ((characterp y) nil)
            ((stringp x)
             (cond ((stringp y) (and (string<= x y) t))
                   (t t)))
            ((stringp y) nil)
            (t (cond ((symbolp x)
                      (cond ((symbolp y) (not (symbol< y x)))
                            (t t)))
                     ((symbolp y) nil)
                     (t (bad-atom<= x y))))))")
 (ALTERNATIVE-INTRODUCTION
  (ACL2-TUTORIAL)
  "Introduction to ACL2

  This section contains introductory material on ACL2 including what
  ACL2 is, how to get started using the system, how to read the
  output, and other introductory topics.  It was written almost
  entirely by Bill Young of Computational Logic, Inc.

  You might also find CLI Technical Report 101 helpful, especially if
  you are familiar with Nqthm.  If you would like more familiarity
  with Nqthm, we suggest CLI Technical Report 100.

  [3mOVERVIEW[0m

  ACL2 is an automated reasoning system developed (for the first 9
  years) at Computational Logic, Inc. and (from January, 1997) at the
  University of Texas at Austin.  It is the successor to the Nqthm
  (or Boyer-Moore) logic and proof system and its Pc-Nqthm
  interactive enhancement.  The acronym ACL2 actually stands for ``A
  Computational Logic for Applicative Common Lisp''.  This title
  suggests several distinct but related aspects of ACL2.

  We assume that readers of the ACL2 [documentation] have at least a
  very slight familiarity with some Lisp-like language.  We will
  address the issue of prerequisites further, in ``ABOUT THIS
  TUTORIAL'' below.

  As a [31;1mlogic[0m, ACL2 is a formal system with rigorously defined syntax
  and semantics.  In mathematical parlance, the ACL2 logic is a
  first-order logic of total recursive functions providing
  mathematical induction on the ordinals up to epsilon-0 and two
  extension principles: one for recursive definition and one for
  constrained introduction of new function symbols, here called
  encapsulation.  The syntax of ACL2 is that of Common Lisp; ACL2
  specifications are ``also'' Common Lisp programs in a way that we
  will make clear later.  In less formal language, the ACL2 logic is
  an integrated collection of rules for defining (or axiomatizing)
  recursive functions, stating properties of those functions, and
  rigorously establishing those properties.  Each of these activities
  is mechanically supported.

  As a [31;1mspecification language[0m, ACL2 supports modeling of systems of
  various kinds.  An ACL2 function can equally be used to express
  purely formal relationships among mathematical entities, to
  describe algorithms, or to capture the intended behavior of digital
  systems.  For digital systems, an ACL2 specification is a
  mathematical [31;1mmodel[0m that is intended to formalize relevant aspects
  of system behavior.  Just as physics allows us to model the
  behavior of continuous physical systems, ACL2 allows us to model
  digital systems, including many with physical realizations such as
  computer hardware.  As early as the 1930's Church, Kleene, Turing
  and others established that recursive functions provide an
  expressive formalism for modeling digital computation.  Digital
  computation should be understood in a broad sense, covering a wide
  variety of activities including almost any systematic or
  algorithmic activity, or activity that can be reasonably
  approximated in that way.  This ranges from the behavior of a
  digital circuit to the behavior of a programming language compiler
  to the behavior of a controller for a physical system (as long as
  the system can be adequately modeled discretely).  All of these
  have been modeled using ACL2 or its predecessor Nqthm.

  ACL2 is a [31;1mcomputational[0m logic in at least three distinct senses.
  First, the theory of recursive functions is often considered the
  mathematics of computation.  Church conjectured that any
  ``effective computation'' can be modeled as a recursive function.
  Thus, ACL2 provides an expressive language for modeling digital
  systems.  Second, many ACL2 specifications are executable.  In
  fact, recursive functions written in ACL2 [31;1mare[0m Common Lisp functions
  that can be submitted to any compliant Common Lisp compiler and
  executed (in an environment where suitable ACL2-specific macros and
  functions are defined).  Third, ACL2 is computational in the sense
  that calculation is heavily integrated into the reasoning process.
  Thus, an expression with explicit constant values but no free
  variables can be simplified by calculation rather than by complex
  logical manipulations.

  ACL2 is a powerful, automated [31;1mtheorem prover[0m or proof checker.  This
  means that a competent user can utilize the ACL2 system to discover
  proofs of theorems stated in the ACL2 logic or to check previously
  discovered proofs.  The basic deductive steps in an ACL2-checked
  proof are often quite large, due to the sophisticated combination
  of decision procedures, conditional rewriting, mathematical and
  structural induction, propositional simplification, and complex
  heuristics to orchestrate the interactions of these capabilities.
  Unlike some automated proof systems, ACL2 does not produce a formal
  proof.  However, we believe that if ACL2 certifies the
  ``theoremhood'' of a given conjecture, then such a formal proof
  exists and, therefore, the theorem is valid.  The ultimate result
  of an ACL2 proof session is a collection of ``[events],'' possibly
  grouped into ``[books],'' that can be replayed in ACL2.  Therefore,
  a proof can be independently validated by any ACL2 user.

  ACL2 may be used in purely automated mode in the shallow sense that
  conjectures are submitted to the prover and the user does not
  interact with the proof attempt (except possibly to stop it) until
  the proof succeeds or fails.  However, any non-trivial proof
  attempt is actually interactive, since successful proof
  ``[events]'' influence the subsequent behavior of the prover.  For
  example, proving a lemma may introduce a rule that subsequently is
  used automatically by the prover.  Thus, any realistic proof
  attempt, even in ``automatic'' mode, is really an interactive
  dialogue with the prover to craft a sequence of [events] building
  an appropriate theory and proof rules leading up to the proof of
  the desired result.  Also, ACL2 supports annotating a theorem with
  ``[hints]'' designed to guide the proof attempt.  By supplying
  appropriate [hints], the user can suggest proof strategies that the
  prover would not discover automatically.  There is a
  ``[proof-tree]'' facility (see [proof-tree]) that allows the user
  to [monitor] the progress and structure of a proof attempt in
  real-time.  Exploring failed proof attempts is actually where
  heavy-duty ACL2 users spend most of their time.

  ACL2 can also be used in a more explicitly interactive mode.  The
  interactive [proof-builder] subsystem of ACL2 allows exploration of
  a proof on a fairly low level including expanding calls of selected
  function symbols, invoking specific [rewrite] rules, and
  selectively navigating around the proof.  This facility can be used
  to gain sufficient insight into the proof to construct an automatic
  version, or to generate a detailed interactive-style proof that can
  be replayed in batch mode.

  Because ACL2 is all of these things --- computational logic,
  specification language, [programming] system, and theorem prover
  --- it is more than the sum of its parts.  The careful integration
  of these diverse aspects has produced a versatile automated
  reasoning system suitable for building highly reliable digital
  systems.  In the remainder of this tutorial, we will illustrate
  some simple uses of this automated reasoning system.

  [3mABOUT THIS TUTORIAL[0m

  ACL2 is a complex system with a vast array of features, bells and
  whistles.  However, it is possible to perform productive work with
  the system using only a small portion of the available
  functionality.  The goals of this tutorial are to:

      familiarize the new user with the most basic features of and modes of
      interaction with ACL2;

      familiarize her with the form of output of the system; and

      work through a graduated series of examples.

  The more knowledge the user brings to this system, the easier it will
  be to become proficient.  On one extreme: the [31;1mideal[0m user of ACL2 is
  an expert Common Lisp programmer, has deep understanding of
  automated reasoning, and is intimately familiar with the earlier
  Nqthm system.  Such ideal users are unlikely to need this tutorial.
  However, without some background knowledge, the beginning user is
  likely to become extremely confused and frustrated by this system.
  We suggest that a new user of ACL2 should:

      (a) have a little familiarity with Lisp, including basic Lisp
      programming and prefix notation (a Lisp reference manual such
      as Guy Steele's ``Common Lisp: The Language'' is also helpful);

      (b) be convinced of the utility of formal modeling; and

      (c) be willing to gain familiarity with basic automated theorem
      proving topics such as rewriting and algebraic simplification.

  We will not assume any deep familiarity with Nqthm (the so-called
  ``Boyer-Moore Theorem Prover''), though the book ``A Computational
  Logic Handbook'' by Boyer and Moore (Academic Press, 1988) is an
  extremely useful reference for many of the topics required to
  become a competent ACL2 user.  We'll refer to it as ACLH below.

  As we said in the introduction, ACL2 has various facets.  For
  example, it can be used as a Common Lisp [programming] system to
  construct application programs.  In fact, the ACL2 system itself is
  a large Common Lisp program constructed almost entirely within
  ACL2.  Another use of ACL2 is as a specification and modeling tool.
  That is the aspect we will concentrate on in the remainder of this
  tutorial.

  [3mGETTING STARTED[0m

  This section is an abridged version of what's available elsewhere;
  feel free to see [startup] for more details.

  How you start ACL2 will be system dependent, but you'll probably type
  something like ``acl2'' at your operating system prompt.  Consult
  your system administrator for details.

  When you start up ACL2, you'll probably find yourself inside the ACL2
  [command] loop, as indicated by the following [prompt].

    ACL2 !>

  If not, you should type [47m(LP)[0m.  See [lp], which has a lot more
  information about the ACL2 [command] loop.

  There are two ``modes'' for using ACL2, [47m:[0m[47m[logic][0m and [47m:[0m[47m[program][0m.
  When you begin ACL2, you will ordinarily be in the [47m:[0m[47m[logic][0m mode.
  This means that any new function defined is not only executable but
  also is axiomatically defined in the ACL2 logic.  (See [defun-mode]
  and see [default-defun-mode].)  Roughly speaking, [47m:[0m[47m[program][0m mode
  is available for using ACL2 as a [programming] language without
  some of the logical burdens necessary for formal reasoning.  In
  this tutorial we will assume that we always remain in [47m:[0m[47m[logic][0m mode
  and that our purpose is to write formal models of digital systems
  and to reason about them.

  Now, within the ACL2 [command] loop you can carry out various kinds
  of activities, including the following.  (We'll see examples later
  of many of these.)

      define new functions (see [defun]);

      execute functions on concrete data;

      pose and attempt to prove conjectures about previously defined
      functions (see [defthm]);

      query the ACL2 ``[world]'' or database (e.g., see [pe]); and

      numerous other things.

  In addition, there is extensive on-line [documentation], of which
  this tutorial introduction is a part.

  [3mINTERACTING WITH ACL2[0m

  The standard means of interacting with ACL2 is to submit a sequence
  of forms for processing by the ACL2 system.  These forms are
  checked for syntactic and semantic acceptability and appropriately
  processed by the system.  These forms can be typed directly at the
  ACL2 [prompt].  However, most successful ACL2 users prefer to do
  their work using the Emacs text editor, maintaining an Emacs
  ``working'' buffer in which forms are edited.  Those forms are then
  copied to the ACL2 interaction buffer, which is often the [47m\"*shell*\"[0m
  buffer.

  In some cases, processing succeeds and makes some change to the ACL2
  ``logical [world],'' which affects the processing of subsequent
  forms.  How can this processing fail?  For example, a proposed
  theorem will be rejected unless all function symbols mentioned have
  been previously defined.  Also the ability of ACL2 to discover the
  proof of a theorem may depend on the user previously having proved
  other theorems.  Thus, the order in which forms are submitted to
  ACL2 is quite important.  Maintaining forms in an appropriate order
  in your working buffer will be helpful for re-playing the proof
  later.

  One of the most common [events] in constructing a model is
  introducing new functions.  New functions are usually introduced
  using the [47m[defun][0m form; we'll encounter some exceptions later.
  Proposed function definitions are checked to make sure that they
  are syntactically and semantically acceptable (e.g., that all
  mentioned functions have been previously defined) and, for
  recursive functions, that their recursive calls [31;1mterminate[0m.  A
  recursive function definition is guaranteed to terminate if there
  is some some ``measure'' of the arguments and a ``well-founded''
  ordering such that the arguments to the function get smaller in
  each recursive call.  See [well-founded-relation-rule].

  For example, suppose that we need a function that will append two
  lists together.  (We already have one in the ACL2 [47m[append][0m
  function; but suppose perversely that we decide to define our own.)
  Suppose we submit the following definition (you should do so as
  well and study the system output):

    (defun my-app (x y)
      (if (atom x)
          y
        (cons (car x) (my-app x y))))

  The system responds with the following message:

    ACL2 Error in ( DEFUN MY-APP ...):  No :MEASURE was supplied with
    the definition of MY-APP.  Our heuristics for guessing one have not
    made any suggestions.  No argument of the function is tested along
    every branch and occurs as a proper subterm at the same argument
    position in every recursive call.  You must specify a :MEASURE.  See
    :DOC defun.

  This means that the system could not find an expression involving the
  formal parameters [47mx[0m and [47my[0m that decreases under some well-founded
  order in every recursive call (there is only one such call).  It
  should be clear that there is no such measure in this case because
  the only recursive call doesn't change the arguments at all.  The
  definition is obviously flawed; if it were accepted and executed it
  would loop forever.  Notice that a definition that is rejected is
  not stored in the system database; there is no need to take any
  action to have it ``thrown away.'' Let's try again with the correct
  definition.  The interaction now looks like (we're also putting in
  the ACL2 [prompt]; you don't type that):

    ACL2 !>(defun my-app (x y)
             (if (atom x)
                 y
               (cons (car x) (my-app (cdr x) y))))

    The admission of MY-APP is trivial, using the relation O<
    (which is known to be well-founded on the domain recognized by
    O-P) and the measure (ACL2-COUNT X).  We observe that the
    type of MY-APP is described by the theorem
    (OR (CONSP (MY-APP X Y)) (EQUAL (MY-APP X Y) Y)).
    We used primitive type reasoning.

    Summary
    Form:  ( DEFUN MY-APP ...)
    Rules: ((:FAKE-RUNE-FOR-TYPE-SET NIL))
    Warnings:  None
    Time:  0.07 seconds (prove: 0.00, print: 0.00, other: 0.07)
    MY-APP

  Notice that this time the function definition was accepted.  We
  didn't have to supply a measure explicitly; the system inferred one
  from the form of the definition.  On complex functions it may be
  necessary to supply a measure explicitly.  (See [xargs].)

  The system output provides several pieces of information.

      The revised definition is acceptable.  The system realized that there
      is a particular measure (namely, [47m(acl2-count x)[0m) and a
      well-founded relation ([47mo<[0m) under which the arguments of [47mmy-app[0m
      get smaller in recursion.  Actually, the theorem prover proved
      several theorems to admit [47mmy-app[0m.  The main one was that when
      [47m(atom x)[0m is false the [47macl2-count[0m of [47m(cdr x)[0m is less than (in
      the [47mo<[0m sense) the [47macl2-count[0m of [47mx[0m.  [47m[Acl2-count][0m is the most
      commonly used measure of the ``size`` of an ACL2 object.  [47m[o<][0m
      is the ordering relation on ordinals less than epsilon-0.  On
      the natural numbers it is just ordinary ``<''.

      The observation printed about ``the type of MY-APP'' means that calls
      of the function [47mmy-app[0m will always return a value that is
      either a [cons] pair or is equal to the second parameter.

      The [summary] provides information about which previously introduced
      definitions and lemmas were used in this proof, about some
      notable things to watch out for (the Warnings), and about how
      long this event took to process.

  Usually, it's not important to read this information.  However, it is
  a good habit to scan it briefly to see if the type information is
  surprising to you or if there are Warnings.  We'll see an example
  of them later.

  After a function is accepted, it is stored in the database and
  available for use in other function definitions or lemmas.  To see
  the definition of any function use the [47m:[0m[47m[pe][0m command (see [pe]).
  For example,

    ACL2 !>:pe my-app
     L       73:x(DEFUN MY-APP (X Y)
                        (IF (ATOM X)
                            Y (CONS (CAR X) (MY-APP (CDR X) Y))))

  This displays the definition along with some other relevant
  information.  In this case, we know that this definition was
  processed in [47m:[0m[47m[logic][0m mode (the ``[47mL[0m'') and was the 73rd [command]
  processed in the current session.

  We can also try out our newly defined function on some sample data.
  To do that, just submit a form to be evaluated to ACL2.  For
  example,

    ACL2 !>(my-app '(0 1 2) '(3 4 5))
    (0 1 2 3 4 5)
    ACL2 !>(my-app nil nil)
    NIL
    ACL2 !>

  Now suppose we want to prove something about the function just
  introduced.  We conjecture, for example, that the length of the
  [append] of two lists is the sum of their lengths.  We can
  formulate this conjecture in the form of the following ACL2
  [47m[defthm][0m form.

    (defthm my-app-length
      (equal (len (my-app x y))
             (+ (len x) (len y))))

  First of all, how did we know about the functions [47mlen[0m and [47m[+][0m, etc.?
  The answer to that is somewhat unsatisfying --- we know them from
  our past experience in using Common Lisp and ACL2.  It's hard to
  know that a function such as [47mlen[0m exists without first knowing some
  Common Lisp.  If we'd guessed that the appropriate function was
  called [47m[length][0m (say, from our knowledge of Lisp) and tried [47m:pe
  length[0m, we would have seen that [47m[length][0m is defined in terms of
  [47mlen[0m, and we could have explored from there.  Luckily, you can write
  a lot of ACL2 functions without knowing too many of the primitive
  functions.

  Secondly, why don't we need some ``type'' hypotheses?  Does it make
  sense to append things that are not lists?  Well, yes.  ACL2 and
  Lisp are both quite weakly typed.  For example, inspection of the
  definition of [47mmy-app[0m shows that if [47mx[0m is not a [cons] pair, then
  [47m(my-app x y)[0m always returns [47my[0m, no matter what [47my[0m is.

  Thirdly, would it matter if we rewrote the lemma with the equality
  reversed, as follows?

    (defthm my-app-length2
      (equal (+ (len x) (len y))
             (len (my-app x y)))).

  The two are [31;1mlogically[0m equivalent, but...yes, it would make a big
  difference.  Recall our remark that a lemma is not only a ``fact''
  to be proved; it also is used by the system to prove other later
  lemmas.  The current lemma would be stored as a [rewrite] rule.
  (See [rule-classes].)  For a [rewrite] rule, a conclusion of the
  form [47m(EQUAL LHS RHS)[0m means to replace instances of the [47mLHS[0m by the
  appropriate instance of the [47mRHS[0m.  Presumably, it's better to
  [rewrite] [47m(len (my-app x y))[0m to [47m(+ (len x) (len y))[0m than the other
  way around.  The reason is that the system ``knows'' more about [47m[+][0m
  than it does about the new function symbol [47mmy-app[0m.

  So let's see if we can prove this lemma.  Submitting our preferred
  [47m[defthm][0m to ACL2 (do it!), we get the following interaction:

              --------------------------------------------------
    ACL2 !>(defthm my-app-length
      (equal (len (my-app x y))
             (+ (len x) (len y))))

    Name the formula above *1.

    Perhaps we can prove *1 by induction.  Three induction schemes are
    suggested by this conjecture.  These merge into two derived
    induction schemes.  However, one of these is flawed and so we are
    left with one viable candidate.

    We will induct according to a scheme suggested by (LEN X), but
    modified to accommodate (MY-APP X Y).  If we let (:P X Y) denote *1
    above then the induction scheme we'll use is
    (AND (IMPLIES (NOT (CONSP X)) (:P X Y))
         (IMPLIES (AND (CONSP X) (:P (CDR X) Y))
                  (:P X Y))).
    This induction is justified by the same argument used to admit LEN,
    namely, the measure (ACL2-COUNT X) is decreasing according to the
    relation O< (which is known to be well-founded on the domain
    recognized by O-P).  When applied to the goal at hand the
    above induction scheme produces the following two nontautological
    subgoals.

    Subgoal *1/2
    (IMPLIES (NOT (CONSP X))
             (EQUAL (LEN (MY-APP X Y))
                    (+ (LEN X) (LEN Y)))).

    But simplification reduces this to T, using the :definitions of FIX,
    LEN and MY-APP, the :type-prescription rule LEN, the :rewrite rule
    UNICITY-OF-0 and primitive type reasoning.

    Subgoal *1/1
    (IMPLIES (AND (CONSP X)
                  (EQUAL (LEN (MY-APP (CDR X) Y))
                         (+ (LEN (CDR X)) (LEN Y))))
             (EQUAL (LEN (MY-APP X Y))
                    (+ (LEN X) (LEN Y)))).

    This simplifies, using the :definitions of LEN and MY-APP, primitive
    type reasoning and the :rewrite rules COMMUTATIVITY-OF-+ and
    CDR-CONS, to

    Subgoal *1/1'
    (IMPLIES (AND (CONSP X)
                  (EQUAL (LEN (MY-APP (CDR X) Y))
                         (+ (LEN Y) (LEN (CDR X)))))
             (EQUAL (+ 1 (LEN (MY-APP (CDR X) Y)))
                    (+ (LEN Y) 1 (LEN (CDR X))))).

    But simplification reduces this to T, using linear arithmetic,
    primitive type reasoning and the :type-prescription rule LEN.

    That completes the proof of *1.

    Q.E.D.

    Summary
    Form:  ( DEFTHM MY-APP-LENGTH ...)
    Rules: ((:REWRITE UNICITY-OF-0)
            (:DEFINITION FIX)
            (:REWRITE COMMUTATIVITY-OF-+)
            (:DEFINITION LEN)
            (:REWRITE CDR-CONS)
            (:DEFINITION MY-APP)
            (:TYPE-PRESCRIPTION LEN)
            (:FAKE-RUNE-FOR-TYPE-SET NIL)
            (:FAKE-RUNE-FOR-LINEAR NIL))
    Warnings:  None
    Time:  0.30 seconds (prove: 0.13, print: 0.05, other: 0.12)
     MY-APP-LENGTH
              --------------------------------------------------

  Wow, it worked!  In brief, the system first tried to [rewrite] and
  simplify as much as possible.  Nothing changed; we know that
  because it said ``Name the formula above *1.'' Whenever the system
  decides to name a formula in this way, we know that it has run out
  of techniques to use other than proof by induction.

  The induction performed by ACL2 is structural or ``Noetherian''
  induction.  You don't need to know much about that except that it
  is induction based on the structure of some object.  The heuristics
  infer the structure of the object from the way the object is
  recursively decomposed by the functions used in the conjecture.
  The heuristics of ACL2 are reasonably good at selecting an
  induction scheme in simple cases.  It is possible to override the
  heuristic choice by providing an [47m:induction[0m hint (see [hints]).  In
  the case of the theorem above, the system inducts on the structure
  of [47mx[0m as suggested by the decomposition of [47mx[0m in both [47m(my-app x y)[0m
  and [47m(len x)[0m.  In the base case, we assume that [47mx[0m is not a [47m[consp][0m.
  In the inductive case, we assume that it is a [47m[consp][0m and assume
  that the conjecture holds for [47m(cdr x)[0m.

  There is a close connection between the analysis that goes on when a
  function like [47mmy-app[0m is accepted and when we try to prove something
  inductively about it.  That connection is spelled out well in Boyer
  and Moore's book ``A Computational Logic,'' if you'd like to look
  it up.  But it's pretty intuitive.  We accepted [47mmy-app[0m because the
  ``size'' of the first argument [47mx[0m decreases in the recursive call.
  That tells us that when we need to prove something inductively
  about [47mmy-app[0m, it's a good idea to try an induction on the size of
  the first argument.  Of course, when you have a theorem involving
  several functions, it may be necessary to concoct a more
  complicated [induction] schema, taking several of them into
  account.  That's what's meant by ``merging'' the induction schemas.

  The proof involves two cases: the base case, and the inductive case.
  You'll notice that the subgoal numbers go [31;1mdown[0m rather than up, so
  you always know how many subgoals are left to process.  The base
  case ([47mSubgoal *1/2[0m) is handled by opening up the function
  definitions, simplifying, doing a little rewriting, and performing
  some reasoning based on the types of the arguments.  You'll often
  encounter references to system defined lemmas (like [47municity-of-0[0m).
  You can always look at those with [47m:[0m[47m[pe][0m; but, in general, assume
  that there's a lot of simplification power under the hood that's
  not too important to understand fully.

  The inductive case ([47mSubgoal *1/1[0m) is also dispatched pretty easily.
  Here we assume the conjecture true for the [47m[cdr][0m of the list and
  try to prove it for the entire list.  Notice that the prover does
  some simplification and then prints out an updated version of the
  goal ([47mSubgoal *1/1'[0m).  Examining these gives you a pretty good idea
  of what's going on in the proof.

  Sometimes one goal is split into a number of subgoals, as happened
  with the induction above.  Sometimes after some initial processing
  the prover decides it needs to prove a subgoal by induction; this
  subgoal is given a name and pushed onto a stack of goals.  Some
  steps, like generalization (see ACLH), are not necessarily validity
  preserving; that is, the system may adopt a false subgoal while
  trying to prove a true one.  (Note that this is ok in the sense
  that it is not ``unsound.'' The system will fail in its attempt to
  establish the false subgoal and the main proof attempt will fail.)
  As you gain facility with using the prover, you'll get pretty good
  at recognizing what to look for when reading a proof script.  The
  prover's [proof-tree] utility helps with monitoring an ongoing
  proof and jumping to designated locations in the proof (see
  [proof-tree]).  See [tips] for a number of useful pointers on using
  the theorem prover effectively.

  When the prover has successfully proved all subgoals, the proof is
  finished.  As with a [47m[defun][0m, a [summary] of the proof is printed.
  This was an extremely simple proof, needing no additional guidance.
  More realistic examples typically require the user to look
  carefully at the failed proof log to find ways to influence the
  prover to do better on its next attempt.  This means either:
  proving some rules that will then be available to the prover,
  changing the global state in ways that will affect the proof, or
  providing some [hints] locally that will influence the prover's
  behavior.  Proving this lemma ([47mmy-app-length[0m) is an example of the
  first.  Since this is a [rewrite] rule, whenever in a later proof
  an instance of the form [47m(LEN (MY-APP X Y))[0m is encountered, it will
  be rewritten to the corresponding instance of [47m(+ (LEN X) (LEN Y))[0m.
  Disabling the rule by executing the [command]

    (in-theory (disable my-app-length)),

  is an example of a global change to the behavior of the prover since
  this [rewrite] will not be performed subsequently (unless the rule
  is again [enable]d).  Finally, we can add a (local) [disable]
  ``hint'' to a [47m[defthm][0m, meaning to [disable] the lemma only in the
  proof of one or more subgoals.  For example:

    (defthm my-app-length-commutativity
      (equal (len (my-app x y))
             (len (my-app y x)))
      :hints ((\"Goal\" :in-theory (disable my-app-length))))

  In this case, the hint supplied is a bad idea since the proof is much
  harder with the hint than without it.  Try it both ways.

  By the way, to undo the previous event use [47m:u[0m (see [u]).  To undo
  back to some earlier event use [47m:ubt[0m (see [ubt]).  To view the
  current event use [47m:pe :here[0m.  To list several [events] use [47m:pbt[0m
  (see [pbt]).

  Notice the form of the hint in the previous example (see [hints]).
  It specifies a goal to which the hint applies.  [47m\"Goal\"[0m refers to
  the top-level goal of the theorem.  Subgoals are given unique names
  as they are generated.  It may be useful to suggest that a function
  symbol be [disable]d only for Subgoal 1.3.9, say, and a different
  function [enable]d only on Subgoal 5.2.8.  Overuse of such [hints]
  often suggests a poor global proof strategy.

  We now recommend that you visit [documentation] on additional
  examples.  See [annotated-ACL2-scripts].")
 (ALWAYS$ (POINTERS) "See [loop$].")
 (ALWAYS$+ (POINTERS) "See [loop$].")
 (ANALYZING_COMMON_LISP_MODELS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "Analyzing Common Lisp Models

  To analyze a model you must be able to reason about the operations
  and relations involved.  Perhaps, for example, some aspect of the
  model depends upon the fact that the concatenation operation is
  associative.

  In any Common Lisp you can confirm that

    (app '(A B) (app '(C D) '(E F)))

  and

    (app (app '(A B) '(C D)) '(E F)))

  both evaluate to the same thing, [47m(A B C D E F)[0m.

  But what distinguishes ACL2 (the logic) from applicative Common Lisp
  (the language) is that in ACL2 you can [31;1mprove[0m that the concatenation
  function [47mapp[0m is associative when its arguments are true-lists,
  whereas in Common Lisp all you can do is test that proposition.

  That is, in ACL2 it makes sense to say that the following formula is
  a ``theorem.''

    [31;1mTheorem[0m Associativity of App
    (implies (and (true-listp a)
                  (true-listp b))
             (equal (app (app a b) c)
                    (app a (app b c))))

  Theorems about the properties of models are proved by symbolically
  manipulating the operations and relations involved.  If the
  concatenation of sequences is involved in your model, then you may
  well need the theorem above in order to that your model has some
  particular property.")
 (AND
  (BASICS ACL2-BUILT-INS)
  "Conjunction

  [47mAnd[0m is the macro for conjunctions.  [47mAnd[0m takes any number of
  arguments.  [47mAnd[0m returns [47mnil[0m if one of the arguments is [47mnil[0m, but
  otherwise returns the last argument.  If there are no arguments,
  [47mand[0m returns [47mt[0m.

  [47mAnd[0m is a Common Lisp macro.  See any Common Lisp documentation for
  more information.

  [31;1mMacro: [0m<and>

    (defmacro and (&rest args)
      (and-macro args))

  [31;1mFunction: [0m<and-macro>

    (defun and-macro (lst)
      (declare (xargs :guard t))
      (if (consp lst)
          (if (consp (cdr lst))
              (list 'if
                    (car lst)
                    (and-macro (cdr lst))
                    nil)
            (car lst))
        t))")
 (ANNOTATED-ACL2-SCRIPTS
  (ACL2-TUTORIAL)
  "Examples of ACL2 scripts

  Beginning users may find these annotated scripts useful.  We suggest
  that you read these in the following order:

    [Tutorial1-Towers-of-Hanoi]
    [Tutorial2-Eights-Problem]
    [Tutorial3-Phonebook-Example]
    [Tutorial4-Defun-Sk-Example]
    [Tutorial5-Miscellaneous-Examples]

  You can also find useful demos in the [community-books] directory,
  [47mbooks/demos/[0m, and its subdirectories.

  The web page {Brief ACL2 Tutorial |
  http://www.cs.utexas.edu/users/moore/publications/tutorial/rev3.html}
  contains a script that illustrates how it feels to use The Method
  to prove an unusual list reverse function correct.  The screen
  shots of ACL2's proof output are outdated --- in the version shown,
  ACL2 does not print Key Checkpoints, but the concept of key
  checkpoint is clear in the discussion and the behavior of the user.

  See {Polishing Proofs Tutorial |
  http://www.cs.utexas.edu/users/moore/acl2/contrib/POLISHING-PROOFS-TUTORIAL.html}
  for a tutorial on becoming successful at approaching a
  formalization and proof problem in ACL2.  That tutorial, written by
  Shilpi Goel and Sandip Ray, has two parts: it illustrates how to
  guide the theorem prover to a successful proof, and it shows how to
  clean up the proof in order to facilitate maintenance and extension
  of the resulting book (see [books]).

  The {ACL2 Demo Given at TPHOLs 2008 |
  http://www.cs.utexas.edu/users/moore/publications/tutorial/kaufmann-TPHOLs08/index.html}
  by Matt Kaufmann includes scripts and a gzipped tar file containing
  the entire contents of the demos.

  The {sort equivalence demo |
  http://www.cs.utexas.edu/users/moore/publications/tutorial/sort-equivalence}
  is a collection of scripts illustrating both high-level strategy
  and lower-level tactics dealing with the functional equivalence of
  various list sorting algorithms.  Start with the [47mREADME[0m on that
  directory.  There is also a {gzipped tar file |
  http://www.cs.utexas.edu/users/moore/publications/tutorial/sort-equivalence.tgz}
  with all of these scripts.

  When you feel you have read enough examples, you might want to try
  the following very simple example on your own. (See
  [solution-to-simple-example] for a solution, after you work on this
  example.)  First define the notion of the ``fringe'' of a tree,
  where we identify trees simply as [cons] structures, with [atom]s
  at the leaves.  For example:

    ACL2 !>(fringe '((a . b) c . d))
    (A B C D)

  Next, define the notion of a ``leaf'' of a tree, i.e., a predicate
  [47mleaf-p[0m that is true of an atom if and only if that atom appears at
  the tip of the tree.  Define this notion without referencing the
  function [47mfringe[0m.  Finally, prove the following theorem, whose proof
  may well be automatic (i.e., not require any lemmas).

    (defthm leaf-p-iff-member-fringe
      (iff (leaf-p atm x)
           (member-equal atm (fringe x))))


Subtopics

  [Solution-to-simple-example]
      Solution to a simple example

  [Tutorial1-towers-of-hanoi]
      The Towers of Hanoi Example

  [Tutorial2-eights-problem]
      The Eights Problem Example

  [Tutorial3-phonebook-example]
      A Phonebook Specification

  [Tutorial4-defun-sk-example]
      Example of quantified notions

  [Tutorial5-miscellaneous-examples]
      Miscellaneous ACL2 examples")
 (AN_EXAMPLE_COMMON_LISP_FUNCTION_DEFINITION
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "An Example Common Lisp Function Definition

  {IMAGE} (see [An_Example_of_ACL2_in_Use])

  Consider the binary trees [47mx[0m and [47my[0m below.

  {IMAGE}

  In Lisp, [47mx[0m is written as the list [47m'(A B)[0m or, equivalently, as [47m'(A B .
  NIL)[0m.  Similarly, [47my[0m may be written [47m'(C D E)[0m.  Suppose we wish to
  replace the right-most tip of [47mx[0m by the entire tree [47my[0m.  This is
  denoted [47m(app x y)[0m, where [47mapp[0m stands for ``append''.

  {IMAGE}

  We can define [47mapp[0m with:

    [31;1m(defun app (x y)[0m                           [3m; Concatenate x and y.[0m
      [31;1m(declare (type (satisfies true-listp) x))[0m[3m; We expect x to end in NIL.[0m
      [31;1m(cond ((endp x) y)[0m                       [3m; If x is empty, return y.[0m
            [31;1m(t (cons (car x)[0m                   [3m; Else, copy first node[0m
                     [31;1m(app (cdr x) y)))))[0m       [3m;  and recur into next.[0m

  If you defined this function in some Common Lisp, then to run [47mapp[0m on
  the [47mx[0m and [47my[0m above you could then type

    (app '(A B) '(C D E))

  and Common Lisp will print the result [47m(A B C D E)[0m.

  {IMAGE} (see [An_Example_of_ACL2_in_Use])")
 (AN_EXAMPLE_OF_ACL2_IN_USE
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "An Example of ACL2 in Use

  {IMAGE} (see [How_To_Find_Out_about_ACL2_Functions])

  To introduce you to ACL2 we will consider the [47mapp[0m function discussed
  in the Common Lisp (see [Common_Lisp]) page, [31;1mexcept[0m we will omit
  for the moment the [31;1mdeclare[0m form, which in ACL2 is called a [31;1mguard[0m.

  Guards are arbitrary ACL2 terms that express the ``intended domain''
  of functions.  In that sense, guards are akin to type signatures.
  However, Common Lisp and ACL2 are untyped programming languages:
  while the language supports several different data types and the
  types of objects can be determined by predicates at runtime, any
  type of object may be passed to any function.  Thus, guards are
  ``extra-logical.'' Recognizing both the practical and intellectual
  value of knowing that your functions are applied to the kinds of
  objects you intend, ACL2 imposes guards on Common Lisp and provides
  a means of proving that functions are used as intended.  But the
  story is necessarily complicated and we do not recommend it to the
  new user.  Get used to the fact that any ACL2 function may be
  applied to any objects and program accordingly.  Read about guards
  later.

  Here is the definition again

    [31;1m(defun app (x y)[0m
      [31;1m(cond ((endp x) y)[0m
            [31;1m(t (cons (car x) [0m
                     [31;1m(app (cdr x) y)))))[0m

  The next few stops along the Walking Tour will show you

    * how to use the ACL2 documentation,

    * what happens when the above definition is submitted to ACL2,

    * what happens when you evaluate calls of [47mapp[0m,

    * what one simple theorem about [47mapp[0m looks like,

    * how ACL2 proves the theorem, and

    * how that theorem can be used in another proof.

  Along the way we will talk about the [31;1mdefinitional principle[0m, [31;1mtypes[0m,
  the ACL2 [31;1mread-eval-print loop[0m, and how the [31;1mtheorem prover[0m works.

  When we complete this part of the tour we will return briefly to the
  notion of [31;1mguards[0m and revisit several of the topics above in that
  context.

  {IMAGE} (see [How_To_Find_Out_about_ACL2_Functions])")
 (APPEND
  (LISTS ACL2-BUILT-INS)
  "[concatenate] zero or more lists

  [47mAppend[0m, which takes zero or more arguments, expects all the arguments
  except perhaps the last to be true ([47mnil[0m-terminated) lists.  It
  returns the result of concatenating all the elements of all the
  given lists into a single list.  Actually, in ACL2 [47mappend[0m is a
  macro that expands into calls of the binary function
  [47m[binary-append][0m if there are at least two arguments; if there is
  just one argument then the expansion is that argument; and finally,
  [47m(append)[0m expands to [47mnil[0m.

  [47mAppend[0m is a Common Lisp function.  See any Common Lisp documentation
  for more information.  See [append-without-guard] for a version of
  [47mappend[0m that has a guard of [47mt[0m.

  [31;1mMacro: [0m<append>

    (defmacro append (&rest rst)
      (cond ((null rst) nil)
            ((null (cdr rst)) (car rst))
            (t (xxxjoin 'binary-append rst))))

  [31;1mFunction: [0m<binary-append>

    (defun binary-append (x y)
      (declare (xargs :guard (true-listp x)))
      (cond ((endp x) y)
            (t (cons (car x)
                     (binary-append (cdr x) y)))))


Subtopics

  [Binary-append]
      [concatenate] two lists")
 (APPEND$ (POINTERS) "See [loop$].")
 (APPEND$+ (POINTERS) "See [loop$].")
 (APPLY$
  (ACL2-BUILT-INS PROGRAMMING)
  "Apply a badged function or tame lambda to arguments

  We recommend that you read the paper {``Limited Second-Order
  Functionality in a First-Order Setting'' |
  http://www.cs.utexas.edu/users/kaufmann/papers/apply/index.html} by
  Matt Kaufmann and J Strother Moore for both motivation and
  foundational details.  You might also read
  [introduction-to-apply$]!

  This documentation starts with a [31;1mglossary[0m of terms.  Then we provide
  some [31;1mexamples[0m and present the [31;1mspecification[0m of [47mapply$[0m.  Next, we
  deal with issues related to [47mapply$[0m in [31;1mdefinitions[0m, [31;1mstating and
  proving theorems[0m, [31;1mguards and guard verification[0m, and [31;1mtop-level
  evaluation[0m.  Finally we exhibit the [31;1mformal definitions[0m [47mapply$[0m and
  some related concepts.  We have sprinkled in a little tutorial
  material for readability but have not provided much motivation for
  some design decisions.


Glossary

  Here is a brief glossary of terms used in the semantics of [47mapply$[0m.
  While we provide links to the documentation of the concepts, we
  urge you not to follow those links until you've understood the big
  picture!

    * [47mapply$[0m --- the ACL2 function that takes two arguments, one
      representing a function and the other listing actuals to be fed
      to that function.  Under certain conditions, [47mapply$[0m applies the
      function to the arguments and returns the result.  [47mApply$[0m is
      mutually recursive with [47m[apply$-lambda][0m, [47m[ev$][0m, and [47m[ev$-list][0m.
      [47mApply$[0m's ``badge'' (see below) is [47m(APPLY$-BADGE 2 1 :FN NIL)[0m
      its arity is 2, its ``out arity'' is 1 (i.e., it returns 1
      result), its first argument has ``ilk'' [47m:FN[0m and is thus treated
      as a ``function;'' its second argument has ilk [47mNIL[0m and is thus
      treated as an ordinary object.

    * [47m[badge][0m --- an object associated with some function symbols
      indicating that [47mapply$[0m can ``handle'' them and under what
      conditions.  The badge of a function symbol specifies its
      arity, its ``out arity,'' (i.e., the number of results the
      function returns), and the [ilk] of each argument position
      telling [47mapply$[0m how each argument is treated.  The ilks are [47m:FN[0m,
      [47m:EXPR[0m and [47mNIL[0m.  The association between a non-primitive
      function symbol and its badge is managed by [47m[warrant][0ms.  In
      proofs, [47mapply$[0m must have a warrant for every non-primitive
      function symbol to be applied.  Those warrants are provided as
      hypotheses to the theorem being proved.  Symbols without badges
      cannot be [47mapply$[0md.  Badges are generated, when possible, by
      [47m[defwarrant][0m.  (Badges can be generated for [47m:[0m[47mprogram[0m mode
      functions by [47m[defbadge][0m, allowing [47mapply$[0m to handle such
      functions in top level evaluation not in proofs.)  Not every
      function symbol can have a badge.

    * compiled [47mLAMBDA[0m cache (or simply [3mcache[0m in this context) --- a cache
      in the raw Lisp under ACL2 that supports the application of
      [47mapply$[0m on well-formed, guard verified [47mLAMBDA[0m objects.  Later in
      this Glossary we define ``lambda expression,'' ``[47mLAMBDA[0m
      object,'' and ``lambda$ expression'' --- three similar looking
      phrases with very different meanings.  See [47m[print-cl-cache][0m for
      some details of the cache.

    * evaluation theory --- the logical theory in which expressions
      submitted at the top level of the ACL2 read-eval-print loop are
      evaluated.  The evaluation theory is a consistent extension of
      the proof theory, the latter being the logical theory in which
      the ACL2 theorem prover operates.  The evaluation theory was
      introduced in ACL2 when [47m[defattach][0m was added, but it was
      changed with the introduction of [47mapply$[0m.  All [47m[warrant][0ms
      introduced by [47mdefwarrant[0m are assumed true in the evaluation
      theory but not in the proof theory.  This means ACL2 can
      execute calls of [47mapply$[0m that arise in the evaluation of
      top-level input, but ACL2 cannot evaluate all calls of [47mapply$[0m
      that arise in proofs unless the appropriate warrants are
      available as hypotheses.  See
      [guarantees-of-the-top-level-loop] for some details of the
      evaluation theory and how it differs from the proof theory
      supported by the ACL2 theorem prover.

    * lambda expression --- an integral part of ACL2's formal term syntax,
      lambda expressions are the way [47mlet[0m expressions and other
      variable-binding idioms are translated into formal terms.
      Lambda expressions have nothing to do with [47mapply$[0m!  See
      [lambda] for a discussion of three confusingly similar but
      different concepts: lambda expressions, [47mLAMBDA[0m objects, and
      [47mlambda$[0m expressions.  Read carefully anytime you see the word
      ``lambda!''

    * [47mLAMBDA[0m object --- an ACL2 list constant, typically of the form
      [47m(LAMBDA vars body)[0m or [47m(LAMBDA vars dcl body)[0m that may be used
      as a ``function'' by [47mapply$[0m.  [47mApply$[0m treats any [47m[consp][0m object
      in its first argument position as though it were a [47mLAMBDA[0m
      object.  But it only gives sensible meanings to [tame] [47mLAMBDA[0m
      objects.  And only well-formed [47mLAMBDA[0m objects are executed
      efficiently.  But well-formed [47mLAMBDA[0m objects are hard to type
      by hand --- there are many constraints to keep in mind to
      guarantee well-formedness.  See [47m[well-formed-lambda-objectp][0m if
      you really want to see all the rules.  But that is generally
      unnecessary.  We [3mstrongly[0m recommend not entering [47mLAMBDA[0m objects
      as quoted constants, e.g., [47m'(LAMBDA (X) (+ 1 X))[0m --- which is
      actually ill-formed!  Instead, use [47m[lambda$][0m, as in [47m(lambda$
      (x) (+ 1 x))[0m.  See also [lambda] for some clarifications.

    * [47m[lambda$][0m expression --- an ACL2 macro that allows you to enter
      quoted well-formed [47mLAMBDA[0m objects into your terms by typing
      untranslated expressions that resemble lambda expressions.  The
      [47mlambda$[0m expression [47m(lambda$ (x) (+ 1 x))[0m essentially translates
      into the quoted [47mLAMBDA[0m object [47m'(LAMBDA (X) (BINARY-+ '1 X))[0m.
      We say ``essentially'' because [47mlambda$[0m always inserts a
      [47m(DECLARE (IGNORABLE v1 ... vn))[0m listing every formal and tags
      the body with a [47m[return-last][0m form that indicates it came from
      a translated [47mlambda$[0m. See also [lambda] for some
      clarifications.

    * [47m[scion][0m --- a function that is ancestrally dependent on [47mapply$[0m.  In
      the early days of [47mapply$[0m we called scions ``mapping functions''
      but in the Lisp community that implies iteration over a list
      and scions are more general.  Of course, a function that
      iterates over a list [47mapply$[0ming a ``function'' to each element
      and collecting the results is an example of a scion.  But so is
      function that takes a ``function'' and applies it in one
      special situation, e.g., as a test or base case.  Any function
      ancestrally dependent on [47mapply$[0m is a scion whether or not it
      takes a ``function'' as an argument or maps over a domain.

    * [tame] --- the class of functions that [47mapply$[0m knows about; we
      actually talk about ``tame functions,'' ``tame [47mLAMBDA[0m
      objects,'' and ``tame expressions.'' The last are expressions
      that are evaluable by an interpreter named [47m[ev$][0m that is
      mutually-recursive with [47mapply$[0m.  [47mApply$[0m cannot handle all
      definable functions: ACL2 is first order and if [47mapply$[0m were
      able to ``handle'' certain functions the logic would be
      inconsistent.

    * [47m[warrant][0m --- a 0-ary predicate associated with some user-defined
      function symbols that must be a hypothesis of any theorem whose
      proof involves ``expanding'' [47mapply$[0m on such symbols; the
      warrant gives [47mapply$[0m ``permission'' to expand if the arguments
      to which the function is applied are appropriately [tame].  The
      warrant for a function specifies the function's [47m[badge][0m and how
      [47mapply$[0m behaves on the function symbol.  Warrants (and badges)
      are computed and introduced by the [47m[defwarrant][0m event.  Not all
      function symbols can be warranted.

  You will get a much better understanding of these concepts if you
  read the paper cited above.


Examples

  To illustrate [47mapply$[0m and some related concepts we need some
  user-defined functions.  We therefore imagine that the following
  events have been successfully admitted.

  [31;1mWe strongly recommend that you include the following book in any
  session in which you intend to use or reason about [47mapply$[0m[31;1m.[0m

    (include-book \"projects/apply/top\" :dir :system)

    (defun$ sq (x) (* x x))

    (defun$ collect$ (fn lst)
      (if (endp lst)
          nil
          (cons (apply$ fn (list (car lst)))
                (collect$ fn (cdr lst)))))

    (defun$ foldr (lst fn init)
      (if (endp lst)
          init
          (apply$ fn
                  (list (car lst)
                        (foldr (cdr lst) fn init)))))

    (defun$ russell (fn x)
      (not (apply$ fn (list x x))))

  Note: [47mCollect$[0m is pre-defined in ACL2 because it is part of the
  support for the [47m[loop$][0m statement.

  [47mCollect$[0m and [47mfoldr[0m might informally be called ``mapping functions''
  because they map a given function over some domain and accumulate
  the answers somehow.  They are useful examples of what we call
  [3mscions of[0m [47mapply$[0m or simply [3mscions[0m: functions in which [47mapply$[0m is
  ancestral, i.e., functions that call [47mapply$[0m or call functions that
  call [47mapply$[0m, etc.  [47mRussell[0m is also a scion.  See [scion] for more.

  Here are some evaluations carried out at the top-level of the ACL2
  loop after the events above.  Top-level evaluations take place in
  ACL2's evaluation theory (see the discussion of the semantics of
  [47m[defattach][0m), which is an extension of the theory in which proofs
  are conducted.  Put more bluntly, the following evaluations won't
  be carried out in proofs unless you have the right hypotheses!

    ACL2 !>(apply$ 'sq '(5))
    25

    ACL2 !>(collect$ 'sq '(1 2 3 4 5))
    (1 4 9 16 25)

    ACL2 !>(collect$ (lambda$ (x) (* x x)) '(1 2 3 4 5))
    (1 4 9 16 25)

    ACL2 !>(foldr '(1 2 3) 'cons '(4 5 6))
    (1 2 3 4 5 6)

    ACL2 !>(foldr '(1 2 3 4 5)
                  (lambda$ (x y)
                    (cons (sq x) y))
                  nil)
    (1 4 9 16 25)

    ACL2 !>(foldr '(1 2 3 4)
                  (lambda$ (x y) (foldr y 'cons (list x)))
                  nil)
    (4 3 2 1)

    ACL2 !>(russell 'natp 3)
    NIL

    ACL2 !>(russell 'consp 3)
    T

  [47mApply$[0m doesn't always work the way you might want!

    ACL2 !>(let ((x 'russell))(russell x x))

    ACL2 Error in TOP-LEVEL:  The value of APPLY$-USERFN is not specified when
    the first argument, fn, is RUSSELL, and the second argument, args,
    is (RUSSELL RUSSELL).  Fn has badge (APPLY$-BADGE 2 1 :FN NIL) and
    args is not known to satisfy the tameness requirement of that badge.

  [47m[Apply$-userfn][0m is the undefined function called by [47mapply$[0m when it
  is asked to apply a user-defined function symbol instead of a
  builtin function symbol.  The [47m[warrant][0m for [47mrussell[0m actually
  specifies the value of [47m(apply$-userfn 'russell ...)[0m under the
  [47m[tame][0mness requirements, and those requirements are violated above.
  This is necessary to preserve the consistency of the logic.
  Otherwise:

    (russell 'russell 'russell)
    = {by defun of russell}
    (not (apply$ 'russell (list 'russell 'russell)))
    =  {by the naive expectation that apply$ always ``works''}
    (not (russell 'russell 'russell))
    Contradiction!

  Top-level evaluation of [47mapply$[0m expressions raises problems not seen
  anywhere else in ACL2's execution model: While executing
  syntactically legal terms the evaluator can encounter undefined
  functions or weirdly ill-formed terms not caught by the usual ACL2
  translation mechanism.  The ACL2 translation mechanism checks the
  well-formedness of [47m[lambda$][0m expressions (and user-typed quoted
  [47mLAMBDA[0m objects) that occur in positions of ilk [47m:FN[0m and are
  therefore destined for [47mapply$[0m.  But the translation checks can be
  defeated.  The [47mLAMBDA[0m object below contains a call of the undefined
  function [47mfoo[0m but the error is not caught at translation time; it is
  caught only when the form executed.

    ACL2 !>(apply$ `(lambda (x) (foo x)) '(5))

    ACL2 Error in TOP-LEVEL:  The value of BADGE-USERFN is not specified
    on FOO because FOO is not a known function symbol.

  Note the [3mbackquote[0m on the [47mLAMBDA[0m object.  This defeats the check of
  well-formedness because the [47mLAMBDA[0m object is not [47mquote[0md.  We could
  have equally written

    ACL2 !>(apply$ (list 'lambda '(x) (cons 'foo '(x))) '(5))

  with the same result.  There is nothing unsound about this.  [47mApply$[0m
  can take any objects as arguments.  But it won't always ``behave''
  as you might expect.  One way to explore the edge cases of [47mapply$[0m
  is to execute it on ill-formed input.  In addition, some theorems
  may require consing up a [47mLAMBDA[0m object in terms of objects used
  elsewhere in the theorem.  See example theorem [47m[3][0m below.

  A peculiar aspect of [47mLAMBDA[0m objects is that they can be written as
  legal ACL2 constants [3mbefore[0m they are well-formed [47mLAMBDA[0m objects,
  e.g., by referring to undefined functions, [47m:program[0m mode functions,
  unbadged functions, etc.  They are, after all, just arbitrary
  quoted objects and any value in ACL2 can be quoted.  But an
  ill-formed object can [3mbecome[0m well-formed if the world is
  appropriately extended, e.g., the appropriate [47mdefun[0ms, [47mdefbadge[0ms,
  and [47mdefwarrant[0ms are made.  Perhaps worse, they can be well-formed
  and then [3mbecome[0m ill-formed by an undo.  So at runtime [47mapply$[0m has to
  check that the function symbol or [47mLAMBDA[0m object is appropriate.
  There is a sophisticated cache behind the execution machinery for
  [47mLAMBDA[0m objects in the evaluation theory.  See [47m[print-cl-cache][0m.

  Here are some theorems that can be proved about these concepts.  The
  last of the theorems shown below requires two lemmas, named
  [47mweird-little-lemma1[0m and [47mweird-little-lemma2[0m, shown in
  [47mbooks/projects/apply/report.lisp[0m.

  For a summary of how the rewriter handles [47mapply$[0m, [47mev$[0m, and [47mloop$[0m
  [scion]s, see [rewriting-calls-of-apply$-ev$-and-loop$-scions].

    ; [1] SQ squares, if you have the warrant for sq!  Imagine for a moment that
    ; we could prove (equal (apply$ 'SQ (list i)) (* i i)) without the warrant
    ; hypothesis shown below.  And imagine that we did so in an encapsulated
    ; environment in which sq was locally defined to be (* x x).  Then imagine we
    ; exported the simpler theorem out of that encapsulate and defined sq to be
    ; (+ 1 (* x x)).  Then ACL2 would be unsound.  Exporting a theorem requires
    ; that the theorem be ancestrally independent of every locally defined
    ; function and the simpler hypothetical theorem is, because the symbol 'SQ is
    ; not ancestrally dependent on sq.  But ACL2 cannot prove the simpler
    ; theorem!  It cannot ``open'' apply$ on 'SQ without the warrant for sq and
    ; the warrant for sq is ancestrally dependent on sq.  So the theorem below
    ; cannot be exported from an environment in which sq is locally defined.
    ; Thus warrants solve the so-called ``LOCAL problem.''

    (thm (implies (warrant sq)
                  (equal (apply$ 'SQ (list i))
                         (* i i))))

    ; [2] Collect$ distributes over append for any fn.

    (thm (equal (collect$ fn (append a b))
                (append (collect$ fn a)
                        (collect$ fn b))))

    ; [3] Foldr can be used to collect$, but the collection must
    ; be with an ``ok'' function (a tame function of one
    ; argument).  Note the backquote on the LAMBDA.  This is
    ; a theorem that requires us to cons up a LAMBDA object.

    (thm (implies (ok-fnp fn)
                  (equal (foldr lst
                                `(LAMBDA (X Y) (CONS (,fn X) Y))
                                nil)
                         (collect$ fn lst))))


Specification of APPLY$

  [31;1mWe strongly recommend that you include the following book in any
  session in which you intend to use or reason about [47mapply$[0m[31;1m.[0m

    (include-book \"projects/apply/top\" :dir :system)

    General Form:
    (apply$ fn args)

  where [47mfn[0m is some function symbol or [47mLAMBDA[0m object and [47margs[0m is a true
  list.  Informally, [47mapply$[0m applies the function named by the first
  argument to the appropriate number of elements taken from the
  second argument.  We might express this as:

    [31;1mNaive Specification (for a single-valued function):[0m
    (apply$ 'fn args) = (fn (nth 0 args) ... (nth (- n 1) args))

    [31;1mNaive Specification (for a multi-valued function):[0m
    (apply$ 'fn args) = (mv-list k (fn (nth 0 args) ... (nth (- n 1) args)))

  where [47mfn[0m is of arity [47mn[0m and [47mk[0m is the ``out arity'' of [47mfn[0m (the number
  of returned values).  [31;1mHowever[0m, these naive specifications are
  guaranteed only if either (i) [47mfn[0m is a function symbol that has a
  [47m[badge][0m and [47margs[0m satisfies the [tame]ness requirements of the
  badge, or (ii) [47mfn[0m is a well-formed [47mLAMBDA[0m object that returns 1
  result.  The tameness requirement is that if an element of [47margs[0m is
  in an argument position of [47mfn[0m with ilk [47m:FN[0m then the element must
  satisfy [47mtamep-functionp[0m and if the element is in an argument
  position of ilk [47m:EXPR[0m it must satisfy [47mtamep[0m.  See [47m[badge][0m for
  further discussion of condition (i).  As for (ii), rather than
  explain ``well-formed [47mLAMBDA[0m object'' here we encourage you to
  write [47m[lambda$][0m expressions when you want to [47mapply$[0m a [47mLAMBDA[0m
  object.

  The [ilk]s of [47mapply$[0m are [47m:FN[0m and [47mNIL[0m respectively, telling us that
  [47mapply$[0m treats its first argument as a ``function'' and its second
  as an ordinary object (never as a function).  Initially [47mapply$[0m and
  several functions used in the translation of [47mloop$[0m statements are
  the only symbols in ACL2 with an ilk of [47m:FN[0m.  However as
  [47m[defwarrant][0m is used successfully on [scion]s --- functions that
  somehow call [47mapply$[0m --- user-defined symbols can have ilk [47m:FN[0m too.

  [47mApply$[0m has a guard, namely [47m(apply$-guard fn args)[0m.  This is an
  exceptionally weak guard, requiring only that [47margs[0m be a true-list
  and, if [47mfn[0m is a cons --- which is automatically treated as a [47mLAMBDA[0m
  object --- the length of [47margs[0m be the length of the second element
  of [47mfn[0m.  We discuss [31;1mguards and guard verification[0m in a subsequent
  section.

  [31;1mNote for Experts[0m: Technically, [47mapply$[0m treats any [47mconsp[0m object as a
  [47mLAMBDA[0m object.  But the results are as you'd naively expect only if
  the object is a [tame] [47mLAMBDA[0m object.  However, we frequently write
  as though the object must be [3mwell-formed[0m, which is different from
  but implies tameness.  What's going on?  The reason for this and
  related discrepancies in the documentation is that there is a
  tension between the logical definition of [47mapply$[0m and the practical
  business of executing it.  The former involves the existence of a
  model, soundness, and the difficulty of proving theorems about
  [47mapply$[0m.  The latter involves the Common Lisp compiler.  We want the
  logical foundations to be simple to make it easier to reason about
  [47mapply$[0m, but the compiler imposes unavoidable and complicated
  restrictions.  The upshot is that the logical foundations assign
  meaning to [47mLAMBDA[0m objects that cannot be compiled.  Applying merely
  ``tame'' [47mLAMBDA[0ms is slower than applying ``well-formed'' ones.  In
  a sense, by acting like ``tame [47mLAMBDA[0m objects'' and ``well-formed
  [47mLAMBDA[0m objects'' are synonymous we're trying to trick you!  If you
  ever have occasion to formally express the restrictions on [47mapply$[0m
  in some theorem, use [47mtamep-functionp[0m.  But when you write concrete
  [47mLAMBDA[0m constants, try to keep them well-formed.  We encourage this
  by providing [47m[lambda$][0m and by enforcing full blown well-formedness
  checks --- not just tameness checks --- in translate on every
  quoted [47mLAMBDA[0m object entered in a [47m:FN[0m slot.  And we give you ways
  to circumvent these checks --- see
  [gratuitous-lambda-object-restrictions] --- if you really mean to
  supply ill-formed [47mLAMBDA[0m objects to [47m:FN[0m slots.

  Badges are assigned by [47m[defwarrant][0m, and also by [47m[defbadge][0m.  See
  [47m[badge][0m for documentation about how to find out whether a function
  has a badge and how to interpret a badge.  The terms ``out arity''
  and ``tameness requirements,'' used above, are explained there too.

  Intuitively, the badge of [47mfn[0m tells [47mapply$[0m how each formal of [47mfn[0m is
  used in the definition of [47mfn[0m and there are only three ``ilks'' of
  use.  Ilk [47m:FN[0m means the formal is used exclusively as a function,
  meaning the formal can be passed into [47m:FN[0m slots of other functions
  and eventually reaches [47mapply$[0m, but it is never touched by other
  ACL2 functions.  Ilk [47m:EXPR[0m means the formal is used exclusively as
  an expression, meaning the formal may be passed into [47m:EXPR[0m slots of
  other functions and eventually reaches [47m[ev$][0m, but is never
  otherwise touched.  Finally, ilk [47mNIL[0m means the formal is treated as
  an ordinary ACL2 object and, in particular, never used as either a
  function or an expression.  The ``tameness requirement'' on each
  actual is determined by the ilk of the corresponding formal:
  actuals in [47m:FN[0m slots must satisfy [47mtamep-functionp[0m, actuals in [47m:EXPR[0m
  slots must satisfy [47mtamep[0m, and there are no requirements on actuals
  in ilk [47mNIL[0m slots.  For discussions of [47mtamep-functionp[0m and [47mtamep[0m see
  the topic [tame].

  Generally speaking, if you want to be able to [47mapply$[0m a function you
  should introduce it with [47m[defun][0m and then call [47m[defwarrant][0m on the
  function name, or use [47m[defun$][0m, which is a convenient abbreviation
  for the above sequence of events.  But [47mdefun$[0m only works for [47m:logic[0m
  mode functions because [47mdefwarrant[0m enforces that restriction.  If
  you want to [47mapply$[0m a [47m:program[0m mode function you should define it
  with [47mdefun[0m and then call [47mdefbadge[0m on its name.

  We summarize the specification of [47mapply$[0m with an example.  Consider

    (apply$ 'foldr
            '((1 2 3)     ; actual 1
              cons        ; actual 2
              (4 5 6)))   ; actual 3

  The badge of [47mfoldr[0m, computed by [47m(badge 'foldr)[0m, is [47m(APPLY$-BADGE 3 1
  NIL :FN NIL)[0m.  The arity is [47m3[0m, the out arity is 1 ([47mfoldr[0m is
  single-valued) and the ilks list is [47m(NIL :FN NIL)[0m.  Thus the first
  and third formals have ilk [47mNIL[0m and are treated as ordinary objects;
  the second formal has ilk [47m:FN[0m and is treated as a function.  Thus,
  the tameness requirement is that the second actual to a call of
  [47mfoldr[0m must satisfy [47mtamep-functionp[0m.  Referring to the specification
  above, we see that the [47mapply$[0m term has the ``naive specification''
  since [47mfoldr[0m has a badge, its out arity is 1, and its second actual,
  [47mcons[0m, satisfies [47mtamep-functionp[0m. That is,

    (apply$ 'foldr
            '((1 2 3)     ; actual 1
              cons        ; actual 2
              (4 5 6)))   ; actual 3
    =
    (foldr '(1 2 3) 'cons '(4 5 6))
    =
    '(1 2 3 4 5 6)

  The first equation above is just the naive specification of [47mapply$[0m
  and the second equation is just the definition of [47mfoldr[0m.

  Formals are classified by [47m[defwarrant][0m when it tries to compute the
  badge of a function.  What are the rules that lead to a formal
  being assigned ilk [47m:FN[0m, for example?  What does ilk [47m:FN[0m actually
  signify?

  Let [3mv[0m be the [3mi [0mth formal parameter of a badged function [3mfn[0m.  If the
  badge says that [3mv[0m has ilk [47m:FN[0m then we know that [3mv [0m is ``used as a
  function'' in the definition of [3mfn [0m, i.e., the value of [3mv [0m
  eventually makes its way into the first argument of [47mapply$[0m.
  Furthermore, [3mv [0m is never used any other way: every place [3mv [0m occurs
  in the body it is treated as a function.  And finally, in every
  recursive call of [3mfn [0m [3mv [0m is passed identically in the [3mi [0mth argument
  position of every recursive call.

  If the badge says that formal variable [3mv [0m has ilk [47m:EXPR[0m then it
  signifies analogous conditions except that instead of eventually
  getting into the first argument of [47mapply$[0m it eventually gets into
  the first argument of [47mev$[0m.  We say such formals are ``used as
  expressions.'' [47m[Ev$][0m is the natural notion of evaluation in this
  context: look up the values of variables in the alist argument to
  [47mev$[0m, return quoted constants, and otherwise [47mapply$[0m function symbols
  and [47mlambda[0m objects to the recursively obtained list of values
  returned by evaluating the actuals.  However, [47mev$[0m first checks that
  the expression is [47m[tamep][0m.

  If the badge says a formal [3mv [0m has ilk [47mNIL[0m in the definition of [3mfn [0m
  then [3mv [0m is [3mnever used [0m as a function or as an expression in the
  definition.

  It is the job of [47m[defwarrant][0m to analyze a definition and assign
  ilks, if possible.  But it may not be possible!  For example,

    (defun foo (x) (apply$ x (list x)))

  is such a definition.  The formal [47mx[0m is used as a function in its
  first occurrence but is not used as a function in its second.  Thus

    (defwarrant foo)

  will fail.

  When successful, [47m[defwarrant][0m also defines the [47m[warrant][0m function for
  the function it analyzed.  Warrants are crucial to stating and
  proving theorems about function symbols being applied with [47mapply$[0m.
  We illustrated warrants in the ``Examples'' section above and
  discuss them further in the section on ``Theorems Involving
  [47mApply$[0m'' below.  See also [47m[warrant][0m.

  [47mApply$[0m is a defined function in the ACL2 source code.  We exhibit its
  definition at the end of this documentation but you may also see
  its definition by doing

    ACL2 !>:pe apply$

  The definition is mutually recursive with

    * [47m[apply$-lambda][0m: used by [47mapply$[0m to handle the case when the first
      argument to [47mapply$[0m is a [47mLAMBDA[0m object.

    * [47m[ev$][0m: used by [47mapply$-lambda[0m to evaluate the body of a [47mLAMBDA[0m object
      in an environment binding the object's formal variables to the
      actuals.

    * [47m[ev$-list][0m: used by [47mev$[0m to evaluate a list of expressions in an
      environment binding formals to actuals.

  [47mApply$[0m calls three undefined functions:

    * [47m[apply$-userfn][0m: used by [47mapply$[0m when it is asked to apply anything
      other than a [47mLAMBDA[0m object or a built-in function symbol.  In
      the evaluation theory, we attach a function to [47mapply$-userfn[0m
      that explicitly enforces the tameness requirements for each
      user-defined [47m:logic[0m mode function symbol that has had a badge
      computed by [47m[defwarrant][0m and, if those requirements are met,
      applies the corresponding function.  Magically, that attachment
      to [47mapply$-userfn[0m can also evaluate [47m:program[0m mode functions with
      badges created by [47m[defbadge][0m.  We say ``magically'' because
      there are no axioms that explain this behavior, just as there
      are no axioms that explain how you can evaluate ordinary calls
      of [47m:program[0m mode functions in the evaluation theory.  But in
      the proof theory [47mapply$-userfn[0m remains undefined.  The value of
      [47m(apply$-userfn 'fn ...)[0m, and thus of [47m(apply$ 'fn ...)[0m, is
      specified by a special hypothesis, called the ``warrant for
      [47mfn[0m.'' You can't prove anything interesting about the behavior
      of [47mapply$[0m on a user-defined function symbol [47mfn[0m unless the
      warrant for [47mfn[0m is a governing hypothesis.  We discuss warrants
      in [47m[warrant][0m.  See also [47m[defwarrant][0m.

    * [47muntame-apply$[0m: used by [47mapply$[0m when it is asked to deal with a
      situation in which tameness is violated.

    * [47muntame-ev$[0m: used by [47mev$[0m when it is asked to deal with a situation in
      which tameness is violated.


Definitions Involving on [47mApply$[0m

  In one sense, [47mapply$[0m is just an ordinary ACL2 function that takes two
  arguments and returns one result.  Like all ACL2 functions, [47mapply$[0m
  is untyped.  You can supply any two objects as arguments and the
  axioms tell you what the result is --- though sometimes the result
  is delivered by an undefined function.

  But in a deeper sense, if you want [47mapply$[0m to ``behave,'' and in
  particular if you want functions that use [47mapply$[0m to ``behave,'' you
  have to follow certain rules.  For example, ACL2 must be able to
  determine whether a formal parameter is ``used as a function'' in a
  given definition.  Basically, you will want every [47m:logic[0m mode
  function that you define to be processed by [47mdefwarrant[0m so that it
  gets a badge and warrant if at all possible and at least has a
  chance of being applied as expected by [47mapply$[0m.

  The macro [47mdefun$[0m is just an abbreviation for a [47mdefun[0m followed by a
  [47mdefwarrant[0m and it is easy to imagine the other ACL2 definitional
  idioms introduced in the ACL2 Community Books eventually being
  extended to include a subsequent [47mdefwarrant[0m.

  So the question becomes ``What rules must a [47mdefun[0m obey in order to be
  processed successfully by [47mdefwarrant[0m?'' The full answer is given in
  the documentation for [47m[defwarrant][0m.  But here are some guidelines
  to follow:

    * use [47m:logic[0m mode,

    * use a measure that either returns a natural number or a lexicographic
      combination of natural numbers as defined by the [47mllist[0m function
      in the Community Books at [47mbooks/ordinals/[0m,

    * make sure every function used in the definition has a badge,

    * ensure that every [47m:FN[0m slot in the body is occupied either by a formal
      parameter or a quoted, badged function symbol or [47m[lambda$][0m
      expression, and

    * ensure that no parameter occupying a [47m:FN[0m slot is ever used in a slot
      of any other ilk, and

    * ensure that every parameter passed into a [47m:FN[0m slot is passed into the
      same argument position in any recursive calls of the function
      being defined.

  You can certainly violate some of these rules and still get an
  admissible definition.  For example [47m(defun rus (x) (not (apply$ x
  (list x))))[0m is admissible and you can run it on some arguments,
  e.g., [47m(rus 'consp)[0m evaluates to [47mT[0m.  You can even prove [47m(equal (rus
  'consp) t)[0m.  But [47m(defwarrant rus)[0m fails because [47mrus[0m violates the
  rules.  So you will not be able to [47mapply$[0m [47m'rus[0m.

  [31;1mNote for Experts[0m: One may wonder why it is possible to warrant a
  function, [47mfn[0m, that calls badged but unwarranted functions.  Naively
  one might expect the semantics of [47m(apply$ 'fn args[0m would involve
  the [47mev$[0m of the body of [47mfn[0m and therefore require the successful
  application (via [47mapply$[0m) of subfunctions in the body.  But that
  expectation is incorrect.  The semantics of [47m(apply$ 'fn args)[0m as
  formalized by the warrant for [47mfn[0m says that (under restrictions on
  the tameness of the arguments) [47m(apply$ 'fn args)[0m is [47m(fn (car args)
  (cadr args) ...)[0m.


Theorems Involving [47mApply$[0m

  Because [47mapply$[0m is undefined on user-defined function symbols and
  warrant hypotheses specify the tameness requirements and value of
  [47mapply$[0m on such symbols, you can't prove much about the application
  of particular user-defined symbols unless you provide the
  corresponding warrants as hypotheses.

  To emphasize this point, suppose [47msq[0m has been introduced with [47mdefun$[0m
  as shown above, then the following top-level evaluation is
  possible:

    ACL2 !>(apply$ 'sq '(5))
    25

  You might expect to be able to prove the obvious little theorem

    (thm (equal (apply$ 'sq '(5)) 25))

  However, you would be wrong!  While ACL2's evaluation theory assumes
  all warrants, the proof theory does not.  (If it did we could
  suffer the [47mLOCAL[0m problem mentioned in example theorem [47m[1][0m above and
  in [introduction-to-apply$].)  Logically, there is no connection
  between the symbol [47m'SQ[0m and the user-defined function [47msq[0m.  That
  connection is established by warrant.  All the necessary warrants
  must be explicitly provided as hypotheses by the user.

  The warranted version of the little theorem above is easily proved.

    (thm (implies (warrant sq) (equal (apply$ 'sq '(5)) 25)))

  Here [47m(warrant sq)[0m is just an abbreviation for a call of the 0-ary
  function symbol [47mapply$-warrant-sq[0m which is the name of the warrant
  for [47msq[0m.  [47mApply$-warrant-sq[0m is introduced when [47m(defwarrant sq)[0m
  completes successfully.  In particular, the following is a theorem:

      (warrant sq)
    <-->
      (force (apply$-warrant-sq))
    <-->
      (((badge 'SQ) = '(APPLY$-BADGE 1 1 . T))
       &
       ((apply$ 'SQ args) = (sq (car args))))

  Note that the [47m[warrant][0m macro [47m[force][0ms the warrants for the functions
  listed.  But logically [47mforce[0m is just the identity.

  Thus, the warrant for [47msq[0m specifies the value of [47m(badge 'sq)[0m and of
  [47m(apply$ 'sq ...)[0m.  Operationally, by forcing the warrant it means
  the absence of a warrant among the hypotheses of a conjecture which
  is otherwise provable just results in a forcing round that
  highlights the need for the warrant.

  If you try to prove the unwarranted version of the little theorem
  about [47m'sq[0m it fails in a forcing round with

    [1]Goal
    (APPLY$-WARRANT-SQ)

  This is a clear indication that you forgot to provide the warrant.

  You might worry that theorems burdened by warrants are vacuously
  valid because it might be impossible to satisfy all the warrant
  hypotheses.  You needn't worry about this.  [3mThere is a model of
  [47mapply$[0m[3m and all of its scions that makes every warrant issued by
  [47mdefwarrant[0m[3m valid.[0m The proof of this is sketched in {``Limited
  Second-Order Functionality in a First-Order Setting'' |
  http://www.cs.utexas.edu/users/kaufmann/papers/apply/index.html} by
  Matt Kaufmann and J Strother Moore and fully fleshed out in the
  comment titled [47mEssay on Admitting a Model for Apply$ and the
  Functions that Use It[0m in the ACL2 source file [47mapply-raw.lisp[0m.

  So there are four lessons here:

  [31;1mLesson 1:[0m When stating theorems involving [47mapply$[0m or scions on
  concrete user-defined functions, provide as additional hypotheses
  the warrants for all user-defined functions that [47mapply$[0m will
  encounter during the proof.  This generally means you should add
  the hypothesis [47m(warrant [0m[3mfn1 fn2 ... fnk[0m[47m)[0m typically listing every
  function symbol that appears inside a quoted constant destined for
  [47mapply$[0m or [47mev$[0m in your conjecture.  In particular, you should
  include every quoted function symbol appearing in a [47m:FN[0m slot of
  [47mapply$[0m or any scion, including every function symbol appearing in
  the body of any [47mLAMBDA[0m object or [47mlambda$[0m term or any [47muntil[0m, [47mwhen[0m,
  or body expressions of [47mloop$[0ms.  (Macro expansion in [47mlambda$[0ms and
  [47mloop$[0ms may introduce function symbols not evident in the
  untranslated forms.  See [47m:[0m[47m[translam][0m and [47m:[0m[47m[trans][0m.)

  [31;1mLesson 2:[0m You need not worry that adding warrant hypotheses makes
  your theorems vacuously valid!  There is a model of [47mapply$[0m and all
  your scions in which all warrants are valid.

  [31;1mLesson 3:[0m If a proof involving [47mapply$[0m or a scion fails in a forcing
  round with a checkpoint whose conclusion is the warrant for some
  function, you should remember Lesson 1 and include the warrant for
  that function symbol in the hypotheses of your conjecture!  That
  is, if you forget to supply a warrant but your conjecture is
  otherwise provable, ACL2's checkpoints will often remind you.  (It
  is possible, in the absence of an explicit warrant hypothesis, for
  a proof to fail before the prover detects that only the warrant is
  missing.)

  [31;1mLesson 4:[0m If a proof involving [47mapply$[0m or a scion fails here are some
  things to think about.  The basic question is whether something is
  ``wrong'' with one or more function symbols supposedly handled by
  [47mapply$[0m.  You have to identify which quoted function symbols are not
  being simplified or expanded.  Typically you'll see a checkpoint
  with a term like [47m(apply$ 'fn ...)[0m or [47m(ev$ '(fn ...)  ...)[0m that you
  expect would be expanded into an actual call of [47mfn[0m.  In that case,
  [47mfn[0m is of interest.  You should realize that problems of these sorts
  can drastically slow down a proof attempt.  We have seen example
  proofs where failure to simplify an [47mapply$[0m term slowed the
  proof-attempt down by several orders of magnitude.  Here are some
  questions you should ask yourself about [47mfn[0m.

    * Is [47mfn[0m defined and in [47m:logic[0m mode?  If [47mfn[0m is in [47m:program[0m mode it is
      treated by the prover as an undefined symbol.  You should try
      to convert it [47m:logic[0m mode with [47m[verify-termination][0m.

    * Is [47mfn[0m warranted?  If not, see [47m[defwarrant][0m.  If [47mfn[0m is warranted then
      it is possible [47mfn[0m is not the problem.  Maybe the warrant for [47mfn[0m
      was not provided as a hypothesis?  Normally, missing warrant
      hypotheses are forced, but the proof might have failed for
      other reasons before the warrant for [47mfn[0m was forced.  But you
      should ask whether forcing is disabled; see [47m[force][0m.

    * If you see [47m(apply$ 'fn ...)[0m then perhaps the rewrite rule [47mAPPLY$-fn[0m
      is disabled.  That rule is the one that forces the warrant for
      [47mfn[0m and it was proved when [47mfn[0m was warranted.

    * Consider how the rewriter handles [47mapply$[0m terms, by reading
      [rewriting-calls-of-apply$-ev$-and-loop$-scions] and inspecting
      the enabled/disabled status of the runes mentioned there.

  These issues are discussed further in the documentation for
  [47m[warrant][0m.

  An unfortunate implication of the need for warrants is highlighted
  during the proofs of measure conjectures while admitting new
  definitions.  Consider

    (defun$ my-cdr (x) (cdr x))

    (defun$ my-len (x)
      (if (endp x)
          0
          (+ 1 (my-len (apply$ 'my-cdr (list x))))))

  The definition of [47mmy-len[0m fails!  The reason is that without the
  warrant for [47mmy-cdr[0m we cannot prove that the measure decreases in
  the recursion above.  Unfortunately, there is no way to provide a
  warrant in a definition.  At the moment we advise users to avoid
  the use of [47mapply$[0m --- and functions that use [47mapply$[0m --- in
  ``termination-critical'' roles.  By that we mean do not use [47mapply$[0m
  if its properties are important to proofs of your measure
  conjectures.  This is easy advice to implement in the case of
  [47mmy-len[0m, i.e., replace the recursive call above by [47m(my-len (my-cdr
  x))[0m.  However, in more sophisticated definitions, e.g., where a
  [47m[loop$][0m is being used in recursive calls and the [47mloop$[0m calls
  user-defined functions in its body, following this advice means
  replacing that [47mloop$[0ms by a recursive function.  That is unfortunate
  since the whole point of [47mloop$[0m is to avoid the introduction of such
  functions!  We hope to address this limitation in the future, e.g.,
  by making the definition of [47mmy-len[0m above be conditional on the
  warrant for [47mmy-cdr[0m.


Guards and Guard Verification

  As noted, [47mapply$[0m has a guard of [47m(apply$-guard fn args)[0m and is itself
  guard verified.  The guard is weak, basically requiring that [47mfn[0m
  either be a symbol or a [47mLAMBDA[0m object, that [47margs[0m be a true-list,
  and, when [47mfn[0m is a [47mLAMBDA[0m object, the length of the list of formals
  is equal to the length of [47margs[0m.  To verify the guards of a scion
  you must make sure these properties hold of every application of
  anything in a [47m:FN[0m slot.  Mainly you must make sure that every time
  a function object is [47mapply$[0md, it is applied to a list of the right
  length.

  Note also that [mixed-mode-functions], i.e., [47m:logic[0m mode functions
  that use [47m:program[0m mode functions in slots of [ilk] [47m:FN[0m or [47m:EXPR[0m,
  cannot be guard verified.

  But guards arise in another way in connection with [47mapply$[0m.  How does
  [47m(apply$ fn args)[0m behave when [47mfn[0m has guards?  The short answer is:
  logically speaking, [47mapply$[0m completely ignores guards.  Guards in
  ACL2 are ``extra-logical.''

  Let's define and warrant a well-guarded version of ``square'',

    (defun$ squ (n) (declare (xargs :guard (natp n))) (* n n))

  [47mSqu[0m is guard verified.  Now let's consider the little conjecture:

    (thm (implies (warrant squ) (equal (apply$ 'SQU (list x)) (* x x))))

  Do we need need to require [47m(natp x)[0m?  We would if the logical
  definition of [47mapply$[0m checked the guard of [47mfn[0m before interpreting
  it.  But it does not check.  It just behaves as specified above.
  So, regardless of whether the guard is satisfied or not, [47m(apply$
  'squ (list x))[0m naively expands (under the warrant) to [47m(squ x)[0m, from
  which the rest of the proof follows.

  However, now let's do a top-level evaluation of this [47mapply$[0m term:

    ACL2 !>(apply$ 'SQU (list 'NAN))

    ACL2 Error in TOP-LEVEL:  The guard for the function call
    (SQU N), which is (NATP N), is violated by the arguments
    in the call (SQU 'NAN).

  (Remember that ACL2's evaluation theory effectively assumes all
  warrants.)  What happened?  [47mApply$[0m expanded to [47m(SQU 'NAN)[0m and that
  caused the usual guard violation, given the default configuration
  of [47m[set-guard-checking][0m.

  A similar guard violation error is signaled if a guarded [47mLAMBDA[0m
  object is [47mapply$[0med to something violating its guard.

  But now consider

    (defun$ strange (x)
      (declare (xargs :guard t))
      (apply$ 'SQU (list x)))

  This succeeds and [47mstrange[0m is now a guard verified, warranted
  function, with a guard of [47mT[0m.  This might be surprising since (a)
  the guard of [47mstrange[0m tells us nothing about [47mx[0m, (b) [47mSQU[0m is applied
  to [47mx[0m, and (c) we know the guard of [47mSQU[0m requires its argument to be
  a [47mnatp[0m.  Guard verification ignores the guards of a quoted function
  symbol being applied by a scion.  This may be particularly
  offensive to one's intuitions when the scion is [47mapply$[0m itself,
  since the appropriate information is available.  But consider a
  call of an arbitrary user-defined scion, e.g., [47m(my-scion 'SQU x)[0m.
  To what arguments will [47mmy-scion[0m [47mapply$[0m [47mSQU[0m?  And how can the
  definition of [47mmy-scion[0m even specify what functional objects are
  acceptable in its first argument?  This is a limitation suffered by
  ACL2 that a logic with a suitably expressive type system would not
  suffer.  Our way of coping with it is to ignore the guard here and
  make sure that when [47mapply$[0m applies the function symbol executes it
  checks the guard of the symbol.

  Guard verification does not ignore guards of a quoted lambda object
  being [47mapply$[0med.  Thus, for example, while [47mstrange[0m can be guard
  verified,

    (defun$ stranger (x)
      (declare (xargs :guard t))
      (apply$ (lambda$ (e) (SQU e)) (list x)))

  cannot be guard verified, because guard verification tries to verify
  the guards of every [47mlambda[0m object in a [47m:FN[0m slot so that the [47mlambda[0m
  object can be marked as guard verified in the compiled [47mlambda[0m cache
  (see [47m[print-cl-cache][0m).  But guards of [47mlambda[0m objects must be
  verified independently of the context in which they are used.  To
  be specific, even

    (defun$ stranger (x)
      (declare (xargs :guard (natp x)))
      (apply$ (lambda$ (e) (SQU e)) (list x)))

  cannot be guard verified because the [47mlambda[0m object's guards are
  verified independently of the context.  The [47mlambda[0m object must
  carry its own guard, as in

    (defun$ stranger (x)
      (declare (xargs :guard (natp x)))
      (apply$ (lambda$ (e)
                (declare (xargs :guard (natp e)))
                (SQU e))
              (list x)))

  The last definition of stranger can be guard verified, the [47mlambda[0m
  object is so marked in the cache and compiled, and if that [47mlambda[0m
  object is used in any other context it is recognized as being guard
  verified.  The guard for that [47mlambda[0m is checked when the object is
  [47mapply$[0med but if the check approves then the body of the [47mlambda[0m is
  executed as compiled code without further guard checking.

  While [47mapply$[0m is not evident in a [47m[loop$][0m statement like

    (loop$ for e in lst collect (SQU e))

  similar treatment is given.  In particular, the [47mloop$[0m above cannot be
  guard verified but

    (loop$ for e in lst collect :guard (natp e) (SQU e))

  can be and is compiled into a Common Lisp [47mloop[0m.  Recall also from the
  [47m[loop$][0m documentation that the formal semantics of the above
  statement is essentially

    (collect$ (lambda$ (e)
                (declare (xargs :guard (natp e)))
                (SQU e))
              lst)

  so guard verification of the [47mloop$[0m also compiles and marks that
  [47mlambda[0m expression as guard verified.

  So now let's return to consideration of

    (defun$ strange (x)
      (declare (xargs :guard t))
      (apply$ 'SQU (list x)))

  which we've seen is guard verified despite the fact that [47mSQU[0m expects
  a natural number and will not necessarily be given one.  What
  happens when we call [47mstrange[0m on a non-natural?

    ACL2 !>(strange 'NAN)

    ACL2 Error in TOP-LEVEL:  The guard for the function call (SQU N),
    which is (NATP N), is violated by the arguments in the call (SQU 'NAN).

    ACL2 !>:q

    Exiting the ACL2 read-eval-print loop.  To re-enter, execute (LP).
    ? (strange 'nan)

    ACL2 Error in ACL2-INTERFACE:  The guard for the function call (SQU N),
    which is (NATP N), is violated by the arguments in the call (SQU 'NAN).

  We see that we can provoke a guard violation with [47mstrange[0m even though
  it is guard verified with a guard of [47mT[0m.  Furthermore, we get the
  error both in the ACL2 read-eval-print loop and in the raw Lisp
  under ACL2.  (Be careful though about exiting the ACL2 loop; see
  [q].)

  This might at first violate your understanding of the link between
  ACL2 and Common Lisp.  Naively, a guard verified ACL2 function with
  a guard of [47mT[0m never causes a runtime error in Common Lisp.  But
  that's not quite what the guarantee is.  Such a function will never
  cause a hard Lisp error, other than possibly resource errors like
  running out of memory or stack space.  Neither of the errors above
  were signaled by Common Lisp.  They were ``soft'' ACL2 errors.  In
  particular, when [47mapply$[0m calls [47msqu[0m above, even when running in raw
  Lisp, it actually calls the executable counterpart of [47msqu[0m, which
  checks guards at runtime and executes properly under the ACL2
  axioms.

    ACL2 !>(set-guard-checking :none)

    Turning off guard checking entirely.

    ACL2 >(strange 'nan)
    0

  The last evaluation can be explained by the fact that ACL2
  multiplication defaults non-numbers to 0.

  We discuss the evaluation of ground [47mapply$[0m terms in the evaluation
  theory further below.

  When the guard conjectures of a function are proved all necessary
  warrants are assumed.  This is unlike what happens when the measure
  conjectures are proved.  The reason we can assume warrants during
  guard verification is that guard verification is relevant in the
  evaluation theory, where attachments are allowed and all warrants
  have true attachments.


Top-Level Evaluation of Apply$

  As noted, ACL2's evaluation theory implicitly assumes all warrants
  produced by [47m[defwarrant][0m.  See [guarantees-of-the-top-level-loop].
  Since top-level evaluation in ACL2 is conducted in the evaluation
  theory, ground calls of [47mapply$[0m --- whether literally in top-level
  input to the ACL2 read-eval-print loop or hidden inside scions
  called from the top-level --- can be evaluated on quoted warranted
  function symbols and [47m[lambda$][0m expressions --- provided the
  [tame]ness restrictions are met.  This is in contrast to
  opportunities for evaluation of ground [47mapply$[0m expressions arising
  in proofs, where warrant hypotheses must be explicit.

  In this section we focus on calls of [47mapply$[0m arising in the evaluation
  theory.  We start with a discussion of the use of [47mapply$[0m with
  warranted [47m:logic[0m mode functions.  We then describe how [47mapply$[0m
  handles badged [47m:program[0m mode functions.  Note that a mere badge is
  [3mnot[0m sufficient for evaluation when using [47mapply$[0m on a [47m:logic[0m mode
  function that is not warranted; see [47m[defbadge][0m and
  [guarantees-of-the-top-level-loop] for discussion of this case.  In
  short: evaluation involving [47m:logic[0m mode functions is expected to
  respect the evaluation theory, and while [47mdefwarrant[0m extends the
  evaluation theory appropriately, [47mdefbadge[0m does not.

  Evaluation of [47mapply$[0m terms in the evaluation theory respects guards
  on quoted function symbols and [47m[lambda$][0m expressions (which is to
  say, on the quoted well-formed [47mLAMBDA[0m objects that [47m[lambda$][0m
  produces).  So consider a call of [47mapply$[0m on [47mfn[0m and [47margs[0m in the
  evaluation theory, where [47mfn[0m is a warranted function symbol or a
  well-formed (and thus tame) [47mLAMBDA[0m object.  Here's what happens.
  Except where noted, the description below applies both to warranted
  [47m:logic[0m and badged [47m:program[0m mode functions.

  [47mApply$[0m determines whether [47mfn[0m's tameness restrictions are met by [47margs[0m.
  Tameness is a syntactic property and so can be checked.  If the
  function's tameness restrictions are not met, an error is caused.

  If the tameness restrictions are met, [47mapply$[0m determines whether [47mfn[0m
  has been guard verified.  In the case of function symbols this is a
  simple lookup on the property list of [47mfn[0m.  (Of course, this check
  fails for [47m:program[0m mode functions.)  In the case of [47mLAMBDA[0m objects
  it is a cache query (see [47m[print-cl-cache][0m) and if the query reveals
  that we have not yet tried to verify the guards of this [47mLAMBDA[0m
  object, [47mapply$[0m uses tau reasoning alone (see
  [introduction-to-the-tau-system]) to try to verify the guard
  conjectures.

  [31;1mNote:[0mAn important distinction between the runtime handling of
  function symbols versus [47mLAMBDA[0m objects by [47mapply$[0m is that function
  symbols can only be guard verified by prior events, e.g., the
  introductory [47m[defun][0m or a subsequent [47mverify-guards[0m, but [47mapply$[0m
  tries to verify the guards of [47mLAMBDA[0m objects [3mon the fly[0m!  The
  reason for this distinction is that we anticipate that many [47mLAMBDA[0m
  objects will not be associated with any event.  For example, an
  ACL2 macro might generate a call of a scion on a never-before-seen
  [47mLAMBDA[0m object and that [47mLAMBDA[0m object may only be seen by the
  top-level evaluator.  We discuss this further in [47m[verify-guards][0m

  If [47mfn[0m is guard verified, [47mapply$[0m next checks whether [47mfn[0m's guard holds
  of the actuals in [47margs[0m.  This is done by evaluation of the compiled
  code for the guard on [47margs[0m.

  If the guard check of [47margs[0m succeeds, a compiled version of [47mfn[0m is
  applied to [47margs[0m.  If the check fails, a guard violation is signaled
  or else the application of [47mfn[0m to [47margs[0m is interpreted under the
  definitional axioms of [47mapply$[0m and [47mev$[0m, depending on how
  [47m[set-guard-checking][0m has been configured.

  Finally, if [47mfn[0m is not guard verified, the application of [47mfn[0m to [47margs[0m
  is interpreted under the definitional axioms of [47mapply$[0m and [47mev$[0m.

  We discuss the cache that supports [47mLAMBDA[0m application in
  [47m[print-cl-cache][0m.  See also the discussion of guard verification in
  [47m[lambda$][0m.  It should be noted that a [47mLAMBDA[0m object can also be
  guard verified using the [47m[verify-guards][0m event.  This brings the
  full power of the prover to bear on the guard verification of the
  [47mLAMBDA[0m object, instead of relying just on the tau system.

  Users are accustomed to executing [47m:program[0m mode functions at the
  top-level of the ACL2 read-eval-print loop.  Indeed, the prover
  itself and the various event commands are mostly written in
  [47m:program[0m mode.  Furthermore, the evaluation theory is described as
  an extension of the proof theory, i.e., as an axiomatic theory.
  And yet no part of that axiomatization explains how [47m:program[0m mode
  functions are run!  It simply isn't important.  The implementation
  supports it and no questions are asked.  We, the implementors of
  ACL2, view top-level evaluation of [47m:program[0m mode functions as a
  convenience not affecting the consistency of the proof theory.  No
  inconsistency results from starting a non-terminating computation
  because you can never inspect the result, whereas if you added the
  corresponding definition as an axiom you might be able to prove
  something contradictory.  So we regard the seamless execution of
  [47m:program[0m mode functions as a convenience to the user who might use
  them to inspect the ACL2 logical world, gather data, experiment
  with constrained formal models by attaching executable code to
  unspecified functions, prototype something to be formalized, etc.
  In that spirit, we have arranged for [47mapply$[0m to handle [47m:program[0m mode
  functions [3mprovided they have badges[0m.  Badges are critical because
  it means that execution of the functions won't ``go outside the
  sandbox.'' However, [47mapply$[0m runs [47m:program[0m mode functions in
  [47m[safe-mode][0m to ensure the functional substitutivity of [47mapply$[0m:
  identical calls must always yield identical results.

  It may seem counterintuitive that a top-level [47mapply$[0m of a [47m:logic[0m mode
  function cannot be executed unless [47mdefwarrant[0m has succeeded but a
  top-level [47mapply$[0m of a [47m:program[0m mode function can be executed.  As
  noted earlier, the reason is simple: execution of [47m:logic[0m mode
  functions is justified by the axioms of the evaluation theory while
  no such assurances are offered for [47m:program[0m mode functions.


Logical Definitions

  In the following definitions, [47mapply$-userfn[0m is an undefined function
  that is constrained by warrants to describe the tameness
  requirement and behavior of [47mapply$[0m on specific function symbols.
  The functions [47muntame-apply$[0m and [47muntame-ev$[0m are simply undefined
  functions for giving unspecified values when untame objects are
  being used.

  [31;1mFunction: [0m<apply$>

    (defun apply$ (fn args)
      (declare (xargs :guard (apply$-guard fn args)))
      (cond ((consp fn) (apply$-lambda fn args))
            ((apply$-primp fn)
             (apply$-prim fn args))
            ((eq fn 'badge) (badge (car args)))
            ((eq fn 'tamep) (tamep (car args)))
            ((eq fn 'tamep-functionp)
             (tamep-functionp (car args)))
            ((eq fn 'suitably-tamep-listp)
             (ec-call (suitably-tamep-listp (car args)
                                            (cadr args)
                                            (caddr args))))
            ((eq fn 'apply$)
             (if (tamep-functionp (car args))
                 (ec-call (apply$ (car args) (cadr args)))
               (untame-apply$ fn args)))
            ((eq fn 'ev$)
             (if (tamep (car args))
                 (ev$ (car args) (cadr args))
               (untame-apply$ fn args)))
            (t (apply$-userfn fn args))))

  [31;1mFunction: [0m<apply$-lambda>

    (defun apply$-lambda (fn args)
      (declare (xargs :guard (apply$-lambda-guard fn args)))
      (apply$-lambda-logical fn args))

  [31;1mMacro: [0m<apply$-lambda-logical>

    (defmacro apply$-lambda-logical (fn args)
     (declare (xargs :guard (symbolp fn)))
     (cons
        'ev$
        (cons (cons 'lambda-object-body
                    (cons fn 'nil))
              (cons (cons 'ec-call
                          (cons (cons 'pairlis$
                                      (cons (cons 'lambda-object-formals
                                                  (cons fn 'nil))
                                            (cons args 'nil)))
                                'nil))
                    'nil))))

  [31;1mFunction: [0m<ev$>

    (defun ev$ (x a)
      (declare (xargs :guard t))
      (cond ((not (tamep x)) (untame-ev$ x a))
            ((variablep x)
             (ec-call (cdr (ec-call (assoc-equal x a)))))
            ((fquotep x) (cadr x))
            ((eq (car x) 'if)
             (if (ev$ (cadr x) a)
                 (ev$ (caddr x) a)
               (ev$ (cadddr x) a)))
            ((eq (car x) 'apply$)
             (apply$ 'apply$
                     (list (cadr (cadr x))
                           (ev$ (caddr x) a))))
            ((eq (car x) 'ev$)
             (apply$ 'ev$
                     (list (cadr (cadr x))
                           (ev$ (caddr x) a))))
            (t (apply$ (car x) (ev$-list (cdr x) a)))))

  [31;1mFunction: [0m<ev$-list>

    (defun ev$-list (x a)
      (declare (xargs :guard t))
      (cond ((atom x) nil)
            (t (cons (ev$ (car x) a)
                     (ev$-list (cdr x) a)))))

  [31;1mFunction: [0m<apply$-guard>

    (defun apply$-guard (fn args)
      (declare (xargs :guard t))
      (if (atom fn)
          (true-listp args)
        (apply$-lambda-guard fn args)))

  [31;1mFunction: [0m<apply$-lambda-guard>

    (defun apply$-lambda-guard (fn args)
      (declare (xargs :guard t))
      (and (consp fn)
           (consp (cdr fn))
           (true-listp args)
           (equal (len (cadr fn)) (length args))))


Subtopics

  [Apply$-guard]
      The guard on [47mapply$[0m

  [Apply$-lambda]
      Used by [47mapply$[0m on [47mLAMBDA[0m objects

  [Apply$-lambda-guard]
      The guard on [47mapply$-lambda[0m

  [Apply$-userfn]
      Undefined function used by [47mapply$[0m on non-primitives

  [Badge]
      Syntactic requirements on a function symbol to be used by [47mapply$[0m

  [Badge-userfn]
      Undefined function used by [47mbadge[0m on non-primitives

  [Defbadge]
      Issue a badge for a function so [47m[apply$][0m can evaluate with it

  [Defun$]
      Define a function symbol and generate a warrant

  [Defwarrant]
      Issue a warrant for a function so [47m[apply$][0m can use it in proofs

  [Ev$]
      Evaluate a tame expression using [47mapply$[0m

  [Explain-giant-lambda-object]
      print data related to a large lambda object

  [Fn-equal]
      Equivalence relation on tame functions

  [Gratuitous-lambda-object-restrictions]
      Enforcement of logically unnecessary restrictions on [47m:FN[0m slots

  [Ilk]
      Indicator of how an argument is used

  [Introduction-to-apply$]
      Background knowledge on how to use [47m[apply$][0m, [47m[defwarrant][0m, etc.

  [L<]
      Ordering on naturals or lists of naturals

  [Lambda]
      Lambda expressions, [47mLAMBDA[0m objects, and [47mlambda$[0m expressions

  [Lambda$]
      Lambda object constructor for use with [47mapply$[0m

  [Mixed-mode-functions]
      [47m:[0m[47m[logic][0m mode functions can [47m[apply$][0m [47m:[0m[47m[program][0m mode functions

  [Print-cl-cache]
      Information about the cache supporting [47mapply$[0m

  [Rewriting-calls-of-apply$-ev$-and-loop$-scions]
      How the rewriter handles [47mapply$[0m, [47mev$[0m, and [47mloop$[0m terms

  [Scion]
      A function ancestrally dependent on [47mapply$[0m

  [Tame]
      Definitions of the various notions of tameness

  [Translam]
      Print the translation of a lambda$ expression

  [Warrant]
      Giving [47m[apply$][0m permission to handle a user-defined function in
      proofs

  [Well-formed-lambda-objectp]
      Predicate for recognizing well-formed [47mLAMBDA[0m objects")
 (APPLY$-GUARD
  (APPLY$)
  "The guard on [47mapply$[0m

  The guard on [47m(apply$ fn lst)[0m is [47m(apply$-guard fn lst)[0m which is
  extraordinarily weak.

  [31;1mFunction: [0m<apply$-guard>

    (defun apply$-guard (fn args)
      (declare (xargs :guard t))
      (if (atom fn)
          (true-listp args)
        (apply$-lambda-guard fn args)))

  where

  [31;1mFunction: [0m<apply$-lambda-guard>

    (defun apply$-lambda-guard (fn args)
      (declare (xargs :guard t))
      (and (consp fn)
           (consp (cdr fn))
           (true-listp args)
           (equal (len (cadr fn)) (length args))))

  This guard is just strong enough to allow the definitions of the
  functions in the [47mapply$[0m clique to be guard verified.  It does not
  guarantee that [47mfn[0m is tame or well-formed or that [47margs[0m satisfy the
  guard of [47mfn[0m.  The last condition is in fact impossible to state
  given the untyped nature of ACL2.  Thus, [47m(apply$ fn args)[0m has to
  check tameness, well-formedness, guard verified, and that [47mfn[0m's
  guard is satisfied by [47margs[0m when the [47mapply$[0m is executed in the
  evaluation theory.

  The issue of guards and guard verification of definitions involving
  [47mapply$[0m is further discussed in [47m[apply$][0m and in [47m[verify-guards][0m.")
 (APPLY$-LAMBDA
  (APPLY$)
  "Used by [47mapply$[0m on [47mLAMBDA[0m objects

  When [47mapply$[0m is given a [47mconsp[0m object as its first argument it treats
  it as a [47mLAMBDA[0m expression and calls this function to apply it.
  This function evaluates the body of the object with [47mev$[0m under an
  alist binding the formals of the object to the actuals.  See
  [47m[apply$][0m for details.")
 (APPLY$-LAMBDA-GUARD
  (APPLY$)
  "The guard on [47mapply$-lambda[0m

  The guard on [47m(apply$-lambda fn lst)[0m is [47m(apply$-lambda-guard fn lst)[0m
  which is extraordinarily weak.

  [31;1mFunction: [0m<apply$-lambda-guard>

    (defun apply$-lambda-guard (fn args)
      (declare (xargs :guard t))
      (and (consp fn)
           (consp (cdr fn))
           (true-listp args)
           (equal (len (cadr fn)) (length args))))

  This guard is just strong enough to allow the definitions of the
  functions in the [47mapply$[0m clique to be guard verified.  It does not
  guarantee that [47mfn[0m is [47mtame[0m or well-formed or that [47margs[0m satisfy the
  guard of [47mfn[0m.  The last condition is in fact impossible to state
  given the untyped nature of ACL2.  Thus, [47m(apply$ fn args)[0m has to
  check tameness, well-formedness, guard verified and that [47mfn[0m's guard
  is satisfied by [47margs[0m when the [47mapply$[0m is executed in the evaluation
  theory.

  The issue of guards and guard verification of definitions involving
  [47mapply$[0m is further discussed in [47m[apply$][0m and in [47m[verify-guards][0m.")
 (APPLY$-USERFN
  (APPLY$)
  "Undefined function used by [47mapply$[0m on non-primitives

  When [47mapply$[0m is given a non-primitive function symbol it calls this
  function to determine the results of applying that symbol to the
  given arguments.  But this function is undefined.  In the proof
  theory, its value on a given function symbol [47mfn[0m is specified, if at
  all, by the [47m[warrant][0m for [47mfn[0m which must be available as a
  hypothesis in the formula being proved.  In the evaluation theory,
  [47mapply$-userfn[0m has an attachment that makes it behave as though all
  warrants are assumed.  See [47m[apply$][0m for details.")
 (APROPOS (POINTERS)
          "See [finding-documentation].")
 (ARCHITECTURE-OF-THE-PROVER
  (INTRODUCTION-TO-THE-THEOREM-PROVER)
  "A simple overview of how the prover works

  Six built-in proof techniques are used by ACL2 to decompose the goal
  formula into subgoals.

    * [3msimplification[0m --- decision procedures and rewriting with previously
      proved rules, but actually including a host of other techniques
      under your control.  Simplification is the only proof technique
      that can reduce a formula to 0 subgoals (i.e., prove it) rather
      than just transform it to other formulas.  The predominant
      activity in most proofs is simplification.  There are many ways
      you can affect what the simplifier does to your formulas.  Good
      users spend most of their time thinking about how to control
      the simplifier.

    * [3mdestructor elimination[0m --- getting rid of ``destructor terms'' like
      [47m(CAR X)[0m and [47m(CDR X)[0m by replacing a variable, e.g., [47mX[0m, by a
      ``constructor'' term, e.g., [47m(CONS A B)[0m.  But you can tell ACL2
      about new destructor/constructor combinations.

    * [3mfertilization[0m --- using an equivalence hypothesis by substituting one
      side for the other in the goal.  When under induction, ACL2 may
      decide to restrict the substitution as follows, using its
      so-called [3mcross-fertilization[0m heuristic: substitute only into
      one side of the conclusion, thus using an inductive hypothesis
      in preparation for possible generalization in advance of
      another induction.  Note that cross-fertilization is used only
      when generalization is enabled: with the hint [47m:do-not
      '(generalize)[0m, only full fertilization is applied.

    * [3mgeneralization[0m --- replacing a term by a new variable and restricting
      the new variable to have some of the properties of the term.
      You can control the restrictions imposed on the new variable.
      This is a heuristic that prepares the goal for another
      induction.

    * [3melimination of irrelevance[0m --- throwing away unnecessary hypotheses.
      This is a heuristic that prepares the goal for another
      induction.

    * [3minduction[0m --- selecting an induction scheme to prove a formula.
      Inductions are ``suggested'' by the recursive functions
      appearing in the formula.  But you can control what inductions
      are suggested by terms.

  But you can add additional techniques, called [3mclause processors[0m.

  The various techniques are tried in turn, with simplification first
  and induction last.  Each technique reports one of three outcomes:
  it found nothing to change (i.e., the technique doesn't [3mapply[0m to
  that subgoal), it decided to abort the proof attempt (typically
  because there is reason to believe the proof is failing), or it
  decomposed the goal into [3mk[0m subgoals.

  The last outcome has a special case: if [3mk[0m is 0 then the technique
  proved the goal.  Whenever [3mk[0m is non-0, the process starts over
  again with simplification on each of the [3mk[0m subgoals.  However, it
  saves up all the subgoals for which induction is the only proof
  technique left to try. That way you see how it performs on every
  base case and induction step of one induction before it launches
  into another induction.

  It runs until you or one of the proof techniques aborts the proof
  attempt or until all subgoals have been proved.

  Note that if simplification produces a subgoal, that subgoal is
  re-simplified.  This process continues until the subgoal cannot be
  simplified further.  Only then is the next proof technique tried.
  Such subgoals are said to be [3mstable under simplification[0m.

  While this is happening, the prover prints an English narrative
  describing the process.  Basically, after each goal is printed, the
  system prints an English paragraph that names the next applicable
  proof technique, gives a brief description of what that technique
  does to the subgoal, and says how many new subgoals are produced.
  Then each subgoal is dealt with in turn.

  If the proof is successful, you could read this log as a proof of the
  conjecture.  But output from successful proofs is generally never
  read because it is not important to The Method described in
  [introduction-to-the-theorem-prover].

  The output of an unsuccessful proof attempt concludes with some [3mkey[0m
  [3mcheckpoints[0m which usually bear looking at.

  For more information about how ACL2 orchestrates its proof
  techniques, see [hints-and-the-waterfall].")
 (AREF1
  (ARRAYS ACL2-BUILT-INS)
  "Access the elements of a 1-dimensional array

    Example Form:
    (aref1 'delta1 a (+ i k))

    General Form:
    (aref1 name alist index)

  where [47mname[0m is a symbol, [47malist[0m is a 1-dimensional array and [47mindex[0m is a
  legal index into [47malist[0m.  This function returns the value associated
  with [47mindex[0m in [47malist[0m, or else the default value of the array.  See
  [arrays] for details.

  This function executes in virtually constant time if [47malist[0m is in fact
  the ``semantic value'' associated with [47mname[0m (see [arrays]).  When
  it is not, [47maref1[0m must do a linear search through [47malist[0m.  In that
  case the correct answer is returned but a [31;1mslow array[0m comment is
  printed to the comment window.  See [slow-array-warning].

  [31;1mFunction: [0m<aref1>

    (defun aref1 (name l n)
      (declare (xargs :guard (and (array1p name l)
                                  (integerp n)
                                  (>= n 0)
                                  (< n (car (dimensions name l))))))
      (let ((x (and (not (eq n :header)) (assoc n l))))
        (cond ((null x) (default name l))
              (t (cdr x)))))")
 (AREF2
  (ARRAYS ACL2-BUILT-INS)
  "Access the elements of a 2-dimensional array

    Example Form:
    (aref2 'delta1 a i j)

    General Form:
    (aref2 name alist i j)

  where [47mname[0m is a symbol, [47malist[0m is a 2-dimensional array and [47mi[0m and [47mj[0m
  are legal indices into [47malist[0m.  This function returns the value
  associated with [47m(i . j)[0m in [47malist[0m, or else the default value of the
  array.  See [arrays] for details.

  This function executes in virtually constant time if [47malist[0m is in fact
  the ``semantic value'' associated with [47mname[0m (see [arrays]).  When
  it is not, [47maref2[0m must do a linear search through [47malist[0m.  In that
  case the correct answer is returned but a [31;1mslow array[0m comment is
  printed to the comment window.  See [slow-array-warning].

  [31;1mFunction: [0m<aref2>

    (defun aref2 (name l i j)
      (declare (xargs :guard (and (array2p name l)
                                  (integerp i)
                                  (>= i 0)
                                  (< i (car (dimensions name l)))
                                  (integerp j)
                                  (>= j 0)
                                  (< j (cadr (dimensions name l))))))
      (let ((x (assoc2 i j l)))
        (cond ((null x) (default name l))
              (t (cdr x)))))")
 (ARGLISTP (POINTERS)
           "See [system-utilities].")
 (ARGS
  (DOCUMENTATION)
  "[47margs[0m, [47m[guard][0m, [47mtype[0m, [47m[constraint][0m, etc., of a function symbol

    Example:
    :args assoc-eq

  [47mArgs[0m takes one argument, a symbol which must be the name of a
  function or macro, and prints out some information about it
  including the formal parameters, the [guard] expression, the output
  [signature], the deduced type, the [constraint] (if any), and its
  [47m[badge][0m and [47m[warrant][0m, if any.")
 (ARITIES-OKP
  (ACL2-BUILT-INS)
  "check the arities of given function symbols

    Example:
    (arities-okp '((IF . 3) (CAR . 1) (CONS . 2)) (w state))

    General Form:
    (arities-okp alist w)

  where [47malist[0m is a [47m[symbol-alistp][0m and [47mw[0m is an ACL2 logical [world].
  The alist is presumed to pair [47m:[0m[47m[logic][0m-mode function symbols with
  arities.  The result is [47mt[0m or [47mnil[0m according to whether each symbol
  in the alist is a [47m:logic[0m-mode function symbol with the associated
  arity as its [47m[arity][0m in [47mw[0m.  See [well-formedness-guarantee].

  [31;1mFunction: [0m<arities-okp>

    (defun arities-okp (user-table w)
      (declare (xargs :guard (and (symbol-alistp user-table)
                                  (plist-worldp-with-formals w))))
      (cond ((endp user-table) t)
            (t (and (equal (arity (car (car user-table)) w)
                           (cdr (car user-table)))
                    (logicp (car (car user-table)) w)
                    (arities-okp (cdr user-table) w)))))")
 (ARITY
  (ACL2-BUILT-INS)
  "number of arguments of a function symbol

    Examples:
    (arity 'IF (w state))
    (arity '(LAMBDA (X) (CONS X X)) (w state))

    General Form:
    (arity fn w)

  where [47mfn[0m is a function symbol or a lambda expression and [47mw[0m is an ACL2
  logical [world].  The result is the number of arguments the
  function or lambda expression takes, or [47mnil[0m if the function symbol
  is not defined in [47mw[0m.

See [arity+] for a variant of [47marity[0m with a stronger [guard].")
 (ARRAY (POINTERS) "See [arrays].")
 (ARRAY1P
  (ARRAYS ACL2-BUILT-INS)
  "Recognize a 1-dimensional array

    Example Form:
    (array1p 'delta1 a)

    General Form:
    (array1p name alist)

  where [47mname[0m and [47malist[0m are arbitrary objects.  This function returns [47mt[0m
  if [47malist[0m is a 1-dimensional ACL2 array.  Otherwise it returns [47mnil[0m.
  The function operates in constant time if [47malist[0m is the semantic
  value of [47mname[0m.  See [arrays].

  [31;1mFunction: [0m<array1p>

    (defun array1p (name l)
     (declare (xargs :guard t))
     (and
      (symbolp name)
      (alistp l)
      (let ((header-keyword-list (cdr (assoc-eq :header l))))
       (and
        (keyword-value-listp header-keyword-list)
        (let
         ((dimensions
               (cadr (assoc-keyword :dimensions header-keyword-list)))
          (maximum-length
            (cadr (assoc-keyword :maximum-length header-keyword-list))))
         (and (true-listp dimensions)
              (equal (length dimensions) 1)
              (integerp (car dimensions))
              (integerp maximum-length)
              (< 0 (car dimensions))
              (< (car dimensions) maximum-length)
              (<= maximum-length
                  (array-maximum-length-bound))
              (bounded-integer-alistp l (car dimensions))))))))")
 (ARRAY2P
  (ARRAYS ACL2-BUILT-INS)
  "Recognize a 2-dimensional array

    Example Form:
    (array2p 'delta1 a)

    General Form:
    (array2p name alist)

  where [47mname[0m and [47malist[0m are arbitrary objects.  This function returns [47mt[0m
  if [47malist[0m is a 2-dimensional ACL2 array.  Otherwise it returns [47mnil[0m.
  The function operates in constant time if [47malist[0m is the semantic
  value of [47mname[0m.  See [arrays].

  [31;1mFunction: [0m<array2p>

    (defun array2p (name l)
     (declare (xargs :guard t))
     (and
      (symbolp name)
      (alistp l)
      (let ((header-keyword-list (cdr (assoc-eq :header l))))
       (and
        (keyword-value-listp header-keyword-list)
        (let
         ((dimensions
               (cadr (assoc-keyword :dimensions header-keyword-list)))
          (maximum-length
            (cadr (assoc-keyword :maximum-length header-keyword-list))))
         (and (true-listp dimensions)
              (equal (length dimensions) 2)
              (let ((d1 (car dimensions))
                    (d2 (cadr dimensions)))
                (and (integerp d1)
                     (integerp d2)
                     (integerp maximum-length)
                     (< 0 d1)
                     (< 0 d2)
                     (< (* d1 d2) maximum-length)
                     (<= maximum-length
                         (array-maximum-length-bound))
                     (bounded-integer-alistp2 l d1 d2)))))))))")
 (ARRAYS
  (PROGRAMMING)
  "ACL2 arrays and operations on them

  Below we begin a detailed presentation of ACL2 arrays.  ACL2's
  single-threaded objects (see [stobj]) provide a similar
  functionality that is generally more efficient when there are
  updates (writes), but is also more restrictive.

  See [arrays-example] for a brief introduction illustrating the use of
  ACL2 arrays.

  ACL2 provides relatively efficient 1- and 2-dimensional arrays.
  Arrays are awkward to provide efficiently in an applicative
  language because the programmer rightly expects to be able to
  ``modify'' an array object with the effect of changing the behavior
  of the element accessing function on that object.  This, of course,
  does not make any sense in an applicative setting.  The element
  accessing function is, after all, a function, and its behavior on a
  given object is immutable.  To ``modify'' an array object in an
  applicative setting we must actually produce a new array object.
  Arranging for this to be done efficiently is a challenge to the
  implementors of the language.  In addition, the programmer
  accustomed to the von Neumann view of arrays must learn how to use
  immutable applicative arrays efficiently.

  In this note we explain 1-dimensional arrays.  In particular, we
  explain briefly how to create, access, and ``modify'' them, how
  they are implemented, and how to program with them.  2-dimensional
  arrays are dealt with by analogy.


The Logical Description of ACL2 Arrays

  An ACL2 1-dimensional array is an object that associates arbitrary
  objects with certain integers, called ``indices.'' Every array has
  a dimension, [47mdim[0m, which is a positive integer.  The indices of an
  array are the consecutive integers from [47m0[0m through [47mdim-1[0m.  To obtain
  the object associated with the index [47mi[0m in an array [47ma[0m, one uses
  [47m(aref1 name a i)[0m.  [47mName[0m is a symbol that is irrelevant to the
  semantics of [47m[aref1][0m but affects the speed with which it computes.
  We will talk more about array ``names'' later.  To produce a new
  array object that is like [47ma[0m but which associates [47mval[0m with index [47mi[0m,
  one uses [47m(aset1 name a i val)[0m.

  An ACL2 1-dimensional array is actually an alist.  There is no
  special ACL2 function for creating arrays; they are generally built
  with the standard list processing functions [47m[list][0m and [47m[cons][0m.
  However, there is a special ACL2 function, called [47m[compress1][0m, for
  speeding up access to the elements of such an alist.  We discuss
  [47m[compress1][0m later.

  One element of the alist must be the ``header'' of the array.  The
  [header] of a 1-dimensional array with dimension [47mdim[0m is of the
  form:

    (:HEADER :DIMENSIONS (dim)
             :MAXIMUM-LENGTH max
             :DEFAULT obj ; optional
             :NAME name   ; optional
             :ORDER order ; optional values are < (the default), >, or :none/nil
             ).

  [47mObj[0m may be any object and is called the ``default value'' of the
  array.  [47m[Max][0m must be an integer greater than [47mdim[0m.  [47mName[0m must be a
  symbol.  The [47m:[0m[47m[default][0m and [47m:name[0m entries are optional; if
  [47m:[0m[47m[default][0m is omitted, the default value is [47mnil[0m.  The function
  [47m[header][0m, when given a name and a 1- or 2-dimensional array,
  returns the [header] of the array.  The functions [47m[dimensions][0m,
  [47m[maximum-length][0m, and [47m[default][0m are similar and return the
  corresponding fields of the [header] of the array.  The role of the
  [47m:[0m[47m[dimensions][0m field is obvious: it specifies the legal indices into
  the array.  The roles played by the [47m:[0m[47m[maximum-length][0m and
  [47m:[0m[47m[default][0m fields are described below.

  Aside from the [header], the other elements of the alist must each be
  of the form [47m(i . val)[0m, where [47mi[0m is an integer and [47m0 <= i < dim[0m, and
  [47mval[0m is an arbitrary object.

  The [47m:order[0m field of the header is ignored for 2-dimensional arrays.
  For 1-dimensional arrays, it specifies the order of keys ([47mi[0m, above)
  when the array is compressed as with [47m[compress1][0m, as described
  below.  An [47m:order[0m of [47m:none[0m or [47mnil[0m specifies no reordering of the
  alist by [47m[compress1][0m, and an order of [47m>[0m specifies reordering by
  [47m[compress1][0m so that keys are in descending order.  Otherwise, the
  alist is reordered by [47m[compress1][0m so that keys are in ascending
  order.

  [47m(Aref1 name a i)[0m is [guard]ed so that [47mname[0m must be a symbol, [47ma[0m must
  be an array and [47mi[0m must be an index into [47ma[0m.  The value of [47m(aref1
  name a i)[0m is either [47m(cdr (assoc i a))[0m or else is the default value
  of [47ma[0m, depending on whether there is a pair in [47ma[0m whose [47m[car][0m is [47mi[0m.
  Note that [47mname[0m is irrelevant to the value of an [47m[aref1][0m expression.
  You might [47m:pe aref1[0m to see how simple the definition is.

  [47m(Aset1 name a i val)[0m is [guard]ed analogously to the [47m[aref1][0m
  expression.  The value of the [47m[aset1][0m expression is essentially
  [47m(cons (cons i val) a)[0m.  Again, [47mname[0m is irrelevant.  Note [47m(aset1
  name a i val)[0m is an array, [47ma'[0m, with the property that [47m(aref1 name
  a' i)[0m is [47mval[0m and, except for index [47mi[0m, all other indices into [47ma'[0m
  produce the same value as in [47ma[0m.  Note also that if [47ma[0m is viewed as
  an alist (which it is) the pair ``binding'' [47mi[0m to its old value is
  in [47ma'[0m but ``covered up'' by the new pair.  Thus, the length of an
  array grows by one when [47m[aset1][0m is done.

  Because [47m[aset1][0m covers old values with new ones, an array produced by
  a sequence of [47m[aset1][0m calls may have many irrelevant pairs in it.
  The function [47m[compress1][0m can remove these irrelevant pairs.  Thus,
  [47m(compress1 name a)[0m returns an array that is equivalent (vis-a-vis
  [47m[aref1][0m) to [47ma[0m but which may be shorter.  For technical reasons, the
  alist returned by [47m[compress1][0m may also list the pairs in a
  different order than listed in [47ma[0m.

  To prevent arrays from growing excessively long due to repeated
  [47m[aset1][0m operations, [47m[aset1][0m essentially calls [47m[compress1][0m on the
  new alist whenever the length of the new alist exceeds the
  [47m:[0m[47m[maximum-length][0m entry, [47m[max][0m, in the [header] of the array.  See
  the definition of [47m[aset1][0m (for example by using [47m:[0m[47m[pe][0m).  This is
  primarily just a mechanism for freeing up [47m[cons][0m space consumed
  while doing [47m[aset1][0m operations.  Note however that this [47m[compress1][0m
  call is replaced by a hard error if the header specifies an [47m:order[0m
  of [47m:none[0m or [47mnil[0m.

  This completes the logical description of 1-dimensional arrays.
  2-dimensional arrays are analogous.  The [47m:[0m[47m[dimensions][0m entry of the
  [header] of a 2-dimensional array should be [47m(dim1 dim2)[0m.  A pair of
  indices, [47mi[0m and [47mj[0m, is legal iff [47m0 <= i < dim1[0m and [47m0 <= j < dim2[0m.
  The [47m:[0m[47m[maximum-length][0m must be greater than [47mdim1*dim2[0m.  [47m[Aref2][0m,
  [47m[aset2][0m, and [47m[compress2][0m are like their counterparts but take an
  additional [47mindex[0m argument.  Finally, the pairs in a 2-dimensional
  array are of the form [47m((i . j) . val)[0m.


The Implementation of ACL2 Arrays

  Very informally speaking, the function [47m[compress1][0m ``creates'' an
  ACL2 array that provides fast access, while the function [47m[aref1][0m
  ``maintains'' fast access.  We now describe this informal idea more
  carefully.

  [47m[Aref1][0m is essentially [47m[assoc][0m.  If [47m[aref1][0m were implemented naively
  the time taken to access an array element would be linear in the
  dimension of the array and the number of ``assignments'' to it (the
  number of [47m[aset1][0m calls done to create the array from the initial
  alist).  This is intolerable; arrays are ``supposed'' to provide
  constant-time access and change.

  The apparently irrelevant names associated with ACL2 arrays allow us
  to provide constant-time access and change when arrays are used in
  ``conventional'' ways.  The implementation of arrays makes it clear
  what we mean by ``conventional.''

  Recall that array names are symbols.  Behind the scenes, ACL2
  associates two objects with each ACL2 array name.  The first object
  is called the ``semantic value'' of the name and is an alist.  The
  second object is called the ``raw lisp array'' and is a Common Lisp
  array.

  When [47m(compress1 name alist)[0m builds a new alist, [47ma'[0m, it sets the
  semantic value of [47mname[0m to that new alist.  Furthermore, it writes
  into a Common Lisp array all of the index/value pairs of [47ma'[0m,
  initializing unassigned indices with the default value.  In general
  this is a new array, which becomes the raw lisp array of [47mname[0m.
  However, if a raw lisp array is already associated with [47mname[0m and is
  at least as long as the dimension specified in the [header], then
  that array is reused and all indices out of range are ignored.
  (Such reuse can be avoided; see [flush-compress] for how to remove
  the existing association of a raw lisp array with a name.)  Either
  way, [47m[compress1][0m then returns [47ma'[0m, the semantic value, as its
  result, as required by the definition of [47m[compress1][0m.

  When [47m(aref1 name a i)[0m is invoked, [47m[aref1][0m first determines whether
  the semantic value of [47mname[0m is [47ma[0m (i.e., is [47m[eq][0m to the alist [47ma[0m).  If
  so, [47m[aref1][0m can determine the [47mi[0mth element of [47ma[0m by invoking Common
  Lisp's [47maref[0m function on the raw lisp array associated with name.
  Note that no linear search of the alist [47ma[0m is required; the
  operation is done in constant time and involves retrieval of two
  global variables, an [47m[eq][0m test and [47mjump[0m, and a raw lisp array
  access.  In fact, an ACL2 array access of this sort is about 5
  times slower than a C array access.  On the other hand, if [47mname[0m has
  no semantic value or if it is different from [47ma[0m, then [47m[aref1][0m
  determines the answer by linear search of [47ma[0m as suggested by the
  [47massoc-like[0m definition of [47m[aref1][0m.  Thus, [47m[aref1][0m always returns the
  axiomatically specified result.  It returns in constant time if the
  array being accessed is the current semantic value of the name
  used.  The ramifications of this are discussed after we deal with
  [47m[aset1][0m.

  When [47m(aset1 name a i val)[0m is invoked, [47m[aset1][0m does two [47m[cons][0mes to
  create the new array.  Call that array [47ma'[0m.  It will be returned as
  the answer.  (In this discussion we ignore the case in which
  [47m[aset1][0m does a [47m[compress1][0m.)  However, before returning, [47m[aset1][0m
  determines if [47mname[0m's semantic value is [47ma[0m.  If so, it makes the new
  semantic value of [47mname[0m be [47ma'[0m and it smashes the raw lisp array of
  [47mname[0m with [47mval[0m at index [47mi[0m, before returning [47ma'[0m as the result.  Thus,
  after doing an [47m[aset1][0m and obtaining a new semantic value [47ma'[0m, all
  [47m[aref1][0ms on that new array will be fast.  Any [47m[aref1][0ms on the old
  semantic value, [47ma[0m, will be slow.

  To understand the performance implications of this design, consider
  the chronological sequence in which ACL2 (Common Lisp) evaluates
  expressions: basically inner-most first, left-to-right,
  call-by-value.  An array use, such as [47m(aref1 name a i)[0m, is ``fast''
  (constant-time) if the alist supplied, [47ma[0m, is the value returned by
  the most recently executed [47m[compress1][0m or [47m[aset1][0m on the name
  supplied.  In the functional expression of ``conventional'' array
  processing, all uses of an array are fast.

  The [47m:name[0m field of the [header] of an array is completely irrelevant.
  Our convention is to store in that field the symbol we mean to use
  as the name of the raw lisp array.  But no ACL2 function inspects
  [47m:name[0m and its primary value is that it allows the user, by
  inspecting the semantic value of the array --- the alist --- to
  recall the name of the raw array that probably holds that value.
  We say ``probably'' since there is no enforcement that the alist
  was compressed under the name in the [header] or that all [47maset[0ms
  used that name.  Such enforcement would be inefficient.


Some Programming Examples

  In the following examples we will use ACL2 ``global variables'' to
  hold several arrays.  See [@], and see [assign].

  Let the [47m[state][0m global variable [47ma[0m be the 1-dimensional compressed
  array of dimension [47m5[0m constructed below.

    ACL2 !>(assign a (compress1 'demo
                                '((:header :dimensions (5)
                                           :maximum-length 15
                                           :default uninitialized
                                           :name demo)
                                  (0 . zero))))

  Then [47m(aref1 'demo (@ a) 0)[0m is [47mzero[0m and [47m(aref1 'demo (@ a) 1)[0m is
  [47muninitialized[0m.

  Now execute

    ACL2 !>(assign b (aset1 'demo (@ a) 1 'one))

  Then [47m(aref1 'demo (@ b) 0)[0m is [47mzero[0m and [47m(aref1 'demo (@ b) 1)[0m is [47mone[0m.

  All of the [47m[aref1][0ms done so far have been ``fast.''

  Note that we now have two array objects, one in the global variable [47ma[0m
  and one in the global variable [47mb[0m.  [47mB[0m was obtained by assigning to
  [47ma[0m.  That assignment does not affect the alist [47ma[0m because this is an
  applicative language.  Thus, [47m(aref1 'demo (@ a) 1)[0m must [31;1mstill[0m be
  [47muninitialized[0m.  And if you execute that expression in ACL2 you will
  see that indeed it is.  However, a rather ugly comment is printed,
  namely that this array access is ``slow.'' The reason it is slow is
  that the raw lisp array associated with the name [47mdemo[0m is the array
  we are calling [47mb[0m.  To access the elements of [47ma[0m, [47m[aref1][0m must now do
  a linear search.  Any reference to [47ma[0m as an array is now
  ``unconventional;'' in a conventional language like Ada or Common
  Lisp it would simply be impossible to refer to the value of the
  array before the assignment that produced our [47mb[0m.

  Now let us define a function that counts how many times a given
  object, [47mx[0m, occurs in an array.  For simplicity, we will pass in the
  name and highest index of the array:

    ACL2 !>(defun cnt (name a i x)
             (declare (xargs :guard
                             (and (array1p name a)
                                  (integerp i)
                                  (>= i -1)
                                  (< i (car (dimensions name a))))
                             :mode :logic
                             :measure (nfix (+ 1 i))))
             (cond ((zp (1+ i)) 0) ; return 0 if i is at most -1
                   ((equal x (aref1 name a i))
                    (1+ (cnt name a (1- i) x)))
                   (t (cnt name a (1- i) x))))

  To determine how many times [47mzero[0m appears in [47m(@ b)[0m we can execute:

    ACL2 !>(cnt 'demo (@ b) 4 'zero)

  The answer is [47m1[0m.  How many times does [47muninitialized[0m appear in [47m(@ b)[0m?

    ACL2 !>(cnt 'demo (@ b) 4 'uninitialized)

  The answer is [47m3[0m, because positions [47m2[0m, [47m3[0m and [47m4[0m of the array contain
  that default value.

  Now imagine that we want to assign [47m'two[0m to index [47m2[0m and then count how
  many times the 2nd element of the array occurs in the array.  This
  specification is actually ambiguous.  In assigning to [47mb[0m we produce
  a new array, which we might call [47mc[0m.  Do we mean to count the
  occurrences in [47mc[0m of the 2nd element of [47mb[0m or the 2nd element of [47mc[0m?
  That is, do we count the occurrences of [47muninitialized[0m or the
  occurrences of [47mtwo[0m?  If we mean the former the correct answer is [47m2[0m
  (positions [47m3[0m and [47m4[0m are [47muninitialized[0m in [47mc[0m); if we mean the latter,
  the correct answer is [47m1[0m (there is only one occurrence of [47mtwo[0m in [47mc[0m).

  Below are ACL2 renderings of the two meanings, which we call [47m[former][0m
  and [47m[latter][0m.  (Warning: Our description of these examples, and of
  an example [47m[fast former][0m that follows, assumes that only one of
  these three examples is actually executed; for example, they are
  not executed in sequence.  See ``A Word of Warning'' below for more
  about this issue.)

    (cnt 'demo (aset1 'demo (@ b) 2 'two) 4 (aref1 'demo (@ b) 2))  ; [former]

    (let ((c (aset1 'demo (@ b) 2 'two)))                           ; [latter]
      (cnt 'demo c 4 (aref1 'demo c 2)))

  Note that in [47m[former][0m we create [47mc[0m in the second argument of the call
  to [47mcnt[0m (although we do not give it a name) and then refer to [47mb[0m in
  the fourth argument.  This is unconventional because the second
  reference to [47mb[0m in [47m[former][0m is no longer the semantic value of [47mdemo[0m.
  While ACL2 computes the correct answer, namely [47m2[0m, the execution of
  the [47m[aref1][0m expression in [47m[former][0m is done slowly.

  A conventional rendering with the same meaning is

    (let ((x (aref1 'demo (@ b) 2)))                           ; [fast former]
      (cnt 'demo (aset1 'demo (@ b) 2 'two) 4 x))

  which fetches the 2nd element of [47mb[0m before creating [47mc[0m by assignment.
  It is important to understand that [47m[former][0m and [47m[fast former][0m mean
  exactly the same thing: both count the number of occurrences of
  [47muninitialized[0m in [47mc[0m.  Both are legal ACL2 and both compute the same
  answer, [47m2[0m.  Indeed, we can symbolically transform [47m[fast former][0m
  into [47m[former][0m merely by substituting the binding of [47mx[0m for [47mx[0m in the
  body of the [47m[let][0m.  But [47m[fast former][0m can be evaluated faster than
  [47m[former][0m because all of the references to [47mdemo[0m use the then-current
  semantic value of [47mdemo[0m, which is [47mb[0m in the first line and [47mc[0m
  throughout the execution of the [47mcnt[0m in the second line.  [47m[Fast
  former][0m is the preferred form, both because of its execution speed
  and its clarity.  If you were writing in a conventional language
  you would have to write something like [47m[fast former][0m because there
  is no way to refer to the 2nd element of the old value of [47mb[0m after
  smashing [47mb[0m unless it had been saved first.

  We turn now to [47m[latter][0m.  It is both clear and efficient.  It creates
  [47mc[0m by assignment to [47mb[0m and then it fetches the 2nd element of [47mc[0m, [47mtwo[0m,
  and proceeds to count the number of occurrences in [47mc[0m.  The answer
  is [47m1[0m.  [47m[Latter][0m is a good example of typical ACL2 array
  manipulation: after the assignment to [47mb[0m that creates [47mc[0m, [47mc[0m is used
  throughout.

  It takes a while to get used to this because most of us have grown
  accustomed to the peculiar semantics of arrays in conventional
  languages.  For example, in raw lisp we might have written
  something like the following, treating [47mb[0m as a ``global variable'':

    (cnt 'demo (aset 'demo b 2 'two) 4 (aref 'demo b 2))

  which sort of resembles [47m[former][0m but actually has the semantics of
  [47m[latter][0m because the [47mb[0m from which [47maref[0m fetches the 2nd element is
  not the same [47mb[0m used in the [47maset[0m!  The array [47mb[0m is destroyed by the
  [47maset[0m and [47mb[0m henceforth refers to the array produced by the [47maset[0m, as
  written more clearly in [47m[latter][0m.

  A Word of Warning: Users must exercise care when experimenting with
  [47m[former][0m, [47m[latter][0m and [47m[fast former][0m.  Suppose you have just
  created [47mb[0m with the assignment shown above,

    ACL2 !>(assign b (aset1 'demo (@ a) 1 'one))

  If you then evaluate [47m[former][0m in ACL2 it will complain that the
  [47m[aref1][0m is slow and compute the answer, as discussed.  Then suppose
  you evaluate [47m[latter][0m in ACL2.  From our discussion you might
  expect it to execute fast --- i.e., issue no complaint.  But in
  fact you will find that it complains repeatedly.  The problem is
  that the evaluation of [47m[former][0m changed the semantic value of [47mdemo[0m
  so that it is no longer [47mb[0m.  To try the experiment correctly you
  must make [47mb[0m be the semantic value of [47mdemo[0m again before the next
  example is evaluated.  One way to do that is to execute

    ACL2 !>(assign b (compress1 'demo (@ b)))

  before each expression.  Because of issues like this it is often hard
  to experiment with ACL2 arrays at the top-level.  We find it easier
  to write functions that use arrays correctly and efficiently than
  to so use them interactively.

  This last assignment also illustrates a very common use of
  [47m[compress1][0m.  While it was introduced as a means of removing
  irrelevant pairs from an array built up by repeated assignments, it
  is actually most useful as a way of insuring fast access to the
  elements of an array.

  Many array processing tasks can be divided into two parts.  During
  the first part the array is built.  During the second part the
  array is used extensively but not modified.  If your [programming]
  task can be so divided, it might be appropriate to construct the
  array entirely with list processing, thereby saving the cost of
  maintaining the semantic value of the name while few references are
  being made.  Once the alist has stabilized, it might be worthwhile
  to treat it as an array by calling [47m[compress1][0m, thereby gaining
  constant time access to it.

  ACL2's theorem prover uses this technique in connection with its
  implementation of the notion of whether a [rune] is [disable]d or
  not.  Associated with every [rune] is a unique integer [47mindex[0m,
  called its ``nume.'' When each rule is stored, the corresponding
  nume is stored as a component of the rule.  [Theories] are lists of
  [rune]s and membership in the ``current theory'' indicates that the
  corresponding rule is [enable]d.  But these lists are very long and
  membership is a linear-time operation.  So just before a proof
  begins we map the list of [rune]s in the current theory into an
  alist that pairs the corresponding numes with [47mt[0m.  Then we compress
  this alist into an array.  Thus, given a rule we can obtain its
  nume (because it is a component) and then determine in constant
  time whether it is [enable]d.  The array is never modified during
  the proof, i.e., [47m[aset1][0m is never used in this example.  From the
  logical perspective this code looks quite odd: we have replaced a
  linear-time membership test with an apparently linear-time [47m[assoc][0m
  after going to the trouble of mapping from a list of [rune]s to an
  alist of numes.  But because the alist of numes is an array, the
  ``apparently linear-time [47m[assoc][0m'' is more apparent than real; the
  operation is constant-time.


Subtopics

  [Aref1]
      Access the elements of a 1-dimensional array

  [Aref2]
      Access the elements of a 2-dimensional array

  [Array1p]
      Recognize a 1-dimensional array

  [Array2p]
      Recognize a 2-dimensional array

  [Arrays-example]
      An example illustrating ACL2 arrays

  [Aset1]
      Set the elements of a 1-dimensional array

  [Aset1-trusted]
      Set the elements of a 1-dimensional array without [invariant-risk]

  [Aset2]
      Set the elements of a 2-dimensional array

  [Compress1]
      Remove irrelevant pairs from a 1-dimensional array

  [Compress2]
      Remove irrelevant pairs from a 2-dimensional array

  [Default]
      Return the [47m:default[0m from the [header] of a 1- or 2-dimensional array

  [Dimensions]
      Return the [47m:dimensions[0m from the [header] of a 1- or 2-dimensional
      array

  [Flush-compress]
      Flush the under-the-hood array for the given name

  [Header]
      Return the header of a 1- or 2-dimensional array

  [Maximum-length]
      Return the [47m:maximum-length[0m from the [header] of an array

  [Maybe-flush-and-compress1]
      Compress a one-dimensional array only if necessary

  [Slow-array-warning]
      A warning or error issued when [arrays] are used inefficiently")
 (ARRAYS-EXAMPLE
  (ARRAYS)
  "An example illustrating ACL2 arrays

  The example below illustrates the use of ACL2 arrays.  It is not, of
  course, a substitute for the detailed explanations provided
  elsewhere (see [arrays], including subtopics).

    ACL2 !>(defun defarray (name size initial-element)
             (compress1 name
                        (cons (list :HEADER
                                    :DIMENSIONS (list size)
                                    :MAXIMUM-LENGTH (1+ size)
                                    :DEFAULT initial-element
                                    :NAME name)
                              nil)))

    Since DEFARRAY is non-recursive, its admission is trivial.  We observe
    that the type of DEFARRAY is described by the theorem
    (AND (CONSP (DEFARRAY NAME SIZE INITIAL-ELEMENT))
         (TRUE-LISTP (DEFARRAY NAME SIZE INITIAL-ELEMENT))).
    We used the :type-prescription rule COMPRESS1.

    Summary
    Form:  ( DEFUN DEFARRAY ...)
    Rules: ((:TYPE-PRESCRIPTION COMPRESS1))
    Warnings:  None
    Time:  0.02 seconds (prove: 0.00, print: 0.02, other: 0.00)
     DEFARRAY
    ACL2 !>(assign my-ar (defarray 'a1 5 17))
     ((:HEADER :DIMENSIONS (5)
               :MAXIMUM-LENGTH 6 :DEFAULT 17 :NAME A1))
    ACL2 !>(aref1 'a1 (@ my-ar) 3)
    17
    ACL2 !>(aref1 'a1 (@ my-ar) 8)

    ACL2 Error in TOP-LEVEL:  The guard for the function symbol AREF1,
    which is
    (AND (ARRAY1P NAME L) (INTEGERP N) (>= N 0) (< N (CAR (DIMENSIONS NAME L)))),
    is violated by the arguments in the call (AREF1 'A1 '(#) 8).

    ACL2 !>(assign my-ar (aset1 'a1 (@ my-ar) 3 'xxx))
     ((3 . XXX)
      (:HEADER :DIMENSIONS (5)
               :MAXIMUM-LENGTH 6 :DEFAULT 17 :NAME A1))
    ACL2 !>(aref1 'a1 (@ my-ar) 3)
    XXX
    ACL2 !>(aset1 'a1 (@ my-ar) 3 'yyy) ; BAD: (@ my-ar) now points to
                                        ;      an old copy of the array!
    ((3 . YYY)
     (3 . XXX)
     (:HEADER :DIMENSIONS (5)
              :MAXIMUM-LENGTH 6 :DEFAULT 17 :NAME A1))
    ACL2 !>(aref1 'a1 (@ my-ar) 3) ; Because of \"BAD\" above, the array
                                   ; access is done using assoc rather
                                   ; than Lisp aref, hence is slower;
                                   ; but the answer is still correct,
                                   ; reflecting the value in (@ my-ar),
                                   ; which was not changed above.

    **********************************************************
    Slow Array Access!  A call of AREF1 on an array named
    A1 is being executed slowly.  See :DOC slow-array-warning
    **********************************************************

    XXX
    ACL2 !>")
 (ASET1
  (ARRAYS ACL2-BUILT-INS)
  "Set the elements of a 1-dimensional array

    Example Form:
    (aset1 'delta1 a (+ i k) 27)

    General Form:
    (aset1 name alist index val)

  where [47mname[0m is a symbol, [47malist[0m is a 1-dimensional array named [47mname[0m,
  [47mindex[0m is a legal index into [47malist[0m, and [47mval[0m is an arbitrary object.
  See [arrays] for details.  Roughly speaking this function
  ``modifies'' [47malist[0m so that the value associated with [47mindex[0m is [47mval[0m.
  More precisely, it returns a new array, [47malist'[0m, of the same name
  and dimension as [47malist[0m that, under [47m[aref1][0m, is everywhere equal to
  [47malist[0m except at [47mindex[0m where the result is [47mval[0m.  That is, [47m(aref1
  name alist' i)[0m is [47m(aref1 name alist i)[0m for all legal indices [47mi[0m
  except [47mindex[0m, where [47m(aref1 name alist' i)[0m is [47mval[0m.

  In order to ``modify'' [47malist[0m, [47maset1[0m [47m[cons][0mes a new pair onto the
  front.  If the length of the resulting alist exceeds the
  [47m:[0m[47m[maximum-length][0m entry in the array [header], [47maset1[0m compresses the
  array as with [47m[compress1][0m.

  It is generally expected that the ``semantic value'' of [47mname[0m will be
  [47malist[0m (see [arrays]).  This function operates in virtually constant
  time whether this condition is true or not (unless the [47m[compress1][0m
  operation is required).  But the value returned by this function
  cannot be used efficiently by subsequent [47maset1[0m operations unless
  [47malist[0m is the semantic value of [47mname[0m when [47maset1[0m is executed.  Thus,
  if the condition is not true, [47maset1[0m prints a [31;1mslow array[0m warning to
  the comment window.  See [slow-array-warning].

  Note that [47m[aset1][0m is marked as having [47m[invariant-risk][0m, which can
  affect the execution of [47m:[0m[47m[program][0m-mode functions.  To get around
  this problem (but only with great care!), see [aset1-trusted].

  [31;1mFunction: [0m<aset1>

    (defun aset1 (name l n val)
      (declare (xargs :guard (and (array1p name l)
                                  (integerp n)
                                  (>= n 0)
                                  (< n (car (dimensions name l))))))
      (let ((l (cons (cons n val) l)))
        (cond ((> (length l) (maximum-length name l))
               (compress1 name l))
              (t l))))


Subtopics

  [Aset1-trusted]
      Set the elements of a 1-dimensional array without [invariant-risk]")
 (ASET1-TRUSTED
  (ARRAYS ACL2-BUILT-INS ASET1)
  "Set the elements of a 1-dimensional array without [invariant-risk]

    Example Form:
    (aset1-trusted 'delta1 a (+ i k) 27)

    General Form:
    (aset1-trusted name alist index val)

  This utility is identical to [47m[aset1][0m; in fact, it has the same guard.
  The difference is that it does not carry [invariant-risk].  Because
  of that, functions that call [47maset1-trusted[0m may suffer from
  invariant-risk but not be noted by the system as carrying
  invariant-risk.  Therefore, [47maset1-trusted[0m it is [untouchable] and
  should be used with great care.  If your system consists of
  [47m:[0m[47m[logic][0m-mode functions, then there is no reason to use
  [47maset1-trusted[0m, because only [47m:[0m[47m[program][0m-mode functions truly carry
  invariant-risk.

  [31;1mFunction: [0m<aset1-trusted>

    (defun aset1-trusted (name l n val)
      (declare (xargs :guard (and (array1p name l)
                                  (integerp n)
                                  (>= n 0)
                                  (< n (car (dimensions name l))))))
      (aset1 name l n val))")
 (ASET2
  (ARRAYS ACL2-BUILT-INS)
  "Set the elements of a 2-dimensional array

    Example Form:
    (aset2 'delta1 a i j 27)

    General Form:
    (aset2 name alist i j val)

  where [47mname[0m is a symbol, [47malist[0m is a 2-dimensional array named [47mname[0m, [47mi[0m
  and [47mj[0m are legal indices into [47malist[0m, and [47mval[0m is an arbitrary object.
  See [arrays] for details.  Roughly speaking this function
  ``modifies'' [47malist[0m so that the value associated with [47m(i . j)[0m is
  [47mval[0m.  More precisely, it returns a new array, [47malist'[0m, of the same
  name and dimension as [47malist[0m that, under [47m[aref2][0m, is everywhere
  equal to [47malist[0m except at [47m(i . j)[0m where the result is [47mval[0m.  That is,
  [47m(aref2 name alist' x y)[0m is [47m(aref2 name alist x y)[0m for all legal
  indices [47mx[0m [47my[0m except [47mi[0m and [47mj[0m where [47m(aref2 name alist' i j)[0m is [47mval[0m.

  In order to ``modify'' [47malist[0m, [47maset2[0m [47m[cons][0mes a new pair onto the
  front.  If the length of the resulting [47malist[0m exceeds the
  [47m:[0m[47m[maximum-length][0m entry in the array [header], [47maset2[0m compresses the
  array as with [47m[compress2][0m.

  It is generally expected that the ``semantic value'' of [47mname[0m will be
  [47malist[0m (see [arrays]).  This function operates in virtually constant
  time whether this condition is true or not (unless the [47m[compress2][0m
  operation is required).  But the value returned by this function
  cannot be used efficiently by subsequent [47maset2[0m operations unless
  [47malist[0m is the semantic value of [47mname[0m when [47maset2[0m is executed.  Thus,
  if the condition is not true, [47maset2[0m prints a [31;1mslow array[0m warning to
  the comment window.  See [slow-array-warning].

  [31;1mFunction: [0m<aset2>

    (defun aset2 (name l i j val)
      (declare (xargs :guard (and (array2p name l)
                                  (integerp i)
                                  (>= i 0)
                                  (< i (car (dimensions name l)))
                                  (integerp j)
                                  (>= j 0)
                                  (< j (cadr (dimensions name l))))))
      (let ((l (cons (cons (cons i j) val) l)))
        (cond ((> (length l) (maximum-length name l))
               (compress2 name l))
              (t l))))")
 (ASH
  (NUMBERS ACL2-BUILT-INS)
  "Arithmetic shift operation

  [47m(ash i c)[0m is the result of taking the two's complement representation
  of the integer [47mi[0m and shifting it by [47mc[0m bits: shifting left and
  padding with [47mc[0m [47m0[0m bits if [47mc[0m is positive, shifting right and dropping
  [47m(abs c)[0m bits if [47mc[0m is negative, and simply returning [47mi[0m if [47mc[0m is [47m0[0m.

  The [guard] for [47mash[0m requires that its arguments are integers.

  [47mAsh[0m is a Common Lisp function.  See any Common Lisp documentation for
  more information.

  [31;1mFunction: [0m<ash>

    (defun ash (i c)
      (declare (xargs :guard (and (integerp i) (integerp c))))
      (floor (* (ifix i) (expt 2 c)) 1))")
 (ASSERT$
  (ERRORS ACL2-BUILT-INS)
  "Cause a hard error if the given test is false

    General Form:
    (assert$ test form)

  where [47mtest[0m returns a single value and [47mform[0m is arbitrary.
  Semantically, this call of [47massert$[0m is equivalent to [47mform[0m.  However,
  it causes a hard error if the value of [47mtest[0m is [47mnil[0m.  That hard
  error invokes the function [47m[illegal][0m, which has a [guard] that is
  equal to [47mnil[0m; so if you use [47massert$[0m in code for which you verify
  guards, then a proof obligation will be that the occurrence of [47mtest[0m
  is never [47mnil[0m.

  See also [47m[assert*][0m.  Both [47m[assert$][0m and [47m[assert*][0m create a [guard]
  proof obligation (when used in a definition made in [47m[logic][0m-mode).
  However, [47massert$[0m checks the assertion at runtime, while [47massert*[0m
  does not.

  Also see [assert-event] for an assertion-checking utility that is an
  [event].")
 (ASSERT*
  (ERRORS ACL2-BUILT-INS)
  "Create a [guard] proof obligation that given test holds

    General Form:
    (assert* test form)

  where [47mtest[0m returns a single value and [47mform[0m is arbitrary.
  Semantically, this call of [47massert*[0m is equivalent to [47mform[0m.  However,
  a [guard] proof obligation is created that [47mtest[0m holds, when used in
  a definition made in [47m[logic][0m-mode.

  For a related utility, see [assert$].  Both [47massert$[0m and [47massert*[0m
  create a [guard] proof obligation (when used in a definition made
  in [47m[logic][0m-mode).  However, [47massert$[0m checks the assertion at
  runtime, while [47massert*[0m does not.

  Also see [assert-event] for an assertion-checking utility that is an
  [event].

  [31;1mMacro: [0m<assert*>

    (defmacro assert* (test form)
      (cons 'and
            (cons (cons 'mbt* (cons test 'nil))
                  (cons form 'nil))))")
 (ASSERT-EVENT
  (EVENTS ERRORS)
  "Assert that a given form returns a non-[47mnil[0m value

  [47mAssert-event[0m provides a flexible way to check that evaluation of an
  expression returns a non-[47mnil[0m value, causing an error otherwise.
  Calls of [47massert-event[0m are [event] forms; thus, they may occur in
  [books] as well as [47m[encapsulate][0m and [47m[progn][0m events.  See also
  [assert!] and [assert!-stobj] for simple interfaces to
  [47massert-event[0m.  See [assert$] and [assert*] for assertion-checking
  utilities to use in programs.

  Basic calls of [47massert-event[0m will take just one argument, called an
  ``assertion'', which is a form that evaluates to a single value
  that is not a [stobj].  The following log shows a successful
  invocation --- one where the assertion evaluates to a non-[47mnil[0m
  value.

    ACL2 !>(assert-event (equal (+ 3 4) 7))
     :PASSED
    ACL2 !>

  Such a use of [47massert-event[0m will probably suffice for most users, that
  is, where the form evaluates to a single non-stobj value and there
  are no keyword arguments.  The keyword arguments, which are
  optional and discussed below, extend that functionality, for
  example: multiple values are permitted by keyword [47m:stobjs-out[0m, and
  keyword [47m:on-skip-proofs[0m can override the default behavior of
  ignoring assertions when proofs are being skipped.

    General Form:
    (assert-event assertion
                  :event event           ; default nil
                  ;; evaluated keyword arguments:
                  :ctx                   ; default 'assert-event
                  :msg msg               ; default t
                  :on-skip-proofs sp     ; default nil
                  :safe-mode safe-mode   ; default :same
                  :stobjs-out stobjs-out ; default nil
                  )

  where [47massertion[0m and [47mevent[0m are not evaluated but all the other
  arguments are evaluated, with the defaults shown above
  corresponding to values after evaluation.

  The following example illustrates all of the keyword arguments, which
  are documented below.

    (assert-event (mv (equal (+ 3 4) 7) state)
                  :event (defun f (x) (cons x x))
                  :ctx '(assert-event . <some-mv>)
                  :msg (msg \"Oops, I forgot what ~x0+~x1 is!\" 3 4)
                  :on-skip-proofs t
                  :safe-mode nil
                  :stobjs-out '(nil state))

  [47mAssert-event[0m is a macro whose expansion directly produces a call of
  the primitive event, [47mvalue-triple[0m, where: if a call of [47massert-event[0m
  specifies [47m:msg msg[0m, then the corresponding call of [47mvalue-triple[0m
  specifies [47m:check (or msg t)[0m.  But unlike [47mvalue-triple[0m, [47massert-event[0m
  can specify an event to evaluate when the assertion has non-[47mnil[0m
  value, using the [47m:event[0m keyword.  (You can get a sense of the
  [47mvalue-triple[0m call generated from an [47massert-event[0m call by using
  [47m:[0m[47m[trans1][0m on the [47massert-event[0m form.)  The remaining keyword
  arguments of [47massert-event[0m are also arguments of [47mvalue-triple[0m.  Here
  is a brief summary of the keyword arguments, but [31;1mNOTE[0m: see
  [value-triple] for more detailed explanations of keywords other
  than [47m:EVENT[0m.

  [47m:EVENT event[0m (default [47mnil[0m): When [47mevent[0m is not [47mnil[0m, it should be an
  [event], that is, a form that may be in a book or a call of
  [47m[encapsulate][0m or [47m[progn][0m.  If the assertion evaluates to a non-[47mnil[0m
  value (or to multiple values where the first value is not a stobj
  and is non-[47mnil[0m; see [47m:STOBJS-OUT[0m below), then [47mevent[0m is evaluated;
  otherwise the evaluation results in an error.

  [47m:CTX ctx[0m (default: [47m'assert-event[0m): context for error messages.

  [47m:MSG msg[0m (default: [47mt[0m): message to print when there is an error
  (equivalent to keyword argument [47m:CHECK[0m of [47m[value-triple][0m).

  [47m:ON-SKIP-PROOFS sp[0m (default: [47mnil[0m): supply [47mt[0m to evaluate the assertion
  even when skipping proofs (i.e., during [47m[include-book][0m or the
  second pass of an [47m[encapsulate][0m event, or after invoking
  [47m[set-ld-skip-proofsp][0m to skip proofs).

  [47m:SAFE-MODE safe-mode[0m (default: [47m:same[0m): provides backward
  compatibility, but is probably best ignored.

  [47m:STOBJS-OUT stobjs-out[0m (default: [47mnil[0m): specify [47m:auto[0m to allow any
  return, even with multiple values provided the first return value
  is not a [stobj]; or specify a list starting with [47mnil[0m,
  corresponding to the multiple values returned, with stobjs in stobj
  positions and [47mnil[0m elsewhere.  A [47mstobjs-out[0m of [47mnil[0m is treated as
  [47m(nil)[0m.  The first return value is the one checked to be non-[47mnil[0m
  with one exception: when an [error-triple] [47m(mv erp val state)[0m is
  returned, [47merp[0m must be [47mnil[0m and it is [47mval[0m that is checked to be
  non-[47mnil[0m.")
 (ASSERTIONS (POINTERS) "See [errors].")
 (ASSIGN
  (PROGRAMMING-WITH-STATE ACL2-BUILT-INS)
  "Assign to a global variable in [47m[state][0m

    Examples:
    (assign x (expt 2 10))
    (assign a (aset1 'ascii-map-array (@ a) 66 'Upper-case-B))

    General Form:
    (assign symbol term)

  where [47msymbol[0m is any symbol (with certain enforced exclusions to avoid
  overwriting ACL2 system ``globals'') and [47mterm[0m is any ACL2 term that
  could be evaluated at the top-level.  [47mAssign[0m evaluates the term,
  stores the result as the value of the given symbol in the
  [47mglobal-table[0m of [47m[state][0m, and returns the result.  (Note: the actual
  implementation of the storage of this value is much more efficient
  than this discussion of the logic might suggest.)  [47mAssign[0m is a
  macro that effectively expands to the more complicated but
  understandable:

    (pprogn (f-put-global 'symbol term state)
            (mv nil (f-get-global 'symbol state) state)).

  The macro [47mf-put-global[0m is closely related to [47m[assign][0m: [47m(assign var
  val)[0m macroexpands to [47m(f-put-global 'var val state)[0m.

  The macro [47m[@][0m gives convenient access to the value of such globals.
  The [47m:[0m[47m[ubt][0m operation has no effect on the [47mglobal-table[0m of [47m[state][0m.
  Thus, you may use these globals to hang onto useful data structures
  even though you may undo back past where you computed and saved
  them.")
 (ASSOC
  (ALISTS ACL2-BUILT-INS)
  "Look up key in association list

    General Forms:
    (assoc x alist)
    (assoc x alist :test 'eql)   ; same as above (eql as equality test)
    (assoc x alist :test 'eq)    ; same, but eq is equality test
    (assoc x alist :test 'equal) ; same, but equal is equality test

  [47m(Assoc x alist)[0m is the first member of [47malist[0m whose [47m[car][0m is [47mx[0m, or [47mnil[0m
  if no such member exists.  The optional keyword, [47m:TEST[0m, has no
  effect logically, but provides the test (default [47m[eql][0m) used for
  comparing [47mx[0m with the [47m[car][0ms of successive elements of [47malist[0m.

  The [guard] for a call of [47massoc[0m depends on the test.  In all cases,
  the second argument must satisfy [47m[alistp][0m.  If the test is [47m[eql][0m,
  then either the first argument must be suitable for [47m[eql][0m (see
  [eqlablep]) or the second argument must satisfy [47m[eqlable-alistp][0m.
  If the test is [47m[eq][0m, then either the first argument must be a
  symbol or the second argument must satisfy [47m[symbol-alistp][0m.

  See [equality-variants] for a discussion of the relation between
  [47massoc[0m and its variants:

      [47m(assoc-eq x alist)[0m is equivalent to [47m(assoc x alist :test 'eq)[0m;

      [47m(assoc-equal x alist)[0m is equivalent to [47m(assoc x alist :test 'equal)[0m.

  In particular, reasoning about any of these primitives reduces to
  reasoning about the function [47massoc-equal[0m.

  [47mAssoc[0m is defined by Common Lisp.  See any Common Lisp documentation
  for more information.

  [31;1mFunction: [0m<assoc-equal>

    (defun assoc-equal (x alist)
      (declare (xargs :guard (alistp alist)))
      (cond ((endp alist) nil)
            ((equal x (car (car alist)))
             (car alist))
            (t (assoc-equal x (cdr alist)))))")
 (ASSOC-EQ (POINTERS) "See [assoc].")
 (ASSOC-EQUAL (POINTERS) "See [assoc].")
 (ASSOC-KEYWORD
  (KEYWORD-VALUE-LISTP ACL2-BUILT-INS)
  "Look up key in a [47m[keyword-value-listp][0m

  If [47ml[0m is a list of even length of the form [47m(k1 a1 k2 a2 ... kn an)[0m,
  where each [47mki[0m is a keyword, then [47m(assoc-keyword key l)[0m is the first
  tail of [47ml[0m starting with [47mkey[0m if key is some [47mki[0m, and is [47mnil[0m
  otherwise.

  The [guard] for [47m(assoc-keyword key l)[0m is [47m(keyword-value-listp l)[0m.

  [31;1mFunction: [0m<assoc-keyword>

    (defun assoc-keyword (key l)
      (declare (xargs :guard (keyword-value-listp l)))
      (cond ((endp l) nil)
            ((eq key (car l)) l)
            (t (assoc-keyword key (cddr l)))))")
 (ASSOC-STRING-EQUAL
  (ALISTS ACL2-BUILT-INS)
  "Look up key, a string, in association list

  [47m(Assoc-string-equal x alist)[0m is similar to [47m[assoc-equal][0m.  However,
  for string [47mx[0m and alist [47malist[0m, the comparison of [47mx[0m with successive
  keys in [47malist[0m is done using [47m[string-equal][0m rather than [47m[equal][0m.

  The [guard] for [47massoc-string-equal[0m requires that [47mx[0m is a string and
  [47malist[0m is an alist.

  [31;1mFunction: [0m<assoc-string-equal>

    (defun assoc-string-equal (str alist)
      (declare (xargs :guard (and (stringp str)
                                  (string-alistp alist))))
      (cond ((endp alist) nil)
            ((string-equal str (car (car alist)))
             (car alist))
            (t (assoc-string-equal str (cdr alist)))))")
 (ASSUME-TRUE-FALSE-AGGRESSIVE-P
  (REWRITE SYSTEM-ATTACHMENTS)
  "Control rewriter's use of the [type-alist] with [47mIF[0m calls

  This topic concerns an advanced control for the ACL2 prover.

  This zero-ary attachable system function controls the rewriter's use
  of the [type-alist] when diving into calls of [47mIF[0m.  By default, when
  ACL2 rewrites what amounts to [47m(if (or test1 test2) (if test1 _ x)
  _)[0m, the type-alist will fail to note that [47mtest2[0m is true when
  rewriting [47mx[0m.  Attach the function [47mconstant-t-function-arity-0[0m to
  strengthen the use of the type-alist so that [47mtest2[0m is instead noted
  as true in that case.  Note that this strengthening may slow down
  ACL2 considerably in some cases, and should rarely if ever be
  necessary when calling the prover; but it can be useful in
  applications that call the rewriter directly.  Attach the function
  [47mconstant-nil-function-arity-0[0m to restore the default behavior.")
 (ATOM
  (CONSES ACL2-BUILT-INS)
  "Recognizer for atoms

  [47m(atom x)[0m is true if and only if [47mx[0m is an atom, i.e., not a [47m[cons][0m
  pair.

  [47mAtom[0m has a [guard] of [47mt[0m, and is a Common Lisp function.  See any
  Common Lisp documentation for more information.

  [31;1mFunction: [0m<atom>

    (defun atom (x)
      (declare (xargs :guard t))
      (not (consp x)))


Subtopics

  [Atom-listp]
      Recognizer for a true list of [atom]s")
 (ATOM-LISTP
  (ATOM LISTS ACL2-BUILT-INS)
  "Recognizer for a true list of [atom]s

  The predicate [47matom-listp[0m tests whether its argument is a [47m[true-listp][0m
  of [atom]s, i.e., of non-conses.

  [31;1mFunction: [0m<atom-listp>

    (defun atom-listp (lst)
      (declare (xargs :guard t))
      (cond ((atom lst) (eq lst nil))
            (t (and (atom (car lst))
                    (atom-listp (cdr lst))))))")
 (ATTACH-STOBJ
  (DEFABSSTOBJ)
  "Attach an ``implementation [stobj]'' to an attachable stobj

  For an illustration of [47mattach-stobj[0m, see [community-books] directory
  [47mbooks/demos/attach-stobj/[0m, in particular file [47mREADME.txt[0m in that
  directory.

  This topic assumes familiarity with abstract [stobj]s; see
  [defabsstobj].  It documents a way to modify the foundation and
  primitives of an abstract [stobj], [47mgen[0m, that is introduced by
  [47mdefabsstobj[0m using the keyword argument [47m:attachable t[0m.  Such a stobj
  is called an [3mattachable[0m stobj.  Execution of its primitives can be
  provided by corresponding primitives of a specified abstract stobj,
  [47mimpl[0m, which we say is [3mattached to[0m [47mgen[0m (or: [47mimpl[0m is the
  [3mimplementation stobj attached to[0m [47mgen[0m); said differently, [47mgen[0m has
  [47mimpl[0m as an attachment.  That relationship is specified by the
  following

    General Form:
    (attach-stobj gen impl)

  where [47mgen[0m and [47mimpl[0m are symbols, [47mgen[0m is not currently the [name] of
  any [event] (function, macro, constant, stobj, etc.), and [47mimpl[0m is
  an abstract stobj.  A subsequent attempt to introduce [47mgen[0m as an
  attachable stobj will require [47mgen[0m and [47mimpl[0m to have [3mcorresponding
  logical skeletons[0m as described below.  In that case, the foundation
  of [47mgen[0m, as well as execution of the primitives of [47mgen[0m, will
  effectively be provided by [47mimpl[0m; details are below.

  In the General Form above, [47mimpl[0m is allowed to be [47mnil[0m, i.e., the event
  [47m(attach-stobj gen nil)[0m is legal, where it is still required that
  [47mgen[0m not be the name of any existing event.  The effect of this
  ``attachment'' of [47mnil[0m is to cancel the effect of any previous
  [47m(attach-stobj gen impl)[0m on any future introduction of [47mgen[0m.  Below,
  we assume the common case that [47mimpl[0m is not [47mnil[0m.

  Note that [47mimpl[0m may itself have an attachment, say, [47mimpl2[0m, in which
  case we say that [47mimpl2[0m is attached to [47mgen[0m.  If furthermore [47mimpl3[0m is
  attached to [47mimpl2[0m, then [47mimpl3[0m is said to be attached to [47mgen[0m; and so
  on.

  The guiding principle is that [47mgen[0m is modified by its attachment to
  [47mimpl[0m so that [47mgen[0m behaves exactly as [47mimpl[0m except for the names
  introduced and the [47m:non-executable[0m keyword.  Specifically, if [47mimpl[0m
  is attached to [47mgen[0m, then the following properties hold.  (See
  [defabsstobj] for the notion of a ``function spec'' and its
  ``completion''.)

    * Both [47mgen[0m and [47mimpl[0m are abstract stobjs, and moreover, [47mgen[0m is an
      attachable stobj.

    * [47mImpl[0m was introduced before the use of [47mattach-stobj[0m to attach [47mimpl[0m to
      [47mgen[0m, which took place before [47mgen[0m was introduced.

    * [47mGen[0m and [47mimpl[0m have corresponding logical skeletons (as defined below).
      In particular, each primitive of [47mgen[0m has the same logical
      meaning (i.e., the same [47m:logic[0m function) as the corresponding
      primitive of [47mimpl[0m.

    * For each primitive [47mp_gen[0m of [47mgen[0m and corresponding primitive [47mp_impl[0m of
      [47mimpl[0m, if [47m(p_impl . kwd-alist)[0m is the completion of the
      corresponding function spec for [47mp_impl[0m, then the function spec
      for [47mp_gen[0m is effectively given as [47m(p_gen . kwd-alist)[0m, with the
      following exception.  Each [47m:updater[0m keyword is replaced
      appropriately, as follows: if [47mkwd-alist[0m specifies [47m:updater
      u_impl[0m and primitive [47mu_gen[0m of [47mgen[0m corresponds to primitive
      [47mu_impl[0m of [47mimpl[0m, then [47m:updater u_impl[0m is replaced by [47m:updater
      u_gen[0m to obtain the effective function spec for [47mp_gen[0m.

    * The [47m:protect-default[0m and [47m:congruent-to[0m keyword arguments for [47mgen[0m are
      effectively those of [47mimpl[0m.

    * The [47m:non-executable[0m keyword argument for [47mgen[0m is unchanged by the
      attachment.

  As promised above, we now define when two [47mdefabsstobj[0m events have
  [3mcorresponding logical skeletons[0m, as follows.  The [47m:exports[0m keyword
  argument of each must be of the same length, establishing a
  positional one-one correspondence between them.  Corresponding
  exports (i.e., exports in the same position) must have the same
  [47m:logic[0m functions and, if one of them specifies [47m:updater u1[0m, then
  the other must specify [47m:updater u2[0m where [47mu1[0m and [47mu2[0m correspond.

  Remarks on Performance.  Stobj attachments are designed to be
  efficient.  There is no indirection: in raw Lisp, each primitive
  macroexpands to a call of the [47m:exec[0m primitive of the attachment
  (which is itself a macro call).  The trade-off is that when a
  function [47mF[0m is defined in the course of evaluating an [47m[include-book][0m
  event, then if the guard or body of [47mF[0m calls an attachable stobj
  primitive --- either directly or by way of inline functions or
  macroexpansion, and whether or not that stobj has an attachment ---
  then [47mF[0m will be compiled at that time.  (This is in contrast to the
  usual case, where compiled code from the book's compiled file will
  be installed to avoid such recompilation.)  Most likely this will
  not be a noticeable problem in practice, but if it is, then one can
  define a wrapper --- a function that does nothing more than call
  the primitive --- to avoid such recompilation at the cost of a
  runtime function call for each such primitive.  End of Remarks on
  Performance.

  Note that the notion of redundancy for [47mdefabsstobj[0m was not changed by
  support for the [47m:attachable[0m keyword.  As noted in the topic
  [redundant-events], a [47mdefabsstobj[0m event is redundant if there is
  already an identical such event in the logical [world].

  The [community-books] directory [47msystem/tests/attachable-stobjs/[0m has
  examples that use attachable stobjs.")
 (AUTO-INSTANCE (POINTERS)
                "See [defthm<w].")
 (A_FLYING_TOUR_OF_ACL2
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "A Flying Tour of ACL2

  {IMAGE} (see [About_the_ACL2_Home_Page])

  On this tour you will learn a little about what ACL2 is for rather
  than how ACL2 works.  At the top and bottom of the ``page'' there
  are ``flying tour'' icons.  Click on either icon to go to the next
  page of the tour.

  The tour visits the following topics sequentially.  But on your first
  reading, don't navigate through the tour by clicking on these
  links; they are shown as live links only so that later you can
  determine what you've visited.  Instead, just use the flying tour
  icons.

    [31;1mThe Flight Plan[0m
    * This Documentation (see [About_the_ACL2_Home_Page])
    * What is ACL2? (see [What_Is_ACL2{Q}])
    * Mathematical Logic (see [What_is_a_Mathematical_Logic{Q}])
    * Mechanical Theorem Proving (see [What_is_a_Mechanical_Theorem_Prover{Q}])
    * Mathematical Models in General (see [About_Models])
    * Mathematical Models of Computing Machines (see [Models_of_Computer_Hardware_and_Software])
         Formalizing Models (see [A_Typical_State])
         Running Models (see [Running_Models])
         Symbolic Execution of Models (see [Symbolic_Execution_of_Models])
         Proving Theorems about Models (see [Proving_Theorems_about_Models])
    * Requirements of ACL2
         The User's Skills (see [What_is_Required_of_the_User{Q}])
         Training (see [How_Long_Does_It_Take_to_Become_an_Effective_User{Q}])
         Host System (see [Other_Requirements])

  On your first reading, don't explore other links you see in the tour.
  Some of them lead to the Walking Tour, which you can take
  coherently when you finish this tour.  Others lead into the
  extensive hypertext documentation and you are liable to get lost
  there unless you're trying to answer a specific question.  We
  intend the tour to take about 10 minutes of your time.

  {IMAGE} (see [About_the_ACL2_Home_Page])")
 (A_SKETCH_OF_HOW_THE_REWRITER_WORKS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "A Sketch of How the Rewriter Works

  Below we show the first target term, extracted from the current
  conjecture.  Below it we show the associativity rule.

  {IMAGE}

  The variables of the rewrite rule are [31;1minstantiated[0m so that the
  [31;1mleft-hand side[0m of the rule matches the target:

    variable          term from target
      a                     x1
      b                     x2
      c                     (app x3 x4)

  Then the target is [31;1mreplaced[0m by the instantiated [31;1mright-hand side[0m of
  the rule.

  Sometimes rules have [31;1mhypotheses[0m.  To make a long story short, if the
  rule has hypotheses, then after matching the left-hand side, the
  rewriter instantiates the hypotheses and rewrites them recursively.
  This is called [31;1mbackchaining[0m.  If they all rewrite to true, then the
  target is replaced as above.

  We discuss the rewriter in more detail in the extended introduction
  to how to use the theorem prover, see
  [introduction-to-the-theorem-prover], which we will recommend you
  work through [31;1mafter[0m you have finished the two tours.")
 (A_TINY_WARNING_SIGN
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "A Tiny Warning Sign

  {IMAGE}

  This warning sign, which usually appears as ``{ICON}'', indicates
  that the link it marks takes you into ACL2's online documentation.

  The documentation is a vast graph of documented topics intended to
  help the [3muser[0m of ACL2 rather than the [3mpotential user[0m.  If you are
  exploring ACL2's home page to learn about the system, perhaps you
  should go back rather than follow the link marked with this sign.
  But you are welcome to explore the online documentation as well.
  Good luck.")
 (A_TRIVIAL_PROOF (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
                  "A Trivial Proof

  {IMAGE}")
 (A_TYPICAL_STATE
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "A Typical State

  {IMAGE} (see [Functions_for_Manipulating_these_Objects])

  {IMAGE}

  Observe that the states in typical models talk about

    [31;1mbooleans[0m    [31;1mintegers[0m   [31;1mvectors[0m     [31;1mrecords[0m   [31;1mcaches[0m
    [31;1mbits[0m        [31;1msymbols[0m    [31;1marrays[0m      [31;1mstacks[0m    [31;1mfiles[0m
    [31;1mcharacters[0m  [31;1mstrings[0m    [31;1msequences[0m   [31;1mtables[0m    [31;1mdirectories[0m

  These objects are [31;1mdiscrete[0m rather than [31;1mcontinuous[0m; furthermore they
  are built incrementally or [31;1minductively[0m by repeatedly using
  primitive operations to put together smaller pieces.

  The functions we need to manipulate these objects do things like
  [31;1mconcatenate[0m, [31;1mreverse[0m, [31;1msort[0m, [31;1msearch[0m, [31;1mcount[0m, etc.

  {IMAGE} (see [Functions_for_Manipulating_these_Objects])")
 (A_WALKING_TOUR_OF_ACL2
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "A Walking Tour of ACL2

  {IMAGE} (see [Common_Lisp])

  On this tour you will learn a little more about the ACL2 logic, the
  theorem prover, and the user interface.

  This time we will stick with really simple things, such as the
  associativity of list concatenation.

  We assume you have taken the Flying Tour but that you did not
  necessarily follow all the ``off-tour'' links because we encouraged
  you not to.  With the Walking Tour we encourage you to visit
  off-tour links --- provided they are not marked with the tiny
  warning sign ({ICON} (see [A_Tiny_Warning_Sign])).  But they are
  ``branches'' in the tour that lead to ``dead ends.'' When you reach
  a dead end, remember to use your browser's Back Button to return to
  the Walking Tour to continue.

  When you get to the end of the tour we'll give you a chance to repeat
  quickly both the Flying and the Walking Tours to visit any off-tour
  links still of interest.

  {IMAGE} (see [Common_Lisp])")
 (BACKCHAIN-LIMIT
  (REWRITE META LINEAR TYPE-PRESCRIPTION)
  "Limiting the effort expended on relieving hypotheses

  Before ACL2 can apply a rule with hypotheses, it must establish that
  the hypotheses are true.  (We ignore the relaxing of this
  requirement afforded by [47m[case-split][0ms and [47m[force][0md hypotheses.)
  ACL2 typically establishes each hypothesis by backchaining ---
  instantiating the hypothesis and then rewriting it recursively.
  Here we describe how ACL2 allows the user to limit backchaining.
  At the end, below, we describe the function [47m[backchain-limit][0m.

  Each hypothesis of a [47m[rewrite][0m, [47m[meta][0m, [47m[linear][0m, or
  [47m[type-prescription][0m rule is assigned a backchain-limit when the
  rule is stored.  By default, this limit is [47mnil[0m, denoting infinity
  (no limit).  However, the value used for the default may be set to
  a non-negative integer (or to [47mnil[0m) by the user; see
  [set-default-backchain-limit].  The default is overridden when a
  [47m:backchain-limit-lst[0m is supplied explicitly with the rule; see
  [rule-classes].  The number of recursive applications of
  backchaining starting with the hypothesis of a rule is limited to
  the backchain-limit associated with that hypothesis.

  Moreover, the user may set global backchain-limits that limit the
  total backchaining depth.  See [set-backchain-limit].  One limit is
  for the use of [47m[rewrite][0m, [47m[meta][0m, and [47m[linear][0m rules, while the
  other limit is for so-called ``type reasoning'', which uses rules
  of class [47m[type-prescription][0m rules (see [type-reasoning]).  The two
  limits operate independently.  Below, we discuss the first kind of
  backchain limits, i.e., for other than [47m[type-prescription][0m rules,
  except as otherwise indicated; but the mechanism for those rules is
  similar.

  Below we lay out the precise sense in which a global backchain-limit
  interacts with the backchain-limits of individual rules in order to
  limit backchaining.  But first we note that when further
  backchaining is disallowed, ACL2 can still prove a hypothesis in a
  given context by using that contextual information.  In fact, type
  reasoning may be used (except that a weaker version of it is used
  in the second case above, i.e., where we are already doing type-set
  reasoning).  Thus, the relieving of hypotheses may be limited to
  the use of contextual information (without backchaining, i.e.,
  without recursively rewriting hypotheses) by executing
  [47m:set-backchain-limit 0[0m.

  Recall that there are two sorts of backchain limits: those applied to
  hypotheses of individual rules, as assigned by their
  [47m:[0m[47m[rule-classes][0m or else taken from the default (see
  [set-default-backchain-limit]); and the global limit, initially [47mnil[0m
  (no limit) but settable with [47m:[0m[47m[set-backchain-limit][0m.  Here is how
  these two types of limits interact to limit backchaining, i.e.,
  recursive rewriting of hypotheses.  ACL2 maintains a current
  backchain limit, which is the limit on the depth of recursive calls
  to the rewriter, as well as a current backchain depth, which is
  initially 0 and is incremented each time ACL2 backchains (and is
  decremented when a backchain completes).  When ACL2 begins to
  rewrite a literal (crudely, one of the ``top-level'' terms of the
  goal currently being worked on), it sets the current
  backchain-limit to the global value, which is initially [47mnil[0m but can
  be set using [47m:[0m[47m[set-backchain-limit][0m.  When ACL2 is preparing to
  relieve a hypothesis by backchaining (hence, after it has already
  tried type-set reasoning), it first makes sure that the current
  backchain limit is greater than the current backchain depth.  If
  not, then it refuses to relieve that hypothesis.  Otherwise, it
  increments the current backchain depth and calculates a new current
  backchain-limit by taking the minimum of two values: the existing
  current backchain-limit, and the sum of the current backchain depth
  and the backchain-limit associated with the hypothesis.  Thus, ACL2
  only modifies the current backchain-limit if it is necessary to
  decrease that limit in order to respect the backchain limit
  associated with the hypothesis.

  We illustrate with the following examples.

    ; We stub out some functions so that we can reason about them.

    (defstub p0 (x) t)
    (defstub p1 (x) t)
    (defstub p2 (x) t)
    (defstub p3 (x) t)

    ; Initially, the default-backchain-limit is nil, or infinite.

    (defaxiom p2-implies-p1-limitless
      (implies (p2 x)
               (p1 x)))

    ; The following rule will have a backchain-limit of 0.

    (defaxiom p1-implies-p0-limit-0
      (implies (p1 x)
               (p0 x))
      :rule-classes ((:rewrite :backchain-limit-lst 0)))

    ; We have (p2 x) ==> (p1 x) ==> (p0 x).  We wish to establish that
    ; (p2 x) ==> (p0 x).  Normally, this would be no problem, but here
    ; we fail because ACL2 cannot establish (p0 x) by type-set reasoning
    ; alone.

    (thm
      (implies (p2 x)
               (p0 x)))

    ; We set the default-backchain-limit (for rewriting) to 1.

    :set-default-backchain-limit 1

    ; The following is more powerful than p1-implies-p0-limit-0
    ; because it can use rewrite rules to establish (p1 x).

    (defaxiom p1-implies-p0-limit-1
      (implies (p1 x)
               (p0 x)))

    ; This theorem will succeed:

    (thm
      (implies (p2 x)
               (p0 x)))

    ; We return the default-backchain-limit to its initial value.

    :set-default-backchain-limit nil

    ; Here is our last axiom.

    (defaxiom p3-implies-p2-limitless
      (implies (p3 x)
               (p2 x)))

    ; We now have (p3 x) ==> (p2 x) ==> (p1 x) ==> (p0 x).  However the
    ; rule p1-implies-p0-limit-1 has a backchain-limit of 1; hence we
    ; are not allowed to backchain far enough back to use
    ; p3-implies-p2-limitless.  We therefore lose.

    (defthm will-fail
      (implies (p3 x)
               (p0 x)))

  Finally, we remark that to see the current global backchain-limits,
  issue the following commands.

    (backchain-limit wrld :ts) ; backchain limit for type-set reasoning
    (backchain-limit wrld :rewrite) ; backchain limit for rewriting


Subtopics

  [Set-backchain-limit]
      Sets the backchain-limit used by the type-set and rewriting
      mechanisms

  [Set-default-backchain-limit]
      Sets the default backchain-limit used when admitting a rule")
 (BACKCHAIN-LIMIT-RW
  (POINTERS)
  "See [hints] for information about the keyword [47m:backchain-limit-rw[0m.")
 (BACKCHAINING
  (RULE-CLASSES)
  "Attempting to relieve the hypotheses of a rule

  When the theorem prover attempts to apply a rule (e.g., a [rewrite]
  rule), it must relieve (prove) the hypotheses of that rule.  In the
  ACL2 community, this process of relieving hypotheses is called
  backchaining.

  There is no such thing as a backchaining or backward-chaining rule
  class (see [rule-classes]) in ACL2.")
 (BACKQUOTE
  (READER)
  "Variant of quotation introducing templates for data structures

  ACL2 supports the backquote ([47m`[0m) construct of Common Lisp.  See any
  Common Lisp documentation for details, for example, its {discussion
  in the Common Lisp HyperSpec |
  http://www.lispworks.com/documentation/HyperSpec/Body/02_df.htm}.
  Here we give only a brief introduction.

  Together with the use of comma ([47m,[0m) and comma-atsign ([47m,@[0m), backquote
  provides a variant of quote that supports an escape mechanism, as
  illustrated by the following examples.

    ACL2 !>`(a b c)
    (A B C)
    ACL2 !>(let ((x '(a b c))) `(1 ,(cdr x) 2))
    (1 (B C) 2)
    ACL2 !>(let ((x '(a b c))) `(1 ,@(cdr x) 2))
    (1 B C 2)
    ACL2 !>

  The first example above illustrates that backquote is much like
  quote.  The second example shows how a comma escapes from the
  quotation, inserting the value of the object that follows the
  comma.  The third example is similar to the second, except that it
  uses comma followed by an atsign, which splices in the value (which
  must satisfy [47m[true-listp][0m) rather than inserting it.")
 (BACKTRACK
      (POINTERS)
      "See [hints] for information about the keyword [47m:backtrack[0m.")
 (BADGE
  (APPLY$)
  "Syntactic requirements on a function symbol to be used by [47mapply$[0m

  ``Badge'' is both the name of an ACL2 function and the name of a
  concept key to the [47m[apply$][0m machinery.  We discuss the function
  named [47mbadge[0m first.  The discussion also mentions the concept of
  warrants, which are easily confused with badges.  See the
  discussion of [31;1mBadges versus Warrants[0m at the top of [47mdefbadge[0m.  But
  roughly put, badges extend the ACL2 syntax and warrants extend the
  proof theory.  You'll need a badge for [47mfn[0m to allow the system to
  syntactically analyze [47m(apply$ 'fn ...)[0m.  You'll need a both a badge
  and a warrant for [47mfn[0m if you wish to reason about that term with
  ACL2.

  General Form:

    (badge fn)

  The argument, [47mfn[0m, is expected to be a function symbol.  If [47mfn[0m is one
  of about 800 ACL2 primitives (discussed below) or is a user-defined
  function successfully processed by either the event [47m[defbadge][0m or
  the event [47m[defwarrant][0m, the result is an object, called the
  ``badge'' of [47mfn[0m, which among other things specifies the [ilk] of
  each formal of [47mfn[0m.  Otherwise, an error is caused.  We explain
  below, where we define the concepts of the ``out arity,'' ``ilks,''
  and ``tameness requirements'' of [47mfn[0m's badge.

  A function symbol must have a badge in order to [47mapply$[0m the symbol and
  it is up to you, the user, to invoke an event that will assign a
  badge to your user-defined functions, if possible.  [47mDefbadge[0m will
  assign a badge to a function symbol, if possible, and [47mdefwarrant[0m
  will assign both a badge (if the function symbol doesn't already
  have one) and a [47m[warrant][0m, if possible.  The macro [47m[defun$][0m is just
  an abbreviation for a [47mdefun[0m followed by a [47mdefwarrant[0m.  Almost all
  primitive system functions already have badges.

  The complete list of badged primitives can be seen by evaluating

    (append '(BADGE TAMEP TAMEP-FUNCTIONP SUITABLY-TAMEP-LISTP
                    APPLY$ EV$)
            (strip-cars *badge-prim-falist*))

  [47mBadge[0m is a defined function in ACL2.  You can inspect its definition
  with

    ACL2 !>:pe badge

  and see that after handling the built-in symbols it defers to the
  undefined function [47m[badge-userfn][0m.  In the evaluation theory,
  [47mbadge-userfn[0m has an attachment that returns the badge computed by
  [47mdefbadge[0m or [47mdefwarrant[0m.  But in the proof theory, [47mbadge-userfn[0m is
  undefined and the [47m[warrant][0m for [47mfn[0m specifies the badge of [47mfn[0m.
  Thus, in the proof theory, you cannot reason about the application
  of a non-primitive function unless there is a warrant for the
  function available as a hypothesis.

  The rest of this documentation illustrates and explains what badges
  mean, starting with a few examples.

    ACL2 !>(badge 'cons)
    (APPLY$-BADGE 2 1 . T)

    ACL2 !>(badge 'apply$)
    (APPLY$-BADGE 2 1 :FN NIL)

    ACL2 !>(badge 'foldr)
    (APPLY$-BADGE 3 1 NIL :FN NIL)

  The last example assumes that [47mfoldr[0m has been defined with

    (defun$ foldr (lst fn init)
      (if (endp lst)
          init
          (apply$ fn
                  (list (car lst)
                        (foldr (cdr lst) fn init)))))

  In general, badges have the form [47m(APPLY$-BADGE n k . ilks)[0m, where [47mn[0m
  is the arity of [47mfn[0m, [47mk[0m is the out arity (i.e., the number of results
  returned by [47mfn[0m) and [47milks[0m is either [47mT[0m or a list of [47mn[0m tokens.  Each
  token is either [47m:FN[0m, [47m:EXPR[0m, or [47mNIL[0m.

  The badge of [47mfn[0m, if any, is computed when the event [47m(defbadge fn)[0m or
  [47m(defwarrant fn)[0m completes successfully.  See [47m[defbadge][0m for a
  sketch of the algorithm used to compute badges.  Here though we are
  just concerned with how badges impact [47mapply$[0m.

  The [47milks[0m of a function, [47mfn[0m, determines the ``tameness requirements''
  mentioned in the specification of [47m[apply$][0m.  When the [47milks[0m
  component of [47mfn[0m's badge is a list, it has as many elements as there
  are formals to [47mfn[0m and each successive element is called the [3milk[0m of
  the corresponding formal.  For example, given the definition of
  [47mfoldr[0m above and the badge shown for it, the first and third
  formals, [47mlst[0m and [47minit[0m, each have ilk [47mNIL[0m and the second formal, [47mfn[0m,
  has ilk [47m:FN[0m.  In the special case that [47milks[0m is not a list it is [47mT[0m
  and we just say each formal has [3milk[0m [47mNIL[0m -- treating that [47mT[0m as a
  suitably long list of [47mNIL[0ms.

  Each non-[47mNIL[0m ilk imposes a [3mtameness requirement[0m on [47m(apply$ fn args)[0m.
  If a formal has ilk [47m:FN[0m the corresponding element of [47margs[0m must
  satisfy [47mtamep-functionp[0m.  If a formal has ilk [47m:EXPR[0m the
  corresponding element of [47margs[0m must satisfy [47mtamep[0m.  Ilk [47mNIL[0m imposes
  no requirement.  (Thus, if the [47milks[0m of [47mfn[0m's badge is [47mT[0m, as it is
  for [47mcons[0m for example, there is no tameness requirement at all.)
  See [tame] for a discussion of the various notions of tameness.

  Informally, if a formal's ilk is [47m:FN[0m, the corresponding element of
  [47margs[0m must be a tame function symbol or well-formed [47mLAMBDA[0m object.
  If a formal's ilk is [47m:EXPR[0m, the corresponding element of [47margs[0m must
  be a tame expression.

  If a formal has ilk [47m:FN[0m then you are allowed to put a [47m[lambda$][0m
  expression in that slot.  Any quoted [47mLAMBDA[0m object you explicitly
  write in such a slot must be well-formed (see
  [well-formed-lambda-objectp]).  Well-formedness can be hard to
  achieve in quoted hand-written [47mLAMBDA[0m objects; we recommend that
  you use [47mlambda$[0m!  But the restrictions on what can occupy a [47m:FN[0m
  slot are enforced when user input is translated into formal terms.
  It is possible to circumvent these syntactic checks without
  endangering soundness: axiomatically [47mapply$[0m puts no restrictions on
  its arguments, it just doesn't behave the way you might expect on
  ill-formed [47mLAMBDA[0m objects.  See
  [gratuitous-lambda-object-restrictions].

  [31;1mClarification[0m: The careful reader will note that the formal
  requirement on a [47m:FN[0m argument is that it must satisfy
  [47mtamep-functionp[0m.  Inspection of the definition of [47mtamep-functionp[0m
  reveals that the argument must either be badged symbol with ilks [47mT[0m
  or else be a tame [47mLAMBDA[0m object.  But in the informal description
  above we said that it must be a ``tame function symbol or a
  [3mwell-formed[0m [47mLAMBDA[0m object.'' Well-formedness implies tameness but
  they are not the same.  What's going on?  The reason for this and
  related discrepancies in the documentation is that there is a
  tension between the logical definition of [47mapply$[0m and the practical
  business of executing it.  The former involves the existence of a
  model, soundness, and the difficulty of proving theorems about
  [47mapply$[0m.  The latter involves the Common Lisp compiler.  We want the
  logical foundations to be simple so we -- and you -- can reason
  about [47mapply$[0m, but the compiler imposes unavoidable and complicated
  restrictions.  The upshot is that the logical foundations assign
  meaning to [47mLAMBDA[0m objects that cannot be compiled.  Applying merely
  ``tame'' [47mLAMBDA[0ms is slower than applying ``well-formed'' ones.  In
  a sense by acting like ``tame [47mLAMBDA[0m objects'' and ``well-formed
  [47mLAMBDA[0m objects'' are the same thing we're trying to trick you!  If
  you ever have occasion to formally express the restrictions on
  [47mapply$[0m in some theorem, use [47mtamep-functionp[0m.  But when you write
  concrete [47mLAMBDA[0m constants, try to keep them well-formed.  We try to
  encourage this by providing [47m[lambda$][0m, which guarantees
  well-formedness at translate-time, and by implementing full
  well-formedness checks -- not just tameness checks -- on quoted
  [47mLAMBDA[0m objects in [47m:FN[0m slots.  And we give you ways to circumvent
  these checks -- see [gratuitous-lambda-object-restrictions] -- if
  you really mean to.")
 (BADGE-USERFN
  (APPLY$)
  "Undefined function used by [47mbadge[0m on non-primitives

  When [47m[badge][0m is given a non-primitive function symbol [47mfn[0m it calls
  this function to determine the badge of [47mfn[0m.  But this function is
  undefined.  In the proof theory, its value on a given function
  symbol [47mfn[0m is specified, if at all, by the [47m[warrant][0m for [47mfn[0m which
  must be available as a hypothesis in the formula being proved.  In
  the evaluation theory, [47mbadge-userfn[0m has an attachment that makes it
  behave as though all warrants are assumed.  See [47m[badge][0m for
  details.")
 (BASICS
  (PROGRAMMING)
  "Basic control structures for [programming] like [if] and [cond],
  binding operators like [let] and [flet], multiple-value constructs
  like [mv], and so forth.


Subtopics

  [ACL2-count]
      A commonly used measure for justifying recursion

  [And]
      Conjunction

  [Booleanp]
      Recognizer for booleans

  [Case]
      Conditional based on if-then-else using [47m[eql][0m

  [Case-match]
      Pattern matching or destructuring

  [Cond]
      Conditional based on if-then-else

  [Equal]
      True equality

  [Flet]
      Local binding of function symbols

  [Good-bye]
      Quit entirely out of Lisp

  [Identity]
      The identity function

  [If]
      If-then-else function

  [Iff]
      Logical ``if and only if''

  [Implies]
      Logical implication

  [Let]
      Binding of lexically scoped (local) variables

  [Let*]
      Binding of lexically scoped (local) variables

  [Macrolet]
      Local binding of macro symbols

  [Mv]
      Returning a multiple value

  [Mv-let]
      Calling multi-valued ACL2 functions

  [Not]
      Logical negation

  [Null]
      Recognizer for the empty list

  [Or]
      Disjunction

  [Progn$]
      Execute a sequence of forms and return the value of the last one

  [Quote]
      Create a constant

  [Return-last]
      Return the last argument, perhaps with side effects

  [Xor]
      Logical ``exclusive or''")
 (BDD
  (ACL2)
  "Ordered binary decision diagrams with rewriting

  Note.  The ACL2 bdd capability has been essentially superseded by GL;
  see [gl].

  Ordered binary decision diagrams (OBDDs, often simply called BDDs)
  are a technique, originally published by Randy Bryant, for the
  efficient simplification of Boolean expressions.  In ACL2 we
  combine this technique with rewriting to handle arbitrary ACL2
  terms that can represent not only Boolean values, but non-Boolean
  values as well.  In particular, we provide a setting for deciding
  equality of bit vectors (lists of Boolean values).

  An introduction to BDDs for the automated reasoning community may be
  found in ``Introduction to the OBDD Algorithm for the ATP
  Community'' by J Moore, [3mJournal of Automated Reasoning[0m (1994), pp.
  33--45.  (This paper also appears as Technical Report #84 from
  Computational Logic, Inc.)

  Further information about BDDs in ACL2 can be found in the subtopics
  of this [documentation] section.  In particular, see
  [bdd-introduction] for a good starting place that provides a number
  of examples.

  See [hints] for a description of [47m:bdd[0m hints.  For quick reference,
  here is an example; but only the [47m:vars[0m part of the hint is
  required, as explained in the documentation for [hints].  The
  values shown are the defaults.

    (:vars nil :bdd-constructors (cons) :prove t :literal :all)

  We suggest that you next visit the documentation topic
  [bdd-introduction].


Subtopics

  [Bdd-algorithm]
      Summary of the BDD algorithm in ACL2

  [Bdd-introduction]
      Examples illustrating the use of BDDs in ACL2

  [If*]
      For conditional rewriting with BDDs

  [Obdd]
      Ordered binary decision diagrams with rewriting

  [Show-bdd]
      Inspect failed BDD proof attempts")
 (BDD-ALGORITHM
  (BDD)
  "Summary of the BDD algorithm in ACL2

  The BDD algorithm in ACL2 uses a combination of manipulation of [47mIF[0m
  terms and unconditional rewriting.  In this discussion we begin
  with some relevant mathematical theory.  This is followed by a
  description of how ACL2 does BDDs, including concluding discussions
  of soundness, completeness, and efficiency.

  We recommend that you read the other documentation about BDDs in ACL2
  before reading the rather technical material that follows.  See
  [bdd].

  Here is an outline of our presentation.  Readers who want a user
  perspective, without undue mathematical theory, may wish to skip to
  Part (B), referring to Part (A) only on occasion if necessary.

  (A) [31;1mMathematical Considerations[0m

      (A1) BDD term order

      (A2) BDD-constructors and BDD terms, and their connection with
      aborting the BDD algorithm

      (A3) Canonical BDD terms

      (A4) A theorem stating the equivalence of provable and syntactic
      equality for canonical BDD terms

  (B) [31;1mAlgorithmic Considerations[0m

      (B1) BDD rules (rules used by the rewriting portion of the ACL2 BDD
      algorithm)

      (B2) Terms ``known to be Boolean''

      (B3) An ``IF-lifting'' operation used by the algorithm, as well as an
      iterative version of that operation

      (B4) The ACL2 BDD algorithm

      (B5) Soundness and Completeness of the ACL2 BDD algorithm

      (B6) Efficiency considerations

  (A) [31;1mMathematical Considerations[0m

  (A1) [3mBDD term order[0m

  Our BDD algorithm creates a total ``BDD term order'' on ACL2 terms,
  on the fly.  We use this order in our discussions below of
  IF-lifting and of canonical BDD terms, and in the algorithm's use
  of commutativity.  The particular order is unimportant, except that
  we guarantee (for purposes of commutative functions) that constants
  are smaller in this order than non-constants.

  (A2) [3mBDD-constructors[0m (assumed to be [47m'(cons)[0m) and [3mBDD terms[0m

  We take as given a list of function symbols that we call the
  ``BDD-constructors.'' By default, the only BDD-constructor is
  [47m[cons][0m, although it is legal to specify any list of function
  symbols as the BDD-constructors, either by using the
  [ACL2-defaults-table] (see [ACL2-defaults-table]) or by supplying a
  [47m:BDD-CONSTRUCTORS[0m hint (see [hints]).  Warning: this capability is
  largely untested and may produce undesirable results.  Henceforth,
  except when explicitly stated to the contrary, we assume that
  BDD-constructors is [47m'(cons)[0m.

  Roughly speaking, a [bdd] term is the sort of [term] produced by our
  BDD algorithm, namely a tree with all [47m[cons][0m nodes lying above all
  non-[47mCONS[0m nodes.  More formally, a [term] is said to be a [bdd] term
  if it contains [31;1mno[0m subterm of either of the following forms, where [47mf[0m
  is not [47mCONS[0m.

    (f ... (CONS ...) ...)

    (f ... 'x ...)  ; where (consp x) = t

  We will see that whenever the BDD algorithm attempts to create a
  [term] that is not a [bdd] term, it aborts instead.  Thus, whenever
  the algorithm completes without aborting, it creates a [bdd] term.

  (A3) [3mCanonical BDD terms[0m

  We can strengthen the notion of ``BDD term'' to a notion of
  ``canonical BDD term'' by imposing the following additional
  requirements, for every subterm of the form [47m(IF x y z)[0m:

      (a) [47mx[0m is a variable, and it precedes (in the BDD term order) every
      variable occurring in [47my[0m or [47mz[0m;

      (b) [47my[0m and [47mz[0m are syntactically distinct; and,

      (c) it is not the case that [47my[0m is [47mt[0m and [47mz[0m is [47mnil[0m.

  We claim that it follows easily from our description of the BDD
  algorithm that every term it creates is a canonical BDD term,
  assuming that the variables occurring in all such terms are treated
  by the algorithm as being Boolean (see (B2) below) and that the
  terms contain no function symbols other than [47mIF[0m and [47mCONS[0m.  Thus,
  under those assumptions the following theorem shows that the BDD
  algorithm never creates distinct terms that are provably equal, a
  property that is useful for completeness and efficiency (as we
  explain in (B5) and (B6) below).

  (A4) [3mProvably equal canonical BDD terms are identical[0m

  We believe that the following theorem and proof are routine
  extensions of a standard result and proof to terms that allow calls
  of [47mCONS[0m.

  [31;1mTheorem[0m.  Suppose that [47mt1[0m and [47mt2[0m are canonical BDD terms that contain
  no function symbols other than [47mIF[0m and [47mCONS[0m.  Also suppose that
  [47m(EQUAL t1 t2)[0m is a theorem.  Then [47mt1[0m and [47mt2[0m are syntactically
  identical.

  Proof of theorem: By induction on the total number of symbols
  occurring in these two terms.  First suppose that at least one term
  is a variable; without loss of generality let it be [47mt1[0m.  We must
  prove that [47mt2[0m is syntactically the same as [47mt1[0m.  Now it is clearly
  consistent that [47m(EQUAL t1 t2)[0m is false if [47mt2[0m is a call of [47mCONS[0m (to
  see this, simply let [47mt1[0m be an value that is not a [47mCONSP[0m).
  Similarly, [47mt2[0m cannot be a constant or a variable other than [47mt1[0m.
  The remaining possibility to rule out is that [47mt2[0m is of the form [47m(IF
  t3 t4 t5)[0m, since by assumption its function symbol must be [47mIF[0m or
  [47mCONS[0m and we have already handled the latter case.  Since [47mt2[0m is
  canonical, we know that [47mt3[0m is a variable.  Since [47m(EQUAL t1 t2)[0m is
  provable, i.e.,

    (EQUAL t1 (if t3 t4 t5))

  is provable, it follows that we may substitute either [47mt[0m or [47mnil[0m for [47mt3[0m
  into this equality to obtain two new provable equalities.  First,
  suppose that [47mt1[0m and [47mt3[0m are distinct variables.  Then these
  substitutions show that [47mt1[0m is provably equal to both [47mt4[0m and [47mt5[0m
  (since [47mt3[0m does not occur in [47mt4[0m or [47mt5[0m by property (a) above, as [47mt2[0m
  is canonical), and hence [47mt4[0m and [47mt5[0m are provably equal to each
  other, which implies by the inductive hypothesis that they are the
  same term --- and this contradicts the assumption that [47mt2[0m is
  canonical (property (b)).  Therefore [47mt1[0m and [47mt3[0m are the same
  variable, i.e., the equality displayed above is actually [47m(EQUAL t1
  (if t1 t4 t5))[0m.  Substituting [47mt[0m and then [47mnil[0m for [47mt1[0m into this
  provable equality lets us prove [47m(EQUAL t t4)[0m and [47m(EQUAL nil t5)[0m,
  which by the inductive hypothesis implies that [47mt4[0m is
  (syntactically) the term [47mt[0m and [47mt5[0m is [47mnil[0m.  That is, [47mt2[0m is [47m(IF t1 t
  nil)[0m, which contradicts the assumption that [47mt2[0m is canonical
  (property (c)).

  Next, suppose that at least one term is a call of [47mIF[0m.  Our first
  observation is that the other term is also a call of [47mIF[0m.  For if
  the other is a call of [47mCONS[0m, then they cannot be provably equal,
  because the former has no function symbols other than [47mIF[0m and hence
  is Boolean when all its variables are assigned Boolean values.
  Also, if the other is a constant, then both branches of the [47mIF[0m term
  are provably equal to that constant and hence these branches are
  syntactically identical by the inductive hypothesis, contradicting
  property (b).  Hence, we may assume for this case that both terms
  are calls of [47mIF[0m; let us write them as follows.

    t0:  (IF t1 t2 t3)
    u0:  (IF u1 u2 u3)

  Note that [47mt1[0m and [47mu1[0m are variables, by property (a) of canonical BDD
  terms.  First we claim that [47mt1[0m does not strictly precede [47mu1[0m in the
  BDD term order.  For suppose [47mt1[0m does strictly precede [47mu1[0m.  Then
  property (a) of canonical BDD terms guarantees that [47mt1[0m does not
  occur in [47mu0[0m.  Hence, an argument much like one used above shows
  that [47mu0[0m is provably equal to both [47mt2[0m (substituting [47mt[0m for [47mt1[0m) and [47mt3[0m
  (substituting [47mnil[0m for [47mt1[0m), and hence [47mt2[0m and [47mt3[0m are provably equal.
  That implies that they are identical terms, by the inductive
  hypothesis, which then contradicts property (b) for [47mt0[0m.  Similarly,
  [47mu1[0m does not strictly precede [47mt1[0m in the BDD term order.  Therefore,
  [47mt1[0m and [47mu1[0m are the same variable.  By substituting [47mt[0m for this
  variable we see that [47mt2[0m and [47mu2[0m are provably equal, and hence they
  are equal by the inductive hypothesis.  Similarly, by substituting
  [47mnil[0m for [47mt1[0m (and [47mu1[0m) we see that [47mt3[0m and [47mu3[0m are provably, hence
  syntactically, equal.

  We have covered all cases in which at least one term is a variable or
  at least one term is a call of [47mIF[0m.  If both terms are constants,
  then provable and syntactic equality are clearly equivalent.
  Finally, then, we may assume that one term is a call of [47mCONS[0m and
  the other is a constant or a call of [47mCONS[0m.  The constant case is
  similar to the [47mCONS[0m case if the constant is a [47mCONSP[0m, so we omit it;
  while if the constant is not a [47mCONSP[0m then it is not provably equal
  to a call of [47mCONS[0m; in fact it is provably [3mnot[0m equal!

  So, we are left with a final case, in which canonical BDD terms [47m(CONS
  t1 t2)[0m and [47m(CONS u1 u2)[0m are provably equal, and we want to show
  that [47mt1[0m and [47mu1[0m are syntactically equal as are [47mt2[0m and [47mu2[0m.  These
  conclusions are easy consequences of the inductive hypothesis,
  since the ACL2 axiom [47mCONS-EQUAL[0m (which you can inspect using [47m:[0m[47m[pe][0m)
  shows that equality of the given terms is equivalent to the
  conjunction of [47m(EQUAL t1 t2)[0m and [47m(EQUAL u1 u2)[0m.  Q.E.D.

  (B) [31;1mAlgorithmic Considerations[0m

  (B1) [3mBDD rules[0m

  A rule of class [47m:[0m[47m[rewrite][0m (see [rule-classes]) is said to be a
  ``[bdd] rewrite rule'' if and only if it satisfies the following
  criteria.  (1) The rule is [enable]d.  (2) Its [equivalence]
  relation is [47m[equal][0m.  (3) It has no hypotheses.  (4) Its
  [47m:[0m[47m[loop-stopper][0m field is [47mnil[0m, i.e., it is not a permutative rule.
  (5) All variables occurring in the rule occur in its left-hand side
  (i.e., there are no ``free variables''; see [rewrite]).  A rule of
  class [47m:[0m[47m[definition][0m (see [rule-classes]) is said to be a ``[bdd]
  definition rule'' if it satisfies all the criteria above (except
  (4), which does not apply), and moreover the top function symbol of
  the left-hand side was not recursively (or mutually recursively)
  defined.  Technical point: Note that this additional criterion is
  independent of whether or not the indicated function symbol
  actually occurs in the right-hand side of the rule.

  Both BDD rewrite rules and BDD definition rules are said to be ``BDD
  rules.''

  (B2) [3mTerms ''known to be Boolean''[0m

  We apply the BDD algorithm in the context of a top-level goal to
  prove, namely, the goal at which the [47m:BDD[0m hint is attached.  As we
  run the BDD algorithm, we allow ourselves to say that a set of
  [term]s is ``known to be Boolean'' if we can verify that the goal
  is provable from the assumption that at least one of the terms is
  not Boolean.  Equivalently, we allow ourselves to say that a set of
  terms is ``known to be Boolean'' if we can verify that the original
  goal is provably equivalent to the assertion that if all terms in
  the set are Boolean, then the goal holds.  The notion ``known to be
  Boolean'' is conservative in the sense that there are generally
  sets of terms for which the above equivalent criteria hold and yet
  the sets of terms are not noted as as being ``known to be
  Boolean.'' However, ACL2 uses a number of tricks, including
  [type-reasoning] and analysis of the structure of the top-level
  goal, to attempt to establish that a sufficiently inclusive set of
  terms is known to be Boolean.

  From a practical standpoint, the algorithm determines a set of terms
  known to be Boolean; we allow ourselves to say that each term in
  this set is ``known to be Boolean.'' The algorithm assumes that
  these terms are indeed Boolean, and can make use of that
  assumption.  For example, if [47mt1[0m is known to be Boolean then the
  algorithm simplifies [47m(IF t1 t nil)[0m to [47mt1[0m; see (iv) in the
  discussion immediately below.

  (B3) [3mIF-lifting[0m and the [3mIF-lifting-for-IF loop[0m

  Suppose that one has a [term] of the form [47m(f ... (IF test x y) ...)[0m,
  where [47mf[0m is a function symbol other than [47mCONS[0m.  Then we say that
  ``IF-lifting'' [47mtest[0m ``from'' this term produces the following term,
  which is provably equal to the given term.

    (if test
        (f ... x ...)  ; resulting true branch
        (f ... y ...)) ; resulting false branch

  Here, we replace each argument of [47mf[0m of the form [47m(IF test .. ..)[0m, for
  the same [47mtest[0m, in the same way.  In this case we say that
  ``IF-lifting applies to'' the given term, ``yielding the test''
  [47mtest[0m and with the ``resulting two branches'' displayed above.
  Whenever we apply IF-lifting, we do so for the available [47mtest[0m that
  is least in the BDD term order (see (A1) above).

  We consider arguments [47mv[0m of [47mf[0m that are ``known to be Boolean'' (see
  above) to be replaced by [47m(IF v t nil)[0m for the purposes of
  IF-lifting, i.e., before IF-lifting is applied.

  There is one special case, however, for IF-lifting.  Suppose that the
  given term is of the form [47m(IF v y z)[0m where [47mv[0m is a variable and is
  the test to be lifted out (i.e., it is least in the BDD term order
  among the potential tests).  Moreover, suppose that neither [47my[0m nor [47mz[0m
  is of the form [47m(IF v W1 W2)[0m for that same [47mv[0m.  Then IF-lifting does
  not apply to the given term.

  We may now describe the IF-lifting-for-IF loop, which applies to
  terms of the form [47m(IF test tbr fbr)[0m where the algorithm has already
  produced [47mtest[0m, [47mtbr[0m, and [47mfbr[0m.  First, if [47mtest[0m is [47mnil[0m then we return
  [47mfbr[0m, while if [47mtest[0m is a non-[47mnil[0m constant or a call of [47mCONS[0m then we
  return [47mtbr[0m.  Otherwise, we see if IF-lifting applies.  If
  IF-lifting does not apply, then we return [47m(IF test tbr fbr)[0m.
  Otherwise, we apply IF-lifting to obtain a term of the form [47m(IF x y
  z)[0m, by lifting out the appropriate test.  Now we recursively apply
  the IF-lifting-for-IF loop to the term [47m(IF x y z)[0m, unless any of
  the following special cases apply.

      (i) If [47my[0m and [47mz[0m are the same term, then return [47my[0m.

      (ii) Otherwise, if [47mx[0m and [47mz[0m are the same term, then replace [47mz[0m by [47mnil[0m
      before recursively applying IF-lifting-for-IF.

      (iii) Otherwise, if [47mx[0m and [47my[0m are the same term and [47my[0m is known to be
      Boolean, then replace [47my[0m by [47mt[0m before recursively applying
      IF-lifting-for-IF.

      (iv) If [47mz[0m is [47mnil[0m and either [47mx[0m and [47my[0m are the same term or [47mx[0m is ``known
      to be Boolean'' and [47my[0m is [47mt[0m, then return [47mx[0m.

  NOTE: When a variable [47mx[0m is known to be Boolean, it is easy to see
  that the form [47m(IF x t nil)[0m is always reduced to [47mx[0m by this
  algorithm.

  (B4) [3mThe ACL2 BDD algorithm[0m

  We are now ready to present the BDD algorithm for ACL2.  It is given
  an ACL2 [term], [47mx[0m, as well as an association list [47mva[0m that maps
  variables to terms, including all variables occurring in [47mx[0m.  We
  maintain the invariant that whenever a variable is mapped by [47mva[0m to
  a term, that term has already been constructed by the algorithm,
  except: initially [47mva[0m maps every variable occurring in the top-level
  term to itself.  The algorithm proceeds as follows.  We implicitly
  ordain that whenever the BDD algorithm attempts to create a [term]
  that is not a [bdd] term (as defined above in (A2)), it aborts
  instead.  Thus, whenever the algorithm completes without aborting,
  it creates a [bdd] term.

      If [47mx[0m is a variable, return the result of looking it up in [47mva[0m.

      If [47mx[0m is a constant, return [47mx[0m.

      If [47mx[0m is of the form [47m(IF test tbr fbr)[0m, then first run the algorithm
      on [47mtest[0m with the given [47mva[0m to obtain [47mtest'[0m.  If [47mtest'[0m is [47mnil[0m,
      then return the result [47mfbr'[0m of running the algorithm on [47mfbr[0m
      with the given [47mva[0m.  If [47mtest'[0m is a constant other than [47mnil[0m, or
      is a call of [47mCONS[0m, then return the result [47mtbr'[0m of running the
      algorithm on [47mtbr[0m with the given [47mva[0m.  If [47mtbr[0m is identical to
      [47mfbr[0m, return [47mtbr[0m.  Otherwise, return the result of applying the
      IF-lifting-for-IF loop (described above) to the term [47m(IF test'
      tbr' fbr')[0m.

      If [47mx[0m is of the form [47m(IF* test tbr fbr)[0m, then compute the result
      exactly as though [47m[if][0m were used rather than [47m[if*][0m, except that
      if [47mtest'[0m is not a constant or a call of [47mCONS[0m (see paragraph
      above), then abort the BDD computation.  Informally, the tests
      of [47m[if*][0m terms are expected to ``resolve.'' NOTE: This
      description shows how [47m[if*][0m can be used to implement
      conditional rewriting in the BDD algorithm.

      If [47mx[0m is a [47mLAMBDA[0m expression [47m((LAMBDA vars body) . args)[0m (which often
      corresponds to a [47m[let][0m term; see [let]), then first form an
      alist [47mva'[0m by binding each [47mv[0m in [47mvars[0m to the result of running
      the algorithm on the corresponding member of [47margs[0m, with the
      current alist [47mva[0m.  Then, return the result of the algorithm on
      [47mbody[0m in the alist [47mva'[0m.

      Otherwise, [47mx[0m is of the form [47m(f x1 x2 ... xn)[0m, where [47mf[0m is a function
      symbol other than [47m[if][0m or [47m[if*][0m.  In that case, let [47mxi'[0m be the
      result of running the algorithm on [47mxi[0m, for [47mi[0m from 1 to [47mn[0m, using
      the given alist [47mva[0m.  First there are a few special cases.  If [47mf[0m
      is [47m[equal][0m then we return [47mt[0m if [47mx1'[0m is syntactically identical
      to [47mx2'[0m (where this test is very fast; see (B6) below); we
      return [47mx1'[0m if it is known to be Boolean and [47mx2'[0m is [47mt[0m; and
      similarly, we return [47mx2'[0m if it is known to be Boolean and [47mx1'[0m
      is [47mt[0m.  Next, if each [47mxi'[0m is a constant and the
      [47m:[0m[47m[executable-counterpart][0m of [47mf[0m is enabled, then the result is
      obtained by computation.  Next, if [47mf[0m is [47m[booleanp][0m and [47mx1'[0m is
      known to be Boolean, [47mt[0m is returned.  Otherwise, we proceed as
      follows, first possibly swapping the arguments if they are out
      of (the BDD term) order and if [47mf[0m is known to be commutative
      (see below).  If a BDD rewrite rule (as defined above) matches
      the term [47m(f x1'... xn')[0m, then the most recently stored such
      rule is applied.  If there is no such match and [47mf[0m is a
      BDD-constructor, then we return [47m(f x1'... xn')[0m.  Otherwise, if
      a BDD definition rule matches this term, then the most recently
      stored such rule (which will usually be the original definition
      for most users) is applied.  If none of the above applies and
      neither does IF-lifting, then we return [47m(f x1'... xn')[0m.
      Otherwise we apply IF-lifting to [47m(f x1'... xn')[0m to obtain a
      term [47m(IF test tbr fbr)[0m; but we aren't done yet.  Rather, we run
      the BDD algorithm (using the same alist) on [47mtbr[0m and [47mfbr[0m to
      obtain terms [47mtbr'[0m and [47mfbr'[0m, and we return [47m(IF test tbr' fbr')[0m
      unless [47mtbr'[0m is syntactically identical to [47mfbr'[0m, in which case
      we return [47mtbr'[0m.

  When is it the case that, as said above, ``[47mf[0m is known to be
  commutative''?  This happens when an enabled rewrite rule is of the
  form [47m(EQUAL (f X Y) (f Y X))[0m.  Regarding swapping the arguments in
  that case: recall that we may assume very little about the BDD term
  order, essentially only that we swap the two arguments when the
  second is a constant and the first is not, for example, in [47m(+ x 1)[0m.
  Other than that situation, one cannot expect to predict accurately
  when the arguments of commutative operators will be swapped.

  (B5) Soundness and Completeness of the ACL2 BDD algorithm

  Roughly speaking, ``soundness'' means that the BDD algorithm should
  give correct answers, and ``completeness'' means that it should be
  powerful enough to prove all true facts.  Let us make the soundness
  claim a little more precise, and then we'll address completeness
  under suitable hypotheses.

  [31;1mClaim[0m (Soundness).  If the ACL2 BDD algorithm runs to completion on
  an input term [47mt0[0m, then it produces a result that is provably equal
  to [47mt0[0m.

  We leave the proof of this claim to the reader.  The basic idea is
  simply to check that each step of the algorithm preserves the
  meaning of the term under the bindings in the given alist.

  Let us start our discussion of completeness by recalling the theorem
  proved above in (A4).

  [31;1mTheorem[0m.  Suppose that [47mt1[0m and [47mt2[0m are canonical BDD terms that contain
  no function symbols other than [47mIF[0m and [47mCONS[0m.  Also suppose that
  [47m(EQUAL t1 t2)[0m is a theorem.  Then [47mt1[0m and [47mt2[0m are syntactically
  identical.

  Below we show how this theorem implies the following completeness
  property of the ACL2 BDD algorithm.  We continue to assume that
  [47mCONS[0m is the only BDD-constructor.

  [31;1mClaim[0m (Completeness).  Suppose that [47mt1[0m and [47mt2[0m are provably equal
  terms, under the assumption that all their variables are known to
  be Boolean.  Assume further that under this same assumption,
  top-level runs of the ACL2 BDD algorithm on these terms return
  terms that contain only the function symbols [47mIF[0m and [47mCONS[0m.  Then the
  algorithm returns the same term for both [47mt1[0m and [47mt2[0m, and the
  algorithm reduces [47m(EQUAL t1 t2)[0m to [47mt[0m.

  Why is this claim true?  First, notice that the second part of the
  conclusion follows immediately from the first, by definition of the
  algorithm.  Next, notice that the terms [47mu1[0m and [47mu2[0m obtained by
  running the algorithm on [47mt1[0m and [47mt2[0m, respectively, are provably
  equal to [47mt1[0m and [47mt2[0m, respectively, by the Soundness Claim.  It
  follows that [47mu1[0m and [47mu2[0m are provably equal to each other.  Since
  these terms contain no function symbols other than [47mIF[0m or [47mCONS[0m, by
  hypothesis, the Claim now follows from the Theorem above together
  with the following lemma.

  [31;1mLemma[0m.  Suppose that the result of running the ACL2 BDD algorithm on
  a top-level term [47mt0[0m is a term [47mu0[0m that contains only the function
  symbols [47mIF[0m and [47mCONS[0m, where all variables of [47mt0[0m are known to be
  Boolean.  Then [47mu0[0m is a canonical BDD term.

  Proof: left to the reader.  Simply follow the definition of the
  algorithm, with a separate argument for the IF-lifting-for-IF loop.

  Finally, let us remark on the assumptions of the Completeness Claim
  above.  The assumption that all variables are known to be Boolean
  is often true; in fact, the system uses the forward-chaining rule
  [47mboolean-listp-forward[0m (you can see it using [47m:[0m[47m[pe][0m) to try to
  establish this assumption, if your theorem has a form such as the
  following.

    (let ((x (list x0 x1 ...))
          (y (list y0 y1 ...)))
      (implies (and (boolean-listp x)
                    (boolean-listp y))
               ...))

  Moreover, the [47m:BDD[0m hint can be used to force the prover to abort if
  it cannot check that the indicated variables are known to be
  Boolean; see [hints].

  Finally, consider the effect in practice of the assumption that the
  terms resulting from application of the algorithm contain calls of
  [47mIF[0m and [47mCONS[0m only.  Typical use of BDDs in ACL2 takes place in a
  theory (see [theories]) in which all relevant non-recursive
  function symbols are enabled and all recursive function symbols
  possess enabled BDD rewrite rules that tell them how open up.  For
  example, such a rule may say how to expand on a given function
  call's argument that has the form [47m(CONS a x)[0m, while another may say
  how to expand when that argument is [47mnil[0m).  (See for example the
  rules [47mappend-cons[0m and [47mappend-nil[0m in the documentation for [47m[if*][0m.)
  We leave it to future work to formulate a theorem that guarantees
  that the BDD algorithm produces terms containing calls only of [47mIF[0m
  and [47mCONS[0m assuming a suitably ``complete'' collection of rewrite
  rules.

  (B6) [3mEfficiency considerations[0m

  Following Bryant's algorithm, we use a graph representation of
  [term]s created by the BDD algorithm's computation.  This
  representation enjoys some important properties.

      (Time efficiency) The test for syntactic equality of BDD terms is
      very fast.

      (Space efficiency) Equal BDD data structures are stored identically
      in memory.

  [3mImplementation note.[0m The representation actually uses a sort of hash
  table for BDD terms that is implemented as an ACL2 1-dimensional
  array.  See [arrays].  In addition, we use a second such hash table
  to avoid recomputing the result of applying a function symbol to
  the result of running the algorithm on its arguments.  We believe
  that these uses of hash tables are standard.  They are also
  discussed in Moore's paper on BDDs; see [bdd] for the reference.")
 (BDD-INTRODUCTION
  (BDD)
  "Examples illustrating the use of BDDs in ACL2

  See [bdd] for a brief introduction to BDDs in ACL2 and for pointers
  to other documentation on BDDs in ACL2.  Here, we illustrate the
  use of BDDs in ACL2 by way of some examples.  For a further
  example, see [if*].

  Let us begin with a really simple example.  (We will explain the [47m:bdd[0m
  hint [47m(:vars nil)[0m below.)

    ACL2 !>(thm (equal (if a b c) (if (not a) c b))
                :hints ((\"Goal\" :bdd (:vars nil)))) ; Prove with BDDs

    [Note:  A hint was supplied for the goal above.  Thanks!]

    But simplification with BDDs (7 nodes) reduces this to T, using the
    :definitions EQUAL and NOT.

    Q.E.D.

    Summary
    Form:  ( THM ...)
    Rules: ((:DEFINITION EQUAL) (:DEFINITION NOT))
    Warnings:  None
    Time:  0.18 seconds (prove: 0.05, print: 0.02, other: 0.12)

    Proof succeeded.
    ACL2 !>

  The [47m:bdd[0m hint [47m(:vars nil)[0m indicates that BDDs are to be used on the
  indicated goal, and that any so-called ``variable ordering'' may be
  used: ACL2 may use a convenient order that is far from optimal.  It
  is beyond the scope of the present documentation to address the
  issue of how the user may choose good variable orderings.  Someday
  our implementation of BDDs may be improved to include
  heuristically-chosen variable orderings rather than rather random
  ones.

  Here is a more interesting example.

    (defun v-not (x)
    ; Complement every element of a list of Booleans.
      (if (consp x)
          (cons (not (car x)) (v-not (cdr x)))
        nil))

    ; Now we prove a rewrite rule that explains how to open up v-not on
    ; a consp.
    (defthm v-not-cons
      (equal (v-not (cons x y))
             (cons (not x) (v-not y))))

    ; Finally, we prove for 7-bit lists that v-not is self-inverting.
    (thm
     (let ((x (list x0 x1 x2 x3 x4 x5 x6)))
       (implies (boolean-listp x)
                (equal (v-not (v-not x)) x)))
     :hints ((\"Goal\" :bdd
                     ;; Note that this time we specify a variable order.
                     (:vars (x0 x1 x2 x3 x4 x5 x6)))))

  It turns out that the variable order doesn't seem to matter in this
  example; using several orders we found that 30 nodes were created,
  and the proof time was about 1/10 of a second on a (somewhat
  enhanced) Sparc 2.  The same proof took about a minute and a half
  without any [47m:bdd[0m hint!  This observation is a bit misleading
  perhaps, since the theorem for arbitrary [47mx[0m,

    (thm
     (implies (boolean-listp x)
              (equal (v-not (v-not x)) x)))

  only takes about 1.5 times as long as the [47m:bdd[0m proof for 7 bits,
  above!  Nevertheless, BDDs can be very useful in reducing proof
  time, especially when there is no regular structure to facilitate
  proof by induction, or when the induction scheme is so complicated
  to construct that significant user effort is required to get the
  proof by induction to go through.

  Finally, consider the preceding example, with a [47m:bdd[0m hint of (say)
  [47m(:vars nil)[0m, but with the rewrite rule [47mv-not-cons[0m above disabled.
  In that case, the proof fails, as we see below.  That is because
  the BDD algorithm in ACL2 uses hypothesis-free [47m:[0m[rewrite] rules,
  [47m:[0m[47m[executable-counterpart][0m[47ms[0m, and nonrecursive definitions, but it
  does not use recursive definitions.

  Notice that when we issue the [47m(show-bdd)[0m command, the system's
  response clearly shows that we need a rewrite rule for simplifying
  terms of the form [47m(v-not (cons ...))[0m.

    ACL2 !>(thm
            (let ((x (list x0 x1 x2 x3 x4 x5 x6)))
              (implies (boolean-listp x)
                       (equal (v-not (v-not x)) x)))
            :hints ((\"Goal\" :bdd (:vars nil)
                     :in-theory (disable v-not-cons))))

    [Note:  A hint was supplied for the goal above.  Thanks!]

    ACL2 Error in ( THM ...):  Attempted to create V-NOT node during BDD
    processing with an argument that is a call of a bdd-constructor,
    which would produce a non-BDD term (as defined in :DOC
    bdd-algorithm).  See :DOC show-bdd.

    Summary
    Form:  ( THM ...)
    Rules: NIL
    Warnings:  None
    Time:  0.58 seconds (prove: 0.13, print: 0.00, other: 0.45)

    ******** FAILED ********  See :DOC failure  ******** FAILED ********
    ACL2 !>(show-bdd)

    BDD computation on Goal yielded 17 nodes.
    ------------------------------

    BDD computation was aborted on Goal, and hence there is no
    falsifying assignment that can be constructed.  Here is a backtrace
    of calls, starting with the top-level call and ending with the one
    that led to the abort.  See :DOC show-bdd.

    (LET ((X (LIST X0 X1 X2 X3 X4 X5 ...)))
         (IMPLIES (BOOLEAN-LISTP X)
                  (EQUAL (V-NOT (V-NOT X)) X)))
      alist: ((X6 X6) (X5 X5) (X4 X4) (X3 X3) (X2 X2) (X1 X1) (X0 X0))

    (EQUAL (V-NOT (V-NOT X)) X)
      alist: ((X (LIST X0 X1 X2 X3 X4 X5 ...)))

    (V-NOT (V-NOT X))
      alist: ((X (LIST X0 X1 X2 X3 X4 X5 ...)))

    (V-NOT X)
      alist: ((X (LIST X0 X1 X2 X3 X4 X5 ...)))
    ACL2 !>

  The term that has caused the BDD algorithm to abort is thus [47m(V-NOT
  X)[0m, where [47mX[0m has the value [47m(LIST X0 X1 X2 X3 X4 X5 ...)[0m, i.e., [47m(CONS
  X0 (LIST X1 X2 X3 X4 X5 ...))[0m.  Thus, we see the utility of
  introducing a rewrite rule to simplify terms of the form [47m(V-NOT
  (CONS ...))[0m.  The moral of this story is that if you get an error
  of the sort shown above, you may find it useful to execute the
  command [47m(show-bdd)[0m and use the result as advice that suggests the
  left hand side of a rewrite rule.

  Here is another sort of failed proof.  In this version we have
  omitted the hypothesis that the input is a bit vector.  Below we
  use [47mshow-bdd[0m to see what went wrong, and use the resulting
  information to construct a counterexample.  This failed proof
  corresponds to a slightly modified input theorem, in which [47mx[0m is
  bound to the 4-element list [47m(list x0 x1 x2 x3)[0m.

    ACL2 !>(thm
            (let ((x (list x0 x1 x2 x3)))
              (equal (v-not (v-not x)) x))
            :hints ((\"Goal\" :bdd
                     ;; This time we do not specify a variable order.
                     (:vars nil))))

    [Note:  A hint was supplied for the goal above.  Thanks!]

    ACL2 Error in ( THM ...):  The :BDD hint for the current goal has
    successfully simplified this goal, but has failed to prove it.
    Consider using (SHOW-BDD) to suggest a counterexample; see :DOC
    show-bdd.

    Summary
    Form:  ( THM ...)
    Rules: NIL
    Warnings:  None
    Time:  0.18 seconds (prove: 0.07, print: 0.00, other: 0.12)

    ******** FAILED ********  See :DOC failure  ******** FAILED ********
    ACL2 !>(show-bdd)

    BDD computation on Goal yielded 73 nodes.
    ------------------------------

    Falsifying constraints:
    ((X0 \"Some non-nil value\")
     (X1 \"Some non-nil value\")
     (X2 \"Some non-nil value\")
     (X3 \"Some non-nil value\")
     ((EQUAL 'T X0) T)
     ((EQUAL 'T X1) T)
     ((EQUAL 'T X2) T)
     ((EQUAL 'T X3) NIL))

    ------------------------------

    Term obtained from BDD computation on Goal:

    (IF X0
        (IF X1
            (IF X2 (IF X3 (IF # # #) (IF X3 # #))
                (IF X2 'NIL (IF X3 # #)))
            (IF X1 'NIL
                (IF X2 (IF X3 # #) (IF X2 # #))))
        (IF X0 'NIL
            (IF X1 (IF X2 (IF X3 # #) (IF X2 # #))
                (IF X1 'NIL (IF X2 # #)))))

    ACL2 Query (:SHOW-BDD):  Print the term in full?  (N, Y, W or ?):
    n ; I've seen enough.  The assignment shown above suggests
      ; (though not conclusively) that if we bind x3 to a non-nil
      ; value other than T, and bind x0, x1, and x2 to t, then we
      ; this may give us a counterexample.
    ACL2 !>(let ((x0 t) (x1 t) (x2 t) (x3 7))
             (let ((x (list x0 x1 x2 x3)))
               ;; Let's use LIST instead of EQUAL to see how the two
               ;; lists differ.
               (list (v-not (v-not x)) x)))
    ((T T T T) (T T T 7))
    ACL2 !>

  See [if*] for another example.")
 (BIBLIOGRAPHY
  (ABOUT-ACL2)
  "Reports about ACL2

  The ACL2 home page includes a {list of notes and reports about ACL2 |
  http://www.cs.utexas.edu/users/moore/publications/acl2-papers.html}.")
 (BINARY-*
  (* ACL2-BUILT-INS)
  "Multiplication function

  Completion Axiom ([47mcompletion-of-*[0m):

    (equal (binary-* x y)
           (if (acl2-numberp x)
               (if (acl2-numberp y)
                   (binary-* x y)
                 0)
             0))

  [Guard] for [47m(binary-* x y)[0m:

    (and (acl2-numberp x) (acl2-numberp y))

  Notice that like all arithmetic functions, [47mbinary-*[0m treats
  non-numeric inputs as [47m0[0m.

  Calls of the macro [47m[*][0m expand to calls of [47mbinary-*[0m; see [*].")
 (BINARY-+
  (+ ACL2-BUILT-INS)
  "Addition function

  Completion Axiom ([47mcompletion-of-+[0m):

    (equal (binary-+ x y)
           (if (acl2-numberp x)
               (if (acl2-numberp y)
                   (binary-+ x y)
                 x)
             (if (acl2-numberp y)
                 y
               0)))

  [Guard] for [47m(binary-+ x y)[0m:

    (and (acl2-numberp x) (acl2-numberp y))

  Notice that like all arithmetic functions, [47mbinary-+[0m treats
  non-numeric inputs as [47m0[0m. Thus, the following are theorems.

    (thm (equal (+ (fix x) y) (+ x y)))
    (thm (equal (+ x (fix y)) (+ x y)))

  Calls of the macro [47m[+][0m expand to calls of [47mbinary-+[0m; see [+].")
 (BINARY-APPEND
  (APPEND ACL2-BUILT-INS)
  "[concatenate] two lists

  This binary function implements [47m[append][0m, which is a macro in ACL2.
  See [append]

  The [guard] for [47mbinary-append[0m requires the first argument to be a
  [47m[true-listp][0m.

  [31;1mFunction: [0m<binary-append>

    (defun binary-append (x y)
      (declare (xargs :guard (true-listp x)))
      (cond ((endp x) y)
            (t (cons (car x)
                     (binary-append (cdr x) y)))))")
 (BINARY-DF* (POINTERS) "See [df].")
 (BINARY-DF+ (POINTERS) "See [df].")
 (BINARY-DF-LOG (POINTERS) "See [df].")
 (BINARY-DF/ (POINTERS) "See [df].")
 (BIND-FREE
  (REWRITE LINEAR DEFINITION)
  "To bind free variables of a rewrite, definition, or linear rule

    Examples:
    (IMPLIES (AND (RATIONALP LHS)
                  (RATIONALP RHS)
                  (BIND-FREE (FIND-MATCH-IN-PLUS-NESTS LHS RHS) (X)))
             (EQUAL (EQUAL LHS RHS)
                    (EQUAL (+ (- X) LHS) (+ (- X) RHS))))

    (IMPLIES (AND (BIND-FREE
                    (FIND-RATIONAL-MATCH-IN-TIMES-NESTS LHS RHS MFC STATE)
                    (X))
                  (RATIONALP X)
                  (CASE-SPLIT (NOT (EQUAL X 0))))
             (EQUAL (< LHS RHS)
                    (IF (< 0 X)
                        (< (* (/ X) LHS) (* (/ X) RHS))
                       (< (* (/ X) RHS) (* (/ X) LHS)))))

  General Forms:

    (BIND-FREE term var-list)
    (BIND-FREE term t)
    (BIND-FREE term)

  A rule which uses a [47mbind-free[0m hypothesis has similarities to both a
  rule which uses a [47m[syntaxp][0m hypothesis and to a [47m:[0m[47m[meta][0m rule.
  [47mBind-free[0m is like [47m[syntaxp][0m, in that it logically always returns [47mt[0m
  but may affect the application of a [47m:[0m[47m[rewrite][0m,
  [47m:[0m[47m[rewrite-quoted-constant][0m, [47m:[0m[47m[definition][0m, or [47m:[0m[47m[linear][0m rule when
  it is called at the top-level of a hypothesis.  It is like a
  [47m:[0m[47m[meta][0m rule, in that it allows the user to perform transformations
  of terms under programmatic control.

  Note that a [47mbind-free[0m hypothesis does not, in general, deal with the
  meaning or semantics or values of the terms, but rather with their
  syntactic forms.  Before attempting to write a rule which uses
  [47mbind-free[0m, the user should be familiar with [47m[syntaxp][0m and the
  internal form that ACL2 uses for terms.  This internal form is
  similar to what the user sees, but there are subtle and important
  differences.  [47m[Trans][0m can be used to view this internal form.

  Just as for a [47m[syntaxp][0m hypothesis, there are two basic types of
  [47mbind-free[0m hypotheses.  The simpler type of [47mbind-free[0m hypothesis may
  be used as the nth hypothesis in a [47m:[0m[47m[rewrite][0m, [47m:[0m[47m[definition][0m, or
  [47m:[0m[47m[linear][0m rule whose [47m:[0m[47m[corollary][0m is [47m(implies (and hyp1 ... hypn
  ... hypk) (equiv lhs rhs))[0m provided [47mterm[0m is a term, [47mterm[0m contains
  at least one variable, and every variable occurring freely in [47mterm[0m
  occurs freely in [47mlhs[0m or in some [47mhypi[0m, [47mi<n[0m.  In addition, [47mterm[0m must
  not use any stobjs.  Later below we will describe the second type,
  an [3mextended[0m [47mbind-free[0m hypothesis, which is similar except that it
  may use [47m[state][0m and [47m[mfc][0m.  Whether simple or extended, a [47mbind-free[0m
  hypothesis may return an alist that binds free variables, as
  explained below, or it may return a list of such alists.  We focus
  on the first of these cases: return of a single binding alist.  We
  conclude our discussion with a section that covers the other case:
  return of a list of alists.

  We begin our description of [47mbind-free[0m by examining the first example
  above in some detail.

  We wish to write a rule which will cancel ``like'' addends from both
  sides of an equality.  Clearly, one could write a series of rules
  such as

    (DEFTHM THE-HARD-WAY-2-1
       (EQUAL (EQUAL (+ A X B)
                     (+ X C))
              (EQUAL (+ A B)
                     (FIX C))))

  with one rule for each combination of positions the matching addends
  might be found in (if one knew before-hand the maximum number of
  addends that would appear in a sum).  But there is a better way.
  (In what follows, we assume the presence of an appropriate set of
  rules for simplifying sums.)

  Consider the following definitions and theorem:

    (DEFUN INTERSECTION-EQUAL (X Y)
      (COND ((ENDP X)
             NIL)
            ((MEMBER-EQUAL (CAR X) Y)
             (CONS (CAR X) (INTERSECTION-EQUAL (CDR X) Y)))
            (T
             (INTERSECTION-EQUAL (CDR X) Y))))

    (DEFUN PLUS-LEAVES (TERM)
      (IF (EQ (FN-SYMB TERM) 'BINARY-+)
          (CONS (FARGN TERM 1)
                (PLUS-LEAVES (FARGN TERM 2)))
        (LIST TERM)))

    (DEFUN FIND-MATCH-IN-PLUS-NESTS (LHS RHS)
      (IF (AND (EQ (FN-SYMB LHS) 'BINARY-+)
               (EQ (FN-SYMB RHS) 'BINARY-+))
          (LET ((COMMON-ADDENDS (INTERSECTION-EQUAL (PLUS-LEAVES LHS)
                                                    (PLUS-LEAVES RHS))))
            (IF COMMON-ADDENDS
                (LIST (CONS 'X (CAR COMMON-ADDENDS)))
              NIL))
        NIL))

    (DEFTHM CANCEL-MATCHING-ADDENDS-EQUAL
      (IMPLIES (AND (RATIONALP LHS)
                    (RATIONALP RHS)
                    (BIND-FREE (FIND-MATCH-IN-PLUS-NESTS LHS RHS) (X)))
               (EQUAL (EQUAL LHS RHS)
                      (EQUAL (+ (- X) LHS) (+ (- X) RHS)))))

  How is this rule applied to the following term?

    (equal (+ 3 (expt a n) (foo a c))
           (+ (bar b) (expt a n)))

  As mentioned above, the internal form of an ACL2 term is not always
  what one sees printed out by ACL2.  In this case, by using [47m:[0m[47m[trans][0m
  one can see that the term is stored internally as

    (equal (binary-+ '3
                     (binary-+ (expt a n) (foo a c)))
           (binary-+ (bar b) (expt a n))).

  When ACL2 attempts to apply [47mcancel-matching-addends-equal[0m to the term
  under discussion, it first forms a substitution that instantiates
  the left-hand side of the conclusion so that it is identical to the
  target term.  This substitution is kept track of by the
  substitution alist:

    ((LHS . (binary-+ '3
                       (binary-+ (expt a n) (foo a c))))
     (RHS . (binary-+ (bar b) (expt a n)))).

  ACL2 then attempts to relieve the hypotheses in the order they were
  given.  Ordinarily this means that we instantiate each hypothesis
  with our substitution and then attempt to rewrite the resulting
  instance to true.  Thus, in order to relieve the first hypothesis,
  we rewrite:

    (RATIONALP (binary-+ '3
                          (binary-+ (expt a n) (foo a c)))).

  Let us assume that the first two hypotheses rewrite to [47mt[0m.  How do we
  relieve the [47mbind-free[0m hypothesis?  Just as for a [47m[syntaxp][0m
  hypothesis, ACL2 evaluates [47m(find-match-in-plus-nests lhs rhs)[0m in an
  environment where [47mlhs[0m and [47mrhs[0m are instantiated as determined by the
  substitution.  In this case we evaluate

    (FIND-MATCH-IN-PLUS-NESTS '(binary-+ '3
                                          (binary-+ (expt a n) (foo a c)))
                              '(binary-+ (bar b) (expt a n))).

  Observe that, just as in the case of a [47m[syntaxp][0m hypothesis, we
  substitute the quotation of the variables bindings into the term to
  be evaluated.  See [syntaxp] for the reasons for this.  The result
  of this evaluation, [47m((X . (EXPT A N)))[0m, is then used to extend the
  substitution alist:

    ((X . (EXPT A N))
     (LHS . (binary-+ '3
                       (binary-+ (expt a n) (foo a c))))
     (RHS . (binary-+ (bar b) (expt a n)))),

  and this extended substitution determines
  [47mcancel-matching-addends-equal[0m's result:

    (EQUAL (+ (- X) LHS) (+ (- X) RHS))
    ==>
    (EQUAL (+ (- (EXPT A N)) 3 (EXPT A N) (FOO A C))
           (+ (- (EXPT A N)) (BAR B) (EXPT A N))).

  Question: What is the internal form of this result?
  Hint: Use [47m:[0m[47m[trans][0m.

  When this rule fires, it adds the negation of a common term to both
  sides of the equality by selecting a binding for the otherwise-free
  variable [47mx[0m, under programmatic control.  Note that other mechanisms
  such as the binding of [free-variables] may also extend the
  substitution alist.

  Just as for a [47m[syntaxp][0m test, a [47mbind-free[0m form signals failure by
  returning [47mnil[0m.  However, while a [47m[syntaxp][0m test signals success by
  returning true, a [47mbind-free[0m form signals success by returning an
  alist which is used to extend the current substitution alist.
  Because of this use of the alist, there are several restrictions on
  it --- in particular the alist must only bind variables, these
  variables must not be already bound by the substitution alist, and
  the variables must be bound to ACL2 terms.  If [47mterm[0m returns an
  alist and the alist meets these restrictions, we append the alist
  to the substitution alist and use the result as the new current
  substitution alist.  This new current substitution alist is then
  used when we attempt to relieve the next hypothesis or, if there
  are no more, instantiate the right hand side of the rule.

  There is also a second, optional, [47mvar-list[0m argument to a [47mbind-free[0m
  hypothesis.  If provided, it must be either [47mt[0m, [47mnil[0m, or a non-empty
  list of variables.  If it is not provided, it defaults to [47mt[0m; and it
  is also treated as [47mt[0m if the value provided is [47mnil[0m.  If it is a
  non-empty list of variables, this second argument is used to place
  a further restriction on the possible values of the alist to be
  returned by [47mterm[0m: any variables bound in the alist must be present
  in that list of variables.  We strongly recommend the use of this
  list of variables, as that list is considered to contribute to the
  list of variables in the hypotheses of a linear rule; see [linear],
  in particular condition (b) mentioned there regarding a requirement
  that maximal terms and hypotheses must suffice for instantiating
  all the variables in the conclusion.  If [47mvar-list[0m is [47mt[0m (either
  explicitly or implicitly, as described above), then that condition
  is considered to be met trivially; this could prevent ACL2 from
  rejecting ineffective linear rules.

  An extended [47mbind-free[0m hypothesis is similar to the simple type
  described above, but it uses two additional variables, [47mmfc[0m and
  [47mstate[0m, which must not be bound by the left hand side or an earlier
  hypothesis of the rule.  They must be the last two variables
  mentioned by [47mterm[0m: first [47mmfc[0m, then [47mstate[0m.  These two variables give
  access to the functions [47mmfc-[0mxxx; see [extended-metafunctions].  As
  described there, [47mmfc[0m is bound to the so-called metafunction-context
  and [47mstate[0m to ACL2's [47m[state][0m.  See [bind-free-examples] for examples
  of the use of these extended [47mbind-free[0m hypotheses.

  [31;1mSECTION[0m: Returning a list of alists.

  As promised above, we conclude with a discussion of the case that
  evaluation of the [47mbind-free[0m term produces a list of alists, [47mx[0m,
  rather than a single alist.  In this case each member [47mb[0m of [47mx[0m is
  considered in turn, starting with the first and proceeding through
  the list.  Each such [47mb[0m is handled exactly as discussed above, as
  though it were the result of evaluating the [47mbind-free[0m term.  Thus,
  each [47mb[0m extends the current variable binding alist, and all
  remaining hypotheses are then relieved, as though [47mb[0m had been the
  value obtained by evaluating the [47mbind-free[0m term.  As soon as one
  such [47mb[0m leads to successful relieving of all remaining hypotheses,
  the process of relieving hypotheses concludes, so no further
  members of [47mx[0m are considered.

  We illustrate with a simple pedagogical example.  First introduce
  functions [47mp1[0m and [47mp2[0m such that a rewrite rule specifies that [47mp2[0m
  implies [47mp1[0m, but with a free variable.

    (defstub p1 (x) t)
    (defstub p2 (x y) t)

    (defaxiom p2-implies-p1
      (implies (p2 x y)
               (p1 x)))

  If we add the following axiom, then [47m(p1 x)[0m follows logically for all
  [47mx[0m.

    (defaxiom p2-instance
      (p2 v (cons v 4)))

  Unfortunately, evaluation of [47m(thm (p1 a))[0m fails, because ACL2 fails
  to bind the free variable [47my[0m in order to apply the rule [47mp2-instance[0m.

  Let's define a function that produces a list of alists, each binding
  the variable [47my[0m.  Of course, we know that only the middle one below
  is necessary in this simple example.  In more complex examples, one
  might use heuristics to construct such a list of alists.

    (defun my-alists (x)
      (list (list (cons 'y (fcons-term* 'cons x ''3)))
            (list (cons 'y (fcons-term* 'cons x ''4)))
            (list (cons 'y (fcons-term* 'cons x ''5)))))

  The following rewrite rule uses [47mbind-free[0m to return a list of
  candidate alists binding [47my[0m.

    (defthm p2-implies-p1-better
      (implies (and (bind-free (my-alists x)
                               (y)) ; the second argument, (y), is optional
                    (p2 x y))
               (p1 x)))

  Now the proof succeeds for [47m(thm (p1 a))[0m.  Why?  When ACL2 applies the
  [47mrewrite[0m rule [47mp2-implies-p1-better[0m, it evaluates [47mmy-alists[0m, as we
  can see from the following [trace], to bind [47my[0m in three different
  alists.

    ACL2 !>(thm (p1 a))
    1> (ACL2_*1*_ACL2::MY-ALISTS A)
    <1 (ACL2_*1*_ACL2::MY-ALISTS (((Y CONS A '3))
                                  ((Y CONS A '4))
                                  ((Y CONS A '5))))

    Q.E.D.

  The first alist, binding [47my[0m to [47m(cons a '3)[0m, fails to allow the
  hypothesis [47m(p2 x y)[0m to be proved.  But the next binding of [47my[0m, to
  [47m(cons a '4)[0m, succeeds: then the current binding alist is [47m((x . a)
  (y . (cons a '4)))[0m, for which the hypothesis [47m(p2 x y)[0m rewrites to
  true using the rewrite rule [47mp2-instance[0m.


Subtopics

  [Bind-free-examples]
      Examples pertaining to [47m[bind-free][0m hypotheses")
 (BIND-FREE-EXAMPLES
  (BIND-FREE)
  "Examples pertaining to [47m[bind-free][0m hypotheses

  See [bind-free] for a basic discussion of the use of [47mbind-free[0m to
  control rewriting.

  Note that the examples below all illustrate the common case in which
  a [47mbind-free[0m hypothesis generates a binding alist.  See [bind-free],
  in particular the final section, for a discussion of the case that
  instead a list of binding alists is generated.

  We give examples of the use of [47m[bind-free][0m hypotheses from the
  perspective of a user interested in reasoning about arithmetic, but
  it should be clear that [47m[bind-free][0m can be used for many other
  purposes also.

  EXAMPLE 1: Cancel a common factor.

    (defun bind-divisor (a b)

    ; If a and b are polynomials with a common factor c, we return a
    ; binding for x.  We could imagine writing get-factor to compute the
    ; gcd, or simply to return a single non-invertible factor.

      (let ((c (get-factor a b)))
        (and c (list (cons 'x c)))))

    (defthm cancel-factor
      ;; We use case-split here to ensure that, once we have selected
      ;; a binding for x, the rest of the hypotheses will be relieved.
      (implies (and (acl2-numberp a)
                    (acl2-numberp b)
                    (bind-free (bind-divisor a b) (x))
                    (case-split (not (equal x 0)))
                    (case-split (acl2-numberp x)))
               (iff (equal a b)
                    (equal (/ a x) (/ b x)))))

  EXAMPLE 2: Pull integer summand out of floor.  Note: This example has
  an [3mextended[0m [47m[bind-free][0m hypothesis, which uses the term
  [47m(find-int-in-sum sum mfc state)[0m.

    (defun fl (x)
      ;; This function is defined, and used, in the IHS books.
      (floor x 1))

    (defun int-binding (term mfc state)
      ;; The call to mfc-ts returns the encoded type of term.
      ;; Thus, we are asking if term is known by type reasoning to
      ;; be an integer.
      (declare (xargs :stobjs (state) :mode :program))
      (if (ts-subsetp (mfc-ts term mfc state)
                      *ts-integer*)
          (list (cons 'int term))
        nil))

    (defun find-int-in-sum (sum mfc state)
      (declare (xargs :stobjs (state) :mode :program))
      (if (and (nvariablep sum)
               (not (fquotep sum))
               (eq (ffn-symb sum) 'binary-+))
          (or (int-binding (fargn sum 1) mfc state)
              (find-int-in-sum (fargn sum 2) mfc state))
        (int-binding sum mfc state)))

    ; Some additional work is required to prove the following.  So for
    ; purposes of illustration, we wrap skip-proofs around the defthm.

    (skip-proofs
     (defthm cancel-fl-int
      ;; The use of case-split is probably not needed, since we should
      ;; know that int is an integer by the way we selected it.  But this
      ;; is safer.
       (implies (and (acl2-numberp sum)
                     (bind-free (find-int-in-sum sum mfc state) (int))
                     (case-split (integerp int)))
                (equal (fl sum)
                       (+ int (fl (- sum int)))))
       :rule-classes ((:rewrite :match-free :all)))
    )

    ; Arithmetic libraries will have this sort of lemma.
    (defthm hack (equal (+ (- x) x y) (fix y)))

    (in-theory (disable fl))

    (thm (implies (and (integerp x) (acl2-numberp y))
                  (equal (fl (+ x y)) (+ x (fl y)))))

  EXAMPLE 3: Simplify terms such as (equal (+ a (* a b)) 0)

    (defun factors (product)
      ;; We return a list of all the factors of product.  We do not
      ;; require that product actually be a product.
      (if (eq (fn-symb product) 'BINARY-*)
          (cons (fargn product 1)
                (factors (fargn product 2)))
        (list product)))

    (defun make-product (factors)
      ;; Factors is assumed to be a list of ACL2 terms.  We return an
      ;; ACL2 term which is the product of all the elements of the
      ;; list factors.
      (cond ((atom factors)
             ''1)
            ((null (cdr factors))
             (car factors))
            ((null (cddr factors))
             (list 'BINARY-* (car factors) (cadr factors)))
            (t
             (list 'BINARY-* (car factors) (make-product (cdr factors))))))

    (defun quotient (common-factors sum)
      ;; Common-factors is a list of ACL2 terms.   Sum is an ACL2 term each
      ;; of whose addends have common-factors as factors.  We return
      ;; (/ sum (make-product common-factors)).
      (if (eq (fn-symb sum) 'BINARY-+)
          (let ((first (make-product (set-difference-equal (factors (fargn sum 1))
                                                           common-factors))))
            (list 'BINARY-+ first (quotient common-factors (fargn sum 2))))
        (make-product (set-difference-equal (factors sum)
                                            common-factors))))

    (defun intersection-equal (x y)
      (cond ((endp x)
             nil)
            ((member-equal (car x) y)
             (cons (car x) (intersection-equal (cdr x) y)))
            (t
             (intersection-equal (cdr x) y))))

    (defun common-factors (factors sum)
      ;; Factors is a list of the factors common to all of the addends
      ;; examined so far.  On entry, factors is a list of the factors in
      ;; the first addend of the original sum, and sum is the rest of the
      ;; addends.  We sweep through sum, trying to find a set of factors
      ;; common to all the addends of sum.
      (declare (xargs :measure (acl2-count sum)))
      (cond ((null factors)
             nil)
            ((eq (fn-symb sum) 'BINARY-+)
             (common-factors (intersection-equal factors (factors (fargn sum 1)))
                             (fargn sum 2)))
            (t
             (intersection-equal factors (factors sum)))))

    (defun simplify-terms-such-as-a+ab-rel-0-fn (sum)
      ;; If we can find a set of factors common to all the addends of sum,
      ;; we return an alist binding common to the product of these common
      ;; factors and binding quotient to (/ sum common).
      (if (eq (fn-symb sum) 'BINARY-+)
          (let ((common-factors (common-factors (factors (fargn sum 1))
                                                (fargn sum 2))))
            (if common-factors
                (let ((common (make-product common-factors))
                      (quotient (quotient common-factors sum)))
                  (list (cons 'common common)
                        (cons 'quotient quotient)))
              nil))
        nil))

    (defthm simplify-terms-such-as-a+ab-=-0
      (implies (and (bind-free
                     (simplify-terms-such-as-a+ab-rel-0-fn sum)
                     (common quotient))
                    (case-split (acl2-numberp common))
                    (case-split (acl2-numberp quotient))
                    (case-split (equal sum
                                       (* common quotient))))
               (equal (equal sum 0)
                      (or (equal common 0)
                          (equal quotient 0)))))

    (thm (equal (equal (+ u (* u v)) 0)
          (or (equal u 0) (equal v -1))))")
 (BITP
  (NUMBERS ACL2-BUILT-INS)
  "A recognizer for the set of bits, {0,1}

  [47mBitp[0m returns [47mt[0m if and only its argument is [47m0[0m or [47m1[0m, and [47mnil[0m otherwise.

  Note that this is a predicate form of the [type-spec] declaration
  [47m(TYPE BIT b)[0m.

  [31;1mFunction: [0m<bitp>

    (defun bitp (x)
      (declare (xargs :guard t))
      (or (eql x 0) (eql x 1)))")
 (BODY (POINTERS)
       "See [system-utilities].")
 (BOOK-COMPILED-FILE
  (BOOKS-REFERENCE)
  "Creating and loading of compiled and expansion files for [books]

  An effect of [compilation] is to speed up the execution of the
  functions defined in a book.  Compilation can also remove tail
  recursion, thus avoiding stack overflows.  The presence of compiled
  code for the functions in the book should not otherwise affect the
  performance of ACL2.  See [guard] for a discussion; also see
  [compilation].

  By default, the [47m[certify-book][0m command compiles the book that it
  certifies.  see [certify-book] for how to control this behavior.

  By default, the [47m[include-book][0m command loads the compiled file for
  the book.  The details of how this loading works are subtle, and do
  not need to be understood by most users.  The ACL2 source code
  contains an ``Essay on Hash Table Support for Compilation'' that
  explains such details for those interested.  All that users should
  generally need to know about this is that the compiled file is
  always the result of compiling a so-called ``expansion file'',
  which contains certain additional code besides the book itself.
  The relevance to users of the expansion file is that it can be
  loaded if the compiled file is missing (except when
  [47m:load-compiled-file t[0m is specified by the [47m[include-book][0m form), and
  its existence is required in order for [47m[include-book][0m to create a
  book's compiled file, as described below.

  Most users can skip the remainder of this documentation topic, which
  addresses the uncommon activity of using [47m[include-book][0m to compile
  books.

  [47mInclude-book[0m can be made to compile a book by supplying its keyword
  argument [47m:load-compiled-file[0m the value [47m:comp[0m.  However, a compiled
  file can only be produced if there is already an [3mexpansion file[0m
  that is at least as recent as the book's [certificate].  Such a
  file, whose name happens to be the result of concatenating the
  string [47m\"@expansion.lsp\"[0m to the book's filename after removing the
  [47m\".lisp\"[0m suffix, is created by [47m[certify-book][0m when state global
  variable [47m'save-expansion-file[0m has a non-[47mnil[0m value.  That will be
  the case if ACL2 started up when environment variable
  [47mACL2_SAVE_EXPANSION[0m was [47mt[0m (or any value that is not the empty
  string and whose [47m[string-upcase][0m is not [47m\"NIL\"[0m), until the time (if
  any) that [47m'save-expansion-file[0m is assigned a different value by the
  user.  In most respects, the [47m:comp[0m setting is treated exactly the
  same as [47m:warn[0m; but after all events in the book are processed, the
  expansion file is compiled if a compiled file was not loaded, after
  which the resulting compiled file is loaded.

  One can thus, for example, compile books for several different host
  Lisps --- useful when installing ACL2 executables at the same site
  that are built on different host Lisps.  A convenient way to do
  this in an environment that provides Gnu `make' is to certify the
  community books using the shell command ``[47mmake regression[0m'' in the
  [47macl2-sources/[0m directory, after setting environment variable
  [47mACL2_SAVE_EXPANSION[0m to [47mt[0m, and then moving to the [47mbooks[0m directory
  and executing the appropriate `make' commands to compile the books
  (targets [47mfasl[0m, [47mo[0m, and so on, according to the compiled file
  extension for the host Lisp).

  We conclude by saying more about the [47m:load-compiled-file[0m argument of
  [47m[include-book][0m.  We assume that [state] global [47m'compiler-enabled[0m
  has a non-[47mnil[0m value; otherwise [47m:load-compiled-file[0m is always
  treated as [47mnil[0m.

  We do not consider raw mode below (see [set-raw-mode]), which
  presents a special case: ACL2 will attempt to load the book itself
  whenever it would otherwise load the expansion or compiled file,
  but cannot (either because the [47m:load-compiled-file[0m argument is [47mnil[0m,
  or for each of the expansion and compiled files, either it does not
  exist or it is out of date with respect to the [47m.cert[0m file).

  The [47m:load-compiled-file[0m argument is not recursive: calls of
  [47minclude-book[0m that are inside the book supplied to [47minclude-book[0m use
  their own [47m:load-compiled-file[0m arguments.  However, those subsidiary
  [47minclude-book[0m calls can nevertheless be sensitive to the
  [47m:load-compiled-file[0m arguments of enclosing [47minclude-book[0m calls, as
  follows.  If [47m:load-compiled-file[0m has value [47mt[0m, then every subsidiary
  [47minclude-book[0m is required to load a compiled file.  Moreover, if a
  book's compiled file or expansion file is loaded in raw Lisp, then
  an attempt will be made to load the compiled file or expansion file
  for any [47m[include-book][0m form encountered during that load.  If that
  attempt fails, then that load immediately aborts, as does its
  parent load, and so on up the chain.  If, when going up the chain,
  an [47m[include-book][0m is aborted for which keyword argument
  [47m:load-compiled-file[0m has value [47mt[0m, then an error occurs.

  When loading a book's compiled file or expansion file, [47mFILE[0m, it is
  possible to encounter an [47m[include-book][0m form for a book that has no
  suitable compiled file or expansion file.  In that case, the load
  of [47mFILE[0m is aborted at that point.  Similarly, the load of [47mFILE[0m is
  aborted in the case that this [47minclude-book[0m form has a suitable
  compiled file or expansion file whose load is itself aborted.
  Thus, whenever any [47minclude-book[0m aborts, so do all of its parent
  [47minclude-book[0ms, up the chain.  Such an abort causes an error when
  the [47minclude-book[0m form specifies a [47m:load-compiled-file[0m value of [47mt[0m.")
 (BOOK-CONTENTS
  (BOOKS-TOUR)
  "Restrictions on the forms inside [books]

    Example Book:

    ; This book defines my app function and the theorem that it is
    ; associative.  One irrelevant help lemma is proved first but
    ; it is local and so not seen by include-book.  I depend on the
    ; inferior book \"weird-list-primitives\" from which I get
    ; definitions of hd and tl.

    (in-package \"MY-PKG\")

    (include-book \"weird-list-primitives\")

    (defun app (x y) (if (consp x) (cons (hd x) (app (tl x) y)) y))

    (local
     (defthm help-lemma
       (implies (true-listp x) (equal (app x nil) x))))

    (defthm app-is-associative
      (equal (app (app a b) c) (app a (app b c))))

  The first form in a book must be [47m(in-package \"pkg\")[0m where [47m\"pkg\"[0m is
  some package name known to ACL2 whenever the book is certified.
  The rest of the forms in a book are embedded event forms, i.e.,
  [47m[defun][0ms, [47m[defthm][0ms, etc., some of which may be marked [47m[local][0m.
  See [embedded-event-form].  The usual Common Lisp commenting
  conventions are provided.  Note that since a book consists of
  embedded event forms, we can talk about the ``[47m[local][0m'' and
  ``non-local'' [events] of a book.

  Because [47m[in-package][0m is not an embedded event form, the only
  [47m[in-package][0m in a book is the initial one.  Because [47m[defpkg][0m is not
  an embedded event form, a book can never contain a [47m[defpkg][0m form.
  Because [47m[include-book][0m is an embedded event form, [books] may
  contain references to other [books].  This makes [books] structured
  objects.

  When the forms in a book are read from the file, they are read with
  [47m[current-package][0m set to the package named in the [47m[in-package][0m form
  at the top of the file.  The effect of this is that all symbols are
  [intern]ed in that package, except those whose packages are given
  explicitly with the ``::'' notation.  For example, if a book begins
  with [47m(in-package \"ACL2-X\")[0m and then contains the form

    (defun fn (x)
      (acl2::list 'car x))

  then [47m[defun][0m, [47mfn[0m, [47mx[0m, and [47m[car][0m are all [intern]ed in the [47m\"ACL2-X\"[0m
  package.  I.e., it is as though the following form were read
  instead:

    (acl2-x::defun acl2-x::fn (acl2-x::x)
        (acl2::list 'acl2-x::car acl2-x::x)).

  Of course, [47macl2-x::defun[0m would be the same symbol as [47macl2::defun[0m if
  the [47m\"ACL2-X\"[0m package imported [47macl2::defun[0m.

  If each book has its own unique package name and all the names
  defined within the book are in that package, then name clashes
  between [books] are completely avoided.  This permits the
  construction of useful logical [world]s by the successive inclusion
  of many [books].  Although it is often too much trouble to manage
  several packages, their judicious use is a way to minimize name
  clashes.  Often, a better way is to use [47mlocal[0m; see [local].

  How does [47m[include-book][0m know the definitions of the packages used in
  a book, since [47m[defpkg][0ms cannot be among the forms?  More generally,
  how do we know that the forms in a book will be admissible in the
  host logical [world] of an [47m[include-book][0m?  See [certificate] for
  answers to these questions.")
 (BOOK-EXAMPLE
  (BOOKS-TOUR)
  "How to create, certify, and use a simple book

  Suppose you have developed a sequence of admissible [events] which
  you want to turn into a book.  We call this ``publishing'' the
  book.  This note explains how to do that.

  A key idea of [books] is that they are ``incremental'' in the sense
  that when you include a book in a host logical [world], the [world]
  is incrementally extended by the results established in that book.
  This is allowed only if every name defined by the incoming book is
  either new or is already identically defined.  See
  [redundant-events].  This is exactly the same problem faced by a
  programmer who wishes to provide a utility to other people: how can
  he make sure he doesn't create name conflicts?  The solution, in
  Common Lisp, is also the same: use packages.  While [books] and
  packages have a very tenuous formal connection (every book must
  start with an [47m[in-package][0m), the creation of a book is intimately
  concerned with the package issue.  Having motivated what would
  otherwise appear as an unnecessary fascination with packages below,
  we now proceed with a description of how to publish a book.

  Just to be concrete, let's suppose you have already gotten ACL2 to
  accept the following sequence of [command]s, starting in the ACL2
  initial [state].

    (defpkg \"ACL2-MY-BOOK\"
            (union-eq *common-lisp-symbols-from-main-lisp-package*
                      *acl2-exports*))
    (in-package \"ACL2-MY-BOOK\")
    (defun app (x y)
      (if (consp x) (cons (car x) (app (cdr x) y)) y))
    (defun rev (x)
      (if (consp x) (app (rev (cdr x)) (list (car x))) nil))
    (defthm rev-app-hack
      (equal (rev (app a (list x))) (cons x (rev a))))
    (defthm rev-rev
      (implies (acl2::true-listp x) (equal (rev (rev x)) x)))

  Observe that the first form above defines a package (which imports
  the symbols defined in CLTL such as [47m[if][0m and [47m[cons][0m and the symbols
  used to [command] ACL2 such as [47m[defun][0m and [47m[defthm][0m).  The second
  form selects that package as the current one.  All subsequent forms
  are read into that package.  The remaining forms are just event
  forms: [47m[defun][0ms and [47m[defthm][0ms in this case.

  Typically you would have created a file with Emacs containing these
  forms and you will have submitted each of them interactively to
  ACL2 to confirm that they are all admissible.  That interactive
  verification should start in ACL2's initial [world] --- although
  you might, of course, start your sequence of [events] with some
  [47m[include-book][0ms to build a more elaborate [world].

  The first step towards publishing a book containing the results above
  is to create a file that starts with the [47m[in-package][0m and then
  contains the rest of the forms.  Let's call that file
  [47m\"my-book.lisp\"[0m.  The name is unimportant, except it must end with
  [47m\".lisp\"[0m.  If there are [events] that you do not wish to be
  available to the user of the book --- e.g., lemmas you proved on
  your way toward proving the main ones --- you may so mark them by
  enclosing them in [47m[local][0m forms.  See [local].  Let us suppose you
  wish to hide [47mrev-app-hack[0m above.  You may also add standard Lisp
  comments to the file.  The final content of [47m\"my-book.lisp\"[0m might
  be:

    ; This book contains my app and rev functions and the theorem
    ; that rev is its own inverse.

      (in-package \"ACL2-MY-BOOK\")
      (defun app (x y)
        (if (consp x) (cons (car x) (app (cdr x) y)) y))
      (defun rev (x)
        (if (consp x) (app (rev (cdr x)) (list (car x))) nil))

    ; The following hack is not exported.
      (local (defthm rev-app-hack
        (equal (rev (app a (list x))) (cons x (rev a)))))

      (defthm rev-rev
        (implies (acl2::true-listp x) (equal (rev (rev x)) x)))

  The file shown above [31;1mis[0m the book.  By the time this note is done you
  will have seen how to certify that the book is correct, how to
  compile it, and how to use it in other host [world]s.  Observe that
  the [47m[defpkg][0m is not in the book.  It cannot be: Common Lisp
  compilers disagree on how to treat new package definitions
  appearing in files to be compiled.

  Since a book is just a source file typed by the user, ACL2 provides a
  mechanism for checking that the [events] are all admissible and
  then marking the file as checked.  This is called certification.
  To certify [47m\"my-book.lisp\"[0m you should first get into ACL2 with an
  initial [world].  Then, define the package needed by the book, by
  typing the following [47m[defpkg][0m to the ACL2 [prompt]:

    ACL2 !>(defpkg \"ACL2-MY-BOOK\"
                   (union-eq *common-lisp-symbols-from-main-lisp-package*
                             *acl2-exports*))

  Then execute the [command]:

    ACL2 !>(certify-book \"my-book\" 1 t) ; the `t' is in fact the default

  Observe that you do not type the [47m\".lisp\"[0m part of the file name.  For
  purposes of [books], the book's name is [47m\"my-book\"[0m and by the time
  all is said and done, there will be several extensions in addition
  to the [47m\".lisp\"[0m extension associated with it.

  The [47m1[0m tells [47m[certify-book][0m that you acknowledge that there is one
  command in this ``certification [world]'' (namely the [47m[defpkg][0m).
  To use the book, any prospective host [world] must be extended by
  the addition of whatever [command]s occurred before certification.
  It would be a pity to certify a book in a [world] containing junk
  because that junk will become the ``[portcullis]'' guarding
  entrance to the book.  The [47mt[0m above tells [47m[certify-book][0m that you
  wish to compile [47m\"my-book.lisp\"[0m also (but see [compilation] for an
  exception).  [47m[Certify-book][0m makes many checks but by far the most
  important and time-consuming one is that it ``proves'' every event
  in the file.

  When [47m[certify-book][0m is done it will have created two new files.  The
  first will be called [47m\"my-book.cert\"[0m and contains the
  ``[certificate]'' attesting to the admissibility of the [events] in
  [47m\"my-book.lisp\"[0m.  The [certificate] contains the [47m[defpkg][0m and any
  other forms necessary to construct the certification [world].  It
  also contains so-called [book-hash] values that are used to help
  you keep track of which version of [47m\"my-book.lisp\"[0m was certified.

  The second file that may be created by [47m[certify-book][0m is the compiled
  version of [47m\"my-book.lisp\"[0m and will have a name that is assigned by
  the host compiler (e.g., [47m\"my-book.o\"[0m in GCL, [47m\"my-book.fasl\"[0m in
  SBCL).  [47m[Certify-book][0m will also load this object file.  When
  [47m[certify-book][0m is done, you may throw away the logical [world] it
  created, for example by executing the [command] [47m:u[0m.

  To use the book later in any ACL2 session, just execute the event
  [47m(include-book \"my-book\")[0m.  This will do the necessary [47m[defpkg][0m,
  load the non-[47m[local][0m [events] in [47m\"my-book.lisp\"[0m and then may load
  the compiled code for the non-local functions defined in that file.
  Checks are made to ensure that the [certificate] file exists and
  describes the version of [47m\"my-book.lisp\"[0m that is read.  The compiled
  code is loaded if and only if it exists and has a later write date
  than the source file (but see [compilation] for an exception).

  Since [47m[include-book][0m is itself an event, you may put such forms into
  other [books].  Thus it is possible for the inclusion of a single
  book to lead to the inclusion of many others.  The [book-hash]
  information maintained in [certificate]s helps deal with the
  version control problem of the referenced [books].  I.e., if this
  version of [47m\"my-book\"[0m is used during the certification of
  [47m\"your-book\"[0m, then the [certificate] for [47m\"your-book\"[0m includes the
  book-hash for this version of [47m\"my-book\"[0m.  If a later [47m(include-book
  \"your-book\")[0m finds a version of [47m\"my-book\"[0m with a different
  book-hash, an error is signaled.  But book-hash values are not
  perfect and the insecurity of the host file system prevents ACL2
  from guaranteeing the logical soundness of an [47m[include-book][0m event,
  even for a book that appears to have a valid [certificate] (they
  can be forged, after all).  (See [certificate] for further
  discussion.)

  This concludes the example of how to create, certify and use a book.
  If you wish, you could now review the [documentation] for
  book-related topics (see [books]) and browse through them.  They'll
  probably make sense in this context.  Alternatively, you could
  continue the ``guided tour'' through the rest of the
  [documentation] of [books].  See [book-name], following the pointer
  given at the conclusion.")
 (BOOK-HASH
  (BOOKS)
  "Assigning ``often unique'' fingerprints to [books]

  ACL2 provides a [3mcertification[0m process for recording into a
  [certificate] file that a book is valid.  That process records
  certain ``fingerprint'' values for the book and the books that it
  includes, in order to give some confidence in the book's validity.
  We call that value the ``book-hash'' for the book.  By default, a
  book-hash is an alist that records, for a given book ([47m.lisp[0m file),
  its file size (in bytes) and its write-date.

  You can arrange for a book-hash to be a checksum instead of an alist,
  which gives a bit greater security, as illustrated in an example
  provided below.  See [checksum].  Nevertheless, the (default) use
  of book-hash alists may be worthwhile, in spite of the decreased
  security, because of faster times for [47m[certify-book][0m and
  [47m[include-book][0m when using book-hash alists instead of checksums.
  If you want to use checksums, however, there are these two ways to
  do so.

    * Before starting ACL2, set environment variable [47mACL2_BOOK_HASH_ALISTP[0m
      to [47mNIL[0m (or [47mnil[0m; actually it suffices that [47m[string-upcase][0m
      applied to the indicated string is [47m\"NIL\"[0m).  A common way to get
      this effect is to supply the argument [47mACL2_BOOK_HASH_ALISTP=NIL[0m
      with your [47m\"make\"[0m command.

    * After starting ACL2, set [state] global variable [47mbook-hash-alistp[0m to
      [47mnil[0m, e.g.: [47m(assign book-hash-alistp nil)[0m.  (Set this variable
      to [47mt[0m to revert to the default behavior: [47m(assign
      book-hash-alistp t)[0m.)

  The simple example below illustrates the potential weakness of
  book-hash alists (as compared to checksums), by exploiting the fact
  that these alists do not hash information in the [certificate]
  itself.  (Book-hash alists also ignore [portcullis] [command]s and
  the corresponding [47m.acl2x[0m file, if any (see [set-write-ACL2x]); but
  we don't exploit these facts in this example.)  We start with the
  following book, [47m\"foo.lisp\"[0m.

    (in-package \"ACL2\")
    (make-event '(defun foo (x) (cons x x)))

  Now start ACL2 and run these commands.

    (assign book-hash-alistp t) ; a no-op, by default
    (certify-book \"foo\")
    (read-file \"foo.cert\" state)
    (quit)

  Next, replace the contents of [47m\"foo.cert\"[0m by the values in the list
  printed by the [47mread-file[0m form above (hence, without the outer
  parentheses).  Further edit that file by twice changing [47m(cons x x)[0m
  to [47mx[0m.  Also, update the write-date on the compiled file, e.g. with
  [47mtouch foo.dx64fsl[0m, if you want to avoid a warning.  Then submit
  [47m(include-book \"foo\")[0m.  We get the following contradictory behavior,
  without any warnings.

    ACL2 !>(foo 3)
    (3 . 3)
    ACL2 !>(thm (equal (foo x) x))

    Q.E.D.

    Summary
    Form:  ( THM ...)
    Rules: ((:DEFINITION FOO))
    Time:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)
    Prover steps counted:  5

    Proof succeeded.
    ACL2 !>

  For more information about connections between book-hash values and
  certification status, see [book-hash-mismatch].


Subtopics

  [Book-hash-mismatch]
      Deeming a book uncertified because of a [book-hash] mismatch")
 (BOOK-HASH-MISMATCH
  (BOOK-HASH)
  "Deeming a book uncertified because of a [book-hash] mismatch

  When [47m[include-book][0m is invoked, the specified book may be considered
  uncertified by ACL2 because its [book-hash] --- which by default is
  an alist specifying the book's size and write-date, but could be a
  checksum --- does not match what was expected.  In that case you
  will typically see a warning such as the following, which instead
  will be an error if this occurs during certification.  In this
  topic, we explain how this warning can occur.

    ACL2 Warning [Uncertified] in ( INCLUDE-BOOK \"foo\" ...):
    The certificate for \"/Users/kaufmann/temp/foo.lisp\" lists the book-
    hash of that book as ((:BOOK-LENGTH . 38) (:BOOK-WRITE-DATE . 3674050905)).
    But its book-hash is now computed to be
    ((:BOOK-LENGTH . 39) (:BOOK-WRITE-DATE . 3674050914)).
    See :DOC book-hash-mismatch.

  Probably the simplest way for such a mismatch to occur is if you
  change the book after certifying it, and then try to include the
  book.  In the example message displayed above, the book-hash for
  [47mfoo.lisp[0m stored into [47mfoo.cert[0m was 516310554.  But then [47mfoo.lisp[0m was
  edited (in this case, by adding a single newline character), and
  ACL2 complained because at [47minclude-book[0m time it computed a
  different book-hash for that book.

  The mismatch might occur on a book that is being included while
  including a superior book.  For example, suppose that the act of
  evaluating [47m(include-book \"bk1\")[0m triggers evaluation of the event
  [47m(include-book \"bk2\")[0m from [47mbk1.lisp[0m, which similarly in turn causes
  evaluation of the event [47m(include-book \"bk3\")[0m from [47mbk2.lisp[0m.  Now
  certify [47mbk3.lisp[0m, then [47mbk2.lisp[0m, and finally [47mbk1.lisp[0m.  So far, so
  good.  But now suppose we edit the lowest-level book, [47mbk3.lisp[0m.  We
  will likely get a warning (or error, if during book certification)
  such as the one displayed above when evaluating [47m(include-book
  \"bk1\")[0m, complaining that the book-hash for [47mbk3.lisp[0m has changed ---
  followed by warnings complaining about inclusions of uncertified
  books by superior books.

  There are several ways for a book-hash in a [47m.cert[0m file to become
  invalid, that is, to fail to match a recomputation of the book-hash
  when later including the book.  All such mismatches are due to a
  difference between the value of a book-hash at certification time
  and at later [47minclude-book[0m time; see [book-hash].

  Note that it is possible to mix alist and checksum book-hash values.
  The key is to avoid conflicts between book-hash values stored for
  the same book in different [47m.cert[0m files.  The following example
  works fine, because there is no such conflict: the book [47m\"sub\"[0m is
  associated with a book-hash checksum in [47msub.cert[0m, which provides
  that same checksum as the book-hash value for [47m\"sub\"[0m in [47mtop.cert[0m;
  and the book [47m\"top\"[0m is associated with a book-hash alist in
  [47mtop.cert[0m.

    (certify-book \"sub\")
    (u)
    (assign book-hash-alistp t)
    (certify-book \"top\") ; contains the event (include-book \"sub\")
    (u)
    (include-book \"top\") ; no problem!

  However, if we instead evaluate the following forms in a fresh ACL2
  session, the last one causes an error, because a checksum serves as
  the book-hash for [47m\"sub\"[0m in [47mtop.cert[0m, but at [47minclude-book[0m time the
  book-hash for [47m\"sub\"[0m in [47msub.cert[0m is an alist, not a checksum.

    (certify-book \"sub\")
    :u
    (certify-book \"top\") ; contains the event (include-book \"sub\")
    :u
    (assign book-hash-alistp t)
    (certify-book \"sub\") ; now the book-hash for sub is an alist
    :u
    ; Error: mismatch for book-hash values for \"sub\" in
    ;        new sub.cert and earlier top.cert.
    (include-book \"top\")

  That said, ACL2 does not care about the current value of state global
  [47mbook-hash-alistp[0m at [47minclude-book[0m time.  For example, the following
  works without error: ACL2 sees the checksum stored in [47msub.cert[0m, so
  at [47minclude-book[0m time it computes a checksum for the book [47m\"sub\"[0m, not
  an alist, even though [47m'book-hash-alistp[0m has value [47mt[0m.

    (assign book-hash-alistp nil)
    (certify-book \"foo\")
    (assign book-hash-alistp t)
    (include-book \"foo\")

  We conclude by discussing a rather insidious book-hash mismatch that
  can occur when including a book using an ACL2 executable that
  differs from the executable that was used when certifying the book.
  Here is an example.  Consider a book, [47m\"foo.lisp\"[0m, containing the
  event [47m(include-book \"tools/remove-hyps\" :dir :system)[0m.  Suppose we
  have ACL2 executables [47macl2-cksum[0m and [47macl2-alist[0m, in different ACL2
  directories.  Also suppose that we have certified (disjoint copies
  of) the [community-books] with each of these ACL2 executables,
  where we used [47mACL2_BOOK_HASH_ALISTP=NIL[0m in our [47m\"make\"[0m command with
  [47macl2-cksum[0m but not with [47macl2-alist[0m.  Now suppose we certify
  [47m\"foo.lisp\"[0m using [47macl2-cksum[0m but then, in a session with [47macl2-alist[0m,
  we include that same book.  Then we will see a warning beginning as
  displayed below.  It complains that the book-hash required of
  [47mbooks/tools/remove-hyps.cert[0m according to [47mfoo.cert[0m --- which was
  created using [47macl2-cksum[0m --- differs from the book-hash in the
  [47m.cert[0m file of the copy of that book that is under the directory of
  the currently running ACL2, [47macl2-alist[0m.

    ACL2 Warning [Uncertified] in ( INCLUDE-BOOK \"foo\" ...):  After including
    the book \"/Users/smith/temp/foo.lisp\":

    -- its certificate requires the book \"/Users/smith/acl2/books/tools/remove-
    hyps.lisp\" with certificate annotations
      ((:SKIPPED-PROOFSP) (:AXIOMSP) (:TTAGS))
    and book hash 1958615726, but we have included a version of \"remove-hyps\"
    with certificate annotations
      ((:SKIPPED-PROOFSP) (:AXIOMSP) (:TTAGS))
    and book-hash ((:BOOK-LENGTH . 14650) (:BOOK-WRITE-DATE . 3656629263)),
    so book recertification is probably required;")
 (BOOK-MAKEFILES (POINTERS)
                 "See [books-certification].")
 (BOOK-NAME
  (BOOKS-TOUR)
  "Conventions associated with book-names

    Examples:
    \"list-processing\"
    \"/usr/home/smith/my-arith\"

  A [3mbook-name[0m is typically a string constant that represents a file.
  (Much later below we discuss other book-names that are not strings,
  namely, [sysfile]s; but till then we consider only strings.)  We
  elaborate book names by concatenating the ``connected book
  directory'' (see [cbd]) string on the left and perhaps a [47m\".lisp\"[0m
  ``extension'' on the right.  However, the connected book directory
  is not added if the book-name itself already represents an absolute
  file name.  Furthermore, [47m[include-book][0m and [47m[certify-book][0m
  temporarily reset the connected book directory to be the directory
  of the book being processed.  This allows [47m[include-book][0m forms to
  use relative pathnames without explicit mention of the enclosing
  book's directory.

  You may wish to read elsewhere for details of ACL2 file name
  conventions (see [pathname]), for a discussion of the filename that
  is the result of the elaboration described here (see
  [full-book-name]), and for details of the concept of the connected
  book directory (see [cbd]).  For details of how [47m[include-book][0m (see
  [include-book]) and [47m[certify-book][0m (see [certify-book]) use these
  concepts, see below.

  Often a book-name is simply the familiar name of the file.  (See
  [full-book-name] for discussion of the notions of ``directory
  string,'' ``familiar name,'' and ``extension''.  These concepts are
  not on the guided tour through [books] and you should read them
  separately.)  However, it is permitted for a book-name to include a
  directory or part of a directory name.  Book-names often do not
  include the extension, since ACL2 must routinely tack several
  different extensions onto the name during [47m[include-book][0m.  For
  example, [47m[include-book][0m uses the [47m\".lisp\"[0m, [47m\".cert\"[0m and possibly a
  compiled file extension (like [47m\".fasl\"[0m) of the book-name.

  A book-name is elaborated into a [full-book-name] by [47m[include-book][0m
  and [47m[certify-book][0m.  This elaboration is sensitive to the
  ``connected book directory.'' The connected book directory is an
  absolute filename string (see [pathname]) that is part of the ACL2
  [47m[state][0m.  (You may wish to see [cbd] and to see [set-cbd] --- note
  that these are not on the guided tour).  If a book-name is an
  absolute filename string, ACL2 elaborates it simply by appending
  the desired extension to the right.  If a book-name is a relative
  filename string, ACL2 appends the connected book directory on the
  left and the desired extension on the right.

  Note that it is possible that the book-name includes some partial
  specification of the directory.  For example, if the connected book
  directory is [47m\"/usr/home/smith/\"[0m then the book-name
  [47m\"project/task-1/arith\"[0m is a book-name that will be elaborated to

    \"/usr/home/smith/project/task-1/arith.lisp\".

  Observe that while the [events] in this [47m\"arith\"[0m book are being
  processed the connected book directory will temporarily be set to

    \"/usr/home/smith/project/task-1/\".

  Thus, if the book requires other [books], e.g.,

    (include-book \"naturals\")

  then it is not necessary to specify the directory on which they
  reside provided that directory is the same as the superior book.

  This inheritance of the connected book directory and its use to
  elaborate the names of inferior [books] makes it possible to move
  [books] and their inferiors to new directories, provided they
  maintain the same relative relationship.  It is even possible to
  move with ease whole collections of [books] to different
  filesystems that use a different operating system than the one
  under which the original certification was performed.

  The [47m\".cert\"[0m extension of a book, if it exists, is presumed to contain
  the most recent [certificate] for the book.  See [certificate] (or,
  if you are on the guided tour, wait until the tour gets there).

  Finally we mention another kind of book-name: a [sysfile], which is a
  pair that associates a keyword with a relative pathname.  This kind
  of book-name is used by the implementation, for example in
  [certificate] files, but is rarely visible to users.  If you run
  across a sysfile and want to understand more about it, see
  [sysfile].

  See [book-contents] to continue the guided tour.")
 (BOOKDATA
  (BOOKS)
  "Write small files with meta-data about certified [books]

  ACL2 provides a primitive capability for writing out a file of
  metadata associated with a book.  This information might be useful,
  for example, in building a database that allows you to search for
  name conflicts.  See [community-books] directory
  [47mbooks/tools/book-conflicts/[0m for an application of this capability
  by Dave Greve.  If you use this capability and have ideas for
  enhancing it, please feel free to send them to the ACL2 developers.

  If the book has the name [47mBK[0m, then the output file is named
  [47mBK__bookdata.out[0m.  That file is generated in the same directory as
  [47mBK[0m, by certifying [47mBK[0m when [state] global [47m'write-bookdata[0m has a
  non-[47mnil[0m value, for example as follows.

    (assign write-bookdata t)
    (certify-book \"BK\" ...)

  Alternatively, one may set environment variable [47mACL2_WRITE_BOOKDATA[0m
  to any non-empty value to cause [47mBK__bookdata.out[0m to be written,
  with one exception, namely: when the value of state global
  [47mwrite-bookdata[0m is [47m:never[0m.

  The resulting file will contain a single form of the following shape,
  although not necessarily in the following order, according to the
  description that follows below.

     (\"...BK.lisp\"
      :PKGS          pkgs-val
      :BOOKS         book-val
      :PORT-BOOKS    port-book-val
      :CONSTS        consts-val
      :PORT-CONSTS   port-consts-val
      :FNS           fns-val
      :PORT-FNS      port-fns-val
      :LABELS        labels-val
      :PORT-LABELS   port-labels-val
      :MACROS        macros-val
      :PORT-MACROS   port-macros-val
      :STOBJS        stobjs-val
      :PORT-STOBJS   port-stobjs-val
      :THEORIES      theories-val
      :PORT-THEORIES port-theories-val
      :THMS          thms-val
      :PORT-THMS     port-thms-val
    )

  The first entry in the form will always be the [full-book-name] of
  the certified book, [47mBK[0m, possibly in [sysfile] format.

  Subsequent values in the form are based on [events] introduced by
  including [47mBK[0m.  For various values of [47mxxx[0m as described below,
  [47mport-[0m[3mxxx[0m[47m-val[0m is a list of values corresponding to [events]
  introduced in the certification [world] for [47mBK[0m (see [portcullis]),
  and [3mxxx[0m[47m-val[0m is a list of values corresponding to [events]
  introduced non-[47m[local][0mly by [47mBK[0m.  These lists include only
  ``top-level'' events, not those that are introduced by a book
  included either in [47mBK[0m or its certification world.

  [47mPkgs-val[0m is a list of names of packages introduced in the
  certification world (at the top level, not in an included book).
  Note that no packages are introduced in a book itself, so no
  distinction is made between [47mpkgs-val[0m and [47mport-pkgs-val[0m.  Both
  [47mport-book-val[0m and [47mbook-val[0m are lists of [full-book-name]s of
  included books.  The values associated with the other keywords are,
  themselves, association lists (see [alistp]) such that each key is
  a package name, which is associated with a list of [symbol-name]s
  for symbols in that package that are introduced for that keyword.
  For example, [47mfns-val[0m may be the alist

    ((\"ACL2\" \"F1\" \"F2\")
     (\"MY-PKG\" \"G1\" \"G2\"))

  if the function symbols introduced in the book are [47mF1[0m and [47mF2[0m in the
  [47m\"ACL2\"[0m package, as well as [47mG1[0m and [47mG2[0m in the [47m\"MY-PKG\"[0m package.

  We next explain what kinds of symbols are introduced for each keyword
  [47m:xxx[0m.  Each such symbol would be associated with either the keyword
  [47m:port-xxx[0m or the keyword [47m:xxx[0m depending respectively on whether the
  symbol is introduced at the top level of the certification world
  for [47mBK[0m or [47mBK[0m itself.

    [47m:CONSTS[0m
      constant symbol introduced by [47mdefconst[0m
    [47m:FNS[0m
      function symbol: introduced by [47mdefun[0m, [47mdefuns[0m, or [47mdefchoose[0m; or
      constrained (by an [47m[encapsulate][0m event)
    [47m:LABELS[0m
      symbol introduced by [47mdeflabel[0m
    [47m:MACROS[0m
      macro name introduced by [47mdefmacro[0m
    [47m:STOBJS[0m
      [47mstobj[0m name introduced by [47mdefstobj[0m or [47mdefabsstobj[0m
    [47m:THEORIES[0m
      theory name introduced by [47mdeftheory[0m
    [47m:THMS[0m
      theorem name, which may be introduced by [47mdefthm[0m or a macro call
      expanding to a call of [47mdefthm[0m, such as see [defequiv] or
      [47mdefaxiom[0m; but may be introduced by [47m[defpkg][0m, for example, with
      name [47m\"MYPKG-PACKAGE\"[0m if the package name is [47m\"MYPKG\"[0m

  Our hope is that people in the ACL2 community will generate and use
  this data to improve the ACL2 [community-books].  Here is an
  example illustrating how to generate bookdata files for those books
  as a byproduct of a regression run.  Below, we write [47m{DIR}[0m as an
  abbreviation for the ACL2 sources directory, and assume that this
  command is run from that directory.  Of course, you may wish to use
  [47mmake[0m options like [47m-j 8[0m and [47mmake[0m variable settings like
  [47mACL2={DIR}/my-saved_acl2[0m; see [books-certification] for details.

    make regression-fresh \\
    ACL2_CUSTOMIZATION={DIR}/acl2-customization-files/bookdata.lisp")
 (BOOKS
  (ACL2)
  "[3mBooks[0m are files of ACL2 [events]---they are the main way to split up
  large ACL2 developments into separate modules.

  This [documentation] topic is about ACL2 {source code |
  https://en.wikipedia.org/wiki/Source_code} files.  However, there
  are also {traditional, paper books |
  http://www.cs.utexas.edu/users/moore/publications/acl2-papers.html#Books}
  published about ACL2 and its applications.

  You will almost surely want to organize your own ACL2 work into
  books.  They facilitate reuse, allow you to reload proofs more
  quickly, allow you to rebuild parts of your proof in parallel, and
  so forth.  You will also want to be aware of the many [3mcommunity
  books[0m, which provide useful tools and lemmas to build upon.  See
  [community-books] for more information, including how to
  contribute.


Introduction

  A [31;1mbook[0m is a file of ACL2 forms.  Books are prepared entirely by the
  user of the system, i.e., they are [3msource files[0m not [3mobject files[0m.
  Some of the forms in a book are marked [47m[local][0m and the others are
  considered ``non-local.''

  [47m[Include-book][0m lets you load a book into any ACL2 [world].  A
  successful [47minclude-book[0m extends the logic of the host [world] by
  adding just the non-local [events] in the book.  Ordinarily, you
  might include a variety of books to load all of their definitions
  and rules.

  Successful book inclusion is consistency preserving, provided that
  the book itself is consistent, as discussed later.  However,
  [47m[include-book][0m assumes the [events] in a book are valid, so if you
  include a book that contains an inconsistency (e.g., an
  inadmissible definition) then the resulting theory is inconsistent!

  [47m[Certify-book][0m lets you [3mcertify[0m a book to guarantee that its
  successful inclusion is consistency preserving.  During
  certification, both the [47m[local][0m and non-local forms are processed.
  This lets you mark as [47m[local][0m any [events] you need for
  certification, but that you want to hide from users of the
  book---e.g., the hacks, crocks, and kludges on the way to a good
  set of [rewrite] rules.

  Certification can also compile (see [COMPILATION]) a book to speed up
  the execution of the functions defined within it.  The desire to
  compile books is largely responsible for the restrictions we put on
  the forms allowed in books.

  Extensive [documentation] is available on the various aspects of
  books.  We recommend that you read it all before using books.  It
  has been written so as to make sense when read in a certain linear
  sequence, called the ``guided tour'', though in general you may
  browse through it randomly.  If you are on the guided tour, you
  should next read [book-example].


Subtopics

  [Book-hash]
      Assigning ``often unique'' fingerprints to [books]

  [Bookdata]
      Write small files with meta-data about certified [books]

  [Books-reference]
      Reference guide for ACL2 functionality related to books, e.g.,
      [include-book], [certify-book], [cbd], etc.

  [Books-tour]
      The [3mguided tour[0m of concepts related to ACL2 [books].

  [Community-books]
      Libraries of ACL2 [books] developed by the ACL2 community.

  [Project-dir-alist]
      Support for moving project directories (also [47m:dir[0m arguments)

  [Sysfile]
      File representation using ACL2 project directories

  [Uncertified-books]
      Invalid [certificate]s and uncertified [books]")
 (BOOKS-CERTIFICATION
  (COMMUNITY-BOOKS)
  "Instructions for certifying the ACL2 [community-books].

  The Community Books (see [COMMUNITY-BOOKS]) provides a [47mmake[0m system,
  which is recommended for certifying a specified subset of those
  books from the [47mbooks/[0m directory of your ACL2 distribution.
  Alternate instructions are however available for certifying from
  the top-level directory (see [books-certification-alt]).

  Below are instructions for certifying various sets of books.  They
  all have the following form in common.  Note: If there is a
  suitable [47m\"acl2\"[0m executable on your Unix [47mPATH[0m --- for example, if
  the [47mbin[0m subdirectory of the main ACL2 directory is on your [47mPATH[0m, so
  that [47mbin/acl2[0m may be your executable --- then you can omit
  [47m\"ACL2=...\"[0m below.

    cd /path/to/acl2-sources/books
    make ACL2=/path/to/acl2-sources/saved_acl2 ...

  For example, the section ``A Full Build'', below, says to do the
  following if you would like to make a change to the
  [community-books] (where the [47m-j[0m argument is optional).

    $ cd /path/to/acl2-sources/books
    $ make ACL2=/path/to/acl2-sources/saved_acl2 -j 2 all

  Success is indicated by a Linux exit status of 0.  Equivalently,
  there should be no failures in the log.  Failures may be found by
  searching for [47m**[0m; for example, if output is redirected to a log
  file [47mmake-regression.log[0m, then the following should provide no
  output.

    fgrep -a '**' make-regression.log

  Unusual books that create output in the log file should not produce
  the string [47m**[0m except upon failure.

  By default, [47mmake[0m commands for certifying books take advantage of
  files [47m*@useless-runes.lsp[0m.  See [useless-runes].


Prerequisites

  We assume that you have already downloaded and installed ACL2 as per
  the {ACL2 installation instructions |
  http://www.cs.utexas.edu/users/moore/acl2/v8-6/HTML/installation/installation.html}
  on the ACL2 home page.

  We assume you know the path to your ACL2 executable.  Typically this
  is a script named [47msaved_acl2[0m in your [47macl2-sources[0m directory.

  We assume the ACL2 [community-books] are installed in the [47mbooks/[0m
  subdirectory of your ACL2 distribution, as is the case when you
  have followed the ACL2 installation instructions above.

  The instructions below are suitable for ACL2 and all of its
  experimental extensions, e.g., ACL2(p) and ACL2(r).

  It may be preferable to avoid being logged in as root, since
  developers do not test as root and at least one community book
  ([47mbooks/oslib/tests/copy.lisp[0m) has failed to certify when logged in
  as root.


A Basic Build

  Before ACL2 Version 6.4, building the Community Books could take
  several hours.  Now, the default [47mmake[0m target in [47mbooks/GNUmakefile[0m,
  called [47mbasic[0m, is much faster --- it excludes many books and
  certifies only books listed below, which tend to be widely used.
  [31;1mWARNING[0m: the [47mbasic[0m target of [47mbooks/GNUmakefile[0m is insufficient for
  validating changes that will go into the [community-books]; for
  that, use the [47mall[0m target.

    * arithmetic

    * arithmetic-3

    * arithmetic-5

    * [ihs]

    * misc

    * tools (mostly)

    * [std]

    * [xdoc] (in part)

    * data-structures

  To certify these books, you should be able to run [47mmake[0m as follows.
  The [47m-j 2[0m part of this command is suitable for a computer with two
  cores.  If you have, e.g., a quad-core computer, you should
  probably use [47m-j 4[0m instead, and so on.

    $ cd /path/to/acl2-sources/books
    $ make ACL2=/path/to/acl2-sources/saved_acl2 -j 2 basic

  If you configure your [47mPATH[0m so that you can launch ACL2 by typing
  [47macl2[0m, then you may omit the [47mACL2=...[0m part.


Certifying Additional Books

  We expect that most ACL2 users will want to certify at least the
  [47mbasic[0m books described above.  But what if you also need other
  books?  One option is to do a full build (see below).  But it is
  usually [31;1mmuch faster[0m to simply tell [47mmake[0m to build the books you
  actually want to use.

  There are [47mmake[0m targets corresponding to most directory names.  For
  instance, to build the books under [47mcoi[0m and [47mrtl[0m and [47mcgen[0m, you can
  run:

    $ cd /path/to/acl2-sources/books
    $ make ACL2=/path/to/acl2-sources/saved_acl2 coi rtl cgen -j 2

  For finer grained control, you can name individual books.  This works
  particularly well for libraries that have [47mtop[0m books.  For instance,
  if you want the [47mrtl/rel9[0m library, you could run:

    $ cd /path/to/acl2-sources/books
    $ make ACL2=/path/to/acl2-sources/saved_acl2 rtl/rel9/lib/top.cert -j 2


Books that Require ACL2 Extensions

  Some books require experimental extensions to ACL2, such as ACL2(p)
  (see [parallelism]) or ACL2(r) (see [real]).  Other books require
  certain additional software.

  The build system will automatically determine which kind of ACL2 you
  are running (ACL2, ACL2(p), or ACL2(r)) and, based on this, may
  prevent incompatible books from being certified.  The output of
  [47mmake[0m should explain which books are being excluded and why.

  These kinds of book requirements are controlled by special
  [build::cert_param] comments.


Books that Require Quicklisp

  Some books, especially [interfacing-tools] like [oslib] and the ACL2
  [bridge], require certain Common Lisp libraries.

  These libraries are now bundled with ACL2 via [quicklisp], so you
  should not need to download anything extra to use them.  They are
  enabled by default for all host Lisps except GCL, but you can avoid
  books that depend on Quicklisp libraries by setting [47mUSE_QUICKLISP=0[0m
  in your [47mmake[0m command.

  Using Quicklisp should definitely work if the host Lisp is CCL or
  SBCL.  (Note however that certification of [books] that use
  Quicklisp may require [47mopenssl[0m to be installed if it is not already
  on your system.)  There is some chance it will work with Allegro
  CL, LispWorks, and CMUCL.  It will almost certainly [31;1mnot[0m work for
  GCL (at least as of 2018).


Books that Require Additional Software

  Some other books based on [satlink] and [gl] require a SAT solver,
  typically Glucose, to be installed; see
  [satlink::sat-solver-options] for installation options.  The build
  system should automatically determine if Glucose is installed on
  your system, and will avoid trying to certify these books unless
  Glucose is present.


Building the manual

  If you just want to get a copy of the ACL2+Books manual for local
  viewing, you probably [31;1mdon't need to build it yourself[0m because you
  can just {download | download/} a copy.  If for some reason you do
  want to build the manual yourself, you should be able to do so as
  follows, provided you have installed glucose.  (That requirement
  might be eliminated in the future.)

    $ cd /path/to/acl2-sources/books
    $ make manual -j 4

  Building the manual should work on at least CCL and SBCL on Linux and
  Mac OS X.  It [31;1mmay not work[0m for some other OS/Lisp combinations.  In
  particular, building the manual requires some features from [oslib]
  and [quicklisp] that may not be available on some other Lisps.

  The resulting web-based manual may be found in:

    acl2-sources/books/doc/manual/index.html

  See also [ACL2-doc] for details about how to build your own
  Emacs-based manual, and [xdoc::save] for general information about
  how to build and distribute custom XDOC manuals, e.g., manuals that
  additionally include your own unreleased books.


A Full Build

  Building all of the books can take hours and is [31;1musually unnecessary[0m.
  That said, it is easy to do: just run [47mmake all[0m, for example as
  follows.  (But as noted above, you may omit [47m\"ACL2=...\"[0m if a
  suitable executable named [47macl2[0m is on your Unix [47mPATH[0m, such as
  [47mbin/acl2[0m.)

    $ cd /path/to/acl2-sources/books
    $ make ACL2=/path/to/acl2-sources/saved_acl2 -j 2 all

  This includes a few books that are quite slow to certify.  You can
  exclude those by replacing ``[47mall[0m'' by ``[47mregression[0m'' in the command
  above.


Cleaning Up

  If you want to delete generated files, you can run [47mmake clean[0m to
  remove certificates, compiled files, and build logs.

  If you just want to remove the files in a particular subdirectory
  (and its subdirectories), you can go into that directory and then
  run the [47mbuild/clean.pl[0m script.  This will delete, starting from
  your current directory, recursively, all certificates, logs,
  compiled files, etc.

  Note that [47mmake clean[0m doesn't remove some files, e.g., [xdoc] manuals.
  To remove everything, try [47mmake moreclean[0m.


Debugging Failed Certifications

  If a book fails to certify, you may want to try certifying it in an
  interactive session.  The most reliable way to do this is to
  replicate the environment and commands that the build system used.
  This information can be found at the top of the [47m[bookname].cert.out[0m
  file.  For instance:

    ;; foo.cert.out
    -*- Mode: auto-revert -*-
    ...
    Environment variables:
    ACL2_CUSTOMIZATION=NONE                 ;; <-- first configure your
    ACL2_SYSTEM_BOOKS=/path/to/acl2/books   ;;     environment to match
    ACL2=/path/to/saved_acl2                ;;     these settings
    ...
    Temp lisp file:
    (acl2::value :q)                 ;; <--- then submit these commands to
    (acl2::in-package \"ACL2\")      ;;      $ACL2 to debug the failure
    ...                              ;;      interactively
    --- End temp lisp file ---

  Some other notes/tips:

    * Make sure the ACL2 image you run is the same as the one listed as
      ACL2 in those environment variables!

    * You may wish to set the environment variables for only the duration
      of your ACL2 session by using the \"env\" command.

    * You may wish to edit some of the commands for better debugging
      purposes; e.g. you may modify the [set-inhibit-output-lst]
      command, or insert a [set-debugger-enable] command, etc.

    * If you don't want your session to exit after a successful
      certification, replace the last form [47m(er-progn (time$
      (certify-book ...[0m with just the [47m(time$ (certify-book ...))[0m
      part.


Further Resources

  The build system is largely based on [build::cert.pl].  There is
  considerable documentation about [47mcert.pl[0m, and we highly recommend
  using it to manage your own ACL2 projects.

  The main build script is [47mbooks/GNUmakefile[0m.  There are many comments
  at the start of this file, and you can also inspect it to see what
  targets are available.

  Please feel absolutely free to contact the [ACL2-help] mailing list
  with any questions about building the community books.


Subtopics

  [Books-certification-alt]
      Alternate instructions for certifying the [community-books], from
      the perspective of the [47macl2-sources[0m directory.

  [Books-certification-classic]
      Classic ACL2 `make'-based certification of [books]

  [Provisional-certification]
      Certify a book in stages for improved book-level parallelism")
 (BOOKS-CERTIFICATION-ALT
  (BOOKS-CERTIFICATION)
  "Alternate instructions for certifying the [community-books], from the
  perspective of the [47macl2-sources[0m directory.

  WARNING: Parts of this documentation are probably obsolete, but parts
  are still relevant.  See [books-certification] as the primary
  source of information on how to certify the [community-books].

  For background on the ACL2 community books, see [community-books].
  Here we explain how to certify those books, or some of those books,
  with ACL2.  We thank Bishop Brock, Jared Davis, and Sol Swords for
  their substantial contributions to this methodology.  See
  [47mbooks/GNUmakefile[0m, in the community books, for more about ``Credits
  and History'', and for additional technical details not covered in
  this topic.

  For more information about installing ACL2, see the {ACL2
  installation instructions |
  http://www.cs.utexas.edu/users/moore/acl2/v8-6/HTML/installation/installation.html}.
  For information about so-called ``classic ACL2 `make'-based
  certification'', which provides support for certifying directories
  of books but may disappear in a future ACL2 release, see
  [books-certification-classic].

  [31;1mThe Basics[0m

  We make the following assumptions.

    * Gnu `make' is available on your system via the `make' command (rather
      than some other flavor of `make').  (Execute `[47mmake --version[0m to
      verify this.)

    * You have built or obtained an ACL2 executable.

    * The ACL2 [community-books] are installed in the [47mbooks/[0m subdirectory
      of your ACL2 distribution, as is the case when you have
      followed the standard installation instructions.

  Note: All commands shown below are issued in the top-level (ACL2
  sources) directory of your ACL2 distribution.

  By default the ACL2 executable is file [47msaved_acl2[0m in your ACL2
  sources directory, and you can issue the following command to the
  shell in order to do a ``regression run'' that certifies all of the
  community books using that executable.

    make regression

  Better yet, save a log file in case there are problems, for example
  as follows.

    (make regression) >& make-regression.log

  or perhaps better yet:

    (time nice make regression) >& make-regression.log

  For the sake of brevity, below we'll skip mentioning any of `[47mtime[0m',
  `[47mnice[0m', or `[47m>& make-regression.log[0m'.  But saving a log file, in
  particular, is useful in case you encounter problems to report.

  If you fetched the community books using git, then you will have a
  directories such [47mbooks/workshops/[0m that is not necessary for
  certifying the most widely-included books.  You can certify just
  such books as follows.

    (time nice make basic) >& make-basic.log

  Whether you use target `[47mregression[0m' or target `[47mbasic[0m', then for each
  book [47mfoo.lisp[0m whose certification is attempted, a file [47mfoo.cert.out[0m
  in the same directory will contain the output from the book's
  certification attempt.

  A regression run may take a few hours, but if you have a
  multiprocessing computer, you can speed it up by certifying some
  books in parallel, by providing a value for `make' option [47m-j[0m.  For
  example, if you have 8 hardware threads then you might want to
  issue the following command.

    make regression -j 8

  [31;1mSpecifying the ACL2 Executable[0m

  If your ACL2 executable is not file [47msaved_acl2[0m in the ACL2 sources
  directory, then you will need to specify that executable.  You can
  do that by setting variable [47mACL2[0m, either as an environment variable
  or, as displayed below, as a `make' variable.  Either way, you will
  need to avoid relative pathnames.  For example, the first two forms
  below are legal, but the third is not, assuming that [47mmy-acl2[0m is on
  your [47mPATH[0m in a Unix-like environment (e.g., linux or MacOS) and
  that [47mmy-saved_acl2[0m is just a pathname relative to your ACL2 sources
  directory, which is not on your path.

    make regression -j 8 ACL2=my-acl2
    make regression -j 8 ACL2=/u/smith/bin/acl2
    # The following only works if my-saved_acl2 is on your path (see above).
    make regression -j 8 ACL2=my-saved_acl2

  [31;1mCleaning[0m

  You can delete files generated by book certification (including [47m.cert[0m
  files, [47m.out[0m files, compiled files, and more) by issuing the
  following command (again, in your ACL2 sources directory).

    make clean-books

  Alternatively, if you want to cause such deletion and then do a
  regression, simply replace the `[47mregression[0m' target by
  `[47mregression-fresh[0m.

  If however you only want to clean up generated files residing under a
  given directory (or its subdirectories, and recursively), you can
  issue the following command while standing in that directory, where
  [47mDIR[0m is a pathname of your [47mbooks[0m directory.

    DIR/clean.pl

  For example, to clean up generated files under [47mbooks/arithmetic[0m, you
  could do the following.

    cd books/arithmetic
    ../clean.pl
    cd - # to return to the ACL2 sources directory, if you wish to do so

  [31;1mRestricting to Specific Directories and Books[0m

  You can specify which books you want certified by using any or all of
  the variables [47mEXCLUDED_PREFIXES[0m, [47mACL2_BOOK_CERTS[0m, or
  [47mACL2_BOOK_DIRS[0m.  First, the set of desired [47m.cert[0m files is
  restricted to those that do not start with any string that is one
  of the words in the value of [47mEXCLUDED_PREFIXES[0m.  Then
  [47mACL2_BOOK_CERTS[0m and [47mACL2_BOOK_DIRS[0m, if supplied, specify which
  books should be certified, as illustrated by the following example.

    make -j 8 regression-fresh \\
     ACL2_BOOK_DIRS=\"symbolic paco\" \\
     ACL2_BOOK_CERTS=\" \\
      workshops/2006/cowles-gamboa-euclid/Euclid/ed6a.cert \\
      workshops/2006/cowles-gamboa-euclid/Euclid/ed4bb.cert \\
      \"

  Then all book in directories [47msymbolic[0m and [47mpaco[0m will be certified, as
  will the books [47mworkshops/2006/cowles-gamboa-euclid/Euclid/ed6a.lisp[0m
  and [47mworkshops/2006/cowles-gamboa-euclid/Euclid/ed4bb.lisp[0m.  Note
  that all pathnames should be relative to your community books
  directory; in particular, they should not be absolute pathnames.
  Also notice the [47m.cert[0m extension used in files supplied for
  [47mACL2_BOOK_CERTS[0m.

  Alternatively, you may wish to invoke [47mbooks/cert.pl[0m while standing in
  a directory under which you want to certify books.  This will
  certify not only those books, but all supporting books --- even
  those not under the current directory --- that do not have
  up-to-date [47m.cert[0m files.  The following is a simple command to
  invoke that will certify all books in the current directory, where
  if the [47mbooks/[0m directory is not on your path, you will need to
  provide a suitable filename, e.g. [47m../../cert.pl[0m or
  [47m~/acl2/books/cert.pl[0m.

    cert.pl -j 4 *.lisp

  Here is a more complex command, which illustrates a way to certify
  books in subdirectories (as well as the current directory), the use
  of provisional certification (see [provisional-certification]), and
  `make'-level parallelism (in this case specifying four parallel
  processes).

    cert.pl --pcert-all -j 4 `find . -name '*.lisp'`

  Note that with this approach, unlike classic ACL2 `make'-based
  certification (see [books-certification-classic], out-of-date [47m.cert[0m
  files that are not under the current directory will also be built.
  For documentation of [47mcert.pl[0m invoke:

    cert.pl -h

  See the top of [47mcert.pl[0m for authorship and copyright information.

  Finally, we give a brief summary of how to use so-called ``classic
  ACL2 `make'-based certification'' for community books; see
  [books-certification-classic] for details.  Note that support for
  this approach might be eliminated in a future ACL2 release.  We
  welcome comments from the ACL2 community about whether or not that
  would be a good thing to do.  See the discussion above about
  [47mACL2_BOOK_DIRS[0m for the ``modern'' way to accomplish the same thing.

  Many community book directories have a [47mMakefile[0m.  If you modify books
  only in such a directory, you can recertify by standing in that
  directory and issuing a `make' command.  This command can
  optionally specify an ACL2 executable as well as parallelism, for
  example as follows, where the first line ([47mmake clean[0m) is optional.

    make clean
    (time nice make -j 8 ACL2=my-acl2)

  [31;1mACL2 Customization Files[0m

  By default, your acl2-customization file (see [ACL2-customization])
  is ignored by all flavors of ``[47mmake regression[0m''.  However, you can
  specify the use of an acl2-customization file by setting the value
  of environment variable [47mACL2_CUSTOMIZATION[0m to the empty string,
  indicating a default such file, or to the desired absolute
  pathname.  For example:

    make regression ACL2_CUSTOMIZATION=''
    make regression ACL2_CUSTOMIZATION='~/acl2-customization.lisp'

  [31;1mRegressions for Variants of ACL2[0m

  The discussion above also pertains to using ACL2(p) (see [parallel])
  or ACL2(r) (see [real]), in which case the default is [47msaved_acl2p[0m
  or [47msaved_acl2r[0m respectively, rather than [47msaved_acl2[0m.  However, we
  recommend that you use ACL2, not ACL2(p), for your regression.
  Then you can use ACL2(p) for your own proof developments.  However,
  if you want to use ACL2(p) or for your regression, see
  [waterfall-parallelism-for-book-certification].

  [31;1mProvisional Certification[0m

  To use provisional certification (see [provisional-certification]),
  supply [47mACL2_PCERT=t[0m with your `make' command.  Here is an example.

    time nice make regression -j 4 ACL2_BOOK_DIRS=deduction ACL2_PCERT=t

  [31;1mMiscellany[0m

  Other control of the certification process may be found by perusing
  community books file [47mbooks/make_cert[0m.  In particular, the [47mINHIBIT[0m
  variable may be set to a call of [47m[set-inhibit-output-lst][0m, for
  example as follows to obtain the output one would get by default in
  an (interactive) ACL2 session.

    time nice make regression -j 4 ACL2_BOOK_DIRS=arithmetic \\
      INHIBIT='(set-inhibit-output-lst proof-tree)'

  [31;1mTroubleshooting[0m

  If you run into problems, you can get help by joining the [47macl2-help[0m
  email list (follow the link from the ACL2 home page) and sending a
  message to that list.  Also consider trying another version of GNU
  `make'; for example, we have found that versions 3.81 and 3.82
  sometimes cause errors on Linux where version 3.80 does not.  Note
  however that Version 3.80 does not print certain informational
  messages that are printed by later versions.")
 (BOOKS-CERTIFICATION-CLASSIC
  (BOOKS-CERTIFICATION)
  "Classic ACL2 `make'-based certification of [books]

  This [documentation] topic explains an approach to certifying
  directories of books, which we call ``classic ACL2 `make'-based
  certification''.

  Warning: The capability described in this section might be replaced
  at any time by a capability based on corresponding support for
  community books (see [books-certification]).  If you think that
  would be a hardship, please contact the ACL2 implementors.

  This topic discusses a way to certify a directory of books other than
  the ACL2 community books.  See [books-certification] for how to
  certify the set of ACL2 community [books].  There is also a section
  in that [documentation] topic, ``Restricting to Specific
  Directories and Books'', that provides an alternative to classic
  ACL2 `make'-based certification (as discussed in the present topic)
  for certifying specified sets of books.

  We assume here a familiarity with Unix/Linux `make'.  We also assume
  that you are using GNU `make' rather than some other flavor of
  `make'.  And finally, we assume, as is typically the case by
  following the standard installation instructions, that you install
  the ACL2 community books in the [47mbooks/[0m subdirectory of your ACL2
  distribution.  We will refer below to that directory as [47mBOOKS[0m.

  In summary: to use `make' to certify [books] under a given directory,
  you may create a simple Makefile in that directory (as explained
  below) so that when you stand in that directory, you can submit the
  command, `make', to certify those books.  If you have a
  multi-processor machine or the like, then you can use the `[47m-j[0m flag
  `make'-level parallelism by specifying the number of concurrent
  processes.  For example:

    make -j 4

  For each book [47mfoo.lisp[0m, a file [47mfoo.out[0m in the same directory as
  [47mfoo.lisp[0m will contain the output from the corresponding
  certification attempt.  If you have previously executed such a
  command, then you might first want to delete [certificate] files
  and other generated files by executing the following command.

    make clean

  Note that when you run `make', then by default, the first error will
  cause the process to stop.  You can use [47mmake -i[0m to force `make' to
  ignore errors, thus continuing past them.  Or, use [47mmake -k[0m to keep
  going, but skipping certification for any book that includes
  another whose certification has failed.

  By default, your acl2-customization file (see [ACL2-customization])
  is ignored by such `make' commands.  However, you can specify the
  use of an acl2-customization file by setting the value of
  environment variable [47mACL2_CUSTOMIZATION[0m to the empty string,
  indicating a default such file, or to the desired absolute
  pathname.  For example:

    make ACL2_CUSTOMIZATION=''
    make ACL2_CUSTOMIZATION='~/acl2-customization.lisp'

  We now discuss how to create makefiles to support `make' commands as
  discussed above.

  First we give five steps for creating a [47mMakefile[0m to support
  certification of a directory of books, without subdirectories.  For
  examples of such Makefiles you can look in community book
  directories (which, however, might disappear in future versions of
  ACL2).

      1. Include the file [47mMakefile-generic[0m from the [47mbooks/[0m subdirectory of
      your ACL2 sources directory, but first perhaps define the
      variable `[47mACL2[0m'.  Consider the following example.

        ACL2 ?= /Users/john_doe/acl2/acl2-sources/saved_acl2
        include /Users/john_doe/acl2/acl2-sources/books/Makefile-generic

      In this example, you can omit the first line, because the default
      ACL2 executable is file [47msaved_acl2[0m in the directory immediately
      above the directory of the specified [47mMakefile-generic[0m file.
      Indeed, that is the common case.  Note the use of [47m?=[0m instead of
      [47m=[0m or [47m:=[0m, so that [47mACL2[0m can instead be defined by the environment
      or provided on the command line as part of the `make' command.

      2. (Optional; usually skipped.)  Set the [47mINHIBIT[0m variable if you want
      to see more than the [summary] output.  For example, if you
      want to see the same output as you would normally see at the
      terminal, put this line in your Makefile after the `[47minclude[0m'
      lines.

        INHIBIT = (assign inhibit-output-lst (list (quote proof-tree)))

      For other values to use for [47mINHIBIT[0m, see [set-inhibit-output-lst] and
      see the original setting of [47mINHIBIT[0m in [47mbooks/Makefile-generic[0m.

      3. Specify the books to be certified.  Normally, every file with
      extension [47m.lisp[0m will be a book that you want to certify, in
      which case you can skip this step.  Otherwise, put a line in
      your [47mMakefile[0m after the ones above that specifies the books to
      be certified.  The following example, from an old version of
      community books file [47mbooks/finite-set-theory/osets/Makefile[0m,
      should make this clear.

        BOOKS = computed-hints fast instance map membership outer primitives \\
                quantify set-order sets sort

      But better yet, use the extension [47m.lsp[0m for any Lisp or ACL2 files
      that are not to be certified, so that the definition of [47mBOOKS[0m
      can be omitted.

      4. Create [47m.acl2[0m files for books that are to be certified in other
      than the initial ACL2 world (see [portcullis]).  For example,
      if you look in community books file
      [47mbooks/arithmetic/equalities.acl2[0m you will see [47m[defpkg][0m forms
      followed by a [47m[certify-book][0m command, because it was determined
      that [47m[defpkg][0m forms were necessary in the certification world
      in order to certify the [47mequalities[0m book.  In general, for each
      [47m<book-name>.lisp[0m whose certification requires a non-initial
      certification world, you will need a corresponding
      [47m<book-name>.acl2[0m file that ends with the appropriate
      [47m[certify-book][0m command.

      You also have the option of creating a file [47mcert.acl2[0m that has a
      special role.  When file [47m<book-name>.lisp[0m is certified, if
      there is no file [47m<book-name>.acl2[0m but there is a file
      [47mcert.acl2[0m, then [47mcert.acl2[0m will be used as [47m<book-name>.acl2[0m
      would have been used, as described in the preceding paragraph,
      except that the appropriate [47m[certify-book][0m command will be
      generated automatically.  Thus, no [47mcertify-book[0m command should
      occur in [47mcert.acl2[0m.

      It is actually allowed to put raw lisp forms in a [47m.acl2[0m file
      (presumably preceded by [47m:q[0m or [47m(value :q)[0m and followed by [47m(lp)[0m).
      But this is not recommended (see [q]); we make no guarantees
      about certification performed any time after raw Lisp has been
      entered in the ACL2 session.

      5. Generally, the next step is to include the following line after
      the `[47minclude[0m' of [47mMakefile-generic[0m (see the first step above).

        -include Makefile-deps

      This will cause `make' to create and then include a file
      [47mMakefile-deps[0m that contains ``dependency'' lines needed by
      `make'.  If those dependencies are somehow flawed, it may be
      because you have [47m[include-book][0m forms that are not truly
      including books, for example in multi-line comments ([47m#|..|#[0m).
      These will be ignored if preceded by a semicolon ([47m;[0m), or if you
      add a line break after ``[47minclude-book[0m.'' But instead of adding
      the `[47m-include[0m' line above, you can create dependency lines
      yourself by running the command

        make dependencies

      and pasting the result into the end of your [47mMakefile[0m, and editing as
      you see fit.

  This concludes the basic instructions for creating a [47mMakefile[0m in a
  directory including books.  Here are some other capabilities
  offered by community books file [47mbooks/Makefile-subdirs[0m.  Not
  included below is a discussion of how to increase parallelism by
  avoiding the need to certify included books before certifying a
  given book; see [provisional-certification].

  [31;1mSubdirectory Support[0m

  There is support for using `make' to certify books in subdirectories.
  Consider the following example.

    DIRS = pass1 bind-free floor-mod
    include ../Makefile-subdirs

  This indicates that we are to run `make' in subdirectories [47mpass1/[0m,
  [47mbind-free/[0m, and [47mfloor-mod/[0m of the current directory.

  You can combine this subdirectory support with the support already
  discussed for certifying books in the top-level directory.  Here is
  an example, which as of this writing is in community books file
  [47mbooks/arithmetic-3/Makefile[0m contains the following lines.

    arith-top: top all
    all: top

    DIRS = pass1 bind-free floor-mod
    include ../Makefile-subdirs
    include ../Makefile-generic

    -include Makefile-deps

  The `[47mtop[0m' target is defined in [47m../Makefile-subdirs[0m to call `make' in
  each subdirectory specified in [47mDIRS[0m.  We have set the default
  target in the example above to a new name, [47marith-top[0m, that makes
  that [47mtop[0m target before making the `[47mall[0m' target which, in turn, is
  the default target in any [47mMakefile-generic[0m, and is responsible for
  certifying books in the current directory as discussed in the five
  steps displayed above.

  Use [47mMakefile-psubdirs[0m instead of [47mMakefile-subdirs[0m if certification of
  a book in a subdirectory never depends on certification of a book
  in a different subdirectory, because then the [47m-j[0m option of `make'
  can allow subdirectories to be processed in parallel.

  [31;1mCleaning Up[0m

  We note that there is a [47mclean[0m target.  Thus,

    make clean

  will remove generated files including [47m.cert[0m, [47m.out[0m files, and compiled
  files.

  [31;1mSystem Books[0m

  An environment variable [47mACL2_SYSTEM_BOOKS[0m is generally set
  automatically, so you can probably skip reading the following
  paragraph unless your attempt to certify books fails to locate
  those books properly.

  The environment variable [47mACL2_SYSTEM_BOOKS[0m can be set to the
  top-level directory of the ACL2 community books.  A Unix-style
  pathname, typically ending in [47mbooks/[0m or [47mbooks[0m, is permissible.  In
  most cases, your ACL2 executable is a small script in which you can
  set this environment variable just above the line on which the
  actual ACL2 image is invoked, for example:

    export ACL2_SYSTEM_BOOKS
    ACL2_SYSTEM_BOOKS=/home/acl2/v3-2/acl2-sources/books

  However, you can also set [47mACL2_SYSTEM_BOOKS[0m as a `make' variable, by
  setting it in your [47mMakefile[0m before the first target definition,
  e.g.:

    ACL2_SYSTEM_BOOKS ?= /home/acl2/v3-2/acl2-sources/books

  [31;1mCompilation Support[0m

  The file [47mbooks/Makefile-generic[0m provides support for compiling books
  that are already certified (but see [compilation] for an
  exception).  For example, suppose that you have certified books
  using GCL as the host Lisp, resulting in compiled files with the [47m.o[0m
  extension.  Now suppose you would like to compile the books for
  Allegro Common Lisp, whose compiled files have the [47m.fasl[0m extension.
  The following command will work if you have included
  [47mbooks/Makefile-generic[0m in your [47mMakefile[0m.

    make fasl

  In general, the compiled file extension for a Lisp supported by ACL2
  will be a target name for building compiled files for all your
  books (after certifying the books, if not already up-to-date on
  certification).

  If you run into problems, you can get help by joining the [47macl2-help[0m
  email list (follow the link from the ACL2 home page) and sending a
  message to that list.  Also consider trying another version of GNU
  `make'; for example, we have found that versions 3.81 and 3.82
  sometimes cause errors on Linux where version 3.80 does not.")
 (BOOKS-REFERENCE
  (BOOKS)
  "Reference guide for ACL2 functionality related to books, e.g.,
  [include-book], [certify-book], [cbd], etc.


Subtopics

  [Add-include-book-dir]
      Link keyword for [47m:dir[0m argument of [47m[ld][0m and [47m[include-book][0m

  [Add-include-book-dir!]
      Non-[47m[local][0mly link keyword for [47m:dir[0m argument of [47m[ld][0m and
      [47m[include-book][0m

  [Book-compiled-file]
      Creating and loading of compiled and expansion files for [books]

  [Cbd]
      Connected book directory string

  [Certify-book]
      How to produce a [certificate] for a book

  [Certify-book-debug]
      Some possible ways to work around [47m[certify-book][0m failures

  [Delete-include-book-dir]
      Unlink keyword for [47m:dir[0m argument of [47m[ld][0m and [47m[include-book][0m

  [Delete-include-book-dir!]
      Non-[47m[local][0mly unlink keyword for [47m:dir[0m argument of [47m[ld][0m and
      [47m[include-book][0m

  [Full-book-name]
      Book naming conventions assumed by ACL2

  [Include-book]
      Load the [events] in a file

  [Pathname]
      Introduction to filename conventions in ACL2

  [Set-cbd]
      To set the connected book directory

  [Set-write-ACL2x]
      Cause [47m[certify-book][0m to write out a [47m.acl2x[0m file

  [With-cbd]
      To bind the connected book directory

  [With-current-package]
      To bind the [current-package]")
 (BOOKS-TOUR
  (BOOKS)
  "The [3mguided tour[0m of concepts related to ACL2 [books].

  The tour begins with [book-example].


Subtopics

  [Book-contents]
      Restrictions on the forms inside [books]

  [Book-example]
      How to create, certify, and use a simple book

  [Book-name]
      Conventions associated with book-names

  [Certificate]
      A file specifying validity of a given book

  [Certify-book]
      How to produce a [certificate] for a book

  [Include-book]
      Load the [events] in a file

  [Keep]
      How we know if [47m[include-book][0m read the correct files

  [Portcullis]
      The gate guarding the entrance to a certified book")
 (BOOLE$
  (NUMBERS ACL2-BUILT-INS)
  "Perform a bit-wise logical operation on 2 two's complement integers

  When integers [47mx[0m and [47my[0m are viewed in their two's complement
  representation, [47m(boole$ op x y)[0m returns the result of applying the
  bit-wise logical operation specified by [47mop[0m.  The following table is
  adapted from documentation for the analogous Common Lisp function
  {boole |
  http://www.lispworks.com/documentation/HyperSpec/Body/f_boole.htm}
  in the {Common Lisp Hyperspec |
  http://www.lispworks.com/documentation/HyperSpec/}.  Note that the
  values of [47mop[0m for [47mboole$[0m are ACL2 constants, rather than
  corresponding values of [47mop[0m for the Common Lisp function [47mboole[0m.

    op               result
    -----------      ---------
    *boole-1*        x
    *boole-2*        y
    *boole-andc1*    and complement of x with y
    *boole-andc2*    and x with complement of y
    *boole-and*      and
    *boole-c1*       complement of x
    *boole-c2*       complement of y
    *boole-clr*      the constant 0 (all zero bits)
    *boole-eqv*      equivalence (exclusive nor)
    *boole-ior*      inclusive or
    *boole-nand*     not-and
    *boole-nor*      not-or
    *boole-orc1*     or complement of x with y
    *boole-orc2*     or x with complement of y
    *boole-set*      the constant -1 (all one bits)
    *boole-xor*      exclusive or

  The guard of [47mboole$[0m specifies that [47mop[0m is the value of one of the
  constants above and that [47mx[0m and [47my[0m are integers.

  See any Common Lisp documentation for analogous information about
  Common Lisp function [47mboole[0m.

  [31;1mFunction: [0m<boole$>

    (defun boole$ (op i1 i2)
      (declare (type (integer 0 15) op)
               (type integer i1 i2))
      (cond ((eql op *boole-1*) i1)
            ((eql op *boole-2*) i2)
            ((eql op *boole-and*) (logand i1 i2))
            ((eql op *boole-andc1*)
             (logandc1 i1 i2))
            ((eql op *boole-andc2*)
             (logandc2 i1 i2))
            ((eql op *boole-c1*) (lognot i1))
            ((eql op *boole-c2*) (lognot i2))
            ((eql op *boole-clr*) 0)
            ((eql op *boole-eqv*) (logeqv i1 i2))
            ((eql op *boole-ior*) (logior i1 i2))
            ((eql op *boole-nand*) (lognand i1 i2))
            ((eql op *boole-nor*) (lognor i1 i2))
            ((eql op *boole-orc1*) (logorc1 i1 i2))
            ((eql op *boole-orc2*) (logorc2 i1 i2))
            ((eql op *boole-set*) 1)
            ((eql op *boole-xor*) (logxor i1 i2))
            (t 0)))")
 (BOOLEAN-LISTP
  (BOOLEANP LISTS ACL2-BUILT-INS)
  "Recognizer for a true list of booleans

  The predicate [47mboolean-listp[0m tests whether its argument is a
  [47m[true-listp][0m of objects each or which satisfies [47m[booleanp][0m, i.e.,
  is [47mt[0m or [47mnil[0m.

  [31;1mFunction: [0m<boolean-listp>

    (defun boolean-listp (lst)
      (declare (xargs :guard t))
      (cond ((atom lst) (eq lst nil))
            (t (and (or (eq (car lst) t) (eq (car lst) nil))
                    (boolean-listp (cdr lst))))))")
 (BOOLEANP
  (BASICS ACL2-BUILT-INS)
  "Recognizer for booleans

  [47m(Booleanp x)[0m is [47mt[0m if [47mx[0m is [47mt[0m or [47mnil[0m, and is [47mnil[0m otherwise.

  See [generalized-booleans] for a discussion of a potential soundness
  problem for ACL2 related to the question: Which Common Lisp
  functions are known to return Boolean values?

  [31;1mFunction: [0m<booleanp>

    (defun booleanp (x)
      (declare (xargs :guard t))
      (if (eq x t) t (eq x nil)))


Subtopics

  [Boolean-listp]
      Recognizer for a true list of booleans")
 (BOUNDERS
  (TAU-SYSTEM)
  "Intervals, bounder functions, and bounder correctness

    [3mBounder Forms 1 and 2[0m:
    (implies (and (tau-intervalp i1)
                  ...
                  (or (equal (tau-interval-dom i1) 'dom1-1)
                      ...)
                  ...
                  (in-tau-intervalp x1 i1)
                  ...)
             (and (tau-intervalp (bounder-fn i1 ...))
                  (in-tau-intervalp [3mtarget[0m
                                    (bounder-fn i1 ...))))

  where [3mtarget[0m is either [47m(fn x1 ... y1 ...)[0m or [47m(mv-nth 'n (fn x1 ... y1
  ...))[0m, depending on whether we are in the [3mForm 1[0m or [3mForm 2[0m case,
  respectively.  However, the shape above is meant just as a
  reminder.  Details are given below.

  This topic first explains the basic shape of [3mBounder Form 1[0m.  Then it
  illustrates [3mBounder Form 2[0m.  Finally, it deals briefly with proving
  bounder correctness theorems.  The community book
  [47mtau-bounders/elementary-bounders[0m contains bounders for various
  elementary functions including [47m[+][0m, [47m[*][0m, [47m[/][0m, [47m[floor][0m, [47m[mod][0m,
  [47m[logand][0m, [47m[lognot][0m, [47m[logior][0m, [47m[logorc1][0m, [47m[logeqv][0m, [47m[logxor][0m, and
  [47m[ash][0m.  You might look at or include this book to see more example
  theorems, to see how proofs of such theorems are managed, and to
  experiment with their effects on proving theorems involving
  arithmetic over finite or half-finite intervals.

  A bounder correctness theorem establishes that [47mbounder-fn[0m is a
  ``bounder'' for the function [47mfn[0m.  That means that when trying to
  compute a tau for a call of [47mfn[0m (or, in the case of [3mForm 2[0m, for the
  [47mn[0mth component of the multiple-value vector returned by a call of
  [47mfn[0m) the tau system can call [47mbounder-fn[0m on the intervals containing
  certain arguments of [47mfn[0m.

  Let us start with an example.  Let [47mfn[0m be the addition function, [47m+[0m
  (actually, [47m[binary-+][0m).  Consider the target term [47m(+ x y)[0m and
  contemplate the question: if you know intervals containing [47mx[0m and [47my[0m,
  say [47mintx[0m and [47minty[0m respectively, what is an interval containing
  their sum?  The answer is pretty easy to state in English: the
  domain of the answer interval is the less restrictive of the
  domains of [47mintx[0m and [47minty[0m.  The lower bound of the answer interval
  is the sum of the lower bounds of [47mintx[0m and [47minty[0m, and the lower
  relation is the stronger of the lower relations of [47mintx[0m and [47minty[0m.
  Analogous comments define the upper bound and relation of the
  answer interval.  So for example, if [47mx[0m is an [47mINTEGERP[0m such that [47m0
  <= x <= 10[0m and [47my[0m is a [47mRATIONALP[0m such that [47m0 < y <= 20[0m, then [47m(+ x y)[0m
  is a [47mRATIONALP[0m such that [47m0 < (+ x y) <= 30[0m.

  Defining this precisely is more tedious than describing it in English
  because one must make precise the notions of ``less restrictive''
  domains, ``weaker'' relations, and the possibility that either or
  both of the bounds could be ``infinite.'' But we can easily imagine
  defining the function [47mbounder-for-+[0m that returns the answer
  interval described, given [47mintx[0m and [47minty[0m.

  Then the following [3mBounder Form 1[0m formula establishes the correctness
  of [47mbounder-for-+[0m and allows the tau system to use it to produce
  bounds in the tau computed for [47m+[0m-expressions:

    (implies (and (tau-intervalp intx)
                  (tau-intervalp inty)
                  (in-tau-intervalp x intx)
                  (in-tau-intervalp y inty))
             (and (tau-intervalp (bounder-for-+ intx inty))
                  (in-tau-intervalp (+ x y)
                                    (bounder-for-+ intx inty))))

  For example, suppose we have a formula with the following hypotheses

    (and (integerp a)
         (<= 0 a)
         (<= a 10)
         (rationalp b)
         (< 0 b)
         (<= b 20))

  and suppose the tau system encounters the term [47m(+ a b)[0m.  When the
  term is encountered, the tau for [47ma[0m would include an [47mINTEGERP[0m
  interval such that [47m0 <= a <= 10[0m and the tau for [47mb[0m would include a
  [47mRATIONALP[0m interval such that [47m0 < b <= 20[0m.  In its most primitive
  configuration, the tau system would only know that the tau for [47m(+ a
  b)[0m includes the recognizer [47mRATIONALP[0m (and all that it is known to
  imply).  But after the bounder theorem above is proved and
  available as a [47m:tau-system[0m rule the tau system would infer that [47m(+
  a b)[0m was in the [47mRATIONALP[0m interval such that [47m0 < (+ a b) <= 30[0m.

  Thus, by defining bounder functions and proving them correct the user
  can give the tau system the ability to compute the bounds on
  function calls as a function of the known bounds on their actuals.

  It is sometimes useful to restrict the domains of the intervals to be
  considered.  For example, in bounding [47m*[0m-expressions it is
  simplifying to restrict one's attention to intervals over the
  integers or rationals (and thus exclude the complex rationals so
  one need not think about the getting negative bounds by multiplying
  two ``positive'' complex rationals or how to ``round up'' from
  complex bounds to the rationals required by our intervals).

  If we were to define [47mbounder-for-*[0m so that it works correctly to
  bound [47m*[0m-expressions, but only for integer or rational arguments,
  its correctness theorem would be:

    (implies (and (tau-intervalp intx)                             ; (a)
                  (tau-intervalp inty)
                  (or (equal (tau-interval-dom intx) 'INTEGERP)    ; (b)
                      (equal (tau-interval-dom intx) 'RATIONALP))
                  (or (equal (tau-interval-dom inty) 'INTEGERP)
                      (equal (tau-interval-dom inty) 'RATIONALP))
                  (in-tau-intervalp x intx)                        ; (c)
                  (in-tau-intervalp y inty))
             (and (tau-intervalp (bounder-for-* intx inty))       ; (d)
                  (in-tau-intervalp (* x y)                        ; (e)
                                    (bounder-for-* intx inty))))

  In this case, [47mbounder-for-*[0m would be applied to the intervals for [47mx[0m
  and [47my[0m only if those intervals were over the integers or the
  rationals.

  The above theorem for [47mbounder-for-*[0m begins to suggest the general
  form of a bounder theorem and we will use it to explain the general
  form.

  The hypotheses of a bounder theorem must be a conjunction and the
  conjuncts must be partitionable into three parts, (a), (b), and
  (c).  The conclusion, must be a conjunction, must contain at least
  two conjuncts, (d) and (e), and is allowed to contain others that
  are simply ignored for purposes of bounders.  (See the note below
  about why we allow but ignore additional conjuncts in the
  conclusion.)

  Part (a) introduces some distinct ``interval variables,'' here called
  ``ivars,'' that are known to denote intervals; for the example
  above, the ivars are [47mintx[0m and [47minty[0m.  Each hypothesis in part (a) is
  of the form [47m(TAU-INTERVALP ivar)[0m.

  Part (b) allows us to restrict the domains of some of the intervals.
  Each hypothesis in part (b) must be a disjunction and each of the
  disjuncts must be of the form [47m(EQUAL (TAU-INTERVAL-DOM ivar) 'dom)[0m,
  where [47mivar[0m is one of the interval variables and [47mdom[0m is one of
  [47mINTEGERP[0m, [47mRATIONALP[0m, [47mACL2-NUMBERP[0m, or [47mNIL[0m.  It is not necessary to
  restrict every interval variable.  Indeed, part (b) may be empty,
  as in the theorem for [47mbounder-for-+[0m above.

  Part (c) consists of a set of [47m(IN-TAU-INTERVALP avar ivar)[0m hypotheses
  where each [47mavar[0m is a variable and no two hypotheses in part (c) use
  the same [47mavar[0m or [47mivar[0m.  We call the set of all such [47mavar[0m the
  ``actual variables'' or ``avars.'' The avars and ivars must be
  distinct.  Part (c) sets up a correspondence between the avars and
  the ivars, each avar is in an interval denoted by one ivar.

  Part (d) introduces the name of the bounder function, here
  [47mbounder-for-*[0m, and the order of its ivar arguments.  We see that
  [47mbounder-for-*[0m takes two arguments and they correspond, in order, to
  the intervals containing [47mx[0m and [47my[0m.  Part (d) also establishes that
  the bounder function always returns an interval under hypotheses
  (a), (b), and (c).  Note that it is sometimes useful to return the
  ``universal interval'' (one that contains everything) if you don't
  want to compute a better interval for some case; see
  [47m[tau-intervalp][0m or [47m[in-tau-intervalp][0m.

  Part (e) introduces the name of the function being bounded, here [47m*[0m,
  and the order of its arguments.  It establishes that the function
  being bounded really is bounded by the interval computed by the
  bounder function.  In general, the function being bounded may take
  additional arguments.  It is possible that the function being
  bounded takes some arguments that do not affect the bounds of its
  output.

  Thus, parts (c) and (e) together establish a mapping between the
  actuals of a call of the function being bounded and the intervals
  to be supplied to the bounder.

  The parts identified above may be presented in any order and the
  literals constituting those parts may be mingled.  Thus, for
  example, here is another version of the theorem above that
  generates the same bounding information for the tau system.  In
  this version, the hypotheses and conclusions are rearranged,
  [47mbounder-for-*[0m takes its arguments in the opposite order, and the
  theorem includes an additional conclusion.

    (implies (and (tau-intervalp intx)                             ; (a)
                  (or (equal (tau-interval-dom intx) 'INTEGERP)    ; (b)
                      (equal (tau-interval-dom intx) 'RATIONALP))
                  (in-tau-intervalp x intx)                        ; (c)

                  (tau-intervalp inty)                             ; (a)
                  (or (equal (tau-interval-dom inty) 'INTEGERP)    ; (b)
                      (equal (tau-interval-dom inty) 'RATIONALP))
                  (in-tau-intervalp y inty))
             (and (in-tau-intervalp (* x y)                        ; (e)
                                    (bounder-for-* inty intx))
                  (tau-intervalp (bounder-for-* inty intx))        ; (d)))

                  (or (equal (tau-interval-dom (bounder-for-* inty intx))
                             'INTEGERP)
                      (equal (tau-interval-dom (bounder-for-* inty intx))
                             'RATIONALP))

  [3mNote on why bounder forms allow additional conjuncts in the
  conclusion[0m: It is often the case that one creates bounders by
  composing other bounders.  To prove compositional bounds correct
  one must often prove more than the mere correctness of the
  components.  For example, one might need to prove that the domain
  of the new bounding interval is [47mINTEGERP[0m or otherwise restricted.
  We allow such ``unnecessary'' conclusions simply to save the user
  the burden of stating multiple theorems.

  [3mAn Illustration of Bounder Form 2[0m: Suppose [47m(quad i)[0m is defined so
  that truncates the integer [47mi[0m to the largest multiple of 4 weakly
  below [47mi[0m and, additionally, returns the remainder.  For example,
  [47m(quad 26)[0m returns [47m(mv 24 2)[0m.  Then here are bounders for each of
  its return values:

    (defun quad-bounds-0 (i)
      (cond ((and (tau-interval-lo i)
                  (<= 0 (tau-interval-lo i)))
             (make-tau-interval 'integerp nil 0 nil (tau-interval-hi i)))
            (t (make-tau-interval nil nil nil nil nil))))

    (defun quad-bounds-1 (i)
      (cond ((and (tau-interval-lo i)
                  (<= 0 (tau-interval-lo i)))
             (make-tau-interval 'integerp nil 0 nil 3))
            (t (make-tau-interval nil nil nil nil nil))))

  Note that the bounders assume [47mi[0m is an [47mINTEGERP[0m and return the
  universal interval when [47mi[0m is not a natural.

  As noted in the discussion below about how to prove bounder
  correctness theorems, proving these bounders correct will require
  an arithmetic book, e.g.,

    (include-book \"arithmetic-5/top\" :dir :system)

  Here then are two bounder correctness theorems of [3mForm 2[0m:

    (defthm quad-bounds-0-correct
      (implies (and (tau-intervalp i)
                    (equal (tau-interval-dom i) 'INTEGERP)
                    (in-tau-intervalp x i))
               (and (tau-intervalp (quad-bounds-0 i))
                    (in-tau-intervalp (mv-nth 0 (quad x))
                                      (quad-bounds-0 i))))
      :rule-classes :tau-system)

    (defthm quad-bounds-1-correct
      (implies (and (tau-intervalp i)
                    (equal (tau-interval-dom i) 'INTEGERP)
                    (in-tau-intervalp x i))
               (and (tau-intervalp (quad-bounds-1 i))
                    (in-tau-intervalp (mv-nth 1 (quad x)) (quad-bounds-1 i))))
      :rule-classes :tau-system)

  As noted above, if these bounders are to be used in constructing
  other bounders, we might include (in the first theorem) an
  additional concluding conjunct, such as

    (equal (tau-interval-dom (quad-bounds-0 i)) 'INTEGERP)

  so that we can keep [47mquad-bounds-0[0m disabled to allow us to use
  [47mquad-bounds-0-correct[0m as a [47m:rewrite[0m or other rule and still relieve
  hypotheses about the domain of the interval it produces.  These
  hypotheses would arise if some other verified bounder was called on
  the produced interval.  In addition, as noted below, we might
  replace the [47m:rule-classes[0m above with

    :rule-classes
     ((:rewrite)
      (:forward-chaining :trigger-terms ((quad-bounds-0 i))))

  Since the theorem is being stored as some kind of rule and since it
  satisfies the [3mBounder Form 2[0m shape, it will additionally be stored
  as a [47m:tau-system[0m rule.

  [3mNote on proving bounder theorems[0m: Proving bounder theorems is just
  like proving any other arithmetic theorem and you will need
  whatever libraries are appropriate for the problem domain you are
  working in.  Do not expect the tau system to be of much use in
  proving bounder theorems.  A typical bounder theorem might require
  you to prove a subgoal like [47m(< (fn x y) (g (tau-interval-hi int1)
  int2))[0m.  But tau deals with inequalities relating terms to
  constants, e.g., [47m(< ... 16)[0m.  A bounder theorem is a sort of
  ``metatheorem'' about [3mhow to construct[0m bounded intervals from other
  bounded intervals.  So when you undertake to define a bounder and
  prove it correct, go into the project with your eyes open!

  But bounder functions can be broadly divided into two classes, those
  defined in terms of arithmetic on the interval bounds and those
  defined in terms of other bounders.  For example, given that

    (LOGXOR x y) = (LOGNOT (LOGEQV x y))

  an interval for bounding [47mLOGXOR[0m can be constructed by composing the
  constructions of intervals for [47mLOGEQV[0m and [47mLOGNOT[0m.  So some bounder
  correctness proofs will involve direct manipulation of arithmetic
  inequalities and others might involve appeal to the correctness of
  other bounders, depending on how the new bounder is defined.

  Regardless of which style of bounder we are dealing with, we have
  found it useful to prove the basic theorems relating the tau
  interval accessors to [47m[make-tau-interval][0m, e.g.,

    (equal (tau-interval-dom (make-tau-interval dom lo-rel lo hi-rel hi)) dom)

  and then disable those functions to avoid seeing excessive [47mcar[0ms and
  [47mcdr[0ms.

  When dealing with bounders defined in the direct, arithmetic style,
  we tend to keep [47m[tau-intervalp][0m and [47m[in-tau-intervalp][0m enabled so
  they unfold and expose the algebra.

  When dealing with bounders defined compositionally in terms of other
  verified bounders, we tend to keep [47m[tau-intervalp][0m and
  [47m[in-tau-intervalp][0m disabled so we can rely on the previously proved
  bounder theorems as rewrite and forward chaining rules.

  Note that this last remark means that when you prove bounder
  correctness theorems you should include corollaries that are useful
  [47m:rewrite[0m and possibly [47m:forward-chaining[0m rules if you anticipate
  using that bounder in more complex ones.  We tend to trigger the
  forward chaining with the bounder expression itself, rather than
  one of the hypotheses.  For example in the rule above for
  [47mbounder-for-*[0m we would include [47m(:forward-chaining :trigger-terms
  ((tau-bounder-expt2 int2)))[0m and let the [47min-tau-intervalp[0m hypotheses
  select the free variables [47mx[0m and [47my[0m.")
 (BREAK$
  (ERRORS ACL2-BUILT-INS)
  "Cause an immediate Lisp break

  ACL2 users are generally advised to avoid breaking into raw Lisp.
  Advanced users may, on occasion, see the need to do so.  Evaluating
  [47m(break$)[0m will have that effect.  (Exception: [47mbreak$[0m is disabled
  after evaluation of [47m(set-debugger-enable :never)[0m; see
  [set-debugger-enable].)  [47mBreak$[0m returns [47mnil[0m.  Note that upon
  returning to the ACL2 read-eval-print loop (for example, using [47m:q[0m
  if the host Lisp is CCL), one will be at the top level even if one
  had been inside a recursive call of [47m[ld][0m or a [wormhole].

  [31;1mFunction: [0m<break$>

    (defun break$ nil
      (declare (xargs :guard t))
      nil)")
 (BREAK-LEMMA
  (BREAK-REWRITE)
  "A quick introduction to breaking rewrite rules in ACL2

    Example:
    :brr t                          ; if you haven't done that yet
    :monitor (:rewrite lemma12) t   ; to install a break point on the
                                    ;   rule named (:rewrite lemma12)
    :monitor! (:rewrite lemma12) t  ; quiet version of :monitor that
                                    ;   invokes :brr t

  ACL2 does not support Nqthm's [47mbreak-lemma[0m but supports a very similar
  and more powerful break facility.  Suppose some proof is failing;
  apparently some particular rule is not being used and you wish to
  learn why.  Then you need the ACL2 [break-rewrite] facility.  See
  [break-rewrite] and all of its associated [47m:[0m[47m[doc][0m topics for
  details.  The following basic steps are required.

  (1) To enable the ``break rewrite'' feature, you must first execute

    ACL2 !>:brr t

  at the top-level of ACL2.  Equivalently, evaluate [47m(brr t)[0m.
  [Break-rewrite] stays enabled until you disable it with [47m(brr nil)[0m.
  When [break-rewrite] is enabled the ACL2 rewriter will run slower
  than normal but you will be able to [monitor] the attempts to apply
  specified rules.

  (2) Decide what [rune]s (see [rune]) you wish to [monitor].  For
  example, you might want to know why [47m(:rewrite lemma12 . 2)[0m is not
  being used in the attempted proof.  That, by the way, is the name
  of the second rewrite rule generated from the event named [47mlemma12[0m.

  The command

    ACL2 !>:monitor (:rewrite lemma12 . 2) t

  will install an ``unconditional'' break point on that rule.  The
  ``[47mt[0m'' at the end of the command means it is unconditional, i.e., a
  break will occur every time the rule is tried.  ACL2 supports
  conditional breaks also, in which case the [47mt[0m is replaced by an
  expression that evaluates to non-[47mnil[0m when you wish for a break to
  occur.  See [monitor].  The above keyword command is, of course,
  equivalent to

    ACL2 !>(monitor '(:rewrite lemma12 . 2) t)

  which you may also type.  You may install breaks on as many rules as
  you wish.  You must use [47m[monitor][0m on each rule.  You may also
  change the break condition on a rule with [47m[monitor][0m.  Use
  [47m[unmonitor][0m (see [unmonitor]) to remove a rule from the list of
  [monitor]ed rules.

  (3) Then try the proof again.  When a [monitor]ed rule is tried by
  the rewriter you will enter an interactive break, called
  [break-rewrite].  See [break-rewrite] for a detailed description.
  Very simply, [break-rewrite] lets you inspect the context of the
  attempted application both before and after the attempt.  When
  [break-rewrite] is entered it will print out the ``target'' term
  being rewritten.  If you type [47m:go[0m [break-rewrite] will try the rule
  and then exit, telling you (a) whether the rule was applied, (b) if
  so, how the target was rewritten, and (c) if not, why the rule
  failed.  There are many other commands.  See [brr-commands].

  (4) When you have finished using the [break-rewrite] feature you
  should disable it to speed up the rewriter.  You can disable it
  with

    ACL2 !>:brr nil

  The list of [monitor]ed rules and their break conditions persists but
  is ignored.  If you enable [break-rewrite] later, the list of
  [monitor]ed rules will be displayed and will be used again by
  rewrite.

  You should disable the [break-rewrite] feature whenever you are not
  intending to use it, even if the list of [monitor]ed rules is
  empty, because the rewriter is slowed down as long as
  [break-rewrite] is enabled.

  If you get a stack overflow, see [cw-gstack].")
 (BREAK-ON-ERROR
  (TRACE ACL2-BUILT-INS)
  "Break when encountering a hard or soft error caused by ACL2

    General forms:
    (break-on-error t)    ; installs a trace causing a continuable error (break)
                          ;   when an error is invoked by ACL2.
    (break-on-error)      ; same as above
    (break-on-error :all) ; same as above, but even when inside the prover
    (break-on-error nil)  ; uninstall any above trace

  Evaluation of [47m(break-on-error :all)[0m generates a suitable [trace] of
  error functions, so that the Lisp debugger is entered whenever ACL2
  calls them.  You can then continue the interrupted computation by
  suitable exit from the debugger (with a command that depends on the
  host Lisp).  Evaluation of [47m(Break-on-error t)[0m, or equivalently,
  [47m(break-on-error)[0m, is similar except that certain errors are ignored
  when inside the theorem prover; this is probably preferable, in
  general, to [47m(break-on-error :all)[0m.  Finally, evaluation of
  [47m(break-on-error nil)[0m removes those traces.

  [31;1mRemarks[0m.

    * The argument, if supplied, is evaluated and must evaluate to [47mt[0m, [47mnil[0m,
      or [47m:all[0m.

    * For technical reasons, you may see breaks or error messages more than
      once.

    * It is an error to call [47mbreak-on-error[0m while in [raw-mode].

    * [47mBreak-on-error[0m is implemented using ACL2 [47m[trace!][0m, which is a version
      of [47m[trace$][0m that uses a [ttag] and hence generates a ``[47mTTAG
      NOTE[0m'' message.  You can use [47m:[0m[47m[trans1][0m to see the [47mtrace![0m call
      generated by a given call of [47mbreak-on-error[0m.  Evaluate [47m(trace$)[0m
      if you want to see the current trace specs.

  You are of course welcome to define your own version of
  [47mbreak-on-error[0m by modifying a copy of the source definition (search
  for ``[47m(defmacro break-on-error)[0m'' in ACL2 source file
  [47mother-events.lisp[0m).  Please feel free to send your version of
  [47mbreak-on-error[0m to the ACL2 implementors, to consider for inclusion
  into ACL2.

  Also see [set-debugger-enable] for how to get raw-Lisp backtrace
  information when an error occurs as a result of [47mbreak-on-error[0m, or
  even of a raw Lisp error, by calling [47mset-debugger-enable[0m with
  argument [47m:bt[0m, [47m:bt-break[0m, or [47m:break-bt[0m.  Note that for ACL2 errors
  (as opposed to raw Lisp errors), i.e. errors affected by
  [47mbreak-on-error[0m, all three of those keyword values are treated
  equivalently (and, all are ignored for non-ANSI GCL; see
  [set-debugger-enable]).")
 (BREAK-REWRITE
  (DEBUGGING)
  "A version of the ACL2 rewriter with interactive breaks

  ACL2 allows the user to [monitor] the application of [rewrite],
  [definition], and [linear] rules.  When the rewriter is about to
  try to apply an [47m[enable][0md [monitor]ed rule, it can trigger an
  interactive break managed by a version of the rewriter called
  ``break-rewrite''.  These breaks can be caused by

    * failure of a rewrite rule's equivalence relation to be a known
      refinement of the permitted relations,

    * failure of a rule's triggering pattern to match the target term while
      ``almost'' matching,

    * failure to relieve the hypotheses of the rule, or

    * failure of any of several heuristic checks to prevent looping in the
      rewriter.

  From within this read-eval-print loop you can inspect the context,
  attempt to apply the rule, and see what happens.  This interactive
  loop is technically just a call of the standard ACL2
  read-eval-print loop, [47m[ld][0m, on a ``[wormhole] [state]'' (see
  [wormhole]).  While in break-rewrite, certain keyword commands are
  available for accessing information about the context in which the
  lemma is being tried.  These keywords are called break-rewrite
  ``commands''; see [brr-commands].  Interactive breaks occur only if
  the [47mbreak-rewrite[0m utility is turned on (see [47m[brr][0m), a monitored
  rune is being considered by the rewriter, and the break conditions
  specified in the monitor are satisfied (see [47m[monitor][0m).

  The following utilities can also be helpful for proof [debugging].

    * [47m[Dmr][0m (Dynamically Monitor Rewrites) allows you to watch progress of
      the rewriter in real time.

    * The [proof-builder] allows you to interactively construct a proof.

    * [47m[with-brr-data][0m helps you to find the source of a term in prover
      output.

  To abort from inside break-rewrite at any time, execute [47m:[0m[47m[a!][0m.

  Output from break-rewrite is abbreviated by default, but that can be
  changed.  See [set-brr-evisc-tuple].

  When the break-rewrite facility is turned on (see [47m[brr][0m), the
  rewriter performs more sluggishly than when break-rewrite is turned
  off.  Therefore if you have done [47m(brr t)[0m to debug a rewriting
  problem, we recommend that you do [47m(brr nil)[0m after the situation is
  remedied and you resume normal proof development.

  For further information, see the related [47m:[0m[47m[doc][0m topics listed below.

  [3mAdvice to Developers and Maintainers of ACL2[0m: If you intend to modify
  break-rewrite, we strongly urge you to read the Essay on
  Break-Rewrite in the source code file [47mrewrite.lisp[0m.  There we
  explain the abstraction provided by break-rewrite, how it is
  implemented as a state machine operating in a wormhole, and some
  low-level tools for inspecting the state of break-rewrite.
  Attempts to add new features without understanding virtually
  everything about the implementation is most likely to create a
  mess.

  It is possible to cause the ACL2 rewriter to [monitor] the attempted
  application of selected rules.  When such a rule is about to be
  tried, the rewriter evaluates its break condition and if the result
  is non-[47mnil[0m, an interactive read-eval-print loop is entered.

  Break-rewrite permits the user to inspect the current [state] by
  evaluating break-rewrite commands.  Type [47m:help[0m in break-rewrite to
  see what the break-rewrite commands are.  However, break-rewrite is
  actually just a call of the general ACL2 read-eval-print loop,
  [47m[ld][0m, on a certain [state] and the break-rewrite commands are
  simply aliases provided by [47mld-keyword-aliases[0m [table] (see
  [ld-keyword-aliases]).  See [ld] for details about this
  read-eval-print loop.  Thus, with a few exceptions, anything you
  can do at the ACL2 top-level can be done within break-rewrite.  For
  example, you can evaluate arbitrary expressions, use the keyword
  command hack, access [documentation], print [events], and even
  define functions and prove theorems.  However, the ``certain
  [state]'' upon which [47m[ld][0m was called is a ``wormhole state'' (see
  [wormhole]) because break-rewrite is not allowed to have any effect
  upon the behavior of rewrite.  What this means, at a high level, is
  that break-rewrite operates on a copy of the [state] being used by
  rewrite and when break-rewrite exits the [wormhole] closes and the
  [state] ``produced'' by break-rewrite disappears.  For example, all
  invocations of [47m[trace$][0m and [47m[untrace$][0m that are made during such a
  break are undone when proceeding from that break (including when
  proceeding via the [47m:eval[0m brr-command).  Thus, break-rewrite lets
  you query the state of the rewriter and even do experiments
  involving proofs, etc., but these experiments have no effect on the
  ongoing proof attempt.

  There are however exceptions to this loss of state when exiting a
  break.  One exception pertains to iprinting (see [set-iprint]).
  When iprinting is enabled in a break, it nevertheless is again
  disabled upon exiting the break.  However, the association of
  values with iprint indices persists even after exiting the break;
  that is, you can still obtain their values, and if you re-enable
  iprinting then indices will be generated from where they left off
  rather than returning to index 1.  The other exception pertains to
  setting the [47m[brr-evisc-tuple][0m while inside break-rewrite: the
  effects persist.  See [47m[set-brr-evisc-tuple][0m.

  When you enter break-rewrite a simple herald is printed such as:

    (3 Breaking (:rewrite lemma12) on (delta a (+ 1 j)):

  The integer after the open parenthesis indicates the depth of nested
  break-rewrite calls.  In this discussion we use [47m3[0m consistently for
  this integer.  Unless you abort or somehow enter unbalanced
  parentheses into the script, the entire session at a given depth
  will be enclosed in balanced parentheses, making it easy to skip
  over them in Emacs.

  You then will see the break-rewrite [prompt]:

    3 ACL2 !>

  The leading integer is, again, the depth.  Because breaks often occur
  recursively it is convenient always to know the level with which
  you are interacting.

  You may type arbitrary commands as in the top-level ACL2 loop.  For
  example, you might type:

    3 ACL2 !>:help

  or

    3 ACL2 !>:pe lemma12

  Exceptions are that [47m:[0m[47m[ubt][0m and related commands such as [47m:[0m[47m[ubu][0m, as
  well as [47m[puff][0m and [47m[puff*][0m, are only allowed to touch [command]s
  issued after entering the interactive break.  (Technical detail:
  that is because [47m[disable-ubt][0m is invoked when entering the break.)

  More likely than typing a history command, upon entering
  break-rewrite you will determine the context of the attempted
  application.  Here are some useful commands:

    3 ACL2 >:target           ; the term being rewritten
    3 ACL2 >:unify-subst      ; the unifying substitution
    3 ACL2 >:path             ; the stack of goals pursued by the rewriter
                              ; starting at the top-level clause being simplified
                              ; and ending with the current application

  The output of the [47m:path[0m command shows a stack of simplification and
  rewriting ``frames'' starting with the current top-level goal (in
  clausal form as a list of literals) and ending with the current
  target.  Frames should be self-explanatory.  Frames describing the
  attempt to apply a rewrite rule will display the name of the
  equivalence relation the rule uses (unless the relation is [47mequal[0m).
  All rewrite frames (including the attempt to apply a given rewrite
  rule) will display the current [geneqv] (the sense of equivalence
  the rewriter is obligated to maintain) unless the geneqv denotes
  just the [47mequal[0mity relation.

  At this point in the interaction the system has not yet tried to
  apply the [monitor]ed rule.  That is, it has not tried to establish
  the hypotheses, considered the heuristic cost of backchaining,
  rewritten the right-hand side of the conclusion, etc.  When you are
  ready for it to try the rule you can type one of several different
  ``proceed'' commands.  The basic proceed commands are [47m:ok[0m, [47m:go[0m, and
  [47m:eval[0m.

    :ok

  exits break-rewrite without further interaction at the current depth.
  When break-rewrite exits it prints ``[47m3)[0m'' (actually, of course, the
  current depth!), closing the parenthesis that opened the current
  depth, [47m3[0m, interaction.  However, between your typing the [47m:ok[0m
  command and the exit from depth [47m3[0m you may well see deeper
  break-rewrite breaks --- triggered by any of your monitored runes
  --- as the rewriter tries to apply the lemma that prompted the
  current depth [47m3[0m break.

    :go

  exits break-rewrite without further interaction at the current depth,
  but as it exits it prints out the result of the application
  attempt, i.e., whether the application succeeded, if so, what the
  [47m:target[0m term was rewritten to, and if not why the rule was not
  applicable.

    :eval

  causes break-rewrite to attempt to apply the rule but interaction at
  this depth of break-rewrite resumes when the attempt is complete.
  When control returns to this level of break-rewrite a message
  indicating the result of the application attempt (just as in [47m:go[0m)
  is printed, followed by the [prompt] for additional user input for
  the current depth [47m3[0m.

  Generally speaking, [47m:ok[0m and [47m:go[0m are used when the break in question
  is routine or uninteresting and [47m:eval[0m is used when the break is one
  that the user anticipates is causing trouble.  For example, if you
  are trying to determine why a lemma isn't being applied to a given
  term and the [47m:target[0m of the current break-rewrite is the term in
  question, you would usually [47m:eval[0m the rule and if break-rewrite
  reports that the rule failed then you are in a position to
  determine why, for example by carefully inspecting the
  [47m:[0m[47m[type-alist][0m and perhaps the [linear-arithmetic] [47m:pot-list[0m of
  governing assumptions or why some hypothesis of the rule could not
  be established.

  It is often the case that when you are in break-rewrite you wish to
  change the set of [monitor]ed [rune]s.  This can be done by using
  [47m:[0m[47m[monitor][0m and [47m:[0m[47m[unmonitor][0m as noted above.  For example, you might
  want to [monitor] a certain rule, say [47mhyp-reliever[0m, just when it is
  being used while attempting to apply another rule, say [47mmain-lemma[0m.
  Typically then you would [monitor] [47mmain-lemma[0m at the ACL2
  top-level, start the proof-attempt, and then in the break-rewrite
  in which [47mmain-lemma[0m is about to be tried, you would install a
  [monitor] on [47mhyp-reliever[0m.  If you then [47m:eval[0m and get a break on
  [47mhyp-reliever[0m you will know it is being used under the attempt to
  apply [47mmain-lemma[0m.

  However, when the rewriter leaves this attempt to apply [47mmain-lemma[0m,
  [47mhyp-reliever[0m will no longer be monitored.  That is, the list of
  monitored runes is maintained as a local variable of break-rewrite.
  See [47m[monitored-runes][0m.

  [47m:Ok![0m, [47m:go![0m, and [47m:eval![0m are just like their counterparts ([47m:ok[0m, [47m:go[0m,
  and [47m:eval[0m, respectively), except that before proceeding they
  unmonitor all runes.  Of course, this is only done in the scope of
  the interactive break in which these commands were used.  When
  control returns to the top-level of the ACL2 loop the monitored
  runes will have reverted to its original value there.  These
  commands allow you to proceed from the current depth without
  getting any deeper breaks.

  [47m:Ok$[0m, [47m:go$[0m, and [47m:eval$[0m are similar but take an additional argument
  which must be a list of runic designators (or a single designator).
  See [rune].  Two examples the use of [47m:eval$[0m are

    3 ACL2 !>:eval$ hyp-reliever

  and

    3 ACL2 !>:eval$ (hyp-reliever (:definition foo))

  The second command above is exactly equivalent to

    3 ACL2 !>:monitor hyp-reliever t
    3 ACL2 !>:monitor (:definition foo) t
    3 ACL2 !>:eval

  Analogous remarks apply to [47m:go$[0m and [47m:ok$[0m.  If you want to specify
  more sophisticated break criteria (rather than just [47m:condition t[0m)
  you must use the [47m:monitor[0m command explicitly before proceeding.

  Thus, there are nine ways to proceed from the initial entry into
  break-rewrite although we often speak as though there are two, [47m:ok[0m
  and [47m:eval[0m, and leave the others implicit.  We group [47m:go[0m with [47m:ok[0m
  because in all their flavors they exit break-rewrite without
  further interaction (at the current depth).  All the flavors of
  [47m:eval[0m require further interaction after the rule has been tried.

  You are not permitted to ``re-[47m:eval[0m'' a rule.  That is, after issuing
  the [47m:eval[0m command in a given break, you cannot issue it again in
  that break.  The rule has been evaluated, the results are available
  to you, and that's that!  All you can do, aside from inspecting the
  context, is allow rewrite to continue, by issuing an [47m:ok[0m or [47m:go[0m, or
  abort.

  To abort a proof attempt and return to the top-level of ACL2 you may
  at any time type [47m(a!)[0m followed by a carriage return or,
  equivalently (if you are not in a raw Lisp break) use the keyword
  command [47m:a![0m.  See [a!].

  We now address ourselves to the post-[47m:eval[0m interaction with
  break-rewrite.  As noted, post-[47m:eval[0m interaction begins with
  break-rewrite's report on the results of applying the rule: whether
  it worked and either what it produced or why it failed.  This
  information is also printed by certain keyword commands available
  after [47m:eval[0m, namely [47m:wonp[0m, [47m:rewritten-rhs[0m or (for [linear] rules)
  [47m:poly-list[0m, and [47m:failure-reason[0m.  In addition, by using [47m[brr@][0m you
  can obtain this information in the form of ACL2 data objects.  This
  allows the development of more sophisticated ``break conditions''
  that test the context of the pending break and that return a list
  of commands to execute if a break occurs; see [monitor] for
  examples.  In this connection we point out the macro form [47m(ok-if
  term)[0m.  See [ok-if].  This command exits break-rewrite if [47mterm[0m
  evaluates to non-[47mnil[0m and otherwise does not exit.  Thus it is
  possible to define macros that provide other kinds of exits from
  break-rewrite.  The only way to exit break-rewrite after [47m:eval[0m is
  [47m:ok[0m or [47m:go[0m or the use of [47m[ok-if][0m.

  Note that when inside break-rewrite, all [history] commands, such as
  [47m:[0m[47m[pe][0m, show the [enable]d status of rules with respect to the
  current point in the proof attempt.  For example, if you break
  while the prover is working on Subgoal 3, and the [hints] supplied
  for the proof specify [47m(\"Subgoal 3\" :in-theory (disable foo))[0m for
  some rule [47mfoo[0m, then [47m:[0m[47m[pe][0m will indicate that [47mfoo[0m is [disable]d:
  even though [47mfoo[0m may be enabled globally, it is shown as disabled
  because it is disabled during Subgoal 3.  See subtopics of
  [history] for a list of all such history commands.  In addition to
  those commands, the function [47m[disabledp][0m is also evaluated inside
  break-rewrite with respect to the current enabled state of the
  prover.

  We have not discussed ``near-miss'' breaks.  These are caused when a
  monitored rune specifies one of the near-miss break criteria and
  the rune's pattern fails to match the target but ``almost'' matches
  according to the criteria.  See [47m[monitor][0m for a discussion of
  near-miss break criteria.  But for example, if [47mmain-lemma[0m rewrites
  the term [47m(f (g (h x) y) x)[0m and you've installed a monitor on it
  like this:

    :monitor main-lemma (:abstraction (f (g u v) w))

  then if the rewriter encountered the target term [47m(F (G (MUMBLE A) B)
  C)[0m it would cause a near-miss break because the pattern of
  [47mmain-lemma[0m does not match the target but the specified abstraction
  of the pattern does match the target.

  You interact with a near-miss break just like the breaks described
  above, except some commands (e.g., [47m:eval[0m) are unavailable because
  the rule did not match and thus there is no way to proceed except
  to exit the break and try the next lemma.

  The rest of this [documentation] discusses a few implementation
  details of break-rewrite and may not be interesting to the typical
  user.

  There is no ACL2 function named break-rewrite --- which is why we
  don't write it in typewriter font in this documentation.
  Break-rewrite is an illusion created by appropriate calls to three
  ``break point handlers'' named [47mnear-miss-brkpt1[0m, [47mbrkpt1[0m and [47mbrkpt2[0m.
  As previously noted, break-rewrite is [47m[ld][0m operating on a
  [wormhole] [state].  One might therefore wonder how break-rewrite
  can apply a rule and then communicate the results back to the
  rewriter running in the external [state].  The answer is that it
  cannot.  Nothing can be communicated through a [wormhole].  In
  fact, the break point handlers are each calls of [47m[ld][0m running on
  [wormhole] [state]s.  They maintain a state machine inside the
  wormhole.  For example, [47mbrkpt1[0m is called by rewrite after a
  successful match, if the monitored [47m:condition[0m is true, an
  interactive break occurs.  Upon an [47m:ok[0m or [47m:eval[0m, the wormhole's
  status information is updated, the wormhole is exited (losing any
  state changes made inside the wormhole), rewrite continues to do
  whatever rewrite does for that lemma, and then [47mbrkpt2[0m is called.
  [47mBrkpt2[0m then uses the state information in the wormhole to decide
  whether to interact or not.

  This helps explain why the rewriter behaves more sluggishly when [47m(brr
  t)[0m has been done: it is entering and exiting wormholes to figure
  out whether to trigger an interactive break.  When you are through
  with break-rewrite, we recommend [47m(brr nil)[0m.

  This design causes certain anomalies that might be troubling.

  Suppose you are inside a depth [47m3[0m break before [47m:evaling[0m a rule (i.e.,
  you're in the [47mbrkpt1[0m [wormhole] [state]) you define some function,
  [47mfoo[0m.  Suppose then you [47m:eval[0m the rule and eventually control
  returns to the depth [47m3[0m break (i.e., now you're in the [47mbrkpt2[0m
  [wormhole] [state] with the results of the application in it).  You
  will discover that [47mfoo[0m is no longer defined!  That is because the
  [wormhole] [state] created during your pre-[47m:eval[0m interaction is
  lost when we exit the [wormhole] to resume the proof attempt.  The
  post-[47m:eval[0m [wormhole] [state] is in fact identical to the initial
  pre-[47m:eval[0m [state] (except for the results of the application)
  because [47m[rewrite][0m did not change the external [state] and both
  [wormhole] [state]s are copies of it.  A similar issue occurs with
  the use of [trace] utilities: all effects of calling [47m[trace$][0m and
  [47m[untrace$][0m are erased when you proceed from a break in the
  break-rewrite loop.

  See the subtopics listed below to learn more about [47mbreak-rewrite[0m.


Subtopics

  [Break-lemma]
      A quick introduction to breaking rewrite rules in ACL2

  [Brr]
      To enable or disable the breaking of rewrite rules

  [Brr-commands]
      [Break-Rewrite] Commands

  [Brr-near-missp]
      attachable function for determining ``near misses''

  [Brr@]
      To access context sensitive information within [47m[break-rewrite][0m

  [Cw-gstack]
      Debug a rewriting loop or stack overflow

  [Dmr]
      Dynamically monitor rewrites and other prover activity

  [Geneqv]
      the rewriter's generated equivalence relation

  [Monitor]
      To monitor attempted applications of certain rules by the rewriter

  [Monitor!]
      A quiet combination of [47m[monitor][0m and [47m[brr][0m

  [Monitored-runes]
      Print the [monitor]ed [rune]s and their break conditions

  [Ok-if]
      Conditional exit from [47mbreak-rewrite[0m

  [Refinement-failure]
      what to do when a rewrite rule fails the refinement check

  [Unmonitor]
      To stop monitoring a rule name

  [Why-brr]
      An explanation of why ACL2 has an explicit [47m[brr][0m mode

  [Windows-installation]
      Installing ACL2 on Windows

  [With-brr-data]
      Finding the source of a term in prover output")
 (BREAKS
  (ERRORS)
  "Common Lisp breaks

    Example:
    Broken at PROVE.  Type :H for Help.
    >>:Q

    ACL2 !>

  You may interrupt the system by typing various control character
  sequences.  The precise sequences are determined by the host Lisp
  and operating system environment.  For example, in GCL and Allegro
  Common Lisp, a console interrupt is caused by typing ``[47mctrl-c[0m''.
  If, however, the GCL or Allegro is running in an Emacs shell
  buffer, one must type ``ctrl-c ctrl-c''.

  If a break occurs, for example because of a bug in ACL2 or a user
  interrupt, the break will run a Common Lisp read-eval-print loop,
  not an ACL2 read-eval-print loop.  This may not be obvious if the
  [prompt]s in the two loops are similar.  Because you are typing to
  a Common Lisp evaluator, you must be careful.  It is possible to
  damage your ACL2 state in irreparable ways by executing non-ACL2
  Common Lisp.  It is even possible to disrupt and render inaccurate
  the interrupted evaluation of a simple ACL2 expression.

  For ACL2 built on most host Common Lisps, you can expect to see a
  different prompt at the break than you would see in the ACL2
  read-eval-print loop.  See [prompt] for how to change the raw Lisp
  prompt to emphasize that one is in raw Lisp, and hence may wish to
  quit from the break.

  The most reliable way to return to the ACL2 top level is by executing
  the following command: [47m([0m[47m[abort!][0m[47m)[0m.  Appropriate cleanup will then
  be done, which should leave you in an appropriate state.

  However, you may be able to quit from the break in the normal Lisp
  manner (as with [47m:q[0m in GCL or CCL, [47m:reset[0m in Allegro CL, and [47mq[0m in
  CMU CL).  If this attempt to quit is successful, it will return you
  to the innermost ACL2 read-eval-print loop, with appropriate
  cleanup performed first.  Note that if you are within a [47m[brr][0m
  environment when the break occurs, quitting from the break will
  only return you to that environment, not to the top of ACL2's
  read-eval-print loop.")
 (BROKEN-LINK
  (DOCUMENTATION)
  "Placeholder for link to documentation that resides in the community
  books

  You may have attempted to access information about the ACL2
  [community-books] while looking at the ACL2 User's Manual, which
  contains [documentation] only about the ACL2 [3msystem[0m, and does not
  include documentation from the [community-books].  Please point
  your browser at the {ACL2+Books Manual |
  http://www.cs.utexas.edu/users/moore/acl2/v8-6/combined-manual/index.html}
  (or if browsing in [ACL2-Doc], switch to that manual with meta-0 I)
  to access the desired topic.

  If you want information about the book where your missing topic is
  defined, see [broken-link-table].


Subtopics

  [Broken-link-table]
      Map [documentation] topics to the community books that define them")
 (BROKEN-LINK-TABLE
  (BROKEN-LINK)
  "Map [documentation] topics to the community books that define them

  The table below maps topics to book locations that reside only in the
  ACL2+Books combined manual, not the ACL2 User's Manual.  For
  example, the entry

    (b* \"[books]/std/util/bstar.lisp\")

  signifies that the topic [47mB*[0m is documented in the community book
  [47mstd/util/bstar.lisp[0m.

      ((*acl2-system-exports* \"[books]/system/acl2-system-exports.lisp\")
       (<< \"[books]/misc/total-order.lisp\")
       (acl2s::acl2s-installation \"[books]/acl2s/installation.lisp\")
       (add-io-pairs \"[books]/std/util/add-io-pairs.lisp\")
       (algebra \"[books]/doc/more-topics.lisp\")
       (append-without-guard \"[books]/std/lists/flatten.lisp\")
       (oslib::argv \"[books]/oslib/argv-logic.lisp\")
       (arith-equivs \"[books]/std/basic/arith-equiv-defs.lisp\")
       (arithmetic \"[books]/doc/more-topics.lisp\")
       (arithmetic-1 \"[books]/arithmetic/top.lisp\")
       (arithmetic/natp-posp \"[books]/arithmetic/natp-posp.lisp\")
       (arity+ \"[books]/std/system/arity-plus.lisp\")
       (assert! \"[books]/std/testing/assert-bang.lisp\")
       (assert!-stobj \"[books]/std/testing/assert-bang-stobj.lisp\")
       (b* \"[books]/std/util/bstar.lisp\")
       (bit-vectors \"[books]/doc/more-topics.lisp\")
       (bridge \"[books]/centaur/bridge/top.lisp\")
       (oslib::catpath \"[books]/oslib/catpath.lisp\")
       (build::cert.pl \"[books]/build/doc.lisp\")
       (build::cert_param \"[books]/build/doc.lisp\")
       (cgen \"[books]/acl2s/cgen/top.lisp\")
       (checkpoint-list \"[books]/kestrel/utilities/checkpoints-doc.lisp\")
       (consideration \"[books]/hints/consider-hint.lisp\")
       (build::custom-certify-book-commands \"[books]/build/doc.lisp\")
       (std::defaggregate \"[books]/std/util/defaggregate.lisp\")
       (defconsts \"[books]/std/util/defconsts.lisp\")
       (defdata \"[books]/acl2s/defdata/top.lisp\")
       (define \"[books]/std/util/define.lisp\")
       (defmac \"[books]/misc/defmac.lisp\")
       (defmacroq \"[books]/kestrel/utilities/defmacroq.lisp\")
       (fty::defprod \"[books]/centaur/fty/top.lisp\")
       (defpun \"[books]/misc/defpun.lisp\")
       (defthm<w \"[books]/kestrel/utilities/auto-instance.lisp\")
       (defthmg \"[books]/tools/defthmg.lisp\")
       (acl2s::defunc \"[books]/acl2s/defunc.lisp\")
       (defxdoc \"[books]/xdoc/topics.lisp\")
       (getopt-demo::demo2 \"[books]/centaur/getopt/demo2.lisp\")
       (developers-guide \"[books]/system/doc/developers-guide.lisp\")
       (developers-guide-utilities
            \"[books]/system/doc/developers-guide.lisp\")
       (do-not-hint \"[books]/tools/do-not.lisp\")
       (easy-simplify-term \"[books]/tools/easy-simplify.lisp\")
       (er-soft+ \"[books]/kestrel/utilities/er-soft-plus.lisp\")
       (final-cdr \"[books]/std/lists/final-cdr.lisp\")
       (fty \"[books]/centaur/fty/top.lisp\")
       (getopt \"[books]/centaur/getopt/top.lisp\")
       (gl \"[books]/centaur/gl/doc.lisp\")
       (hacker \"[books]/hacking/hacking-xdoc.lisp\")
       (ihs \"[books]/ihs/ihs-doc-topic.lisp\")
       (include-raw \"[books]/tools/include-raw.lisp\")
       (install-not-normalized \"[books]/misc/install-not-normalized.lisp\")
       (list-equiv \"[books]/std/lists/equiv.lisp\")
       (list-fix \"[books]/std/lists/list-fix.lisp\")
       (logbitp-reasoning \"[books]/centaur/bitops/equal-by-logbitp.lisp\")
       (make-flag \"[books]/tools/flag.lisp\")
       (make-termination-theorem
            \"[books]/kestrel/utilities/make-termination-theorem.lisp\")
       (xdoc::markup \"[books]/xdoc/topics.lisp\")
       (memoized-prover-fns \"[books]/tools/memoize-prover-fns.lisp\")
       (must-fail \"[books]/std/testing/must-fail.lisp\")
       (str::nat-to-dec-string \"[books]/std/strings/decimal.lisp\")
       (non-parallel-book \"[books]/std/system/non-parallel-book.lisp\")
       (note-6-4-books \"[books]/doc/relnotes.lisp\")
       (note-6-5-books \"[books]/doc/relnotes.lisp\")
       (note-7-0-books \"[books]/doc/relnotes.lisp\")
       (note-7-1-books \"[books]/doc/relnotes.lisp\")
       (note-7-2-books \"[books]/doc/relnotes.lisp\")
       (note-8-0-books \"[books]/doc/relnotes.lisp\")
       (note-8-1-books \"[books]/doc/relnotes.lisp\")
       (note-8-2-books \"[books]/doc/relnotes.lisp\")
       (note-8-3-books \"[books]/doc/relnotes.lisp\")
       (note-8-4-books \"[books]/doc/relnotes.lisp\")
       (note-8-5-books \"[books]/doc/relnotes.lisp\")
       (note-8-6-books \"[books]/doc/relnotes.lisp\")
       (str::numbers \"[books]/std/strings/top.lisp\")
       (open-trace-file! \"[books]/tools/open-trace-file-bang.lisp\")
       (oracle-timelimit \"[books]/tools/oracle-timelimit.lisp\")
       (oslib \"[books]/oslib/top-logic.lisp\")
       (patbind-the \"[books]/std/util/bstar.lisp\")
       (build::pre-certify-book-commands \"[books]/build/doc.lisp\")
       (xdoc::preprocessor \"[books]/xdoc/topics.lisp\")
       (str::pretty \"[books]/std/strings/pretty.lisp\")
       (str::pretty-printing \"[books]/std/strings/pretty.lisp\")
       (profile-acl2 \"[books]/centaur/memoize/old/profile.lisp\")
       (profile-all \"[books]/centaur/memoize/old/profile.lisp\")
       (prove$ \"[books]/tools/prove-dollar.lisp\")
       (quicklisp \"[books]/quicklisp/top.lisp\")
       (release-notes-books \"[books]/doc/relnotes.lisp\")
       (removable-runes \"[books]/tools/removable-runes.lisp\")
       (remove-hyps \"[books]/tools/remove-hyps.lisp\")
       (rewrite$ \"[books]/tools/rewrite-dollar.lisp\")
       (rewrite-equiv-hint \"[books]/coi/util/rewrite-equiv.lisp\")
       (rtl \"[books]/rtl/rel11/lib/doc.lisp\")
       (run-script \"[books]/tools/run-script.lisp\")
       (satlink::sat-solver-options \"[books]/centaur/satlink/top.lisp\")
       (satlink \"[books]/centaur/satlink/top.lisp\")
       (xdoc::save \"[books]/xdoc/topics.lisp\")
       (xdoc::save-rendered \"[books]/xdoc/topics.lisp\")
       (xdoc::save-rendered-event \"[books]/xdoc/topics.lisp\")
       (set-max-mem \"[books]/centaur/misc/memory-mgmt-logic.lisp\")
       (spacewalk \"[books]/centaur/misc/spacewalk.lisp\")
       (std \"[books]/std/top.lisp\")
       (std/io \"[books]/std/io/top.lisp\")
       (std/strings \"[books]/std/strings/top.lisp\")
       (std/util \"[books]/std/util/top.lisp\")
       (std::strict-list-recognizers \"[books]/std/util/deflist-base.lisp\")
       (subseq-list \"[books]/std/lists/subseq.lisp\")
       (xdoc::terminal \"[books]/xdoc/topics.lisp\")
       (trans-eval-error-triple
            \"[books]/kestrel/utilities/trans-eval-error-triple.lisp\")
       (trans-eval-state
            \"[books]/kestrel/utilities/trans-eval-error-triple.lisp\")
       (unsound-read \"[books]/std/io/unsound-read.lisp\")
       (untranslate-patterns \"[books]/misc/untranslate-patterns.lisp\")
       (use-trivial-ancestors-check
            \"[books]/tools/trivial-ancestors-check.lisp\")
       (build::using-extended-acl2-images \"[books]/build/doc.lisp\")
       (with-raw-mode \"[books]/hacking/hacking-xdoc.lisp\")
       (with-redef-allowed \"[books]/hacking/hacking-xdoc.lisp\")
       (with-timeout \"[books]/acl2s/cgen/with-timeout.lisp\")
       (without-subsumption \"[books]/tools/without-subsumption.lisp\")
       (working-with-packages \"[books]/doc/practices.lisp\")
       (write-list \"[books]/misc/file-io-doc.lisp\")
       (xdoc \"[books]/xdoc/topics.lisp\"))")
 (BRR
  (BREAK-REWRITE)
  "To enable or disable the breaking of rewrite rules

    Example:
    :brr t       ; enable
    (brr t)      ; enable (same as above)
    (brr t t)    ; enable with less output (rarely invoked interactively)
    :brr nil     ; disable

    General Form:
    (brr flg &optional quietp)

  where [47mflg[0m and the optional [47mquietp[0m argument evaluate to [47mt[0m or [47mnil[0m.
  This function modifies [47m[state][0m so that the attempted application of
  certain rewrite rules are ``broken.'' ``[47mBrr[0m'' stands for
  ``break-rewrite'' and can be thought of as a mode with two
  settings.  The normal mode is ``disabled.''

  For a more thorough introduction to the break rewrite system see
  [break-rewrite].  For a related proof debugging utility see
  [with-brr-data].

  When [47mbrr[0m mode is ``enabled'' the ACL2 rewriter monitors the attempts
  to apply certain rules and advises the user of those attempts by
  entering an interactive wormhole break.  From within this break the
  user can watch selected application attempts.  The user can also
  interact with the system during [47mbrr[0m breaks via [47m[brr-commands][0m.

  The rules monitored are selected by using the [47m[monitor][0m and
  [47m[unmonitor][0m commands.  It is possible to break a rune
  ``conditionally'' in the sense that an interactive break will occur
  only if a specified predicate is true of the environment at the
  time of the attempted application.  See [monitor] and see
  [unmonitor].

  Even if a non-empty set of rules has been selected, no breaks will
  occur unless [47mbrr[0m mode is enabled.  Thus, the first time in a
  session that you wish to monitor a rewrite rule, use [47m:brr[0m [47mt[0m to
  enable [47mbrr[0m mode.  Thereafter you may select runes to be monitored
  with [47m[monitor][0m and [47m[unmonitor][0m with the effect that whenever
  monitored rules are tried (and their break conditions are met) an
  interactive break will occur.  Be advised that when [47mbrr[0m mode is
  enabled the rewriter is somewhat slower than normal.  Furthermore,
  that sluggishness persists even if no runes are monitored.  You may
  regain normal performance --- regardless of what runes are
  monitored --- by disabling [47mbrr[0m mode with [47m:brr[0m [47mnil[0m.

  Why isn't [47mbrr[0m mode disabled automatically when no runes are
  monitored?  More generally, why does ACL2 have [47mbrr[0m mode at all?
  Why not just test whether there are monitored runes?  If you care
  about the answers, see [why-brr].

  BRR Mode, Console Interrupts, and Subsidiary Prover Calls: If the
  system is operating in [47mbrr[0m mode and you break into raw Lisp (as by
  causing a console interrupt or happening upon a signaled Lisp
  error; see [breaks]), you can return to the ACL2 top-level, outside
  any break-rewrite environment, by executing [47m([0m[47m[abort!][0m[47m)[0m.  Otherwise,
  the normal way to quit from such a raw Lisp break (for example [47m:q[0m
  in GCL, [47m:reset[0m in Allegro CL, and [47mq[0m in CMU CL) will return to the
  innermost ACL2 read-eval-print loop, which may or may not be the
  top-level of your ACL2 session!  In particular, if the interrupt or
  error break happens to occur while ACL2 is within a break-rewrite
  break (in which it is preparing to read [47m[brr-commands][0m), the abort
  will merely return to break-rewrite break.  Upon exiting that
  environment, normal theorem proving is continued (and the
  break-rewrite breaks may be entered again in response to subsequent
  monitored rule applications).  In addition, if while in a
  break-rewrite break, say at depth [47md[0m, you invoke the theorem prover
  recursively as by typing a [47m[thm][0m or [47m[defthm][0m or [47m[defun][0m command to
  break-rewrite, recursive breaks may occur with depths starting at
  [47md+1[0m.  This can get confusing because it may appear that the ongoing
  (sub-)proofs are part of the original proof when in fact the system
  is just carrying out your commands.


Subtopics

  [Brr-evisc-tuple]
      Determines partial suppression of output from [brr-commands]

  [Set-brr-evisc-tuple]
      Set the [47m[brr-evisc-tuple][0m")
 (BRR-COMMANDS
  (BREAK-REWRITE)
  "[Break-Rewrite] Commands

  Below is a list of commonly used [break-rewrite] keyword commands.
  These are only defined within the breaks caused by [47m[monitor][0ms on
  runes in the process of being considered by the ACL2 rewriter.
  These breaks interact with you from within a [47m[wormhole][0m and are
  handled by [47m[ld][0m (the same function that manages ACL2's top-level
  interactive read-eval-print loop).  So within certain limitations
  imposed by wormholes, you can evaluate any command you would at the
  top-level of ACL2 in addition to the special commands below.

  Many break commands display terms, e.g., the target being rewritten,
  and ``large'' terms are ``eviscerated'' (i.e., abbreviated) before
  printing.  These commands have corresponding commands suffixed with
  a ``+'' that avoid evisceration so that the terms in question are
  printed in full.  See [brr-evisc-tuple].  The notation
  ``[47m:ancestors[+][0m'' below indicates that the [47m:ancestors[0m command may
  print abbreviate terms but the [47m:ancestors+[0m command does not.

    :a!                abort to ACL2 top-level
    :ancestors[+]      negations of backchaining hypotheses being pursued
    :btm[+]            bottom-most frame in :path
    :eval              try the rule (i.e., recursively try to relieve
                         the hypotheses and other conditions, possibly
                         producing other breaks) and return to this
                         break afterwards so you can query results
    :eval!             :eval but remove all monitors first (see below)
    :eval$ runes       :eval but first add monitors for runes (see below)
    :explain-near-miss[+]
                       print an explanation of why the rule's pattern failed
                         to match the :target; only relevant in a break caused
                         by a near miss
    :failure-reason[+] reason rule failed (after :eval)
    :final-ttree[+]    ttree after :eval (see :DOC ttree)
    :frame[+] i        ith frame in :path
    :geneqv[+]         generated equivalence relation to be maintained
    :go                :eval but don't return to this break, just
                         print the result of the try
    :go!               :go but first remove all monitors (see below)
    :go$ runes         :go but first add monitors for runes (see below)
    :help              this message
    :hyp i             ith hypothesis of the rule
    :hyps              hypotheses of the rule
    :initial-ttree[+]  ttree before :eval (see :DOC ttree)
    :lhs[+]            left-hand side of rule's conclusion (or, in the case
                         of :rewrite-quoted-constant rules of form [2], the
                         right-hand side!); this is the pattern that the
                         target must match for this :rewrite rule to fire
    :max-term[+]       maximal term of a :linear lemma; this is the pattern
                         that the target must match for this :linear rule to
                         fire
    :ok                like :go, but don't print the result of the try
    :ok!               :ok but first remove all monitors (see below)
    :ok$ runes         :ok but first add monitors for runes (see below)
    :path[+]           rewriter's path from top clause to :target
    :poly-list[+]      list of polynomials (after :eval) of a linear rule,
                         where the leading term of each is enclosed in an
                         extra set of parentheses
    :pot-list[+]       set of polynomials governing :target,
                         organized by maximal term
    :rewritten-rhs[+]  rewritten :rhs (after :eval) of a rewrite rule
    :rhs               right-hand side of rule's conclusion (or, in the case
                         of :rewrite-quoted-constant rules of form [2], the
                         left-hand side!)
    :standard-help     :help message from ACL2 top-level
    :target[+]         term being rewritten
    :top[+]            top-most frame in :path
    :type-alist[+]     type assumptions governing :target
    :unify-subst[+]    substitution making :lhs equal :target
    :wonp              indicates whether application succeeded (after :eval)

  The form [47m([0m[47m[brr@][0m[47m :cmd)[0m, when evaluated within a break, will return
  the value that is only printed by certain of the keyword commands
  above.  This is particularly useful when programming break
  conditions.  See [47m[monitor][0m.

  Since you're actually in a general read-eval-print loop when
  interacting with [break-rewrite] you may type the usual ACL2
  commands like [47m:[0m[47m[pbt][0m or [47m:[0m[47m[pe][0m or even [47m[defun][0m and [47m[defthm][0m.  You
  cannot modify [stobj]s or files from within the break.  However,
  all [state] changes you cause from within [break-rewrite] are lost
  when you exit or [47m:eval[0m the rule.

  Note that if you are breaking on a [monitor]ed [linear] rule, several
  of the commands listed above do not apply: [47m:lhs[0m, [47m:rhs[0m,
  [47m:initial-ttree[0m, and [47m:final-ttree[0m.  The pattern used to fire a
  linear rule is found with the command [47m:max-term[0m.  In addition,
  [47m:rewritten-rhs[0m also does not apply to linear rules, but instead,
  [47m:poly-list[0m shows the result of applying the linear lemma as a list
  of polynomials, implicitly conjoined.  The leading term of each
  polynomial is enclosed in an extra set of parentheses.

  See the discussion of form [2] [47m:[0m[47m[rewrite-quoted-constant][0m rules for
  an explanation of the swapped meanings of ``[47m:lhs[0m'' and ``[47m:rhs[0m.''

  The commands [47m:eval$[0m, [47m:go$[0m, and [47m:ok$[0m take an argument, called runes,
  which may be a list of runes and/or runic designators (see [rune])
  or a single rune or runic designator.  For each rune in runes,
  these commands execute [47m:[0m[47m[monitor][0m rune [47mt[0m, and then execute [47m:eval[0m,
  [47m:go[0m or [47m:ok[0m as appropriate.

  This is useful if you want to monitor the use of a ``secondary'' rune
  only during the attempt to apply a ``primary'' rune: install the
  monitor on the secondary rune inside the break caused by the
  primary rune.  In the case of [47m:eval$[0m, when the attempt to apply the
  primary rune is finished you will be back in the interactive break
  and can inspect the results.  You will notice that the secondary
  rune is still on the list of [47m[monitored-runes][0m.  However, when you
  exit that break [47mmonitored-runes[0m will be restored to its earlier
  value.  In the case of [47mgo$[0m and [47mok$[0m, no interactive break occurs
  after the primary rune has been applied.

  Similar remarks apply to [47m:eval![0m, [47m:go![0m, and [47m:ok![0m except they first
  [47m:[0m[47m[unmonitor][0m [47m:all[0m, before proceeding with the appropriate [47m:eval[0m,
  [47m:go[0m, or [47m:ok[0m.  These commands are useful if you want no breaks to
  occur while attempting to apply the rune that caused the current
  break.

  Recall (from the discussion of [47m[monitor][0ms) that break conditions
  terms installed as part of break criteria do not just determine
  whether a break occurs but can compute the initial break commands
  fed to the interactive loop.  Thus, for example, you can install a
  monitor that causes the rewriter to not only break when a certain
  rune is used, but then automatically print information, proceed
  from the break, inspect the result, and then either exit the break
  or prompt for user input.  See the discussion in [47m[monitor][0m.

  Note: If you use commands that change the monitored runes during a
  break, e.g., [47m[monitor][0m, [47m[unmonitor][0m, or [47m:eval![0m, [47m:eval$[0m, etc., then
  abort during the recursion, the list of monitored runes will not
  necessarily be restored to its original top-level setting.")
 (BRR-EVISC-TUPLE
  (BRR EVISC-TUPLE)
  "Determines partial suppression of output from [brr-commands]

  See [evisc-tuple] for relevant background on ``evisceration'':
  eliding of subexpressions during printing.  Also see
  [break-rewrite] for background on the break-rewrite loop.

    General Form:
    (brr-evisc-tuple state)

  The value of this function is used as the evisceration tuple by
  [brr-commands].  The value can be changed with
  [47m[set-brr-evisc-tuple][0m or the more general [47m[set-evisc-tuple][0m.

  A special value, [47m:default[0m, is legal for this evisc-tuple, and is its
  initial value.  In that case the actual evisc-tuple used during
  output from [brr-commands] --- which we call the [3meffective value[0m of
  the [47mbrr-evisc-tuple[0m --- is the value of the evisc-tuple for terms.
  See [set-evisc-tuple], in particular, the discussion of the [47m:term[0m
  site for setting evisc-tuples.

  Think of [47mbrr-evisc-tuple[0m as a true global variable, not a locally
  bound variable of break-rewrite.  In particular, if you set the
  [47mbrr-evisc-tuple[0m inside a break-rewrite interactive break and
  eventually exit that break --- either to enter a deeper break or
  return to a shallower break or to the ACL2 top-level --- the
  [47mbrr-evisc-tuple[0m will retain its chronologically most recent
  setting.

  The [47mbrr-evisc-tuple[0m is used when [break-rewrite] prints its banner
  opening or closing a break on some monitored rune and when certain
  [brr-commands] print their results.

  When you're in a break-rewrite break, you're actually dealing with
  the read-eval-print loop managed by [47m[ld][0m.  It prints its results
  using the [47m[ld-evisc-tuple][0m, while [47m[brr-commands][0m use
  [47mbrr-evisc-tuple[0m.  This can cause some confusion.

  For example, suppose you have set the [47mbrr-evisc-tuple[0m to [47m(evisc-tuple
  2 3 nil nil)[0m so break-rewrite banners and brr-commands only print
  to depth 2 and length 3.  Suppose the target term is [47m(F (G (H 1)) 2
  3 4 5 6 7)[0m.  Then the following interaction with break-rewrite
  could occur:

    3 ACL2 >:target
    (F (G #) 2 ...)
    3 ACL2 >(make-list 10)
    (NIL NIL NIL NIL NIL NIL NIL NIL NIL NIL)

  You might ask ``Given that the [47mbrr-evisc-tuple[0m limits the print
  length to [47m3[0m, which I see when I print [47m:target[0m, how come the
  [47mmake-list[0m showed all 10 elements?'' The answer is that the
  [47mbrr-command[0m [47m:target[0m actually printed the target with the
  [47mbrr-evisc-tuple[0m and returned [47m(value :invisible)[0m which [47mld[0m's
  read-eval-print loop doesn't print.  But the [47mmake-list[0m returned a
  list of length ten and the read-eval-print loop printed it using
  the [47m[ld-evisc-tuple][0m.

  Another issue relating [47mbrr-evisc-tuple[0m and [47mld-evisc-tuple[0m is that
  while [47mbrr-evisc-tuple[0m is a true global, retaining its
  chronologically most recently set value at all depths of
  break-rewrite, [47mld-evisc-tuple[0m is locally bound by break-rewrite
  (actually, by the [47mld[0m in [47mwormhole[0m) and so sees its value restored as
  break-rewrite ascends back toward the top-level of ACL2.


Subtopics

  [Set-brr-evisc-tuple]
      Set the [47m[brr-evisc-tuple][0m")
 (BRR-NEAR-MISSP
  (BREAK-REWRITE)
  "attachable function for determining ``near misses''

  This is a system function that determine whether a failed match of a
  monitored rule constitutes a near miss.

  [31;1mNote:[0mThis function is attachable (see [defattach]).

    General Form:
    (brr-near-missp msgp lemma target rcnst criteria-alist)

  where msgp is [47mt[0m or [47mnil[0m, [47mlemma[0m is the ACL2 record representing a
  [47m[monitor][0med [47m:rewrite[0m rule or [47m:linear[0m rule, [47mtarget[0m is a term to
  which the rewriter tried to apply the rule but failed to match the
  pattern in the lemma, [47mrcnst[0m is the rewrite constant at the time of
  the attempt, and [47mcriteria-alist[0m is a symbol-alist associated with
  the rule in [47m[monitored-runes][0m.

  The function determines whether the pattern of the lemma ``almost''
  matches the target, i.e., whether a ``near miss'' has occurred.
  The function is only called if the exact match failed.  The
  built-in version of this function checks the criteria described in
  [47m[monitor][0m.  If a near miss has occurred, the result is either [47mt[0m or
  a message (see [47m[msg][0m) object describing the near miss.  If a near
  miss did not occur, the result is [47mnil[0m.  See the source code for
  [47mbuilt-in-brr-near-missp[0m for details of how the built-in version of
  this function operates.")
 (BRR@
  (BREAK-REWRITE)
  "To access context sensitive information within [47m[break-rewrite][0m

    Example:
    (brr@ :target)      ; the term being rewritten
    (brr@ :unify-subst) ; the unifying substitution

    General Form:
    (brr@ :symbol)

  where [47m:symbol[0m is one of the keywords displayed below.  This utility
  may be most useful for system hackers; see [brr-commands] for
  queries that are more at a user level.  In particular, keywords
  marked below with [47m*[0m probably require an implementor's knowledge of
  the system to use effectively.  They are supported but not well
  documented.  More is said on this topic following the table.  For
  background on the notion of ``translated'' term, see [term].

    :symbol             (brr@ :symbol)
    -------             ---------------------

    :target             the term to be rewritten.  This term is an
                        instantiation of the left-hand side of the
                        conclusion of the rewrite-rule being broken.
                        This term is in translated form!  Thus, if
                        you are expecting (equal x nil) -- and your
                        expectation is almost right -- you will see
                        (equal x 'nil); similarly, instead of (cadr a)
                        you will see (car (cdr a)).  In translated
                        forms, all constants are quoted (even nil, t,
                        strings and numbers) and all macros are
                        expanded.

    :unify-subst        the substitution that, when applied to :target,
                        produces the left-hand side of the rule being
                        broken.  This substitution is an alist pairing
                        variable symbols to translated (!) terms.

    :wonp               t or nil indicating whether the rune was
                        successfully applied.  (brr@ :wonp) returns
                        nil if evaluated before :EVALing the rule.

    :rewritten-rhs      the result of successfully applying the rewrite
                        rule or else nil if (brr@ :wonp) is nil.  The
                        result of successfully applying the rule is
                        always a translated (!) term and is never nil.

    :poly-list          the result of successfully applying the linear
                        rule or else nil if (brr@ :wonp) is nil.  This
                        result represents the list of polynomials
                        produced by the rule application.  The leading
                        term of each polynomial is enclosed in an extra
                        set of parentheses.

    :pot-list        *  the pot-list, which is the set of polynomials
                        that are assumed in the current context,
                        organized by maximal term.  Each polynomial in
                        the list is a linear-pot record.

    :failure-reason     some non-nil lisp object indicating why the rule
                        was not applied or else nil.  Before the rule is
                        :EVALed, (brr@ :failure-reason) is nil.  After
                        :EVALing the rule, (brr@ :failure-reason) is nil
                        if (brr@ :wonp) is t.  Rather than document the
                        various non-nil objects returned as the failure
                        reason, we encourage you simply to evaluate
                        (brr@ :failure-reason) in the contexts of interest.
                        Alternatively, study the ACL2 function tilde-@-
                        failure-reason-phrase.

    :lemma           *  the rewrite rule being broken.  For example,
                        (access rewrite-rule (brr@ :lemma) :lhs) will
                        return the left-hand side of the conclusion
                        of the rule.

    :type-alist      *  a display of the type-alist governing :target.
                        Elements on the displayed list are of the form
                        (term type), where term is a term and type
                        describes information about term assumed to hold in
                        the current context.  (See also the documentation for
                        type-alist.)  The type-alist may be used to determine
                        the current assumptions, e.g., whether A is a CONSP.

    :geneqv          *  the generated equivalence relation that specifies
                        what equivalence relations may be used to rewrite
                        the target.  (See the documentation for geneqv and
                        refinement-failure.)

    :ancestors       *  a stack of frames indicating the backchain history
                        of the current context.  The theorem prover is in
                        the process of trying to establish each hypothesis
                        in this stack.  Thus, the negation of each hypothesis
                        can be assumed false.  Each frame also records the
                        rules on behalf of which this backchaining is being
                        done and the weight (function symbol count) of the
                        hypothesis.  All three items are involved in the
                        heuristic for preventing infinite backchaining.
                        Exception:  Some frames are ``binding hypotheses''
                        (equal var term) or (equiv var (double-rewrite term))
                        that bind variable var to the result of rewriting
                        term.  The ACL2 source code has a definition
                        (defrec ancestor ...) that may provide some relevant
                        insight.

    :initial-ttree   *  the initial and (after :EVAL) final tag trees,
    :final-ttree        respectively.  (Tag trees are low-level data structures
                        that store lemmas used and other information, as
                        documented in topic TTREE.)

    :gstack          *  the current goal stack.  The gstack is maintained
                        by rewrite and is the data structure printed as the
                        current ``path.''  Thus, any information derivable
                        from the :path brr command is derivable from gstack.
                        For example, from gstack one might determine that
                        the current term is the second hypothesis of a
                        certain rewrite rule.

  In general [47mbrr@-expressions[0m are used in break conditions, the
  expressions that determine whether interactive breaks occur when
  [monitor]ed [rune]s are applied.  See [monitor].  For example, you
  might want to break only those attempts in which one particular
  term is being rewritten or only those attempts in which the binding
  for the variable [47ma[0m is known to be a [47m[consp][0m.  Such conditions can
  be expressed using ACL2 system functions and the information
  provided by [47mbrr@[0m.  Unfortunately, digging some of this information
  out of the internal data structures may be awkward or may, at
  least, require intimate knowledge of the system functions.  But
  since conditional expressions may employ arbitrary functions and
  macros, we anticipate that a set of convenient primitives will
  gradually evolve within the ACL2 community.  It is to encourage
  this evolution that [47mbrr@[0m provides access to the [47m*[0m'd data.")
 (BUILDING-ACL2
  (ABOUT-ACL2)
  "How to build an ACL2 executable

  This topic summarizes steps for building an ACL2 executable.  For
  more details see the {ACL2 installation page |
  https://www.cs.utexas.edu/users/moore/acl2/current/HTML/installation/installation.html}.

  To build an ACL2 executable, submit the following command while
  standing in the main ACL2 directory, where [47m<my-lisp>[0m invokes your
  Lisp executable (default: [47mccl[0m).

    make LISP=<my-lisp>

  You should find \"Initialization SUCCEEDED.\" near the end of the log.
  Note: There may be ACL2 warnings, for example: \"ACL2 Warning
  [Skip-proofs] in....\".  These may be safely ignored.

  Note that you will want to certify [books] in order to take full
  advantage of ACL2.  See [books-certification].

  See [save-exec] for how to build an ACL2 executable from a state
  resulting from the running of specified [command]s.


Subtopics

  [Ccl-installation]
      Installing Clozure Common Lisp (CCL)

  [Sbcl-installation]
      Installing Steel Bank Common Lisp (SBCL)

  [Sbcl-installation-brief]
      Installing Steel Bank Common Lisp (SBCL)")
 (BUILT-IN-CLAUSE
  (RULE-CLASSES)
  "To build a [clause] into the simplifier

  See [rule-classes] for a general discussion of rule classes,
  including how they are used to build rules from formulas and a
  discussion of the various keywords in a rule class description.

    Example:
    (defthm acl2-count-abl
      (and (implies (and (true-listp x)
                         (not (equal x nil)))
                    (< (acl2-count (abl x))
                       (acl2-count x)))
           (implies (and (true-listp x)
                         (not (equal nil x)))
                    (< (acl2-count (abl x))
                       (acl2-count x))))
      :rule-classes :built-in-clause)

  A [47m:built-in-clause[0m rule can be built from any formula other than
  propositional tautologies.  Roughly speaking, the system uses the
  list of built-in [clause]s as the first method of proof when
  attacking a new goal.  Any goal that is subsumed by a built in
  clause is proved ``silently.''

  ACL2 maintains a set of ``built-in'' clauses that are used to
  short-circuit certain theorem proving tasks.  We discuss this at
  length below.  When a theorem is given the rule class
  [47m:built-in-clause[0m ACL2 flattens the [47m[implies][0m and [47m[and][0m structure of
  the [47m:[0m[47m[corollary][0m formula so as to obtain a set of formulas whose
  conjunction is equivalent to the given corollary.  It then converts
  each of these to clausal form and adds each clause to the set of
  built-in clauses.

  The example above (regardless of the definition of [47mabl[0m) will build in
  two clauses,

    {(not (true-listp x))
     (equal x nil)
     (< (acl2-count (abl x)) (acl2-count x))}

  and

    {(not (true-listp x))
     (equal nil x)
     (< (acl2-count (abl x)) (acl2-count x))}.

  We now give more background.

  Recall that a clause is a set of terms, implicitly representing the
  disjunction of the terms.  Clause [47mc1[0m is ``subsumed'' by clause [47mc2[0m
  if some instance of [47mc2[0m is a subset [47mc1[0m.

  For example, let [47mc1[0m be

    {(not (consp l))
     (equal a (car l))
     (< (acl2-count (cdr l)) (acl2-count l))}.

  Then [47mc1[0m is subsumed by [47mc2[0m, shown below,

    {(not (consp x))
     ; second term omitted here
     (< (acl2-count (cdr x)) (acl2-count x))}

  because we can instantiate [47mx[0m in [47mc2[0m with [47ml[0m to obtain a subset of [47mc1[0m.

  Observe that [47mc1[0m is the clausal form of

    (implies (and (consp l)
                  (not (equal a (car l))))
             (< (acl2-count (cdr l)) (acl2-count l))),

  [47mc2[0m is the clausal form of

    (implies (consp l)
             (< (acl2-count (cdr l)) (acl2-count l)))

  and the subsumption property just means that [47mc1[0m follows trivially
  from [47mc2[0m by instantiation.

  The set of built-in clauses is just a set of known theorems in
  clausal form.  Any formula that is subsumed by a built-in clause is
  thus a theorem.  If the set of built-in theorems is reasonably
  small, this little theorem prover is fast.  ACL2 uses the
  ``built-in clause check'' in four places: (1) at the top of the
  iteration in the prover --- thus if a built-in clause is generated
  as a subgoal it will be recognized when that goal is considered,
  (2) within the simplifier so that no built-in clause is ever
  generated by simplification, (3) as a filter on the clauses
  generated to prove the termination of recursively [47m[defun][0m'd
  functions and (4) as a filter on the clauses generated to verify
  the guards of a function.

  The latter two uses are the ones that most often motivate an
  extension to the set of built-in clauses.  Frequently a given
  formalization problem requires the definition of many functions
  which require virtually identical termination and/or guard proofs.
  These proofs can be short-circuited by extending the set of
  built-in clauses to contain the most general forms of the clauses
  generated by the definitional schemes in use.

  The attentive user might have noticed that there are some recursive
  schemes, e.g., recursion by [47m[cdr][0m after testing [47m[consp][0m, that ACL2
  just seems to ``know'' are ok, while for others it generates
  measure clauses to prove.  Actually, it always generates measure
  clauses but then filters out any that pass the built-in clause
  check.  When ACL2 is initialized, the clause justifying [47m[cdr][0m
  recursion after a [47m[consp][0m test is added to the set of built-in
  clauses.  (That clause is [47mc2[0m above.)

  Note that only a subsumption check is made; no rewriting or
  simplification is done.  Thus, if we want the system to ``know''
  that [47m[cdr][0m recursion is ok after a negative [47m[atom][0m test (which, by
  the definition of [47m[atom][0m, is the same as a [47m[consp][0m test), we have
  to build in a second clause.  The subsumption algorithm does not
  ``know'' about commutative functions.  Thus, for predictability, we
  have built in commuted versions of each clause involving
  commutative functions.  For example, we build in both

    {(not (integerp x))
     (< 0 x)
     (= x 0)
     (< (acl2-count (+ -1 x)) (acl2-count x))}

  and the commuted version

    {(not (integerp x))
     (< 0 x)
     (= 0 x)
     (< (acl2-count (+ -1 x)) (acl2-count x))}

  so that the user need not worry whether to write [47m(= x 0)[0m or [47m(= 0 x)[0m
  in definitions.

  [47m:built-in-clause[0m rules added by the user can be enabled and disabled.")
 (BUTLAST
  (LISTS ACL2-BUILT-INS)
  "All but a final segment of a list

  [47m(Butlast l n)[0m is the list obtained by removing the last [47mn[0m elements
  from the true list [47ml[0m.  The following are theorems.

    (implies (and (integerp n)
                  (<= 0 n)
                  (true-listp l))
             (equal (length (butlast l n))
                    (if (< n (length l))
                        (- (length l) n)
                      0)))

    (equal (len (butlast l n)) (nfix (- (len l) (nfix n)))))

  For related functions, see [take] and see [nthcdr].

  The [guard] for [47m(butlast l n)[0m requires that [47mn[0m is a nonnegative
  integer and [47mlst[0m is a true list.

  [47mButlast[0m is a Common Lisp function.  See any Common Lisp documentation
  for more information.  Note: In Common Lisp the second argument of
  [47mbutlast[0m is optional, but in ACL2 it is required.

  [31;1mFunction: [0m<butlast>

    (defun butlast (lst n)
      (declare (xargs :guard (and (true-listp lst)
                                  (integerp n)
                                  (<= 0 n))))
      (let ((lng (len lst)) (n (nfix n)))
        (if (<= lng n)
            nil
          (take (- lng n) lst))))")
 (BY (POINTERS)
     "See [hints] for information about the keyword [47m:by[0m.")
 (CAAAAR
  (CONSES ACL2-BUILT-INS)
  "[47m[car][0m of the [47m[caaar][0m

  See any Common Lisp documentation for details.")
 (CAAADR
  (CONSES ACL2-BUILT-INS)
  "[47m[car][0m of the [47m[caadr][0m

  See any Common Lisp documentation for details.")
 (CAAAR
  (CONSES ACL2-BUILT-INS)
  "[47m[car][0m of the [47m[caar][0m

  See any Common Lisp documentation for details.")
 (CAADAR
  (CONSES ACL2-BUILT-INS)
  "[47m[car][0m of the [47m[cadar][0m

  See any Common Lisp documentation for details.")
 (CAADDR
  (CONSES ACL2-BUILT-INS)
  "[47m[car][0m of the [47m[caddr][0m

  See any Common Lisp documentation for details.")
 (CAADR
  (CONSES ACL2-BUILT-INS)
  "[47m[car][0m of the [47m[cadr][0m

  See any Common Lisp documentation for details.")
 (CAAR
  (CONSES ACL2-BUILT-INS)
  "[47m[car][0m of the [47m[car][0m

  See any Common Lisp documentation for details.")
 (CADAAR
  (CONSES ACL2-BUILT-INS)
  "[47m[car][0m of the [47m[cdaar][0m

  See any Common Lisp documentation for details.")
 (CADADR
  (CONSES ACL2-BUILT-INS)
  "[47m[car][0m of the [47m[cdadr][0m

  See any Common Lisp documentation for details.")
 (CADAR
  (CONSES ACL2-BUILT-INS)
  "[47m[car][0m of the [47m[cdar][0m

  See any Common Lisp documentation for details.")
 (CADDAR
  (CONSES ACL2-BUILT-INS)
  "[47m[car][0m of the [47m[cddar][0m

  See any Common Lisp documentation for details.")
 (CADDDR
  (CONSES ACL2-BUILT-INS)
  "[47m[car][0m of the [47m[cdddr][0m

  See any Common Lisp documentation for details.")
 (CADDR
  (CONSES ACL2-BUILT-INS)
  "[47m[car][0m of the [47m[cddr][0m

  See any Common Lisp documentation for details.")
 (CADR
  (CONSES ACL2-BUILT-INS)
  "[47m[car][0m of the [47m[cdr][0m

  See any Common Lisp documentation for details.")
 (CALLING-LD-IN-BAD-CONTEXTS
  (LD)
  "Errors caused by calling [47m[ld][0m in inappropriate contexts

  The macro [47m[ld][0m was designed to be called directly in the top-level
  ACL2 loop, although there may be a few occasions for calling it
  from functions.  ACL2 cannot cope with invocations of [47m[ld][0m during
  the process of loading a compiled file for a book, so that is an
  error.

  Specifically: ACL2 will cause an error in the following two
  circumstances:

    * when calling [47m[ld][0m inside [47m[progn!][0m unless state global [47mld-okp[0m is first
      set to [47mt[0m, e.g., using [47m(assign ld-okp t)[0m; also,

    * when calling [47mld[0m while inside raw Lisp, e.g., when loading a compiled
      file during an invocation of [47m[include-book][0m.

  Consider for example the following book, where file [47mconst.lsp[0m
  contains the single form [47m(defconst *foo* '(a b))[0m after its initial
  [47m[in-package][0m form.

    (in-package \"ACL2\")
    (defttag t)
    (progn! (ld \"const.lsp\"))

  An attempt to certify this book as follows

    (certify-book \"const-wrapper\" 0 t :ttags :all)

  will cause an error:

    ACL2 Error in LD:  It is illegal to call LD in this context.  See :DOC
    calling-ld-in-bad-contexts.

  However, that error can be avoided by expanding the [47m[progn!][0m call as
  follows.

    (progn! (assign ld-okp t)
            (ld \"const.lsp\"))

  Now certification succeeds; however, any subsequent call of
  [47m[include-book][0m will fail to load the compiled file for the book.
  Again, that is necessary because of how ACL2 is designed; in this
  case, the [47m[ld][0m call would interfere with tracking of constant
  definitions when loading the compiled file for the book.  To avoid
  warnings about loading compiled files, either certify the book
  without creating a compiled file or else include the book without
  loading the compiled file; see [certify-book] and [include-book].

  Note that it is legal to put a definition such as the following into
  a book, where [47mld[0m is called in the body of a function; the two
  conditions above do not prohibit this.

    (defun foo (state)
      (declare (xargs :guard t :stobjs state :mode :program))
      (ld '((defun h (x) x)) :ld-user-stobjs-modified-warning t))

  One can then include the book, evaluate [47m(foo state)[0m, and then
  evaluate calls of [47mh[0m.")
 (CANONICAL-PATHNAME
  (PROGRAMMING-WITH-STATE ACL2-BUILT-INS)
  "The true absolute filename, with soft links resolved

  For the name [47mfname[0m of a file, the form [47m(canonical-pathname fname nil
  state)[0m evaluates to a Unix-style absolute filename representing the
  same file as [47mfname[0m, but generally without any use of soft links in
  the name.  (Below, we explain the qualifier ``generally''.)  If
  however the file indicated by [47mfname[0m does not exist,
  [47m(canonical-pathname fname nil state)[0m is [47mnil[0m.  Thus,
  [47mcanonical-pathname[0m can be used as one would use the raw Lisp
  function [47mprobe-file[0m.

  The specification of [47m(canonical-pathname fname dir-p state)[0m when
  [47mdir-p[0m is not [47mnil[0m is similar, except that if the specified file
  exists but is not a directory, then the result is [47mnil[0m.

  The function [47mcanonical-pathname[0m has a guard of [47mt[0m, though the second
  argument must be the ACL2 [47m[state][0m.  This function is introduced
  with the following properties.

    (defthm canonical-pathname-is-idempotent
      (equal (canonical-pathname (canonical-pathname x dir-p state) dir-p state)
             (canonical-pathname x dir-p state)))
    (defthm canonical-pathname-type
      (or (equal (canonical-pathname x dir-p state) nil)
          (stringp (canonical-pathname x dir-p state)))
      :rule-classes :type-prescription)

  We use the qualifier ``generally'', above, because there is no
  guarantee that the filename will be canonical without soft links,
  though we expect this to be true in practice.  ACL2 attempts to
  compute the desired result and then checks that the input and
  result have the same Common Lisp ``[47mtruename[0m''.  This check is
  expected to succeed, but if it fails then the input string is
  returned unchanged, and to be conservative, the value returned is
  [47mnil[0m in this case if [47mdir-p[0m is true.")
 (CAR
  (CONSES ACL2-BUILT-INS)
  "Returns the first element of a non-empty list, else [47mnil[0m

  Completion Axiom ([47mcompletion-of-car[0m):

    (equal (car x)
           (cond
            ((consp x)
             (car x))
            (t nil)))

  [Guard]:

    (or (consp x) (equal x nil))

  Notice that in the ACL2 logic, [47mcar[0m returns [47mnil[0m for every [atom].")
 (CASE (BASICS ACL2-BUILT-INS)
  "Conditional based on if-then-else using [47m[eql][0m

    Example Form:
    (case typ
      ((:character foo)
       (open file-name :direction :output))
      (bar (open-for-bar file-name))
      (otherwise
       (my-error \"Illegal.\")))

  is the same as

    (cond ((member typ '(:character foo))
           (open file-name :direction :output))
          ((eql typ 'bar)
           (open-for-bar file-name))
          (t (my-error \"Illegal.\")))

  which in turn is the same as

    (if (member typ '(:character foo))
        (open file-name :direction :output)
        (if (eql typ 'bar)
            (open-for-bar file-name)
            (my-error \"Illegal.\")))

  Notice the quotations that appear in the example above: [47m'(:character
  foo)[0m and [47m'bar[0m.  Indeed, a [47mcase[0m expression expands to a [47m[cond][0m
  expression in which each tested form is quoted, and [47m[eql][0m is used
  to test equality, as described below..

    General Forms:
    (case expr
      (x1 val-1)
      ...
      (xk val-k)
      (otherwise val-k+1))

    (case expr
      (x1 val-1)
      ...
      (xk val-k)
      (t val-k+1))

    (case expr
      (x1 val-1)
      ...
      (xk val-k))

  where each [47mxi[0m is either [47m[eqlablep][0m or a true list of [47m[eqlablep][0m
  objects.  The final [47motherwise[0m or [47mt[0m case is optional; if neither is
  present, then an equivalent expression results from adding the
  final case [47m(t nil)[0m.

  As suggested above, each case [47m(xi val-i)[0m generates an if-then-else
  expression as follows.  If [47mxi[0m is a non-nil atom (i.e., [47mxi[0m is not
  [47mnil[0m or a cons pair), then that case generates the expression [47m(if
  (eql expr (quote xi)) vali ...)[0m where `[47m...[0m' denotes the expression
  generated by the rest of the cases.  If however [47mxi[0m is a list, then
  instead the generated expression is [47m(if (member expr (quote xi))
  vali ...)[0m.  The final case [47m(t val-k+1)[0m or [47m(otherwise val-k+1)[0m
  generates [47mval-k+1[0m.  Note that [47mt[0m and [47motherwise[0m here must be in the
  [47m\"ACL2\"[0m package.  Also note that to compare [47mexpr[0m with [47mnil[0m, you
  should write the case as [47m((nil) val-i)[0m rather than [47m(nil val-i)[0m ---
  and similarly for [47mt[0m or [47motherwise[0m --- that is, put the symbol in a
  list.

  [47mCase[0m is defined in Common Lisp.  See any Common Lisp documentation
  for more information.")
 (CASE-MATCH (BASICS ACL2-BUILT-INS)
  "Pattern matching or destructuring

    General Form:
    (case-match x
      (pat1 dcl1 ... body1)
      ...
      (patk dclk ... bodyk))

  where [47mx[0m is a symbol, the [47mpati[0m are structural patterns as described
  below, each ``[47mdcli ...[0m'' indicates 0 or more [47m[declare][0m forms, and
  the [47mbodyi[0m are terms.  The legal [47mdeclare[0m forms are the same as for
  [47m[let][0m: [47mignore[0m, [47mignorable[0m, and [47mtype[0m.  Return the value(s) of the
  [47mbodyi[0m corresponding to the first [47mpati[0m matching [47mx[0m, or [47mnil[0m if none
  matches.

  Pattern Language:
  With the few special exceptions described below, matching requires
  that the [47m[cons][0m structure of [47mx[0m be isomorphic to that of the
  pattern, down to the [atom]s in the pattern.  Non-symbol [atom]s in
  the pattern match only themselves.  Symbols in the pattern denote
  variables which match anything and which are bound by a successful
  match to the corresponding substructure of [47mx[0m.  Variables that occur
  more than once must match the same ([47m[equal][0m) structure in every
  occurrence.

    Exceptions:
    &               Matches anything and is not bound.  Repeated
                      occurrences of & in a pattern may match different
                      structures.
    nil, t, *sym*, :sym
                    These symbols cannot be bound and match only their
                      global values.
    !sym            where sym is a symbol that is already bound in the
                      context of the case-match, matches only the
                      current binding of sym.
    'obj            Matches only itself.  This is the same as (QUOTE obj).
    (QUOTE~ sym)    where sym is a symbol, is like (QUOTE sym) except it
                      matches any symbol with the same symbol-name as sym.
                      Note that QUOTE~ is in the \"ACL2\" package.

  Some examples are shown below.

  Below we show some sample patterns and examples of things they match
  and do not match.

    pattern       matches         non-matches
    (x y y)       (ABC 3 3)       (ABC 3 4)    ; 3 is not 4
    (fn x . rst)  (P (A I) B C)   (ABC)        ; NIL is not (x . rst)
                  (J (A I))                    ; rst matches nil
    ('fn (g x) 3) (FN (H 4) 3)    (GN (G X) 3) ; 'fn matches only itself
    (& t & !x)    ((A) T (B) (C))              ; provided x is '(C)

  Consider the two binary trees that contain three leaves.  They might
  be described as [47m(x . (y . z))[0m and [47m((x . y) . z)[0m, where [47mx[0m, [47my[0m, and [47mz[0m
  are atomic.  Suppose we wished to recognize those trees.  The
  following [47mcase-match[0m would do:

    (case-match tree
      ((x . (y . z))
       (and (atom x) (atom y) (atom z)))
      (((x . y) . z)
       (and (atom x) (atom y) (atom z))))

  Suppose we wished to recognize such trees where all three tips are
  identical.  Suppose further we wish to return the tip if the tree
  is one of those recognized ones and to return the number [47m7[0m
  otherwise.

    (case-match tree
      ((x . (x . x))
       (if (atom x) x 7))
      (((x . x) . x)
       (if (atom x) x 7))
      (& 7))

  Note that [47mcase-match[0m returns [47mnil[0m if no [47mpati[0m matches.  Thus if we must
  return [47m7[0m in that case, we have to add as the final pattern the [47m&[0m,
  which always matches anything.

  Technical point: The symbol [47msym[0m referenced by the symbol [47m!sym[0m is in
  the same package as [47m!sym[0m but with the leading exclamation point
  character, [47m\\#![0m, removed from the [47m[symbol-name][0m of [47m!sym[0m.")
 (CASE-SPLIT
  (REWRITE LINEAR TYPE-PRESCRIPTION
           DEFINITION META FORWARD-CHAINING)
  "Like force but immediately splits the top-level goal on the
  hypothesis

  [47mCase-split[0m is a variant of [47m[force][0m, which has similar special
  treatment in hypotheses of rules for the same [rule-classes] as for
  [47mforce[0m (see [force]).  This treatment takes place for rule classes
  [47m:[0m[47m[rewrite][0m, [47m:[0m[47m[linear][0m, [47m:[0m[47m[type-prescription][0m, [47m:[0m[47m[definition][0m, [47m:[0m[47m[meta][0m
  (actually in that case, the result of evaluating the hypothesis
  metafunction call), and [47m:[0m[47m[forward-chaining][0m.

  When a hypothesis of a conditional rule (of one of the classes listed
  above) has the form [47m(case-split hyp)[0m it is logically equivalent to
  [47mhyp[0m.  However it affects the application of the rule generated as
  follows: if ACL2 attempts to apply the rule but cannot establish
  that the required instance of [47mhyp[0m holds in the current context, it
  considers the hypothesis true anyhow, but (assuming all hypotheses
  are seen to be true and the rule is applied) creates a subgoal in
  which that instance of [47mhyp[0m is assumed false.  (There are
  exceptions, noted below.)

  For example, given the rule

    (defthm p1->p2
      (implies (case-split (p1 x))
               (p2 x)))

  then an attempt to prove

    (implies (p3 x) (p2 (car x)))

  can give rise to a single subgoal:

    (IMPLIES (AND (NOT (P1 (CAR X))) (P3 X))
             (P2 (CAR X))).

  Unlike [47m[force][0m, [47mcase-split[0m does not delay the ``false case'' to a
  forcing round but tackles it more or less immediately.

  The special ``split'' treatment of [47mcase-split[0m can be disabled by
  disabling forcing: see [force] for a discussion of disabling
  forcing, and also see [disable-forcing].  Finally, we should
  mention that the rewriter is never willing to split when there is
  an [47m[if][0m term present in the goal being simplified.  Since [47m[and][0m
  terms and [47m[or][0m terms are merely abbreviations for [47m[if][0m terms, they
  also prevent splitting.  Note that [47m[if][0m terms are ultimately
  eliminated using the ordinary flow of the proof (but see
  [set-case-split-limitations]), so [47mcase-split[0m will ultimately
  function as intended.

  When in the interactive [proof-builder], [47mcase-split[0m behaves like
  [47mforce[0m.

  [31;1mFunction: [0m<case-split>

    (defun case-split (x)
      (declare (xargs :guard t))
      x)")
 (CASE-SPLIT-LIMITATIONS
  (MISCELLANEOUS)
  "Limiting the number of immediate subgoals

    Examples:
    ACL2 !>(case-split-limitations (w state))
    (500 100)

  With the setting above, which is the default, [47mclausify[0m will not try
  subsumption/replacement if more than 500 [clause]s are involved.
  Furthermore, the simplifier, as it sweeps over a clause, will
  inhibit further case splits when it has accumulated 100 subgoals.
  To implement this inhibition, ACL2 refuses to rewrite subsequent
  literals, although it continues to split on any [47mIF[0m calls in those
  literals.

  The following example illustrates how the latter restriction ---
  specifically, not rewriting subsequent literals to avoid further
  case splits --- can work.  We define a (rather nonsensical)
  function whose body introduces several cases.

    (defun f1 (a b c)
      (if a
          (if b (equal c 0) (equal c 1))
        (if b (equal c 2) (equal c 3))))

    (set-case-split-limitations '(500 10))

    (set-gag-mode nil)

    (thm (or (equal (f1 a b c) xxx)
             (equal (f1 d e f) yyy)
             (equal (f1 g h i) zzz))
         :hints ((\"Goal\" :in-theory (disable f1))
                 (\"Goal'\" :in-theory (enable f1)))
         :otf-flg t)

  We show the output below.  The simplification of the original goal to
  Goal' replaces the original goal, which is the clause (i.e.,
  disjunction) consisting of the single literal (i.e., term) shown
  above, to the clause consisting of three literals, namely, the
  list:

    ; Goal', as a clause (disjunction of three literals)
    ((EQUAL (F1 A B C) XXX)
     (EQUAL (F1 D E F) YYY)
     (EQUAL (F1 G H I) ZZZ))

  That simplification is reflected in the value printed (as an
  implication) for Goal' in the output, below.  If we omit the call
  of [47m[set-case-split-limitations][0m above, then we get 64 cases, from
  opening up the calls of [47mf1[0m and splitting on the variables [47ma[0m, [47mb[0m, [47md[0m,
  [47me[0m, [47mg[0m, and [47mh[0m.  But with the limit of 10 provided by
  set-case-split-limitations above, fewer cases are generated because
  rewriting of literals is inhibited, as explained below.  Here is
  the first part of the output for that limit of 10.

    [Note:  A hint was supplied for the goal above.  Thanks!]

    This simplifies, using trivial observations, to

    [Note:  A hint was supplied for the goal below.  Thanks!]

    Goal'
    (IMPLIES (AND (NOT (EQUAL (F1 A B C) XXX))
                  (NOT (EQUAL (F1 D E F) YYY)))
             (EQUAL (F1 G H I) ZZZ)).

    This simplifies, using the :definition F1 (if-intro), to the following
    thirteen conjectures.

    Subgoal 13
    (IMPLIES (AND A B (NOT (EQUAL (EQUAL C 0) XXX))
                  (NOT (EQUAL (F1 D E F) YYY)))
             (EQUAL (F1 G H I) ZZZ)).

  Why, though, are there 13 cases, even though the limit was specified
  as 10?  Initially, the first literal [47m(EQUAL (F1 A B C) XXX)[0m was
  rewritten, splitting into four cases; and for each of those cases,
  the second literal was rewritten, splitting further; and so on.
  However, the first time more than 10 cases were generated was when
  there were 10 cases generated so far and a literal generated four
  cases --- then since that one literal generated four cases, 4-1 = 3
  cases were added to the 10 already generated.  From that point on,
  further rewriting of literals did not take place.

  In short: the first time a literal splits into enough cases so that
  the accumulated number of cases exceeds the limit, rewriting stops
  --- but that last split can put us significantly past the limit
  specified.

  See [set-case-split-limitations] for a more general discussion.")
 (CASES (POINTERS)
        "See [hints] for information about the keyword [47m:cases[0m.")
 (CBD
  (BOOKS-REFERENCE PROGRAMMING-WITH-STATE ACL2-BUILT-INS)
  "Connected book directory string

    Example:
    ACL2 !>:cbd
    \"/usr/home/smith/\"

  The connected book directory (``cbd'') is a string ending with the [47m/[0m
  character that specifies a directory as an absolute pathname.  (See
  [pathname] for a discussion of file naming conventions.)  When
  utilities that take a filename argument, such as [47m[include-book][0m,
  are given a relative pathname, it is elaborated into an absolute
  pathname, essentially by appending the connected book directory
  string to the left and [47m\".lisp\"[0m to the right.  (This absolute
  pathname is actually canonical when elaborating book names.  For
  more details on book names, see [book-name] and also see
  [full-book-name].)  Furthermore, [47m[include-book][0m and [47m[ld][0m
  temporarily set the connected book directory to the directory
  string of the resulting full pathname so that references to files
  in the same directory may omit the directory.  See [set-cbd] for
  how to set the connected book directory string.

  Note that the cbd is used for elaborating every [pathname] argument,
  not just a pathname that represents a book.  (Technical remark:
  Some utilities, such as [47m[open-input-channel][0m, use the cbd
  indirectly as follows.  That utility uses the Common Lisp utility,
  [47mopen[0m, which knows nothing about the cbd.  However, ACL2 arranges
  that the Lisp global [47m*default-pathname-defaults*[0m always has the cbd
  as its value, and Lisp uses that global to elaborate relative
  pathnames much as ACL2 uses the cbd.)

    General Form:
    (cbd)

  This is a macro that expands into a term involving the single free
  variable [47m[state][0m.  It returns the connected book directory string.

  For example, if the [47mcbd[0m is [47m\"/usr/home/smith/\"[0m then the [book-name]
  [47m\"project/task-1/arith\"[0m is elaborated using the [47mcbd[0m to the
  [full-book-name] [47m\"/usr/home/smith/project/task-1/arith.lisp\"[0m, which
  is what [include-book] opens to read the source text for the book.

  The [47mcbd[0m may be changed using [47m[set-cbd][0m.

  As noted above, during the processing of the [events] in a book,
  [47m[include-book][0m sets the [47mcbd[0m to be the directory string of the
  [full-book-name] of the book; similarly for [47m[ld][0m.  Thus, if the [47mcbd[0m
  is [47m\"/usr/home/smith/\"[0m then during the processing of [events] by

    (include-book \"project/task-1/arith\")

  the [47mcbd[0m will be set to [47m\"/usr/home/smith/project/task-1/\"[0m.  Note that
  if [47m\"arith\"[0m recursively includes a sub-book, say [47m\"naturals\"[0m, that
  resides on the same directory, the [47m[include-book][0m event for it may
  omit the specification of that directory.  For example, [47m\"arith\"[0m
  might contain the event

    (include-book \"naturals\").

  In general, suppose we have a superior book and several inferior
  [books] which are included by [events] in the superior book.  Any
  inferior book residing on the same directory as the superior book
  may be referenced in the superior without specification of the
  directory.

  We call this a ``relative'' as opposed to ``absolute'' naming.  The
  use of relative naming is preferred because it permits [books] (and
  their accompanying inferiors) to be moved between directories while
  maintaining their [certificate]s and utility.  Certified [books]
  that reference inferiors by absolute file names are unusable (and
  rendered uncertified) if the inferiors are moved to new
  directories.")
 (CCL-INSTALLATION
  (BUILDING-ACL2)
  "Installing Clozure Common Lisp (CCL)

  For those who use ACL2 built on CCL as the host Common Lisp
  implementation, it has been common practice to use the latest
  GitHub version of CCL.  We provide the following instructions for
  you to choose from.  The ``brief'' instructions for Linux or Mac
  (according to your operating system) might well suffice; the
  ``elaborate'' instructions have helped with version control.

    * [ccl-installation-linux-brief]

    * [ccl-installation-mac-brief]

    * [ccl-installation-linux-elaborate]

    * [ccl-installation-mac-elaborate]

  You may prefer instead to look at the {CCL Releases |
  https://github.com/Clozure/ccl/releases} page, which has
  potentially more up-to-date information; then you can use the links
  above only as needed (e.g., for Linux-specific information or for
  discussion of [47mCCL_DEFAULT_DIRECTORY[0m).

  One of the links listed above should generally suffice.  But if you
  would like additional information on CCL installation and
  implementation, see [ccl-installation-extra].


Subtopics

  [Ccl-installation-extra]
      Clozure Common Lisp (CCL) installation and implementation details

  [Ccl-installation-linux-brief]
      Installing Clozure Common Lisp (CCL) on Linux (brief version)

  [Ccl-installation-linux-elaborate]
      Installing Clozure Common Lisp (CCL) on Linux (elaborate version)

  [Ccl-installation-mac-brief]
      Installing Clozure Common Lisp (CCL) on Mac (brief version)

  [Ccl-installation-mac-elaborate]
      Installing Clozure Common Lisp (CCL) on Mac (elaborate version)")
 (CCL-INSTALLATION-EXTRA
  (CCL-INSTALLATION)
  "Clozure Common Lisp (CCL) installation and implementation details

  [31;1mNOTE[0m: See {the Clozure CL releases page |
  https://github.com/Clozure/ccl/releases/} for the latest
  information, which may supersede some of what is included below.

  This topic, contributed by Warren A. Hunt, Jr., extends the basic
  information given in [ccl-installation].  It may be useful to some,
  especially those who use ACL2 in ways that particularly stress
  memory.  Another resource may be found on {this page |
  https://github.com/Clozure/ccl/releases/}.

  Below we provide instructions to build CCL on FreeBSD and MacOS;
  building on Linux will be similar.  Before providing the build
  instructions, we mention a few facts about CCL's implementation.

  CCL's implementation can't expand stack space automatically.  The
  sizes of various stacks are set at thread creation time.  Most
  programs don't need very big stacks.  The CCL default value and
  temp stack sizes may be too small for compute-intensive
  applications.

  The various stack sizes are set when creating a thread with code in
  [47mCCL::MAKE-PROCESS[0m and [47mCCL::PROCESS-RUN-FUNCTION[0m, and they set the
  three stack sizes of the initial listener thread that is created
  when CCL starts.

  The value stack is used for data in deeply-nested lisp recursion.
  ACL2 can benefit from an increase in the size of the value stack.

  The temp stack is used for dynamic-extent objects.  This might need
  need to be larger than the default.

  The control stack is used to run C and binary code; it would be
  surprising to need to increase its size.

  If only one or two threads are needed, giant (e.g., 4 GB) stacks can
  be OK, but with many threads large stacks use lots of memory.
  Below are the stacks along with their current (April, 2020) default
  sizes.

    ccl::*default-control-stack-size*                    ;; default 2^21
    ccl::*initial-listener-default-control-stack-size*   ;; default 2^21

    ccl::*default-value-stack-size*                      ;; default 2^21
    ccl::*initial-listener-default-value-stack-size*     ;; default 2^21

    ccl::*initial-listener-default-temp-stack-size*      ;; default 2^20
    ccl::*default-temp-stack-size*                       ;; default 2^20

  If we are running on a 32-bit platform, we set the stack sizes
  modestly.  If we are on a 64-bit platform, we set the stack sizes
  to much larger values.  See the later discussion about
  ``configure-ccl.lisp'' below to see how to alter (increase) stack
  sizes.


MacOS Build Instructions:

    git clone https://github.com/Clozure/ccl.git ccl-dev
    curl -L -O https://github.com/Clozure/ccl/releases/download/v1.12-dev.5/darwinx86.tar.gz
    cd ccl-dev ; tar xf ../darwinx86.tar.gz

  Rebuild C-based, Lisp kernel

  To rebuild the Lisp-code part of the kernel, do...

    cd lisp-kernel/darwinx8664 ; make ; cd ../..

  Unlike for FreeBSD and Linux, we exclude ``:full t'' from the
  ``rebuild-ccl'' command just below Matt Emerson (a CCL expert)
  writes:

      After looking at your log, I was able to duplicate the problem
      myself.  For some reason I do not understand, it appears that
      on Catalina, removing the running lisp kernel binary causes
      run-program to break (trying to run external programs gets
      signal 9).  This surprises me very much.

      One of the effects of running (rebuild-ccl :full t), is that it first
      does a \"make clean\" in the lisp kernel directory, and then does
      a regular make.  This has worked for years, and I do not know
      why it has stopped working.

  To avoid this, rebuild the lisp with (rebuild-ccl :clean t) instead.
  Do not specify ``[47m:full t[0m''.  Since you have already built the lisp
  kernel, you gain nothing from ``[47m:full t[0m'' doing it again.  So, once
  the C-based, Lisp kernel is built, then do:

    echo \"(in-package :ccl) (rebuild-ccl :verbose t :clean t)\" | \\
          ./dx86cl64 -n |& tee ./ccl-build-compile.log

  Matt Emerson suggests that one re-build again.  We asked Matt a
  long-simmering question: we have been told that it is a good idea
  to compile CCL twice.  Is that so that the CCL compiler produced by
  pass one on the target system is used to compile the CCL system
  that will be used (on the target system)?  Or, is compiling twice
  some silly myth?  Matt Emerson responded:

      It's not entirely mythic.  Some rare changes do need the lisp to be
      rebuilt twice for bootstrapping purposes, but usually it isn't
      required.

  Thus, we recommend you re-build (compile) the Lisp code again.

    echo \"(in-package :ccl) (rebuild-ccl :verbose t :clean t)\" | \\
          ./dx86cl64 -n |& tee ./ccl-build-compile-2.log

  Finally, one may specialize the final image by:

    cat configure-ccl.lisp | ./dx86cl64 -n |& tee ~/ccl-build-specialize.log

  where ``configure-ccl.lisp'' (not supplied) contains whatever CCL
  specialization commands you wish to have in the version of CCL you
  use for ACL2 or other work.  See the end of this note for an
  example of ``configure-ccl.lisp''.


FreeBSD Build Instructions:

  The FreeBSD build instructions are similar to the MacOS build
  instruction, but the names are changed appropriately.

    git clone https://github.com/Clozure/ccl.git ccl-dev
    curl -L -O https://github.com/Clozure/ccl/releases/download/v1.12-dev.5/freebsd12-x8664.tar.gz
    cd ccl-dev
    tar xf ../freebsd12-x8664.tar.gz

  Rebuild C-based Lisp kernel

    cd lisp-kernel/freebsdx8664 ; make ; cd ../..

  To rebuild the Lisp-code part of the kernel, do...

    echo \"(in-package :ccl) (rebuild-ccl :full t :verbose t :clean t)\" | \\
          ./fx86cl64 -n |& tee ./ccl-build-compile.log

  FreeBSD is OK with the ``:full t'' flag, which as of MacOS 10.15
  breaks (but used to work on earlier versions of MacOS).  So, this
  option persists on the FreeBSD build.

  Matt Emerson recommends building the Lisp code a second time; see the
  ``MacOS Build Instructions'' above for his rationale.

    echo \"(in-package :ccl) (rebuild-ccl :full t :verbose t :clean t)\" | \\
          ./fx86cl64 -n |& tee ./ccl-build-compile-2.log

  Finally, one may specialize the final image by:

    cat ~/a/scripts/configure-ccl.lisp | ./fx86cl64 -n |& tee ~/ccl-build-specialize.log

  where ``configure-ccl.lisp'' (not supplied) contains whatever CCL
  specialization commands you wish to have in the version of CCL you
  use for ACL2 or other work.


configure-ccl.lisp

  Sample ``configure-ccl.lisp'' file for 64-bit implementation:

    (progn
      ;; Parameters to configure CCL for use on FreeBSD and MacOS

      (in-package :ccl)

      ;; Enlarge stack sizes
      (setq *default-value-stack-size*                    (expt 2 28))
      (setq *initial-listener-value-stack-size*           (expt 2 28))

      (setq *default-temp-stack-size*                     (expt 2 24))
      (setq *initial-listener-temp-stack-size*            (expt 2 24))

      (setq *default-control-stack-size*                  (expt 2 24))
      (setq *initial-listener-default-control-stack-size* (expt 2 24))

      ;; For CCL double precision
      (setf *read-default-float-format* 'double-float)

      ;; Make DEFUN save the source code for later recovery via
      ;; FUNCTION-LAMBDA-EXPRESSION.
      (setq *save-definitions* t)
      (setq *fasl-save-definitions* t)

      ;; Make GC verbose; see ACL2 documentation topic GC-VERBOSE.
      (gc-verbose t t)

      ;; Dump executable heap image; see ACL2 documentation topic SAVE-EXEC.
      (save-exec *heap-image-name* \"Modification string to print at startup\")
      )")
 (CCL-INSTALLATION-LINUX-BRIEF
  (CCL-INSTALLATION)
  "Installing Clozure Common Lisp (CCL) on Linux (brief version)

  [31;1mNOTE:[0m See {the Clozure CL releases page |
  https://github.com/Clozure/ccl/releases/} for the latest
  information, which probably supersedes what is included below.

  See [ccl-installation] for introductory remarks.  The instructions
  below describe how to install CCL on Linux.  For more elaborate
  ``cookbook'' instructions see [ccl-installation-linux-elaborate].

  [31;1mNote[0m: Linux users may need to install m4.

  Fetch CCL from GitHub into a fresh subdirectory, [47mccl/[0m.

    git clone https://github.com/Clozure/ccl

  Next fetch and extract a development snapshot in the new [47mccl[0m
  directory.  [31;1mWARNING.[0m The version below is current as of this
  writing (November, 2023), but see
  {https://github.com/Clozure/ccl/releases/ |
  https://github.com/Clozure/ccl/releases/} for the latest snapshots;
  in particular, [47m\"v1.12.2\"[0m below could change, e.g., to [47m\"v1.12.3\"[0m or
  [47m\"v1.13\"[0m.

    cd ccl
    wget https://github.com/Clozure/ccl/releases/download/v1.12.2/linuxx86.tar.gz
    tar xfz linuxx86.tar.gz

  Rebuild and quit, twice.

    echo '(rebuild-ccl :full t)' | ./lx86cl64
    echo '(rebuild-ccl :full t)' | ./lx86cl64

  Create the following executable script, which you will probably want
  to name [47m\"ccl\"[0m, where [47m<DIR>[0m is the absolute pathname (without using
  ``[47m~[0m'') of the directory in which you issued the ``[47mgit clone[0m''
  command.  Place this script wherever you wish, though putting it in
  a directory on your Unix [47mPATH[0m might be helpful (since then you can
  invoke it as, say [47m\"ccl\"[0m).

    #!/bin/sh

    export CCL_DEFAULT_DIRECTORY=<DIR>/ccl
    ${CCL_DEFAULT_DIRECTORY}/scripts/ccl64 \"$@\"

  You're done!  (Note however that certification of [books] that use
  [Quicklisp] may require [47mopenssl[0m to be installed if it is not
  already on your system.)")
 (CCL-INSTALLATION-LINUX-ELABORATE
  (CCL-INSTALLATION)
  "Installing Clozure Common Lisp (CCL) on Linux (elaborate version)

  [31;1mNOTE:[0m See {the Clozure CL releases page |
  https://github.com/Clozure/ccl/releases/} for the latest
  information, which may well supersede what is included below.

  See [ccl-installation] for introductory remarks.  The ``cookbook''
  instructions below give you one way to install CCL on Linux without
  any knowledge of git or CCL.  For more streamlined instructions see
  [ccl-installation-linux-brief].

  [31;1mNote[0m: Linux users may need to install m4.

  First fetch CCL from GitHub as follows.  (You may prefer to use ``[47mgit
  pull[0m'' if you previously did this step.  In that case you probably
  won't want to do the optional renaming of the directory, mentioned
  below.)

    # Obtain a ccl distribution in a fresh directory:
    mkdir temp
    cd temp
    git clone https://github.com/Clozure/ccl
    # Optionally rename that directory as suggested below, after
    # executing the following three commands.
    cd ccl
    git rev-parse HEAD
    cd ../../
    # Optionally change directory name, and then go back to ccl directory:
    # You'll want the last 10 hex digits to match those of the
    # output from the ``git rev-parse HEAD'' command above: do
    # that twice here and once further below.
    mv temp 2017-12-07-6be8298fe5
    cd 2017-12-07-6be8298fe5/ccl

  Next fetch and extract a development snapshot in the new [47mccl[0m
  directory.  [31;1mWARNING.[0m The version below is current as of this
  writing (November, 2023), but see
  {https://github.com/Clozure/ccl/releases/ |
  https://github.com/Clozure/ccl/releases/} for the latest snapshots;
  in particular, [47m\"v1.12.2\"[0m below could change, e.g., to [47m\"v1.12.3\"[0m or
  [47m\"v1.13\"[0m.

    wget https://github.com/Clozure/ccl/releases/download/v1.12.2/linuxx86.tar.gz
    tar xfz linuxx86.tar.gz

  Rebuild and quit, twice.

    echo '(rebuild-ccl :full t)' | ./lx86cl64
    echo '(rebuild-ccl :full t)' | ./lx86cl64

  Create an executable script like the following.  You might want to
  call it ``[47mccl[0m'' and put it into a directory on your path.  Be sure
  to change the name (shown as ``2017-12-07-6be8298fe5'' above) to
  match the name change already made above.

    #!/bin/sh

    export CCL_DEFAULT_DIRECTORY=/projects/acl2/lisps/ccl/2017-12-07-6be8298fe5/ccl
    ${CCL_DEFAULT_DIRECTORY}/scripts/ccl64 \"$@\"

  Now ensure that your script is executable, e.g.:

    chmod +x my-script

  You're done!  (Note however that certification of [books] that use
  [Quicklisp] may require [47mopenssl[0m to be installed if it is not
  already on your system.)")
 (CCL-INSTALLATION-MAC-BRIEF
  (CCL-INSTALLATION)
  "Installing Clozure Common Lisp (CCL) on Mac (brief version)

  [31;1mNOTE:[0m See {the Clozure CL releases page |
  https://github.com/Clozure/ccl/releases/} for the latest
  information, which probably supersedes what is included below.

  See [ccl-installation] for introductory remarks.  The instructions
  below describe how to install CCL on a Mac (Darwin).  For more
  elaborate ``cookbook'' instructions see
  [ccl-installation-mac-elaborate].

  Fetch CCL from GitHub into a fresh subdirectory, [47mccl/[0m.

    git clone https://github.com/Clozure/ccl

  Next fetch and extract a development snapshot in the new [47mccl[0m
  directory.  [31;1mWARNING.[0m The version below is current as of this
  writing (November, 2023), but see
  {https://github.com/Clozure/ccl/releases/ |
  https://github.com/Clozure/ccl/releases/} for the latest snapshots;
  in particular, [47m\"v1.12.2\"[0m below could change, e.g., to [47m\"v1.12.3\"[0m or
  [47m\"v1.13\"[0m.

    cd ccl
    curl -O -L https://github.com/Clozure/ccl/releases/download/v1.12.2/darwinx86.tar.gz
    tar xfz darwinx86.tar.gz

  Rebuild the lisp kernel by hand before trying to rebuild the lisp.

    cd lisp-kernel/darwinx8664; make clean; make
    cd -

  Rebuild and quit, twice.

    echo '(rebuild-ccl :clean t)' | ./dx86cl64
    echo '(rebuild-ccl :clean t)' | ./dx86cl64

  Create the following executable script, which you will probably want
  to name [47m\"ccl\"[0m, where [47m<DIR>[0m is the absolute pathname (without using
  ``[47m~[0m'') of the directory in which you issued the ``[47mgit clone[0m''
  command.  Place this script wherever you wish, though putting it in
  a directory on your Unix [47mPATH[0m might be helpful (since then you can
  invoke it as, say [47m\"ccl\"[0m).

    #!/bin/sh

    export CCL_DEFAULT_DIRECTORY=<DIR>/ccl
    ${CCL_DEFAULT_DIRECTORY}/scripts/ccl64 \"$@\"

  You're done!  (Note however that certification of [books] that use
  [Quicklisp] may require [47mopenssl[0m to be installed if it is not
  already on your system.)")
 (CCL-INSTALLATION-MAC-ELABORATE
  (CCL-INSTALLATION)
  "Installing Clozure Common Lisp (CCL) on Mac (elaborate version)

  [31;1mNOTE:[0m See {the Clozure CL releases page |
  https://github.com/Clozure/ccl/releases/} for the latest
  information, which may well supersede what is included below.

  See [ccl-installation] for introductory remarks.  The ``cookbook''
  instructions below give you one way to install CCL on a Mac
  (Darwin) without any knowledge of git or CCL.  For more streamlined
  instructions see [ccl-installation-mac-brief].

  First fetch CCL from GitHub as follows.  (You may prefer to use ``[47mgit
  pull[0m'' if you previously did this step.  In that case you probably
  won't want to do the optional renaming of the directory, mentioned
  below.)

    # Obtain a ccl distribution in a fresh directory:
    mkdir temp
    cd temp
    git clone https://github.com/Clozure/ccl
    # Optionally rename that directory as suggested below, after
    # executing the following three commands.
    cd ccl
    git rev-parse HEAD
    cd ../../
    # Optionally change directory name, and then go back to ccl directory:
    # You'll want the last 10 hex digits to match those of the
    # output from the ``git rev-parse HEAD'' command above: do
    # that twice here and once further below.
    mv temp 2017-12-07-6be8298fe5
    cd 2017-12-07-6be8298fe5/ccl

  Next fetch and extract a development snapshot in the new [47mccl[0m
  directory.  [31;1mWARNING.[0m The version below is current as of this
  writing (November, 2023), but see
  {https://github.com/Clozure/ccl/releases/ |
  https://github.com/Clozure/ccl/releases/} for the latest snapshots;
  in particular, [47m\"v1.12.2\"[0m below could change, e.g., to [47m\"v1.12.3\"[0m or
  [47m\"v1.13\"[0m.

    curl -L -O https://github.com/Clozure/ccl/releases/download/v1.12.2/darwinx86.tar.gz
    tar xfz darwinx86.tar.gz

  Rebuild the lisp kernel by hand before trying to rebuild the lisp.
  (Note: This step was formerly unnecessary and might become
  unnecessary again, but it seems to have been necessary on MacOS
  Catalina (10.15).

    cd lisp-kernel/darwinx8664; make clean; make
    cd -

  Rebuild and quit, twice.

    echo '(rebuild-ccl :clean t)' | ./dx86cl64
    echo '(rebuild-ccl :clean t)' | ./dx86cl64

  Create an executable script like the following.  You might want to
  call it ``[47mccl[0m'' and put it into a directory on your path.  Be sure
  to change the name (shown as ``2017-12-07-6be8298fe5'' above) to
  match the name change already made above.

    #!/bin/sh

    export CCL_DEFAULT_DIRECTORY=/projects/acl2/lisps/ccl/2017-12-07-6be8298fe5/ccl
    ${CCL_DEFAULT_DIRECTORY}/scripts/ccl64 \"$@\"

  Now ensure that your script is executable, e.g.:

    chmod +x my-script

  You're done!  (Note however that certification of [books] that use
  [Quicklisp] may require [47mopenssl[0m to be installed if it is not
  already on your system.)")
 (CCL-UPDATES (POINTERS)
              "See [ccl-installation].")
 (CDAAAR
  (CONSES ACL2-BUILT-INS)
  "[47m[cdr][0m of the [47m[caaar][0m

  See any Common Lisp documentation for details.")
 (CDAADR
  (CONSES ACL2-BUILT-INS)
  "[47m[cdr][0m of the [47m[caadr][0m

  See any Common Lisp documentation for details.")
 (CDAAR
  (CONSES ACL2-BUILT-INS)
  "[47m[cdr][0m of the [47m[caar][0m

  See any Common Lisp documentation for details.")
 (CDADAR
  (CONSES ACL2-BUILT-INS)
  "[47m[cdr][0m of the [47m[cadar][0m

  See any Common Lisp documentation for details.")
 (CDADDR
  (CONSES ACL2-BUILT-INS)
  "[47m[cdr][0m of the [47m[caddr][0m

  See any Common Lisp documentation for details.")
 (CDADR
  (CONSES ACL2-BUILT-INS)
  "[47m[cdr][0m of the [47m[cadr][0m

  See any Common Lisp documentation for details.")
 (CDAR
  (CONSES ACL2-BUILT-INS)
  "[47m[cdr][0m of the [47m[car][0m

  See any Common Lisp documentation for details.")
 (CDDAAR
  (CONSES ACL2-BUILT-INS)
  "[47m[cdr][0m of the [47m[cdaar][0m

  See any Common Lisp documentation for details.")
 (CDDADR
  (CONSES ACL2-BUILT-INS)
  "[47m[cdr][0m of the [47m[cdadr][0m

  See any Common Lisp documentation for details.")
 (CDDAR
  (CONSES ACL2-BUILT-INS)
  "[47m[cdr][0m of the [47m[cdar][0m

  See any Common Lisp documentation for details.")
 (CDDDAR
  (CONSES ACL2-BUILT-INS)
  "[47m[cdr][0m of the [47m[cddar][0m

  See any Common Lisp documentation for details.")
 (CDDDDR
  (CONSES ACL2-BUILT-INS)
  "[47m[cdr][0m of the [47m[cdddr][0m

  See any Common Lisp documentation for details.")
 (CDDDR
  (CONSES ACL2-BUILT-INS)
  "[47m[cdr][0m of the [47m[cddr][0m

  See any Common Lisp documentation for details.")
 (CDDR
  (CONSES ACL2-BUILT-INS)
  "[47m[cdr][0m of the [47m[cdr][0m

  See any Common Lisp documentation for details.")
 (CDR
  (CONSES ACL2-BUILT-INS)
  "Returns the second element of a [47m[cons][0m pair, else [47mnil[0m

  Completion Axiom ([47mcompletion-of-cdr[0m):

    (equal (cdr x)
           (cond
            ((consp x)
             (cdr x))
            (t nil)))

  [Guard]:

    (or (consp x) (equal x nil))

  Notice that in the ACL2 logic, [47mcdr[0m returns [47mnil[0m for every [atom].")
 (CEILING
  (NUMBERS ACL2-BUILT-INS)
  "Division returning an integer by truncating toward positive infinity

    Example Forms:
    ACL2 !>(ceiling 14 3)
    5
    ACL2 !>(ceiling -14 3)
    -4
    ACL2 !>(ceiling 14 -3)
    -4
    ACL2 !>(ceiling -14 -3)
    5
    ACL2 !>(ceiling -15 -3)
    5

  [47m(Ceiling i j)[0m is the result of taking the quotient of [47mi[0m and [47mj[0m and
  returning the smallest integer that is at least as great as that
  quotient.  For example, the quotient of [47m-14[0m by [47m3[0m is [47m-4 2/3[0m, and the
  smallest integer at least that great is [47m-4[0m.

  The [guard] for [47m(ceiling i j)[0m requires that [47mi[0m and [47mj[0m are rational
  ([real], in ACL2(r)) numbers and [47mj[0m is non-zero.

  [47mCeiling[0m is a Common Lisp function.  See any Common Lisp documentation
  for more information.  However, note that unlike Common Lisp, the
  ACL2 [47mceiling[0m function returns only a single value,

  [31;1mFunction: [0m<ceiling>

    (defun ceiling (i j)
      (declare (xargs :guard (and (real/rationalp i)
                                  (real/rationalp j)
                                  (not (eql j 0)))))
      (let* ((q (* i (/ j)))
             (n (numerator q))
             (d (denominator q)))
        (cond ((= d 1) n)
              ((>= n 0)
               (+ (nonnegative-integer-quotient n d)
                  1))
              (t (- (nonnegative-integer-quotient (- n)
                                                  d))))))")
 (CERTIFICATE
  (BOOKS-TOUR)
  "A file specifying validity of a given book

  A book, say [47m\"arith\"[0m, is said to have a ``certificate'' if there is a
  file named [47m\"arith.cert\"[0m.  Certificates are created by the function
  [47m[certify-book][0m and inspected by [47m[include-book][0m.  [Book-hash] values
  are used to help ensure that certificates are legitimate and that
  the corresponding book has not been modified since certification.
  But because the file system is insecure and book-hash values are
  not perfect, it is possible for the inclusion of a book to cause
  inconsistency even though the book carries an impeccable
  certificate.

  The certificate includes the version number of the certifying ACL2.
  A book is considered uncertified if it is included in an ACL2 with
  a different [version] number.

  The presence of a ``valid'' certificate file for a book attests to
  two things: all of the [events] of the book are admissible in a
  certain extension of the initial ACL2 logic, and the non-[47m[local][0m
  [events] of the book are independent of the [47m[local][0m ones (see
  [local-incompatibility]).  In addition, the certificate contains
  the [command]s used to construct the [world] in which certification
  occurred.  Among those [command]s, of course, are the [47m[defpkg][0ms
  defining the packages used in the book.  When a book is included
  into a host [world], that [world] is first extended by the
  [command]s listed in the certificate for the book.  Unless that
  causes an error due to name conflicts, the extension ensures that
  all the packages used by the book are identically defined in the
  host [world].

  [3mSecurity:[0m

  Because the host file system is insecure, there is no way ACL2 can
  guarantee that the contents of a book remain the same as when its
  certificate was written.  That is, between the time a book is
  certified and the time it is used, it may be modified.
  Furthermore, certificates can be counterfeited.  [Book-hash] values
  are used to help detect such problems, but provide imperfect
  security: two different files can have the same book-hash.

  Therefore, from the strictly logical point of view, one must consider
  even the inclusion of certified [books] as placing a burden on the
  user:

      The non-erroneous inclusion of a certified book is consistency
      preserving provided (a) the objects read by [47m[include-book][0m from
      the certificate were the objects written there by a
      [47m[certify-book][0m and (b) the forms read by [47m[include-book][0m from
      the book itself are the forms read by the corresponding
      [47m[certify-book][0m.

  We say that a given execution of [47m[include-book][0m is ``certified'' if a
  certificate file for the book is present and well-formed and the
  [book-hash] information contained within it supports the conclusion
  that the [events] read by the [47m[include-book][0m are the ones checked
  by [47m[certify-book][0m.  When an uncertified [47m[include-book][0m occurs,
  warnings are printed or errors are caused.  But even if no warning
  is printed, you must accept burdens (a) and (b) if you use [books].
  These burdens are easier to live with if you protect your [books]
  so that other users cannot write to them, you abstain from running
  concurrent ACL2 jobs, and you abstain from counterfeiting
  certificates.  But even on a single user uniprocessor, you can
  shoot yourself in the foot by using the ACL2 [io] primitives to
  fabricate an inconsistent book and the corresponding certificate.

  Note that part (a) of the burden described above implies, in
  particular, that there are no guarantees when a certificate is
  copied.  When [books] are renamed (as by copying them), it is
  recommended that their certificates be removed and the [books] be
  recertified.  The expectation is that recertification will go
  through without a hitch if relative [pathname]s are used.  See
  [pathname], which is not on the guided tour.

  Certificates contain a [portcullis] and a [keep], each documented
  later in this guided tour through [books].  We mention here two
  other parts, which we do not document elsewhere because we view
  them as implementation details: an [47mexpansion-alist[0m, which records
  [47m[make-event][0m expansions; and [47mcert-data[0m, which contains logical
  information associated with the book.  (Those curious about
  [47mcert-data[0m are invited to look at the ``Essay on Cert-data'' in the
  source code.)

  See [portcullis] to continue the guided tour through [books].


Subtopics

  [Checksum]
      Assigning ``often unique'' integers to files and objects")
 (CERTIFY-BOOK
  (BOOKS-REFERENCE BOOKS-TOUR)
  "How to produce a [certificate] for a book

  Also see [certificate] for information about the [47m\".cert\"[0m file
  produced by [47mcertify-book[0m, in particular for information about the
  use of [book-hash] values to help ensure that the corresponding
  book has not been modified since certification.  See
  [certify-book-debug] for some potential remedies for failures of
  [47mcertify-book[0m.

    Examples:
    (certify-book \"my-arith\")          ; certify in a world with 0 commands
    (certify-book \"my-arith\" 3)        ; ... in a world with 3 commands
    (certify-book \"my-arith\" ?)        ; ... in a world without checking the
                                       ;     number of commands
    (certify-book \"my-arith\" 0 nil)    ; ... without compilation
    (certify-book \"my-arith\" 0 t)      ; ... with compilation (default)
    (certify-book \"my-arith\" 0 t :ttags (foo))
                                       ; ... allowing trust tag (ttag) foo
    (certify-book \"my-arith\" 0 t :ttags :all)
                                       ; ... allowing all trust tags (ttags)
    (certify-book \"my-arith\" 0 nil :acl2x t)
                                       ; ... writing or reading a .acl2x file
    (certify-book \"my-arith\" 0 t :useless-runes :write)
                                       ; ... write file to speed up future proofs
    (certify-book \"my-arith\" 0 t :useless-runes :read)
                                       ; ... read file to speed up future proofs

    General Form:
    (certify-book book-name
                  k                       ; [default 0]
                  compile-flg             ; [default t]
                  :defaxioms-okp t/nil    ; [default nil]
                  :skip-proofs-okp t/nil  ; [default nil]
                  :ttags ttags            ; [default nil]
                  :acl2x t/nil            ; [default nil]
                  :ttagsx ttags           ; [default nil]
                  :pcert pcert            ; [default nil]
                  :write-port t/nil       ; [default t unless pcert is non-nil]
                  :useless-runes          ; :write/:read/:read?/n/-n/nil
                                          ;   (-100 < n < 0 or 0 < n <= 100)
                                          ;   [default nil or from environment]
                  :write-event-data       ; [default nil or from environment]
                  )

  where [47mbook-name[0m is a book filename, [47mk[0m is used to indicate your
  approval of the ``certification [world],'' and [47mcompile-flg[0m can
  control whether the book is to be compiled.  The defaults for
  [47mcompile-flg[0m, [47mskip-proofs-okp[0m, [47macl2x[0m, [47mwrite-port[0m, [47mpcert[0m,
  [47m:useless-runes[0m, and [47m:write-event-data[0m can be affected by
  environment variables.  All of these arguments are described in
  detail below, except for [47m:pcert[0m, [47m:useless-runes[0m, and
  [47m:write-event-data[0m: see [provisional-certification],
  [useless-runes], and [saving-event-data], respectively, for the
  effects of these three arguments and related environment variables,
  as we ignore those effects in the present topic.

  NOTE: If a given book includes some books (see [include-book]), then
  those included books need to be certified before the given book is
  certified.  See [build::cert.pl] for a tool that certifies not only
  a given book but also all of the books that it includes, as well as
  all the books that those books include, and so on --- all in the
  proper order, and with parallelism by using the [47m-j[0m option.

  Certification occurs in some logical [world], called the
  ``certification [world].'' That [world] must contain the [47m[defpkg][0ms
  needed to read and execute the forms in the book.  The [command]s
  necessary to recreate that [world] from the ACL2 initial [world]
  are called the ``[portcullis] commands,'' and will be copied into
  the [certificate] created for the book.  Those [command]s will be
  re-executed whenever the book is included, to ensure that the
  appropriate packages (and all other names used in the certification
  [world]) are correctly defined.  Note that Step 1 of [47mcertify-book[0m
  will fail if a package mentioned in the book is not defined before
  attempting the certification, i.e., defined by a portcullis command
  in the certification world.  For example, suppose that your book
  contains the symbol [47mFOO::X[0m, but the package \"FOO\" is not currently
  defined.  Then an error message will likely complain either about a
  missing package [47m\"FOO\"[0m, or about a symbol [47mFOO::X[0m that is ``not in
  any of the packages known to ACL2.'' A solution is to define the
  package \"FOO\", perhaps directly using [47m[defpkg][0m or by including a
  book that defines this package, before attempting the
  certification.

  The certified book will be more often usable if the certification
  [world] is kept to a minimal extension of the ACL2 initial [world]
  (for example, to prevent name clashes with functions defined in
  other books, or to avoid including undesired rules).
  Alternatively, use [47m[local][0m [events] to build your certification
  world, as these will be skipped when including the certified book.
  But perhaps it's simplest just to get into the initial ACL2 [world]
  (e.g., with [47m:ubt 1[0m or by just starting a new ACL2 run), then define
  the desired packages (directly with [47m[defpkg][0m or by including books
  that define the packages), and finally invoke [47mcertify-book[0m.

  The [47mk[0m argument to [47mcertify-book[0m has default value [47m0[0m, and it must be
  either a nonnegative integer or else the symbol [47m?[0m in any package.
  If [47mk[0m is an integer, then it must be the number of [command]s that
  have been executed after the initial ACL2 [world] to create the
  [world] in which [47mcertify-book[0m was called.  One way to obtain this
  number is by doing [47m:pbt :start[0m to see all the [command]s back to
  the first one.

  Otherwise, [47mk[0m is [47m?[0m (or any symbol whose [47m[symbol-name][0m is [47m\"?\"[0m).  In
  that case there is no check made on the certification world.  This
  can be a nice convenience but at the cost of eliminating a
  potentially valuable check that the certification [world] may be as
  expected.

  We next describe the meaning of [47mcompile-flg[0m and how it defaults.  If
  explicit compilation has been suppressed by [47m(set-compiler-enabled
  nil state)[0m, then [47mcompile-flg[0m is coerced to [47mnil[0m; see [compilation].
  Otherwise [47mcompile-flg[0m may be given the value of [47mt[0m (or [47m:all[0m, which
  is equivalent to [47mt[0m except during provisional certification; see
  [provisional-certification]), indicating that the book is to be
  compiled, or else [47mnil[0m.  (Note that compilation initially creates a
  compiled file with a temporary file name, and then moves that
  temporary file to the final compiled file name obtained by adding a
  suitable extension to the book's filename.  Thus, a compiled file
  will appear atomically in its intended location.)  Finally, if
  [47mcompile-flg[0m is not supplied (or is [47m:default[0m) then it is treated as
  [47mt[0m.  Note that the value [47m:all[0m is equivalent to [47mt[0m except for during
  the Convert procedure of provisional certification; see
  [provisional-certification].

  Two keyword arguments, [47m:defaxioms-okp[0m and [47m:skip-proofs-okp[0m, determine
  how the system handles the inclusion of [47m[defaxiom][0m events and
  [47m[skip-proofs][0m events, respectively, in the book.  The value [47mt[0m
  allows such events, but prints a warning message.  The value [47mnil[0m
  causes an error if such an event is found.  [47mNil[0m is the default
  unless keyword argument [47m:acl2x t[0m is provided and state global
  [47m'write-acl2x[0m is a cons (see [set-write-ACL2x]), in which case the
  default is [47mt[0m.

  The keyword argument [47m:ttags[0m may normally be omitted.  A few
  constructs, used for example if you are building your own system
  based on ACL2, may require it.  See [defttag] for an explanation of
  this argument.

  When book [47mB[0m is certified with value [47mt[0m (the default, unless the value
  used for [47mpcert[0m is non-[47mnil[0m) for keyword argument [47m:write-port[0m, a file
  [47mB.port[0m is written by certification process.  This file contains all
  of the [portcullis] [command]s for [47mB[0m, i.e., all user commands
  present in the ACL2 logical [world] at the time [47mcertify-book[0m is
  called.  If [47mB.lisp[0m later becomes uncertified, say because [events]
  from that file or an included book have been edited, then
  [47m(include-book \"B\")[0m will consult [47mB.port[0m to evaluate forms in that
  file before evaluating the events in [47mB.lisp[0m.  On the other hand,
  [47mB.port[0m is ignored when including [47mB[0m if [47mB[0m is certified.

  If you use [guard]s, please note [47mcertify-book[0m is executed as though
  [47m(set-guard-checking t)[0m has been evaluated; see
  [set-guard-checking].  If you want to run with different
  guard-checking, consider using [47mld[0m instead, or in addition; see
  [ld].

  For a general discussion of books, see [books].  [47mCertify-book[0m is akin
  to what we have historically called a ``proveall'': all the forms
  in the book are ``proved'' to guarantee their admissibility.  More
  precisely, [47mcertify-book[0m (1) reads the forms in the book, confirming
  that the appropriate packages are defined in the certification
  [world]; (2) does the full admissibility checks on each form
  (proving termination of recursive functions, proving theorems,
  etc.), checking as it goes that each form is an embedded event form
  (see [embedded-event-form]); (3) may roll back the logical [world]
  (how far? --- see below) and perform an [47m[include-book][0m to check for
  [47m[local][0m incompatibilities (see [local-incompatibility]); (4) writes
  a [certificate] recording not only that the book was certified but
  also recording the [command]s necessary to recreate the
  certification [world] (so the appropriate packages can be defined
  when the book is included in other [world]s) and a [book-hash] for
  each of the [books] involved (see [certificate]); and (5) compiles
  the book if so directed (and then loads the object file in that
  case).

  [47mCertify-book[0m is a macro that returns an [error-triple], where success
  is indicated by an error component of [47mnil[0m and has the effect of
  extending the [world] with a corresponding [47m[include-book][0m event.
  If you don't want the included book's [events] in your present
  [world], simply execute [47m:[0m[47m[u][0m.

  Remark.  Step (3) above mentions rolling back the logical [world] to
  check for local incompatibilities.  This process is skipped if no
  [local] event is encountered.  Otherwise, the world is rolled back
  through the first local event past the boot-strap world --- see
  [local-incompatibility] --- before the book is included.  Note that
  if that first local event is in the certification world, then all
  commands from that event onward will be rolled back.  See
  [fast-cert] for a way to skip entirely this process of roll-back
  and check, regardless of local events, but with a risk to
  soundness.  End of Remark.

  A utility is provided to assist in debugging failures of
  [47mcertify-book[0m; see [redo-flat].)

  [47mCertify-book[0m requires that the default [defun-mode] (see
  [default-defun-mode]) be [47m:[0m[47m[logic][0m when certification is attempted.
  If the mode is not [47m:[0m[47m[logic][0m, an error is signaled.

  An error will occur if [47mcertify-book[0m has to deal with any uncertified
  book other than the one on which it was called.  For example, if
  the book being certified includes another book, that sub-book must
  already have been certified; that is, that sub-book must have a
  valid [certificate] file.

  If you have a certified book that has remained unchanged for some
  time you might well not remember the appropriate [47m[defpkg][0ms for it,
  though they are stored in the [certificate] file and (by default)
  also in the [47m.port[0m file.  If you begin to change the book, don't
  throw away its [certificate] file just because it has become
  invalid!  It is an important historical document until the book is
  re-certified.  More important, don't throw away the [47m.port[0m file, as
  it will provide the [portcullis] commands when including the book
  as an uncertified book; see [include-book].

  When [47mcertify-book[0m is directed to produce a compiled file, it calls
  the Common Lisp function [47mcompile-file[0m on the original source file.
  This creates a compiled file with an extension known to ACL2, e.g.,
  if the book is named [47m\"my-book\"[0m then the source file is
  [47m\"my-book.lisp\"[0m and the compiled file under GCL will be [47m\"my-book.o\"[0m
  while under SBCL it will be [47m\"my-book.fasl\"[0m.  The compiled file is
  then loaded.  When [47m[include-book][0m is used later on [47m\"my-book\"[0m it
  will automatically load the compiled file, provided the compiled
  file has a later write date than the source file.  The only effect
  of such [compilation] and loading is that the functions defined in
  the book execute faster.  See [guard] for a discussion of the
  issues, and if you want more details about [books] and compilation,
  see [book-compiled-file].

  When [47mcertify-book[0m is directed not to produce a compiled file, it will
  delete any existing compiled file for the book, so as not to
  mislead [47m[include-book][0m into loading the now outdated compiled file.
  Otherwise, [47mcertify-book[0m will create a temporary ``expansion file''
  to compile, obtained by appending the string \"@expansion.lsp\" to
  the end of the book's filename.  Remark: Users may ignore that
  file, which is automatically deleted unless [state] global variable
  [47m'save-expansion-file[0m has been set, presumably by a system
  developer, to a non-[47mnil[0m value; see [book-compiled-file] for more
  information about this issue, including the role of environment
  variable [47mACL2_SAVE_EXPANSION[0m.

  After execution of a [47mcertify-book[0m form, the value of
  [47m[ACL2-defaults-table][0m is restored to what it was immediately before
  that [47mcertify-book[0m form was executed.  See [ACL2-defaults-table].

  Those who use the relatively advanced features of trust tags (see
  [defttag]) and [47m[make-event][0m may wish to know how to create a
  [certificate] file that avoids dependence on trust tags that are
  used only during [47m[make-event][0m expansion.  For this, including
  documentation of the [47m:acl2x[0m and [47m:ttagsx[0m keyword arguments for
  [47mcertify-book[0m, see [set-write-ACL2x].

  This completes the tour through the [documentation] of [books].


Subtopics

  [Certify-book!]
      A variant of [47m[certify-book][0m

  [Certify-book-debug]
      Some possible ways to work around [47m[certify-book][0m failures

  [Fast-cert]
      A mode for faster, but possibly unsound, book certification

  [Useless-runes]
      Speed up proofs by disabling useless [rune]s")
 (CERTIFY-BOOK!
  (CERTIFY-BOOK)
  "A variant of [47m[certify-book][0m

    Examples:
    (certify-book! \"my-arith\" 3)     ;Certify in a world with 3
                                       ; commands, starting in a world
                                       ; with at least 3 commands.
    (certify-book! \"my-arith\")       ;Certify in the initial world.

    General Form:
    (certify-book! book-name k compile-flg)

  where [47mbook-name[0m is a book filename, [47mk[0m is a nonnegative integer used
  to indicate the ``certification [world],'' and [47mcompile-flg[0m
  indicates whether you wish to compile the (functions in the) book.

  This [command] is identical to [47m[certify-book][0m, except that the second
  argument [47mk[0m may not be [47mt[0m in [47mcertify-book![0m and if [47mk[0m exceeds the
  current [command] number, then an appropriate [47m[ubt!][0m will be
  executed first.  See [certify-book] and see [ubt!].")
 (CERTIFY-BOOK-DEBUG
  (CERTIFY-BOOK BOOKS-REFERENCE)
  "Some possible ways to work around [47m[certify-book][0m failures

  This topic provides some ideas for how to deal with [47m[certify-book][0m
  failures.  Ideally, this topic will continue to grow over time.

  Stack overflows may show up as follows.

    ***********************************************
    ************ ABORTING from raw Lisp ***********
    ********** (see :DOC raw-lisp-error) **********
    Error:  Stack overflow on value stack.
    ***********************************************

  When this occurs during book certification, it could be during an
  attempt to handle large objects, in particular by the [serialize]
  writer or by a [memoize]d version of the check for ``bad'' objects.
  These two potential causes can be remedied by first evaluating the
  following forms, respectively.

    (set-serialize-character-system nil state)
    (set-bad-lisp-consp-memoize nil)

  If the large object is in an event in the book under certification,
  then you may need to avoid printing it, as follows.

    (set-inhibit-output-lst '(proof-tree event))

  Other failures of [47mcertify-book[0m may have error messages that point to
  the problem.  When that is not the case, it would be good to
  explain possible workarounds in this topic!")
 (CERTIFY-BOOK-FAILURE (POINTERS)
                       "See [certify-book-debug].")
 (CERTIFYING-BOOKS (POINTERS)
                   "See [books-certification].")
 (CHANGE
  (DEFREC ACL2-BUILT-INS)
  "Mutator macro for [defrec] structures.

  The [47mchange[0m macro is built into ACL2, and allows you to \"modify\"
  instances of structures that have been introduced with [defrec].
  Of course, since ACL2 is applicative, the original structure is not
  actually changed---instead, a new structure is constructed, copying
  some fields from the original structure and installing new values
  for other fields.

  For instance, suppose we first use [make] to create an employee
  structure, e.g.,:

    (defconst *jimmy* (make employee :name \"Jimmy\"
                                     :salary 0
                                     :position \"Unpaid Intern\")

  Then we can use [47mchange[0m to mutate this structure, e.g.,:

    (change employee *jimmy* :salary 300000
                             :position \"Vice President\")

  Produces a new [47memployee[0m structure where the [47mname[0m is still \"Jimmy\",
  but where the [47msalary[0m and [47mposition[0m have been updated to 300000 and
  \"Vice President\", respectively.

  See [defrec] for more information.")
 (CHAR
  (STRINGS CHARACTERS ACL2-BUILT-INS)
  "The [nth] element (zero-based) of a string

  [47m(Char s n)[0m is the [47mn[0mth element of [47ms[0m, zero-based.  If [47mn[0m is greater than
  or equal to the length of [47ms[0m, then [47mchar[0m returns [47mnil[0m.

  [47m(Char s n)[0m has a [guard] that [47mn[0m is a non-negative integer and [47ms[0m is a
  [47m[stringp][0m.

  [47mChar[0m is a Common Lisp function.  See any Common Lisp documentation
  for more information.

  [31;1mFunction: [0m<char>

    (defun char (s n)
      (declare (xargs :guard (and (stringp s)
                                  (integerp n)
                                  (>= n 0)
                                  (< n (length s)))))
      (nth n (coerce s 'list)))")
 (CHAR-CODE
  (CHARACTERS NUMBERS ACL2-BUILT-INS)
  "The numeric code for a given character

  This function maps a character to its code, for example: [47m(char-code
  #\\A)[0m evaluates to [47m65[0m.  See [47m[code-char][0m for a sort of inverse
  function, which maps a code to the corresponding character.

  Completion Axiom ([47mcompletion-of-char-code[0m):

    (equal (char-code x)
           (if (characterp x)
               (char-code x)
             0))

  [Guard] for [47m(char-code x)[0m:

    (characterp x)

  This function maps all non-characters to [47m0[0m.")
 (CHAR-DOWNCASE
  (CHARACTERS ACL2-BUILT-INS)
  "Turn upper-case [characters] into lower-case [characters]

  [47m(Char-downcase x)[0m is equal to [47m#\\a[0m when [47mx[0m is [47m#\\A[0m, [47m#\\b[0m when [47mx[0m is [47m#\\B[0m,
  ..., and [47m#\\z[0m when [47mx[0m is [47m#\\Z[0m, and is [47mx[0m for any other character.

  The [guard] for [47mchar-downcase[0m states that its argument is a
  character.

  [47mChar-downcase[0m is a Common Lisp function.  See any Common Lisp
  documentation for more information.  Note that the value returned
  may depend on the host Lisp; see [soundness], specifically Example
  1 in the Section, ``Examples of divergence among Lisp
  implementations''.

  [31;1mFunction: [0m<char-downcase>

    (defun char-downcase (x)
      (declare (xargs :guard (characterp x)))
      (cond ((standard-char-p x)
             (let ((pair (assoc x
                                '((#\\A . #\\a)
                                  (#\\B . #\\b)
                                  (#\\C . #\\c)
                                  (#\\D . #\\d)
                                  (#\\E . #\\e)
                                  (#\\F . #\\f)
                                  (#\\G . #\\g)
                                  (#\\H . #\\h)
                                  (#\\I . #\\i)
                                  (#\\J . #\\j)
                                  (#\\K . #\\k)
                                  (#\\L . #\\l)
                                  (#\\M . #\\m)
                                  (#\\N . #\\n)
                                  (#\\O . #\\o)
                                  (#\\P . #\\p)
                                  (#\\Q . #\\q)
                                  (#\\R . #\\r)
                                  (#\\S . #\\s)
                                  (#\\T . #\\t)
                                  (#\\U . #\\u)
                                  (#\\V . #\\v)
                                  (#\\W . #\\w)
                                  (#\\X . #\\x)
                                  (#\\Y . #\\y)
                                  (#\\Z . #\\z)))))
               (cond (pair (cdr pair)) (t x))))
            (t (char-downcase-non-standard x))))")
 (CHAR-EQUAL
  (CHARACTERS ACL2-BUILT-INS)
  "Character equality without regard to case

  For [characters] [47mx[0m and [47my[0m, [47m(char-equal x y)[0m is true if and only if [47mx[0m
  and [47my[0m are the same except perhaps for their case.

  The [guard] on [47mchar-equal[0m states that its arguments are both
  [characters].

  [47mChar-equal[0m is a Common Lisp function.  See any Common Lisp
  documentation for more information.  Note that the value returned
  may depend on the host Lisp; see [soundness], specifically Example
  1 in the Section, ``Examples of divergence among Lisp
  implementations''.

  [31;1mFunction: [0m<char-equal>

    (defun char-equal (x y)
      (declare (xargs :guard (and (characterp x) (characterp y))))
      (eql (char-downcase x)
           (char-downcase y)))")
 (CHAR-UPCASE
  (CHARACTERS ACL2-BUILT-INS)
  "Turn lower-case [characters] into upper-case [characters]

  [47m(Char-upcase x)[0m is equal to [47m#\\A[0m when [47mx[0m is [47m#\\a[0m, [47m#\\B[0m when [47mx[0m is [47m#\\b[0m,
  ..., and [47m#\\Z[0m when [47mx[0m is [47m#\\z[0m, and is [47mx[0m for any other character.

  The [guard] for [47mchar-upcase[0m states that its argument is a character.

  [47mChar-upcase[0m is a Common Lisp function.  See any Common Lisp
  documentation for more information.  Note that the value returned
  may depend on the host Lisp; see [soundness], specifically Example
  1 in the Section, ``Examples of divergence among Lisp
  implementations''.

  [31;1mFunction: [0m<char-upcase>

    (defun char-upcase (x)
      (declare (xargs :guard (characterp x)))
      (cond ((standard-char-p x)
             (let ((pair (assoc x
                                '((#\\a . #\\A)
                                  (#\\b . #\\B)
                                  (#\\c . #\\C)
                                  (#\\d . #\\D)
                                  (#\\e . #\\E)
                                  (#\\f . #\\F)
                                  (#\\g . #\\G)
                                  (#\\h . #\\H)
                                  (#\\i . #\\I)
                                  (#\\j . #\\J)
                                  (#\\k . #\\K)
                                  (#\\l . #\\L)
                                  (#\\m . #\\M)
                                  (#\\n . #\\N)
                                  (#\\o . #\\O)
                                  (#\\p . #\\P)
                                  (#\\q . #\\Q)
                                  (#\\r . #\\R)
                                  (#\\s . #\\S)
                                  (#\\t . #\\T)
                                  (#\\u . #\\U)
                                  (#\\v . #\\V)
                                  (#\\w . #\\W)
                                  (#\\x . #\\X)
                                  (#\\y . #\\Y)
                                  (#\\z . #\\Z)))))
               (cond (pair (cdr pair)) (t x))))
            (t (char-upcase-non-standard x))))")
 (CHAR<
  (CHARACTERS ACL2-BUILT-INS)
  "Less-than test for [characters]

  [47m(char< x y)[0m is true if and only if the character code of [47mx[0m is less
  than that of [47my[0m.  See [char-code].

  The [guard] for [47mchar<[0m specifies that its arguments are [characters].

  [47mChar<[0m is a Common Lisp function.  See any Common Lisp documentation
  for more information.

  [31;1mFunction: [0m<char<>

    (defun char< (x y)
      (declare (xargs :guard (and (characterp x) (characterp y))))
      (< (char-code x) (char-code y)))")
 (CHAR<=
  (CHARACTERS ACL2-BUILT-INS)
  "Less-than-or-equal test for [characters]

  [47m(char<= x y)[0m is true if and only if the character code of [47mx[0m is less
  than or equal to that of [47my[0m.  See [char-code].

  The [guard] for [47mchar<=[0m specifies that its arguments are [characters].

  [47mChar<=[0m is a Common Lisp function.  See any Common Lisp documentation
  for more information.

  [31;1mFunction: [0m<char<=>

    (defun char<= (x y)
      (declare (xargs :guard (and (characterp x) (characterp y))))
      (<= (char-code x) (char-code y)))")
 (CHAR>
  (CHARACTERS ACL2-BUILT-INS)
  "Greater-than test for [characters]

  [47m(char> x y)[0m is true if and only if the character code of [47mx[0m is greater
  than that of [47my[0m.  See [char-code].

  The [guard] for [47mchar>[0m specifies that its arguments are [characters].

  [47mChar>[0m is a Common Lisp function.  See any Common Lisp documentation
  for more information.

  [31;1mFunction: [0m<char>>

    (defun char> (x y)
      (declare (xargs :guard (and (characterp x) (characterp y))))
      (> (char-code x) (char-code y)))")
 (CHAR>=
  (CHARACTERS ACL2-BUILT-INS)
  "Greater-than-or-equal test for [characters]

  [47m(char>= x y)[0m is true if and only if the character code of [47mx[0m is
  greater than or equal to that of [47my[0m.  See [char-code].

  The [guard] for [47mchar>=[0m specifies that its arguments are [characters].

  [47mChar>=[0m is a Common Lisp function.  See any Common Lisp documentation
  for more information.

  [31;1mFunction: [0m<char>=>

    (defun char>= (x y)
      (declare (xargs :guard (and (characterp x) (characterp y))))
      (>= (char-code x) (char-code y)))")
 (CHARACTER-ALISTP
  (CHARACTERS ALISTS ACL2-BUILT-INS)
  "Recognizer for association lists with characters as keys

  [47m(Character-alistp x)[0m is true if and only if [47mx[0m is a list of pairs of
  the form [47m(cons key val)[0m where [47mkey[0m is a [47m[characterp][0m.

  [31;1mFunction: [0m<character-alistp>

    (defun character-alistp (x)
      (declare (xargs :guard t))
      (cond ((atom x) (eq x nil))
            (t (and (consp (car x))
                    (characterp (car (car x)))
                    (character-alistp (cdr x))))))")
 (CHARACTER-ENCODING
  (IO)
  "How bytes are parsed into characters

  When the Common Lisp reader comes across bytes in a file or at the
  terminal, they are parsed into characters.  The simplest case is
  when each byte that is read is a standard character (see
  [standard-char-p]).  It is actually quite common that each byte
  that is read corresponds to a single character.  The parsing of
  bytes into characters is based on a [3mcharacter encoding[0m, that is, a
  mapping that associates one or more bytes with each legal
  character.

  In order to help guarantee the portability of files (including
  [books]), ACL2 installs a common character encoding for reading
  files, often known as ISO-8859-1 or Latin-1.  For some host Lisps
  this character encoding is also used for reading from the terminal;
  but, sadly, this may not hold for all host Lisps, and may not even
  be possible for some of them.

  The use of the above encoding could in principle cause problems if
  one's editor produces files using an encoding other than
  ISO-8859-1, at least if one uses non-standard characters.  In
  particular, the default Emacs buffer encoding may be utf-8.  If
  your file has non-standard characters, then in Emacs you can
  evaluate the form

    (setq save-buffer-coding-system 'iso-8859-1)

  before saving the buffer into a file.  This will happen automatically
  for users who load distributed file [47memacs-acl2.el[0m (from a suitable
  directory; see [emacs]) into their Emacs sessions.

  For an example of character encodings in action, see the community
  book [47mbooks/misc/character-encoding-test.lisp[0m.")
 (CHARACTER-LISTP
  (CHARACTERS LISTS ACL2-BUILT-INS)
  "Recognizer for a true list of characters

  The predicate [47mcharacter-listp[0m tests whether its argument is a true
  list of [characters].

  [31;1mFunction: [0m<character-listp>

    (defun character-listp (l)
      (declare (xargs :guard t))
      (cond ((atom l) (equal l nil))
            (t (and (characterp (car l))
                    (character-listp (cdr l))))))")
 (CHARACTERP
  (CHARACTERS ACL2-BUILT-INS)
  "Recognizer for [characters]

  [47m(characterp x)[0m is true if and only if [47mx[0m is a character.  Note that
  ACL2 supports characters with ASCII codes between 0 and 255.  See
  also [code-char] and [char-code].")
 (CHARACTERS
  (PROGRAMMING)
  "Characters in ACL2 and operations on them

  ACL2 accepts 256 distinct characters, which are the characters
  obtained by applying the function [47m[code-char][0m to each integer from
  [47m0[0m to [47m255[0m.  Among these, Common Lisp designates certain ones as
  [3mstandard characters[0m, namely those of the form [47m(code-char n)[0m where [47mn[0m
  is from [47m33[0m to [47m126[0m, together with [47m#\\Newline[0m and [47m#\\Space[0m.  The actual
  standard characters may be viewed by evaluating the [47m[defconst][0m
  [47m*standard-chars*[0m.

  To be more precise, Common Lisp does not specify the precise
  relationship between [47m[code-char][0m and the standard characters.
  However, we check that the underlying Common Lisp implementation
  uses a particular relationship that extends the usual ASCII coding
  of characters.  We also check that Space, Tab, Newline, Page,
  Rubout, and Return correspond to characters with respective
  [47m[char-code][0ms [47m32[0m, [47m9[0m, [47m10[0m, [47m12[0m, [47m127[0m, and [47m13[0m.

  [47m[Code-char][0m has an inverse, [47m[char-code][0m.  Thus, when [47m[char-code][0m is
  applied to an ACL2 character, [47mc[0m, it returns a number [47mn[0m between [47m0[0m
  and [47m255[0m inclusive such that [47m(code-char n)[0m = [47mc[0m.

  The preceding paragraph implies that there is only one ACL2 character
  with a given character code.  CLTL allows for ``attributes'' for
  characters, which could allow distinct characters with the same
  code, but ACL2 does not allow this.

  [3mThe Character Reader[0m

  ACL2 supports the `[47m#\\[0m' notation for characters provided by Common
  Lisp, with some restrictions.  First of all, for every character [47mc[0m,
  the notation

    #\\c

  may be used to denote the character object [47mc[0m.  That is, the user may
  type in this notation and ACL2 will read it as denoting the
  character object [47mc[0m.  In this case, the character immediately
  following [47mc[0m must be one of the following ``terminating
  characters'': a Tab, a Newline, a Page character, a space, or one
  of the characters:

    \"  '  (  )  ;  `  ,

  Other than the notation above, ACL2 accepts alternate notation for
  five characters.

    #\\Space
    #\\Tab
    #\\Newline
    #\\Page
    #\\Rubout
    #\\Return

  Again, in each of these cases the next character must be from among
  the set of ``terminating characters'' described in the
  single-character case.  Our implementation is consistent with
  ISO-8859-1, even though we don't provide [47m#\\[0m syntax for entering
  characters other than that described above.

  Finally, we note that it is our intention that any object printed by
  ACL2's top-level-loop may be read back into ACL2.  Please notify
  the implementors if you find a counterexample to this claim.


Subtopics

  [Alpha-char-p]
      Recognizer for alphabetic characters

  [Char]
      The [nth] element (zero-based) of a string

  [Char-code]
      The numeric code for a given character

  [Char-downcase]
      Turn upper-case [characters] into lower-case [characters]

  [Char-equal]
      Character equality without regard to case

  [Char-upcase]
      Turn lower-case [characters] into upper-case [characters]

  [Char<]
      Less-than test for [characters]

  [Char<=]
      Less-than-or-equal test for [characters]

  [Char>]
      Greater-than test for [characters]

  [Char>=]
      Greater-than-or-equal test for [characters]

  [Character-alistp]
      Recognizer for association lists with characters as keys

  [Character-listp]
      Recognizer for a true list of characters

  [Characterp]
      Recognizer for [characters]

  [Code-char]
      The character corresponding to a given numeric code

  [Coerce]
      Coerce a character list to a string and a string to a list

  [Digit-char-p]
      The number, if any, corresponding to a given character

  [Digit-to-char]
      Map a digit to a character

  [Explode-atom]
      Convert any [atom] into a [character-listp] that contains its
      printed representation, rendering numbers in your choice of
      print base.

  [Explode-nonnegative-integer]
      The list of [characters] in the radix-r form of a number

  [Lower-case-p]
      Recognizer for lower case characters

  [Make-character-list]
      [coerce] to a list of characters

  [Standard-char-listp]
      Recognizer for a true list of standard characters

  [Standard-char-p]
      Recognizer for standard characters

  [Standard-char-p+]
      Recognizer for standard characters whose guard is [47mt[0m

  [Upper-case-p]
      Recognizer for upper case characters")
 (CHECK-INVARIANT-RISK (POINTERS)
                       "See [set-check-invariant-risk].")
 (CHECK-SUM (POINTERS) "See [checksum].")
 (CHECK-VARS-NOT-FREE
  (MACROS)
  "Avoid variable capture in macro calls

  [47mCheck-vars-not-free[0m is a macro that is useful for avoiding capture of
  variables in macro calls.  We explain using a running example,
  after which we give a precise explanation (at the end of this
  documentation topic).  These definitions are rather contrived but
  are designed to illustrate how [47mcheck-vars-not-free[0m can be useful.

    (defmacro has-length (x n)
      `(let ((k (len ,x)))
         (equal k ,n)))
    (defun f1 (u v)
      (and (natp v)
           (has-length u (* 2 v))))
    (defun f2 (lst k)
      (and (natp k)
           (has-length lst (* 2 k))))

  One might expect [47mf1[0m and [47mf2[0m to be the same function, since the only
  change seems to be from the choices of formal parameters.  However,
  consider these evaluations.

    ACL2 !>(f1 '(a b c d e f) 3)
    T
    ACL2 !>(f2 '(a b c d e f) 3)
    NIL
    ACL2 !>

  The problem becomes clear if we expand the macro call in the body of
  [47mf2[0m.

    ACL2 !>:trans1 (has-length lst (* 2 k))
     (LET ((K (LEN LST))) (EQUAL K (* 2 K)))
    ACL2 !>

  We see that when expanding the call of the macro [47mhas-length[0m in the
  body of [47mf2[0m, the substitution of [47m(* 2 k)[0m for [47m,n[0m causes [47mk[0m to
  be``captured'' by the binding of [47mk[0m to [47m(len lst)[0m.

  The macro [47mcheck-vars-not-free[0m is designed to enforce that no such
  capture takes place.  An improved definition of [47mhas-length[0m is as
  follows, since it insists that the variable [47mk[0m must not appear in
  the term that replaces [47m,n[0m.

    (defmacro has-length (x n)
      `(let ((k (len ,x)))
         (equal k (check-vars-not-free (k) ,n))))

  Now, the attempt to define [47mf2[0m as above causes an error.

    ACL2 !>(defun f2 (lst k)
       (and (natp k)
            (has-length lst (* 2 k))))


    ACL2 Error in ( DEFUN F2 ...):  CHECK-VARS-NOT-FREE failed:
    It is forbidden to use K in (BINARY-* '2 K).  Note:  this error occurred
    in the context (CHECK-VARS-NOT-FREE (K) (* 2 K)).


    Summary
    Form:  ( DEFUN F2 ...)
    Rules: NIL
    Time:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)

    ACL2 Error in ( DEFUN F2 ...):  See :DOC failure.

    ******** FAILED ********
    ACL2 !>

  The error message shows that the check performed by
  [47mcheck-vars-not-free[0m has failed, because the variable [47mk[0m occurs in
  the expression [47m(* 2 k)[0m.  More precisely, what is checked is that [47mk[0m
  does not occur in the translation to a [term] of the expression [47m(*
  2 k)[0m, namely, [47m(binary-* '2 k)[0m.

  The general form of a call of [47mcheck-vars-not-free[0m is

    (check-vars-not-free (var_1 ... var_n) expr)

  where [47mvar_1[0m, ..., [47mvar_n[0m are variables and [47mexpr[0m is an expression.
  This call is equivalent to [47mexpr[0m --- indeed, there is no effect on
  the code generated when using this call in place of [47mexpr[0m --- but
  ACL2 requires that the indicated variables do not occur free in the
  translation of [47mexpr[0m to a term.")
 (CHECKPOINT-FORCED-GOALS
  (PROOF-TREE)
  "Cause forcing goals to be checkpointed in proof trees

    Example forms:
    (checkpoint-forced-goals t)
    (checkpoint-forced-goals nil)

  Also see [proof-tree].

  By default, goals are not marked as checkpoints by a proof tree
  display (as described elsewhere; see [proof-tree]) merely because
  they [force] some hypotheses, thus possibly contributing to a
  forcing round.  However, some users may want such behavior, which
  will occur once the command [47m(checkpoint-forced-goals[0m [47mt[0m) has been
  executed.  To return to the default behavior, use the command
  [47m(checkpoint-forced-goals nil)[0m.")
 (CHECKPOINT-SUMMARY-LIMIT
  (SUMMARY SET-GAG-MODE)
  "Control printing of key checkpoints upon a proof's failure

  See [set-checkpoint-summary-limit] for a discussion of the
  checkpoint-summary-limit.  Evaluation of the form
  [47m(checkpoint-summary-limit)[0m produces the current
  checkpoint-summary-limit, and can be invoked with the keyword hack
  (see [keyword-commands]).  For example:

    ACL2 !>:checkpoint-summary-limit
    (NIL . 3)
    ACL2 !>")
 (CHECKSUM
  (CERTIFICATE)
  "Assigning ``often unique'' integers to files and objects

  See [book-hash] for a discussion of how ACL2 can use checksums
  (though not by default) to increase security in the [books]
  mechanism.

  A [3mchecksum[0m is an integer in some fixed range computed from the
  printed representation of an object, e.g., the sum, modulo [47m2**32[0m,
  of the ascii codes of all the [characters] in the printed
  representation.

  Ideally, you would like the checksum of an object to be uniquely
  associated with that object, like a fingerprint.  It could then be
  used as a convenient way to recognize the object in the future: you
  could remember the checksum (which is relatively small) and when an
  object is presented to you and alleged to be the special one you
  could compute its checksum and see if indeed it was.  Alas, there
  are many more objects than checksums (after all, each checksum is
  an object, and then there's [47mt[0m).  So you try to design a checksum
  algorithm that maps similar looking objects far apart, in the hopes
  that corruptions and counterfeits --- which appear to be similar to
  the object --- have different checksums.  Nevertheless, the best
  you can do is a many-to-one map.  If an object with a different
  checksum is presented, you can be positive it is not the special
  object.  But if an object with the same checksum is presented, you
  have no grounds for positive identification.

  The basic checksum algorithm in ACL2 is called [47mcheck-sum-obj[0m, which
  computes the checksum of an ACL2 object.  Roughly speaking, we scan
  the print representation of the object and, for each character
  encountered, we multiply the ascii code of the character times its
  position in the stream (modulo a certain prime) and then add
  (modulo a certain prime) that into the running sum.  This is
  inaccurate in many senses (for example, we don't always use the
  ascii code and we see numbers as though they were printed in base
  127) but indicates the basic idea.")
 (CLAUSE
  (MISCELLANEOUS)
  "A representation of prover goals

  In ACL2, a [3mclause[0m is a list of [term]s, and the meaning of a clause
  is the ACL2 disjunction of those terms where a term [47mp[0m is considered
  ``false'' if ``[47mp[0m = [47mnil[0m'' and is true otherwise.  The elements of a
  clause are called ``literals,'' even though they are just terms.
  For example the goal [47m(IMPLIES (AND p q) r)[0m is internally
  represented as the clause [47m((NOT p) (NOT q) r)[0m.  The literals of
  that clause are the terms [47m(NOT p)[0m, [47m(NOT q)[0m, and [47mr[0m.

  The ACL2 prover acts on clauses: a goal is represented as a clause,
  and each of the resulting subgoals is represented as a clause.
  Thus, the terms (literals) in a clause are all translated (see
  [term]).

  To be precise, suppose that [47m(L1 .. Lk M)[0m is a clause containing at
  least two literals.  ACL2 proof output displays that clause as an
  implication; this is called ``prettyifying a clause''.  Below, [47m~Li[0m
  denotes the [3mnegation[0m of [47mLi[0m in the following sense: if [47mLi[0m is of the
  form [47m(NOT P)[0m then [47m~Li[0m designates [47mP[0m, and otherwise [47m~Li[0m designates
  [47m(NOT Li)[0m.

      [31;1mPrettyifying a clause with at least two literals[0m

        (L1 .. Lk M)

      transforms it to the term

        (IMPLIES (AND ~L1 ~L2 ... ~Lk)
                 M).

  Of course, the disjunction represented by the clause is
  propositionally equivalent to the resulting call of [47mIMPLIES[0m.

  It is sometimes helpful to understand that ACL2's proof processes all
  operate on clauses.  In particular, proof output --- obtained when
  [gag-mode] is turned off or when using [47m:[0m[47m[pso][0m or related utilities
  --- may include a parenthetical remark as follows.  [31;1mWARNING[0m: This
  parenthetical remark is printed only by the main simplifier, not by
  the preprocessor (see [simple]).

    This simplifies (dropping false conclusion; see :DOC clause), using ....

  What this remark signifies is that the last literal of the clause is
  false in at least one subgoal, and therefore does not appear in it
  (even in rewritten form).  Let's see how that works with the
  following example.

    (defstub foo (x) t)
    (defaxiom foo-consp (implies (consp x) (foo x)))
    (set-gag-mode nil)
    (thm (implies (and (consp x) (natp (car x))) (not (foo x))))

  The proof attempt starts as follows.

    ACL2 !>(thm (implies (and (consp x) (natp (car x))) (not (foo x))))

    By the simple :definition NATP we reduce the conjecture to

    Goal'
    (IMPLIES (AND (CONSP X)
                  (INTEGERP (CAR X))
                  (<= 0 (CAR X)))
             (NOT (FOO X))).

    This simplifies (dropping false conclusion; see :DOC clause), using
    the :rewrite rule FOO-CONSP, to

    Goal''
    (IMPLIES (AND (CONSP X) (INTEGERP (CAR X)))
             (< (CAR X) 0)).

  The change from [47mGoal'[0m to [47mGoal''[0m may be jarring because the
  ``conclusion'' --- the second argument of the displayed [47mIMPLIES[0m
  call --- has changed drastically.  Let's analyze this change from
  the perspective of the goals printed; then we'll look at it from
  the perspective of clauses.

  A moment's reflection shows that because of the rule [47mFOO-CONSP[0m, [47mGoal'[0m
  is equivalent to

    (IMPLIES (AND (CONSP X)
                  (INTEGERP (CAR X))
                  (<= 0 (CAR X)))
             NIL).

  And a little more reflection shows that the term above is
  propositionally equivalent to [47mGoal''[0m above.

  But this may make more sense if we consider the clauses on which the
  prover operated.  Here are the clauses for [47mGoal'[0m and [47mGoal''[0m; the
  corresponding [47mIMPLIES[0m terms displayed above are obtained by
  prettyifying the respective clauses (in the sense of
  ``prettyifying'' discussed above).

    Goal'
    ((NOT (CONSP X))
     (NOT (INTEGERP (CAR X)))
     (< (CAR X) '0)
     (NOT (FOO X)))

    Goal''
    ((NOT (CONSP X))
     (NOT (INTEGERP (CAR X)))
     (< (CAR X) '0))

  For each of these clauses, the third literal, [47m(< (CAR X) '0)[0m, is just
  the negation of the (untranslated) [term], [47m(<= 0 (CAR X))[0m, shown in
  the prover output.

  Recall that a clause represents the disjunction of its literals.
  Since the last literal of [47mGoal'[0m, [47m(NOT (FOO X))[0m, rewrote to [47mNIL[0m
  using the rule [47mFOO-CONSP[0m, it was dropped when creating [47mGoal''[0m:
  after all, [47m(OR P NIL)[0m is propositionally equivalent to [47mP[0m.  So in
  [47mGoal''[0m the last literal is [47m(< (CAR X) '0)[0m.  Therefore, the
  conclusion of each [47mIMPLIES[0m term obtained by prettyifying the clause
  has changed from [47m(NOT (FOO X))[0m to [47m(< (CAR X) '0)[0m.

  Finally, note that although ``dropping false conclusion'' signifies
  that the conclusion was dropped in at least one subgoal, if however
  there are at least two subgoals then it might not be dropped in all
  of them.  Consider the following variant of the earlier example.

    (defstub foo (x) t)
    (defaxiom foo-consp (implies (consp x) (foo x)))
    (set-gag-mode nil)
    (defstub bar (x) t)
    ; The proof fails for the following event (not important here).
    (thm (implies (and (or (bar x) (consp x)) (natp (car x)))
                  (not (foo x)))
         :otf-flg t)

  The output includes the following.

    Goal'
    (IMPLIES (AND (OR (BAR X) (CONSP X))
                  (INTEGERP (CAR X))
                  (<= 0 (CAR X)))
             (NOT (FOO X))).

    This simplifies (dropping false conclusion; see :DOC clause), using
    the :rewrite rule FOO-CONSP, to the following two conjectures.

    Subgoal 2
    (IMPLIES (AND (BAR X)
                  (INTEGERP (CAR X))
                  (<= 0 (CAR X)))
             (NOT (FOO X))).

    [[.. output elided ..]]

    Subgoal 1
    (IMPLIES (AND (CONSP X) (INTEGERP (CAR X)))
             (< (CAR X) 0)).

  We see that the conclusion was false, hence dropped, in Subgoal 1,
  but remained in Subgoal 2.")
 (CLAUSE-IDENTIFIER
  (GOAL-SPEC)
  "The internal form of a [goal-spec]

  To each goal-spec, [47mstr[0m, there corresponds a [clause]-identifier
  produced by [47m(parse-clause-id str)[0m.  For example,

    (parse-clause-id \"[2]Subgoal *4.5.6/7.8.9'''\")

  returns [47m((2 4 5 6) (7 8 9) . 3)[0m.

  The function [47mstring-for-tilde-@-clause-id-phrase[0m inverts
  [47mparse-clause-id[0m in the sense that given a clause identifier it
  returns the corresponding goal-spec.

  As noted in the documentation for [goal-spec], each clause printed in
  the theorem prover's proof attempt is identified by a name.  When
  these names are represented as strings they are called ``goal
  specs.'' Such strings are used to specify where in the proof
  attempt a given hint is to be applied.  The function
  [47mparse-clause-id[0m converts goal-specs into clause identifiers, which
  are cons-trees containing natural numbers (and if [47m:OR[0m [hints] are
  used, they may also contain symbols of the form [47mDn[0m where [47mn[0m is a
  natural number, e.g., [47mD23[0m.)

  Examples of goal-specs and their corresponding clause identifiers are
  shown below.

                 parse-clause-id
                       -->

    \"Goal\"                       ((0) NIL . 0)
    \"Subgoal 3.2.1'\"             ((0) (3 2 1) . 1)
    \"[2]Subgoal *4.5.6/7.8.9'''\" ((2 4 5 6) (7 8 9) . 3)

                       <--
          string-for-tilde-@-clause-id-phrase

  The caar of a clause id specifies the forcing round, the cdar
  specifies the goal being proved by induction, the cadr specifies
  the particular subgoal, and the cddr is the number of primes in
  that subgoal.

  Internally, the system maintains clause ids, not goal-specs.  The
  system prints clause ids in the form shown by goal-specs.  When a
  goal-spec is used in a hint, it is parsed (before the proof attempt
  begins) into a clause id.  During the proof attempt, the system
  watches for the clause id and uses the corresponding hint when the
  id arises.  (Because of the expense of creating and garbage
  collecting a lot of strings, this design is more efficient than the
  alternative.)")
 (CLAUSE-PROCESSOR
  (RULE-CLASSES)
  "Make or apply a [47m:clause-processor[0m rule (goal-level simplifier)

  See [rule-classes] for a general discussion of rule classes,
  including how they are used to build rules from formulas and a
  discussion of the various keywords in a rule class description.

  We will introduce clause-processor rules by way of the following
  example.  But note that the clause-processor utility is more
  general than this example may suggest; for example, the second
  argument of [47mevl0[0m in the hypothesis need not be the same as its
  second argument in the conclusion.

    ; Example (which we'll return to, below):
    (defthm correctness-of-note-fact-clause-processor
      (implies (and (pseudo-term-listp cl)
                    (alistp a)
                    (evl0 (conjoin-clauses
                           (note-fact-clause-processor cl term))
                          a))
               (evl0 (disjoin cl) a))
      :rule-classes :clause-processor)

  We begin this documentation with an introduction, focusing on the
  example above, and then conclude with a detailed general discussion
  of clause-processor rules.  You might find it most useful simply to
  look at the examples in community books directory
  [47mbooks/clause-processors/[0m; see file [47mReadme.lsp[0m in that directory.

  Also see [define-trusted-clause-processor] for documentation of an
  analogous utility that does not require the clause-processor to be
  proved correct.  But please read the present documentation before
  reading about that utility.  Both utilities designate functions as
  ``clause-processors''.  Such functions must be executable --- hence
  not constrained by virtue of being introduced in the [signature] of
  an [47m[encapsulate][0m --- and must respect [stobj], [df], and output
  arity restrictions.  For example, something like [47m(car (mv ...))[0m is
  illegal; also see [signature].

  INTRODUCTION

  A [47m:clause-processor[0m rule installs a simplifier at the level of goals,
  where a goal is represented as a [clause]: a list of [term]s that
  is implicitly viewed as a disjunction (the application of [47m[or][0m).
  For example, if ACL2 prints a goal in the form [47m(implies (and p q)
  r)[0m, then the clause might be the one-element list containing the
  internal representation of this term --- [47m(implies (if p q 'nil) r)[0m
  --- but more likely, the corresponding clause is [47m((not p) (not q)
  r)[0m.  Note that the members of a clause are [3mtranslated[0m terms; see
  [term] and [47m[termp][0m.  For example, they do not contain calls of the
  macro [47mAND[0m, and constants are quoted.  The result of running a
  clause-processor must be a list of legal clauses; see [meta] for a
  discussion of translated terms, and for related discussion about
  ``forbidden'' function symbols, [set-skip-meta-termp-checks].

  The recognizer for a clause is the function [47m[term-listp][0m and the
  recognizer for a list of clauses is [47m[term-list-listp][0m.

  Note that clause-processor simplifiers are similar to metafunctions,
  and similar efficiency considerations apply.  See [meta], in
  particular the discussion on how to ``make a metafunction maximally
  efficient.''

  Unlike rules of class [47m:[0m[47m[meta][0m, rules of class [47m:clause-processor[0m must
  be applied by explicit [47m:clause-processor[0m [hints]; they are not
  applied automatically (unless by way of computed hints; see
  [computed-hints]).  But [47m:clause-processor[0m rules can be useful in
  situations for which it is more convenient to code a simplifier
  that manipulates the entire goal clause rather than individual
  subterms of terms in the clause.

  We begin with a simple illustrative example: a clause-processor that
  assumes an alleged fact (named [47mterm[0m in the example) and creates a
  separate goal to prove that fact.  We can extend the hypotheses of
  the current goal (named [47mcl[0m in the example) with a term by adding
  the negation of that term to the clause (disjunctive)
  representation of that goal.  So the following returns a list of
  two clauses: the result of adding [47mterm[0m as a hypothesis to the input
  clause, as just described, and a second clause consisting only of
  that term.  This list of two clauses can be viewed as the
  conjunction of the first clause and the second clause (where again,
  each clause is viewed as a disjunction).

    (defun note-fact-clause-processor (cl term)
      (declare (xargs :guard t)) ; optional, for better efficiency
      (list (cons (list 'not term)
                  cl)
            (list term)))

  As with [47m:[0m[47m[meta][0m rules, we need to introduce a suitable evaluator; see
  [defevaluator] if you want details.  Since we expect to reason
  about the function [47m[not][0m, because of its role in
  [47mnote-fact-clause-processor[0m as defined above, we include [47mNOT[0m in the
  set of functions known to this evaluator.  We also include [47mIF[0m, as
  is often a good idea.

    (defevaluator evl0 evl0-list
      ((not x) (if x y z)))

  ACL2 can now prove the following theorem automatically.  (This is the
  example displayed at the outset of this [documentation] topic.)  Of
  course, [47m:clause-processor[0m rules about clause-processor functions
  less trivial than [47mnote-fact-clause-processor[0m may require lemmas to
  be proved first!  The function [47mdisjoin[0m takes a clause and returns
  its disjunction (the result of applying [47m[or][0m to its members), and
  [47mconjoin-clauses[0m applies [47mdisjoin[0m to every element of a given list of
  clauses and then conjoins (applies [47mAND[0m) to the corresponding list
  of resulting terms.

    (defthm correctness-of-note-fact-clause-processor
      (implies (and (pseudo-term-listp cl)
                    (alistp a)
                    (evl0 (conjoin-clauses
                           (note-fact-clause-processor cl term))
                          a))
               (evl0 (disjoin cl) a))
      :rule-classes :clause-processor)

  Now let us submit a silly but illustrative example theorem to ACL2,
  to show how a corresponding [47m:clause-processor[0m hint is applied.  The
  hint says to apply the clause-processor function,
  [47mnote-fact-clause-processor[0m, to the current goal clause and a ``user
  hint'' as the second argument of that function, in this case [47m(equal
  a a)[0m.  Thus, a specific variable, [47mclause[0m, is always bound to the
  current goal clause for the evaluation of the [47m:clause-processor[0m
  hint, to produce a list of clauses.  Since two subgoals are created
  below, we know that this list contained two clauses.  Indeed, these
  are the clauses returned when [47mnote-fact-clause-processor[0m is applied
  to two arguments: the current clause, which is the one-element list
  [47m((equal (car (cons x y)) x))[0m, and the user hint, [47m(equal a a)[0m.

    ACL2 !>(thm (equal (car (cons x y))
                       x)
                :hints
                ((\"Goal\"
                  :clause-processor
                  (note-fact-clause-processor clause '(equal a a)))))

    [Note:  A hint was supplied for the goal above.  Thanks!]

    We now apply the verified :CLAUSE-PROCESSOR function NOTE-FACT-CLAUSE-
    PROCESSOR to produce two new subgoals.

    Subgoal 2
    (IMPLIES (EQUAL A A)
             (EQUAL (CAR (CONS X Y)) X)).

    But we reduce the conjecture to T, by the :executable-counterpart of
    IF and the simple :rewrite rule CAR-CONS.

    Subgoal 1
    (EQUAL A A).

    But we reduce the conjecture to T, by primitive type reasoning.

    Q.E.D.

    Summary
    Form:  ( THM ...)
    Rules: ((:EXECUTABLE-COUNTERPART IF)
            (:EXECUTABLE-COUNTERPART NOT)
            (:FAKE-RUNE-FOR-TYPE-SET NIL)
            (:REWRITE CAR-CONS))
    Warnings:  None
    Time:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)

    Proof succeeded.
    ACL2 !>

  That concludes our introduction to clause-processor rules and hints.
  We turn now to detailed documentation.

  DETAILED DOCUMENTATION

  The [signature] of a clause-processor function, [47mCL-PROC[0m, must have
  one of the following forms.  Here, each [47mst_i[0m is a [stobj] (possibly
  [47m[state][0m) while the other parameters and results are not stobjs (see
  [stobj]).  Note that there need not be input stobjs in [3] ---
  i.e., [47mk[0m can be 0 --- and even if there are, there need not be
  output stobjs.  In most ways [3] and [3+] are treated similarly;
  see [make-summary-data] for a discussion of the form of [47md[0m in [3+]
  and, more generally, for how [3+] differs from [3] by enhancing the
  [summary].

    [1]  ((CL-PROC cl) => cl-list)

    [2]  ((CL-PROC cl hint) => cl-list)

    [3]  ((CL-PROC cl hint st_1 ... st_k) => (mv erp cl-list st_i1 ... st_in))

    [3+] ((CL-PROC cl hint st_1 ... st_k) => (mv erp cl-list st_i1 ... st_in d))

  We call [47mcl-list[0m the [3mclauses-result[0m.  In [3] and [3+], we think of the
  first component of the result as an error flag.  Indeed, a proof
  will instantly abort if that error flag is not [47mnil[0m.

  We next discuss the legal forms of [47m:clause-processor[0m rules, followed
  below by a discussion of [47m:clause-processor[0m [hints].  In the
  discussion below, we use lower-case names to represent specific
  symbols, for example [47mimplies[0m, and also to represent [stobj] names;
  and we use upper-case names to represent arbitrary pieces of syntax
  (which we will describe), for example, [47mCL[0m.

  If a [47m:[0m[47m[rule-classes][0m specification includes [47m:clause-processor[0m, then
  the corresponding term must have the following form.  (Additional
  ``meta-extract'' hypotheses, not shown or discussed below, may be
  included as desired in order to use facts from the logical [47m[world][0m
  to help prove the rule; see [meta-extract] for explanation of this
  advanced feature.)

    ; General Form (omitting possible meta-extract hypotheses)
    (implies (and (pseudo-term-listp CL)
                  (alistp A)
                  (EVL (conjoin-clauses <CL-LIST>)
                        B))
             (EVL (disjoin CL) A))

  Here [47mEVL[0m is a known evaluator; [47mCL[0m and [47mA[0m are distinct non-stobj
  variables; and [47m<CL-LIST>[0m is an expression representing the clauses
  returned by the clause-processor function [47mCL-PROC[0m, whose form
  depends on the [signature] of that function, as follows.  Typically
  [47mB[0m is [47mA[0m, but it can be any term (useful when generalization is
  occurring; see the example ``Test generalizing alist'' in community
  book [47mbooks/clause-processors/basic-examples.lisp[0m).  For cases [1]
  and [2] above, [47m<CL-LIST>[0m is of the form [47m(CL-PROC CL)[0m or [47m(CL-PROC CL
  HINT)[0m, respectively, where in the latter case [47mHINT[0m is a non-stobj
  variable distinct from the variables [47mCL[0m and [47mA[0m.  For cases [3] and
  [3+], [47m<CL-LIST>[0m is the result of wrapping the function
  [47mclauses-result[0m around a call of [47mCL-PROC[0m:

    (clauses-result (CL-PROC CL HINT ...))

  Logically, [47mclauses-result[0m returns the [47m[cadr][0m if the [47m[car][0m is [47mNIL[0m, and
  otherwise (for the error case) returns a list containing the empty
  (false) clause.  So in the non-error case, [47mclauses-result[0m picks out
  the second result, denoted [47mcl-list[0m in [3] and [3+] above, and in
  the error case the implication above trivially holds.

  In the above theorem, we are asked to prove [47m(EVL (disjoin CL) A)[0m
  assuming that the conjunction of all clauses produced by the clause
  processor evaluates to a non-[47mnil[0m value under some alist [47mB[0m.  In
  fact, we can choose [47mB[0m so as to allow us to assume evaluations of
  the generated clauses over many different alists.  This technique
  is discussed in the community book
  [47mbooks/clause-processors/multi-env-trick.lisp[0m, which introduces some
  macros that may be helpful in accomplishing proofs of this type.

  The clause-processor function, [47mCL[0m, must have a guard that ACL2 can
  trivially prove from the hypotheses that the first argument of [47mCL[0m
  is known to be a [47mpseudo-term-listp[0m and any [stobj] arguments are
  assumed to satisfy their stobj predicates.

  Next we specify the legal forms for [47m:clause-processor[0m [hints].  The
  basic form is [47m:clause-processor TERM[0m, such that the translation of
  [47mTERM[0m to a legal ACL2 term yields a call of a clause-processor
  function [47m(CL-PROC clause)[0m or [47m(CL-PROC clause HINT ...)[0m, where [47mHINT[0m
  is a term whose only non-stobj free variable (if any) is the
  symbol, [47mclause[0m.  Note that the first argument of the call is
  literally the variable, [47mclause[0m.  Recall that at the time the
  :clause-processor hint is applied to the clausal form [47mCL[0m of the
  current subgoal, [47mclause[0m is bound to [47mCL[0m; moreover, any stobj names
  will be bound to the corresponding stobjs.

  But there are two additional general forms for [47m:clause-processor[0m
  hints, which may viewed as abbreviations for the basic form
  discussed above.  The first additional general form, which we call
  the ``[47m:function[0m form'', includes the following two classes of
  expressions.

    :clause-processor (:function F)
    :clause-processor (:function F :hint HINT)

  The first of these [47m:function[0m forms abbreviates the following hint,
  where either [47mF[0m is a macro-alias for the function symbol [47mCL-PROC[0m
  (see [add-macro-alias]), and otherwise [47mCL-PROC[0m is just the function
  symbol [47mF[0m.

    :clause-processor (CL-PROC clause)

  Similarly the second of the [47m:function[0m forms above abbreviates the
  following, where [47mCL-PROC[0m is as above and the output signature of
  [47mCL-PROC[0m is [47m(nil nil st_1 ... st_k)[0m.

    :clause-processor (CL-PROC clause HINT st_1 ... st_k)

  Besides the ``[47m:function[0m form'', there is one more additional general
  form for [47m:clause-processor[0m hint: a symbol, as follows.

    :clause-processor F

  This expands to a basic form as follows, depending on [47mF[0m.

    * If [47mF[0m is a macro with one required argument or a function symbol with
      one argument:
      [47m:clause-processor (F clause)[0m

    * If [47mF[0m is a macro with two required arguments or a function symbol with
      two arguments:
      [47m:clause-processor (F clause nil)[0m

    * If [47mF[0m is a function symbol with inputs of the form [3] or [3+] above,
      that is, with input signature [47m(nil nil st_1 ... st_k)[0m:
      [47m:clause-processor (F clause nil st_1 ... st_k)[0m

  For examples of these syntactic forms, see community book
  [47mbooks/clause-processors/basic-examples.lisp[0m).  We turn now to
  discussion of when a [47m:clause-processor[0m hint causes an abort.

  A [47m:clause-processor[0m hint causes the proof to abort if the
  clauses-result is not a list of clauses, i.e., a list of
  (translated) [term] lists in the current logical [world].  This
  test is done explicitly every time a clause processor is run unless
  a [47m:[0m[47m[well-formedness-guarantee][0m has been provided with the
  [47m:clause-processor[0m rule or [47m[set-skip-meta-termp-checks][0m has been
  used with an active trust tag to skip the check at the user's risk.

  The proof also aborts when the clause-processor function returns at
  least two values and the first value returned --- the ``[47merp[0m'' value
  from cases [3] and [3+] above --- is not [47mnil[0m.  In that case, [47merp[0m is
  used for printing an error message as follows: if it is a string,
  then that string is printed; but if it is a non-empty true list
  whose first element is a string, then it is printed as though by
  [47m(fmt ~@0 (list (cons #\\0 erp)) ...)[0m (see [fmt]).  Otherwise, a
  non-[47mnil[0m [47merp[0m value causes a generic error message to be printed.

  If there is no error as above, but the [47mCL-PROC[0m call returns a clause
  list whose single element is equal to the input clause, then the
  hint is ignored since we are left with the goal with which we
  started.  In that case, the other prover processes are then applied
  as usual (see [hints-and-the-waterfall]).

  You can see all current [47m:clause-processor[0m rules by issuing the
  following command: [47m(print-clause-processor-rules)[0m.

  The following paper discusses ACL2 clause-processors at a high level
  suitable for a non-ACL2 audience:

      M. Kaufmann, J S. Moore, S. Ray, and E. Reeber, ``Integrating
      External Deduction Tools with ACL2.'' [3mJournal of Applied Logic[0m
      (Special Issue: Empirically Successful Computerized Reasoning),
      Volume 7, Issue 1, March 2009, pp. 3--25.  Also published
      online (DOI [47m10.1016/j.jal.2007.07.002[0m).  Preliminary version
      in: Proceedings of the 6th International Workshop on the
      Implementation of Logics (IWIL 2006) (C. Benzmueller, B.
      Fischer, and G. Sutcliffe, editors), {CEUR Workshop Proceedings
      Vol. 212 | http://ceur-ws.org/Vol-212/}, Phnom Penh, Cambodia,
      pp. 7--26, November 2006.


Subtopics

  [Make-summary-data]
      Return summary data from a [clause-processor] function

  [Meta-extract]
      Meta reasoning using valid terms extracted from context or [world]

  [Set-skip-meta-termp-checks]
      Skip output checks for [meta] functions and [clause-processor]s

  [Set-skip-meta-termp-checks!]
      Skip output checks non-[local]ly for [meta] functions and
      [clause-processor]s")
 (CLEAR-MEMOIZE-STATISTICS
  (MEMOIZE)
  "Clears all profiling info displayed by [47m([0m[47m[memoize-summary][0m[47m)[0m

  Logically, this function just returns [47mnil[0m.  It clears all profiling
  info displayed by [47m([0m[47m[memoize-summary][0m[47m)[0m

  [31;1mFunction: [0m<clear-memoize-statistics>

    (defun clear-memoize-statistics nil
      (declare (xargs :guard t))
      nil)")
 (CLEAR-MEMOIZE-TABLE
  (MEMOIZE)
  "Forget values remembered for the given function

  This function returns its argument, [47mfn[0m, unchanged.  The values
  memoized for [47mfn[0m are forgotten.

  [31;1mFunction: [0m<clear-memoize-table>

    (defun clear-memoize-table (fn)
      (declare (xargs :guard t))
      fn)")
 (CLEAR-MEMOIZE-TABLES
  (MEMOIZE)
  "Forget values remembered for all the memoized functions

  [47mClear-memoize-tables[0m is a logical no-op.  All memoized values are
  forgotten.  It returns [47mnil[0m, invoking [47m[clear-memoize-table][0m for each
  memoized function.

  [31;1mFunction: [0m<clear-memoize-tables>

    (defun clear-memoize-tables nil
      (declare (xargs :guard t))
      nil)")
 (CLOSE-INPUT-CHANNEL (POINTERS)
                      "See [io].")
 (CLOSE-OUTPUT-CHANNEL (POINTERS)
                       "See [io].")
 (CLOSE-TRACE-FILE
  (TRACE)
  "Stop redirecting trace output to a file

    General Form:
    (close-trace-file) ; trace output is no longer redirected to a file

  Output from [47m[trace$][0m normally goes to the screen, or more precisely,
  [47m[standard-co][0m.  It can be redirected to a file; see
  [open-trace-file].  Use [47mclose-trace-file[0m to redirect trace output
  to [47m[standard-co][0m.")
 (CODE-CHAR
  (CHARACTERS NUMBERS ACL2-BUILT-INS)
  "The character corresponding to a given numeric code

  This function maps a numeric code to the corresponding character, for
  example: [47m(code-char 65)[0m evaluates to [47m#\\A[0m.  See [47m[char-code][0m for a
  sort of inverse function, which maps a character to its code.

  Completion Axiom ([47mcompletion-of-code-char[0m):

    (equal (code-char x)
           (if (and (integerp x)
                    (>= x 0)
                    (< x 256))
               (code-char x)
             (code-char 0)))

  [Guard] for [47m(code-char x)[0m:

    (and (integerp x)
         (>= x 0)
         (< x 256))

  ACL2 supports 8-bit [characters].  Inputs not between [47m0[0m and [47m255[0m are
  treated as [47m0[0m.")
 (COERCE
  (STRINGS CHARACTERS ACL2-BUILT-INS)
  "Coerce a character list to a string and a string to a list

  Completion Axiom ([47mcompletion-of-coerce[0m):

    (equal (coerce x y)
           (cond
            ((equal y 'list)
             (if (stringp x)
                 (coerce x 'list)
               nil))
            (t
             (coerce (make-character-list x) 'string))))

  [Guard] for [47m(coerce x y)[0m:

    (if (equal y 'list)
        (stringp x)
      (if (equal y 'string)
          (character-listp x)
        nil))

  Also see community book [47mbooks/misc/fast-coerce.lisp[0m, contributed by
  Jared Davis, for a version of [47mcoerce[0m that may be faster for Common
  Lisp implementations other than CCL 1.3 or later, if the second
  argument is [47m'list[0m (for coercing a string to a list).

  Logical Note

  The function [47mcoerce[0m can be viewed as the constructor for strings.  As
  discussed in Section 7 of \"{A Precise Description of the ACL2 Logic
  | http://www.cs.utexas.edu/users/moore/publications/km97a.pdf}\"
  (Matt Kaufmann and J Moore, April, 1998), a string may be built by
  coercing its list of characters: for example, [47m\"abc\"[0m is [47m(coerce
  '(#\\a #\\b #\\c) 'string)[0m.  More precisely, [47m\"abc\"[0m is an abbreviation
  for [47m(coerce '(#\\a #\\b #\\c) 'string)[0m, where even more pedantically,
  [47m'(#\\a #\\b #\\c)[0m is an abbreviation for [47m(cons '#\\a (cons '#\\b (cons
  '#\\c 'nil)))[0m.")
 (COHERENCE (POINTERS)
            "See [wormhole-status].")
 (COLLECT$ (POINTERS) "See [loop$].")
 (COLLECT$+ (POINTERS) "See [loop$].")
 (COMMA (POINTERS) "See [backquote].")
 (COMMA-ATSIGN (POINTERS)
               "See [backquote].")
 (COMMAND
  (HISTORY)
  "Forms you type at the top-level, but...

  ...the word ``command'' usually refers to a top-level form whose
  evaluation produces a new logical [world].

    Typical commands are:
    (defun foo (x) (cons x x))
    (defthm consp-foo (consp (foo x)))
    (defrec pair (hd . tl) nil)

  The first two forms are examples of commands that are in fact
  primitive [events].  See [events].  [47mDefrec[0m, on the other hand, is a
  macro that expands into a [47m[progn][0m of several primitive [events].
  In general, a [world] extending command generates one or more
  [events].

  Both [events] and commands leave landmarks on the [world] that enable
  us to determine how the given [world] was created from the previous
  one.  Most of your interactions will occur at the command level,
  i.e., you type commands, you print previous commands, and you undo
  back through commands.  Commands are denoted by command
  descriptors.  See [command-descriptor].")
 (COMMAND-DESCRIPTOR
  (HISTORY)
  "An object describing a particular [command] typed by the user

    Examples:

    :max      ; the command most recently typed by the user
    :x        ; synonymous with :max
    (:x -1)   ; the command before the most recent one
    (:x -2)   ; the command before that
    :x-2      ; synonymous with (:x -2)
    5         ; the fifth command typed by the user
    1         ; the first command typed by the user
    0         ; the last command of the system initialization
    -1        ; the next-to-last initialization command
    :min      ; the first command of the initialization
    :start    ; the last command of the initial ACL2 logical world
    fn        ; the command that introduced the logical name fn
    (:search (defmacro foo-bar))
              ; the first command encountered in a search from :max to
              ; 0 that either contains defmacro and foo-bar in the
              ; command form or contains defmacro and foo-bar in some
              ; event within its block.

  The recorded [history] of your interactions with the top-level ACL2
  [command] loop is marked by the [command]s you typed that changed
  the logical [world].  Each such [command] generated one or more
  [events], since the only way for you to change the logical [world]
  is to execute an event function.  See [command] and see [events].
  We divide [history] into ``[command] blocks,'' grouping together
  each [world] changing [command] and its [events].  A ``[command]
  descriptor'' is an object that can be used to describe a particular
  [command] in the [history] of the ongoing session.

  Each [command] is assigned a unique integer called its ``[command]
  number'' which indicates the [command]'s position in the
  chronological ordering of all of the [command]s ever executed in
  this session (including those executed to initialize the system).
  We assign the number 1 to the first [command] you type to ACL2.  We
  assign 2 to the second and so on.  The non-positive integers are
  assigned to ``prehistoric'' [command]s, i.e., the [command]s used
  to initialize the ACL2 system: 0 is the last [command] of the
  initialization, -1 is the one before that, etc.

  The legal [command] descriptors are described below.  We use [47mn[0m to
  denote any integer, [47msym[0m to denote any logical name (see
  [logical-name]), and [47mcd[0m to denote, recursively, any [command]
  descriptor.

     command                   command
    descriptor                described

    :max   -- the most recently executed command (i.e., the one with
              the largest command number)
    :x     -- synonymous with :max
    :x-k   -- synonymous with (:x -k), if k is an integer and k>0
    :min   -- the earliest command (i.e., the one with the smallest
              command number and hence the first command of the system
              initialization)
    :start -- the last command when ACL2 starts up
    n      -- command number n  (If n is not in the
              range :min<=n<=:max, n is replaced by the nearest of :min
              and :max.)
    sym    -- the command that introduced the logical name sym
    (cd n) -- the command whose number is n plus the command number of
              the command described by cd
    (:search pat cd1 cd2)
              In this command descriptor, pat must be either an atom or
              a true list of atoms and cd1 and cd2 must be command
              descriptors.  We search the interval from cd1 through cd2
              for the first command that matches pat.  Note that if cd1
              occurs chronologically after cd2, the search is
              ``backwards'' through history while if cd1 occurs
              chronologically before cd2, the search is ``forwards''.  A
              backwards search will find the most recent match; a
              forward search will find the chronologically earliest
              match.  A command matches pat if either the command form
              itself or one of the events in the block contains pat (or
              all of the atoms in pat if pat is a list).
    (:search pat)
              the command found by (:search pat :max 0), i.e., the most
              recent command matching pat that was part of the user's
              session, not part of the system initialization.")
 (COMMAND-LINE
  (INTERFACING-TOOLS)
  "Handling of command-line arguments when ACL2 is invoked

  You may provide command-line arguments when invoking ACL2, which are
  passed to the host Lisp.  For more information on this topic, along
  with a discussion of how to save an ACL2 executable that avoids
  passing command-line arguments to the host Lisp, see [save-exec].


Subtopics

  [Save-exec]
      Save an executable image and a wrapper script")
 (COMMENT
  (HIDE ACL2-BUILT-INS)
  "Variant of [47m[prog2$][0m to help debug evaluation failures during proofs

  Semantically, [47m(comment x y)[0m equals [47my[0m; the value of [47mx[0m is ignored.
  Thus [47mcomment[0m is much like [47m[prog2$][0m.  However, when you see a call
  of [47mcomment[0m in ACL2 proof output, it will likely be under a call of
  [47m[hide][0m, with information that may be helpful in understanding why
  the call of [47mhide[0m was inserted.  Below we illustrate the various
  ways in which ACL2 may replace a term [47mtm[0m by [47m(hide (comment \"...\"
  tm))[0m.  (On occasion you will simply see [47m(hide tm)[0m; such cases are
  not discussed here.)

  Also see [hide] for further discussion of how to avoid such proof
  failures, and for how to keep the prover from inserting a [47mcomment[0m
  call under a call of [47m[hide][0m.


Evaluation during rewriting

  Forms:

    (HIDE (COMMENT \"Failed attempt to call constrained function <fn>\" <term>))
    (HIDE (COMMENT \"Failed attempt to call non-executable function <fn>\" <term>))

  Consider the following example.

    (defstub f (x) t)
    (defun g (x) (cons (f x) x))
    (defund h (x) (cons x (cdr (g x))))
    (thm (equal (h 3) '(3 . 3)))

  Note that the [definition] of [47mh[0m is disabled, but its
  [executable-counterpart] is not.  The proof attempt fails for the
  [47m[thm][0m call, indicating the checkpoint shown below.

    *** Key checkpoint at the top level: ***

    Goal'
    (EQUAL
     (HIDE
       (COMMENT \"Failed attempt to call constrained function F;
    see :DOC comment\"
                (H 3)))
     '(3 . 3))

  The first argument of [47mequal[0m is logically just [47m(h 3)[0m.  But the [47mcomment[0m
  and [47mhide[0m wrappers are telling us that evaluation of [47m(h 3)[0m failed
  because it led to a call of the constrained function [47mf[0m.  It is easy
  to see why in this case, by looking at the definitions, where [47mh[0m
  calls [47mg[0m, which calls [47mf[0m.  But more complicated such failures may be
  difficult to understand without such information.  In very
  complicated cases, one might even want to use the Lisp debugger
  after designating a [47m[break$][0m call using [47m[trace$][0m, like this (here,
  shown using host Lisp CCL).

    ACL2 !>(trace$ (f :entry (break$)))
     ((F :ENTRY (BREAK$)))
    ACL2 !>(thm (equal (h 3) '(3 . 3)))

    > Break: Break
    > While executing: BREAK$, in process listener(1).
    > Type :GO to continue, :POP to abort, :R for a list of available restarts.
    > If continued: Return from BREAK.
    > Type :? for other options.
    1 > :b ; user input to get backtrace
     (262932A0) : 0 (BREAK$) 157
     (262932F0) : 1 (F 3) 141
     (26293338) : 2 (FUNCALL #'#<(:INTERNAL ACL2_*1*_ACL2::G ACL2_*1*_ACL2::G)> 3) 37
     (26293350) : 3 (FUNCALL #'#<(:INTERNAL ACL2_*1*_ACL2::H ACL2_*1*_ACL2::H)> 3) 37
     (26293368) : 4 (RAW-EV-FNCALL H (3) NIL NIL [[.. output elided ..]]

  This output from Lisp is quite low-level, but reading from the bottom
  up provides the following sequence of events.

    * 4. Call [47mh[0m with argument list [47m(3)[0m.

    * 3. Call the [executable-counterpart] of [47mh[0m.

    * 2. Call the [executable-counterpart] of [47mg[0m.

    * 1. Attempt to call the constrained function, [47mf[0m.

  An easy way to avoid this proof failure is to avoid execution of
  calls of [47mh[0m and [47mg[0m, as follows.

    (thm (equal (h 3) '(3 . 3))
         :hints ((\"Goal\" :in-theory (disable (:e g) (:e h)))))

  (It actually suffices to disable only [47m(:e h)[0m, but the workings of the
  ACL2 rewriter are out of scope here.)

  If the offending function (here, [47mf[0m) is introduced as [non-executable]
  rather than constrained, in particular if that function is defined
  using [47m[defun-nx][0m or [47m[defund-nx][0m, then in the first argument of
  comment you will see ``non-executable'' instead of ``constrained''.


Evaluation during substitution

  Form:

    (HIDE
     (COMMENT
      \"Failed attempt (during substitution) to call constrained function <fn>;
    see :DOC comment\"
      <term>))

  Consider how ACL2 approaches the proof of the non-theorem below.

    (defstub foo (x) t)
    (defund bar (x) (foo x))
    (thm (implies (equal x 3) (equal (bar x) yyy)))

  The prover attacks the [47m[thm][0m event by substituting the constant [47m'3[0m
  for [47mx[0m, which results in an attempt to evaluate [47m(bar 3)[0m.  This
  evaluation fails because [47mbar[0m calls the undefined function [47mfoo[0m.  The
  checkpoint is as follows.

    (EQUAL
     (HIDE
      (COMMENT
         \"Failed attempt (during substitution) to call constrained function FOO;
    see :DOC comment\"
         (BAR 3)))
     YYY)


Failure to expand using a rule

  Form:

    (HIDE (COMMENT \"Unable to expand using the rule <name>;
    see :DOC comment\"
                   <term>))

  Consider how ACL2 approaches the proof for the second event below.

    (defthm nth-open (implies (and (consp x) (posp n))
                              (equal (nth n x) (nth (1- n) (cdr x))))
      :rule-classes ((:definition :controller-alist ((nth t t)) :install-body t)))
    (thm (equal (nth i y) zzz)
         :hints ((\"Goal\" :expand (nth i y) :do-not-induct t)))

  The checkpoint is as follows.  What happened is that the rule
  [47mnth-open[0m had a hypothesis that was false when an attempt was made
  to apply it to the term [47m(nth i y)[0m.

    (IMPLIES
     (NOT (CONSP Y))
     (EQUAL
      (HIDE (COMMENT \"Unable to expand using the rule NTH-OPEN;
    see :DOC comment\"
                     (NTH I Y)))
      ZZZ))


Failure due to disabled or missing warrants

  Forms:

    (HIDE (COMMENT \"Call failed because the rule apply$-<fn> is disabled;
    see :DOC comment\"
          <term>))
    (HIDE (COMMENT \"Call failed because the warrant for <fn> is not known to be true;
    see :DOC comment\"
          <term>))

  The first of these forms may appear when an attempt to evaluate a
  call of [47m[apply$][0m fails because a necessary [warrant] is disable)d.
  The second form may appear when the warrant is not known to be true
  in the present context, either because it is known to be false or
  because it cannot be assumed true because forcing is [disable]d.
  In the following example, the attempt to simplify the call of
  [47mapply$[0m in the theorem ultimately leads to an attempt to evaluate a
  call of [47m[ev$][0m, which ultimately fails because it leads to a call to
  evaluate [47m(apply$ 'bar '(3))[0m [47mbar[0m.  That call causes an error because
  the warrant is unavailable since the rule [47mapply$-bar[0m is disabled,
  hence cannot rewrite a term [47m(apply$ 'bar args)[0m to [47m(bar (car args))[0m.

    (include-book \"projects/apply/top\" :dir :system)
    (defun$ bar (x) x)
    (thm (implies (warrant bar)
                  (equal (apply$ '(lambda (y) (bar y)) '(3)) 3))
         :hints ((\"Goal\" :in-theory (disable apply$-bar ev$))))

  The checkpoint in the proof for the [47mthm[0m just above is as follows.

    (IMPLIES
     (APPLY$-WARRANT-BAR)
     (EQUAL
      (HIDE
       (COMMENT
          \"Call failed because the rule APPLY$-BAR is disabled;
    see :DOC comment\"
          (EV$ '(BAR Y) '((Y . 3)))))
      3))

  Similarly, if we instead submit the following event, we see the other
  such message, in this case about a false warrant.

    (thm (implies (not (warrant bar))
                  (equal (apply$ '(lambda (y) (bar y)) '(3)) 3))
         :hints ((\"Goal\" :in-theory (disable ev$))))

  Here is the resulting checkpoint.

    (IMPLIES
     (NOT (APPLY$-WARRANT-BAR))
     (EQUAL
      (HIDE
       (COMMENT
        \"Call failed because the warrant for BAR is not known to be true;
    see :DOC comment\"
        (EV$ '(BAR Y) '((Y . 3)))))
      3))

  Our final example illustrates a failure due to forcing being
  disabled.  The use of [47m[loop$][0m in the definition of [47mbar[0m expands to
  create a call of [47m[ev$][0m, which cannot be simplified during the proof
  of the [47m[thm][0m below because the necessary warrant hypothesis is
  missing and cannot be forced, since forcing is disabled (see also
  [disable-forcing]).

    (defun$ hello (x)
       (declare (xargs :guard t))
       (list 'hi x))

    (defun bar (lst)
       (declare (xargs :guard (true-listp lst)))
       (loop$ for name in lst collect (hello name))))

    (thm (equal (bar '(john))
                '((hi john)))
         :hints ((\"Goal\" :in-theory (disable (:e force)))))

  Here is the resulting checkpoint.

    (EQUAL
     (HIDE
      (COMMENT
       \"Call failed because the warrant for HELLO is not known to be true;
    see :DOC comment\"
       (EV$ '(RETURN-LAST 'PROGN
                          '(LAMBDA$ (LOOP$-IVAR)
                             (LET ((NAME LOOP$-IVAR))
                               (DECLARE (IGNORABLE NAME))
                               (HELLO NAME)))
                          ((LAMBDA (NAME) (HELLO NAME))
                           LOOP$-IVAR))
            '((LOOP$-IVAR . JOHN)))))
     '(HI JOHN))")
 (COMMON-LISP
  (ABOUT-ACL2)
  "Relation to Common Lisp, including deviations from the spec

  ACL2 is a logic, a theorem prover, and a programming language based
  on Common Lisp.  A connection with Common Lisp is established with
  guards (see [guard]).

  However, here we document potential deviations from Common Lisp
  semantics even in the presence of verified guards.  Our view is
  that these deviations are extremely unlikely to manifest; indeed,
  as of this writing we are unaware of any cases in which these
  issues arise in practice.  However, we feel obligated to
  acknowledge their possibility, which could result in surprises
  during evaluation or even proof.

  The Common Lisp spec allows certain predicates to return what it
  calls ``generalized Booleans,'' which are really arbitrary values
  that are to be viewed as either [47mnil[0m or non-[47mnil[0m.  However, in ACL2
  these functions are assumed to return [47mnil[0m or [47mt[0m.  For details, see
  [generalized-booleans].

  The execution of forms with [47m:[0m[47m[program][0m mode functions can result in
  calls of functions on arguments that do not satisfy their [guard]s.
  In practice, this simply causes hard Lisp errors.  But in principle
  one could imagine a damaged Lisp image that operates incorrectly.
  See [defun-mode-caveat].

  The Common Lisp spec, specifically Section {Section 3.2.2.3 |
  http://www.lispworks.com/documentation/HyperSpec/Body/03_bbc.htm}
  of the {Common Lisp Hyperspec |
  http://www.lispworks.com/documentation/HyperSpec/Front}, allows for
  undefined results when a function is ``multiply defined'' in a
  compiled file.  ACL2 allows redundant [47m[defun][0ms in a book, and in
  general [books] are compiled by [47mcertify-book[0m (but see
  [certify-book] and see [compilation] for how to control such
  compilation).  Moreover, ACL2 provides a redefinition capability
  (see [ld-redefinition-action] and see [redef]), and the above
  section also allows for undefined results when a function is
  defined in a compiled file and then redefined, presumably (for
  example) because of inlining.


Subtopics

  [Defun-mode-caveat]
      Potential soundness issue for functions with [defun-mode] [47m:[0m[47m[program][0m

  [Escape-to-common-lisp]
      Escaping to Common Lisp

  [Generalized-booleans]
      Potential soundness issues related to ACL2 predicates

  [Raw-lisp-error]
      Raw lisp errors")
 (COMMON_LISP
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "Common Lisp

  {IMAGE} (see [An_Example_Common_Lisp_Function_Definition])

  The logic of ACL2 is based on Common Lisp.

  Common Lisp is the standard list processing programming language.  It
  is documented in: Guy L. Steele, {[31;1mCommon Lisp The Language[0m |
  https://www.cs.cmu.edu/Groups/AI/html/cltl/cltl2.html}, Digital
  Press, 12 Crosby Drive, Bedford, MA 01730, 1990.

  ACL2 formalizes only a subset of Common Lisp.  It includes such
  familiar Lisp functions as [47mcons[0m, [47mcar[0m and [47mcdr[0m for creating and
  manipulating list structures, various arithmetic primitives such as
  [47m+[0m, [47m*[0m, [47mexpt[0m and [47m<=[0m, and [47mintern[0m and [47msymbol-name[0m for creating and
  manipulating symbols.  Control primitives include [47mcond[0m, [47mcase[0m and
  [47mif[0m, as well as function call, including recursion.  New functions
  are defined with [47mdefun[0m and macros with [47mdefmacro[0m.  See [programming]
  {ICON} (see [A_Tiny_Warning_Sign]) for a list of the Common Lisp
  primitives supported by ACL2.

  ACL2 supports five of Common Lisp's datatypes:

  * the precisely represented, unbounded numbers (integers, rationals,
  and the complex numbers with rational components, called the
  ``complex rationals'' here),

  * the characters with ASCII codes between 0 and 255

  * strings of such characters

  * symbols (including packages)

  * conses

  ACL2 is a large subset of the first-order [31;1mapplicative[0m part of Common
  Lisp.  (Roughly speaking, a language is applicative if it follows
  the rules of function application.  For example, [47mf(x)[0m must be equal
  to [47mf(x)[0m, which means, among other things, that the value of [47mf[0m must
  not be affected by ``global variables'' and the object [47mx[0m must not
  change over time.)  It does not support higher-order features of
  Common Lisp, like functional objects and [47mapply[0m.  It does not
  support Common Lisp primitives that have side-effects such as [47msetq[0m,
  [47msetf[0m, the Common Lisp Object System, etc.  However, ACL2 does
  provide some special features that can be used efficiently to do
  many of the same jobs as these omitted Common Lisp primitives.  The
  ACL2 system is largely implemented in the language it supports.

  {IMAGE} (see [An_Example_Common_Lisp_Function_Definition])")
 (COMMON_LISP_AS_A_MODELING_LANGUAGE
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "Common Lisp as a Modeling Language

  In ACL2 we have adopted Common Lisp as the basis of our modeling
  language.  If you have already read our brief note on Common Lisp
  and recall the example of [47mapp[0m, please proceed.  Otherwise click
  here (see [Common_Lisp]) for an exceedingly brief introduction to
  Common Lisp and then come [31;1mback[0m here.

  In Common Lisp it is very easy to write systems of formulas that
  manipulate discrete, inductively constructed data objects.  In
  building a model you might need to formalize the notion of
  sequences and define such operations as concatenation, length,
  whether one is a permutation of the other, etc.  It is easy to do
  this in Common Lisp.  Furthermore, if you have a Common Lisp
  ``theory of sequences'' you can [31;1mrun[0m the operations and relations
  you define.  That is, you can execute the functions on concrete
  data to see what results your formulas produce.

  If you define the function [47mapp[0m as shown above and then type

    (app '(A B) '(C D E))

  in any Common Lisp, the answer will be computed and will be [47m(A B C D
  E)[0m.

  The [31;1mexecutable[0m nature of Common Lisp and thus of ACL2 is very handy
  when producing models.

  But executability is not enough for a modeling language because the
  purpose of models is to permit analysis.

  Click here (see [Analyzing_Common_Lisp_Models]) to continue.")
 (COMMUNITY-BOOK (POINTERS)
                 "See [community-books].")
 (COMMUNITY-BOOKS
  (BOOKS)
  "Libraries of ACL2 [books] developed by the ACL2 community.

  ACL2 [books] are files of ACL2 [events] like definitions and
  theorems.

  The ACL2 [31;1mCommunity Books[0m are the canonical set of open-source books
  for ACL2, developed since the early 1990s by members of the ACL2
  community.  They include libraries for reasoning in many domains,
  macro libraries for more quickly writing and documenting code,
  interfacing tools for connecting ACL2 to other systems,
  productivity tools for better proof automation and debugging, and
  specialty libraries for areas like hardware verification.

  From the {github ACL2 project | https://github.com/acl2/acl2/} web
  site you can:

    * Download the Community Books;

    * Learn how to contribute books to the ACL2 community; and

    * Obtain updates between ACL2 releases.

  See [git-quick-start] for information about how to download the
  ``bleeding edge'' ACL2 system and community books.

  The community books are also available with ACL2 releases.  See the
  ``Installing'' link from the {ACL2 home page |
  http://www.cs.utexas.edu/users/moore/acl2/}.


Subtopics

  [Books-certification]
      Instructions for certifying the ACL2 [community-books].")
 (COMP
  (COMPILATION EVENTS ACL2-BUILT-INS)
  "Compile some ACL2 functions

  NOTE: [47mComp[0m is a no-op if explicit compilation is suppressed; see
  [compilation].  The documentation here assumes that this is not the
  case.  See [evaluation] for background on executable-counterpart
  and submitted functions.

    Examples:
    :comp t          ; compile all uncompiled ACL2 functions
    (comp t)         ; same as above, but can be put into a book
    (comp :exec)     ; compile all uncompiled executable-counterpart definitions
    :comp foo        ; compile the defined function foo (both its submitted and
                     ; executable-counterpart functions)
    :comp (:raw foo) ; compile the submitted function for the defined function foo
                     ; but not the corresponding executable-counterpart
    :comp (foo bar)  ; compile the defined functions foo and bar
    :comp (foo (:raw bar))  ; compile the defined functions foo and bar, but for
                            ; bar do not compile the executable-counterpart

    General Form:
    :comp specifier
    where specifier is one of the following:

      t                     compile all user-defined ACL2 functions that are
                              currently uncompiled (redefined built-in functions
                              are not recompiled)
      :exec                 same as t, except that only executable-counterparts
                              are compiled (see below), not submitted definitions
      :raw                  same as t, except that only submitted definitions are
                              compiled, not executable-counterparts
      (name-1 ... name-k)   a non-empty list of names of functions defined by
                              DEFUN in ACL2, except that each name-i can be of
                              the form (:raw sym) or (:exec sym), where sym is
                            the name of such a function
      name                  same as (name)

  When you define a function in ACL2, you are really causing two
  definitions to be made ``under the hood'' in Common Lisp: the
  definition is submitted explicitly to raw Lisp, but so is a
  corresponding executable-counterpart; see [evaluation].  If guards
  have not been verified, then only the executable-counterpart will
  be evaluated; see [evaluation] and see [guards-and-evaluation], in
  particular the section titled ``Guards and evaluation V: efficiency
  issues''.

  Thus, if you are not verifying [guard]s and you want the benefit of
  Lisp compilation for speed and space efficiency, then you may want
  to place the form [47m(comp :exec)[0m in your [books].

  Generally it is not necessary to place the form [47m(comp t)[0m, or the form
  [47m(comp :raw)[0m, in a book, because [47m[certify-book][0m compiles the raw
  Lisp definitions anyhow, by default.  But you may wish to put [47m(comp
  t)[0m or [47m(comp fn1 fn2 ... fnk)[0m in a book when such a form precedes
  expensive calls of functions, for example for proofs involving
  calls of functions on large constants, or to support
  computationally expensive macroexpansion.

  As suggested by the examples above, if a function specifier is of the
  form [47m(:raw fn)[0m, then [47mfn[0m will be compiled in raw Common Lisp but its
  corresponding executable-counterpart definition will not be
  compiled; and for [47m(:exec fn)[0m, it's the other way around.

  The use of [47m:comp[0m may create various files whose names start with
  ``[47mTMP*[0m'', but it then deletes them.  If you want to save these
  files, evaluate [47m(assign keep-tmp-files t)[0m.

  Also see [set-compile-fns] for a way to compile each function as it
  is defined.  But note that [47mset-compile-fns[0m is ignored during
  [47m[include-book][0m.

  Note that if functions are traced (see [trace$]), then [47mcomp[0m will
  first untrace the functions that are to be compiled, then will do
  the compile(s), and finally will re-trace the functions that it
  untraced (using their original trace specs).  In particular, if you
  have traced a function and then you compile it using [47m:comp[0m, the
  resulting traced function will be compiled as well unless you
  specified [47m:compile nil[0m in your trace spec; and after you untrace
  the function it will definitely run compiled.

  We conclude with a technical remark only for those who use trust tags
  to write raw Lisp code.  [47m:Comp[0m generally creates files to compile
  unless it is given a single function to compile.  Those files
  contain the ACL2 definitions of all functions to compile, omitting
  those in the lists obtained by evaluating the forms [47m(@
  logic-fns-with-raw-code)[0m and [47m(@ program-fns-with-raw-code)[0m.  [47m:Comp[0m
  skips compilation for functions that are already compiled, as is
  typically the case when you redefine functions in raw Lisp using
  [include-raw].  But if you define interpreted (as opposed to
  compiled) functions with raw Lisp code, say by using trust tags
  (see [defttag]) and [47m[progn!][0m, then you are advised to add all such
  symbols to one of the lists stored in the two [state] globals
  above: to [47mlogic-fns-with-raw-code[0m if the function symbol is in
  [47m:[0m[47m[logic][0m mode, else to [47mprogram-fns-with-raw-code[0m.  Then, instead of
  the corresponding ACL2 definition (without raw Lisp code) being
  written to a file, the function symbol will be passed directly to
  the Lisp [47mcompile[0m function.  Note that the above two state globals
  are both untouchable, so you may need to deal with that before
  modifying them, for example as follows (also see
  [remove-untouchable]).

    (defttag t)
    (progn!
     :state-global-bindings
     ((acl2::temp-touchable-vars t acl2::set-temp-touchable-vars))
     (f-put-global 'acl2::logic-fns-with-raw-code
                   (cons 'my-fn (@ acl2::logic-fns-with-raw-code))
                   state))")
 (COMP-GCL
  (COMPILATION ACL2-BUILT-INS)
  "Compile some ACL2 functions leaving .c and .h files

  [47mComp-gcl[0m is for use by experts who want to examine the results of GCL
  compilation, and it may only be used with ACL2 implementations
  built on top of GCL.  It takes exactly the same arguments as
  [47m[comp][0m, and has the same basic functionality (see [comp]), but has
  two additional effects.  First, files [47m\"TMP.lisp\"[0m and [47m\"TMP1.lisp\"[0m
  are always created, even when a single function is specified.
  Second, [47mcomp-gcl[0m always leaves files [47m\"TMP.c\"[0m, [47m\"TMP.h\"[0m, [47m\"TMP1.c\"[0m,
  and [47m\"TMP1.h\"[0m when compilation is complete.")
 (COMPARE-OBJECTS
  (DEBUGGING)
  "show differences between two ACL2 objects

  In theorem prover output it can sometimes be difficult to see where
  two Lisp objects differ.  (Emacs' compare-windows can often help.)
  This function is an attempt to help while remaining entirely in
  ACL2.

    General Form:
    (compare-objects x y)

  where [47mx[0m and [47my[0m are two (almost) arbitrary objects but which must both
  be [47mcons[0m trees for the comparison to be non-trivial.  The output
  (described below) might be confusing if either object contains
  keywords of the form [47m:<|s...|>[0m, where the ellipsis is the decimal
  representation of a natural number.  For example, the output would
  be confusing if [47mx[0m or [47my[0m contained [47m:|<s1>|[0m because [47mcompare-objects[0m
  inserts tokens like that to mark differences.

  [47mCompare-objects[0m walks through both objects to detect where
  corresponding substructures first differ.  It replaces differences
  by the keyword symbols [47m:|<s1>|[0m, [47m:|<s2>|[0m, [47m:|<s3>|[0m, ..., which we
  call ``placeholders.'' It then assembles a ``legend'' that displays
  triplets of the form [47m(si xi yi)[0m where [47msi[0m is a placeholder marking a
  position in the common superstructure of both [47mx[0m and [47my[0m and [47mxi[0m and [47myi[0m
  are the substructures of [47mx[0m and [47my[0m, respectively, at that position
  that differ.  [47mCompare-objects[0m returns a list consisting of the
  ``common object'' showing the shared superstructure and the legend.

  For example,

    ACL2 !>(compare-objects '(a b c) '(a b . c))
    ((:OBJ (A B . :|<s1>|))
     (:LEGEND ((:|<s1>| (C) C))))

    ACL2 !>(compare-objects '(f x y (g x '(a b c)))
                            '(f y x (g x '(a b c . d))))
    ((:OBJ (F :|<s1>|
              :|<s2>| (G X '(A B C . :|<s3>|))))
     (:LEGEND ((:|<s1>| X Y)
               (:|<s2>| Y X)
               (:|<s3>| NIL D))))

  By the way, the [47mbrr[0m command [47m:[0m[47m[explain-near-miss][0m sometimes calls
  [47mcompare-objects[0m to show the differences between two unequal quoted
  constants involved in a mismatch.  When [47m:explain-near-miss[0m
  prettyprints the output of [47mcompare-object[0m it does so with an
  [47m[evisc-tuple][0m that simplifies the placeholders.  [47m:Explain-near-miss[0m
  would display the second example above as

    ((:OBJ '(F <s1> <s2> (G X '(A B C . <s3>))))
     (:LEGEND ((<s1> X Y) (<s2> Y X) (<s3> NIL D)))).

  [47mCompare-objects[0m might be especially helpful when looking at big
  [47mlambda[0m objects as produced by translating and rewriting [47m[loop$][0m
  expressions.  For example, below we use [47mcompare-objects[0m to discover
  where two large [47mDO$[0m terms differ.

     ACL2 !>(compare-objects
     '(DO$   ; First term
      '(LAMBDA (ALIST)
               (ACL2-COUNT (CDR (ASSOC-EQ-SAFE 'LST ALIST))))
      (CONS (CONS 'LST LST0) '((ANS . 0)))
      '(LAMBDA (ALIST)
               (IF (ENDP (CDR (ASSOC-EQ-SAFE 'LST ALIST)))
                   (CONS ':RETURN
                         (CONS (CDR (ASSOC-EQ-SAFE 'ANS ALIST))
                               (CONS (CONS (CONS 'LST
                                                 (CDR (ASSOC-EQ-SAFE 'LST ALIST)))
                                           (CONS (CONS 'ANS
                                                       (CDR (ASSOC-EQ-SAFE 'ANS ALIST)))
                                                 'NIL))
                                     'NIL)))
                   (CONS
                    'NIL
                    (CONS
                     'NIL
                     (CONS (CONS (CONS 'LST
                                       (CDR (CDR (ASSOC-EQ-SAFE 'LST ALIST))))
                                 (CONS (CONS 'ANS
                                             (BINARY-+ '1
                                                       (CDR (ASSOC-EQ-SAFE 'ANS ALIST))))
                                       'NIL))
                           'NIL)))))
      '(LAMBDA (ALIST)
               (CONS 'NIL
                     (CONS 'NIL
                           (CONS (CONS (CONS 'LST
                                             (CDR (ASSOC-EQ-SAFE 'LST ALIST)))
                                       (CONS (CONS 'ANS
                                                   (CDR (ASSOC-EQ-SAFE 'ANS ALIST)))
                                             'NIL))
                                 'NIL))))
      '(NIL)
      'NIL)
     '(DO$   ; Second term
      '(LAMBDA (ALIST)
               (ACL2-COUNT (CDR (ASSOC-EQ-SAFE 'LST ALIST))))
      (CONS (CONS 'LST LST0) '((ANS . 0)))
      '(LAMBDA (ALIST)
               (IF (ENDP (CDR (ASSOC-EQ-SAFE 'LST ALIST)))
                   (CONS ':RETURN
                         (CONS (CDR (ASSOC-EQ-SAFE 'ANS ALIST))
                               (CONS (CONS (CONS 'LST
                                                 (CDR (ASSOC-EQ-SAFE 'LST ALIST)))
                                           (CONS (CONS 'ANS
                                                       (CDR (ASSOC-EQ-SAFE 'ANS ALIST)))
                                                 'NIL))
                                     'NIL)))
                   (CONS
                    'NIL
                    (CONS
                     'NIL
                     (CONS (CONS (CONS 'LST
                                       (CDR (CDR (ASSOC-EQ-SAFE 'LST ALIST))))
                                 (CONS (CONS 'ANS
                                             (BINARY-+ '1
                                                       (CDR (ASSOC-EQ 'ANS ALIST))))
                                       'NIL))
                           'NIL)))))
      '(LAMBDA (ALIST)
               (CONS 'NIL
                     (CONS 'NIL
                           (CONS (CONS (CONS 'LST
                                             (CDR (ASSOC-EQ-SAFE 'LST ALIST)))
                                       (CONS (CONS 'ANS
                                                   (CDR (ASSOC-EQ-SAFE 'ANS ALIST)))
                                             'NIL))
                                 'NIL))))
      '(NIL)
      'NIL))
    ((:OBJ
     (DO$
      '(LAMBDA (ALIST)
         (ACL2-COUNT (CDR (ASSOC-EQ-SAFE 'LST ALIST))))
      (CONS (CONS 'LST LST0) '((ANS . 0)))
      '(LAMBDA (ALIST)
        (IF
          (ENDP (CDR (ASSOC-EQ-SAFE 'LST ALIST)))
          (CONS ':RETURN
                (CONS (CDR (ASSOC-EQ-SAFE 'ANS ALIST))
                      (CONS (CONS (CONS 'LST
                                        (CDR (ASSOC-EQ-SAFE 'LST ALIST)))
                                  (CONS (CONS 'ANS
                                              (CDR (ASSOC-EQ-SAFE 'ANS ALIST)))
                                        'NIL))
                            'NIL)))
         (CONS
            'NIL
            (CONS 'NIL
                  (CONS (CONS (CONS 'LST
                                    (CDR (CDR (ASSOC-EQ-SAFE 'LST ALIST))))
                              (CONS (CONS 'ANS
                                          (BINARY-+ '1
                                                    (CDR (:|<s1>| 'ANS ALIST))))
                                    'NIL))
                        'NIL)))))
      '(LAMBDA (ALIST)
         (CONS 'NIL
               (CONS 'NIL
                     (CONS (CONS (CONS 'LST
                                       (CDR (ASSOC-EQ-SAFE 'LST ALIST)))
                                 (CONS (CONS 'ANS
                                             (CDR (ASSOC-EQ-SAFE 'ANS ALIST)))
                                       'NIL))
                           'NIL))))
      '(NIL)
      'NIL))
     (:LEGEND ((:|<s1>| ASSOC-EQ-SAFE ASSOC-EQ))))

  [47mCompare-objects[0m tells us that a position [47m:|<s1>|[0m the first term calls
  [47mASSOC-EQ-SAFE[0m while the second one calls [47mASSOC-EQ[0m.")
 (COMPILATION
  (PROGRAMMING)
  "Compiling ACL2 functions

  ACL2 has several mechanisms to speed up the evaluation of function
  calls by [3mcompiling[0m functions: see [comp], see [set-compile-fns],
  and see [certify-book].  The intention is that compilation never
  changes the value returned by a function call, though it could
  cause the call to succeed rather than fail, for example by avoiding
  a stack overflow.

  The [47m[state][0m global variable [47m'compiler-enabled[0m is set automatically
  when the system is built, and may depend on the underlying Lisp
  implementation.  (In order to disable the compiler at build time,
  which will defeat the speed-up but usually be pretty harmless when
  the host Lisp is CCL or SBCL, see the discussion of
  [47mACL2_COMPILER_DISABLED[0m in distributed file [47mGNUmakefile[0m.)  The value
  of [47m'compiler-enabled[0m, as returned by [47m(@ compiler-enabled)[0m, can be
  [47mt[0m, [47m:books[0m, or [47mnil[0m.  If the value is [47mnil[0m, then [47m[include-book][0m and
  [47m[certify-book][0m coerce their arguments [47m:load-compile-file[0m and
  [47mcompile-flg[0m arguments (respectively) to [47mnil[0m.  Otherwise, the value
  is [47m:books[0m or [47mt[0m and there is no such coercion; but if the value is
  not [47mt[0m, then [47m[comp][0m and [47m[set-compile-fns][0m are no-ops, which is
  probably desirable for Lisps such as CCL and SBCL that compile
  on-the-fly even when the compiler is not explicitly invoked.

  However, you may have reason to want to change the above (default)
  behavior.  To enable compilation by default for [47m[certify-book][0m and
  [47m[include-book][0m but not for [47m[comp][0m or [47m[set-compile-fns][0m:

    (set-compiler-enabled :books state)

  To enable compilation not only as above but also for [47m[comp][0m and
  [47m[set-compile-fns][0m:

    (set-compiler-enabled t state)

  To suppress compilation and loading of compiled files by
  [47m[include-book][0m (for example, if you get a raw Lisp error such as
  ``Wrong FASL version''):

    (set-compiler-enabled nil state)

  Remark for users of [47m[make-event][0m.  If [47mset-compiler-enabled[0m is invoked
  during [47mmake-event[0m expansion, its effect on [47m[state][0m global variable
  [47m'compiler-enabled[0m will persist after evaluation completes for that
  [47mmake-event[0m form.  So for example, one might use the following idiom
  in a book so that for all books included on behalf of a given
  [47m[include-book][0m form, no compiled files are loaded, but (optionally)
  no such effect takes place for later [47minclude-book[0m forms in that
  book.

    (make-event
     (pprogn (f-put-global 'saved-compiler-enabled (@ compiler-enabled) state)
             (set-compiler-enabled nil state)
             (value '(value-triple nil)))
     :check-expansion t)
    (include-book \"my-book\")
    ; optional
    (make-event
     (pprogn (set-compiler-enabled (@ saved-compiler-enabled) state)
             (value '(value-triple nil)))
     :check-expansion t)

  Upon completion of an invocation of [47m[include-book][0m or [47m[certify-book][0m,
  the value of [47m[state][0m global variable [47m'compiler-enabled[0m is restored
  to the value it had immediately before that invocation.

  See [book-compiled-file] for more discussion about compilation and
  [books].

  We close with a discussion of a feature that allows control over the
  loading of [47m.port[0m files in close analogy to how loading of compiled
  files is controlled by [47mset-compiler-enabled[0m, as described above.
  (See [uncertified-books] for a discussion of [47m.port[0m files.)  A
  [state] global variable, [47m'port-file-enabled[0m exists for this
  purpose, and it is set as follows.

    (set-port-file-enabled t state)   ; permit loading of .port files (default)
    (set-port-file-enabled nil state) ; skip loading of .port files

  Just as described above for state global [47mcompiler-enabled[0m, the value
  of [47m'port-file-enabled[0m persists after [47m[make-event][0m expansion and is
  restored after [47m[certify-book][0m and [47m[include-book][0m.  The idiom
  displayed above, for avoiding loading of compiled files, can be
  modified or extended in the obvious way to avoid loading of [47m.port[0m
  files.


Subtopics

  [Comp]
      Compile some ACL2 functions

  [Comp-gcl]
      Compile some ACL2 functions leaving .c and .h files

  [Disassemble$]
      Disassemble a function

  [Set-compile-fns]
      Have each function compiled as you go along.

  [Set-compiler-enabled]
      Disable [compilation].

  [The]
      Special form for execution efficiency or run-time type checks")
 (COMPILING-ACL2P
  (PARALLELISM)
  "Compiling ACL2(p)

  This [documentation] topic relates to the experimental extension of
  ACL2 supporting parallel execution and proof; see [parallelism].
  See [parallelism-tutorial] for an introduction to parallel
  programming in ACL2.

  You can build an experimental version of ACL2 that supports parallel
  execution in the following host Common Lisp implementations:

      * CCL (OpenMCL)

      * Lispworks 6.0

      * SBCL with threads (feature [47m:sb-thread[0m)

  The command below will compile ACL2 to support parallel execution,
  including parallel execution during proofs.  Any non-empty string
  may be used in place of [47mt[0m, and the value of [47mLISP[0m (shown here as
  [47mccl[0m) is any Lisp executable on which one can build ACL2(p) (see
  [parallelism]).

    make ACL2_PAR=t LISP=ccl

  So for example, to make an executable image and also documentation
  (which will appear in subdirectories [47mdoc/EMACS[0m and [47mdoc/HTML[0m), using
  the Lisp executable [47mccl[0m:

    make large DOC ACL2_PAR=t LISP=ccl")
 (COMPLEX
  (NUMBERS ACL2-BUILT-INS)
  "Create an ACL2 number

    Examples:
    (complex x 3) ; x + 3i, where i is the principal square root of -1
    (complex x y) ; x + yi
    (complex x 0) ; same as x, for rational numbers x

  The function [47mcomplex[0m takes two rational number arguments and returns
  an ACL2 number.  This number will be of type [47m(complex rational)[0m [as
  defined in the Common Lisp language], except that if the second
  argument is zero, then [47mcomplex[0m returns its first argument.  The
  function [47m[complex-rationalp][0m is a recognizer for complex rational
  numbers, i.e. for ACL2 numbers that are not rational numbers.

  The reader macro [47m#C[0m (which is the same as [47m#c[0m) provides a convenient
  way for typing in complex numbers.  For explicit rational numbers [47mx[0m
  and [47my[0m, [47m#C(x y)[0m is read to the same value as [47m(complex x y)[0m.

  The functions [47m[realpart][0m and [47m[imagpart][0m return the real and imaginary
  parts (respectively) of a complex (possibly rational) number.  So
  for example, [47m(realpart #C(3 4)) = 3[0m, [47m(imagpart #C(3 4)) = 4[0m,
  [47m(realpart 3/4) = 3/4[0m, and [47m(imagpart 3/4) = 0[0m.

  The following built-in axiom may be useful for reasoning about
  complex numbers.

    (defaxiom complex-definition
      (implies (and (real/rationalp x)
                    (real/rationalp y))
               (equal (complex x y)
                      (+ x (* #c(0 1) y))))
      :rule-classes nil)

  A completion axiom that shows what [47mcomplex[0m returns on arguments
  violating its [guard] (which says that both arguments are rational
  numbers) is the following, named [47mcompletion-of-complex[0m.

    (equal (complex x y)
           (complex (if (rationalp x) x 0)
                    (if (rationalp y) y 0)))")
 (COMPLEX-RATIONALP
  (NUMBERS ACL2-BUILT-INS)
  "Recognizes complex rational numbers

    Examples:
    (complex-rationalp 3)       ; nil, as 3 is rational, not complex rational
    (complex-rationalp #c(3 0)) ; nil, since #c(3 0) is the same as 3
    (complex-rationalp t)       ; nil
    (complex-rationalp #c(3 1)) ; t, as #c(3 1) is the complex number 3 + i

  See [complex] for more about complex rationals in ACL2.")
 (COMPLEX/COMPLEX-RATIONALP
  (NUMBERS ACL2-BUILT-INS)
  "Recognizer for complex numbers

  For most ACL2 users, this is a macro abbreviating [47mcomplex-rationalp[0m;
  see [complex-rationalp].  In ACL2(r) (see [real]), a complex number
  [47mx[0m may have irrational real and imaginary parts.  This macro
  abbreviates the predicate [47mcomplexp[0m in ACL2(r), which holds for such
  [47mx[0m.  Most ACL2 users can ignore this macro and use
  [47m[complex-rationalp][0m instead.  Some community books use
  [47mcomplex/complex-rationalp[0m so that they are suitable for ACL2(r) as
  well.")
 (COMPOUND-RECOGNIZER
  (RULE-CLASSES)
  "Make a rule used by the typing mechanism

  See [rule-classes] for a general discussion of rule classes,
  including how they are used to build rules from formulas and a
  discussion of the various keywords in a rule class description.

    Examples:
    (defthm alistp-implies-true-listp-compound-recognizer
      (implies (alistp x)                 ; When (alistp x) is assumed true, add
               (true-listp x))            ; the additional hypothesis that x is
      :rule-classes :compound-recognizer) ; of primitive type true-listp.

    (defthm natp-compound-recognizer      ; See discussion below.
      (equal (natp x)
             (and (integerp x)
                  (<= 0 x)))
      :rule-classes :compound-recognizer)

  Before presenting the General Forms, we start with a motivating
  example: the second [47m[defthm][0m form above, which provides a nice
  example of a [47m:compound-recognizer[0m rule that is built into ACL2.  To
  see how this rule might be useful, consider the following
  (admittedly very simple) [events].

    (defun triple (x)
      (* 3 x))

    (defthm triple-preserves-integerp
      (implies (integerp x)
               (integerp (triple x))))

    (in-theory (disable triple natp))

  If the above [47m:compound-recognizer[0m rule is disabled, then the
  following trivial theorem fails as shown; we explain below.

    (thm (implies (natp x)
                  (integerp (triple x)))
      :hints ((\"Goal\" :in-theory (disable natp-compound-recognizer))))

  The problem is that when ACL2 tries to rewrite the term [47m(integerp
  (triple x))[0m using the [47m:[0m[47m[rewrite][0m rule [47mtriple-preserves-integerp[0m, it
  needs to rewrite the hypothesis [47m(integerp x)[0m to [47mt[0m, but instead what
  is known is [47m(natp x)[0m.  If we remove the hint, then the proof
  succeeds because the above [47m:compound-recognizer[0m rule tells ACL2
  that when assuming [47m(natp x)[0m to be true, it should actually assume
  both [47m(integerp x)[0m and [47m(<= 0 x)[0m to be true.

    General Forms:
    (implies (fn x) concl)               ; (1)
    (implies (not (fn x)) concl)         ; (2)
    (and (implies (fn x) concl1)         ; (3)
         (implies (not (fn x)) concl2))
    (if (fn x) concl1 concl2)            ; (4)
    (iff (fn x) concl)                   ; (5)
    (equal (fn x) concl)                 ; (6)

  where [47mfn[0m is a Boolean valued function of one argument, [47mx[0m is a
  variable symbol, and the system can deduce some restriction on the
  primitive type of [47mx[0m from the assumption that [47mconcl[0m holds.  The last
  restriction is vague but one way to understand it is to strengthen
  it a little to ``and [47mconcl[0m is a non-tautological disjunction of the
  primitive type recognizers listed below.''

  The primitive ACL2 types and a suitable primitive recognizing
  expression for each are listed below.

    type                suitable primitive recognizer

    zero                    (equal x 0)
    one                     (equal x 1)
    negative integers       (and (integerp x) (< x 0))
    positive integers > 1   (and (integerp x) (> x 1))
    negative ratio          (and (rationalp x)
                                 (not (integerp x))
                                 (< x 0))
    positive ratio          (and (rationalp x)
                                 (not (integerp x))
                                 (> x 0))
    complex rational        (complex-rationalp x)
    nil                     (equal x nil)
    t                       (equal x t)
    other symbols           (and (symbolp x)
                                 (not (equal x nil))
                                 (not (equal x t)))
    proper conses           (and (consp x)
                                 (true-listp x))
    improper conses         (and (consp x)
                                 (not (true-listp x)))
    strings                 (stringp x)
    characters              (characterp x)

  Thus, since the naturals comprise the types [47mzero[0m, [47mone[0m, and [47mpositive
  integers > 1[0m, a suitable [47mconcl[0m to recognize the naturals would be

    (or (equal x 0)
        (equal x 1)
        (and (integerp x) (> x 1)))

  However, it turns out that we also permit [47m(and (integerp x) (>= x
  0))[0m, i.e. [47mconcl[0m doesn't literally need to be formed as a direct
  disjunction of terms from the table above.

  Similarly, the true-lists could be specified by

    (or (equal x nil)
        (and (consp x)
             (true-listp x)))

  but we in fact allow [47m(true-listp x)[0m as well.  When time permits we
  may document more fully what is allowed or implement a macro that
  permits direct specification of the desired type in terms of the
  primitives.

  There are essentially four forms of [47m:compound-recognizer[0m rules, as
  the forms labeled (3) and (4) above are equivalent, as are those
  labeled (5) and (6).  We explain how such rules are used by
  considering the individual forms.

  Consider form (1), [47m(implies (fn x) concl)[0m.  The effect of such a rule
  is that when the rewriter assumes [47m(fn x)[0m true, as it would while
  diving through [47m(if (fn x) xxx ...)[0m to rewrite [47mxxx[0m, it restricts the
  type of [47mx[0m as specified by [47mconcl[0m.  For example, if [47mconcl[0m is the term
  [47m(integerp x)[0m, then when rewriting [47mxxx[0m, [47mx[0m will be assumed to be an
  integer.  However, when assuming [47m(fn x)[0m false, as necessary in [47m(if
  (fn x) ... xxx)[0m, the rule permits no additional assumptions about
  the type of [47mx[0m.  For example, if [47mfn[0m is [47mprimep[0m, i.e., the predicate
  that recognizes prime numbers, then [47m(implies (primep x) (and
  (integerp x) (>= x 0)))[0m is a compound recognizer rule of the first
  form.  When [47m(primep x)[0m is assumed true, the rewriter gains the
  additional information that [47mx[0m is a natural number.  When [47m(primep x)[0m
  is assumed false, no additional information is gained --- since [47mx[0m
  may be a non-prime natural or may not even be a natural.

  Form (2) is the symmetric case, when assuming [47m(fn x)[0m false permits
  type restrictions on [47mx[0m but assuming [47m(fn x)[0m true permits no such
  restrictions.  For example, if we defined [47mexprp[0m to be the
  recognizer for well-formed expressions for some language in which
  all symbols, numbers, character objects and strings were
  well-formed --- e.g., the well-formedness rules only put
  restrictions on expressions represented by [47m[consp][0ms --- then the
  theorem [47m(implies (not (exprp x)) (consp x))[0m is a rule of the second
  form.  Assuming [47m(exprp x)[0m true tells us nothing about the type of
  [47mx[0m; assuming it false tells us [47mx[0m is a [47m[consp][0m.

  Forms (3) and (4), which are really equivalent, address themselves to
  the case where one type may be deduced from [47m(fn x)[0m and a generally
  unrelated type may be deduced from its negation.  If we modified
  the expression recognizer above so that character objects are
  illegal, then rules of the forms (3) and (4) are

    (and (implies (exprp x) (not (characterp x)))
         (implies (not (exprp x)) (or (consp x) (characterp x)))).
    (if (exprp x)
        (not (characterp x))
      (or (consp x) (characterp x)))

  Finally, rules of forms (5) and (6) address the case where [47mfn[0m
  recognizes all and only the objects whose type is described.  In
  these cases, [47mfn[0m is really just a new name for some ``compound
  recognizers.'' The classic example is [47m(booleanp x)[0m, which is just a
  handy combination of two primitive types:

    (iff (booleanp x) (or (equal x t) (equal x nil))).

  Often it is best to disable [47mfn[0m after proving that it is a compound
  recognizer, since otherwise the term [47m(fn x)[0m will be expanded and
  thus disappear.

  Every time you prove a new compound recognizer rule about [47mfn[0m it
  overrides all previously proved compound recognizer rules about [47mfn[0m.
  Thus, if you want to establish the type implied by [47m(fn x)[0m and you
  want to establish the type implied by [47m(not (fn x))[0m, you must prove
  a compound recognizer rule of the third, fourth, fifth, or sixth
  forms.  Proving a rule of the first form followed by one of the
  second only leaves the second fact in the database.

  Compound recognizer rules can be disabled with the effect that older
  rules about [47mfn[0m, if any, are exposed.

  If you prove more than one compound recognizer rule for a function,
  you may see a [31;1mwarning[0m message to the effect that the new rule is
  not as ``restrictive'' as the old.  That is, the new rules do not
  give the rewriter strictly more type information than it already
  had.  The new rule is stored anyway, overriding the old, if
  enabled.  You may be playing subtle games with enabling or
  rewriting.  But two other interpretations are more likely, we
  think.  One is that you have forgotten about an earlier rule and
  should merely print it out to make sure it says what you intend,
  and then discard your new rule.  The other is that you meant to
  give the system more information and the system has simply been
  unable to extract the intended type information from the term you
  placed in the conclusion of the new rule.  Given our lack of
  specificity in saying how type information is extracted from rules,
  you can hardly blame yourself for this problem.  Sorry.  If you
  suspect you've been burned this way, you should rephrase the new
  rule in terms of the primitive recognizing expressions above and
  see if the warning is still given.  It would also be helpful to let
  us see your example so we can consider it as we redesign this
  stuff.

  Compound recognizer rules are similar to [47m:[0m[47m[forward-chaining][0m rules in
  that the system deduces new information from the act of assuming
  something true or false.  If a compound recognizer rule were stored
  as a forward chaining rule it would have essentially the same
  effect as described, when it has any effect at all.  The important
  point is that [47m:[0m[47m[forward-chaining][0m rules, because of their more
  general and expensive form, are used ``at the top level'' of the
  simplification process: we forward chain from assumptions in the
  goal being proved.  But compound recognizer rules are built in at
  the bottom-most level of the simplifier, where type reasoning (see
  [TYPE-REASONING]) is done.

  All that said, compound recognizer rules are a rather fancy,
  specialized mechanism.  It may be more appropriate to create
  [47m:[0m[47m[forward-chaining][0m rules instead of [47m:compound-recognizer[0m rules.")
 (COMPRESS1
  (ARRAYS ACL2-BUILT-INS)
  "Remove irrelevant pairs from a 1-dimensional array

    Example Form:
    (compress1 'delta1 a)

    General Form:
    (compress1 name alist)

  where [47mname[0m is a symbol and [47malist[0m is a 1-dimensional array, generally
  named [47mname[0m.  See [arrays] for details.  Logically speaking, this
  function can remove irrelevant pairs from [47malist[0m, possibly
  shortening it.  The function returns a new array, [47malist'[0m, with the
  same [47m[header][0m (including name and dimension) as [47malist[0m, that, under
  [47m[aref1][0m, is everywhere equal to [47malist[0m.  That is, [47m(aref1 name alist'
  i)[0m is [47m(aref1 name alist i)[0m, for all legal indices [47mi[0m.  [47mAlist'[0m may be
  shorter than [47malist[0m and the non-irrelevant pairs may occur in a
  different order than in [47malist[0m.

  Practically speaking, this function plays an important role in the
  efficient implementation of [47m[aref1][0m.  In addition to creating the
  new array, [47malist'[0m, [47mcompress1[0m makes that array the ``semantic
  value'' of [47mname[0m and allocates a raw lisp array to [47mname[0m.  For each
  legal index, [47mi[0m, that raw lisp array contains [47m(aref1 name alist' i)[0m
  in slot [47mi[0m.  Thus, subsequent [47m[aref1][0m operations can be executed in
  virtually constant time provided they are given [47mname[0m and the [47malist'[0m
  returned by the most recently executed [47mcompress1[0m or [47m[aset1][0m on
  [47mname[0m.  See [arrays].

  In general, [47mcompress1[0m returns an alist whose [47m[cdr][0m is an association
  list whose keys are nonnegative integers in ascending order.
  However, if the [47m[header][0m specifies an [47m:order[0m of [47m>[0m then the keys
  will occur in descending order; and if the [47m:order[0m is [47m:none[0m or [47mnil[0m
  then the keys will not be sorted and the header may appear anywhere
  (even more than once), i.e., [47mcompress1[0m is logically the identity
  function (though it still attaches an array under the hood).  Note
  however that a [47m[compress1][0m call is replaced by a hard error if the
  header specifies an [47m:order[0m of [47m:none[0m or [47mnil[0m and the array's length
  exceeds the [47m[maximum-length][0m field of its [47m[header][0m.

  We close with a remark concerning efficiency in the case that the
  [47m:ORDER[0m specified by the given [array]'s [header] is [47m<[0m or [47m>[0m and the
  alist is properly ordered: header occurring only first, then
  ascending (for [47m:ORDER <[0m) or descending (for [47m:ORDER >[0m) order of
  indices, with no value in the alist equal to the [47m:DEFAULT[0m specified
  by the header.  In particular, this can cut the time to run
  [47mcompress1[0m on an alist containing only the header by more than half.

  [31;1mFunction: [0m<compress1>

    (defun compress1 (name l)
     (declare (xargs :guard (array1p name l)))
     (case (array-order (header name l))
      (< (cons (header name l)
               (compress11 name l 0 (car (dimensions name l))
                           (default name l))))
      (> (cons (header name l)
               (reverse (compress11 name l 0 (car (dimensions name l))
                                    (default name l)))))
      (t
       (prog2$
        (and
         (> (length l) (maximum-length name l))
         (hard-error
          'compress1
          \"Attempted to compress a one-dimensional array named ~
                            ~x0 whose header specifies :ORDER ~x1 and whose ~
                            length, ~x2, exceeds its maximum-length, ~x3.\"
          (list (cons #\\0 name)
                (cons #\\1 nil)
                (cons #\\2 (length l))
                (cons #\\3 (maximum-length name l)))))
        l))))")
 (COMPRESS2
  (ARRAYS ACL2-BUILT-INS)
  "Remove irrelevant pairs from a 2-dimensional array

    Example Form:
    (compress2 'delta1 a)

    General Form:
    (compress2 name alist)

  where [47mname[0m is a symbol and [47malist[0m is a 2-dimensional array, generally
  named [47mname[0m.  See [arrays] for details.  Logically speaking, this
  function removes irrelevant pairs from [47malist[0m, possibly shortening
  it.  The function returns a new array, [47malist'[0m, with the same
  [47m[header][0m (including name and dimension) as [47malist[0m, that, under
  [47m[aref2][0m, is everywhere equal to [47malist[0m.  That is, [47m(aref2 name alist'
  i j)[0m is [47m(aref2 name alist i j)[0m, for all legal indices [47mi[0m and [47mj[0m.
  [47mAlist'[0m may be shorter than [47malist[0m and the non-irrelevant pairs may
  occur in a different order in [47malist'[0m than in [47malist[0m.

  Practically speaking, this function plays an important role in the
  efficient implementation of [47m[aref2][0m.  In addition to creating the
  new array, [47malist'[0m, [47mcompress2[0m makes that array the ``semantic
  value'' of [47mname[0m and allocates a raw lisp array to [47mname[0m.  For all
  legal indices, [47mi[0m and [47mj[0m, that raw lisp array contains [47m(aref2 name
  alist' i j)[0m in slot [47mi[0m,[47mj[0m.  Thus, subsequent [47m[aref2][0m operations can
  be executed in virtually constant time provided they are given [47mname[0m
  and the [47malist'[0m returned by the most recently executed [47mcompress2[0m or
  [47m[aset2][0m on [47mname[0m.  See [arrays].

  [31;1mFunction: [0m<compress2>

    (defun compress2 (name l)
      (declare (xargs :guard (array2p name l)))
      (cons (header name l)
            (compress21 name l 0 (car (dimensions name l))
                        (cadr (dimensions name l))
                        (default name l))))")
 (COMPUTED-HINT (POINTERS)
                "See [computed-hints].")
 (COMPUTED-HINTS
  (HINTS)
  "Computing advice to the theorem proving process

    General Form of :hints:
    (hint1 hint2 ... hintk)

  Each element, hinti, must be either a common hint or a computed hint.

  A common hint is of the form

    (goal-spec :key1 val1 ... :keyn valn)

  where [47mgoal-spec[0m is as specified in [goal-spec] and each [47m:keyi[0m and
  [47mvali[0m is as specified in [hints].  Among the ``common hints'' we
  include both the primitive hints and user-defined custom keyword
  hints (see [custom-keyword-hints]).

  A computed hint may be a symbol, in which case it must be a function
  symbol of three, four or seven arguments.  Otherwise, a computed
  hint is a term with the following properties:

  (a) the only free variables allowed in the term are [47mID[0m, [47mCLAUSE[0m,
  [47mWORLD[0m, [47mSTABLE-UNDER-SIMPLIFICATIONP[0m, [47mHIST[0m, [47mPSPV[0m, [47mCTX[0m, and [47m[state][0m;

  (b) the output signature of the term is either [47m(MV * * STATE)[0m, which
  is to be treated as an error triple (see below), or is [47m*[0m, denoting
  a single non-[stobj] value; and

  (c) in the former case of (b) above, the term is single-threaded in
  [47m[state][0m.

  If a computed hint is a function symbol [47mfn[0m, whose arity n is
  therefore three, four, or seven, then it is treated as the term
  resulting from applying that [47mfn[0m to the first n variables shown in
  (a) above.  Notice that it must then return a single non-[stobj]
  value, not an error triple, since [47mstate[0m is not one of the first
  seven variables shown in (a).

  Note: Error triples are an ACL2 idiom for implementing ``errors'';
  see [error-triple].  If a computation returns [47m(mv erp val state)[0m in
  a context in which ACL2 is respecting the error triple convention
  (see [ld-error-triples] and see [ld-error-action]), then an error
  is deemed to have occurred if [47merp[0m is non-[47mnil[0m.  The computation is
  expected to have printed an appropriate error message to [47m[state][0m
  and further computation is aborted.  On the other hand, if a
  computation returns an error triple in which [47merp[0m is nil, then
  ``value'' of the computation is taken to be the second component,
  [47mval[0m, of the triple (along with the possibly modified [47m[state][0m), and
  computation continues.  For more information about programming with
  error triples, see [programming-with-state].

  The function symbol cases are treated as abbreviations of the term
  [47m(fn ID CLAUSE WORLD)[0m, [47m(fn ID CLAUSE WORLD
  STABLE-UNDER-SIMPLIFICATIONP)[0m, or [47m(fn ID CLAUSE WORLD
  STABLE-UNDER-SIMPLIFICATIONP HIST PSPV CTX)[0m as appropriate for the
  arity of [47mfn[0m.  (Note that this tells you which argument of [47mfn[0m is
  which.)  Moreover, in these cases the value returned must be a
  single ordinary (non-[stobj]) value, not an error triple.  In the
  discussion below we assume all computed hints are of the term form.
  Indeed, we almost assume all computed hints are of the 3 and 4
  argument forms.  We only comment briefly on the 7 argument form in
  [using-computed-hints-8].

  The semantics of a computed hint term is as follows.  On every
  subgoal, the term is evaluated in an environment in which the
  variables mentioned in (a) above are bound to context-sensitive
  values explained below.  Either the computed hint signals an error,
  in which the proof attempt aborts, or else it returns a value, [47mval[0m
  and a new state, [47m[state][0m.  Any changes to those parts of [47m[state][0m
  that affect logical soundness are undone; more specifically, the
  values of symbols (sometimes called ``state global variables'') in
  the list [47m*protected-system-state-globals*[0m in the global table of
  the state (see [state]) are restored when changed during
  evaluation.  The value, [47mval[0m, of a non-erroneous computed hint
  calculation is either [47mnil[0m, which means the computed hint did not
  apply to the subgoal in question, or it is an alternating list of
  [47m:keyi vali[0m pairs as specified in [hints].  With one exception,
  those new hints are applied to the given subgoal as though the user
  had typed them explicitly.

  The exception is that the first keyword in the returned [47mval[0m is
  allowed to be [47m:COMPUTED-HINT-REPLACEMENT[0m.  Its value should be [47mnil[0m,
  [47mt[0m, or a list of terms.  If this keyword is not present, the default
  value of [47mnil[0m is provided.  We explain [47m:COMPUTED-HINT-REPLACEMENT[0m
  below.

  The evaluation of a hint term is done with guard checking turned off
  (see [set-guard-checking]); e.g., the form [47m(car 23)[0m in a computed
  hint returns [47mnil[0m as per the axioms.

  When a non-[47mnil[0m value is returned, the keyword/value pairs (other than
  the optional [47m:COMPUTED-HINT-REPLACEMENT[0m) are used as the hint for
  the subgoal in question.  Thus, your job as the programmer of
  computed hints is either to cause an error, typically by invoking
  [47m[er][0m, or to return a non-erroneous value triple whose value is the
  list of keys and values you would have typed had you supplied a
  common hint for the subgoal. (In particular, any theory expressions
  in it are evaluated with respect to the global current-theory, not
  whatever theory is active at the subgoal in question.)  If the
  generated list of keywords and values is illegal, an error will be
  signaled and the proof attempt will be aborted.

  The purpose of the [47m:COMPUTED-HINT-REPLACEMENT[0m keyword and its value,
  [47mchr[0m, is to change the list of hints.  If [47mchr[0m is [47mnil[0m, then the
  computed hint which was applied is removed from the list of hints
  that is passed down to the children of the subgoal in question.
  This is the default.  If [47mchr[0m is [47mt[0m, then the computed hint is left
  in the list of hints.  This means that the same computed hint may
  act on the children of the subgoal.  Otherwise, [47mchr[0m must be a list
  of terms, each of which is treated as a computed hint.  The
  computed hint which was applied is deleted from the list of hints
  and the computed hints in [47mchr[0m are added to the list of hints passed
  to the children of the subgoal.  The ability to generate new
  computed hints and pass them down allows strange and wonderful
  behavior.  Notice that certain hints, for example [47m:in-theory[0m and
  [47m:expand[0m hints, which appear in the computed hint will continue to
  take effect even when [47mchr[0m is [47mnil[0m.  This might give one the false
  impression that a removed computed hint still hangs around.  See
  [hints-and-the-waterfall] for a more detailed discussion about how
  [47m:in-theory[0m and other hints are handled in the waterfall.

  For these purposes, the goals produced by induction and the top-level
  goals of forcing rounds are not considered children; all original
  hints are available to them.

  Only the first hint applicable to a goal, as specified in the
  user-supplied list of [47m:hints[0m followed by the [47m[default-hints-table][0m,
  will be applied to that goal.  (For an advanced exception, see
  [override-hints].)

  It remains only to describe the bindings of the free variables.

  Suppose the theorem prover is working on a [clause] named by some
  [47m[goal-spec][0m, e.g., \"Subgoal *1/2'''\".  Corresponding to the printed
  [47mgoal-spec[0m is an internal data structure called a ``clause
  identifier'' id.  See [clause-identifier].

  In the case of a common hint, the hint applies if the goal-spec of
  the hint is the same as the goal-spec of the clause in question.

  In the case of a computed hint, the variable [47mID[0m is bound to the
  clause id, the variable [47mCLAUSE[0m is bound to the (translated form of
  the) clause, and the variable [47mWORLD[0m is bound to the current ACL2
  world.  The variable [47mSTABLE-UNDER-SIMPLIFICATIONP[0m is bound to [47mt[0m or
  [47mnil[0m.  It is bound to [47mt[0m only if the clause is known to be stable
  under simplification.  That is, the simplifier has been applied to
  the clause and did not change it.  Such a clause is sometimes known
  as a ``simplification checkpoint.'' It is frequently useful to
  inject hints (e.g., to enable a rule or provide a [47m:use[0m hint) only
  when the goal in question has stabilized.  If a hint is provided,
  the processing of the clause starts over with simplification.

  As for [47mCTX[0m and [47m[state][0m, they are provided so that you can pass them
  to the [47m[er][0m macro to print error messages.

  The remaining variables, [47mHIST[0m and [47mPSPV[0m are not documented yet.  Only
  users familiar with the internals of ACL2 are likely to need them
  or understand their values.

  For some instruction about how to use computed hints, see
  [using-computed-hints].


Subtopics

  [Using-computed-hints]
      How to use computed hints")
 (CONCATENATE
  (LISTS STRINGS ACL2-BUILT-INS)
  "Concatenate lists or strings together

    Examples:
    (concatenate 'string \"ab\" \"cd\" \"ef\")     ; equals \"abcdef\"
    (concatenate 'string \"ab\")               ; equals \"ab\"
    (concatenate 'list '(a b) '(c d) '(e f)) ; equals '(a b c d e f)
    (concatenate 'list)                      ; equals nil

    General Form:
    (concatenate result-type x1 x2 ... xn)

  where [47mn >= 0[0m and either: [47mresult-type[0m is [47m'[0m[47m[string][0m and each [47mxi[0m is a
  string; or [47mresult-type[0m is [47m'[0m[47m[list][0m and each [47mxi[0m is a true list.
  [47mConcatenate[0m simply concatenates its arguments to form the result
  string or list.  Also see [append] and see [string-append].  (The
  latter immediately generates a call to [47mconcatenate[0m when applied to
  strings.)

  Note: We do *not* try to comply with the Lisp language's insistence
  that [47mconcatenate[0m copies its arguments.  Not only are we in an
  applicative setting, where this issue shouldn't matter for the
  logic, but also we do not actually modify the underlying lisp
  implementation of [47mconcatenate[0m; we merely provide a definition for
  it.

  [47mConcatenate[0m is a Common Lisp function.  See any Common Lisp
  documentation for more information.

  [31;1mMacro: [0m<concatenate>

    (defmacro concatenate (result-type &rest sequences)
      (declare (xargs :guard (or (equal result-type ''string)
                                 (equal result-type ''list))))
      (cond ((equal result-type ''string)
             (cond ((and sequences (cdr sequences)
                         (null (cddr sequences)))
                    (list 'string-append
                          (car sequences)
                          (cadr sequences)))
                   (t (list 'string-append-lst
                            (cons 'list sequences)))))
            ((endp sequences) nil)
            (t (cons 'append
                     (append sequences (list nil))))))")
 (COND
  (BASICS ACL2-BUILT-INS)
  "Conditional based on if-then-else

  [47mCond[0m is the construct for IF, THEN, ELSE IF, ...  The test is against
  [47mnil[0m.  The argument list for [47mcond[0m is a list of ``cond clauses'',
  each of which is a list.  In ACL2, cond clauses must have length 1
  or 2.

    ; Example 1.  The form
      (COND ((CONSP X) (FOO X Y))
            ((SYMBOLP X) (BAR X Y))
            (T (LIST X Y)))
    ; abbreviates the following.
      (IF (CONSP X)
          (FOO X Y)
          (IF (SYMBOLP X)
              (BAR X Y)
              (LIST X Y)))

    ; Example 2.  The form
      (COND ((CONSP X))
            ((SYMBOLP X) (BAR X Y)))
    ; abbreviates the following.
      (OR (CONSP X)
          (IF (SYMBOLP X) (BAR X Y) NIL))

  The results above were obtained by typing [47m:trans1[0m followed by the
  form in the ACL2 loop, and then hitting [47m<RETURN>[0m.  See [trans1].
  You can experiment in this way to see other such examples.

  [47mCond[0m is a Common Lisp macro.  See any Common Lisp documentation for
  more information.

  [31;1mMacro: [0m<cond>

    (defmacro cond (&rest clauses)
      (declare (xargs :guard (cond-clausesp clauses)))
      (cond-macro clauses))

  [31;1mFunction: [0m<cond-macro>

    (defun cond-macro (clauses)
      (declare (xargs :guard (cond-clausesp clauses)))
      (if (consp clauses)
          (if (and (eq (car (car clauses)) t)
                   (eq (cdr clauses) nil))
              (if (cdr (car clauses))
                  (car (cdr (car clauses)))
                (car (car clauses)))
            (if (cdr (car clauses))
                (list 'if
                      (car (car clauses))
                      (car (cdr (car clauses)))
                      (cond-macro (cdr clauses)))
              (list 'or
                    (car (car clauses))
                    (cond-macro (cdr clauses)))))
        nil))")
 (CONGRUENCE
  (RULE-CLASSES)
  "The relations to maintain while simplifying arguments

  See [rule-classes] for a general discussion of rule classes and how
  they are used to build rules from formulas.  An example
  [47m:[0m[47m[corollary][0m formula from which a rule of class [47m:congruence[0m might
  be built, assuming that [47mset-equal[0m is a known [equivalence]
  relation, is:

    Example:
    (defthm set-equal-implies-iff-memb-2
      (implies (set-equal x y)
               (iff (memb e x) (memb e y)))
      :rule-classes :congruence)

  Also see [defcong] and see [equivalence].

  NOTE: This topic discusses so-called ``classic'' congruence rules.  A
  more general class of rules, so-called ``patterned'' congruence
  rules, is supported.  We discuss only classic congruence rules
  below; for a discussion of patterned congruence rules, first read
  the present topic and then see [patterned-congruence].

    General Form:
    (implies (equiv1 xk xk-equiv)
             (equiv2 (fn x1... xk       ...xn)
                     (fn x1... xk-equiv ...xn)))

  where [47mequiv1[0m and [47mequiv2[0m are known equivalence relations, [47mfn[0m is an
  [47mn-ary[0m function symbol other than [47mif[0m, and the [47mxi[0m and [47mxk-equiv[0m are
  all distinct variables.  The effect of such a rule is to record
  that the [47mequiv2[0m-equivalence of [47mfn[0m-expressions can be maintained if,
  while rewriting the [47mkth[0m argument position, [47mequiv1[0m-equivalence is
  maintained.  See [equivalence] for a general discussion of the
  issues.  We say that [47mequiv2[0m, above, is the ``outside equivalence''
  in the rule and [47mequiv1[0m is the ``inside equivalence for the [47mk[0mth
  argument.''

  The macro form [47m(defcong equiv1 equiv2 (fn x1 ... x1) k)[0m is an
  abbreviation for a [47m[defthm][0m of rule-class [47m:congruence[0m that attempts
  to establish that [47mequiv2[0m is maintained by maintaining [47mequiv1[0m in
  [47mfn[0m's [47mk[0mth argument.  The [47m[defcong][0m macro automatically generates the
  general formula shown above.  See [defcong].

  The [47mmemb[0m example above tells us that [47m(memb e x)[0m is propositionally
  equivalent to [47m(memb e y)[0m, provided [47mx[0m and [47my[0m are [47mset-equal[0m.  The
  outside equivalence is [47m[iff][0m and the inside equivalence for the
  second argument is [47mset-equal[0m.  If we see a [47mmemb[0m expression in a
  propositional context, e.g., as a literal of a [clause] or test of
  an [47m[if][0m (but not, for example, as an argument to [47m[cons][0m), we can
  rewrite its second argument maintaining [47mset-equality[0m.  For example,
  a rule stating the commutativity of [47m[append][0m (modulo set-equality)
  could be applied in this context.  Since equality is a refinement
  of all equivalence relations, all equality rules are always
  available.  See [refinement].

  All known congruence rules about a given outside equivalence and [47mfn[0m
  can be used independently.  That is, consider two congruence rules
  with the same outside equivalence, [47mequiv[0m, and about the same
  function [47mfn[0m.  Suppose one says that [47mequiv1[0m is the inside
  equivalence for the first argument and the other says [47mequiv2[0m is the
  inside equivalence for the second argument.  Then [47m(fn a b)[0m is [47mequiv[0m
  [47m(fn a' b')[0m provided [47ma[0m is [47mequiv1[0m to [47ma'[0m and [47mb[0m is [47mequiv2[0m to [47mb'[0m.  This
  is an easy consequence of the transitivity of [47mequiv[0m.  It permits
  you to think independently about the inside equivalences.

  Furthermore, it is possible that more than one inside equivalence for
  a given argument slot will maintain a given outside equivalence.
  For example, [47m(length a)[0m is equal to [47m(length a')[0m if [47ma[0m and [47ma'[0m are
  related either by [47mlist-equal[0m or by [47m[string-equal][0m.  You may prove
  two (or more) congruence rules for the same slot of a function.
  The result is that the system uses a new, ``generated'' equivalence
  relation for that slot with the result that rules of both (or all)
  kinds are available while rewriting.  See [geneqv] for a discussion
  of how generated equivalence relations are derived using congruence
  rules and how generated equivalence relations are represented.

  Congruence rules can be [disable]d.  For example, if you have two
  different inside equivalences for a given argument position and you
  find that the [47m:[0m[47m[rewrite][0m rules for one are unexpectedly preventing
  the application of the desired rule, you can disable the rule that
  introduced the unwanted inside equivalence.

  [31;1mNOTE[0m however that unlike other rules, the tracking of congruence
  rules is incomplete.  Specifically: when congruence rules are used
  by the rewriter as it descends through terms, to maintain the
  generated equivalence relation used for rewriting, ACL2 does not
  track the congruence rules that are used, even though it is
  relevant that they are all [enable]d.  Congruence rules that are
  used only in this way will therefore not appear in the [summary].

  [3mRemark on Replacing IFF by EQUAL.[0m You may encounter a warning
  suggesting that a congruence rule ``can be strengthened by
  replacing the second equivalence relation, IFF, by EQUAL.'' Suppose
  for example that this warning occurs when you submit the following
  rule:

    (defcong equiv1 iff (fn x y) 2)

  which is shorthand for the following:

    (defthm equiv1-implies-iff-fn-2
           (implies (equiv1 y y-equiv)
                    (iff (fn x y) (fn x y-equiv)))
           :rule-classes (:congruence))

  The warning is telling you that ACL2 was able to deduce that [47mfn[0m
  always returns a Boolean, and hence a trivial but useful
  consequence is obtained by replacing [47m[iff][0m by [47m[equal][0m ---

    (defcong equiv1 equal (fn x y) 2)

  --- which is shorthand for the following:

    (defthm equiv1-implies-equal-fn-2
           (implies (equiv1 y y-equiv)
                    (equal (fn x y) (fn x y-equiv)))
           :rule-classes (:congruence))

  If you have difficulty proving the latter directly, you can derive it
  from the former by giving a suitable hint, minimally as follows.

    (defcong equiv1 equal (fn x y) 2
      :hints ((\"Goal\"
               :use equiv1-implies-iff-fn-2
               :in-theory
               (union-theories '((:type-prescription fn))
                               (theory 'minimal-theory)))))

  By heeding this warning, you may avoid unnecessary [47m[double-rewrite][0m
  warnings later.  We now explain why, but see [double-rewrite] for
  relevant background material.

  For example, suppose you have proved the ``[47miff[0m'' version of the
  congruence rule above, and later you submit the following rewrite
  rule.

    (defthm equal-list-perm
      (implies (equiv1 x y)
               (fn x y)))

  Since [47mfn[0m is known to return a Boolean, ACL2 performs an optimization
  that stores this rule as though it were the following.

    (defthm equal-list-perm
      (implies (equiv1 x y)
               (equal (fn x y) t)))

  Thus, if ACL2's rewriter sees a term [47m(fn a b)[0m in a context where the
  equivalence relation [47m[iff][0m is not being maintained, then it cannot
  use rule [47mequiv1-implies-iff-fn-2[0m, so it rewrites argument [47ma[0m without
  the benefit of knowing that it suffices to maintain [47mequiv1[0m; and
  then it caches the result.  When ACL2 subsequently attempts to
  relieve the hypothesis [47m(equiv1 x y)[0m, it will rewrite [47mx[0m simply by
  returning the rewritten value of [47ma[0m from the result cache.  This is
  unfortunate if [47ma[0m could have been rewritten more completely under
  maintenance of the equivalence relation [47mequiv1[0m --- which is legal
  in the hypothesis since [47ma[0m is an argument of [47mequiv1[0m, which is an
  [equivalence] relation.  The user who observes the warning from
  rule [47mequiv1-implies-iff-fn-2[0m, and replaces it with
  [47mequiv1-implies-equal-fn-2[0m, will avoid this unfortunate case.")
 (CONJOIN (POINTERS)
          "See [system-utilities].")
 (CONJOIN2 (POINTERS)
           "See [system-utilities].")
 (CONJUGATE
  (NUMBERS ACL2-BUILT-INS)
  "Complex number conjugate

  [47mConjugate[0m takes an ACL2 number as an argument, and returns its
  complex conjugate (i.e., the result of negating its imaginary
  part.).

  [47mConjugate[0m is a Common Lisp function.  See any Common Lisp
  documentation for more information.

  [31;1mFunction: [0m<conjugate>

    (defun conjugate (x)
      (declare (xargs :guard (acl2-numberp x)))
      (complex (realpart x) (- (imagpart x))))")
 (CONS
  (CONSES ACL2-BUILT-INS)
  "Pair and list constructor

  [47m(cons x y)[0m is a pair whose first component is [47mx[0m and second component
  is [47my[0m.  If [47my[0m is a list, then [47m(cons x y)[0m is a list that has an
  additional element [47mx[0m on the front.")
 (CONS-COUNT-BOUNDED
  (CONSES ACL2-BUILT-INS)
  "Count the number of conses (up to a limit)

  The call [47m(cons-count-bounded x)[0m returns the number of cons nodes in [47mx[0m
  (without accounting for sharing), but truncated above by the value
  of [47m(fn-count-evg-max-val)[0m, which is 200,000 as of this writing.")
 (CONS-SUBTREES
  (FAST-ALISTS ACL2-BUILT-INS)
  "Build a fast alist whose keys are the subtrees of X

  [47m(cons-subtrees x nil)[0m builds a fast alist that associates each
  subtree of X with T, without duplication.

  [31;1mFunction: [0m<cons-subtrees>

    (defun cons-subtrees (x al)
      (declare (xargs :guard t))
      (cond ((atom x) al)
            ((hons-get x al) al)
            (t (cons-subtrees (car x)
                              (cons-subtrees (cdr x)
                                             (hons-acons x t al))))))")
 (CONS-TERM (POINTERS)
            "See [system-utilities].")
 (CONS-TERM* (POINTERS)
             "See [system-utilities].")
 (CONS-WITH-HINT
  (CONSES ACL2-BUILT-INS)
  "Alternative to [47m[cons][0m that tries to avoid consing when a suitable
  [47mcons[0m structure is provided as a hint.

  This is a special purpose function that is intended to help with
  reducing the memory usage of functions that modify existing cons
  tree structures.  Also see [hons] for a way to share [cons]
  structures; however, [47mcons-with-hint[0m is likely much cheaper than
  [47mhons[0m and hence can be useful for reducing consing without the
  overhead of [47mhons[0m.

  Logically [47m(cons-with-hint x y hint)[0m is just [47m(cons x y)[0m; [47mhint[0m is
  completely irrelevant and ignored.  We generally expect that
  [47mcons-with-hint[0m will just be left [enable]d, so you should never
  have to reason about it.

  But [47mcons-with-hint[0m has a special raw Common Lisp definition that
  tries to avoid consing by using your [47mhint[0m.  Specifically: if [47mhint[0m
  is the cons [47m(x . y)[0m, then [47mhint[0m is returned without creating a new
  cons.  Equality checking against [47mx[0m and [47my[0m is done using [47m[eql][0m, which
  makes it a fast but incomplete check for equality.

  What good is this?  A fairly common operation in ACL2 is to
  ``change'' an existing data structure by consing together a new
  structure that is similar to it, but perhaps with some subtrees
  replaced.  In many cases, some portion of the structure does not
  need to change.

  For instance, consider a function like [47m[remove-equal][0m, which updates
  a list by removing all copies of some element from it.  The
  definition of [47mremove-equal[0m is as follows (in the logic; it has a
  slightly different definition in raw Lisp).

  [31;1mFunction: [0m<remove-equal>

    (defun remove-equal (x l)
      (declare (xargs :guard (true-listp l)))
      (cond ((endp l) nil)
            ((equal x (car l))
             (remove-equal x (cdr l)))
            (t (cons (car l)
                     (remove-equal x (cdr l))))))

  You can see that if [47ml[0m doesn't have any copies of [47mx[0m, this function
  will essentially make a fresh copy of the whole list [47mx[0m.  That could
  waste a lot of memory when [47mx[0m is long.  The choice was made to
  define [47mremove-equal[0m ``under the hood'' to call Common Lisp's
  function, [47mremove[0m; but it is easy to write a new version of
  [47mremove-equal[0m that uses [47mcons-with-hint[0m:

    (defun remove-equal-with-hint (x l)
      (declare (xargs :guard (true-listp l)))
      (mbe :logic (remove-equal x l)
           :exec (cond ((endp l) nil)
                       ((equal x (car l))
                        (remove-equal-with-hint x (cdr l)))
                       (t
                        (cons-with-hint (car l)
                                        (remove-equal-with-hint x (cdr l))
                                        l)))))

  This new version avoids consing in the case that we are not dropping
  an element.  For example, at the time of this writing, we found the
  following memory usages on our copy of ACL2 built on CCL:

    :q

    ;; 16 MB of memory allocated
    (let ((list (make-list 1000 :initial-element 0)))
      (time (loop for i from 1 to 1000 do (remove-equal i list))))

    ;; 0 MB of memory allocated
    (let ((list (make-list 1000 :initial-element 0)))
      (time (loop for i from 1 to 1000 do (remove-equal-with-hint i list))))

  This memory usage is not very surprising when you consider that the
  list does not change when no removal takes place.  For example
  (still in raw Lisp):

    ? (let ((x '(a b c d e))) (eq x (remove-equal-with-hint 3 x)))
    T
    ?

  Note that ACL2 asks Lisp to inline calls of [47mcons-with-hint[0m, so there
  will likely be no function call overhead for using [47mcons-with-hint[0m.")
 (CONSERVATIVITY-OF-DEFCHOOSE
  (DEFCHOOSE)
  "Proof of conservativity of [47m[defchoose][0m

  This documentation topic provides underlying theory.  It is of
  theoretical interest only; it has no relationship to the effective
  use of ACL2.

  The argument below for the conservativity of [defchoose] replaces the
  terse and somewhat misleading reference to a forcing argument in
  Appendix B of the paper by ACL2 authors Kaufmann and Moore,
  ``Structured Theory Development for a Mechanized Logic'' (Journal
  of Automated Reasoning 26, no. 2 (2001), pp. 161--203).

  Our basic idea is to take a (countable) first-order structure for
  ACL2, M, together with a function symbol, f, introduced by
  [defchoose], and find a way to expand M with an interpretation of f
  (without changing the universe of M) so that e0-induction continues
  to hold in the expansion.  A remark at the end of this
  documentation topic shows why care is necessary.  A concept called
  ``forcing'', originally introduced by Paul Cohen for set theory,
  has long since been adapted by logicians (in a simplified form) to
  model theory.  This simplified model-theoretic forcing provides the
  means for making our careful expansion.

  The forcing argument presented below is intended to be completely
  self-contained for those familiar with basic first-order logic and
  ACL2; in particular, see [defchoose].  No background in forcing
  (model-theoretic or otherwise) is expected, though we do expect a
  rudimentary background in first-order logic and familiarity with
  the following.

  Preliminaries.  We write s[p<-p0] to denote the result of extending
  or modifying the assignment s by binding p to p0.  Now let A be a
  subset of the universe U of a first-order structure M.  A is said
  to be ``first-order definable with parameters'' in M if for some
  formula phi, variable x, and assignment s binding the free
  variables of phi except perhaps for x, A = {a \\in U: M |=
  phi[s[x<-a]]}.  Note that we are writing ``\\in'' to denote set
  membership.  Finally, we indicate the end of a proof (or of a
  theorem statement, when the proof is omitted) with the symbol
  ``-|''.

  We gratefully acknowledge very helpful feedback from John Cowles, who
  found several errors in a draft of this note and suggested the
  exercises.  We also thank Ruben Gamboa for helpful feedback, and we
  thank Jim Schmerl for an observation that led us directly to this
  proof in the first place.

  We are given a consistent first-order theory T, extending the ACL2
  ground-zero theory, that satisfies the e0-induction scheme.  We
  wish to show that the extension of T by the following arbitrary
  defchoose event is conservative, where g is a new function symbol.

    (defchoose g <bound-vars> <free-vars> <body>)

  Note that by ``the extension of T'' here we mean the extension of T
  by not only the new defchoose axiom displayed just below, but also
  the addition of e0-induction axioms for formulas in the expanded
  language obtained by including the new defchoose function symbol,
  g.

    <body> -> (LET <bound-vars> = g(<free-vars>) in <body>)

  By definition of conservativity, since proofs are finite, it clearly
  suffices to consider an arbitrary finite subset of T.  Then by the
  completeness, soundness, and downward Lowenheim-Skolem theorems of
  first-order logic, it suffices to show that an arbitrary countable
  model of T can be expanded (i.e., by interpreting the new symbol g
  without changing the universe of the model) to a model of the
  corresponding defchoose axiom above, in which all e0-induction
  axioms hold in the language of that model (i.e., the expanded
  language).

  Below, we will carry out a so-called [3mforcing[0m construction, which
  allows us to expand any countable model M of T to a model M[G] for
  the expanded language that satisfies e0-induction (in the expanded
  language) and also satisfies the axiom displayed above, generated
  from the defchoose event.  The ideas in this argument are standard
  in model theory; no novelty is claimed here.

  Fix a countable model M of a theory T that satisfies e0-induction for
  its countable language and extends the ACL2 ground-zero theory.
  Also fix the above defchoose axiom, where g is not in the language
  of T.

  We start by defining a partial order P as follows.  Let Nb and Nf be
  the lengths of <bound-vars> and <free-vars>, respectively.  P
  consists of all fn in M such that the following formula is true in
  M.  Roughly speaking, it says that fn is a finite function that
  witnesses, on its domain, the requirement above for g.

    alistp(fn) &
    no-duplicatesp-equal(strip-cars(fn)) &
    (forall <bound-vars>, <free-vars> .
       (member-equal(cons(<free-vars>,<bound-vars>), fn) ->
        (length(<bound-vars>) = Nb &
         length(<free-vars>)  = Nf &
         ((exists <bound-vars> . <body>) ->
          (LET <bound-vars> = g(<free-vars>) in <body>)))))

  P is ordered by subset, i.e., we say that p2 [3mextends[0m p1 if p1 is a
  subset (not necessarily proper) of p2 (more precisely, M |=
  subsetp-equal(p1,p2)).

  Remark.  The original argument in Appendix B of the aforementioned
  paper can essentially be salvaged, as we now show.  The key
  observation is that the particular choice of P is nearly irrelevant
  for the argument that follows below.  In particular, we can instead
  define P to consist of finite one-one functions with domain
  contained in the set of natural numbers.  More precisely, consider
  the following definitions.

    (defun function-p (fn)
      (and (alistp fn)
           (no-duplicatesp-equal (strip-cars fn))))

    (defun nat-function-p (x)
      (and (function-p x)
           (nat-listp (strip-cars x))))

  and define an inverse function on alists as follows.

    (defun inverse (fn)
      (if (endp fn)
          nil
        (cons (cons (cdar fn) (caar fn))
              (inverse (cdr fn)))))

  Then P may instead be defined to consist of those fn for which
  nat-function-p(fn) & function-p(inverse(fn)).  With this alternate
  definition of P, the argument below then goes through virtually
  unchanged, and we get an expansion M[G] of M in which there is a
  definable enumeration of the universe.  The conservativity of
  defchoose then follows easily because the function being introduced
  can be defined explicitly using that enumeration (namely, always
  pick the least witness in the sense of the enumeration).

  End of Remark.

  Next we present the relevant forcing concepts from model theory.

  A [3mdense[0m subset of P is a subset D of P such that for every p \\in P,
  there is d \\in D such that d extends p.  A subset G of P is [3mgeneric[0m
  with respect to a collection Ds of dense subsets of P, also written
  ``G is Ds-generic,'' if G is closed under subset (if p2 \\in G and
  p2 extends p1 then p1 \\in G), G is pairwise compatible (the
  union-equal of any two elements of G is in G), and every set in Ds
  has non-empty intersection with G.

  For p \\in P, we say that a subset D of P is [3mdense beyond[0m p if for all
  p1 extending p there exists p2 extending p1 such that p2 \\in D.
  This notion makes sense even for D not a subset of P if we treat
  elements of D not in P as nil.

  Proposition 1.  For any partial order P and countable collection Ds
  of dense subsets of P, there is a Ds-generic subset of P.

  Proof.  Let Ds = {D0,D1,D2,...}.  Define a sequence <p_0,p_1,...>
  such that for all i, p_i \\in Di and p_(i+1) extends p_i.  Let G =
  {p \\in P: for some i, pi extends p}.  Then G is Ds-generic. -|

  Note that P is first-order definable (with parameters) in M.  Let Df
  be the set of dense subsets of P that are first-order definable
  (with parameters) in M.  A standard argument shows there are only
  countably many first-order definitions with parameters in a
  countable model M whose language is countable --- for example, we
  can Goedel number all terms and then all formulas --- hence, Df is
  countable.

  By Proposition 1, let G be Df-generic.  Notice that for any list x of
  length Nf in M, the set of elements f of P for which x is in the
  domain of f is dense and first-order definable.  We may thus define
  a function g0 as follows: g0(x_1,...,x_Nf) = y if there is some
  element of G containing the pair ((x_1 ... x_Nf) . y).  It is easy
  to see that g0 is a total function on M.  Let L be the language of
  T and let L[g] be the union of L with a set containing a single new
  function symbol, g.  Let M[G] be the expansion of M to L[g]
  obtained by interpreting g to be g0 (see also Proposition 5 below).

  So now we have fixed M, P, Df, G, and g0, where G is Df-generic.

  Proposition 2.  Let Df be the set of dense subsets of P that are
  first-order definable (with parameters) in M.  Suppose that p \\in G
  and D \\in Df.  Then for some q \\in G extending p, q \\in D.

  Proof.  Let D0 be the set of p' \\in D that either extend p or have no
  extension in D that extends p.  We leave it as a straightforward
  exercise to show that D0 is dense, and D0 is clearly first-order
  definable (with parameters) in M.  So by genericity of G, we may
  pick q \\in D0 such that q \\in G.  Thus q \\in D.  By definition of
  generic, some extension q1 of both p and q belongs to G.  Pick q2
  \\in D extending q1; thus q has an extension in D that extends p
  (namely, q2), so by definition of D0, q extends p. -|

  Definition of forcing.  Let phi(x1,...,xk) be a first-order formula
  in L[g] and let p \\in P.  We define a formula of L, denoted ``p ||-
  phi'' (``p forces phi''), by recursion on phi (in the metatheory)
  as follows.  (Here, we view ``or'' and ``forall'' as
  abbreviations.)

      If phi is atomic, then let phi'(A) be the result of replacing,
      inside-out, each subterm of the form g(x_1,...,x_Nb) with the
      term (cdr (assoc-equal (list x_1 ... x_Nb) A)), where A is
      neither p nor a variable occurring in phi.  Then p ||- phi is
      defined as follows: ``The set {A \\in P: A extends p and
      phi'(A)} is dense beyond p''.  That is, p ||- phi is the
      following formula:

        (forall p1 \\in P extending p)
         (exists p2 \\in P extending p1) phi'(p2).

      p ||- ~phi is: (forall p' \\in P extending p) ~(p' ||- phi)

      p ||- phi_1 & phi_2 is: (p ||- phi_1) & (p ||- phi_2)

      p ||- (exists x) phi is: (exists x) (p ||- phi)

  We will need the following definition later.

  Definition.  p ||-w phi (p [3mweakly forces[0m phi) is an abbreviation for
  p ||- ~~phi.

  The following exercises were suggested by John Cowles as a means for
  gaining familiarity with the definition of forcing.

  Exercise 1. Consider the formula (phi_1 OR phi_2) as an abbreviation
  for ~(~phi_1 & ~phi_2), Show that p ||- (phi_1 OR phi_2) is
  equivalent to the following.

    (forall p' \\in P extending p) (exists p'' \\in P extending p')
     ((p'' ||- phi_1) OR (p'' ||- phi_2))

  Exercise 2. Consider the formula (forall x)phi as an abbreviation for
  ~(exists x)~phi, Show that p ||- (forall x)phi is equivalent to the
  following.

    (forall x)
     (forall p1 \\in P extending p)
      (exists p2 \\in P extending p1) (p2 ||- phi).

  Exercise 3. Prove that p ||-w phi is equivalent to the following.

    (forall p' \\in P extending p)
     (exists p'' \\in P extending p') (p'' ||- phi).

  Exercise 4. Let phi be a formula of L[g].  Prove: M |= (p ||-
  phi)[s[p<-p0]] implies M |= (p ||-w phi)[s[p<-p0]].

  Exercise 5. Let phi be a formula of L[g].  Prove: M |= (p ||-
  ~phi)[s[p<-p0]] iff M |= (p ||-w ~phi)[s[p<-p0]].

  [End of exercises.]

  The definition of forcing stipulates how to view ``p ||-
  phi(x1,...,xk)'' as a new formula theta(p,x1,...,xk).  That is,
  ``||-'' transforms formulas, so for any first-order formula phi,
  ``p ||- phi'' is just another first-order formula.  That
  observation shows that a formula such as ((p ||- phi) OR (p ||-
  ~phi)) is really just another first-order formula.  The following
  proposition thus follows easily.

  Proposition 3. For any formula phi of L[g], {p0: M |= ((p ||- phi) OR
  (p ||- ~phi))[s[p<-p0]]]} is a dense subset of P, which (since it
  is first-order definable with parameters in M) intersects G. -|

  The following proposition is easily proved by a structural induction
  on phi, and is left to the reader.

  Proposition 4. Let phi be a formula of L[g].  Suppose p0 \\in P, p1
  \\in P,
  M |= (p ||- phi)[s[p<-p0]],
  and p1 extends p0.  Then
  M |= (p ||- phi)[s[p<-p1]]. -|

  We will also need the following.

  Proposition 5. The following is dense for any finite set S of
  Nf-tuples: {p \\in P: for some <x_1 ... x_Nf> \\in S, (list x_1 ...
  x_Nf) \\in strip-cars(p)}.  Thus, the function g0 is a total
  function. -|

  The next lemma tells us that the sentences true in M[G] are those
  that are forced by an element of G.

  Truth Lemma.  Let phi be a formula in L[g], let s be an assignment to
  the free variables of phi, and let p be a variable not in the
  domain of s.  Then M[G] |= phi[s] iff for some p0 \\in G, M |= (p
  ||- phi)[s[p<-p0]].

  Proof.  The proof is by induction on the structure of phi.  First
  suppose phi is atomic.  Let D* be the set of elements p0 \\in P such
  that every assoc-equal evaluation from the definition of forcing
  phi returns a pair when A is bound to p0.  (Intuitively, this means
  that p0 is a sufficiently large approximation from any G containing
  p0 to make sense of phi in M[G].)  We make the following claim.

    (*)   For all p0 \\in G such that p0 \\in D*,
          M[G] |= phi[s] iff M |= (p ||- phi)[s[p<-p0]].

  To prove the claim, fix p0 in both G and D*, and recall the function
  g0 constructed from G in the definition of M[G].  Suppose that t_1,
  ..., t_Nf are terms and g(t_1, ..., t_Nf) is a subterm of phi.
  Then s assigns a value in M to each of the t_i.  Let a_i be the
  value assigned by s to t_i.  Then g0(a_1, ..., a_Nf) = (cdr
  (assoc-equal (list a_1 ... a_Nf) p0)), as the assoc-equal is a pair
  (since p0 \\in D*) and has the indicated value (because p0 \\in G).
  It follows by the definition of formula phi' in the definition of
  forcing:

    M[G] |= phi[s]  iff  M |= phi'(p)[s[p<-p0]]

  Moreover, because p0 \\in D* it is clear that this holds if p0 is
  replaced by an arbitrary extension of p0.  Then (*) easily follows.

  By Proposition 5, D* is dense, so there is some p0 in the
  intersection of D* and G.  The forward direction of the conclusion
  then follows by (*).  The reverse direction is clear from (*) by
  application of Proposition 2 to D* and Proposition 4.

  Next, suppose M[G] |= ~phi[x].  Then it is not the case that M[G] |=
  phi, so by the inductive hypothesis, there is no p0 \\in G for which
  M |= (p ||- phi)[s[p<-p0]].  By Proposition 3, there is p0 \\in G
  for which M |= (p ||- ~phi)[s[p<-p0]].  For the other direction,
  suppose it is not the case that M[G] |= ~phi[s].  So M[G] |=
  phi[s], and by the inductive hypothesis, there is p0 \\in G for
  which M |= (p ||- phi)[s[p<-p0]].  It follows that there is no p1
  \\in G for which M |= (p ||- ~phi)[s[p<-p1]], since from such p1 we
  can find a common extension p2 of p0 and p1 (since G is generic),
  and since p2 extends p0 then by Proposition 4, M |= (p ||-
  phi)[s[p<-p2]], contradicting (by definition of forcing) M |= (p
  ||- ~phi)[s[p<-p1]] since p2 extends p1.

  The case (phi_1 & phi_2) follows easily from the inductive
  hypothesis.  For the forward direction, apply Proposition 4 and the
  observation that by genericity, if p0 \\in G and p1 \\in G then p0
  and p1 have a common extension in G.

  Finally, the case (exists x) phi follows trivially from the inductive
  hypothesis. -|

  Truth Lemma Corollary.  The Truth Lemma holds with ||-w replacing
  ||-.

  Proof.  This is clear by applying the Truth Lemma to ~~phi. -|

  Here is our main theorem.  Recall that all first-order theories in
  our ACL2 context satisfy the e0-induction scheme.

  Theorem.  M[G] satisfies e0-induction.

  Proof.  We consider an arbitrary instance of e0-induction in L[g],
  stated using a strict well-founded relation <| and a formula phi.
  We write phi(y) to indicate that y may be among the free variables
  of phi, and phi(y<-x) to denote the result of substituting x for y
  in phi.

    theta:   (forall y) [((forall x <| y) phi(y<-x)) -> phi(y)]
          -> (forall y) phi(y)

  Our goal is to prove that theta holds in M[G].

  Below, we abuse notation by leaving assignments implicit and by
  writing ``p ||- phi(y0)'' to signify that the formula (p ||-
  phi(y)) is true in M under the extension of the explicit assignment
  that binds y to y0.  We believe that the intended meaning will be
  clear.

  Consider the following set D.

    D = {p \\in P: either p ||-w phi(y0) for all y0,
                  or else
                  for some y0, p ||- ~phi(y0) and
                               for all y1 <| y0 p ||-w phi(y1)}.

  The set D is clearly first-order definable (with parameters) in M.
  We claim that D is a dense subset of P.  For suppose p0 \\in P; we
  find p1 \\in D extending p0, as follows.  If p0 ||-w phi(y0) for all
  y0, then we may take p1 to be p0.  Otherwise, by definition of ||-w
  and ||-, there is some y0 such that for some extension p0' of p0,
  p0' ||- ~phi(y0).  Pick a <|-minimal such y0, and correspondingly
  pick p1 so that p1 extends p0 and p1 ||- ~phi(y0).  In order to
  show that p1 \\in D, it remains to show that for all y1 <| y0, p1
  ||-w phi(y1), i.e., there is no q extending p1 such that q ||-
  ~phi(y1).  This is indeed the case since otherwise q and y1 would
  contradict the <|-minimality of y0.

  Applying the genericity of G and just-proved density of D, pick p0
  \\in G such that p0 \\in D.  If p0 ||-w phi(y0) for all y0, then by
  the Truth Lemma Corollary, M[G] |= phi(y0) for all y0, and thus
  M[G] |= theta.  Otherwise, since p0 \\in D we may choose y0 such
  that p0 ||- ~phi(y0) and for all y1 <| y0, p0 ||-w phi(y1).  By the
  Truth Lemma and its corollary, since p0 \\in G we have:

    (1)   M[G] |= ~phi(y0).
    (2)   For all y1 <| y0, M[G] |= phi(y1).

  It follows that the antecedent of theta is false in M[G], as
  witnessed by y = y0; thus M[G] |= theta. -|

  Remark.  We close by returning, as promised above, to the question of
  why so much care is necessary in constructing an expansion of M.
  We assume familiarity here with the notion of a ``non-standard''
  natural number of M, i.e., one that is greater than the
  interpretation of any term that has the form (+ 1 1 1 ... 1).  Here
  is a very simple example that illustrates the need for some care.
  Consider the following event, which introduces a function foo with
  the following property: for all x, if natp(x) then natp(foo(x)).

    (defchoose foo (y) (x)
      (implies (natp x) (natp y)))

  Certainly we can build a model of the above property from a model M
  of the ground-zero theory, by interpreting foo so that for all x
  for which M satisfies natp(x), foo(x) is also a natp in M.  But
  suppose we start with a non-standard model M of the ground-zero
  theory, and we happen to define foo(x) to be 1 for all non-standard
  natural numbers x and 0 for all other x.  The resulting expansion
  of M will not satisfy the e0-induction scheme or even the ordinary
  natural number induction scheme: foo(0)=0 holds in that expansion
  as does the implication foo(n)=0 => foo(n+1)=0 for every natural
  number n of M, standard or not; and yet foo(k)=0 fails for every
  non-standard natural number k of M.")
 (CONSES
  (PROGRAMMING)
  "A [31;1mcons[0m is an ordered pair.  In ACL2, data structures like [lists],
  [alists], etc., are made up of conses.


Subtopics

  [Atom]
      Recognizer for atoms

  [Caaaar]
      [47m[car][0m of the [47m[caaar][0m

  [Caaadr]
      [47m[car][0m of the [47m[caadr][0m

  [Caaar]
      [47m[car][0m of the [47m[caar][0m

  [Caadar]
      [47m[car][0m of the [47m[cadar][0m

  [Caaddr]
      [47m[car][0m of the [47m[caddr][0m

  [Caadr]
      [47m[car][0m of the [47m[cadr][0m

  [Caar]
      [47m[car][0m of the [47m[car][0m

  [Cadaar]
      [47m[car][0m of the [47m[cdaar][0m

  [Cadadr]
      [47m[car][0m of the [47m[cdadr][0m

  [Cadar]
      [47m[car][0m of the [47m[cdar][0m

  [Caddar]
      [47m[car][0m of the [47m[cddar][0m

  [Cadddr]
      [47m[car][0m of the [47m[cdddr][0m

  [Caddr]
      [47m[car][0m of the [47m[cddr][0m

  [Cadr]
      [47m[car][0m of the [47m[cdr][0m

  [Car]
      Returns the first element of a non-empty list, else [47mnil[0m

  [Cdaaar]
      [47m[cdr][0m of the [47m[caaar][0m

  [Cdaadr]
      [47m[cdr][0m of the [47m[caadr][0m

  [Cdaar]
      [47m[cdr][0m of the [47m[caar][0m

  [Cdadar]
      [47m[cdr][0m of the [47m[cadar][0m

  [Cdaddr]
      [47m[cdr][0m of the [47m[caddr][0m

  [Cdadr]
      [47m[cdr][0m of the [47m[cadr][0m

  [Cdar]
      [47m[cdr][0m of the [47m[car][0m

  [Cddaar]
      [47m[cdr][0m of the [47m[cdaar][0m

  [Cddadr]
      [47m[cdr][0m of the [47m[cdadr][0m

  [Cddar]
      [47m[cdr][0m of the [47m[cdar][0m

  [Cdddar]
      [47m[cdr][0m of the [47m[cddar][0m

  [Cddddr]
      [47m[cdr][0m of the [47m[cdddr][0m

  [Cdddr]
      [47m[cdr][0m of the [47m[cddr][0m

  [Cddr]
      [47m[cdr][0m of the [47m[cdr][0m

  [Cdr]
      Returns the second element of a [47m[cons][0m pair, else [47mnil[0m

  [Cons]
      Pair and list constructor

  [Cons-count-bounded]
      Count the number of conses (up to a limit)

  [Cons-with-hint]
      Alternative to [47m[cons][0m that tries to avoid consing when a suitable
      [47mcons[0m structure is provided as a hint.

  [Consp]
      Recognizer for [cons] pairs

  [Listp]
      Recognizer for (not necessarily proper) lists

  [Subst]
      A single substitution into a tree")
 (CONSP
  (CONSES ACL2-BUILT-INS)
  "Recognizer for [cons] pairs

  [47m(consp x)[0m is true if and only if [47mx[0m is a [cons] pair.")
 (CONSTRAINT
  (ENCAPSULATE)
  "Restrictions on certain functions introduced in [47m[encapsulate][0m
  [events]

  Suppose that a given theorem, [47mthm[0m, is to be functionally instantiated
  using a given functional substitution, [47malist[0m.  (See
  [lemma-instance], or for an example, see
  [functional-instantiation-example].)  What is the set of proof
  obligations generated?  It is the set obtained by applying [47malist[0m to
  all terms, [47mtm[0m, such that (a) [47mtm[0m mentions some function symbol in
  the domain of [47malist[0m, and (b) either (i) [47mtm[0m is the ``constraint''
  (see below) on a function symbol ancestral in [47mthm[0m or in some
  [47m[defaxiom][0m or (ii) [47mtm[0m is the body of a [47m[defaxiom][0m.  Here, a
  function symbol is ``ancestral'' in [47mthm[0m if either it occurs in [47mthm[0m,
  or it occurs in the definition of some function symbol that occurs
  in [47mthm[0m, and so on.

  The remainder of this note explains what we mean by ``constraint'' in
  the words above.  For a utility that obtains the constraint for a
  given function symbol, see [constraint-info].

  In a certain sense, function symbols are introduced in essentially
  two ways.  The most common way is to use [47m[defun][0m (or when there is
  mutual recursion, [47m[mutual-recursion][0m or [47m[defuns][0m).  There is also a
  mechanism for introducing ``witness functions''; see [defchoose].
  The documentation for these [events] describes the axioms they
  introduce, which we will call here their ``definitional axioms.''
  These definitional axioms are generally the constraints on the
  function symbols that these axioms introduce.

  However, when a function symbol is introduced in the scope of an
  [47m[encapsulate][0m event, its constraints may differ from the
  definitional axioms introduced for it.  For example, suppose that a
  function's definition is [47m[local][0m to the [47m[encapsulate][0m; that is,
  suppose the function is introduced in the [signature] of the
  [47m[encapsulate][0m.  Then its constraints include, at the least, those
  non-[47m[local][0m theorems and definitions in the [47m[encapsulate][0m that
  mention the function symbol.

  Actually, it will follow from the discussion below that if the
  [signature] is empty for an [47m[encapsulate][0m, then the constraint on
  each of its new function symbols is exactly the definitional axiom
  introduced for it.  Intuitively, we view such [47mencapsulates[0m just as
  we view [47m[include-book][0m [events].  But the general case, where the
  [signature] is not empty, is more complicated.

  In the discussion that follows we describe in detail exactly which
  constraints are associated with which function symbols that are
  introduced in the scope of an [47m[encapsulate][0m event.  In order to
  simplify the exposition we make two cuts at it.  In the first cut
  we present an over-simplified explanation that nevertheless
  captures the main ideas.  In the second cut we complete our
  explanation by explaining how we view certain [events] as being
  ``lifted'' out of the [47m[encapsulate][0m, resulting in a possibly
  smaller [47m[encapsulate][0m, which becomes the target of the algorithm
  described in the first cut.

  At the end of this note we present an example showing why a more
  naive approach is unsound.

  Finally, before we start our ``first cut,'' we note that any
  information you want ``exported'' outside an [47m[encapsulate][0m event
  must be there as an explicit definition or theorem.  For example,
  even if a function [47mfoo[0m has output type [47m(mv t t)[0m in its [signature],
  the system will not know [47m(true-listp (foo x))[0m merely on account of
  this information.  Thus, if you are using functions like [47mfoo[0m
  (constrained [47m[mv][0m functions), then you may find it useful to prove
  (inside the [47mencapsulate[0m, to be exported) a [47m:[0m[47m[type-prescription][0m
  rule for the constrained function, for example, the
  [47m:[0m[47m[type-prescription][0m rule [47m(true-listp (foo x))[0m.

  [3mFirst cut at constraint-assigning algorithm.[0m Consider the set of
  formulas introduced by all [events] in the scope of an
  [47m[encapsulate][0m:

    * for every [47m[defthm][0m and [47m[defaxiom][0m event, include its formula as well
      as the formulas of all its corollaries;

    * for every [47m[defun][0m event, include the formula that equates the body
      with the application of the function applied to the formals;

    * for every [47mdefchoose[0m event, include the axiom that it adds (see
      [defchoose]);

    * and so on, including axioms added by [47m[defpkg][0m and (recursively) any
      subsidiary [47mencapsulate[0m events.

  Then quite simply, all such formulas are conjoined, and each function
  symbol introduced by the [47m[encapsulate][0m is assigned that conjunction
  as its constraint.

  Clearly this is a rather severe algorithm.  Let us consider two
  possible optimizations in an informal manner before presenting our
  second cut.

  Consider the (rather artificial) event below.  The function [47mbefore1[0m
  does not refer at all, even indirectly, to the locally-introduced
  function [47msig-fn[0m, so it is unfortunate to saddle it with constraints
  about [47msig-fn[0m.

    (encapsulate
     (((sig-fn *) => *))

     (defun before1 (x)
       (if (consp x)
           (before1 (cdr x))
         x))

     (local (defun sig-fn (x) (cons x x)))

     (defthm sig-fn-prop
       (consp (sig-fn x)))
     )

  We would like to imagine moving the definition of [47mbefore1[0m to just in
  front of this [47m[encapsulate][0m, as follows.

    (defun before1 (x)
      (if (consp x)
          (before1 (cdr x))
        x))

    (encapsulate
     (((sig-fn *) => *))

     (local (defun sig-fn (x) (cons x x)))

     (defthm sig-fn-prop
       (consp (sig-fn x)))
     )

  Thus, we will only assign the constraint [47m(consp (sig-fn x))[0m, from the
  theorem [47msig-fn-prop[0m, to the function [47msig-fn[0m, not to the function
  [47mbefore1[0m.

  More generally, suppose an event in an [47m[encapsulate][0m event does not
  mention any function symbol in the [signature] of the
  [47m[encapsulate][0m, nor any function symbol that mentions any such
  function symbol, and so on.  (We might say that no function symbol
  from the [signature] is an ``ancestor'' of any function symbol
  occurring in the event.)  Then we imagine moving the event, so that
  it appears in front of the [47m[encapsulate][0m.  We don't actually move
  it, but we pretend we do when it comes time to assign constraints.
  Thus, such definitions only introduce definitional axioms as the
  constraints on the function symbols being defined.  In the example
  above, the event [47msig-fn-prop[0m introduces no constraints on function
  [47mbefore1[0m.

  Once this first optimization is performed, we have in mind a set of
  ``constrained functions.'' These are the functions introduced in
  the [47m[encapsulate][0m that would remain after moving some of them in
  front, as indicated above.  Consider the collection of all formulas
  introduced by the [47m[encapsulate][0m, except the definitional axioms,
  that mention these constrained functions.  So for example, in the
  event below, no such formula mentions the function symbol [47mafter1[0m.

    (encapsulate
     (((sig-fn *) => *))

     (local (defun sig-fn (x) (cons x x)))

     (defthm sig-fn-prop
       (consp (sig-fn x)))

     (defun after1 (x)
       (sig-fn x))
     )

  We can see that there is really no harm in imagining that we move the
  definition of [47mafter1[0m out of the [47m[encapsulate][0m, to just after the
  [47m[encapsulate][0m.

  Many subtle aspects of this rearrangement process have been omitted.
  For example, suppose the function [47mfn[0m uses [47msig-fn[0m, the latter being
  a function in the signature of the encapsulation.  Suppose a
  formula about [47mfn[0m is proved in the encapsulation.  Then from the
  discussion above [47mfn[0m is among the constrained functions of the
  encapsulate: it cannot be moved before the encapsulate and it
  cannot be moved after the encapsulation.  But why is [47mfn[0m
  constrained?  The reason is that the theorem proved about [47mfn[0m may
  impose or express constraints on [47msig-fn[0m.  That is, the theorem
  proved about [47mfn[0m may depend upon properties of the witness used for
  [47msig-fn[0m.  Here is a simple example:

    (encapsulate
     (((sig-fn *) => *))

     (local (defun sig-fn (x) (declare (ignore x)) 0))

     (defun fn (lst)
       (if (endp lst)
           t
           (and (integerp (sig-fn (car lst)))
                (fn (cdr lst)))))

     (defthm fn-always-true
       (fn lst)))

  In this example, there are no [47m[defthm][0m events that mention [47msig-fn[0m
  explicitly.  One might therefore conclude that it is completely
  unconstrained.  But the witness we chose for it always returns an
  integer.  The function [47mfn[0m uses [47msig-fn[0m and we prove that [47mfn[0m always
  returns true.  Of course, the proof of this theorem depends upon
  the properties of the witness for [47msig-fn[0m, even though those
  properties were not explicitly ``called out'' in theorems proved
  about [47msig-fn[0m.  It would be unsound to move [47mfn-always-true[0m after the
  encapsulate.  It would also be unsound to constrain [47msig-fn[0m to
  satisfy just [47mfn-always-true[0m without including in the constraint the
  relation between [47msig-fn[0m and [47mfn[0m.  Hence both [47msig-fn[0m and [47mfn[0m are
  constrained by this encapsulation and the constraint imposed on
  each is the same and states the relation between the two as
  characterized by the equation defining [47mfn[0m as well as the property
  that [47mfn[0m always returns true.  Suppose, later, one proved a theorem
  about [47msig-fn[0m and wished to functionally instantiate it.  Then one
  must also functionally instantiate [47mfn[0m, even if it is not involved
  in the theorem, because it is only through [47mfn[0m that [47msig-fn[0m inherits
  its constrained properties.

  This is a pathological example that illustrate a trap into which one
  may easily fall: rather than identify the key properties of the
  constrained function the user has foreshadowed its intended
  application and constrained those notions.  Clearly, the user
  wishing to introduce the [47msig-fn[0m above would be well-advised to use
  the following instead:

    (encapsulate
     (((sig-fn *) => *))
     (local (defun sig-fn (x) (declare (ignore x)) 0))
     (defthm integerp-sig-fn
       (integerp (sig-fn x))))

    (defun fn (lst)
      (if (endp lst)
          t
        (and (integerp (sig-fn (car lst)))
             (fn (cdr lst)))))

    (defthm fn-always-true
       (fn lst)))

  Note that [47msig-fn[0m is constrained merely to be an integer.  It is the
  only constrained function.  Now [47mfn[0m is introduced after the
  encapsulation, as a simple function that uses [47msig-fn[0m.  We prove
  that [47mfn[0m always returns true, but this fact does not constrain
  [47msig-fn[0m.  Future uses of [47msig-fn[0m do not have to consider [47mfn[0m at all.

  Sometimes it is necessary to introduce a function such as [47mfn[0m within
  the [47mencapsulate[0m merely to state the key properties of the undefined
  function [47msig-fn[0m.  But that is unusual and the user should
  understand that both functions are being constrained.

  Another subtle aspect of encapsulation that has been brushed over so
  far has to do with exactly how functions defined within the
  encapsulation use the signature functions.  For example, above we
  say ``Consider the collection of all formulas introduced by the
  encapsulate, [3mexcept the definitional axioms[0m, that mention these
  constrained functions.'' We seem to suggest that a definitional
  axiom which mentions a constrained function can be moved out of the
  encapsulation and considered part of the ``post-encapsulation''
  extension of the logical [world], if the defined function is not
  used in any non-definitional formula proved in the encapsulation.
  For example, in the encapsulation above that constrained [47msig-fn[0m and
  introduced [47mfn[0m within the encapsulation, [47mfn[0m was constrained because
  we proved the formula [47mfn-always-true[0m within the encapsulation.  Had
  we not proved [47mfn-always-true[0m within the encapsulation, [47mfn[0m could
  have been moved after the encapsulation.  But this suggests an
  unsound rule because whether such a function can be moved after the
  encapsulate depend on whether its [3madmission[0m used properties of the
  witnesses!  In particular, we say a function is ``subversive'' if
  any of its governing tests or the actuals in any recursive call
  involve a function in which the signature functions are ancestral.
  See [infected-constraints] and see [subversive-recursions].

  (Aside: The definition of [47mfn[0m in the first encapsulation above that
  defines [47mfn[0m, i.e., the encapsulation with [47mfn-always-true[0m inside, is
  subversive because the call of the macro [47m[and][0m expands to a call of
  [47mIF[0m that governs a recursive call of [47mfn[0m, in this case:

    (defun fn (lst)
      (if (endp lst)
          t
          (if (integerp (sig-fn (car lst)))
              (fn (cdr lst))
            nil))).

  If we switch the order of conjuncts in [47mfn[0m, then the definition of [47mfn[0m
  is no longer subversive, but it still ``infects'' the constraint
  generated for the encapsulation, hence for [47msig-fn[0m, because
  [47mfn-always-true[0m blocks the definition of [47mfn[0m from being moved back
  (to after the encapsulation).  Also see [infected-constraints].  If
  we both switch the order of conjuncts and drop [47mfn-always-true[0m from
  the encapsulation, then the definition of [47mfn[0m is in essence moved
  back to after the encapsulation, and the constraint for [47msig-fn[0m no
  longer includes the definition of [47mfn[0m.  End of aside.)

  Another aspect we have not discussed is what happens to nested
  encapsulations when each introduces constrained functions.  We say
  an [47mencapsulate[0m event is ``trivial'' if it introduces no constrained
  functions, i.e., if its list of signatures is [47mnil[0m.  Trivial
  encapsulations are just a way to wrap up a collection of events
  into a single event.

  From the foregoing discussion we see we are interested in exactly how
  we can ``rearrange'' the events in a non-trivial encapsulation ---
  moving some ``before'' the encapsulation and others ``after'' the
  encapsulation.  We are also interested in which functions
  introduced by the encapsulation are ``constrained'' and what the
  ``constraints'' on each are.  We may summarize the observations
  above as follows, after which we conclude with a more elaborate
  example.

  [3mSecond cut at constraint-assigning algorithm.[0m First, we focus only on
  non-trivial encapsulations that neither contain nor are contained
  in non-trivial encapsulations.  (Nested non-trivial encapsulations
  are not rearranged at all: do not put anything in such a nest
  unless you mean for it to become part of the constraints
  generated.)  Second, in what follows we only consider the non-[47mlocal[0m
  events of such an [47mencapsulate[0m, assuming that they satisfy the
  restriction of using no locally defined function symbols other than
  the signature functions.  Given such an [47mencapsulate[0m event, move, to
  just in front of it and in the same order, all definitions and
  theorems for which none of the signature functions is ancestral.
  Now collect up all formulas (theorems) introduced in the
  [47m[encapsulate][0m other than definitional axioms.  Add to this set any
  of those definitional equations that is either subversive or
  defines a function used in a formula in the set.  The conjunction
  of the resulting set of formulas is called the ``constraint'' and
  the set of all the signature functions of the [47mencapsulate[0m together
  with all function symbols defined in the [47mencapsulate[0m and mentioned
  in the constraint is called the ``constrained functions.'' Assign
  the constraint to each of the constrained functions.  Move, to just
  after the [47mencapsulate[0m, the definitions of all function symbols
  defined in the [47mencapsulate[0m that have been omitted from the
  constraint.

  Implementation note.  In the implementation we do not actually move
  [events], but we create constraints that pretend that we did.

  Here is an example illustrating our constraint-assigning algorithm.
  It builds on the preceding examples.

    (encapsulate
     (((sig-fn *) => *))

     (defun before1 (x)
       (if (consp x)
           (before1 (cdr x))
         x))

     (local (defun sig-fn (x) (cons x x)))

     (defthm sig-fn-prop
       (consp (sig-fn x)))

     (defun during (x)
       (if (consp x)
           x
         (cons (car (sig-fn x))
               17)))

     (defun before2 (x)
       (before1 x))

     (defthm before2-prop
       (atom (before2 x)))

     (defthm during-prop
       (implies (and (atom x)
                     (before2 x))
                (equal (car (during x))
                       (car (sig-fn x)))))

     (defun after1 (x)
       (sig-fn x))

     (defchoose after2 (x) (u)
       (and (< u x) (during x)))
     )

  Only the functions [47msig-fn[0m and [47mduring[0m receive extra constraints.  The
  functions [47mbefore1[0m and [47mbefore2[0m are viewed as moving in front of the
  [47m[encapsulate][0m, as is the theorem [47mbefore2-prop[0m.  The functions
  [47mafter1[0m and [47mafter2[0m are viewed as being moved past the [47m[encapsulate][0m.
  The implementation reports the following.

    In addition to SIG-FN, we export AFTER2, AFTER1, BEFORE2, DURING and
    BEFORE1.

    The following constraint is associated with both of the functions DURING and
    SIG-FN:

    (AND (EQUAL (DURING X)
                (IF (CONSP X)
                    X (CONS (CAR (SIG-FN X)) 17)))
         (CONSP (SIG-FN X))
         (IMPLIES (AND (ATOM X) (BEFORE2 X))
                  (EQUAL (CAR (DURING X))
                         (CAR (SIG-FN X)))))

  Notice that the formula [47m(consp (during x))[0m is not a conjunct of the
  constraint.  During the first pass of the [47mencapsulate[0m, this formula
  is stored as a [47m:[0m[47m[type-prescription][0m rule deduced during the
  definition of the function [47mduring[0m.  However, the rule is not
  exported because of a rather subtle soundness issue.  (If you are
  interested in details, see the comments in source function
  [47mputprop-type-prescription-lst[0m.)

  We conclude by asking (and to a certain extent, answering) the
  following question: Isn't there an approach to assigning
  constraints that avoids over-constraining more simply than our
  ``second cut'' above?  Perhaps it seems that given an
  [47m[encapsulate][0m, we should simply assign to each locally defined
  function the theorems exported about that function.  If we adopted
  that simple approach the events below would be admissible.

    (encapsulate
     (((foo *) => *))
     (local (defun foo (x) x))
     (defun bar (x)
       (foo x))
     (defthm bar-prop
       (equal (bar x) x)
       :rule-classes nil))

    (defthm foo-id
      (equal (foo x) x)
      :hints ((\"Goal\" :use bar-prop)))

    ; The following event is not admissible in ACL2.

    (defthm ouch!
      nil
      :rule-classes nil
      :hints
      ((\"Goal\" :use
        ((:functional-instance foo-id
                               (foo (lambda (x) (cons x x))))))))

  Under the simple approach we have in mind, [47mbar[0m is constrained to
  satisfy both its definition and [47mbar-prop[0m because [47mbar[0m mentions a
  function declared in the signature list of the encapsulation.  In
  fact, [47mbar[0m is so-constrained in the ACL2 semantics of encapsulation
  and the first two events above (the [47mencapsulate[0m and the consequence
  that [47mfoo[0m must be the identity function) are actually admissible.
  But under the simple approach to assigning constraints, [47mfoo[0m is
  unconstrained because no theorem about it is exported.  Under that
  approach, [47mouch![0m is provable because [47mfoo[0m can be instantiated in
  [47mfoo-id[0m to a function other than the identity function.

  It's tempting to think we can fix this by including definitions, not
  just theorems, in constraints.  But consider the following slightly
  more elaborate example.  The problem is that we need to include as
  a constraint on [47mfoo[0m not only the definition of [47mbar[0m, which mentions
  [47mfoo[0m explicitly, but also [47mabc[0m, which has [47mfoo[0m as an ancestor.

    (encapsulate
     (((foo *) => *))
     (local (defun foo (x) x))
     (local (defthm foo-prop
              (equal (foo x) x)))
     (defun bar (x)
       (foo x))
     (defun abc (x)
       (bar x))
     (defthm abc-prop
       (equal (abc x) x)
       :rule-classes nil))

    (defthm foo-id
      (equal (foo x) x)
      :hints ((\"Goal\" :use abc-prop)))

    ; The following event is not admissible in ACL2.

    (defthm ouch!
      nil
      :rule-classes nil
      :hints
      ((\"Goal\" :use
        ((:functional-instance foo-id
                               (foo (lambda (x) (cons x x)))
                               (bar (lambda (x) (cons x x))))))))


Subtopics

  [Constraint-info]
      Obtaining the [constraint] on a function symbol")
 (CONSTRAINT-INFO
  (SYSTEM-UTILITIES CONSTRAINT)
  "Obtaining the [constraint] on a function symbol

  For a function symbol, [47mfn[0m, and a logical [world], [47mwrld[0m --- for
  example, the current world, [47m(w state)[0m --- evaluation of the form
  [47m(constraint-info fn wrld)[0m returns [47m(mv flg c)[0m, where [47mc[0m is the list
  of [constraint]s on [47mfn[0m (implicitly conjoined), and [47mflg[0m is [47mnil[0m if [47mfn[0m
  is a defined function and otherwise is a function symbol with that
  same list of constraints (possibly [47mfn[0m itself).  See [constraint]
  for relevant background.

  We illustrate with the following example.

    (encapsulate
      (((f1 *) => *)
       ((f3 *) => *))
      (local (defun f1 (x) x))
      (defun f2 (x) (f1 x))
      (local (defun f3 (x) x))
      (defun f4 (x) (f3 x))
      (defthm f1-prop (equal (f1 x) (f4 x))))

  Then we can see the results of [47mconstraint-info[0m on each introduced
  function symbol, as follows.

    ACL2 !>(let ((wrld (w state)))
              (list
               'result
               'f1 (mv-let (flg1 c1) (constraint-info 'f1 wrld) (list flg1 c1))
               'f2 (mv-let (flg2 c2) (constraint-info 'f2 wrld) (list flg2 c2))
               'f3 (mv-let (flg3 c3) (constraint-info 'f3 wrld) (list flg3 c3))
               'f4 (mv-let (flg4 c4) (constraint-info 'f4 wrld) (list flg4 c4))))
    (RESULT F1
            (F1 ((EQUAL (F4 X) (F3 X))
                 (EQUAL (F1 X) (F4 X))))
            F2 (NIL (EQUAL (F2 X) (F1 X)))
            F3
            (F1 ((EQUAL (F4 X) (F3 X))
                 (EQUAL (F1 X) (F4 X))))
            F4
            (F1 ((EQUAL (F4 X) (F3 X))
                 (EQUAL (F1 X) (F4 X)))))
    ACL2 !>

  Notice that the flag (first result) for [47mf2[0m is [47mnil[0m, because even
  though the definition of [47mf2[0m is lexically inside the [47mencapsulate[0m, it
  doesn't affect the constraints because it can be safely moved to
  just after the [47mencapsulate[0m.  However, the definition of [47mf4[0m does
  affect (or ``infect''; see [subversive-recursions]) the
  constraints: it can't be moved to after the [47mencapsulate[0m because of
  the [47mdefthm[0m after it.

  Also see [constraint].  For more details, see comments in the
  definition of [47mconstraint-info[0m in the ACL2 source code.")
 (CONTEXT (POINTERS) "See [ctx].")
 (CONTEXT-MESSAGE-PAIR
  (KESTREL-UTILITIES SYSTEM-UTILITIES-NON-BUILT-IN)
  "A common ACL2 programming idiom: [error-triple]s without [state]

  [3mContext-message pairs[0m are of the form [47m(mv erp val)[0m, where there are
  the following two cases: the first indicates a successful
  computation and the second indicates an error.

    * [31;1mNormal case[0m: [47merp[0m is [47mnil[0m and [47mval[0m is what we call the ``value'' of that
      context-message pair.

    * [31;1mError case[0m: [47merp[0m is not [47mnil[0m.  [47mVal[0m may be [47mnil[0m; otherwise [47mval[0m is a
      message (see [msgp]) suitable for printing with [47m[fmt][0m and
      related functions using the [47m~@[0m directive, and [47merp[0m is a context
      suitable for error messages (see [ctx]).  A convention
      generally observed (for example, by ACL2 system function
      [47mcmp-to-error-triple[0m, which converts a context-message pair to
      an [error-triple] that may be printed in the error case) is
      when [47merp[0m and [47mval[0m are both non-[47mnil[0m, then [47merp[0m is not [47mt[0m.

  To see how this works let us consider the ACL2 source function,
  [47mtranslate-cmp[0m, whose input is a user-level (``untranslated'') term
  as input and returns a context-message pair.  In the non-error
  case, the value returned is the internal (``translated'') form of
  that input; see [term].  The log below first shows a successful
  translation, returning multiple values [47m(mv nil (binary-+ x '3))[0m,
  thus illustrating the ``Normal case'' above, where the first value
  returned (the error indicator) is [47mnil[0m and the second is the value
  of the pair.  The second example in the log shows an error case
  returning a context and a message.  Don't worry about the various
  arguments of [47mtranslate-cmp[0m; the examples are merely to illustrate
  programming with context-message pairs, not to explain
  [47mtranslate-cmp[0m!

    ACL2 !>(translate-cmp '(+ x 3)
                          t t t 'top (w state)
                          (default-state-vars state))
    (NIL (BINARY-+ X '3))
    ACL2 !>(translate-cmp '(quote 3 4)
                          t t t 'top (w state)
                          (default-state-vars state))
    (TOP (\"The proper form of a quoted constant is (quote x), but ~
                         ~x0 is not of this form.\"
              (#0 QUOTE 3 4)))
    ACL2 !>

  The following macros are useful when programming with context-message
  pairs.

    * [47m(value-cmp x)[0m: same as [47m(mv nil x)[0m.  Example:

          ACL2 !>(value-cmp (* 3 4))
          (NIL 12)
          ACL2 !>

    * [47m(er-cmp ctx str &rest args)[0m: Return [47m(mv ctx msg)[0m where [47mmsg[0m is formed
      from [47mstr[0m and [47margs[0m.  Example:

          ACL2 !>(er-cmp 'example
                         \"I don't like 3-element lists like ~x0.~|\"
                         (make-list 3))
          (EXAMPLE (\"I don't like 3-element lists like ~x0.~|\" (#0 NIL NIL NIL)))
          ACL2 !>(mv-let (ctx msg)
                   (er-cmp 'example
                           \"I don't like 3-element lists like ~x0.~|\"
                           (make-list 3))
                   (fmx \"Error in ~x0: ~@1\" ctx msg))
          Error in EXAMPLE: I don't like 3-element lists like (NIL NIL NIL).
          (0 <state>)
          ACL2 !>

    * [47m(er-let*-cmp alist body)[0m: Analogue of [47m[er-let*][0m for context-message
      pairs.  So, it evaluates the bindings in [47malist[0m much as
      [47m[let*][0m-bindings would be evaluated, but where each expression
      should return a context-message pair and so should [47mbody[0m.  If
      any of those expression evaluations returns a pair with a
      non-nil first value, then that pair is returned.  Otherwise,
      [47mbody[0m --- which should return a context-message pair --- is
      evaluated with respect to the resulting bindings.  Examples
      (refer to previous examples that use [47mtranslate-cmp[0m):

          ACL2 !>(er-let*-cmp ((x (value-cmp '(+ x 3)))
                               (val (translate-cmp x
                                                   t t t 'top (w state)
                                                   (default-state-vars state)))
                               (y (value-cmp (list :term val))))
                              (value-cmp (list :result y)))
          (NIL (:RESULT (:TERM (BINARY-+ X '3))))
          ACL2 !>(er-let*-cmp ((x (value-cmp '(quote 3 4)))
                               (val (translate-cmp x
                                                   t t t 'top (w state)
                                                   (default-state-vars state)))
                               (y (value-cmp (list :term val))))
                              (value-cmp (list :result y)))
          (TOP (\"The proper form of a quoted constant is (quote x), but ~
                               ~x0 is not of this form.\"
                    (#0 QUOTE 3 4)))
          ACL2 !>

    * [47m(er-progn-cmp form1 ... formk)[0m: Each [47mformi[0m should evaluate to a
      context-message pair.  If any of these evaluations produces a
      pair with a non-[47mnil[0m first component (thus indicating an error),
      return that pair.  Otherwise return the context-message pair
      produced by evaluating [47mformk[0m.  Examples:

          ACL2 !>(er-progn-cmp (value-cmp (+ 2 8))
                               (er-cmp 'top \"Ouch\")
                               (value-cmp (* 3 4)))
          (TOP (\"Ouch\"))
          ACL2 !>(er-progn-cmp (value-cmp (+ 2 8))
                               (value-cmp (* 3 4)))
          (NIL 12)
          ACL2 !>")
 (CONVERSION
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "Conversion to Uppercase

  When symbols are read by Common Lisp they are converted to upper
  case.  Note carefully that this remark applies to the characters in
  [3msymbols[0m.  The characters in strings are not converted upper case.

  To type a symbol containing lower case characters you can enclose the
  symbol in vertical bars, as in [47m|AbC|[0m or you can put a ``backslash''
  before each lower case character you wish to preserve, as in [47mA\\bC[0m.
  [47m|AbC|[0m and [47mA\\bC[0m are two different ways of writing the same symbol
  (just like 2/4 and 1/2 are two different ways of writing the same
  rational and 123 and 0123 are two different ways to write the same
  natural number).  The symbol has three characters in its name, the
  middle one of which is a lower case b.")
 (COPYRIGHT
  (ABOUT-ACL2)
  "ACL2 copyright, license, sponsorship

  This topic provides information about copyright, license, authorship,
  and sponsorship of the ACL2 system.  For information about
  copyright and authorship of [documentation], see
  [documentation-copyright], which notes that there are many
  documentation authors.

  ACL2 Version 8.6 --- A Computational Logic for Applicative Common
  Lisp

  Copyright (C) 2025, Regents of the University of Texas

  This version of ACL2 is a descendant of ACL2 Version 1.9, Copyright
  (C) 1997 Computational Logic, Inc.  See the documentation topic
  NOTE-2-0.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the LICENSE file distributed with ACL2.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  LICENSE for more details.

  Written by: Matt Kaufmann and J Strother Moore
  email: Kaufmann@cs.utexas.edu and Moore@cs.utexas.edu
  Department of Computer Science
  University of Texas at Austin
  Austin, TX 78712 U.S.A.

  Please also see [acknowledgments].


Subtopics

  [Documentation-copyright]
      Copyright and authorship of documentation")
 (COROLLARY
  (RULE-CLASSES)
  "The corollary formula of a [rune]

  See [formula].  This is a low-level system function at the present
  time.  See [pr] and see [pr!] instead.  Also see [rule-classes] for
  the use of the symbol [47m:corollary[0m in specifying a rule class.")
 (CORROBORATING_MODELS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "Corroborating Models

  {IMAGE} (see [Models_of_Computer_Hardware_and_Software])

  After producing a model, it must be [31;1mcorroborated[0m against reality.
  The Falling Body Model has been corroborated by a vast number of
  experiments in which the time and distance were measured and
  compared according to the formula.  In general all models must be
  corroborated by experiment.

  The Falling Body Model can be derived from deeper models, namely
  Newton's laws of motion and the assertion that, over the limited
  distances concerned, gravitation exerts a constant acceleration on
  the object.  When the model in question can be derived from other
  models, it is the other models that are being corroborated by our
  experiments.

  Because nature is not formal, we cannot [31;1mprove[0m that our models of it
  are correct.  All we can do is test our models against nature's
  behavior.

  Such testing often exposes restrictions on the applicability of our
  models.  For example, the Falling Body Model is inaccurate if air
  resistance is significant.  Thus, we learn not to use that model to
  predict how long it takes a feather to fall from a 200 foot tower
  in the earth's atmosphere.

  In addition, attempts at corroboration might reveal that the model is
  actually incorrect.  Careful measurements might expose the fact
  that the gravitational force increases as the body falls closer to
  earth.  Very careful measurements might reveal relativistic
  effects.  Technically, the familiar Falling Body Model is just
  wrong, even under excessive restrictions such as ``in a perfect
  vacuum'' and ``over small distances.'' But it is an incredibly
  useful model nonetheless.

  There are several morals here.

  [31;1mModels need not be complete to be useful.[0m

  [31;1mModels need not be perfectly accurate to be useful.[0m

  [31;1mThe user of a model must understand its limitations.[0m

  {IMAGE} (see [Models_of_Computer_Hardware_and_Software])")
 (COUNT
  (LISTS STRINGS ACL2-BUILT-INS)
  "Count the number of occurrences of an item in a string or true-list

    Example Forms:
    (count #\\D \"DabcDefcDe\")                 ; = 3
    (count #\\D \"DabcDefcDe\" :start 1)        ; = 2
    (count #\\D \"DabcDefcDe\" :start 1 :end 5) ; = 1
    (count #\\D \"DabcDefcDe\" :start 1 :end 4) ; = 0
    (count #\\z \"DabcDefcDe\")                 ; = 0
    (count '(a b) '(17 (a b) 23 (a b) (c d)))   ; = 2

    General Form:
    (count item sequence &key start end)

  [47m(Count item sequence)[0m returns the number of times [47mitem[0m occurs in
  [47msequence[0m.  The [guard] for calls of [47mcount[0m (which is actually a
  macro in ACL2) specifies that [47msequence[0m is a string or a true-list,
  and that [47mstart[0m, which defaults to 0, and [47mend[0m, which defaults to the
  length of [47msequence[0m, are valid indices into sequence.

  See any Common Lisp documentation for more information about [47mcount[0m,
  which is a Common Lisp utility.  At this time ACL2 does not support
  keyword arguments for [47mcount[0m other than [47m:start[0m and [47m:end[0m; we may add
  support for the [47m:from-end[0m keyword upon request.

  [31;1mMacro: [0m<count>

    (defmacro count (item sequence &key (start '0) end)
      (cons 'count-fn
            (cons item
                  (cons sequence
                        (cons start (cons end 'nil))))))")
 (COUNT-KEYS
  (STOBJ ACL2-BUILT-INS)
  "Count the number of keys in association list

  [47m(Count-keys al)[0m returns the number of distinct keys in an association
  list.

  [47mCount-keys[0m has a guard of [47mt[0m.  This function is called in the body of
  function, [47m<h>-count[0m where [47m<h>[0m is a hash-table field of a [stobj].
  See [defstobj].

  [31;1mFunction: [0m<hons-remove-assoc>

    (defun hons-remove-assoc (k x)
      (declare (xargs :guard t))
      (if (atom x)
          nil
        (if (and (consp (car x))
                 (not (equal k (caar x))))
            (cons (car x)
                  (hons-remove-assoc k (cdr x)))
          (hons-remove-assoc k (cdr x)))))

  [31;1mFunction: [0m<count-keys>

    (defun count-keys (al)
      (declare (xargs :guard t))
      (if (atom al)
          0
        (if (consp (car al))
            (+ 1
               (count-keys (hons-remove-assoc (caar al) (cdr al))))
          (count-keys (cdr al)))))")
 (COURSE-MATERIALS
  (DOCUMENTATION)
  "Some ACL2 course materials

  The links listed below will take you to materials for some courses
  that involve ACL2.  This list is loosely maintained and incomplete,
  and is given in no particular order.  We strongly encourage you to
  send email to {Matt Kaufmann | mailto:kaufmann@cs.utexas.edu} and
  {J Strother Moore | mailto:moore@cs.utexas.edu} if you have
  additional such links to contribute; or if you are a contributor to
  the ACL2 [community-books], please feel free to add them yourself.

    * See [recursion-and-induction] for notes you can use to teach yourself
      how to prove theorems about recursively defined functions using
      mathematical induction.  That document started as notes for the
      course ``Recursion and Induction'' in the Department of
      Computer Science of the University of Texas at Austin.

    * {Courses taught by Pete Manolios |
      https://www.ccs.neu.edu/home/pete/teaching.html}, which use the
      ACL2 Sedan (ACL2s) (see [ACL2-SEDAN]), including {one taught at
      Northeastern in Spring 2020 |
      https://www.ccs.neu.edu/home/pete/courses/Logic-and-Computation/2020-Spring/}

    * The following two interfaces to ACL2 support the teaching of ACL2 to
      undergraduates:

        * The ACL2 Sedan (ACL2s) (see [ACL2-SEDAN])

        * {DrACuLa | http://dracula-lang.github.io/index.html}

    * John Cowles, {COSC5010: Formalizing the JVM in ACL2 |
      http://www.cs.uwyo.edu/~cowles/jvm-acl2/}, Univ. of Wyoming

    * Links to some of Warren Hunt's courses, many of which use ACL2, may
      be found {here |
      http://www.cs.utexas.edu/users/hunt/class/index.html}.

    * Links to some of J Moore's courses, many of which use ACL2, may be
      found {here |
      http://www.cs.utexas.edu/users/moore/classes/index.html}.")
 (CPU-CORE-COUNT
  (PARALLELISM ACL2-BUILT-INS)
  "The number of cpu cores

  This [documentation] topic relates to the experimental extension of
  ACL2 supporting parallel execution and proof; see [parallelism].

  Unless the ACL2 executable supports parallel execution (see
  [parallelism]), this function returns [47m(mv 1 state)[0m.  Otherwise:

  [47m(Cpu-core-count state)[0m returns [47m(mv core-count state)[0m, where
  [47mcore-count[0m is determined as follows.  If environment variable
  [47mACL2_CORE_COUNT[0m has a non-empty value, then that value should
  represent a positive integer (else an error occurs), which is the
  returned [47mcore-count[0m.  Otherwise, the returned [47mcore-count[0m may be
  obtained from the underlying Common Lisp implementation, else as a
  positive integer value from [state] global variable [47m'cpu-core-count[0m
  (see [assign]).  Otherwise an error occurs.

    Example:
    (cpu-core-count state) ==> (mv 4 state)

  [47mCpu-core-count[0m has the following logical definition.

  [31;1mFunction: [0m<cpu-core-count>

    (defun cpu-core-count (state)
      (declare (xargs :stobjs state :guard t))
      (mv-let (nullp val state)
              (read-acl2-oracle state)
        (declare (ignore nullp))
        (mv val state)))")
 (CTX
  (ERRORS)
  "Context object for error messages

  Calls of [47m[er][0m, such as [47m(er soft ctx ...)[0m, take a context argument,
  typically called [47mctx[0m, for the initial part of the message: [47m\"ACL2
  Error in\"[0m.  If [47mctx[0m is [47mnil[0m, only [47m\"ACL2 Error:\"[0m is printed for that
  initial part of the message.  Otherwise, the string printed after
  [47m\"in\"[0m depends on the form of that context, as follows.  (See [ctxp]
  for the definition of a valid context.)

    * If [47mctx[0m is a symbol, print it with [47m[fmt][0m using [47m\"~x\"[0m.

    * If [47mctx[0m is a pair whose [47mcar[0m is a symbol, use [47m[fmt][0m to print [47m\"(~x0 ~x1
      ...)\"[0m, with [47m#\\0[0m and [47m#\\1[0m bound respectively to the [47mcar[0m and [47mcdr[0m
      of [47mctx[0m.  [31;1mException[0m: if the [47mcar[0m is a member of the value of
      constant [47m*fmt-ctx-spacers*[0m, then a space is printed after the
      left parenthesis.  That explains why there is a space, for
      example, in [47m\"( DEFUN\"[0m in error messages starting with:

          ACL2 Error in ( DEFUN FOO ...):

    * Otherwise, print [47mctx[0m with [47mfmt[0m using [47m\"~@\"[0m.")
 (CTXP
  (ERRORS)
  "Recognizer for context objects for error messages

  See [ctx] for relevant background.  The function [47mctxp[0m returns [47mt[0m when
  [47mctx[0m is a valid context according to the definition below (also see
  [msgp]), else [47mnil[0m.

  [31;1mFunction: [0m<ctxp>

    (defun ctxp (x)
      (declare (xargs :guard t))
      (or (symbolp x)
          (and (consp x) (symbolp (car x)))
          (msgp x)))")
 (CURRENT-PACKAGE
  (LD)
  "The package used for reading and printing

  [47mCurrent-package[0m is an [47m[ld][0m special (see [ld]).  The accessor is
  [47m(current-package state)[0m and the updater is [47m(set-current-package val
  state)[0m, or more conventionally, [47m(in-package val)[0m.  The value of
  [47mcurrent-package[0m is actually the string that names the package.
  (Common Lisp's ``package'' objects do not exist in ACL2.)  The
  current package must be known to ACL2, i.e., it must be one of the
  initial packages or a package defined with [47m[defpkg][0m by the user.

  When printing symbols, the package prefix is displayed if it is not
  the [47mcurrent-package[0m and may be optionally displayed otherwise.
  Thus, if [47mcurrent-package[0m is [47m\"ACL2\"[0m then the symbol [47m'ACL2::SYMB[0m may
  be printed as [47mSYMB[0m or [47mACL2::SYMB[0m, while [47m'MY-PKG::SYMB[0m must be
  printed as [47mMY-PKG::SYMB[0m.  But if [47mcurrent-package[0m is [47m\"MY-PKG\"[0m then
  the former symbol must be printed as [47mACL2::SYMB[0m while the latter
  may be printed as [47mSYMB[0m.

  In Common Lisp, [47mcurrent-package[0m also affects how objects are read
  from character streams.  Roughly speaking, read and print are
  inverses if the [47mcurrent-package[0m is fixed, so reading from a stream
  produced by printing an object must produce an equal object.

  In ACL2, the situation is more complicated because we never read
  objects from character streams, we only read them from object
  ``streams'' (channels).  Logically speaking, the objects in such a
  channel are fixed regardless of the setting of [47mcurrent-package[0m.
  However, our host file systems do not support the idea of Lisp
  object files and instead only support character files.  So when you
  open an object input channel to a given (character file) we must
  somehow convert it to a list of ACL2 objects.  This is done by a
  [3mdeus ex machina[0m (``a person or thing that appears or is introduced
  suddenly and unexpectedly and provides a contrived solution to an
  apparently insoluble difficulty,'' Webster's Ninth New Collegiate
  Dictionary).  Roughly speaking, the [3mdeus ex machina[0m determines what
  sequence of calls to [47mread-object[0m will occur in the future and what
  the [47mcurrent-package[0m will be during each of those calls, and then
  produces a channel containing the sequence of objects produced by
  an analogous sequence of Common Lisp reads with [47m*current-package*[0m
  bound appropriately for each.

  A simple rule suffices to make sane file [io] possible: before you
  read an object from an object channel to a file created by printing
  to a character channel, make sure the [47mcurrent-package[0m at read-time
  is the same as it was at print-time.")
 (CURRENT-THEORY
  (THEORIES THEORY-FUNCTIONS)
  "Currently [enable]d rules as of logical name

    Examples:
    (current-theory :here)
    (current-theory 'lemma3)

  See [logical-name].

    General Form:
    (current-theory logical-name)

  Returns the current theory as it existed immediately after the
  introduction of [47m[logical-name][0m provided it is evaluated in an
  environment in which the variable symbol WORLD is bound to the
  current ACL2 logical world, [47m(w state)[0m.  Thus,

    ACL2 !>(current-theory :here)

  will cause an (unbound variable) error while

    ACL2 !>(let ((world (w state))) (current-theory :here))

  will return the current theory in world.

  See [theories] and see [logical-name] for a discussion of theories in
  general and why the commonly used ``theory functions'' such as
  [47mcurrent-theory[0m are really macros that expand into terms involving
  the variable [47mworld[0m.

  The theory returned by [47mcurrent-theory[0m is in fact the theory selected
  by the [47m[in-theory][0m event most recently preceding logical name,
  extended by the rules introduced up through [47m[logical-name][0m.

  You may experience a fencepost problem in deciding which logical name
  to use.  [47m[Deflabel][0m can always be used to mark unambiguously for
  future reference a particular point in the development of your
  theory.  The order of [events] in the vicinity of an [47m[encapsulate][0m
  is confusing.  See [encapsulate].

  This ``function'' is actually a macro that expands to a term
  mentioning the single free variable [47m[world][0m.  When theory
  expressions are evaluated by [47m[in-theory][0m or the [47m:[0m[47m[in-theory][0m hint,
  [47m[world][0m is bound to the current ACL2 [world].")
 (CUSTOM-KEYWORD-HINTS
  (HINTS)
  "User-def