# flake8: noqa
# THIS FILE IS AUTOGENERATED, DO NOT EDIT!!!
#
# Cambalache Base Object wrappers
#
# Copyright (C) 2021-2024  Juan Pablo Ugarte
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation;
# version 2.1 of the License.
#
# library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# Authors:
#   Juan Pablo Ugarte <juanpablougarte@gmail.com>
#
# SPDX-License-Identifier: LGPL-2.1-only
#

from gi.repository import GObject
from .cmb_base import CmbBase
from .cmb_base_file_monitor import CmbBaseFileMonitor


class CmbBaseLibraryInfo(CmbBase):
    __gtype_name__ = "CmbBaseLibraryInfo"

    library_id = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    version = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    namespace = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    prefix = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    shared_library = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    license_id = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    license_text = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)

    def __init__(self, **kwargs):
        super().__init__(**kwargs)

    @classmethod
    def from_row(cls, project, library_id, version, namespace, prefix, shared_library, license_id, license_text):
        return cls(
            project=project,
            library_id=library_id,
            version=version,
            namespace=namespace,
            prefix=prefix,
            shared_library=shared_library,
            license_id=license_id,
            license_text=license_text,
        )


class CmbBasePropertyInfo(CmbBase):
    __gtype_name__ = "CmbBasePropertyInfo"

    owner_id = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    property_id = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    type_id = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    is_object = GObject.Property(
        type=bool, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY, default=False
    )
    construct_only = GObject.Property(
        type=bool, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY, default=False
    )
    save_always = GObject.Property(
        type=bool, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY, default=False
    )
    default_value = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    minimum = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    maximum = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    version = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    deprecated_version = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    translatable = GObject.Property(
        type=bool, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY, default=False
    )
    disable_inline_object = GObject.Property(
        type=bool, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY, default=False
    )
    deprecated = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    required = GObject.Property(
        type=bool, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY, default=False
    )
    workspace_default = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    original_owner_id = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    disabled = GObject.Property(
        type=bool, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY, default=False
    )

    def __init__(self, **kwargs):
        super().__init__(**kwargs)

    @classmethod
    def from_row(
        cls,
        project,
        owner_id,
        property_id,
        type_id,
        is_object,
        construct_only,
        save_always,
        default_value,
        minimum,
        maximum,
        version,
        deprecated_version,
        translatable,
        disable_inline_object,
        deprecated,
        required,
        workspace_default,
        original_owner_id,
        disabled,
    ):
        return cls(
            project=project,
            owner_id=owner_id,
            property_id=property_id,
            type_id=type_id,
            is_object=is_object,
            construct_only=construct_only,
            save_always=save_always,
            default_value=default_value,
            minimum=minimum,
            maximum=maximum,
            version=version,
            deprecated_version=deprecated_version,
            translatable=translatable,
            disable_inline_object=disable_inline_object,
            deprecated=deprecated,
            required=required,
            workspace_default=workspace_default,
            original_owner_id=original_owner_id,
            disabled=disabled,
        )


class CmbSignalInfo(CmbBase):
    __gtype_name__ = "CmbSignalInfo"

    owner_id = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    signal_id = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    version = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    deprecated_version = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    detailed = GObject.Property(
        type=bool, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY, default=False
    )

    def __init__(self, **kwargs):
        super().__init__(**kwargs)

    @classmethod
    def from_row(cls, project, owner_id, signal_id, version, deprecated_version, detailed):
        return cls(
            project=project,
            owner_id=owner_id,
            signal_id=signal_id,
            version=version,
            deprecated_version=deprecated_version,
            detailed=detailed,
        )


class CmbBaseTypeInfo(CmbBase):
    __gtype_name__ = "CmbBaseTypeInfo"

    type_id = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    parent_id = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    library_id = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    version = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    deprecated_version = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    abstract = GObject.Property(
        type=bool, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY, default=False
    )
    derivable = GObject.Property(
        type=bool, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY, default=False
    )
    layout = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    category = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    workspace_type = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)

    def __init__(self, **kwargs):
        super().__init__(**kwargs)

    @classmethod
    def from_row(
        cls,
        project,
        type_id,
        parent_id,
        library_id,
        version,
        deprecated_version,
        abstract,
        derivable,
        layout,
        category,
        workspace_type,
    ):
        return cls(
            project=project,
            type_id=type_id,
            parent_id=parent_id,
            library_id=library_id,
            version=version,
            deprecated_version=deprecated_version,
            abstract=abstract,
            derivable=derivable,
            layout=layout,
            category=category,
            workspace_type=workspace_type,
        )


class CmbBaseTypeDataInfo(CmbBase):
    __gtype_name__ = "CmbBaseTypeDataInfo"

    owner_id = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    data_id = GObject.Property(type=int, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    parent_id = GObject.Property(type=int, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    key = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    type_id = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    translatable = GObject.Property(
        type=bool, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY, default=False
    )

    def __init__(self, **kwargs):
        super().__init__(**kwargs)

    @classmethod
    def from_row(cls, project, owner_id, data_id, parent_id, key, type_id, translatable):
        return cls(
            project=project,
            owner_id=owner_id,
            data_id=data_id,
            parent_id=parent_id,
            key=key,
            type_id=type_id,
            translatable=translatable,
        )


class CmbBaseTypeDataArgInfo(CmbBase):
    __gtype_name__ = "CmbBaseTypeDataArgInfo"

    owner_id = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    data_id = GObject.Property(type=int, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    key = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    type_id = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)

    def __init__(self, **kwargs):
        super().__init__(**kwargs)

    @classmethod
    def from_row(cls, project, owner_id, data_id, key, type_id):
        return cls(project=project, owner_id=owner_id, data_id=data_id, key=key, type_id=type_id)


class CmbTypeChildInfo(CmbBase):
    __gtype_name__ = "CmbTypeChildInfo"

    type_id = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    child_type = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    max_children = GObject.Property(type=int, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    linked_property_id = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)

    def __init__(self, **kwargs):
        super().__init__(**kwargs)

    @classmethod
    def from_row(cls, project, type_id, child_type, max_children, linked_property_id):
        return cls(
            project=project,
            type_id=type_id,
            child_type=child_type,
            max_children=max_children,
            linked_property_id=linked_property_id,
        )


class CmbBaseTypeInternalChildInfo(CmbBase):
    __gtype_name__ = "CmbBaseTypeInternalChildInfo"

    type_id = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    internal_child_id = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    internal_parent_id = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    internal_type = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    creation_property_id = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)

    def __init__(self, **kwargs):
        super().__init__(**kwargs)

    @classmethod
    def from_row(cls, project, type_id, internal_child_id, internal_parent_id, internal_type, creation_property_id):
        return cls(
            project=project,
            type_id=type_id,
            internal_child_id=internal_child_id,
            internal_parent_id=internal_parent_id,
            internal_type=internal_type,
            creation_property_id=creation_property_id,
        )


class CmbBaseUI(CmbBaseFileMonitor):
    __gtype_name__ = "CmbBaseUI"

    ui_id = GObject.Property(type=int, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)

    def __init__(self, **kwargs):
        super().__init__(**kwargs)

    @classmethod
    def from_row(
        cls,
        project,
        ui_id,
        template_id,
        name,
        filename,
        description,
        copyright,
        authors,
        license_id,
        translation_domain,
        comment,
        custom_fragment,
    ):
        return cls(project=project, ui_id=ui_id)

    @GObject.Property(type=int)
    def template_id(self):
        return self.db_get("SELECT template_id FROM ui WHERE (ui_id) IS (?);", (self.ui_id,))

    @template_id.setter
    def _set_template_id(self, value):
        self.db_set("UPDATE ui SET template_id=? WHERE (ui_id) IS (?);", (self.ui_id,), value)

    @GObject.Property(type=str)
    def name(self):
        return self.db_get("SELECT name FROM ui WHERE (ui_id) IS (?);", (self.ui_id,))

    @name.setter
    def _set_name(self, value):
        self.db_set("UPDATE ui SET name=? WHERE (ui_id) IS (?);", (self.ui_id,), value)

    @GObject.Property(type=str)
    def filename(self):
        return self.db_get("SELECT filename FROM ui WHERE (ui_id) IS (?);", (self.ui_id,))

    @filename.setter
    def _set_filename(self, value):
        self.db_set("UPDATE ui SET filename=? WHERE (ui_id) IS (?);", (self.ui_id,), value)

    @GObject.Property(type=str)
    def description(self):
        return self.db_get("SELECT description FROM ui WHERE (ui_id) IS (?);", (self.ui_id,))

    @description.setter
    def _set_description(self, value):
        self.db_set("UPDATE ui SET description=? WHERE (ui_id) IS (?);", (self.ui_id,), value)

    @GObject.Property(type=str)
    def copyright(self):
        return self.db_get("SELECT copyright FROM ui WHERE (ui_id) IS (?);", (self.ui_id,))

    @copyright.setter
    def _set_copyright(self, value):
        self.db_set("UPDATE ui SET copyright=? WHERE (ui_id) IS (?);", (self.ui_id,), value)

    @GObject.Property(type=str)
    def authors(self):
        return self.db_get("SELECT authors FROM ui WHERE (ui_id) IS (?);", (self.ui_id,))

    @authors.setter
    def _set_authors(self, value):
        self.db_set("UPDATE ui SET authors=? WHERE (ui_id) IS (?);", (self.ui_id,), value)

    @GObject.Property(type=str)
    def license_id(self):
        return self.db_get("SELECT license_id FROM ui WHERE (ui_id) IS (?);", (self.ui_id,))

    @license_id.setter
    def _set_license_id(self, value):
        self.db_set("UPDATE ui SET license_id=? WHERE (ui_id) IS (?);", (self.ui_id,), value)

    @GObject.Property(type=str)
    def translation_domain(self):
        return self.db_get("SELECT translation_domain FROM ui WHERE (ui_id) IS (?);", (self.ui_id,))

    @translation_domain.setter
    def _set_translation_domain(self, value):
        self.db_set("UPDATE ui SET translation_domain=? WHERE (ui_id) IS (?);", (self.ui_id,), value)

    @GObject.Property(type=str)
    def comment(self):
        return self.db_get("SELECT comment FROM ui WHERE (ui_id) IS (?);", (self.ui_id,))

    @comment.setter
    def _set_comment(self, value):
        self.db_set("UPDATE ui SET comment=? WHERE (ui_id) IS (?);", (self.ui_id,), value)

    @GObject.Property(type=str)
    def custom_fragment(self):
        return self.db_get("SELECT custom_fragment FROM ui WHERE (ui_id) IS (?);", (self.ui_id,))

    @custom_fragment.setter
    def _set_custom_fragment(self, value):
        self.db_set("UPDATE ui SET custom_fragment=? WHERE (ui_id) IS (?);", (self.ui_id,), value)


class CmbBaseCSS(CmbBaseFileMonitor):
    __gtype_name__ = "CmbBaseCSS"

    css_id = GObject.Property(type=int, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)

    def __init__(self, **kwargs):
        super().__init__(**kwargs)

    @classmethod
    def from_row(cls, project, css_id, filename, css, priority, is_global):
        return cls(project=project, css_id=css_id)

    @GObject.Property(type=str)
    def filename(self):
        return self.db_get("SELECT filename FROM css WHERE (css_id) IS (?);", (self.css_id,))

    @filename.setter
    def _set_filename(self, value):
        self.db_set("UPDATE css SET filename=? WHERE (css_id) IS (?);", (self.css_id,), value)

    @GObject.Property(type=str)
    def css(self):
        return self.db_get("SELECT css FROM css WHERE (css_id) IS (?);", (self.css_id,))

    @css.setter
    def _set_css(self, value):
        self.db_set("UPDATE css SET css=? WHERE (css_id) IS (?);", (self.css_id,), value)

    @GObject.Property(type=int)
    def priority(self):
        return self.db_get("SELECT priority FROM css WHERE (css_id) IS (?);", (self.css_id,))

    @priority.setter
    def _set_priority(self, value):
        self.db_set("UPDATE css SET priority=? WHERE (css_id) IS (?);", (self.css_id,), value)

    @GObject.Property(type=bool, default=False)
    def is_global(self):
        return self.db_get("SELECT is_global FROM css WHERE (css_id) IS (?);", (self.css_id,))

    @is_global.setter
    def _set_is_global(self, value):
        self.db_set("UPDATE css SET is_global=? WHERE (css_id) IS (?);", (self.css_id,), value)


class CmbBaseGResource(CmbBaseFileMonitor):
    __gtype_name__ = "CmbBaseGResource"

    gresource_id = GObject.Property(type=int, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    resource_type = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)

    def __init__(self, **kwargs):
        super().__init__(**kwargs)

    @classmethod
    def from_row(
        cls,
        project,
        gresource_id,
        resource_type,
        parent_id,
        position,
        gresources_filename,
        gresource_prefix,
        file_filename,
        file_compressed,
        file_preprocess,
        file_alias,
    ):
        return cls(project=project, gresource_id=gresource_id)

    @GObject.Property(type=int)
    def parent_id(self):
        return self.db_get("SELECT parent_id FROM gresource WHERE (gresource_id) IS (?);", (self.gresource_id,))

    @parent_id.setter
    def _set_parent_id(self, value):
        self.db_set("UPDATE gresource SET parent_id=? WHERE (gresource_id) IS (?);", (self.gresource_id,), value)

    @GObject.Property(type=int)
    def position(self):
        return self.db_get("SELECT position FROM gresource WHERE (gresource_id) IS (?);", (self.gresource_id,))

    @position.setter
    def _set_position(self, value):
        self.db_set("UPDATE gresource SET position=? WHERE (gresource_id) IS (?);", (self.gresource_id,), value)

    @GObject.Property(type=str)
    def gresources_filename(self):
        return self.db_get("SELECT gresources_filename FROM gresource WHERE (gresource_id) IS (?);", (self.gresource_id,))

    @gresources_filename.setter
    def _set_gresources_filename(self, value):
        self.db_set("UPDATE gresource SET gresources_filename=? WHERE (gresource_id) IS (?);", (self.gresource_id,), value)

    @GObject.Property(type=str)
    def gresource_prefix(self):
        return self.db_get("SELECT gresource_prefix FROM gresource WHERE (gresource_id) IS (?);", (self.gresource_id,))

    @gresource_prefix.setter
    def _set_gresource_prefix(self, value):
        self.db_set("UPDATE gresource SET gresource_prefix=? WHERE (gresource_id) IS (?);", (self.gresource_id,), value)

    @GObject.Property(type=str)
    def file_filename(self):
        return self.db_get("SELECT file_filename FROM gresource WHERE (gresource_id) IS (?);", (self.gresource_id,))

    @file_filename.setter
    def _set_file_filename(self, value):
        self.db_set("UPDATE gresource SET file_filename=? WHERE (gresource_id) IS (?);", (self.gresource_id,), value)

    @GObject.Property(type=bool, default=False)
    def file_compressed(self):
        return self.db_get("SELECT file_compressed FROM gresource WHERE (gresource_id) IS (?);", (self.gresource_id,))

    @file_compressed.setter
    def _set_file_compressed(self, value):
        self.db_set("UPDATE gresource SET file_compressed=? WHERE (gresource_id) IS (?);", (self.gresource_id,), value)

    @GObject.Property(type=str)
    def file_preprocess(self):
        return self.db_get("SELECT file_preprocess FROM gresource WHERE (gresource_id) IS (?);", (self.gresource_id,))

    @file_preprocess.setter
    def _set_file_preprocess(self, value):
        self.db_set("UPDATE gresource SET file_preprocess=? WHERE (gresource_id) IS (?);", (self.gresource_id,), value)

    @GObject.Property(type=str)
    def file_alias(self):
        return self.db_get("SELECT file_alias FROM gresource WHERE (gresource_id) IS (?);", (self.gresource_id,))

    @file_alias.setter
    def _set_file_alias(self, value):
        self.db_set("UPDATE gresource SET file_alias=? WHERE (gresource_id) IS (?);", (self.gresource_id,), value)


class CmbBaseProperty(CmbBase):
    __gtype_name__ = "CmbBaseProperty"

    ui_id = GObject.Property(type=int, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    object_id = GObject.Property(type=int, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    owner_id = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    property_id = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)

    def __init__(self, **kwargs):
        super().__init__(**kwargs)

    @classmethod
    def from_row(
        cls,
        project,
        ui_id,
        object_id,
        owner_id,
        property_id,
        value,
        translatable,
        comment,
        translation_context,
        translation_comments,
        inline_object_id,
        bind_source_id,
        bind_owner_id,
        bind_property_id,
        bind_flags,
        binding_expression_id,
        binding_expression_object_id,
    ):
        return cls(project=project, ui_id=ui_id, object_id=object_id, owner_id=owner_id, property_id=property_id)

    @GObject.Property(type=str)
    def value(self):
        return self.db_get(
            "SELECT value FROM object_property WHERE (ui_id, object_id, owner_id, property_id) IS (?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.property_id,
            ),
        )

    @value.setter
    def _set_value(self, value):
        self.db_set(
            "UPDATE object_property SET value=? WHERE (ui_id, object_id, owner_id, property_id) IS (?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.property_id,
            ),
            value,
        )

    @GObject.Property(type=bool, default=False)
    def translatable(self):
        return self.db_get(
            "SELECT translatable FROM object_property WHERE (ui_id, object_id, owner_id, property_id) IS (?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.property_id,
            ),
        )

    @translatable.setter
    def _set_translatable(self, value):
        self.db_set(
            "UPDATE object_property SET translatable=? WHERE (ui_id, object_id, owner_id, property_id) IS (?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.property_id,
            ),
            value,
        )

    @GObject.Property(type=str)
    def comment(self):
        return self.db_get(
            "SELECT comment FROM object_property WHERE (ui_id, object_id, owner_id, property_id) IS (?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.property_id,
            ),
        )

    @comment.setter
    def _set_comment(self, value):
        self.db_set(
            "UPDATE object_property SET comment=? WHERE (ui_id, object_id, owner_id, property_id) IS (?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.property_id,
            ),
            value,
        )

    @GObject.Property(type=str)
    def translation_context(self):
        return self.db_get(
            "SELECT translation_context FROM object_property WHERE (ui_id, object_id, owner_id, property_id) IS (?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.property_id,
            ),
        )

    @translation_context.setter
    def _set_translation_context(self, value):
        self.db_set(
            "UPDATE object_property SET translation_context=? WHERE (ui_id, object_id, owner_id, property_id) IS (?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.property_id,
            ),
            value,
        )

    @GObject.Property(type=str)
    def translation_comments(self):
        return self.db_get(
            "SELECT translation_comments FROM object_property WHERE (ui_id, object_id, owner_id, property_id) IS (?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.property_id,
            ),
        )

    @translation_comments.setter
    def _set_translation_comments(self, value):
        self.db_set(
            "UPDATE object_property SET translation_comments=? WHERE (ui_id, object_id, owner_id, property_id) IS (?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.property_id,
            ),
            value,
        )

    @GObject.Property(type=int)
    def inline_object_id(self):
        return self.db_get(
            "SELECT inline_object_id FROM object_property WHERE (ui_id, object_id, owner_id, property_id) IS (?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.property_id,
            ),
        )

    @inline_object_id.setter
    def _set_inline_object_id(self, value):
        self.db_set(
            "UPDATE object_property SET inline_object_id=? WHERE (ui_id, object_id, owner_id, property_id) IS (?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.property_id,
            ),
            value,
        )

    @GObject.Property(type=int)
    def bind_source_id(self):
        return self.db_get(
            "SELECT bind_source_id FROM object_property WHERE (ui_id, object_id, owner_id, property_id) IS (?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.property_id,
            ),
        )

    @bind_source_id.setter
    def _set_bind_source_id(self, value):
        self.db_set(
            "UPDATE object_property SET bind_source_id=? WHERE (ui_id, object_id, owner_id, property_id) IS (?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.property_id,
            ),
            value,
        )

    @GObject.Property(type=str)
    def bind_owner_id(self):
        return self.db_get(
            "SELECT bind_owner_id FROM object_property WHERE (ui_id, object_id, owner_id, property_id) IS (?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.property_id,
            ),
        )

    @bind_owner_id.setter
    def _set_bind_owner_id(self, value):
        self.db_set(
            "UPDATE object_property SET bind_owner_id=? WHERE (ui_id, object_id, owner_id, property_id) IS (?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.property_id,
            ),
            value,
        )

    @GObject.Property(type=str)
    def bind_property_id(self):
        return self.db_get(
            "SELECT bind_property_id FROM object_property WHERE (ui_id, object_id, owner_id, property_id) IS (?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.property_id,
            ),
        )

    @bind_property_id.setter
    def _set_bind_property_id(self, value):
        self.db_set(
            "UPDATE object_property SET bind_property_id=? WHERE (ui_id, object_id, owner_id, property_id) IS (?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.property_id,
            ),
            value,
        )

    @GObject.Property(type=str)
    def bind_flags(self):
        return self.db_get(
            "SELECT bind_flags FROM object_property WHERE (ui_id, object_id, owner_id, property_id) IS (?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.property_id,
            ),
        )

    @bind_flags.setter
    def _set_bind_flags(self, value):
        self.db_set(
            "UPDATE object_property SET bind_flags=? WHERE (ui_id, object_id, owner_id, property_id) IS (?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.property_id,
            ),
            value,
        )

    @GObject.Property(type=int)
    def binding_expression_id(self):
        return self.db_get(
            "SELECT binding_expression_id FROM object_property WHERE (ui_id, object_id, owner_id, property_id) IS (?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.property_id,
            ),
        )

    @binding_expression_id.setter
    def _set_binding_expression_id(self, value):
        self.db_set(
            "UPDATE object_property SET binding_expression_id=? WHERE (ui_id, object_id, owner_id, property_id) IS (?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.property_id,
            ),
            value,
        )

    @GObject.Property(type=int)
    def binding_expression_object_id(self):
        return self.db_get(
            "SELECT binding_expression_object_id FROM object_property WHERE (ui_id, object_id, owner_id, property_id) IS (?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.property_id,
            ),
        )

    @binding_expression_object_id.setter
    def _set_binding_expression_object_id(self, value):
        self.db_set(
            "UPDATE object_property SET binding_expression_object_id=? WHERE (ui_id, object_id, owner_id, property_id) IS (?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.property_id,
            ),
            value,
        )


class CmbBaseLayoutProperty(CmbBase):
    __gtype_name__ = "CmbBaseLayoutProperty"

    ui_id = GObject.Property(type=int, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    object_id = GObject.Property(type=int, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    child_id = GObject.Property(type=int, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    owner_id = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    property_id = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)

    def __init__(self, **kwargs):
        super().__init__(**kwargs)

    @classmethod
    def from_row(
        cls,
        project,
        ui_id,
        object_id,
        child_id,
        owner_id,
        property_id,
        value,
        translatable,
        comment,
        translation_context,
        translation_comments,
    ):
        return cls(
            project=project, ui_id=ui_id, object_id=object_id, child_id=child_id, owner_id=owner_id, property_id=property_id
        )

    @GObject.Property(type=str)
    def value(self):
        return self.db_get(
            "SELECT value FROM object_layout_property WHERE (ui_id, object_id, child_id, owner_id, property_id) IS (?, ?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.child_id,
                self.owner_id,
                self.property_id,
            ),
        )

    @value.setter
    def _set_value(self, value):
        self.db_set(
            "UPDATE object_layout_property SET value=? WHERE (ui_id, object_id, child_id, owner_id, property_id) IS (?, ?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.child_id,
                self.owner_id,
                self.property_id,
            ),
            value,
        )

    @GObject.Property(type=bool, default=False)
    def translatable(self):
        return self.db_get(
            "SELECT translatable FROM object_layout_property WHERE (ui_id, object_id, child_id, owner_id, property_id) IS (?, ?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.child_id,
                self.owner_id,
                self.property_id,
            ),
        )

    @translatable.setter
    def _set_translatable(self, value):
        self.db_set(
            "UPDATE object_layout_property SET translatable=? WHERE (ui_id, object_id, child_id, owner_id, property_id) IS (?, ?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.child_id,
                self.owner_id,
                self.property_id,
            ),
            value,
        )

    @GObject.Property(type=str)
    def comment(self):
        return self.db_get(
            "SELECT comment FROM object_layout_property WHERE (ui_id, object_id, child_id, owner_id, property_id) IS (?, ?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.child_id,
                self.owner_id,
                self.property_id,
            ),
        )

    @comment.setter
    def _set_comment(self, value):
        self.db_set(
            "UPDATE object_layout_property SET comment=? WHERE (ui_id, object_id, child_id, owner_id, property_id) IS (?, ?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.child_id,
                self.owner_id,
                self.property_id,
            ),
            value,
        )

    @GObject.Property(type=str)
    def translation_context(self):
        return self.db_get(
            "SELECT translation_context FROM object_layout_property WHERE (ui_id, object_id, child_id, owner_id, property_id) IS (?, ?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.child_id,
                self.owner_id,
                self.property_id,
            ),
        )

    @translation_context.setter
    def _set_translation_context(self, value):
        self.db_set(
            "UPDATE object_layout_property SET translation_context=? WHERE (ui_id, object_id, child_id, owner_id, property_id) IS (?, ?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.child_id,
                self.owner_id,
                self.property_id,
            ),
            value,
        )

    @GObject.Property(type=str)
    def translation_comments(self):
        return self.db_get(
            "SELECT translation_comments FROM object_layout_property WHERE (ui_id, object_id, child_id, owner_id, property_id) IS (?, ?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.child_id,
                self.owner_id,
                self.property_id,
            ),
        )

    @translation_comments.setter
    def _set_translation_comments(self, value):
        self.db_set(
            "UPDATE object_layout_property SET translation_comments=? WHERE (ui_id, object_id, child_id, owner_id, property_id) IS (?, ?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.child_id,
                self.owner_id,
                self.property_id,
            ),
            value,
        )


class CmbSignal(CmbBase):
    __gtype_name__ = "CmbSignal"

    signal_pk = GObject.Property(type=int, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)

    def __init__(self, **kwargs):
        super().__init__(**kwargs)

    @classmethod
    def from_row(
        cls, project, signal_pk, ui_id, object_id, owner_id, signal_id, handler, detail, user_data, swap, after, comment
    ):
        return cls(project=project, signal_pk=signal_pk)

    @GObject.Property(type=int)
    def ui_id(self):
        return self.db_get("SELECT ui_id FROM object_signal WHERE (signal_pk) IS (?);", (self.signal_pk,))

    @ui_id.setter
    def _set_ui_id(self, value):
        self.db_set("UPDATE object_signal SET ui_id=? WHERE (signal_pk) IS (?);", (self.signal_pk,), value)

    @GObject.Property(type=int)
    def object_id(self):
        return self.db_get("SELECT object_id FROM object_signal WHERE (signal_pk) IS (?);", (self.signal_pk,))

    @object_id.setter
    def _set_object_id(self, value):
        self.db_set("UPDATE object_signal SET object_id=? WHERE (signal_pk) IS (?);", (self.signal_pk,), value)

    @GObject.Property(type=str)
    def owner_id(self):
        return self.db_get("SELECT owner_id FROM object_signal WHERE (signal_pk) IS (?);", (self.signal_pk,))

    @owner_id.setter
    def _set_owner_id(self, value):
        self.db_set("UPDATE object_signal SET owner_id=? WHERE (signal_pk) IS (?);", (self.signal_pk,), value)

    @GObject.Property(type=str)
    def signal_id(self):
        return self.db_get("SELECT signal_id FROM object_signal WHERE (signal_pk) IS (?);", (self.signal_pk,))

    @signal_id.setter
    def _set_signal_id(self, value):
        self.db_set("UPDATE object_signal SET signal_id=? WHERE (signal_pk) IS (?);", (self.signal_pk,), value)

    @GObject.Property(type=str)
    def handler(self):
        return self.db_get("SELECT handler FROM object_signal WHERE (signal_pk) IS (?);", (self.signal_pk,))

    @handler.setter
    def _set_handler(self, value):
        self.db_set("UPDATE object_signal SET handler=? WHERE (signal_pk) IS (?);", (self.signal_pk,), value)

    @GObject.Property(type=str)
    def detail(self):
        return self.db_get("SELECT detail FROM object_signal WHERE (signal_pk) IS (?);", (self.signal_pk,))

    @detail.setter
    def _set_detail(self, value):
        self.db_set("UPDATE object_signal SET detail=? WHERE (signal_pk) IS (?);", (self.signal_pk,), value)

    @GObject.Property(type=int)
    def user_data(self):
        return self.db_get("SELECT user_data FROM object_signal WHERE (signal_pk) IS (?);", (self.signal_pk,))

    @user_data.setter
    def _set_user_data(self, value):
        self.db_set("UPDATE object_signal SET user_data=? WHERE (signal_pk) IS (?);", (self.signal_pk,), value)

    @GObject.Property(type=bool, default=False)
    def swap(self):
        return self.db_get("SELECT swap FROM object_signal WHERE (signal_pk) IS (?);", (self.signal_pk,))

    @swap.setter
    def _set_swap(self, value):
        self.db_set("UPDATE object_signal SET swap=? WHERE (signal_pk) IS (?);", (self.signal_pk,), value)

    @GObject.Property(type=bool, default=False)
    def after(self):
        return self.db_get("SELECT after FROM object_signal WHERE (signal_pk) IS (?);", (self.signal_pk,))

    @after.setter
    def _set_after(self, value):
        self.db_set("UPDATE object_signal SET after=? WHERE (signal_pk) IS (?);", (self.signal_pk,), value)

    @GObject.Property(type=str)
    def comment(self):
        return self.db_get("SELECT comment FROM object_signal WHERE (signal_pk) IS (?);", (self.signal_pk,))

    @comment.setter
    def _set_comment(self, value):
        self.db_set("UPDATE object_signal SET comment=? WHERE (signal_pk) IS (?);", (self.signal_pk,), value)


class CmbBaseObject(CmbBase):
    __gtype_name__ = "CmbBaseObject"

    ui_id = GObject.Property(type=int, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    object_id = GObject.Property(type=int, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)

    def __init__(self, **kwargs):
        super().__init__(**kwargs)

    @classmethod
    def from_row(
        cls,
        project,
        ui_id,
        object_id,
        type_id,
        name,
        parent_id,
        internal,
        type,
        comment,
        position,
        custom_fragment,
        custom_child_fragment,
    ):
        return cls(project=project, ui_id=ui_id, object_id=object_id)

    @GObject.Property(type=str)
    def type_id(self):
        return self.db_get(
            "SELECT type_id FROM object WHERE (ui_id, object_id) IS (?, ?);",
            (
                self.ui_id,
                self.object_id,
            ),
        )

    @type_id.setter
    def _set_type_id(self, value):
        self.db_set(
            "UPDATE object SET type_id=? WHERE (ui_id, object_id) IS (?, ?);",
            (
                self.ui_id,
                self.object_id,
            ),
            value,
        )

    @GObject.Property(type=str)
    def name(self):
        return self.db_get(
            "SELECT name FROM object WHERE (ui_id, object_id) IS (?, ?);",
            (
                self.ui_id,
                self.object_id,
            ),
        )

    @name.setter
    def _set_name(self, value):
        self.db_set(
            "UPDATE object SET name=? WHERE (ui_id, object_id) IS (?, ?);",
            (
                self.ui_id,
                self.object_id,
            ),
            value,
        )

    @GObject.Property(type=int)
    def parent_id(self):
        return self.db_get(
            "SELECT parent_id FROM object WHERE (ui_id, object_id) IS (?, ?);",
            (
                self.ui_id,
                self.object_id,
            ),
        )

    @parent_id.setter
    def _set_parent_id(self, value):
        self.db_set(
            "UPDATE object SET parent_id=? WHERE (ui_id, object_id) IS (?, ?);",
            (
                self.ui_id,
                self.object_id,
            ),
            value,
        )

    @GObject.Property(type=str)
    def internal(self):
        return self.db_get(
            "SELECT internal FROM object WHERE (ui_id, object_id) IS (?, ?);",
            (
                self.ui_id,
                self.object_id,
            ),
        )

    @internal.setter
    def _set_internal(self, value):
        self.db_set(
            "UPDATE object SET internal=? WHERE (ui_id, object_id) IS (?, ?);",
            (
                self.ui_id,
                self.object_id,
            ),
            value,
        )

    @GObject.Property(type=str)
    def type(self):
        return self.db_get(
            "SELECT type FROM object WHERE (ui_id, object_id) IS (?, ?);",
            (
                self.ui_id,
                self.object_id,
            ),
        )

    @type.setter
    def _set_type(self, value):
        self.db_set(
            "UPDATE object SET type=? WHERE (ui_id, object_id) IS (?, ?);",
            (
                self.ui_id,
                self.object_id,
            ),
            value,
        )

    @GObject.Property(type=str)
    def comment(self):
        return self.db_get(
            "SELECT comment FROM object WHERE (ui_id, object_id) IS (?, ?);",
            (
                self.ui_id,
                self.object_id,
            ),
        )

    @comment.setter
    def _set_comment(self, value):
        self.db_set(
            "UPDATE object SET comment=? WHERE (ui_id, object_id) IS (?, ?);",
            (
                self.ui_id,
                self.object_id,
            ),
            value,
        )

    @GObject.Property(type=int)
    def position(self):
        return self.db_get(
            "SELECT position FROM object WHERE (ui_id, object_id) IS (?, ?);",
            (
                self.ui_id,
                self.object_id,
            ),
        )

    @position.setter
    def _set_position(self, value):
        self.db_set(
            "UPDATE object SET position=? WHERE (ui_id, object_id) IS (?, ?);",
            (
                self.ui_id,
                self.object_id,
            ),
            value,
        )

    @GObject.Property(type=str)
    def custom_fragment(self):
        return self.db_get(
            "SELECT custom_fragment FROM object WHERE (ui_id, object_id) IS (?, ?);",
            (
                self.ui_id,
                self.object_id,
            ),
        )

    @custom_fragment.setter
    def _set_custom_fragment(self, value):
        self.db_set(
            "UPDATE object SET custom_fragment=? WHERE (ui_id, object_id) IS (?, ?);",
            (
                self.ui_id,
                self.object_id,
            ),
            value,
        )

    @GObject.Property(type=str)
    def custom_child_fragment(self):
        return self.db_get(
            "SELECT custom_child_fragment FROM object WHERE (ui_id, object_id) IS (?, ?);",
            (
                self.ui_id,
                self.object_id,
            ),
        )

    @custom_child_fragment.setter
    def _set_custom_child_fragment(self, value):
        self.db_set(
            "UPDATE object SET custom_child_fragment=? WHERE (ui_id, object_id) IS (?, ?);",
            (
                self.ui_id,
                self.object_id,
            ),
            value,
        )


class CmbBaseObjectData(CmbBase):
    __gtype_name__ = "CmbBaseObjectData"

    ui_id = GObject.Property(type=int, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    object_id = GObject.Property(type=int, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    owner_id = GObject.Property(type=str, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    data_id = GObject.Property(type=int, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)
    id = GObject.Property(type=int, flags=GObject.ParamFlags.READWRITE | GObject.ParamFlags.CONSTRUCT_ONLY)

    def __init__(self, **kwargs):
        super().__init__(**kwargs)

    @classmethod
    def from_row(
        cls,
        project,
        ui_id,
        object_id,
        owner_id,
        data_id,
        id,
        value,
        parent_id,
        comment,
        translatable,
        translation_context,
        translation_comments,
    ):
        return cls(project=project, ui_id=ui_id, object_id=object_id, owner_id=owner_id, data_id=data_id, id=id)

    @GObject.Property(type=str)
    def value(self):
        return self.db_get(
            "SELECT value FROM object_data WHERE (ui_id, object_id, owner_id, data_id, id) IS (?, ?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.data_id,
                self.id,
            ),
        )

    @value.setter
    def _set_value(self, value):
        self.db_set(
            "UPDATE object_data SET value=? WHERE (ui_id, object_id, owner_id, data_id, id) IS (?, ?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.data_id,
                self.id,
            ),
            value,
        )

    @GObject.Property(type=int)
    def parent_id(self):
        return self.db_get(
            "SELECT parent_id FROM object_data WHERE (ui_id, object_id, owner_id, data_id, id) IS (?, ?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.data_id,
                self.id,
            ),
        )

    @parent_id.setter
    def _set_parent_id(self, value):
        self.db_set(
            "UPDATE object_data SET parent_id=? WHERE (ui_id, object_id, owner_id, data_id, id) IS (?, ?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.data_id,
                self.id,
            ),
            value,
        )

    @GObject.Property(type=str)
    def comment(self):
        return self.db_get(
            "SELECT comment FROM object_data WHERE (ui_id, object_id, owner_id, data_id, id) IS (?, ?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.data_id,
                self.id,
            ),
        )

    @comment.setter
    def _set_comment(self, value):
        self.db_set(
            "UPDATE object_data SET comment=? WHERE (ui_id, object_id, owner_id, data_id, id) IS (?, ?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.data_id,
                self.id,
            ),
            value,
        )

    @GObject.Property(type=bool, default=False)
    def translatable(self):
        return self.db_get(
            "SELECT translatable FROM object_data WHERE (ui_id, object_id, owner_id, data_id, id) IS (?, ?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.data_id,
                self.id,
            ),
        )

    @translatable.setter
    def _set_translatable(self, value):
        self.db_set(
            "UPDATE object_data SET translatable=? WHERE (ui_id, object_id, owner_id, data_id, id) IS (?, ?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.data_id,
                self.id,
            ),
            value,
        )

    @GObject.Property(type=str)
    def translation_context(self):
        return self.db_get(
            "SELECT translation_context FROM object_data WHERE (ui_id, object_id, owner_id, data_id, id) IS (?, ?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.data_id,
                self.id,
            ),
        )

    @translation_context.setter
    def _set_translation_context(self, value):
        self.db_set(
            "UPDATE object_data SET translation_context=? WHERE (ui_id, object_id, owner_id, data_id, id) IS (?, ?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.data_id,
                self.id,
            ),
            value,
        )

    @GObject.Property(type=str)
    def translation_comments(self):
        return self.db_get(
            "SELECT translation_comments FROM object_data WHERE (ui_id, object_id, owner_id, data_id, id) IS (?, ?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.data_id,
                self.id,
            ),
        )

    @translation_comments.setter
    def _set_translation_comments(self, value):
        self.db_set(
            "UPDATE object_data SET translation_comments=? WHERE (ui_id, object_id, owner_id, data_id, id) IS (?, ?, ?, ?, ?);",
            (
                self.ui_id,
                self.object_id,
                self.owner_id,
                self.data_id,
                self.id,
            ),
            value,
        )
