// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file arraysTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen.
 */

#include "arraysTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>

#include "arrays.hpp"

#include "helpers/basic_inner_types.hpp"

using namespace eprosima::fastdds::dds::xtypes;

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayShort_type_identifier(
        TypeIdentifierPair& type_ids_ArrayShort)
{

    ReturnCode_t return_code_ArrayShort {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayShort =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayShort", type_ids_ArrayShort);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayShort)
    {
        StructTypeFlag struct_flags_ArrayShort = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayShort = "ArrayShort";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayShort;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayShort;
        CompleteTypeDetail detail_ArrayShort = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayShort, ann_custom_ArrayShort, type_name_ArrayShort.to_string());
        CompleteStructHeader header_ArrayShort;
        header_ArrayShort = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayShort);
        CompleteStructMemberSeq member_seq_ArrayShort;
        {
            TypeIdentifierPair type_ids_var_array_short;
            ReturnCode_t return_code_var_array_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_10", type_ids_var_array_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_short)
            {
                return_code_var_array_short =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_array_short);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_short)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_short, element_identifier_anonymous_array_int16_t_10_ec))};
                if (!element_identifier_anonymous_array_int16_t_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_short.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_10 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_10, element_flags_anonymous_array_int16_t_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_10", type_ids_var_array_short))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_short = 0x00000000;
            bool common_var_array_short_ec {false};
            CommonStructMember common_var_array_short {TypeObjectUtils::build_common_struct_member(member_id_var_array_short, member_flags_var_array_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_short, common_var_array_short_ec))};
            if (!common_var_array_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_short = "var_array_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_short;
            ann_custom_ArrayShort.reset();
            CompleteMemberDetail detail_var_array_short = TypeObjectUtils::build_complete_member_detail(name_var_array_short, member_ann_builtin_var_array_short, ann_custom_ArrayShort);
            CompleteStructMember member_var_array_short = TypeObjectUtils::build_complete_struct_member(common_var_array_short, detail_var_array_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayShort, member_var_array_short);
        }
        CompleteStructType struct_type_ArrayShort = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayShort, header_ArrayShort, member_seq_ArrayShort);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayShort, type_name_ArrayShort.to_string(), type_ids_ArrayShort))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayShort already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayUShort_type_identifier(
        TypeIdentifierPair& type_ids_ArrayUShort)
{

    ReturnCode_t return_code_ArrayUShort {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayUShort =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayUShort", type_ids_ArrayUShort);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayUShort)
    {
        StructTypeFlag struct_flags_ArrayUShort = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayUShort = "ArrayUShort";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayUShort;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayUShort;
        CompleteTypeDetail detail_ArrayUShort = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayUShort, ann_custom_ArrayUShort, type_name_ArrayUShort.to_string());
        CompleteStructHeader header_ArrayUShort;
        header_ArrayUShort = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayUShort);
        CompleteStructMemberSeq member_seq_ArrayUShort;
        {
            TypeIdentifierPair type_ids_var_array_ushort;
            ReturnCode_t return_code_var_array_ushort {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_ushort =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint16_t_10", type_ids_var_array_ushort);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_ushort)
            {
                return_code_var_array_ushort =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_array_ushort);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_ushort)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint16_t_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint16_t_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_ushort, element_identifier_anonymous_array_uint16_t_10_ec))};
                if (!element_identifier_anonymous_array_uint16_t_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint16_t_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_ushort.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint16_t_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint16_t_10 = 0;
                PlainCollectionHeader header_anonymous_array_uint16_t_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint16_t_10, element_flags_anonymous_array_uint16_t_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint16_t_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint16_t_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint16_t_10", type_ids_var_array_ushort))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint16_t_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_ushort = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_ushort = 0x00000000;
            bool common_var_array_ushort_ec {false};
            CommonStructMember common_var_array_ushort {TypeObjectUtils::build_common_struct_member(member_id_var_array_ushort, member_flags_var_array_ushort, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_ushort, common_var_array_ushort_ec))};
            if (!common_var_array_ushort_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_ushort member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_ushort = "var_array_ushort";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_ushort;
            ann_custom_ArrayUShort.reset();
            CompleteMemberDetail detail_var_array_ushort = TypeObjectUtils::build_complete_member_detail(name_var_array_ushort, member_ann_builtin_var_array_ushort, ann_custom_ArrayUShort);
            CompleteStructMember member_var_array_ushort = TypeObjectUtils::build_complete_struct_member(common_var_array_ushort, detail_var_array_ushort);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayUShort, member_var_array_ushort);
        }
        CompleteStructType struct_type_ArrayUShort = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayUShort, header_ArrayUShort, member_seq_ArrayUShort);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayUShort, type_name_ArrayUShort.to_string(), type_ids_ArrayUShort))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayUShort already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayLong_type_identifier(
        TypeIdentifierPair& type_ids_ArrayLong)
{

    ReturnCode_t return_code_ArrayLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayLong", type_ids_ArrayLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayLong)
    {
        StructTypeFlag struct_flags_ArrayLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayLong = "ArrayLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayLong;
        CompleteTypeDetail detail_ArrayLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayLong, ann_custom_ArrayLong, type_name_ArrayLong.to_string());
        CompleteStructHeader header_ArrayLong;
        header_ArrayLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayLong);
        CompleteStructMemberSeq member_seq_ArrayLong;
        {
            TypeIdentifierPair type_ids_var_array_long;
            ReturnCode_t return_code_var_array_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int32_t_10", type_ids_var_array_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_long)
            {
                return_code_var_array_long =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_array_long);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_long)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int32_t_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int32_t_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_long, element_identifier_anonymous_array_int32_t_10_ec))};
                if (!element_identifier_anonymous_array_int32_t_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int32_t_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_long.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int32_t_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int32_t_10 = 0;
                PlainCollectionHeader header_anonymous_array_int32_t_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int32_t_10, element_flags_anonymous_array_int32_t_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int32_t_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int32_t_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int32_t_10", type_ids_var_array_long))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int32_t_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_long = 0x00000000;
            bool common_var_array_long_ec {false};
            CommonStructMember common_var_array_long {TypeObjectUtils::build_common_struct_member(member_id_var_array_long, member_flags_var_array_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_long, common_var_array_long_ec))};
            if (!common_var_array_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_long = "var_array_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_long;
            ann_custom_ArrayLong.reset();
            CompleteMemberDetail detail_var_array_long = TypeObjectUtils::build_complete_member_detail(name_var_array_long, member_ann_builtin_var_array_long, ann_custom_ArrayLong);
            CompleteStructMember member_var_array_long = TypeObjectUtils::build_complete_struct_member(common_var_array_long, detail_var_array_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayLong, member_var_array_long);
        }
        CompleteStructType struct_type_ArrayLong = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayLong, header_ArrayLong, member_seq_ArrayLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayLong, type_name_ArrayLong.to_string(), type_ids_ArrayLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayULong_type_identifier(
        TypeIdentifierPair& type_ids_ArrayULong)
{

    ReturnCode_t return_code_ArrayULong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayULong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayULong", type_ids_ArrayULong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayULong)
    {
        StructTypeFlag struct_flags_ArrayULong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayULong = "ArrayULong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayULong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayULong;
        CompleteTypeDetail detail_ArrayULong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayULong, ann_custom_ArrayULong, type_name_ArrayULong.to_string());
        CompleteStructHeader header_ArrayULong;
        header_ArrayULong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayULong);
        CompleteStructMemberSeq member_seq_ArrayULong;
        {
            TypeIdentifierPair type_ids_var_array_ulong;
            ReturnCode_t return_code_var_array_ulong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_ulong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint32_t_10", type_ids_var_array_ulong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_ulong)
            {
                return_code_var_array_ulong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_var_array_ulong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_ulong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint32_t_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint32_t_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_ulong, element_identifier_anonymous_array_uint32_t_10_ec))};
                if (!element_identifier_anonymous_array_uint32_t_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint32_t_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_ulong.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint32_t_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint32_t_10 = 0;
                PlainCollectionHeader header_anonymous_array_uint32_t_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint32_t_10, element_flags_anonymous_array_uint32_t_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint32_t_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint32_t_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint32_t_10", type_ids_var_array_ulong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint32_t_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_ulong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_ulong = 0x00000000;
            bool common_var_array_ulong_ec {false};
            CommonStructMember common_var_array_ulong {TypeObjectUtils::build_common_struct_member(member_id_var_array_ulong, member_flags_var_array_ulong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_ulong, common_var_array_ulong_ec))};
            if (!common_var_array_ulong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_ulong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_ulong = "var_array_ulong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_ulong;
            ann_custom_ArrayULong.reset();
            CompleteMemberDetail detail_var_array_ulong = TypeObjectUtils::build_complete_member_detail(name_var_array_ulong, member_ann_builtin_var_array_ulong, ann_custom_ArrayULong);
            CompleteStructMember member_var_array_ulong = TypeObjectUtils::build_complete_struct_member(common_var_array_ulong, detail_var_array_ulong);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayULong, member_var_array_ulong);
        }
        CompleteStructType struct_type_ArrayULong = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayULong, header_ArrayULong, member_seq_ArrayULong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayULong, type_name_ArrayULong.to_string(), type_ids_ArrayULong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayULong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayLongLong_type_identifier(
        TypeIdentifierPair& type_ids_ArrayLongLong)
{

    ReturnCode_t return_code_ArrayLongLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayLongLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayLongLong", type_ids_ArrayLongLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayLongLong)
    {
        StructTypeFlag struct_flags_ArrayLongLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayLongLong = "ArrayLongLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayLongLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayLongLong;
        CompleteTypeDetail detail_ArrayLongLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayLongLong, ann_custom_ArrayLongLong, type_name_ArrayLongLong.to_string());
        CompleteStructHeader header_ArrayLongLong;
        header_ArrayLongLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayLongLong);
        CompleteStructMemberSeq member_seq_ArrayLongLong;
        {
            TypeIdentifierPair type_ids_var_array_longlong;
            ReturnCode_t return_code_var_array_longlong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_longlong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int64_t_10", type_ids_var_array_longlong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_longlong)
            {
                return_code_var_array_longlong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int64_t", type_ids_var_array_longlong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_longlong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int64_t_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int64_t_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_longlong, element_identifier_anonymous_array_int64_t_10_ec))};
                if (!element_identifier_anonymous_array_int64_t_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int64_t_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_longlong.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int64_t_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int64_t_10 = 0;
                PlainCollectionHeader header_anonymous_array_int64_t_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int64_t_10, element_flags_anonymous_array_int64_t_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int64_t_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int64_t_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int64_t_10", type_ids_var_array_longlong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int64_t_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_longlong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_longlong = 0x00000000;
            bool common_var_array_longlong_ec {false};
            CommonStructMember common_var_array_longlong {TypeObjectUtils::build_common_struct_member(member_id_var_array_longlong, member_flags_var_array_longlong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_longlong, common_var_array_longlong_ec))};
            if (!common_var_array_longlong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_longlong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_longlong = "var_array_longlong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_longlong;
            ann_custom_ArrayLongLong.reset();
            CompleteMemberDetail detail_var_array_longlong = TypeObjectUtils::build_complete_member_detail(name_var_array_longlong, member_ann_builtin_var_array_longlong, ann_custom_ArrayLongLong);
            CompleteStructMember member_var_array_longlong = TypeObjectUtils::build_complete_struct_member(common_var_array_longlong, detail_var_array_longlong);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayLongLong, member_var_array_longlong);
        }
        CompleteStructType struct_type_ArrayLongLong = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayLongLong, header_ArrayLongLong, member_seq_ArrayLongLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayLongLong, type_name_ArrayLongLong.to_string(), type_ids_ArrayLongLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayLongLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayULongLong_type_identifier(
        TypeIdentifierPair& type_ids_ArrayULongLong)
{

    ReturnCode_t return_code_ArrayULongLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayULongLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayULongLong", type_ids_ArrayULongLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayULongLong)
    {
        StructTypeFlag struct_flags_ArrayULongLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayULongLong = "ArrayULongLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayULongLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayULongLong;
        CompleteTypeDetail detail_ArrayULongLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayULongLong, ann_custom_ArrayULongLong, type_name_ArrayULongLong.to_string());
        CompleteStructHeader header_ArrayULongLong;
        header_ArrayULongLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayULongLong);
        CompleteStructMemberSeq member_seq_ArrayULongLong;
        {
            TypeIdentifierPair type_ids_var_array_ulonglong;
            ReturnCode_t return_code_var_array_ulonglong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_ulonglong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint64_t_10", type_ids_var_array_ulonglong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_ulonglong)
            {
                return_code_var_array_ulonglong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint64_t", type_ids_var_array_ulonglong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_ulonglong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint64_t_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint64_t_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_ulonglong, element_identifier_anonymous_array_uint64_t_10_ec))};
                if (!element_identifier_anonymous_array_uint64_t_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint64_t_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_ulonglong.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint64_t_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint64_t_10 = 0;
                PlainCollectionHeader header_anonymous_array_uint64_t_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint64_t_10, element_flags_anonymous_array_uint64_t_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint64_t_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint64_t_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint64_t_10", type_ids_var_array_ulonglong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint64_t_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_ulonglong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_ulonglong = 0x00000000;
            bool common_var_array_ulonglong_ec {false};
            CommonStructMember common_var_array_ulonglong {TypeObjectUtils::build_common_struct_member(member_id_var_array_ulonglong, member_flags_var_array_ulonglong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_ulonglong, common_var_array_ulonglong_ec))};
            if (!common_var_array_ulonglong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_ulonglong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_ulonglong = "var_array_ulonglong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_ulonglong;
            ann_custom_ArrayULongLong.reset();
            CompleteMemberDetail detail_var_array_ulonglong = TypeObjectUtils::build_complete_member_detail(name_var_array_ulonglong, member_ann_builtin_var_array_ulonglong, ann_custom_ArrayULongLong);
            CompleteStructMember member_var_array_ulonglong = TypeObjectUtils::build_complete_struct_member(common_var_array_ulonglong, detail_var_array_ulonglong);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayULongLong, member_var_array_ulonglong);
        }
        CompleteStructType struct_type_ArrayULongLong = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayULongLong, header_ArrayULongLong, member_seq_ArrayULongLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayULongLong, type_name_ArrayULongLong.to_string(), type_ids_ArrayULongLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayULongLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayFloat_type_identifier(
        TypeIdentifierPair& type_ids_ArrayFloat)
{

    ReturnCode_t return_code_ArrayFloat {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayFloat =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayFloat", type_ids_ArrayFloat);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayFloat)
    {
        StructTypeFlag struct_flags_ArrayFloat = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayFloat = "ArrayFloat";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayFloat;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayFloat;
        CompleteTypeDetail detail_ArrayFloat = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayFloat, ann_custom_ArrayFloat, type_name_ArrayFloat.to_string());
        CompleteStructHeader header_ArrayFloat;
        header_ArrayFloat = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayFloat);
        CompleteStructMemberSeq member_seq_ArrayFloat;
        {
            TypeIdentifierPair type_ids_var_array_float;
            ReturnCode_t return_code_var_array_float {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_float =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_float_10", type_ids_var_array_float);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_float)
            {
                return_code_var_array_float =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_float", type_ids_var_array_float);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_float)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_float_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_float_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_float, element_identifier_anonymous_array_float_10_ec))};
                if (!element_identifier_anonymous_array_float_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_float_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_float.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_float_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_float_10 = 0;
                PlainCollectionHeader header_anonymous_array_float_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_float_10, element_flags_anonymous_array_float_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_float_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_float_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_float_10", type_ids_var_array_float))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_float_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_float = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_float = 0x00000000;
            bool common_var_array_float_ec {false};
            CommonStructMember common_var_array_float {TypeObjectUtils::build_common_struct_member(member_id_var_array_float, member_flags_var_array_float, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_float, common_var_array_float_ec))};
            if (!common_var_array_float_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_float member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_float = "var_array_float";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_float;
            ann_custom_ArrayFloat.reset();
            CompleteMemberDetail detail_var_array_float = TypeObjectUtils::build_complete_member_detail(name_var_array_float, member_ann_builtin_var_array_float, ann_custom_ArrayFloat);
            CompleteStructMember member_var_array_float = TypeObjectUtils::build_complete_struct_member(common_var_array_float, detail_var_array_float);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayFloat, member_var_array_float);
        }
        CompleteStructType struct_type_ArrayFloat = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayFloat, header_ArrayFloat, member_seq_ArrayFloat);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayFloat, type_name_ArrayFloat.to_string(), type_ids_ArrayFloat))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayFloat already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayDouble_type_identifier(
        TypeIdentifierPair& type_ids_ArrayDouble)
{

    ReturnCode_t return_code_ArrayDouble {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayDouble =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayDouble", type_ids_ArrayDouble);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayDouble)
    {
        StructTypeFlag struct_flags_ArrayDouble = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayDouble = "ArrayDouble";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayDouble;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayDouble;
        CompleteTypeDetail detail_ArrayDouble = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayDouble, ann_custom_ArrayDouble, type_name_ArrayDouble.to_string());
        CompleteStructHeader header_ArrayDouble;
        header_ArrayDouble = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayDouble);
        CompleteStructMemberSeq member_seq_ArrayDouble;
        {
            TypeIdentifierPair type_ids_var_array_double;
            ReturnCode_t return_code_var_array_double {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_double =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_double_10", type_ids_var_array_double);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_double)
            {
                return_code_var_array_double =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_double", type_ids_var_array_double);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_double)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_double_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_double_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_double, element_identifier_anonymous_array_double_10_ec))};
                if (!element_identifier_anonymous_array_double_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_double_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_double.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_double_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_double_10 = 0;
                PlainCollectionHeader header_anonymous_array_double_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_double_10, element_flags_anonymous_array_double_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_double_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_double_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_double_10", type_ids_var_array_double))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_double_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_double = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_double = 0x00000000;
            bool common_var_array_double_ec {false};
            CommonStructMember common_var_array_double {TypeObjectUtils::build_common_struct_member(member_id_var_array_double, member_flags_var_array_double, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_double, common_var_array_double_ec))};
            if (!common_var_array_double_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_double member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_double = "var_array_double";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_double;
            ann_custom_ArrayDouble.reset();
            CompleteMemberDetail detail_var_array_double = TypeObjectUtils::build_complete_member_detail(name_var_array_double, member_ann_builtin_var_array_double, ann_custom_ArrayDouble);
            CompleteStructMember member_var_array_double = TypeObjectUtils::build_complete_struct_member(common_var_array_double, detail_var_array_double);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayDouble, member_var_array_double);
        }
        CompleteStructType struct_type_ArrayDouble = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayDouble, header_ArrayDouble, member_seq_ArrayDouble);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayDouble, type_name_ArrayDouble.to_string(), type_ids_ArrayDouble))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayDouble already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayLongDouble_type_identifier(
        TypeIdentifierPair& type_ids_ArrayLongDouble)
{

    ReturnCode_t return_code_ArrayLongDouble {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayLongDouble =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayLongDouble", type_ids_ArrayLongDouble);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayLongDouble)
    {
        StructTypeFlag struct_flags_ArrayLongDouble = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayLongDouble = "ArrayLongDouble";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayLongDouble;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayLongDouble;
        CompleteTypeDetail detail_ArrayLongDouble = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayLongDouble, ann_custom_ArrayLongDouble, type_name_ArrayLongDouble.to_string());
        CompleteStructHeader header_ArrayLongDouble;
        header_ArrayLongDouble = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayLongDouble);
        CompleteStructMemberSeq member_seq_ArrayLongDouble;
        {
            TypeIdentifierPair type_ids_var_array_longdouble;
            ReturnCode_t return_code_var_array_longdouble {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_longdouble =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_longdouble_10", type_ids_var_array_longdouble);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_longdouble)
            {
                return_code_var_array_longdouble =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_longdouble", type_ids_var_array_longdouble);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_longdouble)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_longdouble_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_longdouble_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_longdouble, element_identifier_anonymous_array_longdouble_10_ec))};
                if (!element_identifier_anonymous_array_longdouble_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_longdouble_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_longdouble.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_longdouble_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_longdouble_10 = 0;
                PlainCollectionHeader header_anonymous_array_longdouble_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_longdouble_10, element_flags_anonymous_array_longdouble_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_longdouble_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_longdouble_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_longdouble_10", type_ids_var_array_longdouble))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_longdouble_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_longdouble = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_longdouble = 0x00000000;
            bool common_var_array_longdouble_ec {false};
            CommonStructMember common_var_array_longdouble {TypeObjectUtils::build_common_struct_member(member_id_var_array_longdouble, member_flags_var_array_longdouble, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_longdouble, common_var_array_longdouble_ec))};
            if (!common_var_array_longdouble_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_longdouble member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_longdouble = "var_array_longdouble";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_longdouble;
            ann_custom_ArrayLongDouble.reset();
            CompleteMemberDetail detail_var_array_longdouble = TypeObjectUtils::build_complete_member_detail(name_var_array_longdouble, member_ann_builtin_var_array_longdouble, ann_custom_ArrayLongDouble);
            CompleteStructMember member_var_array_longdouble = TypeObjectUtils::build_complete_struct_member(common_var_array_longdouble, detail_var_array_longdouble);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayLongDouble, member_var_array_longdouble);
        }
        CompleteStructType struct_type_ArrayLongDouble = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayLongDouble, header_ArrayLongDouble, member_seq_ArrayLongDouble);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayLongDouble, type_name_ArrayLongDouble.to_string(), type_ids_ArrayLongDouble))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayLongDouble already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayBoolean_type_identifier(
        TypeIdentifierPair& type_ids_ArrayBoolean)
{

    ReturnCode_t return_code_ArrayBoolean {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayBoolean =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayBoolean", type_ids_ArrayBoolean);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayBoolean)
    {
        StructTypeFlag struct_flags_ArrayBoolean = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayBoolean = "ArrayBoolean";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayBoolean;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayBoolean;
        CompleteTypeDetail detail_ArrayBoolean = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayBoolean, ann_custom_ArrayBoolean, type_name_ArrayBoolean.to_string());
        CompleteStructHeader header_ArrayBoolean;
        header_ArrayBoolean = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayBoolean);
        CompleteStructMemberSeq member_seq_ArrayBoolean;
        {
            TypeIdentifierPair type_ids_var_array_boolean;
            ReturnCode_t return_code_var_array_boolean {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_boolean =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_bool_10", type_ids_var_array_boolean);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_boolean)
            {
                return_code_var_array_boolean =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_bool", type_ids_var_array_boolean);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_boolean)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_bool_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_bool_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_boolean, element_identifier_anonymous_array_bool_10_ec))};
                if (!element_identifier_anonymous_array_bool_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_bool_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_boolean.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_bool_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_bool_10 = 0;
                PlainCollectionHeader header_anonymous_array_bool_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_bool_10, element_flags_anonymous_array_bool_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_bool_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_bool_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_bool_10", type_ids_var_array_boolean))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_bool_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_boolean = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_boolean = 0x00000000;
            bool common_var_array_boolean_ec {false};
            CommonStructMember common_var_array_boolean {TypeObjectUtils::build_common_struct_member(member_id_var_array_boolean, member_flags_var_array_boolean, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_boolean, common_var_array_boolean_ec))};
            if (!common_var_array_boolean_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_boolean member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_boolean = "var_array_boolean";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_boolean;
            ann_custom_ArrayBoolean.reset();
            CompleteMemberDetail detail_var_array_boolean = TypeObjectUtils::build_complete_member_detail(name_var_array_boolean, member_ann_builtin_var_array_boolean, ann_custom_ArrayBoolean);
            CompleteStructMember member_var_array_boolean = TypeObjectUtils::build_complete_struct_member(common_var_array_boolean, detail_var_array_boolean);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayBoolean, member_var_array_boolean);
        }
        CompleteStructType struct_type_ArrayBoolean = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayBoolean, header_ArrayBoolean, member_seq_ArrayBoolean);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayBoolean, type_name_ArrayBoolean.to_string(), type_ids_ArrayBoolean))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayBoolean already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayOctet_type_identifier(
        TypeIdentifierPair& type_ids_ArrayOctet)
{

    ReturnCode_t return_code_ArrayOctet {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayOctet =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayOctet", type_ids_ArrayOctet);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayOctet)
    {
        StructTypeFlag struct_flags_ArrayOctet = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayOctet = "ArrayOctet";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayOctet;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayOctet;
        CompleteTypeDetail detail_ArrayOctet = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayOctet, ann_custom_ArrayOctet, type_name_ArrayOctet.to_string());
        CompleteStructHeader header_ArrayOctet;
        header_ArrayOctet = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayOctet);
        CompleteStructMemberSeq member_seq_ArrayOctet;
        {
            TypeIdentifierPair type_ids_var_array_octet;
            ReturnCode_t return_code_var_array_octet {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_octet =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_byte_10", type_ids_var_array_octet);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_octet)
            {
                return_code_var_array_octet =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_byte", type_ids_var_array_octet);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_octet)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_byte_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_byte_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_octet, element_identifier_anonymous_array_byte_10_ec))};
                if (!element_identifier_anonymous_array_byte_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_byte_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_octet.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_byte_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_byte_10 = 0;
                PlainCollectionHeader header_anonymous_array_byte_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_byte_10, element_flags_anonymous_array_byte_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_byte_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_byte_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_byte_10", type_ids_var_array_octet))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_byte_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_octet = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_octet = 0x00000000;
            bool common_var_array_octet_ec {false};
            CommonStructMember common_var_array_octet {TypeObjectUtils::build_common_struct_member(member_id_var_array_octet, member_flags_var_array_octet, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_octet, common_var_array_octet_ec))};
            if (!common_var_array_octet_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_octet member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_octet = "var_array_octet";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_octet;
            ann_custom_ArrayOctet.reset();
            CompleteMemberDetail detail_var_array_octet = TypeObjectUtils::build_complete_member_detail(name_var_array_octet, member_ann_builtin_var_array_octet, ann_custom_ArrayOctet);
            CompleteStructMember member_var_array_octet = TypeObjectUtils::build_complete_struct_member(common_var_array_octet, detail_var_array_octet);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayOctet, member_var_array_octet);
        }
        CompleteStructType struct_type_ArrayOctet = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayOctet, header_ArrayOctet, member_seq_ArrayOctet);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayOctet, type_name_ArrayOctet.to_string(), type_ids_ArrayOctet))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayOctet already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayUInt8_type_identifier(
        TypeIdentifierPair& type_ids_ArrayUInt8)
{

    ReturnCode_t return_code_ArrayUInt8 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayUInt8 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayUInt8", type_ids_ArrayUInt8);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayUInt8)
    {
        StructTypeFlag struct_flags_ArrayUInt8 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayUInt8 = "ArrayUInt8";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayUInt8;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayUInt8;
        CompleteTypeDetail detail_ArrayUInt8 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayUInt8, ann_custom_ArrayUInt8, type_name_ArrayUInt8.to_string());
        CompleteStructHeader header_ArrayUInt8;
        header_ArrayUInt8 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayUInt8);
        CompleteStructMemberSeq member_seq_ArrayUInt8;
        {
            TypeIdentifierPair type_ids_var_array_uint8;
            ReturnCode_t return_code_var_array_uint8 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_uint8 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint8_t_10", type_ids_var_array_uint8);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_uint8)
            {
                return_code_var_array_uint8 =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint8_t", type_ids_var_array_uint8);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_uint8)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint8_t_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint8_t_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_uint8, element_identifier_anonymous_array_uint8_t_10_ec))};
                if (!element_identifier_anonymous_array_uint8_t_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint8_t_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_uint8.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint8_t_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint8_t_10 = 0;
                PlainCollectionHeader header_anonymous_array_uint8_t_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint8_t_10, element_flags_anonymous_array_uint8_t_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint8_t_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint8_t_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint8_t_10", type_ids_var_array_uint8))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint8_t_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_uint8 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_uint8 = 0x00000000;
            bool common_var_array_uint8_ec {false};
            CommonStructMember common_var_array_uint8 {TypeObjectUtils::build_common_struct_member(member_id_var_array_uint8, member_flags_var_array_uint8, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_uint8, common_var_array_uint8_ec))};
            if (!common_var_array_uint8_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_uint8 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_uint8 = "var_array_uint8";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_uint8;
            ann_custom_ArrayUInt8.reset();
            CompleteMemberDetail detail_var_array_uint8 = TypeObjectUtils::build_complete_member_detail(name_var_array_uint8, member_ann_builtin_var_array_uint8, ann_custom_ArrayUInt8);
            CompleteStructMember member_var_array_uint8 = TypeObjectUtils::build_complete_struct_member(common_var_array_uint8, detail_var_array_uint8);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayUInt8, member_var_array_uint8);
        }
        CompleteStructType struct_type_ArrayUInt8 = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayUInt8, header_ArrayUInt8, member_seq_ArrayUInt8);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayUInt8, type_name_ArrayUInt8.to_string(), type_ids_ArrayUInt8))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayUInt8 already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayChar_type_identifier(
        TypeIdentifierPair& type_ids_ArrayChar)
{

    ReturnCode_t return_code_ArrayChar {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayChar =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayChar", type_ids_ArrayChar);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayChar)
    {
        StructTypeFlag struct_flags_ArrayChar = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayChar = "ArrayChar";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayChar;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayChar;
        CompleteTypeDetail detail_ArrayChar = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayChar, ann_custom_ArrayChar, type_name_ArrayChar.to_string());
        CompleteStructHeader header_ArrayChar;
        header_ArrayChar = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayChar);
        CompleteStructMemberSeq member_seq_ArrayChar;
        {
            TypeIdentifierPair type_ids_var_array_char;
            ReturnCode_t return_code_var_array_char {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_char =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_char_10", type_ids_var_array_char);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_char)
            {
                return_code_var_array_char =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_char", type_ids_var_array_char);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_char)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_char_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_char_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_char, element_identifier_anonymous_array_char_10_ec))};
                if (!element_identifier_anonymous_array_char_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_char_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_char.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_char_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_char_10 = 0;
                PlainCollectionHeader header_anonymous_array_char_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_char_10, element_flags_anonymous_array_char_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_char_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_char_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_char_10", type_ids_var_array_char))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_char_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_char = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_char = 0x00000000;
            bool common_var_array_char_ec {false};
            CommonStructMember common_var_array_char {TypeObjectUtils::build_common_struct_member(member_id_var_array_char, member_flags_var_array_char, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_char, common_var_array_char_ec))};
            if (!common_var_array_char_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_char member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_char = "var_array_char";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_char;
            ann_custom_ArrayChar.reset();
            CompleteMemberDetail detail_var_array_char = TypeObjectUtils::build_complete_member_detail(name_var_array_char, member_ann_builtin_var_array_char, ann_custom_ArrayChar);
            CompleteStructMember member_var_array_char = TypeObjectUtils::build_complete_struct_member(common_var_array_char, detail_var_array_char);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayChar, member_var_array_char);
        }
        CompleteStructType struct_type_ArrayChar = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayChar, header_ArrayChar, member_seq_ArrayChar);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayChar, type_name_ArrayChar.to_string(), type_ids_ArrayChar))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayChar already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayWChar_type_identifier(
        TypeIdentifierPair& type_ids_ArrayWChar)
{

    ReturnCode_t return_code_ArrayWChar {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayWChar =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayWChar", type_ids_ArrayWChar);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayWChar)
    {
        StructTypeFlag struct_flags_ArrayWChar = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayWChar = "ArrayWChar";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayWChar;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayWChar;
        CompleteTypeDetail detail_ArrayWChar = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayWChar, ann_custom_ArrayWChar, type_name_ArrayWChar.to_string());
        CompleteStructHeader header_ArrayWChar;
        header_ArrayWChar = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayWChar);
        CompleteStructMemberSeq member_seq_ArrayWChar;
        {
            TypeIdentifierPair type_ids_var_array_wchar;
            ReturnCode_t return_code_var_array_wchar {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_wchar =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_wchar_t_10", type_ids_var_array_wchar);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_wchar)
            {
                return_code_var_array_wchar =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_wchar_t", type_ids_var_array_wchar);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_wchar)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_wchar_t_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_wchar_t_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_wchar, element_identifier_anonymous_array_wchar_t_10_ec))};
                if (!element_identifier_anonymous_array_wchar_t_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_wchar_t_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_wchar.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_wchar_t_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_wchar_t_10 = 0;
                PlainCollectionHeader header_anonymous_array_wchar_t_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_wchar_t_10, element_flags_anonymous_array_wchar_t_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_wchar_t_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_wchar_t_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_wchar_t_10", type_ids_var_array_wchar))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_wchar_t_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_wchar = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_wchar = 0x00000000;
            bool common_var_array_wchar_ec {false};
            CommonStructMember common_var_array_wchar {TypeObjectUtils::build_common_struct_member(member_id_var_array_wchar, member_flags_var_array_wchar, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_wchar, common_var_array_wchar_ec))};
            if (!common_var_array_wchar_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_wchar member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_wchar = "var_array_wchar";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_wchar;
            ann_custom_ArrayWChar.reset();
            CompleteMemberDetail detail_var_array_wchar = TypeObjectUtils::build_complete_member_detail(name_var_array_wchar, member_ann_builtin_var_array_wchar, ann_custom_ArrayWChar);
            CompleteStructMember member_var_array_wchar = TypeObjectUtils::build_complete_struct_member(common_var_array_wchar, detail_var_array_wchar);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayWChar, member_var_array_wchar);
        }
        CompleteStructType struct_type_ArrayWChar = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayWChar, header_ArrayWChar, member_seq_ArrayWChar);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayWChar, type_name_ArrayWChar.to_string(), type_ids_ArrayWChar))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayWChar already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayString_type_identifier(
        TypeIdentifierPair& type_ids_ArrayString)
{

    ReturnCode_t return_code_ArrayString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayString", type_ids_ArrayString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayString)
    {
        StructTypeFlag struct_flags_ArrayString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayString = "ArrayString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayString;
        CompleteTypeDetail detail_ArrayString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayString, ann_custom_ArrayString, type_name_ArrayString.to_string());
        CompleteStructHeader header_ArrayString;
        header_ArrayString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayString);
        CompleteStructMemberSeq member_seq_ArrayString;
        {
            TypeIdentifierPair type_ids_var_array_string;
            ReturnCode_t return_code_var_array_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_anonymous_string_unbounded_10", type_ids_var_array_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_string)
            {
                return_code_var_array_string =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_string_unbounded", type_ids_var_array_string);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_string)
                {
                    {
                        SBound bound = 0;
                        StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                                "anonymous_string_unbounded", type_ids_var_array_string))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_array_anonymous_string_unbounded_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_anonymous_string_unbounded_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_string, element_identifier_anonymous_array_anonymous_string_unbounded_10_ec))};
                if (!element_identifier_anonymous_array_anonymous_string_unbounded_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_anonymous_string_unbounded_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_string.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_anonymous_string_unbounded_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_anonymous_string_unbounded_10 = 0;
                PlainCollectionHeader header_anonymous_array_anonymous_string_unbounded_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_anonymous_string_unbounded_10, element_flags_anonymous_array_anonymous_string_unbounded_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_anonymous_string_unbounded_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_anonymous_string_unbounded_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_anonymous_string_unbounded_10", type_ids_var_array_string))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_anonymous_string_unbounded_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_string = 0x00000000;
            bool common_var_array_string_ec {false};
            CommonStructMember common_var_array_string {TypeObjectUtils::build_common_struct_member(member_id_var_array_string, member_flags_var_array_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_string, common_var_array_string_ec))};
            if (!common_var_array_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_string = "var_array_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_string;
            ann_custom_ArrayString.reset();
            CompleteMemberDetail detail_var_array_string = TypeObjectUtils::build_complete_member_detail(name_var_array_string, member_ann_builtin_var_array_string, ann_custom_ArrayString);
            CompleteStructMember member_var_array_string = TypeObjectUtils::build_complete_struct_member(common_var_array_string, detail_var_array_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayString, member_var_array_string);
        }
        CompleteStructType struct_type_ArrayString = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayString, header_ArrayString, member_seq_ArrayString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayString, type_name_ArrayString.to_string(), type_ids_ArrayString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayWString_type_identifier(
        TypeIdentifierPair& type_ids_ArrayWString)
{

    ReturnCode_t return_code_ArrayWString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayWString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayWString", type_ids_ArrayWString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayWString)
    {
        StructTypeFlag struct_flags_ArrayWString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayWString = "ArrayWString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayWString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayWString;
        CompleteTypeDetail detail_ArrayWString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayWString, ann_custom_ArrayWString, type_name_ArrayWString.to_string());
        CompleteStructHeader header_ArrayWString;
        header_ArrayWString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayWString);
        CompleteStructMemberSeq member_seq_ArrayWString;
        {
            TypeIdentifierPair type_ids_var_array_wstring;
            ReturnCode_t return_code_var_array_wstring {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_wstring =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_anonymous_wstring_unbounded_10", type_ids_var_array_wstring);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_wstring)
            {
                return_code_var_array_wstring =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_wstring_unbounded", type_ids_var_array_wstring);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_wstring)
                {
                    {
                        SBound bound = 0;
                        StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                                "anonymous_wstring_unbounded", type_ids_var_array_wstring, true))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_wstring_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_array_anonymous_wstring_unbounded_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_anonymous_wstring_unbounded_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_wstring, element_identifier_anonymous_array_anonymous_wstring_unbounded_10_ec))};
                if (!element_identifier_anonymous_array_anonymous_wstring_unbounded_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_anonymous_wstring_unbounded_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_wstring.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_anonymous_wstring_unbounded_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_anonymous_wstring_unbounded_10 = 0;
                PlainCollectionHeader header_anonymous_array_anonymous_wstring_unbounded_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_anonymous_wstring_unbounded_10, element_flags_anonymous_array_anonymous_wstring_unbounded_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_anonymous_wstring_unbounded_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_anonymous_wstring_unbounded_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_anonymous_wstring_unbounded_10", type_ids_var_array_wstring))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_anonymous_wstring_unbounded_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_wstring = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_wstring = 0x00000000;
            bool common_var_array_wstring_ec {false};
            CommonStructMember common_var_array_wstring {TypeObjectUtils::build_common_struct_member(member_id_var_array_wstring, member_flags_var_array_wstring, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_wstring, common_var_array_wstring_ec))};
            if (!common_var_array_wstring_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_wstring member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_wstring = "var_array_wstring";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_wstring;
            ann_custom_ArrayWString.reset();
            CompleteMemberDetail detail_var_array_wstring = TypeObjectUtils::build_complete_member_detail(name_var_array_wstring, member_ann_builtin_var_array_wstring, ann_custom_ArrayWString);
            CompleteStructMember member_var_array_wstring = TypeObjectUtils::build_complete_struct_member(common_var_array_wstring, detail_var_array_wstring);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayWString, member_var_array_wstring);
        }
        CompleteStructType struct_type_ArrayWString = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayWString, header_ArrayWString, member_seq_ArrayWString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayWString, type_name_ArrayWString.to_string(), type_ids_ArrayWString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayWString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayBoundedString_type_identifier(
        TypeIdentifierPair& type_ids_ArrayBoundedString)
{

    ReturnCode_t return_code_ArrayBoundedString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayBoundedString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayBoundedString", type_ids_ArrayBoundedString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayBoundedString)
    {
        StructTypeFlag struct_flags_ArrayBoundedString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayBoundedString = "ArrayBoundedString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayBoundedString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayBoundedString;
        CompleteTypeDetail detail_ArrayBoundedString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayBoundedString, ann_custom_ArrayBoundedString, type_name_ArrayBoundedString.to_string());
        CompleteStructHeader header_ArrayBoundedString;
        header_ArrayBoundedString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayBoundedString);
        CompleteStructMemberSeq member_seq_ArrayBoundedString;
        {
            TypeIdentifierPair type_ids_var_array_bounded_string;
            ReturnCode_t return_code_var_array_bounded_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_bounded_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_anonymous_string_10_10", type_ids_var_array_bounded_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bounded_string)
            {
                return_code_var_array_bounded_string =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_bounded_string_helper", type_ids_var_array_bounded_string);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bounded_string)
                {
                ::register_Inner_alias_bounded_string_helper_type_identifier(type_ids_var_array_bounded_string);
                }
                bool element_identifier_anonymous_array_anonymous_string_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_anonymous_string_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bounded_string, element_identifier_anonymous_array_anonymous_string_10_10_ec))};
                if (!element_identifier_anonymous_array_anonymous_string_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_anonymous_string_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_bounded_string.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_anonymous_string_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_anonymous_string_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_anonymous_string_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_anonymous_string_10_10, element_flags_anonymous_array_anonymous_string_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_anonymous_string_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_anonymous_string_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_anonymous_string_10_10", type_ids_var_array_bounded_string))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_anonymous_string_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_bounded_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_bounded_string = 0x00000000;
            bool common_var_array_bounded_string_ec {false};
            CommonStructMember common_var_array_bounded_string {TypeObjectUtils::build_common_struct_member(member_id_var_array_bounded_string, member_flags_var_array_bounded_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bounded_string, common_var_array_bounded_string_ec))};
            if (!common_var_array_bounded_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_bounded_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_bounded_string = "var_array_bounded_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_bounded_string;
            ann_custom_ArrayBoundedString.reset();
            CompleteMemberDetail detail_var_array_bounded_string = TypeObjectUtils::build_complete_member_detail(name_var_array_bounded_string, member_ann_builtin_var_array_bounded_string, ann_custom_ArrayBoundedString);
            CompleteStructMember member_var_array_bounded_string = TypeObjectUtils::build_complete_struct_member(common_var_array_bounded_string, detail_var_array_bounded_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayBoundedString, member_var_array_bounded_string);
        }
        CompleteStructType struct_type_ArrayBoundedString = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayBoundedString, header_ArrayBoundedString, member_seq_ArrayBoundedString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayBoundedString, type_name_ArrayBoundedString.to_string(), type_ids_ArrayBoundedString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayBoundedString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayBoundedWString_type_identifier(
        TypeIdentifierPair& type_ids_ArrayBoundedWString)
{

    ReturnCode_t return_code_ArrayBoundedWString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayBoundedWString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayBoundedWString", type_ids_ArrayBoundedWString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayBoundedWString)
    {
        StructTypeFlag struct_flags_ArrayBoundedWString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayBoundedWString = "ArrayBoundedWString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayBoundedWString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayBoundedWString;
        CompleteTypeDetail detail_ArrayBoundedWString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayBoundedWString, ann_custom_ArrayBoundedWString, type_name_ArrayBoundedWString.to_string());
        CompleteStructHeader header_ArrayBoundedWString;
        header_ArrayBoundedWString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayBoundedWString);
        CompleteStructMemberSeq member_seq_ArrayBoundedWString;
        {
            TypeIdentifierPair type_ids_var_array_bounded_wstring;
            ReturnCode_t return_code_var_array_bounded_wstring {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_bounded_wstring =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_anonymous_wstring_10_10", type_ids_var_array_bounded_wstring);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bounded_wstring)
            {
                return_code_var_array_bounded_wstring =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_bounded_wstring_helper", type_ids_var_array_bounded_wstring);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bounded_wstring)
                {
                ::register_Inner_alias_bounded_wstring_helper_type_identifier(type_ids_var_array_bounded_wstring);
                }
                bool element_identifier_anonymous_array_anonymous_wstring_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_anonymous_wstring_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bounded_wstring, element_identifier_anonymous_array_anonymous_wstring_10_10_ec))};
                if (!element_identifier_anonymous_array_anonymous_wstring_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_anonymous_wstring_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_bounded_wstring.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_anonymous_wstring_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_anonymous_wstring_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_anonymous_wstring_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_anonymous_wstring_10_10, element_flags_anonymous_array_anonymous_wstring_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_anonymous_wstring_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_anonymous_wstring_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_anonymous_wstring_10_10", type_ids_var_array_bounded_wstring))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_anonymous_wstring_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_bounded_wstring = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_bounded_wstring = 0x00000000;
            bool common_var_array_bounded_wstring_ec {false};
            CommonStructMember common_var_array_bounded_wstring {TypeObjectUtils::build_common_struct_member(member_id_var_array_bounded_wstring, member_flags_var_array_bounded_wstring, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bounded_wstring, common_var_array_bounded_wstring_ec))};
            if (!common_var_array_bounded_wstring_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_bounded_wstring member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_bounded_wstring = "var_array_bounded_wstring";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_bounded_wstring;
            ann_custom_ArrayBoundedWString.reset();
            CompleteMemberDetail detail_var_array_bounded_wstring = TypeObjectUtils::build_complete_member_detail(name_var_array_bounded_wstring, member_ann_builtin_var_array_bounded_wstring, ann_custom_ArrayBoundedWString);
            CompleteStructMember member_var_array_bounded_wstring = TypeObjectUtils::build_complete_struct_member(common_var_array_bounded_wstring, detail_var_array_bounded_wstring);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayBoundedWString, member_var_array_bounded_wstring);
        }
        CompleteStructType struct_type_ArrayBoundedWString = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayBoundedWString, header_ArrayBoundedWString, member_seq_ArrayBoundedWString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayBoundedWString, type_name_ArrayBoundedWString.to_string(), type_ids_ArrayBoundedWString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayBoundedWString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayEnum_type_identifier(
        TypeIdentifierPair& type_ids_ArrayEnum)
{

    ReturnCode_t return_code_ArrayEnum {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayEnum =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayEnum", type_ids_ArrayEnum);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayEnum)
    {
        StructTypeFlag struct_flags_ArrayEnum = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayEnum = "ArrayEnum";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayEnum;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayEnum;
        CompleteTypeDetail detail_ArrayEnum = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayEnum, ann_custom_ArrayEnum, type_name_ArrayEnum.to_string());
        CompleteStructHeader header_ArrayEnum;
        header_ArrayEnum = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayEnum);
        CompleteStructMemberSeq member_seq_ArrayEnum;
        {
            TypeIdentifierPair type_ids_var_array_enum;
            ReturnCode_t return_code_var_array_enum {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_enum =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_InnerEnumHelper_10", type_ids_var_array_enum);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_enum)
            {
                return_code_var_array_enum =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerEnumHelper", type_ids_var_array_enum);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_enum)
                {
                ::register_InnerEnumHelper_type_identifier(type_ids_var_array_enum);
                }
                bool element_identifier_anonymous_array_InnerEnumHelper_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_InnerEnumHelper_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_enum, element_identifier_anonymous_array_InnerEnumHelper_10_ec))};
                if (!element_identifier_anonymous_array_InnerEnumHelper_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_InnerEnumHelper_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_enum.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_InnerEnumHelper_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_InnerEnumHelper_10 = 0;
                PlainCollectionHeader header_anonymous_array_InnerEnumHelper_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_InnerEnumHelper_10, element_flags_anonymous_array_InnerEnumHelper_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_InnerEnumHelper_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_InnerEnumHelper_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_InnerEnumHelper_10", type_ids_var_array_enum))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_InnerEnumHelper_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_enum = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_enum = 0x00000000;
            bool common_var_array_enum_ec {false};
            CommonStructMember common_var_array_enum {TypeObjectUtils::build_common_struct_member(member_id_var_array_enum, member_flags_var_array_enum, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_enum, common_var_array_enum_ec))};
            if (!common_var_array_enum_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_enum member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_enum = "var_array_enum";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_enum;
            ann_custom_ArrayEnum.reset();
            CompleteMemberDetail detail_var_array_enum = TypeObjectUtils::build_complete_member_detail(name_var_array_enum, member_ann_builtin_var_array_enum, ann_custom_ArrayEnum);
            CompleteStructMember member_var_array_enum = TypeObjectUtils::build_complete_struct_member(common_var_array_enum, detail_var_array_enum);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayEnum, member_var_array_enum);
        }
        CompleteStructType struct_type_ArrayEnum = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayEnum, header_ArrayEnum, member_seq_ArrayEnum);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayEnum, type_name_ArrayEnum.to_string(), type_ids_ArrayEnum))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayEnum already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayBitMask_type_identifier(
        TypeIdentifierPair& type_ids_ArrayBitMask)
{

    ReturnCode_t return_code_ArrayBitMask {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayBitMask =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayBitMask", type_ids_ArrayBitMask);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayBitMask)
    {
        StructTypeFlag struct_flags_ArrayBitMask = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayBitMask = "ArrayBitMask";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayBitMask;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayBitMask;
        CompleteTypeDetail detail_ArrayBitMask = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayBitMask, ann_custom_ArrayBitMask, type_name_ArrayBitMask.to_string());
        CompleteStructHeader header_ArrayBitMask;
        header_ArrayBitMask = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayBitMask);
        CompleteStructMemberSeq member_seq_ArrayBitMask;
        {
            TypeIdentifierPair type_ids_var_array_bitmask;
            ReturnCode_t return_code_var_array_bitmask {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_bitmask =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_InnerBitMaskHelper_10", type_ids_var_array_bitmask);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bitmask)
            {
                return_code_var_array_bitmask =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerBitMaskHelper", type_ids_var_array_bitmask);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bitmask)
                {
                ::register_InnerBitMaskHelper_type_identifier(type_ids_var_array_bitmask);
                }
                bool element_identifier_anonymous_array_InnerBitMaskHelper_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_InnerBitMaskHelper_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bitmask, element_identifier_anonymous_array_InnerBitMaskHelper_10_ec))};
                if (!element_identifier_anonymous_array_InnerBitMaskHelper_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_InnerBitMaskHelper_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_bitmask.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_InnerBitMaskHelper_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_InnerBitMaskHelper_10 = 0;
                PlainCollectionHeader header_anonymous_array_InnerBitMaskHelper_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_InnerBitMaskHelper_10, element_flags_anonymous_array_InnerBitMaskHelper_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_InnerBitMaskHelper_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_InnerBitMaskHelper_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_InnerBitMaskHelper_10", type_ids_var_array_bitmask))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_InnerBitMaskHelper_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_bitmask = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_bitmask = 0x00000000;
            bool common_var_array_bitmask_ec {false};
            CommonStructMember common_var_array_bitmask {TypeObjectUtils::build_common_struct_member(member_id_var_array_bitmask, member_flags_var_array_bitmask, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bitmask, common_var_array_bitmask_ec))};
            if (!common_var_array_bitmask_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_bitmask member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_bitmask = "var_array_bitmask";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_bitmask;
            ann_custom_ArrayBitMask.reset();
            CompleteMemberDetail detail_var_array_bitmask = TypeObjectUtils::build_complete_member_detail(name_var_array_bitmask, member_ann_builtin_var_array_bitmask, ann_custom_ArrayBitMask);
            CompleteStructMember member_var_array_bitmask = TypeObjectUtils::build_complete_struct_member(common_var_array_bitmask, detail_var_array_bitmask);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayBitMask, member_var_array_bitmask);
        }
        CompleteStructType struct_type_ArrayBitMask = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayBitMask, header_ArrayBitMask, member_seq_ArrayBitMask);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayBitMask, type_name_ArrayBitMask.to_string(), type_ids_ArrayBitMask))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayBitMask already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayAlias_type_identifier(
        TypeIdentifierPair& type_ids_ArrayAlias)
{

    ReturnCode_t return_code_ArrayAlias {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayAlias =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayAlias", type_ids_ArrayAlias);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayAlias)
    {
        StructTypeFlag struct_flags_ArrayAlias = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayAlias = "ArrayAlias";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayAlias;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayAlias;
        CompleteTypeDetail detail_ArrayAlias = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayAlias, ann_custom_ArrayAlias, type_name_ArrayAlias.to_string());
        CompleteStructHeader header_ArrayAlias;
        header_ArrayAlias = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayAlias);
        CompleteStructMemberSeq member_seq_ArrayAlias;
        {
            TypeIdentifierPair type_ids_var_array_alias;
            ReturnCode_t return_code_var_array_alias {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_alias =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_InnerAliasHelper_10", type_ids_var_array_alias);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_alias)
            {
                return_code_var_array_alias =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerAliasHelper", type_ids_var_array_alias);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_alias)
                {
                ::register_InnerAliasHelper_type_identifier(type_ids_var_array_alias);
                }
                bool element_identifier_anonymous_array_InnerAliasHelper_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_InnerAliasHelper_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_alias, element_identifier_anonymous_array_InnerAliasHelper_10_ec))};
                if (!element_identifier_anonymous_array_InnerAliasHelper_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_InnerAliasHelper_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_alias.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_InnerAliasHelper_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_InnerAliasHelper_10 = 0;
                PlainCollectionHeader header_anonymous_array_InnerAliasHelper_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_InnerAliasHelper_10, element_flags_anonymous_array_InnerAliasHelper_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_InnerAliasHelper_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_InnerAliasHelper_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_InnerAliasHelper_10", type_ids_var_array_alias))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_InnerAliasHelper_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_alias = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_alias = 0x00000000;
            bool common_var_array_alias_ec {false};
            CommonStructMember common_var_array_alias {TypeObjectUtils::build_common_struct_member(member_id_var_array_alias, member_flags_var_array_alias, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_alias, common_var_array_alias_ec))};
            if (!common_var_array_alias_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_alias member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_alias = "var_array_alias";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_alias;
            ann_custom_ArrayAlias.reset();
            CompleteMemberDetail detail_var_array_alias = TypeObjectUtils::build_complete_member_detail(name_var_array_alias, member_ann_builtin_var_array_alias, ann_custom_ArrayAlias);
            CompleteStructMember member_var_array_alias = TypeObjectUtils::build_complete_struct_member(common_var_array_alias, detail_var_array_alias);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayAlias, member_var_array_alias);
        }
        CompleteStructType struct_type_ArrayAlias = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayAlias, header_ArrayAlias, member_seq_ArrayAlias);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayAlias, type_name_ArrayAlias.to_string(), type_ids_ArrayAlias))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayAlias already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayShortArray_type_identifier(
        TypeIdentifierPair& type_ids_ArrayShortArray)
{

    ReturnCode_t return_code_ArrayShortArray {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayShortArray =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayShortArray", type_ids_ArrayShortArray);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayShortArray)
    {
        StructTypeFlag struct_flags_ArrayShortArray = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayShortArray = "ArrayShortArray";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayShortArray;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayShortArray;
        CompleteTypeDetail detail_ArrayShortArray = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayShortArray, ann_custom_ArrayShortArray, type_name_ArrayShortArray.to_string());
        CompleteStructHeader header_ArrayShortArray;
        header_ArrayShortArray = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayShortArray);
        CompleteStructMemberSeq member_seq_ArrayShortArray;
        {
            TypeIdentifierPair type_ids_var_array_short_array;
            ReturnCode_t return_code_var_array_short_array {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_short_array =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_10_10", type_ids_var_array_short_array);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_short_array)
            {
                return_code_var_array_short_array =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_array_short_array);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_short_array)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_short_array, element_identifier_anonymous_array_int16_t_10_10_ec))};
                if (!element_identifier_anonymous_array_int16_t_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_short_array.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_10_10, element_flags_anonymous_array_int16_t_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_10_10", type_ids_var_array_short_array))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_short_array = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_short_array = 0x00000000;
            bool common_var_array_short_array_ec {false};
            CommonStructMember common_var_array_short_array {TypeObjectUtils::build_common_struct_member(member_id_var_array_short_array, member_flags_var_array_short_array, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_short_array, common_var_array_short_array_ec))};
            if (!common_var_array_short_array_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_short_array member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_short_array = "var_array_short_array";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_short_array;
            ann_custom_ArrayShortArray.reset();
            CompleteMemberDetail detail_var_array_short_array = TypeObjectUtils::build_complete_member_detail(name_var_array_short_array, member_ann_builtin_var_array_short_array, ann_custom_ArrayShortArray);
            CompleteStructMember member_var_array_short_array = TypeObjectUtils::build_complete_struct_member(common_var_array_short_array, detail_var_array_short_array);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayShortArray, member_var_array_short_array);
        }
        CompleteStructType struct_type_ArrayShortArray = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayShortArray, header_ArrayShortArray, member_seq_ArrayShortArray);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayShortArray, type_name_ArrayShortArray.to_string(), type_ids_ArrayShortArray))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayShortArray already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySequence_type_identifier(
        TypeIdentifierPair& type_ids_ArraySequence)
{

    ReturnCode_t return_code_ArraySequence {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySequence =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySequence", type_ids_ArraySequence);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySequence)
    {
        StructTypeFlag struct_flags_ArraySequence = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySequence = "ArraySequence";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySequence;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySequence;
        CompleteTypeDetail detail_ArraySequence = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySequence, ann_custom_ArraySequence, type_name_ArraySequence.to_string());
        CompleteStructHeader header_ArraySequence;
        header_ArraySequence = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySequence);
        CompleteStructMemberSeq member_seq_ArraySequence;
        {
            TypeIdentifierPair type_ids_var_array_sequence;
            ReturnCode_t return_code_var_array_sequence {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_sequence =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_anonymous_sequence_int32_t_unbounded_10", type_ids_var_array_sequence);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_sequence)
            {
                return_code_var_array_sequence =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_sequence_int32_t_unbounded", type_ids_var_array_sequence);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_sequence)
                {
                    return_code_var_array_sequence =
                        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                        "_int32_t", type_ids_var_array_sequence);

                    if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_sequence)
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                        return;
                    }
                    bool element_identifier_anonymous_sequence_int32_t_unbounded_ec {false};
                    TypeIdentifier* element_identifier_anonymous_sequence_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_sequence, element_identifier_anonymous_sequence_int32_t_unbounded_ec))};
                    if (!element_identifier_anonymous_sequence_int32_t_unbounded_ec)
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                        return;
                    }
                    EquivalenceKind equiv_kind_anonymous_sequence_int32_t_unbounded = EK_COMPLETE;
                    if (TK_NONE == type_ids_var_array_sequence.type_identifier2()._d())
                    {
                        equiv_kind_anonymous_sequence_int32_t_unbounded = EK_BOTH;
                    }
                    CollectionElementFlag element_flags_anonymous_sequence_int32_t_unbounded = 0;
                    PlainCollectionHeader header_anonymous_sequence_int32_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_int32_t_unbounded, element_flags_anonymous_sequence_int32_t_unbounded);
                    {
                        SBound bound = 0;
                        PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_int32_t_unbounded, bound,
                                    eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_int32_t_unbounded));
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_int32_t_unbounded", type_ids_var_array_sequence))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_sequence_int32_t_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_array_anonymous_sequence_int32_t_unbounded_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_anonymous_sequence_int32_t_unbounded_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_sequence, element_identifier_anonymous_array_anonymous_sequence_int32_t_unbounded_10_ec))};
                if (!element_identifier_anonymous_array_anonymous_sequence_int32_t_unbounded_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_anonymous_sequence_int32_t_unbounded_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_sequence.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_anonymous_sequence_int32_t_unbounded_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_anonymous_sequence_int32_t_unbounded_10 = 0;
                PlainCollectionHeader header_anonymous_array_anonymous_sequence_int32_t_unbounded_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_anonymous_sequence_int32_t_unbounded_10, element_flags_anonymous_array_anonymous_sequence_int32_t_unbounded_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_anonymous_sequence_int32_t_unbounded_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_anonymous_sequence_int32_t_unbounded_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_anonymous_sequence_int32_t_unbounded_10", type_ids_var_array_sequence))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_anonymous_sequence_int32_t_unbounded_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_sequence = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_sequence = 0x00000000;
            bool common_var_array_sequence_ec {false};
            CommonStructMember common_var_array_sequence {TypeObjectUtils::build_common_struct_member(member_id_var_array_sequence, member_flags_var_array_sequence, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_sequence, common_var_array_sequence_ec))};
            if (!common_var_array_sequence_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_sequence member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_sequence = "var_array_sequence";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_sequence;
            ann_custom_ArraySequence.reset();
            CompleteMemberDetail detail_var_array_sequence = TypeObjectUtils::build_complete_member_detail(name_var_array_sequence, member_ann_builtin_var_array_sequence, ann_custom_ArraySequence);
            CompleteStructMember member_var_array_sequence = TypeObjectUtils::build_complete_struct_member(common_var_array_sequence, detail_var_array_sequence);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySequence, member_var_array_sequence);
        }
        CompleteStructType struct_type_ArraySequence = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySequence, header_ArraySequence, member_seq_ArraySequence);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySequence, type_name_ArraySequence.to_string(), type_ids_ArraySequence))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySequence already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMap_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMap)
{

    ReturnCode_t return_code_ArrayMap {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMap =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMap", type_ids_ArrayMap);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMap)
    {
        StructTypeFlag struct_flags_ArrayMap = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMap = "ArrayMap";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMap;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMap;
        CompleteTypeDetail detail_ArrayMap = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMap, ann_custom_ArrayMap, type_name_ArrayMap.to_string());
        CompleteStructHeader header_ArrayMap;
        header_ArrayMap = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMap);
        CompleteStructMemberSeq member_seq_ArrayMap;
        {
            TypeIdentifierPair type_ids_var_array_map;
            ReturnCode_t return_code_var_array_map {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_map =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10", type_ids_var_array_map);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_map)
            {
                return_code_var_array_map =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_map_int32_t_int32_t_unbounded", type_ids_var_array_map);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_map)
                {
                    return_code_var_array_map =
                        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                        "_int32_t", type_ids_var_array_map);

                    if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_map)
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                        return;
                    }
                    bool element_identifier_anonymous_map_int32_t_int32_t_unbounded_ec {false};
                    TypeIdentifier* element_identifier_anonymous_map_int32_t_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_map, element_identifier_anonymous_map_int32_t_int32_t_unbounded_ec))};
                    if (!element_identifier_anonymous_map_int32_t_int32_t_unbounded_ec)
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_int32_t_unbounded inconsistent element TypeIdentifier.");
                        return;
                    }
                    return_code_var_array_map =
                        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                        "_int32_t", type_ids_var_array_map);

                    if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_map)
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                        return;
                    }
                    bool key_identifier_anonymous_map_int32_t_int32_t_unbounded_ec {false};
                    TypeIdentifier* key_identifier_anonymous_map_int32_t_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_map, key_identifier_anonymous_map_int32_t_int32_t_unbounded_ec))};
                    if (!key_identifier_anonymous_map_int32_t_int32_t_unbounded_ec)
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_int32_t_unbounded inconsistent key TypeIdentifier.");
                        return;
                    }
                    EquivalenceKind equiv_kind_anonymous_map_int32_t_int32_t_unbounded = EK_BOTH;
                    if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d()) ||
                            (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                            (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                            (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->array_sdefn().header().equiv_kind()) ||
                            (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->array_ldefn().header().equiv_kind()) ||
                            (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_sdefn().header().equiv_kind())) ||
                            (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_ldefn().header().equiv_kind())))
                    {
                        equiv_kind_anonymous_map_int32_t_int32_t_unbounded = EK_COMPLETE;
                    }
                    CollectionElementFlag element_flags_anonymous_map_int32_t_int32_t_unbounded = 0;
                    CollectionElementFlag key_flags_anonymous_map_int32_t_int32_t_unbounded = 0;
                    PlainCollectionHeader header_anonymous_map_int32_t_int32_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_int32_t_unbounded, element_flags_anonymous_map_int32_t_int32_t_unbounded);
                    {
                        SBound bound = 0;
                        PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_int32_t_unbounded, bound,
                                    eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_int32_t_unbounded), key_flags_anonymous_map_int32_t_int32_t_unbounded,
                                    eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_int32_t_unbounded));
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_int32_t_unbounded", type_ids_var_array_map))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_map_int32_t_int32_t_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_map, element_identifier_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10_ec))};
                if (!element_identifier_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_map.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10 = 0;
                PlainCollectionHeader header_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10, element_flags_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10", type_ids_var_array_map))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_map = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_map = 0x00000000;
            bool common_var_array_map_ec {false};
            CommonStructMember common_var_array_map {TypeObjectUtils::build_common_struct_member(member_id_var_array_map, member_flags_var_array_map, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_map, common_var_array_map_ec))};
            if (!common_var_array_map_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_map member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_map = "var_array_map";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_map;
            ann_custom_ArrayMap.reset();
            CompleteMemberDetail detail_var_array_map = TypeObjectUtils::build_complete_member_detail(name_var_array_map, member_ann_builtin_var_array_map, ann_custom_ArrayMap);
            CompleteStructMember member_var_array_map = TypeObjectUtils::build_complete_struct_member(common_var_array_map, detail_var_array_map);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMap, member_var_array_map);
        }
        CompleteStructType struct_type_ArrayMap = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMap, header_ArrayMap, member_seq_ArrayMap);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMap, type_name_ArrayMap.to_string(), type_ids_ArrayMap))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMap already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayUnion_type_identifier(
        TypeIdentifierPair& type_ids_ArrayUnion)
{

    ReturnCode_t return_code_ArrayUnion {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayUnion =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayUnion", type_ids_ArrayUnion);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayUnion)
    {
        StructTypeFlag struct_flags_ArrayUnion = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayUnion = "ArrayUnion";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayUnion;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayUnion;
        CompleteTypeDetail detail_ArrayUnion = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayUnion, ann_custom_ArrayUnion, type_name_ArrayUnion.to_string());
        CompleteStructHeader header_ArrayUnion;
        header_ArrayUnion = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayUnion);
        CompleteStructMemberSeq member_seq_ArrayUnion;
        {
            TypeIdentifierPair type_ids_var_array_union;
            ReturnCode_t return_code_var_array_union {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_union =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_InnerUnionHelper_10", type_ids_var_array_union);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_union)
            {
                return_code_var_array_union =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerUnionHelper", type_ids_var_array_union);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_union)
                {
                ::register_InnerUnionHelper_type_identifier(type_ids_var_array_union);
                }
                bool element_identifier_anonymous_array_InnerUnionHelper_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_InnerUnionHelper_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_union, element_identifier_anonymous_array_InnerUnionHelper_10_ec))};
                if (!element_identifier_anonymous_array_InnerUnionHelper_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_InnerUnionHelper_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_union.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_InnerUnionHelper_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_InnerUnionHelper_10 = 0;
                PlainCollectionHeader header_anonymous_array_InnerUnionHelper_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_InnerUnionHelper_10, element_flags_anonymous_array_InnerUnionHelper_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_InnerUnionHelper_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_InnerUnionHelper_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_InnerUnionHelper_10", type_ids_var_array_union))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_InnerUnionHelper_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_union = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_union = 0x00000000;
            bool common_var_array_union_ec {false};
            CommonStructMember common_var_array_union {TypeObjectUtils::build_common_struct_member(member_id_var_array_union, member_flags_var_array_union, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_union, common_var_array_union_ec))};
            if (!common_var_array_union_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_union member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_union = "var_array_union";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_union;
            ann_custom_ArrayUnion.reset();
            CompleteMemberDetail detail_var_array_union = TypeObjectUtils::build_complete_member_detail(name_var_array_union, member_ann_builtin_var_array_union, ann_custom_ArrayUnion);
            CompleteStructMember member_var_array_union = TypeObjectUtils::build_complete_struct_member(common_var_array_union, detail_var_array_union);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayUnion, member_var_array_union);
        }
        CompleteStructType struct_type_ArrayUnion = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayUnion, header_ArrayUnion, member_seq_ArrayUnion);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayUnion, type_name_ArrayUnion.to_string(), type_ids_ArrayUnion))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayUnion already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayStructure_type_identifier(
        TypeIdentifierPair& type_ids_ArrayStructure)
{

    ReturnCode_t return_code_ArrayStructure {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayStructure =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayStructure", type_ids_ArrayStructure);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayStructure)
    {
        StructTypeFlag struct_flags_ArrayStructure = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayStructure = "ArrayStructure";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayStructure;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayStructure;
        CompleteTypeDetail detail_ArrayStructure = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayStructure, ann_custom_ArrayStructure, type_name_ArrayStructure.to_string());
        CompleteStructHeader header_ArrayStructure;
        header_ArrayStructure = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayStructure);
        CompleteStructMemberSeq member_seq_ArrayStructure;
        {
            TypeIdentifierPair type_ids_var_array_structure;
            ReturnCode_t return_code_var_array_structure {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_structure =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_InnerStructureHelper_10", type_ids_var_array_structure);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_structure)
            {
                return_code_var_array_structure =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerStructureHelper", type_ids_var_array_structure);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_structure)
                {
                ::register_InnerStructureHelper_type_identifier(type_ids_var_array_structure);
                }
                bool element_identifier_anonymous_array_InnerStructureHelper_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_InnerStructureHelper_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_structure, element_identifier_anonymous_array_InnerStructureHelper_10_ec))};
                if (!element_identifier_anonymous_array_InnerStructureHelper_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_InnerStructureHelper_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_structure.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_InnerStructureHelper_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_InnerStructureHelper_10 = 0;
                PlainCollectionHeader header_anonymous_array_InnerStructureHelper_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_InnerStructureHelper_10, element_flags_anonymous_array_InnerStructureHelper_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_InnerStructureHelper_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_InnerStructureHelper_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_InnerStructureHelper_10", type_ids_var_array_structure))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_InnerStructureHelper_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_structure = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_structure = 0x00000000;
            bool common_var_array_structure_ec {false};
            CommonStructMember common_var_array_structure {TypeObjectUtils::build_common_struct_member(member_id_var_array_structure, member_flags_var_array_structure, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_structure, common_var_array_structure_ec))};
            if (!common_var_array_structure_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_structure member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_structure = "var_array_structure";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_structure;
            ann_custom_ArrayStructure.reset();
            CompleteMemberDetail detail_var_array_structure = TypeObjectUtils::build_complete_member_detail(name_var_array_structure, member_ann_builtin_var_array_structure, ann_custom_ArrayStructure);
            CompleteStructMember member_var_array_structure = TypeObjectUtils::build_complete_struct_member(common_var_array_structure, detail_var_array_structure);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayStructure, member_var_array_structure);
        }
        CompleteStructType struct_type_ArrayStructure = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayStructure, header_ArrayStructure, member_seq_ArrayStructure);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayStructure, type_name_ArrayStructure.to_string(), type_ids_ArrayStructure))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayStructure already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayBitset_type_identifier(
        TypeIdentifierPair& type_ids_ArrayBitset)
{

    ReturnCode_t return_code_ArrayBitset {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayBitset =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayBitset", type_ids_ArrayBitset);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayBitset)
    {
        StructTypeFlag struct_flags_ArrayBitset = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayBitset = "ArrayBitset";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayBitset;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayBitset;
        CompleteTypeDetail detail_ArrayBitset = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayBitset, ann_custom_ArrayBitset, type_name_ArrayBitset.to_string());
        CompleteStructHeader header_ArrayBitset;
        header_ArrayBitset = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayBitset);
        CompleteStructMemberSeq member_seq_ArrayBitset;
        {
            TypeIdentifierPair type_ids_var_array_bitset;
            ReturnCode_t return_code_var_array_bitset {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_bitset =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_InnerBitsetHelper_10", type_ids_var_array_bitset);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bitset)
            {
                return_code_var_array_bitset =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerBitsetHelper", type_ids_var_array_bitset);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bitset)
                {
                ::register_InnerBitsetHelper_type_identifier(type_ids_var_array_bitset);
                }
                bool element_identifier_anonymous_array_InnerBitsetHelper_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_InnerBitsetHelper_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bitset, element_identifier_anonymous_array_InnerBitsetHelper_10_ec))};
                if (!element_identifier_anonymous_array_InnerBitsetHelper_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_InnerBitsetHelper_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_bitset.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_InnerBitsetHelper_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_InnerBitsetHelper_10 = 0;
                PlainCollectionHeader header_anonymous_array_InnerBitsetHelper_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_InnerBitsetHelper_10, element_flags_anonymous_array_InnerBitsetHelper_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_InnerBitsetHelper_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_InnerBitsetHelper_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_InnerBitsetHelper_10", type_ids_var_array_bitset))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_InnerBitsetHelper_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_bitset = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_bitset = 0x00000000;
            bool common_var_array_bitset_ec {false};
            CommonStructMember common_var_array_bitset {TypeObjectUtils::build_common_struct_member(member_id_var_array_bitset, member_flags_var_array_bitset, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bitset, common_var_array_bitset_ec))};
            if (!common_var_array_bitset_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_bitset member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_bitset = "var_array_bitset";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_bitset;
            ann_custom_ArrayBitset.reset();
            CompleteMemberDetail detail_var_array_bitset = TypeObjectUtils::build_complete_member_detail(name_var_array_bitset, member_ann_builtin_var_array_bitset, ann_custom_ArrayBitset);
            CompleteStructMember member_var_array_bitset = TypeObjectUtils::build_complete_struct_member(common_var_array_bitset, detail_var_array_bitset);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayBitset, member_var_array_bitset);
        }
        CompleteStructType struct_type_ArrayBitset = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayBitset, header_ArrayBitset, member_seq_ArrayBitset);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayBitset, type_name_ArrayBitset.to_string(), type_ids_ArrayBitset))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayBitset already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionShort_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionShort)
{

    ReturnCode_t return_code_ArrayMultiDimensionShort {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionShort =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionShort", type_ids_ArrayMultiDimensionShort);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionShort)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionShort = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionShort = "ArrayMultiDimensionShort";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionShort;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionShort;
        CompleteTypeDetail detail_ArrayMultiDimensionShort = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionShort, ann_custom_ArrayMultiDimensionShort, type_name_ArrayMultiDimensionShort.to_string());
        CompleteStructHeader header_ArrayMultiDimensionShort;
        header_ArrayMultiDimensionShort = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionShort);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionShort;
        {
            TypeIdentifierPair type_ids_var_array_short;
            ReturnCode_t return_code_var_array_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_10_10_10", type_ids_var_array_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_short)
            {
                return_code_var_array_short =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_array_short);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_short)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_short, element_identifier_anonymous_array_int16_t_10_10_10_ec))};
                if (!element_identifier_anonymous_array_int16_t_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_short.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_10_10_10, element_flags_anonymous_array_int16_t_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_10_10_10", type_ids_var_array_short))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_short = 0x00000000;
            bool common_var_array_short_ec {false};
            CommonStructMember common_var_array_short {TypeObjectUtils::build_common_struct_member(member_id_var_array_short, member_flags_var_array_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_short, common_var_array_short_ec))};
            if (!common_var_array_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_short = "var_array_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_short;
            ann_custom_ArrayMultiDimensionShort.reset();
            CompleteMemberDetail detail_var_array_short = TypeObjectUtils::build_complete_member_detail(name_var_array_short, member_ann_builtin_var_array_short, ann_custom_ArrayMultiDimensionShort);
            CompleteStructMember member_var_array_short = TypeObjectUtils::build_complete_struct_member(common_var_array_short, detail_var_array_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionShort, member_var_array_short);
        }
        CompleteStructType struct_type_ArrayMultiDimensionShort = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionShort, header_ArrayMultiDimensionShort, member_seq_ArrayMultiDimensionShort);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionShort, type_name_ArrayMultiDimensionShort.to_string(), type_ids_ArrayMultiDimensionShort))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionShort already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionUShort_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionUShort)
{

    ReturnCode_t return_code_ArrayMultiDimensionUShort {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionUShort =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionUShort", type_ids_ArrayMultiDimensionUShort);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionUShort)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionUShort = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionUShort = "ArrayMultiDimensionUShort";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionUShort;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionUShort;
        CompleteTypeDetail detail_ArrayMultiDimensionUShort = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionUShort, ann_custom_ArrayMultiDimensionUShort, type_name_ArrayMultiDimensionUShort.to_string());
        CompleteStructHeader header_ArrayMultiDimensionUShort;
        header_ArrayMultiDimensionUShort = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionUShort);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionUShort;
        {
            TypeIdentifierPair type_ids_var_array_ushort;
            ReturnCode_t return_code_var_array_ushort {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_ushort =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint16_t_10_10_10", type_ids_var_array_ushort);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_ushort)
            {
                return_code_var_array_ushort =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_array_ushort);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_ushort)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint16_t_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint16_t_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_ushort, element_identifier_anonymous_array_uint16_t_10_10_10_ec))};
                if (!element_identifier_anonymous_array_uint16_t_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint16_t_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_ushort.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint16_t_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint16_t_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_uint16_t_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint16_t_10_10_10, element_flags_anonymous_array_uint16_t_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint16_t_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint16_t_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint16_t_10_10_10", type_ids_var_array_ushort))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint16_t_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_ushort = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_ushort = 0x00000000;
            bool common_var_array_ushort_ec {false};
            CommonStructMember common_var_array_ushort {TypeObjectUtils::build_common_struct_member(member_id_var_array_ushort, member_flags_var_array_ushort, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_ushort, common_var_array_ushort_ec))};
            if (!common_var_array_ushort_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_ushort member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_ushort = "var_array_ushort";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_ushort;
            ann_custom_ArrayMultiDimensionUShort.reset();
            CompleteMemberDetail detail_var_array_ushort = TypeObjectUtils::build_complete_member_detail(name_var_array_ushort, member_ann_builtin_var_array_ushort, ann_custom_ArrayMultiDimensionUShort);
            CompleteStructMember member_var_array_ushort = TypeObjectUtils::build_complete_struct_member(common_var_array_ushort, detail_var_array_ushort);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionUShort, member_var_array_ushort);
        }
        CompleteStructType struct_type_ArrayMultiDimensionUShort = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionUShort, header_ArrayMultiDimensionUShort, member_seq_ArrayMultiDimensionUShort);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionUShort, type_name_ArrayMultiDimensionUShort.to_string(), type_ids_ArrayMultiDimensionUShort))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionUShort already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLong_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLong)
{

    ReturnCode_t return_code_ArrayMultiDimensionLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLong", type_ids_ArrayMultiDimensionLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLong)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLong = "ArrayMultiDimensionLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLong;
        CompleteTypeDetail detail_ArrayMultiDimensionLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLong, ann_custom_ArrayMultiDimensionLong, type_name_ArrayMultiDimensionLong.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLong;
        header_ArrayMultiDimensionLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLong);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLong;
        {
            TypeIdentifierPair type_ids_var_array_long;
            ReturnCode_t return_code_var_array_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int32_t_10_10_10", type_ids_var_array_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_long)
            {
                return_code_var_array_long =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_array_long);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_long)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int32_t_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int32_t_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_long, element_identifier_anonymous_array_int32_t_10_10_10_ec))};
                if (!element_identifier_anonymous_array_int32_t_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int32_t_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_long.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int32_t_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int32_t_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_int32_t_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int32_t_10_10_10, element_flags_anonymous_array_int32_t_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int32_t_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int32_t_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int32_t_10_10_10", type_ids_var_array_long))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int32_t_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_long = 0x00000000;
            bool common_var_array_long_ec {false};
            CommonStructMember common_var_array_long {TypeObjectUtils::build_common_struct_member(member_id_var_array_long, member_flags_var_array_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_long, common_var_array_long_ec))};
            if (!common_var_array_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_long = "var_array_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_long;
            ann_custom_ArrayMultiDimensionLong.reset();
            CompleteMemberDetail detail_var_array_long = TypeObjectUtils::build_complete_member_detail(name_var_array_long, member_ann_builtin_var_array_long, ann_custom_ArrayMultiDimensionLong);
            CompleteStructMember member_var_array_long = TypeObjectUtils::build_complete_struct_member(common_var_array_long, detail_var_array_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLong, member_var_array_long);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLong = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLong, header_ArrayMultiDimensionLong, member_seq_ArrayMultiDimensionLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLong, type_name_ArrayMultiDimensionLong.to_string(), type_ids_ArrayMultiDimensionLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionULong_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionULong)
{

    ReturnCode_t return_code_ArrayMultiDimensionULong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionULong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionULong", type_ids_ArrayMultiDimensionULong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionULong)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionULong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionULong = "ArrayMultiDimensionULong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionULong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionULong;
        CompleteTypeDetail detail_ArrayMultiDimensionULong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionULong, ann_custom_ArrayMultiDimensionULong, type_name_ArrayMultiDimensionULong.to_string());
        CompleteStructHeader header_ArrayMultiDimensionULong;
        header_ArrayMultiDimensionULong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionULong);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionULong;
        {
            TypeIdentifierPair type_ids_var_array_ulong;
            ReturnCode_t return_code_var_array_ulong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_ulong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint32_t_10_10_10", type_ids_var_array_ulong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_ulong)
            {
                return_code_var_array_ulong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_var_array_ulong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_ulong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint32_t_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint32_t_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_ulong, element_identifier_anonymous_array_uint32_t_10_10_10_ec))};
                if (!element_identifier_anonymous_array_uint32_t_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint32_t_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_ulong.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint32_t_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint32_t_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_uint32_t_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint32_t_10_10_10, element_flags_anonymous_array_uint32_t_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint32_t_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint32_t_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint32_t_10_10_10", type_ids_var_array_ulong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint32_t_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_ulong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_ulong = 0x00000000;
            bool common_var_array_ulong_ec {false};
            CommonStructMember common_var_array_ulong {TypeObjectUtils::build_common_struct_member(member_id_var_array_ulong, member_flags_var_array_ulong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_ulong, common_var_array_ulong_ec))};
            if (!common_var_array_ulong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_ulong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_ulong = "var_array_ulong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_ulong;
            ann_custom_ArrayMultiDimensionULong.reset();
            CompleteMemberDetail detail_var_array_ulong = TypeObjectUtils::build_complete_member_detail(name_var_array_ulong, member_ann_builtin_var_array_ulong, ann_custom_ArrayMultiDimensionULong);
            CompleteStructMember member_var_array_ulong = TypeObjectUtils::build_complete_struct_member(common_var_array_ulong, detail_var_array_ulong);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionULong, member_var_array_ulong);
        }
        CompleteStructType struct_type_ArrayMultiDimensionULong = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionULong, header_ArrayMultiDimensionULong, member_seq_ArrayMultiDimensionULong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionULong, type_name_ArrayMultiDimensionULong.to_string(), type_ids_ArrayMultiDimensionULong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionULong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLongLong_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLongLong)
{

    ReturnCode_t return_code_ArrayMultiDimensionLongLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLongLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLongLong", type_ids_ArrayMultiDimensionLongLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLongLong)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLongLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLongLong = "ArrayMultiDimensionLongLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLongLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLongLong;
        CompleteTypeDetail detail_ArrayMultiDimensionLongLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLongLong, ann_custom_ArrayMultiDimensionLongLong, type_name_ArrayMultiDimensionLongLong.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLongLong;
        header_ArrayMultiDimensionLongLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLongLong);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLongLong;
        {
            TypeIdentifierPair type_ids_var_array_longlong;
            ReturnCode_t return_code_var_array_longlong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_longlong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int64_t_10_10_10", type_ids_var_array_longlong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_longlong)
            {
                return_code_var_array_longlong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int64_t", type_ids_var_array_longlong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_longlong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int64_t_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int64_t_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_longlong, element_identifier_anonymous_array_int64_t_10_10_10_ec))};
                if (!element_identifier_anonymous_array_int64_t_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int64_t_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_longlong.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int64_t_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int64_t_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_int64_t_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int64_t_10_10_10, element_flags_anonymous_array_int64_t_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int64_t_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int64_t_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int64_t_10_10_10", type_ids_var_array_longlong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int64_t_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_longlong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_longlong = 0x00000000;
            bool common_var_array_longlong_ec {false};
            CommonStructMember common_var_array_longlong {TypeObjectUtils::build_common_struct_member(member_id_var_array_longlong, member_flags_var_array_longlong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_longlong, common_var_array_longlong_ec))};
            if (!common_var_array_longlong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_longlong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_longlong = "var_array_longlong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_longlong;
            ann_custom_ArrayMultiDimensionLongLong.reset();
            CompleteMemberDetail detail_var_array_longlong = TypeObjectUtils::build_complete_member_detail(name_var_array_longlong, member_ann_builtin_var_array_longlong, ann_custom_ArrayMultiDimensionLongLong);
            CompleteStructMember member_var_array_longlong = TypeObjectUtils::build_complete_struct_member(common_var_array_longlong, detail_var_array_longlong);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLongLong, member_var_array_longlong);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLongLong = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLongLong, header_ArrayMultiDimensionLongLong, member_seq_ArrayMultiDimensionLongLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLongLong, type_name_ArrayMultiDimensionLongLong.to_string(), type_ids_ArrayMultiDimensionLongLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLongLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionULongLong_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionULongLong)
{

    ReturnCode_t return_code_ArrayMultiDimensionULongLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionULongLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionULongLong", type_ids_ArrayMultiDimensionULongLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionULongLong)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionULongLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionULongLong = "ArrayMultiDimensionULongLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionULongLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionULongLong;
        CompleteTypeDetail detail_ArrayMultiDimensionULongLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionULongLong, ann_custom_ArrayMultiDimensionULongLong, type_name_ArrayMultiDimensionULongLong.to_string());
        CompleteStructHeader header_ArrayMultiDimensionULongLong;
        header_ArrayMultiDimensionULongLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionULongLong);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionULongLong;
        {
            TypeIdentifierPair type_ids_var_array_ulonglong;
            ReturnCode_t return_code_var_array_ulonglong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_ulonglong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint64_t_10_10_10", type_ids_var_array_ulonglong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_ulonglong)
            {
                return_code_var_array_ulonglong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint64_t", type_ids_var_array_ulonglong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_ulonglong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint64_t_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint64_t_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_ulonglong, element_identifier_anonymous_array_uint64_t_10_10_10_ec))};
                if (!element_identifier_anonymous_array_uint64_t_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint64_t_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_ulonglong.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint64_t_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint64_t_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_uint64_t_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint64_t_10_10_10, element_flags_anonymous_array_uint64_t_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint64_t_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint64_t_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint64_t_10_10_10", type_ids_var_array_ulonglong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint64_t_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_ulonglong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_ulonglong = 0x00000000;
            bool common_var_array_ulonglong_ec {false};
            CommonStructMember common_var_array_ulonglong {TypeObjectUtils::build_common_struct_member(member_id_var_array_ulonglong, member_flags_var_array_ulonglong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_ulonglong, common_var_array_ulonglong_ec))};
            if (!common_var_array_ulonglong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_ulonglong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_ulonglong = "var_array_ulonglong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_ulonglong;
            ann_custom_ArrayMultiDimensionULongLong.reset();
            CompleteMemberDetail detail_var_array_ulonglong = TypeObjectUtils::build_complete_member_detail(name_var_array_ulonglong, member_ann_builtin_var_array_ulonglong, ann_custom_ArrayMultiDimensionULongLong);
            CompleteStructMember member_var_array_ulonglong = TypeObjectUtils::build_complete_struct_member(common_var_array_ulonglong, detail_var_array_ulonglong);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionULongLong, member_var_array_ulonglong);
        }
        CompleteStructType struct_type_ArrayMultiDimensionULongLong = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionULongLong, header_ArrayMultiDimensionULongLong, member_seq_ArrayMultiDimensionULongLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionULongLong, type_name_ArrayMultiDimensionULongLong.to_string(), type_ids_ArrayMultiDimensionULongLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionULongLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionFloat_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionFloat)
{

    ReturnCode_t return_code_ArrayMultiDimensionFloat {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionFloat =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionFloat", type_ids_ArrayMultiDimensionFloat);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionFloat)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionFloat = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionFloat = "ArrayMultiDimensionFloat";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionFloat;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionFloat;
        CompleteTypeDetail detail_ArrayMultiDimensionFloat = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionFloat, ann_custom_ArrayMultiDimensionFloat, type_name_ArrayMultiDimensionFloat.to_string());
        CompleteStructHeader header_ArrayMultiDimensionFloat;
        header_ArrayMultiDimensionFloat = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionFloat);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionFloat;
        {
            TypeIdentifierPair type_ids_var_array_float;
            ReturnCode_t return_code_var_array_float {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_float =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_float_10_10_10", type_ids_var_array_float);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_float)
            {
                return_code_var_array_float =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_float", type_ids_var_array_float);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_float)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_float_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_float_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_float, element_identifier_anonymous_array_float_10_10_10_ec))};
                if (!element_identifier_anonymous_array_float_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_float_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_float.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_float_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_float_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_float_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_float_10_10_10, element_flags_anonymous_array_float_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_float_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_float_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_float_10_10_10", type_ids_var_array_float))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_float_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_float = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_float = 0x00000000;
            bool common_var_array_float_ec {false};
            CommonStructMember common_var_array_float {TypeObjectUtils::build_common_struct_member(member_id_var_array_float, member_flags_var_array_float, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_float, common_var_array_float_ec))};
            if (!common_var_array_float_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_float member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_float = "var_array_float";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_float;
            ann_custom_ArrayMultiDimensionFloat.reset();
            CompleteMemberDetail detail_var_array_float = TypeObjectUtils::build_complete_member_detail(name_var_array_float, member_ann_builtin_var_array_float, ann_custom_ArrayMultiDimensionFloat);
            CompleteStructMember member_var_array_float = TypeObjectUtils::build_complete_struct_member(common_var_array_float, detail_var_array_float);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionFloat, member_var_array_float);
        }
        CompleteStructType struct_type_ArrayMultiDimensionFloat = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionFloat, header_ArrayMultiDimensionFloat, member_seq_ArrayMultiDimensionFloat);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionFloat, type_name_ArrayMultiDimensionFloat.to_string(), type_ids_ArrayMultiDimensionFloat))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionFloat already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionDouble_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionDouble)
{

    ReturnCode_t return_code_ArrayMultiDimensionDouble {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionDouble =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionDouble", type_ids_ArrayMultiDimensionDouble);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionDouble)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionDouble = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionDouble = "ArrayMultiDimensionDouble";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionDouble;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionDouble;
        CompleteTypeDetail detail_ArrayMultiDimensionDouble = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionDouble, ann_custom_ArrayMultiDimensionDouble, type_name_ArrayMultiDimensionDouble.to_string());
        CompleteStructHeader header_ArrayMultiDimensionDouble;
        header_ArrayMultiDimensionDouble = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionDouble);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionDouble;
        {
            TypeIdentifierPair type_ids_var_array_double;
            ReturnCode_t return_code_var_array_double {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_double =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_double_10_10_10", type_ids_var_array_double);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_double)
            {
                return_code_var_array_double =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_double", type_ids_var_array_double);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_double)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_double_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_double_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_double, element_identifier_anonymous_array_double_10_10_10_ec))};
                if (!element_identifier_anonymous_array_double_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_double_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_double.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_double_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_double_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_double_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_double_10_10_10, element_flags_anonymous_array_double_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_double_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_double_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_double_10_10_10", type_ids_var_array_double))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_double_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_double = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_double = 0x00000000;
            bool common_var_array_double_ec {false};
            CommonStructMember common_var_array_double {TypeObjectUtils::build_common_struct_member(member_id_var_array_double, member_flags_var_array_double, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_double, common_var_array_double_ec))};
            if (!common_var_array_double_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_double member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_double = "var_array_double";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_double;
            ann_custom_ArrayMultiDimensionDouble.reset();
            CompleteMemberDetail detail_var_array_double = TypeObjectUtils::build_complete_member_detail(name_var_array_double, member_ann_builtin_var_array_double, ann_custom_ArrayMultiDimensionDouble);
            CompleteStructMember member_var_array_double = TypeObjectUtils::build_complete_struct_member(common_var_array_double, detail_var_array_double);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionDouble, member_var_array_double);
        }
        CompleteStructType struct_type_ArrayMultiDimensionDouble = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionDouble, header_ArrayMultiDimensionDouble, member_seq_ArrayMultiDimensionDouble);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionDouble, type_name_ArrayMultiDimensionDouble.to_string(), type_ids_ArrayMultiDimensionDouble))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionDouble already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLongDouble_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLongDouble)
{

    ReturnCode_t return_code_ArrayMultiDimensionLongDouble {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLongDouble =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLongDouble", type_ids_ArrayMultiDimensionLongDouble);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLongDouble)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLongDouble = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLongDouble = "ArrayMultiDimensionLongDouble";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLongDouble;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLongDouble;
        CompleteTypeDetail detail_ArrayMultiDimensionLongDouble = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLongDouble, ann_custom_ArrayMultiDimensionLongDouble, type_name_ArrayMultiDimensionLongDouble.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLongDouble;
        header_ArrayMultiDimensionLongDouble = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLongDouble);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLongDouble;
        {
            TypeIdentifierPair type_ids_var_array_longdouble;
            ReturnCode_t return_code_var_array_longdouble {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_longdouble =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_longdouble_10_10_10", type_ids_var_array_longdouble);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_longdouble)
            {
                return_code_var_array_longdouble =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_longdouble", type_ids_var_array_longdouble);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_longdouble)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_longdouble_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_longdouble_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_longdouble, element_identifier_anonymous_array_longdouble_10_10_10_ec))};
                if (!element_identifier_anonymous_array_longdouble_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_longdouble_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_longdouble.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_longdouble_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_longdouble_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_longdouble_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_longdouble_10_10_10, element_flags_anonymous_array_longdouble_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_longdouble_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_longdouble_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_longdouble_10_10_10", type_ids_var_array_longdouble))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_longdouble_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_longdouble = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_longdouble = 0x00000000;
            bool common_var_array_longdouble_ec {false};
            CommonStructMember common_var_array_longdouble {TypeObjectUtils::build_common_struct_member(member_id_var_array_longdouble, member_flags_var_array_longdouble, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_longdouble, common_var_array_longdouble_ec))};
            if (!common_var_array_longdouble_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_longdouble member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_longdouble = "var_array_longdouble";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_longdouble;
            ann_custom_ArrayMultiDimensionLongDouble.reset();
            CompleteMemberDetail detail_var_array_longdouble = TypeObjectUtils::build_complete_member_detail(name_var_array_longdouble, member_ann_builtin_var_array_longdouble, ann_custom_ArrayMultiDimensionLongDouble);
            CompleteStructMember member_var_array_longdouble = TypeObjectUtils::build_complete_struct_member(common_var_array_longdouble, detail_var_array_longdouble);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLongDouble, member_var_array_longdouble);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLongDouble = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLongDouble, header_ArrayMultiDimensionLongDouble, member_seq_ArrayMultiDimensionLongDouble);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLongDouble, type_name_ArrayMultiDimensionLongDouble.to_string(), type_ids_ArrayMultiDimensionLongDouble))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLongDouble already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionBoolean_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionBoolean)
{

    ReturnCode_t return_code_ArrayMultiDimensionBoolean {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionBoolean =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionBoolean", type_ids_ArrayMultiDimensionBoolean);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionBoolean)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionBoolean = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionBoolean = "ArrayMultiDimensionBoolean";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionBoolean;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionBoolean;
        CompleteTypeDetail detail_ArrayMultiDimensionBoolean = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionBoolean, ann_custom_ArrayMultiDimensionBoolean, type_name_ArrayMultiDimensionBoolean.to_string());
        CompleteStructHeader header_ArrayMultiDimensionBoolean;
        header_ArrayMultiDimensionBoolean = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionBoolean);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionBoolean;
        {
            TypeIdentifierPair type_ids_var_array_boolean;
            ReturnCode_t return_code_var_array_boolean {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_boolean =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_bool_10_10_10", type_ids_var_array_boolean);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_boolean)
            {
                return_code_var_array_boolean =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_bool", type_ids_var_array_boolean);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_boolean)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_bool_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_bool_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_boolean, element_identifier_anonymous_array_bool_10_10_10_ec))};
                if (!element_identifier_anonymous_array_bool_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_bool_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_boolean.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_bool_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_bool_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_bool_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_bool_10_10_10, element_flags_anonymous_array_bool_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_bool_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_bool_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_bool_10_10_10", type_ids_var_array_boolean))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_bool_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_boolean = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_boolean = 0x00000000;
            bool common_var_array_boolean_ec {false};
            CommonStructMember common_var_array_boolean {TypeObjectUtils::build_common_struct_member(member_id_var_array_boolean, member_flags_var_array_boolean, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_boolean, common_var_array_boolean_ec))};
            if (!common_var_array_boolean_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_boolean member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_boolean = "var_array_boolean";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_boolean;
            ann_custom_ArrayMultiDimensionBoolean.reset();
            CompleteMemberDetail detail_var_array_boolean = TypeObjectUtils::build_complete_member_detail(name_var_array_boolean, member_ann_builtin_var_array_boolean, ann_custom_ArrayMultiDimensionBoolean);
            CompleteStructMember member_var_array_boolean = TypeObjectUtils::build_complete_struct_member(common_var_array_boolean, detail_var_array_boolean);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionBoolean, member_var_array_boolean);
        }
        CompleteStructType struct_type_ArrayMultiDimensionBoolean = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionBoolean, header_ArrayMultiDimensionBoolean, member_seq_ArrayMultiDimensionBoolean);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionBoolean, type_name_ArrayMultiDimensionBoolean.to_string(), type_ids_ArrayMultiDimensionBoolean))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionBoolean already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionOctet_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionOctet)
{

    ReturnCode_t return_code_ArrayMultiDimensionOctet {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionOctet =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionOctet", type_ids_ArrayMultiDimensionOctet);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionOctet)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionOctet = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionOctet = "ArrayMultiDimensionOctet";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionOctet;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionOctet;
        CompleteTypeDetail detail_ArrayMultiDimensionOctet = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionOctet, ann_custom_ArrayMultiDimensionOctet, type_name_ArrayMultiDimensionOctet.to_string());
        CompleteStructHeader header_ArrayMultiDimensionOctet;
        header_ArrayMultiDimensionOctet = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionOctet);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionOctet;
        {
            TypeIdentifierPair type_ids_var_array_octet;
            ReturnCode_t return_code_var_array_octet {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_octet =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_byte_10_10_10", type_ids_var_array_octet);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_octet)
            {
                return_code_var_array_octet =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_byte", type_ids_var_array_octet);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_octet)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_byte_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_byte_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_octet, element_identifier_anonymous_array_byte_10_10_10_ec))};
                if (!element_identifier_anonymous_array_byte_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_byte_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_octet.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_byte_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_byte_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_byte_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_byte_10_10_10, element_flags_anonymous_array_byte_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_byte_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_byte_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_byte_10_10_10", type_ids_var_array_octet))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_byte_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_octet = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_octet = 0x00000000;
            bool common_var_array_octet_ec {false};
            CommonStructMember common_var_array_octet {TypeObjectUtils::build_common_struct_member(member_id_var_array_octet, member_flags_var_array_octet, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_octet, common_var_array_octet_ec))};
            if (!common_var_array_octet_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_octet member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_octet = "var_array_octet";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_octet;
            ann_custom_ArrayMultiDimensionOctet.reset();
            CompleteMemberDetail detail_var_array_octet = TypeObjectUtils::build_complete_member_detail(name_var_array_octet, member_ann_builtin_var_array_octet, ann_custom_ArrayMultiDimensionOctet);
            CompleteStructMember member_var_array_octet = TypeObjectUtils::build_complete_struct_member(common_var_array_octet, detail_var_array_octet);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionOctet, member_var_array_octet);
        }
        CompleteStructType struct_type_ArrayMultiDimensionOctet = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionOctet, header_ArrayMultiDimensionOctet, member_seq_ArrayMultiDimensionOctet);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionOctet, type_name_ArrayMultiDimensionOctet.to_string(), type_ids_ArrayMultiDimensionOctet))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionOctet already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionChar_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionChar)
{

    ReturnCode_t return_code_ArrayMultiDimensionChar {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionChar =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionChar", type_ids_ArrayMultiDimensionChar);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionChar)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionChar = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionChar = "ArrayMultiDimensionChar";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionChar;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionChar;
        CompleteTypeDetail detail_ArrayMultiDimensionChar = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionChar, ann_custom_ArrayMultiDimensionChar, type_name_ArrayMultiDimensionChar.to_string());
        CompleteStructHeader header_ArrayMultiDimensionChar;
        header_ArrayMultiDimensionChar = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionChar);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionChar;
        {
            TypeIdentifierPair type_ids_var_array_char;
            ReturnCode_t return_code_var_array_char {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_char =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_char_10_10_10", type_ids_var_array_char);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_char)
            {
                return_code_var_array_char =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_char", type_ids_var_array_char);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_char)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_char_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_char_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_char, element_identifier_anonymous_array_char_10_10_10_ec))};
                if (!element_identifier_anonymous_array_char_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_char_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_char.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_char_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_char_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_char_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_char_10_10_10, element_flags_anonymous_array_char_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_char_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_char_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_char_10_10_10", type_ids_var_array_char))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_char_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_char = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_char = 0x00000000;
            bool common_var_array_char_ec {false};
            CommonStructMember common_var_array_char {TypeObjectUtils::build_common_struct_member(member_id_var_array_char, member_flags_var_array_char, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_char, common_var_array_char_ec))};
            if (!common_var_array_char_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_char member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_char = "var_array_char";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_char;
            ann_custom_ArrayMultiDimensionChar.reset();
            CompleteMemberDetail detail_var_array_char = TypeObjectUtils::build_complete_member_detail(name_var_array_char, member_ann_builtin_var_array_char, ann_custom_ArrayMultiDimensionChar);
            CompleteStructMember member_var_array_char = TypeObjectUtils::build_complete_struct_member(common_var_array_char, detail_var_array_char);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionChar, member_var_array_char);
        }
        CompleteStructType struct_type_ArrayMultiDimensionChar = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionChar, header_ArrayMultiDimensionChar, member_seq_ArrayMultiDimensionChar);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionChar, type_name_ArrayMultiDimensionChar.to_string(), type_ids_ArrayMultiDimensionChar))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionChar already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionWChar_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionWChar)
{

    ReturnCode_t return_code_ArrayMultiDimensionWChar {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionWChar =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionWChar", type_ids_ArrayMultiDimensionWChar);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionWChar)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionWChar = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionWChar = "ArrayMultiDimensionWChar";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionWChar;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionWChar;
        CompleteTypeDetail detail_ArrayMultiDimensionWChar = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionWChar, ann_custom_ArrayMultiDimensionWChar, type_name_ArrayMultiDimensionWChar.to_string());
        CompleteStructHeader header_ArrayMultiDimensionWChar;
        header_ArrayMultiDimensionWChar = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionWChar);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionWChar;
        {
            TypeIdentifierPair type_ids_var_array_wchar;
            ReturnCode_t return_code_var_array_wchar {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_wchar =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_wchar_t_10_10_10", type_ids_var_array_wchar);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_wchar)
            {
                return_code_var_array_wchar =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_wchar_t", type_ids_var_array_wchar);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_wchar)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_wchar_t_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_wchar_t_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_wchar, element_identifier_anonymous_array_wchar_t_10_10_10_ec))};
                if (!element_identifier_anonymous_array_wchar_t_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_wchar_t_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_wchar.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_wchar_t_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_wchar_t_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_wchar_t_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_wchar_t_10_10_10, element_flags_anonymous_array_wchar_t_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_wchar_t_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_wchar_t_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_wchar_t_10_10_10", type_ids_var_array_wchar))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_wchar_t_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_wchar = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_wchar = 0x00000000;
            bool common_var_array_wchar_ec {false};
            CommonStructMember common_var_array_wchar {TypeObjectUtils::build_common_struct_member(member_id_var_array_wchar, member_flags_var_array_wchar, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_wchar, common_var_array_wchar_ec))};
            if (!common_var_array_wchar_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_wchar member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_wchar = "var_array_wchar";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_wchar;
            ann_custom_ArrayMultiDimensionWChar.reset();
            CompleteMemberDetail detail_var_array_wchar = TypeObjectUtils::build_complete_member_detail(name_var_array_wchar, member_ann_builtin_var_array_wchar, ann_custom_ArrayMultiDimensionWChar);
            CompleteStructMember member_var_array_wchar = TypeObjectUtils::build_complete_struct_member(common_var_array_wchar, detail_var_array_wchar);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionWChar, member_var_array_wchar);
        }
        CompleteStructType struct_type_ArrayMultiDimensionWChar = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionWChar, header_ArrayMultiDimensionWChar, member_seq_ArrayMultiDimensionWChar);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionWChar, type_name_ArrayMultiDimensionWChar.to_string(), type_ids_ArrayMultiDimensionWChar))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionWChar already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionString_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionString)
{

    ReturnCode_t return_code_ArrayMultiDimensionString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionString", type_ids_ArrayMultiDimensionString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionString)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionString = "ArrayMultiDimensionString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionString;
        CompleteTypeDetail detail_ArrayMultiDimensionString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionString, ann_custom_ArrayMultiDimensionString, type_name_ArrayMultiDimensionString.to_string());
        CompleteStructHeader header_ArrayMultiDimensionString;
        header_ArrayMultiDimensionString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionString);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionString;
        {
            TypeIdentifierPair type_ids_var_array_string;
            ReturnCode_t return_code_var_array_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_anonymous_string_unbounded_10_10_10", type_ids_var_array_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_string)
            {
                return_code_var_array_string =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_string_unbounded", type_ids_var_array_string);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_string)
                {
                    {
                        SBound bound = 0;
                        StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                                "anonymous_string_unbounded", type_ids_var_array_string))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_array_anonymous_string_unbounded_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_anonymous_string_unbounded_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_string, element_identifier_anonymous_array_anonymous_string_unbounded_10_10_10_ec))};
                if (!element_identifier_anonymous_array_anonymous_string_unbounded_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_anonymous_string_unbounded_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_string.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_anonymous_string_unbounded_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_anonymous_string_unbounded_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_anonymous_string_unbounded_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_anonymous_string_unbounded_10_10_10, element_flags_anonymous_array_anonymous_string_unbounded_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_anonymous_string_unbounded_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_anonymous_string_unbounded_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_anonymous_string_unbounded_10_10_10", type_ids_var_array_string))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_anonymous_string_unbounded_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_string = 0x00000000;
            bool common_var_array_string_ec {false};
            CommonStructMember common_var_array_string {TypeObjectUtils::build_common_struct_member(member_id_var_array_string, member_flags_var_array_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_string, common_var_array_string_ec))};
            if (!common_var_array_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_string = "var_array_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_string;
            ann_custom_ArrayMultiDimensionString.reset();
            CompleteMemberDetail detail_var_array_string = TypeObjectUtils::build_complete_member_detail(name_var_array_string, member_ann_builtin_var_array_string, ann_custom_ArrayMultiDimensionString);
            CompleteStructMember member_var_array_string = TypeObjectUtils::build_complete_struct_member(common_var_array_string, detail_var_array_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionString, member_var_array_string);
        }
        CompleteStructType struct_type_ArrayMultiDimensionString = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionString, header_ArrayMultiDimensionString, member_seq_ArrayMultiDimensionString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionString, type_name_ArrayMultiDimensionString.to_string(), type_ids_ArrayMultiDimensionString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionWString_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionWString)
{

    ReturnCode_t return_code_ArrayMultiDimensionWString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionWString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionWString", type_ids_ArrayMultiDimensionWString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionWString)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionWString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionWString = "ArrayMultiDimensionWString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionWString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionWString;
        CompleteTypeDetail detail_ArrayMultiDimensionWString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionWString, ann_custom_ArrayMultiDimensionWString, type_name_ArrayMultiDimensionWString.to_string());
        CompleteStructHeader header_ArrayMultiDimensionWString;
        header_ArrayMultiDimensionWString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionWString);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionWString;
        {
            TypeIdentifierPair type_ids_var_array_wstring;
            ReturnCode_t return_code_var_array_wstring {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_wstring =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_anonymous_wstring_unbounded_10_10_10", type_ids_var_array_wstring);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_wstring)
            {
                return_code_var_array_wstring =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_wstring_unbounded", type_ids_var_array_wstring);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_wstring)
                {
                    {
                        SBound bound = 0;
                        StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                                "anonymous_wstring_unbounded", type_ids_var_array_wstring, true))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_wstring_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_array_anonymous_wstring_unbounded_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_anonymous_wstring_unbounded_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_wstring, element_identifier_anonymous_array_anonymous_wstring_unbounded_10_10_10_ec))};
                if (!element_identifier_anonymous_array_anonymous_wstring_unbounded_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_anonymous_wstring_unbounded_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_wstring.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_anonymous_wstring_unbounded_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_anonymous_wstring_unbounded_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_anonymous_wstring_unbounded_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_anonymous_wstring_unbounded_10_10_10, element_flags_anonymous_array_anonymous_wstring_unbounded_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_anonymous_wstring_unbounded_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_anonymous_wstring_unbounded_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_anonymous_wstring_unbounded_10_10_10", type_ids_var_array_wstring))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_anonymous_wstring_unbounded_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_wstring = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_wstring = 0x00000000;
            bool common_var_array_wstring_ec {false};
            CommonStructMember common_var_array_wstring {TypeObjectUtils::build_common_struct_member(member_id_var_array_wstring, member_flags_var_array_wstring, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_wstring, common_var_array_wstring_ec))};
            if (!common_var_array_wstring_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_wstring member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_wstring = "var_array_wstring";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_wstring;
            ann_custom_ArrayMultiDimensionWString.reset();
            CompleteMemberDetail detail_var_array_wstring = TypeObjectUtils::build_complete_member_detail(name_var_array_wstring, member_ann_builtin_var_array_wstring, ann_custom_ArrayMultiDimensionWString);
            CompleteStructMember member_var_array_wstring = TypeObjectUtils::build_complete_struct_member(common_var_array_wstring, detail_var_array_wstring);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionWString, member_var_array_wstring);
        }
        CompleteStructType struct_type_ArrayMultiDimensionWString = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionWString, header_ArrayMultiDimensionWString, member_seq_ArrayMultiDimensionWString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionWString, type_name_ArrayMultiDimensionWString.to_string(), type_ids_ArrayMultiDimensionWString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionWString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionBoundedString_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionBoundedString)
{

    ReturnCode_t return_code_ArrayMultiDimensionBoundedString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionBoundedString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionBoundedString", type_ids_ArrayMultiDimensionBoundedString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionBoundedString)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionBoundedString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionBoundedString = "ArrayMultiDimensionBoundedString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionBoundedString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionBoundedString;
        CompleteTypeDetail detail_ArrayMultiDimensionBoundedString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionBoundedString, ann_custom_ArrayMultiDimensionBoundedString, type_name_ArrayMultiDimensionBoundedString.to_string());
        CompleteStructHeader header_ArrayMultiDimensionBoundedString;
        header_ArrayMultiDimensionBoundedString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionBoundedString);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionBoundedString;
        {
            TypeIdentifierPair type_ids_var_array_bounded_string;
            ReturnCode_t return_code_var_array_bounded_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_bounded_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_anonymous_string_10_10_10_10", type_ids_var_array_bounded_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bounded_string)
            {
                return_code_var_array_bounded_string =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_bounded_string_helper", type_ids_var_array_bounded_string);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bounded_string)
                {
                ::register_Inner_alias_bounded_string_helper_type_identifier(type_ids_var_array_bounded_string);
                }
                bool element_identifier_anonymous_array_anonymous_string_10_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_anonymous_string_10_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bounded_string, element_identifier_anonymous_array_anonymous_string_10_10_10_10_ec))};
                if (!element_identifier_anonymous_array_anonymous_string_10_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_anonymous_string_10_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_bounded_string.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_anonymous_string_10_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_anonymous_string_10_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_anonymous_string_10_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_anonymous_string_10_10_10_10, element_flags_anonymous_array_anonymous_string_10_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_anonymous_string_10_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_anonymous_string_10_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_anonymous_string_10_10_10_10", type_ids_var_array_bounded_string))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_anonymous_string_10_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_bounded_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_bounded_string = 0x00000000;
            bool common_var_array_bounded_string_ec {false};
            CommonStructMember common_var_array_bounded_string {TypeObjectUtils::build_common_struct_member(member_id_var_array_bounded_string, member_flags_var_array_bounded_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bounded_string, common_var_array_bounded_string_ec))};
            if (!common_var_array_bounded_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_bounded_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_bounded_string = "var_array_bounded_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_bounded_string;
            ann_custom_ArrayMultiDimensionBoundedString.reset();
            CompleteMemberDetail detail_var_array_bounded_string = TypeObjectUtils::build_complete_member_detail(name_var_array_bounded_string, member_ann_builtin_var_array_bounded_string, ann_custom_ArrayMultiDimensionBoundedString);
            CompleteStructMember member_var_array_bounded_string = TypeObjectUtils::build_complete_struct_member(common_var_array_bounded_string, detail_var_array_bounded_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionBoundedString, member_var_array_bounded_string);
        }
        CompleteStructType struct_type_ArrayMultiDimensionBoundedString = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionBoundedString, header_ArrayMultiDimensionBoundedString, member_seq_ArrayMultiDimensionBoundedString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionBoundedString, type_name_ArrayMultiDimensionBoundedString.to_string(), type_ids_ArrayMultiDimensionBoundedString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionBoundedString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionBoundedWString_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionBoundedWString)
{

    ReturnCode_t return_code_ArrayMultiDimensionBoundedWString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionBoundedWString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionBoundedWString", type_ids_ArrayMultiDimensionBoundedWString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionBoundedWString)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionBoundedWString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionBoundedWString = "ArrayMultiDimensionBoundedWString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionBoundedWString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionBoundedWString;
        CompleteTypeDetail detail_ArrayMultiDimensionBoundedWString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionBoundedWString, ann_custom_ArrayMultiDimensionBoundedWString, type_name_ArrayMultiDimensionBoundedWString.to_string());
        CompleteStructHeader header_ArrayMultiDimensionBoundedWString;
        header_ArrayMultiDimensionBoundedWString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionBoundedWString);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionBoundedWString;
        {
            TypeIdentifierPair type_ids_var_array_bounded_wstring;
            ReturnCode_t return_code_var_array_bounded_wstring {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_bounded_wstring =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_anonymous_wstring_10_10_10_10", type_ids_var_array_bounded_wstring);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bounded_wstring)
            {
                return_code_var_array_bounded_wstring =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_bounded_wstring_helper", type_ids_var_array_bounded_wstring);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bounded_wstring)
                {
                ::register_Inner_alias_bounded_wstring_helper_type_identifier(type_ids_var_array_bounded_wstring);
                }
                bool element_identifier_anonymous_array_anonymous_wstring_10_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_anonymous_wstring_10_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bounded_wstring, element_identifier_anonymous_array_anonymous_wstring_10_10_10_10_ec))};
                if (!element_identifier_anonymous_array_anonymous_wstring_10_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_anonymous_wstring_10_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_bounded_wstring.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_anonymous_wstring_10_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_anonymous_wstring_10_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_anonymous_wstring_10_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_anonymous_wstring_10_10_10_10, element_flags_anonymous_array_anonymous_wstring_10_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_anonymous_wstring_10_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_anonymous_wstring_10_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_anonymous_wstring_10_10_10_10", type_ids_var_array_bounded_wstring))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_anonymous_wstring_10_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_bounded_wstring = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_bounded_wstring = 0x00000000;
            bool common_var_array_bounded_wstring_ec {false};
            CommonStructMember common_var_array_bounded_wstring {TypeObjectUtils::build_common_struct_member(member_id_var_array_bounded_wstring, member_flags_var_array_bounded_wstring, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bounded_wstring, common_var_array_bounded_wstring_ec))};
            if (!common_var_array_bounded_wstring_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_bounded_wstring member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_bounded_wstring = "var_array_bounded_wstring";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_bounded_wstring;
            ann_custom_ArrayMultiDimensionBoundedWString.reset();
            CompleteMemberDetail detail_var_array_bounded_wstring = TypeObjectUtils::build_complete_member_detail(name_var_array_bounded_wstring, member_ann_builtin_var_array_bounded_wstring, ann_custom_ArrayMultiDimensionBoundedWString);
            CompleteStructMember member_var_array_bounded_wstring = TypeObjectUtils::build_complete_struct_member(common_var_array_bounded_wstring, detail_var_array_bounded_wstring);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionBoundedWString, member_var_array_bounded_wstring);
        }
        CompleteStructType struct_type_ArrayMultiDimensionBoundedWString = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionBoundedWString, header_ArrayMultiDimensionBoundedWString, member_seq_ArrayMultiDimensionBoundedWString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionBoundedWString, type_name_ArrayMultiDimensionBoundedWString.to_string(), type_ids_ArrayMultiDimensionBoundedWString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionBoundedWString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionEnum_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionEnum)
{

    ReturnCode_t return_code_ArrayMultiDimensionEnum {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionEnum =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionEnum", type_ids_ArrayMultiDimensionEnum);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionEnum)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionEnum = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionEnum = "ArrayMultiDimensionEnum";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionEnum;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionEnum;
        CompleteTypeDetail detail_ArrayMultiDimensionEnum = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionEnum, ann_custom_ArrayMultiDimensionEnum, type_name_ArrayMultiDimensionEnum.to_string());
        CompleteStructHeader header_ArrayMultiDimensionEnum;
        header_ArrayMultiDimensionEnum = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionEnum);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionEnum;
        {
            TypeIdentifierPair type_ids_var_array_enum;
            ReturnCode_t return_code_var_array_enum {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_enum =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_InnerEnumHelper_10_10_10", type_ids_var_array_enum);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_enum)
            {
                return_code_var_array_enum =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerEnumHelper", type_ids_var_array_enum);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_enum)
                {
                ::register_InnerEnumHelper_type_identifier(type_ids_var_array_enum);
                }
                bool element_identifier_anonymous_array_InnerEnumHelper_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_InnerEnumHelper_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_enum, element_identifier_anonymous_array_InnerEnumHelper_10_10_10_ec))};
                if (!element_identifier_anonymous_array_InnerEnumHelper_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_InnerEnumHelper_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_enum.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_InnerEnumHelper_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_InnerEnumHelper_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_InnerEnumHelper_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_InnerEnumHelper_10_10_10, element_flags_anonymous_array_InnerEnumHelper_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_InnerEnumHelper_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_InnerEnumHelper_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_InnerEnumHelper_10_10_10", type_ids_var_array_enum))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_InnerEnumHelper_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_enum = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_enum = 0x00000000;
            bool common_var_array_enum_ec {false};
            CommonStructMember common_var_array_enum {TypeObjectUtils::build_common_struct_member(member_id_var_array_enum, member_flags_var_array_enum, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_enum, common_var_array_enum_ec))};
            if (!common_var_array_enum_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_enum member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_enum = "var_array_enum";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_enum;
            ann_custom_ArrayMultiDimensionEnum.reset();
            CompleteMemberDetail detail_var_array_enum = TypeObjectUtils::build_complete_member_detail(name_var_array_enum, member_ann_builtin_var_array_enum, ann_custom_ArrayMultiDimensionEnum);
            CompleteStructMember member_var_array_enum = TypeObjectUtils::build_complete_struct_member(common_var_array_enum, detail_var_array_enum);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionEnum, member_var_array_enum);
        }
        CompleteStructType struct_type_ArrayMultiDimensionEnum = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionEnum, header_ArrayMultiDimensionEnum, member_seq_ArrayMultiDimensionEnum);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionEnum, type_name_ArrayMultiDimensionEnum.to_string(), type_ids_ArrayMultiDimensionEnum))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionEnum already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionBitMask_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionBitMask)
{

    ReturnCode_t return_code_ArrayMultiDimensionBitMask {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionBitMask =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionBitMask", type_ids_ArrayMultiDimensionBitMask);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionBitMask)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionBitMask = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionBitMask = "ArrayMultiDimensionBitMask";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionBitMask;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionBitMask;
        CompleteTypeDetail detail_ArrayMultiDimensionBitMask = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionBitMask, ann_custom_ArrayMultiDimensionBitMask, type_name_ArrayMultiDimensionBitMask.to_string());
        CompleteStructHeader header_ArrayMultiDimensionBitMask;
        header_ArrayMultiDimensionBitMask = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionBitMask);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionBitMask;
        {
            TypeIdentifierPair type_ids_var_array_bitmask;
            ReturnCode_t return_code_var_array_bitmask {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_bitmask =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_InnerBitMaskHelper_10_10_10", type_ids_var_array_bitmask);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bitmask)
            {
                return_code_var_array_bitmask =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerBitMaskHelper", type_ids_var_array_bitmask);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bitmask)
                {
                ::register_InnerBitMaskHelper_type_identifier(type_ids_var_array_bitmask);
                }
                bool element_identifier_anonymous_array_InnerBitMaskHelper_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_InnerBitMaskHelper_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bitmask, element_identifier_anonymous_array_InnerBitMaskHelper_10_10_10_ec))};
                if (!element_identifier_anonymous_array_InnerBitMaskHelper_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_InnerBitMaskHelper_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_bitmask.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_InnerBitMaskHelper_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_InnerBitMaskHelper_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_InnerBitMaskHelper_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_InnerBitMaskHelper_10_10_10, element_flags_anonymous_array_InnerBitMaskHelper_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_InnerBitMaskHelper_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_InnerBitMaskHelper_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_InnerBitMaskHelper_10_10_10", type_ids_var_array_bitmask))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_InnerBitMaskHelper_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_bitmask = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_bitmask = 0x00000000;
            bool common_var_array_bitmask_ec {false};
            CommonStructMember common_var_array_bitmask {TypeObjectUtils::build_common_struct_member(member_id_var_array_bitmask, member_flags_var_array_bitmask, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bitmask, common_var_array_bitmask_ec))};
            if (!common_var_array_bitmask_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_bitmask member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_bitmask = "var_array_bitmask";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_bitmask;
            ann_custom_ArrayMultiDimensionBitMask.reset();
            CompleteMemberDetail detail_var_array_bitmask = TypeObjectUtils::build_complete_member_detail(name_var_array_bitmask, member_ann_builtin_var_array_bitmask, ann_custom_ArrayMultiDimensionBitMask);
            CompleteStructMember member_var_array_bitmask = TypeObjectUtils::build_complete_struct_member(common_var_array_bitmask, detail_var_array_bitmask);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionBitMask, member_var_array_bitmask);
        }
        CompleteStructType struct_type_ArrayMultiDimensionBitMask = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionBitMask, header_ArrayMultiDimensionBitMask, member_seq_ArrayMultiDimensionBitMask);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionBitMask, type_name_ArrayMultiDimensionBitMask.to_string(), type_ids_ArrayMultiDimensionBitMask))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionBitMask already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionAlias_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionAlias)
{

    ReturnCode_t return_code_ArrayMultiDimensionAlias {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionAlias =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionAlias", type_ids_ArrayMultiDimensionAlias);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionAlias)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionAlias = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionAlias = "ArrayMultiDimensionAlias";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionAlias;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionAlias;
        CompleteTypeDetail detail_ArrayMultiDimensionAlias = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionAlias, ann_custom_ArrayMultiDimensionAlias, type_name_ArrayMultiDimensionAlias.to_string());
        CompleteStructHeader header_ArrayMultiDimensionAlias;
        header_ArrayMultiDimensionAlias = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionAlias);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionAlias;
        {
            TypeIdentifierPair type_ids_var_array_alias;
            ReturnCode_t return_code_var_array_alias {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_alias =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_InnerAliasHelper_10_10_10", type_ids_var_array_alias);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_alias)
            {
                return_code_var_array_alias =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerAliasHelper", type_ids_var_array_alias);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_alias)
                {
                ::register_InnerAliasHelper_type_identifier(type_ids_var_array_alias);
                }
                bool element_identifier_anonymous_array_InnerAliasHelper_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_InnerAliasHelper_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_alias, element_identifier_anonymous_array_InnerAliasHelper_10_10_10_ec))};
                if (!element_identifier_anonymous_array_InnerAliasHelper_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_InnerAliasHelper_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_alias.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_InnerAliasHelper_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_InnerAliasHelper_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_InnerAliasHelper_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_InnerAliasHelper_10_10_10, element_flags_anonymous_array_InnerAliasHelper_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_InnerAliasHelper_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_InnerAliasHelper_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_InnerAliasHelper_10_10_10", type_ids_var_array_alias))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_InnerAliasHelper_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_alias = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_alias = 0x00000000;
            bool common_var_array_alias_ec {false};
            CommonStructMember common_var_array_alias {TypeObjectUtils::build_common_struct_member(member_id_var_array_alias, member_flags_var_array_alias, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_alias, common_var_array_alias_ec))};
            if (!common_var_array_alias_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_alias member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_alias = "var_array_alias";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_alias;
            ann_custom_ArrayMultiDimensionAlias.reset();
            CompleteMemberDetail detail_var_array_alias = TypeObjectUtils::build_complete_member_detail(name_var_array_alias, member_ann_builtin_var_array_alias, ann_custom_ArrayMultiDimensionAlias);
            CompleteStructMember member_var_array_alias = TypeObjectUtils::build_complete_struct_member(common_var_array_alias, detail_var_array_alias);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionAlias, member_var_array_alias);
        }
        CompleteStructType struct_type_ArrayMultiDimensionAlias = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionAlias, header_ArrayMultiDimensionAlias, member_seq_ArrayMultiDimensionAlias);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionAlias, type_name_ArrayMultiDimensionAlias.to_string(), type_ids_ArrayMultiDimensionAlias))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionAlias already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionSequence_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionSequence)
{

    ReturnCode_t return_code_ArrayMultiDimensionSequence {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionSequence =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionSequence", type_ids_ArrayMultiDimensionSequence);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionSequence)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionSequence = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionSequence = "ArrayMultiDimensionSequence";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionSequence;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionSequence;
        CompleteTypeDetail detail_ArrayMultiDimensionSequence = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionSequence, ann_custom_ArrayMultiDimensionSequence, type_name_ArrayMultiDimensionSequence.to_string());
        CompleteStructHeader header_ArrayMultiDimensionSequence;
        header_ArrayMultiDimensionSequence = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionSequence);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionSequence;
        {
            TypeIdentifierPair type_ids_var_array_sequence;
            ReturnCode_t return_code_var_array_sequence {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_sequence =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_anonymous_sequence_int32_t_unbounded_10_10_10", type_ids_var_array_sequence);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_sequence)
            {
                return_code_var_array_sequence =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_sequence_int32_t_unbounded", type_ids_var_array_sequence);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_sequence)
                {
                    return_code_var_array_sequence =
                        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                        "_int32_t", type_ids_var_array_sequence);

                    if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_sequence)
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                        return;
                    }
                    bool element_identifier_anonymous_sequence_int32_t_unbounded_ec {false};
                    TypeIdentifier* element_identifier_anonymous_sequence_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_sequence, element_identifier_anonymous_sequence_int32_t_unbounded_ec))};
                    if (!element_identifier_anonymous_sequence_int32_t_unbounded_ec)
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                        return;
                    }
                    EquivalenceKind equiv_kind_anonymous_sequence_int32_t_unbounded = EK_COMPLETE;
                    if (TK_NONE == type_ids_var_array_sequence.type_identifier2()._d())
                    {
                        equiv_kind_anonymous_sequence_int32_t_unbounded = EK_BOTH;
                    }
                    CollectionElementFlag element_flags_anonymous_sequence_int32_t_unbounded = 0;
                    PlainCollectionHeader header_anonymous_sequence_int32_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_int32_t_unbounded, element_flags_anonymous_sequence_int32_t_unbounded);
                    {
                        SBound bound = 0;
                        PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_int32_t_unbounded, bound,
                                    eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_int32_t_unbounded));
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_int32_t_unbounded", type_ids_var_array_sequence))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_sequence_int32_t_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_array_anonymous_sequence_int32_t_unbounded_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_anonymous_sequence_int32_t_unbounded_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_sequence, element_identifier_anonymous_array_anonymous_sequence_int32_t_unbounded_10_10_10_ec))};
                if (!element_identifier_anonymous_array_anonymous_sequence_int32_t_unbounded_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_anonymous_sequence_int32_t_unbounded_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_sequence.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_anonymous_sequence_int32_t_unbounded_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_anonymous_sequence_int32_t_unbounded_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_anonymous_sequence_int32_t_unbounded_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_anonymous_sequence_int32_t_unbounded_10_10_10, element_flags_anonymous_array_anonymous_sequence_int32_t_unbounded_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_anonymous_sequence_int32_t_unbounded_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_anonymous_sequence_int32_t_unbounded_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_anonymous_sequence_int32_t_unbounded_10_10_10", type_ids_var_array_sequence))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_anonymous_sequence_int32_t_unbounded_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_sequence = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_sequence = 0x00000000;
            bool common_var_array_sequence_ec {false};
            CommonStructMember common_var_array_sequence {TypeObjectUtils::build_common_struct_member(member_id_var_array_sequence, member_flags_var_array_sequence, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_sequence, common_var_array_sequence_ec))};
            if (!common_var_array_sequence_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_sequence member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_sequence = "var_array_sequence";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_sequence;
            ann_custom_ArrayMultiDimensionSequence.reset();
            CompleteMemberDetail detail_var_array_sequence = TypeObjectUtils::build_complete_member_detail(name_var_array_sequence, member_ann_builtin_var_array_sequence, ann_custom_ArrayMultiDimensionSequence);
            CompleteStructMember member_var_array_sequence = TypeObjectUtils::build_complete_struct_member(common_var_array_sequence, detail_var_array_sequence);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionSequence, member_var_array_sequence);
        }
        CompleteStructType struct_type_ArrayMultiDimensionSequence = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionSequence, header_ArrayMultiDimensionSequence, member_seq_ArrayMultiDimensionSequence);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionSequence, type_name_ArrayMultiDimensionSequence.to_string(), type_ids_ArrayMultiDimensionSequence))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionSequence already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionMap_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionMap)
{

    ReturnCode_t return_code_ArrayMultiDimensionMap {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionMap =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionMap", type_ids_ArrayMultiDimensionMap);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionMap)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionMap = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionMap = "ArrayMultiDimensionMap";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionMap;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionMap;
        CompleteTypeDetail detail_ArrayMultiDimensionMap = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionMap, ann_custom_ArrayMultiDimensionMap, type_name_ArrayMultiDimensionMap.to_string());
        CompleteStructHeader header_ArrayMultiDimensionMap;
        header_ArrayMultiDimensionMap = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionMap);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionMap;
        {
            TypeIdentifierPair type_ids_var_array_map;
            ReturnCode_t return_code_var_array_map {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_map =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10_10_10", type_ids_var_array_map);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_map)
            {
                return_code_var_array_map =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_map_int32_t_int32_t_unbounded", type_ids_var_array_map);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_map)
                {
                    return_code_var_array_map =
                        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                        "_int32_t", type_ids_var_array_map);

                    if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_map)
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                        return;
                    }
                    bool element_identifier_anonymous_map_int32_t_int32_t_unbounded_ec {false};
                    TypeIdentifier* element_identifier_anonymous_map_int32_t_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_map, element_identifier_anonymous_map_int32_t_int32_t_unbounded_ec))};
                    if (!element_identifier_anonymous_map_int32_t_int32_t_unbounded_ec)
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_int32_t_unbounded inconsistent element TypeIdentifier.");
                        return;
                    }
                    return_code_var_array_map =
                        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                        "_int32_t", type_ids_var_array_map);

                    if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_map)
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                        return;
                    }
                    bool key_identifier_anonymous_map_int32_t_int32_t_unbounded_ec {false};
                    TypeIdentifier* key_identifier_anonymous_map_int32_t_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_map, key_identifier_anonymous_map_int32_t_int32_t_unbounded_ec))};
                    if (!key_identifier_anonymous_map_int32_t_int32_t_unbounded_ec)
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_int32_t_unbounded inconsistent key TypeIdentifier.");
                        return;
                    }
                    EquivalenceKind equiv_kind_anonymous_map_int32_t_int32_t_unbounded = EK_BOTH;
                    if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d()) ||
                            (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                            (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                            (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->array_sdefn().header().equiv_kind()) ||
                            (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->array_ldefn().header().equiv_kind()) ||
                            (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_sdefn().header().equiv_kind())) ||
                            (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_ldefn().header().equiv_kind())))
                    {
                        equiv_kind_anonymous_map_int32_t_int32_t_unbounded = EK_COMPLETE;
                    }
                    CollectionElementFlag element_flags_anonymous_map_int32_t_int32_t_unbounded = 0;
                    CollectionElementFlag key_flags_anonymous_map_int32_t_int32_t_unbounded = 0;
                    PlainCollectionHeader header_anonymous_map_int32_t_int32_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_int32_t_unbounded, element_flags_anonymous_map_int32_t_int32_t_unbounded);
                    {
                        SBound bound = 0;
                        PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_int32_t_unbounded, bound,
                                    eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_int32_t_unbounded), key_flags_anonymous_map_int32_t_int32_t_unbounded,
                                    eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_int32_t_unbounded));
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_int32_t_unbounded", type_ids_var_array_map))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_map_int32_t_int32_t_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_map, element_identifier_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10_10_10_ec))};
                if (!element_identifier_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_map.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10_10_10, element_flags_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10_10_10", type_ids_var_array_map))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_anonymous_map_int32_t_int32_t_unbounded_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_map = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_map = 0x00000000;
            bool common_var_array_map_ec {false};
            CommonStructMember common_var_array_map {TypeObjectUtils::build_common_struct_member(member_id_var_array_map, member_flags_var_array_map, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_map, common_var_array_map_ec))};
            if (!common_var_array_map_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_map member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_map = "var_array_map";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_map;
            ann_custom_ArrayMultiDimensionMap.reset();
            CompleteMemberDetail detail_var_array_map = TypeObjectUtils::build_complete_member_detail(name_var_array_map, member_ann_builtin_var_array_map, ann_custom_ArrayMultiDimensionMap);
            CompleteStructMember member_var_array_map = TypeObjectUtils::build_complete_struct_member(common_var_array_map, detail_var_array_map);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionMap, member_var_array_map);
        }
        CompleteStructType struct_type_ArrayMultiDimensionMap = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionMap, header_ArrayMultiDimensionMap, member_seq_ArrayMultiDimensionMap);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionMap, type_name_ArrayMultiDimensionMap.to_string(), type_ids_ArrayMultiDimensionMap))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionMap already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionUnion_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionUnion)
{

    ReturnCode_t return_code_ArrayMultiDimensionUnion {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionUnion =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionUnion", type_ids_ArrayMultiDimensionUnion);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionUnion)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionUnion = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionUnion = "ArrayMultiDimensionUnion";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionUnion;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionUnion;
        CompleteTypeDetail detail_ArrayMultiDimensionUnion = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionUnion, ann_custom_ArrayMultiDimensionUnion, type_name_ArrayMultiDimensionUnion.to_string());
        CompleteStructHeader header_ArrayMultiDimensionUnion;
        header_ArrayMultiDimensionUnion = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionUnion);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionUnion;
        {
            TypeIdentifierPair type_ids_var_array_union;
            ReturnCode_t return_code_var_array_union {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_union =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_InnerUnionHelper_10_10_10", type_ids_var_array_union);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_union)
            {
                return_code_var_array_union =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerUnionHelper", type_ids_var_array_union);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_union)
                {
                ::register_InnerUnionHelper_type_identifier(type_ids_var_array_union);
                }
                bool element_identifier_anonymous_array_InnerUnionHelper_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_InnerUnionHelper_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_union, element_identifier_anonymous_array_InnerUnionHelper_10_10_10_ec))};
                if (!element_identifier_anonymous_array_InnerUnionHelper_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_InnerUnionHelper_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_union.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_InnerUnionHelper_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_InnerUnionHelper_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_InnerUnionHelper_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_InnerUnionHelper_10_10_10, element_flags_anonymous_array_InnerUnionHelper_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_InnerUnionHelper_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_InnerUnionHelper_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_InnerUnionHelper_10_10_10", type_ids_var_array_union))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_InnerUnionHelper_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_union = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_union = 0x00000000;
            bool common_var_array_union_ec {false};
            CommonStructMember common_var_array_union {TypeObjectUtils::build_common_struct_member(member_id_var_array_union, member_flags_var_array_union, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_union, common_var_array_union_ec))};
            if (!common_var_array_union_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_union member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_union = "var_array_union";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_union;
            ann_custom_ArrayMultiDimensionUnion.reset();
            CompleteMemberDetail detail_var_array_union = TypeObjectUtils::build_complete_member_detail(name_var_array_union, member_ann_builtin_var_array_union, ann_custom_ArrayMultiDimensionUnion);
            CompleteStructMember member_var_array_union = TypeObjectUtils::build_complete_struct_member(common_var_array_union, detail_var_array_union);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionUnion, member_var_array_union);
        }
        CompleteStructType struct_type_ArrayMultiDimensionUnion = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionUnion, header_ArrayMultiDimensionUnion, member_seq_ArrayMultiDimensionUnion);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionUnion, type_name_ArrayMultiDimensionUnion.to_string(), type_ids_ArrayMultiDimensionUnion))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionUnion already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionStructure_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionStructure)
{

    ReturnCode_t return_code_ArrayMultiDimensionStructure {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionStructure =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionStructure", type_ids_ArrayMultiDimensionStructure);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionStructure)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionStructure = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionStructure = "ArrayMultiDimensionStructure";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionStructure;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionStructure;
        CompleteTypeDetail detail_ArrayMultiDimensionStructure = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionStructure, ann_custom_ArrayMultiDimensionStructure, type_name_ArrayMultiDimensionStructure.to_string());
        CompleteStructHeader header_ArrayMultiDimensionStructure;
        header_ArrayMultiDimensionStructure = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionStructure);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionStructure;
        {
            TypeIdentifierPair type_ids_var_array_structure;
            ReturnCode_t return_code_var_array_structure {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_structure =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_InnerStructureHelper_10_10_10", type_ids_var_array_structure);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_structure)
            {
                return_code_var_array_structure =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerStructureHelper", type_ids_var_array_structure);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_structure)
                {
                ::register_InnerStructureHelper_type_identifier(type_ids_var_array_structure);
                }
                bool element_identifier_anonymous_array_InnerStructureHelper_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_InnerStructureHelper_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_structure, element_identifier_anonymous_array_InnerStructureHelper_10_10_10_ec))};
                if (!element_identifier_anonymous_array_InnerStructureHelper_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_InnerStructureHelper_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_structure.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_InnerStructureHelper_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_InnerStructureHelper_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_InnerStructureHelper_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_InnerStructureHelper_10_10_10, element_flags_anonymous_array_InnerStructureHelper_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_InnerStructureHelper_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_InnerStructureHelper_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_InnerStructureHelper_10_10_10", type_ids_var_array_structure))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_InnerStructureHelper_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_structure = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_structure = 0x00000000;
            bool common_var_array_structure_ec {false};
            CommonStructMember common_var_array_structure {TypeObjectUtils::build_common_struct_member(member_id_var_array_structure, member_flags_var_array_structure, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_structure, common_var_array_structure_ec))};
            if (!common_var_array_structure_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_structure member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_structure = "var_array_structure";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_structure;
            ann_custom_ArrayMultiDimensionStructure.reset();
            CompleteMemberDetail detail_var_array_structure = TypeObjectUtils::build_complete_member_detail(name_var_array_structure, member_ann_builtin_var_array_structure, ann_custom_ArrayMultiDimensionStructure);
            CompleteStructMember member_var_array_structure = TypeObjectUtils::build_complete_struct_member(common_var_array_structure, detail_var_array_structure);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionStructure, member_var_array_structure);
        }
        CompleteStructType struct_type_ArrayMultiDimensionStructure = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionStructure, header_ArrayMultiDimensionStructure, member_seq_ArrayMultiDimensionStructure);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionStructure, type_name_ArrayMultiDimensionStructure.to_string(), type_ids_ArrayMultiDimensionStructure))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionStructure already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionBitset_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionBitset)
{

    ReturnCode_t return_code_ArrayMultiDimensionBitset {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionBitset =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionBitset", type_ids_ArrayMultiDimensionBitset);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionBitset)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionBitset = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionBitset = "ArrayMultiDimensionBitset";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionBitset;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionBitset;
        CompleteTypeDetail detail_ArrayMultiDimensionBitset = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionBitset, ann_custom_ArrayMultiDimensionBitset, type_name_ArrayMultiDimensionBitset.to_string());
        CompleteStructHeader header_ArrayMultiDimensionBitset;
        header_ArrayMultiDimensionBitset = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionBitset);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionBitset;
        {
            TypeIdentifierPair type_ids_var_array_bitset;
            ReturnCode_t return_code_var_array_bitset {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_bitset =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_InnerBitsetHelper_10_10_10", type_ids_var_array_bitset);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bitset)
            {
                return_code_var_array_bitset =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerBitsetHelper", type_ids_var_array_bitset);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bitset)
                {
                ::register_InnerBitsetHelper_type_identifier(type_ids_var_array_bitset);
                }
                bool element_identifier_anonymous_array_InnerBitsetHelper_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_InnerBitsetHelper_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bitset, element_identifier_anonymous_array_InnerBitsetHelper_10_10_10_ec))};
                if (!element_identifier_anonymous_array_InnerBitsetHelper_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_InnerBitsetHelper_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_bitset.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_InnerBitsetHelper_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_InnerBitsetHelper_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_InnerBitsetHelper_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_InnerBitsetHelper_10_10_10, element_flags_anonymous_array_InnerBitsetHelper_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_InnerBitsetHelper_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_InnerBitsetHelper_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_InnerBitsetHelper_10_10_10", type_ids_var_array_bitset))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_InnerBitsetHelper_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_bitset = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_bitset = 0x00000000;
            bool common_var_array_bitset_ec {false};
            CommonStructMember common_var_array_bitset {TypeObjectUtils::build_common_struct_member(member_id_var_array_bitset, member_flags_var_array_bitset, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bitset, common_var_array_bitset_ec))};
            if (!common_var_array_bitset_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_bitset member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_bitset = "var_array_bitset";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_bitset;
            ann_custom_ArrayMultiDimensionBitset.reset();
            CompleteMemberDetail detail_var_array_bitset = TypeObjectUtils::build_complete_member_detail(name_var_array_bitset, member_ann_builtin_var_array_bitset, ann_custom_ArrayMultiDimensionBitset);
            CompleteStructMember member_var_array_bitset = TypeObjectUtils::build_complete_struct_member(common_var_array_bitset, detail_var_array_bitset);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionBitset, member_var_array_bitset);
        }
        CompleteStructType struct_type_ArrayMultiDimensionBitset = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionBitset, header_ArrayMultiDimensionBitset, member_seq_ArrayMultiDimensionBitset);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionBitset, type_name_ArrayMultiDimensionBitset.to_string(), type_ids_ArrayMultiDimensionBitset))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionBitset already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySingleDimensionLiteralsShort_type_identifier(
        TypeIdentifierPair& type_ids_ArraySingleDimensionLiteralsShort)
{

    ReturnCode_t return_code_ArraySingleDimensionLiteralsShort {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySingleDimensionLiteralsShort =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySingleDimensionLiteralsShort", type_ids_ArraySingleDimensionLiteralsShort);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySingleDimensionLiteralsShort)
    {
        StructTypeFlag struct_flags_ArraySingleDimensionLiteralsShort = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySingleDimensionLiteralsShort = "ArraySingleDimensionLiteralsShort";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySingleDimensionLiteralsShort;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySingleDimensionLiteralsShort;
        CompleteTypeDetail detail_ArraySingleDimensionLiteralsShort = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySingleDimensionLiteralsShort, ann_custom_ArraySingleDimensionLiteralsShort, type_name_ArraySingleDimensionLiteralsShort.to_string());
        CompleteStructHeader header_ArraySingleDimensionLiteralsShort;
        header_ArraySingleDimensionLiteralsShort = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySingleDimensionLiteralsShort);
        CompleteStructMemberSeq member_seq_ArraySingleDimensionLiteralsShort;
        {
            TypeIdentifierPair type_ids_var_array_short;
            ReturnCode_t return_code_var_array_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_5", type_ids_var_array_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_short)
            {
                return_code_var_array_short =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_array_short);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_short)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_short, element_identifier_anonymous_array_int16_t_5_ec))};
                if (!element_identifier_anonymous_array_int16_t_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_short.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_5 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_5, element_flags_anonymous_array_int16_t_5);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_5, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_5", type_ids_var_array_short))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_short = 0x00000000;
            bool common_var_array_short_ec {false};
            CommonStructMember common_var_array_short {TypeObjectUtils::build_common_struct_member(member_id_var_array_short, member_flags_var_array_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_short, common_var_array_short_ec))};
            if (!common_var_array_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_short = "var_array_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_short;
            ann_custom_ArraySingleDimensionLiteralsShort.reset();
            CompleteMemberDetail detail_var_array_short = TypeObjectUtils::build_complete_member_detail(name_var_array_short, member_ann_builtin_var_array_short, ann_custom_ArraySingleDimensionLiteralsShort);
            CompleteStructMember member_var_array_short = TypeObjectUtils::build_complete_struct_member(common_var_array_short, detail_var_array_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySingleDimensionLiteralsShort, member_var_array_short);
        }
        CompleteStructType struct_type_ArraySingleDimensionLiteralsShort = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySingleDimensionLiteralsShort, header_ArraySingleDimensionLiteralsShort, member_seq_ArraySingleDimensionLiteralsShort);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySingleDimensionLiteralsShort, type_name_ArraySingleDimensionLiteralsShort.to_string(), type_ids_ArraySingleDimensionLiteralsShort))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySingleDimensionLiteralsShort already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySingleDimensionLiteralsUnsignedShort_type_identifier(
        TypeIdentifierPair& type_ids_ArraySingleDimensionLiteralsUnsignedShort)
{

    ReturnCode_t return_code_ArraySingleDimensionLiteralsUnsignedShort {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySingleDimensionLiteralsUnsignedShort =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySingleDimensionLiteralsUnsignedShort", type_ids_ArraySingleDimensionLiteralsUnsignedShort);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySingleDimensionLiteralsUnsignedShort)
    {
        StructTypeFlag struct_flags_ArraySingleDimensionLiteralsUnsignedShort = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySingleDimensionLiteralsUnsignedShort = "ArraySingleDimensionLiteralsUnsignedShort";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySingleDimensionLiteralsUnsignedShort;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySingleDimensionLiteralsUnsignedShort;
        CompleteTypeDetail detail_ArraySingleDimensionLiteralsUnsignedShort = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySingleDimensionLiteralsUnsignedShort, ann_custom_ArraySingleDimensionLiteralsUnsignedShort, type_name_ArraySingleDimensionLiteralsUnsignedShort.to_string());
        CompleteStructHeader header_ArraySingleDimensionLiteralsUnsignedShort;
        header_ArraySingleDimensionLiteralsUnsignedShort = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySingleDimensionLiteralsUnsignedShort);
        CompleteStructMemberSeq member_seq_ArraySingleDimensionLiteralsUnsignedShort;
        {
            TypeIdentifierPair type_ids_var_array_ushort;
            ReturnCode_t return_code_var_array_ushort {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_ushort =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint16_t_10", type_ids_var_array_ushort);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_ushort)
            {
                return_code_var_array_ushort =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_array_ushort);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_ushort)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint16_t_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint16_t_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_ushort, element_identifier_anonymous_array_uint16_t_10_ec))};
                if (!element_identifier_anonymous_array_uint16_t_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint16_t_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_ushort.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint16_t_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint16_t_10 = 0;
                PlainCollectionHeader header_anonymous_array_uint16_t_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint16_t_10, element_flags_anonymous_array_uint16_t_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint16_t_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint16_t_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint16_t_10", type_ids_var_array_ushort))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint16_t_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_ushort = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_ushort = 0x00000000;
            bool common_var_array_ushort_ec {false};
            CommonStructMember common_var_array_ushort {TypeObjectUtils::build_common_struct_member(member_id_var_array_ushort, member_flags_var_array_ushort, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_ushort, common_var_array_ushort_ec))};
            if (!common_var_array_ushort_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_ushort member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_ushort = "var_array_ushort";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_ushort;
            ann_custom_ArraySingleDimensionLiteralsUnsignedShort.reset();
            CompleteMemberDetail detail_var_array_ushort = TypeObjectUtils::build_complete_member_detail(name_var_array_ushort, member_ann_builtin_var_array_ushort, ann_custom_ArraySingleDimensionLiteralsUnsignedShort);
            CompleteStructMember member_var_array_ushort = TypeObjectUtils::build_complete_struct_member(common_var_array_ushort, detail_var_array_ushort);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySingleDimensionLiteralsUnsignedShort, member_var_array_ushort);
        }
        CompleteStructType struct_type_ArraySingleDimensionLiteralsUnsignedShort = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySingleDimensionLiteralsUnsignedShort, header_ArraySingleDimensionLiteralsUnsignedShort, member_seq_ArraySingleDimensionLiteralsUnsignedShort);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySingleDimensionLiteralsUnsignedShort, type_name_ArraySingleDimensionLiteralsUnsignedShort.to_string(), type_ids_ArraySingleDimensionLiteralsUnsignedShort))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySingleDimensionLiteralsUnsignedShort already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySingleDimensionLiteralsLong_type_identifier(
        TypeIdentifierPair& type_ids_ArraySingleDimensionLiteralsLong)
{

    ReturnCode_t return_code_ArraySingleDimensionLiteralsLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySingleDimensionLiteralsLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySingleDimensionLiteralsLong", type_ids_ArraySingleDimensionLiteralsLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySingleDimensionLiteralsLong)
    {
        StructTypeFlag struct_flags_ArraySingleDimensionLiteralsLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySingleDimensionLiteralsLong = "ArraySingleDimensionLiteralsLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySingleDimensionLiteralsLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySingleDimensionLiteralsLong;
        CompleteTypeDetail detail_ArraySingleDimensionLiteralsLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySingleDimensionLiteralsLong, ann_custom_ArraySingleDimensionLiteralsLong, type_name_ArraySingleDimensionLiteralsLong.to_string());
        CompleteStructHeader header_ArraySingleDimensionLiteralsLong;
        header_ArraySingleDimensionLiteralsLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySingleDimensionLiteralsLong);
        CompleteStructMemberSeq member_seq_ArraySingleDimensionLiteralsLong;
        {
            TypeIdentifierPair type_ids_var_array_long;
            ReturnCode_t return_code_var_array_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int32_t_10", type_ids_var_array_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_long)
            {
                return_code_var_array_long =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_array_long);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_long)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int32_t_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int32_t_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_long, element_identifier_anonymous_array_int32_t_10_ec))};
                if (!element_identifier_anonymous_array_int32_t_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int32_t_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_long.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int32_t_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int32_t_10 = 0;
                PlainCollectionHeader header_anonymous_array_int32_t_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int32_t_10, element_flags_anonymous_array_int32_t_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int32_t_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int32_t_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int32_t_10", type_ids_var_array_long))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int32_t_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_long = 0x00000000;
            bool common_var_array_long_ec {false};
            CommonStructMember common_var_array_long {TypeObjectUtils::build_common_struct_member(member_id_var_array_long, member_flags_var_array_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_long, common_var_array_long_ec))};
            if (!common_var_array_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_long = "var_array_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_long;
            ann_custom_ArraySingleDimensionLiteralsLong.reset();
            CompleteMemberDetail detail_var_array_long = TypeObjectUtils::build_complete_member_detail(name_var_array_long, member_ann_builtin_var_array_long, ann_custom_ArraySingleDimensionLiteralsLong);
            CompleteStructMember member_var_array_long = TypeObjectUtils::build_complete_struct_member(common_var_array_long, detail_var_array_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySingleDimensionLiteralsLong, member_var_array_long);
        }
        CompleteStructType struct_type_ArraySingleDimensionLiteralsLong = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySingleDimensionLiteralsLong, header_ArraySingleDimensionLiteralsLong, member_seq_ArraySingleDimensionLiteralsLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySingleDimensionLiteralsLong, type_name_ArraySingleDimensionLiteralsLong.to_string(), type_ids_ArraySingleDimensionLiteralsLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySingleDimensionLiteralsLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySingleDimensionLiteralsUnsignedLong_type_identifier(
        TypeIdentifierPair& type_ids_ArraySingleDimensionLiteralsUnsignedLong)
{

    ReturnCode_t return_code_ArraySingleDimensionLiteralsUnsignedLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySingleDimensionLiteralsUnsignedLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySingleDimensionLiteralsUnsignedLong", type_ids_ArraySingleDimensionLiteralsUnsignedLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySingleDimensionLiteralsUnsignedLong)
    {
        StructTypeFlag struct_flags_ArraySingleDimensionLiteralsUnsignedLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySingleDimensionLiteralsUnsignedLong = "ArraySingleDimensionLiteralsUnsignedLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySingleDimensionLiteralsUnsignedLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySingleDimensionLiteralsUnsignedLong;
        CompleteTypeDetail detail_ArraySingleDimensionLiteralsUnsignedLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySingleDimensionLiteralsUnsignedLong, ann_custom_ArraySingleDimensionLiteralsUnsignedLong, type_name_ArraySingleDimensionLiteralsUnsignedLong.to_string());
        CompleteStructHeader header_ArraySingleDimensionLiteralsUnsignedLong;
        header_ArraySingleDimensionLiteralsUnsignedLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySingleDimensionLiteralsUnsignedLong);
        CompleteStructMemberSeq member_seq_ArraySingleDimensionLiteralsUnsignedLong;
        {
            TypeIdentifierPair type_ids_var_array_ulong;
            ReturnCode_t return_code_var_array_ulong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_ulong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint32_t_10", type_ids_var_array_ulong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_ulong)
            {
                return_code_var_array_ulong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_var_array_ulong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_ulong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint32_t_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint32_t_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_ulong, element_identifier_anonymous_array_uint32_t_10_ec))};
                if (!element_identifier_anonymous_array_uint32_t_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint32_t_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_ulong.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint32_t_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint32_t_10 = 0;
                PlainCollectionHeader header_anonymous_array_uint32_t_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint32_t_10, element_flags_anonymous_array_uint32_t_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint32_t_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint32_t_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint32_t_10", type_ids_var_array_ulong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint32_t_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_ulong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_ulong = 0x00000000;
            bool common_var_array_ulong_ec {false};
            CommonStructMember common_var_array_ulong {TypeObjectUtils::build_common_struct_member(member_id_var_array_ulong, member_flags_var_array_ulong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_ulong, common_var_array_ulong_ec))};
            if (!common_var_array_ulong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_ulong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_ulong = "var_array_ulong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_ulong;
            ann_custom_ArraySingleDimensionLiteralsUnsignedLong.reset();
            CompleteMemberDetail detail_var_array_ulong = TypeObjectUtils::build_complete_member_detail(name_var_array_ulong, member_ann_builtin_var_array_ulong, ann_custom_ArraySingleDimensionLiteralsUnsignedLong);
            CompleteStructMember member_var_array_ulong = TypeObjectUtils::build_complete_struct_member(common_var_array_ulong, detail_var_array_ulong);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySingleDimensionLiteralsUnsignedLong, member_var_array_ulong);
        }
        CompleteStructType struct_type_ArraySingleDimensionLiteralsUnsignedLong = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySingleDimensionLiteralsUnsignedLong, header_ArraySingleDimensionLiteralsUnsignedLong, member_seq_ArraySingleDimensionLiteralsUnsignedLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySingleDimensionLiteralsUnsignedLong, type_name_ArraySingleDimensionLiteralsUnsignedLong.to_string(), type_ids_ArraySingleDimensionLiteralsUnsignedLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySingleDimensionLiteralsUnsignedLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySingleDimensionLiteralsLongLong_type_identifier(
        TypeIdentifierPair& type_ids_ArraySingleDimensionLiteralsLongLong)
{

    ReturnCode_t return_code_ArraySingleDimensionLiteralsLongLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySingleDimensionLiteralsLongLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySingleDimensionLiteralsLongLong", type_ids_ArraySingleDimensionLiteralsLongLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySingleDimensionLiteralsLongLong)
    {
        StructTypeFlag struct_flags_ArraySingleDimensionLiteralsLongLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySingleDimensionLiteralsLongLong = "ArraySingleDimensionLiteralsLongLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySingleDimensionLiteralsLongLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySingleDimensionLiteralsLongLong;
        CompleteTypeDetail detail_ArraySingleDimensionLiteralsLongLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySingleDimensionLiteralsLongLong, ann_custom_ArraySingleDimensionLiteralsLongLong, type_name_ArraySingleDimensionLiteralsLongLong.to_string());
        CompleteStructHeader header_ArraySingleDimensionLiteralsLongLong;
        header_ArraySingleDimensionLiteralsLongLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySingleDimensionLiteralsLongLong);
        CompleteStructMemberSeq member_seq_ArraySingleDimensionLiteralsLongLong;
        {
            TypeIdentifierPair type_ids_var_array_longlong;
            ReturnCode_t return_code_var_array_longlong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_longlong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int64_t_10", type_ids_var_array_longlong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_longlong)
            {
                return_code_var_array_longlong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int64_t", type_ids_var_array_longlong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_longlong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int64_t_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int64_t_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_longlong, element_identifier_anonymous_array_int64_t_10_ec))};
                if (!element_identifier_anonymous_array_int64_t_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int64_t_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_longlong.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int64_t_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int64_t_10 = 0;
                PlainCollectionHeader header_anonymous_array_int64_t_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int64_t_10, element_flags_anonymous_array_int64_t_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int64_t_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int64_t_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int64_t_10", type_ids_var_array_longlong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int64_t_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_longlong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_longlong = 0x00000000;
            bool common_var_array_longlong_ec {false};
            CommonStructMember common_var_array_longlong {TypeObjectUtils::build_common_struct_member(member_id_var_array_longlong, member_flags_var_array_longlong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_longlong, common_var_array_longlong_ec))};
            if (!common_var_array_longlong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_longlong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_longlong = "var_array_longlong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_longlong;
            ann_custom_ArraySingleDimensionLiteralsLongLong.reset();
            CompleteMemberDetail detail_var_array_longlong = TypeObjectUtils::build_complete_member_detail(name_var_array_longlong, member_ann_builtin_var_array_longlong, ann_custom_ArraySingleDimensionLiteralsLongLong);
            CompleteStructMember member_var_array_longlong = TypeObjectUtils::build_complete_struct_member(common_var_array_longlong, detail_var_array_longlong);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySingleDimensionLiteralsLongLong, member_var_array_longlong);
        }
        CompleteStructType struct_type_ArraySingleDimensionLiteralsLongLong = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySingleDimensionLiteralsLongLong, header_ArraySingleDimensionLiteralsLongLong, member_seq_ArraySingleDimensionLiteralsLongLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySingleDimensionLiteralsLongLong, type_name_ArraySingleDimensionLiteralsLongLong.to_string(), type_ids_ArraySingleDimensionLiteralsLongLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySingleDimensionLiteralsLongLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySingleDimensionLiteralsUnsignedLongLong_type_identifier(
        TypeIdentifierPair& type_ids_ArraySingleDimensionLiteralsUnsignedLongLong)
{

    ReturnCode_t return_code_ArraySingleDimensionLiteralsUnsignedLongLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySingleDimensionLiteralsUnsignedLongLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySingleDimensionLiteralsUnsignedLongLong", type_ids_ArraySingleDimensionLiteralsUnsignedLongLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySingleDimensionLiteralsUnsignedLongLong)
    {
        StructTypeFlag struct_flags_ArraySingleDimensionLiteralsUnsignedLongLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySingleDimensionLiteralsUnsignedLongLong = "ArraySingleDimensionLiteralsUnsignedLongLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySingleDimensionLiteralsUnsignedLongLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySingleDimensionLiteralsUnsignedLongLong;
        CompleteTypeDetail detail_ArraySingleDimensionLiteralsUnsignedLongLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySingleDimensionLiteralsUnsignedLongLong, ann_custom_ArraySingleDimensionLiteralsUnsignedLongLong, type_name_ArraySingleDimensionLiteralsUnsignedLongLong.to_string());
        CompleteStructHeader header_ArraySingleDimensionLiteralsUnsignedLongLong;
        header_ArraySingleDimensionLiteralsUnsignedLongLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySingleDimensionLiteralsUnsignedLongLong);
        CompleteStructMemberSeq member_seq_ArraySingleDimensionLiteralsUnsignedLongLong;
        {
            TypeIdentifierPair type_ids_var_array_ulonglong;
            ReturnCode_t return_code_var_array_ulonglong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_ulonglong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint64_t_10", type_ids_var_array_ulonglong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_ulonglong)
            {
                return_code_var_array_ulonglong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint64_t", type_ids_var_array_ulonglong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_ulonglong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint64_t_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint64_t_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_ulonglong, element_identifier_anonymous_array_uint64_t_10_ec))};
                if (!element_identifier_anonymous_array_uint64_t_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint64_t_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_ulonglong.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint64_t_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint64_t_10 = 0;
                PlainCollectionHeader header_anonymous_array_uint64_t_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint64_t_10, element_flags_anonymous_array_uint64_t_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint64_t_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint64_t_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint64_t_10", type_ids_var_array_ulonglong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint64_t_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_ulonglong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_ulonglong = 0x00000000;
            bool common_var_array_ulonglong_ec {false};
            CommonStructMember common_var_array_ulonglong {TypeObjectUtils::build_common_struct_member(member_id_var_array_ulonglong, member_flags_var_array_ulonglong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_ulonglong, common_var_array_ulonglong_ec))};
            if (!common_var_array_ulonglong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_ulonglong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_ulonglong = "var_array_ulonglong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_ulonglong;
            ann_custom_ArraySingleDimensionLiteralsUnsignedLongLong.reset();
            CompleteMemberDetail detail_var_array_ulonglong = TypeObjectUtils::build_complete_member_detail(name_var_array_ulonglong, member_ann_builtin_var_array_ulonglong, ann_custom_ArraySingleDimensionLiteralsUnsignedLongLong);
            CompleteStructMember member_var_array_ulonglong = TypeObjectUtils::build_complete_struct_member(common_var_array_ulonglong, detail_var_array_ulonglong);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySingleDimensionLiteralsUnsignedLongLong, member_var_array_ulonglong);
        }
        CompleteStructType struct_type_ArraySingleDimensionLiteralsUnsignedLongLong = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySingleDimensionLiteralsUnsignedLongLong, header_ArraySingleDimensionLiteralsUnsignedLongLong, member_seq_ArraySingleDimensionLiteralsUnsignedLongLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySingleDimensionLiteralsUnsignedLongLong, type_name_ArraySingleDimensionLiteralsUnsignedLongLong.to_string(), type_ids_ArraySingleDimensionLiteralsUnsignedLongLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySingleDimensionLiteralsUnsignedLongLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySingleDimensionLiteralsFloat_type_identifier(
        TypeIdentifierPair& type_ids_ArraySingleDimensionLiteralsFloat)
{

    ReturnCode_t return_code_ArraySingleDimensionLiteralsFloat {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySingleDimensionLiteralsFloat =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySingleDimensionLiteralsFloat", type_ids_ArraySingleDimensionLiteralsFloat);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySingleDimensionLiteralsFloat)
    {
        StructTypeFlag struct_flags_ArraySingleDimensionLiteralsFloat = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySingleDimensionLiteralsFloat = "ArraySingleDimensionLiteralsFloat";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySingleDimensionLiteralsFloat;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySingleDimensionLiteralsFloat;
        CompleteTypeDetail detail_ArraySingleDimensionLiteralsFloat = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySingleDimensionLiteralsFloat, ann_custom_ArraySingleDimensionLiteralsFloat, type_name_ArraySingleDimensionLiteralsFloat.to_string());
        CompleteStructHeader header_ArraySingleDimensionLiteralsFloat;
        header_ArraySingleDimensionLiteralsFloat = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySingleDimensionLiteralsFloat);
        CompleteStructMemberSeq member_seq_ArraySingleDimensionLiteralsFloat;
        {
            TypeIdentifierPair type_ids_var_array_float;
            ReturnCode_t return_code_var_array_float {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_float =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_float_5", type_ids_var_array_float);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_float)
            {
                return_code_var_array_float =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_float", type_ids_var_array_float);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_float)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_float_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_float_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_float, element_identifier_anonymous_array_float_5_ec))};
                if (!element_identifier_anonymous_array_float_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_float_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_float.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_float_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_float_5 = 0;
                PlainCollectionHeader header_anonymous_array_float_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_float_5, element_flags_anonymous_array_float_5);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_float_5, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_float_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_float_5", type_ids_var_array_float))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_float_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_float = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_float = 0x00000000;
            bool common_var_array_float_ec {false};
            CommonStructMember common_var_array_float {TypeObjectUtils::build_common_struct_member(member_id_var_array_float, member_flags_var_array_float, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_float, common_var_array_float_ec))};
            if (!common_var_array_float_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_float member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_float = "var_array_float";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_float;
            ann_custom_ArraySingleDimensionLiteralsFloat.reset();
            CompleteMemberDetail detail_var_array_float = TypeObjectUtils::build_complete_member_detail(name_var_array_float, member_ann_builtin_var_array_float, ann_custom_ArraySingleDimensionLiteralsFloat);
            CompleteStructMember member_var_array_float = TypeObjectUtils::build_complete_struct_member(common_var_array_float, detail_var_array_float);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySingleDimensionLiteralsFloat, member_var_array_float);
        }
        CompleteStructType struct_type_ArraySingleDimensionLiteralsFloat = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySingleDimensionLiteralsFloat, header_ArraySingleDimensionLiteralsFloat, member_seq_ArraySingleDimensionLiteralsFloat);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySingleDimensionLiteralsFloat, type_name_ArraySingleDimensionLiteralsFloat.to_string(), type_ids_ArraySingleDimensionLiteralsFloat))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySingleDimensionLiteralsFloat already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySingleDimensionLiteralsDouble_type_identifier(
        TypeIdentifierPair& type_ids_ArraySingleDimensionLiteralsDouble)
{

    ReturnCode_t return_code_ArraySingleDimensionLiteralsDouble {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySingleDimensionLiteralsDouble =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySingleDimensionLiteralsDouble", type_ids_ArraySingleDimensionLiteralsDouble);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySingleDimensionLiteralsDouble)
    {
        StructTypeFlag struct_flags_ArraySingleDimensionLiteralsDouble = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySingleDimensionLiteralsDouble = "ArraySingleDimensionLiteralsDouble";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySingleDimensionLiteralsDouble;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySingleDimensionLiteralsDouble;
        CompleteTypeDetail detail_ArraySingleDimensionLiteralsDouble = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySingleDimensionLiteralsDouble, ann_custom_ArraySingleDimensionLiteralsDouble, type_name_ArraySingleDimensionLiteralsDouble.to_string());
        CompleteStructHeader header_ArraySingleDimensionLiteralsDouble;
        header_ArraySingleDimensionLiteralsDouble = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySingleDimensionLiteralsDouble);
        CompleteStructMemberSeq member_seq_ArraySingleDimensionLiteralsDouble;
        {
            TypeIdentifierPair type_ids_var_array_double;
            ReturnCode_t return_code_var_array_double {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_double =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_double_10", type_ids_var_array_double);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_double)
            {
                return_code_var_array_double =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_double", type_ids_var_array_double);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_double)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_double_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_double_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_double, element_identifier_anonymous_array_double_10_ec))};
                if (!element_identifier_anonymous_array_double_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_double_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_double.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_double_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_double_10 = 0;
                PlainCollectionHeader header_anonymous_array_double_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_double_10, element_flags_anonymous_array_double_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_double_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_double_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_double_10", type_ids_var_array_double))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_double_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_double = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_double = 0x00000000;
            bool common_var_array_double_ec {false};
            CommonStructMember common_var_array_double {TypeObjectUtils::build_common_struct_member(member_id_var_array_double, member_flags_var_array_double, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_double, common_var_array_double_ec))};
            if (!common_var_array_double_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_double member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_double = "var_array_double";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_double;
            ann_custom_ArraySingleDimensionLiteralsDouble.reset();
            CompleteMemberDetail detail_var_array_double = TypeObjectUtils::build_complete_member_detail(name_var_array_double, member_ann_builtin_var_array_double, ann_custom_ArraySingleDimensionLiteralsDouble);
            CompleteStructMember member_var_array_double = TypeObjectUtils::build_complete_struct_member(common_var_array_double, detail_var_array_double);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySingleDimensionLiteralsDouble, member_var_array_double);
        }
        CompleteStructType struct_type_ArraySingleDimensionLiteralsDouble = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySingleDimensionLiteralsDouble, header_ArraySingleDimensionLiteralsDouble, member_seq_ArraySingleDimensionLiteralsDouble);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySingleDimensionLiteralsDouble, type_name_ArraySingleDimensionLiteralsDouble.to_string(), type_ids_ArraySingleDimensionLiteralsDouble))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySingleDimensionLiteralsDouble already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySingleDimensionLiteralsLongDouble_type_identifier(
        TypeIdentifierPair& type_ids_ArraySingleDimensionLiteralsLongDouble)
{

    ReturnCode_t return_code_ArraySingleDimensionLiteralsLongDouble {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySingleDimensionLiteralsLongDouble =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySingleDimensionLiteralsLongDouble", type_ids_ArraySingleDimensionLiteralsLongDouble);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySingleDimensionLiteralsLongDouble)
    {
        StructTypeFlag struct_flags_ArraySingleDimensionLiteralsLongDouble = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySingleDimensionLiteralsLongDouble = "ArraySingleDimensionLiteralsLongDouble";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySingleDimensionLiteralsLongDouble;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySingleDimensionLiteralsLongDouble;
        CompleteTypeDetail detail_ArraySingleDimensionLiteralsLongDouble = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySingleDimensionLiteralsLongDouble, ann_custom_ArraySingleDimensionLiteralsLongDouble, type_name_ArraySingleDimensionLiteralsLongDouble.to_string());
        CompleteStructHeader header_ArraySingleDimensionLiteralsLongDouble;
        header_ArraySingleDimensionLiteralsLongDouble = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySingleDimensionLiteralsLongDouble);
        CompleteStructMemberSeq member_seq_ArraySingleDimensionLiteralsLongDouble;
        {
            TypeIdentifierPair type_ids_var_array_longdouble;
            ReturnCode_t return_code_var_array_longdouble {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_longdouble =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_longdouble_10", type_ids_var_array_longdouble);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_longdouble)
            {
                return_code_var_array_longdouble =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_longdouble", type_ids_var_array_longdouble);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_longdouble)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_longdouble_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_longdouble_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_longdouble, element_identifier_anonymous_array_longdouble_10_ec))};
                if (!element_identifier_anonymous_array_longdouble_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_longdouble_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_longdouble.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_longdouble_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_longdouble_10 = 0;
                PlainCollectionHeader header_anonymous_array_longdouble_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_longdouble_10, element_flags_anonymous_array_longdouble_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_longdouble_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_longdouble_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_longdouble_10", type_ids_var_array_longdouble))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_longdouble_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_longdouble = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_longdouble = 0x00000000;
            bool common_var_array_longdouble_ec {false};
            CommonStructMember common_var_array_longdouble {TypeObjectUtils::build_common_struct_member(member_id_var_array_longdouble, member_flags_var_array_longdouble, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_longdouble, common_var_array_longdouble_ec))};
            if (!common_var_array_longdouble_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_longdouble member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_longdouble = "var_array_longdouble";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_longdouble;
            ann_custom_ArraySingleDimensionLiteralsLongDouble.reset();
            CompleteMemberDetail detail_var_array_longdouble = TypeObjectUtils::build_complete_member_detail(name_var_array_longdouble, member_ann_builtin_var_array_longdouble, ann_custom_ArraySingleDimensionLiteralsLongDouble);
            CompleteStructMember member_var_array_longdouble = TypeObjectUtils::build_complete_struct_member(common_var_array_longdouble, detail_var_array_longdouble);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySingleDimensionLiteralsLongDouble, member_var_array_longdouble);
        }
        CompleteStructType struct_type_ArraySingleDimensionLiteralsLongDouble = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySingleDimensionLiteralsLongDouble, header_ArraySingleDimensionLiteralsLongDouble, member_seq_ArraySingleDimensionLiteralsLongDouble);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySingleDimensionLiteralsLongDouble, type_name_ArraySingleDimensionLiteralsLongDouble.to_string(), type_ids_ArraySingleDimensionLiteralsLongDouble))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySingleDimensionLiteralsLongDouble already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySingleDimensionLiteralsBoolean_type_identifier(
        TypeIdentifierPair& type_ids_ArraySingleDimensionLiteralsBoolean)
{

    ReturnCode_t return_code_ArraySingleDimensionLiteralsBoolean {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySingleDimensionLiteralsBoolean =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySingleDimensionLiteralsBoolean", type_ids_ArraySingleDimensionLiteralsBoolean);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySingleDimensionLiteralsBoolean)
    {
        StructTypeFlag struct_flags_ArraySingleDimensionLiteralsBoolean = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySingleDimensionLiteralsBoolean = "ArraySingleDimensionLiteralsBoolean";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySingleDimensionLiteralsBoolean;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySingleDimensionLiteralsBoolean;
        CompleteTypeDetail detail_ArraySingleDimensionLiteralsBoolean = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySingleDimensionLiteralsBoolean, ann_custom_ArraySingleDimensionLiteralsBoolean, type_name_ArraySingleDimensionLiteralsBoolean.to_string());
        CompleteStructHeader header_ArraySingleDimensionLiteralsBoolean;
        header_ArraySingleDimensionLiteralsBoolean = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySingleDimensionLiteralsBoolean);
        CompleteStructMemberSeq member_seq_ArraySingleDimensionLiteralsBoolean;
        {
            TypeIdentifierPair type_ids_var_array_boolean;
            ReturnCode_t return_code_var_array_boolean {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_boolean =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_bool_5", type_ids_var_array_boolean);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_boolean)
            {
                return_code_var_array_boolean =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_bool", type_ids_var_array_boolean);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_boolean)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_bool_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_bool_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_boolean, element_identifier_anonymous_array_bool_5_ec))};
                if (!element_identifier_anonymous_array_bool_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_bool_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_boolean.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_bool_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_bool_5 = 0;
                PlainCollectionHeader header_anonymous_array_bool_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_bool_5, element_flags_anonymous_array_bool_5);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_bool_5, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_bool_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_bool_5", type_ids_var_array_boolean))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_bool_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_boolean = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_boolean = 0x00000000;
            bool common_var_array_boolean_ec {false};
            CommonStructMember common_var_array_boolean {TypeObjectUtils::build_common_struct_member(member_id_var_array_boolean, member_flags_var_array_boolean, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_boolean, common_var_array_boolean_ec))};
            if (!common_var_array_boolean_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_boolean member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_boolean = "var_array_boolean";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_boolean;
            ann_custom_ArraySingleDimensionLiteralsBoolean.reset();
            CompleteMemberDetail detail_var_array_boolean = TypeObjectUtils::build_complete_member_detail(name_var_array_boolean, member_ann_builtin_var_array_boolean, ann_custom_ArraySingleDimensionLiteralsBoolean);
            CompleteStructMember member_var_array_boolean = TypeObjectUtils::build_complete_struct_member(common_var_array_boolean, detail_var_array_boolean);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySingleDimensionLiteralsBoolean, member_var_array_boolean);
        }
        CompleteStructType struct_type_ArraySingleDimensionLiteralsBoolean = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySingleDimensionLiteralsBoolean, header_ArraySingleDimensionLiteralsBoolean, member_seq_ArraySingleDimensionLiteralsBoolean);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySingleDimensionLiteralsBoolean, type_name_ArraySingleDimensionLiteralsBoolean.to_string(), type_ids_ArraySingleDimensionLiteralsBoolean))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySingleDimensionLiteralsBoolean already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySingleDimensionLiteralsOctet_type_identifier(
        TypeIdentifierPair& type_ids_ArraySingleDimensionLiteralsOctet)
{

    ReturnCode_t return_code_ArraySingleDimensionLiteralsOctet {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySingleDimensionLiteralsOctet =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySingleDimensionLiteralsOctet", type_ids_ArraySingleDimensionLiteralsOctet);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySingleDimensionLiteralsOctet)
    {
        StructTypeFlag struct_flags_ArraySingleDimensionLiteralsOctet = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySingleDimensionLiteralsOctet = "ArraySingleDimensionLiteralsOctet";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySingleDimensionLiteralsOctet;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySingleDimensionLiteralsOctet;
        CompleteTypeDetail detail_ArraySingleDimensionLiteralsOctet = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySingleDimensionLiteralsOctet, ann_custom_ArraySingleDimensionLiteralsOctet, type_name_ArraySingleDimensionLiteralsOctet.to_string());
        CompleteStructHeader header_ArraySingleDimensionLiteralsOctet;
        header_ArraySingleDimensionLiteralsOctet = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySingleDimensionLiteralsOctet);
        CompleteStructMemberSeq member_seq_ArraySingleDimensionLiteralsOctet;
        {
            TypeIdentifierPair type_ids_var_array_octet;
            ReturnCode_t return_code_var_array_octet {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_octet =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_byte_10", type_ids_var_array_octet);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_octet)
            {
                return_code_var_array_octet =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_byte", type_ids_var_array_octet);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_octet)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_byte_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_byte_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_octet, element_identifier_anonymous_array_byte_10_ec))};
                if (!element_identifier_anonymous_array_byte_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_byte_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_octet.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_byte_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_byte_10 = 0;
                PlainCollectionHeader header_anonymous_array_byte_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_byte_10, element_flags_anonymous_array_byte_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_byte_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_byte_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_byte_10", type_ids_var_array_octet))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_byte_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_octet = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_octet = 0x00000000;
            bool common_var_array_octet_ec {false};
            CommonStructMember common_var_array_octet {TypeObjectUtils::build_common_struct_member(member_id_var_array_octet, member_flags_var_array_octet, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_octet, common_var_array_octet_ec))};
            if (!common_var_array_octet_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_octet member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_octet = "var_array_octet";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_octet;
            ann_custom_ArraySingleDimensionLiteralsOctet.reset();
            CompleteMemberDetail detail_var_array_octet = TypeObjectUtils::build_complete_member_detail(name_var_array_octet, member_ann_builtin_var_array_octet, ann_custom_ArraySingleDimensionLiteralsOctet);
            CompleteStructMember member_var_array_octet = TypeObjectUtils::build_complete_struct_member(common_var_array_octet, detail_var_array_octet);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySingleDimensionLiteralsOctet, member_var_array_octet);
        }
        CompleteStructType struct_type_ArraySingleDimensionLiteralsOctet = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySingleDimensionLiteralsOctet, header_ArraySingleDimensionLiteralsOctet, member_seq_ArraySingleDimensionLiteralsOctet);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySingleDimensionLiteralsOctet, type_name_ArraySingleDimensionLiteralsOctet.to_string(), type_ids_ArraySingleDimensionLiteralsOctet))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySingleDimensionLiteralsOctet already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySingleDimensionLiteralsChar_type_identifier(
        TypeIdentifierPair& type_ids_ArraySingleDimensionLiteralsChar)
{

    ReturnCode_t return_code_ArraySingleDimensionLiteralsChar {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySingleDimensionLiteralsChar =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySingleDimensionLiteralsChar", type_ids_ArraySingleDimensionLiteralsChar);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySingleDimensionLiteralsChar)
    {
        StructTypeFlag struct_flags_ArraySingleDimensionLiteralsChar = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySingleDimensionLiteralsChar = "ArraySingleDimensionLiteralsChar";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySingleDimensionLiteralsChar;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySingleDimensionLiteralsChar;
        CompleteTypeDetail detail_ArraySingleDimensionLiteralsChar = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySingleDimensionLiteralsChar, ann_custom_ArraySingleDimensionLiteralsChar, type_name_ArraySingleDimensionLiteralsChar.to_string());
        CompleteStructHeader header_ArraySingleDimensionLiteralsChar;
        header_ArraySingleDimensionLiteralsChar = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySingleDimensionLiteralsChar);
        CompleteStructMemberSeq member_seq_ArraySingleDimensionLiteralsChar;
        {
            TypeIdentifierPair type_ids_var_array_char;
            ReturnCode_t return_code_var_array_char {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_char =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_char_5", type_ids_var_array_char);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_char)
            {
                return_code_var_array_char =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_char", type_ids_var_array_char);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_char)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_char_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_char_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_char, element_identifier_anonymous_array_char_5_ec))};
                if (!element_identifier_anonymous_array_char_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_char_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_char.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_char_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_char_5 = 0;
                PlainCollectionHeader header_anonymous_array_char_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_char_5, element_flags_anonymous_array_char_5);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_char_5, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_char_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_char_5", type_ids_var_array_char))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_char_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_char = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_char = 0x00000000;
            bool common_var_array_char_ec {false};
            CommonStructMember common_var_array_char {TypeObjectUtils::build_common_struct_member(member_id_var_array_char, member_flags_var_array_char, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_char, common_var_array_char_ec))};
            if (!common_var_array_char_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_char member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_char = "var_array_char";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_char;
            ann_custom_ArraySingleDimensionLiteralsChar.reset();
            CompleteMemberDetail detail_var_array_char = TypeObjectUtils::build_complete_member_detail(name_var_array_char, member_ann_builtin_var_array_char, ann_custom_ArraySingleDimensionLiteralsChar);
            CompleteStructMember member_var_array_char = TypeObjectUtils::build_complete_struct_member(common_var_array_char, detail_var_array_char);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySingleDimensionLiteralsChar, member_var_array_char);
        }
        CompleteStructType struct_type_ArraySingleDimensionLiteralsChar = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySingleDimensionLiteralsChar, header_ArraySingleDimensionLiteralsChar, member_seq_ArraySingleDimensionLiteralsChar);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySingleDimensionLiteralsChar, type_name_ArraySingleDimensionLiteralsChar.to_string(), type_ids_ArraySingleDimensionLiteralsChar))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySingleDimensionLiteralsChar already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySingleDimensionLiteralsWChar_type_identifier(
        TypeIdentifierPair& type_ids_ArraySingleDimensionLiteralsWChar)
{

    ReturnCode_t return_code_ArraySingleDimensionLiteralsWChar {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySingleDimensionLiteralsWChar =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySingleDimensionLiteralsWChar", type_ids_ArraySingleDimensionLiteralsWChar);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySingleDimensionLiteralsWChar)
    {
        StructTypeFlag struct_flags_ArraySingleDimensionLiteralsWChar = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySingleDimensionLiteralsWChar = "ArraySingleDimensionLiteralsWChar";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySingleDimensionLiteralsWChar;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySingleDimensionLiteralsWChar;
        CompleteTypeDetail detail_ArraySingleDimensionLiteralsWChar = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySingleDimensionLiteralsWChar, ann_custom_ArraySingleDimensionLiteralsWChar, type_name_ArraySingleDimensionLiteralsWChar.to_string());
        CompleteStructHeader header_ArraySingleDimensionLiteralsWChar;
        header_ArraySingleDimensionLiteralsWChar = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySingleDimensionLiteralsWChar);
        CompleteStructMemberSeq member_seq_ArraySingleDimensionLiteralsWChar;
        {
            TypeIdentifierPair type_ids_var_array_wchar;
            ReturnCode_t return_code_var_array_wchar {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_wchar =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_wchar_t_10", type_ids_var_array_wchar);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_wchar)
            {
                return_code_var_array_wchar =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_wchar_t", type_ids_var_array_wchar);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_wchar)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_wchar_t_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_wchar_t_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_wchar, element_identifier_anonymous_array_wchar_t_10_ec))};
                if (!element_identifier_anonymous_array_wchar_t_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_wchar_t_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_wchar.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_wchar_t_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_wchar_t_10 = 0;
                PlainCollectionHeader header_anonymous_array_wchar_t_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_wchar_t_10, element_flags_anonymous_array_wchar_t_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_wchar_t_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_wchar_t_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_wchar_t_10", type_ids_var_array_wchar))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_wchar_t_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_wchar = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_wchar = 0x00000000;
            bool common_var_array_wchar_ec {false};
            CommonStructMember common_var_array_wchar {TypeObjectUtils::build_common_struct_member(member_id_var_array_wchar, member_flags_var_array_wchar, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_wchar, common_var_array_wchar_ec))};
            if (!common_var_array_wchar_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_wchar member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_wchar = "var_array_wchar";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_wchar;
            ann_custom_ArraySingleDimensionLiteralsWChar.reset();
            CompleteMemberDetail detail_var_array_wchar = TypeObjectUtils::build_complete_member_detail(name_var_array_wchar, member_ann_builtin_var_array_wchar, ann_custom_ArraySingleDimensionLiteralsWChar);
            CompleteStructMember member_var_array_wchar = TypeObjectUtils::build_complete_struct_member(common_var_array_wchar, detail_var_array_wchar);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySingleDimensionLiteralsWChar, member_var_array_wchar);
        }
        CompleteStructType struct_type_ArraySingleDimensionLiteralsWChar = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySingleDimensionLiteralsWChar, header_ArraySingleDimensionLiteralsWChar, member_seq_ArraySingleDimensionLiteralsWChar);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySingleDimensionLiteralsWChar, type_name_ArraySingleDimensionLiteralsWChar.to_string(), type_ids_ArraySingleDimensionLiteralsWChar))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySingleDimensionLiteralsWChar already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySingleDimensionLiteralsString_type_identifier(
        TypeIdentifierPair& type_ids_ArraySingleDimensionLiteralsString)
{

    ReturnCode_t return_code_ArraySingleDimensionLiteralsString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySingleDimensionLiteralsString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySingleDimensionLiteralsString", type_ids_ArraySingleDimensionLiteralsString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySingleDimensionLiteralsString)
    {
        StructTypeFlag struct_flags_ArraySingleDimensionLiteralsString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySingleDimensionLiteralsString = "ArraySingleDimensionLiteralsString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySingleDimensionLiteralsString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySingleDimensionLiteralsString;
        CompleteTypeDetail detail_ArraySingleDimensionLiteralsString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySingleDimensionLiteralsString, ann_custom_ArraySingleDimensionLiteralsString, type_name_ArraySingleDimensionLiteralsString.to_string());
        CompleteStructHeader header_ArraySingleDimensionLiteralsString;
        header_ArraySingleDimensionLiteralsString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySingleDimensionLiteralsString);
        CompleteStructMemberSeq member_seq_ArraySingleDimensionLiteralsString;
        {
            TypeIdentifierPair type_ids_var_array_string;
            ReturnCode_t return_code_var_array_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_anonymous_string_unbounded_5", type_ids_var_array_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_string)
            {
                return_code_var_array_string =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_string_unbounded", type_ids_var_array_string);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_string)
                {
                    {
                        SBound bound = 0;
                        StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                                "anonymous_string_unbounded", type_ids_var_array_string))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_array_anonymous_string_unbounded_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_anonymous_string_unbounded_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_string, element_identifier_anonymous_array_anonymous_string_unbounded_5_ec))};
                if (!element_identifier_anonymous_array_anonymous_string_unbounded_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_anonymous_string_unbounded_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_string.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_anonymous_string_unbounded_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_anonymous_string_unbounded_5 = 0;
                PlainCollectionHeader header_anonymous_array_anonymous_string_unbounded_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_anonymous_string_unbounded_5, element_flags_anonymous_array_anonymous_string_unbounded_5);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_anonymous_string_unbounded_5, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_anonymous_string_unbounded_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_anonymous_string_unbounded_5", type_ids_var_array_string))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_anonymous_string_unbounded_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_string = 0x00000000;
            bool common_var_array_string_ec {false};
            CommonStructMember common_var_array_string {TypeObjectUtils::build_common_struct_member(member_id_var_array_string, member_flags_var_array_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_string, common_var_array_string_ec))};
            if (!common_var_array_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_string = "var_array_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_string;
            ann_custom_ArraySingleDimensionLiteralsString.reset();
            CompleteMemberDetail detail_var_array_string = TypeObjectUtils::build_complete_member_detail(name_var_array_string, member_ann_builtin_var_array_string, ann_custom_ArraySingleDimensionLiteralsString);
            CompleteStructMember member_var_array_string = TypeObjectUtils::build_complete_struct_member(common_var_array_string, detail_var_array_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySingleDimensionLiteralsString, member_var_array_string);
        }
        CompleteStructType struct_type_ArraySingleDimensionLiteralsString = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySingleDimensionLiteralsString, header_ArraySingleDimensionLiteralsString, member_seq_ArraySingleDimensionLiteralsString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySingleDimensionLiteralsString, type_name_ArraySingleDimensionLiteralsString.to_string(), type_ids_ArraySingleDimensionLiteralsString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySingleDimensionLiteralsString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySingleDimensionLiteralsWString_type_identifier(
        TypeIdentifierPair& type_ids_ArraySingleDimensionLiteralsWString)
{

    ReturnCode_t return_code_ArraySingleDimensionLiteralsWString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySingleDimensionLiteralsWString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySingleDimensionLiteralsWString", type_ids_ArraySingleDimensionLiteralsWString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySingleDimensionLiteralsWString)
    {
        StructTypeFlag struct_flags_ArraySingleDimensionLiteralsWString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySingleDimensionLiteralsWString = "ArraySingleDimensionLiteralsWString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySingleDimensionLiteralsWString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySingleDimensionLiteralsWString;
        CompleteTypeDetail detail_ArraySingleDimensionLiteralsWString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySingleDimensionLiteralsWString, ann_custom_ArraySingleDimensionLiteralsWString, type_name_ArraySingleDimensionLiteralsWString.to_string());
        CompleteStructHeader header_ArraySingleDimensionLiteralsWString;
        header_ArraySingleDimensionLiteralsWString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySingleDimensionLiteralsWString);
        CompleteStructMemberSeq member_seq_ArraySingleDimensionLiteralsWString;
        {
            TypeIdentifierPair type_ids_var_array_wstring;
            ReturnCode_t return_code_var_array_wstring {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_wstring =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_anonymous_wstring_unbounded_10", type_ids_var_array_wstring);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_wstring)
            {
                return_code_var_array_wstring =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_wstring_unbounded", type_ids_var_array_wstring);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_wstring)
                {
                    {
                        SBound bound = 0;
                        StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                                "anonymous_wstring_unbounded", type_ids_var_array_wstring, true))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_wstring_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_array_anonymous_wstring_unbounded_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_anonymous_wstring_unbounded_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_wstring, element_identifier_anonymous_array_anonymous_wstring_unbounded_10_ec))};
                if (!element_identifier_anonymous_array_anonymous_wstring_unbounded_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_anonymous_wstring_unbounded_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_wstring.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_anonymous_wstring_unbounded_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_anonymous_wstring_unbounded_10 = 0;
                PlainCollectionHeader header_anonymous_array_anonymous_wstring_unbounded_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_anonymous_wstring_unbounded_10, element_flags_anonymous_array_anonymous_wstring_unbounded_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_anonymous_wstring_unbounded_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_anonymous_wstring_unbounded_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_anonymous_wstring_unbounded_10", type_ids_var_array_wstring))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_anonymous_wstring_unbounded_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_wstring = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_wstring = 0x00000000;
            bool common_var_array_wstring_ec {false};
            CommonStructMember common_var_array_wstring {TypeObjectUtils::build_common_struct_member(member_id_var_array_wstring, member_flags_var_array_wstring, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_wstring, common_var_array_wstring_ec))};
            if (!common_var_array_wstring_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_wstring member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_wstring = "var_array_wstring";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_wstring;
            ann_custom_ArraySingleDimensionLiteralsWString.reset();
            CompleteMemberDetail detail_var_array_wstring = TypeObjectUtils::build_complete_member_detail(name_var_array_wstring, member_ann_builtin_var_array_wstring, ann_custom_ArraySingleDimensionLiteralsWString);
            CompleteStructMember member_var_array_wstring = TypeObjectUtils::build_complete_struct_member(common_var_array_wstring, detail_var_array_wstring);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySingleDimensionLiteralsWString, member_var_array_wstring);
        }
        CompleteStructType struct_type_ArraySingleDimensionLiteralsWString = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySingleDimensionLiteralsWString, header_ArraySingleDimensionLiteralsWString, member_seq_ArraySingleDimensionLiteralsWString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySingleDimensionLiteralsWString, type_name_ArraySingleDimensionLiteralsWString.to_string(), type_ids_ArraySingleDimensionLiteralsWString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySingleDimensionLiteralsWString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySingleDimensionLiteralsBoundedString_type_identifier(
        TypeIdentifierPair& type_ids_ArraySingleDimensionLiteralsBoundedString)
{

    ReturnCode_t return_code_ArraySingleDimensionLiteralsBoundedString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySingleDimensionLiteralsBoundedString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySingleDimensionLiteralsBoundedString", type_ids_ArraySingleDimensionLiteralsBoundedString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySingleDimensionLiteralsBoundedString)
    {
        StructTypeFlag struct_flags_ArraySingleDimensionLiteralsBoundedString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySingleDimensionLiteralsBoundedString = "ArraySingleDimensionLiteralsBoundedString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySingleDimensionLiteralsBoundedString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySingleDimensionLiteralsBoundedString;
        CompleteTypeDetail detail_ArraySingleDimensionLiteralsBoundedString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySingleDimensionLiteralsBoundedString, ann_custom_ArraySingleDimensionLiteralsBoundedString, type_name_ArraySingleDimensionLiteralsBoundedString.to_string());
        CompleteStructHeader header_ArraySingleDimensionLiteralsBoundedString;
        header_ArraySingleDimensionLiteralsBoundedString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySingleDimensionLiteralsBoundedString);
        CompleteStructMemberSeq member_seq_ArraySingleDimensionLiteralsBoundedString;
        {
            TypeIdentifierPair type_ids_var_array_bounded_string;
            ReturnCode_t return_code_var_array_bounded_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_bounded_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_anonymous_string_10_5", type_ids_var_array_bounded_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bounded_string)
            {
                return_code_var_array_bounded_string =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_bounded_string_helper", type_ids_var_array_bounded_string);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bounded_string)
                {
                ::register_Inner_alias_bounded_string_helper_type_identifier(type_ids_var_array_bounded_string);
                }
                bool element_identifier_anonymous_array_anonymous_string_10_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_anonymous_string_10_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bounded_string, element_identifier_anonymous_array_anonymous_string_10_5_ec))};
                if (!element_identifier_anonymous_array_anonymous_string_10_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_anonymous_string_10_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_bounded_string.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_anonymous_string_10_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_anonymous_string_10_5 = 0;
                PlainCollectionHeader header_anonymous_array_anonymous_string_10_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_anonymous_string_10_5, element_flags_anonymous_array_anonymous_string_10_5);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_anonymous_string_10_5, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_anonymous_string_10_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_anonymous_string_10_5", type_ids_var_array_bounded_string))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_anonymous_string_10_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_bounded_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_bounded_string = 0x00000000;
            bool common_var_array_bounded_string_ec {false};
            CommonStructMember common_var_array_bounded_string {TypeObjectUtils::build_common_struct_member(member_id_var_array_bounded_string, member_flags_var_array_bounded_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bounded_string, common_var_array_bounded_string_ec))};
            if (!common_var_array_bounded_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_bounded_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_bounded_string = "var_array_bounded_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_bounded_string;
            ann_custom_ArraySingleDimensionLiteralsBoundedString.reset();
            CompleteMemberDetail detail_var_array_bounded_string = TypeObjectUtils::build_complete_member_detail(name_var_array_bounded_string, member_ann_builtin_var_array_bounded_string, ann_custom_ArraySingleDimensionLiteralsBoundedString);
            CompleteStructMember member_var_array_bounded_string = TypeObjectUtils::build_complete_struct_member(common_var_array_bounded_string, detail_var_array_bounded_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySingleDimensionLiteralsBoundedString, member_var_array_bounded_string);
        }
        CompleteStructType struct_type_ArraySingleDimensionLiteralsBoundedString = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySingleDimensionLiteralsBoundedString, header_ArraySingleDimensionLiteralsBoundedString, member_seq_ArraySingleDimensionLiteralsBoundedString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySingleDimensionLiteralsBoundedString, type_name_ArraySingleDimensionLiteralsBoundedString.to_string(), type_ids_ArraySingleDimensionLiteralsBoundedString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySingleDimensionLiteralsBoundedString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySingleDimensionLiteralsBoundedWString_type_identifier(
        TypeIdentifierPair& type_ids_ArraySingleDimensionLiteralsBoundedWString)
{

    ReturnCode_t return_code_ArraySingleDimensionLiteralsBoundedWString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySingleDimensionLiteralsBoundedWString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySingleDimensionLiteralsBoundedWString", type_ids_ArraySingleDimensionLiteralsBoundedWString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySingleDimensionLiteralsBoundedWString)
    {
        StructTypeFlag struct_flags_ArraySingleDimensionLiteralsBoundedWString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySingleDimensionLiteralsBoundedWString = "ArraySingleDimensionLiteralsBoundedWString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySingleDimensionLiteralsBoundedWString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySingleDimensionLiteralsBoundedWString;
        CompleteTypeDetail detail_ArraySingleDimensionLiteralsBoundedWString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySingleDimensionLiteralsBoundedWString, ann_custom_ArraySingleDimensionLiteralsBoundedWString, type_name_ArraySingleDimensionLiteralsBoundedWString.to_string());
        CompleteStructHeader header_ArraySingleDimensionLiteralsBoundedWString;
        header_ArraySingleDimensionLiteralsBoundedWString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySingleDimensionLiteralsBoundedWString);
        CompleteStructMemberSeq member_seq_ArraySingleDimensionLiteralsBoundedWString;
        {
            TypeIdentifierPair type_ids_var_array_bounded_wstring;
            ReturnCode_t return_code_var_array_bounded_wstring {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_bounded_wstring =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_anonymous_wstring_10_10", type_ids_var_array_bounded_wstring);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bounded_wstring)
            {
                return_code_var_array_bounded_wstring =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_bounded_wstring_helper", type_ids_var_array_bounded_wstring);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bounded_wstring)
                {
                ::register_Inner_alias_bounded_wstring_helper_type_identifier(type_ids_var_array_bounded_wstring);
                }
                bool element_identifier_anonymous_array_anonymous_wstring_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_anonymous_wstring_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bounded_wstring, element_identifier_anonymous_array_anonymous_wstring_10_10_ec))};
                if (!element_identifier_anonymous_array_anonymous_wstring_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_anonymous_wstring_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_bounded_wstring.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_anonymous_wstring_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_anonymous_wstring_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_anonymous_wstring_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_anonymous_wstring_10_10, element_flags_anonymous_array_anonymous_wstring_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_anonymous_wstring_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_anonymous_wstring_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_anonymous_wstring_10_10", type_ids_var_array_bounded_wstring))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_anonymous_wstring_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_bounded_wstring = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_bounded_wstring = 0x00000000;
            bool common_var_array_bounded_wstring_ec {false};
            CommonStructMember common_var_array_bounded_wstring {TypeObjectUtils::build_common_struct_member(member_id_var_array_bounded_wstring, member_flags_var_array_bounded_wstring, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bounded_wstring, common_var_array_bounded_wstring_ec))};
            if (!common_var_array_bounded_wstring_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_bounded_wstring member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_bounded_wstring = "var_array_bounded_wstring";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_bounded_wstring;
            ann_custom_ArraySingleDimensionLiteralsBoundedWString.reset();
            CompleteMemberDetail detail_var_array_bounded_wstring = TypeObjectUtils::build_complete_member_detail(name_var_array_bounded_wstring, member_ann_builtin_var_array_bounded_wstring, ann_custom_ArraySingleDimensionLiteralsBoundedWString);
            CompleteStructMember member_var_array_bounded_wstring = TypeObjectUtils::build_complete_struct_member(common_var_array_bounded_wstring, detail_var_array_bounded_wstring);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySingleDimensionLiteralsBoundedWString, member_var_array_bounded_wstring);
        }
        CompleteStructType struct_type_ArraySingleDimensionLiteralsBoundedWString = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySingleDimensionLiteralsBoundedWString, header_ArraySingleDimensionLiteralsBoundedWString, member_seq_ArraySingleDimensionLiteralsBoundedWString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySingleDimensionLiteralsBoundedWString, type_name_ArraySingleDimensionLiteralsBoundedWString.to_string(), type_ids_ArraySingleDimensionLiteralsBoundedWString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySingleDimensionLiteralsBoundedWString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySingleDimensionLiteralsEnum_type_identifier(
        TypeIdentifierPair& type_ids_ArraySingleDimensionLiteralsEnum)
{

    ReturnCode_t return_code_ArraySingleDimensionLiteralsEnum {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySingleDimensionLiteralsEnum =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySingleDimensionLiteralsEnum", type_ids_ArraySingleDimensionLiteralsEnum);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySingleDimensionLiteralsEnum)
    {
        StructTypeFlag struct_flags_ArraySingleDimensionLiteralsEnum = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySingleDimensionLiteralsEnum = "ArraySingleDimensionLiteralsEnum";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySingleDimensionLiteralsEnum;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySingleDimensionLiteralsEnum;
        CompleteTypeDetail detail_ArraySingleDimensionLiteralsEnum = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySingleDimensionLiteralsEnum, ann_custom_ArraySingleDimensionLiteralsEnum, type_name_ArraySingleDimensionLiteralsEnum.to_string());
        CompleteStructHeader header_ArraySingleDimensionLiteralsEnum;
        header_ArraySingleDimensionLiteralsEnum = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySingleDimensionLiteralsEnum);
        CompleteStructMemberSeq member_seq_ArraySingleDimensionLiteralsEnum;
        {
            TypeIdentifierPair type_ids_var_array_enum;
            ReturnCode_t return_code_var_array_enum {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_enum =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_InnerEnumHelper_5", type_ids_var_array_enum);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_enum)
            {
                return_code_var_array_enum =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerEnumHelper", type_ids_var_array_enum);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_enum)
                {
                ::register_InnerEnumHelper_type_identifier(type_ids_var_array_enum);
                }
                bool element_identifier_anonymous_array_InnerEnumHelper_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_InnerEnumHelper_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_enum, element_identifier_anonymous_array_InnerEnumHelper_5_ec))};
                if (!element_identifier_anonymous_array_InnerEnumHelper_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_InnerEnumHelper_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_enum.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_InnerEnumHelper_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_InnerEnumHelper_5 = 0;
                PlainCollectionHeader header_anonymous_array_InnerEnumHelper_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_InnerEnumHelper_5, element_flags_anonymous_array_InnerEnumHelper_5);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_InnerEnumHelper_5, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_InnerEnumHelper_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_InnerEnumHelper_5", type_ids_var_array_enum))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_InnerEnumHelper_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_enum = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_enum = 0x00000000;
            bool common_var_array_enum_ec {false};
            CommonStructMember common_var_array_enum {TypeObjectUtils::build_common_struct_member(member_id_var_array_enum, member_flags_var_array_enum, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_enum, common_var_array_enum_ec))};
            if (!common_var_array_enum_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_enum member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_enum = "var_array_enum";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_enum;
            ann_custom_ArraySingleDimensionLiteralsEnum.reset();
            CompleteMemberDetail detail_var_array_enum = TypeObjectUtils::build_complete_member_detail(name_var_array_enum, member_ann_builtin_var_array_enum, ann_custom_ArraySingleDimensionLiteralsEnum);
            CompleteStructMember member_var_array_enum = TypeObjectUtils::build_complete_struct_member(common_var_array_enum, detail_var_array_enum);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySingleDimensionLiteralsEnum, member_var_array_enum);
        }
        CompleteStructType struct_type_ArraySingleDimensionLiteralsEnum = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySingleDimensionLiteralsEnum, header_ArraySingleDimensionLiteralsEnum, member_seq_ArraySingleDimensionLiteralsEnum);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySingleDimensionLiteralsEnum, type_name_ArraySingleDimensionLiteralsEnum.to_string(), type_ids_ArraySingleDimensionLiteralsEnum))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySingleDimensionLiteralsEnum already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySingleDimensionLiteralsBitMask_type_identifier(
        TypeIdentifierPair& type_ids_ArraySingleDimensionLiteralsBitMask)
{

    ReturnCode_t return_code_ArraySingleDimensionLiteralsBitMask {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySingleDimensionLiteralsBitMask =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySingleDimensionLiteralsBitMask", type_ids_ArraySingleDimensionLiteralsBitMask);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySingleDimensionLiteralsBitMask)
    {
        StructTypeFlag struct_flags_ArraySingleDimensionLiteralsBitMask = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySingleDimensionLiteralsBitMask = "ArraySingleDimensionLiteralsBitMask";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySingleDimensionLiteralsBitMask;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySingleDimensionLiteralsBitMask;
        CompleteTypeDetail detail_ArraySingleDimensionLiteralsBitMask = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySingleDimensionLiteralsBitMask, ann_custom_ArraySingleDimensionLiteralsBitMask, type_name_ArraySingleDimensionLiteralsBitMask.to_string());
        CompleteStructHeader header_ArraySingleDimensionLiteralsBitMask;
        header_ArraySingleDimensionLiteralsBitMask = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySingleDimensionLiteralsBitMask);
        CompleteStructMemberSeq member_seq_ArraySingleDimensionLiteralsBitMask;
        {
            TypeIdentifierPair type_ids_var_array_bitmask;
            ReturnCode_t return_code_var_array_bitmask {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_bitmask =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_InnerBitMaskHelper_10", type_ids_var_array_bitmask);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bitmask)
            {
                return_code_var_array_bitmask =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerBitMaskHelper", type_ids_var_array_bitmask);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bitmask)
                {
                ::register_InnerBitMaskHelper_type_identifier(type_ids_var_array_bitmask);
                }
                bool element_identifier_anonymous_array_InnerBitMaskHelper_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_InnerBitMaskHelper_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bitmask, element_identifier_anonymous_array_InnerBitMaskHelper_10_ec))};
                if (!element_identifier_anonymous_array_InnerBitMaskHelper_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_InnerBitMaskHelper_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_bitmask.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_InnerBitMaskHelper_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_InnerBitMaskHelper_10 = 0;
                PlainCollectionHeader header_anonymous_array_InnerBitMaskHelper_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_InnerBitMaskHelper_10, element_flags_anonymous_array_InnerBitMaskHelper_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_InnerBitMaskHelper_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_InnerBitMaskHelper_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_InnerBitMaskHelper_10", type_ids_var_array_bitmask))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_InnerBitMaskHelper_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_bitmask = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_bitmask = 0x00000000;
            bool common_var_array_bitmask_ec {false};
            CommonStructMember common_var_array_bitmask {TypeObjectUtils::build_common_struct_member(member_id_var_array_bitmask, member_flags_var_array_bitmask, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bitmask, common_var_array_bitmask_ec))};
            if (!common_var_array_bitmask_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_bitmask member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_bitmask = "var_array_bitmask";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_bitmask;
            ann_custom_ArraySingleDimensionLiteralsBitMask.reset();
            CompleteMemberDetail detail_var_array_bitmask = TypeObjectUtils::build_complete_member_detail(name_var_array_bitmask, member_ann_builtin_var_array_bitmask, ann_custom_ArraySingleDimensionLiteralsBitMask);
            CompleteStructMember member_var_array_bitmask = TypeObjectUtils::build_complete_struct_member(common_var_array_bitmask, detail_var_array_bitmask);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySingleDimensionLiteralsBitMask, member_var_array_bitmask);
        }
        CompleteStructType struct_type_ArraySingleDimensionLiteralsBitMask = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySingleDimensionLiteralsBitMask, header_ArraySingleDimensionLiteralsBitMask, member_seq_ArraySingleDimensionLiteralsBitMask);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySingleDimensionLiteralsBitMask, type_name_ArraySingleDimensionLiteralsBitMask.to_string(), type_ids_ArraySingleDimensionLiteralsBitMask))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySingleDimensionLiteralsBitMask already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySingleDimensionLiteralsAlias_type_identifier(
        TypeIdentifierPair& type_ids_ArraySingleDimensionLiteralsAlias)
{

    ReturnCode_t return_code_ArraySingleDimensionLiteralsAlias {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySingleDimensionLiteralsAlias =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySingleDimensionLiteralsAlias", type_ids_ArraySingleDimensionLiteralsAlias);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySingleDimensionLiteralsAlias)
    {
        StructTypeFlag struct_flags_ArraySingleDimensionLiteralsAlias = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySingleDimensionLiteralsAlias = "ArraySingleDimensionLiteralsAlias";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySingleDimensionLiteralsAlias;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySingleDimensionLiteralsAlias;
        CompleteTypeDetail detail_ArraySingleDimensionLiteralsAlias = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySingleDimensionLiteralsAlias, ann_custom_ArraySingleDimensionLiteralsAlias, type_name_ArraySingleDimensionLiteralsAlias.to_string());
        CompleteStructHeader header_ArraySingleDimensionLiteralsAlias;
        header_ArraySingleDimensionLiteralsAlias = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySingleDimensionLiteralsAlias);
        CompleteStructMemberSeq member_seq_ArraySingleDimensionLiteralsAlias;
        {
            TypeIdentifierPair type_ids_var_array_alias;
            ReturnCode_t return_code_var_array_alias {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_alias =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_InnerAliasHelper_10", type_ids_var_array_alias);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_alias)
            {
                return_code_var_array_alias =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerAliasHelper", type_ids_var_array_alias);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_alias)
                {
                ::register_InnerAliasHelper_type_identifier(type_ids_var_array_alias);
                }
                bool element_identifier_anonymous_array_InnerAliasHelper_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_InnerAliasHelper_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_alias, element_identifier_anonymous_array_InnerAliasHelper_10_ec))};
                if (!element_identifier_anonymous_array_InnerAliasHelper_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_InnerAliasHelper_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_alias.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_InnerAliasHelper_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_InnerAliasHelper_10 = 0;
                PlainCollectionHeader header_anonymous_array_InnerAliasHelper_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_InnerAliasHelper_10, element_flags_anonymous_array_InnerAliasHelper_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_InnerAliasHelper_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_InnerAliasHelper_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_InnerAliasHelper_10", type_ids_var_array_alias))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_InnerAliasHelper_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_alias = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_alias = 0x00000000;
            bool common_var_array_alias_ec {false};
            CommonStructMember common_var_array_alias {TypeObjectUtils::build_common_struct_member(member_id_var_array_alias, member_flags_var_array_alias, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_alias, common_var_array_alias_ec))};
            if (!common_var_array_alias_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_alias member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_alias = "var_array_alias";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_alias;
            ann_custom_ArraySingleDimensionLiteralsAlias.reset();
            CompleteMemberDetail detail_var_array_alias = TypeObjectUtils::build_complete_member_detail(name_var_array_alias, member_ann_builtin_var_array_alias, ann_custom_ArraySingleDimensionLiteralsAlias);
            CompleteStructMember member_var_array_alias = TypeObjectUtils::build_complete_struct_member(common_var_array_alias, detail_var_array_alias);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySingleDimensionLiteralsAlias, member_var_array_alias);
        }
        CompleteStructType struct_type_ArraySingleDimensionLiteralsAlias = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySingleDimensionLiteralsAlias, header_ArraySingleDimensionLiteralsAlias, member_seq_ArraySingleDimensionLiteralsAlias);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySingleDimensionLiteralsAlias, type_name_ArraySingleDimensionLiteralsAlias.to_string(), type_ids_ArraySingleDimensionLiteralsAlias))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySingleDimensionLiteralsAlias already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySingleDimensionLiteralsShortArray_type_identifier(
        TypeIdentifierPair& type_ids_ArraySingleDimensionLiteralsShortArray)
{

    ReturnCode_t return_code_ArraySingleDimensionLiteralsShortArray {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySingleDimensionLiteralsShortArray =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySingleDimensionLiteralsShortArray", type_ids_ArraySingleDimensionLiteralsShortArray);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySingleDimensionLiteralsShortArray)
    {
        StructTypeFlag struct_flags_ArraySingleDimensionLiteralsShortArray = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySingleDimensionLiteralsShortArray = "ArraySingleDimensionLiteralsShortArray";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySingleDimensionLiteralsShortArray;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySingleDimensionLiteralsShortArray;
        CompleteTypeDetail detail_ArraySingleDimensionLiteralsShortArray = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySingleDimensionLiteralsShortArray, ann_custom_ArraySingleDimensionLiteralsShortArray, type_name_ArraySingleDimensionLiteralsShortArray.to_string());
        CompleteStructHeader header_ArraySingleDimensionLiteralsShortArray;
        header_ArraySingleDimensionLiteralsShortArray = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySingleDimensionLiteralsShortArray);
        CompleteStructMemberSeq member_seq_ArraySingleDimensionLiteralsShortArray;
        {
            TypeIdentifierPair type_ids_var_array_short_array;
            ReturnCode_t return_code_var_array_short_array {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_short_array =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_10_10", type_ids_var_array_short_array);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_short_array)
            {
                return_code_var_array_short_array =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_array_short_array);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_short_array)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_short_array, element_identifier_anonymous_array_int16_t_10_10_ec))};
                if (!element_identifier_anonymous_array_int16_t_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_short_array.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_10_10, element_flags_anonymous_array_int16_t_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_10_10", type_ids_var_array_short_array))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_short_array = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_short_array = 0x00000000;
            bool common_var_array_short_array_ec {false};
            CommonStructMember common_var_array_short_array {TypeObjectUtils::build_common_struct_member(member_id_var_array_short_array, member_flags_var_array_short_array, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_short_array, common_var_array_short_array_ec))};
            if (!common_var_array_short_array_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_short_array member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_short_array = "var_array_short_array";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_short_array;
            ann_custom_ArraySingleDimensionLiteralsShortArray.reset();
            CompleteMemberDetail detail_var_array_short_array = TypeObjectUtils::build_complete_member_detail(name_var_array_short_array, member_ann_builtin_var_array_short_array, ann_custom_ArraySingleDimensionLiteralsShortArray);
            CompleteStructMember member_var_array_short_array = TypeObjectUtils::build_complete_struct_member(common_var_array_short_array, detail_var_array_short_array);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySingleDimensionLiteralsShortArray, member_var_array_short_array);
        }
        CompleteStructType struct_type_ArraySingleDimensionLiteralsShortArray = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySingleDimensionLiteralsShortArray, header_ArraySingleDimensionLiteralsShortArray, member_seq_ArraySingleDimensionLiteralsShortArray);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySingleDimensionLiteralsShortArray, type_name_ArraySingleDimensionLiteralsShortArray.to_string(), type_ids_ArraySingleDimensionLiteralsShortArray))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySingleDimensionLiteralsShortArray already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySingleDimensionLiteralsSequence_type_identifier(
        TypeIdentifierPair& type_ids_ArraySingleDimensionLiteralsSequence)
{

    ReturnCode_t return_code_ArraySingleDimensionLiteralsSequence {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySingleDimensionLiteralsSequence =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySingleDimensionLiteralsSequence", type_ids_ArraySingleDimensionLiteralsSequence);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySingleDimensionLiteralsSequence)
    {
        StructTypeFlag struct_flags_ArraySingleDimensionLiteralsSequence = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySingleDimensionLiteralsSequence = "ArraySingleDimensionLiteralsSequence";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySingleDimensionLiteralsSequence;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySingleDimensionLiteralsSequence;
        CompleteTypeDetail detail_ArraySingleDimensionLiteralsSequence = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySingleDimensionLiteralsSequence, ann_custom_ArraySingleDimensionLiteralsSequence, type_name_ArraySingleDimensionLiteralsSequence.to_string());
        CompleteStructHeader header_ArraySingleDimensionLiteralsSequence;
        header_ArraySingleDimensionLiteralsSequence = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySingleDimensionLiteralsSequence);
        CompleteStructMemberSeq member_seq_ArraySingleDimensionLiteralsSequence;
        {
            TypeIdentifierPair type_ids_var_array_sequence;
            ReturnCode_t return_code_var_array_sequence {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_sequence =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_anonymous_sequence_int32_t_unbounded_5", type_ids_var_array_sequence);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_sequence)
            {
                return_code_var_array_sequence =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_sequence_int32_t_unbounded", type_ids_var_array_sequence);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_sequence)
                {
                    return_code_var_array_sequence =
                        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                        "_int32_t", type_ids_var_array_sequence);

                    if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_sequence)
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                        return;
                    }
                    bool element_identifier_anonymous_sequence_int32_t_unbounded_ec {false};
                    TypeIdentifier* element_identifier_anonymous_sequence_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_sequence, element_identifier_anonymous_sequence_int32_t_unbounded_ec))};
                    if (!element_identifier_anonymous_sequence_int32_t_unbounded_ec)
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                        return;
                    }
                    EquivalenceKind equiv_kind_anonymous_sequence_int32_t_unbounded = EK_COMPLETE;
                    if (TK_NONE == type_ids_var_array_sequence.type_identifier2()._d())
                    {
                        equiv_kind_anonymous_sequence_int32_t_unbounded = EK_BOTH;
                    }
                    CollectionElementFlag element_flags_anonymous_sequence_int32_t_unbounded = 0;
                    PlainCollectionHeader header_anonymous_sequence_int32_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_int32_t_unbounded, element_flags_anonymous_sequence_int32_t_unbounded);
                    {
                        SBound bound = 0;
                        PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_int32_t_unbounded, bound,
                                    eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_int32_t_unbounded));
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_int32_t_unbounded", type_ids_var_array_sequence))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_sequence_int32_t_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_array_anonymous_sequence_int32_t_unbounded_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_anonymous_sequence_int32_t_unbounded_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_sequence, element_identifier_anonymous_array_anonymous_sequence_int32_t_unbounded_5_ec))};
                if (!element_identifier_anonymous_array_anonymous_sequence_int32_t_unbounded_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_anonymous_sequence_int32_t_unbounded_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_sequence.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_anonymous_sequence_int32_t_unbounded_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_anonymous_sequence_int32_t_unbounded_5 = 0;
                PlainCollectionHeader header_anonymous_array_anonymous_sequence_int32_t_unbounded_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_anonymous_sequence_int32_t_unbounded_5, element_flags_anonymous_array_anonymous_sequence_int32_t_unbounded_5);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_anonymous_sequence_int32_t_unbounded_5, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_anonymous_sequence_int32_t_unbounded_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_anonymous_sequence_int32_t_unbounded_5", type_ids_var_array_sequence))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_anonymous_sequence_int32_t_unbounded_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_sequence = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_sequence = 0x00000000;
            bool common_var_array_sequence_ec {false};
            CommonStructMember common_var_array_sequence {TypeObjectUtils::build_common_struct_member(member_id_var_array_sequence, member_flags_var_array_sequence, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_sequence, common_var_array_sequence_ec))};
            if (!common_var_array_sequence_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_sequence member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_sequence = "var_array_sequence";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_sequence;
            ann_custom_ArraySingleDimensionLiteralsSequence.reset();
            CompleteMemberDetail detail_var_array_sequence = TypeObjectUtils::build_complete_member_detail(name_var_array_sequence, member_ann_builtin_var_array_sequence, ann_custom_ArraySingleDimensionLiteralsSequence);
            CompleteStructMember member_var_array_sequence = TypeObjectUtils::build_complete_struct_member(common_var_array_sequence, detail_var_array_sequence);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySingleDimensionLiteralsSequence, member_var_array_sequence);
        }
        CompleteStructType struct_type_ArraySingleDimensionLiteralsSequence = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySingleDimensionLiteralsSequence, header_ArraySingleDimensionLiteralsSequence, member_seq_ArraySingleDimensionLiteralsSequence);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySingleDimensionLiteralsSequence, type_name_ArraySingleDimensionLiteralsSequence.to_string(), type_ids_ArraySingleDimensionLiteralsSequence))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySingleDimensionLiteralsSequence already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySingleDimensionLiteralsMap_type_identifier(
        TypeIdentifierPair& type_ids_ArraySingleDimensionLiteralsMap)
{

    ReturnCode_t return_code_ArraySingleDimensionLiteralsMap {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySingleDimensionLiteralsMap =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySingleDimensionLiteralsMap", type_ids_ArraySingleDimensionLiteralsMap);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySingleDimensionLiteralsMap)
    {
        StructTypeFlag struct_flags_ArraySingleDimensionLiteralsMap = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySingleDimensionLiteralsMap = "ArraySingleDimensionLiteralsMap";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySingleDimensionLiteralsMap;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySingleDimensionLiteralsMap;
        CompleteTypeDetail detail_ArraySingleDimensionLiteralsMap = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySingleDimensionLiteralsMap, ann_custom_ArraySingleDimensionLiteralsMap, type_name_ArraySingleDimensionLiteralsMap.to_string());
        CompleteStructHeader header_ArraySingleDimensionLiteralsMap;
        header_ArraySingleDimensionLiteralsMap = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySingleDimensionLiteralsMap);
        CompleteStructMemberSeq member_seq_ArraySingleDimensionLiteralsMap;
        {
            TypeIdentifierPair type_ids_var_array_map;
            ReturnCode_t return_code_var_array_map {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_map =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_anonymous_map_int32_t_int32_t_unbounded_2", type_ids_var_array_map);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_map)
            {
                return_code_var_array_map =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_map_int32_t_int32_t_unbounded", type_ids_var_array_map);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_map)
                {
                    return_code_var_array_map =
                        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                        "_int32_t", type_ids_var_array_map);

                    if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_map)
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                        return;
                    }
                    bool element_identifier_anonymous_map_int32_t_int32_t_unbounded_ec {false};
                    TypeIdentifier* element_identifier_anonymous_map_int32_t_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_map, element_identifier_anonymous_map_int32_t_int32_t_unbounded_ec))};
                    if (!element_identifier_anonymous_map_int32_t_int32_t_unbounded_ec)
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_int32_t_unbounded inconsistent element TypeIdentifier.");
                        return;
                    }
                    return_code_var_array_map =
                        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                        "_int32_t", type_ids_var_array_map);

                    if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_map)
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                        return;
                    }
                    bool key_identifier_anonymous_map_int32_t_int32_t_unbounded_ec {false};
                    TypeIdentifier* key_identifier_anonymous_map_int32_t_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_map, key_identifier_anonymous_map_int32_t_int32_t_unbounded_ec))};
                    if (!key_identifier_anonymous_map_int32_t_int32_t_unbounded_ec)
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_int32_t_unbounded inconsistent key TypeIdentifier.");
                        return;
                    }
                    EquivalenceKind equiv_kind_anonymous_map_int32_t_int32_t_unbounded = EK_BOTH;
                    if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d()) ||
                            (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                            (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                            (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->array_sdefn().header().equiv_kind()) ||
                            (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->array_ldefn().header().equiv_kind()) ||
                            (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_sdefn().header().equiv_kind())) ||
                            (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_ldefn().header().equiv_kind())))
                    {
                        equiv_kind_anonymous_map_int32_t_int32_t_unbounded = EK_COMPLETE;
                    }
                    CollectionElementFlag element_flags_anonymous_map_int32_t_int32_t_unbounded = 0;
                    CollectionElementFlag key_flags_anonymous_map_int32_t_int32_t_unbounded = 0;
                    PlainCollectionHeader header_anonymous_map_int32_t_int32_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_int32_t_unbounded, element_flags_anonymous_map_int32_t_int32_t_unbounded);
                    {
                        SBound bound = 0;
                        PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_int32_t_unbounded, bound,
                                    eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_int32_t_unbounded), key_flags_anonymous_map_int32_t_int32_t_unbounded,
                                    eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_int32_t_unbounded));
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_int32_t_unbounded", type_ids_var_array_map))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_map_int32_t_int32_t_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_2_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_2 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_map, element_identifier_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_2_ec))};
                if (!element_identifier_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_2_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_2 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_map.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_2 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_2 = 0;
                PlainCollectionHeader header_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_2 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_2, element_flags_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_2);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(2));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_2, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_2));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_anonymous_map_int32_t_int32_t_unbounded_2", type_ids_var_array_map))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_anonymous_map_int32_t_int32_t_unbounded_2 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_map = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_map = 0x00000000;
            bool common_var_array_map_ec {false};
            CommonStructMember common_var_array_map {TypeObjectUtils::build_common_struct_member(member_id_var_array_map, member_flags_var_array_map, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_map, common_var_array_map_ec))};
            if (!common_var_array_map_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_map member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_map = "var_array_map";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_map;
            ann_custom_ArraySingleDimensionLiteralsMap.reset();
            CompleteMemberDetail detail_var_array_map = TypeObjectUtils::build_complete_member_detail(name_var_array_map, member_ann_builtin_var_array_map, ann_custom_ArraySingleDimensionLiteralsMap);
            CompleteStructMember member_var_array_map = TypeObjectUtils::build_complete_struct_member(common_var_array_map, detail_var_array_map);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySingleDimensionLiteralsMap, member_var_array_map);
        }
        CompleteStructType struct_type_ArraySingleDimensionLiteralsMap = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySingleDimensionLiteralsMap, header_ArraySingleDimensionLiteralsMap, member_seq_ArraySingleDimensionLiteralsMap);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySingleDimensionLiteralsMap, type_name_ArraySingleDimensionLiteralsMap.to_string(), type_ids_ArraySingleDimensionLiteralsMap))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySingleDimensionLiteralsMap already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySingleDimensionLiteralsUnion_type_identifier(
        TypeIdentifierPair& type_ids_ArraySingleDimensionLiteralsUnion)
{

    ReturnCode_t return_code_ArraySingleDimensionLiteralsUnion {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySingleDimensionLiteralsUnion =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySingleDimensionLiteralsUnion", type_ids_ArraySingleDimensionLiteralsUnion);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySingleDimensionLiteralsUnion)
    {
        StructTypeFlag struct_flags_ArraySingleDimensionLiteralsUnion = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySingleDimensionLiteralsUnion = "ArraySingleDimensionLiteralsUnion";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySingleDimensionLiteralsUnion;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySingleDimensionLiteralsUnion;
        CompleteTypeDetail detail_ArraySingleDimensionLiteralsUnion = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySingleDimensionLiteralsUnion, ann_custom_ArraySingleDimensionLiteralsUnion, type_name_ArraySingleDimensionLiteralsUnion.to_string());
        CompleteStructHeader header_ArraySingleDimensionLiteralsUnion;
        header_ArraySingleDimensionLiteralsUnion = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySingleDimensionLiteralsUnion);
        CompleteStructMemberSeq member_seq_ArraySingleDimensionLiteralsUnion;
        {
            TypeIdentifierPair type_ids_var_array_union;
            ReturnCode_t return_code_var_array_union {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_union =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_InnerUnionHelper_10", type_ids_var_array_union);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_union)
            {
                return_code_var_array_union =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerUnionHelper", type_ids_var_array_union);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_union)
                {
                ::register_InnerUnionHelper_type_identifier(type_ids_var_array_union);
                }
                bool element_identifier_anonymous_array_InnerUnionHelper_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_InnerUnionHelper_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_union, element_identifier_anonymous_array_InnerUnionHelper_10_ec))};
                if (!element_identifier_anonymous_array_InnerUnionHelper_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_InnerUnionHelper_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_union.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_InnerUnionHelper_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_InnerUnionHelper_10 = 0;
                PlainCollectionHeader header_anonymous_array_InnerUnionHelper_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_InnerUnionHelper_10, element_flags_anonymous_array_InnerUnionHelper_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_InnerUnionHelper_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_InnerUnionHelper_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_InnerUnionHelper_10", type_ids_var_array_union))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_InnerUnionHelper_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_union = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_union = 0x00000000;
            bool common_var_array_union_ec {false};
            CommonStructMember common_var_array_union {TypeObjectUtils::build_common_struct_member(member_id_var_array_union, member_flags_var_array_union, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_union, common_var_array_union_ec))};
            if (!common_var_array_union_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_union member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_union = "var_array_union";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_union;
            ann_custom_ArraySingleDimensionLiteralsUnion.reset();
            CompleteMemberDetail detail_var_array_union = TypeObjectUtils::build_complete_member_detail(name_var_array_union, member_ann_builtin_var_array_union, ann_custom_ArraySingleDimensionLiteralsUnion);
            CompleteStructMember member_var_array_union = TypeObjectUtils::build_complete_struct_member(common_var_array_union, detail_var_array_union);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySingleDimensionLiteralsUnion, member_var_array_union);
        }
        CompleteStructType struct_type_ArraySingleDimensionLiteralsUnion = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySingleDimensionLiteralsUnion, header_ArraySingleDimensionLiteralsUnion, member_seq_ArraySingleDimensionLiteralsUnion);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySingleDimensionLiteralsUnion, type_name_ArraySingleDimensionLiteralsUnion.to_string(), type_ids_ArraySingleDimensionLiteralsUnion))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySingleDimensionLiteralsUnion already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySingleDimensionLiteralsStructure_type_identifier(
        TypeIdentifierPair& type_ids_ArraySingleDimensionLiteralsStructure)
{

    ReturnCode_t return_code_ArraySingleDimensionLiteralsStructure {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySingleDimensionLiteralsStructure =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySingleDimensionLiteralsStructure", type_ids_ArraySingleDimensionLiteralsStructure);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySingleDimensionLiteralsStructure)
    {
        StructTypeFlag struct_flags_ArraySingleDimensionLiteralsStructure = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySingleDimensionLiteralsStructure = "ArraySingleDimensionLiteralsStructure";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySingleDimensionLiteralsStructure;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySingleDimensionLiteralsStructure;
        CompleteTypeDetail detail_ArraySingleDimensionLiteralsStructure = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySingleDimensionLiteralsStructure, ann_custom_ArraySingleDimensionLiteralsStructure, type_name_ArraySingleDimensionLiteralsStructure.to_string());
        CompleteStructHeader header_ArraySingleDimensionLiteralsStructure;
        header_ArraySingleDimensionLiteralsStructure = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySingleDimensionLiteralsStructure);
        CompleteStructMemberSeq member_seq_ArraySingleDimensionLiteralsStructure;
        {
            TypeIdentifierPair type_ids_var_array_structure;
            ReturnCode_t return_code_var_array_structure {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_structure =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_InnerStructureHelper_5", type_ids_var_array_structure);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_structure)
            {
                return_code_var_array_structure =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerStructureHelper", type_ids_var_array_structure);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_structure)
                {
                ::register_InnerStructureHelper_type_identifier(type_ids_var_array_structure);
                }
                bool element_identifier_anonymous_array_InnerStructureHelper_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_InnerStructureHelper_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_structure, element_identifier_anonymous_array_InnerStructureHelper_5_ec))};
                if (!element_identifier_anonymous_array_InnerStructureHelper_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_InnerStructureHelper_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_structure.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_InnerStructureHelper_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_InnerStructureHelper_5 = 0;
                PlainCollectionHeader header_anonymous_array_InnerStructureHelper_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_InnerStructureHelper_5, element_flags_anonymous_array_InnerStructureHelper_5);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_InnerStructureHelper_5, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_InnerStructureHelper_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_InnerStructureHelper_5", type_ids_var_array_structure))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_InnerStructureHelper_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_structure = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_structure = 0x00000000;
            bool common_var_array_structure_ec {false};
            CommonStructMember common_var_array_structure {TypeObjectUtils::build_common_struct_member(member_id_var_array_structure, member_flags_var_array_structure, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_structure, common_var_array_structure_ec))};
            if (!common_var_array_structure_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_structure member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_structure = "var_array_structure";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_structure;
            ann_custom_ArraySingleDimensionLiteralsStructure.reset();
            CompleteMemberDetail detail_var_array_structure = TypeObjectUtils::build_complete_member_detail(name_var_array_structure, member_ann_builtin_var_array_structure, ann_custom_ArraySingleDimensionLiteralsStructure);
            CompleteStructMember member_var_array_structure = TypeObjectUtils::build_complete_struct_member(common_var_array_structure, detail_var_array_structure);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySingleDimensionLiteralsStructure, member_var_array_structure);
        }
        CompleteStructType struct_type_ArraySingleDimensionLiteralsStructure = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySingleDimensionLiteralsStructure, header_ArraySingleDimensionLiteralsStructure, member_seq_ArraySingleDimensionLiteralsStructure);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySingleDimensionLiteralsStructure, type_name_ArraySingleDimensionLiteralsStructure.to_string(), type_ids_ArraySingleDimensionLiteralsStructure))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySingleDimensionLiteralsStructure already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArraySingleDimensionLiteralsBitset_type_identifier(
        TypeIdentifierPair& type_ids_ArraySingleDimensionLiteralsBitset)
{

    ReturnCode_t return_code_ArraySingleDimensionLiteralsBitset {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArraySingleDimensionLiteralsBitset =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArraySingleDimensionLiteralsBitset", type_ids_ArraySingleDimensionLiteralsBitset);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArraySingleDimensionLiteralsBitset)
    {
        StructTypeFlag struct_flags_ArraySingleDimensionLiteralsBitset = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArraySingleDimensionLiteralsBitset = "ArraySingleDimensionLiteralsBitset";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArraySingleDimensionLiteralsBitset;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArraySingleDimensionLiteralsBitset;
        CompleteTypeDetail detail_ArraySingleDimensionLiteralsBitset = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArraySingleDimensionLiteralsBitset, ann_custom_ArraySingleDimensionLiteralsBitset, type_name_ArraySingleDimensionLiteralsBitset.to_string());
        CompleteStructHeader header_ArraySingleDimensionLiteralsBitset;
        header_ArraySingleDimensionLiteralsBitset = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArraySingleDimensionLiteralsBitset);
        CompleteStructMemberSeq member_seq_ArraySingleDimensionLiteralsBitset;
        {
            TypeIdentifierPair type_ids_var_array_bitset;
            ReturnCode_t return_code_var_array_bitset {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_bitset =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_InnerBitsetHelper_10", type_ids_var_array_bitset);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bitset)
            {
                return_code_var_array_bitset =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerBitsetHelper", type_ids_var_array_bitset);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bitset)
                {
                ::register_InnerBitsetHelper_type_identifier(type_ids_var_array_bitset);
                }
                bool element_identifier_anonymous_array_InnerBitsetHelper_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_InnerBitsetHelper_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bitset, element_identifier_anonymous_array_InnerBitsetHelper_10_ec))};
                if (!element_identifier_anonymous_array_InnerBitsetHelper_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_InnerBitsetHelper_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_bitset.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_InnerBitsetHelper_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_InnerBitsetHelper_10 = 0;
                PlainCollectionHeader header_anonymous_array_InnerBitsetHelper_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_InnerBitsetHelper_10, element_flags_anonymous_array_InnerBitsetHelper_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_InnerBitsetHelper_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_InnerBitsetHelper_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_InnerBitsetHelper_10", type_ids_var_array_bitset))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_InnerBitsetHelper_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_bitset = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_bitset = 0x00000000;
            bool common_var_array_bitset_ec {false};
            CommonStructMember common_var_array_bitset {TypeObjectUtils::build_common_struct_member(member_id_var_array_bitset, member_flags_var_array_bitset, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bitset, common_var_array_bitset_ec))};
            if (!common_var_array_bitset_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_bitset member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_bitset = "var_array_bitset";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_bitset;
            ann_custom_ArraySingleDimensionLiteralsBitset.reset();
            CompleteMemberDetail detail_var_array_bitset = TypeObjectUtils::build_complete_member_detail(name_var_array_bitset, member_ann_builtin_var_array_bitset, ann_custom_ArraySingleDimensionLiteralsBitset);
            CompleteStructMember member_var_array_bitset = TypeObjectUtils::build_complete_struct_member(common_var_array_bitset, detail_var_array_bitset);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArraySingleDimensionLiteralsBitset, member_var_array_bitset);
        }
        CompleteStructType struct_type_ArraySingleDimensionLiteralsBitset = TypeObjectUtils::build_complete_struct_type(struct_flags_ArraySingleDimensionLiteralsBitset, header_ArraySingleDimensionLiteralsBitset, member_seq_ArraySingleDimensionLiteralsBitset);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArraySingleDimensionLiteralsBitset, type_name_ArraySingleDimensionLiteralsBitset.to_string(), type_ids_ArraySingleDimensionLiteralsBitset))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArraySingleDimensionLiteralsBitset already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLiteralsShort_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLiteralsShort)
{

    ReturnCode_t return_code_ArrayMultiDimensionLiteralsShort {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLiteralsShort =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLiteralsShort", type_ids_ArrayMultiDimensionLiteralsShort);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLiteralsShort)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLiteralsShort = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLiteralsShort = "ArrayMultiDimensionLiteralsShort";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLiteralsShort;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLiteralsShort;
        CompleteTypeDetail detail_ArrayMultiDimensionLiteralsShort = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLiteralsShort, ann_custom_ArrayMultiDimensionLiteralsShort, type_name_ArrayMultiDimensionLiteralsShort.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLiteralsShort;
        header_ArrayMultiDimensionLiteralsShort = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLiteralsShort);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLiteralsShort;
        {
            TypeIdentifierPair type_ids_var_array_short;
            ReturnCode_t return_code_var_array_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_5_10_2", type_ids_var_array_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_short)
            {
                return_code_var_array_short =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_array_short);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_short)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_5_10_2_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_5_10_2 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_short, element_identifier_anonymous_array_int16_t_5_10_2_ec))};
                if (!element_identifier_anonymous_array_int16_t_5_10_2_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_5_10_2 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_short.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_5_10_2 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_5_10_2 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_5_10_2 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_5_10_2, element_flags_anonymous_array_int16_t_5_10_2);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(2));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_5_10_2, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_5_10_2));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_5_10_2", type_ids_var_array_short))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_5_10_2 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_short = 0x00000000;
            bool common_var_array_short_ec {false};
            CommonStructMember common_var_array_short {TypeObjectUtils::build_common_struct_member(member_id_var_array_short, member_flags_var_array_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_short, common_var_array_short_ec))};
            if (!common_var_array_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_short = "var_array_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_short;
            ann_custom_ArrayMultiDimensionLiteralsShort.reset();
            CompleteMemberDetail detail_var_array_short = TypeObjectUtils::build_complete_member_detail(name_var_array_short, member_ann_builtin_var_array_short, ann_custom_ArrayMultiDimensionLiteralsShort);
            CompleteStructMember member_var_array_short = TypeObjectUtils::build_complete_struct_member(common_var_array_short, detail_var_array_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLiteralsShort, member_var_array_short);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLiteralsShort = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLiteralsShort, header_ArrayMultiDimensionLiteralsShort, member_seq_ArrayMultiDimensionLiteralsShort);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLiteralsShort, type_name_ArrayMultiDimensionLiteralsShort.to_string(), type_ids_ArrayMultiDimensionLiteralsShort))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLiteralsShort already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLiteralsUShort_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLiteralsUShort)
{

    ReturnCode_t return_code_ArrayMultiDimensionLiteralsUShort {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLiteralsUShort =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLiteralsUShort", type_ids_ArrayMultiDimensionLiteralsUShort);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLiteralsUShort)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLiteralsUShort = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLiteralsUShort = "ArrayMultiDimensionLiteralsUShort";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLiteralsUShort;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLiteralsUShort;
        CompleteTypeDetail detail_ArrayMultiDimensionLiteralsUShort = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLiteralsUShort, ann_custom_ArrayMultiDimensionLiteralsUShort, type_name_ArrayMultiDimensionLiteralsUShort.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLiteralsUShort;
        header_ArrayMultiDimensionLiteralsUShort = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLiteralsUShort);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLiteralsUShort;
        {
            TypeIdentifierPair type_ids_var_array_ushort;
            ReturnCode_t return_code_var_array_ushort {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_ushort =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint16_t_5_10_5", type_ids_var_array_ushort);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_ushort)
            {
                return_code_var_array_ushort =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_array_ushort);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_ushort)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint16_t_5_10_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint16_t_5_10_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_ushort, element_identifier_anonymous_array_uint16_t_5_10_5_ec))};
                if (!element_identifier_anonymous_array_uint16_t_5_10_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint16_t_5_10_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_ushort.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint16_t_5_10_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint16_t_5_10_5 = 0;
                PlainCollectionHeader header_anonymous_array_uint16_t_5_10_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint16_t_5_10_5, element_flags_anonymous_array_uint16_t_5_10_5);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint16_t_5_10_5, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint16_t_5_10_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint16_t_5_10_5", type_ids_var_array_ushort))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint16_t_5_10_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_ushort = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_ushort = 0x00000000;
            bool common_var_array_ushort_ec {false};
            CommonStructMember common_var_array_ushort {TypeObjectUtils::build_common_struct_member(member_id_var_array_ushort, member_flags_var_array_ushort, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_ushort, common_var_array_ushort_ec))};
            if (!common_var_array_ushort_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_ushort member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_ushort = "var_array_ushort";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_ushort;
            ann_custom_ArrayMultiDimensionLiteralsUShort.reset();
            CompleteMemberDetail detail_var_array_ushort = TypeObjectUtils::build_complete_member_detail(name_var_array_ushort, member_ann_builtin_var_array_ushort, ann_custom_ArrayMultiDimensionLiteralsUShort);
            CompleteStructMember member_var_array_ushort = TypeObjectUtils::build_complete_struct_member(common_var_array_ushort, detail_var_array_ushort);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLiteralsUShort, member_var_array_ushort);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLiteralsUShort = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLiteralsUShort, header_ArrayMultiDimensionLiteralsUShort, member_seq_ArrayMultiDimensionLiteralsUShort);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLiteralsUShort, type_name_ArrayMultiDimensionLiteralsUShort.to_string(), type_ids_ArrayMultiDimensionLiteralsUShort))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLiteralsUShort already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLiteralsLong_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLiteralsLong)
{

    ReturnCode_t return_code_ArrayMultiDimensionLiteralsLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLiteralsLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLiteralsLong", type_ids_ArrayMultiDimensionLiteralsLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLiteralsLong)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLiteralsLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLiteralsLong = "ArrayMultiDimensionLiteralsLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLiteralsLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLiteralsLong;
        CompleteTypeDetail detail_ArrayMultiDimensionLiteralsLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLiteralsLong, ann_custom_ArrayMultiDimensionLiteralsLong, type_name_ArrayMultiDimensionLiteralsLong.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLiteralsLong;
        header_ArrayMultiDimensionLiteralsLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLiteralsLong);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLiteralsLong;
        {
            TypeIdentifierPair type_ids_var_array_long;
            ReturnCode_t return_code_var_array_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int32_t_10_5_5", type_ids_var_array_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_long)
            {
                return_code_var_array_long =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_array_long);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_long)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int32_t_10_5_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int32_t_10_5_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_long, element_identifier_anonymous_array_int32_t_10_5_5_ec))};
                if (!element_identifier_anonymous_array_int32_t_10_5_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int32_t_10_5_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_long.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int32_t_10_5_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int32_t_10_5_5 = 0;
                PlainCollectionHeader header_anonymous_array_int32_t_10_5_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int32_t_10_5_5, element_flags_anonymous_array_int32_t_10_5_5);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int32_t_10_5_5, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int32_t_10_5_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int32_t_10_5_5", type_ids_var_array_long))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int32_t_10_5_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_long = 0x00000000;
            bool common_var_array_long_ec {false};
            CommonStructMember common_var_array_long {TypeObjectUtils::build_common_struct_member(member_id_var_array_long, member_flags_var_array_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_long, common_var_array_long_ec))};
            if (!common_var_array_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_long = "var_array_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_long;
            ann_custom_ArrayMultiDimensionLiteralsLong.reset();
            CompleteMemberDetail detail_var_array_long = TypeObjectUtils::build_complete_member_detail(name_var_array_long, member_ann_builtin_var_array_long, ann_custom_ArrayMultiDimensionLiteralsLong);
            CompleteStructMember member_var_array_long = TypeObjectUtils::build_complete_struct_member(common_var_array_long, detail_var_array_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLiteralsLong, member_var_array_long);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLiteralsLong = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLiteralsLong, header_ArrayMultiDimensionLiteralsLong, member_seq_ArrayMultiDimensionLiteralsLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLiteralsLong, type_name_ArrayMultiDimensionLiteralsLong.to_string(), type_ids_ArrayMultiDimensionLiteralsLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLiteralsLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLiteralsULong_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLiteralsULong)
{

    ReturnCode_t return_code_ArrayMultiDimensionLiteralsULong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLiteralsULong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLiteralsULong", type_ids_ArrayMultiDimensionLiteralsULong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLiteralsULong)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLiteralsULong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLiteralsULong = "ArrayMultiDimensionLiteralsULong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLiteralsULong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLiteralsULong;
        CompleteTypeDetail detail_ArrayMultiDimensionLiteralsULong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLiteralsULong, ann_custom_ArrayMultiDimensionLiteralsULong, type_name_ArrayMultiDimensionLiteralsULong.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLiteralsULong;
        header_ArrayMultiDimensionLiteralsULong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLiteralsULong);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLiteralsULong;
        {
            TypeIdentifierPair type_ids_var_array_ulong;
            ReturnCode_t return_code_var_array_ulong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_ulong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint32_t_10_10_5", type_ids_var_array_ulong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_ulong)
            {
                return_code_var_array_ulong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_var_array_ulong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_ulong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint32_t_10_10_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint32_t_10_10_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_ulong, element_identifier_anonymous_array_uint32_t_10_10_5_ec))};
                if (!element_identifier_anonymous_array_uint32_t_10_10_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint32_t_10_10_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_ulong.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint32_t_10_10_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint32_t_10_10_5 = 0;
                PlainCollectionHeader header_anonymous_array_uint32_t_10_10_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint32_t_10_10_5, element_flags_anonymous_array_uint32_t_10_10_5);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint32_t_10_10_5, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint32_t_10_10_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint32_t_10_10_5", type_ids_var_array_ulong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint32_t_10_10_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_ulong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_ulong = 0x00000000;
            bool common_var_array_ulong_ec {false};
            CommonStructMember common_var_array_ulong {TypeObjectUtils::build_common_struct_member(member_id_var_array_ulong, member_flags_var_array_ulong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_ulong, common_var_array_ulong_ec))};
            if (!common_var_array_ulong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_ulong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_ulong = "var_array_ulong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_ulong;
            ann_custom_ArrayMultiDimensionLiteralsULong.reset();
            CompleteMemberDetail detail_var_array_ulong = TypeObjectUtils::build_complete_member_detail(name_var_array_ulong, member_ann_builtin_var_array_ulong, ann_custom_ArrayMultiDimensionLiteralsULong);
            CompleteStructMember member_var_array_ulong = TypeObjectUtils::build_complete_struct_member(common_var_array_ulong, detail_var_array_ulong);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLiteralsULong, member_var_array_ulong);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLiteralsULong = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLiteralsULong, header_ArrayMultiDimensionLiteralsULong, member_seq_ArrayMultiDimensionLiteralsULong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLiteralsULong, type_name_ArrayMultiDimensionLiteralsULong.to_string(), type_ids_ArrayMultiDimensionLiteralsULong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLiteralsULong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLiteralsLongLong_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLiteralsLongLong)
{

    ReturnCode_t return_code_ArrayMultiDimensionLiteralsLongLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLiteralsLongLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLiteralsLongLong", type_ids_ArrayMultiDimensionLiteralsLongLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLiteralsLongLong)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLiteralsLongLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLiteralsLongLong = "ArrayMultiDimensionLiteralsLongLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLiteralsLongLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLiteralsLongLong;
        CompleteTypeDetail detail_ArrayMultiDimensionLiteralsLongLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLiteralsLongLong, ann_custom_ArrayMultiDimensionLiteralsLongLong, type_name_ArrayMultiDimensionLiteralsLongLong.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLiteralsLongLong;
        header_ArrayMultiDimensionLiteralsLongLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLiteralsLongLong);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLiteralsLongLong;
        {
            TypeIdentifierPair type_ids_var_array_longlong;
            ReturnCode_t return_code_var_array_longlong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_longlong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int64_t_5_10_5", type_ids_var_array_longlong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_longlong)
            {
                return_code_var_array_longlong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int64_t", type_ids_var_array_longlong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_longlong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int64_t_5_10_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int64_t_5_10_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_longlong, element_identifier_anonymous_array_int64_t_5_10_5_ec))};
                if (!element_identifier_anonymous_array_int64_t_5_10_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int64_t_5_10_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_longlong.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int64_t_5_10_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int64_t_5_10_5 = 0;
                PlainCollectionHeader header_anonymous_array_int64_t_5_10_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int64_t_5_10_5, element_flags_anonymous_array_int64_t_5_10_5);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int64_t_5_10_5, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int64_t_5_10_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int64_t_5_10_5", type_ids_var_array_longlong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int64_t_5_10_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_longlong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_longlong = 0x00000000;
            bool common_var_array_longlong_ec {false};
            CommonStructMember common_var_array_longlong {TypeObjectUtils::build_common_struct_member(member_id_var_array_longlong, member_flags_var_array_longlong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_longlong, common_var_array_longlong_ec))};
            if (!common_var_array_longlong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_longlong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_longlong = "var_array_longlong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_longlong;
            ann_custom_ArrayMultiDimensionLiteralsLongLong.reset();
            CompleteMemberDetail detail_var_array_longlong = TypeObjectUtils::build_complete_member_detail(name_var_array_longlong, member_ann_builtin_var_array_longlong, ann_custom_ArrayMultiDimensionLiteralsLongLong);
            CompleteStructMember member_var_array_longlong = TypeObjectUtils::build_complete_struct_member(common_var_array_longlong, detail_var_array_longlong);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLiteralsLongLong, member_var_array_longlong);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLiteralsLongLong = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLiteralsLongLong, header_ArrayMultiDimensionLiteralsLongLong, member_seq_ArrayMultiDimensionLiteralsLongLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLiteralsLongLong, type_name_ArrayMultiDimensionLiteralsLongLong.to_string(), type_ids_ArrayMultiDimensionLiteralsLongLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLiteralsLongLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLiteralsULongLong_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLiteralsULongLong)
{

    ReturnCode_t return_code_ArrayMultiDimensionLiteralsULongLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLiteralsULongLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLiteralsULongLong", type_ids_ArrayMultiDimensionLiteralsULongLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLiteralsULongLong)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLiteralsULongLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLiteralsULongLong = "ArrayMultiDimensionLiteralsULongLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLiteralsULongLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLiteralsULongLong;
        CompleteTypeDetail detail_ArrayMultiDimensionLiteralsULongLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLiteralsULongLong, ann_custom_ArrayMultiDimensionLiteralsULongLong, type_name_ArrayMultiDimensionLiteralsULongLong.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLiteralsULongLong;
        header_ArrayMultiDimensionLiteralsULongLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLiteralsULongLong);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLiteralsULongLong;
        {
            TypeIdentifierPair type_ids_var_array_ulonglong;
            ReturnCode_t return_code_var_array_ulonglong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_ulonglong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint64_t_10_10_10", type_ids_var_array_ulonglong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_ulonglong)
            {
                return_code_var_array_ulonglong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint64_t", type_ids_var_array_ulonglong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_ulonglong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint64_t_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint64_t_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_ulonglong, element_identifier_anonymous_array_uint64_t_10_10_10_ec))};
                if (!element_identifier_anonymous_array_uint64_t_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint64_t_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_ulonglong.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint64_t_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint64_t_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_uint64_t_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint64_t_10_10_10, element_flags_anonymous_array_uint64_t_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint64_t_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint64_t_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint64_t_10_10_10", type_ids_var_array_ulonglong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint64_t_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_ulonglong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_ulonglong = 0x00000000;
            bool common_var_array_ulonglong_ec {false};
            CommonStructMember common_var_array_ulonglong {TypeObjectUtils::build_common_struct_member(member_id_var_array_ulonglong, member_flags_var_array_ulonglong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_ulonglong, common_var_array_ulonglong_ec))};
            if (!common_var_array_ulonglong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_ulonglong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_ulonglong = "var_array_ulonglong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_ulonglong;
            ann_custom_ArrayMultiDimensionLiteralsULongLong.reset();
            CompleteMemberDetail detail_var_array_ulonglong = TypeObjectUtils::build_complete_member_detail(name_var_array_ulonglong, member_ann_builtin_var_array_ulonglong, ann_custom_ArrayMultiDimensionLiteralsULongLong);
            CompleteStructMember member_var_array_ulonglong = TypeObjectUtils::build_complete_struct_member(common_var_array_ulonglong, detail_var_array_ulonglong);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLiteralsULongLong, member_var_array_ulonglong);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLiteralsULongLong = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLiteralsULongLong, header_ArrayMultiDimensionLiteralsULongLong, member_seq_ArrayMultiDimensionLiteralsULongLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLiteralsULongLong, type_name_ArrayMultiDimensionLiteralsULongLong.to_string(), type_ids_ArrayMultiDimensionLiteralsULongLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLiteralsULongLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLiteralsFloat_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLiteralsFloat)
{

    ReturnCode_t return_code_ArrayMultiDimensionLiteralsFloat {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLiteralsFloat =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLiteralsFloat", type_ids_ArrayMultiDimensionLiteralsFloat);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLiteralsFloat)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLiteralsFloat = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLiteralsFloat = "ArrayMultiDimensionLiteralsFloat";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLiteralsFloat;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLiteralsFloat;
        CompleteTypeDetail detail_ArrayMultiDimensionLiteralsFloat = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLiteralsFloat, ann_custom_ArrayMultiDimensionLiteralsFloat, type_name_ArrayMultiDimensionLiteralsFloat.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLiteralsFloat;
        header_ArrayMultiDimensionLiteralsFloat = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLiteralsFloat);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLiteralsFloat;
        {
            TypeIdentifierPair type_ids_var_array_float;
            ReturnCode_t return_code_var_array_float {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_float =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_float_10_5_10", type_ids_var_array_float);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_float)
            {
                return_code_var_array_float =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_float", type_ids_var_array_float);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_float)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_float_10_5_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_float_10_5_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_float, element_identifier_anonymous_array_float_10_5_10_ec))};
                if (!element_identifier_anonymous_array_float_10_5_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_float_10_5_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_float.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_float_10_5_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_float_10_5_10 = 0;
                PlainCollectionHeader header_anonymous_array_float_10_5_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_float_10_5_10, element_flags_anonymous_array_float_10_5_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_float_10_5_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_float_10_5_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_float_10_5_10", type_ids_var_array_float))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_float_10_5_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_float = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_float = 0x00000000;
            bool common_var_array_float_ec {false};
            CommonStructMember common_var_array_float {TypeObjectUtils::build_common_struct_member(member_id_var_array_float, member_flags_var_array_float, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_float, common_var_array_float_ec))};
            if (!common_var_array_float_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_float member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_float = "var_array_float";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_float;
            ann_custom_ArrayMultiDimensionLiteralsFloat.reset();
            CompleteMemberDetail detail_var_array_float = TypeObjectUtils::build_complete_member_detail(name_var_array_float, member_ann_builtin_var_array_float, ann_custom_ArrayMultiDimensionLiteralsFloat);
            CompleteStructMember member_var_array_float = TypeObjectUtils::build_complete_struct_member(common_var_array_float, detail_var_array_float);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLiteralsFloat, member_var_array_float);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLiteralsFloat = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLiteralsFloat, header_ArrayMultiDimensionLiteralsFloat, member_seq_ArrayMultiDimensionLiteralsFloat);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLiteralsFloat, type_name_ArrayMultiDimensionLiteralsFloat.to_string(), type_ids_ArrayMultiDimensionLiteralsFloat))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLiteralsFloat already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLiteralsDouble_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLiteralsDouble)
{

    ReturnCode_t return_code_ArrayMultiDimensionLiteralsDouble {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLiteralsDouble =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLiteralsDouble", type_ids_ArrayMultiDimensionLiteralsDouble);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLiteralsDouble)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLiteralsDouble = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLiteralsDouble = "ArrayMultiDimensionLiteralsDouble";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLiteralsDouble;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLiteralsDouble;
        CompleteTypeDetail detail_ArrayMultiDimensionLiteralsDouble = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLiteralsDouble, ann_custom_ArrayMultiDimensionLiteralsDouble, type_name_ArrayMultiDimensionLiteralsDouble.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLiteralsDouble;
        header_ArrayMultiDimensionLiteralsDouble = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLiteralsDouble);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLiteralsDouble;
        {
            TypeIdentifierPair type_ids_var_array_double;
            ReturnCode_t return_code_var_array_double {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_double =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_double_5_10_5", type_ids_var_array_double);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_double)
            {
                return_code_var_array_double =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_double", type_ids_var_array_double);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_double)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_double_5_10_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_double_5_10_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_double, element_identifier_anonymous_array_double_5_10_5_ec))};
                if (!element_identifier_anonymous_array_double_5_10_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_double_5_10_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_double.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_double_5_10_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_double_5_10_5 = 0;
                PlainCollectionHeader header_anonymous_array_double_5_10_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_double_5_10_5, element_flags_anonymous_array_double_5_10_5);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_double_5_10_5, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_double_5_10_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_double_5_10_5", type_ids_var_array_double))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_double_5_10_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_double = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_double = 0x00000000;
            bool common_var_array_double_ec {false};
            CommonStructMember common_var_array_double {TypeObjectUtils::build_common_struct_member(member_id_var_array_double, member_flags_var_array_double, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_double, common_var_array_double_ec))};
            if (!common_var_array_double_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_double member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_double = "var_array_double";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_double;
            ann_custom_ArrayMultiDimensionLiteralsDouble.reset();
            CompleteMemberDetail detail_var_array_double = TypeObjectUtils::build_complete_member_detail(name_var_array_double, member_ann_builtin_var_array_double, ann_custom_ArrayMultiDimensionLiteralsDouble);
            CompleteStructMember member_var_array_double = TypeObjectUtils::build_complete_struct_member(common_var_array_double, detail_var_array_double);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLiteralsDouble, member_var_array_double);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLiteralsDouble = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLiteralsDouble, header_ArrayMultiDimensionLiteralsDouble, member_seq_ArrayMultiDimensionLiteralsDouble);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLiteralsDouble, type_name_ArrayMultiDimensionLiteralsDouble.to_string(), type_ids_ArrayMultiDimensionLiteralsDouble))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLiteralsDouble already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLiteralsLongDouble_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLiteralsLongDouble)
{

    ReturnCode_t return_code_ArrayMultiDimensionLiteralsLongDouble {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLiteralsLongDouble =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLiteralsLongDouble", type_ids_ArrayMultiDimensionLiteralsLongDouble);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLiteralsLongDouble)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLiteralsLongDouble = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLiteralsLongDouble = "ArrayMultiDimensionLiteralsLongDouble";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLiteralsLongDouble;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLiteralsLongDouble;
        CompleteTypeDetail detail_ArrayMultiDimensionLiteralsLongDouble = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLiteralsLongDouble, ann_custom_ArrayMultiDimensionLiteralsLongDouble, type_name_ArrayMultiDimensionLiteralsLongDouble.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLiteralsLongDouble;
        header_ArrayMultiDimensionLiteralsLongDouble = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLiteralsLongDouble);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLiteralsLongDouble;
        {
            TypeIdentifierPair type_ids_var_array_longdouble;
            ReturnCode_t return_code_var_array_longdouble {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_longdouble =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_longdouble_5_5_10", type_ids_var_array_longdouble);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_longdouble)
            {
                return_code_var_array_longdouble =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_longdouble", type_ids_var_array_longdouble);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_longdouble)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_longdouble_5_5_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_longdouble_5_5_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_longdouble, element_identifier_anonymous_array_longdouble_5_5_10_ec))};
                if (!element_identifier_anonymous_array_longdouble_5_5_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_longdouble_5_5_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_longdouble.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_longdouble_5_5_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_longdouble_5_5_10 = 0;
                PlainCollectionHeader header_anonymous_array_longdouble_5_5_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_longdouble_5_5_10, element_flags_anonymous_array_longdouble_5_5_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_longdouble_5_5_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_longdouble_5_5_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_longdouble_5_5_10", type_ids_var_array_longdouble))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_longdouble_5_5_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_longdouble = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_longdouble = 0x00000000;
            bool common_var_array_longdouble_ec {false};
            CommonStructMember common_var_array_longdouble {TypeObjectUtils::build_common_struct_member(member_id_var_array_longdouble, member_flags_var_array_longdouble, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_longdouble, common_var_array_longdouble_ec))};
            if (!common_var_array_longdouble_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_longdouble member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_longdouble = "var_array_longdouble";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_longdouble;
            ann_custom_ArrayMultiDimensionLiteralsLongDouble.reset();
            CompleteMemberDetail detail_var_array_longdouble = TypeObjectUtils::build_complete_member_detail(name_var_array_longdouble, member_ann_builtin_var_array_longdouble, ann_custom_ArrayMultiDimensionLiteralsLongDouble);
            CompleteStructMember member_var_array_longdouble = TypeObjectUtils::build_complete_struct_member(common_var_array_longdouble, detail_var_array_longdouble);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLiteralsLongDouble, member_var_array_longdouble);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLiteralsLongDouble = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLiteralsLongDouble, header_ArrayMultiDimensionLiteralsLongDouble, member_seq_ArrayMultiDimensionLiteralsLongDouble);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLiteralsLongDouble, type_name_ArrayMultiDimensionLiteralsLongDouble.to_string(), type_ids_ArrayMultiDimensionLiteralsLongDouble))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLiteralsLongDouble already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLiteralsBoolean_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLiteralsBoolean)
{

    ReturnCode_t return_code_ArrayMultiDimensionLiteralsBoolean {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLiteralsBoolean =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLiteralsBoolean", type_ids_ArrayMultiDimensionLiteralsBoolean);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLiteralsBoolean)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLiteralsBoolean = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLiteralsBoolean = "ArrayMultiDimensionLiteralsBoolean";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLiteralsBoolean;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLiteralsBoolean;
        CompleteTypeDetail detail_ArrayMultiDimensionLiteralsBoolean = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLiteralsBoolean, ann_custom_ArrayMultiDimensionLiteralsBoolean, type_name_ArrayMultiDimensionLiteralsBoolean.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLiteralsBoolean;
        header_ArrayMultiDimensionLiteralsBoolean = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLiteralsBoolean);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLiteralsBoolean;
        {
            TypeIdentifierPair type_ids_var_array_boolean;
            ReturnCode_t return_code_var_array_boolean {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_boolean =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_bool_10_5_5", type_ids_var_array_boolean);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_boolean)
            {
                return_code_var_array_boolean =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_bool", type_ids_var_array_boolean);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_boolean)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_bool_10_5_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_bool_10_5_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_boolean, element_identifier_anonymous_array_bool_10_5_5_ec))};
                if (!element_identifier_anonymous_array_bool_10_5_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_bool_10_5_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_boolean.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_bool_10_5_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_bool_10_5_5 = 0;
                PlainCollectionHeader header_anonymous_array_bool_10_5_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_bool_10_5_5, element_flags_anonymous_array_bool_10_5_5);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_bool_10_5_5, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_bool_10_5_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_bool_10_5_5", type_ids_var_array_boolean))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_bool_10_5_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_boolean = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_boolean = 0x00000000;
            bool common_var_array_boolean_ec {false};
            CommonStructMember common_var_array_boolean {TypeObjectUtils::build_common_struct_member(member_id_var_array_boolean, member_flags_var_array_boolean, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_boolean, common_var_array_boolean_ec))};
            if (!common_var_array_boolean_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_boolean member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_boolean = "var_array_boolean";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_boolean;
            ann_custom_ArrayMultiDimensionLiteralsBoolean.reset();
            CompleteMemberDetail detail_var_array_boolean = TypeObjectUtils::build_complete_member_detail(name_var_array_boolean, member_ann_builtin_var_array_boolean, ann_custom_ArrayMultiDimensionLiteralsBoolean);
            CompleteStructMember member_var_array_boolean = TypeObjectUtils::build_complete_struct_member(common_var_array_boolean, detail_var_array_boolean);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLiteralsBoolean, member_var_array_boolean);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLiteralsBoolean = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLiteralsBoolean, header_ArrayMultiDimensionLiteralsBoolean, member_seq_ArrayMultiDimensionLiteralsBoolean);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLiteralsBoolean, type_name_ArrayMultiDimensionLiteralsBoolean.to_string(), type_ids_ArrayMultiDimensionLiteralsBoolean))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLiteralsBoolean already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLiteralsOctet_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLiteralsOctet)
{

    ReturnCode_t return_code_ArrayMultiDimensionLiteralsOctet {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLiteralsOctet =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLiteralsOctet", type_ids_ArrayMultiDimensionLiteralsOctet);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLiteralsOctet)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLiteralsOctet = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLiteralsOctet = "ArrayMultiDimensionLiteralsOctet";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLiteralsOctet;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLiteralsOctet;
        CompleteTypeDetail detail_ArrayMultiDimensionLiteralsOctet = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLiteralsOctet, ann_custom_ArrayMultiDimensionLiteralsOctet, type_name_ArrayMultiDimensionLiteralsOctet.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLiteralsOctet;
        header_ArrayMultiDimensionLiteralsOctet = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLiteralsOctet);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLiteralsOctet;
        {
            TypeIdentifierPair type_ids_var_array_octet;
            ReturnCode_t return_code_var_array_octet {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_octet =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_byte_5_10_5", type_ids_var_array_octet);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_octet)
            {
                return_code_var_array_octet =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_byte", type_ids_var_array_octet);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_octet)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_byte_5_10_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_byte_5_10_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_octet, element_identifier_anonymous_array_byte_5_10_5_ec))};
                if (!element_identifier_anonymous_array_byte_5_10_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_byte_5_10_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_octet.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_byte_5_10_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_byte_5_10_5 = 0;
                PlainCollectionHeader header_anonymous_array_byte_5_10_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_byte_5_10_5, element_flags_anonymous_array_byte_5_10_5);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_byte_5_10_5, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_byte_5_10_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_byte_5_10_5", type_ids_var_array_octet))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_byte_5_10_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_octet = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_octet = 0x00000000;
            bool common_var_array_octet_ec {false};
            CommonStructMember common_var_array_octet {TypeObjectUtils::build_common_struct_member(member_id_var_array_octet, member_flags_var_array_octet, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_octet, common_var_array_octet_ec))};
            if (!common_var_array_octet_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_octet member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_octet = "var_array_octet";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_octet;
            ann_custom_ArrayMultiDimensionLiteralsOctet.reset();
            CompleteMemberDetail detail_var_array_octet = TypeObjectUtils::build_complete_member_detail(name_var_array_octet, member_ann_builtin_var_array_octet, ann_custom_ArrayMultiDimensionLiteralsOctet);
            CompleteStructMember member_var_array_octet = TypeObjectUtils::build_complete_struct_member(common_var_array_octet, detail_var_array_octet);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLiteralsOctet, member_var_array_octet);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLiteralsOctet = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLiteralsOctet, header_ArrayMultiDimensionLiteralsOctet, member_seq_ArrayMultiDimensionLiteralsOctet);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLiteralsOctet, type_name_ArrayMultiDimensionLiteralsOctet.to_string(), type_ids_ArrayMultiDimensionLiteralsOctet))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLiteralsOctet already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLiteralsChar_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLiteralsChar)
{

    ReturnCode_t return_code_ArrayMultiDimensionLiteralsChar {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLiteralsChar =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLiteralsChar", type_ids_ArrayMultiDimensionLiteralsChar);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLiteralsChar)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLiteralsChar = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLiteralsChar = "ArrayMultiDimensionLiteralsChar";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLiteralsChar;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLiteralsChar;
        CompleteTypeDetail detail_ArrayMultiDimensionLiteralsChar = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLiteralsChar, ann_custom_ArrayMultiDimensionLiteralsChar, type_name_ArrayMultiDimensionLiteralsChar.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLiteralsChar;
        header_ArrayMultiDimensionLiteralsChar = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLiteralsChar);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLiteralsChar;
        {
            TypeIdentifierPair type_ids_var_array_char;
            ReturnCode_t return_code_var_array_char {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_char =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_char_10_5_10", type_ids_var_array_char);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_char)
            {
                return_code_var_array_char =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_char", type_ids_var_array_char);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_char)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_char_10_5_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_char_10_5_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_char, element_identifier_anonymous_array_char_10_5_10_ec))};
                if (!element_identifier_anonymous_array_char_10_5_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_char_10_5_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_char.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_char_10_5_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_char_10_5_10 = 0;
                PlainCollectionHeader header_anonymous_array_char_10_5_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_char_10_5_10, element_flags_anonymous_array_char_10_5_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_char_10_5_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_char_10_5_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_char_10_5_10", type_ids_var_array_char))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_char_10_5_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_char = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_char = 0x00000000;
            bool common_var_array_char_ec {false};
            CommonStructMember common_var_array_char {TypeObjectUtils::build_common_struct_member(member_id_var_array_char, member_flags_var_array_char, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_char, common_var_array_char_ec))};
            if (!common_var_array_char_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_char member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_char = "var_array_char";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_char;
            ann_custom_ArrayMultiDimensionLiteralsChar.reset();
            CompleteMemberDetail detail_var_array_char = TypeObjectUtils::build_complete_member_detail(name_var_array_char, member_ann_builtin_var_array_char, ann_custom_ArrayMultiDimensionLiteralsChar);
            CompleteStructMember member_var_array_char = TypeObjectUtils::build_complete_struct_member(common_var_array_char, detail_var_array_char);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLiteralsChar, member_var_array_char);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLiteralsChar = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLiteralsChar, header_ArrayMultiDimensionLiteralsChar, member_seq_ArrayMultiDimensionLiteralsChar);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLiteralsChar, type_name_ArrayMultiDimensionLiteralsChar.to_string(), type_ids_ArrayMultiDimensionLiteralsChar))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLiteralsChar already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLiteralsWChar_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLiteralsWChar)
{

    ReturnCode_t return_code_ArrayMultiDimensionLiteralsWChar {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLiteralsWChar =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLiteralsWChar", type_ids_ArrayMultiDimensionLiteralsWChar);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLiteralsWChar)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLiteralsWChar = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLiteralsWChar = "ArrayMultiDimensionLiteralsWChar";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLiteralsWChar;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLiteralsWChar;
        CompleteTypeDetail detail_ArrayMultiDimensionLiteralsWChar = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLiteralsWChar, ann_custom_ArrayMultiDimensionLiteralsWChar, type_name_ArrayMultiDimensionLiteralsWChar.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLiteralsWChar;
        header_ArrayMultiDimensionLiteralsWChar = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLiteralsWChar);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLiteralsWChar;
        {
            TypeIdentifierPair type_ids_var_array_wchar;
            ReturnCode_t return_code_var_array_wchar {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_wchar =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_wchar_t_10_10_5", type_ids_var_array_wchar);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_wchar)
            {
                return_code_var_array_wchar =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_wchar_t", type_ids_var_array_wchar);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_wchar)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_wchar_t_10_10_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_wchar_t_10_10_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_wchar, element_identifier_anonymous_array_wchar_t_10_10_5_ec))};
                if (!element_identifier_anonymous_array_wchar_t_10_10_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_wchar_t_10_10_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_wchar.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_wchar_t_10_10_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_wchar_t_10_10_5 = 0;
                PlainCollectionHeader header_anonymous_array_wchar_t_10_10_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_wchar_t_10_10_5, element_flags_anonymous_array_wchar_t_10_10_5);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_wchar_t_10_10_5, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_wchar_t_10_10_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_wchar_t_10_10_5", type_ids_var_array_wchar))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_wchar_t_10_10_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_wchar = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_wchar = 0x00000000;
            bool common_var_array_wchar_ec {false};
            CommonStructMember common_var_array_wchar {TypeObjectUtils::build_common_struct_member(member_id_var_array_wchar, member_flags_var_array_wchar, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_wchar, common_var_array_wchar_ec))};
            if (!common_var_array_wchar_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_wchar member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_wchar = "var_array_wchar";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_wchar;
            ann_custom_ArrayMultiDimensionLiteralsWChar.reset();
            CompleteMemberDetail detail_var_array_wchar = TypeObjectUtils::build_complete_member_detail(name_var_array_wchar, member_ann_builtin_var_array_wchar, ann_custom_ArrayMultiDimensionLiteralsWChar);
            CompleteStructMember member_var_array_wchar = TypeObjectUtils::build_complete_struct_member(common_var_array_wchar, detail_var_array_wchar);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLiteralsWChar, member_var_array_wchar);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLiteralsWChar = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLiteralsWChar, header_ArrayMultiDimensionLiteralsWChar, member_seq_ArrayMultiDimensionLiteralsWChar);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLiteralsWChar, type_name_ArrayMultiDimensionLiteralsWChar.to_string(), type_ids_ArrayMultiDimensionLiteralsWChar))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLiteralsWChar already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLiteralsString_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLiteralsString)
{

    ReturnCode_t return_code_ArrayMultiDimensionLiteralsString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLiteralsString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLiteralsString", type_ids_ArrayMultiDimensionLiteralsString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLiteralsString)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLiteralsString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLiteralsString = "ArrayMultiDimensionLiteralsString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLiteralsString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLiteralsString;
        CompleteTypeDetail detail_ArrayMultiDimensionLiteralsString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLiteralsString, ann_custom_ArrayMultiDimensionLiteralsString, type_name_ArrayMultiDimensionLiteralsString.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLiteralsString;
        header_ArrayMultiDimensionLiteralsString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLiteralsString);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLiteralsString;
        {
            TypeIdentifierPair type_ids_var_array_string;
            ReturnCode_t return_code_var_array_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_anonymous_string_unbounded_5_10_5", type_ids_var_array_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_string)
            {
                return_code_var_array_string =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_string_unbounded", type_ids_var_array_string);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_string)
                {
                    {
                        SBound bound = 0;
                        StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                                "anonymous_string_unbounded", type_ids_var_array_string))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_array_anonymous_string_unbounded_5_10_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_anonymous_string_unbounded_5_10_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_string, element_identifier_anonymous_array_anonymous_string_unbounded_5_10_5_ec))};
                if (!element_identifier_anonymous_array_anonymous_string_unbounded_5_10_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_anonymous_string_unbounded_5_10_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_string.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_anonymous_string_unbounded_5_10_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_anonymous_string_unbounded_5_10_5 = 0;
                PlainCollectionHeader header_anonymous_array_anonymous_string_unbounded_5_10_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_anonymous_string_unbounded_5_10_5, element_flags_anonymous_array_anonymous_string_unbounded_5_10_5);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_anonymous_string_unbounded_5_10_5, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_anonymous_string_unbounded_5_10_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_anonymous_string_unbounded_5_10_5", type_ids_var_array_string))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_anonymous_string_unbounded_5_10_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_string = 0x00000000;
            bool common_var_array_string_ec {false};
            CommonStructMember common_var_array_string {TypeObjectUtils::build_common_struct_member(member_id_var_array_string, member_flags_var_array_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_string, common_var_array_string_ec))};
            if (!common_var_array_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_string = "var_array_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_string;
            ann_custom_ArrayMultiDimensionLiteralsString.reset();
            CompleteMemberDetail detail_var_array_string = TypeObjectUtils::build_complete_member_detail(name_var_array_string, member_ann_builtin_var_array_string, ann_custom_ArrayMultiDimensionLiteralsString);
            CompleteStructMember member_var_array_string = TypeObjectUtils::build_complete_struct_member(common_var_array_string, detail_var_array_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLiteralsString, member_var_array_string);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLiteralsString = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLiteralsString, header_ArrayMultiDimensionLiteralsString, member_seq_ArrayMultiDimensionLiteralsString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLiteralsString, type_name_ArrayMultiDimensionLiteralsString.to_string(), type_ids_ArrayMultiDimensionLiteralsString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLiteralsString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLiteralsWString_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLiteralsWString)
{

    ReturnCode_t return_code_ArrayMultiDimensionLiteralsWString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLiteralsWString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLiteralsWString", type_ids_ArrayMultiDimensionLiteralsWString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLiteralsWString)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLiteralsWString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLiteralsWString = "ArrayMultiDimensionLiteralsWString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLiteralsWString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLiteralsWString;
        CompleteTypeDetail detail_ArrayMultiDimensionLiteralsWString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLiteralsWString, ann_custom_ArrayMultiDimensionLiteralsWString, type_name_ArrayMultiDimensionLiteralsWString.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLiteralsWString;
        header_ArrayMultiDimensionLiteralsWString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLiteralsWString);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLiteralsWString;
        {
            TypeIdentifierPair type_ids_var_array_wstring;
            ReturnCode_t return_code_var_array_wstring {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_wstring =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_anonymous_wstring_unbounded_10_10_10", type_ids_var_array_wstring);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_wstring)
            {
                return_code_var_array_wstring =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_wstring_unbounded", type_ids_var_array_wstring);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_wstring)
                {
                    {
                        SBound bound = 0;
                        StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                                "anonymous_wstring_unbounded", type_ids_var_array_wstring, true))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_wstring_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_array_anonymous_wstring_unbounded_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_anonymous_wstring_unbounded_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_wstring, element_identifier_anonymous_array_anonymous_wstring_unbounded_10_10_10_ec))};
                if (!element_identifier_anonymous_array_anonymous_wstring_unbounded_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_anonymous_wstring_unbounded_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_wstring.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_anonymous_wstring_unbounded_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_anonymous_wstring_unbounded_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_anonymous_wstring_unbounded_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_anonymous_wstring_unbounded_10_10_10, element_flags_anonymous_array_anonymous_wstring_unbounded_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_anonymous_wstring_unbounded_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_anonymous_wstring_unbounded_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_anonymous_wstring_unbounded_10_10_10", type_ids_var_array_wstring))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_anonymous_wstring_unbounded_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_wstring = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_wstring = 0x00000000;
            bool common_var_array_wstring_ec {false};
            CommonStructMember common_var_array_wstring {TypeObjectUtils::build_common_struct_member(member_id_var_array_wstring, member_flags_var_array_wstring, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_wstring, common_var_array_wstring_ec))};
            if (!common_var_array_wstring_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_wstring member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_wstring = "var_array_wstring";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_wstring;
            ann_custom_ArrayMultiDimensionLiteralsWString.reset();
            CompleteMemberDetail detail_var_array_wstring = TypeObjectUtils::build_complete_member_detail(name_var_array_wstring, member_ann_builtin_var_array_wstring, ann_custom_ArrayMultiDimensionLiteralsWString);
            CompleteStructMember member_var_array_wstring = TypeObjectUtils::build_complete_struct_member(common_var_array_wstring, detail_var_array_wstring);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLiteralsWString, member_var_array_wstring);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLiteralsWString = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLiteralsWString, header_ArrayMultiDimensionLiteralsWString, member_seq_ArrayMultiDimensionLiteralsWString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLiteralsWString, type_name_ArrayMultiDimensionLiteralsWString.to_string(), type_ids_ArrayMultiDimensionLiteralsWString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLiteralsWString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLiteralsBoundedString_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLiteralsBoundedString)
{

    ReturnCode_t return_code_ArrayMultiDimensionLiteralsBoundedString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLiteralsBoundedString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLiteralsBoundedString", type_ids_ArrayMultiDimensionLiteralsBoundedString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLiteralsBoundedString)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLiteralsBoundedString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLiteralsBoundedString = "ArrayMultiDimensionLiteralsBoundedString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLiteralsBoundedString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLiteralsBoundedString;
        CompleteTypeDetail detail_ArrayMultiDimensionLiteralsBoundedString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLiteralsBoundedString, ann_custom_ArrayMultiDimensionLiteralsBoundedString, type_name_ArrayMultiDimensionLiteralsBoundedString.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLiteralsBoundedString;
        header_ArrayMultiDimensionLiteralsBoundedString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLiteralsBoundedString);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLiteralsBoundedString;
        {
            TypeIdentifierPair type_ids_var_array_bounded_string;
            ReturnCode_t return_code_var_array_bounded_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_bounded_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_anonymous_string_10_5_10_5", type_ids_var_array_bounded_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bounded_string)
            {
                return_code_var_array_bounded_string =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_bounded_string_helper", type_ids_var_array_bounded_string);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bounded_string)
                {
                ::register_Inner_alias_bounded_string_helper_type_identifier(type_ids_var_array_bounded_string);
                }
                bool element_identifier_anonymous_array_anonymous_string_10_5_10_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_anonymous_string_10_5_10_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bounded_string, element_identifier_anonymous_array_anonymous_string_10_5_10_5_ec))};
                if (!element_identifier_anonymous_array_anonymous_string_10_5_10_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_anonymous_string_10_5_10_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_bounded_string.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_anonymous_string_10_5_10_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_anonymous_string_10_5_10_5 = 0;
                PlainCollectionHeader header_anonymous_array_anonymous_string_10_5_10_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_anonymous_string_10_5_10_5, element_flags_anonymous_array_anonymous_string_10_5_10_5);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_anonymous_string_10_5_10_5, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_anonymous_string_10_5_10_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_anonymous_string_10_5_10_5", type_ids_var_array_bounded_string))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_anonymous_string_10_5_10_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_bounded_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_bounded_string = 0x00000000;
            bool common_var_array_bounded_string_ec {false};
            CommonStructMember common_var_array_bounded_string {TypeObjectUtils::build_common_struct_member(member_id_var_array_bounded_string, member_flags_var_array_bounded_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bounded_string, common_var_array_bounded_string_ec))};
            if (!common_var_array_bounded_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_bounded_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_bounded_string = "var_array_bounded_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_bounded_string;
            ann_custom_ArrayMultiDimensionLiteralsBoundedString.reset();
            CompleteMemberDetail detail_var_array_bounded_string = TypeObjectUtils::build_complete_member_detail(name_var_array_bounded_string, member_ann_builtin_var_array_bounded_string, ann_custom_ArrayMultiDimensionLiteralsBoundedString);
            CompleteStructMember member_var_array_bounded_string = TypeObjectUtils::build_complete_struct_member(common_var_array_bounded_string, detail_var_array_bounded_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLiteralsBoundedString, member_var_array_bounded_string);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLiteralsBoundedString = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLiteralsBoundedString, header_ArrayMultiDimensionLiteralsBoundedString, member_seq_ArrayMultiDimensionLiteralsBoundedString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLiteralsBoundedString, type_name_ArrayMultiDimensionLiteralsBoundedString.to_string(), type_ids_ArrayMultiDimensionLiteralsBoundedString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLiteralsBoundedString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLiteralsBoundedWString_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLiteralsBoundedWString)
{

    ReturnCode_t return_code_ArrayMultiDimensionLiteralsBoundedWString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLiteralsBoundedWString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLiteralsBoundedWString", type_ids_ArrayMultiDimensionLiteralsBoundedWString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLiteralsBoundedWString)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLiteralsBoundedWString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLiteralsBoundedWString = "ArrayMultiDimensionLiteralsBoundedWString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLiteralsBoundedWString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLiteralsBoundedWString;
        CompleteTypeDetail detail_ArrayMultiDimensionLiteralsBoundedWString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLiteralsBoundedWString, ann_custom_ArrayMultiDimensionLiteralsBoundedWString, type_name_ArrayMultiDimensionLiteralsBoundedWString.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLiteralsBoundedWString;
        header_ArrayMultiDimensionLiteralsBoundedWString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLiteralsBoundedWString);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLiteralsBoundedWString;
        {
            TypeIdentifierPair type_ids_var_array_bounded_wstring;
            ReturnCode_t return_code_var_array_bounded_wstring {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_bounded_wstring =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_anonymous_wstring_10_10_10_10", type_ids_var_array_bounded_wstring);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bounded_wstring)
            {
                return_code_var_array_bounded_wstring =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_bounded_wstring_helper", type_ids_var_array_bounded_wstring);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bounded_wstring)
                {
                ::register_Inner_alias_bounded_wstring_helper_type_identifier(type_ids_var_array_bounded_wstring);
                }
                bool element_identifier_anonymous_array_anonymous_wstring_10_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_anonymous_wstring_10_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bounded_wstring, element_identifier_anonymous_array_anonymous_wstring_10_10_10_10_ec))};
                if (!element_identifier_anonymous_array_anonymous_wstring_10_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_anonymous_wstring_10_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_bounded_wstring.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_anonymous_wstring_10_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_anonymous_wstring_10_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_anonymous_wstring_10_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_anonymous_wstring_10_10_10_10, element_flags_anonymous_array_anonymous_wstring_10_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_anonymous_wstring_10_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_anonymous_wstring_10_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_anonymous_wstring_10_10_10_10", type_ids_var_array_bounded_wstring))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_anonymous_wstring_10_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_bounded_wstring = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_bounded_wstring = 0x00000000;
            bool common_var_array_bounded_wstring_ec {false};
            CommonStructMember common_var_array_bounded_wstring {TypeObjectUtils::build_common_struct_member(member_id_var_array_bounded_wstring, member_flags_var_array_bounded_wstring, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bounded_wstring, common_var_array_bounded_wstring_ec))};
            if (!common_var_array_bounded_wstring_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_bounded_wstring member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_bounded_wstring = "var_array_bounded_wstring";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_bounded_wstring;
            ann_custom_ArrayMultiDimensionLiteralsBoundedWString.reset();
            CompleteMemberDetail detail_var_array_bounded_wstring = TypeObjectUtils::build_complete_member_detail(name_var_array_bounded_wstring, member_ann_builtin_var_array_bounded_wstring, ann_custom_ArrayMultiDimensionLiteralsBoundedWString);
            CompleteStructMember member_var_array_bounded_wstring = TypeObjectUtils::build_complete_struct_member(common_var_array_bounded_wstring, detail_var_array_bounded_wstring);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLiteralsBoundedWString, member_var_array_bounded_wstring);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLiteralsBoundedWString = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLiteralsBoundedWString, header_ArrayMultiDimensionLiteralsBoundedWString, member_seq_ArrayMultiDimensionLiteralsBoundedWString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLiteralsBoundedWString, type_name_ArrayMultiDimensionLiteralsBoundedWString.to_string(), type_ids_ArrayMultiDimensionLiteralsBoundedWString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLiteralsBoundedWString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLiteralsEnum_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLiteralsEnum)
{

    ReturnCode_t return_code_ArrayMultiDimensionLiteralsEnum {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLiteralsEnum =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLiteralsEnum", type_ids_ArrayMultiDimensionLiteralsEnum);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLiteralsEnum)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLiteralsEnum = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLiteralsEnum = "ArrayMultiDimensionLiteralsEnum";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLiteralsEnum;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLiteralsEnum;
        CompleteTypeDetail detail_ArrayMultiDimensionLiteralsEnum = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLiteralsEnum, ann_custom_ArrayMultiDimensionLiteralsEnum, type_name_ArrayMultiDimensionLiteralsEnum.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLiteralsEnum;
        header_ArrayMultiDimensionLiteralsEnum = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLiteralsEnum);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLiteralsEnum;
        {
            TypeIdentifierPair type_ids_var_array_enum;
            ReturnCode_t return_code_var_array_enum {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_enum =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_InnerEnumHelper_10_5_10", type_ids_var_array_enum);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_enum)
            {
                return_code_var_array_enum =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerEnumHelper", type_ids_var_array_enum);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_enum)
                {
                ::register_InnerEnumHelper_type_identifier(type_ids_var_array_enum);
                }
                bool element_identifier_anonymous_array_InnerEnumHelper_10_5_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_InnerEnumHelper_10_5_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_enum, element_identifier_anonymous_array_InnerEnumHelper_10_5_10_ec))};
                if (!element_identifier_anonymous_array_InnerEnumHelper_10_5_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_InnerEnumHelper_10_5_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_enum.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_InnerEnumHelper_10_5_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_InnerEnumHelper_10_5_10 = 0;
                PlainCollectionHeader header_anonymous_array_InnerEnumHelper_10_5_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_InnerEnumHelper_10_5_10, element_flags_anonymous_array_InnerEnumHelper_10_5_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_InnerEnumHelper_10_5_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_InnerEnumHelper_10_5_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_InnerEnumHelper_10_5_10", type_ids_var_array_enum))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_InnerEnumHelper_10_5_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_enum = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_enum = 0x00000000;
            bool common_var_array_enum_ec {false};
            CommonStructMember common_var_array_enum {TypeObjectUtils::build_common_struct_member(member_id_var_array_enum, member_flags_var_array_enum, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_enum, common_var_array_enum_ec))};
            if (!common_var_array_enum_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_enum member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_enum = "var_array_enum";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_enum;
            ann_custom_ArrayMultiDimensionLiteralsEnum.reset();
            CompleteMemberDetail detail_var_array_enum = TypeObjectUtils::build_complete_member_detail(name_var_array_enum, member_ann_builtin_var_array_enum, ann_custom_ArrayMultiDimensionLiteralsEnum);
            CompleteStructMember member_var_array_enum = TypeObjectUtils::build_complete_struct_member(common_var_array_enum, detail_var_array_enum);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLiteralsEnum, member_var_array_enum);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLiteralsEnum = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLiteralsEnum, header_ArrayMultiDimensionLiteralsEnum, member_seq_ArrayMultiDimensionLiteralsEnum);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLiteralsEnum, type_name_ArrayMultiDimensionLiteralsEnum.to_string(), type_ids_ArrayMultiDimensionLiteralsEnum))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLiteralsEnum already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLiteralsBitMask_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLiteralsBitMask)
{

    ReturnCode_t return_code_ArrayMultiDimensionLiteralsBitMask {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLiteralsBitMask =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLiteralsBitMask", type_ids_ArrayMultiDimensionLiteralsBitMask);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLiteralsBitMask)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLiteralsBitMask = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLiteralsBitMask = "ArrayMultiDimensionLiteralsBitMask";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLiteralsBitMask;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLiteralsBitMask;
        CompleteTypeDetail detail_ArrayMultiDimensionLiteralsBitMask = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLiteralsBitMask, ann_custom_ArrayMultiDimensionLiteralsBitMask, type_name_ArrayMultiDimensionLiteralsBitMask.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLiteralsBitMask;
        header_ArrayMultiDimensionLiteralsBitMask = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLiteralsBitMask);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLiteralsBitMask;
        {
            TypeIdentifierPair type_ids_var_array_bitmask;
            ReturnCode_t return_code_var_array_bitmask {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_bitmask =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_InnerBitMaskHelper_5_10_5", type_ids_var_array_bitmask);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bitmask)
            {
                return_code_var_array_bitmask =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerBitMaskHelper", type_ids_var_array_bitmask);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bitmask)
                {
                ::register_InnerBitMaskHelper_type_identifier(type_ids_var_array_bitmask);
                }
                bool element_identifier_anonymous_array_InnerBitMaskHelper_5_10_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_InnerBitMaskHelper_5_10_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bitmask, element_identifier_anonymous_array_InnerBitMaskHelper_5_10_5_ec))};
                if (!element_identifier_anonymous_array_InnerBitMaskHelper_5_10_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_InnerBitMaskHelper_5_10_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_bitmask.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_InnerBitMaskHelper_5_10_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_InnerBitMaskHelper_5_10_5 = 0;
                PlainCollectionHeader header_anonymous_array_InnerBitMaskHelper_5_10_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_InnerBitMaskHelper_5_10_5, element_flags_anonymous_array_InnerBitMaskHelper_5_10_5);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_InnerBitMaskHelper_5_10_5, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_InnerBitMaskHelper_5_10_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_InnerBitMaskHelper_5_10_5", type_ids_var_array_bitmask))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_InnerBitMaskHelper_5_10_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_bitmask = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_bitmask = 0x00000000;
            bool common_var_array_bitmask_ec {false};
            CommonStructMember common_var_array_bitmask {TypeObjectUtils::build_common_struct_member(member_id_var_array_bitmask, member_flags_var_array_bitmask, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bitmask, common_var_array_bitmask_ec))};
            if (!common_var_array_bitmask_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_bitmask member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_bitmask = "var_array_bitmask";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_bitmask;
            ann_custom_ArrayMultiDimensionLiteralsBitMask.reset();
            CompleteMemberDetail detail_var_array_bitmask = TypeObjectUtils::build_complete_member_detail(name_var_array_bitmask, member_ann_builtin_var_array_bitmask, ann_custom_ArrayMultiDimensionLiteralsBitMask);
            CompleteStructMember member_var_array_bitmask = TypeObjectUtils::build_complete_struct_member(common_var_array_bitmask, detail_var_array_bitmask);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLiteralsBitMask, member_var_array_bitmask);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLiteralsBitMask = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLiteralsBitMask, header_ArrayMultiDimensionLiteralsBitMask, member_seq_ArrayMultiDimensionLiteralsBitMask);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLiteralsBitMask, type_name_ArrayMultiDimensionLiteralsBitMask.to_string(), type_ids_ArrayMultiDimensionLiteralsBitMask))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLiteralsBitMask already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLiteralsAlias_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLiteralsAlias)
{

    ReturnCode_t return_code_ArrayMultiDimensionLiteralsAlias {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLiteralsAlias =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLiteralsAlias", type_ids_ArrayMultiDimensionLiteralsAlias);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLiteralsAlias)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLiteralsAlias = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLiteralsAlias = "ArrayMultiDimensionLiteralsAlias";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLiteralsAlias;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLiteralsAlias;
        CompleteTypeDetail detail_ArrayMultiDimensionLiteralsAlias = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLiteralsAlias, ann_custom_ArrayMultiDimensionLiteralsAlias, type_name_ArrayMultiDimensionLiteralsAlias.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLiteralsAlias;
        header_ArrayMultiDimensionLiteralsAlias = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLiteralsAlias);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLiteralsAlias;
        {
            TypeIdentifierPair type_ids_var_array_alias;
            ReturnCode_t return_code_var_array_alias {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_alias =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_InnerAliasHelper_10_10_10", type_ids_var_array_alias);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_alias)
            {
                return_code_var_array_alias =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerAliasHelper", type_ids_var_array_alias);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_alias)
                {
                ::register_InnerAliasHelper_type_identifier(type_ids_var_array_alias);
                }
                bool element_identifier_anonymous_array_InnerAliasHelper_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_InnerAliasHelper_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_alias, element_identifier_anonymous_array_InnerAliasHelper_10_10_10_ec))};
                if (!element_identifier_anonymous_array_InnerAliasHelper_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_InnerAliasHelper_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_alias.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_InnerAliasHelper_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_InnerAliasHelper_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_InnerAliasHelper_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_InnerAliasHelper_10_10_10, element_flags_anonymous_array_InnerAliasHelper_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_InnerAliasHelper_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_InnerAliasHelper_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_InnerAliasHelper_10_10_10", type_ids_var_array_alias))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_InnerAliasHelper_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_alias = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_alias = 0x00000000;
            bool common_var_array_alias_ec {false};
            CommonStructMember common_var_array_alias {TypeObjectUtils::build_common_struct_member(member_id_var_array_alias, member_flags_var_array_alias, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_alias, common_var_array_alias_ec))};
            if (!common_var_array_alias_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_alias member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_alias = "var_array_alias";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_alias;
            ann_custom_ArrayMultiDimensionLiteralsAlias.reset();
            CompleteMemberDetail detail_var_array_alias = TypeObjectUtils::build_complete_member_detail(name_var_array_alias, member_ann_builtin_var_array_alias, ann_custom_ArrayMultiDimensionLiteralsAlias);
            CompleteStructMember member_var_array_alias = TypeObjectUtils::build_complete_struct_member(common_var_array_alias, detail_var_array_alias);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLiteralsAlias, member_var_array_alias);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLiteralsAlias = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLiteralsAlias, header_ArrayMultiDimensionLiteralsAlias, member_seq_ArrayMultiDimensionLiteralsAlias);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLiteralsAlias, type_name_ArrayMultiDimensionLiteralsAlias.to_string(), type_ids_ArrayMultiDimensionLiteralsAlias))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLiteralsAlias already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLiteralsSequence_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLiteralsSequence)
{

    ReturnCode_t return_code_ArrayMultiDimensionLiteralsSequence {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLiteralsSequence =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLiteralsSequence", type_ids_ArrayMultiDimensionLiteralsSequence);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLiteralsSequence)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLiteralsSequence = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLiteralsSequence = "ArrayMultiDimensionLiteralsSequence";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLiteralsSequence;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLiteralsSequence;
        CompleteTypeDetail detail_ArrayMultiDimensionLiteralsSequence = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLiteralsSequence, ann_custom_ArrayMultiDimensionLiteralsSequence, type_name_ArrayMultiDimensionLiteralsSequence.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLiteralsSequence;
        header_ArrayMultiDimensionLiteralsSequence = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLiteralsSequence);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLiteralsSequence;
        {
            TypeIdentifierPair type_ids_var_array_sequence;
            ReturnCode_t return_code_var_array_sequence {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_sequence =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_anonymous_sequence_int32_t_unbounded_10_5_10", type_ids_var_array_sequence);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_sequence)
            {
                return_code_var_array_sequence =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_sequence_int32_t_unbounded", type_ids_var_array_sequence);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_sequence)
                {
                    return_code_var_array_sequence =
                        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                        "_int32_t", type_ids_var_array_sequence);

                    if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_sequence)
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                        return;
                    }
                    bool element_identifier_anonymous_sequence_int32_t_unbounded_ec {false};
                    TypeIdentifier* element_identifier_anonymous_sequence_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_sequence, element_identifier_anonymous_sequence_int32_t_unbounded_ec))};
                    if (!element_identifier_anonymous_sequence_int32_t_unbounded_ec)
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                        return;
                    }
                    EquivalenceKind equiv_kind_anonymous_sequence_int32_t_unbounded = EK_COMPLETE;
                    if (TK_NONE == type_ids_var_array_sequence.type_identifier2()._d())
                    {
                        equiv_kind_anonymous_sequence_int32_t_unbounded = EK_BOTH;
                    }
                    CollectionElementFlag element_flags_anonymous_sequence_int32_t_unbounded = 0;
                    PlainCollectionHeader header_anonymous_sequence_int32_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_int32_t_unbounded, element_flags_anonymous_sequence_int32_t_unbounded);
                    {
                        SBound bound = 0;
                        PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_int32_t_unbounded, bound,
                                    eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_int32_t_unbounded));
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_int32_t_unbounded", type_ids_var_array_sequence))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_sequence_int32_t_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_array_anonymous_sequence_int32_t_unbounded_10_5_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_anonymous_sequence_int32_t_unbounded_10_5_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_sequence, element_identifier_anonymous_array_anonymous_sequence_int32_t_unbounded_10_5_10_ec))};
                if (!element_identifier_anonymous_array_anonymous_sequence_int32_t_unbounded_10_5_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_anonymous_sequence_int32_t_unbounded_10_5_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_sequence.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_anonymous_sequence_int32_t_unbounded_10_5_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_anonymous_sequence_int32_t_unbounded_10_5_10 = 0;
                PlainCollectionHeader header_anonymous_array_anonymous_sequence_int32_t_unbounded_10_5_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_anonymous_sequence_int32_t_unbounded_10_5_10, element_flags_anonymous_array_anonymous_sequence_int32_t_unbounded_10_5_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_anonymous_sequence_int32_t_unbounded_10_5_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_anonymous_sequence_int32_t_unbounded_10_5_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_anonymous_sequence_int32_t_unbounded_10_5_10", type_ids_var_array_sequence))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_anonymous_sequence_int32_t_unbounded_10_5_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_sequence = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_sequence = 0x00000000;
            bool common_var_array_sequence_ec {false};
            CommonStructMember common_var_array_sequence {TypeObjectUtils::build_common_struct_member(member_id_var_array_sequence, member_flags_var_array_sequence, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_sequence, common_var_array_sequence_ec))};
            if (!common_var_array_sequence_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_sequence member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_sequence = "var_array_sequence";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_sequence;
            ann_custom_ArrayMultiDimensionLiteralsSequence.reset();
            CompleteMemberDetail detail_var_array_sequence = TypeObjectUtils::build_complete_member_detail(name_var_array_sequence, member_ann_builtin_var_array_sequence, ann_custom_ArrayMultiDimensionLiteralsSequence);
            CompleteStructMember member_var_array_sequence = TypeObjectUtils::build_complete_struct_member(common_var_array_sequence, detail_var_array_sequence);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLiteralsSequence, member_var_array_sequence);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLiteralsSequence = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLiteralsSequence, header_ArrayMultiDimensionLiteralsSequence, member_seq_ArrayMultiDimensionLiteralsSequence);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLiteralsSequence, type_name_ArrayMultiDimensionLiteralsSequence.to_string(), type_ids_ArrayMultiDimensionLiteralsSequence))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLiteralsSequence already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLiteralsMap_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLiteralsMap)
{

    ReturnCode_t return_code_ArrayMultiDimensionLiteralsMap {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLiteralsMap =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLiteralsMap", type_ids_ArrayMultiDimensionLiteralsMap);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLiteralsMap)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLiteralsMap = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLiteralsMap = "ArrayMultiDimensionLiteralsMap";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLiteralsMap;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLiteralsMap;
        CompleteTypeDetail detail_ArrayMultiDimensionLiteralsMap = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLiteralsMap, ann_custom_ArrayMultiDimensionLiteralsMap, type_name_ArrayMultiDimensionLiteralsMap.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLiteralsMap;
        header_ArrayMultiDimensionLiteralsMap = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLiteralsMap);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLiteralsMap;
        {
            TypeIdentifierPair type_ids_var_array_map;
            ReturnCode_t return_code_var_array_map {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_map =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_anonymous_map_int32_t_int32_t_unbounded_5_10_5", type_ids_var_array_map);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_map)
            {
                return_code_var_array_map =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_map_int32_t_int32_t_unbounded", type_ids_var_array_map);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_map)
                {
                    return_code_var_array_map =
                        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                        "_int32_t", type_ids_var_array_map);

                    if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_map)
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                        return;
                    }
                    bool element_identifier_anonymous_map_int32_t_int32_t_unbounded_ec {false};
                    TypeIdentifier* element_identifier_anonymous_map_int32_t_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_map, element_identifier_anonymous_map_int32_t_int32_t_unbounded_ec))};
                    if (!element_identifier_anonymous_map_int32_t_int32_t_unbounded_ec)
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_int32_t_unbounded inconsistent element TypeIdentifier.");
                        return;
                    }
                    return_code_var_array_map =
                        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                        "_int32_t", type_ids_var_array_map);

                    if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_map)
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                        return;
                    }
                    bool key_identifier_anonymous_map_int32_t_int32_t_unbounded_ec {false};
                    TypeIdentifier* key_identifier_anonymous_map_int32_t_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_map, key_identifier_anonymous_map_int32_t_int32_t_unbounded_ec))};
                    if (!key_identifier_anonymous_map_int32_t_int32_t_unbounded_ec)
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_int32_t_unbounded inconsistent key TypeIdentifier.");
                        return;
                    }
                    EquivalenceKind equiv_kind_anonymous_map_int32_t_int32_t_unbounded = EK_BOTH;
                    if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d()) ||
                            (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                            (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                            (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->array_sdefn().header().equiv_kind()) ||
                            (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->array_ldefn().header().equiv_kind()) ||
                            (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_sdefn().header().equiv_kind())) ||
                            (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_ldefn().header().equiv_kind())))
                    {
                        equiv_kind_anonymous_map_int32_t_int32_t_unbounded = EK_COMPLETE;
                    }
                    CollectionElementFlag element_flags_anonymous_map_int32_t_int32_t_unbounded = 0;
                    CollectionElementFlag key_flags_anonymous_map_int32_t_int32_t_unbounded = 0;
                    PlainCollectionHeader header_anonymous_map_int32_t_int32_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_int32_t_unbounded, element_flags_anonymous_map_int32_t_int32_t_unbounded);
                    {
                        SBound bound = 0;
                        PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_int32_t_unbounded, bound,
                                    eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_int32_t_unbounded), key_flags_anonymous_map_int32_t_int32_t_unbounded,
                                    eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_int32_t_unbounded));
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_int32_t_unbounded", type_ids_var_array_map))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_map_int32_t_int32_t_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_5_10_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_5_10_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_map, element_identifier_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_5_10_5_ec))};
                if (!element_identifier_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_5_10_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_5_10_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_map.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_5_10_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_5_10_5 = 0;
                PlainCollectionHeader header_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_5_10_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_5_10_5, element_flags_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_5_10_5);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_5_10_5, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_anonymous_map_int32_t_int32_t_unbounded_5_10_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_anonymous_map_int32_t_int32_t_unbounded_5_10_5", type_ids_var_array_map))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_anonymous_map_int32_t_int32_t_unbounded_5_10_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_map = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_map = 0x00000000;
            bool common_var_array_map_ec {false};
            CommonStructMember common_var_array_map {TypeObjectUtils::build_common_struct_member(member_id_var_array_map, member_flags_var_array_map, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_map, common_var_array_map_ec))};
            if (!common_var_array_map_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_map member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_map = "var_array_map";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_map;
            ann_custom_ArrayMultiDimensionLiteralsMap.reset();
            CompleteMemberDetail detail_var_array_map = TypeObjectUtils::build_complete_member_detail(name_var_array_map, member_ann_builtin_var_array_map, ann_custom_ArrayMultiDimensionLiteralsMap);
            CompleteStructMember member_var_array_map = TypeObjectUtils::build_complete_struct_member(common_var_array_map, detail_var_array_map);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLiteralsMap, member_var_array_map);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLiteralsMap = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLiteralsMap, header_ArrayMultiDimensionLiteralsMap, member_seq_ArrayMultiDimensionLiteralsMap);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLiteralsMap, type_name_ArrayMultiDimensionLiteralsMap.to_string(), type_ids_ArrayMultiDimensionLiteralsMap))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLiteralsMap already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLiteralsUnion_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLiteralsUnion)
{

    ReturnCode_t return_code_ArrayMultiDimensionLiteralsUnion {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLiteralsUnion =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLiteralsUnion", type_ids_ArrayMultiDimensionLiteralsUnion);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLiteralsUnion)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLiteralsUnion = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLiteralsUnion = "ArrayMultiDimensionLiteralsUnion";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLiteralsUnion;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLiteralsUnion;
        CompleteTypeDetail detail_ArrayMultiDimensionLiteralsUnion = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLiteralsUnion, ann_custom_ArrayMultiDimensionLiteralsUnion, type_name_ArrayMultiDimensionLiteralsUnion.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLiteralsUnion;
        header_ArrayMultiDimensionLiteralsUnion = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLiteralsUnion);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLiteralsUnion;
        {
            TypeIdentifierPair type_ids_var_array_union;
            ReturnCode_t return_code_var_array_union {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_union =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_InnerUnionHelper_10_10_10", type_ids_var_array_union);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_union)
            {
                return_code_var_array_union =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerUnionHelper", type_ids_var_array_union);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_union)
                {
                ::register_InnerUnionHelper_type_identifier(type_ids_var_array_union);
                }
                bool element_identifier_anonymous_array_InnerUnionHelper_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_InnerUnionHelper_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_union, element_identifier_anonymous_array_InnerUnionHelper_10_10_10_ec))};
                if (!element_identifier_anonymous_array_InnerUnionHelper_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_InnerUnionHelper_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_union.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_InnerUnionHelper_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_InnerUnionHelper_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_InnerUnionHelper_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_InnerUnionHelper_10_10_10, element_flags_anonymous_array_InnerUnionHelper_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_InnerUnionHelper_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_InnerUnionHelper_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_InnerUnionHelper_10_10_10", type_ids_var_array_union))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_InnerUnionHelper_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_union = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_union = 0x00000000;
            bool common_var_array_union_ec {false};
            CommonStructMember common_var_array_union {TypeObjectUtils::build_common_struct_member(member_id_var_array_union, member_flags_var_array_union, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_union, common_var_array_union_ec))};
            if (!common_var_array_union_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_union member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_union = "var_array_union";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_union;
            ann_custom_ArrayMultiDimensionLiteralsUnion.reset();
            CompleteMemberDetail detail_var_array_union = TypeObjectUtils::build_complete_member_detail(name_var_array_union, member_ann_builtin_var_array_union, ann_custom_ArrayMultiDimensionLiteralsUnion);
            CompleteStructMember member_var_array_union = TypeObjectUtils::build_complete_struct_member(common_var_array_union, detail_var_array_union);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLiteralsUnion, member_var_array_union);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLiteralsUnion = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLiteralsUnion, header_ArrayMultiDimensionLiteralsUnion, member_seq_ArrayMultiDimensionLiteralsUnion);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLiteralsUnion, type_name_ArrayMultiDimensionLiteralsUnion.to_string(), type_ids_ArrayMultiDimensionLiteralsUnion))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLiteralsUnion already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLiteralsStructure_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLiteralsStructure)
{

    ReturnCode_t return_code_ArrayMultiDimensionLiteralsStructure {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLiteralsStructure =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLiteralsStructure", type_ids_ArrayMultiDimensionLiteralsStructure);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLiteralsStructure)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLiteralsStructure = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLiteralsStructure = "ArrayMultiDimensionLiteralsStructure";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLiteralsStructure;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLiteralsStructure;
        CompleteTypeDetail detail_ArrayMultiDimensionLiteralsStructure = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLiteralsStructure, ann_custom_ArrayMultiDimensionLiteralsStructure, type_name_ArrayMultiDimensionLiteralsStructure.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLiteralsStructure;
        header_ArrayMultiDimensionLiteralsStructure = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLiteralsStructure);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLiteralsStructure;
        {
            TypeIdentifierPair type_ids_var_array_structure;
            ReturnCode_t return_code_var_array_structure {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_structure =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_InnerStructureHelper_5_5_10", type_ids_var_array_structure);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_structure)
            {
                return_code_var_array_structure =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerStructureHelper", type_ids_var_array_structure);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_structure)
                {
                ::register_InnerStructureHelper_type_identifier(type_ids_var_array_structure);
                }
                bool element_identifier_anonymous_array_InnerStructureHelper_5_5_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_InnerStructureHelper_5_5_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_structure, element_identifier_anonymous_array_InnerStructureHelper_5_5_10_ec))};
                if (!element_identifier_anonymous_array_InnerStructureHelper_5_5_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_InnerStructureHelper_5_5_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_structure.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_InnerStructureHelper_5_5_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_InnerStructureHelper_5_5_10 = 0;
                PlainCollectionHeader header_anonymous_array_InnerStructureHelper_5_5_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_InnerStructureHelper_5_5_10, element_flags_anonymous_array_InnerStructureHelper_5_5_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(5));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_InnerStructureHelper_5_5_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_InnerStructureHelper_5_5_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_InnerStructureHelper_5_5_10", type_ids_var_array_structure))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_InnerStructureHelper_5_5_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_structure = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_structure = 0x00000000;
            bool common_var_array_structure_ec {false};
            CommonStructMember common_var_array_structure {TypeObjectUtils::build_common_struct_member(member_id_var_array_structure, member_flags_var_array_structure, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_structure, common_var_array_structure_ec))};
            if (!common_var_array_structure_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_structure member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_structure = "var_array_structure";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_structure;
            ann_custom_ArrayMultiDimensionLiteralsStructure.reset();
            CompleteMemberDetail detail_var_array_structure = TypeObjectUtils::build_complete_member_detail(name_var_array_structure, member_ann_builtin_var_array_structure, ann_custom_ArrayMultiDimensionLiteralsStructure);
            CompleteStructMember member_var_array_structure = TypeObjectUtils::build_complete_struct_member(common_var_array_structure, detail_var_array_structure);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLiteralsStructure, member_var_array_structure);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLiteralsStructure = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLiteralsStructure, header_ArrayMultiDimensionLiteralsStructure, member_seq_ArrayMultiDimensionLiteralsStructure);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLiteralsStructure, type_name_ArrayMultiDimensionLiteralsStructure.to_string(), type_ids_ArrayMultiDimensionLiteralsStructure))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLiteralsStructure already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ArrayMultiDimensionLiteralsBitSet_type_identifier(
        TypeIdentifierPair& type_ids_ArrayMultiDimensionLiteralsBitSet)
{

    ReturnCode_t return_code_ArrayMultiDimensionLiteralsBitSet {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ArrayMultiDimensionLiteralsBitSet =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ArrayMultiDimensionLiteralsBitSet", type_ids_ArrayMultiDimensionLiteralsBitSet);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ArrayMultiDimensionLiteralsBitSet)
    {
        StructTypeFlag struct_flags_ArrayMultiDimensionLiteralsBitSet = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ArrayMultiDimensionLiteralsBitSet = "ArrayMultiDimensionLiteralsBitSet";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ArrayMultiDimensionLiteralsBitSet;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ArrayMultiDimensionLiteralsBitSet;
        CompleteTypeDetail detail_ArrayMultiDimensionLiteralsBitSet = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ArrayMultiDimensionLiteralsBitSet, ann_custom_ArrayMultiDimensionLiteralsBitSet, type_name_ArrayMultiDimensionLiteralsBitSet.to_string());
        CompleteStructHeader header_ArrayMultiDimensionLiteralsBitSet;
        header_ArrayMultiDimensionLiteralsBitSet = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ArrayMultiDimensionLiteralsBitSet);
        CompleteStructMemberSeq member_seq_ArrayMultiDimensionLiteralsBitSet;
        {
            TypeIdentifierPair type_ids_var_array_bitset;
            ReturnCode_t return_code_var_array_bitset {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_bitset =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_InnerBitsetHelper_10_10_10", type_ids_var_array_bitset);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bitset)
            {
                return_code_var_array_bitset =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerBitsetHelper", type_ids_var_array_bitset);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_bitset)
                {
                ::register_InnerBitsetHelper_type_identifier(type_ids_var_array_bitset);
                }
                bool element_identifier_anonymous_array_InnerBitsetHelper_10_10_10_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_InnerBitsetHelper_10_10_10 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bitset, element_identifier_anonymous_array_InnerBitsetHelper_10_10_10_ec))};
                if (!element_identifier_anonymous_array_InnerBitsetHelper_10_10_10_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_InnerBitsetHelper_10_10_10 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_bitset.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_InnerBitsetHelper_10_10_10 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_InnerBitsetHelper_10_10_10 = 0;
                PlainCollectionHeader header_anonymous_array_InnerBitsetHelper_10_10_10 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_InnerBitsetHelper_10_10_10, element_flags_anonymous_array_InnerBitsetHelper_10_10_10);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(10));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_InnerBitsetHelper_10_10_10, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_InnerBitsetHelper_10_10_10));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_InnerBitsetHelper_10_10_10", type_ids_var_array_bitset))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_InnerBitsetHelper_10_10_10 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_bitset = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_bitset = 0x00000000;
            bool common_var_array_bitset_ec {false};
            CommonStructMember common_var_array_bitset {TypeObjectUtils::build_common_struct_member(member_id_var_array_bitset, member_flags_var_array_bitset, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_bitset, common_var_array_bitset_ec))};
            if (!common_var_array_bitset_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_bitset member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_bitset = "var_array_bitset";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_bitset;
            ann_custom_ArrayMultiDimensionLiteralsBitSet.reset();
            CompleteMemberDetail detail_var_array_bitset = TypeObjectUtils::build_complete_member_detail(name_var_array_bitset, member_ann_builtin_var_array_bitset, ann_custom_ArrayMultiDimensionLiteralsBitSet);
            CompleteStructMember member_var_array_bitset = TypeObjectUtils::build_complete_struct_member(common_var_array_bitset, detail_var_array_bitset);
            TypeObjectUtils::add_complete_struct_member(member_seq_ArrayMultiDimensionLiteralsBitSet, member_var_array_bitset);
        }
        CompleteStructType struct_type_ArrayMultiDimensionLiteralsBitSet = TypeObjectUtils::build_complete_struct_type(struct_flags_ArrayMultiDimensionLiteralsBitSet, header_ArrayMultiDimensionLiteralsBitSet, member_seq_ArrayMultiDimensionLiteralsBitSet);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ArrayMultiDimensionLiteralsBitSet, type_name_ArrayMultiDimensionLiteralsBitSet.to_string(), type_ids_ArrayMultiDimensionLiteralsBitSet))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ArrayMultiDimensionLiteralsBitSet already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_BoundedSmallArrays_type_identifier(
        TypeIdentifierPair& type_ids_BoundedSmallArrays)
{

    ReturnCode_t return_code_BoundedSmallArrays {eprosima::fastdds::dds::RETCODE_OK};
    return_code_BoundedSmallArrays =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "BoundedSmallArrays", type_ids_BoundedSmallArrays);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_BoundedSmallArrays)
    {
        StructTypeFlag struct_flags_BoundedSmallArrays = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_BoundedSmallArrays = "BoundedSmallArrays";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_BoundedSmallArrays;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_BoundedSmallArrays;
        CompleteTypeDetail detail_BoundedSmallArrays = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_BoundedSmallArrays, ann_custom_BoundedSmallArrays, type_name_BoundedSmallArrays.to_string());
        CompleteStructHeader header_BoundedSmallArrays;
        header_BoundedSmallArrays = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_BoundedSmallArrays);
        CompleteStructMemberSeq member_seq_BoundedSmallArrays;
        {
            TypeIdentifierPair type_ids_var_array_small;
            ReturnCode_t return_code_var_array_small {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_small =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_1", type_ids_var_array_small);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_small)
            {
                return_code_var_array_small =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_array_small);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_small)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_1_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_1 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_small, element_identifier_anonymous_array_int16_t_1_ec))};
                if (!element_identifier_anonymous_array_int16_t_1_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_1 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_small.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_1 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_1 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_1 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_1, element_flags_anonymous_array_int16_t_1);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(1));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_1, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_1));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_1", type_ids_var_array_small))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_1 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_small = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_small = 0x00000000;
            bool common_var_array_small_ec {false};
            CommonStructMember common_var_array_small {TypeObjectUtils::build_common_struct_member(member_id_var_array_small, member_flags_var_array_small, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_small, common_var_array_small_ec))};
            if (!common_var_array_small_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_small member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_small = "var_array_small";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_small;
            ann_custom_BoundedSmallArrays.reset();
            CompleteMemberDetail detail_var_array_small = TypeObjectUtils::build_complete_member_detail(name_var_array_small, member_ann_builtin_var_array_small, ann_custom_BoundedSmallArrays);
            CompleteStructMember member_var_array_small = TypeObjectUtils::build_complete_struct_member(common_var_array_small, detail_var_array_small);
            TypeObjectUtils::add_complete_struct_member(member_seq_BoundedSmallArrays, member_var_array_small);
        }
        CompleteStructType struct_type_BoundedSmallArrays = TypeObjectUtils::build_complete_struct_type(struct_flags_BoundedSmallArrays, header_BoundedSmallArrays, member_seq_BoundedSmallArrays);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_BoundedSmallArrays, type_name_BoundedSmallArrays.to_string(), type_ids_BoundedSmallArrays))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "BoundedSmallArrays already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_BoundedBigArrays_type_identifier(
        TypeIdentifierPair& type_ids_BoundedBigArrays)
{

    ReturnCode_t return_code_BoundedBigArrays {eprosima::fastdds::dds::RETCODE_OK};
    return_code_BoundedBigArrays =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "BoundedBigArrays", type_ids_BoundedBigArrays);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_BoundedBigArrays)
    {
        StructTypeFlag struct_flags_BoundedBigArrays = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_BoundedBigArrays = "BoundedBigArrays";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_BoundedBigArrays;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_BoundedBigArrays;
        CompleteTypeDetail detail_BoundedBigArrays = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_BoundedBigArrays, ann_custom_BoundedBigArrays, type_name_BoundedBigArrays.to_string());
        CompleteStructHeader header_BoundedBigArrays;
        header_BoundedBigArrays = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_BoundedBigArrays);
        CompleteStructMemberSeq member_seq_BoundedBigArrays;
        {
            TypeIdentifierPair type_ids_var_array_big;
            ReturnCode_t return_code_var_array_big {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_array_big =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_41925", type_ids_var_array_big);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_big)
            {
                return_code_var_array_big =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_array_big);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_array_big)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_41925_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_41925 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_big, element_identifier_anonymous_array_int16_t_41925_ec))};
                if (!element_identifier_anonymous_array_int16_t_41925_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_41925 = EK_COMPLETE;
                if (TK_NONE == type_ids_var_array_big.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_41925 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_41925 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_41925 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_41925, element_flags_anonymous_array_int16_t_41925);
                {
                    LBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<LBound>(41925));

                    PlainArrayLElemDefn array_ldefn = TypeObjectUtils::build_plain_array_l_elem_defn(header_anonymous_array_int16_t_41925, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_41925));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_l_array_type_identifier(array_ldefn, "anonymous_array_int16_t_41925", type_ids_var_array_big))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_41925 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_array_big = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_array_big = 0x00000000;
            bool common_var_array_big_ec {false};
            CommonStructMember common_var_array_big {TypeObjectUtils::build_common_struct_member(member_id_var_array_big, member_flags_var_array_big, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_array_big, common_var_array_big_ec))};
            if (!common_var_array_big_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_array_big member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_array_big = "var_array_big";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_array_big;
            ann_custom_BoundedBigArrays.reset();
            CompleteMemberDetail detail_var_array_big = TypeObjectUtils::build_complete_member_detail(name_var_array_big, member_ann_builtin_var_array_big, ann_custom_BoundedBigArrays);
            CompleteStructMember member_var_array_big = TypeObjectUtils::build_complete_struct_member(common_var_array_big, detail_var_array_big);
            TypeObjectUtils::add_complete_struct_member(member_seq_BoundedBigArrays, member_var_array_big);
        }
        CompleteStructType struct_type_BoundedBigArrays = TypeObjectUtils::build_complete_struct_type(struct_flags_BoundedBigArrays, header_BoundedBigArrays, member_seq_BoundedBigArrays);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_BoundedBigArrays, type_name_BoundedBigArrays.to_string(), type_ids_BoundedBigArrays))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "BoundedBigArrays already registered in TypeObjectRegistry for a different type.");
        }
    }
}

