// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file inheritance.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__INHERITANCE_HPP
#define FAST_DDS_GENERATED__INHERITANCE_HPP

#include <cstdint>
#include <utility>
#include "helpers/basic_inner_types.hpp"

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(INHERITANCE_SOURCE)
#define INHERITANCE_DllAPI __declspec( dllexport )
#else
#define INHERITANCE_DllAPI __declspec( dllimport )
#endif // INHERITANCE_SOURCE
#else
#define INHERITANCE_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define INHERITANCE_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the structure InnerStructureHelperChild defined by the user in the IDL file.
 * @ingroup inheritance
 */
class InnerStructureHelperChild : public InnerStructureHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport InnerStructureHelperChild()
        : InnerStructureHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~InnerStructureHelperChild()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object InnerStructureHelperChild that will be copied.
     */
    eProsima_user_DllExport InnerStructureHelperChild(
            const InnerStructureHelperChild& x)
        : InnerStructureHelper(x)
    {
                    m_var_child_longlong = x.m_var_child_longlong;

                    m_var_child_ulonglong = x.m_var_child_ulonglong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object InnerStructureHelperChild that will be copied.
     */
    eProsima_user_DllExport InnerStructureHelperChild(
            InnerStructureHelperChild&& x) noexcept
        : InnerStructureHelper(std::move(x))

    {
        m_var_child_longlong = x.m_var_child_longlong;
        m_var_child_ulonglong = x.m_var_child_ulonglong;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object InnerStructureHelperChild that will be copied.
     */
    eProsima_user_DllExport InnerStructureHelperChild& operator =(
            const InnerStructureHelperChild& x)
    {
        InnerStructureHelper::operator =(x);

                    m_var_child_longlong = x.m_var_child_longlong;

                    m_var_child_ulonglong = x.m_var_child_ulonglong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object InnerStructureHelperChild that will be copied.
     */
    eProsima_user_DllExport InnerStructureHelperChild& operator =(
            InnerStructureHelperChild&& x) noexcept
    {
        InnerStructureHelper::operator =(std::move(x));

        m_var_child_longlong = x.m_var_child_longlong;
        m_var_child_ulonglong = x.m_var_child_ulonglong;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x InnerStructureHelperChild object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const InnerStructureHelperChild& x) const
    {
        if (InnerStructureHelper::operator !=(x))
                {
                    return false;
                }
        return (m_var_child_longlong == x.m_var_child_longlong &&
           m_var_child_ulonglong == x.m_var_child_ulonglong);
    }

    /*!
     * @brief Comparison operator.
     * @param x InnerStructureHelperChild object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const InnerStructureHelperChild& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_child_longlong
     * @param _var_child_longlong New value for member var_child_longlong
     */
    eProsima_user_DllExport void var_child_longlong(
            int64_t _var_child_longlong)
    {
        m_var_child_longlong = _var_child_longlong;
    }

    /*!
     * @brief This function returns the value of member var_child_longlong
     * @return Value of member var_child_longlong
     */
    eProsima_user_DllExport int64_t var_child_longlong() const
    {
        return m_var_child_longlong;
    }

    /*!
     * @brief This function returns a reference to member var_child_longlong
     * @return Reference to member var_child_longlong
     */
    eProsima_user_DllExport int64_t& var_child_longlong()
    {
        return m_var_child_longlong;
    }


    /*!
     * @brief This function sets a value in member var_child_ulonglong
     * @param _var_child_ulonglong New value for member var_child_ulonglong
     */
    eProsima_user_DllExport void var_child_ulonglong(
            uint64_t _var_child_ulonglong)
    {
        m_var_child_ulonglong = _var_child_ulonglong;
    }

    /*!
     * @brief This function returns the value of member var_child_ulonglong
     * @return Value of member var_child_ulonglong
     */
    eProsima_user_DllExport uint64_t var_child_ulonglong() const
    {
        return m_var_child_ulonglong;
    }

    /*!
     * @brief This function returns a reference to member var_child_ulonglong
     * @return Reference to member var_child_ulonglong
     */
    eProsima_user_DllExport uint64_t& var_child_ulonglong()
    {
        return m_var_child_ulonglong;
    }



private:

    int64_t m_var_child_longlong{0};
    uint64_t m_var_child_ulonglong{0};

};
/*!
 * @brief This class represents the structure InnerStructureHelperChildChild defined by the user in the IDL file.
 * @ingroup inheritance
 */
class InnerStructureHelperChildChild : public InnerStructureHelperChild
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport InnerStructureHelperChildChild()
        : InnerStructureHelperChild()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~InnerStructureHelperChildChild()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object InnerStructureHelperChildChild that will be copied.
     */
    eProsima_user_DllExport InnerStructureHelperChildChild(
            const InnerStructureHelperChildChild& x)
        : InnerStructureHelperChild(x)
    {
                    m_var_child_childlonglong2 = x.m_var_child_childlonglong2;

                    m_var_childchild_ulonglong2 = x.m_var_childchild_ulonglong2;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object InnerStructureHelperChildChild that will be copied.
     */
    eProsima_user_DllExport InnerStructureHelperChildChild(
            InnerStructureHelperChildChild&& x) noexcept
        : InnerStructureHelperChild(std::move(x))

    {
        m_var_child_childlonglong2 = x.m_var_child_childlonglong2;
        m_var_childchild_ulonglong2 = x.m_var_childchild_ulonglong2;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object InnerStructureHelperChildChild that will be copied.
     */
    eProsima_user_DllExport InnerStructureHelperChildChild& operator =(
            const InnerStructureHelperChildChild& x)
    {
        InnerStructureHelperChild::operator =(x);

                    m_var_child_childlonglong2 = x.m_var_child_childlonglong2;

                    m_var_childchild_ulonglong2 = x.m_var_childchild_ulonglong2;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object InnerStructureHelperChildChild that will be copied.
     */
    eProsima_user_DllExport InnerStructureHelperChildChild& operator =(
            InnerStructureHelperChildChild&& x) noexcept
    {
        InnerStructureHelperChild::operator =(std::move(x));

        m_var_child_childlonglong2 = x.m_var_child_childlonglong2;
        m_var_childchild_ulonglong2 = x.m_var_childchild_ulonglong2;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x InnerStructureHelperChildChild object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const InnerStructureHelperChildChild& x) const
    {
        if (InnerStructureHelperChild::operator !=(x))
                {
                    return false;
                }
        return (m_var_child_childlonglong2 == x.m_var_child_childlonglong2 &&
           m_var_childchild_ulonglong2 == x.m_var_childchild_ulonglong2);
    }

    /*!
     * @brief Comparison operator.
     * @param x InnerStructureHelperChildChild object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const InnerStructureHelperChildChild& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_child_childlonglong2
     * @param _var_child_childlonglong2 New value for member var_child_childlonglong2
     */
    eProsima_user_DllExport void var_child_childlonglong2(
            int64_t _var_child_childlonglong2)
    {
        m_var_child_childlonglong2 = _var_child_childlonglong2;
    }

    /*!
     * @brief This function returns the value of member var_child_childlonglong2
     * @return Value of member var_child_childlonglong2
     */
    eProsima_user_DllExport int64_t var_child_childlonglong2() const
    {
        return m_var_child_childlonglong2;
    }

    /*!
     * @brief This function returns a reference to member var_child_childlonglong2
     * @return Reference to member var_child_childlonglong2
     */
    eProsima_user_DllExport int64_t& var_child_childlonglong2()
    {
        return m_var_child_childlonglong2;
    }


    /*!
     * @brief This function sets a value in member var_childchild_ulonglong2
     * @param _var_childchild_ulonglong2 New value for member var_childchild_ulonglong2
     */
    eProsima_user_DllExport void var_childchild_ulonglong2(
            uint64_t _var_childchild_ulonglong2)
    {
        m_var_childchild_ulonglong2 = _var_childchild_ulonglong2;
    }

    /*!
     * @brief This function returns the value of member var_childchild_ulonglong2
     * @return Value of member var_childchild_ulonglong2
     */
    eProsima_user_DllExport uint64_t var_childchild_ulonglong2() const
    {
        return m_var_childchild_ulonglong2;
    }

    /*!
     * @brief This function returns a reference to member var_childchild_ulonglong2
     * @return Reference to member var_childchild_ulonglong2
     */
    eProsima_user_DllExport uint64_t& var_childchild_ulonglong2()
    {
        return m_var_childchild_ulonglong2;
    }



private:

    int64_t m_var_child_childlonglong2{0};
    uint64_t m_var_childchild_ulonglong2{0};

};
/*!
 * @brief This class represents the structure InnerStructureHelperEmptyChild defined by the user in the IDL file.
 * @ingroup inheritance
 */
class InnerStructureHelperEmptyChild : public InnerStructureHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport InnerStructureHelperEmptyChild()
        : InnerStructureHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~InnerStructureHelperEmptyChild()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object InnerStructureHelperEmptyChild that will be copied.
     */
    eProsima_user_DllExport InnerStructureHelperEmptyChild(
            const InnerStructureHelperEmptyChild& x)
        : InnerStructureHelper(x)
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object InnerStructureHelperEmptyChild that will be copied.
     */
    eProsima_user_DllExport InnerStructureHelperEmptyChild(
            InnerStructureHelperEmptyChild&& x) noexcept
        : InnerStructureHelper(std::move(x))

    {
        static_cast<void>(x);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object InnerStructureHelperEmptyChild that will be copied.
     */
    eProsima_user_DllExport InnerStructureHelperEmptyChild& operator =(
            const InnerStructureHelperEmptyChild& x)
    {
        InnerStructureHelper::operator =(x);

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object InnerStructureHelperEmptyChild that will be copied.
     */
    eProsima_user_DllExport InnerStructureHelperEmptyChild& operator =(
            InnerStructureHelperEmptyChild&& x) noexcept
    {
        InnerStructureHelper::operator =(std::move(x));

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x InnerStructureHelperEmptyChild object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const InnerStructureHelperEmptyChild& x) const
    {
        if (InnerStructureHelper::operator !=(x))
                {
                    return false;
                }
        static_cast<void>(x);
        return true;
    }

    /*!
     * @brief Comparison operator.
     * @param x InnerStructureHelperEmptyChild object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const InnerStructureHelperEmptyChild& x) const
    {
        return !(*this == x);
    }



private:


};
/*!
 * @brief This class represents the structure InnerStructureHelperEmptyChildChild defined by the user in the IDL file.
 * @ingroup inheritance
 */
class InnerStructureHelperEmptyChildChild : public InnerStructureHelperEmptyChild
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport InnerStructureHelperEmptyChildChild()
        : InnerStructureHelperEmptyChild()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~InnerStructureHelperEmptyChildChild()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object InnerStructureHelperEmptyChildChild that will be copied.
     */
    eProsima_user_DllExport InnerStructureHelperEmptyChildChild(
            const InnerStructureHelperEmptyChildChild& x)
        : InnerStructureHelperEmptyChild(x)
    {
                    m_var_char = x.m_var_char;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object InnerStructureHelperEmptyChildChild that will be copied.
     */
    eProsima_user_DllExport InnerStructureHelperEmptyChildChild(
            InnerStructureHelperEmptyChildChild&& x) noexcept
        : InnerStructureHelperEmptyChild(std::move(x))

    {
        m_var_char = x.m_var_char;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object InnerStructureHelperEmptyChildChild that will be copied.
     */
    eProsima_user_DllExport InnerStructureHelperEmptyChildChild& operator =(
            const InnerStructureHelperEmptyChildChild& x)
    {
        InnerStructureHelperEmptyChild::operator =(x);

                    m_var_char = x.m_var_char;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object InnerStructureHelperEmptyChildChild that will be copied.
     */
    eProsima_user_DllExport InnerStructureHelperEmptyChildChild& operator =(
            InnerStructureHelperEmptyChildChild&& x) noexcept
    {
        InnerStructureHelperEmptyChild::operator =(std::move(x));

        m_var_char = x.m_var_char;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x InnerStructureHelperEmptyChildChild object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const InnerStructureHelperEmptyChildChild& x) const
    {
        if (InnerStructureHelperEmptyChild::operator !=(x))
                {
                    return false;
                }
        return (m_var_char == x.m_var_char);
    }

    /*!
     * @brief Comparison operator.
     * @param x InnerStructureHelperEmptyChildChild object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const InnerStructureHelperEmptyChildChild& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_char
     * @param _var_char New value for member var_char
     */
    eProsima_user_DllExport void var_char(
            char _var_char)
    {
        m_var_char = _var_char;
    }

    /*!
     * @brief This function returns the value of member var_char
     * @return Value of member var_char
     */
    eProsima_user_DllExport char var_char() const
    {
        return m_var_char;
    }

    /*!
     * @brief This function returns a reference to member var_char
     * @return Reference to member var_char
     */
    eProsima_user_DllExport char& var_char()
    {
        return m_var_char;
    }



private:

    char m_var_char{0};

};
/*!
 * @brief This class represents the structure InnerEmptyStructureHelperChild defined by the user in the IDL file.
 * @ingroup inheritance
 */
class InnerEmptyStructureHelperChild : public InnerEmptyStructureHelper
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport InnerEmptyStructureHelperChild()
        : InnerEmptyStructureHelper()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~InnerEmptyStructureHelperChild()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object InnerEmptyStructureHelperChild that will be copied.
     */
    eProsima_user_DllExport InnerEmptyStructureHelperChild(
            const InnerEmptyStructureHelperChild& x)
        : InnerEmptyStructureHelper(x)
    {
                    m_var_child_longlong = x.m_var_child_longlong;

                    m_var_child_ulonglong = x.m_var_child_ulonglong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object InnerEmptyStructureHelperChild that will be copied.
     */
    eProsima_user_DllExport InnerEmptyStructureHelperChild(
            InnerEmptyStructureHelperChild&& x) noexcept
        : InnerEmptyStructureHelper(std::move(x))

    {
        m_var_child_longlong = x.m_var_child_longlong;
        m_var_child_ulonglong = x.m_var_child_ulonglong;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object InnerEmptyStructureHelperChild that will be copied.
     */
    eProsima_user_DllExport InnerEmptyStructureHelperChild& operator =(
            const InnerEmptyStructureHelperChild& x)
    {
        InnerEmptyStructureHelper::operator =(x);

                    m_var_child_longlong = x.m_var_child_longlong;

                    m_var_child_ulonglong = x.m_var_child_ulonglong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object InnerEmptyStructureHelperChild that will be copied.
     */
    eProsima_user_DllExport InnerEmptyStructureHelperChild& operator =(
            InnerEmptyStructureHelperChild&& x) noexcept
    {
        InnerEmptyStructureHelper::operator =(std::move(x));

        m_var_child_longlong = x.m_var_child_longlong;
        m_var_child_ulonglong = x.m_var_child_ulonglong;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x InnerEmptyStructureHelperChild object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const InnerEmptyStructureHelperChild& x) const
    {
        if (InnerEmptyStructureHelper::operator !=(x))
                {
                    return false;
                }
        return (m_var_child_longlong == x.m_var_child_longlong &&
           m_var_child_ulonglong == x.m_var_child_ulonglong);
    }

    /*!
     * @brief Comparison operator.
     * @param x InnerEmptyStructureHelperChild object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const InnerEmptyStructureHelperChild& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_child_longlong
     * @param _var_child_longlong New value for member var_child_longlong
     */
    eProsima_user_DllExport void var_child_longlong(
            int64_t _var_child_longlong)
    {
        m_var_child_longlong = _var_child_longlong;
    }

    /*!
     * @brief This function returns the value of member var_child_longlong
     * @return Value of member var_child_longlong
     */
    eProsima_user_DllExport int64_t var_child_longlong() const
    {
        return m_var_child_longlong;
    }

    /*!
     * @brief This function returns a reference to member var_child_longlong
     * @return Reference to member var_child_longlong
     */
    eProsima_user_DllExport int64_t& var_child_longlong()
    {
        return m_var_child_longlong;
    }


    /*!
     * @brief This function sets a value in member var_child_ulonglong
     * @param _var_child_ulonglong New value for member var_child_ulonglong
     */
    eProsima_user_DllExport void var_child_ulonglong(
            uint64_t _var_child_ulonglong)
    {
        m_var_child_ulonglong = _var_child_ulonglong;
    }

    /*!
     * @brief This function returns the value of member var_child_ulonglong
     * @return Value of member var_child_ulonglong
     */
    eProsima_user_DllExport uint64_t var_child_ulonglong() const
    {
        return m_var_child_ulonglong;
    }

    /*!
     * @brief This function returns a reference to member var_child_ulonglong
     * @return Reference to member var_child_ulonglong
     */
    eProsima_user_DllExport uint64_t& var_child_ulonglong()
    {
        return m_var_child_ulonglong;
    }



private:

    int64_t m_var_child_longlong{0};
    uint64_t m_var_child_ulonglong{0};

};
/*!
 * @brief This class represents the structure StructAliasInheritanceStruct defined by the user in the IDL file.
 * @ingroup inheritance
 */
class StructAliasInheritanceStruct : public inner_structure_helper_alias
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructAliasInheritanceStruct()
        : inner_structure_helper_alias()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructAliasInheritanceStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructAliasInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport StructAliasInheritanceStruct(
            const StructAliasInheritanceStruct& x)
        : inner_structure_helper_alias(x)
    {
                    m_new_member = x.m_new_member;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructAliasInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport StructAliasInheritanceStruct(
            StructAliasInheritanceStruct&& x) noexcept
        : inner_structure_helper_alias(std::move(x))

    {
        m_new_member = x.m_new_member;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructAliasInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport StructAliasInheritanceStruct& operator =(
            const StructAliasInheritanceStruct& x)
    {
        inner_structure_helper_alias::operator =(x);

                    m_new_member = x.m_new_member;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructAliasInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport StructAliasInheritanceStruct& operator =(
            StructAliasInheritanceStruct&& x) noexcept
    {
        inner_structure_helper_alias::operator =(std::move(x));

        m_new_member = x.m_new_member;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructAliasInheritanceStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructAliasInheritanceStruct& x) const
    {
        if (inner_structure_helper_alias::operator !=(x))
                {
                    return false;
                }
        return (m_new_member == x.m_new_member);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructAliasInheritanceStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructAliasInheritanceStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member new_member
     * @param _new_member New value for member new_member
     */
    eProsima_user_DllExport void new_member(
            int16_t _new_member)
    {
        m_new_member = _new_member;
    }

    /*!
     * @brief This function returns the value of member new_member
     * @return Value of member new_member
     */
    eProsima_user_DllExport int16_t new_member() const
    {
        return m_new_member;
    }

    /*!
     * @brief This function returns a reference to member new_member
     * @return Reference to member new_member
     */
    eProsima_user_DllExport int16_t& new_member()
    {
        return m_new_member;
    }



private:

    int16_t m_new_member{0};

};
/*!
 * @brief This class represents the structure StructuresInheritanceStruct defined by the user in the IDL file.
 * @ingroup inheritance
 */
class StructuresInheritanceStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructuresInheritanceStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructuresInheritanceStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructuresInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport StructuresInheritanceStruct(
            const StructuresInheritanceStruct& x)
    {
                    m_var_InnerStructureHelperChild = x.m_var_InnerStructureHelperChild;

                    m_var_InnerStructureHelperChildChild = x.m_var_InnerStructureHelperChildChild;

                    m_var_InnerStructureHelperEmptyChild = x.m_var_InnerStructureHelperEmptyChild;

                    m_var_InnerStructureHelperEmptyChildChild = x.m_var_InnerStructureHelperEmptyChildChild;

                    m_var_InnerEmptyStructureHelperChild = x.m_var_InnerEmptyStructureHelperChild;

                    m_var_StructAliasInheritanceStruct = x.m_var_StructAliasInheritanceStruct;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructuresInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport StructuresInheritanceStruct(
            StructuresInheritanceStruct&& x) noexcept
    {
        m_var_InnerStructureHelperChild = std::move(x.m_var_InnerStructureHelperChild);
        m_var_InnerStructureHelperChildChild = std::move(x.m_var_InnerStructureHelperChildChild);
        m_var_InnerStructureHelperEmptyChild = std::move(x.m_var_InnerStructureHelperEmptyChild);
        m_var_InnerStructureHelperEmptyChildChild = std::move(x.m_var_InnerStructureHelperEmptyChildChild);
        m_var_InnerEmptyStructureHelperChild = std::move(x.m_var_InnerEmptyStructureHelperChild);
        m_var_StructAliasInheritanceStruct = std::move(x.m_var_StructAliasInheritanceStruct);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructuresInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport StructuresInheritanceStruct& operator =(
            const StructuresInheritanceStruct& x)
    {

                    m_var_InnerStructureHelperChild = x.m_var_InnerStructureHelperChild;

                    m_var_InnerStructureHelperChildChild = x.m_var_InnerStructureHelperChildChild;

                    m_var_InnerStructureHelperEmptyChild = x.m_var_InnerStructureHelperEmptyChild;

                    m_var_InnerStructureHelperEmptyChildChild = x.m_var_InnerStructureHelperEmptyChildChild;

                    m_var_InnerEmptyStructureHelperChild = x.m_var_InnerEmptyStructureHelperChild;

                    m_var_StructAliasInheritanceStruct = x.m_var_StructAliasInheritanceStruct;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructuresInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport StructuresInheritanceStruct& operator =(
            StructuresInheritanceStruct&& x) noexcept
    {

        m_var_InnerStructureHelperChild = std::move(x.m_var_InnerStructureHelperChild);
        m_var_InnerStructureHelperChildChild = std::move(x.m_var_InnerStructureHelperChildChild);
        m_var_InnerStructureHelperEmptyChild = std::move(x.m_var_InnerStructureHelperEmptyChild);
        m_var_InnerStructureHelperEmptyChildChild = std::move(x.m_var_InnerStructureHelperEmptyChildChild);
        m_var_InnerEmptyStructureHelperChild = std::move(x.m_var_InnerEmptyStructureHelperChild);
        m_var_StructAliasInheritanceStruct = std::move(x.m_var_StructAliasInheritanceStruct);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructuresInheritanceStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructuresInheritanceStruct& x) const
    {
        return (m_var_InnerStructureHelperChild == x.m_var_InnerStructureHelperChild &&
           m_var_InnerStructureHelperChildChild == x.m_var_InnerStructureHelperChildChild &&
           m_var_InnerStructureHelperEmptyChild == x.m_var_InnerStructureHelperEmptyChild &&
           m_var_InnerStructureHelperEmptyChildChild == x.m_var_InnerStructureHelperEmptyChildChild &&
           m_var_InnerEmptyStructureHelperChild == x.m_var_InnerEmptyStructureHelperChild &&
           m_var_StructAliasInheritanceStruct == x.m_var_StructAliasInheritanceStruct);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructuresInheritanceStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructuresInheritanceStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_InnerStructureHelperChild
     * @param _var_InnerStructureHelperChild New value to be copied in member var_InnerStructureHelperChild
     */
    eProsima_user_DllExport void var_InnerStructureHelperChild(
            const InnerStructureHelperChild& _var_InnerStructureHelperChild)
    {
        m_var_InnerStructureHelperChild = _var_InnerStructureHelperChild;
    }

    /*!
     * @brief This function moves the value in member var_InnerStructureHelperChild
     * @param _var_InnerStructureHelperChild New value to be moved in member var_InnerStructureHelperChild
     */
    eProsima_user_DllExport void var_InnerStructureHelperChild(
            InnerStructureHelperChild&& _var_InnerStructureHelperChild)
    {
        m_var_InnerStructureHelperChild = std::move(_var_InnerStructureHelperChild);
    }

    /*!
     * @brief This function returns a constant reference to member var_InnerStructureHelperChild
     * @return Constant reference to member var_InnerStructureHelperChild
     */
    eProsima_user_DllExport const InnerStructureHelperChild& var_InnerStructureHelperChild() const
    {
        return m_var_InnerStructureHelperChild;
    }

    /*!
     * @brief This function returns a reference to member var_InnerStructureHelperChild
     * @return Reference to member var_InnerStructureHelperChild
     */
    eProsima_user_DllExport InnerStructureHelperChild& var_InnerStructureHelperChild()
    {
        return m_var_InnerStructureHelperChild;
    }


    /*!
     * @brief This function copies the value in member var_InnerStructureHelperChildChild
     * @param _var_InnerStructureHelperChildChild New value to be copied in member var_InnerStructureHelperChildChild
     */
    eProsima_user_DllExport void var_InnerStructureHelperChildChild(
            const InnerStructureHelperChildChild& _var_InnerStructureHelperChildChild)
    {
        m_var_InnerStructureHelperChildChild = _var_InnerStructureHelperChildChild;
    }

    /*!
     * @brief This function moves the value in member var_InnerStructureHelperChildChild
     * @param _var_InnerStructureHelperChildChild New value to be moved in member var_InnerStructureHelperChildChild
     */
    eProsima_user_DllExport void var_InnerStructureHelperChildChild(
            InnerStructureHelperChildChild&& _var_InnerStructureHelperChildChild)
    {
        m_var_InnerStructureHelperChildChild = std::move(_var_InnerStructureHelperChildChild);
    }

    /*!
     * @brief This function returns a constant reference to member var_InnerStructureHelperChildChild
     * @return Constant reference to member var_InnerStructureHelperChildChild
     */
    eProsima_user_DllExport const InnerStructureHelperChildChild& var_InnerStructureHelperChildChild() const
    {
        return m_var_InnerStructureHelperChildChild;
    }

    /*!
     * @brief This function returns a reference to member var_InnerStructureHelperChildChild
     * @return Reference to member var_InnerStructureHelperChildChild
     */
    eProsima_user_DllExport InnerStructureHelperChildChild& var_InnerStructureHelperChildChild()
    {
        return m_var_InnerStructureHelperChildChild;
    }


    /*!
     * @brief This function copies the value in member var_InnerStructureHelperEmptyChild
     * @param _var_InnerStructureHelperEmptyChild New value to be copied in member var_InnerStructureHelperEmptyChild
     */
    eProsima_user_DllExport void var_InnerStructureHelperEmptyChild(
            const InnerStructureHelperEmptyChild& _var_InnerStructureHelperEmptyChild)
    {
        m_var_InnerStructureHelperEmptyChild = _var_InnerStructureHelperEmptyChild;
    }

    /*!
     * @brief This function moves the value in member var_InnerStructureHelperEmptyChild
     * @param _var_InnerStructureHelperEmptyChild New value to be moved in member var_InnerStructureHelperEmptyChild
     */
    eProsima_user_DllExport void var_InnerStructureHelperEmptyChild(
            InnerStructureHelperEmptyChild&& _var_InnerStructureHelperEmptyChild)
    {
        m_var_InnerStructureHelperEmptyChild = std::move(_var_InnerStructureHelperEmptyChild);
    }

    /*!
     * @brief This function returns a constant reference to member var_InnerStructureHelperEmptyChild
     * @return Constant reference to member var_InnerStructureHelperEmptyChild
     */
    eProsima_user_DllExport const InnerStructureHelperEmptyChild& var_InnerStructureHelperEmptyChild() const
    {
        return m_var_InnerStructureHelperEmptyChild;
    }

    /*!
     * @brief This function returns a reference to member var_InnerStructureHelperEmptyChild
     * @return Reference to member var_InnerStructureHelperEmptyChild
     */
    eProsima_user_DllExport InnerStructureHelperEmptyChild& var_InnerStructureHelperEmptyChild()
    {
        return m_var_InnerStructureHelperEmptyChild;
    }


    /*!
     * @brief This function copies the value in member var_InnerStructureHelperEmptyChildChild
     * @param _var_InnerStructureHelperEmptyChildChild New value to be copied in member var_InnerStructureHelperEmptyChildChild
     */
    eProsima_user_DllExport void var_InnerStructureHelperEmptyChildChild(
            const InnerStructureHelperEmptyChildChild& _var_InnerStructureHelperEmptyChildChild)
    {
        m_var_InnerStructureHelperEmptyChildChild = _var_InnerStructureHelperEmptyChildChild;
    }

    /*!
     * @brief This function moves the value in member var_InnerStructureHelperEmptyChildChild
     * @param _var_InnerStructureHelperEmptyChildChild New value to be moved in member var_InnerStructureHelperEmptyChildChild
     */
    eProsima_user_DllExport void var_InnerStructureHelperEmptyChildChild(
            InnerStructureHelperEmptyChildChild&& _var_InnerStructureHelperEmptyChildChild)
    {
        m_var_InnerStructureHelperEmptyChildChild = std::move(_var_InnerStructureHelperEmptyChildChild);
    }

    /*!
     * @brief This function returns a constant reference to member var_InnerStructureHelperEmptyChildChild
     * @return Constant reference to member var_InnerStructureHelperEmptyChildChild
     */
    eProsima_user_DllExport const InnerStructureHelperEmptyChildChild& var_InnerStructureHelperEmptyChildChild() const
    {
        return m_var_InnerStructureHelperEmptyChildChild;
    }

    /*!
     * @brief This function returns a reference to member var_InnerStructureHelperEmptyChildChild
     * @return Reference to member var_InnerStructureHelperEmptyChildChild
     */
    eProsima_user_DllExport InnerStructureHelperEmptyChildChild& var_InnerStructureHelperEmptyChildChild()
    {
        return m_var_InnerStructureHelperEmptyChildChild;
    }


    /*!
     * @brief This function copies the value in member var_InnerEmptyStructureHelperChild
     * @param _var_InnerEmptyStructureHelperChild New value to be copied in member var_InnerEmptyStructureHelperChild
     */
    eProsima_user_DllExport void var_InnerEmptyStructureHelperChild(
            const InnerEmptyStructureHelperChild& _var_InnerEmptyStructureHelperChild)
    {
        m_var_InnerEmptyStructureHelperChild = _var_InnerEmptyStructureHelperChild;
    }

    /*!
     * @brief This function moves the value in member var_InnerEmptyStructureHelperChild
     * @param _var_InnerEmptyStructureHelperChild New value to be moved in member var_InnerEmptyStructureHelperChild
     */
    eProsima_user_DllExport void var_InnerEmptyStructureHelperChild(
            InnerEmptyStructureHelperChild&& _var_InnerEmptyStructureHelperChild)
    {
        m_var_InnerEmptyStructureHelperChild = std::move(_var_InnerEmptyStructureHelperChild);
    }

    /*!
     * @brief This function returns a constant reference to member var_InnerEmptyStructureHelperChild
     * @return Constant reference to member var_InnerEmptyStructureHelperChild
     */
    eProsima_user_DllExport const InnerEmptyStructureHelperChild& var_InnerEmptyStructureHelperChild() const
    {
        return m_var_InnerEmptyStructureHelperChild;
    }

    /*!
     * @brief This function returns a reference to member var_InnerEmptyStructureHelperChild
     * @return Reference to member var_InnerEmptyStructureHelperChild
     */
    eProsima_user_DllExport InnerEmptyStructureHelperChild& var_InnerEmptyStructureHelperChild()
    {
        return m_var_InnerEmptyStructureHelperChild;
    }


    /*!
     * @brief This function copies the value in member var_StructAliasInheritanceStruct
     * @param _var_StructAliasInheritanceStruct New value to be copied in member var_StructAliasInheritanceStruct
     */
    eProsima_user_DllExport void var_StructAliasInheritanceStruct(
            const StructAliasInheritanceStruct& _var_StructAliasInheritanceStruct)
    {
        m_var_StructAliasInheritanceStruct = _var_StructAliasInheritanceStruct;
    }

    /*!
     * @brief This function moves the value in member var_StructAliasInheritanceStruct
     * @param _var_StructAliasInheritanceStruct New value to be moved in member var_StructAliasInheritanceStruct
     */
    eProsima_user_DllExport void var_StructAliasInheritanceStruct(
            StructAliasInheritanceStruct&& _var_StructAliasInheritanceStruct)
    {
        m_var_StructAliasInheritanceStruct = std::move(_var_StructAliasInheritanceStruct);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructAliasInheritanceStruct
     * @return Constant reference to member var_StructAliasInheritanceStruct
     */
    eProsima_user_DllExport const StructAliasInheritanceStruct& var_StructAliasInheritanceStruct() const
    {
        return m_var_StructAliasInheritanceStruct;
    }

    /*!
     * @brief This function returns a reference to member var_StructAliasInheritanceStruct
     * @return Reference to member var_StructAliasInheritanceStruct
     */
    eProsima_user_DllExport StructAliasInheritanceStruct& var_StructAliasInheritanceStruct()
    {
        return m_var_StructAliasInheritanceStruct;
    }



private:

    InnerStructureHelperChild m_var_InnerStructureHelperChild;
    InnerStructureHelperChildChild m_var_InnerStructureHelperChildChild;
    InnerStructureHelperEmptyChild m_var_InnerStructureHelperEmptyChild;
    InnerStructureHelperEmptyChildChild m_var_InnerStructureHelperEmptyChildChild;
    InnerEmptyStructureHelperChild m_var_InnerEmptyStructureHelperChild;
    StructAliasInheritanceStruct m_var_StructAliasInheritanceStruct;

};
/*!
 * @brief This structure represents the bitset InnerBitsetHelperChild defined by the user in the IDL file.
 * @ingroup inheritance
 */
struct InnerBitsetHelperChild
{
        uint8_t a : 3;

        bool b : 1;

        uint8_t  : 4;

        uint16_t c : 10;

        uint8_t  : 3;

        int16_t d : 12;

        uint32_t child_w : 17;


    /*!
     * @brief Comparison operator.
     * @param x InnerBitsetHelperChild object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const InnerBitsetHelperChild& x) const
    {
        return (a == x.a &&
           b == x.b &&
           c == x.c &&
           d == x.d &&
           child_w == x.child_w);
    }

    /*!
     * @brief Comparison operator.
     * @param x InnerBitsetHelperChild object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const InnerBitsetHelperChild& x) const
    {
        return !(*this == x);
    }
};
/*!
 * @brief This structure represents the bitset InnerBitsetHelperChildChild defined by the user in the IDL file.
 * @ingroup inheritance
 */
struct InnerBitsetHelperChildChild
{
        uint8_t a : 3;

        bool b : 1;

        uint8_t  : 4;

        uint16_t c : 10;

        uint8_t  : 3;

        int16_t d : 12;

        uint32_t child_w : 17;

        uint16_t childchild_z : 14;


    /*!
     * @brief Comparison operator.
     * @param x InnerBitsetHelperChildChild object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const InnerBitsetHelperChildChild& x) const
    {
        return (a == x.a &&
           b == x.b &&
           c == x.c &&
           d == x.d &&
           child_w == x.child_w &&
           childchild_z == x.childchild_z);
    }

    /*!
     * @brief Comparison operator.
     * @param x InnerBitsetHelperChildChild object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const InnerBitsetHelperChildChild& x) const
    {
        return !(*this == x);
    }
};
/*!
 * @brief This structure represents the bitset BitsetAliasInheritanceBitset defined by the user in the IDL file.
 * @ingroup inheritance
 */
struct BitsetAliasInheritanceBitset
{
        uint8_t a : 3;

        bool b : 1;

        uint8_t  : 4;

        uint16_t c : 10;

        uint8_t  : 3;

        int16_t d : 12;

        uint16_t new_bitfield : 10;


    /*!
     * @brief Comparison operator.
     * @param x BitsetAliasInheritanceBitset object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const BitsetAliasInheritanceBitset& x) const
    {
        return (a == x.a &&
           b == x.b &&
           c == x.c &&
           d == x.d &&
           new_bitfield == x.new_bitfield);
    }

    /*!
     * @brief Comparison operator.
     * @param x BitsetAliasInheritanceBitset object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const BitsetAliasInheritanceBitset& x) const
    {
        return !(*this == x);
    }
};
/*!
 * @brief This class represents the structure BitsetsChildInheritanceStruct defined by the user in the IDL file.
 * @ingroup inheritance
 */
class BitsetsChildInheritanceStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport BitsetsChildInheritanceStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~BitsetsChildInheritanceStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object BitsetsChildInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport BitsetsChildInheritanceStruct(
            const BitsetsChildInheritanceStruct& x)
    {
                    m_var_InnerBitsetHelperChild = x.m_var_InnerBitsetHelperChild;

                    m_var_InnerBitsetHelperChildChild = x.m_var_InnerBitsetHelperChildChild;

                    m_var_BitsetAliasInheritanceBitset = x.m_var_BitsetAliasInheritanceBitset;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object BitsetsChildInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport BitsetsChildInheritanceStruct(
            BitsetsChildInheritanceStruct&& x) noexcept
    {
        m_var_InnerBitsetHelperChild = std::move(x.m_var_InnerBitsetHelperChild);
        m_var_InnerBitsetHelperChildChild = std::move(x.m_var_InnerBitsetHelperChildChild);
        m_var_BitsetAliasInheritanceBitset = std::move(x.m_var_BitsetAliasInheritanceBitset);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object BitsetsChildInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport BitsetsChildInheritanceStruct& operator =(
            const BitsetsChildInheritanceStruct& x)
    {

                    m_var_InnerBitsetHelperChild = x.m_var_InnerBitsetHelperChild;

                    m_var_InnerBitsetHelperChildChild = x.m_var_InnerBitsetHelperChildChild;

                    m_var_BitsetAliasInheritanceBitset = x.m_var_BitsetAliasInheritanceBitset;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object BitsetsChildInheritanceStruct that will be copied.
     */
    eProsima_user_DllExport BitsetsChildInheritanceStruct& operator =(
            BitsetsChildInheritanceStruct&& x) noexcept
    {

        m_var_InnerBitsetHelperChild = std::move(x.m_var_InnerBitsetHelperChild);
        m_var_InnerBitsetHelperChildChild = std::move(x.m_var_InnerBitsetHelperChildChild);
        m_var_BitsetAliasInheritanceBitset = std::move(x.m_var_BitsetAliasInheritanceBitset);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x BitsetsChildInheritanceStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const BitsetsChildInheritanceStruct& x) const
    {
        return (m_var_InnerBitsetHelperChild == x.m_var_InnerBitsetHelperChild &&
           m_var_InnerBitsetHelperChildChild == x.m_var_InnerBitsetHelperChildChild &&
           m_var_BitsetAliasInheritanceBitset == x.m_var_BitsetAliasInheritanceBitset);
    }

    /*!
     * @brief Comparison operator.
     * @param x BitsetsChildInheritanceStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const BitsetsChildInheritanceStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_InnerBitsetHelperChild
     * @param _var_InnerBitsetHelperChild New value to be copied in member var_InnerBitsetHelperChild
     */
    eProsima_user_DllExport void var_InnerBitsetHelperChild(
            const InnerBitsetHelperChild& _var_InnerBitsetHelperChild)
    {
        m_var_InnerBitsetHelperChild = _var_InnerBitsetHelperChild;
    }

    /*!
     * @brief This function moves the value in member var_InnerBitsetHelperChild
     * @param _var_InnerBitsetHelperChild New value to be moved in member var_InnerBitsetHelperChild
     */
    eProsima_user_DllExport void var_InnerBitsetHelperChild(
            InnerBitsetHelperChild&& _var_InnerBitsetHelperChild)
    {
        m_var_InnerBitsetHelperChild = std::move(_var_InnerBitsetHelperChild);
    }

    /*!
     * @brief This function returns a constant reference to member var_InnerBitsetHelperChild
     * @return Constant reference to member var_InnerBitsetHelperChild
     */
    eProsima_user_DllExport const InnerBitsetHelperChild& var_InnerBitsetHelperChild() const
    {
        return m_var_InnerBitsetHelperChild;
    }

    /*!
     * @brief This function returns a reference to member var_InnerBitsetHelperChild
     * @return Reference to member var_InnerBitsetHelperChild
     */
    eProsima_user_DllExport InnerBitsetHelperChild& var_InnerBitsetHelperChild()
    {
        return m_var_InnerBitsetHelperChild;
    }


    /*!
     * @brief This function copies the value in member var_InnerBitsetHelperChildChild
     * @param _var_InnerBitsetHelperChildChild New value to be copied in member var_InnerBitsetHelperChildChild
     */
    eProsima_user_DllExport void var_InnerBitsetHelperChildChild(
            const InnerBitsetHelperChildChild& _var_InnerBitsetHelperChildChild)
    {
        m_var_InnerBitsetHelperChildChild = _var_InnerBitsetHelperChildChild;
    }

    /*!
     * @brief This function moves the value in member var_InnerBitsetHelperChildChild
     * @param _var_InnerBitsetHelperChildChild New value to be moved in member var_InnerBitsetHelperChildChild
     */
    eProsima_user_DllExport void var_InnerBitsetHelperChildChild(
            InnerBitsetHelperChildChild&& _var_InnerBitsetHelperChildChild)
    {
        m_var_InnerBitsetHelperChildChild = std::move(_var_InnerBitsetHelperChildChild);
    }

    /*!
     * @brief This function returns a constant reference to member var_InnerBitsetHelperChildChild
     * @return Constant reference to member var_InnerBitsetHelperChildChild
     */
    eProsima_user_DllExport const InnerBitsetHelperChildChild& var_InnerBitsetHelperChildChild() const
    {
        return m_var_InnerBitsetHelperChildChild;
    }

    /*!
     * @brief This function returns a reference to member var_InnerBitsetHelperChildChild
     * @return Reference to member var_InnerBitsetHelperChildChild
     */
    eProsima_user_DllExport InnerBitsetHelperChildChild& var_InnerBitsetHelperChildChild()
    {
        return m_var_InnerBitsetHelperChildChild;
    }


    /*!
     * @brief This function copies the value in member var_BitsetAliasInheritanceBitset
     * @param _var_BitsetAliasInheritanceBitset New value to be copied in member var_BitsetAliasInheritanceBitset
     */
    eProsima_user_DllExport void var_BitsetAliasInheritanceBitset(
            const BitsetAliasInheritanceBitset& _var_BitsetAliasInheritanceBitset)
    {
        m_var_BitsetAliasInheritanceBitset = _var_BitsetAliasInheritanceBitset;
    }

    /*!
     * @brief This function moves the value in member var_BitsetAliasInheritanceBitset
     * @param _var_BitsetAliasInheritanceBitset New value to be moved in member var_BitsetAliasInheritanceBitset
     */
    eProsima_user_DllExport void var_BitsetAliasInheritanceBitset(
            BitsetAliasInheritanceBitset&& _var_BitsetAliasInheritanceBitset)
    {
        m_var_BitsetAliasInheritanceBitset = std::move(_var_BitsetAliasInheritanceBitset);
    }

    /*!
     * @brief This function returns a constant reference to member var_BitsetAliasInheritanceBitset
     * @return Constant reference to member var_BitsetAliasInheritanceBitset
     */
    eProsima_user_DllExport const BitsetAliasInheritanceBitset& var_BitsetAliasInheritanceBitset() const
    {
        return m_var_BitsetAliasInheritanceBitset;
    }

    /*!
     * @brief This function returns a reference to member var_BitsetAliasInheritanceBitset
     * @return Reference to member var_BitsetAliasInheritanceBitset
     */
    eProsima_user_DllExport BitsetAliasInheritanceBitset& var_BitsetAliasInheritanceBitset()
    {
        return m_var_BitsetAliasInheritanceBitset;
    }



private:

    InnerBitsetHelperChild m_var_InnerBitsetHelperChild{};
    InnerBitsetHelperChildChild m_var_InnerBitsetHelperChildChild{};
    BitsetAliasInheritanceBitset m_var_BitsetAliasInheritanceBitset{};

};

#endif // _FAST_DDS_GENERATED_INHERITANCE_HPP_


