// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file mapsTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen.
 */

#include "mapsTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>

#include "maps.hpp"

#include "helpers/basic_inner_types.hpp"

using namespace eprosima::fastdds::dds::xtypes;

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapShortShort_type_identifier(
        TypeIdentifierPair& type_ids_MapShortShort)
{

    ReturnCode_t return_code_MapShortShort {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapShortShort =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapShortShort", type_ids_MapShortShort);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapShortShort)
    {
        StructTypeFlag struct_flags_MapShortShort = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapShortShort = "MapShortShort";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapShortShort;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapShortShort;
        CompleteTypeDetail detail_MapShortShort = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapShortShort, ann_custom_MapShortShort, type_name_MapShortShort.to_string());
        CompleteStructHeader header_MapShortShort;
        header_MapShortShort = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapShortShort);
        CompleteStructMemberSeq member_seq_MapShortShort;
        {
            TypeIdentifierPair type_ids_var_map_short_short;
            ReturnCode_t return_code_var_map_short_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_short_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_int16_t_unbounded", type_ids_var_map_short_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_short)
            {
                return_code_var_map_short_short =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_short);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_short)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int16_t_int16_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_int16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_short, element_identifier_anonymous_map_int16_t_int16_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_int16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_int16_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_short_short =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_short);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_short)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_int16_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_int16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_short, key_identifier_anonymous_map_int16_t_int16_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_int16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_int16_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_int16_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_int16_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_int16_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_int16_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_int16_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_int16_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_int16_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_int16_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_int16_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_int16_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_int16_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_int16_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_int16_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_int16_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_int16_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_int16_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_int16_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_int16_t_unbounded, element_flags_anonymous_map_int16_t_int16_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_int16_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_int16_t_unbounded), key_flags_anonymous_map_int16_t_int16_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_int16_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_int16_t_unbounded", type_ids_var_map_short_short))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_int16_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_short_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_short_short = 0x00000000;
            bool common_var_map_short_short_ec {false};
            CommonStructMember common_var_map_short_short {TypeObjectUtils::build_common_struct_member(member_id_var_map_short_short, member_flags_var_map_short_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_short, common_var_map_short_short_ec))};
            if (!common_var_map_short_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_short_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_short_short = "var_map_short_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_short_short;
            ann_custom_MapShortShort.reset();
            CompleteMemberDetail detail_var_map_short_short = TypeObjectUtils::build_complete_member_detail(name_var_map_short_short, member_ann_builtin_var_map_short_short, ann_custom_MapShortShort);
            CompleteStructMember member_var_map_short_short = TypeObjectUtils::build_complete_struct_member(common_var_map_short_short, detail_var_map_short_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapShortShort, member_var_map_short_short);
        }
        CompleteStructType struct_type_MapShortShort = TypeObjectUtils::build_complete_struct_type(struct_flags_MapShortShort, header_MapShortShort, member_seq_MapShortShort);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapShortShort, type_name_MapShortShort.to_string(), type_ids_MapShortShort))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapShortShort already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapShortUShort_type_identifier(
        TypeIdentifierPair& type_ids_MapShortUShort)
{

    ReturnCode_t return_code_MapShortUShort {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapShortUShort =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapShortUShort", type_ids_MapShortUShort);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapShortUShort)
    {
        StructTypeFlag struct_flags_MapShortUShort = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapShortUShort = "MapShortUShort";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapShortUShort;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapShortUShort;
        CompleteTypeDetail detail_MapShortUShort = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapShortUShort, ann_custom_MapShortUShort, type_name_MapShortUShort.to_string());
        CompleteStructHeader header_MapShortUShort;
        header_MapShortUShort = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapShortUShort);
        CompleteStructMemberSeq member_seq_MapShortUShort;
        {
            TypeIdentifierPair type_ids_var_map_short_ushort;
            ReturnCode_t return_code_var_map_short_ushort {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_short_ushort =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_uint16_t_unbounded", type_ids_var_map_short_ushort);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_ushort)
            {
                return_code_var_map_short_ushort =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_short_ushort);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_ushort)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int16_t_uint16_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_uint16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_ushort, element_identifier_anonymous_map_int16_t_uint16_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_uint16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_uint16_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_short_ushort =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_ushort);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_ushort)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_uint16_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_uint16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_ushort, key_identifier_anonymous_map_int16_t_uint16_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_uint16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_uint16_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_uint16_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_uint16_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint16_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_uint16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint16_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_uint16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint16_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_uint16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint16_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_uint16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint16_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_uint16_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint16_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint16_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_uint16_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint16_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint16_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_uint16_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_uint16_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_uint16_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_uint16_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_uint16_t_unbounded, element_flags_anonymous_map_int16_t_uint16_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_uint16_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_uint16_t_unbounded), key_flags_anonymous_map_int16_t_uint16_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_uint16_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_uint16_t_unbounded", type_ids_var_map_short_ushort))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_uint16_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_short_ushort = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_short_ushort = 0x00000000;
            bool common_var_map_short_ushort_ec {false};
            CommonStructMember common_var_map_short_ushort {TypeObjectUtils::build_common_struct_member(member_id_var_map_short_ushort, member_flags_var_map_short_ushort, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_ushort, common_var_map_short_ushort_ec))};
            if (!common_var_map_short_ushort_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_short_ushort member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_short_ushort = "var_map_short_ushort";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_short_ushort;
            ann_custom_MapShortUShort.reset();
            CompleteMemberDetail detail_var_map_short_ushort = TypeObjectUtils::build_complete_member_detail(name_var_map_short_ushort, member_ann_builtin_var_map_short_ushort, ann_custom_MapShortUShort);
            CompleteStructMember member_var_map_short_ushort = TypeObjectUtils::build_complete_struct_member(common_var_map_short_ushort, detail_var_map_short_ushort);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapShortUShort, member_var_map_short_ushort);
        }
        CompleteStructType struct_type_MapShortUShort = TypeObjectUtils::build_complete_struct_type(struct_flags_MapShortUShort, header_MapShortUShort, member_seq_MapShortUShort);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapShortUShort, type_name_MapShortUShort.to_string(), type_ids_MapShortUShort))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapShortUShort already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapShortLong_type_identifier(
        TypeIdentifierPair& type_ids_MapShortLong)
{

    ReturnCode_t return_code_MapShortLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapShortLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapShortLong", type_ids_MapShortLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapShortLong)
    {
        StructTypeFlag struct_flags_MapShortLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapShortLong = "MapShortLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapShortLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapShortLong;
        CompleteTypeDetail detail_MapShortLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapShortLong, ann_custom_MapShortLong, type_name_MapShortLong.to_string());
        CompleteStructHeader header_MapShortLong;
        header_MapShortLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapShortLong);
        CompleteStructMemberSeq member_seq_MapShortLong;
        {
            TypeIdentifierPair type_ids_var_map_short_long;
            ReturnCode_t return_code_var_map_short_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_short_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_int32_t_unbounded", type_ids_var_map_short_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_long)
            {
                return_code_var_map_short_long =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_short_long);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_long)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int16_t_int32_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_long, element_identifier_anonymous_map_int16_t_int32_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_int32_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_int32_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_short_long =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_long);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_long)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_int32_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_long, key_identifier_anonymous_map_int16_t_int32_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_int32_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_int32_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_int32_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_int32_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_int32_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_int32_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_int32_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_int32_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_int32_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_int32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_int32_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_int32_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_int32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_int32_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_int32_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_int32_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_int32_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_int32_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_int32_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_int32_t_unbounded, element_flags_anonymous_map_int16_t_int32_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_int32_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_int32_t_unbounded), key_flags_anonymous_map_int16_t_int32_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_int32_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_int32_t_unbounded", type_ids_var_map_short_long))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_int32_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_short_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_short_long = 0x00000000;
            bool common_var_map_short_long_ec {false};
            CommonStructMember common_var_map_short_long {TypeObjectUtils::build_common_struct_member(member_id_var_map_short_long, member_flags_var_map_short_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_long, common_var_map_short_long_ec))};
            if (!common_var_map_short_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_short_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_short_long = "var_map_short_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_short_long;
            ann_custom_MapShortLong.reset();
            CompleteMemberDetail detail_var_map_short_long = TypeObjectUtils::build_complete_member_detail(name_var_map_short_long, member_ann_builtin_var_map_short_long, ann_custom_MapShortLong);
            CompleteStructMember member_var_map_short_long = TypeObjectUtils::build_complete_struct_member(common_var_map_short_long, detail_var_map_short_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapShortLong, member_var_map_short_long);
        }
        CompleteStructType struct_type_MapShortLong = TypeObjectUtils::build_complete_struct_type(struct_flags_MapShortLong, header_MapShortLong, member_seq_MapShortLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapShortLong, type_name_MapShortLong.to_string(), type_ids_MapShortLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapShortLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapShortULong_type_identifier(
        TypeIdentifierPair& type_ids_MapShortULong)
{

    ReturnCode_t return_code_MapShortULong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapShortULong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapShortULong", type_ids_MapShortULong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapShortULong)
    {
        StructTypeFlag struct_flags_MapShortULong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapShortULong = "MapShortULong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapShortULong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapShortULong;
        CompleteTypeDetail detail_MapShortULong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapShortULong, ann_custom_MapShortULong, type_name_MapShortULong.to_string());
        CompleteStructHeader header_MapShortULong;
        header_MapShortULong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapShortULong);
        CompleteStructMemberSeq member_seq_MapShortULong;
        {
            TypeIdentifierPair type_ids_var_map_short_ulong;
            ReturnCode_t return_code_var_map_short_ulong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_short_ulong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_uint32_t_unbounded", type_ids_var_map_short_ulong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_ulong)
            {
                return_code_var_map_short_ulong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_var_map_short_ulong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_ulong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int16_t_uint32_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_uint32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_ulong, element_identifier_anonymous_map_int16_t_uint32_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_uint32_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_uint32_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_short_ulong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_ulong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_ulong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_uint32_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_uint32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_ulong, key_identifier_anonymous_map_int16_t_uint32_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_uint32_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_uint32_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_uint32_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_uint32_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint32_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_uint32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint32_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_uint32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint32_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_uint32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint32_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_uint32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint32_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_uint32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint32_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint32_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_uint32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint32_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint32_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_uint32_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_uint32_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_uint32_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_uint32_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_uint32_t_unbounded, element_flags_anonymous_map_int16_t_uint32_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_uint32_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_uint32_t_unbounded), key_flags_anonymous_map_int16_t_uint32_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_uint32_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_uint32_t_unbounded", type_ids_var_map_short_ulong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_uint32_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_short_ulong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_short_ulong = 0x00000000;
            bool common_var_map_short_ulong_ec {false};
            CommonStructMember common_var_map_short_ulong {TypeObjectUtils::build_common_struct_member(member_id_var_map_short_ulong, member_flags_var_map_short_ulong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_ulong, common_var_map_short_ulong_ec))};
            if (!common_var_map_short_ulong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_short_ulong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_short_ulong = "var_map_short_ulong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_short_ulong;
            ann_custom_MapShortULong.reset();
            CompleteMemberDetail detail_var_map_short_ulong = TypeObjectUtils::build_complete_member_detail(name_var_map_short_ulong, member_ann_builtin_var_map_short_ulong, ann_custom_MapShortULong);
            CompleteStructMember member_var_map_short_ulong = TypeObjectUtils::build_complete_struct_member(common_var_map_short_ulong, detail_var_map_short_ulong);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapShortULong, member_var_map_short_ulong);
        }
        CompleteStructType struct_type_MapShortULong = TypeObjectUtils::build_complete_struct_type(struct_flags_MapShortULong, header_MapShortULong, member_seq_MapShortULong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapShortULong, type_name_MapShortULong.to_string(), type_ids_MapShortULong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapShortULong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapShortLongLong_type_identifier(
        TypeIdentifierPair& type_ids_MapShortLongLong)
{

    ReturnCode_t return_code_MapShortLongLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapShortLongLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapShortLongLong", type_ids_MapShortLongLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapShortLongLong)
    {
        StructTypeFlag struct_flags_MapShortLongLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapShortLongLong = "MapShortLongLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapShortLongLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapShortLongLong;
        CompleteTypeDetail detail_MapShortLongLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapShortLongLong, ann_custom_MapShortLongLong, type_name_MapShortLongLong.to_string());
        CompleteStructHeader header_MapShortLongLong;
        header_MapShortLongLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapShortLongLong);
        CompleteStructMemberSeq member_seq_MapShortLongLong;
        {
            TypeIdentifierPair type_ids_var_map_short_longlong;
            ReturnCode_t return_code_var_map_short_longlong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_short_longlong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_int64_t_unbounded", type_ids_var_map_short_longlong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_longlong)
            {
                return_code_var_map_short_longlong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int64_t", type_ids_var_map_short_longlong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_longlong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int16_t_int64_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_int64_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_longlong, element_identifier_anonymous_map_int16_t_int64_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_int64_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_int64_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_short_longlong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_longlong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_longlong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_int64_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_int64_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_longlong, key_identifier_anonymous_map_int16_t_int64_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_int64_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_int64_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_int64_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_int64_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_int64_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_int64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_int64_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_int64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_int64_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_int64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_int64_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_int64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_int64_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_int64_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_int64_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_int64_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_int64_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_int64_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_int64_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_int64_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_int64_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_int64_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_int64_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_int64_t_unbounded, element_flags_anonymous_map_int16_t_int64_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_int64_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_int64_t_unbounded), key_flags_anonymous_map_int16_t_int64_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_int64_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_int64_t_unbounded", type_ids_var_map_short_longlong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_int64_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_short_longlong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_short_longlong = 0x00000000;
            bool common_var_map_short_longlong_ec {false};
            CommonStructMember common_var_map_short_longlong {TypeObjectUtils::build_common_struct_member(member_id_var_map_short_longlong, member_flags_var_map_short_longlong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_longlong, common_var_map_short_longlong_ec))};
            if (!common_var_map_short_longlong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_short_longlong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_short_longlong = "var_map_short_longlong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_short_longlong;
            ann_custom_MapShortLongLong.reset();
            CompleteMemberDetail detail_var_map_short_longlong = TypeObjectUtils::build_complete_member_detail(name_var_map_short_longlong, member_ann_builtin_var_map_short_longlong, ann_custom_MapShortLongLong);
            CompleteStructMember member_var_map_short_longlong = TypeObjectUtils::build_complete_struct_member(common_var_map_short_longlong, detail_var_map_short_longlong);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapShortLongLong, member_var_map_short_longlong);
        }
        CompleteStructType struct_type_MapShortLongLong = TypeObjectUtils::build_complete_struct_type(struct_flags_MapShortLongLong, header_MapShortLongLong, member_seq_MapShortLongLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapShortLongLong, type_name_MapShortLongLong.to_string(), type_ids_MapShortLongLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapShortLongLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapShortULongLong_type_identifier(
        TypeIdentifierPair& type_ids_MapShortULongLong)
{

    ReturnCode_t return_code_MapShortULongLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapShortULongLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapShortULongLong", type_ids_MapShortULongLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapShortULongLong)
    {
        StructTypeFlag struct_flags_MapShortULongLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapShortULongLong = "MapShortULongLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapShortULongLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapShortULongLong;
        CompleteTypeDetail detail_MapShortULongLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapShortULongLong, ann_custom_MapShortULongLong, type_name_MapShortULongLong.to_string());
        CompleteStructHeader header_MapShortULongLong;
        header_MapShortULongLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapShortULongLong);
        CompleteStructMemberSeq member_seq_MapShortULongLong;
        {
            TypeIdentifierPair type_ids_var_map_short_ulonglong;
            ReturnCode_t return_code_var_map_short_ulonglong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_short_ulonglong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_uint64_t_unbounded", type_ids_var_map_short_ulonglong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_ulonglong)
            {
                return_code_var_map_short_ulonglong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint64_t", type_ids_var_map_short_ulonglong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_ulonglong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int16_t_uint64_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_uint64_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_ulonglong, element_identifier_anonymous_map_int16_t_uint64_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_uint64_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_uint64_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_short_ulonglong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_ulonglong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_ulonglong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_uint64_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_uint64_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_ulonglong, key_identifier_anonymous_map_int16_t_uint64_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_uint64_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_uint64_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_uint64_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_uint64_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint64_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_uint64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint64_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_uint64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint64_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_uint64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint64_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_uint64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint64_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_uint64_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint64_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint64_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_uint64_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint64_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_uint64_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_uint64_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_uint64_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_uint64_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_uint64_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_uint64_t_unbounded, element_flags_anonymous_map_int16_t_uint64_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_uint64_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_uint64_t_unbounded), key_flags_anonymous_map_int16_t_uint64_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_uint64_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_uint64_t_unbounded", type_ids_var_map_short_ulonglong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_uint64_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_short_ulonglong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_short_ulonglong = 0x00000000;
            bool common_var_map_short_ulonglong_ec {false};
            CommonStructMember common_var_map_short_ulonglong {TypeObjectUtils::build_common_struct_member(member_id_var_map_short_ulonglong, member_flags_var_map_short_ulonglong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_ulonglong, common_var_map_short_ulonglong_ec))};
            if (!common_var_map_short_ulonglong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_short_ulonglong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_short_ulonglong = "var_map_short_ulonglong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_short_ulonglong;
            ann_custom_MapShortULongLong.reset();
            CompleteMemberDetail detail_var_map_short_ulonglong = TypeObjectUtils::build_complete_member_detail(name_var_map_short_ulonglong, member_ann_builtin_var_map_short_ulonglong, ann_custom_MapShortULongLong);
            CompleteStructMember member_var_map_short_ulonglong = TypeObjectUtils::build_complete_struct_member(common_var_map_short_ulonglong, detail_var_map_short_ulonglong);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapShortULongLong, member_var_map_short_ulonglong);
        }
        CompleteStructType struct_type_MapShortULongLong = TypeObjectUtils::build_complete_struct_type(struct_flags_MapShortULongLong, header_MapShortULongLong, member_seq_MapShortULongLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapShortULongLong, type_name_MapShortULongLong.to_string(), type_ids_MapShortULongLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapShortULongLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapShortFloat_type_identifier(
        TypeIdentifierPair& type_ids_MapShortFloat)
{

    ReturnCode_t return_code_MapShortFloat {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapShortFloat =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapShortFloat", type_ids_MapShortFloat);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapShortFloat)
    {
        StructTypeFlag struct_flags_MapShortFloat = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapShortFloat = "MapShortFloat";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapShortFloat;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapShortFloat;
        CompleteTypeDetail detail_MapShortFloat = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapShortFloat, ann_custom_MapShortFloat, type_name_MapShortFloat.to_string());
        CompleteStructHeader header_MapShortFloat;
        header_MapShortFloat = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapShortFloat);
        CompleteStructMemberSeq member_seq_MapShortFloat;
        {
            TypeIdentifierPair type_ids_var_map_short_float;
            ReturnCode_t return_code_var_map_short_float {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_short_float =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_float_unbounded", type_ids_var_map_short_float);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_float)
            {
                return_code_var_map_short_float =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_float", type_ids_var_map_short_float);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_float)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int16_t_float_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_float_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_float, element_identifier_anonymous_map_int16_t_float_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_float_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_float_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_short_float =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_float);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_float)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_float_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_float_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_float, key_identifier_anonymous_map_int16_t_float_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_float_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_float_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_float_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_float_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_float_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_float_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_float_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_float_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_float_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_float_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_float_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_float_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_float_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_float_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_float_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_float_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_float_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_float_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_float_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_float_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_float_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_float_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_float_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_float_unbounded, element_flags_anonymous_map_int16_t_float_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_float_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_float_unbounded), key_flags_anonymous_map_int16_t_float_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_float_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_float_unbounded", type_ids_var_map_short_float))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_float_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_short_float = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_short_float = 0x00000000;
            bool common_var_map_short_float_ec {false};
            CommonStructMember common_var_map_short_float {TypeObjectUtils::build_common_struct_member(member_id_var_map_short_float, member_flags_var_map_short_float, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_float, common_var_map_short_float_ec))};
            if (!common_var_map_short_float_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_short_float member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_short_float = "var_map_short_float";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_short_float;
            ann_custom_MapShortFloat.reset();
            CompleteMemberDetail detail_var_map_short_float = TypeObjectUtils::build_complete_member_detail(name_var_map_short_float, member_ann_builtin_var_map_short_float, ann_custom_MapShortFloat);
            CompleteStructMember member_var_map_short_float = TypeObjectUtils::build_complete_struct_member(common_var_map_short_float, detail_var_map_short_float);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapShortFloat, member_var_map_short_float);
        }
        CompleteStructType struct_type_MapShortFloat = TypeObjectUtils::build_complete_struct_type(struct_flags_MapShortFloat, header_MapShortFloat, member_seq_MapShortFloat);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapShortFloat, type_name_MapShortFloat.to_string(), type_ids_MapShortFloat))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapShortFloat already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapShortDouble_type_identifier(
        TypeIdentifierPair& type_ids_MapShortDouble)
{

    ReturnCode_t return_code_MapShortDouble {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapShortDouble =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapShortDouble", type_ids_MapShortDouble);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapShortDouble)
    {
        StructTypeFlag struct_flags_MapShortDouble = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapShortDouble = "MapShortDouble";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapShortDouble;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapShortDouble;
        CompleteTypeDetail detail_MapShortDouble = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapShortDouble, ann_custom_MapShortDouble, type_name_MapShortDouble.to_string());
        CompleteStructHeader header_MapShortDouble;
        header_MapShortDouble = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapShortDouble);
        CompleteStructMemberSeq member_seq_MapShortDouble;
        {
            TypeIdentifierPair type_ids_var_map_short_double;
            ReturnCode_t return_code_var_map_short_double {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_short_double =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_double_unbounded", type_ids_var_map_short_double);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_double)
            {
                return_code_var_map_short_double =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_double", type_ids_var_map_short_double);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_double)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int16_t_double_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_double_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_double, element_identifier_anonymous_map_int16_t_double_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_double_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_double_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_short_double =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_double);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_double)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_double_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_double_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_double, key_identifier_anonymous_map_int16_t_double_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_double_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_double_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_double_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_double_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_double_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_double_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_double_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_double_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_double_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_double_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_double_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_double_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_double_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_double_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_double_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_double_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_double_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_double_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_double_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_double_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_double_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_double_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_double_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_double_unbounded, element_flags_anonymous_map_int16_t_double_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_double_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_double_unbounded), key_flags_anonymous_map_int16_t_double_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_double_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_double_unbounded", type_ids_var_map_short_double))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_double_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_short_double = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_short_double = 0x00000000;
            bool common_var_map_short_double_ec {false};
            CommonStructMember common_var_map_short_double {TypeObjectUtils::build_common_struct_member(member_id_var_map_short_double, member_flags_var_map_short_double, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_double, common_var_map_short_double_ec))};
            if (!common_var_map_short_double_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_short_double member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_short_double = "var_map_short_double";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_short_double;
            ann_custom_MapShortDouble.reset();
            CompleteMemberDetail detail_var_map_short_double = TypeObjectUtils::build_complete_member_detail(name_var_map_short_double, member_ann_builtin_var_map_short_double, ann_custom_MapShortDouble);
            CompleteStructMember member_var_map_short_double = TypeObjectUtils::build_complete_struct_member(common_var_map_short_double, detail_var_map_short_double);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapShortDouble, member_var_map_short_double);
        }
        CompleteStructType struct_type_MapShortDouble = TypeObjectUtils::build_complete_struct_type(struct_flags_MapShortDouble, header_MapShortDouble, member_seq_MapShortDouble);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapShortDouble, type_name_MapShortDouble.to_string(), type_ids_MapShortDouble))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapShortDouble already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapShortLongDouble_type_identifier(
        TypeIdentifierPair& type_ids_MapShortLongDouble)
{

    ReturnCode_t return_code_MapShortLongDouble {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapShortLongDouble =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapShortLongDouble", type_ids_MapShortLongDouble);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapShortLongDouble)
    {
        StructTypeFlag struct_flags_MapShortLongDouble = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapShortLongDouble = "MapShortLongDouble";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapShortLongDouble;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapShortLongDouble;
        CompleteTypeDetail detail_MapShortLongDouble = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapShortLongDouble, ann_custom_MapShortLongDouble, type_name_MapShortLongDouble.to_string());
        CompleteStructHeader header_MapShortLongDouble;
        header_MapShortLongDouble = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapShortLongDouble);
        CompleteStructMemberSeq member_seq_MapShortLongDouble;
        {
            TypeIdentifierPair type_ids_var_map_short_longdouble;
            ReturnCode_t return_code_var_map_short_longdouble {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_short_longdouble =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_longdouble_unbounded", type_ids_var_map_short_longdouble);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_longdouble)
            {
                return_code_var_map_short_longdouble =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_longdouble", type_ids_var_map_short_longdouble);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_longdouble)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int16_t_longdouble_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_longdouble_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_longdouble, element_identifier_anonymous_map_int16_t_longdouble_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_longdouble_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_longdouble_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_short_longdouble =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_longdouble);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_longdouble)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_longdouble_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_longdouble_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_longdouble, key_identifier_anonymous_map_int16_t_longdouble_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_longdouble_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_longdouble_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_longdouble_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_longdouble_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_longdouble_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_longdouble_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_longdouble_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_longdouble_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_longdouble_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_longdouble_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_longdouble_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_longdouble_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_longdouble_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_longdouble_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_longdouble_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_longdouble_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_longdouble_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_longdouble_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_longdouble_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_longdouble_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_longdouble_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_longdouble_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_longdouble_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_longdouble_unbounded, element_flags_anonymous_map_int16_t_longdouble_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_longdouble_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_longdouble_unbounded), key_flags_anonymous_map_int16_t_longdouble_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_longdouble_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_longdouble_unbounded", type_ids_var_map_short_longdouble))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_longdouble_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_short_longdouble = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_short_longdouble = 0x00000000;
            bool common_var_map_short_longdouble_ec {false};
            CommonStructMember common_var_map_short_longdouble {TypeObjectUtils::build_common_struct_member(member_id_var_map_short_longdouble, member_flags_var_map_short_longdouble, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_longdouble, common_var_map_short_longdouble_ec))};
            if (!common_var_map_short_longdouble_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_short_longdouble member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_short_longdouble = "var_map_short_longdouble";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_short_longdouble;
            ann_custom_MapShortLongDouble.reset();
            CompleteMemberDetail detail_var_map_short_longdouble = TypeObjectUtils::build_complete_member_detail(name_var_map_short_longdouble, member_ann_builtin_var_map_short_longdouble, ann_custom_MapShortLongDouble);
            CompleteStructMember member_var_map_short_longdouble = TypeObjectUtils::build_complete_struct_member(common_var_map_short_longdouble, detail_var_map_short_longdouble);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapShortLongDouble, member_var_map_short_longdouble);
        }
        CompleteStructType struct_type_MapShortLongDouble = TypeObjectUtils::build_complete_struct_type(struct_flags_MapShortLongDouble, header_MapShortLongDouble, member_seq_MapShortLongDouble);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapShortLongDouble, type_name_MapShortLongDouble.to_string(), type_ids_MapShortLongDouble))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapShortLongDouble already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapShortBoolean_type_identifier(
        TypeIdentifierPair& type_ids_MapShortBoolean)
{

    ReturnCode_t return_code_MapShortBoolean {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapShortBoolean =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapShortBoolean", type_ids_MapShortBoolean);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapShortBoolean)
    {
        StructTypeFlag struct_flags_MapShortBoolean = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapShortBoolean = "MapShortBoolean";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapShortBoolean;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapShortBoolean;
        CompleteTypeDetail detail_MapShortBoolean = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapShortBoolean, ann_custom_MapShortBoolean, type_name_MapShortBoolean.to_string());
        CompleteStructHeader header_MapShortBoolean;
        header_MapShortBoolean = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapShortBoolean);
        CompleteStructMemberSeq member_seq_MapShortBoolean;
        {
            TypeIdentifierPair type_ids_var_map_short_boolean;
            ReturnCode_t return_code_var_map_short_boolean {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_short_boolean =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_bool_unbounded", type_ids_var_map_short_boolean);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_boolean)
            {
                return_code_var_map_short_boolean =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_bool", type_ids_var_map_short_boolean);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_boolean)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int16_t_bool_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_bool_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_boolean, element_identifier_anonymous_map_int16_t_bool_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_bool_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_bool_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_short_boolean =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_boolean);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_boolean)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_bool_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_bool_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_boolean, key_identifier_anonymous_map_int16_t_bool_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_bool_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_bool_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_bool_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_bool_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_bool_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_bool_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_bool_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_bool_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_bool_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_bool_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_bool_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_bool_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_bool_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_bool_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_bool_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_bool_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_bool_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_bool_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_bool_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_bool_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_bool_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_bool_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_bool_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_bool_unbounded, element_flags_anonymous_map_int16_t_bool_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_bool_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_bool_unbounded), key_flags_anonymous_map_int16_t_bool_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_bool_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_bool_unbounded", type_ids_var_map_short_boolean))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_bool_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_short_boolean = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_short_boolean = 0x00000000;
            bool common_var_map_short_boolean_ec {false};
            CommonStructMember common_var_map_short_boolean {TypeObjectUtils::build_common_struct_member(member_id_var_map_short_boolean, member_flags_var_map_short_boolean, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_boolean, common_var_map_short_boolean_ec))};
            if (!common_var_map_short_boolean_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_short_boolean member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_short_boolean = "var_map_short_boolean";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_short_boolean;
            ann_custom_MapShortBoolean.reset();
            CompleteMemberDetail detail_var_map_short_boolean = TypeObjectUtils::build_complete_member_detail(name_var_map_short_boolean, member_ann_builtin_var_map_short_boolean, ann_custom_MapShortBoolean);
            CompleteStructMember member_var_map_short_boolean = TypeObjectUtils::build_complete_struct_member(common_var_map_short_boolean, detail_var_map_short_boolean);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapShortBoolean, member_var_map_short_boolean);
        }
        CompleteStructType struct_type_MapShortBoolean = TypeObjectUtils::build_complete_struct_type(struct_flags_MapShortBoolean, header_MapShortBoolean, member_seq_MapShortBoolean);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapShortBoolean, type_name_MapShortBoolean.to_string(), type_ids_MapShortBoolean))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapShortBoolean already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapShortOctet_type_identifier(
        TypeIdentifierPair& type_ids_MapShortOctet)
{

    ReturnCode_t return_code_MapShortOctet {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapShortOctet =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapShortOctet", type_ids_MapShortOctet);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapShortOctet)
    {
        StructTypeFlag struct_flags_MapShortOctet = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapShortOctet = "MapShortOctet";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapShortOctet;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapShortOctet;
        CompleteTypeDetail detail_MapShortOctet = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapShortOctet, ann_custom_MapShortOctet, type_name_MapShortOctet.to_string());
        CompleteStructHeader header_MapShortOctet;
        header_MapShortOctet = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapShortOctet);
        CompleteStructMemberSeq member_seq_MapShortOctet;
        {
            TypeIdentifierPair type_ids_var_map_short_octet;
            ReturnCode_t return_code_var_map_short_octet {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_short_octet =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_byte_unbounded", type_ids_var_map_short_octet);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_octet)
            {
                return_code_var_map_short_octet =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_byte", type_ids_var_map_short_octet);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_octet)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int16_t_byte_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_byte_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_octet, element_identifier_anonymous_map_int16_t_byte_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_byte_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_byte_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_short_octet =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_octet);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_octet)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_byte_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_byte_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_octet, key_identifier_anonymous_map_int16_t_byte_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_byte_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_byte_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_byte_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_byte_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_byte_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_byte_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_byte_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_byte_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_byte_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_byte_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_byte_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_byte_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_byte_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_byte_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_byte_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_byte_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_byte_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_byte_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_byte_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_byte_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_byte_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_byte_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_byte_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_byte_unbounded, element_flags_anonymous_map_int16_t_byte_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_byte_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_byte_unbounded), key_flags_anonymous_map_int16_t_byte_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_byte_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_byte_unbounded", type_ids_var_map_short_octet))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_byte_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_short_octet = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_short_octet = 0x00000000;
            bool common_var_map_short_octet_ec {false};
            CommonStructMember common_var_map_short_octet {TypeObjectUtils::build_common_struct_member(member_id_var_map_short_octet, member_flags_var_map_short_octet, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_octet, common_var_map_short_octet_ec))};
            if (!common_var_map_short_octet_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_short_octet member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_short_octet = "var_map_short_octet";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_short_octet;
            ann_custom_MapShortOctet.reset();
            CompleteMemberDetail detail_var_map_short_octet = TypeObjectUtils::build_complete_member_detail(name_var_map_short_octet, member_ann_builtin_var_map_short_octet, ann_custom_MapShortOctet);
            CompleteStructMember member_var_map_short_octet = TypeObjectUtils::build_complete_struct_member(common_var_map_short_octet, detail_var_map_short_octet);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapShortOctet, member_var_map_short_octet);
        }
        CompleteStructType struct_type_MapShortOctet = TypeObjectUtils::build_complete_struct_type(struct_flags_MapShortOctet, header_MapShortOctet, member_seq_MapShortOctet);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapShortOctet, type_name_MapShortOctet.to_string(), type_ids_MapShortOctet))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapShortOctet already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapShortChar_type_identifier(
        TypeIdentifierPair& type_ids_MapShortChar)
{

    ReturnCode_t return_code_MapShortChar {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapShortChar =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapShortChar", type_ids_MapShortChar);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapShortChar)
    {
        StructTypeFlag struct_flags_MapShortChar = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapShortChar = "MapShortChar";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapShortChar;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapShortChar;
        CompleteTypeDetail detail_MapShortChar = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapShortChar, ann_custom_MapShortChar, type_name_MapShortChar.to_string());
        CompleteStructHeader header_MapShortChar;
        header_MapShortChar = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapShortChar);
        CompleteStructMemberSeq member_seq_MapShortChar;
        {
            TypeIdentifierPair type_ids_var_map_short_char;
            ReturnCode_t return_code_var_map_short_char {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_short_char =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_char_unbounded", type_ids_var_map_short_char);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_char)
            {
                return_code_var_map_short_char =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_char", type_ids_var_map_short_char);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_char)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int16_t_char_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_char_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_char, element_identifier_anonymous_map_int16_t_char_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_char_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_char_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_short_char =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_char);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_char)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_char_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_char_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_char, key_identifier_anonymous_map_int16_t_char_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_char_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_char_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_char_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_char_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_char_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_char_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_char_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_char_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_char_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_char_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_char_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_char_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_char_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_char_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_char_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_char_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_char_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_char_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_char_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_char_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_char_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_char_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_char_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_char_unbounded, element_flags_anonymous_map_int16_t_char_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_char_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_char_unbounded), key_flags_anonymous_map_int16_t_char_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_char_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_char_unbounded", type_ids_var_map_short_char))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_char_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_short_char = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_short_char = 0x00000000;
            bool common_var_map_short_char_ec {false};
            CommonStructMember common_var_map_short_char {TypeObjectUtils::build_common_struct_member(member_id_var_map_short_char, member_flags_var_map_short_char, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_char, common_var_map_short_char_ec))};
            if (!common_var_map_short_char_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_short_char member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_short_char = "var_map_short_char";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_short_char;
            ann_custom_MapShortChar.reset();
            CompleteMemberDetail detail_var_map_short_char = TypeObjectUtils::build_complete_member_detail(name_var_map_short_char, member_ann_builtin_var_map_short_char, ann_custom_MapShortChar);
            CompleteStructMember member_var_map_short_char = TypeObjectUtils::build_complete_struct_member(common_var_map_short_char, detail_var_map_short_char);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapShortChar, member_var_map_short_char);
        }
        CompleteStructType struct_type_MapShortChar = TypeObjectUtils::build_complete_struct_type(struct_flags_MapShortChar, header_MapShortChar, member_seq_MapShortChar);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapShortChar, type_name_MapShortChar.to_string(), type_ids_MapShortChar))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapShortChar already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapShortWChar_type_identifier(
        TypeIdentifierPair& type_ids_MapShortWChar)
{

    ReturnCode_t return_code_MapShortWChar {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapShortWChar =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapShortWChar", type_ids_MapShortWChar);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapShortWChar)
    {
        StructTypeFlag struct_flags_MapShortWChar = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapShortWChar = "MapShortWChar";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapShortWChar;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapShortWChar;
        CompleteTypeDetail detail_MapShortWChar = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapShortWChar, ann_custom_MapShortWChar, type_name_MapShortWChar.to_string());
        CompleteStructHeader header_MapShortWChar;
        header_MapShortWChar = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapShortWChar);
        CompleteStructMemberSeq member_seq_MapShortWChar;
        {
            TypeIdentifierPair type_ids_var_map_short_wchar;
            ReturnCode_t return_code_var_map_short_wchar {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_short_wchar =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_wchar_t_unbounded", type_ids_var_map_short_wchar);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_wchar)
            {
                return_code_var_map_short_wchar =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_wchar_t", type_ids_var_map_short_wchar);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_wchar)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int16_t_wchar_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_wchar_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_wchar, element_identifier_anonymous_map_int16_t_wchar_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_wchar_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_wchar_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_short_wchar =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_wchar);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_wchar)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_wchar_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_wchar_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_wchar, key_identifier_anonymous_map_int16_t_wchar_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_wchar_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_wchar_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_wchar_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_wchar_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_wchar_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_wchar_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_wchar_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_wchar_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_wchar_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_wchar_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_wchar_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_wchar_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_wchar_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_wchar_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_wchar_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_wchar_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_wchar_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_wchar_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_wchar_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_wchar_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_wchar_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_wchar_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_wchar_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_wchar_t_unbounded, element_flags_anonymous_map_int16_t_wchar_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_wchar_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_wchar_t_unbounded), key_flags_anonymous_map_int16_t_wchar_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_wchar_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_wchar_t_unbounded", type_ids_var_map_short_wchar))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_wchar_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_short_wchar = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_short_wchar = 0x00000000;
            bool common_var_map_short_wchar_ec {false};
            CommonStructMember common_var_map_short_wchar {TypeObjectUtils::build_common_struct_member(member_id_var_map_short_wchar, member_flags_var_map_short_wchar, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_wchar, common_var_map_short_wchar_ec))};
            if (!common_var_map_short_wchar_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_short_wchar member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_short_wchar = "var_map_short_wchar";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_short_wchar;
            ann_custom_MapShortWChar.reset();
            CompleteMemberDetail detail_var_map_short_wchar = TypeObjectUtils::build_complete_member_detail(name_var_map_short_wchar, member_ann_builtin_var_map_short_wchar, ann_custom_MapShortWChar);
            CompleteStructMember member_var_map_short_wchar = TypeObjectUtils::build_complete_struct_member(common_var_map_short_wchar, detail_var_map_short_wchar);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapShortWChar, member_var_map_short_wchar);
        }
        CompleteStructType struct_type_MapShortWChar = TypeObjectUtils::build_complete_struct_type(struct_flags_MapShortWChar, header_MapShortWChar, member_seq_MapShortWChar);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapShortWChar, type_name_MapShortWChar.to_string(), type_ids_MapShortWChar))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapShortWChar already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapShortString_type_identifier(
        TypeIdentifierPair& type_ids_MapShortString)
{

    ReturnCode_t return_code_MapShortString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapShortString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapShortString", type_ids_MapShortString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapShortString)
    {
        StructTypeFlag struct_flags_MapShortString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapShortString = "MapShortString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapShortString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapShortString;
        CompleteTypeDetail detail_MapShortString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapShortString, ann_custom_MapShortString, type_name_MapShortString.to_string());
        CompleteStructHeader header_MapShortString;
        header_MapShortString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapShortString);
        CompleteStructMemberSeq member_seq_MapShortString;
        {
            TypeIdentifierPair type_ids_var_map_short_string;
            ReturnCode_t return_code_var_map_short_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_short_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_anonymous_string_unbounded_unbounded", type_ids_var_map_short_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_string)
            {
                return_code_var_map_short_string =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_string_unbounded", type_ids_var_map_short_string);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_string)
                {
                    {
                        SBound bound = 0;
                        StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                                "anonymous_string_unbounded", type_ids_var_map_short_string))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_map_int16_t_anonymous_string_unbounded_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_anonymous_string_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_string, element_identifier_anonymous_map_int16_t_anonymous_string_unbounded_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_anonymous_string_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_anonymous_string_unbounded_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_short_string =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_string);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_string)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_anonymous_string_unbounded_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_anonymous_string_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_string, key_identifier_anonymous_map_int16_t_anonymous_string_unbounded_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_anonymous_string_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_anonymous_string_unbounded_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_anonymous_string_unbounded_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_anonymous_string_unbounded_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_string_unbounded_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_anonymous_string_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_string_unbounded_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_anonymous_string_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_string_unbounded_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_anonymous_string_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_string_unbounded_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_anonymous_string_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_string_unbounded_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_anonymous_string_unbounded_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_string_unbounded_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_string_unbounded_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_anonymous_string_unbounded_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_string_unbounded_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_string_unbounded_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_anonymous_string_unbounded_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_anonymous_string_unbounded_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_anonymous_string_unbounded_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_anonymous_string_unbounded_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_anonymous_string_unbounded_unbounded, element_flags_anonymous_map_int16_t_anonymous_string_unbounded_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_anonymous_string_unbounded_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_anonymous_string_unbounded_unbounded), key_flags_anonymous_map_int16_t_anonymous_string_unbounded_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_anonymous_string_unbounded_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_anonymous_string_unbounded_unbounded", type_ids_var_map_short_string))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_anonymous_string_unbounded_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_short_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_short_string = 0x00000000;
            bool common_var_map_short_string_ec {false};
            CommonStructMember common_var_map_short_string {TypeObjectUtils::build_common_struct_member(member_id_var_map_short_string, member_flags_var_map_short_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_string, common_var_map_short_string_ec))};
            if (!common_var_map_short_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_short_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_short_string = "var_map_short_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_short_string;
            ann_custom_MapShortString.reset();
            CompleteMemberDetail detail_var_map_short_string = TypeObjectUtils::build_complete_member_detail(name_var_map_short_string, member_ann_builtin_var_map_short_string, ann_custom_MapShortString);
            CompleteStructMember member_var_map_short_string = TypeObjectUtils::build_complete_struct_member(common_var_map_short_string, detail_var_map_short_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapShortString, member_var_map_short_string);
        }
        CompleteStructType struct_type_MapShortString = TypeObjectUtils::build_complete_struct_type(struct_flags_MapShortString, header_MapShortString, member_seq_MapShortString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapShortString, type_name_MapShortString.to_string(), type_ids_MapShortString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapShortString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapShortWString_type_identifier(
        TypeIdentifierPair& type_ids_MapShortWString)
{

    ReturnCode_t return_code_MapShortWString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapShortWString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapShortWString", type_ids_MapShortWString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapShortWString)
    {
        StructTypeFlag struct_flags_MapShortWString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapShortWString = "MapShortWString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapShortWString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapShortWString;
        CompleteTypeDetail detail_MapShortWString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapShortWString, ann_custom_MapShortWString, type_name_MapShortWString.to_string());
        CompleteStructHeader header_MapShortWString;
        header_MapShortWString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapShortWString);
        CompleteStructMemberSeq member_seq_MapShortWString;
        {
            TypeIdentifierPair type_ids_var_map_short_wstring;
            ReturnCode_t return_code_var_map_short_wstring {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_short_wstring =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded", type_ids_var_map_short_wstring);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_wstring)
            {
                return_code_var_map_short_wstring =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_wstring_unbounded", type_ids_var_map_short_wstring);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_wstring)
                {
                    {
                        SBound bound = 0;
                        StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                                "anonymous_wstring_unbounded", type_ids_var_map_short_wstring, true))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_wstring_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_wstring, element_identifier_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_short_wstring =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_wstring);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_wstring)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_wstring, key_identifier_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded, element_flags_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded), key_flags_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded", type_ids_var_map_short_wstring))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_anonymous_wstring_unbounded_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_short_wstring = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_short_wstring = 0x00000000;
            bool common_var_map_short_wstring_ec {false};
            CommonStructMember common_var_map_short_wstring {TypeObjectUtils::build_common_struct_member(member_id_var_map_short_wstring, member_flags_var_map_short_wstring, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_wstring, common_var_map_short_wstring_ec))};
            if (!common_var_map_short_wstring_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_short_wstring member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_short_wstring = "var_map_short_wstring";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_short_wstring;
            ann_custom_MapShortWString.reset();
            CompleteMemberDetail detail_var_map_short_wstring = TypeObjectUtils::build_complete_member_detail(name_var_map_short_wstring, member_ann_builtin_var_map_short_wstring, ann_custom_MapShortWString);
            CompleteStructMember member_var_map_short_wstring = TypeObjectUtils::build_complete_struct_member(common_var_map_short_wstring, detail_var_map_short_wstring);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapShortWString, member_var_map_short_wstring);
        }
        CompleteStructType struct_type_MapShortWString = TypeObjectUtils::build_complete_struct_type(struct_flags_MapShortWString, header_MapShortWString, member_seq_MapShortWString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapShortWString, type_name_MapShortWString.to_string(), type_ids_MapShortWString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapShortWString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapShortInnerAliasBoundedStringHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapShortInnerAliasBoundedStringHelper)
{

    ReturnCode_t return_code_MapShortInnerAliasBoundedStringHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapShortInnerAliasBoundedStringHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapShortInnerAliasBoundedStringHelper", type_ids_MapShortInnerAliasBoundedStringHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapShortInnerAliasBoundedStringHelper)
    {
        StructTypeFlag struct_flags_MapShortInnerAliasBoundedStringHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapShortInnerAliasBoundedStringHelper = "MapShortInnerAliasBoundedStringHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapShortInnerAliasBoundedStringHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapShortInnerAliasBoundedStringHelper;
        CompleteTypeDetail detail_MapShortInnerAliasBoundedStringHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapShortInnerAliasBoundedStringHelper, ann_custom_MapShortInnerAliasBoundedStringHelper, type_name_MapShortInnerAliasBoundedStringHelper.to_string());
        CompleteStructHeader header_MapShortInnerAliasBoundedStringHelper;
        header_MapShortInnerAliasBoundedStringHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapShortInnerAliasBoundedStringHelper);
        CompleteStructMemberSeq member_seq_MapShortInnerAliasBoundedStringHelper;
        {
            TypeIdentifierPair type_ids_var_map_short_inneraliasboundedstringhelper;
            ReturnCode_t return_code_var_map_short_inneraliasboundedstringhelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_short_inneraliasboundedstringhelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_anonymous_string_10_unbounded", type_ids_var_map_short_inneraliasboundedstringhelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_inneraliasboundedstringhelper)
            {
                return_code_var_map_short_inneraliasboundedstringhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_bounded_string_helper", type_ids_var_map_short_inneraliasboundedstringhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_inneraliasboundedstringhelper)
                {
                ::register_Inner_alias_bounded_string_helper_type_identifier(type_ids_var_map_short_inneraliasboundedstringhelper);
                }
                bool element_identifier_anonymous_map_int16_t_anonymous_string_10_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_anonymous_string_10_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_inneraliasboundedstringhelper, element_identifier_anonymous_map_int16_t_anonymous_string_10_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_anonymous_string_10_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_anonymous_string_10_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_short_inneraliasboundedstringhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_inneraliasboundedstringhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_inneraliasboundedstringhelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_anonymous_string_10_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_anonymous_string_10_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_inneraliasboundedstringhelper, key_identifier_anonymous_map_int16_t_anonymous_string_10_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_anonymous_string_10_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_anonymous_string_10_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_anonymous_string_10_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_anonymous_string_10_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_string_10_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_anonymous_string_10_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_string_10_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_anonymous_string_10_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_string_10_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_anonymous_string_10_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_string_10_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_anonymous_string_10_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_string_10_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_anonymous_string_10_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_string_10_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_string_10_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_anonymous_string_10_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_string_10_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_string_10_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_anonymous_string_10_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_anonymous_string_10_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_anonymous_string_10_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_anonymous_string_10_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_anonymous_string_10_unbounded, element_flags_anonymous_map_int16_t_anonymous_string_10_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_anonymous_string_10_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_anonymous_string_10_unbounded), key_flags_anonymous_map_int16_t_anonymous_string_10_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_anonymous_string_10_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_anonymous_string_10_unbounded", type_ids_var_map_short_inneraliasboundedstringhelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_anonymous_string_10_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_short_inneraliasboundedstringhelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_short_inneraliasboundedstringhelper = 0x00000000;
            bool common_var_map_short_inneraliasboundedstringhelper_ec {false};
            CommonStructMember common_var_map_short_inneraliasboundedstringhelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_short_inneraliasboundedstringhelper, member_flags_var_map_short_inneraliasboundedstringhelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_inneraliasboundedstringhelper, common_var_map_short_inneraliasboundedstringhelper_ec))};
            if (!common_var_map_short_inneraliasboundedstringhelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_short_inneraliasboundedstringhelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_short_inneraliasboundedstringhelper = "var_map_short_inneraliasboundedstringhelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_short_inneraliasboundedstringhelper;
            ann_custom_MapShortInnerAliasBoundedStringHelper.reset();
            CompleteMemberDetail detail_var_map_short_inneraliasboundedstringhelper = TypeObjectUtils::build_complete_member_detail(name_var_map_short_inneraliasboundedstringhelper, member_ann_builtin_var_map_short_inneraliasboundedstringhelper, ann_custom_MapShortInnerAliasBoundedStringHelper);
            CompleteStructMember member_var_map_short_inneraliasboundedstringhelper = TypeObjectUtils::build_complete_struct_member(common_var_map_short_inneraliasboundedstringhelper, detail_var_map_short_inneraliasboundedstringhelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapShortInnerAliasBoundedStringHelper, member_var_map_short_inneraliasboundedstringhelper);
        }
        CompleteStructType struct_type_MapShortInnerAliasBoundedStringHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapShortInnerAliasBoundedStringHelper, header_MapShortInnerAliasBoundedStringHelper, member_seq_MapShortInnerAliasBoundedStringHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapShortInnerAliasBoundedStringHelper, type_name_MapShortInnerAliasBoundedStringHelper.to_string(), type_ids_MapShortInnerAliasBoundedStringHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapShortInnerAliasBoundedStringHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapShortInnerAliasBoundedWStringHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapShortInnerAliasBoundedWStringHelper)
{

    ReturnCode_t return_code_MapShortInnerAliasBoundedWStringHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapShortInnerAliasBoundedWStringHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapShortInnerAliasBoundedWStringHelper", type_ids_MapShortInnerAliasBoundedWStringHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapShortInnerAliasBoundedWStringHelper)
    {
        StructTypeFlag struct_flags_MapShortInnerAliasBoundedWStringHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapShortInnerAliasBoundedWStringHelper = "MapShortInnerAliasBoundedWStringHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapShortInnerAliasBoundedWStringHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapShortInnerAliasBoundedWStringHelper;
        CompleteTypeDetail detail_MapShortInnerAliasBoundedWStringHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapShortInnerAliasBoundedWStringHelper, ann_custom_MapShortInnerAliasBoundedWStringHelper, type_name_MapShortInnerAliasBoundedWStringHelper.to_string());
        CompleteStructHeader header_MapShortInnerAliasBoundedWStringHelper;
        header_MapShortInnerAliasBoundedWStringHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapShortInnerAliasBoundedWStringHelper);
        CompleteStructMemberSeq member_seq_MapShortInnerAliasBoundedWStringHelper;
        {
            TypeIdentifierPair type_ids_var_map_short_inneraliasboundedwstringhelper;
            ReturnCode_t return_code_var_map_short_inneraliasboundedwstringhelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_short_inneraliasboundedwstringhelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_anonymous_wstring_10_unbounded", type_ids_var_map_short_inneraliasboundedwstringhelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_inneraliasboundedwstringhelper)
            {
                return_code_var_map_short_inneraliasboundedwstringhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_bounded_wstring_helper", type_ids_var_map_short_inneraliasboundedwstringhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_inneraliasboundedwstringhelper)
                {
                ::register_Inner_alias_bounded_wstring_helper_type_identifier(type_ids_var_map_short_inneraliasboundedwstringhelper);
                }
                bool element_identifier_anonymous_map_int16_t_anonymous_wstring_10_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_anonymous_wstring_10_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_inneraliasboundedwstringhelper, element_identifier_anonymous_map_int16_t_anonymous_wstring_10_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_anonymous_wstring_10_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_anonymous_wstring_10_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_short_inneraliasboundedwstringhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_inneraliasboundedwstringhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_inneraliasboundedwstringhelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_anonymous_wstring_10_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_anonymous_wstring_10_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_inneraliasboundedwstringhelper, key_identifier_anonymous_map_int16_t_anonymous_wstring_10_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_anonymous_wstring_10_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_anonymous_wstring_10_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_anonymous_wstring_10_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_anonymous_wstring_10_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_wstring_10_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_anonymous_wstring_10_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_wstring_10_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_anonymous_wstring_10_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_wstring_10_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_anonymous_wstring_10_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_wstring_10_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_anonymous_wstring_10_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_wstring_10_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_anonymous_wstring_10_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_wstring_10_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_wstring_10_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_anonymous_wstring_10_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_wstring_10_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_wstring_10_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_anonymous_wstring_10_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_anonymous_wstring_10_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_anonymous_wstring_10_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_anonymous_wstring_10_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_anonymous_wstring_10_unbounded, element_flags_anonymous_map_int16_t_anonymous_wstring_10_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_anonymous_wstring_10_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_anonymous_wstring_10_unbounded), key_flags_anonymous_map_int16_t_anonymous_wstring_10_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_anonymous_wstring_10_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_anonymous_wstring_10_unbounded", type_ids_var_map_short_inneraliasboundedwstringhelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_anonymous_wstring_10_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_short_inneraliasboundedwstringhelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_short_inneraliasboundedwstringhelper = 0x00000000;
            bool common_var_map_short_inneraliasboundedwstringhelper_ec {false};
            CommonStructMember common_var_map_short_inneraliasboundedwstringhelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_short_inneraliasboundedwstringhelper, member_flags_var_map_short_inneraliasboundedwstringhelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_inneraliasboundedwstringhelper, common_var_map_short_inneraliasboundedwstringhelper_ec))};
            if (!common_var_map_short_inneraliasboundedwstringhelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_short_inneraliasboundedwstringhelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_short_inneraliasboundedwstringhelper = "var_map_short_inneraliasboundedwstringhelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_short_inneraliasboundedwstringhelper;
            ann_custom_MapShortInnerAliasBoundedWStringHelper.reset();
            CompleteMemberDetail detail_var_map_short_inneraliasboundedwstringhelper = TypeObjectUtils::build_complete_member_detail(name_var_map_short_inneraliasboundedwstringhelper, member_ann_builtin_var_map_short_inneraliasboundedwstringhelper, ann_custom_MapShortInnerAliasBoundedWStringHelper);
            CompleteStructMember member_var_map_short_inneraliasboundedwstringhelper = TypeObjectUtils::build_complete_struct_member(common_var_map_short_inneraliasboundedwstringhelper, detail_var_map_short_inneraliasboundedwstringhelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapShortInnerAliasBoundedWStringHelper, member_var_map_short_inneraliasboundedwstringhelper);
        }
        CompleteStructType struct_type_MapShortInnerAliasBoundedWStringHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapShortInnerAliasBoundedWStringHelper, header_MapShortInnerAliasBoundedWStringHelper, member_seq_MapShortInnerAliasBoundedWStringHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapShortInnerAliasBoundedWStringHelper, type_name_MapShortInnerAliasBoundedWStringHelper.to_string(), type_ids_MapShortInnerAliasBoundedWStringHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapShortInnerAliasBoundedWStringHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapShortInnerEnumHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapShortInnerEnumHelper)
{

    ReturnCode_t return_code_MapShortInnerEnumHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapShortInnerEnumHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapShortInnerEnumHelper", type_ids_MapShortInnerEnumHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapShortInnerEnumHelper)
    {
        StructTypeFlag struct_flags_MapShortInnerEnumHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapShortInnerEnumHelper = "MapShortInnerEnumHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapShortInnerEnumHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapShortInnerEnumHelper;
        CompleteTypeDetail detail_MapShortInnerEnumHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapShortInnerEnumHelper, ann_custom_MapShortInnerEnumHelper, type_name_MapShortInnerEnumHelper.to_string());
        CompleteStructHeader header_MapShortInnerEnumHelper;
        header_MapShortInnerEnumHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapShortInnerEnumHelper);
        CompleteStructMemberSeq member_seq_MapShortInnerEnumHelper;
        {
            TypeIdentifierPair type_ids_var_map_short_innerenumhelper;
            ReturnCode_t return_code_var_map_short_innerenumhelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_short_innerenumhelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_InnerEnumHelper_unbounded", type_ids_var_map_short_innerenumhelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_innerenumhelper)
            {
                return_code_var_map_short_innerenumhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerEnumHelper", type_ids_var_map_short_innerenumhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_innerenumhelper)
                {
                ::register_InnerEnumHelper_type_identifier(type_ids_var_map_short_innerenumhelper);
                }
                bool element_identifier_anonymous_map_int16_t_InnerEnumHelper_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_InnerEnumHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_innerenumhelper, element_identifier_anonymous_map_int16_t_InnerEnumHelper_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_InnerEnumHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_InnerEnumHelper_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_short_innerenumhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_innerenumhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_innerenumhelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_InnerEnumHelper_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_InnerEnumHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_innerenumhelper, key_identifier_anonymous_map_int16_t_InnerEnumHelper_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_InnerEnumHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_InnerEnumHelper_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_InnerEnumHelper_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_InnerEnumHelper_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerEnumHelper_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_InnerEnumHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerEnumHelper_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_InnerEnumHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerEnumHelper_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_InnerEnumHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerEnumHelper_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_InnerEnumHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerEnumHelper_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_InnerEnumHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerEnumHelper_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerEnumHelper_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_InnerEnumHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerEnumHelper_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerEnumHelper_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_InnerEnumHelper_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_InnerEnumHelper_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_InnerEnumHelper_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_InnerEnumHelper_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_InnerEnumHelper_unbounded, element_flags_anonymous_map_int16_t_InnerEnumHelper_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_InnerEnumHelper_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_InnerEnumHelper_unbounded), key_flags_anonymous_map_int16_t_InnerEnumHelper_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_InnerEnumHelper_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_InnerEnumHelper_unbounded", type_ids_var_map_short_innerenumhelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_InnerEnumHelper_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_short_innerenumhelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_short_innerenumhelper = 0x00000000;
            bool common_var_map_short_innerenumhelper_ec {false};
            CommonStructMember common_var_map_short_innerenumhelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_short_innerenumhelper, member_flags_var_map_short_innerenumhelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_innerenumhelper, common_var_map_short_innerenumhelper_ec))};
            if (!common_var_map_short_innerenumhelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_short_innerenumhelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_short_innerenumhelper = "var_map_short_innerenumhelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_short_innerenumhelper;
            ann_custom_MapShortInnerEnumHelper.reset();
            CompleteMemberDetail detail_var_map_short_innerenumhelper = TypeObjectUtils::build_complete_member_detail(name_var_map_short_innerenumhelper, member_ann_builtin_var_map_short_innerenumhelper, ann_custom_MapShortInnerEnumHelper);
            CompleteStructMember member_var_map_short_innerenumhelper = TypeObjectUtils::build_complete_struct_member(common_var_map_short_innerenumhelper, detail_var_map_short_innerenumhelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapShortInnerEnumHelper, member_var_map_short_innerenumhelper);
        }
        CompleteStructType struct_type_MapShortInnerEnumHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapShortInnerEnumHelper, header_MapShortInnerEnumHelper, member_seq_MapShortInnerEnumHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapShortInnerEnumHelper, type_name_MapShortInnerEnumHelper.to_string(), type_ids_MapShortInnerEnumHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapShortInnerEnumHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapShortInnerBitMaskHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapShortInnerBitMaskHelper)
{

    ReturnCode_t return_code_MapShortInnerBitMaskHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapShortInnerBitMaskHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapShortInnerBitMaskHelper", type_ids_MapShortInnerBitMaskHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapShortInnerBitMaskHelper)
    {
        StructTypeFlag struct_flags_MapShortInnerBitMaskHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapShortInnerBitMaskHelper = "MapShortInnerBitMaskHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapShortInnerBitMaskHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapShortInnerBitMaskHelper;
        CompleteTypeDetail detail_MapShortInnerBitMaskHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapShortInnerBitMaskHelper, ann_custom_MapShortInnerBitMaskHelper, type_name_MapShortInnerBitMaskHelper.to_string());
        CompleteStructHeader header_MapShortInnerBitMaskHelper;
        header_MapShortInnerBitMaskHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapShortInnerBitMaskHelper);
        CompleteStructMemberSeq member_seq_MapShortInnerBitMaskHelper;
        {
            TypeIdentifierPair type_ids_var_map_short_innerbitmaskhelper;
            ReturnCode_t return_code_var_map_short_innerbitmaskhelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_short_innerbitmaskhelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_InnerBitMaskHelper_unbounded", type_ids_var_map_short_innerbitmaskhelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_innerbitmaskhelper)
            {
                return_code_var_map_short_innerbitmaskhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerBitMaskHelper", type_ids_var_map_short_innerbitmaskhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_innerbitmaskhelper)
                {
                ::register_InnerBitMaskHelper_type_identifier(type_ids_var_map_short_innerbitmaskhelper);
                }
                bool element_identifier_anonymous_map_int16_t_InnerBitMaskHelper_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_InnerBitMaskHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_innerbitmaskhelper, element_identifier_anonymous_map_int16_t_InnerBitMaskHelper_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_InnerBitMaskHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_InnerBitMaskHelper_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_short_innerbitmaskhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_innerbitmaskhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_innerbitmaskhelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_InnerBitMaskHelper_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_InnerBitMaskHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_innerbitmaskhelper, key_identifier_anonymous_map_int16_t_InnerBitMaskHelper_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_InnerBitMaskHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_InnerBitMaskHelper_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_InnerBitMaskHelper_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_InnerBitMaskHelper_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerBitMaskHelper_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_InnerBitMaskHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerBitMaskHelper_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_InnerBitMaskHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerBitMaskHelper_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_InnerBitMaskHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerBitMaskHelper_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_InnerBitMaskHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerBitMaskHelper_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_InnerBitMaskHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerBitMaskHelper_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerBitMaskHelper_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_InnerBitMaskHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerBitMaskHelper_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerBitMaskHelper_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_InnerBitMaskHelper_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_InnerBitMaskHelper_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_InnerBitMaskHelper_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_InnerBitMaskHelper_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_InnerBitMaskHelper_unbounded, element_flags_anonymous_map_int16_t_InnerBitMaskHelper_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_InnerBitMaskHelper_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_InnerBitMaskHelper_unbounded), key_flags_anonymous_map_int16_t_InnerBitMaskHelper_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_InnerBitMaskHelper_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_InnerBitMaskHelper_unbounded", type_ids_var_map_short_innerbitmaskhelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_InnerBitMaskHelper_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_short_innerbitmaskhelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_short_innerbitmaskhelper = 0x00000000;
            bool common_var_map_short_innerbitmaskhelper_ec {false};
            CommonStructMember common_var_map_short_innerbitmaskhelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_short_innerbitmaskhelper, member_flags_var_map_short_innerbitmaskhelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_innerbitmaskhelper, common_var_map_short_innerbitmaskhelper_ec))};
            if (!common_var_map_short_innerbitmaskhelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_short_innerbitmaskhelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_short_innerbitmaskhelper = "var_map_short_innerbitmaskhelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_short_innerbitmaskhelper;
            ann_custom_MapShortInnerBitMaskHelper.reset();
            CompleteMemberDetail detail_var_map_short_innerbitmaskhelper = TypeObjectUtils::build_complete_member_detail(name_var_map_short_innerbitmaskhelper, member_ann_builtin_var_map_short_innerbitmaskhelper, ann_custom_MapShortInnerBitMaskHelper);
            CompleteStructMember member_var_map_short_innerbitmaskhelper = TypeObjectUtils::build_complete_struct_member(common_var_map_short_innerbitmaskhelper, detail_var_map_short_innerbitmaskhelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapShortInnerBitMaskHelper, member_var_map_short_innerbitmaskhelper);
        }
        CompleteStructType struct_type_MapShortInnerBitMaskHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapShortInnerBitMaskHelper, header_MapShortInnerBitMaskHelper, member_seq_MapShortInnerBitMaskHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapShortInnerBitMaskHelper, type_name_MapShortInnerBitMaskHelper.to_string(), type_ids_MapShortInnerBitMaskHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapShortInnerBitMaskHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapShortInnerAliasHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapShortInnerAliasHelper)
{

    ReturnCode_t return_code_MapShortInnerAliasHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapShortInnerAliasHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapShortInnerAliasHelper", type_ids_MapShortInnerAliasHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapShortInnerAliasHelper)
    {
        StructTypeFlag struct_flags_MapShortInnerAliasHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapShortInnerAliasHelper = "MapShortInnerAliasHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapShortInnerAliasHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapShortInnerAliasHelper;
        CompleteTypeDetail detail_MapShortInnerAliasHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapShortInnerAliasHelper, ann_custom_MapShortInnerAliasHelper, type_name_MapShortInnerAliasHelper.to_string());
        CompleteStructHeader header_MapShortInnerAliasHelper;
        header_MapShortInnerAliasHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapShortInnerAliasHelper);
        CompleteStructMemberSeq member_seq_MapShortInnerAliasHelper;
        {
            TypeIdentifierPair type_ids_var_map_short_inneraliashelper;
            ReturnCode_t return_code_var_map_short_inneraliashelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_short_inneraliashelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_InnerAliasHelper_unbounded", type_ids_var_map_short_inneraliashelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_inneraliashelper)
            {
                return_code_var_map_short_inneraliashelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerAliasHelper", type_ids_var_map_short_inneraliashelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_inneraliashelper)
                {
                ::register_InnerAliasHelper_type_identifier(type_ids_var_map_short_inneraliashelper);
                }
                bool element_identifier_anonymous_map_int16_t_InnerAliasHelper_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_InnerAliasHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_inneraliashelper, element_identifier_anonymous_map_int16_t_InnerAliasHelper_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_InnerAliasHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_InnerAliasHelper_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_short_inneraliashelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_inneraliashelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_inneraliashelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_InnerAliasHelper_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_InnerAliasHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_inneraliashelper, key_identifier_anonymous_map_int16_t_InnerAliasHelper_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_InnerAliasHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_InnerAliasHelper_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_InnerAliasHelper_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_InnerAliasHelper_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerAliasHelper_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_InnerAliasHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerAliasHelper_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_InnerAliasHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerAliasHelper_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_InnerAliasHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerAliasHelper_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_InnerAliasHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerAliasHelper_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_InnerAliasHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerAliasHelper_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerAliasHelper_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_InnerAliasHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerAliasHelper_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerAliasHelper_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_InnerAliasHelper_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_InnerAliasHelper_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_InnerAliasHelper_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_InnerAliasHelper_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_InnerAliasHelper_unbounded, element_flags_anonymous_map_int16_t_InnerAliasHelper_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_InnerAliasHelper_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_InnerAliasHelper_unbounded), key_flags_anonymous_map_int16_t_InnerAliasHelper_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_InnerAliasHelper_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_InnerAliasHelper_unbounded", type_ids_var_map_short_inneraliashelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_InnerAliasHelper_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_short_inneraliashelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_short_inneraliashelper = 0x00000000;
            bool common_var_map_short_inneraliashelper_ec {false};
            CommonStructMember common_var_map_short_inneraliashelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_short_inneraliashelper, member_flags_var_map_short_inneraliashelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_inneraliashelper, common_var_map_short_inneraliashelper_ec))};
            if (!common_var_map_short_inneraliashelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_short_inneraliashelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_short_inneraliashelper = "var_map_short_inneraliashelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_short_inneraliashelper;
            ann_custom_MapShortInnerAliasHelper.reset();
            CompleteMemberDetail detail_var_map_short_inneraliashelper = TypeObjectUtils::build_complete_member_detail(name_var_map_short_inneraliashelper, member_ann_builtin_var_map_short_inneraliashelper, ann_custom_MapShortInnerAliasHelper);
            CompleteStructMember member_var_map_short_inneraliashelper = TypeObjectUtils::build_complete_struct_member(common_var_map_short_inneraliashelper, detail_var_map_short_inneraliashelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapShortInnerAliasHelper, member_var_map_short_inneraliashelper);
        }
        CompleteStructType struct_type_MapShortInnerAliasHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapShortInnerAliasHelper, header_MapShortInnerAliasHelper, member_seq_MapShortInnerAliasHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapShortInnerAliasHelper, type_name_MapShortInnerAliasHelper.to_string(), type_ids_MapShortInnerAliasHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapShortInnerAliasHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapShortInnerAliasArrayHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapShortInnerAliasArrayHelper)
{

    ReturnCode_t return_code_MapShortInnerAliasArrayHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapShortInnerAliasArrayHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapShortInnerAliasArrayHelper", type_ids_MapShortInnerAliasArrayHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapShortInnerAliasArrayHelper)
    {
        StructTypeFlag struct_flags_MapShortInnerAliasArrayHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapShortInnerAliasArrayHelper = "MapShortInnerAliasArrayHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapShortInnerAliasArrayHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapShortInnerAliasArrayHelper;
        CompleteTypeDetail detail_MapShortInnerAliasArrayHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapShortInnerAliasArrayHelper, ann_custom_MapShortInnerAliasArrayHelper, type_name_MapShortInnerAliasArrayHelper.to_string());
        CompleteStructHeader header_MapShortInnerAliasArrayHelper;
        header_MapShortInnerAliasArrayHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapShortInnerAliasArrayHelper);
        CompleteStructMemberSeq member_seq_MapShortInnerAliasArrayHelper;
        {
            TypeIdentifierPair type_ids_var_map_short_inneraliasarrayhelper;
            ReturnCode_t return_code_var_map_short_inneraliasarrayhelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_short_inneraliasarrayhelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded", type_ids_var_map_short_inneraliasarrayhelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_inneraliasarrayhelper)
            {
                return_code_var_map_short_inneraliasarrayhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_array_helper", type_ids_var_map_short_inneraliasarrayhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_inneraliasarrayhelper)
                {
                ::register_Inner_alias_array_helper_type_identifier(type_ids_var_map_short_inneraliasarrayhelper);
                }
                bool element_identifier_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_inneraliasarrayhelper, element_identifier_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_short_inneraliasarrayhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_inneraliasarrayhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_inneraliasarrayhelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_inneraliasarrayhelper, key_identifier_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded, element_flags_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded), key_flags_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded", type_ids_var_map_short_inneraliasarrayhelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_anonymous_array_int16_t_2_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_short_inneraliasarrayhelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_short_inneraliasarrayhelper = 0x00000000;
            bool common_var_map_short_inneraliasarrayhelper_ec {false};
            CommonStructMember common_var_map_short_inneraliasarrayhelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_short_inneraliasarrayhelper, member_flags_var_map_short_inneraliasarrayhelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_inneraliasarrayhelper, common_var_map_short_inneraliasarrayhelper_ec))};
            if (!common_var_map_short_inneraliasarrayhelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_short_inneraliasarrayhelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_short_inneraliasarrayhelper = "var_map_short_inneraliasarrayhelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_short_inneraliasarrayhelper;
            ann_custom_MapShortInnerAliasArrayHelper.reset();
            CompleteMemberDetail detail_var_map_short_inneraliasarrayhelper = TypeObjectUtils::build_complete_member_detail(name_var_map_short_inneraliasarrayhelper, member_ann_builtin_var_map_short_inneraliasarrayhelper, ann_custom_MapShortInnerAliasArrayHelper);
            CompleteStructMember member_var_map_short_inneraliasarrayhelper = TypeObjectUtils::build_complete_struct_member(common_var_map_short_inneraliasarrayhelper, detail_var_map_short_inneraliasarrayhelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapShortInnerAliasArrayHelper, member_var_map_short_inneraliasarrayhelper);
        }
        CompleteStructType struct_type_MapShortInnerAliasArrayHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapShortInnerAliasArrayHelper, header_MapShortInnerAliasArrayHelper, member_seq_MapShortInnerAliasArrayHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapShortInnerAliasArrayHelper, type_name_MapShortInnerAliasArrayHelper.to_string(), type_ids_MapShortInnerAliasArrayHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapShortInnerAliasArrayHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapShortInnerAliasSequenceHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapShortInnerAliasSequenceHelper)
{

    ReturnCode_t return_code_MapShortInnerAliasSequenceHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapShortInnerAliasSequenceHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapShortInnerAliasSequenceHelper", type_ids_MapShortInnerAliasSequenceHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapShortInnerAliasSequenceHelper)
    {
        StructTypeFlag struct_flags_MapShortInnerAliasSequenceHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapShortInnerAliasSequenceHelper = "MapShortInnerAliasSequenceHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapShortInnerAliasSequenceHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapShortInnerAliasSequenceHelper;
        CompleteTypeDetail detail_MapShortInnerAliasSequenceHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapShortInnerAliasSequenceHelper, ann_custom_MapShortInnerAliasSequenceHelper, type_name_MapShortInnerAliasSequenceHelper.to_string());
        CompleteStructHeader header_MapShortInnerAliasSequenceHelper;
        header_MapShortInnerAliasSequenceHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapShortInnerAliasSequenceHelper);
        CompleteStructMemberSeq member_seq_MapShortInnerAliasSequenceHelper;
        {
            TypeIdentifierPair type_ids_var_map_short_inneraliassequencehelper;
            ReturnCode_t return_code_var_map_short_inneraliassequencehelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_short_inneraliassequencehelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded", type_ids_var_map_short_inneraliassequencehelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_inneraliassequencehelper)
            {
                return_code_var_map_short_inneraliassequencehelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_sequence_helper", type_ids_var_map_short_inneraliassequencehelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_inneraliassequencehelper)
                {
                ::register_Inner_alias_sequence_helper_type_identifier(type_ids_var_map_short_inneraliassequencehelper);
                }
                bool element_identifier_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_inneraliassequencehelper, element_identifier_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_short_inneraliassequencehelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_inneraliassequencehelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_inneraliassequencehelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_inneraliassequencehelper, key_identifier_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded, element_flags_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded), key_flags_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded", type_ids_var_map_short_inneraliassequencehelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_anonymous_sequence_int16_t_unbounded_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_short_inneraliassequencehelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_short_inneraliassequencehelper = 0x00000000;
            bool common_var_map_short_inneraliassequencehelper_ec {false};
            CommonStructMember common_var_map_short_inneraliassequencehelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_short_inneraliassequencehelper, member_flags_var_map_short_inneraliassequencehelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_inneraliassequencehelper, common_var_map_short_inneraliassequencehelper_ec))};
            if (!common_var_map_short_inneraliassequencehelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_short_inneraliassequencehelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_short_inneraliassequencehelper = "var_map_short_inneraliassequencehelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_short_inneraliassequencehelper;
            ann_custom_MapShortInnerAliasSequenceHelper.reset();
            CompleteMemberDetail detail_var_map_short_inneraliassequencehelper = TypeObjectUtils::build_complete_member_detail(name_var_map_short_inneraliassequencehelper, member_ann_builtin_var_map_short_inneraliassequencehelper, ann_custom_MapShortInnerAliasSequenceHelper);
            CompleteStructMember member_var_map_short_inneraliassequencehelper = TypeObjectUtils::build_complete_struct_member(common_var_map_short_inneraliassequencehelper, detail_var_map_short_inneraliassequencehelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapShortInnerAliasSequenceHelper, member_var_map_short_inneraliassequencehelper);
        }
        CompleteStructType struct_type_MapShortInnerAliasSequenceHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapShortInnerAliasSequenceHelper, header_MapShortInnerAliasSequenceHelper, member_seq_MapShortInnerAliasSequenceHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapShortInnerAliasSequenceHelper, type_name_MapShortInnerAliasSequenceHelper.to_string(), type_ids_MapShortInnerAliasSequenceHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapShortInnerAliasSequenceHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapShortInnerAliasMapHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapShortInnerAliasMapHelper)
{

    ReturnCode_t return_code_MapShortInnerAliasMapHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapShortInnerAliasMapHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapShortInnerAliasMapHelper", type_ids_MapShortInnerAliasMapHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapShortInnerAliasMapHelper)
    {
        StructTypeFlag struct_flags_MapShortInnerAliasMapHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapShortInnerAliasMapHelper = "MapShortInnerAliasMapHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapShortInnerAliasMapHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapShortInnerAliasMapHelper;
        CompleteTypeDetail detail_MapShortInnerAliasMapHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapShortInnerAliasMapHelper, ann_custom_MapShortInnerAliasMapHelper, type_name_MapShortInnerAliasMapHelper.to_string());
        CompleteStructHeader header_MapShortInnerAliasMapHelper;
        header_MapShortInnerAliasMapHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapShortInnerAliasMapHelper);
        CompleteStructMemberSeq member_seq_MapShortInnerAliasMapHelper;
        {
            TypeIdentifierPair type_ids_var_map_short_inneraliasmaphelper;
            ReturnCode_t return_code_var_map_short_inneraliasmaphelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_short_inneraliasmaphelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded", type_ids_var_map_short_inneraliasmaphelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_inneraliasmaphelper)
            {
                return_code_var_map_short_inneraliasmaphelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_map_helper", type_ids_var_map_short_inneraliasmaphelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_inneraliasmaphelper)
                {
                ::register_Inner_alias_map_helper_type_identifier(type_ids_var_map_short_inneraliasmaphelper);
                }
                bool element_identifier_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_inneraliasmaphelper, element_identifier_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_short_inneraliasmaphelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_inneraliasmaphelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_inneraliasmaphelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_inneraliasmaphelper, key_identifier_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded, element_flags_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded), key_flags_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded", type_ids_var_map_short_inneraliasmaphelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_anonymous_map_int32_t_int32_t_0_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_short_inneraliasmaphelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_short_inneraliasmaphelper = 0x00000000;
            bool common_var_map_short_inneraliasmaphelper_ec {false};
            CommonStructMember common_var_map_short_inneraliasmaphelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_short_inneraliasmaphelper, member_flags_var_map_short_inneraliasmaphelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_inneraliasmaphelper, common_var_map_short_inneraliasmaphelper_ec))};
            if (!common_var_map_short_inneraliasmaphelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_short_inneraliasmaphelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_short_inneraliasmaphelper = "var_map_short_inneraliasmaphelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_short_inneraliasmaphelper;
            ann_custom_MapShortInnerAliasMapHelper.reset();
            CompleteMemberDetail detail_var_map_short_inneraliasmaphelper = TypeObjectUtils::build_complete_member_detail(name_var_map_short_inneraliasmaphelper, member_ann_builtin_var_map_short_inneraliasmaphelper, ann_custom_MapShortInnerAliasMapHelper);
            CompleteStructMember member_var_map_short_inneraliasmaphelper = TypeObjectUtils::build_complete_struct_member(common_var_map_short_inneraliasmaphelper, detail_var_map_short_inneraliasmaphelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapShortInnerAliasMapHelper, member_var_map_short_inneraliasmaphelper);
        }
        CompleteStructType struct_type_MapShortInnerAliasMapHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapShortInnerAliasMapHelper, header_MapShortInnerAliasMapHelper, member_seq_MapShortInnerAliasMapHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapShortInnerAliasMapHelper, type_name_MapShortInnerAliasMapHelper.to_string(), type_ids_MapShortInnerAliasMapHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapShortInnerAliasMapHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapShortInnerUnionHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapShortInnerUnionHelper)
{

    ReturnCode_t return_code_MapShortInnerUnionHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapShortInnerUnionHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapShortInnerUnionHelper", type_ids_MapShortInnerUnionHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapShortInnerUnionHelper)
    {
        StructTypeFlag struct_flags_MapShortInnerUnionHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapShortInnerUnionHelper = "MapShortInnerUnionHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapShortInnerUnionHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapShortInnerUnionHelper;
        CompleteTypeDetail detail_MapShortInnerUnionHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapShortInnerUnionHelper, ann_custom_MapShortInnerUnionHelper, type_name_MapShortInnerUnionHelper.to_string());
        CompleteStructHeader header_MapShortInnerUnionHelper;
        header_MapShortInnerUnionHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapShortInnerUnionHelper);
        CompleteStructMemberSeq member_seq_MapShortInnerUnionHelper;
        {
            TypeIdentifierPair type_ids_var_map_short_innerunionhelper;
            ReturnCode_t return_code_var_map_short_innerunionhelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_short_innerunionhelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_InnerUnionHelper_unbounded", type_ids_var_map_short_innerunionhelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_innerunionhelper)
            {
                return_code_var_map_short_innerunionhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerUnionHelper", type_ids_var_map_short_innerunionhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_innerunionhelper)
                {
                ::register_InnerUnionHelper_type_identifier(type_ids_var_map_short_innerunionhelper);
                }
                bool element_identifier_anonymous_map_int16_t_InnerUnionHelper_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_InnerUnionHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_innerunionhelper, element_identifier_anonymous_map_int16_t_InnerUnionHelper_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_InnerUnionHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_InnerUnionHelper_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_short_innerunionhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_innerunionhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_innerunionhelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_InnerUnionHelper_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_InnerUnionHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_innerunionhelper, key_identifier_anonymous_map_int16_t_InnerUnionHelper_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_InnerUnionHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_InnerUnionHelper_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_InnerUnionHelper_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_InnerUnionHelper_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerUnionHelper_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_InnerUnionHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerUnionHelper_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_InnerUnionHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerUnionHelper_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_InnerUnionHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerUnionHelper_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_InnerUnionHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerUnionHelper_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_InnerUnionHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerUnionHelper_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerUnionHelper_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_InnerUnionHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerUnionHelper_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerUnionHelper_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_InnerUnionHelper_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_InnerUnionHelper_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_InnerUnionHelper_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_InnerUnionHelper_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_InnerUnionHelper_unbounded, element_flags_anonymous_map_int16_t_InnerUnionHelper_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_InnerUnionHelper_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_InnerUnionHelper_unbounded), key_flags_anonymous_map_int16_t_InnerUnionHelper_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_InnerUnionHelper_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_InnerUnionHelper_unbounded", type_ids_var_map_short_innerunionhelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_InnerUnionHelper_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_short_innerunionhelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_short_innerunionhelper = 0x00000000;
            bool common_var_map_short_innerunionhelper_ec {false};
            CommonStructMember common_var_map_short_innerunionhelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_short_innerunionhelper, member_flags_var_map_short_innerunionhelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_innerunionhelper, common_var_map_short_innerunionhelper_ec))};
            if (!common_var_map_short_innerunionhelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_short_innerunionhelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_short_innerunionhelper = "var_map_short_innerunionhelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_short_innerunionhelper;
            ann_custom_MapShortInnerUnionHelper.reset();
            CompleteMemberDetail detail_var_map_short_innerunionhelper = TypeObjectUtils::build_complete_member_detail(name_var_map_short_innerunionhelper, member_ann_builtin_var_map_short_innerunionhelper, ann_custom_MapShortInnerUnionHelper);
            CompleteStructMember member_var_map_short_innerunionhelper = TypeObjectUtils::build_complete_struct_member(common_var_map_short_innerunionhelper, detail_var_map_short_innerunionhelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapShortInnerUnionHelper, member_var_map_short_innerunionhelper);
        }
        CompleteStructType struct_type_MapShortInnerUnionHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapShortInnerUnionHelper, header_MapShortInnerUnionHelper, member_seq_MapShortInnerUnionHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapShortInnerUnionHelper, type_name_MapShortInnerUnionHelper.to_string(), type_ids_MapShortInnerUnionHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapShortInnerUnionHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapShortInnerStructureHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapShortInnerStructureHelper)
{

    ReturnCode_t return_code_MapShortInnerStructureHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapShortInnerStructureHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapShortInnerStructureHelper", type_ids_MapShortInnerStructureHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapShortInnerStructureHelper)
    {
        StructTypeFlag struct_flags_MapShortInnerStructureHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapShortInnerStructureHelper = "MapShortInnerStructureHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapShortInnerStructureHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapShortInnerStructureHelper;
        CompleteTypeDetail detail_MapShortInnerStructureHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapShortInnerStructureHelper, ann_custom_MapShortInnerStructureHelper, type_name_MapShortInnerStructureHelper.to_string());
        CompleteStructHeader header_MapShortInnerStructureHelper;
        header_MapShortInnerStructureHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapShortInnerStructureHelper);
        CompleteStructMemberSeq member_seq_MapShortInnerStructureHelper;
        {
            TypeIdentifierPair type_ids_var_map_short_innerstructurehelper;
            ReturnCode_t return_code_var_map_short_innerstructurehelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_short_innerstructurehelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_InnerStructureHelper_unbounded", type_ids_var_map_short_innerstructurehelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_innerstructurehelper)
            {
                return_code_var_map_short_innerstructurehelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerStructureHelper", type_ids_var_map_short_innerstructurehelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_innerstructurehelper)
                {
                ::register_InnerStructureHelper_type_identifier(type_ids_var_map_short_innerstructurehelper);
                }
                bool element_identifier_anonymous_map_int16_t_InnerStructureHelper_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_InnerStructureHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_innerstructurehelper, element_identifier_anonymous_map_int16_t_InnerStructureHelper_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_InnerStructureHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_InnerStructureHelper_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_short_innerstructurehelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_innerstructurehelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_innerstructurehelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_InnerStructureHelper_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_InnerStructureHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_innerstructurehelper, key_identifier_anonymous_map_int16_t_InnerStructureHelper_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_InnerStructureHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_InnerStructureHelper_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_InnerStructureHelper_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_InnerStructureHelper_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerStructureHelper_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_InnerStructureHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerStructureHelper_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_InnerStructureHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerStructureHelper_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_InnerStructureHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerStructureHelper_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_InnerStructureHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerStructureHelper_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_InnerStructureHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerStructureHelper_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerStructureHelper_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_InnerStructureHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerStructureHelper_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerStructureHelper_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_InnerStructureHelper_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_InnerStructureHelper_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_InnerStructureHelper_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_InnerStructureHelper_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_InnerStructureHelper_unbounded, element_flags_anonymous_map_int16_t_InnerStructureHelper_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_InnerStructureHelper_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_InnerStructureHelper_unbounded), key_flags_anonymous_map_int16_t_InnerStructureHelper_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_InnerStructureHelper_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_InnerStructureHelper_unbounded", type_ids_var_map_short_innerstructurehelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_InnerStructureHelper_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_short_innerstructurehelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_short_innerstructurehelper = 0x00000000;
            bool common_var_map_short_innerstructurehelper_ec {false};
            CommonStructMember common_var_map_short_innerstructurehelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_short_innerstructurehelper, member_flags_var_map_short_innerstructurehelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_innerstructurehelper, common_var_map_short_innerstructurehelper_ec))};
            if (!common_var_map_short_innerstructurehelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_short_innerstructurehelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_short_innerstructurehelper = "var_map_short_innerstructurehelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_short_innerstructurehelper;
            ann_custom_MapShortInnerStructureHelper.reset();
            CompleteMemberDetail detail_var_map_short_innerstructurehelper = TypeObjectUtils::build_complete_member_detail(name_var_map_short_innerstructurehelper, member_ann_builtin_var_map_short_innerstructurehelper, ann_custom_MapShortInnerStructureHelper);
            CompleteStructMember member_var_map_short_innerstructurehelper = TypeObjectUtils::build_complete_struct_member(common_var_map_short_innerstructurehelper, detail_var_map_short_innerstructurehelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapShortInnerStructureHelper, member_var_map_short_innerstructurehelper);
        }
        CompleteStructType struct_type_MapShortInnerStructureHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapShortInnerStructureHelper, header_MapShortInnerStructureHelper, member_seq_MapShortInnerStructureHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapShortInnerStructureHelper, type_name_MapShortInnerStructureHelper.to_string(), type_ids_MapShortInnerStructureHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapShortInnerStructureHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapShortInnerBitsetHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapShortInnerBitsetHelper)
{

    ReturnCode_t return_code_MapShortInnerBitsetHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapShortInnerBitsetHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapShortInnerBitsetHelper", type_ids_MapShortInnerBitsetHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapShortInnerBitsetHelper)
    {
        StructTypeFlag struct_flags_MapShortInnerBitsetHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapShortInnerBitsetHelper = "MapShortInnerBitsetHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapShortInnerBitsetHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapShortInnerBitsetHelper;
        CompleteTypeDetail detail_MapShortInnerBitsetHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapShortInnerBitsetHelper, ann_custom_MapShortInnerBitsetHelper, type_name_MapShortInnerBitsetHelper.to_string());
        CompleteStructHeader header_MapShortInnerBitsetHelper;
        header_MapShortInnerBitsetHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapShortInnerBitsetHelper);
        CompleteStructMemberSeq member_seq_MapShortInnerBitsetHelper;
        {
            TypeIdentifierPair type_ids_var_map_short_innerbitsethelper;
            ReturnCode_t return_code_var_map_short_innerbitsethelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_short_innerbitsethelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int16_t_InnerBitsetHelper_unbounded", type_ids_var_map_short_innerbitsethelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_innerbitsethelper)
            {
                return_code_var_map_short_innerbitsethelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerBitsetHelper", type_ids_var_map_short_innerbitsethelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_innerbitsethelper)
                {
                ::register_InnerBitsetHelper_type_identifier(type_ids_var_map_short_innerbitsethelper);
                }
                bool element_identifier_anonymous_map_int16_t_InnerBitsetHelper_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int16_t_InnerBitsetHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_innerbitsethelper, element_identifier_anonymous_map_int16_t_InnerBitsetHelper_unbounded_ec))};
                if (!element_identifier_anonymous_map_int16_t_InnerBitsetHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_InnerBitsetHelper_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_short_innerbitsethelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_short_innerbitsethelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_short_innerbitsethelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int16_t_InnerBitsetHelper_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int16_t_InnerBitsetHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_innerbitsethelper, key_identifier_anonymous_map_int16_t_InnerBitsetHelper_unbounded_ec))};
                if (!key_identifier_anonymous_map_int16_t_InnerBitsetHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int16_t_InnerBitsetHelper_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int16_t_InnerBitsetHelper_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int16_t_InnerBitsetHelper_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerBitsetHelper_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int16_t_InnerBitsetHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerBitsetHelper_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int16_t_InnerBitsetHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerBitsetHelper_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int16_t_InnerBitsetHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerBitsetHelper_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int16_t_InnerBitsetHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerBitsetHelper_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int16_t_InnerBitsetHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerBitsetHelper_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerBitsetHelper_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int16_t_InnerBitsetHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerBitsetHelper_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int16_t_InnerBitsetHelper_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int16_t_InnerBitsetHelper_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int16_t_InnerBitsetHelper_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int16_t_InnerBitsetHelper_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int16_t_InnerBitsetHelper_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int16_t_InnerBitsetHelper_unbounded, element_flags_anonymous_map_int16_t_InnerBitsetHelper_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int16_t_InnerBitsetHelper_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int16_t_InnerBitsetHelper_unbounded), key_flags_anonymous_map_int16_t_InnerBitsetHelper_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int16_t_InnerBitsetHelper_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int16_t_InnerBitsetHelper_unbounded", type_ids_var_map_short_innerbitsethelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int16_t_InnerBitsetHelper_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_short_innerbitsethelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_short_innerbitsethelper = 0x00000000;
            bool common_var_map_short_innerbitsethelper_ec {false};
            CommonStructMember common_var_map_short_innerbitsethelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_short_innerbitsethelper, member_flags_var_map_short_innerbitsethelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_short_innerbitsethelper, common_var_map_short_innerbitsethelper_ec))};
            if (!common_var_map_short_innerbitsethelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_short_innerbitsethelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_short_innerbitsethelper = "var_map_short_innerbitsethelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_short_innerbitsethelper;
            ann_custom_MapShortInnerBitsetHelper.reset();
            CompleteMemberDetail detail_var_map_short_innerbitsethelper = TypeObjectUtils::build_complete_member_detail(name_var_map_short_innerbitsethelper, member_ann_builtin_var_map_short_innerbitsethelper, ann_custom_MapShortInnerBitsetHelper);
            CompleteStructMember member_var_map_short_innerbitsethelper = TypeObjectUtils::build_complete_struct_member(common_var_map_short_innerbitsethelper, detail_var_map_short_innerbitsethelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapShortInnerBitsetHelper, member_var_map_short_innerbitsethelper);
        }
        CompleteStructType struct_type_MapShortInnerBitsetHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapShortInnerBitsetHelper, header_MapShortInnerBitsetHelper, member_seq_MapShortInnerBitsetHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapShortInnerBitsetHelper, type_name_MapShortInnerBitsetHelper.to_string(), type_ids_MapShortInnerBitsetHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapShortInnerBitsetHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapUShortShort_type_identifier(
        TypeIdentifierPair& type_ids_MapUShortShort)
{

    ReturnCode_t return_code_MapUShortShort {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapUShortShort =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapUShortShort", type_ids_MapUShortShort);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapUShortShort)
    {
        StructTypeFlag struct_flags_MapUShortShort = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapUShortShort = "MapUShortShort";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapUShortShort;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapUShortShort;
        CompleteTypeDetail detail_MapUShortShort = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapUShortShort, ann_custom_MapUShortShort, type_name_MapUShortShort.to_string());
        CompleteStructHeader header_MapUShortShort;
        header_MapUShortShort = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapUShortShort);
        CompleteStructMemberSeq member_seq_MapUShortShort;
        {
            TypeIdentifierPair type_ids_var_map_ushort_short;
            ReturnCode_t return_code_var_map_ushort_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ushort_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint16_t_int16_t_unbounded", type_ids_var_map_ushort_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_short)
            {
                return_code_var_map_ushort_short =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_ushort_short);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_short)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_uint16_t_int16_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint16_t_int16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_short, element_identifier_anonymous_map_uint16_t_int16_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint16_t_int16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_int16_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ushort_short =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_short);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_short)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint16_t_int16_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint16_t_int16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_short, key_identifier_anonymous_map_uint16_t_int16_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint16_t_int16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_int16_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint16_t_int16_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint16_t_int16_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int16_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint16_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int16_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint16_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int16_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint16_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int16_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint16_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int16_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint16_t_int16_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int16_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int16_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint16_t_int16_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int16_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int16_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint16_t_int16_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint16_t_int16_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint16_t_int16_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint16_t_int16_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint16_t_int16_t_unbounded, element_flags_anonymous_map_uint16_t_int16_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint16_t_int16_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint16_t_int16_t_unbounded), key_flags_anonymous_map_uint16_t_int16_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint16_t_int16_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint16_t_int16_t_unbounded", type_ids_var_map_ushort_short))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint16_t_int16_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ushort_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ushort_short = 0x00000000;
            bool common_var_map_ushort_short_ec {false};
            CommonStructMember common_var_map_ushort_short {TypeObjectUtils::build_common_struct_member(member_id_var_map_ushort_short, member_flags_var_map_ushort_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_short, common_var_map_ushort_short_ec))};
            if (!common_var_map_ushort_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ushort_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ushort_short = "var_map_ushort_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ushort_short;
            ann_custom_MapUShortShort.reset();
            CompleteMemberDetail detail_var_map_ushort_short = TypeObjectUtils::build_complete_member_detail(name_var_map_ushort_short, member_ann_builtin_var_map_ushort_short, ann_custom_MapUShortShort);
            CompleteStructMember member_var_map_ushort_short = TypeObjectUtils::build_complete_struct_member(common_var_map_ushort_short, detail_var_map_ushort_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapUShortShort, member_var_map_ushort_short);
        }
        CompleteStructType struct_type_MapUShortShort = TypeObjectUtils::build_complete_struct_type(struct_flags_MapUShortShort, header_MapUShortShort, member_seq_MapUShortShort);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapUShortShort, type_name_MapUShortShort.to_string(), type_ids_MapUShortShort))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapUShortShort already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapUShortUShort_type_identifier(
        TypeIdentifierPair& type_ids_MapUShortUShort)
{

    ReturnCode_t return_code_MapUShortUShort {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapUShortUShort =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapUShortUShort", type_ids_MapUShortUShort);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapUShortUShort)
    {
        StructTypeFlag struct_flags_MapUShortUShort = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapUShortUShort = "MapUShortUShort";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapUShortUShort;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapUShortUShort;
        CompleteTypeDetail detail_MapUShortUShort = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapUShortUShort, ann_custom_MapUShortUShort, type_name_MapUShortUShort.to_string());
        CompleteStructHeader header_MapUShortUShort;
        header_MapUShortUShort = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapUShortUShort);
        CompleteStructMemberSeq member_seq_MapUShortUShort;
        {
            TypeIdentifierPair type_ids_var_map_ushort_ushort;
            ReturnCode_t return_code_var_map_ushort_ushort {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ushort_ushort =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint16_t_uint16_t_unbounded", type_ids_var_map_ushort_ushort);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_ushort)
            {
                return_code_var_map_ushort_ushort =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_ushort);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_ushort)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_uint16_t_uint16_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint16_t_uint16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_ushort, element_identifier_anonymous_map_uint16_t_uint16_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint16_t_uint16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_uint16_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ushort_ushort =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_ushort);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_ushort)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint16_t_uint16_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint16_t_uint16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_ushort, key_identifier_anonymous_map_uint16_t_uint16_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint16_t_uint16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_uint16_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint16_t_uint16_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint16_t_uint16_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint16_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint16_t_uint16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint16_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint16_t_uint16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint16_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint16_t_uint16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint16_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint16_t_uint16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint16_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint16_t_uint16_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint16_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint16_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint16_t_uint16_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint16_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint16_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint16_t_uint16_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint16_t_uint16_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint16_t_uint16_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint16_t_uint16_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint16_t_uint16_t_unbounded, element_flags_anonymous_map_uint16_t_uint16_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint16_t_uint16_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint16_t_uint16_t_unbounded), key_flags_anonymous_map_uint16_t_uint16_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint16_t_uint16_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint16_t_uint16_t_unbounded", type_ids_var_map_ushort_ushort))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint16_t_uint16_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ushort_ushort = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ushort_ushort = 0x00000000;
            bool common_var_map_ushort_ushort_ec {false};
            CommonStructMember common_var_map_ushort_ushort {TypeObjectUtils::build_common_struct_member(member_id_var_map_ushort_ushort, member_flags_var_map_ushort_ushort, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_ushort, common_var_map_ushort_ushort_ec))};
            if (!common_var_map_ushort_ushort_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ushort_ushort member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ushort_ushort = "var_map_ushort_ushort";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ushort_ushort;
            ann_custom_MapUShortUShort.reset();
            CompleteMemberDetail detail_var_map_ushort_ushort = TypeObjectUtils::build_complete_member_detail(name_var_map_ushort_ushort, member_ann_builtin_var_map_ushort_ushort, ann_custom_MapUShortUShort);
            CompleteStructMember member_var_map_ushort_ushort = TypeObjectUtils::build_complete_struct_member(common_var_map_ushort_ushort, detail_var_map_ushort_ushort);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapUShortUShort, member_var_map_ushort_ushort);
        }
        CompleteStructType struct_type_MapUShortUShort = TypeObjectUtils::build_complete_struct_type(struct_flags_MapUShortUShort, header_MapUShortUShort, member_seq_MapUShortUShort);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapUShortUShort, type_name_MapUShortUShort.to_string(), type_ids_MapUShortUShort))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapUShortUShort already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapUShortLong_type_identifier(
        TypeIdentifierPair& type_ids_MapUShortLong)
{

    ReturnCode_t return_code_MapUShortLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapUShortLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapUShortLong", type_ids_MapUShortLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapUShortLong)
    {
        StructTypeFlag struct_flags_MapUShortLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapUShortLong = "MapUShortLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapUShortLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapUShortLong;
        CompleteTypeDetail detail_MapUShortLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapUShortLong, ann_custom_MapUShortLong, type_name_MapUShortLong.to_string());
        CompleteStructHeader header_MapUShortLong;
        header_MapUShortLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapUShortLong);
        CompleteStructMemberSeq member_seq_MapUShortLong;
        {
            TypeIdentifierPair type_ids_var_map_ushort_long;
            ReturnCode_t return_code_var_map_ushort_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ushort_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint16_t_int32_t_unbounded", type_ids_var_map_ushort_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_long)
            {
                return_code_var_map_ushort_long =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_ushort_long);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_long)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_uint16_t_int32_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint16_t_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_long, element_identifier_anonymous_map_uint16_t_int32_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint16_t_int32_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_int32_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ushort_long =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_long);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_long)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint16_t_int32_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint16_t_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_long, key_identifier_anonymous_map_uint16_t_int32_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint16_t_int32_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_int32_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint16_t_int32_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint16_t_int32_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int32_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint16_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int32_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint16_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int32_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint16_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int32_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint16_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int32_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint16_t_int32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int32_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int32_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint16_t_int32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int32_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int32_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint16_t_int32_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint16_t_int32_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint16_t_int32_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint16_t_int32_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint16_t_int32_t_unbounded, element_flags_anonymous_map_uint16_t_int32_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint16_t_int32_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint16_t_int32_t_unbounded), key_flags_anonymous_map_uint16_t_int32_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint16_t_int32_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint16_t_int32_t_unbounded", type_ids_var_map_ushort_long))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint16_t_int32_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ushort_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ushort_long = 0x00000000;
            bool common_var_map_ushort_long_ec {false};
            CommonStructMember common_var_map_ushort_long {TypeObjectUtils::build_common_struct_member(member_id_var_map_ushort_long, member_flags_var_map_ushort_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_long, common_var_map_ushort_long_ec))};
            if (!common_var_map_ushort_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ushort_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ushort_long = "var_map_ushort_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ushort_long;
            ann_custom_MapUShortLong.reset();
            CompleteMemberDetail detail_var_map_ushort_long = TypeObjectUtils::build_complete_member_detail(name_var_map_ushort_long, member_ann_builtin_var_map_ushort_long, ann_custom_MapUShortLong);
            CompleteStructMember member_var_map_ushort_long = TypeObjectUtils::build_complete_struct_member(common_var_map_ushort_long, detail_var_map_ushort_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapUShortLong, member_var_map_ushort_long);
        }
        CompleteStructType struct_type_MapUShortLong = TypeObjectUtils::build_complete_struct_type(struct_flags_MapUShortLong, header_MapUShortLong, member_seq_MapUShortLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapUShortLong, type_name_MapUShortLong.to_string(), type_ids_MapUShortLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapUShortLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapUShortULong_type_identifier(
        TypeIdentifierPair& type_ids_MapUShortULong)
{

    ReturnCode_t return_code_MapUShortULong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapUShortULong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapUShortULong", type_ids_MapUShortULong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapUShortULong)
    {
        StructTypeFlag struct_flags_MapUShortULong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapUShortULong = "MapUShortULong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapUShortULong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapUShortULong;
        CompleteTypeDetail detail_MapUShortULong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapUShortULong, ann_custom_MapUShortULong, type_name_MapUShortULong.to_string());
        CompleteStructHeader header_MapUShortULong;
        header_MapUShortULong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapUShortULong);
        CompleteStructMemberSeq member_seq_MapUShortULong;
        {
            TypeIdentifierPair type_ids_var_map_ushort_ulong;
            ReturnCode_t return_code_var_map_ushort_ulong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ushort_ulong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint16_t_uint32_t_unbounded", type_ids_var_map_ushort_ulong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_ulong)
            {
                return_code_var_map_ushort_ulong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_var_map_ushort_ulong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_ulong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_uint16_t_uint32_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint16_t_uint32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_ulong, element_identifier_anonymous_map_uint16_t_uint32_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint16_t_uint32_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_uint32_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ushort_ulong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_ulong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_ulong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint16_t_uint32_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint16_t_uint32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_ulong, key_identifier_anonymous_map_uint16_t_uint32_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint16_t_uint32_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_uint32_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint16_t_uint32_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint16_t_uint32_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint32_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint16_t_uint32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint32_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint16_t_uint32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint32_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint16_t_uint32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint32_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint16_t_uint32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint32_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint16_t_uint32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint32_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint32_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint16_t_uint32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint32_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint32_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint16_t_uint32_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint16_t_uint32_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint16_t_uint32_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint16_t_uint32_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint16_t_uint32_t_unbounded, element_flags_anonymous_map_uint16_t_uint32_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint16_t_uint32_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint16_t_uint32_t_unbounded), key_flags_anonymous_map_uint16_t_uint32_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint16_t_uint32_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint16_t_uint32_t_unbounded", type_ids_var_map_ushort_ulong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint16_t_uint32_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ushort_ulong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ushort_ulong = 0x00000000;
            bool common_var_map_ushort_ulong_ec {false};
            CommonStructMember common_var_map_ushort_ulong {TypeObjectUtils::build_common_struct_member(member_id_var_map_ushort_ulong, member_flags_var_map_ushort_ulong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_ulong, common_var_map_ushort_ulong_ec))};
            if (!common_var_map_ushort_ulong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ushort_ulong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ushort_ulong = "var_map_ushort_ulong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ushort_ulong;
            ann_custom_MapUShortULong.reset();
            CompleteMemberDetail detail_var_map_ushort_ulong = TypeObjectUtils::build_complete_member_detail(name_var_map_ushort_ulong, member_ann_builtin_var_map_ushort_ulong, ann_custom_MapUShortULong);
            CompleteStructMember member_var_map_ushort_ulong = TypeObjectUtils::build_complete_struct_member(common_var_map_ushort_ulong, detail_var_map_ushort_ulong);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapUShortULong, member_var_map_ushort_ulong);
        }
        CompleteStructType struct_type_MapUShortULong = TypeObjectUtils::build_complete_struct_type(struct_flags_MapUShortULong, header_MapUShortULong, member_seq_MapUShortULong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapUShortULong, type_name_MapUShortULong.to_string(), type_ids_MapUShortULong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapUShortULong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapUShortLongLong_type_identifier(
        TypeIdentifierPair& type_ids_MapUShortLongLong)
{

    ReturnCode_t return_code_MapUShortLongLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapUShortLongLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapUShortLongLong", type_ids_MapUShortLongLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapUShortLongLong)
    {
        StructTypeFlag struct_flags_MapUShortLongLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapUShortLongLong = "MapUShortLongLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapUShortLongLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapUShortLongLong;
        CompleteTypeDetail detail_MapUShortLongLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapUShortLongLong, ann_custom_MapUShortLongLong, type_name_MapUShortLongLong.to_string());
        CompleteStructHeader header_MapUShortLongLong;
        header_MapUShortLongLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapUShortLongLong);
        CompleteStructMemberSeq member_seq_MapUShortLongLong;
        {
            TypeIdentifierPair type_ids_var_map_ushort_longlong;
            ReturnCode_t return_code_var_map_ushort_longlong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ushort_longlong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint16_t_int64_t_unbounded", type_ids_var_map_ushort_longlong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_longlong)
            {
                return_code_var_map_ushort_longlong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int64_t", type_ids_var_map_ushort_longlong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_longlong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_uint16_t_int64_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint16_t_int64_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_longlong, element_identifier_anonymous_map_uint16_t_int64_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint16_t_int64_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_int64_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ushort_longlong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_longlong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_longlong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint16_t_int64_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint16_t_int64_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_longlong, key_identifier_anonymous_map_uint16_t_int64_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint16_t_int64_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_int64_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint16_t_int64_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint16_t_int64_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int64_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint16_t_int64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int64_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint16_t_int64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int64_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint16_t_int64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int64_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint16_t_int64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int64_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint16_t_int64_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int64_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int64_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint16_t_int64_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int64_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_int64_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint16_t_int64_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint16_t_int64_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint16_t_int64_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint16_t_int64_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint16_t_int64_t_unbounded, element_flags_anonymous_map_uint16_t_int64_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint16_t_int64_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint16_t_int64_t_unbounded), key_flags_anonymous_map_uint16_t_int64_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint16_t_int64_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint16_t_int64_t_unbounded", type_ids_var_map_ushort_longlong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint16_t_int64_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ushort_longlong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ushort_longlong = 0x00000000;
            bool common_var_map_ushort_longlong_ec {false};
            CommonStructMember common_var_map_ushort_longlong {TypeObjectUtils::build_common_struct_member(member_id_var_map_ushort_longlong, member_flags_var_map_ushort_longlong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_longlong, common_var_map_ushort_longlong_ec))};
            if (!common_var_map_ushort_longlong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ushort_longlong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ushort_longlong = "var_map_ushort_longlong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ushort_longlong;
            ann_custom_MapUShortLongLong.reset();
            CompleteMemberDetail detail_var_map_ushort_longlong = TypeObjectUtils::build_complete_member_detail(name_var_map_ushort_longlong, member_ann_builtin_var_map_ushort_longlong, ann_custom_MapUShortLongLong);
            CompleteStructMember member_var_map_ushort_longlong = TypeObjectUtils::build_complete_struct_member(common_var_map_ushort_longlong, detail_var_map_ushort_longlong);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapUShortLongLong, member_var_map_ushort_longlong);
        }
        CompleteStructType struct_type_MapUShortLongLong = TypeObjectUtils::build_complete_struct_type(struct_flags_MapUShortLongLong, header_MapUShortLongLong, member_seq_MapUShortLongLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapUShortLongLong, type_name_MapUShortLongLong.to_string(), type_ids_MapUShortLongLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapUShortLongLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapUShortULongLong_type_identifier(
        TypeIdentifierPair& type_ids_MapUShortULongLong)
{

    ReturnCode_t return_code_MapUShortULongLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapUShortULongLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapUShortULongLong", type_ids_MapUShortULongLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapUShortULongLong)
    {
        StructTypeFlag struct_flags_MapUShortULongLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapUShortULongLong = "MapUShortULongLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapUShortULongLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapUShortULongLong;
        CompleteTypeDetail detail_MapUShortULongLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapUShortULongLong, ann_custom_MapUShortULongLong, type_name_MapUShortULongLong.to_string());
        CompleteStructHeader header_MapUShortULongLong;
        header_MapUShortULongLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapUShortULongLong);
        CompleteStructMemberSeq member_seq_MapUShortULongLong;
        {
            TypeIdentifierPair type_ids_var_map_ushort_ulonglong;
            ReturnCode_t return_code_var_map_ushort_ulonglong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ushort_ulonglong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint16_t_uint64_t_unbounded", type_ids_var_map_ushort_ulonglong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_ulonglong)
            {
                return_code_var_map_ushort_ulonglong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint64_t", type_ids_var_map_ushort_ulonglong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_ulonglong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_uint16_t_uint64_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint16_t_uint64_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_ulonglong, element_identifier_anonymous_map_uint16_t_uint64_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint16_t_uint64_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_uint64_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ushort_ulonglong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_ulonglong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_ulonglong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint16_t_uint64_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint16_t_uint64_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_ulonglong, key_identifier_anonymous_map_uint16_t_uint64_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint16_t_uint64_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_uint64_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint16_t_uint64_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint16_t_uint64_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint64_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint16_t_uint64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint64_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint16_t_uint64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint64_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint16_t_uint64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint64_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint16_t_uint64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint64_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint16_t_uint64_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint64_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint64_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint16_t_uint64_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint64_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_uint64_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint16_t_uint64_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint16_t_uint64_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint16_t_uint64_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint16_t_uint64_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint16_t_uint64_t_unbounded, element_flags_anonymous_map_uint16_t_uint64_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint16_t_uint64_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint16_t_uint64_t_unbounded), key_flags_anonymous_map_uint16_t_uint64_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint16_t_uint64_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint16_t_uint64_t_unbounded", type_ids_var_map_ushort_ulonglong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint16_t_uint64_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ushort_ulonglong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ushort_ulonglong = 0x00000000;
            bool common_var_map_ushort_ulonglong_ec {false};
            CommonStructMember common_var_map_ushort_ulonglong {TypeObjectUtils::build_common_struct_member(member_id_var_map_ushort_ulonglong, member_flags_var_map_ushort_ulonglong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_ulonglong, common_var_map_ushort_ulonglong_ec))};
            if (!common_var_map_ushort_ulonglong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ushort_ulonglong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ushort_ulonglong = "var_map_ushort_ulonglong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ushort_ulonglong;
            ann_custom_MapUShortULongLong.reset();
            CompleteMemberDetail detail_var_map_ushort_ulonglong = TypeObjectUtils::build_complete_member_detail(name_var_map_ushort_ulonglong, member_ann_builtin_var_map_ushort_ulonglong, ann_custom_MapUShortULongLong);
            CompleteStructMember member_var_map_ushort_ulonglong = TypeObjectUtils::build_complete_struct_member(common_var_map_ushort_ulonglong, detail_var_map_ushort_ulonglong);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapUShortULongLong, member_var_map_ushort_ulonglong);
        }
        CompleteStructType struct_type_MapUShortULongLong = TypeObjectUtils::build_complete_struct_type(struct_flags_MapUShortULongLong, header_MapUShortULongLong, member_seq_MapUShortULongLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapUShortULongLong, type_name_MapUShortULongLong.to_string(), type_ids_MapUShortULongLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapUShortULongLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapUShortFloat_type_identifier(
        TypeIdentifierPair& type_ids_MapUShortFloat)
{

    ReturnCode_t return_code_MapUShortFloat {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapUShortFloat =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapUShortFloat", type_ids_MapUShortFloat);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapUShortFloat)
    {
        StructTypeFlag struct_flags_MapUShortFloat = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapUShortFloat = "MapUShortFloat";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapUShortFloat;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapUShortFloat;
        CompleteTypeDetail detail_MapUShortFloat = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapUShortFloat, ann_custom_MapUShortFloat, type_name_MapUShortFloat.to_string());
        CompleteStructHeader header_MapUShortFloat;
        header_MapUShortFloat = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapUShortFloat);
        CompleteStructMemberSeq member_seq_MapUShortFloat;
        {
            TypeIdentifierPair type_ids_var_map_ushort_float;
            ReturnCode_t return_code_var_map_ushort_float {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ushort_float =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint16_t_float_unbounded", type_ids_var_map_ushort_float);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_float)
            {
                return_code_var_map_ushort_float =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_float", type_ids_var_map_ushort_float);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_float)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_uint16_t_float_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint16_t_float_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_float, element_identifier_anonymous_map_uint16_t_float_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint16_t_float_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_float_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ushort_float =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_float);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_float)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint16_t_float_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint16_t_float_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_float, key_identifier_anonymous_map_uint16_t_float_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint16_t_float_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_float_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint16_t_float_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint16_t_float_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_float_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint16_t_float_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_float_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint16_t_float_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_float_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint16_t_float_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_float_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint16_t_float_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_float_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint16_t_float_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_float_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_float_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint16_t_float_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_float_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_float_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint16_t_float_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint16_t_float_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint16_t_float_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint16_t_float_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint16_t_float_unbounded, element_flags_anonymous_map_uint16_t_float_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint16_t_float_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint16_t_float_unbounded), key_flags_anonymous_map_uint16_t_float_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint16_t_float_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint16_t_float_unbounded", type_ids_var_map_ushort_float))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint16_t_float_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ushort_float = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ushort_float = 0x00000000;
            bool common_var_map_ushort_float_ec {false};
            CommonStructMember common_var_map_ushort_float {TypeObjectUtils::build_common_struct_member(member_id_var_map_ushort_float, member_flags_var_map_ushort_float, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_float, common_var_map_ushort_float_ec))};
            if (!common_var_map_ushort_float_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ushort_float member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ushort_float = "var_map_ushort_float";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ushort_float;
            ann_custom_MapUShortFloat.reset();
            CompleteMemberDetail detail_var_map_ushort_float = TypeObjectUtils::build_complete_member_detail(name_var_map_ushort_float, member_ann_builtin_var_map_ushort_float, ann_custom_MapUShortFloat);
            CompleteStructMember member_var_map_ushort_float = TypeObjectUtils::build_complete_struct_member(common_var_map_ushort_float, detail_var_map_ushort_float);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapUShortFloat, member_var_map_ushort_float);
        }
        CompleteStructType struct_type_MapUShortFloat = TypeObjectUtils::build_complete_struct_type(struct_flags_MapUShortFloat, header_MapUShortFloat, member_seq_MapUShortFloat);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapUShortFloat, type_name_MapUShortFloat.to_string(), type_ids_MapUShortFloat))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapUShortFloat already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapUShortDouble_type_identifier(
        TypeIdentifierPair& type_ids_MapUShortDouble)
{

    ReturnCode_t return_code_MapUShortDouble {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapUShortDouble =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapUShortDouble", type_ids_MapUShortDouble);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapUShortDouble)
    {
        StructTypeFlag struct_flags_MapUShortDouble = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapUShortDouble = "MapUShortDouble";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapUShortDouble;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapUShortDouble;
        CompleteTypeDetail detail_MapUShortDouble = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapUShortDouble, ann_custom_MapUShortDouble, type_name_MapUShortDouble.to_string());
        CompleteStructHeader header_MapUShortDouble;
        header_MapUShortDouble = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapUShortDouble);
        CompleteStructMemberSeq member_seq_MapUShortDouble;
        {
            TypeIdentifierPair type_ids_var_map_ushort_double;
            ReturnCode_t return_code_var_map_ushort_double {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ushort_double =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint16_t_double_unbounded", type_ids_var_map_ushort_double);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_double)
            {
                return_code_var_map_ushort_double =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_double", type_ids_var_map_ushort_double);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_double)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_uint16_t_double_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint16_t_double_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_double, element_identifier_anonymous_map_uint16_t_double_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint16_t_double_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_double_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ushort_double =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_double);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_double)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint16_t_double_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint16_t_double_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_double, key_identifier_anonymous_map_uint16_t_double_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint16_t_double_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_double_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint16_t_double_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint16_t_double_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_double_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint16_t_double_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_double_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint16_t_double_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_double_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint16_t_double_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_double_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint16_t_double_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_double_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint16_t_double_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_double_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_double_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint16_t_double_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_double_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_double_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint16_t_double_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint16_t_double_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint16_t_double_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint16_t_double_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint16_t_double_unbounded, element_flags_anonymous_map_uint16_t_double_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint16_t_double_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint16_t_double_unbounded), key_flags_anonymous_map_uint16_t_double_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint16_t_double_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint16_t_double_unbounded", type_ids_var_map_ushort_double))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint16_t_double_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ushort_double = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ushort_double = 0x00000000;
            bool common_var_map_ushort_double_ec {false};
            CommonStructMember common_var_map_ushort_double {TypeObjectUtils::build_common_struct_member(member_id_var_map_ushort_double, member_flags_var_map_ushort_double, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_double, common_var_map_ushort_double_ec))};
            if (!common_var_map_ushort_double_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ushort_double member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ushort_double = "var_map_ushort_double";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ushort_double;
            ann_custom_MapUShortDouble.reset();
            CompleteMemberDetail detail_var_map_ushort_double = TypeObjectUtils::build_complete_member_detail(name_var_map_ushort_double, member_ann_builtin_var_map_ushort_double, ann_custom_MapUShortDouble);
            CompleteStructMember member_var_map_ushort_double = TypeObjectUtils::build_complete_struct_member(common_var_map_ushort_double, detail_var_map_ushort_double);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapUShortDouble, member_var_map_ushort_double);
        }
        CompleteStructType struct_type_MapUShortDouble = TypeObjectUtils::build_complete_struct_type(struct_flags_MapUShortDouble, header_MapUShortDouble, member_seq_MapUShortDouble);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapUShortDouble, type_name_MapUShortDouble.to_string(), type_ids_MapUShortDouble))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapUShortDouble already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapUShortLongDouble_type_identifier(
        TypeIdentifierPair& type_ids_MapUShortLongDouble)
{

    ReturnCode_t return_code_MapUShortLongDouble {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapUShortLongDouble =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapUShortLongDouble", type_ids_MapUShortLongDouble);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapUShortLongDouble)
    {
        StructTypeFlag struct_flags_MapUShortLongDouble = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapUShortLongDouble = "MapUShortLongDouble";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapUShortLongDouble;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapUShortLongDouble;
        CompleteTypeDetail detail_MapUShortLongDouble = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapUShortLongDouble, ann_custom_MapUShortLongDouble, type_name_MapUShortLongDouble.to_string());
        CompleteStructHeader header_MapUShortLongDouble;
        header_MapUShortLongDouble = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapUShortLongDouble);
        CompleteStructMemberSeq member_seq_MapUShortLongDouble;
        {
            TypeIdentifierPair type_ids_var_map_ushort_longdouble;
            ReturnCode_t return_code_var_map_ushort_longdouble {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ushort_longdouble =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint16_t_longdouble_unbounded", type_ids_var_map_ushort_longdouble);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_longdouble)
            {
                return_code_var_map_ushort_longdouble =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_longdouble", type_ids_var_map_ushort_longdouble);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_longdouble)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_uint16_t_longdouble_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint16_t_longdouble_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_longdouble, element_identifier_anonymous_map_uint16_t_longdouble_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint16_t_longdouble_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_longdouble_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ushort_longdouble =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_longdouble);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_longdouble)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint16_t_longdouble_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint16_t_longdouble_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_longdouble, key_identifier_anonymous_map_uint16_t_longdouble_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint16_t_longdouble_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_longdouble_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint16_t_longdouble_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint16_t_longdouble_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_longdouble_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint16_t_longdouble_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_longdouble_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint16_t_longdouble_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_longdouble_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint16_t_longdouble_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_longdouble_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint16_t_longdouble_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_longdouble_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint16_t_longdouble_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_longdouble_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_longdouble_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint16_t_longdouble_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_longdouble_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_longdouble_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint16_t_longdouble_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint16_t_longdouble_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint16_t_longdouble_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint16_t_longdouble_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint16_t_longdouble_unbounded, element_flags_anonymous_map_uint16_t_longdouble_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint16_t_longdouble_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint16_t_longdouble_unbounded), key_flags_anonymous_map_uint16_t_longdouble_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint16_t_longdouble_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint16_t_longdouble_unbounded", type_ids_var_map_ushort_longdouble))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint16_t_longdouble_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ushort_longdouble = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ushort_longdouble = 0x00000000;
            bool common_var_map_ushort_longdouble_ec {false};
            CommonStructMember common_var_map_ushort_longdouble {TypeObjectUtils::build_common_struct_member(member_id_var_map_ushort_longdouble, member_flags_var_map_ushort_longdouble, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_longdouble, common_var_map_ushort_longdouble_ec))};
            if (!common_var_map_ushort_longdouble_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ushort_longdouble member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ushort_longdouble = "var_map_ushort_longdouble";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ushort_longdouble;
            ann_custom_MapUShortLongDouble.reset();
            CompleteMemberDetail detail_var_map_ushort_longdouble = TypeObjectUtils::build_complete_member_detail(name_var_map_ushort_longdouble, member_ann_builtin_var_map_ushort_longdouble, ann_custom_MapUShortLongDouble);
            CompleteStructMember member_var_map_ushort_longdouble = TypeObjectUtils::build_complete_struct_member(common_var_map_ushort_longdouble, detail_var_map_ushort_longdouble);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapUShortLongDouble, member_var_map_ushort_longdouble);
        }
        CompleteStructType struct_type_MapUShortLongDouble = TypeObjectUtils::build_complete_struct_type(struct_flags_MapUShortLongDouble, header_MapUShortLongDouble, member_seq_MapUShortLongDouble);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapUShortLongDouble, type_name_MapUShortLongDouble.to_string(), type_ids_MapUShortLongDouble))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapUShortLongDouble already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapUShortBoolean_type_identifier(
        TypeIdentifierPair& type_ids_MapUShortBoolean)
{

    ReturnCode_t return_code_MapUShortBoolean {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapUShortBoolean =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapUShortBoolean", type_ids_MapUShortBoolean);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapUShortBoolean)
    {
        StructTypeFlag struct_flags_MapUShortBoolean = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapUShortBoolean = "MapUShortBoolean";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapUShortBoolean;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapUShortBoolean;
        CompleteTypeDetail detail_MapUShortBoolean = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapUShortBoolean, ann_custom_MapUShortBoolean, type_name_MapUShortBoolean.to_string());
        CompleteStructHeader header_MapUShortBoolean;
        header_MapUShortBoolean = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapUShortBoolean);
        CompleteStructMemberSeq member_seq_MapUShortBoolean;
        {
            TypeIdentifierPair type_ids_var_map_ushort_boolean;
            ReturnCode_t return_code_var_map_ushort_boolean {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ushort_boolean =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint16_t_bool_unbounded", type_ids_var_map_ushort_boolean);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_boolean)
            {
                return_code_var_map_ushort_boolean =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_bool", type_ids_var_map_ushort_boolean);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_boolean)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_uint16_t_bool_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint16_t_bool_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_boolean, element_identifier_anonymous_map_uint16_t_bool_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint16_t_bool_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_bool_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ushort_boolean =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_boolean);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_boolean)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint16_t_bool_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint16_t_bool_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_boolean, key_identifier_anonymous_map_uint16_t_bool_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint16_t_bool_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_bool_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint16_t_bool_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint16_t_bool_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_bool_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint16_t_bool_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_bool_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint16_t_bool_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_bool_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint16_t_bool_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_bool_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint16_t_bool_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_bool_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint16_t_bool_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_bool_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_bool_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint16_t_bool_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_bool_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_bool_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint16_t_bool_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint16_t_bool_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint16_t_bool_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint16_t_bool_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint16_t_bool_unbounded, element_flags_anonymous_map_uint16_t_bool_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint16_t_bool_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint16_t_bool_unbounded), key_flags_anonymous_map_uint16_t_bool_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint16_t_bool_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint16_t_bool_unbounded", type_ids_var_map_ushort_boolean))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint16_t_bool_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ushort_boolean = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ushort_boolean = 0x00000000;
            bool common_var_map_ushort_boolean_ec {false};
            CommonStructMember common_var_map_ushort_boolean {TypeObjectUtils::build_common_struct_member(member_id_var_map_ushort_boolean, member_flags_var_map_ushort_boolean, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_boolean, common_var_map_ushort_boolean_ec))};
            if (!common_var_map_ushort_boolean_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ushort_boolean member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ushort_boolean = "var_map_ushort_boolean";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ushort_boolean;
            ann_custom_MapUShortBoolean.reset();
            CompleteMemberDetail detail_var_map_ushort_boolean = TypeObjectUtils::build_complete_member_detail(name_var_map_ushort_boolean, member_ann_builtin_var_map_ushort_boolean, ann_custom_MapUShortBoolean);
            CompleteStructMember member_var_map_ushort_boolean = TypeObjectUtils::build_complete_struct_member(common_var_map_ushort_boolean, detail_var_map_ushort_boolean);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapUShortBoolean, member_var_map_ushort_boolean);
        }
        CompleteStructType struct_type_MapUShortBoolean = TypeObjectUtils::build_complete_struct_type(struct_flags_MapUShortBoolean, header_MapUShortBoolean, member_seq_MapUShortBoolean);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapUShortBoolean, type_name_MapUShortBoolean.to_string(), type_ids_MapUShortBoolean))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapUShortBoolean already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapUShortOctet_type_identifier(
        TypeIdentifierPair& type_ids_MapUShortOctet)
{

    ReturnCode_t return_code_MapUShortOctet {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapUShortOctet =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapUShortOctet", type_ids_MapUShortOctet);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapUShortOctet)
    {
        StructTypeFlag struct_flags_MapUShortOctet = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapUShortOctet = "MapUShortOctet";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapUShortOctet;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapUShortOctet;
        CompleteTypeDetail detail_MapUShortOctet = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapUShortOctet, ann_custom_MapUShortOctet, type_name_MapUShortOctet.to_string());
        CompleteStructHeader header_MapUShortOctet;
        header_MapUShortOctet = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapUShortOctet);
        CompleteStructMemberSeq member_seq_MapUShortOctet;
        {
            TypeIdentifierPair type_ids_var_map_ushort_octet;
            ReturnCode_t return_code_var_map_ushort_octet {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ushort_octet =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint16_t_byte_unbounded", type_ids_var_map_ushort_octet);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_octet)
            {
                return_code_var_map_ushort_octet =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_byte", type_ids_var_map_ushort_octet);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_octet)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_uint16_t_byte_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint16_t_byte_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_octet, element_identifier_anonymous_map_uint16_t_byte_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint16_t_byte_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_byte_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ushort_octet =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_octet);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_octet)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint16_t_byte_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint16_t_byte_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_octet, key_identifier_anonymous_map_uint16_t_byte_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint16_t_byte_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_byte_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint16_t_byte_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint16_t_byte_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_byte_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint16_t_byte_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_byte_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint16_t_byte_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_byte_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint16_t_byte_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_byte_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint16_t_byte_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_byte_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint16_t_byte_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_byte_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_byte_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint16_t_byte_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_byte_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_byte_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint16_t_byte_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint16_t_byte_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint16_t_byte_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint16_t_byte_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint16_t_byte_unbounded, element_flags_anonymous_map_uint16_t_byte_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint16_t_byte_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint16_t_byte_unbounded), key_flags_anonymous_map_uint16_t_byte_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint16_t_byte_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint16_t_byte_unbounded", type_ids_var_map_ushort_octet))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint16_t_byte_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ushort_octet = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ushort_octet = 0x00000000;
            bool common_var_map_ushort_octet_ec {false};
            CommonStructMember common_var_map_ushort_octet {TypeObjectUtils::build_common_struct_member(member_id_var_map_ushort_octet, member_flags_var_map_ushort_octet, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_octet, common_var_map_ushort_octet_ec))};
            if (!common_var_map_ushort_octet_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ushort_octet member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ushort_octet = "var_map_ushort_octet";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ushort_octet;
            ann_custom_MapUShortOctet.reset();
            CompleteMemberDetail detail_var_map_ushort_octet = TypeObjectUtils::build_complete_member_detail(name_var_map_ushort_octet, member_ann_builtin_var_map_ushort_octet, ann_custom_MapUShortOctet);
            CompleteStructMember member_var_map_ushort_octet = TypeObjectUtils::build_complete_struct_member(common_var_map_ushort_octet, detail_var_map_ushort_octet);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapUShortOctet, member_var_map_ushort_octet);
        }
        CompleteStructType struct_type_MapUShortOctet = TypeObjectUtils::build_complete_struct_type(struct_flags_MapUShortOctet, header_MapUShortOctet, member_seq_MapUShortOctet);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapUShortOctet, type_name_MapUShortOctet.to_string(), type_ids_MapUShortOctet))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapUShortOctet already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapUShortChar_type_identifier(
        TypeIdentifierPair& type_ids_MapUShortChar)
{

    ReturnCode_t return_code_MapUShortChar {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapUShortChar =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapUShortChar", type_ids_MapUShortChar);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapUShortChar)
    {
        StructTypeFlag struct_flags_MapUShortChar = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapUShortChar = "MapUShortChar";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapUShortChar;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapUShortChar;
        CompleteTypeDetail detail_MapUShortChar = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapUShortChar, ann_custom_MapUShortChar, type_name_MapUShortChar.to_string());
        CompleteStructHeader header_MapUShortChar;
        header_MapUShortChar = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapUShortChar);
        CompleteStructMemberSeq member_seq_MapUShortChar;
        {
            TypeIdentifierPair type_ids_var_map_ushort_char;
            ReturnCode_t return_code_var_map_ushort_char {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ushort_char =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint16_t_char_unbounded", type_ids_var_map_ushort_char);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_char)
            {
                return_code_var_map_ushort_char =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_char", type_ids_var_map_ushort_char);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_char)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_uint16_t_char_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint16_t_char_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_char, element_identifier_anonymous_map_uint16_t_char_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint16_t_char_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_char_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ushort_char =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_char);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_char)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint16_t_char_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint16_t_char_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_char, key_identifier_anonymous_map_uint16_t_char_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint16_t_char_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_char_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint16_t_char_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint16_t_char_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_char_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint16_t_char_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_char_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint16_t_char_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_char_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint16_t_char_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_char_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint16_t_char_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_char_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint16_t_char_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_char_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_char_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint16_t_char_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_char_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_char_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint16_t_char_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint16_t_char_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint16_t_char_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint16_t_char_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint16_t_char_unbounded, element_flags_anonymous_map_uint16_t_char_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint16_t_char_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint16_t_char_unbounded), key_flags_anonymous_map_uint16_t_char_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint16_t_char_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint16_t_char_unbounded", type_ids_var_map_ushort_char))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint16_t_char_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ushort_char = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ushort_char = 0x00000000;
            bool common_var_map_ushort_char_ec {false};
            CommonStructMember common_var_map_ushort_char {TypeObjectUtils::build_common_struct_member(member_id_var_map_ushort_char, member_flags_var_map_ushort_char, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_char, common_var_map_ushort_char_ec))};
            if (!common_var_map_ushort_char_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ushort_char member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ushort_char = "var_map_ushort_char";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ushort_char;
            ann_custom_MapUShortChar.reset();
            CompleteMemberDetail detail_var_map_ushort_char = TypeObjectUtils::build_complete_member_detail(name_var_map_ushort_char, member_ann_builtin_var_map_ushort_char, ann_custom_MapUShortChar);
            CompleteStructMember member_var_map_ushort_char = TypeObjectUtils::build_complete_struct_member(common_var_map_ushort_char, detail_var_map_ushort_char);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapUShortChar, member_var_map_ushort_char);
        }
        CompleteStructType struct_type_MapUShortChar = TypeObjectUtils::build_complete_struct_type(struct_flags_MapUShortChar, header_MapUShortChar, member_seq_MapUShortChar);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapUShortChar, type_name_MapUShortChar.to_string(), type_ids_MapUShortChar))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapUShortChar already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapUShortWChar_type_identifier(
        TypeIdentifierPair& type_ids_MapUShortWChar)
{

    ReturnCode_t return_code_MapUShortWChar {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapUShortWChar =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapUShortWChar", type_ids_MapUShortWChar);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapUShortWChar)
    {
        StructTypeFlag struct_flags_MapUShortWChar = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapUShortWChar = "MapUShortWChar";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapUShortWChar;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapUShortWChar;
        CompleteTypeDetail detail_MapUShortWChar = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapUShortWChar, ann_custom_MapUShortWChar, type_name_MapUShortWChar.to_string());
        CompleteStructHeader header_MapUShortWChar;
        header_MapUShortWChar = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapUShortWChar);
        CompleteStructMemberSeq member_seq_MapUShortWChar;
        {
            TypeIdentifierPair type_ids_var_map_ushort_wchar;
            ReturnCode_t return_code_var_map_ushort_wchar {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ushort_wchar =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint16_t_wchar_t_unbounded", type_ids_var_map_ushort_wchar);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_wchar)
            {
                return_code_var_map_ushort_wchar =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_wchar_t", type_ids_var_map_ushort_wchar);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_wchar)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_uint16_t_wchar_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint16_t_wchar_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_wchar, element_identifier_anonymous_map_uint16_t_wchar_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint16_t_wchar_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_wchar_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ushort_wchar =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_wchar);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_wchar)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint16_t_wchar_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint16_t_wchar_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_wchar, key_identifier_anonymous_map_uint16_t_wchar_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint16_t_wchar_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_wchar_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint16_t_wchar_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint16_t_wchar_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_wchar_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint16_t_wchar_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_wchar_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint16_t_wchar_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_wchar_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint16_t_wchar_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_wchar_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint16_t_wchar_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_wchar_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint16_t_wchar_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_wchar_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_wchar_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint16_t_wchar_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_wchar_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_wchar_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint16_t_wchar_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint16_t_wchar_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint16_t_wchar_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint16_t_wchar_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint16_t_wchar_t_unbounded, element_flags_anonymous_map_uint16_t_wchar_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint16_t_wchar_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint16_t_wchar_t_unbounded), key_flags_anonymous_map_uint16_t_wchar_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint16_t_wchar_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint16_t_wchar_t_unbounded", type_ids_var_map_ushort_wchar))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint16_t_wchar_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ushort_wchar = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ushort_wchar = 0x00000000;
            bool common_var_map_ushort_wchar_ec {false};
            CommonStructMember common_var_map_ushort_wchar {TypeObjectUtils::build_common_struct_member(member_id_var_map_ushort_wchar, member_flags_var_map_ushort_wchar, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_wchar, common_var_map_ushort_wchar_ec))};
            if (!common_var_map_ushort_wchar_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ushort_wchar member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ushort_wchar = "var_map_ushort_wchar";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ushort_wchar;
            ann_custom_MapUShortWChar.reset();
            CompleteMemberDetail detail_var_map_ushort_wchar = TypeObjectUtils::build_complete_member_detail(name_var_map_ushort_wchar, member_ann_builtin_var_map_ushort_wchar, ann_custom_MapUShortWChar);
            CompleteStructMember member_var_map_ushort_wchar = TypeObjectUtils::build_complete_struct_member(common_var_map_ushort_wchar, detail_var_map_ushort_wchar);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapUShortWChar, member_var_map_ushort_wchar);
        }
        CompleteStructType struct_type_MapUShortWChar = TypeObjectUtils::build_complete_struct_type(struct_flags_MapUShortWChar, header_MapUShortWChar, member_seq_MapUShortWChar);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapUShortWChar, type_name_MapUShortWChar.to_string(), type_ids_MapUShortWChar))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapUShortWChar already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapUShortString_type_identifier(
        TypeIdentifierPair& type_ids_MapUShortString)
{

    ReturnCode_t return_code_MapUShortString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapUShortString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapUShortString", type_ids_MapUShortString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapUShortString)
    {
        StructTypeFlag struct_flags_MapUShortString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapUShortString = "MapUShortString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapUShortString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapUShortString;
        CompleteTypeDetail detail_MapUShortString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapUShortString, ann_custom_MapUShortString, type_name_MapUShortString.to_string());
        CompleteStructHeader header_MapUShortString;
        header_MapUShortString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapUShortString);
        CompleteStructMemberSeq member_seq_MapUShortString;
        {
            TypeIdentifierPair type_ids_var_map_ushort_string;
            ReturnCode_t return_code_var_map_ushort_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ushort_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint16_t_anonymous_string_unbounded_unbounded", type_ids_var_map_ushort_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_string)
            {
                return_code_var_map_ushort_string =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_string_unbounded", type_ids_var_map_ushort_string);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_string)
                {
                    {
                        SBound bound = 0;
                        StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                                "anonymous_string_unbounded", type_ids_var_map_ushort_string))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_string, element_identifier_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_anonymous_string_unbounded_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ushort_string =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_string);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_string)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_string, key_identifier_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_anonymous_string_unbounded_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded, element_flags_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded), key_flags_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint16_t_anonymous_string_unbounded_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint16_t_anonymous_string_unbounded_unbounded", type_ids_var_map_ushort_string))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint16_t_anonymous_string_unbounded_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ushort_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ushort_string = 0x00000000;
            bool common_var_map_ushort_string_ec {false};
            CommonStructMember common_var_map_ushort_string {TypeObjectUtils::build_common_struct_member(member_id_var_map_ushort_string, member_flags_var_map_ushort_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_string, common_var_map_ushort_string_ec))};
            if (!common_var_map_ushort_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ushort_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ushort_string = "var_map_ushort_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ushort_string;
            ann_custom_MapUShortString.reset();
            CompleteMemberDetail detail_var_map_ushort_string = TypeObjectUtils::build_complete_member_detail(name_var_map_ushort_string, member_ann_builtin_var_map_ushort_string, ann_custom_MapUShortString);
            CompleteStructMember member_var_map_ushort_string = TypeObjectUtils::build_complete_struct_member(common_var_map_ushort_string, detail_var_map_ushort_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapUShortString, member_var_map_ushort_string);
        }
        CompleteStructType struct_type_MapUShortString = TypeObjectUtils::build_complete_struct_type(struct_flags_MapUShortString, header_MapUShortString, member_seq_MapUShortString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapUShortString, type_name_MapUShortString.to_string(), type_ids_MapUShortString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapUShortString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapUShortWString_type_identifier(
        TypeIdentifierPair& type_ids_MapUShortWString)
{

    ReturnCode_t return_code_MapUShortWString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapUShortWString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapUShortWString", type_ids_MapUShortWString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapUShortWString)
    {
        StructTypeFlag struct_flags_MapUShortWString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapUShortWString = "MapUShortWString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapUShortWString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapUShortWString;
        CompleteTypeDetail detail_MapUShortWString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapUShortWString, ann_custom_MapUShortWString, type_name_MapUShortWString.to_string());
        CompleteStructHeader header_MapUShortWString;
        header_MapUShortWString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapUShortWString);
        CompleteStructMemberSeq member_seq_MapUShortWString;
        {
            TypeIdentifierPair type_ids_var_map_ushort_wstring;
            ReturnCode_t return_code_var_map_ushort_wstring {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ushort_wstring =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded", type_ids_var_map_ushort_wstring);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_wstring)
            {
                return_code_var_map_ushort_wstring =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_wstring_unbounded", type_ids_var_map_ushort_wstring);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_wstring)
                {
                    {
                        SBound bound = 0;
                        StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                                "anonymous_wstring_unbounded", type_ids_var_map_ushort_wstring, true))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_wstring_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_wstring, element_identifier_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ushort_wstring =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_wstring);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_wstring)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_wstring, key_identifier_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded, element_flags_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded), key_flags_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded", type_ids_var_map_ushort_wstring))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint16_t_anonymous_wstring_unbounded_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ushort_wstring = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ushort_wstring = 0x00000000;
            bool common_var_map_ushort_wstring_ec {false};
            CommonStructMember common_var_map_ushort_wstring {TypeObjectUtils::build_common_struct_member(member_id_var_map_ushort_wstring, member_flags_var_map_ushort_wstring, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_wstring, common_var_map_ushort_wstring_ec))};
            if (!common_var_map_ushort_wstring_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ushort_wstring member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ushort_wstring = "var_map_ushort_wstring";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ushort_wstring;
            ann_custom_MapUShortWString.reset();
            CompleteMemberDetail detail_var_map_ushort_wstring = TypeObjectUtils::build_complete_member_detail(name_var_map_ushort_wstring, member_ann_builtin_var_map_ushort_wstring, ann_custom_MapUShortWString);
            CompleteStructMember member_var_map_ushort_wstring = TypeObjectUtils::build_complete_struct_member(common_var_map_ushort_wstring, detail_var_map_ushort_wstring);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapUShortWString, member_var_map_ushort_wstring);
        }
        CompleteStructType struct_type_MapUShortWString = TypeObjectUtils::build_complete_struct_type(struct_flags_MapUShortWString, header_MapUShortWString, member_seq_MapUShortWString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapUShortWString, type_name_MapUShortWString.to_string(), type_ids_MapUShortWString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapUShortWString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapUShortInnerAliasBoundedStringHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapUShortInnerAliasBoundedStringHelper)
{

    ReturnCode_t return_code_MapUShortInnerAliasBoundedStringHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapUShortInnerAliasBoundedStringHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapUShortInnerAliasBoundedStringHelper", type_ids_MapUShortInnerAliasBoundedStringHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapUShortInnerAliasBoundedStringHelper)
    {
        StructTypeFlag struct_flags_MapUShortInnerAliasBoundedStringHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapUShortInnerAliasBoundedStringHelper = "MapUShortInnerAliasBoundedStringHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapUShortInnerAliasBoundedStringHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapUShortInnerAliasBoundedStringHelper;
        CompleteTypeDetail detail_MapUShortInnerAliasBoundedStringHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapUShortInnerAliasBoundedStringHelper, ann_custom_MapUShortInnerAliasBoundedStringHelper, type_name_MapUShortInnerAliasBoundedStringHelper.to_string());
        CompleteStructHeader header_MapUShortInnerAliasBoundedStringHelper;
        header_MapUShortInnerAliasBoundedStringHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapUShortInnerAliasBoundedStringHelper);
        CompleteStructMemberSeq member_seq_MapUShortInnerAliasBoundedStringHelper;
        {
            TypeIdentifierPair type_ids_var_map_ushort_inneraliasboundedstringhelper;
            ReturnCode_t return_code_var_map_ushort_inneraliasboundedstringhelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ushort_inneraliasboundedstringhelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint16_t_anonymous_string_10_unbounded", type_ids_var_map_ushort_inneraliasboundedstringhelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_inneraliasboundedstringhelper)
            {
                return_code_var_map_ushort_inneraliasboundedstringhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_bounded_string_helper", type_ids_var_map_ushort_inneraliasboundedstringhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_inneraliasboundedstringhelper)
                {
                ::register_Inner_alias_bounded_string_helper_type_identifier(type_ids_var_map_ushort_inneraliasboundedstringhelper);
                }
                bool element_identifier_anonymous_map_uint16_t_anonymous_string_10_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint16_t_anonymous_string_10_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_inneraliasboundedstringhelper, element_identifier_anonymous_map_uint16_t_anonymous_string_10_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint16_t_anonymous_string_10_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_anonymous_string_10_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ushort_inneraliasboundedstringhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_inneraliasboundedstringhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_inneraliasboundedstringhelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint16_t_anonymous_string_10_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint16_t_anonymous_string_10_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_inneraliasboundedstringhelper, key_identifier_anonymous_map_uint16_t_anonymous_string_10_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint16_t_anonymous_string_10_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_anonymous_string_10_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint16_t_anonymous_string_10_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint16_t_anonymous_string_10_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_string_10_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint16_t_anonymous_string_10_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_string_10_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint16_t_anonymous_string_10_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_string_10_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint16_t_anonymous_string_10_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_string_10_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint16_t_anonymous_string_10_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_string_10_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint16_t_anonymous_string_10_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_string_10_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_string_10_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint16_t_anonymous_string_10_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_string_10_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_string_10_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint16_t_anonymous_string_10_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint16_t_anonymous_string_10_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint16_t_anonymous_string_10_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint16_t_anonymous_string_10_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint16_t_anonymous_string_10_unbounded, element_flags_anonymous_map_uint16_t_anonymous_string_10_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint16_t_anonymous_string_10_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint16_t_anonymous_string_10_unbounded), key_flags_anonymous_map_uint16_t_anonymous_string_10_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint16_t_anonymous_string_10_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint16_t_anonymous_string_10_unbounded", type_ids_var_map_ushort_inneraliasboundedstringhelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint16_t_anonymous_string_10_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ushort_inneraliasboundedstringhelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ushort_inneraliasboundedstringhelper = 0x00000000;
            bool common_var_map_ushort_inneraliasboundedstringhelper_ec {false};
            CommonStructMember common_var_map_ushort_inneraliasboundedstringhelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_ushort_inneraliasboundedstringhelper, member_flags_var_map_ushort_inneraliasboundedstringhelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_inneraliasboundedstringhelper, common_var_map_ushort_inneraliasboundedstringhelper_ec))};
            if (!common_var_map_ushort_inneraliasboundedstringhelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ushort_inneraliasboundedstringhelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ushort_inneraliasboundedstringhelper = "var_map_ushort_inneraliasboundedstringhelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ushort_inneraliasboundedstringhelper;
            ann_custom_MapUShortInnerAliasBoundedStringHelper.reset();
            CompleteMemberDetail detail_var_map_ushort_inneraliasboundedstringhelper = TypeObjectUtils::build_complete_member_detail(name_var_map_ushort_inneraliasboundedstringhelper, member_ann_builtin_var_map_ushort_inneraliasboundedstringhelper, ann_custom_MapUShortInnerAliasBoundedStringHelper);
            CompleteStructMember member_var_map_ushort_inneraliasboundedstringhelper = TypeObjectUtils::build_complete_struct_member(common_var_map_ushort_inneraliasboundedstringhelper, detail_var_map_ushort_inneraliasboundedstringhelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapUShortInnerAliasBoundedStringHelper, member_var_map_ushort_inneraliasboundedstringhelper);
        }
        CompleteStructType struct_type_MapUShortInnerAliasBoundedStringHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapUShortInnerAliasBoundedStringHelper, header_MapUShortInnerAliasBoundedStringHelper, member_seq_MapUShortInnerAliasBoundedStringHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapUShortInnerAliasBoundedStringHelper, type_name_MapUShortInnerAliasBoundedStringHelper.to_string(), type_ids_MapUShortInnerAliasBoundedStringHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapUShortInnerAliasBoundedStringHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapUShortInnerAliasBoundedWStringHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapUShortInnerAliasBoundedWStringHelper)
{

    ReturnCode_t return_code_MapUShortInnerAliasBoundedWStringHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapUShortInnerAliasBoundedWStringHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapUShortInnerAliasBoundedWStringHelper", type_ids_MapUShortInnerAliasBoundedWStringHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapUShortInnerAliasBoundedWStringHelper)
    {
        StructTypeFlag struct_flags_MapUShortInnerAliasBoundedWStringHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapUShortInnerAliasBoundedWStringHelper = "MapUShortInnerAliasBoundedWStringHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapUShortInnerAliasBoundedWStringHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapUShortInnerAliasBoundedWStringHelper;
        CompleteTypeDetail detail_MapUShortInnerAliasBoundedWStringHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapUShortInnerAliasBoundedWStringHelper, ann_custom_MapUShortInnerAliasBoundedWStringHelper, type_name_MapUShortInnerAliasBoundedWStringHelper.to_string());
        CompleteStructHeader header_MapUShortInnerAliasBoundedWStringHelper;
        header_MapUShortInnerAliasBoundedWStringHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapUShortInnerAliasBoundedWStringHelper);
        CompleteStructMemberSeq member_seq_MapUShortInnerAliasBoundedWStringHelper;
        {
            TypeIdentifierPair type_ids_var_map_ushort_inneraliasboundedwstringhelper;
            ReturnCode_t return_code_var_map_ushort_inneraliasboundedwstringhelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ushort_inneraliasboundedwstringhelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint16_t_anonymous_wstring_10_unbounded", type_ids_var_map_ushort_inneraliasboundedwstringhelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_inneraliasboundedwstringhelper)
            {
                return_code_var_map_ushort_inneraliasboundedwstringhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_bounded_wstring_helper", type_ids_var_map_ushort_inneraliasboundedwstringhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_inneraliasboundedwstringhelper)
                {
                ::register_Inner_alias_bounded_wstring_helper_type_identifier(type_ids_var_map_ushort_inneraliasboundedwstringhelper);
                }
                bool element_identifier_anonymous_map_uint16_t_anonymous_wstring_10_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint16_t_anonymous_wstring_10_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_inneraliasboundedwstringhelper, element_identifier_anonymous_map_uint16_t_anonymous_wstring_10_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint16_t_anonymous_wstring_10_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_anonymous_wstring_10_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ushort_inneraliasboundedwstringhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_inneraliasboundedwstringhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_inneraliasboundedwstringhelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint16_t_anonymous_wstring_10_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint16_t_anonymous_wstring_10_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_inneraliasboundedwstringhelper, key_identifier_anonymous_map_uint16_t_anonymous_wstring_10_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint16_t_anonymous_wstring_10_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_anonymous_wstring_10_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint16_t_anonymous_wstring_10_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint16_t_anonymous_wstring_10_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_wstring_10_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint16_t_anonymous_wstring_10_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_wstring_10_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint16_t_anonymous_wstring_10_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_wstring_10_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint16_t_anonymous_wstring_10_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_wstring_10_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint16_t_anonymous_wstring_10_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_wstring_10_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint16_t_anonymous_wstring_10_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_wstring_10_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_wstring_10_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint16_t_anonymous_wstring_10_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_wstring_10_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_wstring_10_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint16_t_anonymous_wstring_10_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint16_t_anonymous_wstring_10_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint16_t_anonymous_wstring_10_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint16_t_anonymous_wstring_10_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint16_t_anonymous_wstring_10_unbounded, element_flags_anonymous_map_uint16_t_anonymous_wstring_10_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint16_t_anonymous_wstring_10_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint16_t_anonymous_wstring_10_unbounded), key_flags_anonymous_map_uint16_t_anonymous_wstring_10_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint16_t_anonymous_wstring_10_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint16_t_anonymous_wstring_10_unbounded", type_ids_var_map_ushort_inneraliasboundedwstringhelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint16_t_anonymous_wstring_10_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ushort_inneraliasboundedwstringhelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ushort_inneraliasboundedwstringhelper = 0x00000000;
            bool common_var_map_ushort_inneraliasboundedwstringhelper_ec {false};
            CommonStructMember common_var_map_ushort_inneraliasboundedwstringhelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_ushort_inneraliasboundedwstringhelper, member_flags_var_map_ushort_inneraliasboundedwstringhelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_inneraliasboundedwstringhelper, common_var_map_ushort_inneraliasboundedwstringhelper_ec))};
            if (!common_var_map_ushort_inneraliasboundedwstringhelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ushort_inneraliasboundedwstringhelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ushort_inneraliasboundedwstringhelper = "var_map_ushort_inneraliasboundedwstringhelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ushort_inneraliasboundedwstringhelper;
            ann_custom_MapUShortInnerAliasBoundedWStringHelper.reset();
            CompleteMemberDetail detail_var_map_ushort_inneraliasboundedwstringhelper = TypeObjectUtils::build_complete_member_detail(name_var_map_ushort_inneraliasboundedwstringhelper, member_ann_builtin_var_map_ushort_inneraliasboundedwstringhelper, ann_custom_MapUShortInnerAliasBoundedWStringHelper);
            CompleteStructMember member_var_map_ushort_inneraliasboundedwstringhelper = TypeObjectUtils::build_complete_struct_member(common_var_map_ushort_inneraliasboundedwstringhelper, detail_var_map_ushort_inneraliasboundedwstringhelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapUShortInnerAliasBoundedWStringHelper, member_var_map_ushort_inneraliasboundedwstringhelper);
        }
        CompleteStructType struct_type_MapUShortInnerAliasBoundedWStringHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapUShortInnerAliasBoundedWStringHelper, header_MapUShortInnerAliasBoundedWStringHelper, member_seq_MapUShortInnerAliasBoundedWStringHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapUShortInnerAliasBoundedWStringHelper, type_name_MapUShortInnerAliasBoundedWStringHelper.to_string(), type_ids_MapUShortInnerAliasBoundedWStringHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapUShortInnerAliasBoundedWStringHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapUShortInnerEnumHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapUShortInnerEnumHelper)
{

    ReturnCode_t return_code_MapUShortInnerEnumHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapUShortInnerEnumHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapUShortInnerEnumHelper", type_ids_MapUShortInnerEnumHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapUShortInnerEnumHelper)
    {
        StructTypeFlag struct_flags_MapUShortInnerEnumHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapUShortInnerEnumHelper = "MapUShortInnerEnumHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapUShortInnerEnumHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapUShortInnerEnumHelper;
        CompleteTypeDetail detail_MapUShortInnerEnumHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapUShortInnerEnumHelper, ann_custom_MapUShortInnerEnumHelper, type_name_MapUShortInnerEnumHelper.to_string());
        CompleteStructHeader header_MapUShortInnerEnumHelper;
        header_MapUShortInnerEnumHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapUShortInnerEnumHelper);
        CompleteStructMemberSeq member_seq_MapUShortInnerEnumHelper;
        {
            TypeIdentifierPair type_ids_var_map_ushort_innerenumhelper;
            ReturnCode_t return_code_var_map_ushort_innerenumhelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ushort_innerenumhelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint16_t_InnerEnumHelper_unbounded", type_ids_var_map_ushort_innerenumhelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_innerenumhelper)
            {
                return_code_var_map_ushort_innerenumhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerEnumHelper", type_ids_var_map_ushort_innerenumhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_innerenumhelper)
                {
                ::register_InnerEnumHelper_type_identifier(type_ids_var_map_ushort_innerenumhelper);
                }
                bool element_identifier_anonymous_map_uint16_t_InnerEnumHelper_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint16_t_InnerEnumHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_innerenumhelper, element_identifier_anonymous_map_uint16_t_InnerEnumHelper_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint16_t_InnerEnumHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_InnerEnumHelper_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ushort_innerenumhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_innerenumhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_innerenumhelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint16_t_InnerEnumHelper_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint16_t_InnerEnumHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_innerenumhelper, key_identifier_anonymous_map_uint16_t_InnerEnumHelper_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint16_t_InnerEnumHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_InnerEnumHelper_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint16_t_InnerEnumHelper_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint16_t_InnerEnumHelper_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerEnumHelper_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint16_t_InnerEnumHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerEnumHelper_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint16_t_InnerEnumHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerEnumHelper_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint16_t_InnerEnumHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerEnumHelper_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint16_t_InnerEnumHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerEnumHelper_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint16_t_InnerEnumHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerEnumHelper_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerEnumHelper_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint16_t_InnerEnumHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerEnumHelper_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerEnumHelper_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint16_t_InnerEnumHelper_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint16_t_InnerEnumHelper_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint16_t_InnerEnumHelper_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint16_t_InnerEnumHelper_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint16_t_InnerEnumHelper_unbounded, element_flags_anonymous_map_uint16_t_InnerEnumHelper_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint16_t_InnerEnumHelper_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint16_t_InnerEnumHelper_unbounded), key_flags_anonymous_map_uint16_t_InnerEnumHelper_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint16_t_InnerEnumHelper_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint16_t_InnerEnumHelper_unbounded", type_ids_var_map_ushort_innerenumhelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint16_t_InnerEnumHelper_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ushort_innerenumhelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ushort_innerenumhelper = 0x00000000;
            bool common_var_map_ushort_innerenumhelper_ec {false};
            CommonStructMember common_var_map_ushort_innerenumhelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_ushort_innerenumhelper, member_flags_var_map_ushort_innerenumhelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_innerenumhelper, common_var_map_ushort_innerenumhelper_ec))};
            if (!common_var_map_ushort_innerenumhelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ushort_innerenumhelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ushort_innerenumhelper = "var_map_ushort_innerenumhelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ushort_innerenumhelper;
            ann_custom_MapUShortInnerEnumHelper.reset();
            CompleteMemberDetail detail_var_map_ushort_innerenumhelper = TypeObjectUtils::build_complete_member_detail(name_var_map_ushort_innerenumhelper, member_ann_builtin_var_map_ushort_innerenumhelper, ann_custom_MapUShortInnerEnumHelper);
            CompleteStructMember member_var_map_ushort_innerenumhelper = TypeObjectUtils::build_complete_struct_member(common_var_map_ushort_innerenumhelper, detail_var_map_ushort_innerenumhelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapUShortInnerEnumHelper, member_var_map_ushort_innerenumhelper);
        }
        CompleteStructType struct_type_MapUShortInnerEnumHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapUShortInnerEnumHelper, header_MapUShortInnerEnumHelper, member_seq_MapUShortInnerEnumHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapUShortInnerEnumHelper, type_name_MapUShortInnerEnumHelper.to_string(), type_ids_MapUShortInnerEnumHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapUShortInnerEnumHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapUShortInnerBitMaskHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapUShortInnerBitMaskHelper)
{

    ReturnCode_t return_code_MapUShortInnerBitMaskHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapUShortInnerBitMaskHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapUShortInnerBitMaskHelper", type_ids_MapUShortInnerBitMaskHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapUShortInnerBitMaskHelper)
    {
        StructTypeFlag struct_flags_MapUShortInnerBitMaskHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapUShortInnerBitMaskHelper = "MapUShortInnerBitMaskHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapUShortInnerBitMaskHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapUShortInnerBitMaskHelper;
        CompleteTypeDetail detail_MapUShortInnerBitMaskHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapUShortInnerBitMaskHelper, ann_custom_MapUShortInnerBitMaskHelper, type_name_MapUShortInnerBitMaskHelper.to_string());
        CompleteStructHeader header_MapUShortInnerBitMaskHelper;
        header_MapUShortInnerBitMaskHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapUShortInnerBitMaskHelper);
        CompleteStructMemberSeq member_seq_MapUShortInnerBitMaskHelper;
        {
            TypeIdentifierPair type_ids_var_map_ushort_innerbitmaskhelper;
            ReturnCode_t return_code_var_map_ushort_innerbitmaskhelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ushort_innerbitmaskhelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint16_t_InnerBitMaskHelper_unbounded", type_ids_var_map_ushort_innerbitmaskhelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_innerbitmaskhelper)
            {
                return_code_var_map_ushort_innerbitmaskhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerBitMaskHelper", type_ids_var_map_ushort_innerbitmaskhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_innerbitmaskhelper)
                {
                ::register_InnerBitMaskHelper_type_identifier(type_ids_var_map_ushort_innerbitmaskhelper);
                }
                bool element_identifier_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_innerbitmaskhelper, element_identifier_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_InnerBitMaskHelper_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ushort_innerbitmaskhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_innerbitmaskhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_innerbitmaskhelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_innerbitmaskhelper, key_identifier_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_InnerBitMaskHelper_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded, element_flags_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded), key_flags_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint16_t_InnerBitMaskHelper_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint16_t_InnerBitMaskHelper_unbounded", type_ids_var_map_ushort_innerbitmaskhelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint16_t_InnerBitMaskHelper_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ushort_innerbitmaskhelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ushort_innerbitmaskhelper = 0x00000000;
            bool common_var_map_ushort_innerbitmaskhelper_ec {false};
            CommonStructMember common_var_map_ushort_innerbitmaskhelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_ushort_innerbitmaskhelper, member_flags_var_map_ushort_innerbitmaskhelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_innerbitmaskhelper, common_var_map_ushort_innerbitmaskhelper_ec))};
            if (!common_var_map_ushort_innerbitmaskhelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ushort_innerbitmaskhelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ushort_innerbitmaskhelper = "var_map_ushort_innerbitmaskhelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ushort_innerbitmaskhelper;
            ann_custom_MapUShortInnerBitMaskHelper.reset();
            CompleteMemberDetail detail_var_map_ushort_innerbitmaskhelper = TypeObjectUtils::build_complete_member_detail(name_var_map_ushort_innerbitmaskhelper, member_ann_builtin_var_map_ushort_innerbitmaskhelper, ann_custom_MapUShortInnerBitMaskHelper);
            CompleteStructMember member_var_map_ushort_innerbitmaskhelper = TypeObjectUtils::build_complete_struct_member(common_var_map_ushort_innerbitmaskhelper, detail_var_map_ushort_innerbitmaskhelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapUShortInnerBitMaskHelper, member_var_map_ushort_innerbitmaskhelper);
        }
        CompleteStructType struct_type_MapUShortInnerBitMaskHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapUShortInnerBitMaskHelper, header_MapUShortInnerBitMaskHelper, member_seq_MapUShortInnerBitMaskHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapUShortInnerBitMaskHelper, type_name_MapUShortInnerBitMaskHelper.to_string(), type_ids_MapUShortInnerBitMaskHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapUShortInnerBitMaskHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapUShortInnerAliasHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapUShortInnerAliasHelper)
{

    ReturnCode_t return_code_MapUShortInnerAliasHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapUShortInnerAliasHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapUShortInnerAliasHelper", type_ids_MapUShortInnerAliasHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapUShortInnerAliasHelper)
    {
        StructTypeFlag struct_flags_MapUShortInnerAliasHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapUShortInnerAliasHelper = "MapUShortInnerAliasHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapUShortInnerAliasHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapUShortInnerAliasHelper;
        CompleteTypeDetail detail_MapUShortInnerAliasHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapUShortInnerAliasHelper, ann_custom_MapUShortInnerAliasHelper, type_name_MapUShortInnerAliasHelper.to_string());
        CompleteStructHeader header_MapUShortInnerAliasHelper;
        header_MapUShortInnerAliasHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapUShortInnerAliasHelper);
        CompleteStructMemberSeq member_seq_MapUShortInnerAliasHelper;
        {
            TypeIdentifierPair type_ids_var_map_ushort_inneraliashelper;
            ReturnCode_t return_code_var_map_ushort_inneraliashelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ushort_inneraliashelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint16_t_InnerAliasHelper_unbounded", type_ids_var_map_ushort_inneraliashelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_inneraliashelper)
            {
                return_code_var_map_ushort_inneraliashelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerAliasHelper", type_ids_var_map_ushort_inneraliashelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_inneraliashelper)
                {
                ::register_InnerAliasHelper_type_identifier(type_ids_var_map_ushort_inneraliashelper);
                }
                bool element_identifier_anonymous_map_uint16_t_InnerAliasHelper_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint16_t_InnerAliasHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_inneraliashelper, element_identifier_anonymous_map_uint16_t_InnerAliasHelper_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint16_t_InnerAliasHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_InnerAliasHelper_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ushort_inneraliashelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_inneraliashelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_inneraliashelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint16_t_InnerAliasHelper_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint16_t_InnerAliasHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_inneraliashelper, key_identifier_anonymous_map_uint16_t_InnerAliasHelper_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint16_t_InnerAliasHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_InnerAliasHelper_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint16_t_InnerAliasHelper_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint16_t_InnerAliasHelper_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerAliasHelper_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint16_t_InnerAliasHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerAliasHelper_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint16_t_InnerAliasHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerAliasHelper_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint16_t_InnerAliasHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerAliasHelper_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint16_t_InnerAliasHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerAliasHelper_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint16_t_InnerAliasHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerAliasHelper_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerAliasHelper_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint16_t_InnerAliasHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerAliasHelper_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerAliasHelper_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint16_t_InnerAliasHelper_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint16_t_InnerAliasHelper_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint16_t_InnerAliasHelper_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint16_t_InnerAliasHelper_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint16_t_InnerAliasHelper_unbounded, element_flags_anonymous_map_uint16_t_InnerAliasHelper_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint16_t_InnerAliasHelper_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint16_t_InnerAliasHelper_unbounded), key_flags_anonymous_map_uint16_t_InnerAliasHelper_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint16_t_InnerAliasHelper_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint16_t_InnerAliasHelper_unbounded", type_ids_var_map_ushort_inneraliashelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint16_t_InnerAliasHelper_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ushort_inneraliashelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ushort_inneraliashelper = 0x00000000;
            bool common_var_map_ushort_inneraliashelper_ec {false};
            CommonStructMember common_var_map_ushort_inneraliashelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_ushort_inneraliashelper, member_flags_var_map_ushort_inneraliashelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_inneraliashelper, common_var_map_ushort_inneraliashelper_ec))};
            if (!common_var_map_ushort_inneraliashelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ushort_inneraliashelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ushort_inneraliashelper = "var_map_ushort_inneraliashelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ushort_inneraliashelper;
            ann_custom_MapUShortInnerAliasHelper.reset();
            CompleteMemberDetail detail_var_map_ushort_inneraliashelper = TypeObjectUtils::build_complete_member_detail(name_var_map_ushort_inneraliashelper, member_ann_builtin_var_map_ushort_inneraliashelper, ann_custom_MapUShortInnerAliasHelper);
            CompleteStructMember member_var_map_ushort_inneraliashelper = TypeObjectUtils::build_complete_struct_member(common_var_map_ushort_inneraliashelper, detail_var_map_ushort_inneraliashelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapUShortInnerAliasHelper, member_var_map_ushort_inneraliashelper);
        }
        CompleteStructType struct_type_MapUShortInnerAliasHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapUShortInnerAliasHelper, header_MapUShortInnerAliasHelper, member_seq_MapUShortInnerAliasHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapUShortInnerAliasHelper, type_name_MapUShortInnerAliasHelper.to_string(), type_ids_MapUShortInnerAliasHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapUShortInnerAliasHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapUShortInnerAliasArrayHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapUShortInnerAliasArrayHelper)
{

    ReturnCode_t return_code_MapUShortInnerAliasArrayHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapUShortInnerAliasArrayHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapUShortInnerAliasArrayHelper", type_ids_MapUShortInnerAliasArrayHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapUShortInnerAliasArrayHelper)
    {
        StructTypeFlag struct_flags_MapUShortInnerAliasArrayHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapUShortInnerAliasArrayHelper = "MapUShortInnerAliasArrayHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapUShortInnerAliasArrayHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapUShortInnerAliasArrayHelper;
        CompleteTypeDetail detail_MapUShortInnerAliasArrayHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapUShortInnerAliasArrayHelper, ann_custom_MapUShortInnerAliasArrayHelper, type_name_MapUShortInnerAliasArrayHelper.to_string());
        CompleteStructHeader header_MapUShortInnerAliasArrayHelper;
        header_MapUShortInnerAliasArrayHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapUShortInnerAliasArrayHelper);
        CompleteStructMemberSeq member_seq_MapUShortInnerAliasArrayHelper;
        {
            TypeIdentifierPair type_ids_var_map_ushort_inneraliasarrayhelper;
            ReturnCode_t return_code_var_map_ushort_inneraliasarrayhelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ushort_inneraliasarrayhelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded", type_ids_var_map_ushort_inneraliasarrayhelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_inneraliasarrayhelper)
            {
                return_code_var_map_ushort_inneraliasarrayhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_array_helper", type_ids_var_map_ushort_inneraliasarrayhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_inneraliasarrayhelper)
                {
                ::register_Inner_alias_array_helper_type_identifier(type_ids_var_map_ushort_inneraliasarrayhelper);
                }
                bool element_identifier_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_inneraliasarrayhelper, element_identifier_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ushort_inneraliasarrayhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_inneraliasarrayhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_inneraliasarrayhelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_inneraliasarrayhelper, key_identifier_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded, element_flags_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded), key_flags_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded", type_ids_var_map_ushort_inneraliasarrayhelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint16_t_anonymous_array_int16_t_2_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ushort_inneraliasarrayhelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ushort_inneraliasarrayhelper = 0x00000000;
            bool common_var_map_ushort_inneraliasarrayhelper_ec {false};
            CommonStructMember common_var_map_ushort_inneraliasarrayhelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_ushort_inneraliasarrayhelper, member_flags_var_map_ushort_inneraliasarrayhelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_inneraliasarrayhelper, common_var_map_ushort_inneraliasarrayhelper_ec))};
            if (!common_var_map_ushort_inneraliasarrayhelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ushort_inneraliasarrayhelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ushort_inneraliasarrayhelper = "var_map_ushort_inneraliasarrayhelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ushort_inneraliasarrayhelper;
            ann_custom_MapUShortInnerAliasArrayHelper.reset();
            CompleteMemberDetail detail_var_map_ushort_inneraliasarrayhelper = TypeObjectUtils::build_complete_member_detail(name_var_map_ushort_inneraliasarrayhelper, member_ann_builtin_var_map_ushort_inneraliasarrayhelper, ann_custom_MapUShortInnerAliasArrayHelper);
            CompleteStructMember member_var_map_ushort_inneraliasarrayhelper = TypeObjectUtils::build_complete_struct_member(common_var_map_ushort_inneraliasarrayhelper, detail_var_map_ushort_inneraliasarrayhelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapUShortInnerAliasArrayHelper, member_var_map_ushort_inneraliasarrayhelper);
        }
        CompleteStructType struct_type_MapUShortInnerAliasArrayHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapUShortInnerAliasArrayHelper, header_MapUShortInnerAliasArrayHelper, member_seq_MapUShortInnerAliasArrayHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapUShortInnerAliasArrayHelper, type_name_MapUShortInnerAliasArrayHelper.to_string(), type_ids_MapUShortInnerAliasArrayHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapUShortInnerAliasArrayHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapUShortInnerAliasSequenceHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapUShortInnerAliasSequenceHelper)
{

    ReturnCode_t return_code_MapUShortInnerAliasSequenceHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapUShortInnerAliasSequenceHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapUShortInnerAliasSequenceHelper", type_ids_MapUShortInnerAliasSequenceHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapUShortInnerAliasSequenceHelper)
    {
        StructTypeFlag struct_flags_MapUShortInnerAliasSequenceHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapUShortInnerAliasSequenceHelper = "MapUShortInnerAliasSequenceHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapUShortInnerAliasSequenceHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapUShortInnerAliasSequenceHelper;
        CompleteTypeDetail detail_MapUShortInnerAliasSequenceHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapUShortInnerAliasSequenceHelper, ann_custom_MapUShortInnerAliasSequenceHelper, type_name_MapUShortInnerAliasSequenceHelper.to_string());
        CompleteStructHeader header_MapUShortInnerAliasSequenceHelper;
        header_MapUShortInnerAliasSequenceHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapUShortInnerAliasSequenceHelper);
        CompleteStructMemberSeq member_seq_MapUShortInnerAliasSequenceHelper;
        {
            TypeIdentifierPair type_ids_var_map_ushort_inneraliassequencehelper;
            ReturnCode_t return_code_var_map_ushort_inneraliassequencehelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ushort_inneraliassequencehelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded", type_ids_var_map_ushort_inneraliassequencehelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_inneraliassequencehelper)
            {
                return_code_var_map_ushort_inneraliassequencehelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_sequence_helper", type_ids_var_map_ushort_inneraliassequencehelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_inneraliassequencehelper)
                {
                ::register_Inner_alias_sequence_helper_type_identifier(type_ids_var_map_ushort_inneraliassequencehelper);
                }
                bool element_identifier_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_inneraliassequencehelper, element_identifier_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ushort_inneraliassequencehelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_inneraliassequencehelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_inneraliassequencehelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_inneraliassequencehelper, key_identifier_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded, element_flags_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded), key_flags_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded", type_ids_var_map_ushort_inneraliassequencehelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint16_t_anonymous_sequence_int16_t_unbounded_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ushort_inneraliassequencehelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ushort_inneraliassequencehelper = 0x00000000;
            bool common_var_map_ushort_inneraliassequencehelper_ec {false};
            CommonStructMember common_var_map_ushort_inneraliassequencehelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_ushort_inneraliassequencehelper, member_flags_var_map_ushort_inneraliassequencehelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_inneraliassequencehelper, common_var_map_ushort_inneraliassequencehelper_ec))};
            if (!common_var_map_ushort_inneraliassequencehelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ushort_inneraliassequencehelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ushort_inneraliassequencehelper = "var_map_ushort_inneraliassequencehelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ushort_inneraliassequencehelper;
            ann_custom_MapUShortInnerAliasSequenceHelper.reset();
            CompleteMemberDetail detail_var_map_ushort_inneraliassequencehelper = TypeObjectUtils::build_complete_member_detail(name_var_map_ushort_inneraliassequencehelper, member_ann_builtin_var_map_ushort_inneraliassequencehelper, ann_custom_MapUShortInnerAliasSequenceHelper);
            CompleteStructMember member_var_map_ushort_inneraliassequencehelper = TypeObjectUtils::build_complete_struct_member(common_var_map_ushort_inneraliassequencehelper, detail_var_map_ushort_inneraliassequencehelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapUShortInnerAliasSequenceHelper, member_var_map_ushort_inneraliassequencehelper);
        }
        CompleteStructType struct_type_MapUShortInnerAliasSequenceHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapUShortInnerAliasSequenceHelper, header_MapUShortInnerAliasSequenceHelper, member_seq_MapUShortInnerAliasSequenceHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapUShortInnerAliasSequenceHelper, type_name_MapUShortInnerAliasSequenceHelper.to_string(), type_ids_MapUShortInnerAliasSequenceHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapUShortInnerAliasSequenceHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapUShortInnerAliasMapHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapUShortInnerAliasMapHelper)
{

    ReturnCode_t return_code_MapUShortInnerAliasMapHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapUShortInnerAliasMapHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapUShortInnerAliasMapHelper", type_ids_MapUShortInnerAliasMapHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapUShortInnerAliasMapHelper)
    {
        StructTypeFlag struct_flags_MapUShortInnerAliasMapHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapUShortInnerAliasMapHelper = "MapUShortInnerAliasMapHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapUShortInnerAliasMapHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapUShortInnerAliasMapHelper;
        CompleteTypeDetail detail_MapUShortInnerAliasMapHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapUShortInnerAliasMapHelper, ann_custom_MapUShortInnerAliasMapHelper, type_name_MapUShortInnerAliasMapHelper.to_string());
        CompleteStructHeader header_MapUShortInnerAliasMapHelper;
        header_MapUShortInnerAliasMapHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapUShortInnerAliasMapHelper);
        CompleteStructMemberSeq member_seq_MapUShortInnerAliasMapHelper;
        {
            TypeIdentifierPair type_ids_var_map_ushort_inneraliasmaphelper;
            ReturnCode_t return_code_var_map_ushort_inneraliasmaphelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ushort_inneraliasmaphelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded", type_ids_var_map_ushort_inneraliasmaphelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_inneraliasmaphelper)
            {
                return_code_var_map_ushort_inneraliasmaphelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_map_helper", type_ids_var_map_ushort_inneraliasmaphelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_inneraliasmaphelper)
                {
                ::register_Inner_alias_map_helper_type_identifier(type_ids_var_map_ushort_inneraliasmaphelper);
                }
                bool element_identifier_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_inneraliasmaphelper, element_identifier_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ushort_inneraliasmaphelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_inneraliasmaphelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_inneraliasmaphelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_inneraliasmaphelper, key_identifier_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded, element_flags_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded), key_flags_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded", type_ids_var_map_ushort_inneraliasmaphelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint16_t_anonymous_map_int32_t_int32_t_0_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ushort_inneraliasmaphelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ushort_inneraliasmaphelper = 0x00000000;
            bool common_var_map_ushort_inneraliasmaphelper_ec {false};
            CommonStructMember common_var_map_ushort_inneraliasmaphelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_ushort_inneraliasmaphelper, member_flags_var_map_ushort_inneraliasmaphelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_inneraliasmaphelper, common_var_map_ushort_inneraliasmaphelper_ec))};
            if (!common_var_map_ushort_inneraliasmaphelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ushort_inneraliasmaphelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ushort_inneraliasmaphelper = "var_map_ushort_inneraliasmaphelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ushort_inneraliasmaphelper;
            ann_custom_MapUShortInnerAliasMapHelper.reset();
            CompleteMemberDetail detail_var_map_ushort_inneraliasmaphelper = TypeObjectUtils::build_complete_member_detail(name_var_map_ushort_inneraliasmaphelper, member_ann_builtin_var_map_ushort_inneraliasmaphelper, ann_custom_MapUShortInnerAliasMapHelper);
            CompleteStructMember member_var_map_ushort_inneraliasmaphelper = TypeObjectUtils::build_complete_struct_member(common_var_map_ushort_inneraliasmaphelper, detail_var_map_ushort_inneraliasmaphelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapUShortInnerAliasMapHelper, member_var_map_ushort_inneraliasmaphelper);
        }
        CompleteStructType struct_type_MapUShortInnerAliasMapHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapUShortInnerAliasMapHelper, header_MapUShortInnerAliasMapHelper, member_seq_MapUShortInnerAliasMapHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapUShortInnerAliasMapHelper, type_name_MapUShortInnerAliasMapHelper.to_string(), type_ids_MapUShortInnerAliasMapHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapUShortInnerAliasMapHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapUShortInnerUnionHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapUShortInnerUnionHelper)
{

    ReturnCode_t return_code_MapUShortInnerUnionHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapUShortInnerUnionHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapUShortInnerUnionHelper", type_ids_MapUShortInnerUnionHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapUShortInnerUnionHelper)
    {
        StructTypeFlag struct_flags_MapUShortInnerUnionHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapUShortInnerUnionHelper = "MapUShortInnerUnionHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapUShortInnerUnionHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapUShortInnerUnionHelper;
        CompleteTypeDetail detail_MapUShortInnerUnionHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapUShortInnerUnionHelper, ann_custom_MapUShortInnerUnionHelper, type_name_MapUShortInnerUnionHelper.to_string());
        CompleteStructHeader header_MapUShortInnerUnionHelper;
        header_MapUShortInnerUnionHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapUShortInnerUnionHelper);
        CompleteStructMemberSeq member_seq_MapUShortInnerUnionHelper;
        {
            TypeIdentifierPair type_ids_var_map_ushort_innerunionhelper;
            ReturnCode_t return_code_var_map_ushort_innerunionhelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ushort_innerunionhelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint16_t_InnerUnionHelper_unbounded", type_ids_var_map_ushort_innerunionhelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_innerunionhelper)
            {
                return_code_var_map_ushort_innerunionhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerUnionHelper", type_ids_var_map_ushort_innerunionhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_innerunionhelper)
                {
                ::register_InnerUnionHelper_type_identifier(type_ids_var_map_ushort_innerunionhelper);
                }
                bool element_identifier_anonymous_map_uint16_t_InnerUnionHelper_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint16_t_InnerUnionHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_innerunionhelper, element_identifier_anonymous_map_uint16_t_InnerUnionHelper_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint16_t_InnerUnionHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_InnerUnionHelper_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ushort_innerunionhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_innerunionhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_innerunionhelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint16_t_InnerUnionHelper_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint16_t_InnerUnionHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_innerunionhelper, key_identifier_anonymous_map_uint16_t_InnerUnionHelper_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint16_t_InnerUnionHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_InnerUnionHelper_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint16_t_InnerUnionHelper_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint16_t_InnerUnionHelper_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerUnionHelper_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint16_t_InnerUnionHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerUnionHelper_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint16_t_InnerUnionHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerUnionHelper_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint16_t_InnerUnionHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerUnionHelper_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint16_t_InnerUnionHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerUnionHelper_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint16_t_InnerUnionHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerUnionHelper_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerUnionHelper_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint16_t_InnerUnionHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerUnionHelper_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerUnionHelper_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint16_t_InnerUnionHelper_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint16_t_InnerUnionHelper_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint16_t_InnerUnionHelper_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint16_t_InnerUnionHelper_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint16_t_InnerUnionHelper_unbounded, element_flags_anonymous_map_uint16_t_InnerUnionHelper_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint16_t_InnerUnionHelper_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint16_t_InnerUnionHelper_unbounded), key_flags_anonymous_map_uint16_t_InnerUnionHelper_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint16_t_InnerUnionHelper_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint16_t_InnerUnionHelper_unbounded", type_ids_var_map_ushort_innerunionhelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint16_t_InnerUnionHelper_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ushort_innerunionhelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ushort_innerunionhelper = 0x00000000;
            bool common_var_map_ushort_innerunionhelper_ec {false};
            CommonStructMember common_var_map_ushort_innerunionhelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_ushort_innerunionhelper, member_flags_var_map_ushort_innerunionhelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_innerunionhelper, common_var_map_ushort_innerunionhelper_ec))};
            if (!common_var_map_ushort_innerunionhelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ushort_innerunionhelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ushort_innerunionhelper = "var_map_ushort_innerunionhelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ushort_innerunionhelper;
            ann_custom_MapUShortInnerUnionHelper.reset();
            CompleteMemberDetail detail_var_map_ushort_innerunionhelper = TypeObjectUtils::build_complete_member_detail(name_var_map_ushort_innerunionhelper, member_ann_builtin_var_map_ushort_innerunionhelper, ann_custom_MapUShortInnerUnionHelper);
            CompleteStructMember member_var_map_ushort_innerunionhelper = TypeObjectUtils::build_complete_struct_member(common_var_map_ushort_innerunionhelper, detail_var_map_ushort_innerunionhelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapUShortInnerUnionHelper, member_var_map_ushort_innerunionhelper);
        }
        CompleteStructType struct_type_MapUShortInnerUnionHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapUShortInnerUnionHelper, header_MapUShortInnerUnionHelper, member_seq_MapUShortInnerUnionHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapUShortInnerUnionHelper, type_name_MapUShortInnerUnionHelper.to_string(), type_ids_MapUShortInnerUnionHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapUShortInnerUnionHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapUShortInnerStructureHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapUShortInnerStructureHelper)
{

    ReturnCode_t return_code_MapUShortInnerStructureHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapUShortInnerStructureHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapUShortInnerStructureHelper", type_ids_MapUShortInnerStructureHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapUShortInnerStructureHelper)
    {
        StructTypeFlag struct_flags_MapUShortInnerStructureHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapUShortInnerStructureHelper = "MapUShortInnerStructureHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapUShortInnerStructureHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapUShortInnerStructureHelper;
        CompleteTypeDetail detail_MapUShortInnerStructureHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapUShortInnerStructureHelper, ann_custom_MapUShortInnerStructureHelper, type_name_MapUShortInnerStructureHelper.to_string());
        CompleteStructHeader header_MapUShortInnerStructureHelper;
        header_MapUShortInnerStructureHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapUShortInnerStructureHelper);
        CompleteStructMemberSeq member_seq_MapUShortInnerStructureHelper;
        {
            TypeIdentifierPair type_ids_var_map_ushort_innerstructurehelper;
            ReturnCode_t return_code_var_map_ushort_innerstructurehelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ushort_innerstructurehelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint16_t_InnerStructureHelper_unbounded", type_ids_var_map_ushort_innerstructurehelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_innerstructurehelper)
            {
                return_code_var_map_ushort_innerstructurehelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerStructureHelper", type_ids_var_map_ushort_innerstructurehelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_innerstructurehelper)
                {
                ::register_InnerStructureHelper_type_identifier(type_ids_var_map_ushort_innerstructurehelper);
                }
                bool element_identifier_anonymous_map_uint16_t_InnerStructureHelper_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint16_t_InnerStructureHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_innerstructurehelper, element_identifier_anonymous_map_uint16_t_InnerStructureHelper_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint16_t_InnerStructureHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_InnerStructureHelper_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ushort_innerstructurehelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_innerstructurehelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_innerstructurehelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint16_t_InnerStructureHelper_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint16_t_InnerStructureHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_innerstructurehelper, key_identifier_anonymous_map_uint16_t_InnerStructureHelper_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint16_t_InnerStructureHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_InnerStructureHelper_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint16_t_InnerStructureHelper_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint16_t_InnerStructureHelper_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerStructureHelper_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint16_t_InnerStructureHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerStructureHelper_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint16_t_InnerStructureHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerStructureHelper_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint16_t_InnerStructureHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerStructureHelper_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint16_t_InnerStructureHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerStructureHelper_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint16_t_InnerStructureHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerStructureHelper_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerStructureHelper_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint16_t_InnerStructureHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerStructureHelper_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerStructureHelper_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint16_t_InnerStructureHelper_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint16_t_InnerStructureHelper_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint16_t_InnerStructureHelper_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint16_t_InnerStructureHelper_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint16_t_InnerStructureHelper_unbounded, element_flags_anonymous_map_uint16_t_InnerStructureHelper_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint16_t_InnerStructureHelper_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint16_t_InnerStructureHelper_unbounded), key_flags_anonymous_map_uint16_t_InnerStructureHelper_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint16_t_InnerStructureHelper_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint16_t_InnerStructureHelper_unbounded", type_ids_var_map_ushort_innerstructurehelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint16_t_InnerStructureHelper_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ushort_innerstructurehelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ushort_innerstructurehelper = 0x00000000;
            bool common_var_map_ushort_innerstructurehelper_ec {false};
            CommonStructMember common_var_map_ushort_innerstructurehelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_ushort_innerstructurehelper, member_flags_var_map_ushort_innerstructurehelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_innerstructurehelper, common_var_map_ushort_innerstructurehelper_ec))};
            if (!common_var_map_ushort_innerstructurehelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ushort_innerstructurehelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ushort_innerstructurehelper = "var_map_ushort_innerstructurehelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ushort_innerstructurehelper;
            ann_custom_MapUShortInnerStructureHelper.reset();
            CompleteMemberDetail detail_var_map_ushort_innerstructurehelper = TypeObjectUtils::build_complete_member_detail(name_var_map_ushort_innerstructurehelper, member_ann_builtin_var_map_ushort_innerstructurehelper, ann_custom_MapUShortInnerStructureHelper);
            CompleteStructMember member_var_map_ushort_innerstructurehelper = TypeObjectUtils::build_complete_struct_member(common_var_map_ushort_innerstructurehelper, detail_var_map_ushort_innerstructurehelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapUShortInnerStructureHelper, member_var_map_ushort_innerstructurehelper);
        }
        CompleteStructType struct_type_MapUShortInnerStructureHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapUShortInnerStructureHelper, header_MapUShortInnerStructureHelper, member_seq_MapUShortInnerStructureHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapUShortInnerStructureHelper, type_name_MapUShortInnerStructureHelper.to_string(), type_ids_MapUShortInnerStructureHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapUShortInnerStructureHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapUShortInnerBitsetHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapUShortInnerBitsetHelper)
{

    ReturnCode_t return_code_MapUShortInnerBitsetHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapUShortInnerBitsetHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapUShortInnerBitsetHelper", type_ids_MapUShortInnerBitsetHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapUShortInnerBitsetHelper)
    {
        StructTypeFlag struct_flags_MapUShortInnerBitsetHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapUShortInnerBitsetHelper = "MapUShortInnerBitsetHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapUShortInnerBitsetHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapUShortInnerBitsetHelper;
        CompleteTypeDetail detail_MapUShortInnerBitsetHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapUShortInnerBitsetHelper, ann_custom_MapUShortInnerBitsetHelper, type_name_MapUShortInnerBitsetHelper.to_string());
        CompleteStructHeader header_MapUShortInnerBitsetHelper;
        header_MapUShortInnerBitsetHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapUShortInnerBitsetHelper);
        CompleteStructMemberSeq member_seq_MapUShortInnerBitsetHelper;
        {
            TypeIdentifierPair type_ids_var_map_ushort_innerbitsethelper;
            ReturnCode_t return_code_var_map_ushort_innerbitsethelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ushort_innerbitsethelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint16_t_InnerBitsetHelper_unbounded", type_ids_var_map_ushort_innerbitsethelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_innerbitsethelper)
            {
                return_code_var_map_ushort_innerbitsethelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerBitsetHelper", type_ids_var_map_ushort_innerbitsethelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_innerbitsethelper)
                {
                ::register_InnerBitsetHelper_type_identifier(type_ids_var_map_ushort_innerbitsethelper);
                }
                bool element_identifier_anonymous_map_uint16_t_InnerBitsetHelper_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint16_t_InnerBitsetHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_innerbitsethelper, element_identifier_anonymous_map_uint16_t_InnerBitsetHelper_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint16_t_InnerBitsetHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_InnerBitsetHelper_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ushort_innerbitsethelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ushort_innerbitsethelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ushort_innerbitsethelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint16_t_InnerBitsetHelper_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint16_t_InnerBitsetHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_innerbitsethelper, key_identifier_anonymous_map_uint16_t_InnerBitsetHelper_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint16_t_InnerBitsetHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint16_t_InnerBitsetHelper_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint16_t_InnerBitsetHelper_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint16_t_InnerBitsetHelper_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerBitsetHelper_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint16_t_InnerBitsetHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerBitsetHelper_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint16_t_InnerBitsetHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerBitsetHelper_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint16_t_InnerBitsetHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerBitsetHelper_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint16_t_InnerBitsetHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerBitsetHelper_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint16_t_InnerBitsetHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerBitsetHelper_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerBitsetHelper_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint16_t_InnerBitsetHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerBitsetHelper_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint16_t_InnerBitsetHelper_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint16_t_InnerBitsetHelper_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint16_t_InnerBitsetHelper_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint16_t_InnerBitsetHelper_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint16_t_InnerBitsetHelper_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint16_t_InnerBitsetHelper_unbounded, element_flags_anonymous_map_uint16_t_InnerBitsetHelper_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint16_t_InnerBitsetHelper_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint16_t_InnerBitsetHelper_unbounded), key_flags_anonymous_map_uint16_t_InnerBitsetHelper_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint16_t_InnerBitsetHelper_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint16_t_InnerBitsetHelper_unbounded", type_ids_var_map_ushort_innerbitsethelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint16_t_InnerBitsetHelper_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ushort_innerbitsethelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ushort_innerbitsethelper = 0x00000000;
            bool common_var_map_ushort_innerbitsethelper_ec {false};
            CommonStructMember common_var_map_ushort_innerbitsethelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_ushort_innerbitsethelper, member_flags_var_map_ushort_innerbitsethelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ushort_innerbitsethelper, common_var_map_ushort_innerbitsethelper_ec))};
            if (!common_var_map_ushort_innerbitsethelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ushort_innerbitsethelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ushort_innerbitsethelper = "var_map_ushort_innerbitsethelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ushort_innerbitsethelper;
            ann_custom_MapUShortInnerBitsetHelper.reset();
            CompleteMemberDetail detail_var_map_ushort_innerbitsethelper = TypeObjectUtils::build_complete_member_detail(name_var_map_ushort_innerbitsethelper, member_ann_builtin_var_map_ushort_innerbitsethelper, ann_custom_MapUShortInnerBitsetHelper);
            CompleteStructMember member_var_map_ushort_innerbitsethelper = TypeObjectUtils::build_complete_struct_member(common_var_map_ushort_innerbitsethelper, detail_var_map_ushort_innerbitsethelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapUShortInnerBitsetHelper, member_var_map_ushort_innerbitsethelper);
        }
        CompleteStructType struct_type_MapUShortInnerBitsetHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapUShortInnerBitsetHelper, header_MapUShortInnerBitsetHelper, member_seq_MapUShortInnerBitsetHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapUShortInnerBitsetHelper, type_name_MapUShortInnerBitsetHelper.to_string(), type_ids_MapUShortInnerBitsetHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapUShortInnerBitsetHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapLongShort_type_identifier(
        TypeIdentifierPair& type_ids_MapLongShort)
{

    ReturnCode_t return_code_MapLongShort {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapLongShort =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapLongShort", type_ids_MapLongShort);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapLongShort)
    {
        StructTypeFlag struct_flags_MapLongShort = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapLongShort = "MapLongShort";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapLongShort;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapLongShort;
        CompleteTypeDetail detail_MapLongShort = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapLongShort, ann_custom_MapLongShort, type_name_MapLongShort.to_string());
        CompleteStructHeader header_MapLongShort;
        header_MapLongShort = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapLongShort);
        CompleteStructMemberSeq member_seq_MapLongShort;
        {
            TypeIdentifierPair type_ids_var_map_long_short;
            ReturnCode_t return_code_var_map_long_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_long_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_int16_t_unbounded", type_ids_var_map_long_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_short)
            {
                return_code_var_map_long_short =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_long_short);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_short)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int32_t_int16_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_int16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_short, element_identifier_anonymous_map_int32_t_int16_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_int16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_int16_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_long_short =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_short);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_short)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_int16_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_int16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_short, key_identifier_anonymous_map_int32_t_int16_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_int16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_int16_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_int16_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int16_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_int16_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_int16_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_int16_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_int16_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_int16_t_unbounded, element_flags_anonymous_map_int32_t_int16_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_int16_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_int16_t_unbounded), key_flags_anonymous_map_int32_t_int16_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_int16_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_int16_t_unbounded", type_ids_var_map_long_short))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_int16_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_long_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_long_short = 0x00000000;
            bool common_var_map_long_short_ec {false};
            CommonStructMember common_var_map_long_short {TypeObjectUtils::build_common_struct_member(member_id_var_map_long_short, member_flags_var_map_long_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_short, common_var_map_long_short_ec))};
            if (!common_var_map_long_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_long_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_long_short = "var_map_long_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_long_short;
            ann_custom_MapLongShort.reset();
            CompleteMemberDetail detail_var_map_long_short = TypeObjectUtils::build_complete_member_detail(name_var_map_long_short, member_ann_builtin_var_map_long_short, ann_custom_MapLongShort);
            CompleteStructMember member_var_map_long_short = TypeObjectUtils::build_complete_struct_member(common_var_map_long_short, detail_var_map_long_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapLongShort, member_var_map_long_short);
        }
        CompleteStructType struct_type_MapLongShort = TypeObjectUtils::build_complete_struct_type(struct_flags_MapLongShort, header_MapLongShort, member_seq_MapLongShort);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapLongShort, type_name_MapLongShort.to_string(), type_ids_MapLongShort))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapLongShort already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapLongUShort_type_identifier(
        TypeIdentifierPair& type_ids_MapLongUShort)
{

    ReturnCode_t return_code_MapLongUShort {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapLongUShort =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapLongUShort", type_ids_MapLongUShort);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapLongUShort)
    {
        StructTypeFlag struct_flags_MapLongUShort = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapLongUShort = "MapLongUShort";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapLongUShort;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapLongUShort;
        CompleteTypeDetail detail_MapLongUShort = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapLongUShort, ann_custom_MapLongUShort, type_name_MapLongUShort.to_string());
        CompleteStructHeader header_MapLongUShort;
        header_MapLongUShort = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapLongUShort);
        CompleteStructMemberSeq member_seq_MapLongUShort;
        {
            TypeIdentifierPair type_ids_var_map_long_ushort;
            ReturnCode_t return_code_var_map_long_ushort {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_long_ushort =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_uint16_t_unbounded", type_ids_var_map_long_ushort);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_ushort)
            {
                return_code_var_map_long_ushort =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_long_ushort);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_ushort)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int32_t_uint16_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_uint16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_ushort, element_identifier_anonymous_map_int32_t_uint16_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_uint16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_uint16_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_long_ushort =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_ushort);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_ushort)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_uint16_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_uint16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_ushort, key_identifier_anonymous_map_int32_t_uint16_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_uint16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_uint16_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_uint16_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_uint16_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint16_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_uint16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint16_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_uint16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint16_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_uint16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint16_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_uint16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint16_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_uint16_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint16_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint16_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_uint16_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint16_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint16_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_uint16_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_uint16_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_uint16_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_uint16_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_uint16_t_unbounded, element_flags_anonymous_map_int32_t_uint16_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_uint16_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_uint16_t_unbounded), key_flags_anonymous_map_int32_t_uint16_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_uint16_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_uint16_t_unbounded", type_ids_var_map_long_ushort))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_uint16_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_long_ushort = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_long_ushort = 0x00000000;
            bool common_var_map_long_ushort_ec {false};
            CommonStructMember common_var_map_long_ushort {TypeObjectUtils::build_common_struct_member(member_id_var_map_long_ushort, member_flags_var_map_long_ushort, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_ushort, common_var_map_long_ushort_ec))};
            if (!common_var_map_long_ushort_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_long_ushort member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_long_ushort = "var_map_long_ushort";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_long_ushort;
            ann_custom_MapLongUShort.reset();
            CompleteMemberDetail detail_var_map_long_ushort = TypeObjectUtils::build_complete_member_detail(name_var_map_long_ushort, member_ann_builtin_var_map_long_ushort, ann_custom_MapLongUShort);
            CompleteStructMember member_var_map_long_ushort = TypeObjectUtils::build_complete_struct_member(common_var_map_long_ushort, detail_var_map_long_ushort);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapLongUShort, member_var_map_long_ushort);
        }
        CompleteStructType struct_type_MapLongUShort = TypeObjectUtils::build_complete_struct_type(struct_flags_MapLongUShort, header_MapLongUShort, member_seq_MapLongUShort);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapLongUShort, type_name_MapLongUShort.to_string(), type_ids_MapLongUShort))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapLongUShort already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapLongLong_type_identifier(
        TypeIdentifierPair& type_ids_MapLongLong)
{

    ReturnCode_t return_code_MapLongLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapLongLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapLongLong", type_ids_MapLongLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapLongLong)
    {
        StructTypeFlag struct_flags_MapLongLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapLongLong = "MapLongLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapLongLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapLongLong;
        CompleteTypeDetail detail_MapLongLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapLongLong, ann_custom_MapLongLong, type_name_MapLongLong.to_string());
        CompleteStructHeader header_MapLongLong;
        header_MapLongLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapLongLong);
        CompleteStructMemberSeq member_seq_MapLongLong;
        {
            TypeIdentifierPair type_ids_var_map_long_long;
            ReturnCode_t return_code_var_map_long_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_long_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_int32_t_unbounded", type_ids_var_map_long_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_long)
            {
                return_code_var_map_long_long =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_long);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_long)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int32_t_int32_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_long, element_identifier_anonymous_map_int32_t_int32_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_int32_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_int32_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_long_long =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_long);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_long)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_int32_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_long, key_identifier_anonymous_map_int32_t_int32_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_int32_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_int32_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_int32_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int32_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_int32_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_int32_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_int32_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_int32_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_int32_t_unbounded, element_flags_anonymous_map_int32_t_int32_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_int32_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_int32_t_unbounded), key_flags_anonymous_map_int32_t_int32_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_int32_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_int32_t_unbounded", type_ids_var_map_long_long))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_int32_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_long_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_long_long = 0x00000000;
            bool common_var_map_long_long_ec {false};
            CommonStructMember common_var_map_long_long {TypeObjectUtils::build_common_struct_member(member_id_var_map_long_long, member_flags_var_map_long_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_long, common_var_map_long_long_ec))};
            if (!common_var_map_long_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_long_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_long_long = "var_map_long_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_long_long;
            ann_custom_MapLongLong.reset();
            CompleteMemberDetail detail_var_map_long_long = TypeObjectUtils::build_complete_member_detail(name_var_map_long_long, member_ann_builtin_var_map_long_long, ann_custom_MapLongLong);
            CompleteStructMember member_var_map_long_long = TypeObjectUtils::build_complete_struct_member(common_var_map_long_long, detail_var_map_long_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapLongLong, member_var_map_long_long);
        }
        CompleteStructType struct_type_MapLongLong = TypeObjectUtils::build_complete_struct_type(struct_flags_MapLongLong, header_MapLongLong, member_seq_MapLongLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapLongLong, type_name_MapLongLong.to_string(), type_ids_MapLongLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapLongLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapLongULong_type_identifier(
        TypeIdentifierPair& type_ids_MapLongULong)
{

    ReturnCode_t return_code_MapLongULong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapLongULong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapLongULong", type_ids_MapLongULong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapLongULong)
    {
        StructTypeFlag struct_flags_MapLongULong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapLongULong = "MapLongULong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapLongULong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapLongULong;
        CompleteTypeDetail detail_MapLongULong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapLongULong, ann_custom_MapLongULong, type_name_MapLongULong.to_string());
        CompleteStructHeader header_MapLongULong;
        header_MapLongULong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapLongULong);
        CompleteStructMemberSeq member_seq_MapLongULong;
        {
            TypeIdentifierPair type_ids_var_map_long_ulong;
            ReturnCode_t return_code_var_map_long_ulong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_long_ulong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_uint32_t_unbounded", type_ids_var_map_long_ulong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_ulong)
            {
                return_code_var_map_long_ulong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_var_map_long_ulong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_ulong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int32_t_uint32_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_uint32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_ulong, element_identifier_anonymous_map_int32_t_uint32_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_uint32_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_uint32_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_long_ulong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_ulong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_ulong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_uint32_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_uint32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_ulong, key_identifier_anonymous_map_int32_t_uint32_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_uint32_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_uint32_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_uint32_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_uint32_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint32_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_uint32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint32_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_uint32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint32_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_uint32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint32_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_uint32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint32_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_uint32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint32_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint32_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_uint32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint32_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint32_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_uint32_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_uint32_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_uint32_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_uint32_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_uint32_t_unbounded, element_flags_anonymous_map_int32_t_uint32_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_uint32_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_uint32_t_unbounded), key_flags_anonymous_map_int32_t_uint32_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_uint32_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_uint32_t_unbounded", type_ids_var_map_long_ulong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_uint32_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_long_ulong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_long_ulong = 0x00000000;
            bool common_var_map_long_ulong_ec {false};
            CommonStructMember common_var_map_long_ulong {TypeObjectUtils::build_common_struct_member(member_id_var_map_long_ulong, member_flags_var_map_long_ulong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_ulong, common_var_map_long_ulong_ec))};
            if (!common_var_map_long_ulong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_long_ulong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_long_ulong = "var_map_long_ulong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_long_ulong;
            ann_custom_MapLongULong.reset();
            CompleteMemberDetail detail_var_map_long_ulong = TypeObjectUtils::build_complete_member_detail(name_var_map_long_ulong, member_ann_builtin_var_map_long_ulong, ann_custom_MapLongULong);
            CompleteStructMember member_var_map_long_ulong = TypeObjectUtils::build_complete_struct_member(common_var_map_long_ulong, detail_var_map_long_ulong);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapLongULong, member_var_map_long_ulong);
        }
        CompleteStructType struct_type_MapLongULong = TypeObjectUtils::build_complete_struct_type(struct_flags_MapLongULong, header_MapLongULong, member_seq_MapLongULong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapLongULong, type_name_MapLongULong.to_string(), type_ids_MapLongULong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapLongULong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapLongKeyLongLongValue_type_identifier(
        TypeIdentifierPair& type_ids_MapLongKeyLongLongValue)
{

    ReturnCode_t return_code_MapLongKeyLongLongValue {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapLongKeyLongLongValue =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapLongKeyLongLongValue", type_ids_MapLongKeyLongLongValue);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapLongKeyLongLongValue)
    {
        StructTypeFlag struct_flags_MapLongKeyLongLongValue = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapLongKeyLongLongValue = "MapLongKeyLongLongValue";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapLongKeyLongLongValue;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapLongKeyLongLongValue;
        CompleteTypeDetail detail_MapLongKeyLongLongValue = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapLongKeyLongLongValue, ann_custom_MapLongKeyLongLongValue, type_name_MapLongKeyLongLongValue.to_string());
        CompleteStructHeader header_MapLongKeyLongLongValue;
        header_MapLongKeyLongLongValue = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapLongKeyLongLongValue);
        CompleteStructMemberSeq member_seq_MapLongKeyLongLongValue;
        {
            TypeIdentifierPair type_ids_var_map_long_longlong;
            ReturnCode_t return_code_var_map_long_longlong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_long_longlong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_int64_t_unbounded", type_ids_var_map_long_longlong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_longlong)
            {
                return_code_var_map_long_longlong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int64_t", type_ids_var_map_long_longlong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_longlong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int32_t_int64_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_int64_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_longlong, element_identifier_anonymous_map_int32_t_int64_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_int64_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_int64_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_long_longlong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_longlong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_longlong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_int64_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_int64_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_longlong, key_identifier_anonymous_map_int32_t_int64_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_int64_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_int64_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_int64_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_int64_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int64_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_int64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int64_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_int64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int64_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_int64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int64_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_int64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_int64_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_int64_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_int64_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int64_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_int64_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_int64_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_int64_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_int64_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_int64_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_int64_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_int64_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_int64_t_unbounded, element_flags_anonymous_map_int32_t_int64_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_int64_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_int64_t_unbounded), key_flags_anonymous_map_int32_t_int64_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_int64_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_int64_t_unbounded", type_ids_var_map_long_longlong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_int64_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_long_longlong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_long_longlong = 0x00000000;
            bool common_var_map_long_longlong_ec {false};
            CommonStructMember common_var_map_long_longlong {TypeObjectUtils::build_common_struct_member(member_id_var_map_long_longlong, member_flags_var_map_long_longlong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_longlong, common_var_map_long_longlong_ec))};
            if (!common_var_map_long_longlong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_long_longlong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_long_longlong = "var_map_long_longlong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_long_longlong;
            ann_custom_MapLongKeyLongLongValue.reset();
            CompleteMemberDetail detail_var_map_long_longlong = TypeObjectUtils::build_complete_member_detail(name_var_map_long_longlong, member_ann_builtin_var_map_long_longlong, ann_custom_MapLongKeyLongLongValue);
            CompleteStructMember member_var_map_long_longlong = TypeObjectUtils::build_complete_struct_member(common_var_map_long_longlong, detail_var_map_long_longlong);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapLongKeyLongLongValue, member_var_map_long_longlong);
        }
        CompleteStructType struct_type_MapLongKeyLongLongValue = TypeObjectUtils::build_complete_struct_type(struct_flags_MapLongKeyLongLongValue, header_MapLongKeyLongLongValue, member_seq_MapLongKeyLongLongValue);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapLongKeyLongLongValue, type_name_MapLongKeyLongLongValue.to_string(), type_ids_MapLongKeyLongLongValue))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapLongKeyLongLongValue already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapLongULongLong_type_identifier(
        TypeIdentifierPair& type_ids_MapLongULongLong)
{

    ReturnCode_t return_code_MapLongULongLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapLongULongLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapLongULongLong", type_ids_MapLongULongLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapLongULongLong)
    {
        StructTypeFlag struct_flags_MapLongULongLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapLongULongLong = "MapLongULongLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapLongULongLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapLongULongLong;
        CompleteTypeDetail detail_MapLongULongLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapLongULongLong, ann_custom_MapLongULongLong, type_name_MapLongULongLong.to_string());
        CompleteStructHeader header_MapLongULongLong;
        header_MapLongULongLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapLongULongLong);
        CompleteStructMemberSeq member_seq_MapLongULongLong;
        {
            TypeIdentifierPair type_ids_var_map_long_ulonglong;
            ReturnCode_t return_code_var_map_long_ulonglong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_long_ulonglong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_uint64_t_unbounded", type_ids_var_map_long_ulonglong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_ulonglong)
            {
                return_code_var_map_long_ulonglong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint64_t", type_ids_var_map_long_ulonglong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_ulonglong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int32_t_uint64_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_uint64_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_ulonglong, element_identifier_anonymous_map_int32_t_uint64_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_uint64_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_uint64_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_long_ulonglong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_ulonglong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_ulonglong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_uint64_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_uint64_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_ulonglong, key_identifier_anonymous_map_int32_t_uint64_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_uint64_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_uint64_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_uint64_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_uint64_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint64_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_uint64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint64_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_uint64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint64_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_uint64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint64_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_uint64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint64_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_uint64_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint64_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint64_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_uint64_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint64_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_uint64_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_uint64_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_uint64_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_uint64_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_uint64_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_uint64_t_unbounded, element_flags_anonymous_map_int32_t_uint64_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_uint64_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_uint64_t_unbounded), key_flags_anonymous_map_int32_t_uint64_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_uint64_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_uint64_t_unbounded", type_ids_var_map_long_ulonglong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_uint64_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_long_ulonglong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_long_ulonglong = 0x00000000;
            bool common_var_map_long_ulonglong_ec {false};
            CommonStructMember common_var_map_long_ulonglong {TypeObjectUtils::build_common_struct_member(member_id_var_map_long_ulonglong, member_flags_var_map_long_ulonglong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_ulonglong, common_var_map_long_ulonglong_ec))};
            if (!common_var_map_long_ulonglong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_long_ulonglong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_long_ulonglong = "var_map_long_ulonglong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_long_ulonglong;
            ann_custom_MapLongULongLong.reset();
            CompleteMemberDetail detail_var_map_long_ulonglong = TypeObjectUtils::build_complete_member_detail(name_var_map_long_ulonglong, member_ann_builtin_var_map_long_ulonglong, ann_custom_MapLongULongLong);
            CompleteStructMember member_var_map_long_ulonglong = TypeObjectUtils::build_complete_struct_member(common_var_map_long_ulonglong, detail_var_map_long_ulonglong);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapLongULongLong, member_var_map_long_ulonglong);
        }
        CompleteStructType struct_type_MapLongULongLong = TypeObjectUtils::build_complete_struct_type(struct_flags_MapLongULongLong, header_MapLongULongLong, member_seq_MapLongULongLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapLongULongLong, type_name_MapLongULongLong.to_string(), type_ids_MapLongULongLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapLongULongLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapLongFloat_type_identifier(
        TypeIdentifierPair& type_ids_MapLongFloat)
{

    ReturnCode_t return_code_MapLongFloat {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapLongFloat =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapLongFloat", type_ids_MapLongFloat);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapLongFloat)
    {
        StructTypeFlag struct_flags_MapLongFloat = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapLongFloat = "MapLongFloat";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapLongFloat;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapLongFloat;
        CompleteTypeDetail detail_MapLongFloat = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapLongFloat, ann_custom_MapLongFloat, type_name_MapLongFloat.to_string());
        CompleteStructHeader header_MapLongFloat;
        header_MapLongFloat = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapLongFloat);
        CompleteStructMemberSeq member_seq_MapLongFloat;
        {
            TypeIdentifierPair type_ids_var_map_long_float;
            ReturnCode_t return_code_var_map_long_float {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_long_float =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_float_unbounded", type_ids_var_map_long_float);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_float)
            {
                return_code_var_map_long_float =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_float", type_ids_var_map_long_float);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_float)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int32_t_float_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_float_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_float, element_identifier_anonymous_map_int32_t_float_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_float_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_float_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_long_float =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_float);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_float)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_float_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_float_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_float, key_identifier_anonymous_map_int32_t_float_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_float_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_float_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_float_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_float_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_float_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_float_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_float_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_float_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_float_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_float_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_float_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_float_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_float_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_float_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_float_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_float_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_float_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_float_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_float_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_float_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_float_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_float_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_float_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_float_unbounded, element_flags_anonymous_map_int32_t_float_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_float_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_float_unbounded), key_flags_anonymous_map_int32_t_float_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_float_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_float_unbounded", type_ids_var_map_long_float))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_float_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_long_float = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_long_float = 0x00000000;
            bool common_var_map_long_float_ec {false};
            CommonStructMember common_var_map_long_float {TypeObjectUtils::build_common_struct_member(member_id_var_map_long_float, member_flags_var_map_long_float, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_float, common_var_map_long_float_ec))};
            if (!common_var_map_long_float_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_long_float member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_long_float = "var_map_long_float";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_long_float;
            ann_custom_MapLongFloat.reset();
            CompleteMemberDetail detail_var_map_long_float = TypeObjectUtils::build_complete_member_detail(name_var_map_long_float, member_ann_builtin_var_map_long_float, ann_custom_MapLongFloat);
            CompleteStructMember member_var_map_long_float = TypeObjectUtils::build_complete_struct_member(common_var_map_long_float, detail_var_map_long_float);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapLongFloat, member_var_map_long_float);
        }
        CompleteStructType struct_type_MapLongFloat = TypeObjectUtils::build_complete_struct_type(struct_flags_MapLongFloat, header_MapLongFloat, member_seq_MapLongFloat);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapLongFloat, type_name_MapLongFloat.to_string(), type_ids_MapLongFloat))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapLongFloat already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapLongDouble_type_identifier(
        TypeIdentifierPair& type_ids_MapLongDouble)
{

    ReturnCode_t return_code_MapLongDouble {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapLongDouble =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapLongDouble", type_ids_MapLongDouble);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapLongDouble)
    {
        StructTypeFlag struct_flags_MapLongDouble = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapLongDouble = "MapLongDouble";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapLongDouble;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapLongDouble;
        CompleteTypeDetail detail_MapLongDouble = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapLongDouble, ann_custom_MapLongDouble, type_name_MapLongDouble.to_string());
        CompleteStructHeader header_MapLongDouble;
        header_MapLongDouble = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapLongDouble);
        CompleteStructMemberSeq member_seq_MapLongDouble;
        {
            TypeIdentifierPair type_ids_var_map_long_double;
            ReturnCode_t return_code_var_map_long_double {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_long_double =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_double_unbounded", type_ids_var_map_long_double);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_double)
            {
                return_code_var_map_long_double =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_double", type_ids_var_map_long_double);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_double)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int32_t_double_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_double_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_double, element_identifier_anonymous_map_int32_t_double_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_double_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_double_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_long_double =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_double);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_double)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_double_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_double_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_double, key_identifier_anonymous_map_int32_t_double_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_double_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_double_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_double_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_double_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_double_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_double_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_double_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_double_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_double_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_double_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_double_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_double_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_double_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_double_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_double_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_double_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_double_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_double_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_double_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_double_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_double_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_double_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_double_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_double_unbounded, element_flags_anonymous_map_int32_t_double_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_double_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_double_unbounded), key_flags_anonymous_map_int32_t_double_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_double_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_double_unbounded", type_ids_var_map_long_double))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_double_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_long_double = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_long_double = 0x00000000;
            bool common_var_map_long_double_ec {false};
            CommonStructMember common_var_map_long_double {TypeObjectUtils::build_common_struct_member(member_id_var_map_long_double, member_flags_var_map_long_double, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_double, common_var_map_long_double_ec))};
            if (!common_var_map_long_double_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_long_double member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_long_double = "var_map_long_double";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_long_double;
            ann_custom_MapLongDouble.reset();
            CompleteMemberDetail detail_var_map_long_double = TypeObjectUtils::build_complete_member_detail(name_var_map_long_double, member_ann_builtin_var_map_long_double, ann_custom_MapLongDouble);
            CompleteStructMember member_var_map_long_double = TypeObjectUtils::build_complete_struct_member(common_var_map_long_double, detail_var_map_long_double);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapLongDouble, member_var_map_long_double);
        }
        CompleteStructType struct_type_MapLongDouble = TypeObjectUtils::build_complete_struct_type(struct_flags_MapLongDouble, header_MapLongDouble, member_seq_MapLongDouble);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapLongDouble, type_name_MapLongDouble.to_string(), type_ids_MapLongDouble))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapLongDouble already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapLongKeyLongDoubleValue_type_identifier(
        TypeIdentifierPair& type_ids_MapLongKeyLongDoubleValue)
{

    ReturnCode_t return_code_MapLongKeyLongDoubleValue {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapLongKeyLongDoubleValue =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapLongKeyLongDoubleValue", type_ids_MapLongKeyLongDoubleValue);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapLongKeyLongDoubleValue)
    {
        StructTypeFlag struct_flags_MapLongKeyLongDoubleValue = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapLongKeyLongDoubleValue = "MapLongKeyLongDoubleValue";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapLongKeyLongDoubleValue;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapLongKeyLongDoubleValue;
        CompleteTypeDetail detail_MapLongKeyLongDoubleValue = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapLongKeyLongDoubleValue, ann_custom_MapLongKeyLongDoubleValue, type_name_MapLongKeyLongDoubleValue.to_string());
        CompleteStructHeader header_MapLongKeyLongDoubleValue;
        header_MapLongKeyLongDoubleValue = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapLongKeyLongDoubleValue);
        CompleteStructMemberSeq member_seq_MapLongKeyLongDoubleValue;
        {
            TypeIdentifierPair type_ids_var_map_long_longdouble;
            ReturnCode_t return_code_var_map_long_longdouble {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_long_longdouble =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_longdouble_unbounded", type_ids_var_map_long_longdouble);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_longdouble)
            {
                return_code_var_map_long_longdouble =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_longdouble", type_ids_var_map_long_longdouble);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_longdouble)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int32_t_longdouble_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_longdouble_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_longdouble, element_identifier_anonymous_map_int32_t_longdouble_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_longdouble_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_longdouble_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_long_longdouble =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_longdouble);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_longdouble)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_longdouble_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_longdouble_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_longdouble, key_identifier_anonymous_map_int32_t_longdouble_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_longdouble_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_longdouble_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_longdouble_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_longdouble_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_longdouble_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_longdouble_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_longdouble_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_longdouble_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_longdouble_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_longdouble_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_longdouble_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_longdouble_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_longdouble_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_longdouble_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_longdouble_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_longdouble_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_longdouble_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_longdouble_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_longdouble_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_longdouble_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_longdouble_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_longdouble_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_longdouble_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_longdouble_unbounded, element_flags_anonymous_map_int32_t_longdouble_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_longdouble_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_longdouble_unbounded), key_flags_anonymous_map_int32_t_longdouble_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_longdouble_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_longdouble_unbounded", type_ids_var_map_long_longdouble))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_longdouble_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_long_longdouble = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_long_longdouble = 0x00000000;
            bool common_var_map_long_longdouble_ec {false};
            CommonStructMember common_var_map_long_longdouble {TypeObjectUtils::build_common_struct_member(member_id_var_map_long_longdouble, member_flags_var_map_long_longdouble, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_longdouble, common_var_map_long_longdouble_ec))};
            if (!common_var_map_long_longdouble_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_long_longdouble member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_long_longdouble = "var_map_long_longdouble";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_long_longdouble;
            ann_custom_MapLongKeyLongDoubleValue.reset();
            CompleteMemberDetail detail_var_map_long_longdouble = TypeObjectUtils::build_complete_member_detail(name_var_map_long_longdouble, member_ann_builtin_var_map_long_longdouble, ann_custom_MapLongKeyLongDoubleValue);
            CompleteStructMember member_var_map_long_longdouble = TypeObjectUtils::build_complete_struct_member(common_var_map_long_longdouble, detail_var_map_long_longdouble);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapLongKeyLongDoubleValue, member_var_map_long_longdouble);
        }
        CompleteStructType struct_type_MapLongKeyLongDoubleValue = TypeObjectUtils::build_complete_struct_type(struct_flags_MapLongKeyLongDoubleValue, header_MapLongKeyLongDoubleValue, member_seq_MapLongKeyLongDoubleValue);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapLongKeyLongDoubleValue, type_name_MapLongKeyLongDoubleValue.to_string(), type_ids_MapLongKeyLongDoubleValue))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapLongKeyLongDoubleValue already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapLongBoolean_type_identifier(
        TypeIdentifierPair& type_ids_MapLongBoolean)
{

    ReturnCode_t return_code_MapLongBoolean {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapLongBoolean =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapLongBoolean", type_ids_MapLongBoolean);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapLongBoolean)
    {
        StructTypeFlag struct_flags_MapLongBoolean = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapLongBoolean = "MapLongBoolean";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapLongBoolean;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapLongBoolean;
        CompleteTypeDetail detail_MapLongBoolean = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapLongBoolean, ann_custom_MapLongBoolean, type_name_MapLongBoolean.to_string());
        CompleteStructHeader header_MapLongBoolean;
        header_MapLongBoolean = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapLongBoolean);
        CompleteStructMemberSeq member_seq_MapLongBoolean;
        {
            TypeIdentifierPair type_ids_var_map_long_boolean;
            ReturnCode_t return_code_var_map_long_boolean {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_long_boolean =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_bool_unbounded", type_ids_var_map_long_boolean);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_boolean)
            {
                return_code_var_map_long_boolean =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_bool", type_ids_var_map_long_boolean);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_boolean)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int32_t_bool_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_bool_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_boolean, element_identifier_anonymous_map_int32_t_bool_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_bool_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_bool_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_long_boolean =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_boolean);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_boolean)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_bool_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_bool_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_boolean, key_identifier_anonymous_map_int32_t_bool_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_bool_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_bool_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_bool_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_bool_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_bool_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_bool_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_bool_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_bool_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_bool_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_bool_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_bool_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_bool_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_bool_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_bool_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_bool_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_bool_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_bool_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_bool_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_bool_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_bool_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_bool_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_bool_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_bool_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_bool_unbounded, element_flags_anonymous_map_int32_t_bool_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_bool_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_bool_unbounded), key_flags_anonymous_map_int32_t_bool_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_bool_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_bool_unbounded", type_ids_var_map_long_boolean))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_bool_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_long_boolean = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_long_boolean = 0x00000000;
            bool common_var_map_long_boolean_ec {false};
            CommonStructMember common_var_map_long_boolean {TypeObjectUtils::build_common_struct_member(member_id_var_map_long_boolean, member_flags_var_map_long_boolean, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_boolean, common_var_map_long_boolean_ec))};
            if (!common_var_map_long_boolean_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_long_boolean member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_long_boolean = "var_map_long_boolean";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_long_boolean;
            ann_custom_MapLongBoolean.reset();
            CompleteMemberDetail detail_var_map_long_boolean = TypeObjectUtils::build_complete_member_detail(name_var_map_long_boolean, member_ann_builtin_var_map_long_boolean, ann_custom_MapLongBoolean);
            CompleteStructMember member_var_map_long_boolean = TypeObjectUtils::build_complete_struct_member(common_var_map_long_boolean, detail_var_map_long_boolean);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapLongBoolean, member_var_map_long_boolean);
        }
        CompleteStructType struct_type_MapLongBoolean = TypeObjectUtils::build_complete_struct_type(struct_flags_MapLongBoolean, header_MapLongBoolean, member_seq_MapLongBoolean);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapLongBoolean, type_name_MapLongBoolean.to_string(), type_ids_MapLongBoolean))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapLongBoolean already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapLongOctet_type_identifier(
        TypeIdentifierPair& type_ids_MapLongOctet)
{

    ReturnCode_t return_code_MapLongOctet {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapLongOctet =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapLongOctet", type_ids_MapLongOctet);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapLongOctet)
    {
        StructTypeFlag struct_flags_MapLongOctet = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapLongOctet = "MapLongOctet";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapLongOctet;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapLongOctet;
        CompleteTypeDetail detail_MapLongOctet = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapLongOctet, ann_custom_MapLongOctet, type_name_MapLongOctet.to_string());
        CompleteStructHeader header_MapLongOctet;
        header_MapLongOctet = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapLongOctet);
        CompleteStructMemberSeq member_seq_MapLongOctet;
        {
            TypeIdentifierPair type_ids_var_map_long_octet;
            ReturnCode_t return_code_var_map_long_octet {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_long_octet =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_byte_unbounded", type_ids_var_map_long_octet);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_octet)
            {
                return_code_var_map_long_octet =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_byte", type_ids_var_map_long_octet);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_octet)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int32_t_byte_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_byte_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_octet, element_identifier_anonymous_map_int32_t_byte_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_byte_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_byte_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_long_octet =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_octet);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_octet)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_byte_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_byte_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_octet, key_identifier_anonymous_map_int32_t_byte_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_byte_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_byte_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_byte_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_byte_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_byte_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_byte_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_byte_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_byte_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_byte_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_byte_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_byte_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_byte_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_byte_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_byte_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_byte_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_byte_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_byte_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_byte_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_byte_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_byte_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_byte_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_byte_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_byte_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_byte_unbounded, element_flags_anonymous_map_int32_t_byte_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_byte_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_byte_unbounded), key_flags_anonymous_map_int32_t_byte_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_byte_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_byte_unbounded", type_ids_var_map_long_octet))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_byte_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_long_octet = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_long_octet = 0x00000000;
            bool common_var_map_long_octet_ec {false};
            CommonStructMember common_var_map_long_octet {TypeObjectUtils::build_common_struct_member(member_id_var_map_long_octet, member_flags_var_map_long_octet, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_octet, common_var_map_long_octet_ec))};
            if (!common_var_map_long_octet_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_long_octet member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_long_octet = "var_map_long_octet";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_long_octet;
            ann_custom_MapLongOctet.reset();
            CompleteMemberDetail detail_var_map_long_octet = TypeObjectUtils::build_complete_member_detail(name_var_map_long_octet, member_ann_builtin_var_map_long_octet, ann_custom_MapLongOctet);
            CompleteStructMember member_var_map_long_octet = TypeObjectUtils::build_complete_struct_member(common_var_map_long_octet, detail_var_map_long_octet);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapLongOctet, member_var_map_long_octet);
        }
        CompleteStructType struct_type_MapLongOctet = TypeObjectUtils::build_complete_struct_type(struct_flags_MapLongOctet, header_MapLongOctet, member_seq_MapLongOctet);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapLongOctet, type_name_MapLongOctet.to_string(), type_ids_MapLongOctet))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapLongOctet already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapLongChar_type_identifier(
        TypeIdentifierPair& type_ids_MapLongChar)
{

    ReturnCode_t return_code_MapLongChar {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapLongChar =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapLongChar", type_ids_MapLongChar);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapLongChar)
    {
        StructTypeFlag struct_flags_MapLongChar = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapLongChar = "MapLongChar";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapLongChar;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapLongChar;
        CompleteTypeDetail detail_MapLongChar = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapLongChar, ann_custom_MapLongChar, type_name_MapLongChar.to_string());
        CompleteStructHeader header_MapLongChar;
        header_MapLongChar = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapLongChar);
        CompleteStructMemberSeq member_seq_MapLongChar;
        {
            TypeIdentifierPair type_ids_var_map_long_char;
            ReturnCode_t return_code_var_map_long_char {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_long_char =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_char_unbounded", type_ids_var_map_long_char);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_char)
            {
                return_code_var_map_long_char =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_char", type_ids_var_map_long_char);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_char)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int32_t_char_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_char_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_char, element_identifier_anonymous_map_int32_t_char_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_char_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_char_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_long_char =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_char);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_char)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_char_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_char_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_char, key_identifier_anonymous_map_int32_t_char_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_char_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_char_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_char_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_char_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_char_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_char_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_char_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_char_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_char_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_char_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_char_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_char_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_char_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_char_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_char_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_char_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_char_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_char_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_char_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_char_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_char_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_char_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_char_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_char_unbounded, element_flags_anonymous_map_int32_t_char_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_char_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_char_unbounded), key_flags_anonymous_map_int32_t_char_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_char_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_char_unbounded", type_ids_var_map_long_char))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_char_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_long_char = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_long_char = 0x00000000;
            bool common_var_map_long_char_ec {false};
            CommonStructMember common_var_map_long_char {TypeObjectUtils::build_common_struct_member(member_id_var_map_long_char, member_flags_var_map_long_char, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_char, common_var_map_long_char_ec))};
            if (!common_var_map_long_char_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_long_char member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_long_char = "var_map_long_char";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_long_char;
            ann_custom_MapLongChar.reset();
            CompleteMemberDetail detail_var_map_long_char = TypeObjectUtils::build_complete_member_detail(name_var_map_long_char, member_ann_builtin_var_map_long_char, ann_custom_MapLongChar);
            CompleteStructMember member_var_map_long_char = TypeObjectUtils::build_complete_struct_member(common_var_map_long_char, detail_var_map_long_char);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapLongChar, member_var_map_long_char);
        }
        CompleteStructType struct_type_MapLongChar = TypeObjectUtils::build_complete_struct_type(struct_flags_MapLongChar, header_MapLongChar, member_seq_MapLongChar);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapLongChar, type_name_MapLongChar.to_string(), type_ids_MapLongChar))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapLongChar already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapLongWChar_type_identifier(
        TypeIdentifierPair& type_ids_MapLongWChar)
{

    ReturnCode_t return_code_MapLongWChar {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapLongWChar =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapLongWChar", type_ids_MapLongWChar);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapLongWChar)
    {
        StructTypeFlag struct_flags_MapLongWChar = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapLongWChar = "MapLongWChar";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapLongWChar;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapLongWChar;
        CompleteTypeDetail detail_MapLongWChar = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapLongWChar, ann_custom_MapLongWChar, type_name_MapLongWChar.to_string());
        CompleteStructHeader header_MapLongWChar;
        header_MapLongWChar = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapLongWChar);
        CompleteStructMemberSeq member_seq_MapLongWChar;
        {
            TypeIdentifierPair type_ids_var_map_long_wchar;
            ReturnCode_t return_code_var_map_long_wchar {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_long_wchar =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_wchar_t_unbounded", type_ids_var_map_long_wchar);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_wchar)
            {
                return_code_var_map_long_wchar =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_wchar_t", type_ids_var_map_long_wchar);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_wchar)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_int32_t_wchar_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_wchar_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_wchar, element_identifier_anonymous_map_int32_t_wchar_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_wchar_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_wchar_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_long_wchar =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_wchar);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_wchar)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_wchar_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_wchar_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_wchar, key_identifier_anonymous_map_int32_t_wchar_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_wchar_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_wchar_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_wchar_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_wchar_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_wchar_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_wchar_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_wchar_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_wchar_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_wchar_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_wchar_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_wchar_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_wchar_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_wchar_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_wchar_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_wchar_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_wchar_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_wchar_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_wchar_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_wchar_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_wchar_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_wchar_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_wchar_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_wchar_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_wchar_t_unbounded, element_flags_anonymous_map_int32_t_wchar_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_wchar_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_wchar_t_unbounded), key_flags_anonymous_map_int32_t_wchar_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_wchar_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_wchar_t_unbounded", type_ids_var_map_long_wchar))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_wchar_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_long_wchar = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_long_wchar = 0x00000000;
            bool common_var_map_long_wchar_ec {false};
            CommonStructMember common_var_map_long_wchar {TypeObjectUtils::build_common_struct_member(member_id_var_map_long_wchar, member_flags_var_map_long_wchar, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_wchar, common_var_map_long_wchar_ec))};
            if (!common_var_map_long_wchar_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_long_wchar member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_long_wchar = "var_map_long_wchar";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_long_wchar;
            ann_custom_MapLongWChar.reset();
            CompleteMemberDetail detail_var_map_long_wchar = TypeObjectUtils::build_complete_member_detail(name_var_map_long_wchar, member_ann_builtin_var_map_long_wchar, ann_custom_MapLongWChar);
            CompleteStructMember member_var_map_long_wchar = TypeObjectUtils::build_complete_struct_member(common_var_map_long_wchar, detail_var_map_long_wchar);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapLongWChar, member_var_map_long_wchar);
        }
        CompleteStructType struct_type_MapLongWChar = TypeObjectUtils::build_complete_struct_type(struct_flags_MapLongWChar, header_MapLongWChar, member_seq_MapLongWChar);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapLongWChar, type_name_MapLongWChar.to_string(), type_ids_MapLongWChar))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapLongWChar already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapLongString_type_identifier(
        TypeIdentifierPair& type_ids_MapLongString)
{

    ReturnCode_t return_code_MapLongString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapLongString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapLongString", type_ids_MapLongString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapLongString)
    {
        StructTypeFlag struct_flags_MapLongString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapLongString = "MapLongString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapLongString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapLongString;
        CompleteTypeDetail detail_MapLongString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapLongString, ann_custom_MapLongString, type_name_MapLongString.to_string());
        CompleteStructHeader header_MapLongString;
        header_MapLongString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapLongString);
        CompleteStructMemberSeq member_seq_MapLongString;
        {
            TypeIdentifierPair type_ids_var_map_long_string;
            ReturnCode_t return_code_var_map_long_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_long_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_anonymous_string_unbounded_unbounded", type_ids_var_map_long_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_string)
            {
                return_code_var_map_long_string =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_string_unbounded", type_ids_var_map_long_string);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_string)
                {
                    {
                        SBound bound = 0;
                        StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                                "anonymous_string_unbounded", type_ids_var_map_long_string))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_map_int32_t_anonymous_string_unbounded_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_anonymous_string_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_string, element_identifier_anonymous_map_int32_t_anonymous_string_unbounded_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_anonymous_string_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_anonymous_string_unbounded_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_long_string =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_string);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_string)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_anonymous_string_unbounded_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_anonymous_string_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_string, key_identifier_anonymous_map_int32_t_anonymous_string_unbounded_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_anonymous_string_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_anonymous_string_unbounded_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_anonymous_string_unbounded_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_anonymous_string_unbounded_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_string_unbounded_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_anonymous_string_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_string_unbounded_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_anonymous_string_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_string_unbounded_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_anonymous_string_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_string_unbounded_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_anonymous_string_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_string_unbounded_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_anonymous_string_unbounded_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_string_unbounded_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_string_unbounded_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_anonymous_string_unbounded_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_string_unbounded_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_string_unbounded_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_anonymous_string_unbounded_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_anonymous_string_unbounded_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_anonymous_string_unbounded_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_anonymous_string_unbounded_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_anonymous_string_unbounded_unbounded, element_flags_anonymous_map_int32_t_anonymous_string_unbounded_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_anonymous_string_unbounded_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_anonymous_string_unbounded_unbounded), key_flags_anonymous_map_int32_t_anonymous_string_unbounded_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_anonymous_string_unbounded_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_anonymous_string_unbounded_unbounded", type_ids_var_map_long_string))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_anonymous_string_unbounded_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_long_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_long_string = 0x00000000;
            bool common_var_map_long_string_ec {false};
            CommonStructMember common_var_map_long_string {TypeObjectUtils::build_common_struct_member(member_id_var_map_long_string, member_flags_var_map_long_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_string, common_var_map_long_string_ec))};
            if (!common_var_map_long_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_long_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_long_string = "var_map_long_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_long_string;
            ann_custom_MapLongString.reset();
            CompleteMemberDetail detail_var_map_long_string = TypeObjectUtils::build_complete_member_detail(name_var_map_long_string, member_ann_builtin_var_map_long_string, ann_custom_MapLongString);
            CompleteStructMember member_var_map_long_string = TypeObjectUtils::build_complete_struct_member(common_var_map_long_string, detail_var_map_long_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapLongString, member_var_map_long_string);
        }
        CompleteStructType struct_type_MapLongString = TypeObjectUtils::build_complete_struct_type(struct_flags_MapLongString, header_MapLongString, member_seq_MapLongString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapLongString, type_name_MapLongString.to_string(), type_ids_MapLongString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapLongString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapLongWString_type_identifier(
        TypeIdentifierPair& type_ids_MapLongWString)
{

    ReturnCode_t return_code_MapLongWString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapLongWString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapLongWString", type_ids_MapLongWString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapLongWString)
    {
        StructTypeFlag struct_flags_MapLongWString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapLongWString = "MapLongWString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapLongWString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapLongWString;
        CompleteTypeDetail detail_MapLongWString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapLongWString, ann_custom_MapLongWString, type_name_MapLongWString.to_string());
        CompleteStructHeader header_MapLongWString;
        header_MapLongWString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapLongWString);
        CompleteStructMemberSeq member_seq_MapLongWString;
        {
            TypeIdentifierPair type_ids_var_map_long_wstring;
            ReturnCode_t return_code_var_map_long_wstring {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_long_wstring =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded", type_ids_var_map_long_wstring);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_wstring)
            {
                return_code_var_map_long_wstring =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_wstring_unbounded", type_ids_var_map_long_wstring);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_wstring)
                {
                    {
                        SBound bound = 0;
                        StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                                "anonymous_wstring_unbounded", type_ids_var_map_long_wstring, true))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_wstring_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_wstring, element_identifier_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_long_wstring =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_wstring);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_wstring)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_wstring, key_identifier_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded, element_flags_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded), key_flags_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded", type_ids_var_map_long_wstring))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_anonymous_wstring_unbounded_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_long_wstring = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_long_wstring = 0x00000000;
            bool common_var_map_long_wstring_ec {false};
            CommonStructMember common_var_map_long_wstring {TypeObjectUtils::build_common_struct_member(member_id_var_map_long_wstring, member_flags_var_map_long_wstring, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_wstring, common_var_map_long_wstring_ec))};
            if (!common_var_map_long_wstring_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_long_wstring member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_long_wstring = "var_map_long_wstring";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_long_wstring;
            ann_custom_MapLongWString.reset();
            CompleteMemberDetail detail_var_map_long_wstring = TypeObjectUtils::build_complete_member_detail(name_var_map_long_wstring, member_ann_builtin_var_map_long_wstring, ann_custom_MapLongWString);
            CompleteStructMember member_var_map_long_wstring = TypeObjectUtils::build_complete_struct_member(common_var_map_long_wstring, detail_var_map_long_wstring);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapLongWString, member_var_map_long_wstring);
        }
        CompleteStructType struct_type_MapLongWString = TypeObjectUtils::build_complete_struct_type(struct_flags_MapLongWString, header_MapLongWString, member_seq_MapLongWString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapLongWString, type_name_MapLongWString.to_string(), type_ids_MapLongWString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapLongWString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapLongInnerAliasBoundedStringHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapLongInnerAliasBoundedStringHelper)
{

    ReturnCode_t return_code_MapLongInnerAliasBoundedStringHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapLongInnerAliasBoundedStringHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapLongInnerAliasBoundedStringHelper", type_ids_MapLongInnerAliasBoundedStringHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapLongInnerAliasBoundedStringHelper)
    {
        StructTypeFlag struct_flags_MapLongInnerAliasBoundedStringHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapLongInnerAliasBoundedStringHelper = "MapLongInnerAliasBoundedStringHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapLongInnerAliasBoundedStringHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapLongInnerAliasBoundedStringHelper;
        CompleteTypeDetail detail_MapLongInnerAliasBoundedStringHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapLongInnerAliasBoundedStringHelper, ann_custom_MapLongInnerAliasBoundedStringHelper, type_name_MapLongInnerAliasBoundedStringHelper.to_string());
        CompleteStructHeader header_MapLongInnerAliasBoundedStringHelper;
        header_MapLongInnerAliasBoundedStringHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapLongInnerAliasBoundedStringHelper);
        CompleteStructMemberSeq member_seq_MapLongInnerAliasBoundedStringHelper;
        {
            TypeIdentifierPair type_ids_var_map_long_inneraliasboundedstringhelper;
            ReturnCode_t return_code_var_map_long_inneraliasboundedstringhelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_long_inneraliasboundedstringhelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_anonymous_string_10_unbounded", type_ids_var_map_long_inneraliasboundedstringhelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_inneraliasboundedstringhelper)
            {
                return_code_var_map_long_inneraliasboundedstringhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_bounded_string_helper", type_ids_var_map_long_inneraliasboundedstringhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_inneraliasboundedstringhelper)
                {
                ::register_Inner_alias_bounded_string_helper_type_identifier(type_ids_var_map_long_inneraliasboundedstringhelper);
                }
                bool element_identifier_anonymous_map_int32_t_anonymous_string_10_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_anonymous_string_10_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_inneraliasboundedstringhelper, element_identifier_anonymous_map_int32_t_anonymous_string_10_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_anonymous_string_10_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_anonymous_string_10_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_long_inneraliasboundedstringhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_inneraliasboundedstringhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_inneraliasboundedstringhelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_anonymous_string_10_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_anonymous_string_10_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_inneraliasboundedstringhelper, key_identifier_anonymous_map_int32_t_anonymous_string_10_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_anonymous_string_10_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_anonymous_string_10_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_anonymous_string_10_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_anonymous_string_10_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_string_10_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_anonymous_string_10_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_string_10_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_anonymous_string_10_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_string_10_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_anonymous_string_10_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_string_10_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_anonymous_string_10_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_string_10_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_anonymous_string_10_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_string_10_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_string_10_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_anonymous_string_10_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_string_10_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_string_10_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_anonymous_string_10_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_anonymous_string_10_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_anonymous_string_10_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_anonymous_string_10_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_anonymous_string_10_unbounded, element_flags_anonymous_map_int32_t_anonymous_string_10_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_anonymous_string_10_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_anonymous_string_10_unbounded), key_flags_anonymous_map_int32_t_anonymous_string_10_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_anonymous_string_10_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_anonymous_string_10_unbounded", type_ids_var_map_long_inneraliasboundedstringhelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_anonymous_string_10_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_long_inneraliasboundedstringhelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_long_inneraliasboundedstringhelper = 0x00000000;
            bool common_var_map_long_inneraliasboundedstringhelper_ec {false};
            CommonStructMember common_var_map_long_inneraliasboundedstringhelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_long_inneraliasboundedstringhelper, member_flags_var_map_long_inneraliasboundedstringhelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_inneraliasboundedstringhelper, common_var_map_long_inneraliasboundedstringhelper_ec))};
            if (!common_var_map_long_inneraliasboundedstringhelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_long_inneraliasboundedstringhelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_long_inneraliasboundedstringhelper = "var_map_long_inneraliasboundedstringhelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_long_inneraliasboundedstringhelper;
            ann_custom_MapLongInnerAliasBoundedStringHelper.reset();
            CompleteMemberDetail detail_var_map_long_inneraliasboundedstringhelper = TypeObjectUtils::build_complete_member_detail(name_var_map_long_inneraliasboundedstringhelper, member_ann_builtin_var_map_long_inneraliasboundedstringhelper, ann_custom_MapLongInnerAliasBoundedStringHelper);
            CompleteStructMember member_var_map_long_inneraliasboundedstringhelper = TypeObjectUtils::build_complete_struct_member(common_var_map_long_inneraliasboundedstringhelper, detail_var_map_long_inneraliasboundedstringhelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapLongInnerAliasBoundedStringHelper, member_var_map_long_inneraliasboundedstringhelper);
        }
        CompleteStructType struct_type_MapLongInnerAliasBoundedStringHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapLongInnerAliasBoundedStringHelper, header_MapLongInnerAliasBoundedStringHelper, member_seq_MapLongInnerAliasBoundedStringHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapLongInnerAliasBoundedStringHelper, type_name_MapLongInnerAliasBoundedStringHelper.to_string(), type_ids_MapLongInnerAliasBoundedStringHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapLongInnerAliasBoundedStringHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapLongInnerAliasBoundedWStringHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapLongInnerAliasBoundedWStringHelper)
{

    ReturnCode_t return_code_MapLongInnerAliasBoundedWStringHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapLongInnerAliasBoundedWStringHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapLongInnerAliasBoundedWStringHelper", type_ids_MapLongInnerAliasBoundedWStringHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapLongInnerAliasBoundedWStringHelper)
    {
        StructTypeFlag struct_flags_MapLongInnerAliasBoundedWStringHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapLongInnerAliasBoundedWStringHelper = "MapLongInnerAliasBoundedWStringHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapLongInnerAliasBoundedWStringHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapLongInnerAliasBoundedWStringHelper;
        CompleteTypeDetail detail_MapLongInnerAliasBoundedWStringHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapLongInnerAliasBoundedWStringHelper, ann_custom_MapLongInnerAliasBoundedWStringHelper, type_name_MapLongInnerAliasBoundedWStringHelper.to_string());
        CompleteStructHeader header_MapLongInnerAliasBoundedWStringHelper;
        header_MapLongInnerAliasBoundedWStringHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapLongInnerAliasBoundedWStringHelper);
        CompleteStructMemberSeq member_seq_MapLongInnerAliasBoundedWStringHelper;
        {
            TypeIdentifierPair type_ids_var_map_long_inneraliasboundedwstringhelper;
            ReturnCode_t return_code_var_map_long_inneraliasboundedwstringhelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_long_inneraliasboundedwstringhelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_anonymous_wstring_10_unbounded", type_ids_var_map_long_inneraliasboundedwstringhelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_inneraliasboundedwstringhelper)
            {
                return_code_var_map_long_inneraliasboundedwstringhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_bounded_wstring_helper", type_ids_var_map_long_inneraliasboundedwstringhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_inneraliasboundedwstringhelper)
                {
                ::register_Inner_alias_bounded_wstring_helper_type_identifier(type_ids_var_map_long_inneraliasboundedwstringhelper);
                }
                bool element_identifier_anonymous_map_int32_t_anonymous_wstring_10_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_anonymous_wstring_10_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_inneraliasboundedwstringhelper, element_identifier_anonymous_map_int32_t_anonymous_wstring_10_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_anonymous_wstring_10_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_anonymous_wstring_10_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_long_inneraliasboundedwstringhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_inneraliasboundedwstringhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_inneraliasboundedwstringhelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_anonymous_wstring_10_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_anonymous_wstring_10_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_inneraliasboundedwstringhelper, key_identifier_anonymous_map_int32_t_anonymous_wstring_10_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_anonymous_wstring_10_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_anonymous_wstring_10_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_anonymous_wstring_10_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_anonymous_wstring_10_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_wstring_10_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_anonymous_wstring_10_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_wstring_10_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_anonymous_wstring_10_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_wstring_10_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_anonymous_wstring_10_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_wstring_10_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_anonymous_wstring_10_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_wstring_10_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_anonymous_wstring_10_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_wstring_10_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_wstring_10_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_anonymous_wstring_10_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_wstring_10_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_wstring_10_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_anonymous_wstring_10_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_anonymous_wstring_10_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_anonymous_wstring_10_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_anonymous_wstring_10_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_anonymous_wstring_10_unbounded, element_flags_anonymous_map_int32_t_anonymous_wstring_10_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_anonymous_wstring_10_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_anonymous_wstring_10_unbounded), key_flags_anonymous_map_int32_t_anonymous_wstring_10_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_anonymous_wstring_10_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_anonymous_wstring_10_unbounded", type_ids_var_map_long_inneraliasboundedwstringhelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_anonymous_wstring_10_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_long_inneraliasboundedwstringhelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_long_inneraliasboundedwstringhelper = 0x00000000;
            bool common_var_map_long_inneraliasboundedwstringhelper_ec {false};
            CommonStructMember common_var_map_long_inneraliasboundedwstringhelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_long_inneraliasboundedwstringhelper, member_flags_var_map_long_inneraliasboundedwstringhelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_inneraliasboundedwstringhelper, common_var_map_long_inneraliasboundedwstringhelper_ec))};
            if (!common_var_map_long_inneraliasboundedwstringhelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_long_inneraliasboundedwstringhelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_long_inneraliasboundedwstringhelper = "var_map_long_inneraliasboundedwstringhelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_long_inneraliasboundedwstringhelper;
            ann_custom_MapLongInnerAliasBoundedWStringHelper.reset();
            CompleteMemberDetail detail_var_map_long_inneraliasboundedwstringhelper = TypeObjectUtils::build_complete_member_detail(name_var_map_long_inneraliasboundedwstringhelper, member_ann_builtin_var_map_long_inneraliasboundedwstringhelper, ann_custom_MapLongInnerAliasBoundedWStringHelper);
            CompleteStructMember member_var_map_long_inneraliasboundedwstringhelper = TypeObjectUtils::build_complete_struct_member(common_var_map_long_inneraliasboundedwstringhelper, detail_var_map_long_inneraliasboundedwstringhelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapLongInnerAliasBoundedWStringHelper, member_var_map_long_inneraliasboundedwstringhelper);
        }
        CompleteStructType struct_type_MapLongInnerAliasBoundedWStringHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapLongInnerAliasBoundedWStringHelper, header_MapLongInnerAliasBoundedWStringHelper, member_seq_MapLongInnerAliasBoundedWStringHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapLongInnerAliasBoundedWStringHelper, type_name_MapLongInnerAliasBoundedWStringHelper.to_string(), type_ids_MapLongInnerAliasBoundedWStringHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapLongInnerAliasBoundedWStringHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapLongInnerEnumHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapLongInnerEnumHelper)
{

    ReturnCode_t return_code_MapLongInnerEnumHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapLongInnerEnumHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapLongInnerEnumHelper", type_ids_MapLongInnerEnumHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapLongInnerEnumHelper)
    {
        StructTypeFlag struct_flags_MapLongInnerEnumHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapLongInnerEnumHelper = "MapLongInnerEnumHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapLongInnerEnumHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapLongInnerEnumHelper;
        CompleteTypeDetail detail_MapLongInnerEnumHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapLongInnerEnumHelper, ann_custom_MapLongInnerEnumHelper, type_name_MapLongInnerEnumHelper.to_string());
        CompleteStructHeader header_MapLongInnerEnumHelper;
        header_MapLongInnerEnumHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapLongInnerEnumHelper);
        CompleteStructMemberSeq member_seq_MapLongInnerEnumHelper;
        {
            TypeIdentifierPair type_ids_var_map_long_innerenumhelper;
            ReturnCode_t return_code_var_map_long_innerenumhelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_long_innerenumhelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_InnerEnumHelper_unbounded", type_ids_var_map_long_innerenumhelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_innerenumhelper)
            {
                return_code_var_map_long_innerenumhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerEnumHelper", type_ids_var_map_long_innerenumhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_innerenumhelper)
                {
                ::register_InnerEnumHelper_type_identifier(type_ids_var_map_long_innerenumhelper);
                }
                bool element_identifier_anonymous_map_int32_t_InnerEnumHelper_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_InnerEnumHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_innerenumhelper, element_identifier_anonymous_map_int32_t_InnerEnumHelper_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_InnerEnumHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_InnerEnumHelper_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_long_innerenumhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_innerenumhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_innerenumhelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_InnerEnumHelper_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_InnerEnumHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_innerenumhelper, key_identifier_anonymous_map_int32_t_InnerEnumHelper_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_InnerEnumHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_InnerEnumHelper_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_InnerEnumHelper_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_InnerEnumHelper_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerEnumHelper_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_InnerEnumHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerEnumHelper_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_InnerEnumHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerEnumHelper_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_InnerEnumHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerEnumHelper_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_InnerEnumHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerEnumHelper_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_InnerEnumHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerEnumHelper_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerEnumHelper_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_InnerEnumHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerEnumHelper_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerEnumHelper_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_InnerEnumHelper_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_InnerEnumHelper_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_InnerEnumHelper_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_InnerEnumHelper_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_InnerEnumHelper_unbounded, element_flags_anonymous_map_int32_t_InnerEnumHelper_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_InnerEnumHelper_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_InnerEnumHelper_unbounded), key_flags_anonymous_map_int32_t_InnerEnumHelper_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_InnerEnumHelper_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_InnerEnumHelper_unbounded", type_ids_var_map_long_innerenumhelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_InnerEnumHelper_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_long_innerenumhelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_long_innerenumhelper = 0x00000000;
            bool common_var_map_long_innerenumhelper_ec {false};
            CommonStructMember common_var_map_long_innerenumhelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_long_innerenumhelper, member_flags_var_map_long_innerenumhelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_innerenumhelper, common_var_map_long_innerenumhelper_ec))};
            if (!common_var_map_long_innerenumhelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_long_innerenumhelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_long_innerenumhelper = "var_map_long_innerenumhelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_long_innerenumhelper;
            ann_custom_MapLongInnerEnumHelper.reset();
            CompleteMemberDetail detail_var_map_long_innerenumhelper = TypeObjectUtils::build_complete_member_detail(name_var_map_long_innerenumhelper, member_ann_builtin_var_map_long_innerenumhelper, ann_custom_MapLongInnerEnumHelper);
            CompleteStructMember member_var_map_long_innerenumhelper = TypeObjectUtils::build_complete_struct_member(common_var_map_long_innerenumhelper, detail_var_map_long_innerenumhelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapLongInnerEnumHelper, member_var_map_long_innerenumhelper);
        }
        CompleteStructType struct_type_MapLongInnerEnumHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapLongInnerEnumHelper, header_MapLongInnerEnumHelper, member_seq_MapLongInnerEnumHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapLongInnerEnumHelper, type_name_MapLongInnerEnumHelper.to_string(), type_ids_MapLongInnerEnumHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapLongInnerEnumHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapLongInnerBitMaskHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapLongInnerBitMaskHelper)
{

    ReturnCode_t return_code_MapLongInnerBitMaskHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapLongInnerBitMaskHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapLongInnerBitMaskHelper", type_ids_MapLongInnerBitMaskHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapLongInnerBitMaskHelper)
    {
        StructTypeFlag struct_flags_MapLongInnerBitMaskHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapLongInnerBitMaskHelper = "MapLongInnerBitMaskHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapLongInnerBitMaskHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapLongInnerBitMaskHelper;
        CompleteTypeDetail detail_MapLongInnerBitMaskHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapLongInnerBitMaskHelper, ann_custom_MapLongInnerBitMaskHelper, type_name_MapLongInnerBitMaskHelper.to_string());
        CompleteStructHeader header_MapLongInnerBitMaskHelper;
        header_MapLongInnerBitMaskHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapLongInnerBitMaskHelper);
        CompleteStructMemberSeq member_seq_MapLongInnerBitMaskHelper;
        {
            TypeIdentifierPair type_ids_var_map_long_innerbitmaskhelper;
            ReturnCode_t return_code_var_map_long_innerbitmaskhelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_long_innerbitmaskhelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_InnerBitMaskHelper_unbounded", type_ids_var_map_long_innerbitmaskhelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_innerbitmaskhelper)
            {
                return_code_var_map_long_innerbitmaskhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerBitMaskHelper", type_ids_var_map_long_innerbitmaskhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_innerbitmaskhelper)
                {
                ::register_InnerBitMaskHelper_type_identifier(type_ids_var_map_long_innerbitmaskhelper);
                }
                bool element_identifier_anonymous_map_int32_t_InnerBitMaskHelper_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_InnerBitMaskHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_innerbitmaskhelper, element_identifier_anonymous_map_int32_t_InnerBitMaskHelper_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_InnerBitMaskHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_InnerBitMaskHelper_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_long_innerbitmaskhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_innerbitmaskhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_innerbitmaskhelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_InnerBitMaskHelper_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_InnerBitMaskHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_innerbitmaskhelper, key_identifier_anonymous_map_int32_t_InnerBitMaskHelper_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_InnerBitMaskHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_InnerBitMaskHelper_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_InnerBitMaskHelper_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_InnerBitMaskHelper_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerBitMaskHelper_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_InnerBitMaskHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerBitMaskHelper_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_InnerBitMaskHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerBitMaskHelper_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_InnerBitMaskHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerBitMaskHelper_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_InnerBitMaskHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerBitMaskHelper_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_InnerBitMaskHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerBitMaskHelper_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerBitMaskHelper_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_InnerBitMaskHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerBitMaskHelper_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerBitMaskHelper_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_InnerBitMaskHelper_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_InnerBitMaskHelper_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_InnerBitMaskHelper_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_InnerBitMaskHelper_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_InnerBitMaskHelper_unbounded, element_flags_anonymous_map_int32_t_InnerBitMaskHelper_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_InnerBitMaskHelper_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_InnerBitMaskHelper_unbounded), key_flags_anonymous_map_int32_t_InnerBitMaskHelper_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_InnerBitMaskHelper_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_InnerBitMaskHelper_unbounded", type_ids_var_map_long_innerbitmaskhelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_InnerBitMaskHelper_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_long_innerbitmaskhelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_long_innerbitmaskhelper = 0x00000000;
            bool common_var_map_long_innerbitmaskhelper_ec {false};
            CommonStructMember common_var_map_long_innerbitmaskhelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_long_innerbitmaskhelper, member_flags_var_map_long_innerbitmaskhelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_innerbitmaskhelper, common_var_map_long_innerbitmaskhelper_ec))};
            if (!common_var_map_long_innerbitmaskhelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_long_innerbitmaskhelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_long_innerbitmaskhelper = "var_map_long_innerbitmaskhelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_long_innerbitmaskhelper;
            ann_custom_MapLongInnerBitMaskHelper.reset();
            CompleteMemberDetail detail_var_map_long_innerbitmaskhelper = TypeObjectUtils::build_complete_member_detail(name_var_map_long_innerbitmaskhelper, member_ann_builtin_var_map_long_innerbitmaskhelper, ann_custom_MapLongInnerBitMaskHelper);
            CompleteStructMember member_var_map_long_innerbitmaskhelper = TypeObjectUtils::build_complete_struct_member(common_var_map_long_innerbitmaskhelper, detail_var_map_long_innerbitmaskhelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapLongInnerBitMaskHelper, member_var_map_long_innerbitmaskhelper);
        }
        CompleteStructType struct_type_MapLongInnerBitMaskHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapLongInnerBitMaskHelper, header_MapLongInnerBitMaskHelper, member_seq_MapLongInnerBitMaskHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapLongInnerBitMaskHelper, type_name_MapLongInnerBitMaskHelper.to_string(), type_ids_MapLongInnerBitMaskHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapLongInnerBitMaskHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapLongInnerAliasHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapLongInnerAliasHelper)
{

    ReturnCode_t return_code_MapLongInnerAliasHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapLongInnerAliasHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapLongInnerAliasHelper", type_ids_MapLongInnerAliasHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapLongInnerAliasHelper)
    {
        StructTypeFlag struct_flags_MapLongInnerAliasHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapLongInnerAliasHelper = "MapLongInnerAliasHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapLongInnerAliasHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapLongInnerAliasHelper;
        CompleteTypeDetail detail_MapLongInnerAliasHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapLongInnerAliasHelper, ann_custom_MapLongInnerAliasHelper, type_name_MapLongInnerAliasHelper.to_string());
        CompleteStructHeader header_MapLongInnerAliasHelper;
        header_MapLongInnerAliasHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapLongInnerAliasHelper);
        CompleteStructMemberSeq member_seq_MapLongInnerAliasHelper;
        {
            TypeIdentifierPair type_ids_var_map_long_inneraliashelper;
            ReturnCode_t return_code_var_map_long_inneraliashelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_long_inneraliashelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_InnerAliasHelper_unbounded", type_ids_var_map_long_inneraliashelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_inneraliashelper)
            {
                return_code_var_map_long_inneraliashelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerAliasHelper", type_ids_var_map_long_inneraliashelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_inneraliashelper)
                {
                ::register_InnerAliasHelper_type_identifier(type_ids_var_map_long_inneraliashelper);
                }
                bool element_identifier_anonymous_map_int32_t_InnerAliasHelper_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_InnerAliasHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_inneraliashelper, element_identifier_anonymous_map_int32_t_InnerAliasHelper_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_InnerAliasHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_InnerAliasHelper_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_long_inneraliashelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_inneraliashelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_inneraliashelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_InnerAliasHelper_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_InnerAliasHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_inneraliashelper, key_identifier_anonymous_map_int32_t_InnerAliasHelper_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_InnerAliasHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_InnerAliasHelper_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_InnerAliasHelper_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_InnerAliasHelper_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerAliasHelper_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_InnerAliasHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerAliasHelper_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_InnerAliasHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerAliasHelper_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_InnerAliasHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerAliasHelper_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_InnerAliasHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerAliasHelper_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_InnerAliasHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerAliasHelper_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerAliasHelper_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_InnerAliasHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerAliasHelper_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerAliasHelper_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_InnerAliasHelper_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_InnerAliasHelper_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_InnerAliasHelper_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_InnerAliasHelper_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_InnerAliasHelper_unbounded, element_flags_anonymous_map_int32_t_InnerAliasHelper_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_InnerAliasHelper_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_InnerAliasHelper_unbounded), key_flags_anonymous_map_int32_t_InnerAliasHelper_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_InnerAliasHelper_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_InnerAliasHelper_unbounded", type_ids_var_map_long_inneraliashelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_InnerAliasHelper_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_long_inneraliashelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_long_inneraliashelper = 0x00000000;
            bool common_var_map_long_inneraliashelper_ec {false};
            CommonStructMember common_var_map_long_inneraliashelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_long_inneraliashelper, member_flags_var_map_long_inneraliashelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_inneraliashelper, common_var_map_long_inneraliashelper_ec))};
            if (!common_var_map_long_inneraliashelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_long_inneraliashelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_long_inneraliashelper = "var_map_long_inneraliashelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_long_inneraliashelper;
            ann_custom_MapLongInnerAliasHelper.reset();
            CompleteMemberDetail detail_var_map_long_inneraliashelper = TypeObjectUtils::build_complete_member_detail(name_var_map_long_inneraliashelper, member_ann_builtin_var_map_long_inneraliashelper, ann_custom_MapLongInnerAliasHelper);
            CompleteStructMember member_var_map_long_inneraliashelper = TypeObjectUtils::build_complete_struct_member(common_var_map_long_inneraliashelper, detail_var_map_long_inneraliashelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapLongInnerAliasHelper, member_var_map_long_inneraliashelper);
        }
        CompleteStructType struct_type_MapLongInnerAliasHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapLongInnerAliasHelper, header_MapLongInnerAliasHelper, member_seq_MapLongInnerAliasHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapLongInnerAliasHelper, type_name_MapLongInnerAliasHelper.to_string(), type_ids_MapLongInnerAliasHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapLongInnerAliasHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapLongInnerAliasArrayHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapLongInnerAliasArrayHelper)
{

    ReturnCode_t return_code_MapLongInnerAliasArrayHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapLongInnerAliasArrayHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapLongInnerAliasArrayHelper", type_ids_MapLongInnerAliasArrayHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapLongInnerAliasArrayHelper)
    {
        StructTypeFlag struct_flags_MapLongInnerAliasArrayHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapLongInnerAliasArrayHelper = "MapLongInnerAliasArrayHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapLongInnerAliasArrayHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapLongInnerAliasArrayHelper;
        CompleteTypeDetail detail_MapLongInnerAliasArrayHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapLongInnerAliasArrayHelper, ann_custom_MapLongInnerAliasArrayHelper, type_name_MapLongInnerAliasArrayHelper.to_string());
        CompleteStructHeader header_MapLongInnerAliasArrayHelper;
        header_MapLongInnerAliasArrayHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapLongInnerAliasArrayHelper);
        CompleteStructMemberSeq member_seq_MapLongInnerAliasArrayHelper;
        {
            TypeIdentifierPair type_ids_var_map_long_inneraliasarrayhelper;
            ReturnCode_t return_code_var_map_long_inneraliasarrayhelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_long_inneraliasarrayhelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded", type_ids_var_map_long_inneraliasarrayhelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_inneraliasarrayhelper)
            {
                return_code_var_map_long_inneraliasarrayhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_array_helper", type_ids_var_map_long_inneraliasarrayhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_inneraliasarrayhelper)
                {
                ::register_Inner_alias_array_helper_type_identifier(type_ids_var_map_long_inneraliasarrayhelper);
                }
                bool element_identifier_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_inneraliasarrayhelper, element_identifier_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_long_inneraliasarrayhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_inneraliasarrayhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_inneraliasarrayhelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_inneraliasarrayhelper, key_identifier_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded, element_flags_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded), key_flags_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded", type_ids_var_map_long_inneraliasarrayhelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_anonymous_array_int16_t_2_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_long_inneraliasarrayhelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_long_inneraliasarrayhelper = 0x00000000;
            bool common_var_map_long_inneraliasarrayhelper_ec {false};
            CommonStructMember common_var_map_long_inneraliasarrayhelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_long_inneraliasarrayhelper, member_flags_var_map_long_inneraliasarrayhelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_inneraliasarrayhelper, common_var_map_long_inneraliasarrayhelper_ec))};
            if (!common_var_map_long_inneraliasarrayhelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_long_inneraliasarrayhelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_long_inneraliasarrayhelper = "var_map_long_inneraliasarrayhelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_long_inneraliasarrayhelper;
            ann_custom_MapLongInnerAliasArrayHelper.reset();
            CompleteMemberDetail detail_var_map_long_inneraliasarrayhelper = TypeObjectUtils::build_complete_member_detail(name_var_map_long_inneraliasarrayhelper, member_ann_builtin_var_map_long_inneraliasarrayhelper, ann_custom_MapLongInnerAliasArrayHelper);
            CompleteStructMember member_var_map_long_inneraliasarrayhelper = TypeObjectUtils::build_complete_struct_member(common_var_map_long_inneraliasarrayhelper, detail_var_map_long_inneraliasarrayhelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapLongInnerAliasArrayHelper, member_var_map_long_inneraliasarrayhelper);
        }
        CompleteStructType struct_type_MapLongInnerAliasArrayHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapLongInnerAliasArrayHelper, header_MapLongInnerAliasArrayHelper, member_seq_MapLongInnerAliasArrayHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapLongInnerAliasArrayHelper, type_name_MapLongInnerAliasArrayHelper.to_string(), type_ids_MapLongInnerAliasArrayHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapLongInnerAliasArrayHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapLongInnerAliasSequenceHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapLongInnerAliasSequenceHelper)
{

    ReturnCode_t return_code_MapLongInnerAliasSequenceHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapLongInnerAliasSequenceHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapLongInnerAliasSequenceHelper", type_ids_MapLongInnerAliasSequenceHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapLongInnerAliasSequenceHelper)
    {
        StructTypeFlag struct_flags_MapLongInnerAliasSequenceHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapLongInnerAliasSequenceHelper = "MapLongInnerAliasSequenceHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapLongInnerAliasSequenceHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapLongInnerAliasSequenceHelper;
        CompleteTypeDetail detail_MapLongInnerAliasSequenceHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapLongInnerAliasSequenceHelper, ann_custom_MapLongInnerAliasSequenceHelper, type_name_MapLongInnerAliasSequenceHelper.to_string());
        CompleteStructHeader header_MapLongInnerAliasSequenceHelper;
        header_MapLongInnerAliasSequenceHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapLongInnerAliasSequenceHelper);
        CompleteStructMemberSeq member_seq_MapLongInnerAliasSequenceHelper;
        {
            TypeIdentifierPair type_ids_var_map_long_inneraliassequencehelper;
            ReturnCode_t return_code_var_map_long_inneraliassequencehelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_long_inneraliassequencehelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded", type_ids_var_map_long_inneraliassequencehelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_inneraliassequencehelper)
            {
                return_code_var_map_long_inneraliassequencehelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_sequence_helper", type_ids_var_map_long_inneraliassequencehelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_inneraliassequencehelper)
                {
                ::register_Inner_alias_sequence_helper_type_identifier(type_ids_var_map_long_inneraliassequencehelper);
                }
                bool element_identifier_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_inneraliassequencehelper, element_identifier_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_long_inneraliassequencehelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_inneraliassequencehelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_inneraliassequencehelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_inneraliassequencehelper, key_identifier_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded, element_flags_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded), key_flags_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded", type_ids_var_map_long_inneraliassequencehelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_anonymous_sequence_int16_t_unbounded_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_long_inneraliassequencehelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_long_inneraliassequencehelper = 0x00000000;
            bool common_var_map_long_inneraliassequencehelper_ec {false};
            CommonStructMember common_var_map_long_inneraliassequencehelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_long_inneraliassequencehelper, member_flags_var_map_long_inneraliassequencehelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_inneraliassequencehelper, common_var_map_long_inneraliassequencehelper_ec))};
            if (!common_var_map_long_inneraliassequencehelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_long_inneraliassequencehelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_long_inneraliassequencehelper = "var_map_long_inneraliassequencehelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_long_inneraliassequencehelper;
            ann_custom_MapLongInnerAliasSequenceHelper.reset();
            CompleteMemberDetail detail_var_map_long_inneraliassequencehelper = TypeObjectUtils::build_complete_member_detail(name_var_map_long_inneraliassequencehelper, member_ann_builtin_var_map_long_inneraliassequencehelper, ann_custom_MapLongInnerAliasSequenceHelper);
            CompleteStructMember member_var_map_long_inneraliassequencehelper = TypeObjectUtils::build_complete_struct_member(common_var_map_long_inneraliassequencehelper, detail_var_map_long_inneraliassequencehelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapLongInnerAliasSequenceHelper, member_var_map_long_inneraliassequencehelper);
        }
        CompleteStructType struct_type_MapLongInnerAliasSequenceHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapLongInnerAliasSequenceHelper, header_MapLongInnerAliasSequenceHelper, member_seq_MapLongInnerAliasSequenceHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapLongInnerAliasSequenceHelper, type_name_MapLongInnerAliasSequenceHelper.to_string(), type_ids_MapLongInnerAliasSequenceHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapLongInnerAliasSequenceHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapLongInnerAliasMapHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapLongInnerAliasMapHelper)
{

    ReturnCode_t return_code_MapLongInnerAliasMapHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapLongInnerAliasMapHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapLongInnerAliasMapHelper", type_ids_MapLongInnerAliasMapHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapLongInnerAliasMapHelper)
    {
        StructTypeFlag struct_flags_MapLongInnerAliasMapHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapLongInnerAliasMapHelper = "MapLongInnerAliasMapHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapLongInnerAliasMapHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapLongInnerAliasMapHelper;
        CompleteTypeDetail detail_MapLongInnerAliasMapHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapLongInnerAliasMapHelper, ann_custom_MapLongInnerAliasMapHelper, type_name_MapLongInnerAliasMapHelper.to_string());
        CompleteStructHeader header_MapLongInnerAliasMapHelper;
        header_MapLongInnerAliasMapHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapLongInnerAliasMapHelper);
        CompleteStructMemberSeq member_seq_MapLongInnerAliasMapHelper;
        {
            TypeIdentifierPair type_ids_var_map_long_inneraliasmaphelper;
            ReturnCode_t return_code_var_map_long_inneraliasmaphelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_long_inneraliasmaphelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded", type_ids_var_map_long_inneraliasmaphelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_inneraliasmaphelper)
            {
                return_code_var_map_long_inneraliasmaphelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Inner_alias_map_helper", type_ids_var_map_long_inneraliasmaphelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_inneraliasmaphelper)
                {
                ::register_Inner_alias_map_helper_type_identifier(type_ids_var_map_long_inneraliasmaphelper);
                }
                bool element_identifier_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_inneraliasmaphelper, element_identifier_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_long_inneraliasmaphelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_inneraliasmaphelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_inneraliasmaphelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_inneraliasmaphelper, key_identifier_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded, element_flags_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded), key_flags_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded", type_ids_var_map_long_inneraliasmaphelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_anonymous_map_int32_t_int32_t_0_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_long_inneraliasmaphelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_long_inneraliasmaphelper = 0x00000000;
            bool common_var_map_long_inneraliasmaphelper_ec {false};
            CommonStructMember common_var_map_long_inneraliasmaphelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_long_inneraliasmaphelper, member_flags_var_map_long_inneraliasmaphelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_inneraliasmaphelper, common_var_map_long_inneraliasmaphelper_ec))};
            if (!common_var_map_long_inneraliasmaphelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_long_inneraliasmaphelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_long_inneraliasmaphelper = "var_map_long_inneraliasmaphelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_long_inneraliasmaphelper;
            ann_custom_MapLongInnerAliasMapHelper.reset();
            CompleteMemberDetail detail_var_map_long_inneraliasmaphelper = TypeObjectUtils::build_complete_member_detail(name_var_map_long_inneraliasmaphelper, member_ann_builtin_var_map_long_inneraliasmaphelper, ann_custom_MapLongInnerAliasMapHelper);
            CompleteStructMember member_var_map_long_inneraliasmaphelper = TypeObjectUtils::build_complete_struct_member(common_var_map_long_inneraliasmaphelper, detail_var_map_long_inneraliasmaphelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapLongInnerAliasMapHelper, member_var_map_long_inneraliasmaphelper);
        }
        CompleteStructType struct_type_MapLongInnerAliasMapHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapLongInnerAliasMapHelper, header_MapLongInnerAliasMapHelper, member_seq_MapLongInnerAliasMapHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapLongInnerAliasMapHelper, type_name_MapLongInnerAliasMapHelper.to_string(), type_ids_MapLongInnerAliasMapHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapLongInnerAliasMapHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapLongInnerUnionHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapLongInnerUnionHelper)
{

    ReturnCode_t return_code_MapLongInnerUnionHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapLongInnerUnionHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapLongInnerUnionHelper", type_ids_MapLongInnerUnionHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapLongInnerUnionHelper)
    {
        StructTypeFlag struct_flags_MapLongInnerUnionHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapLongInnerUnionHelper = "MapLongInnerUnionHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapLongInnerUnionHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapLongInnerUnionHelper;
        CompleteTypeDetail detail_MapLongInnerUnionHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapLongInnerUnionHelper, ann_custom_MapLongInnerUnionHelper, type_name_MapLongInnerUnionHelper.to_string());
        CompleteStructHeader header_MapLongInnerUnionHelper;
        header_MapLongInnerUnionHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapLongInnerUnionHelper);
        CompleteStructMemberSeq member_seq_MapLongInnerUnionHelper;
        {
            TypeIdentifierPair type_ids_var_map_long_innerunionhelper;
            ReturnCode_t return_code_var_map_long_innerunionhelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_long_innerunionhelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_InnerUnionHelper_unbounded", type_ids_var_map_long_innerunionhelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_innerunionhelper)
            {
                return_code_var_map_long_innerunionhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerUnionHelper", type_ids_var_map_long_innerunionhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_innerunionhelper)
                {
                ::register_InnerUnionHelper_type_identifier(type_ids_var_map_long_innerunionhelper);
                }
                bool element_identifier_anonymous_map_int32_t_InnerUnionHelper_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_InnerUnionHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_innerunionhelper, element_identifier_anonymous_map_int32_t_InnerUnionHelper_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_InnerUnionHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_InnerUnionHelper_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_long_innerunionhelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_innerunionhelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_innerunionhelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_InnerUnionHelper_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_InnerUnionHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_innerunionhelper, key_identifier_anonymous_map_int32_t_InnerUnionHelper_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_InnerUnionHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_InnerUnionHelper_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_InnerUnionHelper_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_InnerUnionHelper_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerUnionHelper_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_InnerUnionHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerUnionHelper_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_InnerUnionHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerUnionHelper_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_InnerUnionHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerUnionHelper_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_InnerUnionHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerUnionHelper_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_InnerUnionHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerUnionHelper_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerUnionHelper_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_InnerUnionHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerUnionHelper_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerUnionHelper_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_InnerUnionHelper_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_InnerUnionHelper_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_InnerUnionHelper_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_InnerUnionHelper_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_InnerUnionHelper_unbounded, element_flags_anonymous_map_int32_t_InnerUnionHelper_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_InnerUnionHelper_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_InnerUnionHelper_unbounded), key_flags_anonymous_map_int32_t_InnerUnionHelper_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_InnerUnionHelper_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_InnerUnionHelper_unbounded", type_ids_var_map_long_innerunionhelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_InnerUnionHelper_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_long_innerunionhelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_long_innerunionhelper = 0x00000000;
            bool common_var_map_long_innerunionhelper_ec {false};
            CommonStructMember common_var_map_long_innerunionhelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_long_innerunionhelper, member_flags_var_map_long_innerunionhelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_innerunionhelper, common_var_map_long_innerunionhelper_ec))};
            if (!common_var_map_long_innerunionhelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_long_innerunionhelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_long_innerunionhelper = "var_map_long_innerunionhelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_long_innerunionhelper;
            ann_custom_MapLongInnerUnionHelper.reset();
            CompleteMemberDetail detail_var_map_long_innerunionhelper = TypeObjectUtils::build_complete_member_detail(name_var_map_long_innerunionhelper, member_ann_builtin_var_map_long_innerunionhelper, ann_custom_MapLongInnerUnionHelper);
            CompleteStructMember member_var_map_long_innerunionhelper = TypeObjectUtils::build_complete_struct_member(common_var_map_long_innerunionhelper, detail_var_map_long_innerunionhelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapLongInnerUnionHelper, member_var_map_long_innerunionhelper);
        }
        CompleteStructType struct_type_MapLongInnerUnionHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapLongInnerUnionHelper, header_MapLongInnerUnionHelper, member_seq_MapLongInnerUnionHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapLongInnerUnionHelper, type_name_MapLongInnerUnionHelper.to_string(), type_ids_MapLongInnerUnionHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapLongInnerUnionHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapLongInnerStructureHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapLongInnerStructureHelper)
{

    ReturnCode_t return_code_MapLongInnerStructureHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapLongInnerStructureHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapLongInnerStructureHelper", type_ids_MapLongInnerStructureHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapLongInnerStructureHelper)
    {
        StructTypeFlag struct_flags_MapLongInnerStructureHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapLongInnerStructureHelper = "MapLongInnerStructureHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapLongInnerStructureHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapLongInnerStructureHelper;
        CompleteTypeDetail detail_MapLongInnerStructureHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapLongInnerStructureHelper, ann_custom_MapLongInnerStructureHelper, type_name_MapLongInnerStructureHelper.to_string());
        CompleteStructHeader header_MapLongInnerStructureHelper;
        header_MapLongInnerStructureHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapLongInnerStructureHelper);
        CompleteStructMemberSeq member_seq_MapLongInnerStructureHelper;
        {
            TypeIdentifierPair type_ids_var_map_long_innerstructurehelper;
            ReturnCode_t return_code_var_map_long_innerstructurehelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_long_innerstructurehelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_InnerStructureHelper_unbounded", type_ids_var_map_long_innerstructurehelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_innerstructurehelper)
            {
                return_code_var_map_long_innerstructurehelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerStructureHelper", type_ids_var_map_long_innerstructurehelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_innerstructurehelper)
                {
                ::register_InnerStructureHelper_type_identifier(type_ids_var_map_long_innerstructurehelper);
                }
                bool element_identifier_anonymous_map_int32_t_InnerStructureHelper_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_InnerStructureHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_innerstructurehelper, element_identifier_anonymous_map_int32_t_InnerStructureHelper_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_InnerStructureHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_InnerStructureHelper_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_long_innerstructurehelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_innerstructurehelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_innerstructurehelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_InnerStructureHelper_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_InnerStructureHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_innerstructurehelper, key_identifier_anonymous_map_int32_t_InnerStructureHelper_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_InnerStructureHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_InnerStructureHelper_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_InnerStructureHelper_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_InnerStructureHelper_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerStructureHelper_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_InnerStructureHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerStructureHelper_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_InnerStructureHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerStructureHelper_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_InnerStructureHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerStructureHelper_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_InnerStructureHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerStructureHelper_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_InnerStructureHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerStructureHelper_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerStructureHelper_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_InnerStructureHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerStructureHelper_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerStructureHelper_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_InnerStructureHelper_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_InnerStructureHelper_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_InnerStructureHelper_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_InnerStructureHelper_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_InnerStructureHelper_unbounded, element_flags_anonymous_map_int32_t_InnerStructureHelper_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_InnerStructureHelper_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_InnerStructureHelper_unbounded), key_flags_anonymous_map_int32_t_InnerStructureHelper_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_InnerStructureHelper_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_InnerStructureHelper_unbounded", type_ids_var_map_long_innerstructurehelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_InnerStructureHelper_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_long_innerstructurehelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_long_innerstructurehelper = 0x00000000;
            bool common_var_map_long_innerstructurehelper_ec {false};
            CommonStructMember common_var_map_long_innerstructurehelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_long_innerstructurehelper, member_flags_var_map_long_innerstructurehelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_innerstructurehelper, common_var_map_long_innerstructurehelper_ec))};
            if (!common_var_map_long_innerstructurehelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_long_innerstructurehelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_long_innerstructurehelper = "var_map_long_innerstructurehelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_long_innerstructurehelper;
            ann_custom_MapLongInnerStructureHelper.reset();
            CompleteMemberDetail detail_var_map_long_innerstructurehelper = TypeObjectUtils::build_complete_member_detail(name_var_map_long_innerstructurehelper, member_ann_builtin_var_map_long_innerstructurehelper, ann_custom_MapLongInnerStructureHelper);
            CompleteStructMember member_var_map_long_innerstructurehelper = TypeObjectUtils::build_complete_struct_member(common_var_map_long_innerstructurehelper, detail_var_map_long_innerstructurehelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapLongInnerStructureHelper, member_var_map_long_innerstructurehelper);
        }
        CompleteStructType struct_type_MapLongInnerStructureHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapLongInnerStructureHelper, header_MapLongInnerStructureHelper, member_seq_MapLongInnerStructureHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapLongInnerStructureHelper, type_name_MapLongInnerStructureHelper.to_string(), type_ids_MapLongInnerStructureHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapLongInnerStructureHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapLongInnerBitsetHelper_type_identifier(
        TypeIdentifierPair& type_ids_MapLongInnerBitsetHelper)
{

    ReturnCode_t return_code_MapLongInnerBitsetHelper {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapLongInnerBitsetHelper =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapLongInnerBitsetHelper", type_ids_MapLongInnerBitsetHelper);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapLongInnerBitsetHelper)
    {
        StructTypeFlag struct_flags_MapLongInnerBitsetHelper = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapLongInnerBitsetHelper = "MapLongInnerBitsetHelper";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapLongInnerBitsetHelper;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapLongInnerBitsetHelper;
        CompleteTypeDetail detail_MapLongInnerBitsetHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapLongInnerBitsetHelper, ann_custom_MapLongInnerBitsetHelper, type_name_MapLongInnerBitsetHelper.to_string());
        CompleteStructHeader header_MapLongInnerBitsetHelper;
        header_MapLongInnerBitsetHelper = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapLongInnerBitsetHelper);
        CompleteStructMemberSeq member_seq_MapLongInnerBitsetHelper;
        {
            TypeIdentifierPair type_ids_var_map_long_innerbitsethelper;
            ReturnCode_t return_code_var_map_long_innerbitsethelper {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_long_innerbitsethelper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_int32_t_InnerBitsetHelper_unbounded", type_ids_var_map_long_innerbitsethelper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_innerbitsethelper)
            {
                return_code_var_map_long_innerbitsethelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "InnerBitsetHelper", type_ids_var_map_long_innerbitsethelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_innerbitsethelper)
                {
                ::register_InnerBitsetHelper_type_identifier(type_ids_var_map_long_innerbitsethelper);
                }
                bool element_identifier_anonymous_map_int32_t_InnerBitsetHelper_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_int32_t_InnerBitsetHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_innerbitsethelper, element_identifier_anonymous_map_int32_t_InnerBitsetHelper_unbounded_ec))};
                if (!element_identifier_anonymous_map_int32_t_InnerBitsetHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_InnerBitsetHelper_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_long_innerbitsethelper =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_long_innerbitsethelper);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_long_innerbitsethelper)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_int32_t_InnerBitsetHelper_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_int32_t_InnerBitsetHelper_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_innerbitsethelper, key_identifier_anonymous_map_int32_t_InnerBitsetHelper_unbounded_ec))};
                if (!key_identifier_anonymous_map_int32_t_InnerBitsetHelper_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_int32_t_InnerBitsetHelper_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_int32_t_InnerBitsetHelper_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_int32_t_InnerBitsetHelper_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerBitsetHelper_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_int32_t_InnerBitsetHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerBitsetHelper_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_int32_t_InnerBitsetHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerBitsetHelper_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_int32_t_InnerBitsetHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerBitsetHelper_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_int32_t_InnerBitsetHelper_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerBitsetHelper_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_int32_t_InnerBitsetHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerBitsetHelper_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerBitsetHelper_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_int32_t_InnerBitsetHelper_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerBitsetHelper_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_int32_t_InnerBitsetHelper_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_int32_t_InnerBitsetHelper_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_int32_t_InnerBitsetHelper_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_int32_t_InnerBitsetHelper_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_int32_t_InnerBitsetHelper_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_int32_t_InnerBitsetHelper_unbounded, element_flags_anonymous_map_int32_t_InnerBitsetHelper_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_int32_t_InnerBitsetHelper_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_int32_t_InnerBitsetHelper_unbounded), key_flags_anonymous_map_int32_t_InnerBitsetHelper_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_int32_t_InnerBitsetHelper_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_int32_t_InnerBitsetHelper_unbounded", type_ids_var_map_long_innerbitsethelper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_int32_t_InnerBitsetHelper_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_long_innerbitsethelper = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_long_innerbitsethelper = 0x00000000;
            bool common_var_map_long_innerbitsethelper_ec {false};
            CommonStructMember common_var_map_long_innerbitsethelper {TypeObjectUtils::build_common_struct_member(member_id_var_map_long_innerbitsethelper, member_flags_var_map_long_innerbitsethelper, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_long_innerbitsethelper, common_var_map_long_innerbitsethelper_ec))};
            if (!common_var_map_long_innerbitsethelper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_long_innerbitsethelper member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_long_innerbitsethelper = "var_map_long_innerbitsethelper";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_long_innerbitsethelper;
            ann_custom_MapLongInnerBitsetHelper.reset();
            CompleteMemberDetail detail_var_map_long_innerbitsethelper = TypeObjectUtils::build_complete_member_detail(name_var_map_long_innerbitsethelper, member_ann_builtin_var_map_long_innerbitsethelper, ann_custom_MapLongInnerBitsetHelper);
            CompleteStructMember member_var_map_long_innerbitsethelper = TypeObjectUtils::build_complete_struct_member(common_var_map_long_innerbitsethelper, detail_var_map_long_innerbitsethelper);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapLongInnerBitsetHelper, member_var_map_long_innerbitsethelper);
        }
        CompleteStructType struct_type_MapLongInnerBitsetHelper = TypeObjectUtils::build_complete_struct_type(struct_flags_MapLongInnerBitsetHelper, header_MapLongInnerBitsetHelper, member_seq_MapLongInnerBitsetHelper);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapLongInnerBitsetHelper, type_name_MapLongInnerBitsetHelper.to_string(), type_ids_MapLongInnerBitsetHelper))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapLongInnerBitsetHelper already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapULongShort_type_identifier(
        TypeIdentifierPair& type_ids_MapULongShort)
{

    ReturnCode_t return_code_MapULongShort {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapULongShort =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapULongShort", type_ids_MapULongShort);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapULongShort)
    {
        StructTypeFlag struct_flags_MapULongShort = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapULongShort = "MapULongShort";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapULongShort;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapULongShort;
        CompleteTypeDetail detail_MapULongShort = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapULongShort, ann_custom_MapULongShort, type_name_MapULongShort.to_string());
        CompleteStructHeader header_MapULongShort;
        header_MapULongShort = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapULongShort);
        CompleteStructMemberSeq member_seq_MapULongShort;
        {
            TypeIdentifierPair type_ids_var_map_ulong_short;
            ReturnCode_t return_code_var_map_ulong_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ulong_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint32_t_int16_t_unbounded", type_ids_var_map_ulong_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_short)
            {
                return_code_var_map_ulong_short =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_var_map_ulong_short);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_short)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_uint32_t_int16_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint32_t_int16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_short, element_identifier_anonymous_map_uint32_t_int16_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint32_t_int16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_int16_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ulong_short =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_var_map_ulong_short);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_short)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint32_t_int16_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint32_t_int16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_short, key_identifier_anonymous_map_uint32_t_int16_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint32_t_int16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_int16_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint32_t_int16_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint32_t_int16_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int16_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint32_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int16_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint32_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int16_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint32_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int16_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint32_t_int16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int16_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint32_t_int16_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int16_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int16_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint32_t_int16_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int16_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int16_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint32_t_int16_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint32_t_int16_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint32_t_int16_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint32_t_int16_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint32_t_int16_t_unbounded, element_flags_anonymous_map_uint32_t_int16_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint32_t_int16_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint32_t_int16_t_unbounded), key_flags_anonymous_map_uint32_t_int16_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint32_t_int16_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint32_t_int16_t_unbounded", type_ids_var_map_ulong_short))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint32_t_int16_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ulong_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ulong_short = 0x00000000;
            bool common_var_map_ulong_short_ec {false};
            CommonStructMember common_var_map_ulong_short {TypeObjectUtils::build_common_struct_member(member_id_var_map_ulong_short, member_flags_var_map_ulong_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_short, common_var_map_ulong_short_ec))};
            if (!common_var_map_ulong_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ulong_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ulong_short = "var_map_ulong_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ulong_short;
            ann_custom_MapULongShort.reset();
            CompleteMemberDetail detail_var_map_ulong_short = TypeObjectUtils::build_complete_member_detail(name_var_map_ulong_short, member_ann_builtin_var_map_ulong_short, ann_custom_MapULongShort);
            CompleteStructMember member_var_map_ulong_short = TypeObjectUtils::build_complete_struct_member(common_var_map_ulong_short, detail_var_map_ulong_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapULongShort, member_var_map_ulong_short);
        }
        CompleteStructType struct_type_MapULongShort = TypeObjectUtils::build_complete_struct_type(struct_flags_MapULongShort, header_MapULongShort, member_seq_MapULongShort);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapULongShort, type_name_MapULongShort.to_string(), type_ids_MapULongShort))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapULongShort already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapULongUShort_type_identifier(
        TypeIdentifierPair& type_ids_MapULongUShort)
{

    ReturnCode_t return_code_MapULongUShort {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapULongUShort =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapULongUShort", type_ids_MapULongUShort);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapULongUShort)
    {
        StructTypeFlag struct_flags_MapULongUShort = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapULongUShort = "MapULongUShort";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapULongUShort;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapULongUShort;
        CompleteTypeDetail detail_MapULongUShort = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapULongUShort, ann_custom_MapULongUShort, type_name_MapULongUShort.to_string());
        CompleteStructHeader header_MapULongUShort;
        header_MapULongUShort = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapULongUShort);
        CompleteStructMemberSeq member_seq_MapULongUShort;
        {
            TypeIdentifierPair type_ids_var_map_ulong_ushort;
            ReturnCode_t return_code_var_map_ulong_ushort {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ulong_ushort =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint32_t_uint16_t_unbounded", type_ids_var_map_ulong_ushort);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_ushort)
            {
                return_code_var_map_ulong_ushort =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_var_map_ulong_ushort);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_ushort)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_uint32_t_uint16_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint32_t_uint16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_ushort, element_identifier_anonymous_map_uint32_t_uint16_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint32_t_uint16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_uint16_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ulong_ushort =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_var_map_ulong_ushort);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_ushort)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint32_t_uint16_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint32_t_uint16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_ushort, key_identifier_anonymous_map_uint32_t_uint16_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint32_t_uint16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_uint16_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint32_t_uint16_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint32_t_uint16_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint16_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint32_t_uint16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint16_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint32_t_uint16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint16_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint32_t_uint16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint16_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint32_t_uint16_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint16_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint32_t_uint16_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint16_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint16_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint32_t_uint16_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint16_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint16_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint32_t_uint16_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint32_t_uint16_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint32_t_uint16_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint32_t_uint16_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint32_t_uint16_t_unbounded, element_flags_anonymous_map_uint32_t_uint16_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint32_t_uint16_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint32_t_uint16_t_unbounded), key_flags_anonymous_map_uint32_t_uint16_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint32_t_uint16_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint32_t_uint16_t_unbounded", type_ids_var_map_ulong_ushort))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint32_t_uint16_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ulong_ushort = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ulong_ushort = 0x00000000;
            bool common_var_map_ulong_ushort_ec {false};
            CommonStructMember common_var_map_ulong_ushort {TypeObjectUtils::build_common_struct_member(member_id_var_map_ulong_ushort, member_flags_var_map_ulong_ushort, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_ushort, common_var_map_ulong_ushort_ec))};
            if (!common_var_map_ulong_ushort_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ulong_ushort member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ulong_ushort = "var_map_ulong_ushort";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ulong_ushort;
            ann_custom_MapULongUShort.reset();
            CompleteMemberDetail detail_var_map_ulong_ushort = TypeObjectUtils::build_complete_member_detail(name_var_map_ulong_ushort, member_ann_builtin_var_map_ulong_ushort, ann_custom_MapULongUShort);
            CompleteStructMember member_var_map_ulong_ushort = TypeObjectUtils::build_complete_struct_member(common_var_map_ulong_ushort, detail_var_map_ulong_ushort);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapULongUShort, member_var_map_ulong_ushort);
        }
        CompleteStructType struct_type_MapULongUShort = TypeObjectUtils::build_complete_struct_type(struct_flags_MapULongUShort, header_MapULongUShort, member_seq_MapULongUShort);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapULongUShort, type_name_MapULongUShort.to_string(), type_ids_MapULongUShort))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapULongUShort already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapULongLong_type_identifier(
        TypeIdentifierPair& type_ids_MapULongLong)
{

    ReturnCode_t return_code_MapULongLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapULongLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapULongLong", type_ids_MapULongLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapULongLong)
    {
        StructTypeFlag struct_flags_MapULongLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapULongLong = "MapULongLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapULongLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapULongLong;
        CompleteTypeDetail detail_MapULongLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapULongLong, ann_custom_MapULongLong, type_name_MapULongLong.to_string());
        CompleteStructHeader header_MapULongLong;
        header_MapULongLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapULongLong);
        CompleteStructMemberSeq member_seq_MapULongLong;
        {
            TypeIdentifierPair type_ids_var_map_ulong_long;
            ReturnCode_t return_code_var_map_ulong_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ulong_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint32_t_int32_t_unbounded", type_ids_var_map_ulong_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_long)
            {
                return_code_var_map_ulong_long =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_var_map_ulong_long);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_long)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_uint32_t_int32_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint32_t_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_long, element_identifier_anonymous_map_uint32_t_int32_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint32_t_int32_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_int32_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ulong_long =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_var_map_ulong_long);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_long)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint32_t_int32_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint32_t_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_long, key_identifier_anonymous_map_uint32_t_int32_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint32_t_int32_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_int32_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint32_t_int32_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint32_t_int32_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int32_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int32_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int32_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int32_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint32_t_int32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int32_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint32_t_int32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int32_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int32_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint32_t_int32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int32_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int32_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint32_t_int32_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint32_t_int32_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint32_t_int32_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint32_t_int32_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint32_t_int32_t_unbounded, element_flags_anonymous_map_uint32_t_int32_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint32_t_int32_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint32_t_int32_t_unbounded), key_flags_anonymous_map_uint32_t_int32_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint32_t_int32_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint32_t_int32_t_unbounded", type_ids_var_map_ulong_long))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint32_t_int32_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ulong_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ulong_long = 0x00000000;
            bool common_var_map_ulong_long_ec {false};
            CommonStructMember common_var_map_ulong_long {TypeObjectUtils::build_common_struct_member(member_id_var_map_ulong_long, member_flags_var_map_ulong_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_long, common_var_map_ulong_long_ec))};
            if (!common_var_map_ulong_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ulong_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ulong_long = "var_map_ulong_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ulong_long;
            ann_custom_MapULongLong.reset();
            CompleteMemberDetail detail_var_map_ulong_long = TypeObjectUtils::build_complete_member_detail(name_var_map_ulong_long, member_ann_builtin_var_map_ulong_long, ann_custom_MapULongLong);
            CompleteStructMember member_var_map_ulong_long = TypeObjectUtils::build_complete_struct_member(common_var_map_ulong_long, detail_var_map_ulong_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapULongLong, member_var_map_ulong_long);
        }
        CompleteStructType struct_type_MapULongLong = TypeObjectUtils::build_complete_struct_type(struct_flags_MapULongLong, header_MapULongLong, member_seq_MapULongLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapULongLong, type_name_MapULongLong.to_string(), type_ids_MapULongLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapULongLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapULongULong_type_identifier(
        TypeIdentifierPair& type_ids_MapULongULong)
{

    ReturnCode_t return_code_MapULongULong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapULongULong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapULongULong", type_ids_MapULongULong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapULongULong)
    {
        StructTypeFlag struct_flags_MapULongULong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapULongULong = "MapULongULong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapULongULong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapULongULong;
        CompleteTypeDetail detail_MapULongULong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapULongULong, ann_custom_MapULongULong, type_name_MapULongULong.to_string());
        CompleteStructHeader header_MapULongULong;
        header_MapULongULong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapULongULong);
        CompleteStructMemberSeq member_seq_MapULongULong;
        {
            TypeIdentifierPair type_ids_var_map_ulong_ulong;
            ReturnCode_t return_code_var_map_ulong_ulong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ulong_ulong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint32_t_uint32_t_unbounded", type_ids_var_map_ulong_ulong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_ulong)
            {
                return_code_var_map_ulong_ulong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_var_map_ulong_ulong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_ulong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_uint32_t_uint32_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint32_t_uint32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_ulong, element_identifier_anonymous_map_uint32_t_uint32_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint32_t_uint32_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_uint32_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ulong_ulong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_var_map_ulong_ulong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_ulong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint32_t_uint32_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint32_t_uint32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_ulong, key_identifier_anonymous_map_uint32_t_uint32_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint32_t_uint32_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_uint32_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint32_t_uint32_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint32_t_uint32_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint32_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint32_t_uint32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint32_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint32_t_uint32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint32_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint32_t_uint32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint32_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint32_t_uint32_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint32_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint32_t_uint32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint32_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint32_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint32_t_uint32_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint32_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint32_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint32_t_uint32_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint32_t_uint32_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint32_t_uint32_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint32_t_uint32_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint32_t_uint32_t_unbounded, element_flags_anonymous_map_uint32_t_uint32_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint32_t_uint32_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint32_t_uint32_t_unbounded), key_flags_anonymous_map_uint32_t_uint32_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint32_t_uint32_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint32_t_uint32_t_unbounded", type_ids_var_map_ulong_ulong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint32_t_uint32_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ulong_ulong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ulong_ulong = 0x00000000;
            bool common_var_map_ulong_ulong_ec {false};
            CommonStructMember common_var_map_ulong_ulong {TypeObjectUtils::build_common_struct_member(member_id_var_map_ulong_ulong, member_flags_var_map_ulong_ulong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_ulong, common_var_map_ulong_ulong_ec))};
            if (!common_var_map_ulong_ulong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ulong_ulong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ulong_ulong = "var_map_ulong_ulong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ulong_ulong;
            ann_custom_MapULongULong.reset();
            CompleteMemberDetail detail_var_map_ulong_ulong = TypeObjectUtils::build_complete_member_detail(name_var_map_ulong_ulong, member_ann_builtin_var_map_ulong_ulong, ann_custom_MapULongULong);
            CompleteStructMember member_var_map_ulong_ulong = TypeObjectUtils::build_complete_struct_member(common_var_map_ulong_ulong, detail_var_map_ulong_ulong);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapULongULong, member_var_map_ulong_ulong);
        }
        CompleteStructType struct_type_MapULongULong = TypeObjectUtils::build_complete_struct_type(struct_flags_MapULongULong, header_MapULongULong, member_seq_MapULongULong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapULongULong, type_name_MapULongULong.to_string(), type_ids_MapULongULong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapULongULong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapKeyULongValueLongLong_type_identifier(
        TypeIdentifierPair& type_ids_MapKeyULongValueLongLong)
{

    ReturnCode_t return_code_MapKeyULongValueLongLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapKeyULongValueLongLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapKeyULongValueLongLong", type_ids_MapKeyULongValueLongLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapKeyULongValueLongLong)
    {
        StructTypeFlag struct_flags_MapKeyULongValueLongLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapKeyULongValueLongLong = "MapKeyULongValueLongLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapKeyULongValueLongLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapKeyULongValueLongLong;
        CompleteTypeDetail detail_MapKeyULongValueLongLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapKeyULongValueLongLong, ann_custom_MapKeyULongValueLongLong, type_name_MapKeyULongValueLongLong.to_string());
        CompleteStructHeader header_MapKeyULongValueLongLong;
        header_MapKeyULongValueLongLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapKeyULongValueLongLong);
        CompleteStructMemberSeq member_seq_MapKeyULongValueLongLong;
        {
            TypeIdentifierPair type_ids_var_map_ulong_longlong;
            ReturnCode_t return_code_var_map_ulong_longlong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ulong_longlong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint32_t_int64_t_unbounded", type_ids_var_map_ulong_longlong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_longlong)
            {
                return_code_var_map_ulong_longlong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int64_t", type_ids_var_map_ulong_longlong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_longlong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_uint32_t_int64_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint32_t_int64_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_longlong, element_identifier_anonymous_map_uint32_t_int64_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint32_t_int64_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_int64_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ulong_longlong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_var_map_ulong_longlong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_longlong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint32_t_int64_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint32_t_int64_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_longlong, key_identifier_anonymous_map_uint32_t_int64_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint32_t_int64_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_int64_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint32_t_int64_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint32_t_int64_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int64_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint32_t_int64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int64_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint32_t_int64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int64_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint32_t_int64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int64_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint32_t_int64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int64_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint32_t_int64_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int64_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int64_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint32_t_int64_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int64_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_int64_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint32_t_int64_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint32_t_int64_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint32_t_int64_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint32_t_int64_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint32_t_int64_t_unbounded, element_flags_anonymous_map_uint32_t_int64_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint32_t_int64_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint32_t_int64_t_unbounded), key_flags_anonymous_map_uint32_t_int64_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint32_t_int64_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint32_t_int64_t_unbounded", type_ids_var_map_ulong_longlong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint32_t_int64_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ulong_longlong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ulong_longlong = 0x00000000;
            bool common_var_map_ulong_longlong_ec {false};
            CommonStructMember common_var_map_ulong_longlong {TypeObjectUtils::build_common_struct_member(member_id_var_map_ulong_longlong, member_flags_var_map_ulong_longlong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_longlong, common_var_map_ulong_longlong_ec))};
            if (!common_var_map_ulong_longlong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ulong_longlong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ulong_longlong = "var_map_ulong_longlong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ulong_longlong;
            ann_custom_MapKeyULongValueLongLong.reset();
            CompleteMemberDetail detail_var_map_ulong_longlong = TypeObjectUtils::build_complete_member_detail(name_var_map_ulong_longlong, member_ann_builtin_var_map_ulong_longlong, ann_custom_MapKeyULongValueLongLong);
            CompleteStructMember member_var_map_ulong_longlong = TypeObjectUtils::build_complete_struct_member(common_var_map_ulong_longlong, detail_var_map_ulong_longlong);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapKeyULongValueLongLong, member_var_map_ulong_longlong);
        }
        CompleteStructType struct_type_MapKeyULongValueLongLong = TypeObjectUtils::build_complete_struct_type(struct_flags_MapKeyULongValueLongLong, header_MapKeyULongValueLongLong, member_seq_MapKeyULongValueLongLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapKeyULongValueLongLong, type_name_MapKeyULongValueLongLong.to_string(), type_ids_MapKeyULongValueLongLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapKeyULongValueLongLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapULongULongLong_type_identifier(
        TypeIdentifierPair& type_ids_MapULongULongLong)
{

    ReturnCode_t return_code_MapULongULongLong {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapULongULongLong =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapULongULongLong", type_ids_MapULongULongLong);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapULongULongLong)
    {
        StructTypeFlag struct_flags_MapULongULongLong = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapULongULongLong = "MapULongULongLong";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapULongULongLong;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapULongULongLong;
        CompleteTypeDetail detail_MapULongULongLong = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapULongULongLong, ann_custom_MapULongULongLong, type_name_MapULongULongLong.to_string());
        CompleteStructHeader header_MapULongULongLong;
        header_MapULongULongLong = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapULongULongLong);
        CompleteStructMemberSeq member_seq_MapULongULongLong;
        {
            TypeIdentifierPair type_ids_var_map_ulong_ulonglong;
            ReturnCode_t return_code_var_map_ulong_ulonglong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ulong_ulonglong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint32_t_uint64_t_unbounded", type_ids_var_map_ulong_ulonglong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_ulonglong)
            {
                return_code_var_map_ulong_ulonglong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint64_t", type_ids_var_map_ulong_ulonglong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_ulonglong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_uint32_t_uint64_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint32_t_uint64_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_ulonglong, element_identifier_anonymous_map_uint32_t_uint64_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint32_t_uint64_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_uint64_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ulong_ulonglong =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_var_map_ulong_ulonglong);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_ulonglong)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint32_t_uint64_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint32_t_uint64_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_ulonglong, key_identifier_anonymous_map_uint32_t_uint64_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint32_t_uint64_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_uint64_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint32_t_uint64_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint32_t_uint64_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint64_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint32_t_uint64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint64_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint32_t_uint64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint64_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint32_t_uint64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint64_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint32_t_uint64_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint64_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint32_t_uint64_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint64_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint64_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint32_t_uint64_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint64_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_uint64_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint32_t_uint64_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint32_t_uint64_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint32_t_uint64_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint32_t_uint64_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint32_t_uint64_t_unbounded, element_flags_anonymous_map_uint32_t_uint64_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint32_t_uint64_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint32_t_uint64_t_unbounded), key_flags_anonymous_map_uint32_t_uint64_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint32_t_uint64_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint32_t_uint64_t_unbounded", type_ids_var_map_ulong_ulonglong))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint32_t_uint64_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ulong_ulonglong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ulong_ulonglong = 0x00000000;
            bool common_var_map_ulong_ulonglong_ec {false};
            CommonStructMember common_var_map_ulong_ulonglong {TypeObjectUtils::build_common_struct_member(member_id_var_map_ulong_ulonglong, member_flags_var_map_ulong_ulonglong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_ulonglong, common_var_map_ulong_ulonglong_ec))};
            if (!common_var_map_ulong_ulonglong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ulong_ulonglong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ulong_ulonglong = "var_map_ulong_ulonglong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ulong_ulonglong;
            ann_custom_MapULongULongLong.reset();
            CompleteMemberDetail detail_var_map_ulong_ulonglong = TypeObjectUtils::build_complete_member_detail(name_var_map_ulong_ulonglong, member_ann_builtin_var_map_ulong_ulonglong, ann_custom_MapULongULongLong);
            CompleteStructMember member_var_map_ulong_ulonglong = TypeObjectUtils::build_complete_struct_member(common_var_map_ulong_ulonglong, detail_var_map_ulong_ulonglong);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapULongULongLong, member_var_map_ulong_ulonglong);
        }
        CompleteStructType struct_type_MapULongULongLong = TypeObjectUtils::build_complete_struct_type(struct_flags_MapULongULongLong, header_MapULongULongLong, member_seq_MapULongULongLong);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapULongULongLong, type_name_MapULongULongLong.to_string(), type_ids_MapULongULongLong))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapULongULongLong already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapULongFloat_type_identifier(
        TypeIdentifierPair& type_ids_MapULongFloat)
{

    ReturnCode_t return_code_MapULongFloat {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapULongFloat =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapULongFloat", type_ids_MapULongFloat);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapULongFloat)
    {
        StructTypeFlag struct_flags_MapULongFloat = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapULongFloat = "MapULongFloat";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapULongFloat;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapULongFloat;
        CompleteTypeDetail detail_MapULongFloat = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapULongFloat, ann_custom_MapULongFloat, type_name_MapULongFloat.to_string());
        CompleteStructHeader header_MapULongFloat;
        header_MapULongFloat = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapULongFloat);
        CompleteStructMemberSeq member_seq_MapULongFloat;
        {
            TypeIdentifierPair type_ids_var_map_ulong_float;
            ReturnCode_t return_code_var_map_ulong_float {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ulong_float =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint32_t_float_unbounded", type_ids_var_map_ulong_float);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_float)
            {
                return_code_var_map_ulong_float =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_float", type_ids_var_map_ulong_float);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_float)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_uint32_t_float_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint32_t_float_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_float, element_identifier_anonymous_map_uint32_t_float_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint32_t_float_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_float_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ulong_float =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_var_map_ulong_float);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_float)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint32_t_float_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint32_t_float_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_float, key_identifier_anonymous_map_uint32_t_float_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint32_t_float_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_float_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint32_t_float_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint32_t_float_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_float_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint32_t_float_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_float_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint32_t_float_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_float_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint32_t_float_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_float_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint32_t_float_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_float_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint32_t_float_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_float_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_float_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint32_t_float_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_float_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_float_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint32_t_float_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint32_t_float_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint32_t_float_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint32_t_float_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint32_t_float_unbounded, element_flags_anonymous_map_uint32_t_float_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint32_t_float_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint32_t_float_unbounded), key_flags_anonymous_map_uint32_t_float_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint32_t_float_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint32_t_float_unbounded", type_ids_var_map_ulong_float))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint32_t_float_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ulong_float = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ulong_float = 0x00000000;
            bool common_var_map_ulong_float_ec {false};
            CommonStructMember common_var_map_ulong_float {TypeObjectUtils::build_common_struct_member(member_id_var_map_ulong_float, member_flags_var_map_ulong_float, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_float, common_var_map_ulong_float_ec))};
            if (!common_var_map_ulong_float_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ulong_float member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ulong_float = "var_map_ulong_float";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ulong_float;
            ann_custom_MapULongFloat.reset();
            CompleteMemberDetail detail_var_map_ulong_float = TypeObjectUtils::build_complete_member_detail(name_var_map_ulong_float, member_ann_builtin_var_map_ulong_float, ann_custom_MapULongFloat);
            CompleteStructMember member_var_map_ulong_float = TypeObjectUtils::build_complete_struct_member(common_var_map_ulong_float, detail_var_map_ulong_float);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapULongFloat, member_var_map_ulong_float);
        }
        CompleteStructType struct_type_MapULongFloat = TypeObjectUtils::build_complete_struct_type(struct_flags_MapULongFloat, header_MapULongFloat, member_seq_MapULongFloat);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapULongFloat, type_name_MapULongFloat.to_string(), type_ids_MapULongFloat))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapULongFloat already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapULongDouble_type_identifier(
        TypeIdentifierPair& type_ids_MapULongDouble)
{

    ReturnCode_t return_code_MapULongDouble {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapULongDouble =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapULongDouble", type_ids_MapULongDouble);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapULongDouble)
    {
        StructTypeFlag struct_flags_MapULongDouble = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapULongDouble = "MapULongDouble";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapULongDouble;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapULongDouble;
        CompleteTypeDetail detail_MapULongDouble = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapULongDouble, ann_custom_MapULongDouble, type_name_MapULongDouble.to_string());
        CompleteStructHeader header_MapULongDouble;
        header_MapULongDouble = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapULongDouble);
        CompleteStructMemberSeq member_seq_MapULongDouble;
        {
            TypeIdentifierPair type_ids_var_map_ulong_double;
            ReturnCode_t return_code_var_map_ulong_double {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ulong_double =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint32_t_double_unbounded", type_ids_var_map_ulong_double);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_double)
            {
                return_code_var_map_ulong_double =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_double", type_ids_var_map_ulong_double);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_double)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_uint32_t_double_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint32_t_double_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_double, element_identifier_anonymous_map_uint32_t_double_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint32_t_double_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_double_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ulong_double =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_var_map_ulong_double);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_double)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint32_t_double_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint32_t_double_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_double, key_identifier_anonymous_map_uint32_t_double_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint32_t_double_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_double_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint32_t_double_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint32_t_double_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_double_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint32_t_double_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_double_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint32_t_double_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_double_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint32_t_double_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_double_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint32_t_double_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_double_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint32_t_double_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_double_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_double_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint32_t_double_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_double_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_double_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint32_t_double_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint32_t_double_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint32_t_double_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint32_t_double_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint32_t_double_unbounded, element_flags_anonymous_map_uint32_t_double_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint32_t_double_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint32_t_double_unbounded), key_flags_anonymous_map_uint32_t_double_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint32_t_double_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint32_t_double_unbounded", type_ids_var_map_ulong_double))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint32_t_double_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ulong_double = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ulong_double = 0x00000000;
            bool common_var_map_ulong_double_ec {false};
            CommonStructMember common_var_map_ulong_double {TypeObjectUtils::build_common_struct_member(member_id_var_map_ulong_double, member_flags_var_map_ulong_double, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_double, common_var_map_ulong_double_ec))};
            if (!common_var_map_ulong_double_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ulong_double member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ulong_double = "var_map_ulong_double";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ulong_double;
            ann_custom_MapULongDouble.reset();
            CompleteMemberDetail detail_var_map_ulong_double = TypeObjectUtils::build_complete_member_detail(name_var_map_ulong_double, member_ann_builtin_var_map_ulong_double, ann_custom_MapULongDouble);
            CompleteStructMember member_var_map_ulong_double = TypeObjectUtils::build_complete_struct_member(common_var_map_ulong_double, detail_var_map_ulong_double);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapULongDouble, member_var_map_ulong_double);
        }
        CompleteStructType struct_type_MapULongDouble = TypeObjectUtils::build_complete_struct_type(struct_flags_MapULongDouble, header_MapULongDouble, member_seq_MapULongDouble);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapULongDouble, type_name_MapULongDouble.to_string(), type_ids_MapULongDouble))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapULongDouble already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapKeyULongValueLongDouble_type_identifier(
        TypeIdentifierPair& type_ids_MapKeyULongValueLongDouble)
{

    ReturnCode_t return_code_MapKeyULongValueLongDouble {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapKeyULongValueLongDouble =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapKeyULongValueLongDouble", type_ids_MapKeyULongValueLongDouble);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapKeyULongValueLongDouble)
    {
        StructTypeFlag struct_flags_MapKeyULongValueLongDouble = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapKeyULongValueLongDouble = "MapKeyULongValueLongDouble";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapKeyULongValueLongDouble;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapKeyULongValueLongDouble;
        CompleteTypeDetail detail_MapKeyULongValueLongDouble = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapKeyULongValueLongDouble, ann_custom_MapKeyULongValueLongDouble, type_name_MapKeyULongValueLongDouble.to_string());
        CompleteStructHeader header_MapKeyULongValueLongDouble;
        header_MapKeyULongValueLongDouble = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapKeyULongValueLongDouble);
        CompleteStructMemberSeq member_seq_MapKeyULongValueLongDouble;
        {
            TypeIdentifierPair type_ids_var_map_ulong_longdouble;
            ReturnCode_t return_code_var_map_ulong_longdouble {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ulong_longdouble =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint32_t_longdouble_unbounded", type_ids_var_map_ulong_longdouble);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_longdouble)
            {
                return_code_var_map_ulong_longdouble =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_longdouble", type_ids_var_map_ulong_longdouble);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_longdouble)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_uint32_t_longdouble_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint32_t_longdouble_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_longdouble, element_identifier_anonymous_map_uint32_t_longdouble_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint32_t_longdouble_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_longdouble_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ulong_longdouble =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_var_map_ulong_longdouble);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_longdouble)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint32_t_longdouble_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint32_t_longdouble_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_longdouble, key_identifier_anonymous_map_uint32_t_longdouble_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint32_t_longdouble_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_longdouble_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint32_t_longdouble_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint32_t_longdouble_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_longdouble_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint32_t_longdouble_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_longdouble_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint32_t_longdouble_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_longdouble_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint32_t_longdouble_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_longdouble_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint32_t_longdouble_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_longdouble_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint32_t_longdouble_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_longdouble_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_longdouble_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint32_t_longdouble_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_longdouble_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_longdouble_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint32_t_longdouble_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint32_t_longdouble_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint32_t_longdouble_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint32_t_longdouble_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint32_t_longdouble_unbounded, element_flags_anonymous_map_uint32_t_longdouble_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint32_t_longdouble_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint32_t_longdouble_unbounded), key_flags_anonymous_map_uint32_t_longdouble_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint32_t_longdouble_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint32_t_longdouble_unbounded", type_ids_var_map_ulong_longdouble))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint32_t_longdouble_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ulong_longdouble = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ulong_longdouble = 0x00000000;
            bool common_var_map_ulong_longdouble_ec {false};
            CommonStructMember common_var_map_ulong_longdouble {TypeObjectUtils::build_common_struct_member(member_id_var_map_ulong_longdouble, member_flags_var_map_ulong_longdouble, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_longdouble, common_var_map_ulong_longdouble_ec))};
            if (!common_var_map_ulong_longdouble_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ulong_longdouble member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ulong_longdouble = "var_map_ulong_longdouble";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ulong_longdouble;
            ann_custom_MapKeyULongValueLongDouble.reset();
            CompleteMemberDetail detail_var_map_ulong_longdouble = TypeObjectUtils::build_complete_member_detail(name_var_map_ulong_longdouble, member_ann_builtin_var_map_ulong_longdouble, ann_custom_MapKeyULongValueLongDouble);
            CompleteStructMember member_var_map_ulong_longdouble = TypeObjectUtils::build_complete_struct_member(common_var_map_ulong_longdouble, detail_var_map_ulong_longdouble);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapKeyULongValueLongDouble, member_var_map_ulong_longdouble);
        }
        CompleteStructType struct_type_MapKeyULongValueLongDouble = TypeObjectUtils::build_complete_struct_type(struct_flags_MapKeyULongValueLongDouble, header_MapKeyULongValueLongDouble, member_seq_MapKeyULongValueLongDouble);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapKeyULongValueLongDouble, type_name_MapKeyULongValueLongDouble.to_string(), type_ids_MapKeyULongValueLongDouble))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapKeyULongValueLongDouble already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapULongBoolean_type_identifier(
        TypeIdentifierPair& type_ids_MapULongBoolean)
{

    ReturnCode_t return_code_MapULongBoolean {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapULongBoolean =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapULongBoolean", type_ids_MapULongBoolean);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapULongBoolean)
    {
        StructTypeFlag struct_flags_MapULongBoolean = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapULongBoolean = "MapULongBoolean";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapULongBoolean;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapULongBoolean;
        CompleteTypeDetail detail_MapULongBoolean = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapULongBoolean, ann_custom_MapULongBoolean, type_name_MapULongBoolean.to_string());
        CompleteStructHeader header_MapULongBoolean;
        header_MapULongBoolean = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapULongBoolean);
        CompleteStructMemberSeq member_seq_MapULongBoolean;
        {
            TypeIdentifierPair type_ids_var_map_ulong_boolean;
            ReturnCode_t return_code_var_map_ulong_boolean {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ulong_boolean =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint32_t_bool_unbounded", type_ids_var_map_ulong_boolean);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_boolean)
            {
                return_code_var_map_ulong_boolean =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_bool", type_ids_var_map_ulong_boolean);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_boolean)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_uint32_t_bool_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint32_t_bool_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_boolean, element_identifier_anonymous_map_uint32_t_bool_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint32_t_bool_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_bool_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ulong_boolean =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_var_map_ulong_boolean);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_boolean)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint32_t_bool_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint32_t_bool_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_boolean, key_identifier_anonymous_map_uint32_t_bool_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint32_t_bool_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_bool_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint32_t_bool_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint32_t_bool_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_bool_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint32_t_bool_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_bool_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint32_t_bool_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_bool_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint32_t_bool_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_bool_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint32_t_bool_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_bool_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint32_t_bool_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_bool_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_bool_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint32_t_bool_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_bool_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_bool_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint32_t_bool_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint32_t_bool_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint32_t_bool_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint32_t_bool_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint32_t_bool_unbounded, element_flags_anonymous_map_uint32_t_bool_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint32_t_bool_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint32_t_bool_unbounded), key_flags_anonymous_map_uint32_t_bool_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint32_t_bool_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint32_t_bool_unbounded", type_ids_var_map_ulong_boolean))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint32_t_bool_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ulong_boolean = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ulong_boolean = 0x00000000;
            bool common_var_map_ulong_boolean_ec {false};
            CommonStructMember common_var_map_ulong_boolean {TypeObjectUtils::build_common_struct_member(member_id_var_map_ulong_boolean, member_flags_var_map_ulong_boolean, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_boolean, common_var_map_ulong_boolean_ec))};
            if (!common_var_map_ulong_boolean_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ulong_boolean member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ulong_boolean = "var_map_ulong_boolean";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ulong_boolean;
            ann_custom_MapULongBoolean.reset();
            CompleteMemberDetail detail_var_map_ulong_boolean = TypeObjectUtils::build_complete_member_detail(name_var_map_ulong_boolean, member_ann_builtin_var_map_ulong_boolean, ann_custom_MapULongBoolean);
            CompleteStructMember member_var_map_ulong_boolean = TypeObjectUtils::build_complete_struct_member(common_var_map_ulong_boolean, detail_var_map_ulong_boolean);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapULongBoolean, member_var_map_ulong_boolean);
        }
        CompleteStructType struct_type_MapULongBoolean = TypeObjectUtils::build_complete_struct_type(struct_flags_MapULongBoolean, header_MapULongBoolean, member_seq_MapULongBoolean);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapULongBoolean, type_name_MapULongBoolean.to_string(), type_ids_MapULongBoolean))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapULongBoolean already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapULongOctet_type_identifier(
        TypeIdentifierPair& type_ids_MapULongOctet)
{

    ReturnCode_t return_code_MapULongOctet {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapULongOctet =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapULongOctet", type_ids_MapULongOctet);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapULongOctet)
    {
        StructTypeFlag struct_flags_MapULongOctet = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapULongOctet = "MapULongOctet";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapULongOctet;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapULongOctet;
        CompleteTypeDetail detail_MapULongOctet = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapULongOctet, ann_custom_MapULongOctet, type_name_MapULongOctet.to_string());
        CompleteStructHeader header_MapULongOctet;
        header_MapULongOctet = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapULongOctet);
        CompleteStructMemberSeq member_seq_MapULongOctet;
        {
            TypeIdentifierPair type_ids_var_map_ulong_octet;
            ReturnCode_t return_code_var_map_ulong_octet {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ulong_octet =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint32_t_byte_unbounded", type_ids_var_map_ulong_octet);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_octet)
            {
                return_code_var_map_ulong_octet =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_byte", type_ids_var_map_ulong_octet);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_octet)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_uint32_t_byte_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint32_t_byte_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_octet, element_identifier_anonymous_map_uint32_t_byte_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint32_t_byte_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_byte_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ulong_octet =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_var_map_ulong_octet);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_octet)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint32_t_byte_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint32_t_byte_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_octet, key_identifier_anonymous_map_uint32_t_byte_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint32_t_byte_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_byte_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint32_t_byte_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint32_t_byte_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_byte_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint32_t_byte_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_byte_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint32_t_byte_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_byte_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint32_t_byte_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_byte_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint32_t_byte_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_byte_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint32_t_byte_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_byte_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_byte_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint32_t_byte_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_byte_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_byte_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint32_t_byte_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint32_t_byte_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint32_t_byte_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint32_t_byte_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint32_t_byte_unbounded, element_flags_anonymous_map_uint32_t_byte_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint32_t_byte_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint32_t_byte_unbounded), key_flags_anonymous_map_uint32_t_byte_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint32_t_byte_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint32_t_byte_unbounded", type_ids_var_map_ulong_octet))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint32_t_byte_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ulong_octet = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ulong_octet = 0x00000000;
            bool common_var_map_ulong_octet_ec {false};
            CommonStructMember common_var_map_ulong_octet {TypeObjectUtils::build_common_struct_member(member_id_var_map_ulong_octet, member_flags_var_map_ulong_octet, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_octet, common_var_map_ulong_octet_ec))};
            if (!common_var_map_ulong_octet_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ulong_octet member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ulong_octet = "var_map_ulong_octet";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ulong_octet;
            ann_custom_MapULongOctet.reset();
            CompleteMemberDetail detail_var_map_ulong_octet = TypeObjectUtils::build_complete_member_detail(name_var_map_ulong_octet, member_ann_builtin_var_map_ulong_octet, ann_custom_MapULongOctet);
            CompleteStructMember member_var_map_ulong_octet = TypeObjectUtils::build_complete_struct_member(common_var_map_ulong_octet, detail_var_map_ulong_octet);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapULongOctet, member_var_map_ulong_octet);
        }
        CompleteStructType struct_type_MapULongOctet = TypeObjectUtils::build_complete_struct_type(struct_flags_MapULongOctet, header_MapULongOctet, member_seq_MapULongOctet);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapULongOctet, type_name_MapULongOctet.to_string(), type_ids_MapULongOctet))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapULongOctet already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapULongChar_type_identifier(
        TypeIdentifierPair& type_ids_MapULongChar)
{

    ReturnCode_t return_code_MapULongChar {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapULongChar =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapULongChar", type_ids_MapULongChar);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapULongChar)
    {
        StructTypeFlag struct_flags_MapULongChar = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapULongChar = "MapULongChar";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapULongChar;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapULongChar;
        CompleteTypeDetail detail_MapULongChar = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapULongChar, ann_custom_MapULongChar, type_name_MapULongChar.to_string());
        CompleteStructHeader header_MapULongChar;
        header_MapULongChar = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapULongChar);
        CompleteStructMemberSeq member_seq_MapULongChar;
        {
            TypeIdentifierPair type_ids_var_map_ulong_char;
            ReturnCode_t return_code_var_map_ulong_char {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ulong_char =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint32_t_char_unbounded", type_ids_var_map_ulong_char);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_char)
            {
                return_code_var_map_ulong_char =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_char", type_ids_var_map_ulong_char);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_char)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_uint32_t_char_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint32_t_char_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_char, element_identifier_anonymous_map_uint32_t_char_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint32_t_char_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_char_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ulong_char =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_var_map_ulong_char);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_char)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint32_t_char_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint32_t_char_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_char, key_identifier_anonymous_map_uint32_t_char_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint32_t_char_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_char_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint32_t_char_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint32_t_char_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_char_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint32_t_char_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_char_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint32_t_char_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_char_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint32_t_char_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_char_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint32_t_char_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_char_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint32_t_char_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_char_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_char_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint32_t_char_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_char_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_char_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint32_t_char_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint32_t_char_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint32_t_char_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint32_t_char_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint32_t_char_unbounded, element_flags_anonymous_map_uint32_t_char_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint32_t_char_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint32_t_char_unbounded), key_flags_anonymous_map_uint32_t_char_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint32_t_char_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint32_t_char_unbounded", type_ids_var_map_ulong_char))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint32_t_char_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ulong_char = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ulong_char = 0x00000000;
            bool common_var_map_ulong_char_ec {false};
            CommonStructMember common_var_map_ulong_char {TypeObjectUtils::build_common_struct_member(member_id_var_map_ulong_char, member_flags_var_map_ulong_char, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_char, common_var_map_ulong_char_ec))};
            if (!common_var_map_ulong_char_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ulong_char member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ulong_char = "var_map_ulong_char";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ulong_char;
            ann_custom_MapULongChar.reset();
            CompleteMemberDetail detail_var_map_ulong_char = TypeObjectUtils::build_complete_member_detail(name_var_map_ulong_char, member_ann_builtin_var_map_ulong_char, ann_custom_MapULongChar);
            CompleteStructMember member_var_map_ulong_char = TypeObjectUtils::build_complete_struct_member(common_var_map_ulong_char, detail_var_map_ulong_char);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapULongChar, member_var_map_ulong_char);
        }
        CompleteStructType struct_type_MapULongChar = TypeObjectUtils::build_complete_struct_type(struct_flags_MapULongChar, header_MapULongChar, member_seq_MapULongChar);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapULongChar, type_name_MapULongChar.to_string(), type_ids_MapULongChar))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapULongChar already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapULongWChar_type_identifier(
        TypeIdentifierPair& type_ids_MapULongWChar)
{

    ReturnCode_t return_code_MapULongWChar {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapULongWChar =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapULongWChar", type_ids_MapULongWChar);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapULongWChar)
    {
        StructTypeFlag struct_flags_MapULongWChar = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapULongWChar = "MapULongWChar";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapULongWChar;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapULongWChar;
        CompleteTypeDetail detail_MapULongWChar = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapULongWChar, ann_custom_MapULongWChar, type_name_MapULongWChar.to_string());
        CompleteStructHeader header_MapULongWChar;
        header_MapULongWChar = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapULongWChar);
        CompleteStructMemberSeq member_seq_MapULongWChar;
        {
            TypeIdentifierPair type_ids_var_map_ulong_wchar;
            ReturnCode_t return_code_var_map_ulong_wchar {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ulong_wchar =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint32_t_wchar_t_unbounded", type_ids_var_map_ulong_wchar);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_wchar)
            {
                return_code_var_map_ulong_wchar =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_wchar_t", type_ids_var_map_ulong_wchar);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_wchar)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_map_uint32_t_wchar_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint32_t_wchar_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_wchar, element_identifier_anonymous_map_uint32_t_wchar_t_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint32_t_wchar_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_wchar_t_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ulong_wchar =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_var_map_ulong_wchar);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_wchar)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint32_t_wchar_t_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint32_t_wchar_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_wchar, key_identifier_anonymous_map_uint32_t_wchar_t_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint32_t_wchar_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_wchar_t_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint32_t_wchar_t_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint32_t_wchar_t_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_wchar_t_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint32_t_wchar_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_wchar_t_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint32_t_wchar_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_wchar_t_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint32_t_wchar_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_wchar_t_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint32_t_wchar_t_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_wchar_t_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint32_t_wchar_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_wchar_t_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_wchar_t_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint32_t_wchar_t_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_wchar_t_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_wchar_t_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint32_t_wchar_t_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint32_t_wchar_t_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint32_t_wchar_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint32_t_wchar_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint32_t_wchar_t_unbounded, element_flags_anonymous_map_uint32_t_wchar_t_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint32_t_wchar_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint32_t_wchar_t_unbounded), key_flags_anonymous_map_uint32_t_wchar_t_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint32_t_wchar_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint32_t_wchar_t_unbounded", type_ids_var_map_ulong_wchar))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint32_t_wchar_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ulong_wchar = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ulong_wchar = 0x00000000;
            bool common_var_map_ulong_wchar_ec {false};
            CommonStructMember common_var_map_ulong_wchar {TypeObjectUtils::build_common_struct_member(member_id_var_map_ulong_wchar, member_flags_var_map_ulong_wchar, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_wchar, common_var_map_ulong_wchar_ec))};
            if (!common_var_map_ulong_wchar_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ulong_wchar member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ulong_wchar = "var_map_ulong_wchar";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ulong_wchar;
            ann_custom_MapULongWChar.reset();
            CompleteMemberDetail detail_var_map_ulong_wchar = TypeObjectUtils::build_complete_member_detail(name_var_map_ulong_wchar, member_ann_builtin_var_map_ulong_wchar, ann_custom_MapULongWChar);
            CompleteStructMember member_var_map_ulong_wchar = TypeObjectUtils::build_complete_struct_member(common_var_map_ulong_wchar, detail_var_map_ulong_wchar);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapULongWChar, member_var_map_ulong_wchar);
        }
        CompleteStructType struct_type_MapULongWChar = TypeObjectUtils::build_complete_struct_type(struct_flags_MapULongWChar, header_MapULongWChar, member_seq_MapULongWChar);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapULongWChar, type_name_MapULongWChar.to_string(), type_ids_MapULongWChar))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapULongWChar already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapULongString_type_identifier(
        TypeIdentifierPair& type_ids_MapULongString)
{

    ReturnCode_t return_code_MapULongString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapULongString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapULongString", type_ids_MapULongString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapULongString)
    {
        StructTypeFlag struct_flags_MapULongString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapULongString = "MapULongString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapULongString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapULongString;
        CompleteTypeDetail detail_MapULongString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapULongString, ann_custom_MapULongString, type_name_MapULongString.to_string());
        CompleteStructHeader header_MapULongString;
        header_MapULongString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapULongString);
        CompleteStructMemberSeq member_seq_MapULongString;
        {
            TypeIdentifierPair type_ids_var_map_ulong_string;
            ReturnCode_t return_code_var_map_ulong_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ulong_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint32_t_anonymous_string_unbounded_unbounded", type_ids_var_map_ulong_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_string)
            {
                return_code_var_map_ulong_string =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_string_unbounded", type_ids_var_map_ulong_string);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_string)
                {
                    {
                        SBound bound = 0;
                        StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                                "anonymous_string_unbounded", type_ids_var_map_ulong_string))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_string, element_identifier_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_anonymous_string_unbounded_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ulong_string =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_var_map_ulong_string);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_string)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_string, key_identifier_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_anonymous_string_unbounded_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded, element_flags_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded), key_flags_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint32_t_anonymous_string_unbounded_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint32_t_anonymous_string_unbounded_unbounded", type_ids_var_map_ulong_string))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_map_uint32_t_anonymous_string_unbounded_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_map_ulong_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_map_ulong_string = 0x00000000;
            bool common_var_map_ulong_string_ec {false};
            CommonStructMember common_var_map_ulong_string {TypeObjectUtils::build_common_struct_member(member_id_var_map_ulong_string, member_flags_var_map_ulong_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_string, common_var_map_ulong_string_ec))};
            if (!common_var_map_ulong_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_map_ulong_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_map_ulong_string = "var_map_ulong_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_map_ulong_string;
            ann_custom_MapULongString.reset();
            CompleteMemberDetail detail_var_map_ulong_string = TypeObjectUtils::build_complete_member_detail(name_var_map_ulong_string, member_ann_builtin_var_map_ulong_string, ann_custom_MapULongString);
            CompleteStructMember member_var_map_ulong_string = TypeObjectUtils::build_complete_struct_member(common_var_map_ulong_string, detail_var_map_ulong_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_MapULongString, member_var_map_ulong_string);
        }
        CompleteStructType struct_type_MapULongString = TypeObjectUtils::build_complete_struct_type(struct_flags_MapULongString, header_MapULongString, member_seq_MapULongString);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MapULongString, type_name_MapULongString.to_string(), type_ids_MapULongString))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MapULongString already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MapULongWString_type_identifier(
        TypeIdentifierPair& type_ids_MapULongWString)
{

    ReturnCode_t return_code_MapULongWString {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MapULongWString =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MapULongWString", type_ids_MapULongWString);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MapULongWString)
    {
        StructTypeFlag struct_flags_MapULongWString = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_MapULongWString = "MapULongWString";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MapULongWString;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MapULongWString;
        CompleteTypeDetail detail_MapULongWString = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MapULongWString, ann_custom_MapULongWString, type_name_MapULongWString.to_string());
        CompleteStructHeader header_MapULongWString;
        header_MapULongWString = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MapULongWString);
        CompleteStructMemberSeq member_seq_MapULongWString;
        {
            TypeIdentifierPair type_ids_var_map_ulong_wstring;
            ReturnCode_t return_code_var_map_ulong_wstring {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_map_ulong_wstring =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded", type_ids_var_map_ulong_wstring);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_wstring)
            {
                return_code_var_map_ulong_wstring =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_wstring_unbounded", type_ids_var_map_ulong_wstring);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_wstring)
                {
                    {
                        SBound bound = 0;
                        StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                                "anonymous_wstring_unbounded", type_ids_var_map_ulong_wstring, true))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_wstring_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_wstring, element_identifier_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded_ec))};
                if (!element_identifier_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded inconsistent element TypeIdentifier.");
                    return;
                }
                return_code_var_map_ulong_wstring =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_var_map_ulong_wstring);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_map_ulong_wstring)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Map key TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool key_identifier_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded_ec {false};
                TypeIdentifier* key_identifier_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_map_ulong_wstring, key_identifier_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded_ec))};
                if (!key_identifier_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded inconsistent key TypeIdentifier.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded = EK_BOTH;
                if ((EK_COMPLETE == key_identifier_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded->_d()) ||
                        (TI_PLAIN_SEQUENCE_SMALL == element_identifier_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded->seq_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_SEQUENCE_LARGE == element_identifier_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded->seq_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_SMALL == element_identifier_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded->array_sdefn().header().equiv_kind()) ||
                        (TI_PLAIN_ARRAY_LARGE == element_identifier_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded->_d() && EK_COMPLETE == element_identifier_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded->array_ldefn().header().equiv_kind()) ||
                        (TI_PLAIN_MAP_SMALL == element_identifier_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded->map_sdefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded->map_sdefn().header().equiv_kind())) ||
                        (TI_PLAIN_MAP_LARGE == element_identifier_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded->_d() && (EK_COMPLETE == element_identifier_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded->map_ldefn().key_identifier()->_d() || EK_COMPLETE == element_identifier_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded->map_ldefn().header().equiv_kind())))
                {
                    equiv_kind_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded = EK_COMPLETE;
                }
                CollectionElementFlag element_flags_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded = 0;
                CollectionElementFlag key_flags_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded = 0;
                PlainCollectionHeader header_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded, element_flags_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded);
                {
                    SBound bound = 0;
                    PlainMapSTypeDefn map_sdefn = TypeObjectUtils::build_plain_map_s_type_defn(header_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded), key_flags_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded,
                                eprosima::fastcdr::external<TypeIdentifier>(key_identifier_anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_map_type_identifier(map_sdefn, "anonymous_map_uint32_t_anonymous_wstring_unbounded_unbounded", type_ids_var_map_ulong_wstring))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                      