-------------------------------------------------------------------------------
--									     --
--  Filename        : $Source: /cvsroot/gnade/gnade/tools/files.ads,v $
--  Description     : Export the contents of a data base                     --
--  Author          : Michael Erdmann                                        --
--  Created         : 5.4.2003                                               --
--  Last Modified By: $Author: persan $				     --
--  Last Modified On: $Date: 2007/08/25 12:43:35 $			     --
--  Status          : $State: Exp $					     --
--									     --
--  Copyright (C) 2000 - 2003 Michael Erdmann                                --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
--  Functional Description                                                   --
--  ======================                                                   --
--                                                                           --
--  Export the contents of a table into a simple file format. This file      --
--  format i intended for importing or processing by other gnade tools       --
--                                                                           --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--  None                                                                     --
--                                                                           --
--  References                                                               --
--  ==========                                                               --
--  None                                                                     --
--                                                                           --
-------------------------------------------------------------------------------
with Tools;                                      use Tools;

package Files is

   Opt_Verbose : Boolean := False;

   type Object is private;

   -------------------
   -- Contents_Type --
   -------------------
   type Contents_Type is (
                          Database_Export,
                          Null_Contents_Type
                         );

   ----------------
   -- Initialize --
   ----------------
   procedure Initialize (
                         This : in out Object);

   --------------
   -- Finalize --
   --------------
   procedure Finalize (
                       This : in out Object);

   ------------
   -- Fields --
   ------------
   procedure Fields (
                     This : in out Object;
                     Info : in String_Array_Access);

   ------------
   -- Fields --
   ------------
   function Fields (
                    This : in Object) return String_Array_Access;

   -----------------
   -- End_of_File --
   -----------------
   function End_Of_File (
                         This : in Object) return Boolean;

   ----------
   -- Open --
   ----------
   procedure Open (
                   This     : in out Object;
                   Name     : in String;
                   Contents : in Contents_Type := Database_Export);

   ------------
   -- Create --
   ------------
   procedure Create (
                     This     : in out Object;
                     Name     : in String        := "";
                     Contents : in Contents_Type := Database_Export);

   -----------
   -- Close --
   -----------
   procedure Close (
                    This : in out Object);

   ----------
   -- Read --
   ----------
   function Read (
                  This : in  Object) return String_Array_Access;

   -----------
   -- Write --
   -----------
   procedure Write (
                    This  : in out Object;
                    Items : in String_Array_Access);

   File_Not_Existing    : exception;
   Unexpected_File_Type : exception;


private
   type Object_Data_Type;
   type Object_Data_Access is access Object_Data_Type;

   type Object is record
      Data : Object_Data_Access := null;
   end record;

end Files;
