headings 10
Tests 23
add
adf
bkw
chow
coeffsum
coint
coint2
cusum
difftest
hausman
kpss
leverage
levinlin
meantest
modtest
normtest
omit
qlrtest
reset
restrict
runs
vartest
vif
Graphs 10
boxplot
gnuplot
graphpg
hfplot
panplot
plot
qqplot
rmplot
scatters
textplot
Statistics 14
anova
corr
corrgm
fractint
freq
hurst
mahal
pca
pergm
pvalue
spearman
summary
xcorrgm
xtab
Dataset 18
append
data
dataset
delete
genr
info
join
labels
markers
nulldata
open
rename
setinfo
setmiss
setobs
smpl
store
varlist
Estimation 35
ar
ar1
arbond
arch
arima
arma
biprobit
dpanel
duration
equation
estimate
garch
gmm
heckit
hsk
intreg
lad
logistic
logit
midasreg
mle
mpols
negbin
nls
ols
panel
poisson
probit
quantreg
system
tobit
tsls
var
vecm
wls
Programming 20
break
catch
clear
debug
elif
else
end
endif
endloop
flush
foreign
funcerr
function
if
include
loop
makepkg
run
set
setopt
Transformations 10
diff
discrete
dummify
lags
ldiff
logs
orthdev
sdiff
square
stdize
Utilities 6
eval
help
modeltab
pkg
quit
shell
Printing 7
eqnprint
modprint
outfile
print
printf
sprintf
tabprint
Prediction 1
fcast

# add Tests

Argumento:  listavariables 
Opciones:   --lm (Hace un contraste de ML; solo con MCO)
            --quiet (Presenta solo los resultados básicos del contraste)
            --silent (No presenta nada)
            --vcv (Presenta la matriz de covarianzas del modelo ampliado)
            --both (Solo para estimación VI; mira abajo)
Ejemplos:   add 5 7 9
            add xx yy zz --quiet

Debes solicitar esta instrucción después de ejecutar una instrucción de
estimación. Realiza un contraste conjunto (cuyos resultados puedes obtener
con los accesorios "$test" y "$pvalue") sobre la adición de las variables
indicadas en el argumento, al último modelo estimado.

Por defecto, se estima una versión "ampliada" del modelo original, que
resulta al añadirle a este las variables del argumento listavariables, como
regresores. En este caso, el contraste es de tipo Wald sobre el modelo
ampliado, pasando a ser este el "modelo vigente" en lugar del original.
Debes tener esto en cuenta, por ejemplo, para usar $uhat porque este permite
recuperar los errores del que sea el modelo vigente en cada momento, o para
hacer contrastes posteriores.

Alternativamente, si indicas la opción --lm (que solo está disponible para
aquellos modelos estimados mediante MCO), se realiza un contraste de
Multiplicadores de Lagrange. Para eso, se ejecuta una regresión auxiliar en
la que el error de estimación del último modelo se toma como variable
dependiente; y las variables independientes son las de ese último modelo
más las de listavariables. Bajo la hipótesis nula de que las variables
añadidas no tienen una capacidad explicativa adicional, el estadístico
formado multiplicando el tamaño de la muestra por el R-cuadrado de esta
regresión, tiene la distribución de una variable chi-cuadrado con tantos
grados de libertad como el número de regresores añadidos. En este caso, el
modelo original no se substituye por el modelo de la regresión auxiliar.

La opción --both es específica del método de estimación de Mínimos
Cuadrados en 2 Etapas. Indica que las nuevas variables deben añadirse tanto
a la lista de los regresores como a la lista de los instrumentos, puesto que
cuando no se indica nada, se añaden por defecto solo a la de regresores.

Menú gráfico: Ventana de modelo: Contrastes/Añadir variables

# adf Tests

Argumentos: orden listavariables 
Opciones:   --nc (Sin constante)
            --c (Con constante)
            --ct (Con constante más tendencia)
            --ctt (Con constante, más tendencia cuadrática)
            --seasonals (Incluye variables ficticias estacionales)
            --gls (Detrae la media o la tendencia usando MCG)
            --verbose (Muestra los resultados de la regresión)
            --quiet (No presenta los resultados)
            --difference (Usa las primeras diferencias de la variable)
            --test-down[=criterio] (Orden de retardos automático)
            --perron-qu (Mira abajo)
Ejemplos:   adf 0 y
            adf 2 y --nc --c --ct
            adf 12 y --c --test-down
            Ver también jgm-1996.inp

Las opciones que se muestran abajo y la discusión que sigue, se
corresponden con el uso de la instrucción adf con datos de series
temporales típicos. Para utilizar esta instrucción con datos de panel,
mira más abajo.

Calcula un conjunto de contrastes de Dickey-Fuller sobre cada una de las
variables del argumento, siendo la hipótesis nula la existencia de una
raíz unitaria. (Ahora bien, cuando escoges la opción --difference, se
calcula la primera diferencia de la(s) variable(s) antes de hacer el
contraste, y la discusión de abajo debes entenderla como referida a la(s)
variable(s) transformada(s).)

Por defecto, se muestran dos variantes del contraste: una basada en una
regresión que utiliza una constante, y otra que utiliza una constante más
una tendencia lineal. Puedes controlar las variantes que se presentan
especificando uno o más de los indicadores de opción.

Puedes utilizar la opción --gls junto con alguna de las dos opciones --c y
--ct (el modelo con constante o el modelo con constante más tendencia). El
efecto de esta opción es que la detracción de la media o de la tendencia
de la variable que se quiere contrastar, se hace utilizando el procedimiento
de Mínimos Cuadrados Generalizados sugerido por Elliott, Rothenberg y Stock
(1996), que proporciona un contraste de mayor potencia que la aproximación
estándar de Dickey-Fuller. Esta opción no es compatible con --nc, --ctt ni
--seasonals.

En todos los casos, la variable dependiente es la primera diferencia de la
variable especificada (y) y la variable independiente clave es el primer
retardo de y. El modelo se construye de modo que el coeficiente de la
variable y retardada, es igual a la raíz en cuestión menos 1. Por ejemplo,
el modelo con constante puede escribirse como

  (1 - L)y(t) = b0 + (a-1)y(t-1) + e(t)

Bajo la hipótesis nula de existencia de una raíz unitaria, el coeficiente
de la variable y retardada es igual a cero; y bajo la hipótesis alternativa
de que y es estacionaria, este coeficiente es negativo.

Selección del orden de retardos

Si el argumento orden (de aquí en adelante le llamaremos k) es mayor que 0,
entonces se incluyen k retardos de la variable dependiente en el lado
derecho de la regresión que se estima para calcular el estadístico de
contraste en cada caso. Cuando indicas el orden de retardos como -1, k se
establece siguiendo lo aconsejado por Schwert (1989): concretamente se toma
la parte entera de calcular 12(T/100)^0.25, donde T indica el tamaño de la
muestra. Sin embargo, en cada caso en el que indicas la opción --test-down,
entonces k se toma como el retardo máximo, y el orden de retardos concreto
que se utilizará, se obtiene probando hacia abajo. Puedes escoger el
criterio para ir probando hacia abajo, utilizando uno de los parámetros de
opción que deberá ser AIC (por defecto), BIC o tstat.

Cuando pides que se pruebe hacia atrás mediante AIC o BIC, el orden de
retardos final para la ecuación ADF es el que optimiza el criterio de
información escogido (de Akaike o Bayesiano de Schwarz). El procedimiento
exacto depende de si indicas o no la opción --gls: cuando se especifica la
detracción con MCG (GLS) de la tendencia, los AIC y BIC son las versiones
"modificadas" descritas en Ng y Perron (2001); en otro caso, son las
versiones estándar. En caso de MCG, dispones de un refinamiento pues cuando
indicas la opción adicional --perron-qu, se calculan estos criterios de
información modificados de acuerdo con el método revisado que recomendaron
Perron y Qu (2007).

Cuando pides que se pruebe hacia atrás mediante el método del estadístico
t, el procedimiento es como se indica a continuación:

1. Se estima la regresión de Dickey-Fuller utilizando k retardos de la
   variable dependiente.

2. ¿Es significativo el último retardo? Si lo es, se ejecuta el contraste
   con un orden de retardos k. Si no lo es, se hace que k = k - 1, y se
   vuelve al paso 1 con un retardo menos. El proceso se repite hasta que sea
   significativo el último retardo de una regresión, o hasta que k sea 0
   (se haría el contraste con un orden de retardos igual a 0).

En el contexto del paso 2 de arriba, "significativo" quiere decir que el
estadístico t del último retardo tiene un valor p asintótico de dos colas
igual o menor que 0.10, frente a la distribución Normal.

Los valores P para los contrastes de Dickey-Fuller están basados en
MacKinnon (1996); y el código relevante se incluye con el amable permiso
del propio autor. En el caso del contraste con la tendencia lineal
utilizando MCG (GLS), estos valores P no son aplicables; por eso, en su
lugar se muestran los puntos críticos de la Tabla 1 que hay en Elliott,
Rothenberg y Stock (1996).

Datos de Panel

Cuando se utiliza la instrucción adf con datos de panel para hacer un
contraste de raíz unitaria de panel, las opciones aplicables y los
resultados que se muestran son algo diferentes.

Primero, mientras que puedes indicar una lista de variables para probar en
el caso de series temporales típicas, con datos de panel solo puedes
contrastar una variable por cada instrucción. Segundo, las opciones que
manejan la inclusión de términos determinísticos pasan a ser mutuamente
excluyentes: debes escoger una entre sin constante, con constante, y con
constante más tendencia; por defecto es con constante. Además, la opción
--seasonals no está disponible. Tercero, la opción --verbose aquí tiene
un significado diferente: produce un breve informe del contraste para cada
serie temporal individual (siendo este por defecto una presentación solo
del resultado global).

Se calcula el contraste global (Hipótesis nula: La serie en cuestión tiene
una raíz unitaria para todas las unidades del panel) de una o las dos
formas siguientes: utilizando el método de Im, Pesaran y Shin (Journal of
Econometrics, 2003) o la de Choi (Journal of International Money and
Finance, 2001) El contraste de Choi requiere que estén disponibles las
probabilidades asociadas (valores P) para los contrastes individuales; si
este no es el caso (dependiendo de las opciones escogidas), se omite. El
estadístico concreto proporcionado para el contraste de Im, Pesaran y Shin
varía del modo siguiente: si el orden de retardo para el contraste no es
cero, se muestra su estadístico W; por otro lado, si las longitudes de las
series de tiempo difieren de un individuo a otro, se muestra su estadístico
Z; en otro caso, se muestra su estadístico t-barra. Consulta también la
instrución "levinlin".

Menú gráfico: /Variable/Contrastes de raíz unitaria/Contraste aumentado de Dickey-Fuller

# anova Statistics

Argumentos: respuesta tratamiento [ control ] 
Opción:     --quiet (No presenta los resultados)

Análisis de la Varianza: El argumento respuesta deberá ser una serie que
mida algún efecto de interés, y tratamiento deberá ser una variable
discreta que codifique dos o más tipos de tratamiento (o no tratamiento).
Para un ANOVA de dos factores, la variable control (que también será
discreta) deberá codificar los valores de alguna variable de control.

Excepto cuando indicas la opción --quiet, esta instrucción presenta una
tabla mostrando las sumas de cuadrados y los cuadrados de la media junto con
un contraste F. Puedes recuperar el estadístico del contraste F y su
probabilidad asociada, utilizando los accesorios "$test" y "$pvalue",
respectivamente.

La hipótesis nula del contraste F es que la respuesta media es invariante
con respecto al tipo de tratamiento o, en otras palabras, que el tratamiento
no tiene efecto. Hablando estrictamente, el contraste solo es válido cuando
la varianza de la respuesta es la misma para todos los tipos de tratamiento.

Ten en cuenta que los resultados que muestra esta instrucción son de hecho
un subconjunto de la información ofrecida por el siguiente procedimiento,
que puedes preparar fácilmente en el Gretl. (1) Genera un conjunto de
variables ficticias que codifiquen todos los tipos de tratamiento excepto
uno. Para un ANOVA de dos factores, genera además un conjunto de variables
ficticias que codifiquen todos los bloques de "control" excepto uno. (2) Haz
la regresión de respuesta sobre una constante y las variables ficticias
utilizando "ols". Con un único factor, se presenta la tabla ANOVA mediante
la opción --anova en esa función ols. En caso de dos factores, el
contraste F relevante lo encuentras utilizando la instrucción "omit" luego
de la regresión. Por ejemplo, (asumiendo que respuesta es y, que xt
codifica el tratamiento, y que xb codifica los bloques de "control"):

	# Un factor
	list Fict_xt = dummify(xt)
	ols y 0 Fict_xt --anova
	# Dos factores
	list Fict_xb = dummify(xb)
	ols y 0 Fict_xt Fict_xb
	# Contraste de significación conjunta de Fict_xt
	omit Fict_xt --quiet

Menú gráfico: /Modelo/Otros modelos lineales/ANOVA

# append Dataset

Argumento:  nombrearchivo 
Opciones:   --time-series (Mira abajo)
            --fixed-sample (Mira abajo)
            --update-overlap (Mira abajo)
            --quiet (No presenta nada)
            Mira abajo para opciones adicionales especiales

Abre un archivo de datos y agrega el contenido al conjunto vigente de datos,
si los nuevos datos son compatibles. El programa intentará detectar el
formato del archivo de datos (propio, texto plano, CSV, Gnumeric, Excel,
etc.).

Los datos añadidos pueden tener el formato de observaciones adicionales
sobre series ya presentes en el conjunto de datos, y/o el formato de nuevas
series. En caso de añadir series, la compatibilidad requiere (a) que el
número de observaciones de los nuevos datos sea igual al número de datos
actuales, o (b) que los nuevos datos conlleven clara información de las
observaciones de modo que Gretl pueda deducir como colocar los valores.

Un caso que no se admite es aquel en el que los nuevos datos comienzan antes
y acaban después que los datos originales. Para añadir series en esa
situación, puedes utilizar la opción --fixed-sample; esto tiene como
efecto que se suprime la adición de observaciones, por lo que así, la
operación se restringe únicamente a añadir series nuevas.

Se admite una característica especial cuando se añaden datos a un conjunto
de datos de panel. Sirva n para denotar el número de unidades atemporales
en el panel, T para denotar el número de períodos de tiempo, y m para
denotar el número de observaciones de los nuevos datos. Si m = n, los
nuevos datos se consideran invariantes en el tiempo, y se copian repetidos
para cada período de tiempo. Por otro lado, si m = T los datos se tratan
como invariantes entre las unidades atemporales, y se copian repetidos para
cada unidad atemporal. Si el panel es "cuadrado", y m es igual tanto a n
como a T, aparece una ambigüedad. Por defecto, en este caso se tratan los
nuevos datos como invariantes en el tiempo, pero puedes forzar a que Gretl
trate los nuevos datos como series temporales con la opción --time-series.
(Esta posibilidad se ignora en todos los otros casos.)

Cuando se selecciona un archivo de datos para agregar, puede haber un área
de solapamiento con el conjunto de datos existente; es decir, una o más
series pueden tener una o más observaciones en común entre los dos
orígenes. Cuando indicas la opción --update-overlap, la instrucción
append substituye cualquier observación solapada con los valores del
archivo de datos escogido; en otro caso, los valores que en ese momento ya
están en su sitio no se ven afectados.

Las opciones especiales adicionales --sheet, --coloffset, --rowoffset y
--fixed-cols funcionan del mismo modo que con "open"; consulta esa
instrucción para obtener más explicaciones.

Consulta también "join" para un manejo más sofisticado de orígenes de
datos múltiples.

Menú gráfico: /Archivo/Añadir datos

# ar Estimation

Argumentos: retardos ; depvar indepvars 
Opciones:   --vcv (Presenta la matriz de covarianzas)
            --quiet (No presenta las estimaciones de los parámetros)
Ejemplo:    ar 1 3 4 ; y 0 x1 x2 x3

Calcula las estimaciones de los parámetros utilizando el procedimiento
iterativo generalizado de Cochrane-Orcutt; consulta la Sección 9.5 de
Ramanathan (2002). Las iteraciones acaban cuando la sucesión de sumas de
errores cuadrados no difiere de un término al siguiente en más del 0.005
por ciento, o después de 20 iteraciones.

Con "retardos" tienes que indicar una lista de retardos del término de
perturbación, acabada en un punto y coma. En el ejemplo de arriba, el
término de perturbación se especifica como

  u(t) = rho(1)*u(t-1) + rho(3)*u(t-3) + rho(4)*u(t-4)

Menú gráfico: /Modelo/Series temporales univariantes/Errores AR (MCG)

# ar1 Estimation

Argumentos: depvar indepvars 
Opciones:   --hilu (Utiliza el procedimiento de Hildreth-Lu)
            --pwe (Utiliza el estimador de Prais-Winsten)
            --vcv (Presenta la matriz de covarianzas)
            --no-corc (No afina los resultados con Cochrane-Orcutt)
            --loose (Utiliza un criterio de convergencia menos preciso)
            --quiet (No presenta nada)
Ejemplos:   ar1 1 0 2 4 6 7
            ar1 y 0 xlista --pwe
            ar1 y 0 xlista --hilu --no-corc

Calcula estimaciones MCG que sean viables para un modelo en el que el
término de perturbación se asume que sigue un proceso autorregresivo de
primer orden.

El método utilizado por defecto es el procedimiento iterativo de
Cochrane-Orcutt; por ejemplo, consulta la sección 9.4 de Ramanathan (2002).
El criterio para lograr la convergencia es que las estimaciones sucesivas
del coeficiente de autocorrelación, no difieran en más de 1e-6 o, cuando
indicas la opción --loose, en más de 0.001. Si esto no se alcanza antes de
que se hagan las 100 iteraciones, se muestra un fallo.

Cuando indicas la opción --pwe, se utiliza el estimador de Prais-Winsten.
Esto implica una iteración similar a la de Cochrane-Orcutt; la diferencia
está en que mientras que el método de Cochrane-Orcutt descarta la primera
observación, el método de Prais-Winsten hace uso de ella. Para obtener
más detalles consulta, por ejemplo, el capítulo 13 de Greene (2000).

Cuando indicas la opción --hilu, se utiliza el procedimiento de búsqueda
de Hildreth-Lu. En ese caso, se afinan los resultados utilizando el método
de Cochrane-Orcutt, excepto que especifiques la opción --no-corc. Esta
opción --no-corc se ignora para estimadores diferentes al del método de
Hildreth-Lu.

Menú gráfico: /Modelo/Series temporales univariantes/Errores AR (MCG)

# arbond Estimation

Argumento:  p [ q ] ; depvar indepvars [ ; instrumentos ] 
Opciones:   --quiet (No muestra el modelo estimado)
            --vcv (Presenta la matriz de covarianzas)
            --two-step (Realiza la estimación MGM (GMM) en 2 etapas)
            --time-dummies (Añade variables ficticias temporales)
            --asymptotic (Desviaciones típicas asintóticas sin corregir)
Ejemplos:   arbond 2 ; y Dx1 Dx2
            arbond 2 5 ; y Dx1 Dx2 ; Dx1
            arbond 1 ; y Dx1 Dx2 ; Dx1 GMM(x2,2,3)
            Ver también arbond91.inp

Realiza la estimación de modelos dinámicos con datos de panel (es decir,
modelos de panel que incluyen uno o más retardos de la variable
dependiente) utilizando el método MGM-DIF establecido por Arellano y Bond
(1991). Consulta "dpanel" para ver los detalles de una versión actualizada
y más flexible de esta instrucción, que permite manejar tanto MGM-SIS como
MGM-DIF.

El parámetro p representa el orden de la autorregresión de la variable
dependiente. El parámetro q (opcional) indica el retardo máximo en el
orden de la variable dependiente que se va a utilizar como instrumento.
Cuando omites este argumento o indicas que es 0, se utilizan todos los
retardos disponibles.

Debes indicar la variable dependiente en su nivel, pues ya se va a calcular
automáticamente su diferencia (puesto que este estimador utiliza la
diferenciación para eliminar los efectos individuales). Las diferencias de
las variables independientes no se van a calcular automáticamente; si
quieres utilizar estas diferencias (lo que será el caso general para
variables cuantitativas habituales, aunque quizás no para variables
ficticias temporales) debes generar primero las diferencias y luego indicar
que estas son regresores.

El último campo (opcional) de la instrucción es para especificar los
instrumentos. Si no indicas instrumentos, se asume que todas las variables
independientes son estrictamente exógenas. Y si especificas algún
instrumento, debes incluir en la lista alguna variable independiente
estrictamente exógena. Con regresores predeterminados, puedes utilizar la
función GMM para incluir un rango indicado de retardos en disposición
diagonal por bloques; como se ilustra en el tercer ejemplo de arriba. Así,
el primer argumento de GMM es el nombre de la variable en cuestión, el
segundo es el retardo mínimo que se utiliza como instrumento, y el tercero
es el retardo máximo. Cuando indicas el tercero argumento con un 0, se
utilizan todos los retardos disponibles.

Por defecto, se presentan los resultados de la estimación en una etapa (con
las desviaciones típicas robustas), pero puedes escoger la estimación en 2
etapas como opción. En ambos casos, se proporcionan los contrastes de
autocorrelación de orden 1 y 2, así como también el contraste de
sobreidentificación de Sargan y el estadístico de contraste de Wald para
la significación conjunta de los regresores. Ten en cuenta que en este
modelo diferenciado, la autocorrelación de primer orden no es una amenaza
para la validez del modelo, pero la autocorrelación de segundo orden viola
los supuestos estadísticos que lo sostienen.

En el caso de la estimación en 2 etapas, las desviaciones típicas se
calculan por defecto utilizando la corrección de muestra finita sugerida
por Windmeijer (2005). Las desviaciones típicas asintóticas estándar,
asociadas al estimador del método en 2 etapas, generalmente se considera
que son una guía poco fiable para la inferencia, pero si quieres verlas por
alguna razón puedes utilizar la opción --asymptotic para inhabilitar así
la corrección de Windmeijer.

Cuando indicas la opción --time-dummies, se añade un conjunto de variables
ficticias temporales a los regresores especificados. El número de variables
ficticias es igual al número máximo de períodos utilizados en la
estimación menos uno, para evitar multicolinealidad perfecta con la
constante. Las variables ficticias se introducen en niveles; si quieres
utilizar variables ficticias temporales en forma de primeras diferencias,
tienes que definir y añadir estas variables manualmente.

# arch Estimation

Argumentos: orden depvar indepvars 
Opción:     --quiet (No presenta nada)
Ejemplo:    arch 4 y 0 x1 x2 x3

En este momento, esta instrucción se mantiene por compatibilidad con
versiones anteriores, pero sales ganando si utilizas el estimador máximo
verosímil que ofrece la instrucción "garch". Si quieres estimar un modelo
ARCH sencillo, puedes usar el GARCH haciendo que su primer parámetro sea 0.

Estima la especificación indicada del modelo permitiendo ARCH
(Heterocedasticidad Condicional Autorregresiva). Primero, se estima el
modelo mediante MCO, y luego se ejecuta una regresión auxiliar, en la que
se regresa el error cuadrado de la primera sobre sus propios valores
retardados. El paso final es la estimación por mínimos cuadrados
ponderados, utilizando como ponderaciones las inversas de las varianzas de
los errores ajustados con la regresión auxiliar. (Si la varianza que se
predice para alguna observación de la regresión auxiliar, no es positiva,
entonces se utiliza en su lugar el error cuadrado correspondiente).

Los valores alpha presentados debajo de los coeficientes son los parámetros
estimados del proceso ARCH con la regresión auxiliar.

Consulta también "garch" y "modtest" (opción --arch).

# arima Estimation

Argumentos: p d q [ ; P D Q ] ; depvar [ indepvars ] 
Opciones:   --verbose (Presenta los detalles de las iteraciones)
            --quiet (No presenta los resultados)
            --vcv (Presenta la matriz de covarianzas)
            --hessian (Mira abajo)
            --opg (Mira abajo)
            --nc (Sin constante)
            --conditional (Utiliza Máxima Verosimilitud condicional)
            --x-12-arima (Utiliza ARIMA X-12 en la estimación)
            --lbfgs (Utiliza el maximizador L-BFGS-B)
            --y-diff-only (ARIMAX especial; mira abajo)
Ejemplos:   arima 1 0 2 ; y
            arima 2 0 2 ; y 0 x1 x2 --verbose
            arima 0 1 1 ; 0 1 1 ; y --nc
            Ver también armaloop.inp, bjg.inp

Advertencia: arma es un alias aceptable para esta instrucción.

Cuando no indicas la lista indepvars, se estima un modelo univariante ARIMA
(Autorregresivo, Integrado, de Medias móviles). Los valores p, d y q
representan el orden autorregresivo (AR), el orden de diferenciación y el
orden de medias móviles (MA), respectivamente. Puedes indicar estos valores
en formato numérico, o como nombres de variables escalares ya existentes.
Por ejemplo, un valor de 1 para d significa que, antes de estimar los
parámetros del ARMA, debe tomarse la primera diferencia de la variable
dependiente.

Si quieres incluir en el modelo solo retardos AR o MA específicos (en
contraposición a todos los retardos hasta un orden indicado) puedes
substituir por p y/o q bien (a) el nombre de una matriz definida previamente
que contiene un conjunto de valores enteros, o bien (b) una expresión tal
como {1,4}; es decir, un conjunto de retardos separados con comas y puestos
entre llaves.

Los valores enteros P, D y Q (opcionales) representan el orden AR
estacional, el orden de diferenciación estacional y el orden MA estacional,
respectivamente. Estos órdenes solo los puedes aplicar cuando los datos
tienen una frecuencia mayor que 1 (por ejemplo, con datos trimestrales o
mensuales); y puedes indicarlas en formato numérico o como variables
escalares.

En el caso univariante, por defecto se incluye en el modelo una ordenada en
el origen, pero puedes eliminar esto por medio de la opción --nc. Cuando
añades indepvars, el modelo se convierte en un ARMAX; en este caso, debes
incluir la constante explícitamente si quieres tener la ordenada en el
origen (como en el segundo ejemplo de arriba).

Dispones de una forma alternativa de sintaxis para esta instrucción: si no
quieres aplicar diferencias (ni estacionales ni no estacionales), puedes
omitir los dos campos d y D a la vez, mejor que introducir explícitamente
0. Además, arma es un alias o sinónimo de arima y así, por ejemplo, la
siguiente instrucción es un modo válido de especificar un modelo ARMA(2,
1):

	arma 2 1 ; y

Por defecto, se utiliza la funcionalidad ARMA "propia" de Gretl, con la
estimación Máximo Verosímil (MV) exacta; pero dispones de la opción de
hacer la estimación mediante MV condicional. (Si el programa ARIMA X-12
está instalado en el ordenador, tienes la posibilidad de utilizarlo en vez
del código propio.) Para otros detalles relacionados con estas opciones,
consulta El manual de gretl (Capítulo 29).

Cuando se utiliza código propio de MV exacta, las desviaciones típicas
estimadas se basan por defecto en una aproximación numérica a la (inversa
negativa de la) matriz Hessiana, con un último recurso al Producto Externo
del vector Gradiente (PEG) si el cálculo de la matriz Hessiana numérica
pudiera fallar. Puedes utilizar dos indicadores de opción (mutuamente
excluyentes) para forzar esta cuestión: mientras que la opción --opg
fuerza la utilización del método PEG, sin intentar calcular la matriz
Hessiana, la opción --hessian inhabilita el último recurso a PEG. Ten en
cuenta que un fallo en el cálculo de la matriz Hessiana numérica,
generalmente es un indicador de que un modelo está mal especificado.

La opción --lbfgs es específica de la estimación que utiliza código ARMA
propio y Máxima Verosimilitud exacta; y solicita que se utilice el
algoritmo de "memoria limitada" L-BFGS-B en lugar del maximizador BFGS
habitual. Esto puede ser de ayuda en algunos casos en los que la
convergencia es difícil de lograr.

La opción --y-diff-only es específica de la estimación de modelos ARIMAX
(modelos con orden de integración no nulo, en los que se incluyen
regresores exógenos) y se aplica solo cuando se utiliza la Máxima
Verosimilitud exacta propia de Gretl. Para esos modelos, el comportamiento
por defecto consiste en calcular las primeras diferencias tanto de la
variable dependiente como de los regresores; pero cuando indicas esta
opción, solo se calcula para la variable dependiente, quedando los
regresores en niveles.

El valor del AIC de Akaike indicado en conexión con modelos ARIMA, se
calcula de acuerdo con la definición que utiliza el ARIMA X-12,
concretamente

  AIC = -2L + 2k

donde L es el logaritmo de la verosimilitud y k es el número total de
parámetros estimados. Observa que el ARIMA X-12 no produce criterios de
información tales como AIC cuando la estimación es por Máxima
Verosimilitud condicional.

Las raíces AR y MA mostradas en conexión con la estimación ARMA se basan
en la siguiente representación de un proceso ARMA(p, q):

      	(1 - a_1*L - a_2*L^2 - ... - a_p*L^p)Y =
        c + (1 + b_1*L + b_2*L^2 + ... + b_q*L^q) e_t

Por lo tanto, las raíces AR son las soluciones a

       1 - a_1*z - a_2*z^2 - ... - a_p*L^p = 0

y la estabilidad requiere que estas raíces se encuentren fuera del círculo
de radio unitario.

La cantidad "Frecuencia" presentada en conexión con las raíces AR y MA, es
el valor lambda que soluciona z = r * exp(i*2*pi*lambda) donde z es la raíz
en cuestión y r es su módulo.

Menú gráfico: /Modelo/Series temporales univariantes/ARIMA

# arma Estimation

Consulta "arima"; arma es un alias.

# biprobit Estimation

Argumentos: depvar1 depvar2 indepvars1 [ ; indepvars2 ] 
Opciones:   --vcv (Presenta la matriz de covarianzas)
            --robust (Desviaciones típicas robustas)
            --cluster=clustvar (Consulta "logit" para aclaración)
            --opg (Mira abajo)
            --save-xbeta (Mira abajo)
            --verbose (Presenta información adicional)
Ejemplos:   biprobit y1 y2 0 x1 x2
            biprobit y1 y2 0 x11 x12 ; 0 x21 x22
            Ver también biprobit.inp

Estima un modelo probit bivariante utilizando el método de Newton-Raphson
para maximizar la verosimilitud.

La lista de argumentos comienza con las dos variables (binarias)
dependientes, seguidas de una lista de regresores. Cuando indicas una
segunda lista (separada por un punto y coma) se entiende como un grupo de
regresores específicos de la segunda ecuación, siendo indepvars1
específica de la primera ecuación; en otro caso, indepvars1 se considera
que representa un conjunto de regresores común.

Por defecto, las desviaciones típicas se calculan utilizando una
aproximación numérica a la matriz Hessiana al converger. Pero si indicas
la opción --opg, la matriz de covarianzas se basa en el Producto Externo
del vector Gradiente (PEG o OPG); o si indicas la opción --robust, se
calculan las desviaciones típicas cuasi máximo verosímiles (QML),
utilizando un "emparedado" entre la inversa de la matriz Hessiana y el PEG.

Luego de una estimación correcta, el accesorio $uhat permite recuperar una
matriz con 2 columnas que contiene los errores generalizados de las dos
ecuaciones; es decir, los valores esperados de las perturbaciones
condicionadas a los resultados observados y a las variables covariantes. Por
defecto, $yhat permite recuperar una matriz con 4 columnas que contiene las
probabilidades estimadas de los 4 posibles resultados conjuntos para (y_1,
y_2), en el orden (1,1), (1,0), (0,1), (0,0). Alternativamente, cuando
indicas la opción --save-xbeta, entonces $yhat tiene 2 columnas y contiene
los valores de las funciones índice de las ecuaciones respectivas.

El resultado incluye un contraste de Razón de Verosimilitudes respecto a la
hipótesis nula de que las perturbaciones de las dos ecuaciones no están
correlacionadas.

# bkw Tests

Opción:     --quiet (No presenta nada)
Ejemplos:   longley.inp

Debe ir después de la estimación de un modelo que contenga al menos dos
variables explicativas. Calcula y presenta información de diagnóstico en
relación a la multicolinealidad, en concreto la Tabla BKW que está basada
en el trabajo de Belsley, Kuh y Welsch (1980). Esta tabla presenta un
sofisticado análisis del grado y de las causas de la multicolinealidad,
mediante el examen de los autovalores de la inversa de la matriz de
correlaciones. Para tener una explicación en detalle del enfoque BKW en
relación a Gretl, y con diversos ejemplos, consulta Adkins, Waters y Hill
(2015).

Después de utilizar esta instrucción, puedes usar el accesor "$result"
para recuperar la tabla BKW en forma de matriz. Consulta también la
instrucción "vif" para obtener un enfoque más sencillo del diagnóstico de
la multicolinealidad.

Hay también una función denominada "bkw" que ofrece una mayor
flexibilidad.

Menú gráfico: Ventana de modelo: Análisis/Colinealidad

# boxplot Graphs

Argumento:  listavariables 
Opciones:   --notches (Muestra el intervalo del 90 por ciento para la mediana)
            --factorized (Mira abajo)
            --panel (Mira abajo)
            --matrix=nombre (Representa las columnas de la matriz indicada)
            --output=nombrearchivo (Envía el resultado al archivo especificado)

Estos gráficos muestran la distribución de una variable. Una caja central
encierra el 50 por ciento central de los datos; i.e. está deslindada por el
primer y el tercer cuartiles. Un "bigote" se extiende desde cada límite de
la caja con un rango igual a 1.5 veces el rango intercuartil. Las
observaciones que están fuera de ese rango se consideran valores atípicos
y se representan mediante puntos. Se dibuja una línea a lo ancho de la caja
en la mediana. El signo "+" se utiliza para indicar la media. Si escoges la
opción de mostrar un intervalo de confianza para la mediana, este se
calcula mediante el método bootstrap y se muestra con formato de líneas
con rayas horizontales por arriba y/o abajo de la mediana.

La opción --factorized te permite examinar la distribución de la variable
elegida condicionada al valor de algún factor discreto. Por ejemplo, si un
conjunto de datos contiene una variable con los salarios y una variable
ficticia con el género, puedes escoger la de los salarios como objetivo y
la del género como el factor, para ver así los gráficos de cajas de
salarios de hombres y mujeres, uno al lado del otro, como en

	boxplot salario genero --factorized

Ten en cuenta que en este caso debes especificar exactamente solo dos
variables, con el factor indicado en segundo lugar.

Cuando tienes un conjunto vigente de datos de panel y especificas solo una
variable, la opción --panel produce una serie de gráficos de cajas (uno al
lado del otro) en la que cada uno se corresponde con un grupo o "unidad" del
panel.

Generalmente se requiere el argumento listavariables que se refiere a una o
más series del conjunto vigente de datos (indicadas bien por el nombre o
bien por el número ID). Pero si, mediante la opción --matrix, indicas una
matriz ya definida, este argumento se convierte en opcional pues, por
defecto, se dibuja un gráfico para cada columna de la matriz especificada.

Los gráficos de cajas en Gretl se generan utilizando la instrucción
gnuplot, y resulta posible especificar con mayor detalle el gráfico
añadiendo instrucciones adicionales de Gnuplot, puestas entre llaves. Para
obtener más detalles, consulta la ayuda para la instrucción "gnuplot".

En modo interactivo, el resultado se muestra inmediatamente. En modo de
procesamiento por lotes, el proceder por defecto consiste en escribir un
archivo de instrucciones de Gnuplot en el directorio de trabajo del usuario,
con un nombre con el patrón gpttmpN.plt, comenzando con N = 01. Puedes
generar los gráficos más tarde utilizando el gnuplot (o bien wgnuplot bajo
MS Windows). Puedes modificar este comportamiento mediante el uso de la
opción --output=nombrearchivo. Si quieres obtener más detalles, consulta
la instrucción "gnuplot".

Menú gráfico: /Ver/Gráficos/Gráficos de caja

# break Programming

Salida de un bucle. Puedes utilizar esta instrucción solo dentro de un
bucle; eso provoca que la ejecución de instrucciones salga del bucle actual
(del más interior, si hay varios anidados). Consulta también "loop".

# catch Programming

Sintaxis:   catch command

Esta no es una instrucción por si misma, pero puedes utilizarla como
prefijo en la mayoría de las instrucciones habituales: su efecto es el de
prevenir que termine un guion de instrucciones si ocurre un fallo al
ejecutar una de ellas. Si aparece un fallo, esto se registra con un código
de fallo interno al que puedes acceder con $error (un valor de 0 indica
éxito). Inmediatamente después de utilizar catch deberías verificar
siempre cual es el valor de $error, y realizar una acción adecuada si
falló una de las instrucciones.

No puedes utilizar la palabra clave catch antes de if, elif o endif.
Además, no debe utilizarse en peticiones a funciones definidas por el
usuario, pues se pretende utilizarla solo con las instrucciones de Gretl y
con las peticiones a los operadores o funciones "internos".

# chow Tests

Variantes:  chow obs
            chow dummyvar --dummy
Opciones:   --dummy (Utiliza una variable ficticia ya existente)
            --quiet (No presenta las estimaciones del modelo ampliado)
            --limit-to=lista (Limita el contraste a un subconjunto de regresores)
Ejemplos:   chow 25
            chow 1988:1
            chow mujer --dummy

Debe ir a continuación de una regresión MCO (OLS). Si indicas un número
de observación o una fecha, proporciona un contraste respecto a la
hipótesis nula de que no existe cambio estructural en el punto de corte
indicado. El procedimiento consiste en crear una variable ficticia que toma
el valor 1 desde el punto de corte especificado por obs hasta el final de la
muestra, y 0 en otro caso, así como generar términos de interacción entre
esa ficticia y los regresores originales. Si indicas una ficticia, se
contrasta esa hipótesis nula de homogeneidad estructural respecto a esa
variable ficticia, y también se añaden términos de interacción. En cada
caso se ejecuta una regresión ampliada incluyendo los términos
adicionales.

Por defecto, se calcula un estadístico F, considerando la regresión
ampliada como el modelo sin restricciones y el modelo original como el
restringido. Pero si el modelo original utilizó un estimador robusto para
la matriz de covarianzas, el estadístico de contraste es uno de Wald con
distribución chi-cuadrado; con su valor basado en un estimador robusto de
la matriz de covarianzas de la regresión ampliada.

Puedes utilizar la opción --limit-to para limitar el conjunto de términos
de interacción con la variable ficticia de corte, a un subconjunto de los
regresores originales. El argumento para esta opción debe ser una lista ya
definida en la que todos sus elementos estén entre los regresores
originales, y no debe incluir la constante.

Menú gráfico: Ventana de modelo: Contrastes/Contraste de Chow

# clear Programming

Opción:     --dataset (Vacía solo el conjunto de datos)

Sin ninguna opción, quita de la memoria todos los objetos guardados,
incluyendo el conjunto de datos (si hay alguno). Ten en cuenta que también
tienes este efecto al abrir un nuevo conjunto de datos, o al utilizar la
instrucción "nulldata" para crear un conjunto de datos vacío; por eso
normalmente no necesitas utilizar "clear".

Cuando indicas la opción --dataset, entonces solo se vacía el conjunto de
datos (más cualquier lista de series definida); otros objetos guardados
como matrices y escalares ya definidos, se van a conservar.

# coeffsum Tests

Argumento:  listavariables 
Opción:     --quiet (No presenta nada)
Ejemplos:   coeffsum xt xt_1 xr_2
            Ver también restrict.inp

Debe ir después de una regresión. Calcula la suma de los coeficientes de
las variables del argumento listavariables. Presenta esta suma junto con su
desviación típica y la probabilidad asociada al estadístico para
contrastar la hipótesis nula de que la suma es cero.

Ten en cuenta la diferencia entre esto y la instrucción "omit", pues esta
última te permite contrastar la hipótesis nula de que los coeficientes de
un subconjunto especificado de variables independientes son todos nulos.

La opción --quiet te puede ser de utilidad si únicamente deseas acceder a
los valores de "$test" y de "$pvalue" que se registran después de terminar
la estimación con éxito.

Menú gráfico: Ventana de modelo: Contrastes/Suma de los coeficientes

# coint Tests

Argumentos: orden depvar indepvars 
Opciones:   --nc (Sin constante)
            --ct (Con constante y tendencia)
            --ctt (Con constante más tendencia cuadrática)
            --seasonals (Con variables ficticias estacionales)
            --skip-df (Sin contrastes DF sobre las variables individuales)
            --test-down[=criterio] (Orden de retardos automático)
            --verbose (Presenta detalles adicionales de las regresiones)
            --silent (No presenta nada)
Ejemplos:   coint 4 y x1 x2
            coint 0 y x1 x2 --ct --skip-df

Contraste de cointegración de Engle-Granger (1987). El proceso por defecto
consiste en: (1) realizar los contrastes de Dickey-Fuller respecto a la
hipótesis nula de que cada una de las variables enumeradas tiene una raíz
unitaria; (2) estimar la regresión de cointegración; y (3) hacer un
contraste DF respecto a los errores que comete la regresión de
cointegración. Cuando se indica la opción --skip-df, se omite el paso (1).

Si el orden especificado de retardos es positivo, todos los contrastes de
Dickey-Fuller usan ese orden pero con este requisito: cuando se indica la
opción --test-down, el valor indicado se toma como un máximo, y el orden
concreto de retardos que se utilizará en cada caso se obtiene probando
hacia abajo. Consulta la instrucción "adf" para obtener más detalles sobre
este procedimiento.

Por defecto, la regresión de cointegración contiene una constante pero, si
quieres eliminar la constante, añade la opción --nc. Si quieres ampliar la
lista de términos determinísticos en la regresión de cointegración con
tendencia lineal (o cuadrática), añade la opción --ct (o --ctt). Estos
indicadores de opción son mutuamente excluyentes. También tienes la
posibilidad de añadir variables ficticias estacionales (en caso de utilizar
datos trimestrales o mensuales).

Los valores P (probabilidades asociadas) de este contraste se basan en
MacKinnon (1996). El código relevante se incluye con el amable permiso del
propio autor.

Menú gráfico: /Modelo/Series temporales multivariantes

# coint2 Tests

Argumentos: orden ylista [ ; xlista ] [ ; rxlista ] 
Opciones:   --nc (Sin constante)
            --rc (Constante restringida)
            --uc (Constante no restringida)
            --crt (Constante y tendencia restringida)
            --ct (Constante y tendencia no restringida)
            --seasonals (Incluye variables ficticias estacionales centradas)
            --asy (Guarda los valores p asintóticos)
            --quiet (Presenta solo los contrastes)
            --silent (No presenta nada)
            --verbose (Presenta detalles de las regresiones auxiliares)
Ejemplos:   coint2 2 y x
            coint2 4 y x1 x2 --verbose
            coint2 3 y x1 x2 --rc
            Ver también hamilton.inp, denmark.inp

Lleva a cabo el contraste de cointegración de Johansen entre las variables
de ylista para el orden de retardos seleccionado. Para obtener más detalles
sobre este contraste, consulta El manual de gretl (Capítulo 31) o el
capítulo 20 de Hamilton (1994). Las probabilidades asociadas (valores p) se
calculan mediante la aproximación Gamma de Doornik (Doornik, 1998). Se
muestran dos conjuntos de valores p para el contraste de la traza: valores
asintóticos directos y valores ajustados por el tamaño de la muestra. Por
defecto, el accesorio "$pvalue" genera la variante ajustada, pero puedes
utilizar la opción --asy para obtener en su lugar los valores asintóticos.

La inclusión de términos determinísticos en el modelo se controla
mediante los indicadores de opción. Por defecto, si no especificas ninguna
opción, se incluye una "constante no restringida", que permite la presencia
de una ordenada en el origen no nula en las relaciones de cointegración,
así como una tendencia en los niveles de las variables endógenas. En la
literatura generada a partir del trabajo de Johansen (por ejemplo, consulta
su libro de 1995) se refiere esta situación como el "caso 3". Las 4
primeras opciones indicadas arriba, que son mutuamente excluyentes, producen
respectivamente los casos 1, 2, 4 y 5. Tanto el significado de estos casos
como el criterio para seleccionar un caso se explican en El manual de gretl
(Capítulo 31).

Las listas xlista y rxlista (opcionales) te permiten controlar las variables
exógenas especificadas, y así estas entran en el sistema bien sin
restricciones (xlista) o bien restringidas al espacio de cointegración
(rxlista). Estas listas se separan de ylista y unas de las otras mediante un
punto y coma.

La opción --seasonals, que puedes combinar con cualquiera de las otras
opciones, especifica la inclusión de un conjunto de variables ficticias
estacionales centradas. Esta opción está disponible solo para datos
trimestrales o mensuales.

La siguiente tabla se ofrece como guía para la interpretación de los
resultados del contraste que se muestran, para el caso con 3 variables. H0
denota la hipótesis nula, H1 la hipótesis alternativa, y c el número de
relaciones de cointegración.

         Rango   Contraste traza      Contraste Lmáx
                  H0     H1          H0     H1
         ---------------------------------------
          0      c = 0  c = 3       c = 0  c = 1
          1      c = 1  c = 3       c = 1  c = 2
          2      c = 2  c = 3       c = 2  c = 3
         ---------------------------------------

Consulta también la instrucción "vecm".

Menú gráfico: /Modelo/Series temporales multivariantes

# corr Statistics

Variantes:  corr [ listavariables ]
            corr --matrix=nombrematriz
Opciones:   --uniform (Garantiza una muestra uniforme)
            --spearman (Rho de Spearman)
            --kendall (Tau de Kendall)
            --verbose (Presenta jerarquías)
            --plot=modo-o-nombrearchivo (Mira abajo)
Ejemplos:   corr y x1 x2 x3
            corr ylista --uniform
            corr x y --spearman
            corr --matrix=X --plot=display

Por defecto, presenta los coeficientes de correlación (correlación
producto-momento de Pearson) por pares de las variables de listavariables, o
de todas las variables del conjunto de datos si no indicas listavariables.
El comportamiento típico de esta instrucción consiste en utilizar todas
las observaciones disponibles para calcular cada coeficiente por parejas de
variables, pero cuando indicas la opción --uniform, la muestra se limita
(si es necesario) de modo que se utiliza el mismo conjunto de observaciones
para todos los coeficientes. Esta opción es adecuada solo cuando hay un
número diferente de valores ausentes en las variables utilizadas.

Las opciones --spearman y --kendall (que son mutuamente excluyentes)
permiten calcular, respectivamente, el coeficiente rho de correlación por
rangos de Spearman y el coeficiente tau de correlación por rangos de
Kendall en lugar del coeficiente de Pearson (por defecto). Cuando indicas
alguna de estas opciones, listavariables debe contener solo dos variables.

Cuando se calcula una correlación por rangos, puedes utilizar la opción
--verbose para presentar los datos originales y su jerarquía (en otro caso,
esta alternativa se ignora).

Si listavariables contiene más de dos series y el programa no está en modo
de procesamiento por lotes, se muestra un gráfico de "mapa de calor" de la
matriz de correlaciones. Puedes ajustar esto mediante la opción --plot, en
la que los parámetros que se admiten son: none (para no mostrar el
gráfico), display (para presentar el gráfico incluso cuando se esté en
modo de procesamiento por lotes), o un nombre de archivo. El efecto de
indicar un nombre de archivo es como el descrito para la opción --output de
la instrucción "gnuplot". Cuando activas la representación del gráfico,
puedes utilizar la opción adicional --triangle para mostrar solo el mapa de
calor del triángulo inferior de la matriz.

Cuando indicas una forma alternativa, utilizando una matriz ya definida en
lugar de una lista de series, las opciones --spearman y --kendall no están
disponibles (pero consulta la función "npcorr").

Puedes usar el accesor "$result" para obtener las correlaciones en forma de
matriz.

Menú gráfico: /Ver/Matriz de correlación
Otro acceso:  Ventana principal: Menú emergente (tras selección múltiple)

# corrgm Statistics

Argumentos: serie [ orden ] 
Opciones:   --bartlett (Utiliza las desviaciones típicas de Bartlett)
            --plot=modo-o-nombrearchivo (Mira abajo)
            --quiet (No presenta el gráfico)
Ejemplo:    corrgm x 12

Presenta los valores de la función de autocorrelación (FAC) del argumento
serie, que puede especificarse por su nombre o su número. Los valores se
definen como rho(u_t, u_t-s) donde u_t es la t-ésima observación de la
variable u y s denota el número de retardos.

También se presentan las autocorrelaciones parciales (FACP, que se calculan
utilizando el algoritmo de Durbin-Levinson), y que están libres de los
efectos de los retardos intermedios. Además, se presenta el estadístico Q
de Ljung-Box que puedes utilizar para contrastar la hipótesis nula de que
la serie es un "ruido blanco", y que se distribuye asintóticamente como una
chi-cuadrado con tantos grados de libertad como el número de retardos
utilizados.

Se utilizan asteriscos para indicar la significación estadística de las
autocorrelaciones individuales. Por defecto, esto se evalúa utilizando una
desviación típica igual al cociente entre 1 y la raíz cuadrada del
tamaño de la muestra; pero cuando indicas la opción --bartlett, entonces
se utilizan las desviaciones típicas de Bartlett para la FAC. Si resulta
aplicable, esta opción también determina la banda de confianza que se
dibuja en el gráfico de la FAC.

Si especificas un valor para orden, la longitud del correlograma se limita
hasta ese número de retardos como máximo; en otro caso, la longitud se
determina automáticamente como una función de la frecuencia de los datos y
del número de observaciones.

Por defecto, se genera un gráfico del correlograma: un gráfico de Gnuplot
en modo interactivo o un gráfico ASCII en modo de procesamiento por lotes.
Esto puedes ajustarlo mediante la opción --plot en la que los parámetros
que se admiten son: none (para no mostrar el gráfico), ascii (para
presentar un gráfico de texto incluso en modo interactivo), display (para
presentar un gráfico de Gnuplot incluso en modo de procesamiento por
lotes); o un nombre de archivo. El efecto de indicar un nombre de archivo es
como el descrito para la opción --output de la instrucción "gnuplot".

Cuando se completa con éxito esta instrucción, los accesorios "$test" y
"$pvalue" contienen los dos valores respectivos del contraste de Ljung-Box
para el máximo orden de retardo presentado. Si únicamente quieres calcular
el estadístico Q, ten en cuenta que probablemente será preferible que
utilices en su lugar la función "ljungbox".

Menú gráfico: /Variable/Correlograma
Otro acceso:  Ventana principal: Menú emergente (selección única)

# cusum Tests

Opciones:   --squares (Realiza el contraste CUSUMSQ)
            --quiet (Solo presenta el contraste de Harvey-Collier)

Debe ir después de la estimación de un modelo mediante MCO. Te permite
realizar el contraste CUSUM de estabilidad de los parámetros (o el
contraste CUSUMSQ si indicas la opción --squares). Vas a obtener una serie
con los errores de predicción adelantados un paso, ejecutando una serie de
regresiones. En la primera regresión se utilizan las primeras k
observaciones y te permite generar la predicción de la variable dependiente
en la observación k + 1; en la segunda se utilizan las primeras k + 1
observaciones y se genera una predicción para la observación k + 2, y así
sucesivamente (donde k es el número de parámetros del modelo original).

Se presenta y se dibuja la suma acumulada de los errores de predicción
escalados (o los cuadrados de estos errores). La hipótesis nula de
estabilidad de los parámetros se rechaza con un nivel de significación del
5 por ciento cuando la suma acumulada se separa de la banda de confianza del
95 por ciento.

En el caso del contraste CUSUM, también se presenta el estadístico t de
Harvey-Collier para contrastar la hipótesis nula de estabilidad de los
parámetros. Consulta el libro Econometric Analysis de Greene para obtener
más detalles. Para el contraste CUSUMSQ, se calcula la banda de confianza
del 95 por ciento utilizando el algoritmo indicado en Edgerton y Wells
(1994).

Menú gráfico: Ventana de modelo: Contrastes/Contraste CUSUM(SQ)

# data Dataset

Argumento:  listavariables 
Opciones:   --compact=método (Especifica el método para compactar)
            --interpolate (Hace la interpolación para datos de baja frecuencia)
            --quiet (No muestra los resultados excepto en caso de fallo)
            --name=identificador (Renombra series importadas)

Lee las variables de listavariables de una base de datos (Gretl, dbnomics,
RATS 4.0 o PcGive) que debe abrirse previamente utilizando la instrucción
"open". Puedes establecer la frecuencia de los datos y el rango de la
muestra mediante las instrucciones "setobs" y "smpl" antes de utilizar esta
instrucción. Este es un ejemplo completo:

	open macrodat.rat
	setobs 4 1959:1
	smpl ; 1999:4
	data GDP_JP GDP_UK

Las instrucciones de arriba abren una base de datos llamada macrodat.rat,
determinan que los datos son de tipo trimestral, que comienzan en el primer
trimestre de 1959, que la muestra finaliza en el cuarto trimestre de 1999, y
luego se importan las series denominadas GDP_JP y GDP_UK.

Si no especificas setobs y smpl de este modo, la frecuencia de los datos y
el rango de la muestra se establecen utilizando la primera variable que se
lee de la base de datos.

Si las series que se van a leer son de frecuencia mayor que el conjunto de
datos de trabajo, puedes especificar un método para compactar como aquí
debajo:

	data LHUR PUNEW --compact=average

Los cinco métodos que permiten compactar de los que dispones son estos:
"average" (toma la media de las observaciones de alta frecuencia), "last"
(utiliza la última observación), "first", "sum" y "spread", pero si no
especificas ningún método, por defecto se utiliza la media. El método
"spread" es especial pues con él no se pierde ninguna información, sino
que más bien esta se expande entre varias series, una por cada subperíodo.
Así con ella cuando añades, por ejemplo, una serie mensual a un conjunto
de datos trimestrales, se generan 3 series (una por cada mes del trimestre)
cuyos nombres contienen los sufijos m01, m02 y m03.

Cuando las series que se leen son de frecuencia menor que la del conjunto de
datos de trabajo, por defecto se repiten los valores de los datos añadidos
según se necesite. Pero puedes utilizar la opción --interpolate para
solicitar que se haga la interpolación utilizando el método de Chow y Lin
(1971) en el que los regresores son una constante más una tendencia lineal
y cuadrada, y se asume que la perturbación sigue un AR(1). Sin embargo, ten
en cuenta que dispones de esta opción solo para convertir datos
trimestrales en mensuales, o datos anuales en trimestrales.

En el caso de bases de datos propias (únicamente) de Gretl, puedes utilizar
los caracteres "genéricos", * y ? en listavariables para importar series
que coincidan con el patrón indicado. Por ejemplo, la siguiente expresión
va a importar todas las series de la base de datos cuyos nombres comiencen
por cpi:

	data cpi*

Puedes usar la opción --name para determinar un nombre distinto del nombre
original en la base de datos, para la seire importada. El parámetro debe
ser un identificador válido de Gretl. Esta opción se restringe al caso en
el que especificas una única serie a importar.

Menú gráfico: /Archivo/Bases de datos

# dataset Dataset

Argumentos: clave parámetros 
Ejemplos:   dataset addobs 24
            dataset insobs 10
            dataset compact 1
            dataset compact 4 last
            dataset expand interp
            dataset transpose
            dataset sortby x1
            dataset resample 500
            dataset renumber x 4
            dataset pad-daily 7
            dataset clear

Realiza diversas operaciones en el conjunto de datos como un todo,
dependiendo de la clave indicada, que debe ser: addobs, insobs, clear,
compact, expand, transpose, sortby, dsortby, resample, renumber o pad-daily.
Advertencia: Con la excepción de la opción clear, estas acciones no están
disponibles mientras tengas una submuestra del conjunto de datos, escogida
por selección de los casos según algún criterio booleano.

addobs: Debe estar seguido de un entero positivo. Añade el número
especificado de observaciones adicionales al final del conjunto de datos de
trabajo. Esto está pensado principalmente con el propósito de hacer
predicciones. Los valores de la mayoría de las variables a lo largo del
rango añadido se van a estipular como ausentes, pero ciertas variables
determinísticas se reconocen y su contenido se extiende al rango añadido;
en concreto, las variables con tendencia lineal simple y las variables
ficticias periódicas.

insobs: Debe estar seguido de un entero positivo (no mayor que el número
vigente de observaciones) que especifica la posición en la que se inserta
una única observación. Todos los datos posteriores se desplazan un lugar y
el conjunto de datos se amplía en una observación. Excepto a la constante,
se le dan valores ausentes a todas las variables en la nueva observación.
Esta acción no está disponible para conjuntos de datos de panel.

clear: No necesita ningún parámetro. Vacía todos los datos vigentes,
devolviendo el Gretl a su estado "vacío" inicial.

compact: Debe estar seguido de un entero positivo que represente la nueva
frecuencia de los datos, y que debe ser menor que la frecuencia vigente (por
ejemplo, indicar un valor de 4 cuando la frecuencia vigente es 12, indica
que se van a compactar los datos de mensuales a trimestrales). Esta
instrucción solo está disponible para datos de series temporales y
compacta todas las series del conjunto de datos a una nueva frecuencia.
También puedes indicar un segundo parámetro, en concreto uno de entre sum,
first, last o spread. Estos permiten especificar que se va a compactar
utilizando, respectivamente: la suma de los valores de frecuencia mayor, el
valor de inicio-de-período, el valor de fin-de-período, o expandiendo los
valores de frecuencia mayor entre varias series (una por cada subperíodo),
pues por defecto se hace usando la media.

expand: Esta instrucción solo está disponible para datos de series
temporales anuales o trimestrales, pues los datos anuales se pueden expandir
a trimestrales y los datos trimestrales a frecuencia mensual. Por defecto,
todas las series del conjunto de datos se rellenan con la nueva frecuencia
repitiendo los valores existentes, pero si añades el parámetro interp,
entonces la serie se expande utilizando la interpolación de Chow-Lin (para
los detalles, consulta Chow y Lin, 1971) en la que los regresores son una
constante más una tendencia cuadrática, y se asume que la perturbación
sigue un AR(1).

transpose: No necesita ningún parámetro adicional. Traspone el conjunto
vigente de datos, es decir, cada observación (fila) del conjunto vigente de
datos se va a tratar como una variable (columna), y cada variable como una
observación. Esta instrucción puede serte útil si los datos se leyeron de
algún origen externo en el que las filas de la tabla de datos representan
variables.

sortby: Se requiere el nombre de una única serie o lista. Cuando indicas
una serie, las observaciones de todas las variables del conjunto de datos se
vuelven a ordenar según los valores ascendentes de la serie especificada.
Cuando indicas una lista, la reordenación se hace jerárquicamente: si hay
observaciones empatadas al reordenarse según la primera variable clave,
entonces la segunda clave se utiliza para romper el empate, y así
sucesivamente hasta que se rompa el empate o se agoten las claves. Ten en
cuenta que esta instrucción está disponible solo para datos sin fecha.

dsortby: Funciona como sortby excepto que la reordenación se hace según
los valores descendientes de la serie clave.

resample: Construye un nuevo conjunto de datos mediante muestreo aleatorio
(con substitución) de las filas del conjunto vigente de datos, y requiere
que indiques como argumento el número concreto de filas que quieres
incluir. Este puede ser menor, igual o mayor que el número de observaciones
de los datos originales. Puedes recuperar el conjunto original de datos
mediante la instrucción smpl full.

renumber: Requiere el nombre de una serie ya existente seguida de un número
entero entre 1 y el número de series del conjunto de datos menos 1. Mueve
la serie especificada a la posición indicada del conjunto de datos,
volviendo a numerar las demás series conforme a esto. (La posición 0 se
ocupa con la constante, que no puede moverse.)

pad-daily: Válido solo cuando el conjunto vigente de datos contiene datos
con fechas diarias con un calendario incompleto. Tiene como efecto llenar
los datos en un calendario completo insertando filas en blanco (es decir,
filas que no contienen nada excepto NAs). Esta opción requiere un número
entero como parámetro, concretamente el número de días por semana (5, 6 o
7), y que debe ser mayor o igual que la frecuencia vigente de los datos.
Cuando se completa con éxito, el calendario de datos va a estar "completo"
en relación a este valor. Por ejemplo, si días-por-semana es igual a 5,
entonces se representan todos los días laborables, haya o no algún dato
disponible para esos días.

Menú gráfico: /Datos

# debug Programming

Argumento:  función 

Depurador experimental para funciones definidas por el usuario, que está
disponible en el programa Gretlcli de líneas de instrucciones y en la
consola de Interface Gráfica de Usuario (GUI). Debes invocar esta
instrucción debug después de que esté definida la función en cuestión,
pero antes de llamar por ella. El efecto de esta instrucción consiste en
que la ejecución se detiene cuando se llama por la función y se muestra un
indicador especial.

Ante el indicador de depuración puedes teclear next para ejecutar la
siguiente instrucción de la función, o continue para permitir que la
ejecución de la función continúe sin trabas; y puedes acortar estas
instrucciones mediante n y c, respectivamente. También puedes intercalar
una instrucción al aparecer este indicador; por ejemplo, la instrucción
print para revelar el valor actual de alguna variable de interés.

# delete Dataset

Variantes:  delete listavariables
            delete nombrevar
            delete --type=tipo
            delete nombrepaquete
Opciones:   --db (Elimina series de la base de datos)
            --force (Mira abajo)

Esta instrucción es un destructor. Deberías utilizarla con precaución
pues no se pide confirmación.

En la primera variante de arriba, listavariables es una lista de series,
indicada por su nombre o número ID. Ten en cuenta que cuando eliminas
series, se vuelve a numerar cualquier serie cuyo número ID sea mayor que
los de las series de la lista que se elimina. Si indicas la opción --db,
las series de la lista no se eliminan con esta instrucción del conjunto
vigente de datos, pero sí de la base de datos de Gretl (suponiendo que se
abrió una de ellas y que el usuario tiene permisos para escribir en el
archivo en cuestión). Consulta también la instrucción "open".

En la segunda variante, puedes indicar el nombre de un escalar, de una
matriz, de una cadena de texto o de un bundle, para que se elimine. La
opción --db no puede aplicarse en este caso. Ten en cuenta que no debes
mezclar series y variables de diferentes tipos en una misma llamada a
delete.

En la tercera variante, la opción --type debes acompañarla con alguno de
los siguientes nombres de tipos: matrix, bundle, string, list, scalar o
array; y su efecto consiste en eliminar todas las variables del tipo
indicado. En este caso no debes indicar ningún argumento que no sea la
opción.

Puedes usar la cuarta variante para descargar un paquete de funciones. En
este caso, debes proporcionar el sufijo .gfn como en

	delete somepkg.gfn

Ten en cuenta que esto no elimina el archivo de paquete; únicamente
descarga el paquete de la memoria.

Eliminar variables en un bucle

En general, no se permite eliminar variables en el contexto de un bucle,
puesto que esto puede suponer un riesgo para la integridad del código del
propio bucle. Sin embargo, si tienes total confianza en que la eliminación
de una determinada variable va a ser inocua, puedes anular esta prohibición
añadiendo la opción --force a la instrucción delete.

Menú gráfico: Ventana principal: Menú emergente (selección única)

# diff Transformations

Argumento:  listavariables 
Ejemplos:   penngrow.inp, sw_ch12.inp, sw_ch14.inp

Con esta instrucción obtienes la primera diferencia de cada variable de
listavariables, y el resultado se guarda en una nueva variable con el
prefijo d_. Así "diff x y" genera las nuevas variables

	d_x = x(t) - x(t-1)
	d_y = y(t) - y(t-1)

Menú gráfico: /Añadir/Primeras diferencias de las variables seleccionadas

# difftest Tests

Argumentos: serie1 serie2 
Opciones:   --sign (Contraste de los signos, por defecto)
            --rank-sum (Contraste de la suma de rangos de Wilcoxon)
            --signed-rank (Contraste de los rangos con signo de Wilcoxon)
            --verbose (Presenta resultados adicionales)
            --quiet (Elimina el resultado presentado)
Ejemplos:   ooballot.inp

Lleva a cabo un contraste no paramétrico sobre la diferencia entre dos
poblaciones o grupos, en la que el contraste concreto depende de la opción
seleccionada.

Con la opción --sign, se realiza el contraste de los signos. Este contraste
se basa en el hecho de que, cuando se extraen dos muestras, x e y, de forma
aleatoria de una misma distribución, la probabilidad de que x_i > y_i, para
cada observación i, deberá ser igual a 0.5. El estadístico de contraste
es w, es decir, el número de observaciones para las que se cumple que x_i >
y_i. Bajo la hipótesis nula, este estadístico sigue una distribución de
probabilidad Binomial con parámetros (n, 0.5), donde n indica el número de
observaciones.

Con la opción --rank-sum, se realiza el contraste de la suma de rangos de
Wilcoxon. Este contraste se desarrolla determinando el rango en jerarquía
de las observaciones de ambas muestras juntas, desde la de menor valor hasta
la de mayor, y luego calculando la suma de los rangos de las observaciones
de una cualquiera de las dos muestras. No es necesario que las dos muestras
tengan el mismo tamaño y, si son diferentes, se utiliza la muestra más
pequeña para calcular la suma de los rangos. Bajo la hipótesis nula de que
las muestras proceden de poblaciones con la misma mediana, la distribución
de probabilidad de la suma de rangos puede calcularse para cualquier tamaño
de muestra que se indique; y para muestras razonablemente largas, existe una
estrecha aproximación Normal.

Con la opción --signed-rank, se realiza el contraste de los rangos con
signo de Wilcoxon, que está ideada para pares de datos ligados como, por
ejemplo, los pares de valores de una misma variable en una muestra de
individuos, antes y después de algún tratamiento. El contraste se
desarrolla calculando las diferencias entre las observaciones emparejadas
x_i - y_i, y determinando el rango de estas diferencias según su valor
absoluto, además de asignándole a cada par, un rango con un signo que
coincide con el signo de la diferencia. A continuación se calcula la suma
de los rangos con signo positivo (W_+). De igual modo que en el contraste de
la suma de rangos, bajo la hipótesis nula de que la diferencia de las
medianas es cero, este estadístico sigue una distribución de probabilidad
bien definida, que converge a la Normal para muestras de tamaño razonable.

Para los contrastes de Wilcoxon, cuando indicas la opción --verbose,
entonces se presenta la ordenación. (Esta opción no tiene efecto cuando se
selecciona el contraste de los signos.)

Al completarse con éxito, vas a tener disponibles los accesorios "$test" y
"$pvalue". Si únicamente quieres obtener estos valores, puedes añadir la
opción --quiet a la instrucción.

# discrete Transformations

Argumento:  listavariables 
Opción:     --reverse (Marca las variables como continuas)
Ejemplos:   ooballot.inp, oprobit.inp

Marca cada variable de listavariables como discreta pues, por defecto, todas
las variables se tratan como continuas. Al hacer que una variable sea
discreta, eso afecta al modo en el que se maneja esa variable en los
gráficos de frecuencia, y también te permite escoger la variable para la
instrucción "dummify".

Cuando especificas la opción --reverse, la operación se invierte; es
decir, las variables contenidas en listavariables se marcan como continuas.

Menú gráfico: /Variable/Editar atributos

# dpanel Estimation

Argumento:  p ; depvar indepvars [ ; instrumentos ] 
Opciones:   --quiet (No muestra el modelo estimado)
            --vcv (Presenta la matriz de covarianzas)
            --two-step (Realiza la estimación MGM (GMM) en 2 etapas)
            --system (Añade ecuaciones en niveles)
            --time-dummies (Añade variables ficticias temporales)
            --dpdstyle (Imita el paquete DPD para Ox)
            --asymptotic (Desviaciones típicas asintóticas sin corregir)
            --keep-extra (Mira abajo)
Ejemplos:   dpanel 2 ; y x1 x2
            dpanel 2 ; y x1 x2 --system
            dpanel {2 3} ; y x1 x2 ; x1
            dpanel 1 ; y x1 x2 ; x1 GMM(x2,2,3)
            Ver también bbond98.inp

Realiza la estimación de modelos dinámicos con datos de panel (es decir,
modelos de panel que incluyen uno o más retardos de la variable
dependiente) utilizando bien el método GMM-DIF o bien GMM-SYS.

El parámetro p representa el orden de autorregresión para la variable
dependiente. En el caso más sencillo, este parámetro es un valor escalar,
pero también puedes indicar una matriz definida previamente para este
argumento, para especificar con ello un conjunto de retardos (posiblemente
no consecutivos) a utilizar.

Debes indicar la variable dependiente y los regresores con sus valores en
niveles, pues ya se van a diferenciar automáticamente (dado que este
estimador utiliza la diferenciación para eliminar los efectos
individuales).

El último campo (opcional) de la instrucción es para especificar los
instrumentos. Si no indicas ningún instrumento, se asume que todas las
variables independientes son estrictamente exógenas. Si especificas
cualquier instrumento, debes incluir en la lista cualquier variable
independiente estrictamente exógena. Para los regresores predeterminados
puedes utilizar la función GMM para incluir un rango específico de
retardos con el estilo diagonal por bloques, como se ilustra en el tercer
ejemplo de arriba. El primer argumento de GMM es el nombre de la variable en
cuestión, el segundo es el retardo mínimo que se utiliza como instrumento,
y el tercero es el retardo máximo. Puedes utilizar la misma sintaxis con la
función GMMlevel para especificar instrumentos de tipo GMM para las
ecuaciones en niveles.

Por defecto, se presentan los resultados de la estimación en 1 etapa (con
las desviaciones típicas robustas) pero tienes la opción de escoger la
estimación en 2 etapas. En ambos casos, se presentan los contrastes de
autocorrelación de orden 1 y 2 , así como el contraste de
sobreidentificación de Sargan y el estadístico del contraste de Wald para
la significación conjunta de los regresores. Ten en cuenta que en este
modelo en diferencias, la autocorrelación de primer orden no es una amenaza
para la validez del modelo, pero la autocorrelación de segundo orden
infringe los supuestos estadísticos vigentes.

En el caso de la estimación en 2 etapas, las desviaciones típicas se
calculan por defecto utilizando la corrección de muestra finita sugerida
por Windmeijer (2005). Generalmente se considera que las desviaciones
típicas asintóticas estándar asociadas al estimador del método en 2
etapas, son una guía poco fiable para la inferencia, pero si por alguna
razón quieres verlas, puedes utilizar la opción --asymptotic para
desactivar la corrección de Windmeijer.

Si indicas la opción --time-dummies, se añade un conjunto de variables
ficticias temporales a los regresores especificados. El número de estas
variables ficticias es una menos que el número máximo de períodos usados
en la estimación, para evitar que haya multicolinealidad perfecta con la
constante. Las variables ficticias se introducen en forma de diferencias
excepto que se indique la opción --dpdstyle, en cuyo caso se introducen en
niveles.

De igual modo que con otras instruciones para hacer la estimación, dispones
de un 'bundle' "$model" después de realizarla. En caso de dpanel, puedes
usar la opción --keep-extra para guardar información que quieras añadir a
ese 'bundle', por ejemplo las matrices de ponderaciones y de instrumentos
GMM.

Para obtener otros detalles y ejemplos, consulta El manual de gretl
(Capítulo 22).

Menú gráfico: /Modelo/Panel/Modelo de panel dinámico

# dummify Transformations

Argumento:  listavariables 
Opciones:   --drop-first (Excluye de la codificación al valor más bajo)
            --drop-last (Excluye de la codificación al valor más alto)

Para cualquier variable adecuada de listavariables, genera un conjunto de
variables ficticias que codifican los distintos valores de esa variable. Las
variables adecuadas son aquellas que se marcan explícitamente como
discretas o aquellas que tienen un número claramente pequeño de valores,
de los que todos ellos estén "claramente redondeadados" (múltiplos de
0.25).

Por defecto, se añade una variable ficticia por cada valor diferente de la
variable en cuestión. Por ejemplo, si una variable discreta x tiene 5
valores diferentes, se añaden 5 variables ficticias al conjunto de datos,
con los nombres Dx_1, Dx_2, etcétera. La primera variable ficticia va a
tener el valor 1 en las observaciones donde x toma su valor más pequeño y
0 en otro caso; la siguiente variable ficticia va a tener el valor 1 en las
observaciones donde x toma su segundo valor más pequeño, etcétera. Si
añades uno de los indicadores de opción --drop-first o --drop-last,
entonces se omite del proceso de codificación bien el valor más bajo o
bien el valor más alto de cada variable, respectivamente (lo que puede
serte útil para evitar la "trampa de las variables ficticias").

También puedes insertar esta instrucción en el contexto de la
especificación de una regresión. Por ejemplo, la siguiente línea
especifica un modelo donde y se regresa sobre el conjunto de variables
ficticias que se codifican para x. (No puedes aplicar los indicadores de
opción a "dummify" en este contexto.)

	ols y dummify(x)

Otro acceso:  Ventana principal: Menú emergente (selección única)

# duration Estimation

Argumentos: depvar indepvars [ ; censuravar ] 
Opciones:   --exponential (Utiliza la distribución exponencial)
            --loglogistic (Utiliza la distribución log-logística)
            --lognormal (Utiliza la distribución log-normal)
            --medians (Los valores ajustados son las medianas)
            --robust (Desviaciones típicas robustas: CMV (QML))
            --cluster=clustervar (Consulta "logit" para explicación)
            --vcv (Presenta la matriz de covarianzas)
            --verbose (Presenta los detalles de las iteraciones)
            --quiet (No presenta nada)
Ejemplos:   duration y 0 x1 x2
            duration y 0 x1 x2 ; cens
            Ver también weibull.inp

Estima un modelo de duración en el que la variable dependiente (que debe
ser positiva) representa la duración de algún estado de un asunto; por
ejemplo, la duración del período de desempleo para una sección cruzada de
encuestados. Por defecto, se utiliza la distribución de Weibull pero
también están disponibles las distribuciones exponencial, log-logística y
log-normal.

Si algunas de las medidas de duración están censuradas por la derecha
(e.g. el período del desempleo de un individuo aún no acabó dentro del
período de observación), entonces debes indicar en el argumento posterior
censuravar, una serie en la que los valores no nulos indiquen los casos
censurados por la derecha.

Por defecto, los valores ajustados que obtienes mediante el accesorio $yhat
son las medias condicionadas de las duraciones, pero cuando indicas la
opción --medians entonces $yhat te proporciona las medianas condicionadas
en su lugar.

Consulta El manual de gretl (Capítulo 36) para obtener más detalles.

Menú gráfico: /Modelo/Variable dependiente limitada/Datos de duración

# elif Programming

Consulta "if".

# else Programming

Consulta "if". Ten en cuenta que la instrucción "else" necesita una línea
para ella misma, antes de la siguiente instrucción condicional. Puedes
añadirle un comentario, como en

	else # Correcto, hace algo distinto

Pero no puedes añadirle una instrucción, como en

	else x = 5 # Incorrecto!

# end Programming

Termina un bloque de instrucciones de algún tipo. Por ejemplo, "end system"
termina un sistema de ecuaciones ("system").

# endif Programming

Consulta "if".

# endloop Programming

Marca el final de un bucle de instrucciones. Consulta "loop".

# eqnprint Printing

Opciones:   --complete (Genera un documento completo)
            --output=nombrearchivo (Envía el resultado al archivo especificado)

Debe ir después de la estimación de un modelo y presenta el modelo
estimado en formato de una ecuación LaTeX. Si especificas el nombre de un
archivo utilizando la opción --output, el resultado se dirige a ese
archivo; en otro caso, se dirige a un archivo con un nombre con el estilo
equation_N.tex, donde N es el número de modelos estimados hasta ese momento
en la sesión vigente. Consulta también "tabprint".

El archivo resultante va a escribirse en el directorio de trabajo
("workdir") establecido en ese momento, excepto que la cadena nombrearchivo
contenga una especificación completa de la ruta.

Cuando especificas la opción --complete, el archivo LaTeX es un documento
completo (listo para procesar); en otro caso, debes incluirlo en un
documento.

Menú gráfico: Ventana de modelo: LaTeX

# equation Estimation

Argumentos: depvar indepvars 
Ejemplo:    equation y x1 x2 x3 const

Te permite especificar una de las ecuaciones de un sistema de ellas
(consulta "system"). La sintaxis para especificar una ecuación de un
sistema SUR es la misma que para, e.g., "ols". Pero para una de las
ecuaciones de un sistema a estimar con Mínimos Cuadrados en 3 etapas,
puedes: (a) indicar una especificación de una ecuación como se estima con
MCO y proporcionar una lista normal de instrumentos utilizando la palabra
clave "instr" (de nuevo, consulta "system"), o (b) utilizar la misma
sintaxis de ecuaciones que para "tsls".

# estimate Estimation

Argumentos: [ nombresistema ] [ estimador ] 
Opciones:   --iterate (Itera hasta la convergencia)
            --no-df-corr (Sin corrección de los grados de libertad)
            --geomean (Mira abajo)
            --quiet (No presenta los resultados)
            --verbose (Presenta los detalles de las iteraciones)
Ejemplos:   estimate "Klein Model 1" method=fiml
            estimate Sys1 method=sur
            estimate Sys1 method=sur --iterate

Solicita la estimación de un sistema de ecuaciones que debes definir
previamente usando la instrucción "system". Debes indicar primero el nombre
del sistema, puesto entre comillas si el nombre contiene espacios. El
estimador debe ser uno de los siguientes: "ols", "tsls", "sur", "3sls",
"fiml" o "liml"; y debes de ponerle antes la cadena de texto method=. Estos
argumentos son opcionales si el sistema en cuestión ya se estimó, y ocupa
el lugar del "último modelo"; en ese caso, el estimador que se toma por
defecto será el utilizado previamente.

Si el sistema en cuestión tuvo aplicadas un conjunto de restricciones
(consulta la instrucción "restrict"), la estimación estará sujeta a las
restricciones especificadas.

Si el método de estimación es "sur" o "3sls", y especificas la opción
--iterate, se va a calcular el estimador iterativamente. En caso de SUR, si
el procedimiento converge, los resultados son las estimaciones máximo
verosímiles. La iteración de Mínimos Cuadrados en 3 Etapas (3sls), sin
embargo, en general no converge a los resultados de la máxima verosimilitud
con información completa (fiml). La opción --iterate se ignora para otros
métodos de estimación.

Si eliges los estimadores de ecuación a ecuación "ols" o "tsls", por
defecto se aplica una corrección de los grados de libertad cuando se
calculan las desviaciones típicas, pero puedes eliminar esto utilizando la
opción --no-df-corr. Esta opción no tiene efecto con los otros
estimadores, y así no se aplica la corrección de los grados de libertad en
ningún caso.

Por defecto, la fórmula utilizada para calcular los elementos de la matriz
de covarianzas de las ecuaciones cruzadas es

  sigma(i,j) = u(i)' * u(j) / T

Cuando indicas la opción --geomean, se aplica una corrección de los grados
de libertad con lo que la fórmula en ese caso es

  sigma(i,j) = u(i)' * u(j) / sqrt((T - ki) * (T - kj))

donde las ks denotan el número de parámetros independientes en cada
ecuación.

Cuando indicas la opción --verbose y especificas un método iterativo, se
presentan detalles de las iteraciones.

# eval Utilities

Argumento:  expresión 
Ejemplos:   eval x
            eval inv(X'X)
            eval sqrt($pi)

Esta instrucción hace que Gretl funcione como una sofisticada calculadora.
El programa evalúa expresión y presenta su valor. El argumento puede ser
el nombre de una variable, o algo más complicado. En cualquier caso, debe
ser una expresión que puedas poner correctamente como el lado derecho de un
enunciado de asignación (igualdad).

Ten en cuenta que una instrucción tal como

	print x^2

no funcionará en Gretl puesto que x^2 no es (no puede ser) el nombre de una
variable, pero (dada una variable escalar denominada x)

	eval x^2

funcionará correctamente, mostrando el cuadrado de x.

Consulta también "printf", en caso de que quieras combinar resultados
numéricos y de texto.

# fcast Prediction

Variantes:  fcast [obsinicio obsfin] [nombrev]
            fcast [obsinicio obsfin] pasosadelante [nombrev] --recursive
Opciones:   --dynamic (Genera la predicción dinámica)
            --static (Genera la predicción estática)
            --out-of-sample (Genera la predicción postmuestral)
            --no-stats (No presenta las estadísticas de predicción)
            --stats-only (Presenta solo las estadísticas de predicción)
            --quiet (No presenta nada)
            --recursive (Mira abajo)
            --plot=nombrearchivo (Mira abajo)
Ejemplos:   fcast 1997:1 2001:4 f1
            fcast fit2
            fcast 2004:1 2008:3 4 rfcast --recursive
            Ver también gdp_midas.inp

Debe ir después de una instrucción de estimación. Las predicciones se
generan para cierto rango de observaciones que será, bien el definido
cuando indicas obsinicio y obsfin (de ser posible), bien el definido por las
observaciones que van a continuación del rango sobre el que se estimó el
modelo cuando indicas la opción --out-of-sample, o bien, en otro caso, el
rango de la muestra definido en ese momento. Cuando solicitas una
predicción 'out-of-sample' pero no hay disponibles observaciones
relevantes, se muestra un fallo. Dependiendo de la naturaleza del modelo,
también pueden generarse las desviaciones típicas (mira abajo). También
mira abajo para indagar sobre el efecto especial de la opción --recursive.

Si el último modelo estimado tiene una única ecuación, entonces el
argumento nombrev (opcional) tiene el siguiente efecto: no se presentan los
valores de la predicción, sino que se guardan en el conjunto de datos con
el nombre indicado. Si el último modelo es un sistema de ecuaciones,
nombrev tiene un efecto distinto ya que, en concreto, escoge una variable
endógena en particular para hacer la predicción (pues por defecto se
generan las predicciones para todas las variables endógenas). En caso de un
sistema o si no indicas nombrev, puedes recuperar los valores de predicción
utilizando el accesorio "$fcast" y, si están disponibles, las desviaciones
típicas mediante "$fcse".

La elección entre una predicción estática o dinámica se aplica
únicamente en caso de modelos dinámicos, con una perturbación con un
proceso autorregresivo y/o que incluyan uno o más valores retardados de la
variable dependiente como regresores. Las predicciones estáticas son un
paso adelantadas (basadas en los valores obtenidos en el período previo),
mientras que las predicciones dinámicas emplean la regla de la cadena de
predicción. Por ejemplo, si una predicción para y en 2008 requiere como
entrada un valor de y en 2007, una predicción estática es imposible sin
datos actualizados para 2007, pero una predicción dinámica para 2008 es
posible si puedes substituir una predicción previa para y en 2007.

Por defecto se proporciona: (a) una predicción estática para alguna
porción del rango de predicción que cae dentro del rango de la muestra
sobre el que se estima el modelo, y (b) una predicción dinámica (si es
relevante) fuera de la muestra. La opción --dynamic solicita una
predicción dinámica a partir de la fecha lo más temprana posible, y la
opción --static solicita una predicción estática incluso fuera de la
muestra.

La opción --recursive está actualmente disponible solo para modelos de una
sola ecuación, estimados mediante MCO. Cuando indicas esta opción las
predicciones son recursivas; es decir, cada predicción se genera a partir
de una estimación del modelo indicado, utilizando los datos a partir de un
punto de inicio fijado (en concreto, el inicio del rango de la muestra para
la estimación original) hasta la fecha de predicción menos k, el número
de pasos adelantados que debes indicar en el argumento pasosadelante. Las
predicciones siempre son dinámicas si eso es pertinente. Ten en cuenta que
debes indicar el argumento pasosadelante únicamente junto con la opción
--recursive.

La opción --plot (disponible solo en caso de estimación de una única
ecuación) solicita que se produzca un archivo gráfico, que contiene una
representación gráfica de la predicción. El sufijo del argumento
nombrearchivo de esta opción controla el formato del gráfico: .eps para
EPS, .pdf para PDF, .png para PNG, y .plt para un archivo de instrucciones
Gnuplot. Puedes utilizar el título display en substitución del nombre de
archivo para forzar la representación del gráfico en una ventana. Por
ejemplo,

	fcast --plot=fc.pdf

va a generar un gráfico con formato PDF. Se respetan los nombres de rutas
que no ofrezcan dudas; en otro caso, los archivos se escriben en el
directorio de trabajo de Gretl.

La naturaleza de las desviaciones típicas de las predicciones (si están
disponibles) depende de la naturaleza del modelo y de la predicción. En
modelos lineales estáticos, las desviaciones típicas se calculan
utilizando el método bosquejado por Davidson y MacKinnon (2004); ellos
incorporan tanto la incertidumbre debida al proceso de la perturbación como
la incertidumbre en los parámetros (resumida en la matriz de covarianzas de
los estimadores de los parámetros). En modelos dinámicos, las desviaciones
típicas de las predicciones se calculan únicamente en caso de una
predicción dinámica, y no incorporan la incertidumbre en los parámetros.
Para modelos no lineales, las desviaciones típicas de las predicciones no
están disponibles actualmente.

Menú gráfico: Ventana de modelo: Análisis/Predicciones

# flush Programming

Esta sencilla instrucción (sin argumentos, sin opciones) está ideada para
ser usada en guiones que llevan algo de tiempo, y que deben ejecutarse con
la Interface Gráfica de Usuario (GUI) de Gretl (el programa de líneas de
instrucción lo ignora), para darle al usuario un indicio visual de que las
cosas se están moviendo y Gretl no está "parado".

Generalmente, si lanzas un guion en la Interface Gráfica de Usuario (GUI),
no se muestra el resultado hasta que se complete su ejecución, pero el
efecto de invocar flush es como se indica a continuación:

  En la primera llamada, Gretl abre una ventana, muestra los resultados
  hasta el presente y añade el mensaje "Procesando...".

  Tras invocaciones posteriores, se actualiza el texto que se muestra en la
  ventana de resultados, y se añade un nuevo mensaje "Procesando".

Cuando se completa la ejecución del guion, cualquier resultado que quede
pendiente se descarga automáticamente en la ventana de texto.

Ten en cuenta que no tiene sentido que utilices flush en guiones que tarden
menos de (digamos) 5 segundos en ejecutarse. También ten en cuenta que no
deberías utilizar esta instrucción en un lugar del guion donde no hay
resultados posteriores que presentar, ya que el mensaje "Procesando" será
entonces engañoso para el usuario.

El siguiente código ilustra el uso que se pretende con flush:

       set echo off
       scalar n = 10
       loop i=1..n
           # Hacer una operación que lleve algo de tiempo
           loop 100 --quiet
               a = mnormal(200,200)
               b = inv(a)
           endloop
           # Presentar algunos resultados
           printf "Iteración %2d hecha\n", i
           if i < n
               flush
           endif
       endloop

# foreign Programming

Sintaxis:   foreign language=ling
Opciones:   --send-data[=lista] (Carga previamente los datos; mira abajo)
            --quiet (Elimina los resultados del programa externo)

Esta instrucción abre un modo especial en el que se admiten instrucciones
que van a ejecutarse con otro programa. Puedes salir de este modo con end
foreign y, en ese punto, se ejecutan las instrucciones acumuladas.

Actualmente los programas "externos" a los que se les da apoyo de este modo
son GNU R (language=R), Python, Julia, GNU Octave (language=Octave), Ox de
Jurgen Doornik y Stata. Los nombres de los lenguajes se reconocen en
términos que no distinguen mayúsculas y minúsculas.

Junto con R, Octave y Stata, la opción --send-data tiene como efecto el
hacer accesibles los datos del espacio de trabajo del Gretl dentro del
programa señalado. Por defecto, se envía el conjunto completo de datos,
pero puedes limitar los datos que se van a enviar indicando el nombre de una
lista de series definida previamente. Por ejemplo:

	list Rlist = x1 x2 x3
	foreign language=R --send-data=Rlist

Consulta El manual de gretl (Capítulo 40) para obtener más detalles y
ejemplos.

# fractint Statistics

Argumentos: serie [ orden ] 
Opciones:   --gph (Hace el contraste de Geweke y Porter-Hudak)
            --all (Hace ambos contrastes)
            --quiet (No presenta los resultados)

Comprueba la integración fraccional ("memoria larga") de las series
especificadas contrastando la hipótesis nula de que el orden de
integración de la serie es cero. Por defecto, se utiliza el Estimador Local
Whittle (Robinson, 1995), pero cuando indicas la opción --gph, se realiza
el contraste GPH (Geweke y Porter-Hudak, 1983) en su lugar. Cuando decidas
indicar la opción --all, entonces se van a presentar los resultados de
ambos contrastes.

Para obtener más detalles sobre este tipo de contraste, consulta Phillips y
Shimotsu (2004).

Cuando no indicas el argumento orden (opcional), el orden para el(los)
contraste(s) se establece automáticamente como el número menor entre T/2 y
T^0.6.

Puedes recuperar los resultados utilizando los accesorios "$test" y
"$pvalue". Estos valores se basan en el Estimador Local Whittle excepto
cuando indicas la opción --gph.

Menú gráfico: /Variable/Contrastes de raíz unitaria/Integración fraccional

# freq Statistics

Argumento:  variable 
Opciones:   --nbins=n (Especifica el número de intervalos)
            --min=valormínimo (Especifica el mínimo, mira abajo)
            --binwidth=ancho (Especifica el ancho del intervalo, mira abajo)
            --normal (Contrasta la distribución Normal)
            --gamma (Contrasta la distribución Gamma)
            --silent (No presenta nada)
            --matrix=nombrematriz (Utiliza una columna de la matriz indicada)
            --plot=modo-o-nombrearchivo (Mira abajo)
            --quiet (No presenta el gráfico)
Ejemplos:   freq x
            freq x --normal
            freq x --nbins=5
            freq x --min=0 --binwidth=0.10

Si no indicas opciones, muestra la distribución de frecuencias de la serie
variable (indicada por su nombre o número), con el número de intervalos y
sus tamaños elegidos automáticamente.

Cuando indicas la opción --matrix, entonces variable debe ser un número
entero y se interpreta en este caso como un índice que escoge una columna
de la matriz indicada. Si la matriz en cuestión es realmente un vector
columna, puedes omitir este argumento variable.

Para controlar la presentación de la distribución puedes especificar, o
bien el número de intervalos, o bien el valor mínimo junto con el ancho de
los intervalos, como se mostró en los dos últimos ejemplos de arriba. La
opción --min establece el límite inferior del intervalo situado más a la
izquierda.

Cuando indicas la opción --normal, se calcula el estadístico chi-cuadrado
de Doornik-Hansen para contrastar la Normalidad. Cuando indicas la opción
--gamma, el contraste de Normalidad se substituye por el contraste no
paramétrico de Locke respecto a la hipótesis nula de que una variable
sigue una distribución Gamma; consulta Locke (1976), y también Shapiro y
Chen (2001). Ten en cuenta que la forma en la que se indican en Gretl los
parámetros de la distribución Gamma utilizada es (forma, escala).

Por defecto, si el programa no está en modo de procesamiento por lotes, se
muestra un gráfico de la distribución, pero puedes ajustar esto mediante
la opción --plot. Los parámetros admisibles para esta opción son: none
(para suprimir el gráfico), display (para mostrar un gráfico incluso
cuando estés en modo de procesamiento por lotes), o un nombre de archivo.
El efecto de indicar un nombre de archivo es como se describe para la
opción --output de la instrucción "gnuplot".

La opción --silent elimina el resultado de texto habitual. Puedes utilizar
esto junto con una u otra de las opciones para contrastes de distribución;
entonces se registran el estadístico de prueba más su probabilidad
asociada, y puedes recuperarlos utilizando los accesorios "$test" y
"$pvalue". También puedes usar esto junto con la opción --plot si
únicamente quieres un histograma y no te interesa mirar el texto que lo
acompaña.

Ten en cuenta que Gretl no tiene una función que se corresponda con esta
instrucción, pero resulta posible utilizar la función "aggregate" para
lograr el mismo objetivo. Además, puedes obtener la distribución de
frecuencias que se genera con la instrucción freq, en forma de matriz, por
medio del accesor "$result".

Menú gráfico: /Variable/Distribución de frecuencias

# funcerr Programming

Argumento:  [ mensaje ] 

Solo es aplicable en el contexto de una función definida por el usuario
(consulta "function"). Provoca que la ejecución de la función actual,
finalice con la señalización de una condición de fallo.

El argumento mensaje (opcional) puede tener la forma de una cadena de texto
literal, o del nome de una variable de cadena; si está presente, se
presenta como parte del mensaje de fallo que se le muestra a quien invoca la
función.

Esta instrucción también está disponible en forma de función (con el
mismo nombre, "funcerr").

# function Programming

Argumento:  nombrefunción 

Abre un bloque de expresiones en las que se define una función. Este bloque
debe estar terminado con end function. Consulta El manual de gretl
(Capítulo 13) para obtener más detalles.

# garch Estimation

Argumentos: p q ; depvar [ indepvars ] 
Opciones:   --robust (Desviaciones típicas robustas)
            --verbose (Presenta los detalles de las iteraciones)
            --quiet (No presenta nada)
            --vcv (Presenta la matriz de covarianzas)
            --nc (Sin constante)
            --stdresid (Tipifica los errores)
            --fcp (Utiliza el algoritmo de Fiorentini, Calzolari y Panattoni)
            --arma-init (Parámetros iniciales de la varianza partiendo de ARMA)
Ejemplos:   garch 1 1 ; y
            garch 1 1 ; y 0 x1 x2 --robust
            Ver también garch.inp, sw_ch14.inp

Estima un modelo GARCH (GARCH, Heterocedasticidad Condicional Autorregresiva
Generalizada), bien en un modelo univariante o bien incluyendo las variables
exógenas indicadas si especificas indepvars. Los valores enteros p y q (que
puedes indicar en formato numérico o con nombres de variables escalares ya
existentes) representan los órdenes de retardo en la ecuación de varianza
condicional:

  h(t) = a(0) + sum(i=1 to q) a(i)*u(t-i)^2 + sum(j=1 to p) b(j)*h(t-j)

Así, el parámetro p representa el orden Generalizado (o "AR"), mientras
que q representa el orden normal ARCH (o "MA"). Cuando p es no nulo, q
también debe ser no nulo; en otro caso, el modelo no está identificado.
Con todo, puedes estimar un modelo ARCH normal estableciendo que q es un
valor positivo, y que p es cero. La suma de p y q no debe ser mayor que 5.
Ten en cuenta que se incluye automáticamente una constante en la ecuación
media, excepto cunado indiques la opción --nc.

Por defecto, se utiliza el propio código de Gretl para estimar los modelos
GARCH, pero también tienes la opción de usar el algoritmo de Fiorentini,
Calzolari y Panattoni (1996). El primero utiliza el maximizador BFGS
mientras que el último usa la matriz de información para maximizar la
verosimilitud, con una puesta a punto mediante la matriz Hessiana.

Con esta instrucción dispones de diversas variantes de la matriz estimada
de las covarianzas de los estimadores. Por defecto, se utiliza la matriz
Hessiana excepto que indiques la opción --robust, en cuyo caso se va a usar
la matriz de covarianzas CMV (QML de White). También puedes especificar
otras posibilidades (e.g. la matriz de información o el estimador de
Bollerslev-Wooldridge) utilizando la instrucción "set".

Por defecto, las estimaciones de los parámetros de la varianza se inician
usando la varianza de la perturbación no condicionada de una estimación
inicial por MCO (para la constante) y valores positivos pequeños (para los
coeficientes que acompañan a los valores pasados tanto de las
perturbaciones cuadradas como de la varianza de la perturbación). La
opción --arma-init solicita que, para establecer los valores iniciales de
estos parámetros, se utilice un modelo inicial ARMA, explotando la
relación entre GARCH y ARMA expuesta en el capítulo 21 del libro Time
Series Analysis de Hamilton. En algunos casos, esto puede mejorar las
posibilidades de convergencia.

Puedes recuperar los errores GARCH y la varianza condicionada estimada con
$uhat y $h, respectivamente. Por ejemplo, para obtener la varianza
condicional:

	series ht = $h

Cuando indicas la opción --stdresid, se dividen los valores de $uhat por la
raíz cuadrada de h_t.

Menú gráfico: /Modelo/Series temporales univariantes/GARCH

# genr Dataset

Argumentos: nuevavariable = fórmula 

NOTA: Esta instrucción experimentó numerosos cambios y mejoras desde que
se escribió el siguiente texto de ayuda, por eso para comprender y
actualizar la información sobre esta instrucción, deberás seguir la
referencia de El manual de gretl (Capítulo 9). Por otro lado, esta ayuda no
contiene nada actualmente incorrecto, por lo que interpreta lo que sigue
como "tienes esto, y más".

Para esta instrucción y en el contexto apropiado, las expresiones series,
scalar, matrix, string y bundle son sinónimos.

Genera nuevas variables, habitualmente mediante transformaciones de las
variables ya existentes. Consulta también "diff", "logs", "lags", "ldiff",
"sdiff" y "square" como atajos. En el contexto de una fórmula genr, debes
hacer referencia a las variables ya existentes mediante su nombre, no con su
número ID. La fórmula debe ser una combinación bien hecha de nombres de
variables, constantes, operadores y funciones (descrito más abajo). Ten en
cuenta que puedes encontrar más detalles sobre algunos aspectos de esta
instrucción en El manual de gretl (Capítulo 9).

Una instrucción genr puede producir un resultado escalar o una serie. Por
ejemplo, la fórmula x2 = x * 2 naturalmente produce una serie cuando la
variable x es una serie, y un escalar cuando x es un escalar. Las fórmulas
x = 0 y mx = mean(x) naturalmente devuelven escalares. Bajo ciertas
circunstancias, puedes querer tener un resultado escalar ampliado a una
serie o vector; esto puedes hacerlo utilizando series como un "alias" para
la instrucción genr. Por ejemplo, series x = 0 produce una serie en la que
todos sus valores se ponen a 0. También puedes utilizar scalar como alias
de genr. No es posible forzar a un resultado en forma de vector que sea un
escalar, pero la utilización de esta palabra clave indica que el resultado
debiera de ser un escalar: si no lo es, aparece un fallo.

Cuando una fórmula produce un resultado en forma de serie, el rango sobre
el que se escribe ese resultado en la variable objetivo depende de la
configuración vigente de la muestra. Por lo tanto, puedes definir una serie
hecha a trozos utilizando la instrucción smpl junto con genr.

Se admiten los operadores aritméticos, en orden de prioridad: ^ (elevar a
la potencia); *, / y % (módulo o resto); + y -.

Los operadores booleanos disponibles son (de nuevo, en orden de prioridad):
! (negación), && (Y lógico), || (O lógico), >, <, == (igual a), >= (mayor
o igual que), <= (menor o igual que) y != (no igual). También puedes
utilizar los operadores booleanos en la construcción de variables
ficticias: por ejemplo, (x > 10) devuelve 1 en caso de que x > 10, y 0 en
otro caso.

Las constantes integradas son pi y NA. La última es el código de valor
ausente: puedes iniciar una variable con el valor ausente mediante scalar x
= NA.

La instrucción genr admite un amplio rango de funciones matemáticas y
estadísticas, incluyendo todas las habituales más varias que son
especiales de Econometría. Además, ofrece acceso a muchas variables
internas que se definen durante la ejecución de las regresiones, la
realización de contrastes de hipótesis, etcétera. Para obtener un listado
de funciones y accesorios, escribe "help functions".

Además de los operadores y de las funciones indicados arriba, hay algunos
usos especiales de "genr":

  "genr time" genera una variable de tendencia temporal (1,2,3,...) llamada
  "time". Y "genr index" tiene el mismo efecto, salvo que la variable se
  llama index.

  "genr dummy" genera tantas variables ficticias como la periodicidad de los
  datos. En caso de tener datos trimestrales (periodicidad 4), el programa
  genera dq1 = 1 para el primer trimestre y 0 para los otros trimestres, dq2
  = 1 para el segundo trimestre y 0 para los otros trimestres, etcétera.
  Con datos mensuales, las variables ficticias se nombran dm1, dm2,
  etcétera. Con otras frecuencias, los nombres son dummy_1, dummy_2, etc.

  "genr unitdum" y "genr timedum" generan conjuntos de variables ficticias
  especiales para utilizar con datos de panel, codificando las unidades de
  sección cruzada con la primera, y el período de tiempo de las
  observaciones con la segunda.

Advertencia: Con el programa en líneas de instrucción, las instrucciones
"genr" que recuperan datos relacionados con un modelo, siempre se refieren
al modelo que se estimó más recientemente. Esto también es cierto en el
programa de Interface Gráfica de Usuario (GUI), cuando utilizas "genr" en
la "consola de Gretl"o si introduces una fórmula usando la opción "Definir
nueva variable" bajo el menú Añadir en la ventana principal. Con la GUI,
sin embargo, tienes la opción de recuperar datos de cualquiera de los
modelos que se muestran en ese momento en una ventana (sea o no sea el
modelo estimado más recientemente). Puedes hacer esto bajo el menú
"Guardar" de la ventana del modelo correspondiente.

La variable especial obs sirve como índice para las observaciones. Por
ejemplo, series dum = (obs==15) genera una variable ficticia que tiene valor
1 para la observación 15, y el valor 0 en otro caso. También puedes usar
esta variable para escoger observaciones concretas por fecha o nombre. Por
ejemplo, series d = (obs>1986:4), series d = (obs>"2008-04-01"), o series d
= (obs=="CA"). Cuando utilizas fechas diarias o marcadores de observación
en este contexto, debes ponerlas entre comillas, pero puedes usar las fechas
trimestrales y mensuales (con dos puntos) sin comillas. Ten en cuenta que,
en caso de datos de series temporales anuales, el año no se distingue
sintácticamente de un sencillo número entero. Por lo tanto, si quieres
comparar observaciones frente a obs por año, debes usar la función obsnum
para convertir así el año en un valor índice en base 1, como se hace en
series d = (obs>obsnum(1986)).

Puedes sacar los valores escalares de una serie en el contexto de una
fórmula genr, utilizando la sintaxis varname[obs] en la que puedes indicar
el valor obs por número o fecha. Ejemplos: x[5], CPI[1996:01]. Para datos
diarios, debes usar la forma YYYY-MM-DD; e.g. ibm[1970-01-23].

Puedes modificar una observación individual de una serie mediante genr.
Para hacer esto, debes añadir un número válido de observación o de
fecha, entre corchetes, al nombre de la variable en el lado izquierdo de la
fórmula. Por ejemplo, genr x[3] = 30 o genr x[1950:04] = 303.7.

  Fórmula               Comentario
  -------                -------
  y = x1^3               x1 al cubo
  y = ln((x1+x2)/x3)     
  z = x>y                z(t) = 1 si x(t) > y(t), en otro caso 0
  y = x(-2)              x retardada 2 períodos
  y = x(+2)              x adelantada 2 períodos
  y = diff(x)            y(t) = x(t) - x(t-1)
  y = ldiff(x)           y(t) = log x(t) - log x(t-1), la tasa de crecimiento 
                         instantáneo de x
  y = sort(x)            Ordena x en orden ascendente y lo guarda en y
  y = dsort(x)           Ordena x en orden descendente
  y = int(x)             Trunca x y guarda su valor entero como y
  y = abs(x)             Guarda los valores absolutos de x
  y = sum(x)             Suma los valores de x excluyendo las entradas 
                         ausentes NA
  y = cum(x)             Acumulación: y(t) = suma desde s=1 hasta s=t de x(s) 
  aa = $ess              Establece aa igual a la Suma de Errores Cuadrados de 
                         la última regresión
  x = $coeff(sqft)       Recoge el coeficiente estimado de la variable sqft de 
                         la última regresión
  rho4 = $rho(4)         Recoge el coeficiente autorregresivo de orden 4 del 
                         último modelo (asume un modelo ar)
  cvx1x2 = $vcv(x1, x2)  Recoge la covarianza estimada de los coeficientes de 
                         las variables x1 y x2 del último modelo
  foo = uniform()        Variable pseudoaleatoria Uniforme en el rango 0-1
  bar = 3 * normal()     Variable pseudoaleatoria Normal, mu = 0, sigma = 3
  samp = ok(x)           = 1 para las observaciones donde x no está ausente

Menú gráfico: /Añadir/Definir nueva variable
Otro acceso:  Ventana principal: Menú emergente

# gmm Estimation

Opciones:   --two-step (Estimación en 2 etapas)
            --iterate (GMM iterados)
            --vcv (Presenta la matriz de covarianzas)
            --verbose (Presenta los detalles de las iteraciones)
            --quiet (No presenta nada)
            --lbfgs (Utiliza L-BFGS-B en lugar del BFGS normal)
Ejemplos:   hall_cbapm.inp

Realiza la estimación con el Método Generalizado de los Momentos (MGM o
GMM) utilizando el algoritmo BFGS (Broyden, Fletcher, Goldfarb, Shanno).
Debes especificar: (a) una o más instrucciones para actualizar las
cantidades relevantes (típicamente errores GMM), (b) uno o más conjuntos
de condiciones de ortogonalidad, (c) una matriz inicial de ponderaciones, y
(d) un listado con los parámetros a estimar, todo puesto entre las
etiquetas gmm y end gmm. Cualquier opción deberá añadirse a la línea end
gmm.

Consulta El manual de gretl (Capítulo 25) para obtener más detalles sobre
esta instrucción. Aquí simplemente lo ilustramos con un ejemplo sencillo.

	gmm e = y - X*b
	  orthog e ; W
	  weights V
	  params b
	end gmm

En el ejemplo de arriba, asumimos que tanto y como X son matrices de datos,
b es un vector de valores de los parámetros con la dimensión adecuada, W
es una matriz de instrumentos, y V es una matriz adecuada de ponderaciones.
La expresión

	orthog e ; W

indica que el vector de errores (e) es ortogonal, en principio, a cada uno
de los instrumentos que constituyen las columnas de W.

Nombres de los parámetros

Al estimar un modelo no lineal, frecuentemente resulta conveniente que
nombres los parámetros de modo conciso. Al presentar los resultados, sin
embargo, puede que desees utilizar etiquetas más informativas. Puedes
lograr esto mediante la palabra clave adicional param_names dentro del
bloque de instrucción. Para un modelo con k parámetros, el argumento que
sigue a esta palabra clave debe ser, bien una cadena de texto literal entre
comillas que contenga k nombres separados por espacios, o bien el nombre de
una variable de cadena que contenga k de esos nombres.

Menú gráfico: /Modelo/Variables instrumentales/GMM

# gnuplot Graphs

Argumentos: yvars xvar [ varficticia ] 
Opciones:   --with-lines[=varspec] (Utiliza líneas, no puntos)
            --with-lp[=varspec] (Utiliza líneas y puntos)
            --with-impulses[=varspec] (Utiliza barras finas verticales)
            --with-steps[=varspec] (Utiliza segmentos de líneas perpendiculares)
            --time-series (Representa frente al tiempo)
            --single-yaxis (Fuerza el uso de un único eje de ordenadas)
            --dummy (Mira abajo)
            --fit=espajuste (Mira abajo)
            --font=espfuente (Mira abajo)
            --band=espfranja (Mira abajo)
            --band-style=estilofranja (Mira abajo)
            --matrix=nombrematriz (Representa las columnas de la matriz indicada)
            --output=nombrearchivo (Envía el resultado al archivo especificado)
            --input=nombrearchivo (Coge la entrada de datos desde un archivo especificado)
Ejemplos:   gnuplot y1 y2 x
            gnuplot x --time-series --with-lines
            gnuplot wages educ gender --dummy
            gnuplot y x --fit=quadratic
            gnuplot y1 y2 x --with-lines=y2

Las variables de la lista yvars se dibujan frente a xvar. Para un gráfico
de una serie temporal puedes bien proponer time en lugar de xvar, o bien
utilizar el indicador de opción --time-series. Consulta también las
instrucciones"plot" y "panplot".

Por defecto, las posiciones de los datos se muestran con puntos, pero puedes
anular esto indicando una de las siguientes opciones: --with-lines,
--with-lp, --with-impulses o --with-steps. Cuando vas a representar más de
una variable en el eje de la y, puedes limitar el efecto de estas opciones a
un subconjunto de las variables utilizando el parámetro varspec. Este
deberá tener el formato de un listado con los nombres o números (en ambos
casos separados por comas) de las variables que se van a representar
respectivamente. Por ejemplo, en el último ejemplo de arriba se muestra
como representar y1 e y2 frente a x, de tal modo que y2 se representa con
una línea mientras y1 con símbolos.

Cuando selecciones la opción --dummy, debes indicar exactamente tres
variables: una variable y simple, una variable x y dvar, una variable
discreta. El efecto de esto consiste en representar yvar frente a xvar con
los puntos mostrados con colores diferentes dependiendo del valor de
varficticia en la observación indicada.

Cogiendo datos de una matriz

Generalmente se requieren los argumentos yvars y xvar que se refieren a
series del conjunto vigente de datos (indicados por el nombre o por el
número ID). Pero si mediante la opción --matrix, indicas una matriz ya
definida, estos argumentos se convierten en opcionales: si la matriz
especificada tiene k columnas, por defecto se tratan las primeras k - 1
columnas como las yvars y la última columna se trata como xvar. Sin
embargo, cuando indicas la opción --time-series, todas las k columnas se
representan frente al tiempo. Si quieres representar columnas escogidas de
la matriz, debes especificar yvars y xvar con el formato de números de
columna enteros positivos. Por ejemplo, si quieres un gráfico de
dispersión de la columna 2 de la matriz M frente a la columna 1, puedes
hacer:

	gnuplot 2 1 --matrix=M

Mostrar la línea del mejor ajuste

La opción --fit es solo aplicable en gráficos de dispersión de dos
variables y en gráficos de series temporales individuales. Por defecto, el
procedimiento en un gráfico de dispersión consiste en mostrar el ajuste
MCO si el coeficiente de la pendiente es significativo a un nivel del 10 por
ciento, mientras que el proceder para las series temporales es no mostrar
ninguna línea de ajuste. Puedes solicitar un comportamiento diferente
utilizando esta opción junto con alguno de los siguientes valores de los
parámetros espajuste. Ten en cuenta que si el gráfico es para una serie
temporal individual, el lugar de x lo ocupa 'time'.

  linear: Muestra el ajuste MCO independientemente del nivel de
  significación estadística.

  none: No muestra ninguna línea de ajuste.

  inverse, quadratic, cubic, semilog o linlog: Muestran una línea de ajuste
  basada en la regresión del tipo especificado. Con semilog queremos decir
  una regresión del logaritmo de y sobre x; entonces la línea ajustada
  representa la esperanza condicionada de y, obtenida mediante la función
  exponencial. Con linlog se quiere decir una regresión de y sobre el
  logaritmo de x.

  loess: Muestra el ajuste de una regresión robusta localmente ponderada
  (que también se conoce a veces como "lowess").

Representando una franja

Puedes utilizar la opción --band para representar cero o más series
acompañadas de una "franja" de algún tipo (típicamente representa un
intervalo de confianza). Esta opción requiere dos parámetros separados por
una coma: el nombre o el número ID de una serie que represente el centro de
la franja, y el nombre o ID de una serie que indique el ancho de la franja:
el efecto de esto consiste en dibujar una franja con ordenadas y que son
iguales al centro más/menos el ancho. Puedes utilizar un tercer parámetro
opcional (de nuevo separado por una coma) con el formato de una constante
numérica o el nombre de una variable escalar, para indicar un múltiplo de
la dimensión de anchura. Así, por ejemplo, el siguiente caso permite
representar y junto con una franja de más/menos 1.96 veces se_y:

	gnuplot y --time-series --band=y,se_y,1.96 --with-lines

Cuando indicas la opción --band, puedes usar la opción adjunta
--band-style para controlar la representación de la franja. Por defecto,
los límites superior e inferior se muestran con líneas sólidas, pero los
parámetros fill, dash, bars o step provocan que la franja se dibuje
respectivamente como un área sombreada, utilizando líneas con rayas,
utilizando barras de error o utilizando escalones. Además, puedes añadir
(después de una coma) o substituir una especificación del color. Aquí
tienes algunos ejemplos de estilo:

	gnuplot ... --band-style=fill
	gnuplot ... --band-style=dash,0xbbddff
	gnuplot ... --band-style=,black
	gnuplot ... --band-style=bars,blue

El primer ejemplo produce un área sombreada en el color establecido por
defecto; el segundo pasa a usar líneas con rayas con un color específico
gris azulado; el tercero utiliza líneas negras sólidas; y el último
muestra barras azules. Ten en cuenta que puedes indicar los colores bien
como valores RGB hexadecimales, o bien por el nombre; y puedes acceder a la
lista de nombres de colores reconocidos por Gnuplot dando la instrucción
"show colornames" en el propio Gnuplot o, en la propia consola de Gretl,
haciendo

	eval readfile("@gretldir/data/gnuplot/gpcolors.txt")

Franjas de recesión

También puedes utilizar las opciones "band" que se han descrito más
arriba, para añadir "franjas de recesión" a un gráfico. De este modo nos
referimos a franjas verticales que ocupan todo el rango de la dimensión y
del gráfico, y que indican la presencia (con franja) o ausencia (sin
franja) de alguna característica cualitativa, en un gráfico de series de
tiempo. Estas franjas habitualmente se utilizan para indicar períodos de
recesión; pero también puedes usarlas para señalar períodos de guerra, o
cualquier cosa que pueda codificarse con una variable ficticia 0/1.

En este contexto, la opción --band requiere un único parámetro: el
identificador de una serie que tenga valores 0 y 1, donde el 1 indica
"presencia" y el 0 indica "ausencia". Puedes utilizar la opción
--band-style para especificar un color para las franjas, indicado bien
mediante formato hexadecimal, o bien mediante un nombre que resulte
reconocible por gnuplot (consulta la sección previa). Aquí debajo se
presenta un ejemplo para representar una única franja:

	open AWM17 --quiet
	series dum = obs >= 1990:1 && obs <= 1994:2
	gnuplot YER URX --with-lines --time-series \
	  --band=dum --band-style=0xcccccc --output=display \
	  {set key top left;}

Controlando el resultado

En modo interactivo, el gráfico se muestra inmediatamente pero, en modo de
procesamiento por lotes, el procedimiento por defecto consiste en escribir
un archivo de instrucciones Gnuplot en el directorio de trabajo del usuario,
con un nombre con el patrón gpttmpN.plt, comenzando con N = 01. Puedes
generar los gráficos reales más tarde utilizando gnuplot (bajo MS Windows,
wgnuplot). Y puedes modificar este proceder utilizando la opción
--output=nombrearchivo. Esta opción controla el nombre de archivo
utilizado, y al mismo tiempo te permite especificar un formato concreto para
el resultado mediante la extensión de tres letras del nombre del archivo,
del siguiente modo: .eps da como resultado la génesis de un archivo
Encapsulated PostScript (EPS); .pdf produce un PDF; .png genera uno con
formato PNG, .emf solicita que sea EMF (Enhanced MetaFile), .fig pide que
sea un archivo Xfig, y .svg que sea un SVG (Scalable Vector Graphics).
Cuando indicas el nombre ficticio de archivo "display", entonces el gráfico
se muestra en la pantalla, como en el modo interactivo. Y cuando indicas un
nombre de archivo con cualquier extensión diferente a las que acaban de
mencionarse, se escribe un archivo de instrucciones Gnuplot.

Especificando una fuente

Puedes utilizar la opción --font para especificar una fuente concreta para
el gráfico. El parámetro espfuente debe tener la forma del nombre de una
fuente, seguida opcionalmente por un número que indique el tamaño en
puntos, separado del nombre por una coma o espacio, todo ello puesto entre
comillas, como en

	--font="serif,12"

Ten en cuenta que las fuentes disponibles para Gnuplot varían dependiendo
de la plataforma, y si estás escribiendo una instrucción de gráfico que
pretendes que sea portable, es mejor restringir el nombre de la fuente a las
genéricas sans o serif.

Añadiendo instrucciones Gnuplot

Dispones de una opción añadida de esta instrucción pues, a continuación
de la especificación de las variables que se van a dibujar y del indicador
de opción (si hay alguno), puedes añadir instrucciones literales de
Gnuplot para controlar la apariencia del gráfico (por ejemplo,
estableciendo el título del gráfico y/o rangos de los ejes). Estas
instrucciones deben estar puestas entre llaves, y debes terminar cada
instrucción Gnuplot con un punto y coma. Puedes utilizar una barra inversa
para continuar un conjunto de instrucciones Gnuplot a lo largo de más de
una línea. Aquí tienes un ejemplo de la sintaxis:

	{ set title 'Mi Título'; set yrange [0:1000]; }

Menú gráfico: /Ver/Gráficos
Otro acceso:  Ventana principal: Menú emergente, botón de gráficos en la barra de herramientas

# graphpg Graphs

Variantes:  graphpg add
            graphpg fontscale escala
            graphpg show
            graphpg free
            graphpg --output=nombrearchivo

La sesión "Página de gráficos" va a funcionar solo cuando tengas
instalado el sistema de composición tipográfica LaTeX, y además puedas
generar y ver un resultado PDF o PostScript.

En la ventana de iconos de la sesión, puedes arrastrar hasta 8 gráficos
sobre el icono de página de gráficos. Cuando pulses un doble clic sobre la
página de gráficos (o pulses el botón derecho y elijas "Mostrar"), se va
a componer una página que contiene los gráficos seleccionados y se va a
abrir con un visor adecuado. Desde ahí deberías poder imprimir la página.

Para vaciar la página de gráficos, pulsa el botón derecho del ratón
sobre su icono y selecciona "Vaciar".

Ten en cuenta que en sistemas diferentes a MS Windows, podrías tener que
ajustar la configuración del programa utilizado para ver archivos PDF o
PostScript. Encuéntralo bajo la pestaña "Programas" en la caja de diálogo
de las Preferencias generales de Gretl (bajo el menú Herramientas de la
ventana principal).

También es posible trabajar en la página de gráficos mediante un guion, o
utilizando la consola (en el programa de Interface Gráfica de Usuario,
GUI). Se le da apoyo a las siguientes instrucciones y opciones:

Para añadir un gráfico a la página de gráficos, puedes indicar la
instrucción graphpg add luego de guardar un gráfico definido, como en

	grf1 <- gnuplot Y X
	graphpg add

Para mostrar la página de gráficos: graphpg show.

Para vaciar la página de gráficos: graphpg free.

Para ajustar la escala de la fuente utilizada en la página de gráficos,
usa graphpg fontscale escala, donde escala es un múltiplo (por defecto
igual a 1.0). De este modo, para hacer que el tamaño de la fuente sea un 50
por ciento mayor que el tamaño por defecto, puedes hacer

	graphpg fontscale 1.5

Para solicitar la impresión de la página del gráfico en un archivo, usa
la opción --output= más un nombre de archivo; este nombre debería tener
la extensión ".pdf", ".ps" o ".eps". Por ejemplo:

	graphpg --output="myfile.pdf"

El archivo resultante va a escribirse en el directorio establecido en ese
momento ("workdir"), excepto que la cadena nombrearchivo contenga una
especificación completa de la ruta.

En este contexto, para el resultado se utilizan líneas de colores por
defecto; para utilizar patrones punto/raya en vez de colores, puedes añadir
la opción --monochrome.

# hausman Tests

Opciones:   --nerlove (Utiliza el método de Nerlove para efectos aleatorios)
            --matrix_diff (Utiliza el método de la matriz-diferencia para el contraste de Hausman)

Este contraste está disponible únicamente después de estimar un modelo
con datos de panel utilizando MCO (consulta también "setobs"). Contrasta el
modelo combinado simple frente a las principales alternativas, el modelo de
efectos fijos y el de efectos aleatorios.

El modelo de efectos fijos permite que la ordenada en el origen de la
regresión varíe de una unidad de sección cruzada a otra. Se presenta un
contraste F para la hipótesis nula de que las ordenadas en el origen no
difieren. El modelo de efectos aleatorios descompone la varianza de cada
perturbación en dos partes, una parte específica de la unidad de sección
cruzada y otra parte específica de cada observación concreta. (Se puede
calcular este estimador solo cuando el número de unidades de sección
cruzada en el conjunto de datos supera al número de parámetros a estimar.)
El estadístico de Multiplicadores de Lagrange de Breusch-Pagan contrasta la
hipótesis nula de que el estimador combinado de MCO es adecuado frente a la
alternativa de efectos aleatorios.

El modelo combinado de MCO puede rechazarse frente a ambas alternativas, la
de efectos fijos y la de efectos aleatorios. Mientras la perturbación
específica por unidad o grupo no esté correlacionada con las variables
independientes, el estimador de efectos aleatorios será más eficiente que
el estimador de efectos fijos; en otro caso, el estimador de efectos
aleatorios será inconsistente por lo que se prefiere el estimador de
efectos fijos. La hipótesis nula del contraste de Hausman indica que la
perturbación específica de grupo no está así correlacionada (y por eso
se prefiere el modelo de efectos aleatorios). Un valor bajo de la
probabilidad asociada (valor p) al estadístico de este contraste va en
contra del modelo de efectos aleatorios y a favor del modelo de efectos
fijos.

Las dos opciones de esta instrucción pertenecen al modelo de efectos
aleatorios. Por defecto, se utiliza el método de Swamy y Arora, mediante el
cálculo del estadístico de contraste de Hausman, utilizando el método de
regresión. Las opciones permiten utilizar el estimador alternativo de la
varianza de Nerlove, y /o la aproximación de la matriz-diferencia al
estadístico de Hausman.

Menú gráfico: Ventana de modelo: Contrastes/Diagnósticos de panel

# heckit Estimation

Argumentos: depvar indepvars ; ecuaciondeseleccion 
Opciones:   --quiet (No presenta los resultados)
            --two-step (Realiza la estimación en 2 etapas)
            --vcv (Presenta la matriz de covarianzas)
            --opg (Desviaciones típicas PEG (OPG))
            --robust (Desviaciones típicas CMV (QML))
            --cluster=clustvar (Consulta "logit" para más explicaciones)
            --verbose (Presenta resultados adicionales)
Ejemplos:   heckit y 0 x1 x2 ; ys 0 x3 x4
            Ver también heckit.inp

Modelo de selección de tipo Heckman. Al especificar esta instrucción, la
lista antes del punto y coma representa las variables de la ecuación
resultante, y la segunda lista representa las variables de la ecuación de
selección. La variable dependiente de la ecuación de selección (ys en el
ejemplo de arriba) debe ser una variable binaria.

Por defecto, los parámetros se estiman por el método de máxima
verosimilitud. La matriz de covarianzas de los estimadores de los
parámetros se calcula utilizando la inversa negativa de la matriz Hessiana.
Si quieres hacer la estimación en 2 etapas, utiliza la opción --two-step.
En este caso, la matriz de covarianzas de los estimadores de los parámetros
de la ecuación resultante se ajusta de modo adecuado según Heckman (1979).

Menú gráfico: /Modelo/Variable dependiente limitada/Heckit

# help Utilities

Variantes:  help
            help functions
            help instrucción
            help función
Opción:     --func (Escoge la ayuda sobre las funciones)

Si no indicas ningún argumento, presenta la lista de instrucciones
disponibles. Si indicas el argumento simple "functions", presenta la lista
de funciones disponibles (consulta "genr").

La expresión help instrucción describe cada instrucción indicada (e.g.
help smpl). La expresión help función describe cada función indicada
(e.g. help ldet). Algunas funciones tienen los mismos nombres que las
instrucciones relacionadas (e.g. diff); en ese caso, por defecto se presenta
la ayuda para la instrucción, pero puedes obtener ayuda para la función
utilizando la opción --func.

Menú gráfico: /Ayuda

# hfplot Graphs

Argumentos: listaaltafrec [ ; listabajafrec ] 
Opciones:   --with-lines (Gráfico con líneas)
            --time-series (Pon el tiempo en el eje de abscisas)
            --output=nombrearchivo (Envía el resultado al archivo especificado)

Proporciona un medio de dibujar una serie de alta frecuencia, posiblemente
junto a una o más series observadas con la frecuencia base del conjunto de
datos. El primer argumento debe ser una "MIDAS list"; y los términos
adicionales listabajafrec (opcionales) deberán ser series habituales ("de
baja frecuencia"), después de un punto y coma.

Para obtener más detalles sobre el efecto de la opción --output, consulta
la instrucción "gnuplot".

# hsk Estimation

Argumentos: depvar indepvars 
Opciones:   --no-squares (Mira abajo)
            --vcv (Presenta la matriz de covarianzas)
            --quiet (No presenta nada)

Esta instrucción es aplicable cuando existe heterocedasticidad en forma de
una función desconocida de los regresores, que puede aproximarse por medio
de una relación cuadrática. En ese contexto, ofrece la posibilidad de
obtener desviaciones típicas consistentes y estimaciones más eficientes de
los parámetros, en comparación con MCO.

El procedimiento implica (a) la estimación MCO del modelo de interés,
seguido de (b) una regresión auxiliar para generar una estimación de la
varianza de la perturbación, y finalmente (c) mínimos cuadrados
ponderados, utilizando como ponderación la inversa de la varianza estimada.

En la regresión auxiliar de (b), se regresa el logaritmo de los errores
cuadrados de la primera estimación MCO, sobre los regresores originales y
sus cuadrados (por defecto), o solo sobre los regresores originales (si
indicas la opción --no-squares). La transformación logarítmica se realiza
para asegurar que las varianzas estimadas son todas no negativas.
Denominando u^* a los valores ajustados por esta regresión, la serie con
las ponderaciones para la estimación MCP (WLS) final se forma entonces como
1/exp(u^*).

Menú gráfico: /Modelo/Otros modelos lineales/con corrección de Heterocedasticidad

# hurst Statistics

Argumento:  serie 
Opción:     --plot=modo-o-nombrearchivo (Mira abajo)

Calcula el exponente de Hurst (una medida de persistencia o larga memoria)
para una variable de tipo serie temporal que tenga por lo menos 128
observaciones.

Mandelbrot (1983) discute sobre el exponente de Hurst. En términos
teóricos, este es el exponente (H) de la relación

  RS(x) = an^H

donde RS expresa el "rango que se vuelve a escalar" de la variable x en
muestras de tamaño n y a es una constante. El rango reescalado es el rango
(valor máximo menos mínimo) del valor acumulado o suma parcial de x (luego
de la substracción de su media muestral) en el período de la muestra,
dividida por la desviación típica muestral.

Como punto de referencia, si x es una variable ruido blanco (con media y
persistencia nulas) entonces el rango de su "paseo" (forma un paseo
aleatorio) acumulado y escalado por su desviación típica, tiene un
crecimiento igual a la raíz cuadrada del tamaño de la muestra,
proporcionando un exponente de Hurst esperado de 0.5. Los valores del
exponente que estén significativamente por encima de 0.5 indican
persistencia, y los menores que 0.5 indican "antipersistencia"
(autocorrelación negativa). En principio, el exponente está acotado entre
0 y 1, aunque en muestras finitas es posible obtener un exponente estimado
mayor que 1.

En Gretl, el exponente se estima utilizando submuestreo binario: se empieza
con el rango completo de datos, después con las dos mitades del rango,
después con los 4 cuartos, etcétera. Para tamaños de la muestra menores
que el rango de datos, el valor RS es la media entre las muestras
disponibles. El exponente se estima así como el coeficiente de la
pendiente, en una regresión del logaritmo de RS sobre el logaritmo del
tamaño de la muestra.

Por defecto, si el programa no está en modo de procesamiento por lotes, se
muestra un gráfico del rango reescalado pero puedes ajustar esto mediante
la opción --plot. Los parámetros que se admiten para esta opción son none
(para suprimir el gráfico); display (para presentar un gráfico incluso en
caso de procesar por lotes); o un nombre de archivo. El efecto de indicar un
nombre de archivo es como el descrito para la opción --output de la
instrucción "gnuplot".

Menú gráfico: /Variable/Exponente de Hurst

# if Programming

Control de flujo para la ejecución de instrucciones. Se admiten 3 tipos de
construcción, como las indicadas a continuación.

	# Forma simple
	if (poner la condición)
	    instrucciones
	endif

	# Dos ramas
	if (poner la condición)
	    instrucciones 1
	else
	    instrucciones 2
	endif

	# Tres o más ramas
	if (poner la condición 1)
	    instrucciones 1
	elif (poner la condición 2)
	    instrucciones 2
	else
	    instrucciones 3
	endif

La condición ("condition") debe ser una expresión booleana; para su
sintaxis consulta "genr". Puedes incluir más de un bloque "elif". Además,
puedes anidar los bloques if ... endif.

# include Programming

Argumento:  nombrearchivo 
Opción:     --force (Fuerza a volver a leer desde el archivo)
Ejemplos:   include myfile.inp
            include sols.gfn

Ideado para utilizar en un guion de instrucciones, principalmente para
incluir definiciones de funciones. El nombre del archivo (nombrearchivo)
debería tener la extensión inp (un guion de texto plano) o gfn (un paquete
de funciones de Gretl). Las instrucciones de nombrearchivo se ejecutan y
luego el control se devuelve al guion principal.

La opción --force es específica de los archivos gfn y su efecto consiste
en forzar a Gretl a que vuelva a leer el paquete de funciones desde el
archivo, incluso aunque ya esté cargado en la memoria. (Los archivos de
texto plano inp siempre se leen y se procesan en respuesta a esta
instrucción.)

Consulta también "run".

# info Dataset

Presenta cualquier información complementaria guardada con el archivo
vigente de datos.

Menú gráfico: /Datos/Información del conjunto de datos
Otro acceso:  Ventanas del buscador de datos

# intreg Estimation

Argumentos: minvar maxvar indepvars 
Opciones:   --quiet (No presenta los resultados)
            --verbose (Presenta los detalles de las iteraciones)
            --robust (Desviaciones típicas robustas)
            --opg (Mira más abajo)
            --cluster=clustvar (Consulta "logit" para más explicaciones)
Ejemplos:   intreg lo hi const x1 x2
            Ver también wtp.inp

Estima un modelo de regresión por intervalos. Este modelo surge cuando la
variable dependiente está imperfectamente observada para algunas
observaciones (posiblemente todas). En otras palabras, se asume que el
proceso generador de datos es

  y* = x b + u

pero solo observamos m <= y* <= M (el intervalo puede no tener límite por
la izquierda o por la derecha). Ten en cuenta que para algunas observaciones
m puede ser igual a M. Las variables minvar y maxvar deben contener NAs para
las observaciones sin límite por la izquierda o por la derecha,
respectivamente.

El modelo se estima mediante Máxima Verosimilitud, asumiendo la
distribución Normal del término de perturbación aleatoria.

Por defecto, las desviaciones típicas se calculan utilizando la inversa
negativa de la matriz Hessiana. Cuando especificas la opción --robust,
entonces se calculan en su lugar las desviaciones típicas CMV (QML) o de
Huber-White. En este caso, la matriz de covarianzas estimada es un
"emparedado" entre la inversa de la matriz Hessiana estimada y el producto
externo del vector gradiente. Como alternativa puedes indicar la
opción--opg, en cuyo caso las desviaciones típicas se basan únicamente en
el producto externo del vector gradiente.

Menú gráfico: /Modelo/Variable dependiente limitada/Regresión de intervalos

# join Dataset

Argumentos: nombrearchivo nombrevar 
Opciones:   --data=nombrecolumna (Mira abajo)
            --filter=expresión (Mira abajo)
            --ikey=claveinterna (Mira abajo)
            --okey=claveexterna (Mira abajo)
            --aggr=método (Mira abajo)
            --tkey=nombrecoluma,cadenaformato (Mira abajo)
            --verbose (Informe en marcha)

Esta instrucción incorpora una serie con el nombre nombrevar con datos,
desde el origen nombrearchivo (que debe ser bien un archivo de datos con el
texto delimitado, o bien un archivo de datos "propio" de Gretl). Para
obtener más detalles, consulta El manual de gretl (Capítulo 7) pues aquí
damos solo un breve resumen de las opciones disponibles.

Puedes utilizar la opción --data para especificar el encabezamiento de los
datos del archivo de origen, si difiere del nombre por el que los datos
debieran de conocerse en Gretl.

Puedes usar la opción --filter para especificar un criterio para filtrar
los datos de origen (es decir, para escoger un subconjunto de las
observaciones).

Puedes utilizar las opciones --ikey y --okey para especificar una
equivalencia entre las observaciones del conjunto vigente de datos y las
observaciones de la fuente de datos (por ejemplo, los individuos pueden
hacerse corresponder con el hogar al que pertenecen).

La opción --aggr se utiliza cuando la equivalencia entre las observaciones
del conjunto vigente de datos y las del origen no es de una a una.

La opción --tkey se aplica solo cuando el conjunto vigente de datos tiene
una estructura de serie temporal. Puedes usarla para especificar, bien el
nombre de una columna que contenga fechas que van a ser emparejadas con el
conjunto de datos, y/o bien el formato en el que las fechas se representan
en esa columna.

Consulta también "append" para las operaciones más sencillas de anexión.

# kpss Tests

Argumentos: orden listavariables 
Opciones:   --trend (Incluye una tendencia)
            --seasonals (Incluye variables ficticias estacionales)
            --verbose (Presenta los resultados de la regresión)
            --quiet (No presenta los resultados)
            --difference (Utiliza la primera diferencia de la variable)
Ejemplos:   kpss 8 y
            kpss 4 x1 --trend

Para utilizar esta instrucción con datos de panel, consulta la sección
final de estas anotaciones.

Calcula el contraste de estacionariedad KPSS (Kwiatkowski et al, Journal of
Econometrics, 1992) para cada una de las variables indicadas (o para sus
primeras diferencias, si escoges la opción --difference). La hipótesis
nula es que la variable en cuestión es estacionaria, bien alrededor de un
nivel o, si marcas la opción --trend, alrededor de una tendencia lineal
determinística.

El argumento orden determina el tamaño de la ventana utilizada para el
suavizado de Bartlett. Cuando indicas un valor negativo, eso se toma como
señal para que se utilice una ventana automática de tamaño 4(T/100)^0.25,
donde T es el tamaño de la muestra.

Si escoges la opción --verbose, se presentan los resultados de la
regresión auxiliar junto con la varianza estimada de la componente de paseo
aleatorio de la variable.

Los puntos críticos mostrados para el estadístico de contraste se basan en
superficies de respuesta estimadas del modo establecido por Sephton
(Economics Letters, 1995), que son más fiables para muestras pequeñas que
los valores indicados en el artículo original de KPSS. Cuando el
estadístico de contraste cae entre los puntos críticos del 1 y del 10 por
ciento, se muestra una probabilidad asociada (valor p) que se obtiene
mediante interpolación lineal y no debe tomarse demasiado literalmente.
Consulta la función "kpsscrit" para ver un medio de obtener esos puntos
críticos con la ayuda del programa.

Datos de panel

Cuando se utiliza la instrucción kpss con datos de panel, para realizar un
contraste de raíz unitaria de panel, las opciones aplicables y los
resultados mostrados son algo diferentes. Mientras que en el caso habitual
de series temporales, puedes indicar una lista de variables para contrastar,
con datos de panel solo puedes contrastar una variable por cada
instrucción. Y la opción --verbose tiene un significado diferente, pues
genera una breve presentación del contraste para cada serie temporal
individual (ya que, por defecto, solo se muestra el resultado global).

Cuando es posible, se calcula el contraste global (Hipótesis nula: La serie
en cuestión es estacionaria para todas las unidades del panel) utilizando
para ello el método de Choi (Journal of International Money and Finance,
2001). Esto no siempre es sencillo pues la dificultad está en que, mientras
que el contraste de Choi se basa en las probabilidades asociadas de los
contrastes con las series individuales, no tenemos actualmente un modo de
calcular las probabilidades asociadas para el estadístico de contraste
KPSS; debemos apoyarnos en unos pocos puntos críticos.

Si el estadístico de contraste con una determinada serie, cae entre los
puntos críticos del 1 y del 10 por ciento, podemos interpolar una
probabilidad asociada. Pero si el valor del estadístico del contraste cae
por debajo del correspondiente al 10 por ciento o si excede al del 1 por
ciento, no se puede interpolar y como mucho se puede establecer un límite
sobre el contraste de Choi global. Si el valor del estadístico de contraste
individual cae por debajo del correspondiente al 10 por ciento para unas
unidades y excede al del 1 por ciento para otras, ni siquiera se puede
calcular un límite para el contraste global.

Menú gráfico: /Variable/Contrastes de raíz unitaria/Contraste KPSS

# labels Dataset

Variantes:  labels [ listavariables ]
            labels --to-file=nombrearchivo
            labels --from-file=nombrearchivo
            labels --delete
Ejemplos:   oprobit.inp

Con la primera forma, se presentan las etiquetas informativas (si existen)
de las series de listavariables, o de todas las series del conjunto de datos
cuando no especificas listavariables.

Con la opción --to-file se escriben en el archivo indicado, las etiquetas
de todas las series del conjunto de datos, una etiqueta por cada línea. Si
no hay ninguna etiqueta, se muestra un fallo; y si algunas series tienen
etiqueta y otras no, se presenta una línea en blanco para las series sin
etiqueta. El archivo resultante se va a escribir en el directorio "workdir"
vigente en ese momento, excepto que la cadena nombrearchivo contenga una
especificación completa de la ruta.

Con la opción --from-file, se lee el archivo especificado (que debe ser de
texto plano) y se asignan etiquetas a las series del conjunto de datos,
leyéndose una etiqueta por línea y usando líneas en blanco para indicar
etiquetas en blanco.

La opción --delete hace lo que cabría esperar pues elimina todas las
etiquetas de las series del conjunto de datos.

Menú gráfico: /Datos/Etiquetas de variables

# lad Estimation

Argumentos: depvar indepvars 
Opciones:   --vcv (Presenta la matriz de covarianzas)
            --no-vcv (No calcula la matriz de covarianzas)
            --quiet (No presenta nada)

Calcula una regresión que minimiza la suma de las desviaciones absolutas de
los valores ajustados respecto a los valores observados de la variable
dependiente. Las estimaciones de los coeficientes se derivan utilizando el
algoritmo del simplex de Barrodale-Roberts; y se presenta una advertencia si
la solución no es única.

Las desviaciones típicas se deducen utilizando el procedimiento 'bootstrap'
con 500 extracciones. La matriz de covarianzas de los estimadores de los
parámetros, que se presenta cuando indicas --vcv, se basa en el mismo
'bootstrap'. Puesto que esta es una operación bastante costosa, la opción
--no-vcv se proporciona para aquellos casos en los que no se necesita la
matriz de covarianzas; cuando indicas esta opción, las desviaciones
típicas no van a estar disponibles.

Ten en cuenta que este método puede resultar lento cuando la muestra es muy
larga o cuando hay muchos regresores. Por eso, en esos casos, puede ser
mejor utilizar la instrucción "quantreg". Dadas una variable dependiente y
junto con una lista X de regresores, las siguientes instrucciones son
básicamente equivalentes, con la excepción de que el método "quantreg"
utiliza el algoritmo más rápido de Frisch-Newton, y que proporciona las
desviaciones típicas analíticas en lugar de las de "bootstrapping".

	lad y const X
	quantreg 0.5 y const X

Menú gráfico: /Modelo/Estimación robusta/Mínima desviación absoluta

# lags Transformations

Argumentos: [ orden ; ] listaretardos 
Opción:     --bylag (Ordena los términos por retardo)
Ejemplos:   lags x y
            lags 12 ; x y
            lags 4 ; x1 x2 x3 --bylag
            Ver también sw_ch12.inp, sw_ch14.inp

Genera nuevas series que contienen los valores retardados de cada una de las
series de listavariables. Por defecto, el número de retardos que se crean
es igual a la periodicidad de los datos. Por ejemplo, si la periodicidad es
4 (trimestral), la instrucción "lags x" genera

	x_1 = x(t-1)
	x_2 = x(t-2)
	x_3 = x(t-3)
	x_4 = x(t-4)

Puedes controlar el número de retardos generados mediante el primer
parámetro opcional (que, si existe, debe estar seguido de un punto y coma).

La opción --bylag tiene sentido solo cuando listavariables contiene más de
una serie y el orden máximo de retardos es mayor que 1. Por defecto, se
añaden los términos retardados al conjunto de datos, por variable: primero
todos los retardos de la primera serie de la lista, después todos los
retardos de la segunda serie, etcétera. Pero cuando indicas --bylag, la
ordenación se hace por retardos: primero el retardo 1 de todas las series
de la lista, después el retardo 2 de todas as series de la lista,
etcétera.

Menú gráfico: /Añadir/Retardos de las variables seleccionadas

# ldiff Transformations

Argumento:  listavariables 

Se obtiene la primera diferencia del logaritmo natural de cada una de las
series de listavariables, y el resultado se guarda en una nueva serie con el
prefijo ld_. Así "ldiff x y" genera las nuevas variables

	ld_x = log(x) - log(x(-1))
	ld_y = log(y) - log(y(-1))

Menú gráfico: /Añadir/Diferencias de logaritmos de las variables seleccionadas

# leverage Tests

Opciones:   --save (Guarda las series resultantes)
            --quiet (No presenta los resultados)
            --plot=modo-o-nombrearchivo (Mira abajo)
Ejemplos:   leverage.inp

Debe ir después de una instrucción de MCO ("ols"). Calcula el
apalancamiento (h, que debe caer en el rango entre 0 y 1) para cada punto de
datos de la muestra sobre la que se estimó el modelo previo. Muestra el
error (u) para cada observación junto con su apalancamiento y una medida de
su influencia en las estimaciones, uh/(1 - h). Los "puntos de Leverage" para
los que el valor de h supera 2k/n (donde k es el número de parámetros que
se estiman y n es el tamaño de la muestra) se destacan mediante un
asterisco. Para obtener más detalles sobre los conceptos de apalancamiento
e influencia, consulta el capítulo 2 del libro de Davidson y MacKinnon
(1993).

También se calculan los valores DFFITS: estos son iguales a los "errores
tipificados" (errores de predicción divididos por sus desviaciones
típicas) multiplicados por sqrt[h/(1 - h)]. Para una discusión sobre
errores tipificados y DFFITS consulta el capítulo 12 del libro de Maddala
Introduction to Econometrics o Belsley, Kuh y Welsch (1980).

Abreviadamente, un "error de predicción" es la diferencia entre el valor
observado de la variable dependiente en la observación t, y el valor
ajustado para esa observación t que se obtiene de la regresión en la que
se omite esa observación (o en la que se añade una variable ficticia con
un valor 1 solo en la observación t); el error tipificado se obtiene
dividiendo el error de predicción por su desviación típica.

Cuando especificas la opción --save con esta instrucción, los valores de
apalancamiento, influencia y DFFITS se añaden al conjunto vigente de datos;
en este contexto, puedes utilizar la opción --quiet para eliminar la
presentación de los resultados. Los nombres por defecto de las series
guardadas son lever, influ y dffits, respectivamente. Sin embargo, si ya
existen series con esos nombres, los de las nuevas series guardadas se
ajustan para garantizar la unicidad; en cualquier caso, estas serán las 3
series con números ID más grandes del conjunto de datos.

Después de la ejecución, el accesorio "$test" devuelve el criterio de
validación cruzada, que se define como la suma de las desviaciones
cuadradas de la variable dependiente con relación a sus valores de
predicción, estando la predicción para cada observación basada en una
muestra de la que se excluye esa observación. (Este es el conocido como
estimador dejar-uno-fuera). Para una discusión más amplia sobre el
criterio de validación cruzada, consulta el libro de Davidson y MacKinnon
Econometric Theory and Methods, páginas 685-686, y las referencias que
contiene.

Por defecto, si haces una llamada interactiva a esta instrución, se muestra
un gráfico con los valores de apanlancamiento e influencia. Puedes axustar
esto mediante la opción --plot. Los parámetros que se admiten para esta
opción son none (para suprimir el gráfico), display (para mostrar un
gráfico incluso al estar en modo de guiones), o un nombre de archivo. El
efecto de indicar un nombre de archivo es como el descrito para la opción
--output de la instrucción "gnuplot".

Menú gráfico: Ventana de modelo: Análisis/Observaciones influyentes

# levinlin Tests

Argumentos: orden serie 
Opciones:   --nc (Sin constante)
            --ct (Con constante y tendencia)
            --quiet (No presenta los resultados)
            --verbose (Presenta los resultados por unidad)
Ejemplos:   levinlin 0 y
            levinlin 2 y --ct
            levinlin {2,2,3,3,4,4} y

Realiza el contraste de raíz unitaria para panel descrita por Levin, Lin y
Chu (2002). La hipótesis nula es que todas las series temporales
individuales presentan una raíz unitaria, y la alternativa es que ninguna
de las series tiene una raíz unitaria. (Es decir, se asume un mismo
coeficiente común de AR(1), aunque en otros aspectos se permite que las
propiedades estadísticas de las series varíen de unos individuos a otros.)

Por defecto, las regresiones del contraste ADF incluyen una constante. Para
eliminar la constante utiliza la opción --nc y para incluirla junto con una
tendencia lineal utiliza la opción --ct. (Consulta la instrucción "adf"
para una explicación de las regresiones del ADF.)

Puedes indicar el orden de retardo con orden (no negativo) para hacer el
contraste (controlando así el número de retardos de la variable
dependiente a incluir en las regresiones del ADF) de una de estas dos
formas. Cuando indicas un valor escalar, esto se aplica a todos los
individuos del panel. La alternativa es proporcionar una matriz que contenga
un orden específico de retardos para cada individuo; esta debe ser un
vector con tantos elementos como individuos haya en el rango de la muestra
vigente. Puedes especificar esa matriz con el nombre o construirla
utilizando llaves, como se ilustró en el último ejemplo de arriba.

Cuando indicas la opción --verbose, se presentan los siguientes resultados
para cada unidad del panel: delta, el coeficiente del nivel retardado en
cada regresión ADF; s2e, la varianza estimada de las innovaciones; y s2y,
la varianza estimada a largo plazo de la serie diferenciada.

Observa que los contrastes de raíz unitaria en un panel también puedes
hacerlos utilizando las instrucciones "adf" y "kpss".

Menú gráfico: /Variable/Contrastes de raíz unitaria/Contraste Levin-Lin-Chu

# logistic Estimation

Argumentos: depvar indepvars 
Opciones:   --ymax=máximo (Especifica el máximo de la variable dependiente)
            --robust (Desviaciones típicas robustas)
            --cluster=clustvar (Consulta "logit" para una explicación)
            --vcv (Presenta la matriz de covarianzas)
            --fixed-effects (Mira abajo)
            --quiet (No presenta nada)
Ejemplos:   logistic y const x
            logistic y const x --ymax=50

Regresión logística: Lleva a cabo una regresión MCO utilizando la
transformación logística de la variable dependiente,

  log(y/(y* - y))

La variable dependiente debe ser estrictamente positiva. Si todos sus
valores están entre 0 y 1, por defecto se utiliza un valor de y^* (el
máximo asintótico de la variable dependiente) igual a 1; si sus valores
están entre 0 y 100, entonces y^* es 100 por defecto.

Si quieres establecer un máximo diferente, utiliza la opción --ymax. Ten
en cuenta que el valor que indiques debe ser mayor que todos los valores
observados de la variable dependiente.

Los valores ajustados y los errores de la regresión se transforman
automáticamente utilizando la inversa de la transformación logística:

  y =~ E(y* / (1 + exp(-x)))

donde x representa un valor ajustado o un error, obtenidos de la regresión
MCO que utiliza la variable dependiente logística. De este modo puedes
comparar los valores que se presentan con los de la variable dependiente
original. La aproximación es necesaria pues la transformación inversa no
es lineal, y por lo tanto la esperanza no se corresponde exactamente.

La opción --fixed-effects solo es aplicable cuando el conjunto de datos
tiene forma de panel. En ese caso, se le restan las medias de grupo de la
transformación logística de la variable dependiente, y la estimación
continúa como se hace habitualmente con efectos fijos.

Ten en cuenta que si la variable dependiente es binaria, debes utilizar en
su lugar la instrucción "logit".

Menú gráfico: /Modelo/Variable dependiente limitada/Logística

# logit Estimation

Argumentos: depvar indepvars 
Opciones:   --robust (Desviaciones típicas robustas)
            --cluster=clustvar (Desviaciones típicas agrupadas)
            --multinomial (Estima un logit multinomial)
            --vcv (Presenta la matriz de covarianzas)
            --verbose (Presenta los detalles de las iteraciones)
            --quiet (No presenta los resultados)
            --p-values (Muestra los valores p en vez de las pendientes)
Ejemplos:   keane.inp, oprobit.inp

Si la variable dependiente es una variable binaria (todos sus valores son 0
o 1), se obtienen estimaciones máximo verosímiles de los coeficientes de
las variables de indepvars mediante el método de Newton-Raphson. Como el
modelo es no lineal, las pendientes están condicionadas por los valores de
las variables independientes. Por defecto, se calculan las pendientes con
respecto a cada una de las variables independientes (en las medias de esas
variables), y estas pendientes substituyen los valores p habituales en el
resultado de la regresión. Puedes prescindir de este proceder indicando la
opción --p-values. El estadístico chi-cuadrado contrasta la hipótesis
nula de que todos los coeficientes son cero, excepto el de la constante.

Por defecto, las desviaciones típicas se calculan utilizando la inversa
negativa de la matriz Hessiana. Si indicas la opción --robust, entonces se
calculan en su lugar las desviaciones típicas CMV (QML) o de Huber-White.
En este caso, la matriz de covarianzas estimadas es un "emparedado" entre la
inversa de la matriz Hessiana estimada y el producto externo del vector
gradiente; consulta el capítulo 10 del libro de Davidson y MacKinnon
(2004). Pero cuando indicas la opción --cluster, entonces se generan las
desviaciones típicas "robustas por agrupación"; consulta El manual de
gretl (Capítulo 20) para obtener más detalles.

Si la variable dependiente no es binaria sino discreta, entonces por defecto
se interpreta como una respuesta ordinal y se obtienen las estimaciones con
un Logit Ordenado. Sin embargo, cuando indicas la opción --multinomial, la
variable dependiente se interpreta como una respuesta sin ordenar y se
generan las estimaciones con un Logit Multinomial. (En otro caso, si la
variable escogida como dependiente no es de tipo discreto, se muestra un
fallo.) En el caso multinomial, el accesorio $mnlprobs está disponible
después de la estimación, para conseguir una matriz que contenga las
probabilidades estimadas de los posibles valores de la variable dependiente
para cada observación (con las observaciones por filas y los posibles
valores por columnas).

Si quieres utilizar un Logit para el análisis de proporciones donde, para
cada observación, la variable dependiente es la proporción de casos que
tienen una determinada característica (en vez de una variable con 1 o 0
para indicar si está presente o no la característica), no debes utilizar
la instrucción "logit", sino más bien construir la variable logit, como en

	series lgt_p = log(p/(1 - p))

y utilizar esta como la variable dependiente de una regresión MCO. Consulta
el capítulo 12 de Ramanathan (2002).

Menú gráfico: /Modelo/Variable dependiente limitada/Logit

# logs Transformations

Argumento:  listavariables 

Permite obtener el logaritmo natural de cada una de las series de
listavariables y el resultado se guarda en una nueva serie con el prefijo l_
("ele" y guion bajo). Por ejemplo, "logs x y" genera las nuevas variables
l_x = ln(x) y l_y = ln(y).

Menú gráfico: /Añadir/Logaritmos de las variables seleccionadas

# loop Programming

Argumento:  control 
Opciones:   --progressive (Permite formas especiales de ciertas instrucciones)
            --verbose (Muestra los detalles de las instrucciones genr)
            --quiet (No muestra el número de iteraciones realizadas)
Ejemplos:   loop 1000
            loop 1000 --progressive
            loop while essdiff > .00001
            loop i=1991..2000
            loop for (r=-.99; r<=.99; r+=.01)
            loop foreach i xlista
            Ver también armaloop.inp, keane.inp

Esta instrucción abre un modo especial en el que el programa admite que las
instrucciones se ejecuten repetidas veces. Terminas el proceso de ir
introduciendo las instrucciones del bucle con "endloop" y en este punto se
ejecutan las instrucciones acumuladas.

El parámetro "control" puede tener cualquiera de las 5 formas siguientes,
tal como se muestra en los ejemplos: (a) un número entero que indica las
veces a repetir las instrucciones de un bucle; (b) la palabra "while" más
una condición booleana; (c) un rango de valores enteros para el índice;
(d) la palabra "for" más 3 expresiones dentro de un paréntesis, separadas
con punto y comas (que imita la orden for en el lenguaje de programación
C); o (e) la palabra "foreach" más una variable índice y una lista.

Consulta El manual de gretl (Capítulo 12) para obtener otros detalles y
ejemplos. Ahí se explica el efecto de la opción --progressive (que está
diseñada para ser utilizada con simulaciones de tipo Monte Carlo). No
puedes utilizar todas las instrucciones de Gretl dentro de un bucle; por eso
las instrucciones disponibles en este contexto también se exponen ahí.

# mahal Statistics

Argumento:  listavariables 
Opciones:   --quiet (No presenta nada)
            --save (Añade las distancias al conjunto de datos)
            --vcv (Presenta la matriz de covarianzas)

Calcula las distancias de Mahalanobis entre las series indicadas en
listavariables. La distancia de Mahalanobis es la distancia entre dos puntos
en un espacio de dimensión k, escalada por la variación estadística en
cada dimensión del espacio. Por ejemplo, si p y q son dos observaciones de
un conjunto de k variables con matriz de covarianzas C, entonces la
distancia de Mahalanobis entre las observaciones viene dada por

  sqrt((p - q)' * C-inverse * (p - q))

donde (p - q) es un vector de dimensión k. Esto se reduce a la distancia
euclidiana en caso de que la matriz de covarianzas sea una matriz identidad.

El espacio para el que se calculan las distancias está definido por las
variables seleccionadas. Para cada observación del rango vigente de la
muestra, la distancia se calcula entre la observación y el centroide de las
variables escogidas. Esta distancia es la contrapartida multidimensional de
una puntuación z estándar, y puedes utilizarla para juzgar si una
observación dada "pertenece" a un grupo de otras observaciones.

Cuando indicas la opción --vcv, se presentan tanto la matriz de covarianzas
como su inversa. Cuando indicas la opción --save, las distancias se guardan
en el conjunto de datos con el nombre mdist (o mdist1, mdist2 y así
sucesivamente, si ya existe una variable con ese nombre).

Menú gráfico: /Ver/Distancias de Mahalanobis

# makepkg Programming

Argumento:  nombrearchivo 
Opciones:   --index (Escribe el archivo índice, auxiliar)
            --translations (Escribe el archivo de cadenas de texto, auxiliar)
            --quiet (Funciona sigilosamente)

Da soporte a la creación de un paquete de funciones de Gretl mediante la
línea de instrucciones. El modo de funcionamiento de esta instrucción
depende de la extensión del nombrearchivo, que debe ser .gfn o .zip.

Modo gfn

Escribe un archivo gfn. Se asume que puede accederse a un archivo de
especificación de un paquete, que tiene el mismo nombre base que
nombrearchivo pero con la extensión .spec, junto con cualquier archivo
auxiliar al que haga referencia. También se asume que todas las funciones a
empaquetar se leyeron en la memoria.

Modo zip

Escribe un archivo comprimido zip de un paquete (un gfn más otros
elementos). En caso de encontrarse un archivo gfn con el mismo nombre base
que nombrearchivo, Gretl comprueba los archivos correspondientes inp y spec,
y si los encuentra a ambos, siendo por lo menos uno de ellos más nuevo que
el archivo gfn, entonces se vuelve a generar el gfn; en otro caso, se
utiliza el gfn existente. Cuando no se encuentra ese archivo, Gretl intenta
primero generar el gfn.

Opciones de gfn

Los indicadores de opciones admiten la escritura de archivos auxiliares,
pensados para utilizar con los "añadidos" de Gretl. El archivo índice es
un corto documento XML que contiene información básica sobre el paquete, y
que tiene su mismo nombre como base además de la extensión .xml. El
archivo de traducciones contiene las cadenas de texto del paquete (en
formato C) que podrían ser apropiadas para la traducción; para un paquete
foo este archivo se llama foo-i18n.c. Estos archivos no se generan si la
instrucción opera en modo zip, y se utiliza un archivo gfn que ya existía.

Para obtener más detalles sobre todo esto, consulta la Guía para paquetes
de funciones.

Menú gráfico: /Archivo/Paquetes de funciones/Paquete nuevo

# markers Dataset

Variantes:  markers --to-file=nombrearchivo
            markers --to-array=nombre
            markers --from-file=nombrearchivo
            markers --delete

Las opciones --to-file y --to-array proporcionan formas de guardar las
cadenas de texto que son marcadores de observaciones del conjunto vigente de
datos, en el archivo o 'array' que indiques. Si no hay ninguna de esas
cadenas, se muestra un fallo. En el caso del archivo, las cadenas se
escriben una por línea en ese archivo, y este se guarda en el directorio
("workdir") establecido en ese momento, excepto que la cadena nombrearchivo
contenga una especificación completa de la ruta. En el caso del 'array', si
nombre es el identificador de un 'array' de cadenas de texto ya existente,
ese 'array' se va a sobrescribir; en caso contrario, se crea uno nuevo.

Con la opción --from-file, se lee el archivo especificado (que debe ser de
texto plano) y se asignan las etiquetas de observación contenidas en este,
uno por cada línea, a las filas del conjunto de datos. En general, debería
haber como mínimo tantas etiquetas en el archivo como observaciones en el
conjunto de datos; pero si el conjunto de datos es de tipo panel, también
se acepta que el número de etiquetas en el archivo coincida con el número
de unidades de sección cruzada (en cuyo caso las etiquetas se repiten para
cada período de tiempo.)

La opción --delete hace lo que ya esperarías, es decir, eliminar las
cadenas de texto que etiquetan cada observación del conjunto de datos.

Menú gráfico: /Datos/Etiquetas de las observaciones

# meantest Tests

Argumentos: serie1 serie2 
Opción:     --unequal-vars (Asume que las varianzas no son iguales)

Calcula el estadístico t para contrastar la hipótesis nula de que las
medias en la población son iguales para las variables serie1 y serie2, y
muestra su probabilidad asociada (valor p).

Por defecto, el estadístico de contraste se calcula bajo el supuesto de que
las varianzas son iguales para las dos variables. Con la opción
--unequal-vars se asume que las varianzas son diferentes; y en este caso,
los grados de libertad del estadístico de contraste se aproximan conforme a
Satterthwaite (1946).

Menú gráfico: /Herramientas/Calculadora de estadísticos de contraste

# midasreg Estimation

Argumentos: depvar indepvars ; términosMIDAS 
Opciones:   --vcv (Presenta la matriz de covarianzas)
            --robust (Desviaciones típicas robustas)
            --quiet (No presenta los resultados)
            --levenberg (Mira abajo)
Ejemplos:   midasreg y 0 y(-1) ; mds(X, 1, 9, 1, theta)
            midasreg y 0 y(-1) ; mds(X, 1, 9, 0)
            midasreg y 0 y(-1) ; mdsl(XL, 2, theta)
            Ver también gdp_midas.inp

Lleva a cabo la estimación por mínimos cuadrados (bien MCNL o bien MCO,
dependiendo de la especificación) de un modelo MIDAS (Mixed Data Sampling).
Este tipo de modelos incluye una o más variables independientes que se
observan con una frecuencia mayor que a variable dependiente; para una buena
y breve introducción consulta Armesto, Engemann y Owyang (2010).

Las variables de indepvars deben tener la misma frecuencia que la variable
dependiente. Esta lista normalmente debe incluir const o 0 (ordenada en el
origen), y habitualmente incluye uno o más retardos de la variable
dependiente. Los términos de alta frecuencia se indican después de un
punto y coma; cada uno tiene el formato de unos cuantos argumentos entre
paréntesis, separados por comas, precedidos por mds o por mdsl.

mds: Esta variante generalmente requiere 5 argumentos, del modo siguiente:
el nombre de una "MIDAS list", dos enteros que indican los retardos mínimo
y máximo de alta frecuencia, un entero entre 0 y 4 (o una cadena de texto,
mira abajo) que especifica el tipo de disposición de los parámetros que se
va a usar, y el nombre de un vector que contiene los valores iniciales de
los parámetros. El ejemplo de abajo solicita los retardos del 3 al 11 de
las series de alta frecuencia representadas en la lista X, utilizando para
ello una disposición de los parámetros de tipo 1 (Almon exponencial, mira
abajo) con el vector de inicio theta.

	mds(X, 3, 11, 1, theta)

mdsl: Generalmente requiere 3 argumentos: el nombre de una lista de retardos
MIDAS, un número entero (o una cadena de texto, mira abajo) para
especificar el tipo de disposición de los parámetros y el nombre de un
vector de inicio. En este caso, los retardos máximo y mínimo están
implícitos en el argumento inicial de la lista. En el ejemplo de abajo
Xlags debe ser una lista que ya contenga todos los retardos que se
necesiten; puedes construir una lista de ese tipo utilizando la función
"hflags".

	mdsl(XLags, 1, theta)

Los tipos de disposición de parámetros que se admiten, se muestran abajo.
En el contexto de las especificaciones mds y mdsl, puedes indicarlos en
forma de los códigos numéricos, o de las cadenas de texto entre comillas
que se muestran después de los números:

0 o "umidas": MIDAS sin restricciones o U-MIDAS, en el que cada retardo
tiene su propio coeficiente.

1 o "nealmon": Almon exponencial normalizada, que requiere por lo menos un
parámetro y habitualmente utiliza dos.

2 o "beta0": Beta normalizada con un último retardo nulo, que requiere
exactamente dos parámetros.

3 o "betan": Beta normalizada con un último retardo no nulo, que requiere
exactamente tres parámetros.

4 o "almonp": Polinomio de Almon (no normalizada), que requiere por lo menos
un parámetro.

Cuando la disposición de parámetros es U-MIDAS, no es necesario el vector
de inicio del último argumento. En otros casos, puedes solicitar un inicio
automático substituyendo el nombre del vector de parámetros inicial por
alguna de estas dos formas:

  La palabra clave null: esto solo es admisible cuando la disposición de
  los parámetros tiene un número fijo de términos (los casos Beta, con 2
  o 3 parámetros). También se acepta en el caso del Almon exponencial, lo
  que implica que ese es el valor por defecto de los dos parámetros.

  Un valor entero que indica el número requerido de parámetros.

El método de estimación que utiliza esta instrucción depende de la
especificación de los elementos de alta frecuencia. En el caso de U-MIDAS,
el método es MCO (OLS); de lo contario, es mínimos cuadrados no lineales
(MCNL o NLS). Cuando especificas las disposiciones de parámetros Almon
exponencial normalizada o Beta normalizada, el método MCNL por defecto es
una combinación de BFGS restringido y MCO, pero puedes indicar la opción
--levenberg para forzar que se utilice el algoritmo de Levenberg-Marquardt.

Menú gráfico: /Modelo/Series temporales univariantes/MIDAS

# mle Estimation

Argumentos: función logaritmo-verosimilitud [ derivadas ] 
Opciones:   --quiet (No muestra el modelo estimado)
            --vcv (Presenta la matriz de covarianzas)
            --hessian (Basa la matriz de covarianzas en la Hessiana)
            --robust (Matriz de covarianzas CMV (QML))
            --cluster=clustvar (Matriz de covarianzas robusta por agrupación)
            --verbose (Presenta los detalles de las iteraciones)
            --no-gradient-check (Mira abajo)
            --auxiliary (Mira abajo)
            --lbfgs (Utiliza L-BFGS-B en vez del BFGS habitual)
Ejemplos:   weibull.inp, biprobit_via_ghk.inp, frontier.inp, keane.inp

Realiza la estimación de Máxima Verosimilitud (MV o ML) utilizando bien el
algoritmo BFGS (Broyden, Fletcher, Goldfarb, Shanno) o bien el método de
Newton. Debes especificar la función logaritmo de verosimilitud. Y debes
expresar los parámetros de esta función, y asignarles valores iniciales
antes de la estimación. Opcionalmente, el usuario puede especificar las
derivadas de la función logaritmo de verosimilitud con respecto a cada uno
de los parámetros; si no indicas las derivadas analíticas, se calcula una
aproximación numérica.

Este texto de ayuda asume que se utiliza, por defecto, el maximizador BFGS.
Para obtener más información sobre el uso del método de Newton, por favor
consulta El manual de gretl (Capítulo 24).

Ejemplo sencillo: Supón que tenemos una serie X con valores 0 o 1, y
queremos obtener la estimación máximo verosímil de la probabilidad (p) de
que X = 1. (En este caso sencillo, se puede adelantar que la estimación MV
de p será simplemente equivalente a la proporción de Xs iguales a 1, en la
muestra.)

Primero se debe añadir el parámetro p al conjunto de datos, e indicar su
valor inicial. Por ejemplo, scalar p = 0.5.

A continuación, se configura el bloque de instrucciones de estimación EMV:

	mle loglik = X*log(p) + (1-X)*log(1-p)
	  deriv p = X/p - (1-X)/(1-p)
	end mle

La primera línea de arriba especifica la función logaritmo de
verosimilitud. Comienza con la palabra clave mle, después se especifica la
variable dependiente y se indica una expresión para el logaritmo de la
verosimilitud (usando la misma sintaxis que en la instrucción "genr"). La
siguiente línea (que es opcional) comienza con la palabra clave deriv y
proporciona la derivada de la función logaritmo de verosimilitud con
respecto al parámetro p. Si no indicas las derivadas, debes incluir una
orden utilizando la palabra clave params que identifique los parámetros
libres: estos se enumeran en una línea, separados por espacios y pueden ser
bien escalares, bien vectores, o bien cualquier combinación de los dos. Por
ejemplo, puedes cambiar lo de arriba por:

	mle loglik = X*log(p) + (1-X)*log(1-p)
	  params p
	end mle

en cuyo caso se utilizarían derivadas numéricas.

Ten en cuenta que cualquier indicador de opción debe añadirse a la línea
final del bloque EMV (MLE).

Matriz de covarianzas y desviaciones típicas

Cuando la función del logaritmo de la verosimilitud devuelve una serie o un
vector que proporciona valores por observación, entonces las desviaciones
típicas estimadas se basan por defecto en el Producto Externo del vector
Gradiente (PEG); mientras que si indicas la opción --hessian, por el
contario se basan en la inversa negativa de la matriz Hessiana, que se
aproxima numéricamente. Cuando indicas la opción --robust, se utiliza un
estimador CMV (QML, un "emparedado" entre la inversa negativa de la matriz
Hessiana y el PEG). Ahora bien, cuando la función del logaritmo de la
verosimilitud únicamente devuelve un valor escalar, el PEG no está
disponible (por lo tanto tampoco el estimador CMV), y las desviaciones
típicas tienen que calcularse necesariamente utilizando la matriz Hessiana
numérica.

En caso de que únicamente quieras las estimaciones del parámetro primario,
puedes indicar la opción --auxiliary, que elimina el cálculo de la matriz
de covarianzas y de las desviaciones típicas. Esto va a ahorrar algunos
ciclos de CPU y uso de memoria.

Comprobando las derivadas analíticas

Si proporcionas las derivadas analíticas, por defecto Gretl ejecuta una
verificación numérica de su credibilidad. Algunas veces esto puede
producir falsos positivos, por situaciones en las que las derivadas
correctas parecen ser incorrectas y la estimación se rechaza. Para tener
esto en cuenta o para conseguir un poco de velocidad adicional, puedes
indicar la opción --no-gradient-check. Obviamente, debes hacer esto solo
cuando tengas certeza de que el vector gradiente que has especificado es
correcto.

Nombres de parámetros

Al estimar un modelo no lineal, con frecuencia es conveniente nombrar los
parámetros de forma sucinta. Ahora bien, al presentar los resultados, puede
que desees utilizar etiquetas más informativas. Esto lo puedes conseguir
mediante la palabra clave adicional param_names dentro del bloque de
instrucciones. Para un modelo con k parámetros, el argumento que sigue a
esta palabra clave debe ser bien una cadena de texto literal puesta entre
comillas, que contenga k nombres separados por espacios, o bien el nombre de
una variable de cadena que contenga k de esos nombres.

Para una descripción más en profundidad de la estimación "mle" consulta
El manual de gretl (Capítulo 24).

Menú gráfico: /Modelo/Máxima Verosimilitud

# modeltab Utilities

Variantes:  modeltab add
            modeltab show
            modeltab free
            modeltab --output=nombrearchivo

Permite manejar la "Tabla de modelos" de Gretl; consulta El manual de gretl
(Capítulo 3) para obtener más detalles. Las instrucciones subordinadas
tienen los siguientes efectos: "add" añade el último modelo estimado a la
tabla de modelos, cuando sea posible; "show" muestra la tabla de modelos en
una ventana; y "free" vacía la tabla.

Para solicitar que se guarde la tabla de modelos, usa la opción --output=
más un nombre de archivo. Cuando el nombre del archivo tenga el sufijo
".tex", el resultado va a estar en formato TeX; cuando el sufijo sea ".rtf",
el resultado tendrá formato RTF; y en otro caso, va a estar en texto plano.
En caso de un resultado TeX, por defecto se genera un "trozo" adecuado para
incluir en un documento; en cambio, si quieres un documento independiente,
usa la opción --complete, como por ejemplo

	modeltab --output="myfile.tex" --complete

Menú gráfico: Ventana de iconos de sesión: icono de Tabla de modelos

# modprint Printing

Argumentos: matrizcoef nombres [ estadicionales ] 
Opción:     --output=nombrearchivo (Envía el resultado al archivo especificado)

Presenta la tabla de coeficientes y estadísticos adicionales opcionales
para un modelo estimado "a mano"; es útil sobre todo para funciones
escritas por el usuario.

El argumento matrizcoef debe ser una matriz de dimensión k por 2, que
contiene k coeficientes y k desviaciones típicas asociadas. El argumento
nombres debe proporcionar por lo menos k nombres para etiquetar los
coeficientes. Puedes indicarlo con el formato: (a) de una cadena de texto
literal (puesta entre comillas) o de una variable de cadena, que contenga
los nombres separados por comas o espacios, o (b) un array ya definido de
cadenas de texto.

El argumento estadicionales (opcional) es un vector que contiene p
estadísticos adicionales que se muestran debajo de la tabla de
coeficientes. Si indicas este argumento, entonces nombres debe contener k +
p nombres, de forma que los p nombres agregados se asocien a los
estadísticos adicionales.

Para colocar el resultado en un archivo, utiliza la opción --output= más
un nombre de archivo. Cuando el nombre de archivo tenga el sufijo ".tex", el
resultado va a estar en formato TeX; cuando el sufijo sea ".rtf", el
resultado tendrá formato RTF; y en otro caso, va a estar en texto plano. En
caso de un resultado TeX, por defecto se genera un "trozo" adecuado para
incluir en un documento; en cambio, si quieres un documento independiente,
usa la opción --complete.

El archivo resultante se escribe en el directorio ("workdir") establecido en
ese momento, excepto que la cadena nombrearchivo contenga una
especificación completa de la ruta.

# modtest Tests

Argumento:  [ orden ] 
Opciones:   --normality (Normalidad de las perturbaciones)
            --logs (No linealidad: logaritmos)
            --squares (No linealidad: cuadrados)
            --autocorr (Autocorrelación)
            --arch (ARCH)
            --white (Heterocedasticidad: contraste de White)
            --white-nocross (Contraste de White: solo cuadrados)
            --breusch-pagan (Heterocedasticidad: contraste de Breusch-Pagan)
            --robust (Estimación con varianzas robustas para Breusch-Pagan)
            --panel (Heterocedasticidad: por grupos)
            --comfac (Restricción de factor común: solo modelos AR1)
            --xdepend (Dependencia de sección cruzada: solo con datos de panel)
            --quiet (No presenta los detalles)
            --silent (No presenta nada)
Ejemplos:   credscore.inp

Debe seguir inmediatamente a una instrucción de estimación. La discusión
de abajo se aplica a la utilización de esta instrucción a continuación de
la estimación de un modelo de una única ecuación; consulta El manual de
gretl (Capítulo 30) para una exposición de como opera "modtest" después
de la estimación de un VAR.

Dependiendo de la opción que indiques, esta instrucción efectúa una de
estas acciones: el contraste de Normalidad de la perturbación de
Doornik-Hansen; un contraste de No Linealidad (logaritmos o cuadrados) con
Multiplicadores de Lagrange; el contraste de Heterocedasticidad de White
(con o sin productos cruzados) o el de Breusch-Pagan (Breusch y Pagan,
1979); el contraste LMF de Autocorrelación (Kiviet, 1986); un contraste de
ARCH (Heterocedasticidad Condicional Autorregresiva; consulta también la
instrucción "arch"); un contraste de la restricción de Factor Común
implícita en la estimación AR(1); o un contraste de Dependencia de
sección cruzada en modelos con datos de panel. Con la excepción de los
contrastes de Normalidad, de Factor Común y de Dependencia de sección
cruzada, la mayor parte de las opciones de estos contrastes solo están
disponibles para modelos estimados mediante MCO, pero mira más abajo para
obtener más detalles en relación con Mínimos Cuadrados en 2 Etapas.

El argumento orden (opcional) es importante solo en caso de que escojas las
opciones --autocorr o --arch. Por defecto, estos contrastes se ejecutan
utilizando un orden de retardos igual a la periodicidad de los datos, pero
puedes ajustar esto indicando un orden de retardos específico.

La opción --robust se aplica únicamente cuando seleccionas el contraste de
Breusch-Pagan; su efecto consiste en que se utiliza el estimador robusto de
la varianza propuesto por Koenker (1981), haciendo el contraste menos
sensible al supuesto de Normalidad.

La opción --panel está disponible solo cuando el modelo se estima con
datos de panel; y en este caso, se realiza un contraste de
heterocedasticidad por grupos (es decir, de varianzas de las perturbaciones
diferentes entre las unidades de sección cruzada).

La opción --comfac está disponible solo cuando el modelo se estima
mediante un método AR(1) tal como el de Hildreth-Lu. La regresión auxiliar
toma la forma de un modelo dinámico relativamente no restringido, que se
utiliza para contrastar la restricción de factor común implícita en la
especificación AR(1).

La opción --xdepend está disponible solo para modelos estimados con datos
de panel. El estadístico de contraste es el desarrollado por Pesaran
(2004). La hipótesis nula es que la perturbación se distribuye
independientemente entre las unidades atemporales o los individuos.

Por defecto, el programa presenta la regresión auxiliar en la que se basa
el estadístico de contraste, si es aplicable. Puedes eliminar esto
utilizando la opción --quiet (presentación mínima de resultados) o la
opción --silent (no presenta ningún resultado). Puedes recuperar el
estadístico de contraste y su probabilidad asociada (valor p) utilizando
los accesorios "$test" y "$pvalue", respectivamente.

Cuando un modelo se estima por Mínimos Cuadrados en 2 Etapas (consulta
"tsls"), se rompe el principio de Máxima Verosimilitud y Gretl ofrece
algunos equivalentes: la opción --autocorr calcula el estadístico de
Godfrey para contrastar autocorrelación (Godfrey, 1994) mientras que la
opción --white produce el estadístico del contraste HET1 de
heterocedasticidad (Pesaran y Taylor, 1999).

Para contrastes adicionales de diagnóstico sobre los modelos, consulta
"chow", "cusum", "reset" y "qlrtest".

Menú gráfico: Ventana de modelo: Contrastes

# mpols Estimation

Argumentos: depvar indepvars 
Opciones:   --vcv (Presenta la matriz de covarianzas)
            --simple-print (No presenta los estadísticos auxiliares)
            --quiet (No presenta los resultados)

Calcula las estimaciones de MCO para el modelo especificado, utilizando
aritmética de punto flotante con precisión múltiple, con la ayuda de la
biblioteca Gnu Multiple Precision (GMP). Por defecto, se utilizan 256 bits
de precisión en los cálculos, pero puedes aumentar esto mediante la
variable de entorno GRETL_MP_BITS. Por ejemplo, cuando utilizas el
intérprete Bash se te podría ocurrir la siguiente instrucción para
establecer una precisión de 1024 bits antes de comenzar Gretl.

	export GRETL_MP_BITS=1024

Dispones de una opción (más bien rebuscada) para esta instrucción,
principalmente con el propósito de hacer pruebas: cuando la lista indepvars
va seguida de un punto y coma, más de una lista posterior de números, esos
números se toman como potencias de x que se añaden a la regresión, donde
x es la última variable de indepvars. Estos términos adicionales se
calculan y se guardan con precisión múltiple. En el siguiente ejemplo, se
hace la regresión de y sobre x más la segunda, tercera y cuarta potencias
de ese x:

	mpols y 0 x ; 2 3 4

Menú gráfico: /Modelo/Otros modelos lineales/MCO de alta precisión

# negbin Estimation

Argumentos: depvar indepvars [ ; exposición ] 
Opciones:   --model1 (Utiliza el modelo NegBin 1)
            --robust (Matriz de covarianzas CMV (QML))
            --cluster=clustvar (Consulta "logit" para una explicación)
            --opg (Mira abajo)
            --vcv (Presenta la matriz de covarianzas)
            --verbose (Presenta los detalles de las iteraciones)
            --quiet (No presenta los resultados)
Ejemplos:   camtriv.inp

Estima un modelo Binomial Negativo. Se toma la variable dependiente para
representar un recuento del número de veces que ocurre un suceso de algún
tipo, y debe tener solo valores enteros no negativos. Por defecto, se
utiliza el modelo NegBin 2 en el que la varianza condicionada del recuento
viene determinada por mu(1 + αmu), donde mu denota la media condicionada.
Pero si indicas la opción --model1, la varianza condicionada es mu(1 + α).

La serie de exposición (offset, opcional) funciona del mismo modo que para
la instrucción "poisson". El modelo de Poisson es una forma restringida de
la Binomial Negativa en la que α = 0 por construcción.

Por defecto, las desviaciones típicas se calculan utilizando una
aproximación numérica a la matriz Hessiana en la convergencia. Pero si
indicas la opción --opg, la matriz de covarianzas se basa en el Producto
Externo del vector Gradiente, PEG (OPG), y si indicas la opción --robust,
se calculan las desviaciones típicas CMV (QML), utilizando un "emparedado"
entre la inversa de la matriz Hessiana y el PEG.

Menú gráfico: /Modelo/Variable dependiente limitada/Datos de conteo

# nls Estimation

Argumentos: función [ derivadas ] 
Opciones:   --quiet (No presenta el modelo estimado)
            --robust (Desviaciones típicas robustas)
            --vcv (Presenta la matriz de covarianzas)
            --verbose (Presenta los detalles de las iteraciones)
            --no-gradient-check (Mira abajo)
Ejemplos:   wg_nls.inp, ects_nls.inp

Realiza la estimación de Mínimos Cuadrados No Lineales (MCNL o NLS)
utilizando una versión modificada del algoritmo de Levenberg-Marquardt.
Debes indicar la especificación de una función y de enunciar los
parámetros de esta, además de darles unos valores iniciales antes de la
estimación. Como opción, puedes especificar las derivadas de la función
de regresión con respecto a cada uno de los parámetros. Si no proporcionas
as derivadas, en su lugar debes indicar una lista de los parámetros que se
van a estimar (separados por espacios o comas), precedida por la palabra
clave params. En este último caso, se calcula una aproximación numérica
al Jacobiano.

Resulta más fácil mostrar lo que se requiere mediante un ejemplo. Lo que
sigue es un guion completo para estimar la función no lineal de consumo
establecida en el libro Econometric Analysis (capítulo 11 de la 4a edición
o capítulo 9 de la 5a) de William Greene. Los números a la izquierda de
las líneas son solo para tomar como referencia y no son parte de las
instrucciones. Ten en cuenta que cualquier indicador de opción, como sería
--vcv para presentar la matriz de covarianzas de los estimadores de los
parámetros, deberías de añadirlo a la instrucción final, end nls.

	1   open greene11_3.gdt
	2   ols C 0 Y
	3   scalar alfa = $coeff(0)
	4   scalar beta = $coeff(Y)
	5   scalar gamma = 1.0
	6   nls C = alfa + beta * Y^gamma
	7    deriv alfa = 1
	8    deriv beta = Y^gamma
	9    deriv gamma = beta * Y^gamma * log(Y)
	10  end nls --vcv

Con frecuencia es conveniente iniciar los parámetros con una referencia a
un modelo lineal relacionado; esto se logra aquí con las líneas de la 2 a
la 5. Los parámetros alfa, beta y gamma pueden establecerse con cualquier
valor inicial (no necesariamente basados en un modelo estimado con MCO),
aunque la convergencia del procedimiento de MCNL no está garantizada para
cualquier punto de inicio que se te antoje.

Las auténticas instrucciones de MCNL ocupan las líneas de la 6 hasta la
10. En la línea 6 se indica la instrucción "nls" en la que se declara la
variable dependiente, con un signo de igualdad a continuación, y seguido
este de la especificación de una función. La sintaxis para el lado derecho
de la expresión es la misma que la de la instrucción "genr". Las
siguientes 3 líneas especifican las derivadas de la función de regresión
con respecto a cada uno de los parámetros, de uno en uno. Cada línea
comienza con la palabra clave "deriv", establece el nombre de un parámetro,
un signo de igualdad y una expresión por la que puede calcularse la
derivada. En lugar de proporcionar las derivadas analíticas, como
alternativa puedes substituir las líneas de la 7 a la 9, por lo siguiente:

	params alfa beta gamma

La línea 10, "end nls", completa la instrucción y solicita la estimación.
Cualquier opción deberás de añadirla a esta línea.

Si proporcionas las derivadas analíticas, por defecto Gretl ejecuta una
verificación numérica de su credibilidad. Algunas veces esto puede
producir falsos positivos, por situaciones en las que las derivadas
correctas parecen ser incorrectas y la estimación se rechaza. Para tener
esto en cuenta o para conseguir un poco de velocidad adicional, puedes
indicar la opción --no-gradient-check. Obviamente, debes hacer esto solo
cuando tengas certeza de que el vector gradiente que has especificado es
correcto.

Nombres de parámetros

Al estimar un modelo no lineal, con frecuencia es conveniente nombrar los
parámetros de forma sucinta. Ahora bien, al presentar los resultados, puede
que desees utilizar etiquetas más informativas. Esto lo puedes lograr
mediante la palabra clave adicional param_names dentro del bloque de
instrucciones. Para un modelo con k parámetros, el argumento que sigue a
esta palabra clave debe ser, bien una cadena de texto literal puesta entre
comillas que contenga k nombres separados por espacios, o bien el nombre de
una variable de cadena que contenga k de esos nombres.

Para obtener otros detalles sobre la estimación MCNL (NLS), consulta El
manual de gretl (Capítulo 23).

Menú gráfico: /Modelo/Mínimos cuadrados no lineales

# normtest Tests

Argumento:  serie 
Opciones:   --dhansen (Contraste de Doornik-Hansen, por defecto)
            --swilk (Contraste de Shapiro-Wilk)
            --lillie (Contraste de Lilliefors)
            --jbera (Contraste de Jarque-Bera)
            --all (Hace todos los contrastes)
            --quiet (No presenta los resultados)

Realiza un contraste de Normalidad para la serie indicada. El tipo concreto
de contraste se controla con el indicador de opción (y se ejecuta el
contraste de Doornik-Hansen cuando no indicas ninguna opción). Advertencia:
Los contrastes de Doornik-Hansen y Shapiro-Wilk son más recomendables que
los otros, teniendo en cuenta sus mejores propiedades en muestras pequeñas.

Mediante los accesorios "$test" y "$pvalue" puedes recuperar el estadístico
de contraste y su probabilidad asociada (valor p), respectivamente. Ten en
cuenta que cuando indicas la opción --all, el resultado guardado es el del
contraste de Doornik-Hansen.

Menú gráfico: /Variable/Contraste de Normalidad

# nulldata Dataset

Argumento:  longitud 
Opción:     --preserve (Retiene las variables que no son series)
Ejemplo:    nulldata 500

Establece un conjunto de datos "en blanco" que: incluye solo una constante
más una variable índice, tiene periodicidad 1 y contiene el número de
observaciones especificado en el argumento. Puedes utilizar esto con la
intención de hacer simulaciones, pues funciones como "uniform()" y
"normal()" generan series artificiales comenzando por el principio, para
rellenar el conjunto de datos. Esta instrucción puede ser muy útil en
combinación con "loop". Consulta también la opción "seed" (semilla) de la
instrucción "set".

Por defecto, esta instrucción vacía todos los datos del espacio vigente de
trabajo de Gretl, no solo las series sino también las matrices, los
escalares, las cadenas de texto, etc. Ahora bien, cuando indicas la opción
--preserve, se retiene cualquier variable que no sea una serie y esté
definida en ese momento.

Menú gráfico: /Archivo/Nuevo conjunto de datos

# ols Estimation

Argumentos: depvar indepvars 
Opciones:   --vcv (Presenta la matriz de covarianzas)
            --robust (Desviaciones típicas robustas)
            --cluster=clustvar (Desviaciones típicas agrupadas)
            --jackknife (Mira abajo)
            --simple-print (No presenta estadísticos auxiliares)
            --quiet (No presenta los resultados)
            --anova (Presenta una tabla ANOVA)
            --no-df-corr (Elimina la corrección de los grados de libertad)
            --print-final (Mira abajo)
Ejemplos:   ols 1 0 2 4 6 7
            ols y 0 x1 x2 x3 --vcv
            ols y 0 x1 x2 x3 --quiet

Calcula las estimaciones de mínimos cuadrados ordinarios (MCO u OLS) siendo
depvar la variable dependiente, e indepvars una lista de variables
independientes. Puedes especificar las variables con el nombre o con el
número; y utilizar el número cero para indicar el término constante.

Aparte de las estimaciones de los coeficientes y de las desviaciones
típicas, el programa también presenta las probabilidades asociadas
(valores p) a los estadísticos t (con dos colas) y F. Un 'valor p' por
debajo de 0.01 indica significación estadística a un nivel del 1 por
ciento, y se marca con ***. La marca ** indica niveles de significación
entre 1 y 5 por ciento, y la marca * indica niveles entre 5 y 10 por ciento.
También se presentan los estadísticos para elegir modelos (el Criterio de
Información de Akaike o AIC, y el Criterio de Información Bayesiano de
Schwarz). La fórmula utilizada para el AIC es la proporcionada por Akaike
(1974), en concreto, menos dos veces el logaritmo de la verosimilitud
maximizada más dos veces el número de parámetros estimados.

Si indicas la opción --no-df-corr, no se aplica la corrección habitual de
los grados de libertad al calcular la varianza estimada de la perturbación
(y por lo tanto, tampoco las desviaciones típicas de los estimadores de los
parámetros).

La opción --print-final es aplicable solo en el contexto de un bucle
("loop"), y dispone que la regresión se ejecute silenciosamente en todas
las iteraciones del bucle, excepto en la última. Consulta El manual de
gretl (Capítulo 12) para obtener más detalles.

Puedes recuperar varias variables internas después de la estimación. Por
ejemplo:

	series uh = $uhat

guarda los errores de la estimación bajo el nombre uh. Consulta la sección
"Accesorios" de la Guía de funciones de Gretl para obtener más detalles.

Puedes ajustar la fórmula (versión "HC") específica que se va a utilizar
para generar las desviaciones típicas robustas cuando indicas la opción
--robust, mediante la instrucción "set". La opción --jackknife tiene como
consecuencia la selección de una hc_version de 3a. La opción --cluster
anula la selección de la versión HC, y produce las desviaciones típicas
robustas agrupando las observaciones según los distintos valores de
clustvar. Consulta El manual de gretl (Capítulo 20) para obtener más
detalles.

Menú gráfico: /Modelo/Mínimos Cuadrados Ordinarios
Otro acceso:  Botón con el símbolo beta en la barra de herramientas

# omit Tests

Argumento:  listavariables 
Opciones:   --test-only (No substituye el modelo vigente)
            --chi-square (Devuelve la forma Chi-cuadrado del contraste de Wald)
            --quiet (Presenta solo los resultados básicos del contraste)
            --silent (No presenta nada)
            --vcv (Presenta la matriz de covarianzas del modelo reducido)
            --auto[=alfa] (Eliminación secuencial, mira abajo)
Ejemplos:   omit 5 7 9
            omit seasonals --quiet
            omit --auto
            omit --auto=0.05
            Ver también restrict.inp, sw_ch12.inp, sw_ch14.inp

Esta instrucción debe ir después de una instrucción de estimación. En su
forma básica, calcula el estadístico de contraste de Wald para la
significación conjunta de las variables de listavariables, que debe ser un
subconjunto (aunque no necesariamente un subconjunto apropiado) de las
variables independientes del último modelo estimado. Puedes recuperar los
resultados del contraste utilizando los accesores "$test" y "$pvalue".

A no ser que la restricción elimine todos los regresores originales, por
defecto, se estima el modelo restringido y este substituye al original como
"modelo vigente" si tienes intención, por ejemplo, de recuperar los errores
con $uhat o hacer contrastes posteriores. Puedes impedir este comportamiento
mediante la opción --test-only.

Por defecto, se registra la forma F del contraste de Wald; pero puedes
utilizar la opción --chi-square para recoger la forma chi-cuadrado en su
lugar.

Si tanto estimas como representas el modelo restringido, la opción --vcv
tiene el efecto de presentar su matriz de covarianzas; en otro caso, esta
opción se ignora.

Como alternativa, cuando indicas la opción --auto, se lleva a cabo la
eliminación secuencial por pasos. En cada etapa se excluye la variable
ligada a la mayor probabilidad asociada (valor p), hasta que todas las que
queden estén ligadas a valores p que no sean mayores que algún valor de
corte. Por defecto, este es del 10 por ciento (con 2 colas) y puedes
ajustarlo añadiendo "=", y un valor entre 0 y 1 (sin espacios), como en el
cuarto ejemplo de arriba. Si indicas listavariables, este proceso se limita
solo a las variables de la lista; en otro caso, todos los regresores aparte
de la constante se tratan como candidatos a la exclusión. Ten en cuenta que
las opciones --auto y --test-only no puedes combinarlas.

Menú gráfico: Ventana de modelo: Contrastes/Omitir variables

# open Dataset

Argumento:  nombrearchivo 
Opciones:   --quiet (No presenta la lista de las series)
            --preserve (Retiene las variables que no son series)
            --frompkg=nombrepaquete (Mira abajo)
            --all-cols (Mira abajo)
            --www (Utiliza una base de datos del servidor de Gretl)
            Mira abajo para opciones adicionales especiales
Ejemplos:   open data4-1
            open voter.dta
            open fedbog --www

Abre un archivo de datos o una base de datos. Si ya hay abierto un archivo
de datos, este se substituye por lo que se va a abrir. Para añadir datos al
conjunto vigente, consulta "append" y (para tener mayor flexibilidad)
"join".

Si no indicas una ruta completa, el programa busca en algunas rutas
destacadas para tratar de encontrar el archivo, de las que el directorio
vigente ("workdir") es la primera elección. Si no indicas el sufijo en el
nombre de archivo (como en el primer ejemplo de arriba), Gretl asume que es
un archivo de datos propio con sufijo .gdt. Basándose en el nombre del
archivo y varias reglas heurísticas, Gretl tratará de detectar el formato
del archivo de datos (propio, texto plano, CSV, MS Excel, Stata, SPSS,
etc.).

Cuando se utiliza la opción --frompkg, Gretl va a buscar el archivo
especificado de datos en el subdirectorio asociado al paquete de funciones
especificado por nombrepaquete.

Si el argumento nombrearchivo toma la forma de un identificador de recursos
uniforme (URI) que comienza por http:// o por https://, entonces Gretl
tratará de descargar el archivo de datos indicado, antes de abrirlo.

Por defecto, al abrir un nuevo archivo de datos se vacía la sesión vigente
de Gretl, lo que incluye la eliminación de todas las variables definidas,
incluyendo matrices, escalares y cadenas de texto. Si quieres mantener las
variables que tengas definidas en ese momento (que no sean series, pues
estas se eliminan obligatoriamente), utiliza la opción --preserve.

Abriendo una base de datos

También puedes utilizar la instrucción open para abrir una base de datos
(de Gretl, RATS 4.0 o PcGive) para leerla. En ese caso, deberá ir seguida
de la instrucción "data" para extraer series concretas de la base de datos.
Cuando indicas la opción www, el programa va a tratar de acceder a la base
de datos del nombre indicado en el servidor de Gretl (por ejemplo, la base
de datos de los tipos de interés de la Reserva Federal del tercer ejemplo
de arriba).

Archivos de hoja de cálculo

Al abrir un archivo de hoja de cálculo (Gnumeric, Open Document o MS
Excel), puedes facilitar tres parámetros adicionales después del nombre
del archivo. Primero, puedes escoger una hoja de cálculo concreta dentro
del archivo. Esto se hace, bien indicando el número de hoja por medio de la
sintaxis (e.g., --sheet=2), o bien indicando el nombre de la hoja (si lo
sabes) entre comillas, como en --sheet="MacroData" pues, por defecto, se va
a leer la primera hoja de cálculo del archivo. También puedes especificar
un desplazamiento de columna y/o de fila dentro de la hoja de cálculo
mediante, e.g.,

	--coloffset=3 --rowoffset=2

lo que va a provocar que Gretl ignore las 3 primeras columnas y las 2
primeras filas. Por defecto, hay un desplazamiento de 0 en ambas
dimensiones, es decir, se empieza a leer en la celda de arriba a la
izquierda.

Archivos de texto delimitado

Con archivos de texto plano, Gretl habitualmente espera encontrar las
columnas de datos delimitadas de algún modo estándar (en general mediante
coma, tabulador, espacio, o punto y coma). Por defecto, Gretl busca en la
primera columna las etiquetas o las fechas de las observaciones, si su
encabezado está vacío o bien contiene una cadena de texto sugerente tal
como "year", "date" o "obs". Puedes evitar que Gretl trate de forma especial
la primera columna indicando la opción --all-cols.

Texto de formato fijo

Un archivo de datos en texto con "formato fijo" es aquel que no tiene
delimitadores de columna, pero en el que los datos se disponen de acuerdo
con un conjunto conocido de especificaciones como, por ejemplo, "la variable
k ocupa 8 columnas comenzando en la columna 24". Para leer ese tipo de
archivos, debes añadir una cadena de texto con --fixed-cols=colspec, donde
colspec se compone de números enteros separados por comas. Estos enteros se
interpretan como un conjunto de pares. El primer elemento de cada par denota
una columna de inicio, medida en bytes desde el principio de la línea, en
la que el 1 indica el primer byte; y el segundo elemento de cada par indica
cuantos bytes se deben de leer para el campo indicado. Así, por ejemplo, si
indicas

	open fixed.txt --fixed-cols=1,6,20,3

entonces Gretl va a leer 6 bytes comenzando en la columna 1 para la variable
1; y para la variable 2, va a leer 3 bytes comenzando en la columna 20. Las
líneas que están en blanco, o que comienzan con # se ignoran; pero en caso
contrario se aplica el patrón de lectura de columnas, y cuando se encuentra
algo distinto a un valor numérico válido, se muestra un fallo. Cuando se
leen los datos satisfactoriamente, las variables se van a designar como v1,
v2, etc. Está en manos del usuario el facilitar nombres con significado y/o
descripciones, utilizando para ello las instrucciones "rename" y/o
"setinfo".

Por defecto, cuando importas un archivo que contiene series con valores en
formato de cadena de texto, se abre una caja de texto mostrándote el
contenido del archivo string_table.txt, que consiste en la correspondencia
entre las cadenas y su codificación numérica. Puedes eliminar este
proceder mediante la opción--quiet.

Menú gráfico: /Archivo/Abrir archivo de datos
Otro acceso:  Arrastrar un archivo de datos hasta la ventana principal de Gretl

# orthdev Transformations

Argumento:  listavariables 

Aplicable solo con datos de panel. Se obtiene una serie con desviaciones
ortogonales adelantadas para cada variable de listavariables y se guarda en
una nueva variable con el prefijoo_. De este modo "orthdev x y" genera las
nuevas variables o_x y o_y.

Los valores se guardan un paso por delante de su localización temporal
verdadera (es decir, o_x en la observación t va a contener la desviación
que pertenece a t - 1, hablando estrictamente). Esto es por compatibilidad
con las primeras diferencias pues así se va a perder la primera
observación de cada serie temporal, no la última.

# outfile Printing

Variantes:  outfile archivo
            outfile --buffer=strvar
            outfile --tempfile=strvar
Opciones:   --append (Añadir a un archivo, solo la primera variante)
            --quiet (Mira abajo)
            --buffer (Mira abajo)
            --tempfile (Mira abajo)

La instrucción outfile inicia un bloque con el que se desvía todo
resultado a presentar, hacia un archivo o buffer (o, si lo deseas,
simplemente se descarta). Dicho bloque se termina con la instrucción "end
outfile", y después de ella los resultados vuelven al cauce por defecto.

Desvío a un archivo señalado

La primera variante que se muestra abajo envía los resultados al archivo
señalado por el argumento archivo. Por defecto, se crea un nuevo archivo (o
se sobrescribe uno ya existente). El archivo resultante se guarda en la
carpeta "workdir" de la configuración, vigente excepto que la cadena de
texto archivo contenga una especificación completa de la ruta. Pero, si
quieres añadir resultados a un archivo ya existente, utiliza la opción
--append.

Dispones de algunas variantes especiales de este tema. Cuando indicas la
palabra clave null en lugar de un nombre real de archivo, la consecuencia es
que se eliminan todos los resultados presentados hasta que la redirección
acabe. Si indicas alguna de las palabras clave stdout o stderr en lugar de
un nombre típico de archivo, su efecto consiste en volver a dirigir el
resultado a un resultado estándar o a un resultado de error estándar,
respectivamente.

En el sencillo ejemplo que sigue, los resultados de una determinada
regresión se escriben en el archivo señalado.

	open data4-10
	outfile regress.txt
	  ols ENROLL 0 CATHOL INCOME COLLEGE
	end outfile

Desvío a un buffer de cadena

La opción --buffer se utiliza para guardar resultados en una variable de
cadena. El parámetro que se necesita para esta opción debe ser el nombre
de una variable de cadena ya existente, cuyo contenido se sobrescribirá.
Abajo se muestra el mismo ejemplo indicado anteriormente, modificado para
guardar una cadena. En este caso, al representar el contenido de model_out
se mostrarán los resultados redirigidos.

	open data4-10
	string model_out = ""
	outfile --buffer=model_out
	  ols ENROLL 0 CATHOL INCOME COLLEGE
	end outfile
	print model_out

Desvío a un archivo temporal

La opción --tempfile se utiliza para dirigir los resultados hacia un
archivo temporal, con un nombre generado automáticamente que se garantiza
que es único, en el directorio "punto" del usuario. Igual que en el caso
del desvío a un buffer, el parámetro de opción debe ser el nombre de una
variable de cadena: en este caso, su contenido se sobrescribe con el nombre
del archivo temporal. Atención: los archivos que se guardan en el
directorio 'punto', se van a depurar al salir del programa, por lo que no
uses esta modalidad si deseas que los resultados se conserven después de tu
sesión de Gretl.

Repetimos el sencillo ejemplo de arriba, con un par de líneas extra para
ilustrar la cuestión de que strvar te indica a donde van los resultados, y
que puedes recuperarlos utilizando la función "readfile".

	open data4-10
	string mytemp
	outfile --tempfile=mytemp
	  ols ENROLL 0 CATHOL INCOME COLLEGE
	end outfile
	printf "Los resultados se han dirigido a %s\n", mytemp
	printf "Los resultados fueron:\n%s\n", readfile(mytemp)

Discreción

Los efectos de la opción --quiet son: se desactiva que se vuelvan a
presentar las órdenes de instrucción, y se muestran los mensajes
auxiliares mientras los resultados estén redirigidos. Es equivalente a
hacer

	set echo off
	set messages off

excepto que, cuando finaliza la redirección, se restablecen los valores
originales de las variables echo y messages. Esta opción está disponible
en todo caso.

Niveles de redirección

En general, solo puedes abrir un archivo de este modo en un momento dado,
por lo que las llamadas a esta instrucción no pueden anidarse. Sin embargo,
la utilización de esta instrucción se permite dentro de funciones
definidas por el usuario (siempre que el archivo de resultados se cierre
desde dentro de la misma función) de forma que puedes desviar esos
resultados temporalmente, y después devolverlos a un archivo de resultados
original en caso de que outfile esté en uso en ese momento por el
solicitante. Por ejemplo, el código

	function void f (string s)
	    outfile interno.txt
	      print s
	    end outfile
	end function

	outfile externo.txt --quiet
	  print "Fuera"
	  f("Dentro")
	  print "De nuevo fuera"
	end outfile

producirá un archivo llamado "externo.txt" que contiene las dos líneas

	Fuera
	De nuevo fuera

y un archivo llamado "interno.txt" que contiene la línea

	Dentro

# panel Estimation

Argumentos: depvar indepvars 
Opciones:   --vcv (Presenta la matriz de covarianzas)
            --fixed-effects (Estima con efectos fijos por grupo)
            --random-effects (Modelo de efectos aleatorios o MCG (GLS))
            --nerlove (Utiliza la transformación de Nerlove)
            --pooled (Estima mediante MCO combinados)
            --between (Estima el modelo entre-grupos)
            --robust (Desviaciones típicas robustas; mira abajo)
            --time-dummies (Incluye variables ficticias temporales)
            --unit-weights (Mínimos Cuadrados Ponderados)
            --iterate (Estimación iterativa)
            --matrix-diff (Calcula el contraste de Hausman mediante la matriz-diferencia)
            --unbalanced=método (Solo efectos aleatorios; mira abajo)
            --quiet (Resultados menos detallados)
            --verbose (Resultados más detallados)
Ejemplos:   penngrow.inp

Estima un modelo de panel. Por defecto, se utiliza el estimador de efectos
fijos; esto se pone en práctica restándoles las medias de grupo o unidad,
a los datos originales.

Cuando indicas la opción --random-effects, se calculan las estimaciones de
efectos aleatorios, utilizando por defecto el método de Swamy y Arora
(1972). Únicamente en este caso, la opción --matrix-diff fuerza el uso del
método de la matriz-diferencia (en contraposición al método de
regresión) para llevar a cabo el contraste de Hausman sobre la consistencia
del estimador de efectos aleatorios. También es específica del estimador
de efectos aleatorios, la opción --nerlove que escoge el método de Nerlove
(1971) en contraposición al de Swamy y Arora.

Como alternativa, cuando indicas la opción --unit-weights, el modelo se
estima mediante mínimos cuadrados ponderados, con las ponderaciones basadas
en la varianza residual para las unidades respectivas de sección cruzada de
la muestra. Únicamente en este caso, puedes añadir la opción --iterate
para generar estimaciones iterativas y, si la iteración converge, las
estimaciones resultantes son Máximo Verosímiles.

Como alternativa posterior, si indicas la opción --between, se estima el
modelo entre-grupos (es decir, se hace una regresión MCO utilizando las
medias de los grupos).

El procedimiento por defecto para calcular desviaciones típicas robustas en
modelos con datos de panel, es el estimador HAC de Arellano, pero puedes
escoger las "Desviaciones Típicas Corregidas de Panel" de Beck-Katz
mediante la instrucción set pcse on. Cuando especificas la opción robusta,
se ejecuta el contraste conjunto F sobre los efectos fijos utilizando el
método robusto de Welch (1951).

La opción --unbalanced está disponible solo para modelos con efectos
aleatorios, y puedes usarla para elegir el método ANOVA que emplear con un
panel desequilibrado. Por defecto, Gretl emplea el método de Swamy-Arora
igual que se hace para los paneles equilibrados, excepto que utiliza la
media armónica de las longitudes de las series de tiempo individuales en
lugar de la T habitual. Bajo esta opción puedes especificar, bien bc para
usar el método de Baltagi y Chang (1994), o bien usar stata para emular la
opción sa de la instrucción xtreg de Stata.

Para obtener más detalles sobre la estimación de un panel, consulta El
manual de gretl (Capítulo 21).

Menú gráfico: /Modelo/Panel

# panplot Graphs

Argumento:  vardibujar 
Opciones:   --means (Serie temporal con medias de grupo)
            --overlay (Gráfico por grupo, superpuestos, N <= 130)
            --sequence (Gráfico por grupo, en secuencia, N <= 130)
            --grid (Gráfico por grupo, en cuadrícula, N <= 16)
            --stack (Gráfico por grupo, apilados, N <= 6)
            --boxplots (Gráfico de caja por grupo, en secuencia, N <= 150)
            --boxplot (Gráfico único de caja, todos los grupos)
            --output=nombrearchivo (Enviar el resultado a un archivo específico)
Ejemplos:   panplot x --overlay
            panplot x --means --output=display

Instrucción de dibujo específica para datos de panel: la serie vardibujar
se dibuja del modo que se especifica con alguna de las opciones.

Además de las opciones --means y --boxplot, el gráfico representa
explícitamente las variaciones en las dos dimensiones, la de serie temporal
y la de sección cruzada. Tales gráficos están limitados en lo que se
refiere al número de grupos (o también conocidos como individuos o
unidades) en el rango de la muestra vigente del panel. Por ejemplo, la
opción --overlay, que presenta una serie temporal para cada grupo en un
único gráfico, solo está disponible si el número de grupos, N, es menor
o igual a 130. (De otro modo, el gráfico llegaría a ser demasiado denso
para resultar instructivo.) Si un panel es demasiado largo para permitir la
especificación gráfica deseada, puedes escoger provisionalmente un rango
reducido de grupos o de unidades, como en

	smpl 1 100 --unit
	panplot x --overlay
	smpl full

Puedes usar la opción --output=nombrearchivo para controlar la forma y el
destino del resultado; consulta la instrucción "gnuplot" para obtener más
detalles.

Otro acceso:  Ventana principal: Menú emergente (selección única)

# pca Statistics

Argumento:  listavariables 
Opciones:   --covariance (Utiliza la matriz de covarianzas)
            --save[=n] (Guarda las componentes más importantes)
            --save-all (Guarda todas las componentes)
            --quiet (No presenta los resultados)

Análisis de Componentes Principales. Excepto cuando indicas la opción
--quiet, presenta los valores propios de la matriz de correlaciones (o de la
matriz de covarianzas cuando indicas la opción --covariance) para las
variables que forman listavariables, junto con la proporción de la varianza
conjunta representada por cada componente. También presenta los
correspondientes autovectores o "pesos de las componentes".

Si indicas la opción --save-all, entonces se guardan todas las componentes
como series en el conjunto de datos, con los nombres PC1, PC2, etcétera.
Estas variables artificiales se forman como la suma de los productos de (el
peso de la componente) por (X_i tipificada), donde X_i denota la variable
i-ésima de listavariables.

Si indicas la opción --save sin un valor del parámetro, se guardan las
componentes con valores propios mayores que la media (lo que significa
mayores que 1.0 cuando el análisis se basa en la matriz de correlaciones)
en el conjunto de datos, tal como se describió arriba. Si indicas un valor
para n con esta opción, entonces se guardan las n componentes más
importantes.

Consulta también la función "princomp".

Menú gráfico: /Ver/Componentes principales

# pergm Statistics

Argumentos: serie [ anchobanda ] 
Opciones:   --bartlett (Utiliza la ventana de retardo de Bartlett)
            --log (Utiliza la escala logarítmica)
            --radians (Muestra la frecuencia en radianes)
            --degrees (Muestra la frecuencia en grados)
            --plot=modo-o-nombrearchivo (Mira abajo)

Calcula y muestra el espectro de la serie especificada. Por defecto, se
indica el periodograma de la muestra, pero se utiliza opcionalmente una
ventana de retardo de Bartlett al estimar el espectro, (consulta por
ejemplo, el libro de Greene Econometric Analysis para ver una discusión
sobre esto). La anchura por defecto de la ventana de Bartlett es de dos
veces la raíz cuadrada del tamaño de la muestra, pero puedes establecer
esto de modo manual utilizando el parámetro anchobanda, hasta un máximo de
la mitad del tamaño de la muestra.

Cuando indicas la opción --log, se representa el espectro en una escala
logarítmica.

Las opciones (mutuamente excluyentes) --radians y --degrees afectan al
aspecto del eje de frecuencias cuando se dibuja el periodograma. Por
defecto, la frecuencia se escala por el número de períodos de la muestra,
pero esas dos opciones provocan que el eje se etiquete desde 0 hasta pi
radianes o desde 0 a 180degrees, respectivamente.

Por defecto, si el programa no está en modo de procesamiento por lotes, se
muestra un gráfico del periodograma. Puedes ajustar esto mediante la
opción --plot. Los parámetros admisibles para esta opción son none (para
suprimir el gráfico), display (para representar un gráfico incluso en modo
de procesamiento por lotes), o un nombre de archivo. El efecto de indicar un
nombre de archivo es como se describe para la opción --output de la
instrucción "gnuplot".

Menú gráfico: /Variable/Periodograma
Otro acceso:  Ventana principal: Menú emergente (selección única)

# pkg Utilities

Argumentos: acción nombrepaquete 
Opciones:   --local (Instala desde un archivo local)
            --quiet (Mira abajo)
Ejemplos:   pkg install armax
            pkg install /path/to/myfile.gfn --local
            pkg query ghosts
            pkg unload armax

Esta instrución proporciona una manera de instalar, consultar descargar, o
eliminar paquetes de funciones de Gretl. El argumento acción debe ser
alguno de entre install, query, unload o remove, respectivamente.

install: En su forma más elemental, sin ningún indicador de opción y con
el argumento nombrepaquete expresado como el nombre "plano" de un paquete de
funciones de Gretl (como en el primer ejemplo de arriba), el efecto de esta
opción consiste en descargar el paquete que se especifica del servidor de
Gretl, (excepto que nombrepaquete comience con http://), e instalarlo en la
máquina local. En este caso, no es necesario expresar una extensión en el
nombre del archivo. Sin embargo, cuando indicas la opción --local, el
argumento nombrepaquete debe ser la ruta a un archivo de paquete en la
máquina local, que todavía no esté instalado, y expresado con una
extensión correcta (.gfn o .zip). En este caso, el efecto consiste en
copiar el archivo en su sitio (gfn), o descomprimirlo en su sitio (zip),
significando "en su sitio" allí donde lo va a encontrar la instrucción
"include" .

query: Por defecto, la consecuencia de esta opción es la presentación de
información básica sobre el paquete especificado (autor, versión, etc.).
Pero si añades la opción --quiet, no se presenta nada; en su lugar, se
guarda la información del paquete en forma de un 'bundle' de Gretl, al que
se puede acceder mediante "$result".

unload: Debes indicar el argumento pkgname en modo 'plano', sin ruta ni
extensión, como en el último ejemplo de arriba. La consecuencia de esto es
la descarga de ese paquete en cuestión de la memoria de Gretl (si está
cargado en ese momento), y también eliminarlo del menú de la Interface
Gráfica (GUI) al que esté añadido, si lo está a alguno.

remove: Realiza las acciones indicadas para unload y, además, elimina del
disco el(los) archivo(s) asociado(s) con el paquete indicado.

Menú gráfico: /Archivo/Paquetes de funciones/Sobre servidor

# plot Graphs

Argumento:  [ datos ] 
Opciones:   --with-lines[=varspec] (Utiliza líneas, no puntos)
            --with-lp[=varspec] (Utiliza líneas y puntos)
            --with-impulses[=varspec] (Utiliza líneas verticales)
            --with-steps[=varspec] (Utiliza segmentos de línea horizontales y verticales)
            --time-series (Representa frente al tiempo)
            --single-yaxis (Fuerza el uso de un único eje de ordenadas)
            --dummy (Mira abajo)
            --fit=espajuste (Mira abajo)
            --band=espfranja (Mira abajo)
            --band-style=estilofranja (Mira abajo)
            --output=nombrearchivo (Envía el resultado al archivo especificado)
Ejemplos:   nile.inp

El bloque plot proporciona una alternativa a la instrucción "gnuplot" que
puede ser más conveniente cuando estás generando un gráfico complicado
(con varias opciones y/o instrucciones Gnuplot para que se inserten en el
archivo gráfico).

Un bloque de tipo plot comienza con la palabra de instrución plot.
Habitualmente va seguida de un argumento de datos que especifica los datos
que se van a representar, y que debe indicar el nombre de una lista, de una
matriz o de una única serie. Si no especificas datos de entrada, el bloque
debe contener en su lugar al menos una directriz para dibujar una fórmula;
ese tipo de directivas puedes indicarlas por medio de lineas de tipo literal
o printf (mira más abajo).

Cuando indicas una lista (o una matriz), se asume que el último término (o
la última columna de la matriz) es la variable del eje x y que los(as)
otros(as) son las variables del eje y, excepto cuando indicas la opción
--time-series, en cuyo caso todos los datos especificados van en el eje y.

La opción de proporcionar el nombre de una sola serie se restringe a los
datos de series temporales, en cuyo caso se asume que quieres un gráfico de
series temporales; en otro caso, se muestra un fallo.

La línea de comienzo se puede preceder de la expresión "savename <-" para
que se guarde un gráfico como icono en el programa de Interface Gráfica de
Usuario (GUI). El bloque acaba con end plot.

Dentro del bloque tienes cero o más líneas de los siguientes tipos,
identificadas por la palabra clave inicial:

  option: Especifica una opción simple.

  options: Especifica múltiples opciones en una sola línea, separadas por
  espacios.

  literal: Una instrucción que se va a pasar literalmente a Gnuplot.

  printf: Un enunciado printf cuyo resultado se pasará literalmente a
  Gnuplot.

Ten en cuenta que cuando especificas una opción utilizando las palabras
clave option u options, no es necesario proporcionar el habitual doble guion
antes del indicador de opción. Para obtener más detalles sobre los efectos
de las distintas opciones, consulta "gnuplot" (pero mira abajo para algunos
detalles específicos de utilizar la opción --band en el contexto plot).

La intención de utilizar el bloque plot se ilustra mejor con el ejemplo:

	string title = "Mi título"
	string xname = "Mi variable X"
	plot plotmat
	    options with-lines fit=none
	    literal set linetype 3 lc rgb "#0000ff"
	    literal set nokey
	    printf "set title \"%s\"", title
	    printf "set xlabel \"%s\"", xname
	end plot --output=display

Este ejemplo asume que plotmat es el nombre de una matriz que tiene 2
columnas por lo menos (o una lista que tiene 2 elementos por lo menos). Ten
en cuenta que se considera una buena praxis colocar (únicamente) la opción
--output en la última línea del bloque.

Dibujar una franja con datos de matrices

Las opciones --band y --band-style funcionan la mayoría de las veces como
se describe en la ayuda para "gnuplot", con la siguiente excepción: cuando
se proporcionan los datos a representar en forma de una matriz, el primer
parámetro para --band debe indicarse con el nombre de una matriz de 2
columnas (que contengan el centro y el ancho de la franja, respectivamente).
Este parámetro ocupa el lugar de los dos primeros valores (nombres de
series, números ID o columnas de matriz) que requiere la versión gnuplot
de esta opción (el tercero es un factor multiplicador). A continuación
tienes un ejemplo:

	scalar n = 100
	matrix x = seq(1,n)'
	matrix y = x + filter(mnormal(n,1), 1, {1.8, -0.9})
	matrix B = y ~ muniform(n,1)
	plot y
	    options time-series with-lines
	    options band=B,10 band-style=fill
	end plot --output=display

Dibujar un gráfico sin datos

El seguiente ejemplo muestra un caso sencillo de cómo especificar la
representación de una gráfica sin ter una fuente de datos.

	plot
	    literal set title 'Utilidad CRRA'
	    literal set xlabel 'c'
	    literal set ylabel 'u(c)'
	    literal set xrange[1:3]
	    literal set key top left
	    literal crra(x,s) = (x**(1-s) - 1)/(1-s)
	    printf "plot crra(x, 0) t 'sigma=0', \\"
	    printf " log(x) t 'sigma=1', \\"
	    printf " crra(x,3) t 'sigma=3"
	end plot --output=display

# poisson Estimation

Argumentos: depvar indepvars [ ; exposición ] 
Opciones:   --robust (Desviaciones típicas robustas)
            --cluster=clustvar (Consulta "logit" para más explicaciones)
            --vcv (Presenta la matriz de covarianzas)
            --verbose (Presenta los detalles de las iteraciones)
            --quiet (No presenta los resultados)
Ejemplos:   poisson y 0 x1 x2
            poisson y 0 x1 x2 ; S
            Ver también camtriv.inp

Estima una regresión de Poisson. Se coge la variable dependiente para
representar el acaecimiento de sucesos de algún tipo, y debe tener solo
valores enteros no negativos.

Si una variable aleatoria discreta Y sigue una distribución de Poisson,
entonces

  Pr(Y = y) = exp(-v) * v^y / y!

para y = 0, 1, 2,.... La media y la varianza de la distribución son ambas
iguales a v. En el modelo de regresión de Poisson, el parámetro v está
representado como una función de una o más variables independientes. La
versión más habitual (y la única que admite Gretl) cumple

  v = exp(b0 + b1*x1 + b2*x2 + ...)

o, en otras palabras, el logaritmo de v es una función lineal de las
variables independientes.

Como opción, puedes añadir una variable de exposición ("offset") a la
especificación. Esta es una variable de escala, y su logaritmo se añade a
la función lineal de regresión (implícitamente, con un coeficiente de
1.0). Esto tiene sentido si esperas que el número de ocurrencias del evento
en cuestión es proporcional (manteniéndose lo demás constante) a algún
factor conocido. Por ejemplo, puedes suponer que el número de accidentes de
tráfico es proporcional al volumen de tráfico (manteniéndose lo demás
constante) y, en ese caso, el volumen de tráfico puede expresarse como una
variable "de exposición" en un modelo de Poisson del cociente de
accidentes. La variable de exposición debe ser estrictamente positiva.

Por defecto, se calculan las desviaciones típicas utilizando la inversa
negativa de la matriz Hessiana. Si especificas la opción --robust, entonces
se calculan en su lugar las desviaciones típicas CMV (QML) o de
Huber-White. En este caso, la matriz de covarianzas estimada es un
"emparedado" entre la inversa de la matriz Hessiana estimada y el producto
externo del vector gradiente.

Consulta también "negbin".

Menú gráfico: /Modelo/Variable dependiente limitada/Datos de conteo

# print Printing

Variantes:  print listavariables
            print
            print nombresobjetos
            print cadenaliteral
Opciones:   --byobs (Por observaciones)
            --no-dates (Utiliza números de observación simples)
            --range=inicio:parada (Mira abajo)
            --midas (Mira abajo)
            --tree (Específico para bundles; mira abajo)
Ejemplos:   print x1 x2 --byobs
            print my_matrix
            print "Esto es una cadena"
            print my_array --range=3:6
            print hflist --midas

Ten en cuenta que print es más bien una instrucción "básica" (con la
intención principal de presentar los valores de las series). Consulta
"printf" y "eval" para otras alternativas más avanzadas y menos
restrictivas.

En la primera variante mostrada arriba (consulta el primer ejemplo
también), listavariables debe ser una lista de series (bien una lista ya
definida, o bien una lista especificada mediante los nombres o números ID
de las series, separados por espacios). En este caso, esta instrucción
presenta los valores de las series de la lista. Por defecto, los datos se
presentan "por variable", pero si añades la opción --byobs se presentan
por observación. Cuando se presentan por observación, por defecto se
muestra la fecha (con datos de series temporales) o la cadena de texto de la
etiqueta de observación (en caso de que lo haya) al comienzo de cada
línea. Mediante la opción --no-dates se elimina la presentación de las
fechas o de las etiquetas; en su lugar se muestra un simple número de
observación. Consulta el párrafo final de estos comentarios para ver el
efecto de la opción --midas (que se aplica solo a una lista ya definida de
series).

Cuando no indicas ningún argumento (la segunda variante mostrada arriba)
entonces el efecto es similar al primer caso, excepto que se van a presentar
todas las series del conjunto vigente de datos. Las opciones que se admiten
son como se describieron más arriba.

La tercera variante (con el argumento nombresobjetos; mira el segundo
ejemplo) espera una lista de nombres, separados por espacios, de objetos
básicos de Gretl que no sean series (escalares, matrices, cadenas de texto,
bundles, arrays); y se muestra el valor de estos objetos.

En la cuarta forma (tercer ejemplo), cadenaliteral debe ser una cadena de
texto puesta entre comillas (y no debe haber nada más siguiendo a la línea
de instrucción). Se presenta la cadena de texto en cuestión, seguida de un
carácter de línea nueva.

Puedes utilizar la opción --range para controlar el volumen de información
que se presenta. Los valores (enteros) de los marcadores de inicio y parada
pueden referirse a observaciones de series y de listas, a filas de matrices,
a elementos de 'arrays', y a líneas de cadenas de texto. En todos los
casos, el valor mínimo de inicio es 1, y el máximo valor de parada es el
"tamaño en forma de filas" del objeto en cuestión. Los valores negativos
de estos marcadores se usan para disponer un recuento hacia atrás, desde el
final. Puedes indicar estos marcadores en formato numérico, o mediante
nombres de variables escalares previamente definidas. Si omites inicio, se
considera implícitamente igual a 1; y si omites parada, eso significa ir
hasta el final del todo. Con series y listas, ten en cuenta que los
marcadores se refieren al rango muestral vigente.

La opción --tree es específica para presentar un bundle de Gretl. El
efecto de ello es que, si el paquete especificado contiene otros bundles o
arrays de ellos, se presentan sus contenidos. De lo contrario, solo se
presentan los elementos del nivel superior del bundle.

La opción --midas es especial para presentar una lista de series y, más
aún, es específica para conjuntos de datos que contienen una o más series
de alta frecuencia, cada una representada por una "MIDAS list". Cuando
indicas una de esas listas como argumento y agregas esta opción, la serie
se presenta por observación de su frecuencia "original".

Menú gráfico: /Datos/Mostrar valores

# printf Printing

Argumentos: formato , elementos 

Presenta valores escalares, series, matrices o cadenas de texto bajo el
control de una cadena de texto para dar formato (ofreciendo una parte de la
función printf del lenguaje de programación C). Los formatos numéricos
reconocidos son %e, %E, %f, %g, %G, %d y %x, en cada caso con los diversos
reguladores disponibles en C. Ejemplos: el formato %.10g presenta un valor
con 10 cifras significativas, y %12.6f presenta un valor con un ancho de 12
caracteres de los que 6 son decimales. Sin embargo, ten en cuenta que en
Gretl el formato %g es una buena elección por defecto para todos los
valores numéricos, y no tienes necesidad de complicarte demasiado. Debes
utilizar el formato %s para las cadenas de texto.

La propia cadena de formato debe estar puesta entre comillas, y los valores
que se van a presentar deben ir después de esa cadena de formato, separados
por comas. Estos valores deben tener la forma de, o bien (a) los nombres de
las variables, o bien (b) unas expresiones que generan alguna clase de
resultado que es presentable, o bien (c) las funciones especiales varname()
o date(). El siguiente ejemplo presenta los valores de dos variables, más
el de una expresión que se calcula:

	ols 1 0 2 3
	scalar b = $coeff[2]
	scalar se_b = $stderr[2]
	printf "b = %.8g, Desviación típica %.8g, t = %.4f\n",
          b, se_b, b/se_b

Las siguientes líneas ilustran el uso de las funciones 'varname' y 'date',
que presentan respectivamente el nombre de una variable (indicado por su
número ID) y una cadena de texto con una fecha (dada por un número natural
positivo que indica una observación).

	printf "El nombre de la variable %d es %s\n", i, varname(i)
	printf "La fecha de la observación %d es %s\n", j, date(j)

Cuando indicas un argumento matricial asociado a un formato numérico, se
presenta la matriz entera utilizando el formato especificado para cada
elemento. El mismo se aplica a las series, excepto que el rango de valores
presentados se rige por la configuración vigente de la muestra.

La longitud máxima de una cadena de formato es de 127 caracteres. Se
reconocen las secuencias de escape \n (nueva línea), \t (tabulación), \v
(tabulación vertical) y \\ (barra inclinada a la izquierda literal). Para
presentar un signo por ciento literal, utiliza %%.

Como en C, puedes indicar los valores numéricos que forman parte del
formato (el ancho y/o la precisión) directamente como números, como en
%10.4f, o como variables. En este último caso, se ponen asteriscos en la
cadena de formato y se proporcionan los argumentos correspondientes por
orden. Por ejemplo:

	scalar ancho = 12
	scalar precision = 6
	printf "x = %*.*f\n", ancho, precision, x

# probit Estimation

Argumentos: depvar indepvars 
Opciones:   --robust (Desviaciones típicas robustas)
            --cluster=clustvar (Consulta "logit" para más explicaciones)
            --vcv (Presenta la matriz de covarianzas)
            --verbose (Presenta los detalles de las iteraciones)
            --quiet (No presenta los resultados)
            --p-values (Muestra los valores p en lugar de las pendientes)
            --random-effects (Estima un modelo Probit de panel con efectos aleatorios, EA)
            --quadpoints=k (Número de puntos de cuadratura para la estimación con EA)
Ejemplos:   ooballot.inp, oprobit.inp, reprobit.inp

Si la variable dependiente es una variable binaria (todos sus valores son 0
o 1), se obtienen estimaciones máximo verosímiles de los coeficientes de
las variables de indepvars mediante el método de Newton-Raphson. Como el
modelo es no lineal, las pendientes están condicionadas por los valores de
las variables independientes. Por defecto, se calculan las pendientes con
respecto a cada una de las variables independientes (en las medias de esas
variables) y estas pendientes substituyen a los valores p habituales en el
resultado de la regresión. Puedes prescindir de este proceder indicando la
opción --p-values. El estadístico chi-cuadrado contrasta la hipótesis
nula de que todos los coeficientes son cero, excepto el de la constante.

Por defecto, las desviaciones típicas se calculan utilizando la inversa
negativa de la matriz Hessiana. Si indicas la opción --robust, entonces se
calculan en su lugar las desviaciones típicas CMV (QML) o de Huber-White.
En este caso, la matriz de covarianzas estimadas es un "emparedado" entre la
inversa de la matriz Hessiana estimada y el producto externo del vector
gradiente. Para obtener más detalles, consulta el capítulo 10 del libro de
Davidson y MacKinnon (2004).

Si la variable dependiente no es binaria sino discreta, entonces se obtienen
las estimaciones de un Probit Ordenado. (Si la variable elegida como
dependiente no es discreta, se muestra un fallo.)

Probit para datos de panel

Con la opción --random-effects, se asume que cada perturbación está
compuesta por dos componentes Normalmente distribuidas: (a) un término
invariante en el tiempo que es específico de la unidad de sección cruzada
o "individuo" (y que se conoce como efecto individual), y (b) un término
que es específico de la observación concreta.

La evaluación de la verosimilitud de este modelo implica utilizar la
cuadratura de Gauss-Hermite para aproximar el valor de las esperanzas de
funciones de variables Normales. Puedes escoger el número de puntos de
cuadratura utilizados mediante la opción --quadpoints (por defecto es de
32). Utilizando más puntos se mejora la precisión de los resultados, pero
con el coste de más tiempo de cálculo; así, con muchos puntos de
cuadratura, la estimación con un conjunto de datos muy grande puede
consumir demasiado tiempo.

Además de las estimaciones habituales de los parámetros (y de los
estadísticos asociados) relacionados con los regresores incluidos, se
presenta alguna información adicional sobre la estimación de este tipo de
modelo:

  lnsigma2: La estimación máximo verosímil del logaritmo de la varianza
  del efecto individual;

  sigma_u: La estimación de la desviación típica del efecto individual; y

  rho: La estimación de la parte del efecto individual en la varianza
  compuesta de la perturbación (también conocida como la correlación
  intra-clase).

El contraste de Razón de Verosimilitudes respecto a la hipótesis nula de
que rho es igual a cero, proporciona un modo de evaluar si es necesaria la
especificación de efectos aleatorios. Si la hipótesis nula no se rechaza,
eso sugiere que es adecuada una simple especificación Probit combinada.

Menú gráfico: /Modelo/Variable dependiente limitada/Probit

# pvalue Statistics

Argumentos: distribución [ parámetros ] xvalor 
Ejemplos:   pvalue z zscore
            pvalue t 25 3.0
            pvalue X 3 5.6
            pvalue F 4 58 fval
            pvalue G shape scale x
            pvalue B bprob 10 6
            pvalue P lambda x
            pvalue W shape scale x
            Ver también mrw.inp, restrict.inp

Calcula el área que queda a la derecha del valor xvalor en la distribución
especificada (z para la Normal, t para la t de Student, X para la
Chi-cuadrado, F para la F, G para la Gamma, B para la Binomial, P para la
Poisson, exp para la Exponencial, o W para la Weibull).

Dependiendo del tipo de distribución, debes indicar la siguiente
información antes del valor xvalor: para las distribuciones t y
chi-cuadrado, los grados de libertad; para la F, los grados de libertad de
numerador y denominador; para la Gamma, los parámetros de forma y de
escala; para la distribución Binomial, la probabilidad de "éxito" y el
número de intentos; para la distribución de Poisson, el parámetro lambda
(que es tanto la media como la varianza); para la Exponencial, un parámetro
de escala; y para la distribución de Weibull, los parámetros de forma y de
escala. Como se mostró en los ejemplos de arriba, puedes indicar los
parámetros numéricos en formato numérico o como nombres de variables.

Los parámetros para la distribución Gamma se indican a veces como media y
varianza en lugar de forma y escala. La media es el producto de la forma y
la escala; la varianza es el producto de la forma y el cuadrado de la
escala. De este modo, puedes calcular la escala dividiendo la varianza entre
la media, y puedes calcular la forma dividiendo la media entre la escala.

Menú gráfico: /Herramientas/Buscador de valores P

# qlrtest Tests

Opciones:   --limit-to=lista (Limita el contraste a un subconjunto de regresores)
            --plot=modo-o-nombrearchivo (Mira abajo)
            --quiet (No presenta los resultados)

Para un modelo estimado con datos de series temporales mediante MCO, realiza
el contraste de la Razón de Verosimilitudes de Quandt (QLR) para un cambio
estructural en un punto desconocido en el tiempo, con un 15 por ciento de
recorte al comienzo y al final del período de la muestra.

Para cada punto potencial de cambio dentro del 70 por ciento central de las
observaciones, se realiza un contraste de Chow. Consulta "chow" para obtener
más detalles; pues, de igual modo que con el contraste habitual de Chow,
este es un contraste robusto de Wald cuando el modelo original se estima con
la opción --robust, y un contraste F en otro caso. Entonces el estadístico
QLR es el máximo de los estadísticos de contraste particulares.

Se obtiene una probabilidad asociada (valor p) asintótica utilizando el
método de Bruce Hansen (1997).

Además de los accesorios "$test" y "$pvalue" típicos de los contrastes de
hipótesis, puedes utilizar "$qlrbreak" para recuperar el índice de la
observación en la que el estadístico de contraste se maximiza.

Puedes utilizar la opción --limit-to para limitar el conjunto de
interacciones con la variable ficticia de corte en los contrastes de Chow, a
un subconjunto de los regresores originales. El parámetro para esta opción
debe ser una lista ya definida en la que todos sus elementos se encuentren
entre los regresores originales, y en la que no debes incluir la constante.

Cuando ejecutas de modo interactivo (únicamente) esta instrucción, se
muestra por defecto un gráfico del estadístico de contraste de Chow, pero
puedes ajustar esto mediante la opción --plot. Los parámetros que se
admiten en esta opción son none (para eliminar el gráfico), display (para
mostrar un gráfico incluso cuando no se está en modo interactivo), o un
nombre de archivo. El efecto de proporcionar un nombre de archivo es como el
descrito para la opción --output de la instrucción "gnuplot".

Menú gráfico: Ventana de modelo: Contraste/Contraste de RV de Quandt

# qqplot Graphs

Variantes:  qqplot y
            qqplot y x
Opciones:   --z-scores (Mira abajo)
            --raw (Mira abajo)
            --output=nombrearchivo (Envía el gráfico al archivo especificado)

Indicando como argumento una única serie, muestra un gráfico de los
cuantiles empíricos de la serie seleccionada (indicada por su nombre o su
número ID) frente a los cuantiles de la distribución Normal. La serie debe
incluir cuando menos 20 observaciones válidas en el rango vigente de la
muestra. Por defecto, los cuantiles empíricos se dibujan frente a los
cuantiles de una distribución Normal que tiene las mismas media y varianza
que los datos de la muestra, pero dispones de dos alternativas: si indicas
la opción --z-scores, los datos se tipifican; mientras que si indicas la
opción --raw, se dibujan los cuantiles empíricos "en bruto" frente a los
cuantiles de la distribución Normal estándar.

La opción --output tiene como efecto el envío del resultado al archivo
especificado; utiliza "display" para forzar que el resultado se presente en
la pantalla. Consulta la instrucción "gnuplot" para obtener más detalles
sobre esta opción.

Dadas dos series como argumentos, y y x, se muestra un gráfico de los
cuantiles empíricos de y frente a los de x. Los valores de los datos no se
tipifican.

Menú gráfico: /Variable/Gráfico Q-Q normal
Menú gráfico: /Ver/Gráficos/Gráfico Q-Q

# quantreg Estimation

Argumentos: tau depvar indepvars 
Opciones:   --robust (Desviaciones típicas robustas)
            --intervals[=nivelconf] (Calcula los intervalos de confianza)
            --vcv (Presenta la matriz de covarianzas)
            --quiet (No presenta los resultados)
Ejemplos:   quantreg 0.25 y 0 xlista
            quantreg 0.5 y 0 xlista --intervals
            quantreg 0.5 y 0 xlista --intervals=.95
            quantreg tauvec y 0 xlista --robust
            Ver también mrw_qr.inp

Regresión de cuantiles. El primer argumento (tau) es el cuantil
condicionado para el que se quiere la estimación. Puedes indicarlo, bien
con un valor numérico, o bien con el nombre de una variable escalar
definida previamente; y el valor debe estar en el rango de 0.01 a 0.99.
(Como alternativa, puedes indicar un vector de valores para tau; mira abajo
para obtener más detalles.) El segundo y subsiguientes argumentos componen
una lista de regresión con el mismo patrón que "ols".

Sin la opción --intervals, se presentan las desviaciones típicas para las
estimaciones de los cuantiles. Por defecto, estas se calculan de acuerdo con
la fórmula asintótica indicada por Koenker y Bassett (1978), pero cuando
indicas la opción --robust, se calculan las desviaciones típicas que son
robustas con respecto a la heterocedasticidad, utilizando el método de
Koenker y Zhao (1994).

Cuando escoges la opción --intervals, se presentan los intervalos de
confianza para las estimaciones de los parámetros en lugar de las
desviaciones típicas. Estos intervalos se calculan usando el método de la
inversión del rango y, en general, son asimétricos con respecto a las
estimaciones puntuales. Las especificidades del cálculo están mediatizadas
por la opción --robust: sin esta, los intervalos se calculan bajo el
supuesto de perturbaciones IID (Koenker, 1994); y con ella se utiliza el
estimador robusto desarrollado por Koenker y Machado (1999).

Por defecto, se generan intervalos de confianza del 90 por ciento. Puedes
modificar esto añadiendo un nivel de confianza (expresado como una
fracción decimal) a la opción de intervalos, como en --intervals=0.95.

Vector tau de valores: en lugar de proporcionar un escalar, puedes indicar
el nombre de una matriz definida previamente. En este caso, las estimaciones
se calculan para todos los valores tau indicados, y los resultados se
presentan en un formato especial, mostrando la secuencia de las estimaciones
de cuantiles para cada regresor, de uno en uno.

Menú gráfico: /Modelo/Estimación Robusta/Regresión de cuantil

# quit Utilities

Sale del programa, ofreciéndote la opción de guardar los resultados de la
sesión al salir.

Menú gráfico: /Archivo/Salir

# rename Dataset

Argumentos: serie nuevonombre 
Opción:     --quiet (Suprime la presentación del resultado)

Cambia el nombre de serie (identificada por su nombre o su número ID) a
nuevonombre. El nuevo nombre debe tener 31 caracteres como máximo, comenzar
con una letra y estar formado solo por letras, dígitos y el carácter de
barra baja. Además, no debe ser el nombre de un objeto de cualquier tipo
que ya exista.

Menú gráfico: /Variable/Editar atributos
Otro acceso:  Ventana principal: Menú emergente (selección única)

# reset Tests

Opciones:   --quiet (No presenta la regresión auxiliar)
            --silent (No presenta nada)
            --squares-only (Calcula el contraste usando solo los cuadrados)
            --cubes-only (Calcula el contraste usando solo los cubos)

Debe ir después de la estimación de un modelo mediante MCO. Lleva a cabo
el contraste RESET de Ramsey sobre la especificación (no lineal) de un
modelo, añadiéndole a la regresión los cuadrados y/o los cubos de los
valores ajustados, y calculando el estadístico F para contrastar la
hipótesis nula de que los parámetros de los términos añadidos son cero.

Se van a añadir tanto los cuadrados como los cubos, excepto que indiques
una de las opciones --squares-only o --cubes-only.

Puedes utilizar la opción --silent si tienes intención de hacer uso de los
accesorios "$test" y/o "$pvalue" para guardar los resultados del contraste.

Menú gráfico: Ventana de modelo: Contrastes/Contraste RESET de Ramsey

# restrict Tests

Opciones:   --quiet (No presenta las estimaciones restringidas)
            --silent (No presenta nada)
            --wald (Solo estimadores de sistema, mira abajo)
            --bootstrap (Cálculo del contraste con remuestreo automático, si es posible)
            --full (Solo MCO y VECMs, mira abajo)
Ejemplos:   hamilton.inp, restrict.inp

Impone un conjunto de restricciones (habitualmente lineales) sobre: (a) el
último modelo estimado o (b) un sistema de ecuaciones que se definió y
nombró previamente. En todos los casos, debes comenzar el conjunto de
restricciones con la palabra clave "restrict" y terminarlo con "end
restrict".

En caso de una única ecuación, las restricciones siempre se aplican
implícitamente al último modelo, y se evalúan tan pronto como se cierre
el bloque restrict.

En caso de un sistema de ecuaciones (definido mediante la instrucción
"system"), puedes poner el nombre del sistema de ecuaciones definido
previamente, después del "restrict" inicial. Cuando omites eso y el último
modelo fue un sistema, entonces las restricciones se aplican a ese último
modelo. Por defecto, las restricciones se evalúan cuando el sistema acaba
de estimarse, usando la instrucción "estimate". Pero cuando indicas la
opción --wald, la restricción se comprueba inmediatamente a través del
contraste chi-cuadrado de Wald en relación a la matriz de covarianzas. Ten
en cuenta que esta opción va a generar un fallo si ya has definido un
sistema, pero aún no lo has estimado.

Dependiendo del contexto, puedes expresar de varios modos las restricciones
que quieras contrastar. El más simple es como se indica a continuación:
cada restricción se expresa como una ecuación, con una combinación lineal
de parámetros a la izquierda del signo de igualdad y un valor escalar a la
derecha (bien una constante numérica, o bien el nombre de una variable
escalar).

En caso de una única ecuación, puedes referirte a sus parámetros con el
formato b[i], donde i representa la posición en la lista de regresores
(comenzando en el 1), o con el formato b[nombrevar], donde nombrevar es el
nombre del regresor en cuestión. En caso de un sistema, la referencia a los
parámetros se hace utilizando la letra b junto con dos números colocados
entre corchetes. El primer número representa la posición de la ecuación
dentro del sistema, y el segundo número indica la posición del regresor
dentro de la lista de ellos. Por ejemplo, b[2,1] denota el primer parámetro
de la segunda ecuación, mientras que b[3,2] denota el segundo parámetro de
la tercera ecuación. Puedes anteponer multiplicadores numéricos a los
elementos b de la ecuación que representa una restricción, por ejemplo
3.5*b[4].

Aquí tienes un ejemplo de un conjunto de restricciones para un modelo
estimado previamente:

	restrict
	 b[1] = 0
	 b[2] - b[3] = 0
	 b[4] + 2*b[5] = 1
	end restrict

Y aquí tienes un ejemplo de un conjunto de restricciones para aplicar a un
sistema ya definido. (Si el nombre del sistema no contiene espacios, no
hacen falta las comillas que lo delimitan.)

	restrict "Sistema 1"
	 b[1,1] = 0
	 b[1,2] - b[2,2] = 0
	 b[3,4] + 2*b[3,5] = 1
	end restrict

En caso de una única ecuación, las restricciones se evalúan por defecto
por medio del contraste de Wald, usando la matriz de covarianzas del modelo
en cuestión. Si estimaste el modelo original con MCO, entonces se presentan
las estimaciones de los coeficientes restringidos; para eliminar esto,
añade la opción --quiet a la instrucción restrict inicial. Como
alternativa al contraste de Wald, para modelos estimados únicamente
mediante MCO o MCP, puedes indicar la opción --bootstrap para realizar el
contraste de la restricción con remuestreo automático (bootstrap).

En caso de un sistema, el estadístico de contraste depende del estimador
elegido: un estadístico de Razón de Verosimilitudes cuando el sistema se
estima utilizando un método de Máxima Verosimilitud, o un estadístico F
asintótico, en otro caso.

Tienes 2 alternativas al método para expresar las restricciones que se
discutió más arriba. Primero, puedes escribir de forma compacta un
conjunto de g restricciones lineales sobre el vector con los k parámetros
(beta), como Rbeta - q = 0, donde R es una matriz de dimensión g x k y q es
un vector de dimensión g. Puedes expresar una restricción indicando los
nombres de matrices definidas previamente, cómodas para utilizar como R y
q, como en

	restrict
	  R = Rmat
	  q = qvec
	end restrict

En segundo lugar, si quieres contrastar una restricción no lineal (lo que
actualmente solo está disponible para modelos de una única ecuación),
debes indicar la restricción con el nombre de una función, precedida por
"rfunc = ", como en

	restrict
	  rfunc = mifuncion
	end restrict

La función de restricción debe tener un único argumento const matrix, y
esto se completa automáticamente con el vector de parámetros. Y debiera
devolver un vector que es cero bajo la hipótesis nula, y no nulo en otro
caso. La dimensión del vector es igual al número de restricciones. Esta
función se utiliza como una "rellamada" de la rutina numérica para el
Jacobiano, de Gretl, que calcula el estadístico de contraste de Wald
mediante el método delta.

Aquí tienes un ejemplo sencillo de una función apropiada para comprobar
una restricción no lineal, concretamente que dos pares de valores de los
parámetros tienen una razón común.

	function matrix restr (const matrix b)
	  matrix v = b[1]/b[2] - b[4]/b[5]
	  return v
	end function

Cuando se completa con éxito la instrucción restrict, los accesorios
"$test" y "$pvalue" proporcionan el estadístico de contraste y su
probabilidad asociada (valor p), respectivamente.

Cuando se contrastan restricciones sobre un modelo de una única ecuación
que fue estimado mediante MCO o sobre un Modelo de Vectores de Corrección
del Error (VECM), puedes utilizar la opción --full para disponer que las
estimaciones restringidas sean el "último modelo", con la intención de
hacer contrastes más adelante o de usar accesorios como $coeff y $vcv. Ten
en cuenta que se aplican algunos detalles especiales en caso de que pruebes
restricciones sobre un VECM. Consulta El manual de gretl (Capítulo 31) para
obtener más detalles.

Menú gráfico: Ventana de modelo: Contrastes/Restricciones lineales

# rmplot Graphs

Argumento:  serie 
Opciones:   --trim (Mira abajo)
            --quiet (No presenta los resultados)
            --output=nombrearchivo (Mira abajo)

Gráfico Rango-Media: Esta instrucción genera un gráfico sencillo para
ayudar a decidir si una serie temporal, y(t), tiene una varianza constante o
no. Se coge la muestra completa (t=1,...,T) y se divide en pequeñas
submuestras de tamaño arbitrario k. La primera submuestra está compuesta
por y(1),...,y(k), la segunda por y(k+1), ..., y(2k), etcétera. Para cada
submuestra, se calcula la media de la serie en la muestra y el rango (=
máximo menos mínimo), y se construye un gráfico con las medias en el eje
horizontal y los rangos en el vertical. Así cada submuestra se representa
mediante un punto en este plano. Si la varianza de la serie es constante, se
esperaría que el rango de la submuestra sea independiente de la media de la
submuestra. Por eso, si observamos que los puntos se aproximan a una línea
con pendiente positiva, esto sugiere que la varianza de las series aumenta a
medida que lo hace la media; y si los puntos se aproximan a una línea con
pendiente negativa, esto sugiere que la varianza decrece al aumentar la
media.

Además del gráfico, Gretl muestra las medias y rangos para cada
submuestra, junto con el coeficiente de la pendiente de una regresión MCO
do rango sobre la media, y con la probabilidad asociada al estadístico para
contrastar la hipótesis nula de que esta pendiente es cero. Si el
coeficiente de la pendiente es significativo con un nivel de significación
del 10 por ciento, entonces se muestra en el gráfico la línea ajustada de
la regresión del rango sobre la media. Se registran tanto el estadístico t
para contrastar la hipótesis nula como la probabilidad asociada
correspondiente, y puedes recuperarlos usando los accesorios "$test" y
"$pvalue", respectivamente.

Cuando indicas la opción --trim, se descartan los valores mínimo y máximo
de cada submuestra antes de calcular la media y el rango. Esto hace que sea
menos probable que los valores atípicos provoquen una distorsión en el
análisis.

Cuando indicas la opción --quiet, no se muestra el gráfico ni se presenta
el resultado; solo se indican el estadístico t y su probabilidad asociada
(valor p). Por otro lado, puedes controlar el formato del gráfico mediante
la opción --output; y esto funciona como se describe en conexión con la
instrucción "gnuplot".

Menú gráfico: /Variable/Gráfico rango-media

# run Programming

Argumento:  nombrearchivo 

Ejecuta las instrucciones de nombrearchivo y luego devuelve el control al
indicador interactivo. Esta instrucción está pensada para que la utilices
con el programa de líneas de instrucción gretlcli o con la "consola de
Gretl" en el programa de Interface Gráfica de Usuario (GUI).

Consulta también "include".

Menú gráfico: Icono 'Ejecutar' en la ventana del editor de guiones

# runs Tests

Argumento:  serie 
Opciones:   --difference (Utiliza las primeras diferencias de la variable)
            --equal (Los valores positivos y negativos son equiprobables)

Realiza el contraste no paramétrico "de rachas" para comprobar el carácter
aleatorio de la serie indicada, donde las rachas se definen como secuencias
de valores consecutivos positivos o negativos. Si quieres contrastar el
carácter aleatorio de las desviaciones respecto a la mediana, para una
variable llamada x1 que tiene una mediana no nula, puedes hacer lo
siguiente:

	series signx1 = x1 - median(x1)
	runs signx1

Cuando indicas la opción --difference, se van a calcular las primeras
diferencias de la serie antes del análisis, por lo que las rachas se
interpretarían como secuencias de aumentos o de diminuciones consecutivas
del valor de la variable.

Cuando indicas la opción --equal, la hipótesis nula también incorpora el
supuesto de que los valores positivos y negativos son igual de probables; de
lo contrario, el estadístico de contraste resulta invariante con respecto a
la "neutralidad" del proceso que generó la secuencia de valores, y el
contraste se centra únicamente en la independencia.

Menú gráfico: /Herramientas/Contrastes no paramétricos

# scatters Graphs

Argumentos: yvar ; xvars  o yvars ; xvar 
Opciones:   --with-lines (Genera gráficos de líneas)
            --matrix=nombrematriz (Representa las columnas de la matriz indicada)
            --output=nombrearchivo (Envía el resultado al archivo especificado)
Ejemplos:   scatters 1 ; 2 3 4 5
            scatters 1 2 3 4 5 6 ; 7
            scatters y1 y2 y3 ; x --with-lines

Genera gráficos de dos variables, bien de yvar frente a todas las variables
de xvars, o bien de todas las variables de yvars frente a xvar. En el primer
ejemplo de arriba, se coloca la variable 1 en el eje y y se dibujan 4
gráficos: el primero tiene la variable 2 en el eje x, el segundo con la
variable 3 en el eje x, etcétera. El segundo ejemplo representa cada una de
las variables de la 1 a la 6, frente a la variable 7 en el eje x. Repasar un
conjunto de esos gráficos puede ser un paso conveniente en el análisis
exploratorio de datos. El número máximo de gráficos es de 16, por lo que
se va a ignorar cualquier variable adicional en la lista.

Por defecto, los gráficos son de dispersión, pero si indicas la opción
--with-lines serán gráficos de líneas.

Para obtener más detalles sobre el uso de la opción --output, consulta la
instrucción "gnuplot".

Si especificas una matriz ya definida como origen de los datos, debes
expresar las listas x e y con números naturales positivos que indiquen la
columna; o, en caso contrario, si no indicas esos números, se representan
todas las columnas frente al tiempo o a una variable índice.

Cuando el conjunto de datos es de series temporales, entonces puedes omitir
la segunda lista, pues en ese caso se va a tomar implícitamente al 'tiempo'
como tal, por lo que puedes dibujar varias series temporales en gráficos
separados.

Menú gráfico: /Ver/Gráficos múltiples

# sdiff Transformations

Argumento:  listavariables 

Se obtiene la diferencia estacional de cada una de las variables de
listavariables, y se guarda el resultado en una nueva variable con el
prefijo sd_. Esta instrucción está disponible solo para series de tiempo
estacionales.

Menú gráfico: /Añadir/Diferencias estacionales de las variables seleccionadas

# set Programming

Variantes:  set variable valor
            set --to-file=nombrearchivo
            set --from-file=nombrearchivo
            set stopwatch
            set
Ejemplos:   set svd on
            set csv_delim tab
            set horizon 10
            set --to-file=mysettings.inp

El uso más común de esta instrucción es la primera variante mostrada
arriba, en la que se utiliza para establecer el valor de un parámetro
escogido del programa (esto se discute con detalle más abajo). Los otros
usos son: con --to-file para escribir un archivo de guion que contenga todas
las configuraciones actuales de los parámetros; con --from-file para leer
un archivo de guion que contenga las configuraciones de los parámetros y
para aplicarlas a la sesión vigente; con stopwatch para poner a cero el
"cronómetro" de Gretl que puedes usar para medir el tiempo de CPU (consulta
los comentarios para el accesorio "$stopwatch"); o para presentar las
configuraciones actuales, cuando indicas solo la palabra set.

Los valores establecidos mediante esta instrucción siguen vigentes durante
la duración de la sesión de Gretl, excepto que los cambies por medio de
una llamada posterior a "set". Los parámetros que puedes establecer de este
modo se enumeran más abajo. Ten en cuenta que se utilizan las
configuraciones de hc_version, hac_lag y hac_kernel cuando indicas la
opción --robust en una instrucción de estimación.

Las configuraciones disponibles se agrupan bajo las siguientes categorías:
interacción y comportamiento del programa, métodos numéricos, generación
de números aleatorios, estimación robusta, filtrado, estimación de series
temporales e interacción con GNU R.

Interacción y comportamiento del programa

Estas configuraciones se utilizan para controlar diversos aspectos del modo
en el que Gretl interactúa con el usuario.

  workdir: path. Establece el directorio por defecto para escribir y leer
  archivos en los casos en los que no se especifican las rutas completas.

  use_cwd: on u off (por defecto). Maneja la configuración del directorio
  de trabajo (workdir) inicial: si está en on, se hereda el directorio de
  trabajo desde el intérprete; en otro caso, se establece donde quiera que
  se seleccionó en la sesión previa de Gretl.

  echo: off u on (por defecto). Elimina (o acorta) la resonancia de los
  textos de las instrucciones en los resultados de Gretl.

  messages: off u on (por defecto). Elimina (o acorta) la presentación de
  mensajes sin fallo asociados a diversas instrucciones, por ejemplo cuando
  se genera una nueva variable o cuando se cambia el rango de la muestra.

  verbose: off, on (por defecto) o comments. Funciona como un "interruptor
  maestro" para echo y messages (mira más abajo), apagando o encendiendo
  los dos simultáneamente. El argumento comments apaga la resonancia y la
  aparición de mensajes, pero mantiene la presentación de comentarios de
  un guion.

  warnings: off u on (por defecto). Elimina (o acorta) la presentación de
  mensajes de advertencia que surgen cuando las operaciones aritméticas
  producen valores no finitos.

  csv_delim: comma (coma, por defecto), space (espacio), tab (tabulación) o
  semicolon (punto y coma). Establece el delimitador de columnas que se usa
  cuando se guardan datos en un archivo con formato CSV.

  csv_write_na: La cadena de texto que se utiliza para representar los
  valores ausentes cuando se escriben datos en un archivo con formato CSV.
  Máximo = 7 caracteres; por defecto es NA.

  csv_read_na: La cadena de texto que se coge para representar valores
  ausentes (NAs) cuando se leen datos con el formato CSV (máximo 7
  caracteres). La cadena por defecto depende de que se encuentre una columna
  de datos que contenga datos numéricos (la mayoría de las veces) o
  valores de cadena. Para datos numéricos, se considera que lo siguiente
  indica NAs: una celda vacía o cualquiera de las cadenas NA, N.A., na,
  n.a., N/A, #N/A, NaN, .NaN, ., .., -999, y -9999. Para datos con forma de
  cadenas de texto con valores, tan solo se cuenta como NA una celda en
  blanco o una celda que contenga una cadena vacía. Puedes volver a imponer
  esos valores por defecto indicando default como el valor de csv_read_na.
  Para especificar que tan solo se leen las celdas vacías como NAs, indica
  el valor "". Ten en cuenta que las celdas vacías siempre se leen como NAs
  con independencia de como esté configurada esta variable.

  csv_digits: Un entero positivo que especifica el número de dígitos
  significativos a usar cuando se escriben datos en formato CSV. Por
  defecto, se utilizan hasta 15 dígitos dependiendo de la precisión de los
  datos originales. Ten en cuenta que el resultado CSV emplea la función
  fprintf de la librería de C con la conversión "%g" , lo que significa
  que se prescinde de los ceros que quedan atrás.

  display_digits: Un entero de 3 a 6 que especifica el número de dígitos
  significativos a usar cuando se muestran los coeficientes de la regresión
  y las desviaciones típicas (siendo 6 por defecto). También puedes
  utilizar esta configuración para limitar el número de dígitos que se
  muestran con la instrucción "summary"; siendo en este caso 5 por defecto
  (y también como máximo) o 4 cuando indicas la opción --simple.

  mwrite_g: on u off (por defecto). Cuando se escribe una matriz como texto
  en un archivo, Gretl por defecto utiliza notación científica con 18
  dígitos de precisión, asegurando de este modo que los valores guardados
  son una representación fiable de los números en memoria. Cuando se
  escriben datos básicos con no más que 6 dígitos de precisión, puedes
  preferir utilizar el formato %g para tener un archivo más compacto y
  fácil de leer; puedes hacer este cambio mediante set mwrite_g on.

  force_decpoint: on u off (por defecto). Fuerza a Gretl a utilizar el
  carácter de punto decimal, en un escenario donde otro carácter
  (probablemente la coma) es el separador decimal estándar.

  loop_maxiter: Un valor entero no negativo (por defecto es 100000).
  Establece el número máximo de iteraciones que se le permite a un bucle
  while, antes de parar (consulta "loop"). Ten en cuenta que esta
  configuración solo afecta a la variante while; su intención es
  protegerse ante infinitos bucles que surjan de forma inadvertida.
  Establecer que este valor sea 0 tiene el efecto de inhabilitar el límite
  (utilízalo con precaución).

  max_verbose: on u off (por defecto). Conmuta el resultado más completo
  para las funciones BFGSmax y NRmax (consulta El manual de gretl (Capítulo
  35) para obtener más detalles).

  debug: 1, 2 o 0 (por defecto). Esto se utiliza con las funciones definidas
  por el usuario. Establecer debug igual a 1 equivale a activar messages
  dentro de todas esas funciones, y establecer esta variable igual a 2 tiene
  el efecto adicional de activar max_verbose dentro de todas las funciones.

  shell_ok: on u off (por defecto). Permite ejecutar programas externos
  desde Gretl mediante el intérprete de sistema. Esto no está habilitado
  por defecto por razones de seguridad, y solo puedes habilitarlo mediante
  la Interface Gráfica de Usuario (Herramientas/Preferencias/General). Sin
  embargo, una vez activada, esta configuración permanecerá activa para
  sesiones futuras hasta que se desactive explícitamente.

  bfgs_verbskip: Un entero. Esta configuración afecta al comportamiento de
  la opción --verbose en aquellas instrucciones que utilizan BFGS como
  algoritmo de optimización, y se usa para compactar el resultado. Si
  bfgs_verbskip se establece en 3, por ejemplo, entonces la opción
  --verbose va a provocar que se presenten las iteraciones 3, 6, 9,
  etcétera.

  skip_missing: on (por defecto) u off. Controla el comportamiento de Gretl
  cuando se construye una matriz a partir de series de datos: por defecto se
  saltan las filas de datos que contienen uno o más valores ausentes, pero
  cuando se pone skip_missing en off, los valores ausentes se convierten en
  NaNs.

  matrix_mask: El nombre de una serie o la palabra clave null. Ofrece un
  mayor control que skip_missing cuando se construyen matrices a partir de
  series: las filas de datos seleccionadas para las matrices son aquellas
  con valores no nulos (y no ausentes) de las series especificadas. La
  máscara escogida permanece en vigor hasta que se substituye, o se elimina
  mediante la palabra clave null.

  huge: Un número positivo muy grande (por defecto, 1.0E100). Esta
  configuración controla el valor que devuelve el accesorio "$huge".

Métodos numéricos

Estas configuraciones se utilizan para controlar los algoritmos numéricos
que utiliza Gretl para la estimación.

  optimizer: o auto (por defecto), o BFGS, o bien newton. Establece el
  algoritmo de optimización que se utiliza para varios estimadores Máximo
  Verosímiles, en los casos donde el BFGS y el de Newton-Raphson se pueden
  aplicar ambos. Por defecto, se utiliza el de Newton-Raphson cuando se
  disponga de una matriz Hessiana analítica; en otro caso, BFGS.

  bhhh_maxiter: Un entero, el número máximo de iteraciones para la rutina
  interna BHHH de Gretl, que se utiliza en la instrucción "arma" para la
  estimación MV condicional. Si la convergencia no se alcanza luego de
  bhhh_maxiter, el programa devuelve un fallo. Por defecto, se establece en
  500.

  bhhh_toler: Un valor de punto flotante o la cadena default. Esto se
  utiliza en la rutina interna BHHH de Gretl para verificar si la
  convergencia se alcanzó. El algoritmo termina de repetirse tan pronto
  como el incremento en el logaritmo de la verosimilitud entre iteraciones
  sea menor que bhhh_toler. El valor por defecto es 1.0E-06, y puedes
  restablecer este valor tecleando default en lugar de un valor numérico.

  bfgs_maxiter: Un entero, el número máximo de iteraciones para la rutina
  BFGS de Gretl, que se utiliza para "mle" (EMV), "gmm" (MXM) y varios
  estimadores específicos. Si no se alcanza la convergencia en el número
  indicado de iteraciones, el programa devuelve un fallo. El valor por
  defecto depende del contexto, pero habitualmente es del orden de 500.

  bfgs_toler: Un valor de punto flotante o la cadena default. Esto se
  utiliza en la rutina interna BFGS de Gretl para verificar si la
  convergencia se alcanzó. El algoritmo termina de repetirse tan pronto
  como la mejoría relativa en la función objetivo entre iteraciones sea
  menor que bfgs_toler. El valor por defecto es igual a la precisión de
  máquina elevada a 3/4, y puedes restablecer este valor tecleando default
  en lugar de un valor numérico.

  bfgs_maxgrad: Un valor de punto flotante. Esto se utiliza en la rutina
  interna BFGS de Gretl, para verificar si la norma del vector gradiente
  está razonablemente cerca de cero cuando se alcanza el criterio
  bfgs_toler. Se va a presentar una advertencia cuando la norma del vector
  gradiente exceda de 1; y se muestra un fallo si la norma excede
  bfgs_maxgrad. Actualmente, por defecto el valor de tolerancia es de 5.0.

  bfgs_richardson: on u off (por defecto). Utiliza la extrapolación de
  Richardson cuando calcula las derivadas numéricas en el contexto de la
  maximización BFGS.

  initvals: O auto (por defecto), o bien el nombre de una matriz
  especificada previamente. Permite establecer manualmente las estimaciones
  iniciales de los parámetros para problemas de optimización numérica
  (tales como la estimación ARMA). Para obtener más detalles, consulta El
  manual de gretl (Capítulo 29).

  lbfgs: on u off (por defecto). Utiliza la versión de memoria limitada de
  BFGS (L-BFGS-B) en vez del algoritmo habitual. Esto puede ser ventajoso
  cuando la función que se maximiza no es globalmente cóncava.

  lbfgs_mem: Un valor entero en el rango de 3 a 20 (con un valor por defecto
  de 8). Esto determina el número de correcciones que se utilizan en la
  matriz de memoria limitada cuando se emplea L-BFGS-B.

  nls_toler: Un valor de punto flotante. Establece la tolerancia que se
  utiliza al juzgar si la convergencia se alcanza o no, en una estimación
  de mínimos cuadrados no lineales utilizando la instrucción "nls". El
  valor por defecto es igual a la precisión de máquina elevada a 3/4, y
  puedes restablecer este valor tecleando default en lugar de un valor
  numérico.

  svd: on u off (por defecto). Utiliza la Descompisición en Valores
  Singulares (SVD) en vez de las descomposiciones de Cholesky o la QR, en
  los cálculos de mínimos cuadrados. Esta opción se aplica a la función
  mols así como a varios cálculos internos, pero no a la instrucción
  "ols" habitual.

  force_qr: on u off (por defecto). Esto se aplica a la instrucción "ols".
  Por defecto, esta instrucción calcula las estimaciones de MCO utilizando
  la descomposición de Cholesky (el método más rápido), con QR como
  último recurso si los datos parecen demasiado mal condicionados. Puedes
  utilizar force_qr para saltarte el paso de Cholesky, pues en los casos
  "dudosos" esto puede asegurar una mayor precisión.

  fcp: on u off (por defecto). Utiliza el algoritmo de Fiorentini, Calzolari
  y Panattoni en vez del código propio de Gretl, cuando se calculan las
  estimaciones GARCH.

  gmm_maxiter: Un entero, el número máximo de iteraciones de la
  instrucción "gmm" de Gretl cuando se está en modo iterativo (en
  contraposición al de un paso o al de dos pasos). El valor por defecto es
  250.

  nadarwat_trim: Un entero, el parámetro de recorte utilizado en la
  función "nadarwat".

  fdjac_quality: Un entero (0, 1 o 2) que indica el algoritmo utilizado por
  la función "fdjac"; por defecto es 0.

Generación de números aleatorios

  seed: Un número natural positivo. Establece la semilla para el generador
  de números pseudoaleatorios. Por defecto, esto se establece a partir del
  tiempo del sistema; pero si quieres generar secuencias repetibles de
  números aleatorios debes establecer la semilla manualmente.

Estimación robusta

  bootrep: Un entero. Establece el número de repeticiones de la
  instrucción "restrict" con la opción --bootstrap.

  garch_vcv: unset, hessian, im (matriz de información), op (matriz de
  producto externo), qml (estimador CMV o QML), o bw
  (Bollerslev-Wooldridge). Especifica la variante que se va a utilizar para
  estimar la matriz de covarianzas de los coeficientes para modelos GARCH.
  Cuando indicas unset (caso por defecto) entonces se utiliza la matriz
  Hessiana, excepto que se indique la opción "robust" para la instrucción
  garch, en cuyo caso se utiliza CMV (QML).

  arma_vcv: hessian (caso por defecto) u op (matriz de producto externo).
  Especifica la variante que se va a utilizar cuando se calcula la matriz de
  covarianzas para modelos ARIMA.

  force_hc: off (por defecto) u on. Por defecto, con datos de series
  temporales y cuando indicas la opción--robust con ols (MCO), se utiliza
  el estimador HAC. Si pones force_hc en "on", esto fuerza el cálculo de la
  Matriz de Covarianzas Consistente ante Heterocedasticidad (HCCM) habitual,
  que no tiene en cuenta la autocorrelación. Ten en cuenta que los VARs se
  tratan como un caso especial, pues cuando indicas la opción --robust el
  método por defecto es el de la HCCM habitual, pero puedes utilizar la
  opción --robust-hac para forzar que se emplee un estimador HAC.

  robust_z: off (por defecto) u on. Esto controla la distribución que se
  utiliza cuando se calculan las probabilidades asociadas (valores p)
  basadas en las desviaciones típicas robustas, en el contexto de los
  estimadores de mínimos cuadrados. Por defecto, Gretl utiliza la
  distribución t de Student pero si activas robust_z, se utiliza una
  distribución Normal.

  hac_lag: nw1 (por defecto), nw2, nw3 o un entero. Establece el valor del
  retardo máximo o ancho de banda (p) utilizado cuando se calculan las
  desviaciones típicas HAC (Consistentes ante Heterocedasticidad y
  Autocorrelación) utilizando el enfoque de Newey-West, para datos de
  series temporales. Las opciones nw1 y nw2 representan dos variantes de
  cálculo automático basadas en el tamaño de la muestra T: para nw1, p =
  0.75 * T^(1/3), y para nw2, p = 4 * (T/100)^(2/9). La nw3 solicita una
  elección del ancho de banda que se basa en los datos. Consulta también
  más abajo qs_bandwidth y hac_prewhiten.

  hac_kernel: bartlett (por defecto), parzen o qs (Espectral cuadrado).
  Establece el 'kernel', o patrón de ponderaciones, que se utiliza cuando
  se calculan las desviaciones típicas HAC.

  hac_prewhiten: on u off (por defecto). Utiliza el 'blanqueo' previo y la
  'vuelta a colorear' de Andrews-Monahan cuando se calculan las desviaciones
  típicas HAC. Esto también implica utilizar una elección del ancho de
  banda que se basa en los datos.

  hc_version: 0 (por defecto), 1, 2, 3 o 3a. Establece la variante que se
  utiliza al calcular las desviaciones típicas Consistentes ante
  Heterocedasticidad (HC) con datos de sección cruzada. Las 4 primeras
  opciones se corresponden a HC0, HC1, HC2 y HC3 discutidas por Davidson y
  MacKinnon en el capítulo 5 de Econometric Theory and Methods. HC0 produce
  las "desviaciones típicas de White", como se denominan habitualmente. La
  variante 3a es el procedimiento de la "navaja" de MacKinnon-White.

  pcse: off (por defecto) u on. Por defecto, cuando se estima un modelo
  utilizando MCO combinados con datos de panel con la opción --robust, se
  utiliza el estimador de Arellano para la matriz de covarianzas. Cuando
  pones pcse en "on", esto fuerza que se utilicen las Desviaciones Típicas
  Corregidas de Panel de Beck y Katz (que no tienen en cuenta la
  autocorrelación).

  qs_bandwidth: Ancho de banda para la estimación HAC en caso de que
  selecciones el kernel Espectral Cuadrado (QS). (A diferencia de los
  'kernels' de Bartlett y de Parzen, el ancho de banda QS no requiere ser un
  entero.)

Series temporales

  horizon: Un entero (por defecto se basa en la frecuencia de los datos).
  Establece el horizonte para las respuestas al impulso y las
  descomposiciones de la varianza de predicción en el contexto de
  autorregresiones de vectores.

  vecm_norm: phillips (por defecto), diag, first o none. Usada en el
  contexto de la estimación VECM mediante la instrucción "vecm" para
  identificar los vectores de cointegración. Consulta El manual de gretl
  (Capítulo 31) para obtener más detalles.

  boot_iters: Un entero, B. Establece el número de iteracciones 'bootstrap'
  que se usan cuando se calculan funciones de respuesta al impulso con
  intervalos de confianza. El valor por defecto es 1999. Es recomendable que
  B + 1 sea siempre divisible por 100α/2 de forma que, por ejemplo con α =
  0.1, B+1 debería ser múltiplo de 5. El mínimo valor aceptable para B es
  499.

Interacción con R

  R_lib: on (por defecto) u off. Cuando se envían instrucciones para que
  las ejecute R, utiliza la biblioteca compartida de R mejor que el
  ejecutable de R, si la biblioteca está disponible.

  R_functions: off (por defecto) u on. Reconoce funciones definidas en R
  como si fueran funciones propias (para eso se requiere el prefijo de
  asignación de nombres "R."). Consulta El manual de gretl (Capítulo 40)
  para obtener más detalles sobre este elemento y el anterior.

# setinfo Dataset

Argumento:  serie 
Opciones:   --description=cadena (Establece la descripción)
            --graph-name=cadena (Establece el nombre del gráfico)
            --discrete (Marca la serie como discreta)
            --continuous (Marca la serie como continua)
            --coded (Marca como una codificación)
            --numeric (Marca como no codificación)
            --midas (Marca como componente de datos de alta frecuencia)
Ejemplos:   setinfo x1 --description="Descripción de x1"
            setinfo y --graph-name="Alguna cadena"
            setinfo z --discrete

Si activas las opciones --description o --graph-name, el argumento debe ser
una única serie; de lo contrario, podrá ser una lista de series, en cuyo
caso la instrucción funciona sobre todos los elementos de la lista. Esta
instrucción configura 4 atributos como se indica a continuación.

Cuando indicas la opción --description seguida de una cadena de texto entre
comillas, esa cadena se utiliza para establecer la etiqueta descriptiva de
la variable. Esta etiqueta se muestra en respuesta a la instrucción
"labels", y también se muestra en la ventana principal del programa de
Interface Gráfica de Usuario (GUI).

Cuando especificas la opción --graph-name seguida de una cadena de texto
entre comillas, esa cadena se va a utilizar en los gráficos en lugar del
nombre de la variable.

Cuando indicas uno de los dos indicadores de opción --discrete o
--continuous, el carácter numérico de la variable se establece en
consonancia con eso. Por defecto, se tratan todas las series como continuas,
entonces determinar que una serie sea discreta va a afectar al modo en que
se maneja la variable en los gráficos de frecuencia.

Cuando indicas alguna de las dos opciones --coded o --numeric, el status de
la serie indicada se establece de acuerdo con eso. Por defecto, se tratan
todos los valores numéricos como que tienen sentido como tales, por lo
menos en la acepción habitual; pero establecer que una serie es coded
quiere decir que los valores numéricos son una codificación arbitraria de
características cualitativas.

La opción --midas establece una indicación que alude a que una determinada
serie contiene datos de una frecuencia mayor que la frecuencia base del
conjunto de datos; por ejemplo, si el conjunto de datos es trimestral, y las
series contienen valores para el mes 1, 2 o 3 de cada trimestre. (MIDAS =
Mixed Data Sampling.)

Menú gráfico: /Variable/Editar atributos
Otro acceso:  Ventana principal: Menú emergente

# setmiss Dataset

Argumentos: valor [ listavariables ] 
Ejemplos:   setmiss -1
            setmiss 100 x2

Permite que el programa interprete algún valor específico de dato
numérico (el primer parámetro de la instrucción) como un código para
"ausente", en caso de importar datos. Cuando este valor es el único
parámetro (como en el primer ejemplo de arriba), esa interpretación se va
a aplicar a todas las series del conjunto de datos. Cuando "valor" va
seguido de una lista de variables (indicadas por nombre o número), la
interpretación se limita a la(s) variable(s) especificada(s). Así, en el
segundo ejemplo, el valor 100 de los datos se interpreta como un código
para "ausente", pero solo para la variable x2.

Menú gráfico: /Datos/Establecer código de valor ausente

# setobs Dataset

Variantes:  setobs periodicidad obsinicio
            setobs varunidades vartiempo --panel-vars
Opciones:   --cross-section (Interpreta como de sección cruzada)
            --time-series (Interpreta como serie temporal)
            --special-time-series (Mira abajo)
            --stacked-cross-section (Interpreta como datos de panel)
            --stacked-time-series (Interpreta como datos de panel)
            --panel-vars (Utiliza variables índice, mira abajo)
            --panel-time (Mira abajo)
            --panel-groups (Mira abajo)
Ejemplos:   setobs 4 1990:1 --time-series
            setobs 12 1978:03
            setobs 1 1 --cross-section
            setobs 20 1:1 --stacked-time-series
            setobs unit year --panel-vars

Esta instrucción fuerza al programa a interpretar que el conjunto de datos
tiene una estructura específica.

En la primera forma de la instrucción, debes indicar la periodicidad
mediante un entero que represente la frecuencia en caso de que los datos
sean series temporales (1 = anuales; 4 = trimestrales; 12 = mensuales; 52 =
semanales; 5, 6, o 7 = diarios; 24 = horarios). En caso de datos de panel,
la periodicidad indica el número de líneas por bloque de datos; por lo
tanto, esto expresa o bien el número de unidades consecutivas cuando
indicas que son 'secciones cruzadas apiladas', o bien el número de
períodos de tiempo consecutivos cuando indicas 'series de tiempo apiladas'.
En caso de datos simples de sección cruzada, la periodicidad debe
establecerse en 1.

La observación de inicio representa la fecha inicial, en caso de tratarse
de datos de series temporales. Puedes indicar los años mediante 2 o 4
dígitos; y debes separar los subperíodos (por ejemplo, trimestres o meses)
del año mediante dos puntos. En caso de datos de panel, debes indicar la
observación inicial como 1:1, y en caso de datos de sección cruzada, como
1. Debes indicar las observaciones iniciales para datos diarios o semanales
con el formato YYYY-MM-DD (o simplemente como 1 para datos sin fechar).

Algunas periodicidades de series temporales tienen interpretaciones
estándar (por ejemplo, 12 = mensuales y 4 = trimestrales). Pero si tienes
datos de series temporales poco habituales para las que no se aplica la
interpretación estándar, puedes señalar esto indicando la opción
--special-time-series. En ese caso, Gretl no va a advertir de que tus datos
de (por ejemplo) frecuencia igual a 12, sean mensuales.

Cuando no seleccionas un indicador de opción explícito para determinar la
estructura de los datos, el programa va a tratar de adivinar la estructura a
partir de la información proporcionada.

La segunda forma de la instrucción (que requiere que indiques la opción
--panel-vars) puede utilizarse para imponer una interpretación de panel,
cuando el conjunto de datos contiene variables que identifican de forma
inequívoca las unidades de sección cruzada y los períodos de tiempo. El
conjunto de datos se va a ordenar como series de tiempo apiladas, en
función de los valores ascendentes de la variable de unidades
(varunidades).

Opciones específicas de Panel

Puedes usar opciones --panel-time y --panel-groups únicamente con un
conjunto de datos que ya fue definido previamente como un panel.

La intención de la opción --panel-time es determinar información
adicional relacionada con la dimensión temporal del panel. Debes indicar
esta siguiendo el patrón del primer formato de setobs apuntado más arriba.
Por ejemplo, puedes utilizar la siguiente forma de indicar que la dimensión
temporal de un panel es trimestral, comenzando en el primer trimestre de
1990:

	setobs 4 1990:1 --panel-time

La intención de la opción --panel-groups es crear una serie con valores en
cadenas de texto, que contenga los nombres de los grupos (individuos,
unidades atemporales) del panel. (Esto se va a utilizar cuando sea adecuado
en gráficos de panel.) Con esta opción indicas uno o dos argumentos, como
se indica a continuación.

Primer caso: Un único argumento es el nombre de una serie con valores en
cadenas de texto. Si el número de valores diferentes es igual al número de
grupos del panel, esa serie se utiliza para definir los nombres de los
grupos. Si resulta necesario, el contenido numérico de la serie se va a
ajustar de forma que los valores sean todos 1 para el primer grupo, todos 2
para el segundo grupo, etcétera. Cuando el número de valores diferentes en
cadenas de texto no coincide con el número de grupos, se muestra un fallo.

Segundo caso: El primer argumento es el nombre de una serie, y el segundo es
una cadena de texto literal o una variable de cadena que contiene un nombre
para cada grupo. Las series se van a generar si no existen ya. Cuando el
segundo argumento es una cadena de texto literal o una variable de cadena,
los nombres de los grupos deben estar separados por espacios; pero se un
nombre incluye espacios, debe delimitarse con comillas precedidas (cada una)
de barra inversa. Alternativamente, el segundo argumento puede ser un array
de cadenas de texto.

Por ejemplo, el siguiente código genera una serie que se va llamar Estado
en la que los nombres de la cadena cstrs se repiten cada uno T veces, y
siendo T la longitud de las series de tiempo del panel.

	string cstrs = sprintf("Francia Alemania Italia \"Reino Unido\"")
	setobs Estado cstrs --panel-groups

Menú gráfico: /Datos/Estructura del conjunto de datos

# setopt Programming

Argumentos: instrucción [ acción ] opciones 
Ejemplos:   setopt mle --hessian
            setopt ols persist --quiet
            setopt ols clear
            Ver también gdp_midas.inp

Esta instrucción permite la configuración previa de opciones para una
instrucción concreta. Normalmente esto no hace falta, pero puede ser útil
para los autores de funciones en Hansl, cuando quieren hacer que algunas
opciones de las instrucciones estén condicionadas al valor de un argumento
que proporcione quien las solicita.

Por ejemplo, supón que una función ofrece un interruptor booleano "quiet",
cuya intención es que se suprima la presentación de resultados de una
determinada regresión que se ejecuta dentro de la propia función. En ese
caso, se podría escribir:

	if quiet
	  setopt ols --quiet
	endif
	ols ...

Entonces, la opción --quiet se va a aplicar a la siguiente instrucción ols
únicamente si la variable quiet tiene un valor no nulo.

Por defecto, las opciones que se establecen de este modo solo se aplican a
la siguiente petición de la instrucción; por lo que no son persistentes.
Sin embargo, si indicas persist como valor para acción, las opciones se
continuarán aplicando a la instrucción indicada hasta nuevo aviso. El
'antídoto' a la acción persist es clear, pues este elimina cualquier
configuración guardada para la instrucción especificada.

Debes tener en cuenta que las opciones establecidas mediante setopt se
combinan con cualquier opción agregada directamente a la instrucción
apuntada. Así, por ejemplo, se puede añadir la opción --hessian a una
instrucción mle de forma incondicional, pero utilizar setopt para añadir
--quiet de forma condicional.

# shell Utilities

Argumento:  instrucshell 
Ejemplos:   ! ls -al
            ! notepad
            launch notepad

Un signo de exclamación ("!") o la palabra clave "launch", al comienzo de
una línea de instrucción se interpreta como una escapada del intérprete
de usuario. Así puedes ejecutar instrucciones del intérprete a tu antojo
desde dentro de Gretl. Si utilizas "!", la instrucción externa se ejecuta
de forma sincrónica; es decir, Gretl espera a que se complete la
instrucción antes de proseguir. Cuando quieras comenzar otro programa desde
dentro de Gretl y no tener que esperar a que se complete (operación
asíncrona ), utiliza en su lugar "launch".

Por razones de seguridad, esta prestación no se permite por defecto. Para
activarla, marca el cuadradito "Permitir instrucciones de shell" bajo el
menú Herramientas/Preferencias/General en el programa de Interface Gráfica
de Usuario (GUI). Esto también hace que estén disponibles las
instrucciones del intérprete en el programa de instrucciones en líneas (y
resulta el único modo de hacerlo).

# smpl Dataset

Variantes:  smpl obsinicio obsfin
            smpl +i -j
            smpl varficticia --dummy
            smpl condición --restrict
            smpl --no-missing [ listavariables ]
            smpl --no-all-missing [ listavariables ]
            smpl --contiguous [ listavariables ]
            smpl n --random
            smpl full
Opciones:   --dummy (El argumento es una variable ficticia)
            --restrict (Aplica una restricción booleana)
            --replace (Substituye cualquier restricción booleana existente)
            --no-missing (Limitarse a observaciones válidas)
            --no-all-missing (Omite observaciones vacías (mira abajo))
            --contiguous (Mira abajo)
            --random (Genera una submuestra aleatoria)
            --permanent (Mira abajo)
            --balanced (Datos de panel: trata de mantener el panel equilibrado)
            --unit (Datos de panel: muestra en la dimensión de sección cruzada)
            --quiet (No mostrar el rango muestral)
Ejemplos:   smpl 3 10
            smpl 1960:2 1982:4
            smpl +1 -1
            smpl x > 3000 --restrict
            smpl y > 3000 --restrict --replace
            smpl 100 --random

Restablece el rango de la muestra. Puedes definir el nuevo rango de varios
modos. En la primera alternativa (y en los dos primeros ejemplos) de arriba,
obsinicio y obsfin deben ser consistentes con la periodicidad de los datos.
Puedes substituir cualquiera de los dos mediante un punto y coma para dejar
ese valor sin cambiar. En la segunda forma, los números enteros i y j
(pueden ser positivos o negativos, y deben tener su signo) se consideran
como variaciones en relación al rango de la muestra existente. En la
tercera forma, varficticia debe ser una variable de señalización con
valores 0 o 1 en cada observación; así la muestra se va a restringir a las
observaciones en las que el valor es 1. La cuarta forma, que utiliza
--restrict, restringe la muestra a las observaciones que cumplen la
condición booleana que se indica (y que se especifica de acuerdo con la
sintaxis de la instrucción "genr").

Puedes emplear las opciones --no-missing y --no-all-missing para excluir de
la muestra aquellas observaciones para las que hay ausencia de datos. La
primera variante excluye aquellas filas del conjunto de datos para las que,
por lo menos una variable, tiene un valor ausente; mientras que la segunda
variante excluye únicamente aquellas filas en las que todas las variables
tienen valores ausentes. En cada caso, la comprobación se limita a las
variables de listavariables cuando indicas este argumento; de lo contrario,
se aplica a todas las series (con la reserva de que, en caso de no tener
listavariables e indicar --no-all-missing, las variables genéricas index y
time se ignoran).

La opción --contiguous de smpl está pensada para usar con datos de series
temporales. Su efecto consiste en recortar cualquier observación al
comienzo y al final del rango de la muestra vigente que contenga valores
ausentes (bien para las variables de listavariables, o bien para todas las
series de datos si no indicas listavariables). Entonces se realiza una
verificación para comprobar si hay algún valor ausente en el rango que
queda; y si es así, se muestra un fallo.

Con la opción --random, el número de casos especificado se escoge
aleatoriamente del conjunto vigente de datos (sin substitución). Si quieres
ser capaz de replicar esa selección, debes establecer primero la semilla
para el generador de números aleatorios (consulta la instrucción "set").

La forma final (smpl full) restablece el rango completo de datos.

Ten en cuenta que las restricciones muestrales son, por defecto,
acumulativas; es decir, el punto de partida de cualquier instrucción smpl
es la muestra vigente. Si quieres que la instrucción actúe substituyendo
cualquier restricción ya existente, puedes añadir el indicador de opción
--replace al final de la instrucción. (Pero esta opción no es compatible
con la opción --contiguous.)

Puedes utilizar la variable interna obs junto con la opción --restrict de
smpl para excluir observaciones concretas de la muestra. Por ejemplo

	smpl obs!=4 --restrict

va a prescindir únicamente de la cuarta observación. Si los casos de los
datos se identifican mediante etiquetas,

	smpl obs!="USA" --restrict

va a prescindir de la observación con la etiqueta "USA".

Debe apuntarse una cuestión en relación a las opciones --dummy, --restrict
y --no-missing de la instrucción smpl: la información "estructural" del
archivo de datos (relacionada con la naturaleza de series de tiempo o de
panel, de los datos) probablemente se va a perder cuando se ejecute esta
instrucción; pero puedes volver a imponer la estructura con la instrucción
"setobs". Para utilizar con datos de panel, una opción relacionada es
--balanced, que pide que se reconstruya un panel equilibrado luego de
extraer una submuestra, mediante la inserción de "filas ausentes", si es
necesario. Pero ten en cuenta que no siempre es posible cumplir esta
petición.

La opción --unit es específica para datos de panel, y te permite indicar
directamente un rango de "individuos" en la dimensión atemporal de ese tipo
de datos. Por ejemplo:

	# Limita la muestra a los primeros 50 individuos en esa dimensión
	smpl 1 50 --unit

Por defecto, puedes deshacer las limitaciones que establezcas sobre el rango
de la muestra vigente, pues ejecutando smpl full puedes restaurar el
conjunto de datos completo. Sin embargo, puedes utilizar la opción
--permanent para sustituir el conjunto de datos restringido en lugar del
original. El efecto de indicar la opción --permanent sin otros argumentos
ni opciones, es el de reducir la base de datos al rango de la muestra
vigente.

Consulta El manual de gretl (Capítulo 5) para obtener otros detalles.

Menú gráfico: /Muestra

# spearman Statistics

Argumentos: serie1 serie2 
Opción:     --verbose (Presenta los datos por rangos)

Presenta el coeficiente de la correlación por rangos de Spearman para las
series serie1 y serie2. No tienes que jerarquizar manualmente las variables
por adelantado, pues la función ya se ocupa de ello.

La forma automática de jerarquizar es de mayor a menor (i.e. el valor más
grande de los datos adquiere el rango 1). Si necesitas invertir esta forma
de jerarquizar, genera una nueva variable que sea la negativa de la
original. Por ejemplo:

	series altx = -x
	spearman altx y

Menú gráfico: /Herramientas/Contrastes no paramétricos/Correlación

# sprintf Printing

Instrucción obsoleta: utiliza en su lugar la función con el mismo nombre,
"sprintf".

# square Transformations

Argumento:  listavariables 
Opción:     --cross (Genera los productos cruzados así como los cuadrados)

Genera nuevas series que son los cuadrados de las series de listavariables
(además de las variables con los productos cruzados entre cada dos, cuando
indicas la opción --cross). Por ejemplo, "square x y" va a generar las
variables sq_x = x al cuadrado, sq_y = y al cuadrado y (opcionalmente con
'cross') x_y = x por y. Cuando una determinada variable es una variable
ficticia, no se calcula su cuadrado pues obtendríamos la misma variable.

Menú gráfico: /Añadir/Cuadrados de las variables seleccionadas

# stdize Transformations

Argumento:  listavar 
Opciones:   --no-df-corr (Sin corrección de grados de libertad)
            --center-only (Sin dividir por desviación típica)

Por defecto, se obtiene una versión tipificada de cada una de las variables
de listavar, y cada resultado se guarda en una nueva serie con el prefijo
s_. Por ejemplo, la expresión "stdize x y" crea las nuevas series s_x y
s_y, cada una como resultado de centrar y dividir la original por su
desviación típica muestral (con la corrección de 1, en los grados de
libertad).

Cuando indicas la opción --no-df-corr, no se aplica ninguna corrección de
los graos de libertad en la desviación típica que se utiliza; será el
estimador máximo-verosímil. Si indicas la opción --center-only, las
series resultan de únicamente restar la media y, en ese caso, los nombres
de las resultantes tendrán el prefijo c_ en lugar de s_.

La funcionalidad de esta instrucción está disponible de forma en cierto
modo más flexible, mediante la función "stdize".

Menú gráfico: /Añadir/Tipificar las variables seleccionadas

# store Dataset

Argumentos: nombrearchivo [ listavariables ] 
Opciones:   --csv (Utiliza el formato CSV)
            --omit-obs (Mira abajo, sobre el formato CSV)
            --no-header (Mira abajo, sobre el formato CSV)
            --gnu-octave (Utiliza el formato GNU Octave)
            --gnu-R (Formato tratable con read.table)
            --gzipped[=nivel] (Aplica la compresión gzip)
            --jmulti (Utiliza el formato ASCII JMulti)
            --dat (Utiliza el formato ASCII PcGive)
            --decimal-comma (Utiliza la coma como carácter decimal)
            --database (Utiliza el formato de base de datos de Gretl)
            --overwrite (Mira abajo, sobre el formato de base de datos)
            --comment=cadena (Mira abajo)

Guarda los datos en nombrearchivo. Por defecto, se guardan todas las series
ya definidas en ese momento, pero puedes utilizar el argumento
listavariables (opcional) para escoger un subconjunto de series. Si el
conjunto de datos es una submuestra, solo se guardan las observaciones del
rango vigente de la muestra.

El archivo resultante va a escribirse en el directorio ("workdir")
establecido en ese momento, excepto que la cadena nombrearchivo contenga una
especificación completa de la ruta.

Hasta cierto punto, puedes controlar el formato en el que se escriben los
datos mediante la extensión o sufijo de nombrearchivo, como se indica a
continuación:

  .gdt (o sin extensión): Formato de datos XML propio de Gretl. (Si no
  indicas ninguna extensión, automáticamente se añade ".gdt")

  .gtdb: Formato de datos binario propio de Gretl.

  .csv: Valores Separados por Comas (CSV).

  .txt o .asc: valores separados por espacios.

  .m: Formato matricial GNU Octave.

  .dta: Formato dta de Stata (versión 113).

Puedes usar los indicadores de opción relacionados con el formato que se
muestran arriba para forzar la cuestión del formato cuando se guarda, con
independencia del nombre del archivo (o para lograr que Gretl escriba en los
formatos de PcGive o JMulTi). Sin embargo, si nombrearchivo tiene una
extensión .gdt o .gdtb, esto implica utilizar necesariamente el formato
propio, y si añades un indicador de opción conflictivo, va a generarse un
fallo.

Cuando guardas los datos en el formato propio (únicamente), puedes utilizar
la opción --gzipped para comprimir los datos, lo que puede ser muy útil
para conjuntos grandes de datos. El parámetro (opcional) de esta opción
controla el nivel de compresión (de 0 a 9): los niveles más altos producen
un archivo más pequeño, pero la compresión lleva más tiempo. El nivel
por defecto es 1, y un nivel igual a 0 significa que no se aplica ninguna
compresión.

Los indicadores de opción --omit-obs y --no-header son solo aplicables
cuando se guardan datos en el formato CSV. Por defecto, si los datos son
series temporales o de panel, o si el conjunto de datos incluye marcadores
específicos de observación, el archivo CSV incluye una primera columna que
identifica las observaciones (e.g. por fecha). Cuando indicas la opción
--omit-obs, esta columna se omite. La opción --no-header elimina la
habitual representación de los nombres de las variables en el
encabezamiento de las columnas.

El indicador de opción --decimal-comma está también limitado al caso de
que se guarden los datos en formato CSV. El efecto de esta opción consiste
en substituir el punto decimal con la coma decimal; y, por añadido, se
fuerza a que el separador de columnas sea el punto y coma.

La posibilidad de guardar en el formato de base de datos de Gretl está
pensada para ayudar a construir conjuntos largos de series, tal vez
mezclando frecuencias y rangos de observaciones. En este momento, esta
opción solo está disponible para datos de series temporales de tipo anual,
trimestral o mensual. Si guardas en un archivo que ya existe, el efecto por
defecto consiste en añadir las series recientemente guardadas al contenido
existente en la base de datos. En este contexto, es un fallo que una (o
más) de las variables que se van a guardar tenga el mismo nombre que una
variable que ya está presente en la base de datos. La opción --overwrite
tiene como consecuencia que, si hay nombres de variables en común, la
variable recientemente guardada substituye a la variable del mismo nombre en
el conjunto de datos original.

La opción --comment está disponible cuando se guardan datos como base de
datos o en formato CSV. El parámetro que se requiere es una cadena en una
línea, entre comillas, ligada al indicador de opción mediante un signo de
igualdad. La cadena de texto se inserta como comentario en el archivo
índice de la base de datos o en el encabezamiento del CSV.

La instrucción store se comporta de modo especial en el contexto de un
"bucle progresivo". Consulta El manual de gretl (Capítulo 12) para obtener
más detalles.

Menú gráfico: /Archivo/Guardar datos; /Archivo/Exportar datos

# summary Statistics

Variantes:  summary [ listavariables ]
            summary --matrix=nombrematriz
Opciones:   --simple (Solo estadísticos básicos)
            --weight=wvar (Variable de ponderación)
            --by=byvar (Mira abajo)
Ejemplos:   frontier.inp

En su primera forma, esta instrucción presenta un resumen estadístico de
las variables de listavariables, o de todas las variables del conjunto de
datos cuando omites listavariables. Por defecto, el resultado consiste en la
media, desviación típica (sd), coeficiente de variación (= sd/media),
mediana, mínimo, máximo, coeficiente de asimetría y exceso de curtosis.
Cuando indicas la opción --simple, el resultado se limita a la media, el
mínimo, el máximo y la desviación típica.

Cuando indicas la opción --by (en cuyo caso el parámetro byvar debe ser el
nombre de una variable discreta), entonces se presentan los estadísticos
para las submuestras que se corresponden con los diferentes valores que toma
byvar. Por ejemplo, cuando byvar es una variable ficticia (binaria), se
presentan los estadísticos para los casos en los que byvar = 0 y byvar = 1.
Advertencia: En este momento, esta opción es incompatible con la opción
--weight.

Cuando indicas la forma alternativa, utilizando una matriz ya definida,
entonces se presenta el resumen estadístico para cada columna de la matriz.
En este caso, la opción --by no está disponible.

Puedes obtener, en forma de matriz, la tabla de estadísticos generada con
la instrucción summary, por medio del accesor "$result".

Menú gráfico: /Ver/Estadísticos principales
Otro acceso:  Ventana principal: Menú emergente

# system Estimation

Variantes:  system method=estimador
            sysname <- system
Ejemplos:   "Klein Model 1" <- system
            system method=sur
            system method=3sls
            Ver también klein.inp, kmenta.inp, greene14_2.inp

Empieza un sistema de ecuaciones. Puedes indicar una de las dos formas de la
instrucción, dependiendo de si quieres guardar el sistema para estimarlo de
varias formas, o solo estimar el sistema una vez.

Para guardar el sistema debes asignarle un nombre como en el primer ejemplo
(si el nombre contiene espacios, debes delimitarlo con comillas). En este
caso, se estima el sistema utilizando la instrucción "estimate". Con un
sistema de ecuaciones ya guardado, puedes imponer restricciones (incluidas
restricciones entre ecuaciones) utilizando la instrucción "restrict".

Como alternativa, puedes especificar un estimador para el sistema utilizando
method= seguido de una cadena que identifique uno de los estimadores
admitidos: "ols" (Mínimos Cuadrados Ordinarios), "tsls" (Mínimos Cuadrados
en 2 Etapas) "sur" (Regresiones Aparentemente No Relacionadas), "3sls"
(Mínimos Cuadrados en 3 Etapas), "fiml" (Máxima Verosimilitud con
Información Total) o "liml" (Máxima Verosimilitud con Información
Limitada). En este caso, el sistema se estima una vez que esté completa su
definición.

Un sistema de ecuaciones se termina con la línea "end system". Dentro del
sistema pueden indicarse 4 tipos de enunciado, como los siguientes.

  "equation": Especifica una ecuación del sistema.

  "instr": Para estimar un sistema mediante Mínimos Cuadrados en 3 etapas,
  se indica una lista de instrumentos (mediante el nombre de la variable o
  su número). Alternativamente, puedes poner esta información en la línea
  "equation" usando la misma sintaxis que en la instrucción "tsls".

  "endog": Para un sistema de ecuaciones simultáneas, se indica una lista
  de variables endógenas. En principio, esto está pensado para utilizar
  con la estimación FIML, pero puedes utilizar este enfoque con Mínimos
  Cuadrados en 3 Etapas en lugar de indicar una lista "instr"; y entonces
  todas las variables que no se identifiquen como endógenas, se van a
  utilizar como instrumentos.

  "identity": Para utilizar con Máxima Verosimilitud con Información
  Completa (MVIC, FIML), se indica una identidad que enlaza dos o más
  variables del sistema. Este tipo de enunciado se ignora cuando se utiliza
  un estimador diferente al de MVIC.

Después de hacer la estimación utilizando las instrucciones "system" o
"estimate", puedes usar los siguientes accesorios para recoger información
adicional:

  $uhat: Matriz con los errores de estimación, con una columna por
  ecuación.

  $yhat: Matriz con los valores ajustados, con una columna por ecuación.

  $coeff: Vector columna con los coeficientes de las ecuaciones (todos los
  coeficientes de la primera ecuación, seguidos por los de la segunda
  ecuación, etcétera).

  $vcv: Matriz con las covarianzas entre los coeficientes. Cuando hay k
  elementos en el vector $coeff, esta matriz tiene una dimensión de k por
  k.

  $sigma: Matriz con las covarianzas entre los errores de estimación de las
  ecuaciones cruzadas.

  $sysGamma, $sysA y $sysB: Matrices con los coeficientes en la forma
  estructural (mira abajo).

Si quieres recuperar los errores de estimación o los valores ajustados para
una ecuación en concreto, en forma de serie de datos, escoge una columna de
la matriz $uhat o $yhat, y asígnale la serie como en

	series uh1 = $uhat[,1]

Las matrices en la forma estructural se corresponden con la siguiente
representación de un modelo de ecuaciones simultáneas:

  Gamma y(t) = A y(t-1) + B x(t) + e(t)

Si hay n variables endógenas y k variables exógenas, Gamma es una matriz
de dimensión n x n y B es n x k. Cuando el sistema no contiene ningún
retardo de las variables endógenas, entonces la matriz A no está presente.
Si el retardo máximo de un regresor endógeno es p, la matriz A es de
dimensión n x np.

Menú gráfico: /Modelo/Ecuaciones simultáneas

# tabprint Printing

Opciones:   --output=nombrearchivo (Envía el resultado al archivo especificado)
            --format="f1|f2|f3|f4" (Especifica el formato TeX personalizado)
            --complete (Relacionado con TeX, mira abajo)

Debe ir después de la estimación de un modelo y presenta ese modelo en
formato de tabla. El formato se rige por la extensión del nombrearchivo
especificado: ".tex" para LaTeX, ".rtf" para RTF (Microsoft's Rich Text
Format) o ".csv" para el formato con separación mediante comas. El archivo
resultante va a escribirse en el directorio vigente ("workdir"), excepto que
la cadena nombrearchivo contenga una especificación completa de la ruta.

Cuando seleccionas el formato CSV, los valores se separan con comas excepto
que la coma decimal esté en vigor, en cuyo caso el separador es el punto y
coma.

Opciones específicas de resultados en LaTeX

Cuando indicas la opción --complete, el archivo LaTeX es un documento
completo, listo para procesar; de lo contrario, debe incluirse en un
documento.

Si quieres modificar la apariencia del resultado tabular, puedes especificar
un formato personalizado en filas utilizando la opción --format. La cadena
de formato debe estar puesta entre comillas y debe estar ligada a la opción
con un signo de igualdad. El patrón para las cadenas de formato es el
siguiente. Existen 4 campos que representan: el coeficiente, la desviación
típica, el ratio t y la probabilidad asociada, respectivamente. Debes
separar estos campos mediante barras verticales; y, o bien pueden tener una
especificación de tipo printf para el formato del valor numérico en
cuestión, o bien pueden dejarse en blanco para eliminar la presentación de
esa columna (sujeto esto a la condición de que no puedes dejar todas las
columnas en blanco). Aquí tienes unos pocos ejemplos:

	--format="%.4f|%.4f|%.4f|%.4f"
	--format="%.4f|%.4f|%.3f|"
	--format="%.5f|%.4f||%.4f"
	--format="%.8g|%.8g||%.4f"

La primera de estas especificaciones presenta los valores de todas las
columnas usando 4 dígitos decimales. La segunda elimina la probabilidad
asociada y presenta las razones t con 3 dígitos decimales. La tercera omite
el ratio t. La última también omite el t, y presenta tanto el coeficiente
como la desviación típica con 8 cifras significativas.

Una vez que estableces un formato personalizado de este modo, este se
recuerda y se utiliza a lo largo de lo que dure la sesión de Gretl. Para
revertir esto al formato por defecto, puedes utilizar la variante especial
--format=default.

Menú gráfico: Ventana de modelo: LaTeX

# textplot Graphs

Argumento:  listavariables 
Opciones:   --time-series (Gráfico por observación)
            --one-scale (Fuerza una escala única)
            --tall (Usa 40 filas)

Gráficos ASCII rápidos y sencillos. Sin la opción --time-series,
listavariables debe contener al menos 2 series, la última de ellas se toma
como la variable para el eje x, y se genera un gráfico de dispersión. En
este caso, puedes utilizar la opción --tall para generar un gráfico en la
que el eje y se representa mediante 40 filas de caracteres (por defecto son
20 filas).

Con la opción --time-series, se genera un gráfico por observación. En
este caso, puedes utilizar la opción --one-scale para forzar el uso de una
escala única; de lo contrario, si listavariables contiene más de una
serie, los datos pueden escalarse. Cada línea representa una observación,
con los valores de los datos dibujados horizontalmente.

Consulta también "gnuplot".

# tobit Estimation

Argumentos: depvar indepvars 
Opciones:   --llimit=cotaizq (Especifica la cota de la izquierda)
            --rlimit=cotader (Especifica la cota de la derecha)
            --vcv (Presenta la matriz de covarianzas)
            --robust (Desviaciones típicas robustas)
            --opg (Mira más abajo)
            --cluster=clustvar (Consulta "logit" para más explicaciones)
            --verbose (Presenta los detalles de las iteraciones)
            --quiet (No presenta los resultados)

Estima un modelo Tobit, que puede ser lo adecuado cuando la variable
dependiente está "censurada". Por ejemplo, cuando se observan valores
positivos y nulos en la adquisición de bienes duraderos por parte de los
hogares, y ningún valor negativo, puede llegar a pensarse que las
decisiones sobre esas compras son el resultado de una disposición
subyacente e inobservada a comprar, que puede ser negativa en algunos casos.

Por defecto, se asume que la variable dependiente está 'censurada' en el
cero por la izquierda, y que no está 'censurada' por la derecha. Sin
embargo, puedes usar las opciones --llimit y --rlimit para especificar un
patrón diferente para hacer la 'censura'. Ten en cuenta que si especificas
únicamente una cota por la derecha, entonces lo que se supone es que la
variable dependiente no está 'censurada' por la izquierda.

El modelo Tobit es un caso especial de la regresión de intervalos. Consulta
la instrucción "intreg" para obtener detalles adicionales, incluída una
explicación de las opciones --robust y --opg.

Menú gráfico: /Modelo/Variable dependiente limitada/Tobit

# tsls Estimation

Argumentos: depvar indepvars ; instrumentos 
Opciones:   --no-tests (No hace contrastes de diagnóstico)
            --vcv (Presenta la matriz de covarianzas)
            --quiet (No presenta los resultados)
            --no-df-corr (Sin corrección de los grados de libertad)
            --robust (Desviaciones típicas robustas)
            --cluster=clustvar (Desviaciones típicas agrupadas)
            --liml (Utiliza Máxima Verosimilitud con Información Limitada)
            --gmm (Utiliza el Método Generalizado de los Momentos)
Ejemplos:   tsls y1 0 y2 y3 x1 x2 ; 0 x1 x2 x3 x4 x5 x6
            Ver también penngrow.inp

Calcula las estimaciones de Variables Instrumentales (VI), utilizando por
defecto Mínimos Cuadrados en 2 Etapas (TSLS), pero mira más abajo para
otras opciones. La variable dependiente es depvar, mientras que indepvars
expresa una lista de regresores (se presupone que incluye al menos una
variable endógena), e instrumentos indica una lista de instrumentos
(variables exógenas y/o predeterminadas). Si la lista instrumentos no es al
menos tan larga como indepvars, el modelo no está identificado.

En el ejemplo de arriba, las ys son las variables endógenas y las xs son
las variables exógenas. Ten en cuenta que los regresores exógenos deben
aparecer en ambas listas.

El resultado de las estimaciones de Mínimos Cuadrados en 2 Etapas incluyen
el contraste de Hausman y (si el modelo está sobreidentificado) el
contraste de sobreidentificación de Sargan. En el contraste de Hausman, la
hipótesis nula es que las estimaciones MCO son consistentes o, en otras
palabras, que la estimación por medio de variables instrumentales en
realidad no es necesaria. Un modelo de este tipo está sobreidentificado si
hay más instrumentos de los que estrictamente se requieren. El contraste de
Sargan se basa en una regresión auxiliar de los errores de la estimación
del modelo por Mínimos Cuadrados en 2 Etapas sobre la lista completa de
instrumentos. La hipótesis nula es que todos los instrumentos son válidos,
y se sospecha de la validez de esta hipótesis si la regresión auxiliar
tiene un grado de poder explicativo que es significativo. Para una buena
explicación de los dos contrastes, consulta el capítulo 8 de Davidson y
MacKinnon (2004).

Tanto para MC2E (TSLS) como para la estimación MVIL (LIML), se muestra el
resultado de un contraste adicional, puesto que el modelo se estima bajo el
supuesto de perturbaciones IID (es decir, no se escoge la opción --robust).
Este es un contraste de la debilidad de los instrumentos, pues instrumentos
débiles pueden llevar a serios problemas en la regresión de VI:
estimaciones sesgadas y/o tamaño incorrecto de los contrastes de hipótesis
basados en la matriz de covarianzas, con tasas de rechazo que superan mucho
el nivel de significación nominal (Stock, Wright y Yogo, 2002). El
estadístico es el del contraste F de la primera etapa si el modelo tiene
tan solo un regresor endógeno; de lo contrario, es el valor propio más
pequeño de la matriz de contrapartida del F de la primera etapa. Se
muestran los puntos críticos basados en el análisis Monte Carlo de Stock y
Yogo (2003), cuando estén disponibles.

El valor de R-cuadrado que se presenta para modelos estimados mediante
Mínimos Cuadrados en 2 Etapas es el cuadrado de la correlación entre la
variable dependiente y la variable con los valores ajustados.

Para obtener más detalles en relación a los efectos de las opciones
--robust y --cluster, consulta la ayuda para "ols".

Como alternativas a MC2E, el modelo puede estimarse mediante Máxima
Verosimilitud con Información Limitada (opción --liml) o mediante el
Método Generalizado de los Momentos (opción --gmm). Ten en cuenta que, si
el modelo está simplemente identificado, estos métodos deberían generar
los mismos resultados que MC2E; pero si está sobreidentificado, los
resultados en general van a diferir.

Cuando se escoge la estimación MGM (GMM), las siguientes opciones
adicionales pasan a estar disponibles:

  --two-step: Realiza MGM en 2 etapas en lugar de hacerlo en 1 etapa (por
  defecto).

  --iterate: Reitera MGM hasta la convergencia.

  --weights=Wmat: Especifica una matriz cuadrada de ponderaciones para
  utilizar cuando se calcula la función del criterio MGM. La dimensión de
  esta matriz debe ser igual al número de instrumentos. Por defecto, es una
  matriz identidad de dimensión adecuada.

Menú gráfico: /Modelo/Variables instrumentales

# var Estimation

Argumentos: orden ylista [ ; xlista ] 
Opciones:   --nc (Sin constante)
            --trend (Con tendencia lineal)
            --seasonals (Con variables ficticias estacionales)
            --robust (Desviaciones típicas robustas)
            --robust-hac (Desviaciones típicas HAC)
            --quiet (No muestra los resultados de las ecuaciones individuales)
            --silent (No presenta nada)
            --impulse-responses (Presenta las respuestas al impulso)
            --variance-decomp (Presenta las descomposiciones de la varianza)
            --lagselect (Muestra los criterios de selección de retardos)
Ejemplos:   var 4 x1 x2 x3 ; time mydum
            var 4 x1 x2 x3 --seasonals
            var 12 x1 x2 x3 --lagselect
            Ver también sw_ch14.inp

Establece y estima (utilizando MCO) una autorregresión de vectores (VAR).
El primer argumento especifica el orden de retardos (o el orden máximo de
retardos, en caso de que indiques la opción --lagselect, mira más abajo).
El orden puedes indicarlo numéricamente o con el nombre de una variable
escalar preexistente. A continuación sigue la configuración de la primera
ecuación. No incluyas retardos entre los elementos de ylista pues se van a
añadir automáticamente. El punto y coma va a separar las variables
estocásticas (para las que se va a incluir un orden de retardos) de
cualquier variable exógena de xlista. Ten en cuenta que: (a) se incluye una
constante automáticamente (excepto que indiques la opción --nc), (b)
puedes añadir una tendencia con la opción --trend, y (c) puedes añadir
variables ficticias estacionales utilizando la opción --seasonals.

Mientras que una especificación VAR habitualmente incluye todos los
retardos desde 1 hasta el máximo que indiques, también puedes escoger un
grupo de retardos. Para hacer esto, substituye el argumento rutinario orden
(escalar), bien con el nombre de un vector ya definido previamente, o bien
con una lista de retardos separados con comas y colocada entre llaves.
Debajo se muestran dos modos de especificar que un VAR debe incluir los
retardos 1, 2 y 4 (pero no el 3):

	var {1,2,4} ylista
	matrix p = {1,2,4}
	var p ylista

Se desenvuelve una regresión por separado para cada una de las variables de
ylista. Los resultados para cada ecuación incluyen los contrastes F para
restricciones cero en todos los retardos de cada una de las variables, un
contraste F sobre la significación del retardo máximo y, cuando
especificas la opción --impulse-responses, las descomposiciones de la
varianza de la predicción y las respuestas al impulso.

Las descomposiciones de la varianza de la predicción y las respuestas al
impulso se basan en la descomposición de Cholesky de la matriz de
covarianzas contemporánea y, en este contexto, tiene importancia el orden
en el que indicas las variables (estocásticas). Así, la primera variable
de la lista se asume que es la "más exógena" dentro del período. Puedes
establecer el horizonte para las descomposiciones de la varianza y las
respuestas al impulso, utilizando la instrucción "set". Para recuperar una
función concreta de respuesta al impulso en forma matricial, consulta la
función "irf".

Cuando indicas la opción --robust, las desviaciones típicas se corrigen
del efecto de la heterocedasticidad. Como alternativa, puedes indicar la
opción --robust-hac para dar lugar a desviaciones típicas que sean
robustas con respecto tanto a la heterocedasticidad como a la
autocorrelación (HAC). En general, esta última corrección no debiera de
ser necesaria si el VAR incluye un número suficiente de retardos.

Cuando indicas la opción --lagselect, se toma el primer parámetro de la
instrucción var como el orden máximo de retardos. El resultado consiste en
una tabla que muestra los valores de los criterios de información de Akaike
(AIC), Schwarz (BIC) y Hannan-Quinn (HQC) calculados con VARs de órdenes
desde 1 hasta el máximo indicado. Esto trata de ayudar en la selección del
orden óptimo de retardos. El resultado habitual del VAR no se presenta.
Puedes recuperar la tabla con los criterios de información en forma de
matriz mediante el accesorio "$test".

Menú gráfico: /Modelo/Series temporales multivariantes

# varlist Dataset

Opción:     --type=nombretipo (Campo del listado)

Por defecto, presenta un listado de las series del conjunto vigente de datos
(si hay alguna); y puedes utilizar "ls" como alias.

Cuando indicas la opción --type, debe ir seguida (después de un signo de
igualdad) por uno de los siguientes tipos: series, scalar, matrix, list,
string, bundle o accessor. Su efecto consiste en presentar los nombres de
todos los objetos del tipo indicado que estén definidos en ese momento.

Como caso especial, si el tipo es accessor, los nombres que se presentan son
aquellos de las variables internas disponibles en ese momento como
"accesorios", como pueden ser "$nobs" y "$uhat" (sea cual sea su tipo en
concreto).

# vartest Tests

Argumentos: serie1 serie2 

Calcula el estadístico F para contrastar la hipótesis nula de que las
varianzas poblacionales de las variables serie1 y serie2 son iguales, y
muestra su probabilidad asociada (valor p).

Menú gráfico: /Herramientas/Calculadora de estadísticos de contraste

# vecm Estimation

Argumentos: orden rango ylista [ ; xlista ] [ ; rxlista ] 
Opciones:   --nc (Sin constante)
            --rc (Constante restringida)
            --uc (Constante no restringida)
            --crt (Constante y tendencia restringida)
            --ct (Constante y tendencia no restringida)
            --seasonals (Incluye variables ficticias estacionales centradas)
            --quiet (No muestra los resultados de las ecuaciones individuales)
            --silent (No presenta nada)
            --impulse-responses (Presenta las respuestas al impulso)
            --variance-decomp (Presenta las descomposiciones de la varianza)
Ejemplos:   vecm 4 1 Y1 Y2 Y3
            vecm 3 2 Y1 Y2 Y3 --rc
            vecm 3 2 Y1 Y2 Y3 ; X1 --rc
            Ver también denmark.inp, hamilton.inp

Un VECM es una forma de autorregresión de vectores o VAR (consulta "var"),
aplicable cuando las variables del modelo son individualmente integradas de
orden 1 (por lo tanto son paseos aleatorios, con o sin deriva) pero
presentan cointegración. Esta instrucción está íntimamente relacionada
con el contraste de cointegración de Johansen (consulta "coint2").

El parámetro orden de esta instrucción representa el orden de retardos del
sistema VAR. El número de retardos en el propio VECM (donde la variable
dependiente se indica como una primera diferencia) es de uno menos que
orden.

El parámetro rango representa el rango de cointegración o, en otras
palabras, el número de vectores cointegrantes. Este debe ser mayor que
cero, y menor o igual (generalmente menor) que el número de variables
endógenas indicadas en ylista.

El argumento ylista proporciona la lista de variables endógenas, expresadas
en niveles. La inclusión de términos de tipo determinístico en el modelo,
se controla con los indicadores de opción. Por defecto, cuando no indicas
ninguna opción, se incluye una "Constante no restringida", lo que permite
que haya una ordenada en el origen no nula en las relaciones de
cointegración, así como una tendencia en los niveles de las variables
endógenas. La literatura derivada del trabajo de Johansen (por ejemplo,
puedes consultar su libro de 1995) habitualmente se refiere a esto como el
"caso 3". Las primeras 4 opciones indicadas arriba (mutuamente excluyentes)
generan los casos 1, 2, 4 y 5, respectivamente. Los significados de estos
casos y los criterios que se usan para escoger un caso, se explican en El
manual de gretl (Capítulo 31).

Las listas (opcionales) xlista y rxlista te permiten especificar conjuntos
de variables exógenas que forman parte del modelo, bien sin restricciones
(xlista) o bien restringidas al espacio de cointegración (rxlista). Estas
listas se separan de ylista y unas de las otras, mediante punto y coma.

La opción --seasonals, que puedes combinar con cualquiera de las otras
opciones, especifica la inclusión de un conjunto de variables ficticias
estacionales centradas. Esta opción únicamente está disponible para datos
trimestrales o mensuales.

El primer ejemplo de arriba especifica un VECM, con un orden de retardos de
4 y un único vector de cointegración. Las variables endógenas son Y1, Y2
e Y3. El segundo ejemplo usa las mismas variables pero especifica un orden
de retardos de 3, y dos vectores de cointegración; también especifica una
"Constante restringida", que es adecuada cuando los vectores de
cointegración pueden tener ordenada en el origen no nula pero las variables
Y no tienen tendencia.

A continuación de la estimación de un VECM, tienes disponibles algunos
accesorios especiales: $jalpha, $jbeta y $jvbeta recuperan las matrices α y
beta, y la varianza estimada de beta, respectivamente. Para recuperar la
función de respuesta ante un impulso determinado, en forma de matriz,
consulta la función "irf".

Menú gráfico: /Modelo/Series temporales multivariantes

# vif Tests

Opción:     --quiet (No presenta nada)
Ejemplos:   longley.inp

Debe ir después de la estimación de un modelo que incluya al menos 2
variables independientes. Calcula y muestra información de diagnóstico
relacionada con la multicolinealidad.

El Factor de Inflación de la Varianza (FIV) del regresor j se define como

  1/(1 - Rj^2)

donde R_j es el coeficiente de correlación múltiple entre ese regresor j y
los demás regresores. El factor tiene un valor mínimo de 1.0 cuando la
variable en cuestión es ortogonal con respecto a las otras variables
independientes. Neter, Wasserman y Kutner (1990) sugieren revisar el valor
más grande de los FIV para diagnosticar un alto grado de multicolinealidad;
así, un valor mayor que 10 se considera a veces indicativo de un grado de
multicolinealidad problemático.

Después de utilizar esta instrucción, puedes usar el accesor "$result"
para obtener un vector columna que incluya los FIV. Para tener un enfoque
más sofisticado para diagnosticar la multicolinealidad, consulta la
instrución "bkw".

Menú gráfico: Ventana de modelo: Análisis/Colinealidad

# wls Estimation

Argumentos: varponder depvar indepvars 
Opciones:   --vcv (Presenta la matriz de covarianzas)
            --robust (Desviaciones típicas robustas)
            --quiet (No presenta los resultados)

Calcula las estimaciones de mínimos cuadrados ponderados (MCP o WLS)
utilizando varponder como ponderación, depvar como variable dependiente e
indepvars como lista de variables independientes. Sea w la raíz cuadrada
positiva de varponder, entonces MCP es básicamente equivalente a la
regresión MCO de w * depvar sobre w * indepvars. Sin embargo, el R-cuadrado
se calcula de modo especial, concretamente como

  R^2 = 1 - ESS / WTSS

donde ESS es la suma de errores cuadrados de la regresión ponderada, y WTSS
denota la "Suma de cuadrados totales ponderados", que es igual a la suma de
errores cuadrados de la regresión de la variable dependiente ponderada
sobre únicamente la constante ponderada.

Si varponder es una variable ficticia, la estimación MCP es equivalente a
la que resulta al eliminar todas las observaciones que tienen un valor de
cero para varponder.

Para aplicar la estimación de Mínimos Cuadrados Ponderados a datos de
panel, basada en las varianzas del error específico de cada unidad,
consulta la instrucción "panel" junto con la opción --unit-weights.

Menú gráfico: /Modelo/Otros modelos lineales/Mínimos cuadrados ponderados

# xcorrgm Statistics

Argumentos: serie1 serie2 [ orden ] 
Opciones:   --plot=modo-o-nombrearchivo (Mira abajo)
            --quiet (No presenta el gráfico)
Ejemplo:    xcorrgm x y 12

Presenta y dibuja el correlograma cruzado de serie1 con serie2, las que
puedes especificar mediante sus nombres o sus números. Los valores son los
coeficientes de correlación muestrales entre el valor vigente de serie1 y
los sucesivos adelantos y retardos de serie2.

Si especificas un valor para orden, la longitud del correlograma cruzado se
limita a ese número de adelantos y retardos (al menos); de lo contrario, la
longitud se determina de forma automática en función de la frecuencia de
los datos y del número de observaciones.

Por defecto, se genera un gráfico del correlograma cruzado: un gráfico
Gnuplot en modo interactivo o un gráfico ASCII en modo de procesamiento por
lotes. Puedes ajustar esto mediante la opción --plot. Los parámetros
admisibles para esta opción son none (para omitir el gráfico), ascii (para
generar un gráfico de texto aunque sea en modo interactivo), display (para
generar un gráfico Gnuplot aunque sea en modo de procesamiento por lotes),
o un nombre de archivo. El efecto de proporcionar un nombre de archivo es
como se describió para la opción --output de la instrucción "gnuplot".

Menú gráfico: /Ver/Correlograma cruzado
Otro acceso:  Ventana principal: Menú emergente (tras selección múltiple)

# xtab Statistics

Argumentos: ylista [ ; xlista ] 
Opciones:   --row (Muestra los porcentajes de fila)
            --column (Muestra los porcentajes de columna)
            --zeros (Muestra un cero en las entradas nulas)
            --no-totals (Elimina la presentación de los recuentos marginales)
            --matrix=nombrematr (Usa las frecuencias de la matriz indicada)
            --quiet (Consulta el caso bivariante de abajo)
            --tex[=nombrearchivo] (Salida como LaTeX)
            --equal (Consulta el caso LaTeX más abajo)
Ejemplos:   xtab 1 2
            xtab 1 ; 2 3 4
            xtab --matrix=A
            xtab 1 2 --tex="xtab.tex"
            Ver también ooballot.inp

Muestra una tabla de contingencia o una tabulación cruzada para cada
combinación de las variables incluidas en ylista; y cuando indicas una
segunda lista (xlista), cada variable de ylista se cruza en una tabla por
fila frente a cada variable de xlista (por columna). Puedes referirte a las
variables de estas listas mediante sus nombres o sus números. Ten en cuenta
que todas las variables tienen que estar marcadas como discretas. Como
alternativa, cuando indicas la opción --matrix, se trata la matriz indicada
como un conjunto calculado previamente de frecuencias a presentar como
tabulación cruzada (consulta también la función "mxtab"). En este caso
deberás omitir el argumento list.

Por defecto, la anotación de cada celda indica el recuento de la frecuencia
de casos. Las opciones --row y --column (que se excluyen mutuamente),
substituyen los recuentos con los porcentajes para cada fila o columna,
respectivamente. Por defecto, las celdas con un recuento de cero casos se
dejan en blanco; pero la opción --zeros, que tiene como efecto la
presentación explícita de los ceros, puede serte útil para importar la
tabla con otro programa tal como una hoja de cálculo.

El contraste de independencia chi-cuadrado de Pearson se muestra si la
frecuencia esperada bajo independencia es cuando menos de 1.0e-7 para todas
las celdas. Una regla general habitual de la validez de este estadístico es
que, al menos el 80 por ciento de las celdas, deben tener frecuencias
esperadas iguales a 5 o más; y si este criterio no se cumple, se presenta
una advertencia.

Si una tabla de contingencia es 2 por 2, se calcula el Contraste Exacto de
independencia de Fisher. Ten en cuenta que este contraste se basa en el
supuesto de que los totales por fila y por columna son fijos, lo que puede
ser o no ser adecuado dependiendo de cómo se generaron los datos. Debes
utilizar la probabilidad asociada (valor p) de la izquierda cuando la
hipótesis alternativa a la de independencia es la asociación negativa (los
valores tienden a agruparse en las celdas de abajo a la izquierda y de
arriba a la derecha); y debes utilizar el valor p de la derecha si la
alternativa es la asociación positiva. El valor p de dos colas para este
contraste se calcula mediante el método (b) de la sección 2.1 de Agresti
(1992): esto es la suma de las probabilidades de todas las tablas posibles
que tengan los totales de filas y columnas indicados, y que tengan una
probabilidad menor o igual a la de la tabla observada.

El caso bivariante

En el sencillo caso de una tabulación cruzada bivariante, puedes utilizar
los accesorios "$test" y "$pvalue" para recuperar el estadístico del
contraste chi-cuadrado de Pearson y su probabilidad asociada (con tal de que
se cumpla la condición del mínimo valor esperado). En ese contexto, puedes
utilizar la opción --quiet para eliminar la presentación de la tabla.

Salida LaTeX

Cuando indicas la opción --tex, la tabulación cruzada se presenta con el
formato de un entorno tabular LaTeX en línea (de donde podría copiarse y
pegarse) o, cuando se añade el parámetro nombrearchivo, se envía al
archivo ahí indicado. (Si en nombrearchivo no se especifica una ruta
completa, el archivo se escribe en el directorio vigente establecido,
"workdir".) No se calcula ningún estadístico de contraste. Puedes utilizar
--equal como opción adicional para señalar (mostrado en negrilla) el
recuento o porcentaje de celdas en las que las variables de la fila y
columna tienen el mismo valor numérico. Esta opción se ignora excepto que
indiques la opción --tex; y también cuando una o las dos variables de la
tabulación cruzada tenga valores de cadena de texto.

La tabla como matriz

Cuando indicas un argumento con una única lista, vas a poder obtener la
tabla de contingencia en forma de matriz, por medio del accesor "$result".

