/* 
 * File: statusdisplay.c
 *
 * gxmms2 - A gtk2 frontend for XMMS2
 * Copyright (c) 2005-2006 Johannes Heimansberg
 *
 * requires GTK+ 2.6 or better and XMMS2
 *
 * Released under the GNU General Public License v2
 */

#include <gtk/gtk.h>
#include "statusdisplay.h"
#include "status_play.xpm"
#include "status_pause.xpm"
#include "status_stop.xpm"

void status_display_set_status(StatusDisplay *sd, gint status)
{
	if (GTK_IS_IMAGE(sd->image_status)) {
		switch (status) {
			case STATUS_PLAY:
				gtk_image_set_from_pixbuf(GTK_IMAGE(sd->image_status), 
				                          sd->icon_play);
				break;
			case STATUS_PAUSE:
				gtk_image_set_from_pixbuf(GTK_IMAGE(sd->image_status), 
				                          sd->icon_pause);
				break;			
			case STATUS_STOP:
				gtk_image_set_from_pixbuf(GTK_IMAGE(sd->image_status), 
				                          sd->icon_stop);
				break;
		}
	}
}

void status_display_init(StatusDisplay *sd)
{
	sd->icon_stop = 
		gdk_pixbuf_new_from_xpm_data((const char **)status_stop_xpm);
	sd->icon_play = 
		gdk_pixbuf_new_from_xpm_data((const char **)status_play_xpm);
	sd->icon_pause = 
		gdk_pixbuf_new_from_xpm_data((const char **)status_pause_xpm);

	sd->image_status = gtk_image_new_from_pixbuf(sd->icon_stop);
}

GtkWidget *status_display_get_image(StatusDisplay *sd)
{
	return sd->image_status;
}
