# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
UBUNTU_RELEASES += 24.10

.PHONY: all
all:: ubuntu-cloud-24.10.$(GARDEN_ARCH).qcow2 ubuntu-cloud-24.10.$(GARDEN_ARCH).run

.PHONY: fetch
fetch: $(GARDEN_DL_DIR)/ubuntu/oracular-server-cloudimg-$(call map_to_debian_arch,$(GARDEN_ARCH)).img

$(GARDEN_DL_DIR)/ubuntu/oracular-server-cloudimg-amd64.img $(GARDEN_DL_DIR)/ubuntu/oracular-server-cloudimg-arm64.img: $(GARDEN_DL_DIR)/ubuntu/oracular-server-cloudimg-%.img: | $(GARDEN_DL_DIR)/ubuntu
	$(strip $(WGET) \
		--no-clobber \
		--directory-prefix=$(firstword $|)/ \
		https://cloud-images.ubuntu.com/oracular/current/oracular-server-cloudimg-$*.img)

$(GARDEN_DL_DIR)/ubuntu/ubuntu-cloud-24.10.x86_64.qcow2: | $(GARDEN_DL_DIR)/ubuntu $(GARDEN_DL_DIR)/ubuntu/oracular-server-cloudimg-amd64.img
	ln -sf $(notdir $(word 2,$|)) $@

$(GARDEN_DL_DIR)/ubuntu/ubuntu-cloud-24.10.aarch64.qcow2: | $(GARDEN_DL_DIR)/ubuntu $(GARDEN_DL_DIR)/ubuntu/oracular-server-cloudimg-arm64.img
	ln -sf $(notdir $(word 2,$|)) $@

.PHONY: clean
clean::
	rm -f $(GARDEN_DL_DIR)/ubuntu/ubuntu-cloud-24.10.*.qcow2

.PHONY: distclean
distclean::
	rm -f $(GARDEN_DL_DIR)/ubuntu/oracular-server-cloudimg-*.img
