; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -verify-machineinstrs -mcpu=ppc -mtriple=powerpc64-ibm-aix < %s | FileCheck -check-prefix=AIX64 %s
; RUN: llc -verify-machineinstrs -mcpu=ppc -mtriple=powerpc-ibm-aix < %s | FileCheck -check-prefix=AIX32 %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu < %s | FileCheck -check-prefix=LE64 %s

define signext i32 @leaf1_noredzone(i32 signext %a, i32 signext %b) #0 {
; AIX64-LABEL: leaf1_noredzone:
; AIX64:       # %bb.0: # %entry
; AIX64-NEXT:    stdu 1, -64(1)
; AIX64-NEXT:    stw 3, 60(1)
; AIX64-NEXT:    add 3, 3, 4
; AIX64-NEXT:    extsw 3, 3
; AIX64-NEXT:    stw 4, 56(1)
; AIX64-NEXT:    addi 1, 1, 64
; AIX64-NEXT:    blr
;
; AIX32-LABEL: leaf1_noredzone:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    stwu 1, -32(1)
; AIX32-NEXT:    stw 3, 28(1)
; AIX32-NEXT:    add 3, 3, 4
; AIX32-NEXT:    stw 4, 24(1)
; AIX32-NEXT:    addi 1, 1, 32
; AIX32-NEXT:    blr
;
; LE64-LABEL: leaf1_noredzone:
; LE64:       # %bb.0: # %entry
; LE64-NEXT:    stdu 1, -48(1)
; LE64-NEXT:    stw 3, 44(1)
; LE64-NEXT:    add 3, 3, 4
; LE64-NEXT:    stw 4, 40(1)
; LE64-NEXT:    extsw 3, 3
; LE64-NEXT:    addi 1, 1, 48
; LE64-NEXT:    blr
entry:
  %a.addr = alloca i32, align 4
  %b.addr = alloca i32, align 4
  store i32 %a, ptr %a.addr, align 4
  store i32 %b, ptr %b.addr, align 4
  %0 = load i32, ptr %a.addr, align 4
  %1 = load i32, ptr %b.addr, align 4
  %add = add nsw i32 %0, %1
  ret i32 %add
}

define void @nonleaf1_noredzone(i32 signext %a, i32 signext %b) #0 {
; AIX64-LABEL: nonleaf1_noredzone:
; AIX64:       # %bb.0: # %entry
; AIX64-NEXT:    mflr 0
; AIX64-NEXT:    stdu 1, -128(1)
; AIX64-NEXT:    std 0, 144(1)
; AIX64-NEXT:    stw 3, 124(1)
; AIX64-NEXT:    add 3, 3, 4
; AIX64-NEXT:    extsw 3, 3
; AIX64-NEXT:    stw 4, 120(1)
; AIX64-NEXT:    bl .leaf2[PR]
; AIX64-NEXT:    nop
; AIX64-NEXT:    lwz 3, 124(1)
; AIX64-NEXT:    lwz 4, 120(1)
; AIX64-NEXT:    sub 3, 3, 4
; AIX64-NEXT:    extsw 3, 3
; AIX64-NEXT:    bl .leaf2[PR]
; AIX64-NEXT:    nop
; AIX64-NEXT:    addi 1, 1, 128
; AIX64-NEXT:    ld 0, 16(1)
; AIX64-NEXT:    mtlr 0
; AIX64-NEXT:    blr
;
; AIX32-LABEL: nonleaf1_noredzone:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    mflr 0
; AIX32-NEXT:    stwu 1, -64(1)
; AIX32-NEXT:    stw 0, 72(1)
; AIX32-NEXT:    stw 3, 60(1)
; AIX32-NEXT:    add 3, 3, 4
; AIX32-NEXT:    stw 4, 56(1)
; AIX32-NEXT:    bl .leaf2[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    lwz 3, 60(1)
; AIX32-NEXT:    lwz 4, 56(1)
; AIX32-NEXT:    sub 3, 3, 4
; AIX32-NEXT:    bl .leaf2[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    addi 1, 1, 64
; AIX32-NEXT:    lwz 0, 8(1)
; AIX32-NEXT:    mtlr 0
; AIX32-NEXT:    blr
;
; LE64-LABEL: nonleaf1_noredzone:
; LE64:       # %bb.0: # %entry
; LE64-NEXT:    mflr 0
; LE64-NEXT:    stdu 1, -48(1)
; LE64-NEXT:    std 0, 64(1)
; LE64-NEXT:    stw 3, 44(1)
; LE64-NEXT:    add 3, 3, 4
; LE64-NEXT:    extsw 3, 3
; LE64-NEXT:    stw 4, 40(1)
; LE64-NEXT:    bl leaf2
; LE64-NEXT:    nop
; LE64-NEXT:    lwz 3, 44(1)
; LE64-NEXT:    lwz 4, 40(1)
; LE64-NEXT:    sub 3, 3, 4
; LE64-NEXT:    extsw 3, 3
; LE64-NEXT:    bl leaf2
; LE64-NEXT:    nop
; LE64-NEXT:    addi 1, 1, 48
; LE64-NEXT:    ld 0, 16(1)
; LE64-NEXT:    mtlr 0
; LE64-NEXT:    blr
entry:
  %a.addr = alloca i32, align 4
  %b.addr = alloca i32, align 4
  store i32 %a, ptr %a.addr, align 4
  store i32 %b, ptr %b.addr, align 4
  %0 = load i32, ptr %a.addr, align 4
  %1 = load i32, ptr %b.addr, align 4
  %add = add nsw i32 %0, %1
  call void @leaf2(i32 signext %add)
  %2 = load i32, ptr %a.addr, align 4
  %3 = load i32, ptr %b.addr, align 4
  %sub = sub nsw i32 %2, %3
  call void @leaf2(i32 signext %sub)
  ret void
}

declare void @leaf2(i32 signext)

define signext i32 @leaf3_noredzone(i32 signext %a, i32 signext %b) #0 {
; AIX64-LABEL: leaf3_noredzone:
; AIX64:       # %bb.0: # %entry
; AIX64-NEXT:    stdu 1, -48(1)
; AIX64-NEXT:    ld 6, 0(1)
; AIX64-NEXT:    mr 5, 3
; AIX64-NEXT:    add 3, 5, 4
; AIX64-NEXT:    extsw 3, 3
; AIX64-NEXT:    stw 5, 48(6)
; AIX64-NEXT:    stw 4, 52(6)
; AIX64-NEXT:    addi 1, 1, 48
; AIX64-NEXT:    blr
;
; AIX32-LABEL: leaf3_noredzone:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    stwu 1, -32(1)
; AIX32-NEXT:    lwz 6, 0(1)
; AIX32-NEXT:    mr 5, 3
; AIX32-NEXT:    add 3, 3, 4
; AIX32-NEXT:    stw 5, 24(6)
; AIX32-NEXT:    stw 4, 28(6)
; AIX32-NEXT:    addi 1, 1, 32
; AIX32-NEXT:    blr
;
; LE64-LABEL: leaf3_noredzone:
; LE64:       # %bb.0: # %entry
; LE64-NEXT:    stdu 1, -32(1)
; LE64-NEXT:    ld 5, 0(1)
; LE64-NEXT:    stw 3, 48(5)
; LE64-NEXT:    add 3, 3, 4
; LE64-NEXT:    stw 4, 52(5)
; LE64-NEXT:    extsw 3, 3
; LE64-NEXT:    addi 1, 1, 32
; LE64-NEXT:    blr
entry:
  %f.addr = call ptr @llvm.frameaddress(i32 1)
  %a.addr = getelementptr ptr, ptr %f.addr, i32 6
  %b.addr = getelementptr i32, ptr %a.addr, i32 1
  store i32 %a, ptr %a.addr, align 4
  store i32 %b, ptr %b.addr, align 4
  %0 = load i32, ptr %a.addr, align 4
  %1 = load i32, ptr %b.addr, align 4
  %add = add nsw i32 %0, %1
  ret i32 %add
}

define void @nonleaf2_noredzone(i32 signext %a, i32 signext %b) #0 {
; AIX64-LABEL: nonleaf2_noredzone:
; AIX64:       # %bb.0: # %entry
; AIX64-NEXT:    mflr 0
; AIX64-NEXT:    stdu 1, -128(1)
; AIX64-NEXT:    std 0, 144(1)
; AIX64-NEXT:    std 31, 120(1) # 8-byte Folded Spill
; AIX64-NEXT:    add 5, 3, 4
; AIX64-NEXT:    ld 31, 0(1)
; AIX64-NEXT:    extsw 5, 5
; AIX64-NEXT:    stw 3, 48(31)
; AIX64-NEXT:    mr 3, 5
; AIX64-NEXT:    stw 4, 52(31)
; AIX64-NEXT:    bl .leaf2[PR]
; AIX64-NEXT:    nop
; AIX64-NEXT:    lwz 3, 48(31)
; AIX64-NEXT:    lwz 4, 52(31)
; AIX64-NEXT:    sub 3, 3, 4
; AIX64-NEXT:    extsw 3, 3
; AIX64-NEXT:    bl .leaf2[PR]
; AIX64-NEXT:    nop
; AIX64-NEXT:    ld 31, 120(1) # 8-byte Folded Reload
; AIX64-NEXT:    addi 1, 1, 128
; AIX64-NEXT:    ld 0, 16(1)
; AIX64-NEXT:    mtlr 0
; AIX64-NEXT:    blr
;
; AIX32-LABEL: nonleaf2_noredzone:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    mflr 0
; AIX32-NEXT:    stwu 1, -64(1)
; AIX32-NEXT:    stw 0, 72(1)
; AIX32-NEXT:    add 5, 3, 4
; AIX32-NEXT:    stw 31, 60(1) # 4-byte Folded Spill
; AIX32-NEXT:    lwz 31, 0(1)
; AIX32-NEXT:    stw 3, 24(31)
; AIX32-NEXT:    mr 3, 5
; AIX32-NEXT:    stw 4, 28(31)
; AIX32-NEXT:    bl .leaf2[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    lwz 3, 24(31)
; AIX32-NEXT:    lwz 4, 28(31)
; AIX32-NEXT:    sub 3, 3, 4
; AIX32-NEXT:    bl .leaf2[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    lwz 31, 60(1) # 4-byte Folded Reload
; AIX32-NEXT:    addi 1, 1, 64
; AIX32-NEXT:    lwz 0, 8(1)
; AIX32-NEXT:    mtlr 0
; AIX32-NEXT:    blr
;
; LE64-LABEL: nonleaf2_noredzone:
; LE64:       # %bb.0: # %entry
; LE64-NEXT:    mflr 0
; LE64-NEXT:    std 30, -16(1) # 8-byte Folded Spill
; LE64-NEXT:    stdu 1, -48(1)
; LE64-NEXT:    std 0, 64(1)
; LE64-NEXT:    ld 30, 0(1)
; LE64-NEXT:    stw 3, 48(30)
; LE64-NEXT:    add 3, 3, 4
; LE64-NEXT:    stw 4, 52(30)
; LE64-NEXT:    extsw 3, 3
; LE64-NEXT:    bl leaf2
; LE64-NEXT:    nop
; LE64-NEXT:    lwz 3, 48(30)
; LE64-NEXT:    lwz 4, 52(30)
; LE64-NEXT:    sub 3, 3, 4
; LE64-NEXT:    extsw 3, 3
; LE64-NEXT:    bl leaf2
; LE64-NEXT:    nop
; LE64-NEXT:    addi 1, 1, 48
; LE64-NEXT:    ld 0, 16(1)
; LE64-NEXT:    ld 30, -16(1) # 8-byte Folded Reload
; LE64-NEXT:    mtlr 0
; LE64-NEXT:    blr
entry:
  %f.addr = call ptr @llvm.frameaddress(i32 1)
  %a.addr = getelementptr ptr, ptr %f.addr, i32 6
  %b.addr = getelementptr i32, ptr %a.addr, i32 1
  store i32 %a, ptr %a.addr, align 4
  store i32 %b, ptr %b.addr, align 4
  %0 = load i32, ptr %a.addr, align 4
  %1 = load i32, ptr %b.addr, align 4
  %add = add nsw i32 %0, %1
  call void @leaf2(i32 signext %add)
  %2 = load i32, ptr %a.addr, align 4
  %3 = load i32, ptr %b.addr, align 4
  %sub = sub nsw i32 %2, %3
  call void @leaf2(i32 signext %sub)
  ret void
}

define signext i32 @leaf1_redzone(i32 signext %a, i32 signext %b) #1 {
; AIX64-LABEL: leaf1_redzone:
; AIX64:       # %bb.0: # %entry
; AIX64-NEXT:    stw 3, -4(1)
; AIX64-NEXT:    add 3, 3, 4
; AIX64-NEXT:    extsw 3, 3
; AIX64-NEXT:    stw 4, -8(1)
; AIX64-NEXT:    blr
;
; AIX32-LABEL: leaf1_redzone:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    stw 3, -4(1)
; AIX32-NEXT:    add 3, 3, 4
; AIX32-NEXT:    stw 4, -8(1)
; AIX32-NEXT:    blr
;
; LE64-LABEL: leaf1_redzone:
; LE64:       # %bb.0: # %entry
; LE64-NEXT:    stw 3, -4(1)
; LE64-NEXT:    add 3, 3, 4
; LE64-NEXT:    stw 4, -8(1)
; LE64-NEXT:    extsw 3, 3
; LE64-NEXT:    blr
entry:
  %a.addr = alloca i32, align 4
  %b.addr = alloca i32, align 4
  store i32 %a, ptr %a.addr, align 4
  store i32 %b, ptr %b.addr, align 4
  %0 = load i32, ptr %a.addr, align 4
  %1 = load i32, ptr %b.addr, align 4
  %add = add nsw i32 %0, %1
  ret i32 %add
}

define void @nonleaf1_redzone(i32 signext %a, i32 signext %b) #1 {
; AIX64-LABEL: nonleaf1_redzone:
; AIX64:       # %bb.0: # %entry
; AIX64-NEXT:    mflr 0
; AIX64-NEXT:    stdu 1, -128(1)
; AIX64-NEXT:    std 0, 144(1)
; AIX64-NEXT:    stw 3, 124(1)
; AIX64-NEXT:    add 3, 3, 4
; AIX64-NEXT:    extsw 3, 3
; AIX64-NEXT:    stw 4, 120(1)
; AIX64-NEXT:    bl .leaf2[PR]
; AIX64-NEXT:    nop
; AIX64-NEXT:    lwz 3, 124(1)
; AIX64-NEXT:    lwz 4, 120(1)
; AIX64-NEXT:    sub 3, 3, 4
; AIX64-NEXT:    extsw 3, 3
; AIX64-NEXT:    bl .leaf2[PR]
; AIX64-NEXT:    nop
; AIX64-NEXT:    addi 1, 1, 128
; AIX64-NEXT:    ld 0, 16(1)
; AIX64-NEXT:    mtlr 0
; AIX64-NEXT:    blr
;
; AIX32-LABEL: nonleaf1_redzone:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    mflr 0
; AIX32-NEXT:    stwu 1, -64(1)
; AIX32-NEXT:    stw 0, 72(1)
; AIX32-NEXT:    stw 3, 60(1)
; AIX32-NEXT:    add 3, 3, 4
; AIX32-NEXT:    stw 4, 56(1)
; AIX32-NEXT:    bl .leaf2[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    lwz 3, 60(1)
; AIX32-NEXT:    lwz 4, 56(1)
; AIX32-NEXT:    sub 3, 3, 4
; AIX32-NEXT:    bl .leaf2[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    addi 1, 1, 64
; AIX32-NEXT:    lwz 0, 8(1)
; AIX32-NEXT:    mtlr 0
; AIX32-NEXT:    blr
;
; LE64-LABEL: nonleaf1_redzone:
; LE64:       # %bb.0: # %entry
; LE64-NEXT:    mflr 0
; LE64-NEXT:    stdu 1, -48(1)
; LE64-NEXT:    std 0, 64(1)
; LE64-NEXT:    stw 3, 44(1)
; LE64-NEXT:    add 3, 3, 4
; LE64-NEXT:    extsw 3, 3
; LE64-NEXT:    stw 4, 40(1)
; LE64-NEXT:    bl leaf2
; LE64-NEXT:    nop
; LE64-NEXT:    lwz 3, 44(1)
; LE64-NEXT:    lwz 4, 40(1)
; LE64-NEXT:    sub 3, 3, 4
; LE64-NEXT:    extsw 3, 3
; LE64-NEXT:    bl leaf2
; LE64-NEXT:    nop
; LE64-NEXT:    addi 1, 1, 48
; LE64-NEXT:    ld 0, 16(1)
; LE64-NEXT:    mtlr 0
; LE64-NEXT:    blr
entry:
  %a.addr = alloca i32, align 4
  %b.addr = alloca i32, align 4
  store i32 %a, ptr %a.addr, align 4
  store i32 %b, ptr %b.addr, align 4
  %0 = load i32, ptr %a.addr, align 4
  %1 = load i32, ptr %b.addr, align 4
  %add = add nsw i32 %0, %1
  call void @leaf2(i32 signext %add)
  %2 = load i32, ptr %a.addr, align 4
  %3 = load i32, ptr %b.addr, align 4
  %sub = sub nsw i32 %2, %3
  call void @leaf2(i32 signext %sub)
  ret void
}

define signext i32 @leaf3_redzone(i32 signext %a, i32 signext %b) #1 {
; AIX64-LABEL: leaf3_redzone:
; AIX64:       # %bb.0: # %entry
; AIX64-NEXT:    stdu 1, -48(1)
; AIX64-NEXT:    ld 6, 0(1)
; AIX64-NEXT:    mr 5, 3
; AIX64-NEXT:    add 3, 5, 4
; AIX64-NEXT:    extsw 3, 3
; AIX64-NEXT:    stw 5, 48(6)
; AIX64-NEXT:    stw 4, 52(6)
; AIX64-NEXT:    addi 1, 1, 48
; AIX64-NEXT:    blr
;
; AIX32-LABEL: leaf3_redzone:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    stwu 1, -32(1)
; AIX32-NEXT:    lwz 6, 0(1)
; AIX32-NEXT:    mr 5, 3
; AIX32-NEXT:    add 3, 3, 4
; AIX32-NEXT:    stw 5, 24(6)
; AIX32-NEXT:    stw 4, 28(6)
; AIX32-NEXT:    addi 1, 1, 32
; AIX32-NEXT:    blr
;
; LE64-LABEL: leaf3_redzone:
; LE64:       # %bb.0: # %entry
; LE64-NEXT:    stdu 1, -32(1)
; LE64-NEXT:    ld 5, 0(1)
; LE64-NEXT:    stw 3, 48(5)
; LE64-NEXT:    add 3, 3, 4
; LE64-NEXT:    stw 4, 52(5)
; LE64-NEXT:    extsw 3, 3
; LE64-NEXT:    addi 1, 1, 32
; LE64-NEXT:    blr
entry:
  %f.addr = call ptr @llvm.frameaddress(i32 1)
  %a.addr = getelementptr ptr, ptr %f.addr, i32 6
  %b.addr = getelementptr i32, ptr %a.addr, i32 1
  store i32 %a, ptr %a.addr, align 4
  store i32 %b, ptr %b.addr, align 4
  %0 = load i32, ptr %a.addr, align 4
  %1 = load i32, ptr %b.addr, align 4
  %add = add nsw i32 %0, %1
  ret i32 %add
}

define void @nonleaf2_redzone(i32 signext %a, i32 signext %b) #1 {
; AIX64-LABEL: nonleaf2_redzone:
; AIX64:       # %bb.0: # %entry
; AIX64-NEXT:    mflr 0
; AIX64-NEXT:    stdu 1, -128(1)
; AIX64-NEXT:    std 0, 144(1)
; AIX64-NEXT:    std 31, 120(1) # 8-byte Folded Spill
; AIX64-NEXT:    add 5, 3, 4
; AIX64-NEXT:    ld 31, 0(1)
; AIX64-NEXT:    extsw 5, 5
; AIX64-NEXT:    stw 3, 48(31)
; AIX64-NEXT:    mr 3, 5
; AIX64-NEXT:    stw 4, 52(31)
; AIX64-NEXT:    bl .leaf2[PR]
; AIX64-NEXT:    nop
; AIX64-NEXT:    lwz 3, 48(31)
; AIX64-NEXT:    lwz 4, 52(31)
; AIX64-NEXT:    sub 3, 3, 4
; AIX64-NEXT:    extsw 3, 3
; AIX64-NEXT:    bl .leaf2[PR]
; AIX64-NEXT:    nop
; AIX64-NEXT:    ld 31, 120(1) # 8-byte Folded Reload
; AIX64-NEXT:    addi 1, 1, 128
; AIX64-NEXT:    ld 0, 16(1)
; AIX64-NEXT:    mtlr 0
; AIX64-NEXT:    blr
;
; AIX32-LABEL: nonleaf2_redzone:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    mflr 0
; AIX32-NEXT:    stwu 1, -64(1)
; AIX32-NEXT:    stw 0, 72(1)
; AIX32-NEXT:    add 5, 3, 4
; AIX32-NEXT:    stw 31, 60(1) # 4-byte Folded Spill
; AIX32-NEXT:    lwz 31, 0(1)
; AIX32-NEXT:    stw 3, 24(31)
; AIX32-NEXT:    mr 3, 5
; AIX32-NEXT:    stw 4, 28(31)
; AIX32-NEXT:    bl .leaf2[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    lwz 3, 24(31)
; AIX32-NEXT:    lwz 4, 28(31)
; AIX32-NEXT:    sub 3, 3, 4
; AIX32-NEXT:    bl .leaf2[PR]
; AIX32-NEXT:    nop
; AIX32-NEXT:    lwz 31, 60(1) # 4-byte Folded Reload
; AIX32-NEXT:    addi 1, 1, 64
; AIX32-NEXT:    lwz 0, 8(1)
; AIX32-NEXT:    mtlr 0
; AIX32-NEXT:    blr
;
; LE64-LABEL: nonleaf2_redzone:
; LE64:       # %bb.0: # %entry
; LE64-NEXT:    mflr 0
; LE64-NEXT:    std 30, -16(1) # 8-byte Folded Spill
; LE64-NEXT:    stdu 1, -48(1)
; LE64-NEXT:    std 0, 64(1)
; LE64-NEXT:    ld 30, 0(1)
; LE64-NEXT:    stw 3, 48(30)
; LE64-NEXT:    add 3, 3, 4
; LE64-NEXT:    stw 4, 52(30)
; LE64-NEXT:    extsw 3, 3
; LE64-NEXT:    bl leaf2
; LE64-NEXT:    nop
; LE64-NEXT:    lwz 3, 48(30)
; LE64-NEXT:    lwz 4, 52(30)
; LE64-NEXT:    sub 3, 3, 4
; LE64-NEXT:    extsw 3, 3
; LE64-NEXT:    bl leaf2
; LE64-NEXT:    nop
; LE64-NEXT:    addi 1, 1, 48
; LE64-NEXT:    ld 0, 16(1)
; LE64-NEXT:    ld 30, -16(1) # 8-byte Folded Reload
; LE64-NEXT:    mtlr 0
; LE64-NEXT:    blr
entry:
  %f.addr = call ptr @llvm.frameaddress(i32 1)
  %a.addr = getelementptr ptr, ptr %f.addr, i32 6
  %b.addr = getelementptr i32, ptr %a.addr, i32 1
  store i32 %a, ptr %a.addr, align 4
  store i32 %b, ptr %b.addr, align 4
  %0 = load i32, ptr %a.addr, align 4
  %1 = load i32, ptr %b.addr, align 4
  %add = add nsw i32 %0, %1
  call void @leaf2(i32 signext %add)
  %2 = load i32, ptr %a.addr, align 4
  %3 = load i32, ptr %b.addr, align 4
  %sub = sub nsw i32 %2, %3
  call void @leaf2(i32 signext %sub)
  ret void
}

attributes #0 = { noredzone nounwind noinline }
attributes #1 = { nounwind noinline }
