/*
 * Copyright (C) 2025 Linux Studio Plugins Project <https://lsp-plug.in/>
 *           (C) 2025 Vladimir Sadovnikov <sadko4u@gmail.com>
 *
 * This file is part of lsp-plugins
 * Created on: 14 июл. 2024 г.
 *
 * lsp-plugins is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * lsp-plugins is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with lsp-plugins. If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef GENERATED_ISO226_ISO226_2023_H_
#define GENERATED_ISO226_ISO226_2023_H_

#include <generated/iso226/defs.h>

namespace lsp
{
    static const int16_t iso226_2023_curve_0_phons[985] =
    {
        -4288, -4300,
        -4275, -4285, -4310, -4307, -4329, -4339, -4358, -4378, -4375, -4429,
        -4426, -4433, -4474, -4487, -4481, -4522, -4522, -4548, -4548, -4558,
        -4571, -4597, -4606, -4606, -4606, -4635, -4648, -4635, -4679, -4689,
        -4712, -4706, -4738, -4760, -4782, -4792, -4818, -4830, -4840, -4857,
        -4869, -4886, -4895, -4908, -4914, -4934, -4943, -4966, -4960, -4985,
        -5004, -5004, -5027, -5043, -5043, -5033, -5084, -5082, -5091, -5111,
        -5133, -5139, -5149, -5171, -5200, -5197, -5197, -5232, -5242, -5246,
        -5270, -5271, -5271, -5299, -5290, -5300, -5310, -5329, -5351, -5351,
        -5380, -5377, -5399, -5409, -5416, -5438, -5445, -5454, -5467, -5461,
        -5474, -5493, -5505, -5500, -5522, -5534, -5541, -5554, -5573, -5583,
        -5602, -5621, -5644, -5641, -5663, -5663, -5675, -5685, -5682, -5707,
        -5714, -5714, -5714, -5736, -5746, -5746, -5768, -5772, -5782, -5794,
        -5810, -5820, -5817, -5840, -5864, -5874, -5884, -5884, -5906, -5923,
        -5935, -5935, -5957, -5964, -5964, -5964, -5984, -5993, -5993, -6015,
        -6012, -6044, -6032, -6051, -6064, -6067, -6073, -6086, -6098, -6105,
        -6102, -6112, -6125, -6119, -6128, -6153, -6151, -6182, -6180, -6192,
        -6211, -6221, -6221, -6231, -6231, -6240, -6228, -6253, -6260, -6272,
        -6294, -6292, -6317, -6301, -6323, -6323, -6330, -6337, -6362, -6347,
        -6369, -6366, -6388, -6395, -6401, -6417, -6405, -6426, -6424, -6446,
        -6446, -6461, -6468, -6478, -6488, -6500, -6519, -6532, -6542, -6561,
        -6551, -6561, -6571, -6574, -6583, -6583, -6583, -6580, -6580, -6593,
        -6600, -6597, -6619, -6616, -6638, -6648, -6673, -6658, -6683, -6705,
        -6683, -6708, -6715, -6715, -6702, -6724, -6736, -6731, -6753, -6750,
        -6760, -6770, -6770, -6782, -6779, -6801, -6807, -6804, -6824, -6825,
        -6824, -6846, -6824, -6843, -6856, -6862, -6878, -6872, -6885, -6907,
        -6904, -6916, -6929, -6929, -6929, -6926, -6936, -6933, -6945, -6945,
        -6952, -6965, -6974, -6974, -6997, -6997, -7009, -7022, -7019, -7034,
        -7028, -7048, -7041, -7048, -7058, -7057, -7057, -7045, -7067, -7076,
        -7067, -7086, -7083, -7086, -7106, -7128, -7118, -7128, -7140, -7125,
        -7144, -7160, -7144, -7160, -7157, -7169, -7172, -7179, -7192, -7201,
        -7189, -7208, -7198, -7208, -7230, -7218, -7227, -7252, -7250, -7243,
        -7262, -7256, -7252, -7275, -7287, -7284, -7297, -7307, -7304, -7313,
        -7326, -7323, -7323, -7336, -7333, -7333, -7345, -7355, -7339, -7355,
        -7364, -7349, -7364, -7384, -7371, -7384, -7384, -7395, -7384, -7393,
        -7403, -7393, -7403, -7413, -7427, -7413, -7425, -7438, -7422, -7435,
        -7448, -7460, -7457, -7463, -7480, -7479, -7479, -7489, -7492, -7488,
        -7489, -7489, -7501, -7499, -7508, -7508, -7518, -7515, -7525, -7534,
        -7547, -7537, -7547, -7550, -7569, -7574, -7560, -7569, -7557, -7591,
        -7569, -7589, -7589, -7613, -7613, -7589, -7614, -7614, -7613, -7626,
        -7623, -7623, -7642, -7655, -7643, -7652, -7672, -7677, -7665, -7687,
        -7690, -7690, -7702, -7700, -7700, -7700, -7702, -7712, -7709, -7722,
        -7719, -7731, -7741, -7731, -7738, -7741, -7751, -7751, -7751, -7760,
        -7760, -7776, -7785, -7770, -7770, -7780, -7783, -7802, -7804, -7814,
        -7802, -7802, -7812, -7824, -7823, -7812, -7834, -7834, -7834, -7831,
        -7843, -7843, -7843, -7853, -7843, -7853, -7853, -7841, -7860, -7847,
        -7847, -7882, -7870, -7872, -7895, -7895, -7895, -7903, -7905, -7905,
        -7917, -7927, -7902, -7902, -7914, -7914, -7924, -7914, -7901, -7921,
        -7924, -7914, -7924, -7933, -7936, -7939, -7958, -7946, -7952, -7971,
        -7970, -7959, -7971, -7983, -7983, -7983, -7996, -7993, -7990, -8000,
        -8012, -7990, -7990, -8000, -8000, -8000, -8012, -8000, -8012, -8010,
        -8010, -8010, -8010, -8025, -8034, -8034, -8032, -8043, -8032, -8032,
        -8042, -8032, -8032, -8044, -8054, -8053, -8051, -8054, -8064, -8064,
        -8051, -8051, -8061, -8051, -8064, -8064, -8065, -8057, -8057, -8060,
        -8067, -8067, -8076, -8067, -8067, -8067, -8066, -8054, -8054, -8064,
        -8064, -8073, -8076, -8076, -8064, -8073, -8073, -8068, -8070, -8083,
        -8083, -8098, -8098, -8086, -8096, -8098, -8098, -8098, -8098, -8098,
        -8101, -8098, -8089, -8089, -8089, -8079, -8089, -8089, -8089, -8111,
        -8111, -8111, -8111, -8114, -8114, -8114, -8116, -8117, -8107, -8107,
        -8107, -8107, -8104, -8105, -8105, -8114, -8126, -8126, -8126, -8117,
        -8129, -8129, -8129, -8126, -8120, -8129, -8129, -8114, -8117, -8129,
        -8129, -8139, -8129, -8129, -8149, -8139, -8126, -8149, -8136, -8133,
        -8158, -8152, -8165, -8168, -8162, -8155, -8168, -8162, -8165, -8162,
        -8175, -8197, -8181, -8204, -8213, -8223, -8236, -8242, -8255, -8255,
        -8280, -8277, -8274, -8287, -8303, -8303, -8303, -8332, -8332, -8329,
        -8351, -8351, -8358, -8381, -8400, -8412, -8425, -8429, -8429, -8451,
        -8458, -8458, -8467, -8487, -8499, -8499, -8518, -8531, -8531, -8541,
        -8550, -8550, -8547, -8557, -8557, -8554, -8564, -8551, -8564, -8574,
        -8576, -8586, -8586, -8599, -8599, -8593, -8596, -8583, -8593, -8580,
        -8596, -8583, -8596, -8583, -8599, -8586, -8599, -8583, -8599, -8608,
        -8599, -8599, -8611, -8608, -8599, -8608, -8589, -8583, -8586, -8576,
        -8574, -8576, -8574, -8576, -8576, -8589, -8576, -8589, -8579, -8589,
        -8579, -8576, -8579, -8579, -8579, -8599, -8589, -8579, -8599, -8576,
        -8589, -8586, -8589, -8586, -8576, -8579, -8574, -8574, -8564, -8576,
        -8576, -8576, -8579, -8579, -8586, -8586, -8586, -8596, -8599, -8605,
        -8605, -8618, -8615, -8628, -8625, -8622, -8634, -8637, -8644, -8631,
        -8644, -8657, -8644, -8654, -8666, -8666, -8666, -8676, -8686, -8686,
        -8673, -8673, -8660, -8663, -8673, -8673, -8676, -8676, -8676, -8686,
        -8686, -8708, -8708, -8708, -8708, -8708, -8708, -8705, -8705, -8705,
        -8705, -8717, -8727, -8724, -8724, -8737, -8749, -8737, -8724, -8724,
        -8721, -8734, -8734, -8731, -8750, -8753, -8753, -8763, -8766, -8763,
        -8763, -8766, -8775, -8775, -8753, -8766, -8778, -8763, -8753, -8774,
        -8753, -8753, -8772, -8753, -8772, -8763, -8750, -8763, -8753, -8750,
        -8753, -8738, -8753, -8744, -8744, -8756, -8746, -8759, -8759, -8737,
        -8746, -8749, -8727, -8727, -8715, -8715, -8702, -8715, -8715, -8717,
        -8695, -8705, -8708, -8698, -8698, -8691, -8679, -8666, -8676, -8676,
        -8657, -8647, -8647, -8631, -8622, -8618, -8608, -8583, -8586, -8589,
        -8576, -8564, -8567, -8570, -8560, -8570, -8550, -8525, -8528, -8531,
        -8531, -8521, -8487, -8477, -8470, -8480, -8459, -8448, -8448, -8423,
        -8426, -8419, -8419, -8406, -8384, -8387, -8384, -8378, -8365, -8368,
        -8371, -8364, -8361, -8351, -8354, -8338, -8335, -8322, -8325, -8313,
        -8303, -8300, -8288, -8275, -8278, -8268, -8265, -8246, -8249, -8224,
        -8239, -8224, -8237, -8227, -8227, -8214, -8214, -8214, -8211, -8202,
        -8214, -8192, -8189, -8205, -8195, -8182, -8195, -8195, -8186, -8181,
        -8192, -8192, -8189, -8180, -8177, -8177, -8167, -8164, -8164, -8167,
        -8167, -8154, -8157, -8157, -8132, -8145, -8145, -8132, -8142, -8145,
        -8145, -8129, -8132, -8107, -8110, -8097, -8075, -8078, -8066, -8046,
        -8049, -8037, -8040, -8005, -8017, -8017, -7983, -7983, -7960, -7960,
        -7941, -7909, -7909, -7893, -7871, -7854, -7832, -7813, -7790, -7749,
        -7720, -7701, -7672
    };

    static const int16_t iso226_2023_curve_10_phons[985] =
    {
        -3679, -3692,
        -3676, -3686, -3711, -3708, -3740, -3740, -3750, -3769, -3766, -3801,
        -3798, -3795, -3808, -3830, -3824, -3837, -3837, -3853, -3863, -3853,
        -3875, -3882, -3901, -3901, -3892, -3911, -3924, -3921, -3945, -3946,
        -3958, -3962, -3975, -3987, -4000, -4000, -4007, -4029, -4039, -4036,
        -4048, -4055, -4065, -4087, -4074, -4084, -4094, -4106, -4110, -4116,
        -4135, -4135, -4157, -4154, -4154, -4164, -4177, -4174, -4183, -4203,
        -4206, -4222, -4222, -4235, -4254, -4251, -4251, -4276, -4276, -4261,
        -4295, -4295, -4295, -4314, -4324, -4334, -4344, -4363, -4376, -4376,
        -4385, -4392, -4405, -4414, -4402, -4424, -4431, -4431, -4443, -4437,
        -4450, -4460, -4472, -4466, -4479, -4492, -4489, -4511, -4520, -4530,
        -4520, -4549, -4562, -4559, -4581, -4581, -4594, -4604, -4601, -4616,
        -4613, -4632, -4632, -4645, -4655, -4655, -4667, -4662, -4661, -4664,
        -4671, -4681, -4678, -4700, -4724, -4725, -4745, -4735, -4747, -4754,
        -4776, -4776, -4789, -4796, -4796, -4815, -4805, -4825, -4825, -4847,
        -4834, -4866, -4854, -4873, -4876, -4888, -4895, -4908, -4911, -4917,
        -4914, -4924, -4937, -4931, -4931, -4956, -4963, -4975, -4963, -4985,
        -4995, -4995, -5014, -5024, -5024, -5033, -5021, -5046, -5053, -5065,
        -5058, -5075, -5090, -5085, -5107, -5107, -5104, -5101, -5126, -5120,
        -5142, -5139, -5152, -5149, -5165, -5171, -5168, -5180, -5188, -5190,
        -5200, -5225, -5213, -5232, -5232, -5254, -5274, -5277, -5286, -5306,
        -5306, -5315, -5325, -5328, -5337, -5347, -5347, -5354, -5354, -5357,
        -5364, -5361, -5373, -5361, -5383, -5402, -5417, -5421, -5437, -5459,
        -5447, -5472, -5469, -5469, -5466, -5488, -5491, -5485, -5507, -5495,
        -5505, -5514, -5524, -5536, -5533, -5546, -5570, -5568, -5588, -5589,
        -5588, -5610, -5607, -5607, -5619, -5626, -5651, -5636, -5648, -5671,
        -5668, -5690, -5702, -5702, -5712, -5719, -5709, -5716, -5729, -5729,
        -5735, -5748, -5767, -5758, -5780, -5780, -5792, -5805, -5802, -5817,
        -5812, -5831, -5834, -5831, -5850, -5850, -5860, -5847, -5860, -5879,
        -5870, -5889, -5886, -5889, -5908, -5921, -5921, -5930, -5943, -5937,
        -5947, -5962, -5947, -5972, -5979, -5991, -6004, -6001, -6023, -6023,
        -6011, -6030, -6030, -6040, -6062, -6050, -6059, -6074, -6081, -6084,
        -6094, -6107, -6113, -6116, -6138, -6145, -6148, -6157, -6164, -6154,
        -6167, -6174, -6174, -6186, -6183, -6193, -6196, -6215, -6200, -6225,
        -6225, -6219, -6225, -6244, -6241, -6244, -6254, -6275, -6254, -6273,
        -6282, -6273, -6293, -6312, -6326, -6312, -6334, -6347, -6331, -6344,
        -6356, -6369, -6356, -6372, -6379, -6378, -6378, -6398, -6401, -6407,
        -6407, -6407, -6420, -6417, -6437, -6436, -6446, -6443, -6453, -6463,
        -6475, -6475, -6485, -6488, -6507, -6511, -6497, -6517, -6504, -6529,
        -6526, -6526, -6536, -6561, -6561, -6555, -6571, -6571, -6590, -6583,
        -6590, -6600, -6600, -6612, -6609, -6609, -6629, -6644, -6632, -6654,
        -6666, -6676, -6679, -6686, -6686, -6686, -6698, -6698, -6705, -6708,
        -6715, -6717, -6727, -6737, -6734, -6746, -6756, -6746, -6756, -6756,
        -6766, -6781, -6790, -6785, -6795, -6795, -6807, -6817, -6819, -6820,
        -6817, -6817, -6827, -6839, -6838, -6836, -6849, -6858, -6868, -6865,
        -6878, -6878, -6887, -6897, -6897, -6897, -6907, -6894, -6894, -6901,
        -6901, -6916, -6923, -6926, -6939, -6948, -6948, -6956, -6959, -6968,
        -6980, -6980, -6965, -6975, -6987, -6997, -6997, -6997, -6994, -6994,
        -7006, -7006, -7006, -7026, -7028, -7041, -7051, -7038, -7054, -7063,
        -7062, -7051, -7063, -7076, -7076, -7085, -7098, -7085, -7102, -7102,
        -7104, -7102, -7102, -7102, -7121, -7121, -7133, -7121, -7134, -7121,
        -7121, -7141, -7131, -7146, -7165, -7165, -7153, -7164, -7153, -7163,
        -7163, -7163, -7163, -7166, -7185, -7184, -7172, -7195, -7195, -7195,
        -7192, -7192, -7201, -7192, -7204, -7214, -7225, -7217, -7217, -7229,
        -7226, -7226, -7236, -7226, -7226, -7236, -7245, -7233, -7233, -7243,
        -7252, -7252, -7256, -7265, -7252, -7252, -7252, -7247, -7250, -7262,
        -7271, -7287, -7286, -7275, -7285, -7287, -7287, -7287, -7287, -7297,
        -7300, -7297, -7297, -7297, -7297, -7287, -7287, -7297, -7297, -7319,
        -7319, -7319, -7319, -7322, -7322, -7322, -7324, -7325, -7334, -7334,
        -7334, -7335, -7332, -7342, -7342, -7341, -7354, -7354, -7344, -7345,
        -7357, -7347, -7347, -7344, -7337, -7347, -7347, -7341, -7344, -7357,
        -7347, -7366, -7357, -7357, -7376, -7366, -7354, -7376, -7373, -7361,
        -7386, -7380, -7393, -7395, -7390, -7392, -7405, -7390, -7402, -7409,
        -7412, -7434, -7419, -7441, -7450, -7450, -7463, -7460, -7473, -7473,
        -7488, -7476, -7473, -7485, -7482, -7482, -7482, -7501, -7502, -7499,
        -7521, -7521, -7518, -7540, -7540, -7562, -7575, -7569, -7579, -7591,
        -7608, -7608, -7617, -7627, -7640, -7640, -7649, -7662, -7662, -7672,
        -7672, -7672, -7669, -7669, -7669, -7666, -7675, -7663, -7666, -7685,
        -7678, -7688, -7688, -7691, -7691, -7685, -7698, -7685, -7695, -7682,
        -7698, -7695, -7707, -7685, -7710, -7688, -7701, -7695, -7701, -7710,
        -7710, -7701, -7723, -7701, -7701, -7710, -7691, -7675, -7698, -7688,
        -7675, -7688, -7685, -7688, -7688, -7710, -7688, -7710, -7691, -7710,
        -7691, -7688, -7691, -7681, -7691, -7691, -7691, -7691, -7691, -7688,
        -7691, -7698, -7691, -7678, -7688, -7691, -7675, -7685, -7666, -7688,
        -7688, -7669, -7691, -7691, -7678, -7698, -7688, -7698, -7710, -7698,
        -7717, -7720, -7707, -7730, -7717, -7704, -7727, -7730, -7717, -7724,
        -7727, -7730, -7736, -7736, -7749, -7758, -7758, -7758, -7768, -7768,
        -7756, -7756, -7753, -7756, -7756, -7765, -7768, -7768, -7768, -7768,
        -7768, -7781, -7781, -7781, -7781, -7781, -7781, -7778, -7778, -7778,
        -7778, -7790, -7800, -7797, -7797, -7810, -7822, -7810, -7807, -7797,
        -7794, -7807, -7797, -7794, -7804, -7816, -7807, -7816, -7810, -7807,
        -7807, -7800, -7810, -7810, -7797, -7800, -7813, -7797, -7787, -7809,
        -7807, -7797, -7807, -7807, -7816, -7807, -7804, -7816, -7816, -7804,
        -7807, -7782, -7807, -7797, -7788, -7790, -7800, -7803, -7803, -7790,
        -7800, -7803, -7790, -7800, -7787, -7787, -7775, -7778, -7778, -7790,
        -7768, -7768, -7771, -7761, -7761, -7764, -7761, -7749, -7749, -7739,
        -7739, -7749, -7749, -7724, -7724, -7730, -7730, -7714, -7717, -7720,
        -7707, -7695, -7707, -7710, -7701, -7681, -7681, -7656, -7669, -7672,
        -7672, -7662, -7637, -7637, -7620, -7630, -7609, -7608, -7608, -7563,
        -7576, -7579, -7560, -7547, -7534, -7528, -7525, -7528, -7515, -7528,
        -7531, -7533, -7511, -7511, -7505, -7517, -7505, -7492, -7495, -7482,
        -7482, -7470, -7457, -7445, -7448, -7438, -7425, -7416, -7419, -7393,
        -7409, -7384, -7387, -7377, -7367, -7364, -7364, -7364, -7342, -7352,
        -7355, -7333, -7320, -7336, -7316, -7313, -7316, -7307, -7298, -7282,
        -7284, -7275, -7272, -7252, -7250, -7240, -7230, -7227, -7227, -7211,
        -7211, -7179, -7182, -7182, -7147, -7150, -7140, -7128, -7118, -7121,
        -7121, -7096, -7089, -7064, -7067, -7045, -7023, -7035, -7013, -6994,
        -7006, -6984, -6977, -6952, -6965, -6955, -6920, -6911, -6898, -6879,
        -6859, -6837, -6828, -6811, -6789, -6782, -6760, -6750, -6738, -6725,
        -6696, -6696, -6687
    };

    static const int16_t iso226_2023_curve_20_phons[985] =
    {
        -3100, -3112,
        -3097, -3097, -3122, -3139, -3141, -3142, -3161, -3151, -3139, -3173,
        -3161, -3158, -3170, -3183, -3177, -3190, -3190, -3206, -3196, -3206,
        -3209, -3216, -3225, -3225, -3225, -3235, -3257, -3245, -3278, -3280,
        -3292, -3286, -3280, -3302, -3314, -3314, -3321, -3334, -3334, -3350,
        -3353, -3360, -3369, -3382, -3379, -3389, -3379, -3392, -3386, -3411,
        -3401, -3411, -3433, -3430, -3430, -3430, -3452, -3450, -3459, -3469,
        -3491, -3478, -3488, -3491, -3501, -3498, -3488, -3504, -3513, -3507,
        -3522, -3523, -3523, -3541, -3533, -3533, -3542, -3552, -3574, -3584,
        -3593, -3590, -3603, -3613, -3600, -3622, -3619, -3639, -3642, -3636,
        -3648, -3658, -3671, -3655, -3658, -3680, -3687, -3690, -3709, -3709,
        -3709, -3729, -3741, -3738, -3770, -3760, -3773, -3783, -3780, -3796,
        -3783, -3792, -3792, -3805, -3805, -3805, -3817, -3812, -3821, -3824,
        -3840, -3850, -3847, -3850, -3874, -3875, -3895, -3885, -3898, -3895,
        -3907, -3917, -3920, -3917, -3917, -3927, -3936, -3936, -3946, -3968,
        -3965, -3978, -3985, -3994, -3997, -4010, -4016, -4019, -4022, -4029,
        -4016, -4017, -4029, -4023, -4023, -4048, -4045, -4068, -4055, -4077,
        -4087, -4087, -4097, -4097, -4106, -4116, -4094, -4128, -4135, -4138,
        -4150, -4157, -4173, -4157, -4180, -4180, -4177, -4183, -4209, -4193,
        -4215, -4203, -4215, -4212, -4238, -4225, -4222, -4243, -4222, -4253,
        -4254, -4279, -4276, -4266, -4286, -4298, -4308, -4321, -4321, -4340,
        -4340, -4350, -4350, -4362, -4372, -4372, -4381, -4369, -4379, -4391,
        -4388, -4376, -4398, -4385, -4398, -4417, -4432, -4417, -4442, -4464,
        -4462, -4477, -4474, -4484, -4481, -4503, -4506, -4500, -4513, -4510,
        -4520, -4529, -4539, -4551, -4539, -4561, -4585, -4574, -4583, -4595,
        -4593, -4605, -4603, -4622, -4625, -4622, -4647, -4641, -4654, -4666,
        -4654, -4676, -4689, -4698, -4689, -4695, -4705, -4712, -4715, -4724,
        -4731, -4724, -4744, -4744, -4756, -4766, -4778, -4791, -4788, -4813,
        -4807, -4808, -4820, -4817, -4827, -4817, -4827, -4814, -4827, -4836,
        -4836, -4846, -4843, -4856, -4865, -4887, -4878, -4887, -4910, -4894,
        -4914, -4929, -4923, -4939, -4945, -4958, -4980, -4968, -4990, -4990,
        -4987, -4997, -4987, -4997, -5019, -5007, -5026, -5051, -5038, -5051,
        -5070, -5064, -5070, -5083, -5095, -5092, -5095, -5105, -5102, -5111,
        -5124, -5121, -5131, -5143, -5131, -5140, -5143, -5163, -5138, -5163,
        -5172, -5157, -5172, -5192, -5198, -5192, -5211, -5223, -5211, -5221,
        -5230, -5221, -5230, -5250, -5264, -5250, -5272, -5275, -5259, -5282,
        -5284, -5297, -5294, -5309, -5316, -5316, -5326, -5336, -5358, -5344,
        -5355, -5355, -5367, -5364, -5374, -5374, -5384, -5381, -5391, -5400,
        -5403, -5413, -5413, -5425, -5445, -5449, -5435, -5445, -5432, -5467,
        -5445, -5464, -5474, -5479, -5499, -5493, -5508, -5508, -5527, -5521,
        -5518, -5528, -5537, -5540, -5537, -5547, -5557, -5582, -5579, -5592,
        -5604, -5614, -5617, -5614, -5614, -5614, -5626, -5636, -5633, -5646,
        -5652, -5655, -5665, -5665, -5672, -5674, -5674, -5684, -5684, -5694,
        -5704, -5719, -5728, -5723, -5713, -5723, -5726, -5735, -5757, -5748,
        -5755, -5755, -5774, -5777, -5776, -5784, -5787, -5787, -5806, -5793,
        -5815, -5815, -5806, -5825, -5815, -5825, -5825, -5813, -5832, -5819,
        -5829, -5863, -5861, -5864, -5886, -5886, -5905, -5894, -5896, -5906,
        -5918, -5918, -5913, -5912, -5915, -5934, -5934, -5925, -5931, -5931,
        -5944, -5944, -5944, -5963, -5976, -5988, -5988, -5995, -6001, -6001,
        -6010, -6008, -6011, -6023, -6033, -6033, -6055, -6042, -6040, -6050,
        -6061, -6040, -6050, -6059, -6059, -6059, -6081, -6069, -6071, -6078,
        -6078, -6078, -6078, -6103, -6103, -6103, -6110, -6121, -6110, -6110,
        -6120, -6110, -6120, -6123, -6123, -6141, -6129, -6132, -6152, -6152,
        -6139, -6149, -6158, -6149, -6181, -6180, -6182, -6174, -6193, -6196,
        -6193, -6203, -6213, -6203, -6203, -6212, -6211, -6200, -6209, -6209,
        -6209, -6209, -6231, -6232, -6219, -6238, -6238, -6223, -6226, -6258,
        -6257, -6263, -6263, -6261, -6261, -6273, -6273, -6273, -6273, -6274,
        -6295, -6293, -6283, -6283, -6283, -6283, -6283, -6293, -6293, -6305,
        -6305, -6314, -6314, -6327, -6327, -6327, -6330, -6330, -6330, -6330,
        -6330, -6330, -6327, -6328, -6328, -6337, -6359, -6359, -6359, -6360,
        -6372, -6362, -6362, -6359, -6352, -6362, -6352, -6347, -6359, -6372,
        -6372, -6391, -6391, -6372, -6391, -6391, -6378, -6391, -6388, -6376,
        -6391, -6385, -6398, -6401, -6385, -6398, -6401, -6385, -6398, -6405,
        -6407, -6420, -6414, -6436, -6436, -6436, -6449, -6456, -6459, -6449,
        -6474, -6471, -6459, -6462, -6468, -6468, -6459, -6477, -6468, -6465,
        -6478, -6478, -6475, -6497, -6497, -6510, -6513, -6507, -6507, -6510,
        -6517, -6517, -6517, -6526, -6539, -6539, -6539, -6551, -6551, -6561,
        -6561, -6561, -6548, -6548, -6568, -6555, -6565, -6562, -6565, -6575,
        -6568, -6568, -6568, -6571, -6580, -6565, -6568, -6565, -6565, -6562,
        -6577, -6584, -6577, -6575, -6600, -6577, -6590, -6584, -6590, -6609,
        -6590, -6590, -6612, -6590, -6600, -6600, -6590, -6575, -6587, -6577,
        -6575, -6587, -6575, -6587, -6597, -6600, -6597, -6609, -6600, -6609,
        -6600, -6597, -6590, -6600, -6590, -6609, -6600, -6609, -6609, -6587,
        -6609, -6597, -6600, -6597, -6597, -6600, -6584, -6594, -6584, -6587,
        -6587, -6587, -6590, -6590, -6597, -6597, -6597, -6606, -6609, -6606,
        -6616, -6619, -6626, -6629, -6616, -6613, -6626, -6629, -6616, -6623,
        -6626, -6629, -6626, -6635, -6638, -6648, -6648, -6648, -6648, -6648,
        -6635, -6635, -6623, -6626, -6626, -6626, -6638, -6638, -6638, -6648,
        -6648, -6660, -6660, -6660, -6660, -6660, -6660, -6657, -6658, -6648,
        -6648, -6660, -6660, -6658, -6658, -6670, -6683, -6670, -6667, -6667,
        -6664, -6668, -6667, -6664, -6674, -6667, -6667, -6677, -6670, -6667,
        -6667, -6670, -6670, -6670, -6667, -6660, -6673, -6667, -6648, -6669,
        -6648, -6638, -6648, -6648, -6648, -6648, -6635, -6648, -6648, -6645,
        -6648, -6642, -6667, -6648, -6658, -6670, -6670, -6673, -6673, -6660,
        -6651, -6663, -6660, -6660, -6638, -6648, -6635, -6638, -6638, -6651,
        -6629, -6638, -6651, -6641, -6641, -6644, -6641, -6629, -6629, -6619,
        -6619, -6619, -6629, -6604, -6604, -6609, -6609, -6604, -6606, -6609,
        -6597, -6575, -6597, -6600, -6580, -6580, -6590, -6565, -6568, -6571,
        -6580, -6580, -6546, -6555, -6568, -6568, -6547, -6536, -6536, -6501,
        -6504, -6497, -6497, -6485, -6472, -6475, -6482, -6475, -6463, -6475,
        -6478, -6481, -6468, -6459, -6471, -6474, -6462, -6449, -6452, -6439,
        -6430, -6417, -6405, -6402, -6405, -6405, -6382, -6363, -6366, -6341,
        -6356, -6331, -6334, -6324, -6334, -6312, -6302, -6302, -6280, -6280,
        -6283, -6270, -6248, -6264, -6254, -6232, -6244, -6235, -6226, -6201,
        -6212, -6193, -6181, -6171, -6158, -6149, -6139, -6126, -6126, -6110,
        -6110, -6097, -6081, -6081, -6056, -6058, -6049, -6027, -6017, -6020,
        -6011, -5985, -5979, -5963, -5966, -5944, -5931, -5934, -5912, -5893,
        -5905, -5883, -5876, -5861, -5864, -5854, -5820, -5819, -5797, -5778,
        -5768, -5736, -5717, -5710, -5678, -5662, -5649, -5640, -5608, -5595,
        -5586, -5566, -5557
    };

    static const int16_t iso226_2023_curve_30_phons[985] =
    {
        -2569, -2581,
        -2576, -2566, -2591, -2598, -2610, -2591, -2601, -2601, -2598, -2613,
        -2610, -2607, -2620, -2633, -2627, -2639, -2639, -2636, -2636, -2636,
        -2649, -2656, -2656, -2665, -2665, -2675, -2697, -2685, -2709, -2710,
        -2722, -2697, -2719, -2732, -2735, -2725, -2732, -2754, -2754, -2761,
        -2764, -2761, -2771, -2783, -2771, -2780, -2780, -2793, -2787, -2793,
        -2802, -2802, -2815, -2812, -2802, -2802, -2834, -2831, -2822, -2841,
        -2854, -2851, -2851, -2863, -2873, -2870, -2870, -2895, -2886, -2880,
        -2904, -2895, -2895, -2914, -2915, -2924, -2934, -2934, -2946, -2946,
        -2956, -2953, -2975, -2985, -2963, -2985, -2982, -2992, -3004, -2989,
        -2992, -3001, -3014, -2989, -3001, -3014, -3021, -3014, -3024, -3033,
        -3033, -3053, -3055, -3053, -3075, -3065, -3078, -3087, -3075, -3090,
        -3087, -3097, -3097, -3100, -3110, -3110, -3132, -3126, -3126, -3139,
        -3145, -3145, -3133, -3155, -3169, -3161, -3180, -3180, -3183, -3190,
        -3193, -3202, -3215, -3222, -3202, -3212, -3222, -3241, -3241, -3253,
        -3260, -3273, -3260, -3270, -3282, -3295, -3302, -3295, -3308, -3314,
        -3311, -3302, -3314, -3309, -3299, -3324, -3321, -3334, -3321, -3343,
        -3334, -3343, -3353, -3363, -3363, -3363, -3360, -3385, -3392, -3404,
        -3397, -3404, -3429, -3414, -3426, -3417, -3423, -3421, -3446, -3421,
        -3443, -3440, -3462, -3450, -3465, -3472, -3469, -3490, -3469, -3490,
        -3501, -3506, -3513, -3513, -3523, -3535, -3535, -3548, -3567, -3577,
        -3567, -3577, -3577, -3590, -3580, -3590, -3590, -3596, -3587, -3599,
        -3606, -3603, -3616, -3603, -3616, -3635, -3650, -3645, -3670, -3673,
        -3660, -3695, -3682, -3692, -3689, -3702, -3714, -3699, -3711, -3708,
        -3708, -3708, -3708, -3731, -3728, -3731, -3755, -3753, -3772, -3774,
        -3772, -3794, -3791, -3791, -3804, -3801, -3816, -3811, -3814, -3836,
        -3823, -3836, -3858, -3868, -3858, -3865, -3865, -3862, -3874, -3884,
        -3881, -3894, -3903, -3903, -3926, -3926, -3938, -3941, -3938, -3963,
        -3948, -3957, -3960, -3957, -3977, -3967, -3977, -3974, -3986, -3995,
        -3996, -4006, -4003, -4015, -4025, -4038, -4038, -4038, -4050, -4035,
        -4054, -4060, -4054, -4069, -4076, -4079, -4101, -4098, -4111, -4111,
        -4108, -4127, -4108, -4127, -4140, -4128, -4137, -4153, -4150, -4153,
        -4162, -4176, -4172, -4184, -4197, -4204, -4207, -4216, -4213, -4213,
        -4226, -4223, -4223, -4236, -4233, -4233, -4255, -4255, -4239, -4265,
        -4274, -4259, -4274, -4294, -4281, -4294, -4294, -4305, -4294, -4303,
        -4312, -4303, -4313, -4332, -4346, -4332, -4354, -4357, -4352, -4364,
        -4386, -4399, -4386, -4402, -4409, -4408, -4408, -4418, -4431, -4427,
        -4428, -4437, -4440, -4437, -4457, -4457, -4457, -4454, -4454, -4473,
        -4485, -4486, -4486, -4498, -4508, -4522, -4508, -4518, -4515, -4540,
        -4527, -4537, -4537, -4562, -4562, -4547, -4562, -4562, -4581, -4584,
        -4581, -4591, -4601, -4604, -4601, -4610, -4620, -4636, -4632, -4635,
        -4658, -4658, -4660, -4667, -4667, -4667, -4670, -4689, -4677, -4699,
        -4687, -4709, -4709, -4709, -4706, -4709, -4728, -4718, -4718, -4728,
        -4728, -4753, -4752, -4747, -4747, -4757, -4760, -4770, -4791, -4782,
        -4789, -4789, -4799, -4811, -4810, -4818, -4821, -4830, -4840, -4828,
        -4840, -4850, -4840, -4859, -4850, -4850, -4850, -4847, -4847, -4834,
        -4854, -4869, -4857, -4879, -4891, -4891, -4911, -4909, -4911, -4930,
        -4933, -4933, -4928, -4927, -4930, -4940, -4949, -4940, -4927, -4946,
        -4949, -4959, -4959, -4959, -4981, -4984, -4984, -4981, -4997, -4997,
        -5015, -5003, -5016, -5028, -5028, -5038, -5051, -5038, -5035, -5045,
        -5047, -5035, -5035, -5045, -5055, -5055, -5057, -5064, -5067, -5055,
        -5074, -5074, -5083, -5099, -5108, -5118, -5106, -5136, -5125, -5125,
        -5135, -5125, -5125, -5128, -5128, -5127, -5125, -5128, -5128, -5147,
        -5135, -5135, -5154, -5144, -5157, -5176, -5178, -5169, -5179, -5192,
        -5189, -5198, -5208, -5198, -5208, -5218, -5217, -5205, -5205, -5215,
        -5206, -5224, -5227, -5227, -5224, -5234, -5234, -5219, -5231, -5244,
        -5253, -5259, -5258, -5247, -5247, -5250, -5259, -5259, -5269, -5269,
        -5272, -5279, -5269, -5269, -5279, -5269, -5269, -5279, -5279, -5300,
        -5300, -5300, -5301, -5304, -5313, -5313, -5316, -5316, -5316, -5316,
        -5316, -5316, -5313, -5314, -5314, -5323, -5336, -5336, -5336, -5336,
        -5348, -5348, -5348, -5345, -5348, -5348, -5348, -5342, -5345, -5358,
        -5348, -5367, -5367, -5358, -5377, -5377, -5364, -5387, -5384, -5362,
        -5387, -5381, -5384, -5387, -5381, -5374, -5387, -5371, -5374, -5381,
        -5384, -5396, -5391, -5393, -5403, -5413, -5406, -5413, -5425, -5416,
        -5431, -5428, -5425, -5419, -5425, -5425, -5406, -5425, -5425, -5413,
        -5435, -5425, -5422, -5445, -5435, -5448, -5450, -5445, -5445, -5457,
        -5464, -5464, -5463, -5464, -5477, -5477, -5477, -5489, -5489, -5489,
        -5498, -5499, -5486, -5486, -5496, -5493, -5493, -5480, -5503, -5503,
        -5496, -5505, -5505, -5508, -5508, -5503, -5505, -5493, -5503, -5490,
        -5515, -5512, -5515, -5503, -5528, -5505, -5518, -5503, -5518, -5528,
        -5528, -5528, -5540, -5528, -5528, -5537, -5518, -5503, -5525, -5505,
        -5503, -5515, -5512, -5515, -5515, -5537, -5525, -5537, -5528, -5528,
        -5528, -5515, -5528, -5518, -5518, -5528, -5518, -5528, -5528, -5515,
        -5528, -5515, -5508, -5515, -5515, -5528, -5512, -5522, -5503, -5525,
        -5525, -5505, -5518, -5528, -5515, -5525, -5525, -5525, -5547, -5534,
        -5544, -5557, -5544, -5557, -5554, -5541, -5563, -5566, -5563, -5561,
        -5563, -5566, -5554, -5564, -5576, -5576, -5576, -5576, -5576, -5576,
        -5563, -5563, -5551, -5563, -5563, -5563, -5566, -5566, -5566, -5566,
        -5566, -5579, -5579, -5579, -5579, -5579, -5579, -5576, -5576, -5566,
        -5566, -5579, -5579, -5576, -5576, -5579, -5591, -5579, -5566, -5566,
        -5554, -5566, -5557, -5554, -5563, -5566, -5566, -5576, -5569, -5566,
        -5566, -5569, -5579, -5569, -5566, -5579, -5572, -5566, -5566, -5568,
        -5566, -5566, -5576, -5566, -5576, -5576, -5554, -5566, -5566, -5554,
        -5566, -5551, -5566, -5557, -5557, -5569, -5560, -5562, -5582, -5560,
        -5569, -5582, -5569, -5579, -5557, -5557, -5554, -5557, -5557, -5569,
        -5547, -5557, -5569, -5560, -5569, -5572, -5560, -5557, -5547, -5537,
        -5537, -5547, -5547, -5522, -5522, -5547, -5547, -5522, -5525, -5528,
        -5515, -5512, -5515, -5528, -5528, -5528, -5528, -5493, -5496, -5508,
        -5499, -5508, -5474, -5474, -5477, -5486, -5475, -5464, -5464, -5439,
        -5451, -5445, -5445, -5432, -5429, -5442, -5439, -5432, -5429, -5422,
        -5435, -5438, -5425, -5416, -5419, -5421, -5409, -5396, -5409, -5396,
        -5387, -5374, -5371, -5368, -5371, -5371, -5359, -5339, -5342, -5317,
        -5333, -5308, -5310, -5291, -5310, -5288, -5279, -5279, -5266, -5266,
        -5269, -5247, -5224, -5230, -5230, -5208, -5221, -5211, -5192, -5168,
        -5169, -5169, -5147, -5147, -5125, -5125, -5125, -5103, -5103, -5106,
        -5096, -5074, -5077, -5067, -5042, -5035, -5035, -5023, -5003, -5006,
        -5006, -4981, -4974, -4949, -4952, -4930, -4908, -4920, -4898, -4879,
        -4901, -4879, -4872, -4847, -4850, -4850, -4815, -4815, -4793, -4773,
        -4773, -4751, -4732, -4735, -4713, -4706, -4684, -4674, -4661, -4639,
        -4620, -4620, -4610
    };

    static const int16_t iso226_2023_curve_40_phons[985] =
    {
        -2067, -2079,
        -2064, -2064, -2089, -2076, -2089, -2089, -2089, -2089, -2086, -2101,
        -2098, -2096, -2098, -2111, -2096, -2118, -2118, -2125, -2115, -2115,
        -2137, -2134, -2134, -2134, -2134, -2144, -2156, -2144, -2158, -2179,
        -2182, -2166, -2198, -2201, -2204, -2204, -2211, -2223, -2223, -2230,
        -2242, -2220, -2230, -2242, -2230, -2230, -2230, -2242, -2237, -2252,
        -2242, -2242, -2265, -2262, -2262, -2242, -2265, -2262, -2271, -2271,
        -2284, -2291, -2291, -2303, -2303, -2300, -2300, -2325, -2306, -2300,
        -2325, -2316, -2316, -2334, -2335, -2345, -2345, -2354, -2367, -2377,
        -2367, -2364, -2377, -2386, -2383, -2386, -2383, -2393, -2396, -2380,
        -2393, -2393, -2396, -2390, -2403, -2415, -2422, -2425, -2435, -2435,
        -2434, -2454, -2466, -2444, -2466, -2466, -2469, -2469, -2466, -2472,
        -2479, -2479, -2479, -2492, -2482, -2492, -2504, -2498, -2489, -2501,
        -2508, -2518, -2515, -2537, -2551, -2543, -2562, -2562, -2575, -2581,
        -2575, -2584, -2587, -2584, -2584, -2575, -2584, -2604, -2604, -2616,
        -2604, -2626, -2613, -2613, -2626, -2638, -2626, -2638, -2651, -2638,
        -2635, -2645, -2648, -2633, -2642, -2667, -2655, -2667, -2664, -2687,
        -2687, -2687, -2696, -2696, -2696, -2706, -2684, -2709, -2716, -2718,
        -2721, -2728, -2744, -2728, -2750, -2741, -2738, -2745, -2760, -2745,
        -2767, -2764, -2767, -2764, -2779, -2786, -2774, -2795, -2774, -2795,
        -2805, -2830, -2818, -2818, -2828, -2840, -2840, -2843, -2843, -2862,
        -2853, -2853, -2862, -2875, -2875, -2875, -2875, -2862, -2872, -2885,
        -2872, -2869, -2891, -2888, -2891, -2911, -2935, -2920, -2936, -2958,
        -2955, -2961, -2968, -2968, -2945, -2968, -2980, -2955, -2977, -2974,
        -2984, -2984, -2984, -2997, -2984, -2997, -3021, -3009, -3019, -3021,
        -3019, -3041, -3028, -3048, -3051, -3048, -3073, -3057, -3070, -3083,
        -3070, -3083, -3095, -3095, -3105, -3102, -3102, -3109, -3102, -3121,
        -3118, -3121, -3131, -3140, -3153, -3153, -3166, -3178, -3166, -3181,
        -3175, -3175, -3188, -3175, -3185, -3185, -3185, -3182, -3195, -3204,
        -3204, -3204, -3201, -3214, -3214, -3226, -3226, -3236, -3249, -3233,
        -3243, -3268, -3252, -3268, -3265, -3287, -3300, -3297, -3319, -3319,
        -3316, -3326, -3316, -3316, -3329, -3317, -3316, -3341, -3338, -3341,
        -3351, -3355, -3351, -3364, -3376, -3373, -3376, -3386, -3393, -3393,
        -3405, -3402, -3402, -3405, -3412, -3412, -3424, -3434, -3428, -3434,
        -3444, -3419, -3444, -3444, -3450, -3444, -3463, -3475, -3453, -3473,
        -3491, -3482, -3482, -3482, -3506, -3482, -3495, -3507, -3502, -3505,
        -3517, -3529, -3507, -3533, -3530, -3539, -3530, -3549, -3561, -3558,
        -3549, -3559, -3561, -3559, -3568, -3578, -3578, -3565, -3585, -3585,
        -3607, -3597, -3597, -3610, -3619, -3634, -3619, -3629, -3626, -3651,
        -3629, -3648, -3648, -3664, -3673, -3658, -3674, -3674, -3692, -3686,
        -3683, -3693, -3702, -3705, -3693, -3712, -3712, -3718, -3725, -3728,
        -3740, -3750, -3743, -3760, -3750, -3750, -3762, -3762, -3769, -3772,
        -3779, -3782, -3801, -3791, -3779, -3801, -3801, -3811, -3801, -3801,
        -3811, -3826, -3825, -3830, -3820, -3820, -3823, -3843, -3854, -3855,
        -3843, -3852, -3862, -3865, -3883, -3872, -3884, -3894, -3894, -3900,
        -3903, -3913, -3913, -3913, -3923, -3923, -3913, -3910, -3920, -3907,
        -3927, -3941, -3929, -3952, -3955, -3955, -3974, -3962, -3965, -3984,
        -3986, -3996, -3981, -3981, -3984, -4003, -4003, -3993, -4000, -4000,
        -4003, -4003, -4013, -4013, -4015, -4038, -4038, -4025, -4041, -4050,
        -4049, -4038, -4050, -4063, -4063, -4072, -4085, -4072, -4070, -4089,
        -4091, -4069, -4080, -4089, -4089, -4089, -4111, -4098, -4102, -4098,
        -4098, -4108, -4098, -4114, -4133, -4133, -4121, -4142, -4140, -4140,
        -4140, -4140, -4150, -4153, -4162, -4171, -4159, -4162, -4162, -4182,
        -4169, -4169, -4169, -4160, -4182, -4181, -4183, -4184, -4184, -4187,
        -4194, -4204, -4204, -4204, -4204, -4204, -4212, -4201, -4201, -4210,
        -4220, -4220, -4223, -4233, -4220, -4220, -4220, -4205, -4208, -4229,
        -4229, -4235, -4235, -4233, -4233, -4236, -4245, -4245, -4255, -4255,
        -4258, -4265, -4255, -4265, -4265, -4265, -4265, -4265, -4274, -4286,
        -4286, -4286, -4286, -4289, -4289, -4299, -4302, -4302, -4312, -4312,
        -4312, -4312, -4309, -4310, -4310, -4319, -4331, -4331, -4331, -4332,
        -4344, -4344, -4344, -4341, -4334, -4344, -4344, -4328, -4331, -4344,
        -4344, -4353, -4353, -4344, -4363, -4363, -4341, -4363, -4360, -4338,
        -4363, -4348, -4351, -4363, -4357, -4351, -4363, -4357, -4351, -4357,
        -4360, -4373, -4367, -4389, -4389, -4389, -4402, -4389, -4402, -4402,
        -4407, -4405, -4402, -4395, -4402, -4401, -4382, -4401, -4392, -4379,
        -4402, -4402, -4389, -4402, -4402, -4414, -4417, -4411, -4411, -4424,
        -4421, -4421, -4421, -4421, -4434, -4434, -4434, -4446, -4446, -4446,
        -4446, -4456, -4443, -4443, -4443, -4431, -4431, -4428, -4440, -4440,
        -4443, -4453, -4443, -4456, -4465, -4441, -4453, -4440, -4450, -4447,
        -4463, -4460, -4472, -4450, -4465, -4463, -4465, -4460, -4465, -4475,
        -4475, -4465, -4488, -4475, -4475, -4475, -4465, -4460, -4472, -4463,
        -4469, -4463, -4469, -4472, -4472, -4485, -4472, -4485, -4465, -4485,
        -4465, -4463, -4465, -4465, -4465, -4475, -4475, -4475, -4485, -4472,
        -4485, -4472, -4475, -4472, -4463, -4485, -4460, -4469, -4460, -4463,
        -4472, -4463, -4465, -4475, -4472, -4472, -4463, -4472, -4485, -4472,
        -4472, -4494, -4482, -4485, -4482, -4479, -4482, -4494, -4492, -4479,
        -4492, -4504, -4492, -4492, -4514, -4514, -4514, -4514, -4514, -4523,
        -4501, -4501, -4489, -4492, -4501, -4501, -4504, -4504, -4504, -4504,
        -4504, -4517, -4517, -4517, -4517, -4517, -4517, -4504, -4504, -4494,
        -4494, -4507, -4517, -4514, -4514, -4526, -4529, -4517, -4514, -4514,
        -4511, -4523, -4504, -4501, -4511, -4523, -4504, -4514, -4526, -4514,
        -4504, -4517, -4526, -4507, -4504, -4517, -4520, -4504, -4504, -4515,
        -4504, -4494, -4504, -4504, -4504, -4504, -4482, -4504, -4504, -4492,
        -4504, -4489, -4494, -4494, -4485, -4497, -4497, -4500, -4510, -4497,
        -4497, -4500, -4488, -4497, -4485, -4485, -4482, -4494, -4494, -4507,
        -4485, -4504, -4507, -4497, -4497, -4510, -4498, -4494, -4504, -4494,
        -4485, -4485, -4494, -4469, -4469, -4475, -4485, -4460, -4463, -4475,
        -4472, -4460, -4482, -4485, -4475, -4475, -4485, -4460, -4463, -4475,
        -4475, -4475, -4440, -4441, -4443, -4443, -4442, -4431, -4431, -4415,
        -4418, -4421, -4421, -4408, -4406, -4418, -4406, -4408, -4396, -4399,
        -4402, -4405, -4392, -4382, -4405, -4398, -4385, -4373, -4385, -4373,
        -4363, -4351, -4348, -4335, -4348, -4338, -4325, -4316, -4328, -4303,
        -4309, -4294, -4296, -4287, -4296, -4274, -4274, -4265, -4242, -4242,
        -4245, -4233, -4210, -4226, -4226, -4204, -4216, -4207, -4198, -4182,
        -4184, -4175, -4162, -4162, -4150, -4140, -4140, -4137, -4118, -4121,
        -4121, -4098, -4101, -4092, -4067, -4069, -4069, -4047, -4038, -4041,
        -4050, -4025, -4018, -4003, -4006, -3984, -3971, -3974, -3952, -3942,
        -3955, -3932, -3926, -3910, -3913, -3903, -3888, -3869, -3856, -3846,
        -3837, -3815, -3805, -3808, -3776, -3779, -3766, -3747, -3734, -3722,
        -3712, -3703, -3693
    };

    static const int16_t iso226_2023_curve_50_phons[985] =
    {
        -1574, -1587,
        -1571, -1562, -1587, -1574, -1587, -1587, -1597, -1577, -1574, -1599,
        -1596, -1593, -1606, -1628, -1613, -1625, -1625, -1622, -1632, -1613,
        -1625, -1622, -1622, -1613, -1613, -1622, -1635, -1642, -1656, -1657,
        -1670, -1664, -1657, -1670, -1682, -1682, -1679, -1692, -1682, -1689,
        -1702, -1679, -1689, -1702, -1699, -1699, -1699, -1702, -1696, -1711,
        -1721, -1721, -1724, -1721, -1721, -1711, -1724, -1721, -1721, -1721,
        -1733, -1740, -1740, -1753, -1753, -1740, -1740, -1765, -1756, -1740,
        -1765, -1765, -1756, -1774, -1775, -1794, -1795, -1794, -1807, -1816,
        -1807, -1814, -1816, -1826, -1823, -1826, -1823, -1833, -1836, -1820,
        -1833, -1833, -1845, -1820, -1833, -1836, -1833, -1836, -1845, -1845,
        -1836, -1855, -1868, -1865, -1877, -1868, -1880, -1890, -1868, -1893,
        -1890, -1900, -1890, -1893, -1902, -1912, -1925, -1900, -1909, -1922,
        -1909, -1919, -1906, -1919, -1943, -1934, -1944, -1944, -1947, -1954,
        -1957, -1957, -1959, -1966, -1957, -1966, -1966, -1985, -1976, -1998,
        -1985, -1998, -1995, -1995, -2008, -2001, -2008, -2020, -2023, -2020,
        -2017, -2018, -2020, -2014, -2005, -2030, -2027, -2030, -2027, -2040,
        -2040, -2040, -2040, -2049, -2049, -2059, -2046, -2062, -2059, -2071,
        -2074, -2071, -2097, -2081, -2094, -2084, -2091, -2088, -2103, -2088,
        -2110, -2107, -2110, -2107, -2123, -2120, -2117, -2128, -2117, -2129,
        -2129, -2145, -2132, -2142, -2142, -2154, -2164, -2167, -2177, -2186,
        -2177, -2186, -2186, -2199, -2199, -2209, -2189, -2196, -2186, -2199,
        -2186, -2174, -2196, -2193, -2196, -2215, -2230, -2215, -2231, -2243,
        -2231, -2256, -2243, -2253, -2240, -2253, -2265, -2250, -2263, -2250,
        -2260, -2269, -2260, -2282, -2269, -2282, -2306, -2295, -2304, -2316,
        -2314, -2317, -2314, -2314, -2326, -2323, -2339, -2323, -2336, -2358,
        -2346, -2349, -2371, -2371, -2371, -2368, -2368, -2365, -2358, -2378,
        -2365, -2378, -2378, -2378, -2390, -2390, -2403, -2415, -2403, -2428,
        -2412, -2422, -2425, -2422, -2432, -2432, -2441, -2429, -2441, -2450,
        -2441, -2451, -2448, -2451, -2461, -2473, -2473, -2483, -2486, -2461,
        -2480, -2486, -2470, -2486, -2473, -2495, -2508, -2505, -2508, -2518,
        -2515, -2534, -2515, -2524, -2547, -2525, -2534, -2549, -2537, -2549,
        -2549, -2553, -2549, -2562, -2575, -2572, -2575, -2584, -2591, -2591,
        -2594, -2601, -2591, -2604, -2601, -2591, -2613, -2613, -2607, -2613,
        -2633, -2607, -2623, -2633, -2620, -2633, -2633, -2654, -2633, -2652,
        -2651, -2652, -2652, -2661, -2676, -2652, -2674, -2677, -2671, -2674,
        -2677, -2699, -2677, -2692, -2699, -2708, -2699, -2699, -2721, -2708,
        -2718, -2709, -2711, -2718, -2719, -2709, -2728, -2716, -2735, -2735,
        -2747, -2747, -2747, -2760, -2770, -2794, -2770, -2779, -2777, -2801,
        -2779, -2789, -2799, -2814, -2805, -2799, -2804, -2804, -2823, -2817,
        -2804, -2824, -2824, -2827, -2824, -2824, -2834, -2849, -2836, -2849,
        -2861, -2861, -2874, -2871, -2871, -2871, -2874, -2874, -2881, -2884,
        -2871, -2893, -2893, -2893, -2890, -2893, -2903, -2903, -2903, -2913,
        -2913, -2918, -2937, -2922, -2922, -2932, -2925, -2945, -2956, -2947,
        -2935, -2954, -2954, -2957, -2975, -2964, -2967, -2986, -2986, -2993,
        -2996, -2996, -2996, -3005, -2996, -2996, -3005, -2993, -2993, -2990,
        -2999, -3014, -3003, -3015, -3018, -3027, -3027, -3016, -3038, -3037,
        -3040, -3059, -3035, -3044, -3056, -3056, -3066, -3066, -3054, -3054,
        -3076, -3066, -3066, -3066, -3088, -3091, -3091, -3098, -3104, -3104,
        -3103, -3111, -3113, -3116, -3117, -3136, -3139, -3126, -3123, -3124,
        -3145, -3123, -3123, -3123, -3142, -3142, -3155, -3133, -3145, -3142,
        -3142, -3143, -3142, -3158, -3167, -3167, -3155, -3186, -3174, -3174,
        -3184, -3174, -3184, -3187, -3187, -3195, -3184, -3187, -3187, -3187,
        -3184, -3184, -3184, -3184, -3196, -3196, -3198, -3190, -3199, -3202,
        -3199, -3219, -3219, -3209, -3219, -3219, -3227, -3216, -3216, -3225,
        -3225, -3225, -3238, -3238, -3225, -3235, -3235, -3229, -3232, -3254,
        -3254, -3260, -3259, -3248, -3258, -3260, -3260, -3270, -3280, -3280,
        -3282, -3280, -3280, -3280, -3280, -3280, -3280, -3280, -3280, -3301,
        -3301, -3301, -3301, -3304, -3304, -3304, -3307, -3307, -3307, -3307,
        -3307, -3308, -3305, -3315, -3315, -3324, -3337, -3337, -3327, -3327,
        -3339, -3339, -3330, -3327, -3330, -3330, -3330, -3324, -3337, -3340,
        -3339, -3359, -3359, -3359, -3359, -3359, -3346, -3349, -3337, -3334,
        -3349, -3334, -3346, -3359, -3343, -3346, -3359, -3353, -3356, -3353,
        -3365, -3378, -3363, -3375, -3375, -3385, -3378, -3385, -3397, -3388,
        -3403, -3400, -3378, -3391, -3388, -3378, -3368, -3377, -3378, -3365,
        -3378, -3378, -3375, -3378, -3378, -3391, -3384, -3378, -3378, -3381,
        -3388, -3388, -3388, -3388, -3400, -3400, -3400, -3413, -3413, -3413,
        -3422, -3422, -3410, -3410, -3420, -3407, -3407, -3404, -3407, -3417,
        -3410, -3410, -3420, -3422, -3422, -3417, -3420, -3407, -3417, -3404,
        -3420, -3417, -3420, -3407, -3422, -3410, -3422, -3417, -3432, -3442,
        -3432, -3432, -3445, -3432, -3432, -3432, -3422, -3417, -3429, -3429,
        -3426, -3429, -3426, -3429, -3420, -3442, -3429, -3442, -3432, -3442,
        -3422, -3429, -3422, -3422, -3422, -3432, -3432, -3442, -3442, -3420,
        -3442, -3439, -3442, -3429, -3429, -3442, -3417, -3417, -3407, -3420,
        -3420, -3420, -3422, -3432, -3429, -3429, -3439, -3439, -3442, -3430,
        -3449, -3451, -3439, -3451, -3449, -3436, -3439, -3461, -3449, -3436,
        -3449, -3451, -3439, -3449, -3451, -3451, -3452, -3461, -3461, -3461,
        -3458, -3458, -3446, -3458, -3458, -3458, -3452, -3451, -3451, -3451,
        -3442, -3454, -3454, -3454, -3454, -3454, -3454, -3451, -3452, -3451,
        -3451, -3464, -3464, -3461, -3461, -3464, -3476, -3454, -3451, -3451,
        -3439, -3451, -3451, -3439, -3449, -3461, -3451, -3461, -3474, -3461,
        -3461, -3474, -3464, -3464, -3461, -3454, -3467, -3461, -3442, -3463,
        -3451, -3442, -3461, -3442, -3451, -3442, -3439, -3442, -3442, -3449,
        -3442, -3436, -3442, -3442, -3442, -3454, -3454, -3457, -3467, -3454,
        -3454, -3467, -3454, -3454, -3442, -3451, -3439, -3451, -3442, -3464,
        -3442, -3442, -3445, -3435, -3445, -3448, -3435, -3432, -3442, -3432,
        -3422, -3432, -3442, -3417, -3417, -3442, -3442, -3417, -3420, -3422,
        -3429, -3417, -3429, -3442, -3442, -3442, -3442, -3417, -3429, -3432,
        -3442, -3442, -3417, -3407, -3420, -3420, -3409, -3407, -3407, -3392,
        -3394, -3397, -3398, -3395, -3382, -3385, -3382, -3375, -3363, -3375,
        -3378, -3381, -3378, -3378, -3371, -3374, -3371, -3359, -3362, -3349,
        -3349, -3337, -3324, -3321, -3324, -3314, -3302, -3302, -3305, -3280,
        -3305, -3280, -3292, -3282, -3292, -3280, -3280, -3280, -3257, -3257,
        -3260, -3238, -3235, -3241, -3231, -3228, -3241, -3231, -3232, -3217,
        -3219, -3209, -3187, -3187, -3174, -3155, -3155, -3152, -3152, -3145,
        -3145, -3133, -3136, -3136, -3111, -3113, -3113, -3101, -3091, -3094,
        -3094, -3069, -3072, -3047, -3050, -3046, -3025, -3027, -3005, -3005,
        -3008, -3005, -2999, -2983, -2986, -2986, -2971, -2951, -2948, -2939,
        -2939, -2916, -2916, -2910, -2887, -2890, -2878, -2868, -2856, -2843,
        -2833, -2833, -2824
    };

    static const int16_t iso226_2023_curve_60_phons[985] =
    {
        -1111, -1123,
        -1108, -1098, -1123, -1111, -1123, -1123, -1114, -1114, -1111, -1126,
        -1113, -1111, -1123, -1126, -1111, -1133, -1133, -1130, -1130, -1130,
        -1142, -1130, -1130, -1130, -1130, -1130, -1133, -1130, -1154, -1145,
        -1148, -1142, -1155, -1158, -1161, -1161, -1168, -1161, -1161, -1168,
        -1180, -1177, -1177, -1180, -1177, -1187, -1187, -1190, -1184, -1190,
        -1190, -1180, -1202, -1190, -1190, -1180, -1202, -1199, -1209, -1209,
        -1222, -1219, -1219, -1231, -1222, -1219, -1219, -1234, -1225, -1219,
        -1234, -1225, -1225, -1233, -1234, -1234, -1244, -1244, -1247, -1256,
        -1256, -1253, -1256, -1256, -1263, -1266, -1263, -1263, -1266, -1251,
        -1253, -1263, -1276, -1260, -1273, -1276, -1273, -1285, -1285, -1295,
        -1295, -1295, -1308, -1295, -1317, -1298, -1301, -1310, -1298, -1313,
        -1310, -1310, -1301, -1313, -1313, -1333, -1326, -1320, -1320, -1333,
        -1329, -1330, -1317, -1330, -1344, -1345, -1355, -1345, -1358, -1355,
        -1367, -1367, -1370, -1367, -1358, -1358, -1367, -1377, -1367, -1390,
        -1367, -1390, -1387, -1387, -1399, -1393, -1390, -1393, -1386, -1393,
        -1380, -1390, -1383, -1377, -1387, -1402, -1390, -1412, -1399, -1412,
        -1422, -1422, -1422, -1431, -1431, -1431, -1419, -1444, -1441, -1444,
        -1436, -1444, -1459, -1453, -1466, -1456, -1453, -1450, -1466, -1460,
        -1473, -1460, -1482, -1460, -1466, -1473, -1450, -1471, -1460, -1472,
        -1473, -1498, -1485, -1485, -1485, -1488, -1498, -1501, -1510, -1520,
        -1520, -1530, -1520, -1533, -1523, -1523, -1513, -1520, -1520, -1523,
        -1520, -1508, -1520, -1507, -1520, -1530, -1545, -1530, -1545, -1567,
        -1545, -1570, -1567, -1558, -1555, -1567, -1570, -1564, -1587, -1564,
        -1584, -1584, -1584, -1596, -1584, -1596, -1601, -1599, -1599, -1591,
        -1599, -1612, -1599, -1609, -1612, -1609, -1634, -1609, -1621, -1644,
        -1621, -1644, -1647, -1647, -1647, -1634, -1644, -1631, -1634, -1644,
        -1631, -1644, -1653, -1653, -1666, -1666, -1678, -1681, -1669, -1694,
        -1669, -1678, -1681, -1678, -1698, -1678, -1698, -1685, -1698, -1707,
        -1698, -1707, -1695, -1707, -1707, -1710, -1720, -1710, -1713, -1707,
        -1707, -1713, -1707, -1713, -1710, -1723, -1745, -1732, -1755, -1745,
        -1742, -1752, -1752, -1752, -1774, -1752, -1761, -1777, -1774, -1777,
        -1777, -1781, -1777, -1780, -1802, -1789, -1792, -1802, -1789, -1799,
        -1802, -1789, -1799, -1802, -1809, -1799, -1812, -1821, -1816, -1821,
        -1822, -1816, -1821, -1831, -1828, -1821, -1831, -1843, -1821, -1841,
        -1840, -1831, -1841, -1860, -1865, -1841, -1863, -1866, -1850, -1863,
        -1875, -1888, -1866, -1872, -1888, -1878, -1878, -1888, -1891, -1897,
        -1888, -1878, -1900, -1888, -1888, -1888, -1898, -1885, -1895, -1904,
        -1907, -1907, -1907, -1910, -1920, -1924, -1910, -1910, -1907, -1932,
        -1910, -1910, -1929, -1935, -1945, -1929, -1945, -1955, -1954, -1957,
        -1955, -1955, -1954, -1967, -1955, -1955, -1964, -1980, -1967, -1989,
        -1992, -1992, -2005, -2002, -1993, -2002, -2005, -2005, -2012, -2014,
        -2002, -2024, -2024, -2014, -2012, -2024, -2024, -2015, -2005, -2024,
        -2024, -2030, -2048, -2034, -2024, -2034, -2037, -2046, -2049, -2049,
        -2046, -2046, -2046, -2068, -2067, -2056, -2069, -2078, -2078, -2066,
        -2078, -2088, -2078, -2078, -2088, -2088, -2088, -2075, -2085, -2072,
        -2072, -2107, -2095, -2098, -2100, -2101, -2110, -2108, -2111, -2110,
        -2132, -2132, -2108, -2127, -2129, -2129, -2139, -2139, -2126, -2126,
        -2139, -2139, -2139, -2149, -2152, -2154, -2164, -2152, -2157, -2167,
        -2166, -2155, -2167, -2170, -2170, -2189, -2192, -2180, -2186, -2177,
        -2179, -2167, -2167, -2167, -2177, -2177, -2179, -2186, -2189, -2177,
        -2186, -2186, -2177, -2202, -2201, -2201, -2199, -2210, -2199, -2199,
        -2209, -2199, -2199, -2211, -2221, -2220, -2209, -2212, -2221, -2221,
        -2218, -2218, -2218, -2218, -2240, -2240, -2242, -2243, -2234, -2237,
        -2243, -2253, -2253, -2243, -2244, -2253, -2252, -2240, -2240, -2250,
        -2250, -2250, -2262, -2272, -2260, -2260, -2260, -2244, -2247, -2260,
        -2269, -2275, -2284, -2272, -2273, -2285, -2285, -2285, -2276, -2285,
        -2288, -2285, -2275, -2275, -2275, -2266, -2266, -2266, -2275, -2287,
        -2287, -2297, -2297, -2300, -2300, -2300, -2303, -2303, -2303, -2303,
        -2303, -2303, -2300, -2301, -2301, -2310, -2323, -2323, -2323, -2323,
        -2335, -2325, -2325, -2323, -2316, -2325, -2325, -2320, -2323, -2335,
        -2335, -2335, -2335, -2335, -2335, -2335, -2323, -2335, -2332, -2320,
        -2335, -2320, -2323, -2335, -2320, -2332, -2335, -2320, -2332, -2329,
        -2332, -2345, -2339, -2351, -2351, -2361, -2354, -2361, -2374, -2354,
        -2379, -2377, -2354, -2367, -2354, -2354, -2335, -2354, -2354, -2332,
        -2354, -2354, -2332, -2355, -2354, -2348, -2360, -2354, -2354, -2357,
        -2364, -2364, -2364, -2364, -2377, -2367, -2367, -2380, -2380, -2380,
        -2380, -2380, -2367, -2377, -2377, -2364, -2374, -2361, -2364, -2374,
        -2367, -2377, -2377, -2389, -2399, -2374, -2377, -2374, -2374, -2361,
        -2377, -2364, -2377, -2364, -2389, -2367, -2389, -2374, -2389, -2399,
        -2389, -2389, -2402, -2389, -2380, -2389, -2380, -2354, -2377, -2367,
        -2364, -2367, -2374, -2367, -2367, -2389, -2377, -2389, -2380, -2399,
        -2389, -2386, -2389, -2389, -2379, -2399, -2389, -2389, -2399, -2377,
        -2389, -2386, -2389, -2386, -2386, -2399, -2374, -2393, -2374, -2377,
        -2396, -2377, -2389, -2399, -2386, -2387, -2386, -2396, -2399, -2387,
        -2396, -2408, -2396, -2408, -2406, -2393, -2396, -2408, -2396, -2383,
        -2396, -2399, -2386, -2396, -2399, -2399, -2399, -2399, -2408, -2408,
        -2396, -2406, -2393, -2396, -2396, -2396, -2399, -2399, -2399, -2399,
        -2399, -2411, -2411, -2411, -2411, -2411, -2411, -2399, -2399, -2399,
        -2389, -2402, -2411, -2399, -2399, -2411, -2414, -2402, -2399, -2389,
        -2386, -2399, -2389, -2386, -2396, -2399, -2399, -2408, -2411, -2399,
        -2399, -2411, -2411, -2402, -2399, -2411, -2414, -2399, -2399, -2420,
        -2399, -2399, -2399, -2389, -2399, -2399, -2386, -2399, -2399, -2406,
        -2399, -2393, -2408, -2389, -2389, -2402, -2402, -2405, -2414, -2402,
        -2402, -2405, -2402, -2411, -2399, -2389, -2386, -2399, -2389, -2402,
        -2389, -2399, -2402, -2402, -2402, -2405, -2411, -2399, -2408, -2399,
        -2399, -2399, -2399, -2393, -2393, -2399, -2399, -2383, -2396, -2399,
        -2386, -2383, -2396, -2399, -2389, -2389, -2389, -2374, -2377, -2380,
        -2380, -2380, -2364, -2374, -2377, -2377, -2375, -2374, -2374, -2349,
        -2361, -2364, -2364, -2351, -2339, -2342, -2339, -2342, -2329, -2332,
        -2345, -2348, -2345, -2345, -2357, -2360, -2357, -2345, -2357, -2345,
        -2335, -2323, -2320, -2317, -2320, -2320, -2317, -2307, -2310, -2295,
        -2300, -2295, -2297, -2288, -2297, -2285, -2285, -2285, -2263, -2272,
        -2285, -2263, -2260, -2275, -2266, -2253, -2266, -2256, -2247, -2241,
        -2234, -2234, -2231, -2211, -2209, -2209, -2199, -2186, -2186, -2189,
        -2180, -2167, -2170, -2170, -2154, -2148, -2157, -2145, -2145, -2148,
        -2148, -2132, -2126, -2110, -2123, -2110, -2098, -2110, -2098, -2078,
        -2091, -2078, -2071, -2056, -2069, -2078, -2053, -2043, -2040, -2041,
        -2031, -2018, -2009, -2012, -1999, -1992, -1980, -1980, -1967, -1964,
        -1955, -1955, -1955
    };

    static const int16_t iso226_2023_curve_70_phons[985] =
    {
        -628, -640,
        -615, -615, -640, -628, -640, -640, -641, -640, -628, -653,
        -640, -628, -640, -653, -628, -640, -640, -628, -628, -628,
        -640, -628, -628, -628, -628, -628, -640, -628, -652, -653,
        -665, -640, -653, -665, -678, -678, -665, -678, -678, -665,
        -678, -665, -665, -678, -665, -665, -665, -678, -653, -678,
        -678, -678, -690, -678, -678, -678, -690, -678, -678, -678,
        -690, -678, -678, -690, -690, -678, -678, -703, -703, -678,
        -702, -703, -703, -702, -703, -703, -704, -703, -716, -716,
        -716, -703, -716, -716, -703, -716, -703, -703, -716, -690,
        -703, -703, -716, -690, -703, -716, -703, -716, -716, -716,
        -715, -716, -728, -716, -728, -728, -741, -741, -728, -753,
        -741, -741, -741, -753, -753, -753, -766, -741, -741, -753,
        -740, -741, -728, -741, -765, -766, -766, -766, -778, -766,
        -778, -778, -791, -778, -778, -778, -778, -778, -778, -791,
        -778, -791, -778, -778, -791, -803, -791, -803, -816, -804,
        -791, -792, -803, -778, -778, -803, -791, -803, -791, -803,
        -803, -803, -803, -803, -803, -803, -791, -816, -803, -816,
        -828, -816, -841, -816, -829, -829, -816, -803, -829, -803,
        -816, -803, -816, -803, -829, -816, -803, -815, -803, -815,
        -816, -841, -829, -829, -829, -841, -841, -854, -854, -854,
        -854, -854, -854, -866, -866, -866, -866, -854, -854, -866,
        -854, -842, -854, -841, -854, -854, -878, -854, -879, -891,
        -879, -904, -891, -891, -879, -892, -903, -879, -891, -879,
        -879, -879, -879, -891, -879, -891, -916, -904, -904, -915,
        -904, -916, -904, -904, -916, -904, -929, -904, -916, -929,
        -916, -929, -942, -942, -942, -930, -929, -916, -929, -929,
        -916, -929, -929, -929, -942, -942, -954, -967, -954, -979,
        -954, -954, -967, -954, -955, -954, -954, -942, -954, -953,
        -954, -954, -942, -954, -954, -967, -967, -967, -979, -954,
        -954, -979, -954, -979, -967, -979, -992, -979, -992, -992,
        -979, -979, -979, -979, -992, -980, -979, -1004, -992, -1004,
        -1004, -1018, -1004, -1017, -1029, -1017, -1029, -1029, -1017, -1017,
        -1029, -1017, -1017, -1029, -1017, -1017, -1029, -1029, -1004, -1029,
        -1029, -1004, -1029, -1029, -1017, -1029, -1029, -1041, -1029, -1029,
        -1029, -1029, -1029, -1029, -1053, -1029, -1042, -1055, -1030, -1043,
        -1055, -1067, -1055, -1080, -1068, -1066, -1067, -1067, -1080, -1066,
        -1067, -1067, -1079, -1067, -1068, -1067, -1067, -1055, -1055, -1055,
        -1067, -1067, -1067, -1080, -1080, -1104, -1080, -1080, -1068, -1092,
        -1080, -1080, -1080, -1105, -1105, -1080, -1105, -1105, -1104, -1117,
        -1105, -1105, -1105, -1117, -1105, -1105, -1105, -1130, -1117, -1130,
        -1142, -1142, -1155, -1143, -1142, -1142, -1155, -1155, -1142, -1155,
        -1143, -1155, -1155, -1155, -1143, -1155, -1155, -1155, -1155, -1155,
        -1155, -1180, -1179, -1155, -1155, -1155, -1168, -1168, -1179, -1180,
        -1168, -1168, -1168, -1180, -1179, -1168, -1180, -1180, -1180, -1168,
        -1180, -1180, -1180, -1180, -1180, -1180, -1180, -1168, -1168, -1155,
        -1155, -1180, -1168, -1180, -1193, -1193, -1193, -1182, -1193, -1193,
        -1205, -1205, -1181, -1180, -1193, -1193, -1193, -1193, -1180, -1180,
        -1193, -1193, -1193, -1193, -1205, -1218, -1218, -1205, -1230, -1230,
        -1229, -1218, -1230, -1243, -1243, -1243, -1255, -1243, -1230, -1231,
        -1243, -1230, -1230, -1230, -1230, -1231, -1243, -1230, -1243, -1230,
        -1230, -1231, -1230, -1255, -1255, -1255, -1243, -1254, -1243, -1243,
        -1244, -1243, -1243, -1255, -1255, -1254, -1243, -1255, -1255, -1255,
        -1243, -1243, -1243, -1243, -1255, -1255, -1267, -1268, -1268, -1281,
        -1268, -1268, -1269, -1268, -1268, -1268, -1267, -1255, -1255, -1255,
        -1255, -1255, -1267, -1267, -1255, -1255, -1255, -1230, -1243, -1255,
        -1255, -1280, -1280, -1268, -1269, -1281, -1281, -1281, -1281, -1281,
        -1292, -1281, -1281, -1281, -1281, -1281, -1281, -1281, -1281, -1293,
        -1293, -1293, -1293, -1305, -1305, -1305, -1318, -1318, -1318, -1318,
        -1318, -1318, -1306, -1307, -1307, -1306, -1318, -1318, -1318, -1319,
        -1331, -1331, -1331, -1318, -1331, -1331, -1331, -1306, -1318, -1331,
        -1331, -1331, -1331, -1331, -1331, -1331, -1318, -1331, -1318, -1306,
        -1331, -1306, -1318, -1331, -1306, -1318, -1331, -1306, -1318, -1306,
        -1318, -1331, -1306, -1318, -1318, -1318, -1331, -1318, -1331, -1331,
        -1355, -1343, -1331, -1343, -1331, -1331, -1331, -1330, -1331, -1318,
        -1331, -1331, -1318, -1332, -1331, -1343, -1356, -1331, -1331, -1343,
        -1331, -1331, -1331, -1331, -1343, -1343, -1343, -1356, -1356, -1356,
        -1356, -1356, -1343, -1343, -1343, -1331, -1331, -1318, -1331, -1331,
        -1343, -1343, -1343, -1356, -1356, -1332, -1343, -1331, -1331, -1318,
        -1343, -1331, -1343, -1331, -1356, -1343, -1356, -1331, -1356, -1356,
        -1356, -1356, -1368, -1356, -1356, -1356, -1356, -1331, -1343, -1343,
        -1331, -1343, -1331, -1343, -1343, -1356, -1343, -1356, -1356, -1356,
        -1356, -1343, -1356, -1356, -1356, -1356, -1356, -1356, -1356, -1343,
        -1356, -1343, -1356, -1343, -1343, -1356, -1331, -1331, -1331, -1343,
        -1343, -1343, -1356, -1356, -1343, -1344, -1343, -1343, -1356, -1343,
        -1343, -1356, -1343, -1356, -1343, -1331, -1343, -1356, -1343, -1331,
        -1343, -1356, -1343, -1343, -1356, -1356, -1356, -1356, -1356, -1356,
        -1343, -1343, -1331, -1343, -1343, -1343, -1356, -1356, -1356, -1356,
        -1356, -1368, -1368, -1368, -1368, -1368, -1368, -1356, -1356, -1356,
        -1356, -1368, -1368, -1357, -1356, -1368, -1381, -1368, -1356, -1356,
        -1343, -1356, -1356, -1343, -1343, -1356, -1356, -1356, -1368, -1356,
        -1356, -1368, -1368, -1368, -1356, -1368, -1381, -1356, -1356, -1367,
        -1356, -1356, -1356, -1356, -1356, -1356, -1343, -1356, -1356, -1343,
        -1356, -1331, -1356, -1356, -1356, -1368, -1369, -1381, -1381, -1368,
        -1368, -1381, -1368, -1368, -1356, -1356, -1343, -1356, -1356, -1368,
        -1356, -1356, -1368, -1368, -1368, -1381, -1368, -1356, -1356, -1356,
        -1356, -1356, -1356, -1331, -1331, -1356, -1356, -1331, -1343, -1356,
        -1343, -1331, -1343, -1356, -1356, -1356, -1356, -1331, -1343, -1356,
        -1356, -1356, -1331, -1332, -1343, -1343, -1342, -1331, -1331, -1306,
        -1318, -1331, -1331, -1318, -1306, -1318, -1306, -1318, -1306, -1318,
        -1331, -1343, -1331, -1331, -1343, -1356, -1343, -1331, -1343, -1331,
        -1331, -1318, -1306, -1293, -1306, -1306, -1293, -1293, -1306, -1281,
        -1306, -1281, -1293, -1293, -1293, -1281, -1281, -1281, -1268, -1268,
        -1281, -1268, -1255, -1281, -1281, -1268, -1281, -1281, -1281, -1256,
        -1268, -1268, -1255, -1255, -1243, -1243, -1243, -1230, -1230, -1243,
        -1243, -1230, -1243, -1243, -1218, -1230, -1230, -1218, -1218, -1230,
        -1230, -1205, -1218, -1193, -1205, -1193, -1180, -1193, -1180, -1180,
        -1193, -1180, -1193, -1168, -1180, -1180, -1155, -1155, -1142, -1142,
        -1142, -1130, -1130, -1142, -1130, -1142, -1130, -1130, -1117, -1105,
        -1105, -1105, -1105
    };

    static const int16_t iso226_2023_curve_80_phons[985] =
    {
        -145, -148,
        -142, -142, -148, -145, -148, -148, -148, -148, -145, -151,
        -148, -145, -148, -151, -145, -148, -148, -145, -145, -145,
        -148, -145, -145, -145, -145, -145, -148, -145, -150, -151,
        -154, -148, -151, -154, -156, -156, -154, -156, -156, -154,
        -156, -154, -154, -156, -154, -154, -154, -156, -151, -156,
        -156, -156, -159, -156, -156, -156, -159, -156, -156, -156,
        -159, -156, -156, -159, -159, -156, -156, -162, -162, -156,
        -162, -162, -162, -162, -162, -162, -163, -162, -165, -165,
        -165, -162, -165, -165, -162, -165, -162, -162, -165, -159,
        -162, -162, -165, -159, -162, -165, -162, -165, -165, -165,
        -165, -165, -168, -165, -168, -168, -171, -171, -168, -174,
        -171, -171, -171, -174, -174, -174, -177, -171, -171, -174,
        -171, -171, -168, -171, -176, -177, -177, -177, -180, -177,
        -180, -180, -183, -180, -180, -180, -180, -180, -180, -183,
        -180, -183, -180, -180, -183, -185, -183, -185, -188, -185,
        -183, -183, -185, -180, -180, -185, -183, -185, -183, -185,
        -185, -185, -185, -185, -185, -185, -183, -188, -185, -188,
        -191, -188, -194, -188, -191, -191, -188, -185, -191, -185,
        -188, -185, -188, -185, -191, -188, -185, -188, -185, -188,
        -188, -194, -191, -191, -191, -194, -194, -197, -197, -197,
        -197, -197, -197, -200, -200, -200, -200, -197, -197, -200,
        -197, -194, -197, -194, -197, -197, -203, -197, -203, -206,
        -203, -209, -206, -206, -203, -206, -208, -203, -206, -203,
        -203, -203, -203, -206, -203, -206, -211, -209, -209, -211,
        -209, -211, -209, -209, -211, -209, -214, -209, -211, -214,
        -211, -214, -217, -217, -217, -215, -214, -211, -214, -214,
        -211, -214, -214, -214, -217, -217, -220, -223, -220, -226,
        -220, -220, -223, -220, -220, -220, -220, -217, -220, -220,
        -220, -220, -217, -220, -220, -223, -223, -223, -226, -220,
        -220, -226, -220, -226, -223, -226, -229, -226, -229, -229,
        -226, -226, -226, -226, -229, -226, -226, -232, -229, -232,
        -232, -235, -232, -235, -238, -235, -238, -238, -235, -235,
        -238, -235, -235, -238, -235, -235, -238, -238, -232, -238,
        -238, -232, -238, -238, -235, -238, -238, -240, -238, -238,
        -237, -238, -238, -238, -243, -238, -240, -243, -238, -241,
        -243, -246, -243, -249, -246, -246, -246, -246, -249, -246,
        -246, -246, -249, -246, -246, -246, -246, -243, -243, -243,
        -246, -246, -246, -249, -249, -255, -249, -249, -246, -252,
        -249, -249, -249, -255, -255, -249, -255, -255, -255, -258,
        -255, -255, -255, -258, -255, -255, -255, -261, -258, -261,
        -264, -264, -267, -264, -264, -264, -267, -267, -264, -267,
        -264, -267, -267, -267, -264, -267, -267, -267, -267, -267,
        -267, -272, -272, -267, -267, -267, -269, -270, -272, -272,
        -269, -269, -269, -272, -272, -269, -272, -272, -272, -269,
        -272, -272, -272, -272, -272, -272, -272, -269, -269, -267,
        -267, -272, -269, -272, -275, -275, -275, -273, -275, -275,
        -278, -278, -272, -272, -275, -275, -275, -275, -272, -272,
        -275, -275, -275, -275, -278, -281, -281, -278, -284, -284,
        -284, -281, -284, -287, -287, -287, -290, -287, -284, -284,
        -287, -284, -284, -284, -284, -284, -287, -284, -287, -284,
        -284, -284, -284, -290, -290, -290, -287, -289, -287, -287,
        -287, -287, -287, -290, -290, -289, -287, -290, -290, -290,
        -287, -287, -287, -287, -290, -290, -292, -293, -293, -296,
        -293, -293, -293, -293, -293, -293, -292, -290, -290, -290,
        -290, -290, -292, -292, -290, -290, -290, -284, -287, -290,
        -290, -295, -295, -293, -293, -296, -296, -296, -296, -296,
        -298, -296, -296, -296, -296, -296, -296, -296, -296, -298,
        -298, -298, -298, -301, -301, -301, -304, -304, -304, -304,
        -304, -304, -301, -302, -302, -301, -304, -304, -304, -304,
        -307, -307, -307, -304, -307, -307, -307, -301, -304, -307,
        -307, -307, -307, -307, -307, -307, -304, -307, -304, -301,
        -307, -301, -304, -307, -301, -304, -307, -301, -304, -301,
        -304, -307, -301, -304, -304, -304, -307, -304, -307, -307,
        -313, -310, -307, -310, -307, -307, -307, -307, -307, -304,
        -307, -307, -304, -307, -307, -310, -313, -307, -307, -310,
        -307, -307, -307, -307, -310, -310, -310, -313, -313, -313,
        -313, -313, -310, -310, -310, -307, -307, -304, -307, -307,
        -310, -310, -310, -313, -313, -307, -310, -307, -307, -304,
        -310, -307, -310, -307, -313, -310, -313, -307, -313, -313,
        -313, -313, -316, -313, -313, -313, -313, -307, -310, -310,
        -307, -310, -307, -310, -310, -313, -310, -313, -313, -313,
        -313, -310, -313, -313, -313, -313, -313, -313, -313, -310,
        -313, -310, -313, -310, -310, -313, -307, -307, -307, -310,
        -310, -310, -313, -313, -310, -310, -310, -310, -313, -310,
        -310, -313, -310, -313, -310, -307, -310, -313, -310, -307,
        -310, -313, -310, -310, -313, -313, -313, -313, -313, -313,
        -310, -310, -307, -310, -310, -310, -313, -313, -313, -313,
        -313, -316, -316, -316, -316, -316, -316, -313, -313, -313,
        -313, -316, -316, -313, -313, -316, -319, -316, -313, -313,
        -310, -313, -313, -310, -310, -313, -313, -313, -316, -313,
        -313, -316, -316, -316, -313, -316, -319, -313, -313, -316,
        -313, -313, -313, -313, -313, -313, -310, -313, -313, -310,
        -313, -307, -313, -313, -313, -316, -316, -319, -319, -316,
        -316, -319, -316, -316, -313, -313, -310, -313, -313, -316,
        -313, -313, -316, -316, -316, -319, -316, -313, -313, -313,
        -313, -313, -313, -307, -307, -313, -313, -307, -310, -313,
        -310, -307, -310, -313, -313, -313, -313, -307, -310, -313,
        -313, -313, -307, -307, -310, -310, -310, -307, -307, -301,
        -304, -307, -307, -304, -301, -304, -301, -304, -301, -304,
        -307, -310, -307, -307, -310, -313, -310, -307, -310, -307,
        -307, -304, -301, -298, -301, -301, -298, -298, -301, -296,
        -301, -296, -298, -298, -298, -296, -296, -296, -293, -293,
        -296, -293, -290, -296, -296, -293, -296, -296, -296, -290,
        -293, -293, -290, -290, -287, -287, -287, -284, -284, -287,
        -287, -284, -287, -287, -281, -284, -284, -281, -281, -284,
        -284, -278, -281, -275, -278, -275, -272, -275, -272, -272,
        -275, -272, -275, -269, -272, -272, -267, -267, -264, -264,
        -264, -261, -261, -264, -261, -264, -261, -261, -258, -255,
        -255, -255, -255
    };

    static const int16_t iso226_2023_curve_90_phons[985] =
    {
        338, 345,
        331, 331, 345, 338, 345, 345, 345, 345, 338, 352,
        345, 338, 345, 352, 338, 345, 345, 338, 338, 338,
        345, 338, 338, 338, 338, 338, 345, 338, 351, 352,
        358, 345, 352, 358, 365, 365, 358, 365, 365, 358,
        365, 358, 358, 365, 358, 358, 358, 365, 352, 365,
        365, 365, 372, 365, 365, 365, 372, 365, 365, 365,
        372, 365, 365, 372, 372, 365, 365, 379, 379, 365,
        378, 379, 379, 378, 379, 379, 379, 379, 385, 385,
        385, 379, 385, 385, 379, 385, 379, 379, 385, 372,
        379, 379, 385, 372, 379, 385, 379, 385, 385, 385,
        385, 385, 392, 385, 392, 392, 399, 399, 392, 406,
        399, 399, 399, 406, 406, 406, 412, 399, 399, 406,
        399, 399, 392, 399, 412, 412, 412, 412, 419, 412,
        419, 419, 426, 419, 419, 419, 419, 419, 419, 426,
        419, 426, 419, 419, 426, 433, 426, 433, 439, 433,
        426, 426, 433, 419, 419, 433, 426, 433, 426, 433,
        433, 433, 433, 433, 433, 433, 426, 439, 433, 439,
        446, 439, 453, 440, 446, 446, 439, 433, 446, 433,
        439, 433, 439, 433, 446, 439, 433, 439, 433, 439,
        439, 453, 446, 446, 446, 453, 453, 460, 460, 460,
        460, 460, 460, 466, 466, 466, 466, 460, 460, 466,
        460, 453, 460, 453, 460, 460, 473, 460, 473, 480,
        473, 487, 480, 480, 473, 480, 486, 473, 480, 473,
        473, 473, 473, 480, 473, 480, 493, 487, 487, 493,
        487, 493, 487, 487, 493, 487, 500, 487, 493, 500,
        493, 500, 507, 507, 507, 501, 500, 493, 500, 500,
        493, 500, 500, 500, 507, 507, 514, 521, 514, 527,
        514, 514, 521, 514, 514, 514, 514, 507, 514, 513,
        514, 514, 507, 514, 514, 521, 521, 521, 527, 514,
        514, 527, 514, 527, 521, 527, 534, 527, 534, 534,
        527, 527, 527, 527, 534, 528, 527, 541, 534, 541,
        541, 548, 541, 548, 554, 548, 554, 554, 548, 548,
        554, 548, 548, 554, 548, 548, 554, 554, 541, 554,
        554, 541, 554, 554, 548, 554, 554, 561, 554, 554,
        554, 554, 554, 554, 567, 554, 561, 568, 554, 561,
        568, 575, 568, 581, 575, 574, 575, 575, 581, 574,
        575, 575, 581, 575, 575, 575, 575, 568, 568, 568,
        574, 575, 575, 581, 581, 594, 581, 581, 575, 588,
        581, 581, 581, 595, 595, 581, 595, 595, 595, 602,
        595, 595, 595, 602, 595, 595, 595, 608, 602, 609,
        615, 615, 622, 615, 615, 615, 622, 622, 615, 622,
        615, 622, 622, 622, 615, 622, 622, 622, 622, 622,
        622, 635, 635, 622, 622, 622, 629, 629, 635, 635,
        629, 629, 629, 635, 635, 629, 635, 635, 635, 629,
        635, 635, 635, 635, 635, 635, 635, 629, 629, 622,
        622, 635, 629, 635, 642, 642, 642, 636, 643, 642,
        649, 649, 636, 636, 642, 642, 642, 642, 635, 635,
        642, 642, 642, 642, 649, 656, 656, 649, 662, 662,
        662, 656, 662, 669, 669, 669, 676, 669, 662, 663,
        669, 662, 662, 662, 662, 663, 669, 662, 669, 662,
        662, 663, 662, 676, 676, 676, 669, 675, 669, 670,
        670, 669, 669, 676, 676, 675, 670, 676, 676, 676,
        669, 669, 669, 669, 676, 676, 682, 683, 683, 690,
        683, 683, 683, 683, 683, 683, 682, 676, 676, 676,
        676, 676, 682, 682, 676, 676, 676, 662, 669, 676,
        676, 689, 689, 683, 683, 690, 690, 690, 690, 690,
        696, 690, 690, 690, 690, 690, 690, 690, 690, 696,
        696, 696, 696, 703, 703, 703, 710, 710, 710, 710,
        710, 710, 703, 704, 704, 703, 710, 710, 710, 710,
        717, 717, 717, 710, 717, 717, 717, 703, 710, 717,
        717, 717, 717, 717, 717, 717, 710, 717, 710, 703,
        717, 703, 710, 717, 703, 710, 717, 703, 710, 703,
        710, 717, 703, 710, 710, 710, 717, 710, 717, 717,
        730, 723, 717, 723, 717, 717, 717, 716, 717, 710,
        717, 717, 710, 717, 717, 723, 730, 717, 717, 723,
        717, 717, 717, 717, 723, 723, 723, 730, 730, 730,
        730, 730, 723, 723, 723, 717, 717, 710, 717, 717,
        723, 723, 723, 730, 730, 717, 723, 717, 717, 710,
        723, 717, 723, 717, 730, 723, 730, 717, 730, 730,
        730, 730, 737, 730, 730, 730, 730, 717, 723, 723,
        717, 723, 717, 723, 723, 730, 723, 730, 730, 730,
        730, 723, 730, 730, 730, 730, 730, 730, 730, 723,
        730, 723, 730, 723, 723, 730, 717, 717, 717, 723,
        723, 723, 730, 730, 723, 724, 723, 723, 730, 723,
        723, 730, 723, 730, 723, 717, 723, 730, 723, 717,
        723, 730, 723, 723, 730, 730, 730, 730, 730, 730,
        723, 723, 717, 723, 723, 723, 730, 730, 730, 730,
        730, 737, 737, 737, 737, 737, 737, 730, 730, 730,
        730, 737, 737, 730, 730, 737, 744, 737, 730, 730,
        723, 730, 730, 723, 723, 730, 730, 730, 737, 730,
        730, 737, 737, 737, 730, 737, 744, 730, 730, 736,
        730, 730, 730, 730, 730, 730, 723, 730, 730, 723,
        730, 717, 730, 730, 730, 737, 737, 744, 744, 737,
        737, 744, 737, 737, 730, 730, 723, 730, 730, 737,
        730, 730, 737, 737, 737, 744, 737, 730, 730, 730,
        730, 730, 730, 717, 717, 730, 730, 717, 723, 730,
        723, 717, 723, 730, 730, 730, 730, 717, 723, 730,
        730, 730, 717, 717, 723, 723, 723, 717, 717, 703,
        710, 717, 717, 710, 703, 710, 703, 710, 703, 710,
        717, 723, 717, 717, 723, 730, 723, 717, 723, 717,
        717, 710, 703, 696, 703, 703, 696, 696, 703, 690,
        703, 690, 696, 696, 696, 690, 690, 690, 683, 683,
        690, 683, 676, 690, 690, 683, 690, 690, 690, 677,
        683, 683, 676, 676, 669, 669, 669, 662, 662, 669,
        669, 662, 669, 669, 656, 662, 662, 656, 656, 662,
        662, 649, 656, 642, 649, 642, 635, 642, 635, 635,
        642, 635, 642, 629, 635, 635, 622, 622, 615, 615,
        615, 608, 608, 615, 608, 615, 608, 608, 602, 595,
        595, 595, 595
    };

    static const int16_t * const iso226_2023_curves[] =
    {
        iso226_2023_curve_0_phons,
        iso226_2023_curve_10_phons,
        iso226_2023_curve_20_phons,
        iso226_2023_curve_30_phons,
        iso226_2023_curve_40_phons,
        iso226_2023_curve_50_phons,
        iso226_2023_curve_60_phons,
        iso226_2023_curve_70_phons,
        iso226_2023_curve_80_phons,
        iso226_2023_curve_90_phons
    };

    static const freq_curve_t iso226_2023_curve =
    {
        22.33, // fmin
        12989.79, // fmax
        0.00, // amin
        90.00, // amax
        985, // hdots
        10, // curves
        iso226_2023_curves // curve data
    };

} /* namespace lsp */

#endif /* GENERATED_ISO226_ISO226_2023_H_ */

