#define CPUID(func,leaf,a,b,c,d) \
  __asm("cpuid":"=a"(a),"=b"(b),"=c"(c),"=d"(d):"a"(func),"c"(leaf):)

#define WANT_7_1 ((1<<3)|(1<<8))
/* 3=bmi1; 8=bmi2 */

int supports(void)
{
  unsigned int cpuidmax,id0,id1,id2;
  unsigned int feature0,feature1,feature2,feature3;

  CPUID(0,0,cpuidmax,id0,id1,id2);
  if (cpuidmax < 7) return 0;

  CPUID(7,0,feature0,feature1,feature2,feature3);
  if (WANT_7_1 != (WANT_7_1 & feature1)) return 0;

  return 1;
}
