# File:///home/langella/developpement/git/pappsomspp/CMakeStuff/toolchains/mxe-toolchain.cmake# 
# This file should be included if the command line reads like this:
# x86_64-w64-mingw32.shared-cmake -DCMAKE_BUILD_TYPE=Release -DMXE=1 ..

message("MXE (M cross environment) https://mxe.cc/")
message("Please run the configuration like this:")
message("x86_64-w64-mingw32.shared-cmake -DMXEOLIVIER=1 -G \"Unix Makefiles\" -DCMAKE_BUILD_TYPE=Release ../../development")


set(MXE_ROOT_DIR "/opt/mxe")
set(MXE_SHIPPED_DLLS_DIR "${MXE_ROOT_DIR}/dlls-and-stuff-for-packages")

set(CMAKE_C_IMPLICIT_INCLUDE_DIRECTORIES /opt/mxe/usr/x86_64-w64-mingw32.shared/include)
set(CMAKE_CXX_IMPLICIT_INCLUDE_DIRECTORIES /opt/mxe/usr/x86_64-w64-mingw32.shared/include)

if(WIN32 OR _WIN32)
	message(STATUS "Building with WIN32 defined.")
endif()

message(STATUS "${BoldGreen}Setting definition -DPMSPP_LIBRARY for symbol DLL export.${ColourReset}")
add_definitions(-DPMSPP_LIBRARY)


find_package(ZLIB REQUIRED)


find_package(Boost 1.85 COMPONENTS iostreams thread filesystem chrono REQUIRED)

## We can build the package setup executable with this specific command.
add_custom_target(dllinstall
  COMMAND ${CMAKE_COMMAND} -E copy ${CMAKE_BINARY_DIR}/src/libpwizlite.dll ${MXE_SHIPPED_DLLS_DIR}
  COMMENT "Build and copy the dll file to its MXE destination."
  DEPENDS ${CORE_SOURCE_LIB} ${GUI_SOURCE_LIB}
  VERBATIM)

# On Win10 all the code is relocatable.
remove_definitions(-fPIC)


