// Author(s): Rimco Boudewijns
// Copyright: see the accompanying file COPYING or copy at
// https://svn.win.tue.nl/trac/MCRL2/browser/trunk/COPYING
//
// Distributed under the Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)
//

/**

  @file mainwindow.h
  @author R. Boudewijns

  Main Window of mCRL2-gui used as GUI

*/

#ifndef MCRL2_GUI_MAINWINDOW_H
#define MCRL2_GUI_MAINWINDOW_H

#include <QMainWindow>
#include "ui_mainwindow.h"

#include "mcrl2/utilities/persistentfiledialog.h"

#include "toolcatalog.h"
#include "toolinformation.h"

class MainWindow : public QMainWindow
{
    Q_OBJECT
  public:
    /**
     * @brief Constructor
     * @param parent The parent QWidget for the window
     */
    MainWindow(QWidget *parent = 0);

    /**
     * @brief Creates the tool menu
     */
    void createToolMenu();

  public slots:

    /**
     * @brief Updates the statusbar with the latest log output
     */
    void onLogOutput(QString level, QString hint, QDateTime timestamp, QString message, QString formattedMessage);

    /**
     * @brief Displays information about the selected tool
     */
    void onToolInfo();

    /**
     * @brief Updates the title for the instance
     * @param title The new title
     */
    void onTabTitleChanged(QString title);

    /**
     * @brief Updates the color for the instance
     * @param color The new color
     */
    void onTabColorChanged(QColor color);

    /**
     * @brief Deletes the given instance
     * @param index The instance to be deleted
     */
    void onTabCloseRequest(int index);

    /**
     * @brief Creates a new tool instance (tab)
     */
    void createToolInstance(QString filename, ToolInformation info);

    /**
     * @brief Creates a new file information tab
     */
    void createFileInformation(QString filename);

    void onResetPerspective();

  protected:
    /**
     * @brief Saves window information
     */
    void closeEvent(QCloseEvent *event);

  private:
    Ui::MainWindow m_ui;                      ///< The user interface generated by Qt
    ToolCatalog m_catalog;                    ///< The loaded tool_catalog.xml
    QByteArray m_state;                       ///< The window state that is used to restore the user interface

    mcrl2::utilities::qt::PersistentFileDialog m_fileDialog;

};

#endif // MCRL2_GUI_MAINWINDOW_H
