//
// ContextMenuStrip.cs
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Copyright (c) 2006 Jonathan Pobst
//
// Authors:
//	Jonathan Pobst (monkey@jpobst.com)
//
using System.ComponentModel;
using System.Runtime.InteropServices;

namespace System.Windows.Forms
{
	[ComVisible (true)]
	[ClassInterface (ClassInterfaceType.AutoDispatch)]
	[DefaultEvent ("Opening")]
	public class ContextMenuStrip : ToolStripDropDownMenu
	{
		#region Public Construtors
		public ContextMenuStrip () : base ()
		{
		}
		
		public ContextMenuStrip (IContainer container) : this ()
		{
			// TODO: handle `container` argument
		}
		#endregion

		#region Public Properties

		[Browsable (false)]
		[DesignerSerializationVisibility (DesignerSerializationVisibility.Hidden)]
		public Control SourceControl { get; protected set; }
		
		#endregion

		#region Protected Methods
		protected override void Dispose (bool disposing)
		{
			base.Dispose (disposing);
		}

		protected override void SetVisibleCore (bool visible)
		{
			base.SetVisibleCore (visible);
			if (visible)
				XplatUI.SetTopmost (this.Handle, true);
		}

		protected override void SetOwnerControl (Control newOwner)
		{
			base.SetOwnerControl (newOwner);
			SourceControl = newOwner;
			OnSetOwnerControlDone (new SetOwnerControlDoneArgs (newOwner));
		}
		#endregion

		#region Internal Events

		internal delegate void SetOwnerControlDoneHandler (object sender, SetOwnerControlDoneArgs e);
		
		// Is used by UIA API.
		[Browsable (false)]
		internal static event SetOwnerControlDoneHandler SetOwnerControlDone; 

		private void OnSetOwnerControlDone (SetOwnerControlDoneArgs e)
		{
			if (SetOwnerControlDone != null)
				SetOwnerControlDone (this, e);
		}

		internal class SetOwnerControlDoneArgs : EventArgs
		{
			public readonly Control NewOwner;

			public SetOwnerControlDoneArgs (Control newOwner)
			{
				NewOwner = newOwner;
			}
		}

		#endregion
	}
}
