# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from collections.abc import MutableMapping
import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class Attestation(Resource):
    """An attestation resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.policyinsights.models.SystemData
    :ivar policy_assignment_id: The resource ID of the policy assignment that the attestation is
     setting the state for. Required.
    :vartype policy_assignment_id: str
    :ivar policy_definition_reference_id: The policy definition reference ID from a policy set
     definition that the attestation is setting the state for. If the policy assignment assigns a
     policy set definition the attestation can choose a definition within the set definition with
     this property or omit this and set the state for the entire set definition.
    :vartype policy_definition_reference_id: str
    :ivar compliance_state: The compliance state that should be set on the resource. Known values
     are: "Compliant", "NonCompliant", and "Unknown".
    :vartype compliance_state: str or ~azure.mgmt.policyinsights.models.ComplianceState
    :ivar expires_on: The time the compliance state should expire.
    :vartype expires_on: ~datetime.datetime
    :ivar owner: The person responsible for setting the state of the resource. This value is
     typically an Azure Active Directory object ID.
    :vartype owner: str
    :ivar comments: Comments describing why this attestation was created.
    :vartype comments: str
    :ivar evidence: The evidence supporting the compliance state set in this attestation.
    :vartype evidence: list[~azure.mgmt.policyinsights.models.AttestationEvidence]
    :ivar provisioning_state: The status of the attestation.
    :vartype provisioning_state: str
    :ivar last_compliance_state_change_at: The time the compliance state was last changed in this
     attestation.
    :vartype last_compliance_state_change_at: ~datetime.datetime
    :ivar assessment_date: The time the evidence was assessed.
    :vartype assessment_date: ~datetime.datetime
    :ivar metadata: Additional metadata for this attestation.
    :vartype metadata: JSON
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "policy_assignment_id": {"required": True},
        "provisioning_state": {"readonly": True},
        "last_compliance_state_change_at": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "policy_assignment_id": {"key": "properties.policyAssignmentId", "type": "str"},
        "policy_definition_reference_id": {"key": "properties.policyDefinitionReferenceId", "type": "str"},
        "compliance_state": {"key": "properties.complianceState", "type": "str"},
        "expires_on": {"key": "properties.expiresOn", "type": "iso-8601"},
        "owner": {"key": "properties.owner", "type": "str"},
        "comments": {"key": "properties.comments", "type": "str"},
        "evidence": {"key": "properties.evidence", "type": "[AttestationEvidence]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "last_compliance_state_change_at": {"key": "properties.lastComplianceStateChangeAt", "type": "iso-8601"},
        "assessment_date": {"key": "properties.assessmentDate", "type": "iso-8601"},
        "metadata": {"key": "properties.metadata", "type": "object"},
    }

    def __init__(
        self,
        *,
        policy_assignment_id: str,
        policy_definition_reference_id: Optional[str] = None,
        compliance_state: Optional[Union[str, "_models.ComplianceState"]] = None,
        expires_on: Optional[datetime.datetime] = None,
        owner: Optional[str] = None,
        comments: Optional[str] = None,
        evidence: Optional[List["_models.AttestationEvidence"]] = None,
        assessment_date: Optional[datetime.datetime] = None,
        metadata: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword policy_assignment_id: The resource ID of the policy assignment that the attestation is
         setting the state for. Required.
        :paramtype policy_assignment_id: str
        :keyword policy_definition_reference_id: The policy definition reference ID from a policy set
         definition that the attestation is setting the state for. If the policy assignment assigns a
         policy set definition the attestation can choose a definition within the set definition with
         this property or omit this and set the state for the entire set definition.
        :paramtype policy_definition_reference_id: str
        :keyword compliance_state: The compliance state that should be set on the resource. Known
         values are: "Compliant", "NonCompliant", and "Unknown".
        :paramtype compliance_state: str or ~azure.mgmt.policyinsights.models.ComplianceState
        :keyword expires_on: The time the compliance state should expire.
        :paramtype expires_on: ~datetime.datetime
        :keyword owner: The person responsible for setting the state of the resource. This value is
         typically an Azure Active Directory object ID.
        :paramtype owner: str
        :keyword comments: Comments describing why this attestation was created.
        :paramtype comments: str
        :keyword evidence: The evidence supporting the compliance state set in this attestation.
        :paramtype evidence: list[~azure.mgmt.policyinsights.models.AttestationEvidence]
        :keyword assessment_date: The time the evidence was assessed.
        :paramtype assessment_date: ~datetime.datetime
        :keyword metadata: Additional metadata for this attestation.
        :paramtype metadata: JSON
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.policy_assignment_id = policy_assignment_id
        self.policy_definition_reference_id = policy_definition_reference_id
        self.compliance_state = compliance_state
        self.expires_on = expires_on
        self.owner = owner
        self.comments = comments
        self.evidence = evidence
        self.provisioning_state: Optional[str] = None
        self.last_compliance_state_change_at: Optional[datetime.datetime] = None
        self.assessment_date = assessment_date
        self.metadata = metadata


class AttestationEvidence(_serialization.Model):
    """A piece of evidence supporting the compliance state set in the attestation.

    :ivar description: The description for this piece of evidence.
    :vartype description: str
    :ivar source_uri: The URI location of the evidence.
    :vartype source_uri: str
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "source_uri": {"key": "sourceUri", "type": "str"},
    }

    def __init__(self, *, description: Optional[str] = None, source_uri: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword description: The description for this piece of evidence.
        :paramtype description: str
        :keyword source_uri: The URI location of the evidence.
        :paramtype source_uri: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.source_uri = source_uri


class AttestationListResult(_serialization.Model):
    """List of attestations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of attestation definitions.
    :vartype value: list[~azure.mgmt.policyinsights.models.Attestation]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Attestation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.Attestation"]] = None
        self.next_link: Optional[str] = None


class CheckManagementGroupRestrictionsRequest(_serialization.Model):
    """The check policy restrictions parameters describing the resource that is being evaluated.

    :ivar resource_details: The information about the resource that will be evaluated.
    :vartype resource_details: ~azure.mgmt.policyinsights.models.CheckRestrictionsResourceDetails
    :ivar pending_fields: The list of fields and values that should be evaluated for potential
     restrictions.
    :vartype pending_fields: list[~azure.mgmt.policyinsights.models.PendingField]
    """

    _attribute_map = {
        "resource_details": {"key": "resourceDetails", "type": "CheckRestrictionsResourceDetails"},
        "pending_fields": {"key": "pendingFields", "type": "[PendingField]"},
    }

    def __init__(
        self,
        *,
        resource_details: Optional["_models.CheckRestrictionsResourceDetails"] = None,
        pending_fields: Optional[List["_models.PendingField"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_details: The information about the resource that will be evaluated.
        :paramtype resource_details: ~azure.mgmt.policyinsights.models.CheckRestrictionsResourceDetails
        :keyword pending_fields: The list of fields and values that should be evaluated for potential
         restrictions.
        :paramtype pending_fields: list[~azure.mgmt.policyinsights.models.PendingField]
        """
        super().__init__(**kwargs)
        self.resource_details = resource_details
        self.pending_fields = pending_fields


class CheckRestrictionEvaluationDetails(_serialization.Model):
    """Policy evaluation details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar evaluated_expressions: Details of the evaluated expressions.
    :vartype evaluated_expressions:
     list[~azure.mgmt.policyinsights.models.ExpressionEvaluationDetails]
    :ivar if_not_exists_details: Evaluation details of IfNotExists effect.
    :vartype if_not_exists_details: ~azure.mgmt.policyinsights.models.IfNotExistsEvaluationDetails
    :ivar reason: The reason for the evaluation result.
    :vartype reason: str
    """

    _validation = {
        "reason": {"readonly": True},
    }

    _attribute_map = {
        "evaluated_expressions": {"key": "evaluatedExpressions", "type": "[ExpressionEvaluationDetails]"},
        "if_not_exists_details": {"key": "ifNotExistsDetails", "type": "IfNotExistsEvaluationDetails"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(
        self,
        *,
        evaluated_expressions: Optional[List["_models.ExpressionEvaluationDetails"]] = None,
        if_not_exists_details: Optional["_models.IfNotExistsEvaluationDetails"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword evaluated_expressions: Details of the evaluated expressions.
        :paramtype evaluated_expressions:
         list[~azure.mgmt.policyinsights.models.ExpressionEvaluationDetails]
        :keyword if_not_exists_details: Evaluation details of IfNotExists effect.
        :paramtype if_not_exists_details:
         ~azure.mgmt.policyinsights.models.IfNotExistsEvaluationDetails
        """
        super().__init__(**kwargs)
        self.evaluated_expressions = evaluated_expressions
        self.if_not_exists_details = if_not_exists_details
        self.reason: Optional[str] = None


class CheckRestrictionsRequest(_serialization.Model):
    """The check policy restrictions parameters describing the resource that is being evaluated.

    All required parameters must be populated in order to send to server.

    :ivar resource_details: The information about the resource that will be evaluated. Required.
    :vartype resource_details: ~azure.mgmt.policyinsights.models.CheckRestrictionsResourceDetails
    :ivar pending_fields: The list of fields and values that should be evaluated for potential
     restrictions.
    :vartype pending_fields: list[~azure.mgmt.policyinsights.models.PendingField]
    :ivar include_audit_effect: Whether to include policies with the 'audit' effect in the results.
     Defaults to false.
    :vartype include_audit_effect: bool
    """

    _validation = {
        "resource_details": {"required": True},
    }

    _attribute_map = {
        "resource_details": {"key": "resourceDetails", "type": "CheckRestrictionsResourceDetails"},
        "pending_fields": {"key": "pendingFields", "type": "[PendingField]"},
        "include_audit_effect": {"key": "includeAuditEffect", "type": "bool"},
    }

    def __init__(
        self,
        *,
        resource_details: "_models.CheckRestrictionsResourceDetails",
        pending_fields: Optional[List["_models.PendingField"]] = None,
        include_audit_effect: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_details: The information about the resource that will be evaluated. Required.
        :paramtype resource_details: ~azure.mgmt.policyinsights.models.CheckRestrictionsResourceDetails
        :keyword pending_fields: The list of fields and values that should be evaluated for potential
         restrictions.
        :paramtype pending_fields: list[~azure.mgmt.policyinsights.models.PendingField]
        :keyword include_audit_effect: Whether to include policies with the 'audit' effect in the
         results. Defaults to false.
        :paramtype include_audit_effect: bool
        """
        super().__init__(**kwargs)
        self.resource_details = resource_details
        self.pending_fields = pending_fields
        self.include_audit_effect = include_audit_effect


class CheckRestrictionsResourceDetails(_serialization.Model):
    """The information about the resource that will be evaluated.

    All required parameters must be populated in order to send to server.

    :ivar resource_content: The resource content. This should include whatever properties are
     already known and can be a partial set of all resource properties. Required.
    :vartype resource_content: JSON
    :ivar api_version: The api-version of the resource content.
    :vartype api_version: str
    :ivar scope: The scope where the resource is being created. For example, if the resource is a
     child resource this would be the parent resource's resource ID.
    :vartype scope: str
    """

    _validation = {
        "resource_content": {"required": True},
    }

    _attribute_map = {
        "resource_content": {"key": "resourceContent", "type": "object"},
        "api_version": {"key": "apiVersion", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
    }

    def __init__(
        self, *, resource_content: JSON, api_version: Optional[str] = None, scope: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword resource_content: The resource content. This should include whatever properties are
         already known and can be a partial set of all resource properties. Required.
        :paramtype resource_content: JSON
        :keyword api_version: The api-version of the resource content.
        :paramtype api_version: str
        :keyword scope: The scope where the resource is being created. For example, if the resource is
         a child resource this would be the parent resource's resource ID.
        :paramtype scope: str
        """
        super().__init__(**kwargs)
        self.resource_content = resource_content
        self.api_version = api_version
        self.scope = scope


class CheckRestrictionsResult(_serialization.Model):
    """The result of a check policy restrictions evaluation on a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar field_restrictions: The restrictions that will be placed on various fields in the
     resource by policy.
    :vartype field_restrictions: list[~azure.mgmt.policyinsights.models.FieldRestrictions]
    :ivar content_evaluation_result: Evaluation results for the provided partial resource content.
    :vartype content_evaluation_result:
     ~azure.mgmt.policyinsights.models.CheckRestrictionsResultContentEvaluationResult
    """

    _validation = {
        "field_restrictions": {"readonly": True},
        "content_evaluation_result": {"readonly": True},
    }

    _attribute_map = {
        "field_restrictions": {"key": "fieldRestrictions", "type": "[FieldRestrictions]"},
        "content_evaluation_result": {
            "key": "contentEvaluationResult",
            "type": "CheckRestrictionsResultContentEvaluationResult",
        },
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.field_restrictions: Optional[List["_models.FieldRestrictions"]] = None
        self.content_evaluation_result: Optional["_models.CheckRestrictionsResultContentEvaluationResult"] = None


class CheckRestrictionsResultContentEvaluationResult(_serialization.Model):  # pylint: disable=name-too-long
    """Evaluation results for the provided partial resource content.

    :ivar policy_evaluations: Policy evaluation results against the given resource content. This
     will indicate if the partial content that was provided will be denied as-is.
    :vartype policy_evaluations: list[~azure.mgmt.policyinsights.models.PolicyEvaluationResult]
    """

    _attribute_map = {
        "policy_evaluations": {"key": "policyEvaluations", "type": "[PolicyEvaluationResult]"},
    }

    def __init__(
        self, *, policy_evaluations: Optional[List["_models.PolicyEvaluationResult"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword policy_evaluations: Policy evaluation results against the given resource content. This
         will indicate if the partial content that was provided will be denied as-is.
        :paramtype policy_evaluations: list[~azure.mgmt.policyinsights.models.PolicyEvaluationResult]
        """
        super().__init__(**kwargs)
        self.policy_evaluations = policy_evaluations


class ComplianceDetail(_serialization.Model):
    """The compliance state rollup.

    :ivar compliance_state: The compliance state.
    :vartype compliance_state: str
    :ivar count: Summarized count value for this compliance state.
    :vartype count: int
    """

    _attribute_map = {
        "compliance_state": {"key": "complianceState", "type": "str"},
        "count": {"key": "count", "type": "int"},
    }

    def __init__(self, *, compliance_state: Optional[str] = None, count: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword compliance_state: The compliance state.
        :paramtype compliance_state: str
        :keyword count: Summarized count value for this compliance state.
        :paramtype count: int
        """
        super().__init__(**kwargs)
        self.compliance_state = compliance_state
        self.count = count


class ComponentEventDetails(_serialization.Model):
    """Component event details.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Component Id.
    :vartype id: str
    :ivar type: Component type.
    :vartype type: str
    :ivar name: Component name.
    :vartype name: str
    :ivar timestamp: Timestamp for component policy event record.
    :vartype timestamp: ~datetime.datetime
    :ivar tenant_id: Tenant ID for the policy event record.
    :vartype tenant_id: str
    :ivar principal_oid: Principal object ID for the user who initiated the resource component
     operation that triggered the policy event.
    :vartype principal_oid: str
    :ivar policy_definition_action: Policy definition action, i.e. effect.
    :vartype policy_definition_action: str
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "principal_oid": {"key": "principalOid", "type": "str"},
        "policy_definition_action": {"key": "policyDefinitionAction", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        type: Optional[str] = None,
        name: Optional[str] = None,
        timestamp: Optional[datetime.datetime] = None,
        tenant_id: Optional[str] = None,
        principal_oid: Optional[str] = None,
        policy_definition_action: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Component Id.
        :paramtype id: str
        :keyword type: Component type.
        :paramtype type: str
        :keyword name: Component name.
        :paramtype name: str
        :keyword timestamp: Timestamp for component policy event record.
        :paramtype timestamp: ~datetime.datetime
        :keyword tenant_id: Tenant ID for the policy event record.
        :paramtype tenant_id: str
        :keyword principal_oid: Principal object ID for the user who initiated the resource component
         operation that triggered the policy event.
        :paramtype principal_oid: str
        :keyword policy_definition_action: Policy definition action, i.e. effect.
        :paramtype policy_definition_action: str
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.id = id
        self.type = type
        self.name = name
        self.timestamp = timestamp
        self.tenant_id = tenant_id
        self.principal_oid = principal_oid
        self.policy_definition_action = policy_definition_action


class ComponentExpressionEvaluationDetails(_serialization.Model):
    """Evaluation details of policy language expressions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar result: Evaluation result.
    :vartype result: str
    :ivar expression: Expression evaluated.
    :vartype expression: str
    :ivar expression_kind: The kind of expression that was evaluated.
    :vartype expression_kind: str
    :ivar path: Property path if the expression is a field or an alias.
    :vartype path: str
    :ivar expression_value: Value of the expression.
    :vartype expression_value: JSON
    :ivar target_value: Target value to be compared with the expression value.
    :vartype target_value: JSON
    :ivar operator: Operator to compare the expression value and the target value.
    :vartype operator: str
    """

    _validation = {
        "expression": {"readonly": True},
        "expression_kind": {"readonly": True},
        "path": {"readonly": True},
        "expression_value": {"readonly": True},
        "target_value": {"readonly": True},
        "operator": {"readonly": True},
    }

    _attribute_map = {
        "result": {"key": "result", "type": "str"},
        "expression": {"key": "expression", "type": "str"},
        "expression_kind": {"key": "expressionKind", "type": "str"},
        "path": {"key": "path", "type": "str"},
        "expression_value": {"key": "expressionValue", "type": "object"},
        "target_value": {"key": "targetValue", "type": "object"},
        "operator": {"key": "operator", "type": "str"},
    }

    def __init__(self, *, result: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword result: Evaluation result.
        :paramtype result: str
        """
        super().__init__(**kwargs)
        self.result = result
        self.expression: Optional[str] = None
        self.expression_kind: Optional[str] = None
        self.path: Optional[str] = None
        self.expression_value: Optional[JSON] = None
        self.target_value: Optional[JSON] = None
        self.operator: Optional[str] = None


class ComponentPolicyEvaluationDetails(_serialization.Model):
    """Policy evaluation details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar evaluated_expressions: Details of the evaluated expressions.
    :vartype evaluated_expressions:
     list[~azure.mgmt.policyinsights.models.ComponentExpressionEvaluationDetails]
    :ivar reason: Additional textual reason for the evaluation outcome.
    :vartype reason: str
    """

    _validation = {
        "evaluated_expressions": {"readonly": True},
    }

    _attribute_map = {
        "evaluated_expressions": {"key": "evaluatedExpressions", "type": "[ComponentExpressionEvaluationDetails]"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: Additional textual reason for the evaluation outcome.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.evaluated_expressions: Optional[List["_models.ComponentExpressionEvaluationDetails"]] = None
        self.reason = reason


class ComponentPolicyState(_serialization.Model):
    """Component Policy State record.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar odata_id: OData entity ID; always set to null since component policy state records do not
     have an entity ID.
    :vartype odata_id: str
    :ivar odata_context: OData context string; used by OData clients to resolve type information
     based on metadata.
    :vartype odata_context: str
    :ivar timestamp: Timestamp for the component policy state record.
    :vartype timestamp: ~datetime.datetime
    :ivar component_id: Component Id.
    :vartype component_id: str
    :ivar component_type: Component type.
    :vartype component_type: str
    :ivar component_name: Component name.
    :vartype component_name: str
    :ivar resource_id: Resource ID.
    :vartype resource_id: str
    :ivar policy_assignment_id: Policy assignment ID.
    :vartype policy_assignment_id: str
    :ivar policy_definition_id: Policy definition ID.
    :vartype policy_definition_id: str
    :ivar subscription_id: Subscription ID.
    :vartype subscription_id: str
    :ivar resource_type: Resource type.
    :vartype resource_type: str
    :ivar resource_location: Resource location.
    :vartype resource_location: str
    :ivar resource_group: Resource group name.
    :vartype resource_group: str
    :ivar policy_assignment_name: Policy assignment name.
    :vartype policy_assignment_name: str
    :ivar policy_assignment_owner: Policy assignment owner.
    :vartype policy_assignment_owner: str
    :ivar policy_assignment_parameters: Policy assignment parameters.
    :vartype policy_assignment_parameters: str
    :ivar policy_assignment_scope: Policy assignment scope.
    :vartype policy_assignment_scope: str
    :ivar policy_definition_name: Policy definition name.
    :vartype policy_definition_name: str
    :ivar policy_definition_action: Policy definition action, i.e. effect.
    :vartype policy_definition_action: str
    :ivar policy_definition_category: Policy definition category.
    :vartype policy_definition_category: str
    :ivar policy_set_definition_id: Policy set definition ID, if the policy assignment is for a
     policy set.
    :vartype policy_set_definition_id: str
    :ivar policy_set_definition_name: Policy set definition name, if the policy assignment is for a
     policy set.
    :vartype policy_set_definition_name: str
    :ivar policy_set_definition_owner: Policy set definition owner, if the policy assignment is for
     a policy set.
    :vartype policy_set_definition_owner: str
    :ivar policy_set_definition_category: Policy set definition category, if the policy assignment
     is for a policy set.
    :vartype policy_set_definition_category: str
    :ivar policy_set_definition_parameters: Policy set definition parameters, if the policy
     assignment is for a policy set.
    :vartype policy_set_definition_parameters: str
    :ivar policy_definition_reference_id: Reference ID for the policy definition inside the policy
     set, if the policy assignment is for a policy set.
    :vartype policy_definition_reference_id: str
    :ivar compliance_state: Compliance state of the resource.
    :vartype compliance_state: str
    :ivar policy_evaluation_details: Policy evaluation details. This is only included in the
     response if the request contains $expand=PolicyEvaluationDetails.
    :vartype policy_evaluation_details:
     ~azure.mgmt.policyinsights.models.ComponentPolicyEvaluationDetails
    :ivar policy_definition_group_names: Policy definition group names.
    :vartype policy_definition_group_names: list[str]
    :ivar policy_definition_version: Evaluated policy definition version.
    :vartype policy_definition_version: str
    :ivar policy_set_definition_version: Evaluated policy set definition version.
    :vartype policy_set_definition_version: str
    :ivar policy_assignment_version: Evaluated policy assignment version.
    :vartype policy_assignment_version: str
    """

    _validation = {
        "odata_id": {"readonly": True},
        "odata_context": {"readonly": True},
        "timestamp": {"readonly": True},
        "component_id": {"readonly": True},
        "component_type": {"readonly": True},
        "component_name": {"readonly": True},
        "resource_id": {"readonly": True},
        "policy_assignment_id": {"readonly": True},
        "policy_definition_id": {"readonly": True},
        "subscription_id": {"readonly": True},
        "resource_type": {"readonly": True},
        "resource_location": {"readonly": True},
        "resource_group": {"readonly": True},
        "policy_assignment_name": {"readonly": True},
        "policy_assignment_owner": {"readonly": True},
        "policy_assignment_parameters": {"readonly": True},
        "policy_assignment_scope": {"readonly": True},
        "policy_definition_name": {"readonly": True},
        "policy_definition_action": {"readonly": True},
        "policy_definition_category": {"readonly": True},
        "policy_set_definition_id": {"readonly": True},
        "policy_set_definition_name": {"readonly": True},
        "policy_set_definition_owner": {"readonly": True},
        "policy_set_definition_category": {"readonly": True},
        "policy_set_definition_parameters": {"readonly": True},
        "policy_definition_reference_id": {"readonly": True},
        "compliance_state": {"readonly": True},
        "policy_definition_group_names": {"readonly": True},
        "policy_definition_version": {"readonly": True},
        "policy_set_definition_version": {"readonly": True},
        "policy_assignment_version": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "odata_id": {"key": "@odata\\.id", "type": "str"},
        "odata_context": {"key": "@odata\\.context", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "component_id": {"key": "componentId", "type": "str"},
        "component_type": {"key": "componentType", "type": "str"},
        "component_name": {"key": "componentName", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "policy_assignment_id": {"key": "policyAssignmentId", "type": "str"},
        "policy_definition_id": {"key": "policyDefinitionId", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "resource_location": {"key": "resourceLocation", "type": "str"},
        "resource_group": {"key": "resourceGroup", "type": "str"},
        "policy_assignment_name": {"key": "policyAssignmentName", "type": "str"},
        "policy_assignment_owner": {"key": "policyAssignmentOwner", "type": "str"},
        "policy_assignment_parameters": {"key": "policyAssignmentParameters", "type": "str"},
        "policy_assignment_scope": {"key": "policyAssignmentScope", "type": "str"},
        "policy_definition_name": {"key": "policyDefinitionName", "type": "str"},
        "policy_definition_action": {"key": "policyDefinitionAction", "type": "str"},
        "policy_definition_category": {"key": "policyDefinitionCategory", "type": "str"},
        "policy_set_definition_id": {"key": "policySetDefinitionId", "type": "str"},
        "policy_set_definition_name": {"key": "policySetDefinitionName", "type": "str"},
        "policy_set_definition_owner": {"key": "policySetDefinitionOwner", "type": "str"},
        "policy_set_definition_category": {"key": "policySetDefinitionCategory", "type": "str"},
        "policy_set_definition_parameters": {"key": "policySetDefinitionParameters", "type": "str"},
        "policy_definition_reference_id": {"key": "policyDefinitionReferenceId", "type": "str"},
        "compliance_state": {"key": "complianceState", "type": "str"},
        "policy_evaluation_details": {"key": "policyEvaluationDetails", "type": "ComponentPolicyEvaluationDetails"},
        "policy_definition_group_names": {"key": "policyDefinitionGroupNames", "type": "[str]"},
        "policy_definition_version": {"key": "policyDefinitionVersion", "type": "str"},
        "policy_set_definition_version": {"key": "policySetDefinitionVersion", "type": "str"},
        "policy_assignment_version": {"key": "policyAssignmentVersion", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        policy_evaluation_details: Optional["_models.ComponentPolicyEvaluationDetails"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword policy_evaluation_details: Policy evaluation details. This is only included in the
         response if the request contains $expand=PolicyEvaluationDetails.
        :paramtype policy_evaluation_details:
         ~azure.mgmt.policyinsights.models.ComponentPolicyEvaluationDetails
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.odata_id: Optional[str] = None
        self.odata_context: Optional[str] = None
        self.timestamp: Optional[datetime.datetime] = None
        self.component_id: Optional[str] = None
        self.component_type: Optional[str] = None
        self.component_name: Optional[str] = None
        self.resource_id: Optional[str] = None
        self.policy_assignment_id: Optional[str] = None
        self.policy_definition_id: Optional[str] = None
        self.subscription_id: Optional[str] = None
        self.resource_type: Optional[str] = None
        self.resource_location: Optional[str] = None
        self.resource_group: Optional[str] = None
        self.policy_assignment_name: Optional[str] = None
        self.policy_assignment_owner: Optional[str] = None
        self.policy_assignment_parameters: Optional[str] = None
        self.policy_assignment_scope: Optional[str] = None
        self.policy_definition_name: Optional[str] = None
        self.policy_definition_action: Optional[str] = None
        self.policy_definition_category: Optional[str] = None
        self.policy_set_definition_id: Optional[str] = None
        self.policy_set_definition_name: Optional[str] = None
        self.policy_set_definition_owner: Optional[str] = None
        self.policy_set_definition_category: Optional[str] = None
        self.policy_set_definition_parameters: Optional[str] = None
        self.policy_definition_reference_id: Optional[str] = None
        self.compliance_state: Optional[str] = None
        self.policy_evaluation_details = policy_evaluation_details
        self.policy_definition_group_names: Optional[List[str]] = None
        self.policy_definition_version: Optional[str] = None
        self.policy_set_definition_version: Optional[str] = None
        self.policy_assignment_version: Optional[str] = None


class ComponentPolicyStatesQueryResults(_serialization.Model):
    """Query results.

    :ivar odata_context: OData context string; used by OData clients to resolve type information
     based on metadata.
    :vartype odata_context: str
    :ivar odata_count: OData entity count; represents the number of policy state records returned.
    :vartype odata_count: int
    :ivar value: Query results.
    :vartype value: list[~azure.mgmt.policyinsights.models.ComponentPolicyState]
    """

    _validation = {
        "odata_count": {"minimum": 0},
    }

    _attribute_map = {
        "odata_context": {"key": "@odata\\.context", "type": "str"},
        "odata_count": {"key": "@odata\\.count", "type": "int"},
        "value": {"key": "value", "type": "[ComponentPolicyState]"},
    }

    def __init__(
        self,
        *,
        odata_context: Optional[str] = None,
        odata_count: Optional[int] = None,
        value: Optional[List["_models.ComponentPolicyState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword odata_context: OData context string; used by OData clients to resolve type information
         based on metadata.
        :paramtype odata_context: str
        :keyword odata_count: OData entity count; represents the number of policy state records
         returned.
        :paramtype odata_count: int
        :keyword value: Query results.
        :paramtype value: list[~azure.mgmt.policyinsights.models.ComponentPolicyState]
        """
        super().__init__(**kwargs)
        self.odata_context = odata_context
        self.odata_count = odata_count
        self.value = value


class ComponentStateDetails(_serialization.Model):
    """Component state details.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar id: Component Id.
    :vartype id: str
    :ivar type: Component type.
    :vartype type: str
    :ivar name: Component name.
    :vartype name: str
    :ivar timestamp: Component compliance evaluation timestamp.
    :vartype timestamp: ~datetime.datetime
    :ivar compliance_state: Component compliance state.
    :vartype compliance_state: str
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "compliance_state": {"key": "complianceState", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        type: Optional[str] = None,
        name: Optional[str] = None,
        timestamp: Optional[datetime.datetime] = None,
        compliance_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword id: Component Id.
        :paramtype id: str
        :keyword type: Component type.
        :paramtype type: str
        :keyword name: Component name.
        :paramtype name: str
        :keyword timestamp: Component compliance evaluation timestamp.
        :paramtype timestamp: ~datetime.datetime
        :keyword compliance_state: Component compliance state.
        :paramtype compliance_state: str
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.id = id
        self.type = type
        self.name = name
        self.timestamp = timestamp
        self.compliance_state = compliance_state


class ErrorDefinition(_serialization.Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Service specific error code which serves as the substatus for the HTTP error code.
    :vartype code: str
    :ivar message: Description of the error.
    :vartype message: str
    :ivar target: The target of the error.
    :vartype target: str
    :ivar details: Internal error details.
    :vartype details: list[~azure.mgmt.policyinsights.models.ErrorDefinition]
    :ivar additional_info: Additional scenario specific error details.
    :vartype additional_info: list[~azure.mgmt.policyinsights.models.TypedErrorInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDefinition]"},
        "additional_info": {"key": "additionalInfo", "type": "[TypedErrorInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[List["_models.ErrorDefinition"]] = None
        self.additional_info: Optional[List["_models.TypedErrorInfo"]] = None


class ErrorDefinitionAutoGenerated(_serialization.Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Service specific error code which serves as the substatus for the HTTP error code.
    :vartype code: str
    :ivar message: Description of the error.
    :vartype message: str
    :ivar target: The target of the error.
    :vartype target: str
    :ivar details: Internal error details.
    :vartype details: list[~azure.mgmt.policyinsights.models.ErrorDefinitionAutoGenerated]
    :ivar additional_info: Additional scenario specific error details.
    :vartype additional_info: list[~azure.mgmt.policyinsights.models.TypedErrorInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDefinitionAutoGenerated]"},
        "additional_info": {"key": "additionalInfo", "type": "[TypedErrorInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[List["_models.ErrorDefinitionAutoGenerated"]] = None
        self.additional_info: Optional[List["_models.TypedErrorInfo"]] = None


class ErrorDefinitionAutoGenerated2(_serialization.Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Service specific error code which serves as the substatus for the HTTP error code.
    :vartype code: str
    :ivar message: Description of the error.
    :vartype message: str
    :ivar target: The target of the error.
    :vartype target: str
    :ivar details: Internal error details.
    :vartype details: list[~azure.mgmt.policyinsights.models.ErrorDefinitionAutoGenerated2]
    :ivar additional_info: Additional scenario specific error details.
    :vartype additional_info: list[~azure.mgmt.policyinsights.models.TypedErrorInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDefinitionAutoGenerated2]"},
        "additional_info": {"key": "additionalInfo", "type": "[TypedErrorInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[List["_models.ErrorDefinitionAutoGenerated2"]] = None
        self.additional_info: Optional[List["_models.TypedErrorInfo"]] = None


class ErrorResponse(_serialization.Model):
    """Error response.

    :ivar error: The error details.
    :vartype error: ~azure.mgmt.policyinsights.models.ErrorDefinition
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDefinition"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDefinition"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error details.
        :paramtype error: ~azure.mgmt.policyinsights.models.ErrorDefinition
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorResponseAutoGenerated(_serialization.Model):
    """Error response.

    :ivar error: The error details.
    :vartype error: ~azure.mgmt.policyinsights.models.ErrorDefinitionAutoGenerated
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDefinitionAutoGenerated"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDefinitionAutoGenerated"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error details.
        :paramtype error: ~azure.mgmt.policyinsights.models.ErrorDefinitionAutoGenerated
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorResponseAutoGenerated2(_serialization.Model):
    """Error response.

    :ivar error: The error details.
    :vartype error: ~azure.mgmt.policyinsights.models.ErrorDefinitionAutoGenerated2
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDefinitionAutoGenerated2"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDefinitionAutoGenerated2"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error details.
        :paramtype error: ~azure.mgmt.policyinsights.models.ErrorDefinitionAutoGenerated2
        """
        super().__init__(**kwargs)
        self.error = error


class ExpressionEvaluationDetails(_serialization.Model):
    """Evaluation details of policy language expressions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar result: Evaluation result.
    :vartype result: str
    :ivar expression: Expression evaluated.
    :vartype expression: str
    :ivar expression_kind: The kind of expression that was evaluated.
    :vartype expression_kind: str
    :ivar path: Property path if the expression is a field or an alias.
    :vartype path: str
    :ivar expression_value: Value of the expression.
    :vartype expression_value: JSON
    :ivar target_value: Target value to be compared with the expression value.
    :vartype target_value: JSON
    :ivar operator: Operator to compare the expression value and the target value.
    :vartype operator: str
    """

    _validation = {
        "expression_kind": {"readonly": True},
    }

    _attribute_map = {
        "result": {"key": "result", "type": "str"},
        "expression": {"key": "expression", "type": "str"},
        "expression_kind": {"key": "expressionKind", "type": "str"},
        "path": {"key": "path", "type": "str"},
        "expression_value": {"key": "expressionValue", "type": "object"},
        "target_value": {"key": "targetValue", "type": "object"},
        "operator": {"key": "operator", "type": "str"},
    }

    def __init__(
        self,
        *,
        result: Optional[str] = None,
        expression: Optional[str] = None,
        path: Optional[str] = None,
        expression_value: Optional[JSON] = None,
        target_value: Optional[JSON] = None,
        operator: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword result: Evaluation result.
        :paramtype result: str
        :keyword expression: Expression evaluated.
        :paramtype expression: str
        :keyword path: Property path if the expression is a field or an alias.
        :paramtype path: str
        :keyword expression_value: Value of the expression.
        :paramtype expression_value: JSON
        :keyword target_value: Target value to be compared with the expression value.
        :paramtype target_value: JSON
        :keyword operator: Operator to compare the expression value and the target value.
        :paramtype operator: str
        """
        super().__init__(**kwargs)
        self.result = result
        self.expression = expression
        self.expression_kind: Optional[str] = None
        self.path = path
        self.expression_value = expression_value
        self.target_value = target_value
        self.operator = operator


class FieldRestriction(_serialization.Model):
    """The restrictions on a field imposed by a specific policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar result: The type of restriction that is imposed on the field. Known values are:
     "Required", "Removed", "Deny", and "Audit".
    :vartype result: str or ~azure.mgmt.policyinsights.models.FieldRestrictionResult
    :ivar default_value: The value that policy will set for the field if the user does not provide
     a value.
    :vartype default_value: str
    :ivar values: The values that policy either requires or denies for the field.
    :vartype values: list[str]
    :ivar policy: The details of the policy that is causing the field restriction.
    :vartype policy: ~azure.mgmt.policyinsights.models.PolicyReference
    :ivar policy_effect: The effect of the policy that is causing the field restriction.
     http://aka.ms/policyeffects.
    :vartype policy_effect: str
    :ivar reason: The reason for the restriction.
    :vartype reason: str
    """

    _validation = {
        "result": {"readonly": True},
        "default_value": {"readonly": True},
        "values": {"readonly": True},
        "policy": {"readonly": True},
        "policy_effect": {"readonly": True},
        "reason": {"readonly": True},
    }

    _attribute_map = {
        "result": {"key": "result", "type": "str"},
        "default_value": {"key": "defaultValue", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
        "policy": {"key": "policy", "type": "PolicyReference"},
        "policy_effect": {"key": "policyEffect", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.result: Optional[Union[str, "_models.FieldRestrictionResult"]] = None
        self.default_value: Optional[str] = None
        self.values: Optional[List[str]] = None
        self.policy: Optional["_models.PolicyReference"] = None
        self.policy_effect: Optional[str] = None
        self.reason: Optional[str] = None


class FieldRestrictions(_serialization.Model):
    """The restrictions that will be placed on a field in the resource by policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar field: The name of the field. This can be a top-level property like 'name' or 'type' or
     an Azure Policy field alias.
    :vartype field: str
    :ivar restrictions: The restrictions placed on that field by policy.
    :vartype restrictions: list[~azure.mgmt.policyinsights.models.FieldRestriction]
    """

    _validation = {
        "field": {"readonly": True},
    }

    _attribute_map = {
        "field": {"key": "field", "type": "str"},
        "restrictions": {"key": "restrictions", "type": "[FieldRestriction]"},
    }

    def __init__(self, *, restrictions: Optional[List["_models.FieldRestriction"]] = None, **kwargs: Any) -> None:
        """
        :keyword restrictions: The restrictions placed on that field by policy.
        :paramtype restrictions: list[~azure.mgmt.policyinsights.models.FieldRestriction]
        """
        super().__init__(**kwargs)
        self.field: Optional[str] = None
        self.restrictions = restrictions


class IfNotExistsEvaluationDetails(_serialization.Model):
    """Evaluation details of IfNotExists effect.

    :ivar resource_id: ID of the last evaluated resource for IfNotExists effect.
    :vartype resource_id: str
    :ivar total_resources: Total number of resources to which the existence condition is
     applicable.
    :vartype total_resources: int
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "total_resources": {"key": "totalResources", "type": "int"},
    }

    def __init__(
        self, *, resource_id: Optional[str] = None, total_resources: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: ID of the last evaluated resource for IfNotExists effect.
        :paramtype resource_id: str
        :keyword total_resources: Total number of resources to which the existence condition is
         applicable.
        :paramtype total_resources: int
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.total_resources = total_resources


class Operation(_serialization.Model):
    """Operation definition.

    :ivar name: Operation name.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar display: Display metadata associated with the operation.
    :vartype display: ~azure.mgmt.policyinsights.models.OperationDisplay
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["_models.OperationDisplay"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name.
        :paramtype name: str
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        :keyword display: Display metadata associated with the operation.
        :paramtype display: ~azure.mgmt.policyinsights.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.display = display


class OperationDisplay(_serialization.Model):
    """Display metadata associated with the operation.

    :ivar provider: Resource provider name.
    :vartype provider: str
    :ivar resource: Resource name on which the operation is performed.
    :vartype resource: str
    :ivar operation: Operation name.
    :vartype operation: str
    :ivar description: Operation description.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Resource provider name.
        :paramtype provider: str
        :keyword resource: Resource name on which the operation is performed.
        :paramtype resource: str
        :keyword operation: Operation name.
        :paramtype operation: str
        :keyword description: Operation description.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationsListResults(_serialization.Model):
    """List of available operations.

    :ivar odata_count: OData entity count; represents the number of operations returned.
    :vartype odata_count: int
    :ivar value: List of available operations.
    :vartype value: list[~azure.mgmt.policyinsights.models.Operation]
    """

    _validation = {
        "odata_count": {"minimum": 1},
    }

    _attribute_map = {
        "odata_count": {"key": "@odata\\.count", "type": "int"},
        "value": {"key": "value", "type": "[Operation]"},
    }

    def __init__(
        self, *, odata_count: Optional[int] = None, value: Optional[List["_models.Operation"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword odata_count: OData entity count; represents the number of operations returned.
        :paramtype odata_count: int
        :keyword value: List of available operations.
        :paramtype value: list[~azure.mgmt.policyinsights.models.Operation]
        """
        super().__init__(**kwargs)
        self.odata_count = odata_count
        self.value = value


class PendingField(_serialization.Model):
    """A field that should be evaluated against Azure Policy to determine restrictions.

    All required parameters must be populated in order to send to server.

    :ivar field: The name of the field. This can be a top-level property like 'name' or 'type' or
     an Azure Policy field alias. Required.
    :vartype field: str
    :ivar values: The list of potential values for the field that should be evaluated against Azure
     Policy.
    :vartype values: list[str]
    """

    _validation = {
        "field": {"required": True},
    }

    _attribute_map = {
        "field": {"key": "field", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(self, *, field: str, values: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword field: The name of the field. This can be a top-level property like 'name' or 'type'
         or an Azure Policy field alias. Required.
        :paramtype field: str
        :keyword values: The list of potential values for the field that should be evaluated against
         Azure Policy.
        :paramtype values: list[str]
        """
        super().__init__(**kwargs)
        self.field = field
        self.values = values


class PolicyAssignmentSummary(_serialization.Model):
    """Policy assignment summary.

    :ivar policy_assignment_id: Policy assignment ID.
    :vartype policy_assignment_id: str
    :ivar policy_set_definition_id: Policy set definition ID, if the policy assignment is for a
     policy set.
    :vartype policy_set_definition_id: str
    :ivar results: Compliance summary for the policy assignment.
    :vartype results: ~azure.mgmt.policyinsights.models.SummaryResults
    :ivar policy_definitions: Policy definitions summary.
    :vartype policy_definitions: list[~azure.mgmt.policyinsights.models.PolicyDefinitionSummary]
    :ivar policy_groups: Policy definition group summary.
    :vartype policy_groups: list[~azure.mgmt.policyinsights.models.PolicyGroupSummary]
    """

    _attribute_map = {
        "policy_assignment_id": {"key": "policyAssignmentId", "type": "str"},
        "policy_set_definition_id": {"key": "policySetDefinitionId", "type": "str"},
        "results": {"key": "results", "type": "SummaryResults"},
        "policy_definitions": {"key": "policyDefinitions", "type": "[PolicyDefinitionSummary]"},
        "policy_groups": {"key": "policyGroups", "type": "[PolicyGroupSummary]"},
    }

    def __init__(
        self,
        *,
        policy_assignment_id: Optional[str] = None,
        policy_set_definition_id: Optional[str] = None,
        results: Optional["_models.SummaryResults"] = None,
        policy_definitions: Optional[List["_models.PolicyDefinitionSummary"]] = None,
        policy_groups: Optional[List["_models.PolicyGroupSummary"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword policy_assignment_id: Policy assignment ID.
        :paramtype policy_assignment_id: str
        :keyword policy_set_definition_id: Policy set definition ID, if the policy assignment is for a
         policy set.
        :paramtype policy_set_definition_id: str
        :keyword results: Compliance summary for the policy assignment.
        :paramtype results: ~azure.mgmt.policyinsights.models.SummaryResults
        :keyword policy_definitions: Policy definitions summary.
        :paramtype policy_definitions: list[~azure.mgmt.policyinsights.models.PolicyDefinitionSummary]
        :keyword policy_groups: Policy definition group summary.
        :paramtype policy_groups: list[~azure.mgmt.policyinsights.models.PolicyGroupSummary]
        """
        super().__init__(**kwargs)
        self.policy_assignment_id = policy_assignment_id
        self.policy_set_definition_id = policy_set_definition_id
        self.results = results
        self.policy_definitions = policy_definitions
        self.policy_groups = policy_groups


class PolicyDefinitionSummary(_serialization.Model):
    """Policy definition summary.

    :ivar policy_definition_id: Policy definition ID.
    :vartype policy_definition_id: str
    :ivar policy_definition_reference_id: Policy definition reference ID.
    :vartype policy_definition_reference_id: str
    :ivar policy_definition_group_names: Policy definition group names.
    :vartype policy_definition_group_names: list[str]
    :ivar effect: Policy effect, i.e. policy definition action.
    :vartype effect: str
    :ivar results: Compliance summary for the policy definition.
    :vartype results: ~azure.mgmt.policyinsights.models.SummaryResults
    """

    _attribute_map = {
        "policy_definition_id": {"key": "policyDefinitionId", "type": "str"},
        "policy_definition_reference_id": {"key": "policyDefinitionReferenceId", "type": "str"},
        "policy_definition_group_names": {"key": "policyDefinitionGroupNames", "type": "[str]"},
        "effect": {"key": "effect", "type": "str"},
        "results": {"key": "results", "type": "SummaryResults"},
    }

    def __init__(
        self,
        *,
        policy_definition_id: Optional[str] = None,
        policy_definition_reference_id: Optional[str] = None,
        policy_definition_group_names: Optional[List[str]] = None,
        effect: Optional[str] = None,
        results: Optional["_models.SummaryResults"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword policy_definition_id: Policy definition ID.
        :paramtype policy_definition_id: str
        :keyword policy_definition_reference_id: Policy definition reference ID.
        :paramtype policy_definition_reference_id: str
        :keyword policy_definition_group_names: Policy definition group names.
        :paramtype policy_definition_group_names: list[str]
        :keyword effect: Policy effect, i.e. policy definition action.
        :paramtype effect: str
        :keyword results: Compliance summary for the policy definition.
        :paramtype results: ~azure.mgmt.policyinsights.models.SummaryResults
        """
        super().__init__(**kwargs)
        self.policy_definition_id = policy_definition_id
        self.policy_definition_reference_id = policy_definition_reference_id
        self.policy_definition_group_names = policy_definition_group_names
        self.effect = effect
        self.results = results


class PolicyDetails(_serialization.Model):
    """The policy details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar policy_definition_id: The ID of the policy definition.
    :vartype policy_definition_id: str
    :ivar policy_assignment_id: The ID of the policy assignment.
    :vartype policy_assignment_id: str
    :ivar policy_assignment_display_name: The display name of the policy assignment.
    :vartype policy_assignment_display_name: str
    :ivar policy_assignment_scope: The scope of the policy assignment.
    :vartype policy_assignment_scope: str
    :ivar policy_set_definition_id: The ID of the policy set definition.
    :vartype policy_set_definition_id: str
    :ivar policy_definition_reference_id: The policy definition reference ID within the policy set
     definition.
    :vartype policy_definition_reference_id: str
    """

    _validation = {
        "policy_definition_id": {"readonly": True},
        "policy_assignment_id": {"readonly": True},
        "policy_assignment_display_name": {"readonly": True},
        "policy_assignment_scope": {"readonly": True},
        "policy_set_definition_id": {"readonly": True},
        "policy_definition_reference_id": {"readonly": True},
    }

    _attribute_map = {
        "policy_definition_id": {"key": "policyDefinitionId", "type": "str"},
        "policy_assignment_id": {"key": "policyAssignmentId", "type": "str"},
        "policy_assignment_display_name": {"key": "policyAssignmentDisplayName", "type": "str"},
        "policy_assignment_scope": {"key": "policyAssignmentScope", "type": "str"},
        "policy_set_definition_id": {"key": "policySetDefinitionId", "type": "str"},
        "policy_definition_reference_id": {"key": "policyDefinitionReferenceId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.policy_definition_id: Optional[str] = None
        self.policy_assignment_id: Optional[str] = None
        self.policy_assignment_display_name: Optional[str] = None
        self.policy_assignment_scope: Optional[str] = None
        self.policy_set_definition_id: Optional[str] = None
        self.policy_definition_reference_id: Optional[str] = None


class PolicyEffectDetails(_serialization.Model):
    """The details of the effect that was applied to the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar policy_effect: The effect that was applied to the resource. http://aka.ms/policyeffects.
    :vartype policy_effect: str
    """

    _validation = {
        "policy_effect": {"readonly": True},
    }

    _attribute_map = {
        "policy_effect": {"key": "policyEffect", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.policy_effect: Optional[str] = None


class PolicyEvaluationDetails(_serialization.Model):
    """Policy evaluation details.

    :ivar evaluated_expressions: Details of the evaluated expressions.
    :vartype evaluated_expressions:
     list[~azure.mgmt.policyinsights.models.ExpressionEvaluationDetails]
    :ivar if_not_exists_details: Evaluation details of IfNotExists effect.
    :vartype if_not_exists_details: ~azure.mgmt.policyinsights.models.IfNotExistsEvaluationDetails
    """

    _attribute_map = {
        "evaluated_expressions": {"key": "evaluatedExpressions", "type": "[ExpressionEvaluationDetails]"},
        "if_not_exists_details": {"key": "ifNotExistsDetails", "type": "IfNotExistsEvaluationDetails"},
    }

    def __init__(
        self,
        *,
        evaluated_expressions: Optional[List["_models.ExpressionEvaluationDetails"]] = None,
        if_not_exists_details: Optional["_models.IfNotExistsEvaluationDetails"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword evaluated_expressions: Details of the evaluated expressions.
        :paramtype evaluated_expressions:
         list[~azure.mgmt.policyinsights.models.ExpressionEvaluationDetails]
        :keyword if_not_exists_details: Evaluation details of IfNotExists effect.
        :paramtype if_not_exists_details:
         ~azure.mgmt.policyinsights.models.IfNotExistsEvaluationDetails
        """
        super().__init__(**kwargs)
        self.evaluated_expressions = evaluated_expressions
        self.if_not_exists_details = if_not_exists_details


class PolicyEvaluationResult(_serialization.Model):
    """The result of a non-compliant policy evaluation against the given resource content.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar policy_info: The details of the policy that was evaluated.
    :vartype policy_info: ~azure.mgmt.policyinsights.models.PolicyReference
    :ivar evaluation_result: The result of the policy evaluation against the resource. This will
     typically be 'NonCompliant' but may contain other values if errors were encountered.
    :vartype evaluation_result: str
    :ivar evaluation_details: The detailed results of the policy expressions and values that were
     evaluated.
    :vartype evaluation_details:
     ~azure.mgmt.policyinsights.models.CheckRestrictionEvaluationDetails
    :ivar effect_details: The details of the effect that was applied to the resource.
    :vartype effect_details: ~azure.mgmt.policyinsights.models.PolicyEffectDetails
    """

    _validation = {
        "policy_info": {"readonly": True},
        "evaluation_result": {"readonly": True},
        "evaluation_details": {"readonly": True},
        "effect_details": {"readonly": True},
    }

    _attribute_map = {
        "policy_info": {"key": "policyInfo", "type": "PolicyReference"},
        "evaluation_result": {"key": "evaluationResult", "type": "str"},
        "evaluation_details": {"key": "evaluationDetails", "type": "CheckRestrictionEvaluationDetails"},
        "effect_details": {"key": "effectDetails", "type": "PolicyEffectDetails"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.policy_info: Optional["_models.PolicyReference"] = None
        self.evaluation_result: Optional[str] = None
        self.evaluation_details: Optional["_models.CheckRestrictionEvaluationDetails"] = None
        self.effect_details: Optional["_models.PolicyEffectDetails"] = None


class PolicyEvent(_serialization.Model):
    """Policy event record.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar odata_id: OData entity ID; always set to null since policy event records do not have an
     entity ID.
    :vartype odata_id: str
    :ivar odata_context: OData context string; used by OData clients to resolve type information
     based on metadata.
    :vartype odata_context: str
    :ivar timestamp: Timestamp for the policy event record.
    :vartype timestamp: ~datetime.datetime
    :ivar resource_id: Resource ID.
    :vartype resource_id: str
    :ivar policy_assignment_id: Policy assignment ID.
    :vartype policy_assignment_id: str
    :ivar policy_definition_id: Policy definition ID.
    :vartype policy_definition_id: str
    :ivar effective_parameters: Effective parameters for the policy assignment.
    :vartype effective_parameters: str
    :ivar is_compliant: Flag which states whether the resource is compliant against the policy
     assignment it was evaluated against.
    :vartype is_compliant: bool
    :ivar subscription_id: Subscription ID.
    :vartype subscription_id: str
    :ivar resource_type: Resource type.
    :vartype resource_type: str
    :ivar resource_location: Resource location.
    :vartype resource_location: str
    :ivar resource_group: Resource group name.
    :vartype resource_group: str
    :ivar resource_tags: List of resource tags.
    :vartype resource_tags: str
    :ivar policy_assignment_name: Policy assignment name.
    :vartype policy_assignment_name: str
    :ivar policy_assignment_owner: Policy assignment owner.
    :vartype policy_assignment_owner: str
    :ivar policy_assignment_parameters: Policy assignment parameters.
    :vartype policy_assignment_parameters: str
    :ivar policy_assignment_scope: Policy assignment scope.
    :vartype policy_assignment_scope: str
    :ivar policy_definition_name: Policy definition name.
    :vartype policy_definition_name: str
    :ivar policy_definition_action: Policy definition action, i.e. effect.
    :vartype policy_definition_action: str
    :ivar policy_definition_category: Policy definition category.
    :vartype policy_definition_category: str
    :ivar policy_set_definition_id: Policy set definition ID, if the policy assignment is for a
     policy set.
    :vartype policy_set_definition_id: str
    :ivar policy_set_definition_name: Policy set definition name, if the policy assignment is for a
     policy set.
    :vartype policy_set_definition_name: str
    :ivar policy_set_definition_owner: Policy set definition owner, if the policy assignment is for
     a policy set.
    :vartype policy_set_definition_owner: str
    :ivar policy_set_definition_category: Policy set definition category, if the policy assignment
     is for a policy set.
    :vartype policy_set_definition_category: str
    :ivar policy_set_definition_parameters: Policy set definition parameters, if the policy
     assignment is for a policy set.
    :vartype policy_set_definition_parameters: str
    :ivar management_group_ids: Comma separated list of management group IDs, which represent the
     hierarchy of the management groups the resource is under.
    :vartype management_group_ids: str
    :ivar policy_definition_reference_id: Reference ID for the policy definition inside the policy
     set, if the policy assignment is for a policy set.
    :vartype policy_definition_reference_id: str
    :ivar compliance_state: Compliance state of the resource.
    :vartype compliance_state: str
    :ivar tenant_id: Tenant ID for the policy event record.
    :vartype tenant_id: str
    :ivar principal_oid: Principal object ID for the user who initiated the resource operation that
     triggered the policy event.
    :vartype principal_oid: str
    :ivar components: Components events records populated only when URL contains $expand=components
     clause.
    :vartype components: list[~azure.mgmt.policyinsights.models.ComponentEventDetails]
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "odata_id": {"key": "@odata\\.id", "type": "str"},
        "odata_context": {"key": "@odata\\.context", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "policy_assignment_id": {"key": "policyAssignmentId", "type": "str"},
        "policy_definition_id": {"key": "policyDefinitionId", "type": "str"},
        "effective_parameters": {"key": "effectiveParameters", "type": "str"},
        "is_compliant": {"key": "isCompliant", "type": "bool"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "resource_location": {"key": "resourceLocation", "type": "str"},
        "resource_group": {"key": "resourceGroup", "type": "str"},
        "resource_tags": {"key": "resourceTags", "type": "str"},
        "policy_assignment_name": {"key": "policyAssignmentName", "type": "str"},
        "policy_assignment_owner": {"key": "policyAssignmentOwner", "type": "str"},
        "policy_assignment_parameters": {"key": "policyAssignmentParameters", "type": "str"},
        "policy_assignment_scope": {"key": "policyAssignmentScope", "type": "str"},
        "policy_definition_name": {"key": "policyDefinitionName", "type": "str"},
        "policy_definition_action": {"key": "policyDefinitionAction", "type": "str"},
        "policy_definition_category": {"key": "policyDefinitionCategory", "type": "str"},
        "policy_set_definition_id": {"key": "policySetDefinitionId", "type": "str"},
        "policy_set_definition_name": {"key": "policySetDefinitionName", "type": "str"},
        "policy_set_definition_owner": {"key": "policySetDefinitionOwner", "type": "str"},
        "policy_set_definition_category": {"key": "policySetDefinitionCategory", "type": "str"},
        "policy_set_definition_parameters": {"key": "policySetDefinitionParameters", "type": "str"},
        "management_group_ids": {"key": "managementGroupIds", "type": "str"},
        "policy_definition_reference_id": {"key": "policyDefinitionReferenceId", "type": "str"},
        "compliance_state": {"key": "complianceState", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "principal_oid": {"key": "principalOid", "type": "str"},
        "components": {"key": "components", "type": "[ComponentEventDetails]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        odata_id: Optional[str] = None,
        odata_context: Optional[str] = None,
        timestamp: Optional[datetime.datetime] = None,
        resource_id: Optional[str] = None,
        policy_assignment_id: Optional[str] = None,
        policy_definition_id: Optional[str] = None,
        effective_parameters: Optional[str] = None,
        is_compliant: Optional[bool] = None,
        subscription_id: Optional[str] = None,
        resource_type: Optional[str] = None,
        resource_location: Optional[str] = None,
        resource_group: Optional[str] = None,
        resource_tags: Optional[str] = None,
        policy_assignment_name: Optional[str] = None,
        policy_assignment_owner: Optional[str] = None,
        policy_assignment_parameters: Optional[str] = None,
        policy_assignment_scope: Optional[str] = None,
        policy_definition_name: Optional[str] = None,
        policy_definition_action: Optional[str] = None,
        policy_definition_category: Optional[str] = None,
        policy_set_definition_id: Optional[str] = None,
        policy_set_definition_name: Optional[str] = None,
        policy_set_definition_owner: Optional[str] = None,
        policy_set_definition_category: Optional[str] = None,
        policy_set_definition_parameters: Optional[str] = None,
        management_group_ids: Optional[str] = None,
        policy_definition_reference_id: Optional[str] = None,
        compliance_state: Optional[str] = None,
        tenant_id: Optional[str] = None,
        principal_oid: Optional[str] = None,
        components: Optional[List["_models.ComponentEventDetails"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword odata_id: OData entity ID; always set to null since policy event records do not have
         an entity ID.
        :paramtype odata_id: str
        :keyword odata_context: OData context string; used by OData clients to resolve type information
         based on metadata.
        :paramtype odata_context: str
        :keyword timestamp: Timestamp for the policy event record.
        :paramtype timestamp: ~datetime.datetime
        :keyword resource_id: Resource ID.
        :paramtype resource_id: str
        :keyword policy_assignment_id: Policy assignment ID.
        :paramtype policy_assignment_id: str
        :keyword policy_definition_id: Policy definition ID.
        :paramtype policy_definition_id: str
        :keyword effective_parameters: Effective parameters for the policy assignment.
        :paramtype effective_parameters: str
        :keyword is_compliant: Flag which states whether the resource is compliant against the policy
         assignment it was evaluated against.
        :paramtype is_compliant: bool
        :keyword subscription_id: Subscription ID.
        :paramtype subscription_id: str
        :keyword resource_type: Resource type.
        :paramtype resource_type: str
        :keyword resource_location: Resource location.
        :paramtype resource_location: str
        :keyword resource_group: Resource group name.
        :paramtype resource_group: str
        :keyword resource_tags: List of resource tags.
        :paramtype resource_tags: str
        :keyword policy_assignment_name: Policy assignment name.
        :paramtype policy_assignment_name: str
        :keyword policy_assignment_owner: Policy assignment owner.
        :paramtype policy_assignment_owner: str
        :keyword policy_assignment_parameters: Policy assignment parameters.
        :paramtype policy_assignment_parameters: str
        :keyword policy_assignment_scope: Policy assignment scope.
        :paramtype policy_assignment_scope: str
        :keyword policy_definition_name: Policy definition name.
        :paramtype policy_definition_name: str
        :keyword policy_definition_action: Policy definition action, i.e. effect.
        :paramtype policy_definition_action: str
        :keyword policy_definition_category: Policy definition category.
        :paramtype policy_definition_category: str
        :keyword policy_set_definition_id: Policy set definition ID, if the policy assignment is for a
         policy set.
        :paramtype policy_set_definition_id: str
        :keyword policy_set_definition_name: Policy set definition name, if the policy assignment is
         for a policy set.
        :paramtype policy_set_definition_name: str
        :keyword policy_set_definition_owner: Policy set definition owner, if the policy assignment is
         for a policy set.
        :paramtype policy_set_definition_owner: str
        :keyword policy_set_definition_category: Policy set definition category, if the policy
         assignment is for a policy set.
        :paramtype policy_set_definition_category: str
        :keyword policy_set_definition_parameters: Policy set definition parameters, if the policy
         assignment is for a policy set.
        :paramtype policy_set_definition_parameters: str
        :keyword management_group_ids: Comma separated list of management group IDs, which represent
         the hierarchy of the management groups the resource is under.
        :paramtype management_group_ids: str
        :keyword policy_definition_reference_id: Reference ID for the policy definition inside the
         policy set, if the policy assignment is for a policy set.
        :paramtype policy_definition_reference_id: str
        :keyword compliance_state: Compliance state of the resource.
        :paramtype compliance_state: str
        :keyword tenant_id: Tenant ID for the policy event record.
        :paramtype tenant_id: str
        :keyword principal_oid: Principal object ID for the user who initiated the resource operation
         that triggered the policy event.
        :paramtype principal_oid: str
        :keyword components: Components events records populated only when URL contains
         $expand=components clause.
        :paramtype components: list[~azure.mgmt.policyinsights.models.ComponentEventDetails]
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.odata_id = odata_id
        self.odata_context = odata_context
        self.timestamp = timestamp
        self.resource_id = resource_id
        self.policy_assignment_id = policy_assignment_id
        self.policy_definition_id = policy_definition_id
        self.effective_parameters = effective_parameters
        self.is_compliant = is_compliant
        self.subscription_id = subscription_id
        self.resource_type = resource_type
        self.resource_location = resource_location
        self.resource_group = resource_group
        self.resource_tags = resource_tags
        self.policy_assignment_name = policy_assignment_name
        self.policy_assignment_owner = policy_assignment_owner
        self.policy_assignment_parameters = policy_assignment_parameters
        self.policy_assignment_scope = policy_assignment_scope
        self.policy_definition_name = policy_definition_name
        self.policy_definition_action = policy_definition_action
        self.policy_definition_category = policy_definition_category
        self.policy_set_definition_id = policy_set_definition_id
        self.policy_set_definition_name = policy_set_definition_name
        self.policy_set_definition_owner = policy_set_definition_owner
        self.policy_set_definition_category = policy_set_definition_category
        self.policy_set_definition_parameters = policy_set_definition_parameters
        self.management_group_ids = management_group_ids
        self.policy_definition_reference_id = policy_definition_reference_id
        self.compliance_state = compliance_state
        self.tenant_id = tenant_id
        self.principal_oid = principal_oid
        self.components = components


class PolicyEventsQueryResults(_serialization.Model):
    """Query results.

    :ivar odata_context: OData context string; used by OData clients to resolve type information
     based on metadata.
    :vartype odata_context: str
    :ivar odata_count: OData entity count; represents the number of policy event records returned.
    :vartype odata_count: int
    :ivar odata_next_link: Odata next link; URL to get the next set of results.
    :vartype odata_next_link: str
    :ivar value: Query results.
    :vartype value: list[~azure.mgmt.policyinsights.models.PolicyEvent]
    """

    _validation = {
        "odata_count": {"minimum": 0},
    }

    _attribute_map = {
        "odata_context": {"key": "@odata\\.context", "type": "str"},
        "odata_count": {"key": "@odata\\.count", "type": "int"},
        "odata_next_link": {"key": "@odata\\.nextLink", "type": "str"},
        "value": {"key": "value", "type": "[PolicyEvent]"},
    }

    def __init__(
        self,
        *,
        odata_context: Optional[str] = None,
        odata_count: Optional[int] = None,
        odata_next_link: Optional[str] = None,
        value: Optional[List["_models.PolicyEvent"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword odata_context: OData context string; used by OData clients to resolve type information
         based on metadata.
        :paramtype odata_context: str
        :keyword odata_count: OData entity count; represents the number of policy event records
         returned.
        :paramtype odata_count: int
        :keyword odata_next_link: Odata next link; URL to get the next set of results.
        :paramtype odata_next_link: str
        :keyword value: Query results.
        :paramtype value: list[~azure.mgmt.policyinsights.models.PolicyEvent]
        """
        super().__init__(**kwargs)
        self.odata_context = odata_context
        self.odata_count = odata_count
        self.odata_next_link = odata_next_link
        self.value = value


class PolicyGroupSummary(_serialization.Model):
    """Policy definition group summary.

    :ivar policy_group_name: Policy group name.
    :vartype policy_group_name: str
    :ivar results: Compliance summary for the policy definition group.
    :vartype results: ~azure.mgmt.policyinsights.models.SummaryResults
    """

    _attribute_map = {
        "policy_group_name": {"key": "policyGroupName", "type": "str"},
        "results": {"key": "results", "type": "SummaryResults"},
    }

    def __init__(
        self,
        *,
        policy_group_name: Optional[str] = None,
        results: Optional["_models.SummaryResults"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword policy_group_name: Policy group name.
        :paramtype policy_group_name: str
        :keyword results: Compliance summary for the policy definition group.
        :paramtype results: ~azure.mgmt.policyinsights.models.SummaryResults
        """
        super().__init__(**kwargs)
        self.policy_group_name = policy_group_name
        self.results = results


class PolicyMetadata(_serialization.Model):
    """Policy metadata resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the policy metadata.
    :vartype id: str
    :ivar type: The type of the policy metadata.
    :vartype type: str
    :ivar name: The name of the policy metadata.
    :vartype name: str
    :ivar metadata_id: The policy metadata identifier.
    :vartype metadata_id: str
    :ivar category: The category of the policy metadata.
    :vartype category: str
    :ivar title: The title of the policy metadata.
    :vartype title: str
    :ivar owner: The owner of the policy metadata.
    :vartype owner: str
    :ivar additional_content_url: Url for getting additional content about the resource metadata.
    :vartype additional_content_url: str
    :ivar metadata: Additional metadata.
    :vartype metadata: JSON
    :ivar description: The description of the policy metadata.
    :vartype description: str
    :ivar requirements: The requirements of the policy metadata.
    :vartype requirements: str
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "name": {"readonly": True},
        "metadata_id": {"readonly": True},
        "category": {"readonly": True},
        "title": {"readonly": True},
        "owner": {"readonly": True},
        "additional_content_url": {"readonly": True},
        "metadata": {"readonly": True},
        "description": {"readonly": True},
        "requirements": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "metadata_id": {"key": "properties.metadataId", "type": "str"},
        "category": {"key": "properties.category", "type": "str"},
        "title": {"key": "properties.title", "type": "str"},
        "owner": {"key": "properties.owner", "type": "str"},
        "additional_content_url": {"key": "properties.additionalContentUrl", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "object"},
        "description": {"key": "properties.description", "type": "str"},
        "requirements": {"key": "properties.requirements", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.type: Optional[str] = None
        self.name: Optional[str] = None
        self.metadata_id: Optional[str] = None
        self.category: Optional[str] = None
        self.title: Optional[str] = None
        self.owner: Optional[str] = None
        self.additional_content_url: Optional[str] = None
        self.metadata: Optional[JSON] = None
        self.description: Optional[str] = None
        self.requirements: Optional[str] = None


class PolicyMetadataCollection(_serialization.Model):
    """Collection of policy metadata resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of policy metadata definitions.
    :vartype value: list[~azure.mgmt.policyinsights.models.SlimPolicyMetadata]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SlimPolicyMetadata]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.SlimPolicyMetadata"]] = None
        self.next_link: Optional[str] = None


class PolicyMetadataSlimProperties(_serialization.Model):
    """The properties of the policy metadata, excluding properties containing large strings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar metadata_id: The policy metadata identifier.
    :vartype metadata_id: str
    :ivar category: The category of the policy metadata.
    :vartype category: str
    :ivar title: The title of the policy metadata.
    :vartype title: str
    :ivar owner: The owner of the policy metadata.
    :vartype owner: str
    :ivar additional_content_url: Url for getting additional content about the resource metadata.
    :vartype additional_content_url: str
    :ivar metadata: Additional metadata.
    :vartype metadata: JSON
    """

    _validation = {
        "metadata_id": {"readonly": True},
        "category": {"readonly": True},
        "title": {"readonly": True},
        "owner": {"readonly": True},
        "additional_content_url": {"readonly": True},
        "metadata": {"readonly": True},
    }

    _attribute_map = {
        "metadata_id": {"key": "metadataId", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "title": {"key": "title", "type": "str"},
        "owner": {"key": "owner", "type": "str"},
        "additional_content_url": {"key": "additionalContentUrl", "type": "str"},
        "metadata": {"key": "metadata", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.metadata_id: Optional[str] = None
        self.category: Optional[str] = None
        self.title: Optional[str] = None
        self.owner: Optional[str] = None
        self.additional_content_url: Optional[str] = None
        self.metadata: Optional[JSON] = None


class PolicyMetadataProperties(PolicyMetadataSlimProperties):
    """The properties of the policy metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar metadata_id: The policy metadata identifier.
    :vartype metadata_id: str
    :ivar category: The category of the policy metadata.
    :vartype category: str
    :ivar title: The title of the policy metadata.
    :vartype title: str
    :ivar owner: The owner of the policy metadata.
    :vartype owner: str
    :ivar additional_content_url: Url for getting additional content about the resource metadata.
    :vartype additional_content_url: str
    :ivar metadata: Additional metadata.
    :vartype metadata: JSON
    :ivar description: The description of the policy metadata.
    :vartype description: str
    :ivar requirements: The requirements of the policy metadata.
    :vartype requirements: str
    """

    _validation = {
        "metadata_id": {"readonly": True},
        "category": {"readonly": True},
        "title": {"readonly": True},
        "owner": {"readonly": True},
        "additional_content_url": {"readonly": True},
        "metadata": {"readonly": True},
        "description": {"readonly": True},
        "requirements": {"readonly": True},
    }

    _attribute_map = {
        "metadata_id": {"key": "metadataId", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "title": {"key": "title", "type": "str"},
        "owner": {"key": "owner", "type": "str"},
        "additional_content_url": {"key": "additionalContentUrl", "type": "str"},
        "metadata": {"key": "metadata", "type": "object"},
        "description": {"key": "description", "type": "str"},
        "requirements": {"key": "requirements", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.description: Optional[str] = None
        self.requirements: Optional[str] = None


class PolicyReference(_serialization.Model):
    """Resource identifiers for a policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar policy_definition_id: The resource identifier of the policy definition.
    :vartype policy_definition_id: str
    :ivar policy_set_definition_id: The resource identifier of the policy set definition.
    :vartype policy_set_definition_id: str
    :ivar policy_definition_reference_id: The reference identifier of a specific policy definition
     within a policy set definition.
    :vartype policy_definition_reference_id: str
    :ivar policy_assignment_id: The resource identifier of the policy assignment.
    :vartype policy_assignment_id: str
    """

    _validation = {
        "policy_definition_id": {"readonly": True},
        "policy_set_definition_id": {"readonly": True},
        "policy_definition_reference_id": {"readonly": True},
        "policy_assignment_id": {"readonly": True},
    }

    _attribute_map = {
        "policy_definition_id": {"key": "policyDefinitionId", "type": "str"},
        "policy_set_definition_id": {"key": "policySetDefinitionId", "type": "str"},
        "policy_definition_reference_id": {"key": "policyDefinitionReferenceId", "type": "str"},
        "policy_assignment_id": {"key": "policyAssignmentId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.policy_definition_id: Optional[str] = None
        self.policy_set_definition_id: Optional[str] = None
        self.policy_definition_reference_id: Optional[str] = None
        self.policy_assignment_id: Optional[str] = None


class PolicyState(_serialization.Model):
    """Policy state record.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar odata_id: OData entity ID; always set to null since policy state records do not have an
     entity ID.
    :vartype odata_id: str
    :ivar odata_context: OData context string; used by OData clients to resolve type information
     based on metadata.
    :vartype odata_context: str
    :ivar timestamp: Timestamp for the policy state record.
    :vartype timestamp: ~datetime.datetime
    :ivar resource_id: Resource ID.
    :vartype resource_id: str
    :ivar policy_assignment_id: Policy assignment ID.
    :vartype policy_assignment_id: str
    :ivar policy_definition_id: Policy definition ID.
    :vartype policy_definition_id: str
    :ivar effective_parameters: Effective parameters for the policy assignment.
    :vartype effective_parameters: str
    :ivar is_compliant: Flag which states whether the resource is compliant against the policy
     assignment it was evaluated against. This property is deprecated; please use ComplianceState
     instead.
    :vartype is_compliant: bool
    :ivar subscription_id: Subscription ID.
    :vartype subscription_id: str
    :ivar resource_type: Resource type.
    :vartype resource_type: str
    :ivar resource_location: Resource location.
    :vartype resource_location: str
    :ivar resource_group: Resource group name.
    :vartype resource_group: str
    :ivar resource_tags: List of resource tags.
    :vartype resource_tags: str
    :ivar policy_assignment_name: Policy assignment name.
    :vartype policy_assignment_name: str
    :ivar policy_assignment_owner: Policy assignment owner.
    :vartype policy_assignment_owner: str
    :ivar policy_assignment_parameters: Policy assignment parameters.
    :vartype policy_assignment_parameters: str
    :ivar policy_assignment_scope: Policy assignment scope.
    :vartype policy_assignment_scope: str
    :ivar policy_definition_name: Policy definition name.
    :vartype policy_definition_name: str
    :ivar policy_definition_action: Policy definition action, i.e. effect.
    :vartype policy_definition_action: str
    :ivar policy_definition_category: Policy definition category.
    :vartype policy_definition_category: str
    :ivar policy_set_definition_id: Policy set definition ID, if the policy assignment is for a
     policy set.
    :vartype policy_set_definition_id: str
    :ivar policy_set_definition_name: Policy set definition name, if the policy assignment is for a
     policy set.
    :vartype policy_set_definition_name: str
    :ivar policy_set_definition_owner: Policy set definition owner, if the policy assignment is for
     a policy set.
    :vartype policy_set_definition_owner: str
    :ivar policy_set_definition_category: Policy set definition category, if the policy assignment
     is for a policy set.
    :vartype policy_set_definition_category: str
    :ivar policy_set_definition_parameters: Policy set definition parameters, if the policy
     assignment is for a policy set.
    :vartype policy_set_definition_parameters: str
    :ivar management_group_ids: Comma separated list of management group IDs, which represent the
     hierarchy of the management groups the resource is under.
    :vartype management_group_ids: str
    :ivar policy_definition_reference_id: Reference ID for the policy definition inside the policy
     set, if the policy assignment is for a policy set.
    :vartype policy_definition_reference_id: str
    :ivar compliance_state: Compliance state of the resource.
    :vartype compliance_state: str
    :ivar policy_evaluation_details: Policy evaluation details.
    :vartype policy_evaluation_details: ~azure.mgmt.policyinsights.models.PolicyEvaluationDetails
    :ivar policy_definition_group_names: Policy definition group names.
    :vartype policy_definition_group_names: list[str]
    :ivar components: Components state compliance records populated only when URL contains
     $expand=components clause.
    :vartype components: list[~azure.mgmt.policyinsights.models.ComponentStateDetails]
    :ivar policy_definition_version: Evaluated policy definition version.
    :vartype policy_definition_version: str
    :ivar policy_set_definition_version: Evaluated policy set definition version.
    :vartype policy_set_definition_version: str
    :ivar policy_assignment_version: Evaluated policy assignment version.
    :vartype policy_assignment_version: str
    """

    _validation = {
        "policy_definition_version": {"readonly": True},
        "policy_set_definition_version": {"readonly": True},
        "policy_assignment_version": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "odata_id": {"key": "@odata\\.id", "type": "str"},
        "odata_context": {"key": "@odata\\.context", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "policy_assignment_id": {"key": "policyAssignmentId", "type": "str"},
        "policy_definition_id": {"key": "policyDefinitionId", "type": "str"},
        "effective_parameters": {"key": "effectiveParameters", "type": "str"},
        "is_compliant": {"key": "isCompliant", "type": "bool"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "resource_location": {"key": "resourceLocation", "type": "str"},
        "resource_group": {"key": "resourceGroup", "type": "str"},
        "resource_tags": {"key": "resourceTags", "type": "str"},
        "policy_assignment_name": {"key": "policyAssignmentName", "type": "str"},
        "policy_assignment_owner": {"key": "policyAssignmentOwner", "type": "str"},
        "policy_assignment_parameters": {"key": "policyAssignmentParameters", "type": "str"},
        "policy_assignment_scope": {"key": "policyAssignmentScope", "type": "str"},
        "policy_definition_name": {"key": "policyDefinitionName", "type": "str"},
        "policy_definition_action": {"key": "policyDefinitionAction", "type": "str"},
        "policy_definition_category": {"key": "policyDefinitionCategory", "type": "str"},
        "policy_set_definition_id": {"key": "policySetDefinitionId", "type": "str"},
        "policy_set_definition_name": {"key": "policySetDefinitionName", "type": "str"},
        "policy_set_definition_owner": {"key": "policySetDefinitionOwner", "type": "str"},
        "policy_set_definition_category": {"key": "policySetDefinitionCategory", "type": "str"},
        "policy_set_definition_parameters": {"key": "policySetDefinitionParameters", "type": "str"},
        "management_group_ids": {"key": "managementGroupIds", "type": "str"},
        "policy_definition_reference_id": {"key": "policyDefinitionReferenceId", "type": "str"},
        "compliance_state": {"key": "complianceState", "type": "str"},
        "policy_evaluation_details": {"key": "policyEvaluationDetails", "type": "PolicyEvaluationDetails"},
        "policy_definition_group_names": {"key": "policyDefinitionGroupNames", "type": "[str]"},
        "components": {"key": "components", "type": "[ComponentStateDetails]"},
        "policy_definition_version": {"key": "policyDefinitionVersion", "type": "str"},
        "policy_set_definition_version": {"key": "policySetDefinitionVersion", "type": "str"},
        "policy_assignment_version": {"key": "policyAssignmentVersion", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        odata_id: Optional[str] = None,
        odata_context: Optional[str] = None,
        timestamp: Optional[datetime.datetime] = None,
        resource_id: Optional[str] = None,
        policy_assignment_id: Optional[str] = None,
        policy_definition_id: Optional[str] = None,
        effective_parameters: Optional[str] = None,
        is_compliant: Optional[bool] = None,
        subscription_id: Optional[str] = None,
        resource_type: Optional[str] = None,
        resource_location: Optional[str] = None,
        resource_group: Optional[str] = None,
        resource_tags: Optional[str] = None,
        policy_assignment_name: Optional[str] = None,
        policy_assignment_owner: Optional[str] = None,
        policy_assignment_parameters: Optional[str] = None,
        policy_assignment_scope: Optional[str] = None,
        policy_definition_name: Optional[str] = None,
        policy_definition_action: Optional[str] = None,
        policy_definition_category: Optional[str] = None,
        policy_set_definition_id: Optional[str] = None,
        policy_set_definition_name: Optional[str] = None,
        policy_set_definition_owner: Optional[str] = None,
        policy_set_definition_category: Optional[str] = None,
        policy_set_definition_parameters: Optional[str] = None,
        management_group_ids: Optional[str] = None,
        policy_definition_reference_id: Optional[str] = None,
        compliance_state: Optional[str] = None,
        policy_evaluation_details: Optional["_models.PolicyEvaluationDetails"] = None,
        policy_definition_group_names: Optional[List[str]] = None,
        components: Optional[List["_models.ComponentStateDetails"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword odata_id: OData entity ID; always set to null since policy state records do not have
         an entity ID.
        :paramtype odata_id: str
        :keyword odata_context: OData context string; used by OData clients to resolve type information
         based on metadata.
        :paramtype odata_context: str
        :keyword timestamp: Timestamp for the policy state record.
        :paramtype timestamp: ~datetime.datetime
        :keyword resource_id: Resource ID.
        :paramtype resource_id: str
        :keyword policy_assignment_id: Policy assignment ID.
        :paramtype policy_assignment_id: str
        :keyword policy_definition_id: Policy definition ID.
        :paramtype policy_definition_id: str
        :keyword effective_parameters: Effective parameters for the policy assignment.
        :paramtype effective_parameters: str
        :keyword is_compliant: Flag which states whether the resource is compliant against the policy
         assignment it was evaluated against. This property is deprecated; please use ComplianceState
         instead.
        :paramtype is_compliant: bool
        :keyword subscription_id: Subscription ID.
        :paramtype subscription_id: str
        :keyword resource_type: Resource type.
        :paramtype resource_type: str
        :keyword resource_location: Resource location.
        :paramtype resource_location: str
        :keyword resource_group: Resource group name.
        :paramtype resource_group: str
        :keyword resource_tags: List of resource tags.
        :paramtype resource_tags: str
        :keyword policy_assignment_name: Policy assignment name.
        :paramtype policy_assignment_name: str
        :keyword policy_assignment_owner: Policy assignment owner.
        :paramtype policy_assignment_owner: str
        :keyword policy_assignment_parameters: Policy assignment parameters.
        :paramtype policy_assignment_parameters: str
        :keyword policy_assignment_scope: Policy assignment scope.
        :paramtype policy_assignment_scope: str
        :keyword policy_definition_name: Policy definition name.
        :paramtype policy_definition_name: str
        :keyword policy_definition_action: Policy definition action, i.e. effect.
        :paramtype policy_definition_action: str
        :keyword policy_definition_category: Policy definition category.
        :paramtype policy_definition_category: str
        :keyword policy_set_definition_id: Policy set definition ID, if the policy assignment is for a
         policy set.
        :paramtype policy_set_definition_id: str
        :keyword policy_set_definition_name: Policy set definition name, if the policy assignment is
         for a policy set.
        :paramtype policy_set_definition_name: str
        :keyword policy_set_definition_owner: Policy set definition owner, if the policy assignment is
         for a policy set.
        :paramtype policy_set_definition_owner: str
        :keyword policy_set_definition_category: Policy set definition category, if the policy
         assignment is for a policy set.
        :paramtype policy_set_definition_category: str
        :keyword policy_set_definition_parameters: Policy set definition parameters, if the policy
         assignment is for a policy set.
        :paramtype policy_set_definition_parameters: str
        :keyword management_group_ids: Comma separated list of management group IDs, which represent
         the hierarchy of the management groups the resource is under.
        :paramtype management_group_ids: str
        :keyword policy_definition_reference_id: Reference ID for the policy definition inside the
         policy set, if the policy assignment is for a policy set.
        :paramtype policy_definition_reference_id: str
        :keyword compliance_state: Compliance state of the resource.
        :paramtype compliance_state: str
        :keyword policy_evaluation_details: Policy evaluation details.
        :paramtype policy_evaluation_details: ~azure.mgmt.policyinsights.models.PolicyEvaluationDetails
        :keyword policy_definition_group_names: Policy definition group names.
        :paramtype policy_definition_group_names: list[str]
        :keyword components: Components state compliance records populated only when URL contains
         $expand=components clause.
        :paramtype components: list[~azure.mgmt.policyinsights.models.ComponentStateDetails]
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.odata_id = odata_id
        self.odata_context = odata_context
        self.timestamp = timestamp
        self.resource_id = resource_id
        self.policy_assignment_id = policy_assignment_id
        self.policy_definition_id = policy_definition_id
        self.effective_parameters = effective_parameters
        self.is_compliant = is_compliant
        self.subscription_id = subscription_id
        self.resource_type = resource_type
        self.resource_location = resource_location
        self.resource_group = resource_group
        self.resource_tags = resource_tags
        self.policy_assignment_name = policy_assignment_name
        self.policy_assignment_owner = policy_assignment_owner
        self.policy_assignment_parameters = policy_assignment_parameters
        self.policy_assignment_scope = policy_assignment_scope
        self.policy_definition_name = policy_definition_name
        self.policy_definition_action = policy_definition_action
        self.policy_definition_category = policy_definition_category
        self.policy_set_definition_id = policy_set_definition_id
        self.policy_set_definition_name = policy_set_definition_name
        self.policy_set_definition_owner = policy_set_definition_owner
        self.policy_set_definition_category = policy_set_definition_category
        self.policy_set_definition_parameters = policy_set_definition_parameters
        self.management_group_ids = management_group_ids
        self.policy_definition_reference_id = policy_definition_reference_id
        self.compliance_state = compliance_state
        self.policy_evaluation_details = policy_evaluation_details
        self.policy_definition_group_names = policy_definition_group_names
        self.components = components
        self.policy_definition_version: Optional[str] = None
        self.policy_set_definition_version: Optional[str] = None
        self.policy_assignment_version: Optional[str] = None


class PolicyStatesQueryResults(_serialization.Model):
    """Query results.

    :ivar odata_context: OData context string; used by OData clients to resolve type information
     based on metadata.
    :vartype odata_context: str
    :ivar odata_count: OData entity count; represents the number of policy state records returned.
    :vartype odata_count: int
    :ivar odata_next_link: Odata next link; URL to get the next set of results.
    :vartype odata_next_link: str
    :ivar value: Query results.
    :vartype value: list[~azure.mgmt.policyinsights.models.PolicyState]
    """

    _validation = {
        "odata_count": {"minimum": 0},
    }

    _attribute_map = {
        "odata_context": {"key": "@odata\\.context", "type": "str"},
        "odata_count": {"key": "@odata\\.count", "type": "int"},
        "odata_next_link": {"key": "@odata\\.nextLink", "type": "str"},
        "value": {"key": "value", "type": "[PolicyState]"},
    }

    def __init__(
        self,
        *,
        odata_context: Optional[str] = None,
        odata_count: Optional[int] = None,
        odata_next_link: Optional[str] = None,
        value: Optional[List["_models.PolicyState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword odata_context: OData context string; used by OData clients to resolve type information
         based on metadata.
        :paramtype odata_context: str
        :keyword odata_count: OData entity count; represents the number of policy state records
         returned.
        :paramtype odata_count: int
        :keyword odata_next_link: Odata next link; URL to get the next set of results.
        :paramtype odata_next_link: str
        :keyword value: Query results.
        :paramtype value: list[~azure.mgmt.policyinsights.models.PolicyState]
        """
        super().__init__(**kwargs)
        self.odata_context = odata_context
        self.odata_count = odata_count
        self.odata_next_link = odata_next_link
        self.value = value


class PolicyTrackedResource(_serialization.Model):
    """Policy tracked resource record.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tracked_resource_id: The ID of the policy tracked resource.
    :vartype tracked_resource_id: str
    :ivar policy_details: The details of the policy that require the tracked resource.
    :vartype policy_details: ~azure.mgmt.policyinsights.models.PolicyDetails
    :ivar created_by: The details of the policy triggered deployment that created the tracked
     resource.
    :vartype created_by: ~azure.mgmt.policyinsights.models.TrackedResourceModificationDetails
    :ivar last_modified_by: The details of the policy triggered deployment that modified the
     tracked resource.
    :vartype last_modified_by: ~azure.mgmt.policyinsights.models.TrackedResourceModificationDetails
    :ivar last_update_utc: Timestamp of the last update to the tracked resource.
    :vartype last_update_utc: ~datetime.datetime
    """

    _validation = {
        "tracked_resource_id": {"readonly": True},
        "policy_details": {"readonly": True},
        "created_by": {"readonly": True},
        "last_modified_by": {"readonly": True},
        "last_update_utc": {"readonly": True},
    }

    _attribute_map = {
        "tracked_resource_id": {"key": "trackedResourceId", "type": "str"},
        "policy_details": {"key": "policyDetails", "type": "PolicyDetails"},
        "created_by": {"key": "createdBy", "type": "TrackedResourceModificationDetails"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "TrackedResourceModificationDetails"},
        "last_update_utc": {"key": "lastUpdateUtc", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.tracked_resource_id: Optional[str] = None
        self.policy_details: Optional["_models.PolicyDetails"] = None
        self.created_by: Optional["_models.TrackedResourceModificationDetails"] = None
        self.last_modified_by: Optional["_models.TrackedResourceModificationDetails"] = None
        self.last_update_utc: Optional[datetime.datetime] = None


class PolicyTrackedResourcesQueryResults(_serialization.Model):
    """Query results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Query results.
    :vartype value: list[~azure.mgmt.policyinsights.models.PolicyTrackedResource]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PolicyTrackedResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.PolicyTrackedResource"]] = None
        self.next_link: Optional[str] = None


class QueryFailure(_serialization.Model):
    """Error response.

    :ivar error: Error definition.
    :vartype error: ~azure.mgmt.policyinsights.models.QueryFailureError
    """

    _attribute_map = {
        "error": {"key": "error", "type": "QueryFailureError"},
    }

    def __init__(self, *, error: Optional["_models.QueryFailureError"] = None, **kwargs: Any) -> None:
        """
        :keyword error: Error definition.
        :paramtype error: ~azure.mgmt.policyinsights.models.QueryFailureError
        """
        super().__init__(**kwargs)
        self.error = error


class QueryFailureError(_serialization.Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Service specific error code which serves as the substatus for the HTTP error code.
    :vartype code: str
    :ivar message: Description of the error.
    :vartype message: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None


class QueryOptions(_serialization.Model):
    """Parameter group.

    :ivar top: Maximum number of records to return.
    :vartype top: int
    :ivar filter: OData filter expression.
    :vartype filter: str
    :ivar order_by: Ordering expression using OData notation. One or more comma-separated column
     names with an optional "desc" (the default) or "asc", e.g. "$orderby=PolicyAssignmentId,
     ResourceId asc".
    :vartype order_by: str
    :ivar select: Select expression using OData notation. Limits the columns on each record to just
     those requested, e.g. "$select=PolicyAssignmentId, ResourceId".
    :vartype select: str
    :ivar from_property: ISO 8601 formatted timestamp specifying the start time of the interval to
     query. When not specified, the service uses ($to - 1-day).
    :vartype from_property: ~datetime.datetime
    :ivar to: ISO 8601 formatted timestamp specifying the end time of the interval to query. When
     not specified, the service uses request time.
    :vartype to: ~datetime.datetime
    :ivar apply: OData apply expression for aggregations.
    :vartype apply: str
    :ivar skip_token: Skiptoken is only provided if a previous response returned a partial result
     as a part of nextLink element.
    :vartype skip_token: str
    :ivar expand: The $expand query parameter. For example, to expand components use
     $expand=components.
    :vartype expand: str
    """

    _validation = {
        "top": {"minimum": 0},
    }

    _attribute_map = {
        "top": {"key": "Top", "type": "int"},
        "filter": {"key": "Filter", "type": "str"},
        "order_by": {"key": "OrderBy", "type": "str"},
        "select": {"key": "Select", "type": "str"},
        "from_property": {"key": "FromProperty", "type": "iso-8601"},
        "to": {"key": "To", "type": "iso-8601"},
        "apply": {"key": "Apply", "type": "str"},
        "skip_token": {"key": "SkipToken", "type": "str"},
        "expand": {"key": "Expand", "type": "str"},
    }

    def __init__(
        self,
        *,
        top: Optional[int] = None,
        filter: Optional[str] = None,  # pylint: disable=redefined-builtin
        order_by: Optional[str] = None,
        select: Optional[str] = None,
        from_property: Optional[datetime.datetime] = None,
        to: Optional[datetime.datetime] = None,
        apply: Optional[str] = None,
        skip_token: Optional[str] = None,
        expand: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword top: Maximum number of records to return.
        :paramtype top: int
        :keyword filter: OData filter expression.
        :paramtype filter: str
        :keyword order_by: Ordering expression using OData notation. One or more comma-separated column
         names with an optional "desc" (the default) or "asc", e.g. "$orderby=PolicyAssignmentId,
         ResourceId asc".
        :paramtype order_by: str
        :keyword select: Select expression using OData notation. Limits the columns on each record to
         just those requested, e.g. "$select=PolicyAssignmentId, ResourceId".
        :paramtype select: str
        :keyword from_property: ISO 8601 formatted timestamp specifying the start time of the interval
         to query. When not specified, the service uses ($to - 1-day).
        :paramtype from_property: ~datetime.datetime
        :keyword to: ISO 8601 formatted timestamp specifying the end time of the interval to query.
         When not specified, the service uses request time.
        :paramtype to: ~datetime.datetime
        :keyword apply: OData apply expression for aggregations.
        :paramtype apply: str
        :keyword skip_token: Skiptoken is only provided if a previous response returned a partial
         result as a part of nextLink element.
        :paramtype skip_token: str
        :keyword expand: The $expand query parameter. For example, to expand components use
         $expand=components.
        :paramtype expand: str
        """
        super().__init__(**kwargs)
        self.top = top
        self.filter = filter
        self.order_by = order_by
        self.select = select
        self.from_property = from_property
        self.to = to
        self.apply = apply
        self.skip_token = skip_token
        self.expand = expand


class Remediation(_serialization.Model):
    """The remediation definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the remediation.
    :vartype id: str
    :ivar type: The type of the remediation.
    :vartype type: str
    :ivar name: The name of the remediation.
    :vartype name: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.policyinsights.models.SystemData
    :ivar policy_assignment_id: The resource ID of the policy assignment that should be remediated.
    :vartype policy_assignment_id: str
    :ivar policy_definition_reference_id: The policy definition reference ID of the individual
     definition that should be remediated. Required when the policy assignment being remediated
     assigns a policy set definition.
    :vartype policy_definition_reference_id: str
    :ivar resource_discovery_mode: The way resources to remediate are discovered. Defaults to
     ExistingNonCompliant if not specified. Known values are: "ExistingNonCompliant" and
     "ReEvaluateCompliance".
    :vartype resource_discovery_mode: str or
     ~azure.mgmt.policyinsights.models.ResourceDiscoveryMode
    :ivar provisioning_state: The status of the remediation. This refers to the entire remediation
     task, not individual deployments. Allowed values are Evaluating, Canceled, Cancelling, Failed,
     Complete, or Succeeded.
    :vartype provisioning_state: str
    :ivar created_on: The time at which the remediation was created.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: The time at which the remediation was last updated.
    :vartype last_updated_on: ~datetime.datetime
    :ivar filters: The filters that will be applied to determine which resources to remediate.
    :vartype filters: ~azure.mgmt.policyinsights.models.RemediationFilters
    :ivar deployment_status: The deployment status summary for all deployments created by the
     remediation.
    :vartype deployment_status: ~azure.mgmt.policyinsights.models.RemediationDeploymentSummary
    :ivar status_message: The remediation status message. Provides additional details regarding the
     state of the remediation.
    :vartype status_message: str
    :ivar correlation_id: The remediation correlation Id. Can be used to find events related to the
     remediation in the activity log.
    :vartype correlation_id: str
    :ivar resource_count: Determines the max number of resources that can be remediated by the
     remediation job. If not provided, the default resource count is used.
    :vartype resource_count: int
    :ivar parallel_deployments: Determines how many resources to remediate at any given time. Can
     be used to increase or reduce the pace of the remediation. If not provided, the default
     parallel deployments value is used.
    :vartype parallel_deployments: int
    :ivar failure_threshold: The remediation failure threshold settings.
    :vartype failure_threshold:
     ~azure.mgmt.policyinsights.models.RemediationPropertiesFailureThreshold
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "created_on": {"readonly": True},
        "last_updated_on": {"readonly": True},
        "deployment_status": {"readonly": True},
        "status_message": {"readonly": True},
        "correlation_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "policy_assignment_id": {"key": "properties.policyAssignmentId", "type": "str"},
        "policy_definition_reference_id": {"key": "properties.policyDefinitionReferenceId", "type": "str"},
        "resource_discovery_mode": {"key": "properties.resourceDiscoveryMode", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "created_on": {"key": "properties.createdOn", "type": "iso-8601"},
        "last_updated_on": {"key": "properties.lastUpdatedOn", "type": "iso-8601"},
        "filters": {"key": "properties.filters", "type": "RemediationFilters"},
        "deployment_status": {"key": "properties.deploymentStatus", "type": "RemediationDeploymentSummary"},
        "status_message": {"key": "properties.statusMessage", "type": "str"},
        "correlation_id": {"key": "properties.correlationId", "type": "str"},
        "resource_count": {"key": "properties.resourceCount", "type": "int"},
        "parallel_deployments": {"key": "properties.parallelDeployments", "type": "int"},
        "failure_threshold": {"key": "properties.failureThreshold", "type": "RemediationPropertiesFailureThreshold"},
    }

    def __init__(
        self,
        *,
        policy_assignment_id: Optional[str] = None,
        policy_definition_reference_id: Optional[str] = None,
        resource_discovery_mode: Optional[Union[str, "_models.ResourceDiscoveryMode"]] = None,
        filters: Optional["_models.RemediationFilters"] = None,
        resource_count: Optional[int] = None,
        parallel_deployments: Optional[int] = None,
        failure_threshold: Optional["_models.RemediationPropertiesFailureThreshold"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword policy_assignment_id: The resource ID of the policy assignment that should be
         remediated.
        :paramtype policy_assignment_id: str
        :keyword policy_definition_reference_id: The policy definition reference ID of the individual
         definition that should be remediated. Required when the policy assignment being remediated
         assigns a policy set definition.
        :paramtype policy_definition_reference_id: str
        :keyword resource_discovery_mode: The way resources to remediate are discovered. Defaults to
         ExistingNonCompliant if not specified. Known values are: "ExistingNonCompliant" and
         "ReEvaluateCompliance".
        :paramtype resource_discovery_mode: str or
         ~azure.mgmt.policyinsights.models.ResourceDiscoveryMode
        :keyword filters: The filters that will be applied to determine which resources to remediate.
        :paramtype filters: ~azure.mgmt.policyinsights.models.RemediationFilters
        :keyword resource_count: Determines the max number of resources that can be remediated by the
         remediation job. If not provided, the default resource count is used.
        :paramtype resource_count: int
        :keyword parallel_deployments: Determines how many resources to remediate at any given time.
         Can be used to increase or reduce the pace of the remediation. If not provided, the default
         parallel deployments value is used.
        :paramtype parallel_deployments: int
        :keyword failure_threshold: The remediation failure threshold settings.
        :paramtype failure_threshold:
         ~azure.mgmt.policyinsights.models.RemediationPropertiesFailureThreshold
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.type: Optional[str] = None
        self.name: Optional[str] = None
        self.system_data: Optional["_models.SystemData"] = None
        self.policy_assignment_id = policy_assignment_id
        self.policy_definition_reference_id = policy_definition_reference_id
        self.resource_discovery_mode = resource_discovery_mode
        self.provisioning_state: Optional[str] = None
        self.created_on: Optional[datetime.datetime] = None
        self.last_updated_on: Optional[datetime.datetime] = None
        self.filters = filters
        self.deployment_status: Optional["_models.RemediationDeploymentSummary"] = None
        self.status_message: Optional[str] = None
        self.correlation_id: Optional[str] = None
        self.resource_count = resource_count
        self.parallel_deployments = parallel_deployments
        self.failure_threshold = failure_threshold


class RemediationDeployment(_serialization.Model):
    """Details of a single deployment created by the remediation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar remediated_resource_id: Resource ID of the resource that is being remediated by the
     deployment.
    :vartype remediated_resource_id: str
    :ivar deployment_id: Resource ID of the template deployment that will remediate the resource.
    :vartype deployment_id: str
    :ivar status: Status of the remediation deployment.
    :vartype status: str
    :ivar resource_location: Location of the resource that is being remediated.
    :vartype resource_location: str
    :ivar error: Error encountered while remediated the resource.
    :vartype error: ~azure.mgmt.policyinsights.models.ErrorDefinition
    :ivar created_on: The time at which the remediation was created.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_on: The time at which the remediation deployment was last updated.
    :vartype last_updated_on: ~datetime.datetime
    """

    _validation = {
        "remediated_resource_id": {"readonly": True},
        "deployment_id": {"readonly": True},
        "status": {"readonly": True},
        "resource_location": {"readonly": True},
        "error": {"readonly": True},
        "created_on": {"readonly": True},
        "last_updated_on": {"readonly": True},
    }

    _attribute_map = {
        "remediated_resource_id": {"key": "remediatedResourceId", "type": "str"},
        "deployment_id": {"key": "deploymentId", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "resource_location": {"key": "resourceLocation", "type": "str"},
        "error": {"key": "error", "type": "ErrorDefinition"},
        "created_on": {"key": "createdOn", "type": "iso-8601"},
        "last_updated_on": {"key": "lastUpdatedOn", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.remediated_resource_id: Optional[str] = None
        self.deployment_id: Optional[str] = None
        self.status: Optional[str] = None
        self.resource_location: Optional[str] = None
        self.error: Optional["_models.ErrorDefinition"] = None
        self.created_on: Optional[datetime.datetime] = None
        self.last_updated_on: Optional[datetime.datetime] = None


class RemediationDeploymentsListResult(_serialization.Model):
    """List of deployments for a remediation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of deployments for the remediation.
    :vartype value: list[~azure.mgmt.policyinsights.models.RemediationDeployment]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RemediationDeployment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.RemediationDeployment"]] = None
        self.next_link: Optional[str] = None


class RemediationDeploymentSummary(_serialization.Model):
    """The deployment status summary for all deployments created by the remediation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar total_deployments: The number of deployments required by the remediation.
    :vartype total_deployments: int
    :ivar successful_deployments: The number of deployments required by the remediation that have
     succeeded.
    :vartype successful_deployments: int
    :ivar failed_deployments: The number of deployments required by the remediation that have
     failed.
    :vartype failed_deployments: int
    """

    _validation = {
        "total_deployments": {"readonly": True},
        "successful_deployments": {"readonly": True},
        "failed_deployments": {"readonly": True},
    }

    _attribute_map = {
        "total_deployments": {"key": "totalDeployments", "type": "int"},
        "successful_deployments": {"key": "successfulDeployments", "type": "int"},
        "failed_deployments": {"key": "failedDeployments", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.total_deployments: Optional[int] = None
        self.successful_deployments: Optional[int] = None
        self.failed_deployments: Optional[int] = None


class RemediationFilters(_serialization.Model):
    """The filters that will be applied to determine which resources to remediate.

    :ivar locations: The resource locations that will be remediated.
    :vartype locations: list[str]
    :ivar resource_ids: The IDs of the resources that will be remediated. Can specify at most 100
     IDs. This filter cannot be used when ReEvaluateCompliance is set to ReEvaluateCompliance, and
     cannot be empty if provided.
    :vartype resource_ids: list[str]
    """

    _attribute_map = {
        "locations": {"key": "locations", "type": "[str]"},
        "resource_ids": {"key": "resourceIds", "type": "[str]"},
    }

    def __init__(
        self, *, locations: Optional[List[str]] = None, resource_ids: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword locations: The resource locations that will be remediated.
        :paramtype locations: list[str]
        :keyword resource_ids: The IDs of the resources that will be remediated. Can specify at most
         100 IDs. This filter cannot be used when ReEvaluateCompliance is set to ReEvaluateCompliance,
         and cannot be empty if provided.
        :paramtype resource_ids: list[str]
        """
        super().__init__(**kwargs)
        self.locations = locations
        self.resource_ids = resource_ids


class RemediationListResult(_serialization.Model):
    """List of remediations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of remediation definitions.
    :vartype value: list[~azure.mgmt.policyinsights.models.Remediation]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Remediation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.Remediation"]] = None
        self.next_link: Optional[str] = None


class RemediationPropertiesFailureThreshold(_serialization.Model):
    """The remediation failure threshold settings.

    :ivar percentage: A number between 0.0 to 1.0 representing the percentage failure threshold.
     The remediation will fail if the percentage of failed remediation operations (i.e. failed
     deployments) exceeds this threshold.
    :vartype percentage: float
    """

    _attribute_map = {
        "percentage": {"key": "percentage", "type": "float"},
    }

    def __init__(self, *, percentage: Optional[float] = None, **kwargs: Any) -> None:
        """
        :keyword percentage: A number between 0.0 to 1.0 representing the percentage failure threshold.
         The remediation will fail if the percentage of failed remediation operations (i.e. failed
         deployments) exceeds this threshold.
        :paramtype percentage: float
        """
        super().__init__(**kwargs)
        self.percentage = percentage


class SlimPolicyMetadata(_serialization.Model):
    """Slim version of policy metadata resource definition, excluding properties with large strings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the policy metadata.
    :vartype id: str
    :ivar type: The type of the policy metadata.
    :vartype type: str
    :ivar name: The name of the policy metadata.
    :vartype name: str
    :ivar metadata_id: The policy metadata identifier.
    :vartype metadata_id: str
    :ivar category: The category of the policy metadata.
    :vartype category: str
    :ivar title: The title of the policy metadata.
    :vartype title: str
    :ivar owner: The owner of the policy metadata.
    :vartype owner: str
    :ivar additional_content_url: Url for getting additional content about the resource metadata.
    :vartype additional_content_url: str
    :ivar metadata: Additional metadata.
    :vartype metadata: JSON
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "name": {"readonly": True},
        "metadata_id": {"readonly": True},
        "category": {"readonly": True},
        "title": {"readonly": True},
        "owner": {"readonly": True},
        "additional_content_url": {"readonly": True},
        "metadata": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "metadata_id": {"key": "properties.metadataId", "type": "str"},
        "category": {"key": "properties.category", "type": "str"},
        "title": {"key": "properties.title", "type": "str"},
        "owner": {"key": "properties.owner", "type": "str"},
        "additional_content_url": {"key": "properties.additionalContentUrl", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.type: Optional[str] = None
        self.name: Optional[str] = None
        self.metadata_id: Optional[str] = None
        self.category: Optional[str] = None
        self.title: Optional[str] = None
        self.owner: Optional[str] = None
        self.additional_content_url: Optional[str] = None
        self.metadata: Optional[JSON] = None


class SummarizeResults(_serialization.Model):
    """Summarize action results.

    :ivar odata_context: OData context string; used by OData clients to resolve type information
     based on metadata.
    :vartype odata_context: str
    :ivar odata_count: OData entity count; represents the number of summaries returned; always set
     to 1.
    :vartype odata_count: int
    :ivar value: Summarize action results.
    :vartype value: list[~azure.mgmt.policyinsights.models.Summary]
    """

    _validation = {
        "odata_count": {"maximum": 1, "minimum": 1},
    }

    _attribute_map = {
        "odata_context": {"key": "@odata\\.context", "type": "str"},
        "odata_count": {"key": "@odata\\.count", "type": "int"},
        "value": {"key": "value", "type": "[Summary]"},
    }

    def __init__(
        self,
        *,
        odata_context: Optional[str] = None,
        odata_count: Optional[int] = None,
        value: Optional[List["_models.Summary"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword odata_context: OData context string; used by OData clients to resolve type information
         based on metadata.
        :paramtype odata_context: str
        :keyword odata_count: OData entity count; represents the number of summaries returned; always
         set to 1.
        :paramtype odata_count: int
        :keyword value: Summarize action results.
        :paramtype value: list[~azure.mgmt.policyinsights.models.Summary]
        """
        super().__init__(**kwargs)
        self.odata_context = odata_context
        self.odata_count = odata_count
        self.value = value


class Summary(_serialization.Model):
    """Summary results.

    :ivar odata_id: OData entity ID; always set to null since summaries do not have an entity ID.
    :vartype odata_id: str
    :ivar odata_context: OData context string; used by OData clients to resolve type information
     based on metadata.
    :vartype odata_context: str
    :ivar results: Compliance summary for all policy assignments.
    :vartype results: ~azure.mgmt.policyinsights.models.SummaryResults
    :ivar policy_assignments: Policy assignments summary.
    :vartype policy_assignments: list[~azure.mgmt.policyinsights.models.PolicyAssignmentSummary]
    """

    _attribute_map = {
        "odata_id": {"key": "@odata\\.id", "type": "str"},
        "odata_context": {"key": "@odata\\.context", "type": "str"},
        "results": {"key": "results", "type": "SummaryResults"},
        "policy_assignments": {"key": "policyAssignments", "type": "[PolicyAssignmentSummary]"},
    }

    def __init__(
        self,
        *,
        odata_id: Optional[str] = None,
        odata_context: Optional[str] = None,
        results: Optional["_models.SummaryResults"] = None,
        policy_assignments: Optional[List["_models.PolicyAssignmentSummary"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword odata_id: OData entity ID; always set to null since summaries do not have an entity
         ID.
        :paramtype odata_id: str
        :keyword odata_context: OData context string; used by OData clients to resolve type information
         based on metadata.
        :paramtype odata_context: str
        :keyword results: Compliance summary for all policy assignments.
        :paramtype results: ~azure.mgmt.policyinsights.models.SummaryResults
        :keyword policy_assignments: Policy assignments summary.
        :paramtype policy_assignments: list[~azure.mgmt.policyinsights.models.PolicyAssignmentSummary]
        """
        super().__init__(**kwargs)
        self.odata_id = odata_id
        self.odata_context = odata_context
        self.results = results
        self.policy_assignments = policy_assignments


class SummaryResults(_serialization.Model):
    """Compliance summary on a particular summary level.

    :ivar query_results_uri: HTTP POST URI for queryResults action on Microsoft.PolicyInsights to
     retrieve raw results for the compliance summary. This property will not be available by default
     in future API versions, but could be queried explicitly.
    :vartype query_results_uri: str
    :ivar non_compliant_resources: Number of non-compliant resources.
    :vartype non_compliant_resources: int
    :ivar non_compliant_policies: Number of non-compliant policies.
    :vartype non_compliant_policies: int
    :ivar resource_details: The resources summary at this level.
    :vartype resource_details: list[~azure.mgmt.policyinsights.models.ComplianceDetail]
    :ivar policy_details: The policy artifact summary at this level. For query scope level, it
     represents policy assignment summary. For policy assignment level, it represents policy
     definitions summary.
    :vartype policy_details: list[~azure.mgmt.policyinsights.models.ComplianceDetail]
    :ivar policy_group_details: The policy definition group summary at this level.
    :vartype policy_group_details: list[~azure.mgmt.policyinsights.models.ComplianceDetail]
    """

    _validation = {
        "non_compliant_resources": {"minimum": 0},
        "non_compliant_policies": {"minimum": 0},
    }

    _attribute_map = {
        "query_results_uri": {"key": "queryResultsUri", "type": "str"},
        "non_compliant_resources": {"key": "nonCompliantResources", "type": "int"},
        "non_compliant_policies": {"key": "nonCompliantPolicies", "type": "int"},
        "resource_details": {"key": "resourceDetails", "type": "[ComplianceDetail]"},
        "policy_details": {"key": "policyDetails", "type": "[ComplianceDetail]"},
        "policy_group_details": {"key": "policyGroupDetails", "type": "[ComplianceDetail]"},
    }

    def __init__(
        self,
        *,
        query_results_uri: Optional[str] = None,
        non_compliant_resources: Optional[int] = None,
        non_compliant_policies: Optional[int] = None,
        resource_details: Optional[List["_models.ComplianceDetail"]] = None,
        policy_details: Optional[List["_models.ComplianceDetail"]] = None,
        policy_group_details: Optional[List["_models.ComplianceDetail"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword query_results_uri: HTTP POST URI for queryResults action on Microsoft.PolicyInsights
         to retrieve raw results for the compliance summary. This property will not be available by
         default in future API versions, but could be queried explicitly.
        :paramtype query_results_uri: str
        :keyword non_compliant_resources: Number of non-compliant resources.
        :paramtype non_compliant_resources: int
        :keyword non_compliant_policies: Number of non-compliant policies.
        :paramtype non_compliant_policies: int
        :keyword resource_details: The resources summary at this level.
        :paramtype resource_details: list[~azure.mgmt.policyinsights.models.ComplianceDetail]
        :keyword policy_details: The policy artifact summary at this level. For query scope level, it
         represents policy assignment summary. For policy assignment level, it represents policy
         definitions summary.
        :paramtype policy_details: list[~azure.mgmt.policyinsights.models.ComplianceDetail]
        :keyword policy_group_details: The policy definition group summary at this level.
        :paramtype policy_group_details: list[~azure.mgmt.policyinsights.models.ComplianceDetail]
        """
        super().__init__(**kwargs)
        self.query_results_uri = query_results_uri
        self.non_compliant_resources = non_compliant_resources
        self.non_compliant_policies = non_compliant_policies
        self.resource_details = resource_details
        self.policy_details = policy_details
        self.policy_group_details = policy_group_details


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.policyinsights.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.policyinsights.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.policyinsights.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.policyinsights.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TrackedResourceModificationDetails(_serialization.Model):
    """The details of the policy triggered deployment that created or modified the tracked resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar policy_details: The details of the policy that created or modified the tracked resource.
    :vartype policy_details: ~azure.mgmt.policyinsights.models.PolicyDetails
    :ivar deployment_id: The ID of the deployment that created or modified the tracked resource.
    :vartype deployment_id: str
    :ivar deployment_time: Timestamp of the deployment that created or modified the tracked
     resource.
    :vartype deployment_time: ~datetime.datetime
    """

    _validation = {
        "policy_details": {"readonly": True},
        "deployment_id": {"readonly": True},
        "deployment_time": {"readonly": True},
    }

    _attribute_map = {
        "policy_details": {"key": "policyDetails", "type": "PolicyDetails"},
        "deployment_id": {"key": "deploymentId", "type": "str"},
        "deployment_time": {"key": "deploymentTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.policy_details: Optional["_models.PolicyDetails"] = None
        self.deployment_id: Optional[str] = None
        self.deployment_time: Optional[datetime.datetime] = None


class TypedErrorInfo(_serialization.Model):
    """Scenario specific error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of included error details.
    :vartype type: str
    :ivar info: The scenario specific error details.
    :vartype info: any
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[Any] = None
