\name{smooth.construct.sz.smooth.spec}
\alias{smooth.construct.sz.smooth.spec}
\alias{Predict.matrix.sz.interaction}

%- Also NEED an `\alias' for EACH other topic documented here.
\title{Constrained factor smooth interactions in GAMs}

\description{Factor smooth interactions constructed to exclude main effects (and lower order factor smooth interactions). A smooth is constucted for each combination of the supplied factor levels. By appropriate application of sum to zero contrasts to equivalent smooth coefficients across factor levels, the required exclusion of lower order effects is achieved.   


See \link{factor.smooth} for alternative factor smooth interactions.
}

\usage{
\method{smooth.construct}{sz.smooth.spec}(object, data, knots)
\method{Predict.matrix}{sz.interaction}(object, data)
}

\arguments{ 
\item{object}{For the \code{smooth.construct} method a smooth specification object, 
usually generated by a term \code{s(x,...,bs="sz",)}. For the \code{predict.Matrix} method 
an object of class \code{"sz.interaction"} produced by the \code{smooth.construct} method.}

\item{data}{a list containing just the data (including any \code{by} variable) required by this term, 
            with names corresponding to \code{object$term}.} 

\item{knots}{ a list containing any knots supplied for smooth basis setup.}

}

\value{ An object of class \code{"sz.interaction"} or a matrix mapping the coefficients of the factor smooth interaction to the smooths themselves.
}

\details{This class produces a smooth for each combination of the levels of the supplied factor variables. \code{s(fac,x,bs="sz")} produces a smooth of \code{x} for each level of \code{fac}, for example. The smooths are constrained to represent deviations from the main effect smooth, so that models such as
\deqn{g(\mu_i) = f(x_i) + f_{k(i)}(x_i)}{g(mu_i) = f(x_i) + f_k(i)(x_i)}
can be estimated in an identifiable manner, where \eqn{k(i)}{k(i)} indicates the level of some factor that applies for the ith observation. Identifiability in this case is ensured by constraining the coefficients of the splines representing the \eqn{f_{k}}{k}. In particular if \eqn{\beta_{ki}}{beta_ki} is the ith coefficient of \eqn{f_k}{f_k} then the constraints are \eqn{\sum_k \beta_{ki} = 0}{\sum_k beta_ki = 0}.

Such sum to zero constraints are implemented using sum to zero contrasts: identity matrices with an extra row of -1s appended. Consider the case of a single factor first. The model matrix corresponding to a smooth per factor level is the row tensor product (see \code{\link{tensor.prod.model.matrix}}) of the model matrix for the factor, and the model matrix for the smooth. The contrast matrix is then the Kronecker product of the sum to zero contrast for the factor, and an identity matrix of dimension determined by the number of coefficients of the smooth.

If there are multiple factors then the overall model matrix is the row Kronecker product of all the factor model matrices and the smooth, while the contrast is the Kronecker product of all the sum-to-zero contrasts for the factors and a final identity matrix. Notice that this construction means that the main effects (and any interactions) of the factors are included in the factor level dependent smooths. In other words the individual smooths are not each centered. This means that adding main effects or interactions of the factors will lead to a rank deficient model. 

The terms can have a smoothing parameter per smooth, or a single smoothing parameter for all the smooths. The latter is specified by giving the smooth term an \code{id}. e.g. \code{s(fac,x,bs="sz",id=1)}.

The basis for the smooths can be selected by supplying a list as the \code{xt} argument to \code{\link{s}}, with a \code{bs} item. e.g. \code{s(fac,x,xt=list(bs="cr"))} selectes the \code{"cr"} basis. The default is \code{"tp"}

The plot method for this class has two schemes. \code{scheme==0} is in colour, while \code{scheme==1} is black and white. Currently it only works for 1D smooths.
}


\author{ Simon N. Wood \email{simon.wood@r-project.org} with input from Matteo Fasiolo.}

\seealso{\code{\link{gam.models}}, \code{\link{gamm}}, \link{factor.smooth}}

\examples{
library(mgcv)
set.seed(0)
dat <- gamSim(4)

b <- gam(y ~ s(x2)+s(fac,x2,bs="sz")+s(x0),data=dat,method="REML")
plot(b,pages=1)
summary(b)

## Example involving 2 factors

f1 <- function(x2) 2 * sin(pi * x2)
f2 <- function(x2) exp(2 * x2) - 3.75887
f3 <- function(x2) 0.2 * x2^11 * (10 * (1 - x2))^6 + 10 * (10 * x2)^3 * 
            (1 - x2)^10

n <- 600
x <- runif(n)
f1 <- factor(sample(c("a","b","c"),n,replace=TRUE))
f2 <- factor(sample(c("foo","bar"),n,replace=TRUE))

mu <- f3(x)
for (i in 1:3) mu <- mu + exp(2*(2-i)*x)*(f1==levels(f1)[i])
for (i in 1:2) mu <- mu + 10*i*x*(1-x)*(f2==levels(f2)[i])
y <- mu + rnorm(n)
dat <- data.frame(y=y,x=x,f1=f1,f2=f2)
b <- gam(y ~ s(x)+s(f1,x,bs="sz")+s(f2,x,bs="sz")+s(f1,f2,x,bs="sz",id=1),data=dat,method="REML")
plot(b,pages=1,scale=0)



}
\keyword{models} \keyword{regression}%-- one or more ..


