% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{==.CFTime}
\alias{==.CFTime}
\alias{CFtime-equivalent}
\title{Equivalence of CFTime objects}
\usage{
\method{==}{CFTime}(e1, e2)
}
\arguments{
\item{e1, e2}{Instances of the \code{CFTime} class.}
}
\value{
\code{TRUE} if the \code{CFTime} objects are equivalent, \code{FALSE} otherwise.
}
\description{
This operator can be used to test if two \link{CFTime} objects represent the same
CF-convention time coordinates. Two \code{CFTime} objects are considered equivalent
if they have an equivalent calendar and the same offsets.
}
\examples{
e1 <- CFtime("days since 1850-01-01", "gregorian", 0:364)
e2 <- CFtime("days since 1850-01-01 00:00:00", "standard", 0:364)
e1 == e2
}
