% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth-flow-client-credentials.R
\name{req_oauth_client_credentials}
\alias{req_oauth_client_credentials}
\alias{oauth_flow_client_credentials}
\title{OAuth with client credentials}
\usage{
req_oauth_client_credentials(req, client, scope = NULL, token_params = list())

oauth_flow_client_credentials(client, scope = NULL, token_params = list())
}
\arguments{
\item{req}{A httr2 \link{request} object.}

\item{client}{An \code{\link[=oauth_client]{oauth_client()}}.}

\item{scope}{Scopes to be requested from the resource owner.}

\item{token_params}{List containing additional parameters passed to the
\code{token_url}.}
}
\value{
\code{req_oauth_client_credentials()} returns a modified HTTP \link{request} that will
use OAuth; \code{oauth_flow_client_credentials()} returns an \link{oauth_token}.
}
\description{
Authenticate using OAuth \strong{client credentials flow}, as defined by
\href{https://datatracker.ietf.org/doc/html/rfc6749#section-4.4}{Section 4.4 of RFC 6749}. It is used to allow the client to access resources that
it controls directly, not on behalf of an user.

Learn more about the overall OAuth authentication flow in
\url{https://httr2.r-lib.org/articles/oauth.html}.
}
\examples{
req_auth <- function(req) {
  req_oauth_client_credentials(
    req,
    client = oauth_client("example", "https://example.com/get_token")
  )
}

request("https://example.com") |>
  req_auth()
}
\seealso{
Other OAuth flows: 
\code{\link{req_oauth_auth_code}()},
\code{\link{req_oauth_bearer_jwt}()},
\code{\link{req_oauth_password}()},
\code{\link{req_oauth_refresh}()},
\code{\link{req_oauth_token_exchange}()}
}
\concept{OAuth flows}
