// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT
#![allow(deprecated)]

#[cfg(feature = "v0_80")]
#[cfg_attr(docsrs, doc(cfg(feature = "v0_80")))]
use crate::PrintDuplex;
#[cfg(feature = "v0_73")]
#[cfg_attr(docsrs, doc(cfg(feature = "v0_73")))]
use crate::PrintScaling;
#[cfg(feature = "v23_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v23_7")))]
use crate::SigningData;
use crate::{
    ffi, Attachment, Dest, FormField, PDFConformance, PDFPart, PDFSubtype, Page, PageLayout,
    PageMode, Permissions, ViewerPreferences,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;
#[cfg(feature = "v23_7")]
#[cfg_attr(docsrs, doc(cfg(feature = "v23_7")))]
use std::pin::Pin;

glib::wrapper! {
    #[doc(alias = "PopplerDocument")]
    pub struct Document(Object<ffi::PopplerDocument>);

    match fn {
        type_ => || ffi::poppler_document_get_type(),
    }
}

impl Document {
    #[cfg(feature = "v0_82")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v0_82")))]
    #[doc(alias = "poppler_document_new_from_bytes")]
    #[doc(alias = "new_from_bytes")]
    pub fn from_bytes(
        bytes: &glib::Bytes,
        password: Option<&str>,
    ) -> Result<Document, glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let ret = ffi::poppler_document_new_from_bytes(
                bytes.to_glib_none().0,
                password.to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[cfg_attr(feature = "v0_82", deprecated = "Since 0.82")]
    #[allow(deprecated)]
    #[doc(alias = "poppler_document_new_from_data")]
    #[doc(alias = "new_from_data")]
    pub fn from_data(data: &[u8], password: Option<&str>) -> Result<Document, glib::Error> {
        let length = data.len() as _;
        unsafe {
            let mut error = std::ptr::null_mut();
            let ret = ffi::poppler_document_new_from_data(
                data.to_glib_none().0,
                length,
                password.to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[cfg(target_os = "linux")]
    #[cfg_attr(docsrs, doc(cfg(target_os = "linux")))]
    #[cfg(feature = "v21_12")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v21_12")))]
    #[doc(alias = "poppler_document_new_from_fd")]
    #[doc(alias = "new_from_fd")]
    pub fn from_fd(fd: i32, password: Option<&str>) -> Result<Document, glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let ret = ffi::poppler_document_new_from_fd(fd, password.to_glib_none().0, &mut error);
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "poppler_document_new_from_file")]
    #[doc(alias = "new_from_file")]
    pub fn from_file(uri: &str, password: Option<&str>) -> Result<Document, glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let ret = ffi::poppler_document_new_from_file(
                uri.to_glib_none().0,
                password.to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "poppler_document_new_from_gfile")]
    #[doc(alias = "new_from_gfile")]
    pub fn from_gfile(
        file: &impl IsA<gio::File>,
        password: Option<&str>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Document, glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let ret = ffi::poppler_document_new_from_gfile(
                file.as_ref().to_glib_none().0,
                password.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "poppler_document_new_from_stream")]
    #[doc(alias = "new_from_stream")]
    pub fn from_stream(
        stream: &impl IsA<gio::InputStream>,
        length: i64,
        password: Option<&str>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Document, glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let ret = ffi::poppler_document_new_from_stream(
                stream.as_ref().to_glib_none().0,
                length,
                password.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Document`] objects.
    ///
    /// This method returns an instance of [`DocumentBuilder`](crate::builders::DocumentBuilder) which can be used to create [`Document`] objects.
    pub fn builder() -> DocumentBuilder {
        DocumentBuilder::new()
    }

    //#[cfg(feature = "v0_78")]
    //#[cfg_attr(docsrs, doc(cfg(feature = "v0_78")))]
    //#[doc(alias = "poppler_document_create_dests_tree")]
    //pub fn create_dests_tree(&self) -> /*Ignored*/Option<glib::Tree> {
    //    unsafe { TODO: call ffi:poppler_document_create_dests_tree() }
    //}

    #[doc(alias = "poppler_document_find_dest")]
    pub fn find_dest(&self, link_name: &str) -> Option<Dest> {
        unsafe {
            from_glib_full(ffi::poppler_document_find_dest(
                self.to_glib_none().0,
                link_name.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_document_get_attachments")]
    #[doc(alias = "get_attachments")]
    pub fn attachments(&self) -> Vec<Attachment> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::poppler_document_get_attachments(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_document_get_author")]
    #[doc(alias = "get_author")]
    pub fn author(&self) -> Option<glib::GString> {
        unsafe { from_glib_full(ffi::poppler_document_get_author(self.to_glib_none().0)) }
    }

    #[doc(alias = "poppler_document_get_creation_date")]
    #[doc(alias = "get_creation_date")]
    #[doc(alias = "creation-date")]
    pub fn creation_date(&self) -> libc::time_t {
        unsafe { ffi::poppler_document_get_creation_date(self.to_glib_none().0) }
    }

    #[cfg(feature = "v20_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v20_9")))]
    #[doc(alias = "poppler_document_get_creation_date_time")]
    #[doc(alias = "get_creation_date_time")]
    pub fn creation_date_time(&self) -> Option<glib::DateTime> {
        unsafe {
            from_glib_full(ffi::poppler_document_get_creation_date_time(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_document_get_creator")]
    #[doc(alias = "get_creator")]
    pub fn creator(&self) -> Option<glib::GString> {
        unsafe { from_glib_full(ffi::poppler_document_get_creator(self.to_glib_none().0)) }
    }

    #[doc(alias = "poppler_document_get_form_field")]
    #[doc(alias = "get_form_field")]
    pub fn form_field(&self, id: i32) -> Option<FormField> {
        unsafe {
            from_glib_full(ffi::poppler_document_get_form_field(
                self.to_glib_none().0,
                id,
            ))
        }
    }

    #[doc(alias = "poppler_document_get_id")]
    #[doc(alias = "get_id")]
    pub fn id(&self) -> Option<(glib::GString, glib::GString)> {
        unsafe {
            let mut permanent_id = std::ptr::null_mut();
            let mut update_id = std::ptr::null_mut();
            let ret = from_glib(ffi::poppler_document_get_id(
                self.to_glib_none().0,
                &mut permanent_id,
                &mut update_id,
            ));
            if ret {
                Some((from_glib_full(permanent_id), from_glib_full(update_id)))
            } else {
                None
            }
        }
    }

    #[doc(alias = "poppler_document_get_keywords")]
    #[doc(alias = "get_keywords")]
    pub fn keywords(&self) -> Option<glib::GString> {
        unsafe { from_glib_full(ffi::poppler_document_get_keywords(self.to_glib_none().0)) }
    }

    #[doc(alias = "poppler_document_get_metadata")]
    #[doc(alias = "get_metadata")]
    pub fn metadata(&self) -> Option<glib::GString> {
        unsafe { from_glib_full(ffi::poppler_document_get_metadata(self.to_glib_none().0)) }
    }

    #[doc(alias = "poppler_document_get_modification_date")]
    #[doc(alias = "get_modification_date")]
    pub fn modification_date(&self) -> libc::time_t {
        unsafe { ffi::poppler_document_get_modification_date(self.to_glib_none().0) }
    }

    #[cfg(feature = "v20_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v20_9")))]
    #[doc(alias = "poppler_document_get_modification_date_time")]
    #[doc(alias = "get_modification_date_time")]
    pub fn modification_date_time(&self) -> Option<glib::DateTime> {
        unsafe {
            from_glib_full(ffi::poppler_document_get_modification_date_time(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_document_get_n_attachments")]
    #[doc(alias = "get_n_attachments")]
    pub fn n_attachments(&self) -> u32 {
        unsafe { ffi::poppler_document_get_n_attachments(self.to_glib_none().0) }
    }

    #[doc(alias = "poppler_document_get_n_pages")]
    #[doc(alias = "get_n_pages")]
    pub fn n_pages(&self) -> i32 {
        unsafe { ffi::poppler_document_get_n_pages(self.to_glib_none().0) }
    }

    #[cfg(feature = "v21_12")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v21_12")))]
    #[doc(alias = "poppler_document_get_n_signatures")]
    #[doc(alias = "get_n_signatures")]
    pub fn n_signatures(&self) -> i32 {
        unsafe { ffi::poppler_document_get_n_signatures(self.to_glib_none().0) }
    }

    #[doc(alias = "poppler_document_get_page")]
    #[doc(alias = "get_page")]
    pub fn page(&self, index: i32) -> Option<Page> {
        unsafe { from_glib_full(ffi::poppler_document_get_page(self.to_glib_none().0, index)) }
    }

    #[doc(alias = "poppler_document_get_page_by_label")]
    #[doc(alias = "get_page_by_label")]
    pub fn page_by_label(&self, label: &str) -> Option<Page> {
        unsafe {
            from_glib_full(ffi::poppler_document_get_page_by_label(
                self.to_glib_none().0,
                label.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_document_get_page_layout")]
    #[doc(alias = "get_page_layout")]
    #[doc(alias = "page-layout")]
    pub fn page_layout(&self) -> PageLayout {
        unsafe { from_glib(ffi::poppler_document_get_page_layout(self.to_glib_none().0)) }
    }

    #[doc(alias = "poppler_document_get_page_mode")]
    #[doc(alias = "get_page_mode")]
    #[doc(alias = "page-mode")]
    pub fn page_mode(&self) -> PageMode {
        unsafe { from_glib(ffi::poppler_document_get_page_mode(self.to_glib_none().0)) }
    }

    #[doc(alias = "poppler_document_get_pdf_conformance")]
    #[doc(alias = "get_pdf_conformance")]
    pub fn pdf_conformance(&self) -> PDFConformance {
        unsafe {
            from_glib(ffi::poppler_document_get_pdf_conformance(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_document_get_pdf_part")]
    #[doc(alias = "get_pdf_part")]
    pub fn pdf_part(&self) -> PDFPart {
        unsafe { from_glib(ffi::poppler_document_get_pdf_part(self.to_glib_none().0)) }
    }

    #[doc(alias = "poppler_document_get_pdf_subtype")]
    #[doc(alias = "get_pdf_subtype")]
    pub fn pdf_subtype(&self) -> PDFSubtype {
        unsafe { from_glib(ffi::poppler_document_get_pdf_subtype(self.to_glib_none().0)) }
    }

    #[doc(alias = "poppler_document_get_pdf_subtype_string")]
    #[doc(alias = "get_pdf_subtype_string")]
    pub fn pdf_subtype_string(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::poppler_document_get_pdf_subtype_string(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_document_get_pdf_version")]
    #[doc(alias = "get_pdf_version")]
    pub fn pdf_version(&self) -> (u32, u32) {
        unsafe {
            let mut major_version = std::mem::MaybeUninit::uninit();
            let mut minor_version = std::mem::MaybeUninit::uninit();
            ffi::poppler_document_get_pdf_version(
                self.to_glib_none().0,
                major_version.as_mut_ptr(),
                minor_version.as_mut_ptr(),
            );
            (major_version.assume_init(), minor_version.assume_init())
        }
    }

    #[doc(alias = "poppler_document_get_pdf_version_string")]
    #[doc(alias = "get_pdf_version_string")]
    pub fn pdf_version_string(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::poppler_document_get_pdf_version_string(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_document_get_permissions")]
    #[doc(alias = "get_permissions")]
    pub fn permissions(&self) -> Permissions {
        unsafe { from_glib(ffi::poppler_document_get_permissions(self.to_glib_none().0)) }
    }

    #[cfg(feature = "v0_80")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v0_80")))]
    #[doc(alias = "poppler_document_get_print_duplex")]
    #[doc(alias = "get_print_duplex")]
    #[doc(alias = "print-duplex")]
    pub fn print_duplex(&self) -> PrintDuplex {
        unsafe {
            from_glib(ffi::poppler_document_get_print_duplex(
                self.to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v0_80")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v0_80")))]
    #[doc(alias = "poppler_document_get_print_n_copies")]
    #[doc(alias = "get_print_n_copies")]
    #[doc(alias = "print-n-copies")]
    pub fn print_n_copies(&self) -> i32 {
        unsafe { ffi::poppler_document_get_print_n_copies(self.to_glib_none().0) }
    }

    #[cfg(feature = "v0_73")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v0_73")))]
    #[doc(alias = "poppler_document_get_print_scaling")]
    #[doc(alias = "get_print_scaling")]
    #[doc(alias = "print-scaling")]
    pub fn print_scaling(&self) -> PrintScaling {
        unsafe {
            from_glib(ffi::poppler_document_get_print_scaling(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_document_get_producer")]
    #[doc(alias = "get_producer")]
    pub fn producer(&self) -> Option<glib::GString> {
        unsafe { from_glib_full(ffi::poppler_document_get_producer(self.to_glib_none().0)) }
    }

    #[cfg(feature = "v22_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v22_2")))]
    #[doc(alias = "poppler_document_get_signature_fields")]
    #[doc(alias = "get_signature_fields")]
    pub fn signature_fields(&self) -> Vec<FormField> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::poppler_document_get_signature_fields(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_document_get_subject")]
    #[doc(alias = "get_subject")]
    pub fn subject(&self) -> Option<glib::GString> {
        unsafe { from_glib_full(ffi::poppler_document_get_subject(self.to_glib_none().0)) }
    }

    #[doc(alias = "poppler_document_get_title")]
    #[doc(alias = "get_title")]
    pub fn title(&self) -> Option<glib::GString> {
        unsafe { from_glib_full(ffi::poppler_document_get_title(self.to_glib_none().0)) }
    }

    #[doc(alias = "poppler_document_has_attachments")]
    pub fn has_attachments(&self) -> bool {
        unsafe { from_glib(ffi::poppler_document_has_attachments(self.to_glib_none().0)) }
    }

    #[cfg(feature = "v0_90")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v0_90")))]
    #[doc(alias = "poppler_document_has_javascript")]
    pub fn has_javascript(&self) -> bool {
        unsafe { from_glib(ffi::poppler_document_has_javascript(self.to_glib_none().0)) }
    }

    #[doc(alias = "poppler_document_is_linearized")]
    #[doc(alias = "linearized")]
    pub fn is_linearized(&self) -> bool {
        unsafe { from_glib(ffi::poppler_document_is_linearized(self.to_glib_none().0)) }
    }

    #[cfg(feature = "v0_90")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v0_90")))]
    #[doc(alias = "poppler_document_reset_form")]
    pub fn reset_form(&self, fields: &[&str], exclude_fields: bool) {
        unsafe {
            ffi::poppler_document_reset_form(
                self.to_glib_none().0,
                fields.to_glib_none().0,
                exclude_fields.into_glib(),
            );
        }
    }

    #[doc(alias = "poppler_document_save")]
    pub fn save(&self, uri: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok =
                ffi::poppler_document_save(self.to_glib_none().0, uri.to_glib_none().0, &mut error);
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "poppler_document_save_a_copy")]
    pub fn save_a_copy(&self, uri: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::poppler_document_save_a_copy(
                self.to_glib_none().0,
                uri.to_glib_none().0,
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[cfg(target_os = "linux")]
    #[cfg_attr(docsrs, doc(cfg(target_os = "linux")))]
    #[cfg(feature = "v21_12")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v21_12")))]
    #[doc(alias = "poppler_document_save_to_fd")]
    pub fn save_to_fd(&self, fd: i32, include_changes: bool) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::poppler_document_save_to_fd(
                self.to_glib_none().0,
                fd,
                include_changes.into_glib(),
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "poppler_document_set_author")]
    #[doc(alias = "author")]
    pub fn set_author(&self, author: &str) {
        unsafe {
            ffi::poppler_document_set_author(self.to_glib_none().0, author.to_glib_none().0);
        }
    }

    #[doc(alias = "poppler_document_set_creation_date")]
    #[doc(alias = "creation-date")]
    pub fn set_creation_date(&self, creation_date: libc::time_t) {
        unsafe {
            ffi::poppler_document_set_creation_date(self.to_glib_none().0, creation_date);
        }
    }

    #[cfg(feature = "v20_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v20_9")))]
    #[doc(alias = "poppler_document_set_creation_date_time")]
    pub fn set_creation_date_time(&self, creation_datetime: Option<&glib::DateTime>) {
        unsafe {
            ffi::poppler_document_set_creation_date_time(
                self.to_glib_none().0,
                creation_datetime.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "poppler_document_set_creator")]
    #[doc(alias = "creator")]
    pub fn set_creator(&self, creator: &str) {
        unsafe {
            ffi::poppler_document_set_creator(self.to_glib_none().0, creator.to_glib_none().0);
        }
    }

    #[doc(alias = "poppler_document_set_keywords")]
    #[doc(alias = "keywords")]
    pub fn set_keywords(&self, keywords: &str) {
        unsafe {
            ffi::poppler_document_set_keywords(self.to_glib_none().0, keywords.to_glib_none().0);
        }
    }

    #[doc(alias = "poppler_document_set_modification_date")]
    pub fn set_modification_date(&self, modification_date: libc::time_t) {
        unsafe {
            ffi::poppler_document_set_modification_date(self.to_glib_none().0, modification_date);
        }
    }

    #[cfg(feature = "v20_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v20_9")))]
    #[doc(alias = "poppler_document_set_modification_date_time")]
    pub fn set_modification_date_time(&self, modification_datetime: Option<&glib::DateTime>) {
        unsafe {
            ffi::poppler_document_set_modification_date_time(
                self.to_glib_none().0,
                modification_datetime.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "poppler_document_set_producer")]
    #[doc(alias = "producer")]
    pub fn set_producer(&self, producer: &str) {
        unsafe {
            ffi::poppler_document_set_producer(self.to_glib_none().0, producer.to_glib_none().0);
        }
    }

    #[doc(alias = "poppler_document_set_subject")]
    #[doc(alias = "subject")]
    pub fn set_subject(&self, subject: &str) {
        unsafe {
            ffi::poppler_document_set_subject(self.to_glib_none().0, subject.to_glib_none().0);
        }
    }

    #[doc(alias = "poppler_document_set_title")]
    #[doc(alias = "title")]
    pub fn set_title(&self, title: &str) {
        unsafe {
            ffi::poppler_document_set_title(self.to_glib_none().0, title.to_glib_none().0);
        }
    }

    #[cfg(feature = "v23_7")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v23_7")))]
    #[doc(alias = "poppler_document_sign")]
    pub fn sign<P: FnOnce(Result<(), glib::Error>) + 'static>(
        &self,
        signing_data: &SigningData,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn sign_trampoline<P: FnOnce(Result<(), glib::Error>) + 'static>(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = std::ptr::null_mut();
            ffi::poppler_document_sign_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = sign_trampoline::<P>;
        unsafe {
            ffi::poppler_document_sign(
                self.to_glib_none().0,
                signing_data.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    #[cfg(feature = "v23_7")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v23_7")))]
    pub fn sign_future(
        &self,
        signing_data: &SigningData,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        let signing_data = signing_data.clone();
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.sign(&signing_data, Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }

    #[cfg(feature = "v20_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v20_9")))]
    #[doc(alias = "creation-datetime")]
    pub fn creation_datetime(&self) -> Option<glib::DateTime> {
        ObjectExt::property(self, "creation-datetime")
    }

    #[cfg(feature = "v20_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v20_9")))]
    #[doc(alias = "creation-datetime")]
    pub fn set_creation_datetime(&self, creation_datetime: Option<&glib::DateTime>) {
        ObjectExt::set_property(self, "creation-datetime", creation_datetime)
    }

    pub fn format(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "format")
    }

    #[doc(alias = "format-major")]
    pub fn format_major(&self) -> u32 {
        ObjectExt::property(self, "format-major")
    }

    #[doc(alias = "format-minor")]
    pub fn format_minor(&self) -> u32 {
        ObjectExt::property(self, "format-minor")
    }

    #[cfg_attr(feature = "v20_9", deprecated = "Since 20.9")]
    #[doc(alias = "mod-date")]
    pub fn mod_date(&self) -> i32 {
        ObjectExt::property(self, "mod-date")
    }

    #[cfg_attr(feature = "v20_9", deprecated = "Since 20.9")]
    #[doc(alias = "mod-date")]
    pub fn set_mod_date(&self, mod_date: i32) {
        ObjectExt::set_property(self, "mod-date", mod_date)
    }

    #[cfg(feature = "v20_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v20_9")))]
    #[doc(alias = "mod-datetime")]
    pub fn mod_datetime(&self) -> Option<glib::DateTime> {
        ObjectExt::property(self, "mod-datetime")
    }

    #[cfg(feature = "v20_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v20_9")))]
    #[doc(alias = "mod-datetime")]
    pub fn set_mod_datetime(&self, mod_datetime: Option<&glib::DateTime>) {
        ObjectExt::set_property(self, "mod-datetime", mod_datetime)
    }

    pub fn subtype(&self) -> PDFSubtype {
        ObjectExt::property(self, "subtype")
    }

    #[doc(alias = "subtype-conformance")]
    pub fn subtype_conformance(&self) -> PDFConformance {
        ObjectExt::property(self, "subtype-conformance")
    }

    #[doc(alias = "subtype-part")]
    pub fn subtype_part(&self) -> PDFPart {
        ObjectExt::property(self, "subtype-part")
    }

    #[doc(alias = "subtype-string")]
    pub fn subtype_string(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "subtype-string")
    }

    #[doc(alias = "viewer-preferences")]
    pub fn viewer_preferences(&self) -> ViewerPreferences {
        ObjectExt::property(self, "viewer-preferences")
    }

    #[doc(alias = "author")]
    pub fn connect_author_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_author_trampoline<F: Fn(&Document) + 'static>(
            this: *mut ffi::PopplerDocument,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::author".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_author_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg_attr(feature = "v20_9", deprecated = "Since 20.9")]
    #[doc(alias = "creation-date")]
    pub fn connect_creation_date_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_creation_date_trampoline<F: Fn(&Document) + 'static>(
            this: *mut ffi::PopplerDocument,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::creation-date".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_creation_date_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v20_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v20_9")))]
    #[doc(alias = "creation-datetime")]
    pub fn connect_creation_datetime_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_creation_datetime_trampoline<F: Fn(&Document) + 'static>(
            this: *mut ffi::PopplerDocument,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::creation-datetime".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_creation_datetime_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "creator")]
    pub fn connect_creator_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_creator_trampoline<F: Fn(&Document) + 'static>(
            this: *mut ffi::PopplerDocument,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::creator".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_creator_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "format")]
    pub fn connect_format_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_format_trampoline<F: Fn(&Document) + 'static>(
            this: *mut ffi::PopplerDocument,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::format".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_format_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "format-major")]
    pub fn connect_format_major_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_format_major_trampoline<F: Fn(&Document) + 'static>(
            this: *mut ffi::PopplerDocument,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::format-major".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_format_major_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "format-minor")]
    pub fn connect_format_minor_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_format_minor_trampoline<F: Fn(&Document) + 'static>(
            this: *mut ffi::PopplerDocument,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::format-minor".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_format_minor_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "keywords")]
    pub fn connect_keywords_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_keywords_trampoline<F: Fn(&Document) + 'static>(
            this: *mut ffi::PopplerDocument,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::keywords".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_keywords_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "linearized")]
    pub fn connect_linearized_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_linearized_trampoline<F: Fn(&Document) + 'static>(
            this: *mut ffi::PopplerDocument,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::linearized".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_linearized_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "metadata")]
    pub fn connect_metadata_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_metadata_trampoline<F: Fn(&Document) + 'static>(
            this: *mut ffi::PopplerDocument,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::metadata".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_metadata_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg_attr(feature = "v20_9", deprecated = "Since 20.9")]
    #[doc(alias = "mod-date")]
    pub fn connect_mod_date_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_mod_date_trampoline<F: Fn(&Document) + 'static>(
            this: *mut ffi::PopplerDocument,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::mod-date".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_mod_date_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v20_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v20_9")))]
    #[doc(alias = "mod-datetime")]
    pub fn connect_mod_datetime_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_mod_datetime_trampoline<F: Fn(&Document) + 'static>(
            this: *mut ffi::PopplerDocument,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::mod-datetime".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_mod_datetime_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "page-layout")]
    pub fn connect_page_layout_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_page_layout_trampoline<F: Fn(&Document) + 'static>(
            this: *mut ffi::PopplerDocument,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::page-layout".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_page_layout_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "page-mode")]
    pub fn connect_page_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_page_mode_trampoline<F: Fn(&Document) + 'static>(
            this: *mut ffi::PopplerDocument,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::page-mode".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_page_mode_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "permissions")]
    pub fn connect_permissions_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_permissions_trampoline<F: Fn(&Document) + 'static>(
            this: *mut ffi::PopplerDocument,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::permissions".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_permissions_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v0_80")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v0_80")))]
    #[doc(alias = "print-duplex")]
    pub fn connect_print_duplex_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_print_duplex_trampoline<F: Fn(&Document) + 'static>(
            this: *mut ffi::PopplerDocument,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::print-duplex".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_print_duplex_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v0_80")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v0_80")))]
    #[doc(alias = "print-n-copies")]
    pub fn connect_print_n_copies_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_print_n_copies_trampoline<F: Fn(&Document) + 'static>(
            this: *mut ffi::PopplerDocument,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::print-n-copies".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_print_n_copies_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v0_73")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v0_73")))]
    #[doc(alias = "print-scaling")]
    pub fn connect_print_scaling_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_print_scaling_trampoline<F: Fn(&Document) + 'static>(
            this: *mut ffi::PopplerDocument,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::print-scaling".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_print_scaling_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "producer")]
    pub fn connect_producer_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_producer_trampoline<F: Fn(&Document) + 'static>(
            this: *mut ffi::PopplerDocument,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::producer".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_producer_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "subject")]
    pub fn connect_subject_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_subject_trampoline<F: Fn(&Document) + 'static>(
            this: *mut ffi::PopplerDocument,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::subject".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_subject_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "subtype")]
    pub fn connect_subtype_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_subtype_trampoline<F: Fn(&Document) + 'static>(
            this: *mut ffi::PopplerDocument,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::subtype".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_subtype_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "subtype-conformance")]
    pub fn connect_subtype_conformance_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_subtype_conformance_trampoline<F: Fn(&Document) + 'static>(
            this: *mut ffi::PopplerDocument,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::subtype-conformance".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_subtype_conformance_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "subtype-part")]
    pub fn connect_subtype_part_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_subtype_part_trampoline<F: Fn(&Document) + 'static>(
            this: *mut ffi::PopplerDocument,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::subtype-part".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_subtype_part_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "subtype-string")]
    pub fn connect_subtype_string_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_subtype_string_trampoline<F: Fn(&Document) + 'static>(
            this: *mut ffi::PopplerDocument,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::subtype-string".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_subtype_string_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "title")]
    pub fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_title_trampoline<F: Fn(&Document) + 'static>(
            this: *mut ffi::PopplerDocument,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::title".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_title_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "viewer-preferences")]
    pub fn connect_viewer_preferences_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_viewer_preferences_trampoline<F: Fn(&Document) + 'static>(
            this: *mut ffi::PopplerDocument,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::viewer-preferences".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_viewer_preferences_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Document`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct DocumentBuilder {
    builder: glib::object::ObjectBuilder<'static, Document>,
}

impl DocumentBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn author(self, author: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("author", author.into()),
        }
    }

    #[cfg_attr(feature = "v20_9", deprecated = "Since 20.9")]
    pub fn creation_date(self, creation_date: i32) -> Self {
        Self {
            builder: self.builder.property("creation-date", creation_date),
        }
    }

    #[cfg(feature = "v20_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v20_9")))]
    pub fn creation_datetime(self, creation_datetime: &glib::DateTime) -> Self {
        Self {
            builder: self
                .builder
                .property("creation-datetime", creation_datetime.clone()),
        }
    }

    pub fn creator(self, creator: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("creator", creator.into()),
        }
    }

    pub fn keywords(self, keywords: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("keywords", keywords.into()),
        }
    }

    #[cfg_attr(feature = "v20_9", deprecated = "Since 20.9")]
    pub fn mod_date(self, mod_date: i32) -> Self {
        Self {
            builder: self.builder.property("mod-date", mod_date),
        }
    }

    #[cfg(feature = "v20_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v20_9")))]
    pub fn mod_datetime(self, mod_datetime: &glib::DateTime) -> Self {
        Self {
            builder: self.builder.property("mod-datetime", mod_datetime.clone()),
        }
    }

    pub fn producer(self, producer: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("producer", producer.into()),
        }
    }

    pub fn subject(self, subject: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("subject", subject.into()),
        }
    }

    pub fn title(self, title: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("title", title.into()),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Document`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Document {
        self.builder.build()
    }
}
