/*
 * Decompiled with CFR 0.152.
 */
package adql.query;

import adql.parser.grammar.Token;

public class TextPosition {
    public final int beginLine;
    public final int beginColumn;
    public final int endLine;
    public final int endColumn;

    public TextPosition() {
        this.endColumn = -1;
        this.endLine = -1;
        this.beginColumn = -1;
        this.beginLine = -1;
    }

    public TextPosition(int line, int column) {
        this.beginLine = line < 0 ? -1 : line;
        this.beginColumn = column < 0 ? -1 : column;
        this.endColumn = -1;
        this.endLine = -1;
    }

    public TextPosition(int beginLine, int beginColumn, int endLine, int endColumn) {
        this.beginLine = beginLine < 0 ? -1 : beginLine;
        this.beginColumn = beginColumn < 0 ? -1 : beginColumn;
        this.endLine = endLine < 0 ? -1 : endLine;
        this.endColumn = endColumn < 0 ? -1 : endColumn;
    }

    public TextPosition(Token token) {
        this(token.beginLine, token.beginColumn, token.endLine, token.endColumn < 0 ? -1 : token.endColumn + 1);
    }

    public TextPosition(Token beginToken, Token endToken) {
        this(beginToken.beginLine, beginToken.beginColumn, endToken.endLine, endToken.endColumn < 0 ? -1 : endToken.endColumn + 1);
    }

    public TextPosition(TextPosition positionToCopy) {
        this(positionToCopy.beginLine, positionToCopy.beginColumn, positionToCopy.endLine, positionToCopy.endColumn);
    }

    public TextPosition(TextPosition startPos, TextPosition endPos) {
        this(startPos.beginLine, startPos.beginColumn, endPos.endLine, endPos.endColumn);
    }

    public String toString() {
        if (this.beginLine == -1 && this.beginColumn == -1) {
            return "[l.? c.?]";
        }
        if (this.endLine == -1 && this.endColumn == -1) {
            return "[l." + this.beginLine + " c." + this.beginColumn + "]";
        }
        return "[l." + this.beginLine + " c." + this.beginColumn + " - l." + this.endLine + " c." + this.endColumn + "]";
    }
}

