---
myst:
  html_meta:
    keywords: LaTeX, composition, illustrations, images, capture d'écran, 
              screenshot, copie d'écran, faire une capture d'écran avec LaTeX
---

# Comment inclure une capture d'écran ?

LaTeX lui-même ne permet pas de réaliser une capture d'écran, mais vous pouvez
inclure n'importe quelle image au format PNG, JPEG ou PDF, y compris 
une capture réalisée au moyen d'un outil externe. La commande permettant 
l'inclusion, `\includegraphics` de l'extension <ctanpkg:graphicx>, est décrite
dans la question 
"[](/3_composition/illustrations/images/inclure_une_image)".


## Réaliser la capture d'écran

De nombreux outils permettent de réaliser ce genre de choses, que ce soit 
sous Linux/Unix, macOS ou Windows. La page Wikipedia traitant de la 
[capture d'écran](wpfr:Capture_d'écran) propose de nombreuses solutions. Nous
en citons ici quelques-unes. 


### Sous Linux

Sur certaines distributions Linux (Mint par exemple) ou avec l'environnement 
Gnome, la touche "Imp écran" en haut à droite du clavier permet de faire 
une copie d'écran au format PNG. Vous pouvez ensuite retravailler l'image 
avec vos logiciels préférés.

Une autre solution consiste à utiliser [The Gimp](wpfr:GIMP) 
(*GNU Image Manipulation Program*). C'est un logiciel de dessin très complet,
assez similaire à [Adobe Photoshop](wpfr:Adobe_Photoshop) (logiciel commercial,
non disponible pour Linux). Vous devriez pouvoir l'installer à partir 
des paquets de votre distribution Linux.

Pour réaliser la capture d'écran, allez dans le menu *Fichier* → *Créer* 
→ *Capture d'écran*. Vous pouvez ensuite choisir ce que vous voulez capturer
(tout l'écran, une seule fenêtre...), puis un délai (mettez 5 secondes 
pour un premier essai). Quand vous cliquerez sur OK, vous aurez alors 
5 secondes pour disposer vos fenêtres commes vous l'entendez, puis cliquer
sur ce que vous voulez capturer. L'image s'ouvre ensuite dans *Gimp*, 
où vous pourrez la retailler puis l'enregistrer dans un fichier. 
Il ne vous restera plus qu'à l'inclure dans votre document LaTeX 
avec `\includegraphics`.


### Sous macOS

Le système macOS permet de faire une capture du ou des écrans, ou bien 
de zones de l'écran, 
grâce à des [combinaisons de touches](https://support.apple.com/fr-fr/102646).
Ceci vous créera un ou plusieurs fichiers PNG sur votre bureau, 
correpondants aux captures demandées :

- "Shift + Command + 3" pour une capture complète du ou des écrans ;
- "Shift + Command + 4" pour une capture d'une zone de l'écran (à sélectionner
  à la souris) ;
- "Shift + Command + Espace + 4" pour une capture d'une fenêtre (à sélectionner
  à la souris).


### Sous Windows

La touche "Imp écran" en haut à droite du clavier permet de faire une copie 
de l'écran dans le presse-papier. Vous pouvez alors coller cette image 
dans un logiciel de dessin avec un simple "Ctrl + V".


## Format d'image à utiliser ?

Les images obtenues sont relativement petites, par rapport à une photographie 
en haute résolution (elles font la taille d'un écran...), mais elles montrent
généralement du texte et des traits fins, qui ne supportent pas une compression
avec perte de qualité. Préférez donc le format PNG au format JPG, 
si vous utilisez pdf(La)TeX ou Lua(La)TeX.

Si jamais vous utilisez LaTeX pour produire un fichier DVI, il ne faudra pas 
oublier d'exporter le résultat en PS (ou EPS) pour l'inclure dans un document
LaTeX. Vous pouvez éventuellement utiliser la commande `\DeclareGraphicsRule` 
pour effectuer une conversion à la volée, comme le propose la question
"[](/3_composition/illustrations/images/inclure_une_image)".


:::{sources}
- [Capture d'écran](wpfr:Capture_d'écran)
- [How to embed screenshots properly?](https://tex.stackexchange.com/q/4430),
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::