---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, pages, numéro de page, \thepage
---

# Pourquoi un numéro de page courante peut être faux en haut de page ?

Voici un exemple de ce qui semble être une anomalie : 
la phrase en gras en fin de texte fait apparaître un numéro de page courante incorrect 
(en utilisant la commande `\thepage{}` qui restitue normalement bien le numéro de page).

```
\documentclass[french]{book}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte

\begin{document}
\chapter{Un classique incontournable}
\lipsum[1-4]
\textbf{Dès lors, serions-nous arrivés en page \thepage{} ?}
\end{document}
```

Cette anomalie tient à des éléments profondément ancrés dans le fonctionnement 
de TeX lui-même : tout découle de l'effort de TeX pour générer 
le meilleur résultat possible.

Le numéro de page est stocké dans `\count0`. Les utilisateurs de LaTeX voient 
cela comme le compteur `page` et peuvent composer sa valeur en utilisant `\thepage`.

La valeur de `\count0` n'est mise à jour que lorsque TeX produit réellement une page. 
TeX n'essaye même de faire cela que lorsqu'il détecte un indice que ce pourrait être
une bonne chose à faire. Du point de vue de TeX, la fin d'un paragraphe constitue 
un bon moment pour envisager de produire une page. Il créera une page s'il dispose 
de plus de matière qu'il n'en faut pour en faire une, ceci pour s'assurer 
qu'il pourra toujours tester certaines optimisations. En conséquence, la valeur 
de `\count0` est presque toujours fausse dans le premier paragraphe d'une page 
(l'exception étant le cas où le numéro de page a été "forcé", soit en changeant 
sa valeur directement, soit en plaçant un saut de page là où TeX ne l'aurait 
pas nécessairement placé).

LaTeX fournit un moyen sûr de se référer au numéro de page, en utilisant 
les mécaniques de [références](../../renvois/start.md).

Il faut donc éviter d'écrire :

```{noedit}
Nous sommes sur la page \thepage{}.
```

et écrire plutôt  :

```{noedit}
Nous sommes sur la page \pageref{ici}\label{ici}.
```

Voici ce que cela donne pour notre exemple :

```
\documentclass[french]{book}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte

\begin{document}
\chapter{Un classique incontournable}
\lipsum[1-4]
\textbf{Dès lors, serions-nous arrivés en page 
\pageref{ici}\label{ici} ? Oui !}
\end{document}
```

Il ne faut pas ici d'espace entre les commandes `\pageref` et `\label` : 
cet espace pourrait sinon potentiellement finir comme un espace de saut de page... 
ce qui va plutôt à l'encontre de l'objectif recherché.


:::{sources}
[Page number is wrong at start of page](faquk:FAQ-wrongpn)
:::