---
myst:
  substitutions:
    directive: "{term}`directive <Directive>`"
    dek: "Donald Ervin Knuth"
---
# Syntaxe détaillée des fichiers sources de la FAQ

```{warning}
La présente page est très détaillée. Il en existe une [version résumée](antiseche).
```

<!-- ::::{danger} -->
<!-- La présente page est un travail en cours ! -->
<!--  -->
<!-- :::{todo} -->
<!-- Reste (liste probablement pas exhaustive) : -->
<!--  -->
<!-- - unification du discours : parfois adressé au lecteur (p. ex. "vous pouvez -->
<!--   ..."), parfois impersonnel (p. ex. "on peut ...). -->
<!-- ::: -->
<!--  -->
<!-- :::: -->

:::{note}
Les fichiers sources de la présente FAQ sont au format
[Markdown](https://commonmark.org/help/).

Markdown est un langage de balisage léger dont le but est d'offrir une syntaxe
aussi facile à lire et à écrire que possible, à la manière des courriers
électroniques écrits en mode texte.
:::

Cette page explique la syntaxe Markdown utilisée dans les pages de la présente
FAQ. Lorsque cette syntaxe n'appelle pas de commentaires particuliers, elle est
seulement illustrée par des exemples constitués de code Markdown suivi du
résultat que l'on obtient sur le présent site de la FAQ.

<!-- Regardez simplement le -->
<!-- code source de cette page en cliquant sur le bouton *Modifier cette -->
<!-- page*. Si vous souhaitez essayer quelque chose, rendez-vous dans la page -->
<!-- du [bac à sable](file:///playground/playground). Les balises les plus -->
<!-- simples sont également facilement accessibles depuis la [barre -->
<!-- d'outils](file:///fr/toolbar). -->

<!-- [Fiche résumée de la syntaxe.](file:///wiki/antiseche) -->

::::{important}
En réalité, c’est une version enrichie de Markdown,
[MyST-Parser](https://mystmd.org), qui est utilisée ici. Elle fournit de très
nombreuses fonctionnalités, notablement similaires à celles de LaTeX. Aussi
accompagnons-nous, lorsqu'il y a lieu et que c'est pertinent, les codes Markdown
de leurs équivalents LaTeX.

:::{danger}
Même si c'est un but que GUTenberg s'est fixé, les fichiers sources de la FAQ ne
sont pas encore en LaTeX !
:::
::::

## Mise en forme de texte basique

::::{tab-set}

:::{tab-item} Markdown
```{example}
Markdown accepte les textes en **gras**, *italique* et `à chasse fixe`.
Bien sûr, il est possible de tous les ***`combiner`***.
```
:::

:::{tab-item} LaTeX
```{noedit}
Markdown accepte les textes en \textbf{gras}, \textbf{italique}, et
\texttt{à chasse fixe}. Bien sûr, il est possible de tous les
\textbf{\textit{\texttt{combiner}}}.
```
:::
::::

::::{tab-set}

:::{tab-item} Markdown
```{example}
Il est possible d'utiliser des {sub}`indices` et {sup}`exposants`.
```
:::

:::{tab-item} LaTeX
```{noedit}
Il est possible d'utiliser des \textsubscript{indices} et
\textsuperscript{exposants}.
```
:::
::::

::::{tab-set}

:::{tab-item} Markdown
```{example}
De plus, un passage peut être marqué comme ~~supprimé~~.
```
:::

:::{tab-item} LaTeX
```{noedit}
\documentclass{article}
\usepackage[T1]{fontenc}
\usepackage{lmodern}
\usepackage{ulem}
\begin{document}
De plus, un passage peut être marqué comme \sout{supprimé}.
\end{document}
```
:::
::::

::::{tab-set}

:::{tab-item} Markdown
```{example}
Les paragraphes sont créés à partir des lignes vides.

Comme cela.
```
:::

:::{tab-item} LaTeX
```{noedit}
Les paragraphes sont créés à partir des lignes vides.

Comme cela.
```
:::
::::

## Listes

Avec Markdown, il y a, comme avec LaTeX, trois types de listes : les listes non
ordonnées et ordonnées (environnements LaTeX `itemize` et `enumerate`), et les
listes de description (environnement LaTeX `description`).

### Listes non ordonnées et ordonnées

Pour les listes :

:non ordonnées: commencez une ligne par un `-` ou par un `*` ;
:ordonnées: commencez une ligne par un `1.` (les numéros suivants pouvant être
n'importe lesquels).

Ces listes peuvent être imbriquées en utilisant deux espaces au début de la ligne.

::::{tab-set}

:::{tab-item} Markdown
```{example}
Voici une liste :

- Un premier élément.
- Un deuxième élément.
  - Un premier sous-élément.
- Un troisième élément.

La même liste, mais ordonnée :

1. Le premier élément.
2. Le deuxième élément.
   1. Un premier sous-élément.
3. Un troisième élément.
```
:::

:::{tab-item} LaTeX
```{noedit}
Voici une liste :

\begin{itemize}
\item Un premier élément.
\item Un deuxième élément.
  \begin{itemize}
  \item Un premier sous-élément.
  \end{itemize}
\item Un troisième élément.
\end{itemize}

La même liste, mais ordonnée :

\begin{enumerate}
\item Un premier élément.
\item Un deuxième élément.
  \begin{itemize}
  \item Un premier sous-élément.
  \end{itemize}
\item Un troisième élément.
\end{enumerate}
```
:::
::::

### Listes de description

La « saveur » de Markdown utilisée sur ce site ([MyST-Parser (Markedly
Structured Text)](https://myst-parser.readthedocs.io/en/latest/index.html))
permet aussi de créer l'équivalent des listes de description sous LaTeX
(appelées « listes de champs »). Elles s'obtiennent en plaçant le « label »
entre paire de `:` et en faisant suivre sur la même ligne la description du
« label ».

::::{tab-set}

:::{tab-item} Markdown
```{example}

:Label:
:Label: Description
:*Syntaxe imbriquée*: Le label et sa description peuvent tous deux contenir une
**syntaxe imbriquée**.
:Paragraphes: Le marqueur de champ pouvant être très long, la deuxième ligne et
les lignes suivantes d'un paragraphe n'ont pas besoin d'être alignées.
:Blocs:

  Outre les paragraphes, toutes les syntaxes de blocs peuvent être utilisées
  dans le corps d'un champ :

  Voici une liste :

  - Le premier élément.
  - Le second élément.
    - Il peut y  avoir plusieurs niveaux.
  - Un autre élément.
```
:::

:::{tab-item} LaTeX
```{noedit}
\begin{description}
\item[Label :]
\item[Label :] Description
\item[\textit{Syntaxe imbriquée} :] Le label et sa description peuvent tous deux
  contenir une \textbf{syntaxe imbriquée}.
\item[Paragraphes :] Le marqueur de champ pouvant être très long, la deuxième
  ligne et les lignes suivantes d'un paragraphe n'ont pas besoin d'être
  alignées.
\item[Blocs :]

  Outre les paragraphes, toutes les syntaxes de blocs peuvent être utilisées
  dans le corps d'un champ :

  Voici une liste :

  \begin{itemize}
  \item Le premier élément.
  \item Le second élément.
    \begin{itemize}
    \item Il peut y  avoir plusieurs niveaux.
    \end{itemize}
  \item Un autre élément.
  \end{itemize}
\end{description}
```
:::
::::

:::{danger}
Les listes de description sont à employer avec précaution : lorsqu'un label ou
sa description comportent un texte *long* et *ne pouvant être coupé* (tel un chemin de
fichier), la mise en page sur téléphone ou tablette (mise en page
[*responsive*](wp:Responsive_web_design)) peut être très sous-optimale. Dans de
pareils cas, il est conseillé de plutôt recourir à des « listes de définition »
(ainsi que nous l'avons fait à la rubrique <project:#liens-automatiques>). Ce
type de listes est présenté maintenant.
:::

### Listes de définition

Il est possible de *définir* des termes, en utilisant la syntaxe :

:::{example}
Terme 1
: Définition

Terme 2
: Définition plus longue

  Avec plusieurs paragraphes

  - Et des items de listes
:::

<!-- Vous pouvez également ajouter une « classe » `glossary` à une liste de -->
<!-- définitions, qui vous permettra de référencer des termes dans votre texte en -->
<!-- utilisant le « rôle » `term` : -->
<!--  -->
<!-- :::{example} -->
<!-- {.glossary} -->
<!-- terme -->
<!-- : Définition du terme -->
<!--  -->
<!-- {term}`terme` -->
<!-- ::: -->


## Structuration

### Rubriques

La syntaxe Markdown stipule les rubriques (les `\section`s en LaTeX) en faisant précéder
leurs titres de suites de caractères `#`. Il est possible d'utiliser jusqu'à
6 niveaux de rubriques afin de **structurer** le contenu.

::::{tab-set}

:::{tab-item} Markdown
```md
# Titre de niveau 1
Du texte.

## Titre de niveau 2
Essai.
```
:::

:::{tab-item} LaTeX
```{noedit}
\section{Titre de niveau 1}
Du texte.

\subsection{Titre de niveau 2}
Essai.
```
:::
::::

### Coupures thématiques

```{raw} latex
\def\faqGUTtransition{\bigskip\hrule\bigskip}
```

::::{tab-set}

:::{tab-item} Markdown
```{example}
Il est possible de créer une coupure thématique en insérant sur une ligne au moins
trois caractères `*`, `-` ou `_` consécutifs.

***

Et maintenant, on passe à autre chose.
```
:::

:::{tab-item} LaTeX
```{noedit}
Il est possible de créer une coupure thématique en insérant
sur une ligne la commande \verb|\bigskip\hrule\bigskip|.

\bigskip\hrule\bigskip

Et maintenant, on passe à autre chose.
```
:::
::::

```{raw} latex
\def\faqGUTtransition{\par}
```

::::{only} latex
:::{warning}

   Dans la version PDF de cette FAQ, pour des raisons techniques les coupures
   thématiques ont été configurées pour ne rien faire.  L'exemple ci-dessus
   est l'exception qui confirme la règle, juste pour montrer le comportement
   par défaut (y-compris pour le format de sortie PDF) dans d'autres documents
   utilisant le système de production [Sphinx][sphinx] à partir de sources
   [MyST-Parser][mystparser].

   [sphinx]: https://www.sphinx-doc.org
   [mystparser]: https://myst-parser.readthedocs.io/en/latest/

:::
::::

(syntaxe/blocs-de-code)=
## Blocs de code informatique

Les blocs de codes sources sont clôturés (avant et après) par une séquence d'au
moins trois caractères *backtick* (`` ` ``) ou tildes (`~`) consécutifs (les
*backticks* et les tildes ne pouvant être mélangés), comme suit :

:::::{tab-set}

::::{tab-item} Markdown
````text
```
Ceci est un bloc de code avec des caractères spéciaux :
- # ^ <-- > % *coucou*
```
````

:::{note}
Dans un contexte autre que la présente FAQ, le résultat devrait être le suivant :

```text
Ceci est un bloc de code avec des caractères spéciaux :
- # ^ <-- > % *coucou*
```
Mais voyons maintenant qu'il va en être autrement.
:::
::::

::::{tab-item} LaTeX
```{noedit}
\begin{verbatim}
Ceci est un bloc de code avec des caractères spéciaux :
- # ^ <-- > % *coucou*
\end{verbatim}
```
::::
:::::

### Mise en évidence de la syntaxe du code

Les blocs de code peuvent contenir ou pas un identifiant de `⟨langage⟩`, alors
figurant juste après le triplet ```` ``` ```` ouvrant, ainsi :

````text
```⟨langage⟩
⟨Code informatique en langage ⟨langage⟩⟩
```
````

#### Blocs de codes LaTeX

Dans la présente FAQ, le code sous-jacent des blocs de codes est par défaut
réputé être du code LaTeX. Donc, un bloc de code :

- soit *ne contenant pas* d'identifiant de `⟨langage⟩` ;
- soit *contenant* l'identifiant `acetex` (et non `latex`) ;

est réputé être en code LaTeX et est alors dans ce cas coloré syntaxiquement en
conséquence.

##### Compilables et éditables

Ces blocs de codes font bien plus que cela ! Ils sont :

- compilables en ligne, avec affichage du PDF généré (grâce au système
  [`latexcgi`](https://davidcarlisle.github.io/latexcgi/) conçu par David
  Carlisle) !
- éditables dans une fenêtre (grâce à l'éditeur de code
  [Ace](https://ace.c9.io/)).

Ainsi, le code suivant inséré dans un fichier source Markdown de la présente FAQ :

````text
```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc}
\usepackage{lmodern}
\usepackage[a4paper]{geometry}
\usepackage{babel}
\begin{document}
Test.
\end{document}
```
````

donnera :

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc}
\usepackage{lmodern}
\usepackage[a4paper]{geometry}
\usepackage{babel}
\begin{document}
Test.
\end{document}
```

Ce code peut être édité directement dans le navigateur Web et le PDF généré par (par
défaut) `pdflatex` peut être affiché par simple clic sur le bouton "Compiler et
afficher".

:::{note}
:name: erreur-compilation
En cas d'erreur de compilation, c'est le fichier `.log` de la compilation qui
est affiché.
:::

###### Paramètres de la compilation LaTeX (avec `latexcgi`)

:::{note}
La compilation des blocs de code LaTeX compilables est paramétrable.
:::

Moteur
: Comme nous venons de le dire, le moteur LaTeX utilisé par défaut est `pdflatex`
(sauf si le package `fontspec` est utilisé, auquel cas le moteur par défaut
utilisé est `xelatex`).

Pour recourir à un autre `⟨moteur⟩` (toujours avec le format LaTeX), il suffit
  d’écrire en commentaire au début de l’exemple :

  ```{noedit}
  %!TEX ⟨moteur⟩
  ```

  où `⟨moteur⟩` peut être `lualatex`, `xelatex`, `pdflatex`, etc. On peut aussi utiliser la syntaxe :

  ```{noedit}
  %!TEX engine=⟨moteur⟩
  ```

  L’exemple suivant illustre ceci avec `lualatex` comme moteur.

  ```
  %!TEX engine=lualatex
  \documentclass{article}
  \begin{document}
  $\pi=\directlua{tex.sprint(math.pi)}$
  \end{document}
  ```

Bibliographie
: Pour paramétrer le programme utilisé pour la bibliographie, on utilisera la clé
`bibcmd` qui peut prendre comme valeurs `biber`, `bibtex`, `pbibtex`, etc.

  ```{noedit}
  %!TEX bibcmd=bibtex
  ```

Retour
: Par défaut, le PDF issu de la compilation affiché sous le code l'est grâce à la
bibliothèque [`PDF.js`](https://mozilla.github.io/pdf.js/). Il est possible de spécifier
une autre sortie grâce à la clé `return` qui peut valoir :
  - `pdf` : indique que la sortie de la compilation est un PDF et laisse le
    navigateur web afficher le PDF (souvent par son moteur PDF interne) ;
  - `log` : indique que la sortie de la compilation à afficher est le fichier de
    `log`, et cela même si [la compilation se passe sans erreur](#erreur-compilation) ;

    ```
    %!TEX engine=lualatex
    %!TEX return=log
    \documentclass{article}
    \begin{document}
    $\pi=\directlua{tex.sprint(math.pi)}$
    \end{document}
    ```

  - `make4ht` : indique que la sortie de la compilation est le code `html` produit
    par `make4ht`;
  - `LaTeXML` : indique que la sortie de la compilation est le code `html`
    produit par le programme `LaTeXML` ;
  - `lwarp` : indique que le la sortie de la compilation est le code `html`
    produit par `lwarpmk`.

:::{seealso}
Pour tous les détails sur `latexcgi`, on consultera la page de référence :
https://davidcarlisle.github.io/latexcgi/.
:::

###### Blocs de codes incomplets compilables

::::{important} Il est même possible pour un bloc de code LaTeX de ne contenir
que l'extrait "intéressant" du corps du document : le système `latexcgi` va, de
façon heuristique, compléter cet extrait en un [exemple complet
minimal](/1_generalites/documentation/listes_de_discussion/comment_rediger_un_exemple_complet_minimal).
::::

Le système `latexcgi` va même, en examinant les commandes utilisées dans le corps, ajouter au
préambule le chargement des packages nécessaires, au moins pour certaines des
commandes fournies par les packages suivants :
- <ctanpkg:graphicx>
- <ctanpkg:amsmath> ;
- <ctanpkg:tikz> ;
- <ctanpkg:fancyhdr> ;
- <ctanpkg:pgfplots> ;
- <ctanpkg:hyperref> ;
- <ctanpkg:array> ;
- <ctanpkg:listings> ;
- <ctanpkg:blindtext> ;
- <ctanpkg:lipsum> ;
- <ctanpkg:xcolor> ;
- <ctanpkg:pstricks>.

````{example}
```
\color{red}%
Ce code ne contient pas de préambule, ni d'environnement \verb|document| mais
va néanmoins être compilé correctement avec même l'ajout du package
\verb|xcolor| permettant à la présente phrase d'être colorée en rouge.
```
````

:::{danger}
Cette fonctionnalité est fragile. Il est donc fortement conseillé de vérifier
que la compilation fonctionne et de, sinon, créer manuellement l'exemple complet
minimal *ad hoc*.
:::

##### Non compilables et non éditables

Comme nous venons de le voir, par défaut, les blocs de code LaTeX sont éditables
par les internautes directement dans leur navigateur et le résultat des
modifications peut être visualisé en direct. Il est toutefois parfois
nécessaire de présenter des blocs de code LaTeX n'ayant pas vocation à être
édités ou compilés. Dans ce cas, on recourrera à la {{directive}} `noedit`,
comme dans l'exemple suivant.

::::{tab-set}

:::{tab-item} Markdown
`````{example}
```{noedit}
\documentclass[french]{article}
```
`````
:::

:::{tab-item} LaTeX
````{noedit}
\documentclass{article}
\usepackage{minted}
\begin{document}
\begin{minted}{latex}
\documentclass[french]{article}
\end{minted}
\end{document}
````
:::
::::

La version PDF de cette FAQ externalise automatiquement les blocs de code
LaTeX, pour compilation séparée et inclusion du résultat, mais ne dispose pas
de la capacité de [`latexcgi`](https://davidcarlisle.github.io/latexcgi) à
compléter les fragments en des documents complets.  Tout bloc LaTeX comportant
un ``\documentclass`` est réputé compilable.  Il faut donc nécessairement,
comme ci-dessus, ajouter un ``{noedit}`` si tel n'est pas le cas.

#### Blocs de codes autres

Si un bloc de code *contient* un identifiant de `⟨langage⟩`, le code sous-jacent
est réputé être du code dans ce `⟨langage⟩`. Il est alors dans ce cas coloré
syntaxiquement en conséquence en utilisant un [*pygments
lexer*](https://pygments.org/docs/lexers/) disponible.

::::{tab-set}

:::{tab-item} Markdown
````{example}
```python
from a import b
c = "string"
```
````
:::

:::{tab-item} LaTeX
```{noedit}
\documentclass{article}
\usepackage{minted}
\begin{document}
\begin{minted}{python}
from a import b
c = "string"
\end{minted}
\end{document}
```
:::
::::

::::::{admonition} Contenu de fichiers `.log` et sortie du terminal
:class: tip

Dans la présente FAQ, il arrive d'avoir à faire figurer un extrait du fichier
`.log` ou de la sortie du terminal et, plus généralement, du code n'ayant pas de
langage sous-jacent. Pour cela, il suffit de recourir au "langage" `text` :

::::{tab-set}

:::{tab-item} Markdown
````{example}
```text
This is pdfTeX, Version 3.141592653-2.6-1.40.25 (TeX Live 2023) (preloaded format=pdflatex)
 restricted \write18 enabled.
**
```
````
:::

:::{tab-item} LaTeX
```{noedit}
\begin{verbatim}
This is pdfTeX, Version 3.141592653-2.6-1.40.25 (TeX Live 2023) (preloaded format=pdflatex)
 restricted \write18 enabled.
**
\end{verbatim}
```
:::

::::::

::::{admonition} Afficher des *backticks* à l'intérieur des blocs de code
:class: tip dropdown

Pour afficher des *backticks* à l'intérieur d'un code, il suffit de les
imbriquer dans un séquence de *backticks* d'une longueur supérieure.  Markdown
traitera les *backticks* les plus extérieurs comme les bords du bloc "brut" et
tout ce qui se trouve à l'intérieur sera affiché.  Par exemple :

:::{example}
`` `Coucou !` ``

````text
```
Coucou !
```
````
:::

::::

### Numérotation et mise en évidence des lignes

Il est possible d'appliquer la numérotation et la mise en évidence à un bloc
spécifique de code LaTeX non compilable et non éditable :

:::::{tab-set}

::::{tab-item} Markdown
:::{example}
```{noedit}
:emphasize-lines : 1,6
:lineno-start : 1

\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc}
\usepackage{lmodern}
\usepackage[a4paper]{geometry}
\usepackage{babel}
\begin{document}
Test.
\end{document}
```
:::
::::

::::{tab-item} LaTeX
````{noedit}
\documentclass{article}
\usepackage{minted}
\begin{document}
% Pas de solution simple de mise en évidence de ligne
% avec le package minted
\begin{minted}[linenos]{latex}
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc}
\usepackage{lmodern}
\usepackage[a4paper]{geometry}
\usepackage{babel}
\begin{document}
Test.
\end{document}
\end{minted}
\end{document}
````
::::
:::::

Le cas de blocs de codes autres que LaTeX est un peu moins simple mais deux
syntaxes sont possibles, la première étant la plus proche de celle ci-dessus :

:::{example}
```{code-block} python
:lineno-start: 10
:emphasize-lines: 1, 3

a = 1
b = 2
c = 3
```

{lineno-start=10 emphasize-lines="1,3"}
```python
a = 1
b = 2
c = 3
```
:::

### Légendes

Plusieurs options peuvent être ajoutées à un bloc de code, par exemple pour
lui ajouter une légende :

:::{example}
```{noedit}
:caption: Ceci est une légende
:emphasize-lines : 1,6
:lineno-start : 1

\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc}
\usepackage{lmodern}
\usepackage[a4paper]{geometry}
\usepackage{babel}
\begin{document}
Test.
\end{document}
```
:::

:::{admonition} Options des blocs de code
:class: hint dropdown

Les options suivantes sont reconnues :

`linenos` : ⟨drapeau⟩
: Affiche des numéros de ligne pour le bloc de code

`lineno-start` : ⟨entier⟩
: L’⟨entier⟩ de ligne de départ pour le bloc de code (`linenos` est alors automatiquement activé)

`emphasize-lines` : ⟨liste d'entiers séparés par des virgules⟩
: Surligne les lignes spécifiées

`caption` : ⟨légende⟩
: La ⟨légende⟩ du bloc de code

`force` : ⟨drapeau⟩
: Permet d'ignorer les erreurs mineures lors de la mise en évidence

`name` : ⟨chaîne de caractères⟩
: Le nom du bloc de code, qui peut être référencé ailleurs dans le document.

`class` : ⟨classe⟩
: La ⟨classe⟩ à appliquer au bloc de code
:::

(syntaxe/literalinclude)=
### Inclusion de code à partir de fichiers

Des morceaux de code plus longs peuvent être inclus à partir de fichiers en utilisant la {{directive}} `literalinclude` :

````{noedit}
```{literalinclude} /conf.py
```
````

Le nom de fichier est généralement relatif au chemin du fichier courant. Cependant, s'il est absolu (commençant par `/`), il est relatif au répertoire racine.

```{seealso}
La [documentation
Sphinx](https://www.sphinx-doc.org/en/master/usage/restructuredtext/directives.html#directive-literalinclude)
fournit la liste exhaustive des options de cette directive (mais selon la
syntaxe reStructuredText et non Markdown).
```

Par exemple, pour spécifier le langage sous-jacent et ne sélectionner qu'une
partie du fichier, les options `language`, `lines` (ou `start-at` et `end-at`)
peuvent être utilisées :

:::{example}
```{literalinclude} /conf.py
:language: python
:lines: 3-24
```
:::

## Extraits de code informatique

### Code brut

Le code informatique court (que ce soit du LaTeX ou autre) est intégré au texte
en l'entourant d'une paire de caractères *backtick* (`` ` ``), ainsi :

::::{tab-set}

:::{tab-item} Markdown
`````{example}
La commande `\title` permet d'intituler son document.
`````
:::

:::{tab-item} LaTeX
````{noedit}
\documentclass{article}
\begin{document}
La commande \verb`\title` permet d'intituler son document.
\end{document}
````
:::
::::

### Coloration syntaxique

Il est possible d'appliquer la coloration syntaxique au code en ligne :

::::{tab-set}

:::{tab-item} Markdown
```{example}
Code Python en ligne :
- pas coloré syntaxiquement : `a = "b"` ;
- coloré syntaxiquement : `a = "b"`{l=python}.
```
:::

:::{tab-item} LaTeX
```{noedit}
\documentclass{article}
\usepackage{minted}
\begin{document}
Code Python en ligne :
\begin{itemize}
\item pas coloré syntaxiquement : \verb`a = "b"` ;
\item coloré syntaxiquement : \mintinline{python}`a = "b"`.
\end{itemize}
\end{document}
```
:::
::::

<!-- :::{note} -->
<!-- Le code en ligne sans spécification est coloré syntaxiquement en LaTeX, -->
<!-- langage par défaut de la présente FAQ. -->
<!-- ```{example} -->
<!-- `\textbf{Coucou !}` -->
<!-- ``` -->
<!-- ::: -->
<!--  -->
<!-- `\textbf`{l=latex} -->

(elements-de-code-variables)=
## Éléments de code variables

Pour signifier que des éléments du code sont variables, il est d'usage de les
placer entre signes `⟨` et `⟩`, comme ici l'argument *titre*  de la commande `\title` :
`\title{⟨titre⟩}`. Ces caractères (unicodes `U+27E8` et `U+27E9`) peuvent être
obtenus :

- par des raccourcis différents selon les systèmes d'exploitation (pour macOS, voir
admonition "Attention" après le tableau) :

    | Système d'exploitation | Raccourci pour `⟨`                                                                                | Raccourci pour `⟩`                                                                                |
    |:-----------------------|:--------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------|
    | GNU/Linux              | {kbd}`Ctrl` + {kbd}`Shift` + {kbd}`u` puis {kbd}`2`{kbd}`7`{kbd}`e`{kbd}`8` puis {kbd}`espace` | {kbd}`Ctrl` + {kbd}`Shift` + {kbd}`u` puis {kbd}`2`{kbd}`7`{kbd}`e`{kbd}`9` puis {kbd}`espace` |
    | macOS                  | {kbd}`⌥` + {kbd}`2`{kbd}`7`{kbd}`e`{kbd}`8`                                   | {kbd}`⌥` + {kbd}`2`{kbd}`7`{kbd}`e`{kbd}`9`                                   |
    | Windows                | {kbd}`Alt` + {kbd}`1`{kbd}`0`{kbd}`2`{kbd}`1`{kbd}`6`                     | {kbd}`Alt` + {kbd}`1`{kbd}`0`{kbd}`2`{kbd}`1`{kbd}`7`                     |

    :::{attention}
    Dans le cas de macOS, pour que la combinaison ci-dessus fonctionne, il convient de choisir au préalable la méthode de saisie "Unicode" (voir [Méthode de saisie Unicode](saisieUnicode)).
    :::

- par copiés-collés depuis la présente page ;

- par modification logiciele de la disposition du clavier, en assignant `⟨` et `⟩` à des combinaisons de touches.

    ::::{admonition} Création d'une méthode de saisie personnalisée pour `⟨` et `⟩` sur macOS
    :class: tip dropdown

    Nous détaillons ici une méthode pour pouvoir saisir simplement les caractères 
    `⟨` et `⟩`, non accessibles par défaut sur le clavier.

    :::{important}
    Pour illustrer notre propos, nous nous basons sur un utilisateur de clavier **français**, 
    utilisant la méthode de saisie "**Français**".
    :::

    La première étape consiste, à l'aide du visualiseur de clavier (voir [Visualiseur de clavier](visualiseur-de-clavier)), à trouver
    deux combinaisons de caractères (produisant des caractères dont nous n'avons *a priori* 
    que faire dans le contexte de cette FAQ) que nous pourrions utilement modifier pour 
    produire les caractères `⟨` et `⟩`. 

    Nous allons plutôt en déléguer la tâche à un logiciel à interface graphique qui a 
    l'avantage d'être gratuit (et qui sera *open source* dans une prochaine version, selon la 
    page qui le présente) : [Ukelele](https://software.sil.org/ukelele/).

    Le manuel d'utilisation du logiciel *Ukelele* est complet, mais pas vraiment orienté
    envers l'utilisateur de base. Voici un guide qui se concentre sur l'essentiel.

    Une fois l'image disque au format `.dmg` téléchargée, double-cliquez sur le fichier et 
    procédez à l'installation du logiciel comme indiqué dans l'image disque montée : faites 
    glisser l'icone de l'application *Ukelele* sur l'alias du dossier "Applications". Copiez les deux dossiers "Resources" et "Documentation" sur le disque de votre 
    ordinateur. Fermez l'image disque montée et éjectez-là (virtuellement) avec l'icône ⏏︎ ou **Fichier ► Éjecter** dans le [Finder](wpfr:Finder).

    Créez (par exemple dans le dossier "Documents" de notre compte utilisateur) un 
    dossier que vous nommerez par exemple "Méthode de saisie".

    Lancez le logiciel "Ukelele". L'application affiche un clavier essentiellement vide 
    (exceptées les touches de modification, de tabulation, d'espace et les touches de fonction).
    Puisque nous ne cherchons à faire qu'une modification légère à la méthode de saisie 
    "Français" actuellement en vigueur, nous choisissez le menu
    **File ► New From Current Input Source**. Une nouvelle fenêtre devrait alors apparaître,
    listant une disposition de clavier 
    (*Keyboard layout* dans le logiciel non traduit) nommée "French copy". Double-cliquez sur 
    ce nom apparaissant dans la liste et un nouveau clavier virtuel titré "French copy" 
    apparaît à l'écran, cette fois avec toutes les touches comportant des caractères, et 
    reproduisant la disposition des touches de votre clavier physique. Appuyez sur la touche 
    {kbd}`⌥` et observez qu'à la place de `w` vous voyez `‹` sur le clavier virtuel. Ce 
    qui signifie qu'actuellement {kbd}`⌥` + {kbd}`w` produit `‹`.

    1. Copiez dans le presse-papier le caractère `⟨` (avec {kbd}`⌘` + {kbd}`c`).

        Laissez le doigt sur la touche {kbd}`⌥` et double-cliquez sur la touche virtuelle `‹` 
    (située sur la troisième touche à partir de la gauche en partant de la touche {kbd}`⇧`
    de gauche). Relâchez la touche {kbd}`⌥`. Dans le champ "Enter the new output string" 
    (entrez la nouvelle chaîne de sortie), remplacez le caractère `‹` par `⟨` en procédant à 
    un collage (avec {kbd}`⌘` + {kbd}`v`) puis cliquez sur "Done".

    2. Copiez dans le presse-papier le caractère `⟩` (avec {kbd}`⌘` + {kbd}`c`).

        Laissez le doigt sur les touches {kbd}`⌥` + {kbd}`⇧` et double-cliquez sur la 
    touche virtuelle `›` (située sur la troisième touche à partir de la gauche en partant de 
    la touche {kbd}`⇧` de gauche). Relâchez les touches {kbd}`⌥` + {kbd}`⇧`. Dans 
    le champ "Enter the new output string" (entrez la nouvelle chaîne de sortie), remplacez le
    caractère `›` par `⟩` en procédant à un collage (avec {kbd}`⌘` + {kbd}`v`) puis 
    cliquez sur "Done".

    3. Vérifiez que la nouvelle disposition de clavier est bien enregistrée dans le clavier 
    virtuel : repérez sur la clavier virtuel l'emplacement de la touche `w`. Alors en appuyant
    sur la touche physique {kbd}`⌥` vous devez voir `⟨` à cet emplacement, tandis qu'en 
    appuyant sur les touches physiques {kbd}`⌥` + {kbd}`⇧` vous devriez 
    voir `⟩` à cet  emplacement.

    Fermez la fenêtre affichant le clavier virtuel titré "French copy" et repassez dans la 
    fenêtre du logiciel Ukelele listant les dispositions de clavier (Keyboard Layouts). 
    Sélectionnez la ligne "French copy" et faites un clic droit (ou {kbd}`control` + clic)
    et choisissez "**Set Keyboard Name and Script…**". Remplacez le texte "French copy" par 
    quelque chose de plus explicite comme "Français (FAQGut)" pour rappeler que cette 
    disposition de clavier a été adaptée pour contribuer plus facilement à la FAQ. Laissez la 
    valeur de Script sur "Unicode", et cliquez sur "**OK**". Vous pourriez changer l'icône 
    associée, mais laissons cela de côté.

    En ayant la ligne "Français (FAQGut)" sélectionnée dans la fenêtre listant les 
    dispositions de clavier (*Keyboard Layouts*), allez dans le menu **File ► Save…** et dans
    la fenêtre qui s'affiche, choisissez pour File Format "Keyboard Layout Bundle", pour 
    l'emplacement le dossier "Méthode de saisie" créé précédemment dans le dossier "Documents" 
    (cliquez au besoin sur le bouton "**v**" pour naviguer), et pour le nom "Français 
    (FAQGut).bundle", puis validez avec le bouton "**Save**".

    Puis allez dans le menu **File ► Install ► Show Organizer**. Cliquez sur 
    "**Set Folder…**", 
    choisissez le dossier "Méthode de saisie" situé dans le dossier "Documents" et cliquez sur 
    "**Open**". Vous voyez alors dans la première colonne de la fenêtre (celle des éléments
    non installés) la disposition de clavier "Français (FAQGut)". Faites-là glisser dans la 
    troisième colonne, correspondant à une installation pour l'utilisateur courant. Une 
    fenêtre d'alerte affiche alors
    "***You should log out*** *After installing a keyboard layout, it is recommended that you log out and log in again, or restart your computer, before  activating the new keyboard layout.*" 
    (soit "**Vous devriez vous déconnecter.**
    Après avoir installé une disposition de clavier, il est recommandé de vous déconnecter et
    de vous reconnecter, ou de redémarrer votre ordinateur, avant d'activer la nouvelle 
    disposition de clavier."). Cliquez sur "**OK**". 

    :::{caution}
    La documentation de Ukelele indique qu'il ne serait pas nécessaire de se déconnecter de sa 
    session utilisateur à partir de macOS Yosemite (macOS 10.10), et effectivement ce fut le 
    cas lors d'un premier essai, mais lors d'un second essai, une déconnection puis une 
    reconnection à sa session utilisateur fut nécessaire pour la détection de la disposition 
    de clavier créée, nécessaire pour la finalisation de l'étape suivante.
    :::

    La dernière étape consiste à ajouter la nouvelle disposition de clavier aux méthodes de 
    saisie déjà employées. Pour cela, il faut ouvrir l'application Réglages Système 
    (anciennement Préférences Système), ce qui peut par exemple être fait à partir du menu 
    Pomme situé dans la barre des menus, puis aller dans la rubrique Clavier. La disposition 
    peut varier selon les versions de macOS, dans la version actuelle (Sequoia, ou macOS 15),
    allez dans la section *Entrée de texte* puis cliquez sur "**Modifier…**" en regard de 
    *Méthodes de saisie*. 
    Cliquez sur le bouton "**+**" au bas de la liste des méthodes de saisie 
    déjà sélectionnées. Si le mode d'emploi a été suivi à la lettre, vous trouverez, en regard 
    de la langue *Français*, la disposition de clavier nouvellement créée, 
    "Français (FAQGut)". 
    Sélectionnez-là et cliquez sur le bouton "**Ajouter**".

    Désormais, vous pourrez sélectionner la méthode de saisie "**Français (FAQGut)**" 
    dans le menu *saisie* de la barre des menus et contribuer efficacement à la présente FAQ 
    grâce à l'accès direct aux caractères `⟨` et `⟩` via respectivement les raccourcis 
    {kbd}`⌥` + {kbd}`w` et {kbd}`⌥` + {kbd}`⇧` + {kbd}`w`.
    ::::


(syntaxe/référencement)=
## Références croisées

Markdown et MyST-Parser offrent de puissantes fonctionnalités de références
croisées permettant d'établir des liens vers des [URL], des documents, des
rubriques, des figures, etc.

:::{attention}
Ne jamais utiliser la syntaxe générale pour les URLs vers des pages HTML
avec un nom de fichier en ``.html``
pour des références internes, car, en particulier, cela est incompatible avec
la sortie en PDF (sauf si l'on veut délibérement faire un hyperlien depuis le
PDF vers le site web de la présente FAQ en utilisant une URL complète).
:::

(syntaxe/cibles)=
### Cibles

(syntaxe/cibles-explicites)=
#### Cibles explicites
Les cibles sont utilisées pour définir des ancres personnalisées auxquelles il
est possible de faire référence ailleurs dans la FAQ. C'est l'équivalent de
`\label` en LaTeX.

Il existe trois façons principales de créer des cibles :

1. Annoter un bloc de syntaxe avec `(⟨identifiant⟩)=`.
2. Annoter un bloc syntaxique, un élément en ligne ou une « étendue » (« *span* »)
   avec un attribut `{#⟨identifiant⟩}`.
3. Ajouter l'option `:name: ⟨identifiant⟩` à une {{ directive }}, par exemple
   une [admonition](#admonitions).

:::::{tab-set}

::::{tab-item} Markdown
```markdown
(identifiant-rubrique)=
### Rubrique

{#identifiant-paragraphe}
Ceci est un paragraphe, avec un identifiant.

Ceci est une [« étendue » avec un identifiant]{#identifiant-etendue}.

- [Lien vers la rubrique](#identifiant-rubrique).
- [Lien vers le paragraphe](#identifiant-paragraphe).
- [Lien vers l’« étendue »](#identifiant-etendue).
```
::::

::::{tab-item} LaTeX
```{noedit}
\documentclass{article}
\usepackage[T1]{fontenc}
\usepackage{lmodern}
\usepackage{hyperref}
\begin{document}
  \hypertarget{identifiant-rubrique}{\section{Rubrique}}

  \hypertarget{identifiant-paragraphe}{}%
  Ceci est un paragraphe, avec un identifiant.

  Ceci est une \hypertarget{identifiant-etendue}{« étendue »
  avec un identifiant}.

  \begin{itemize}
  \item \hyperlink{identifiant-rubrique}{Lien vers la rubrique}.
  \item \hyperlink{identifiant-paragraphe}{Lien vers le paragraphe}.
  \item \hyperlink{identifiant-etendue}{Lien vers l’« étendue »}.
  \end{itemize}
\end{document}
```
::::
:::::

:::{seealso}
La rubrique [](#notes-de-bas-de-page) explique comment créer et lier des
notes de bas de page.
:::

(syntaxe/cibles implicites)=
#### Cibles implicites

<!-- Les pages de cette FAQ peuvent être référencées par un chemin d'accès. -->
Les rubriques des pages de cette FAQ peuvent se voir attribuer une cible
implicite. Les ancres de ces cibles sont automatiquement créées à partir du
titre de la rubrique selon les règles suivantes :

- les titres des rubriques sont convertis en minuscules ;
- la ponctuation est supprimée ;
- les espaces sont remplacés par des `-` ;
- l'unicité est assurée par des numéros en suffixe automatiquement ajoutés et
  incrémentés ;
- pour un lien vers une sous-rubrique d'une autre page on utilise le chemin complet
  du fichier source (voir l'exemple).

:::{warning}
Lorsque le titre d'une rubrique est modifié, son lien change aussi, or la personne
qui fait cette modification ne va probablement pas vérifier si la cible était
déjà référencée ailleurs.

C'est donc une mauvaise pratique que d'utiliser les cibles implicites.
:::

```{example}
On peut faire référence à la [rubrique (ou section) courante](#cibles-implicites)
ainsi qu'à une [sous-rubrique d'une autre page](/1_generalites/bases/comment_obtenir_ce_caractere_sous_macOS.md#le-visualiseur-de-clavier).
```

### Liens

Les liens Markdown se présentent sous quatre formes :

1. Liens automatiques pour les [URL] "nues".
   ::::{tab-set}

   :::{tab-item} Markdown
   ```{example}
   Les liens externes sont reconnus automagiquement :

   - https://www.gutenberg-asso.fr --- ou, simplement, www.gutenberg-asso.fr.
   - ftp://mirrors.ircam.fr/pub/CTAN/.

   Les adresses de courriel, telles que celle-ci : faq@gutenberg-asso.fr, sont
   également reconnues.
   ```
   :::

   :::{tab-item} LaTeX
   ```{noedit}
   \documentclass{article}
   \usepackage[T1]{fontenc}
   \usepackage{lmodern}
   \usepackage{hyperref}
   \begin{document}
   Les liens externes sont reconnus automagiquement~:

   \begin{itemize}
   \item \url{https://www.gutenberg-asso.fr} --- ou, simplement,
     \url{www.gutenberg-asso.fr}.
   \item \url{ftp://mirrors.ircam.fr/pub/CTAN/}.
   \end{itemize}

   Les adresses de courriel, telles que celle-ci~:
   \href{mailto:faq@gutenberg-asso.fr}{\nolinkurl{faq@gutenberg-asso.fr}},
   sont également reconnues.
   \end{document}
   ```
   :::
   ::::
2. Les *liens automatiques* sont des [URI] entourés de `<` et `>`
    à composer notamment selon l'une des syntaxes suivantes :
    - `<⟨schéma⟩:⟨chemin⟩>`
    - `<⟨schéma⟩:⟨chemin⟩#⟨fragment⟩>`

    Plus de détails sur les `⟨schéma⟩`s [ci-dessous](#schemas).
3. *Les liens en ligne* permettent un `⟨texte⟩` et des titres optionnels
   (en HTML, les titres sont rendus sous forme d'infobulles), ainsi :
   ```md
   [⟨texte⟩](⟨destination⟩ "⟨titre explicite optionnel⟩")
   ```
   Par exemple :
   ::::{tab-set}

   :::{tab-item} Markdown
   ```{example}
   [*Uniform Resource Locator*](https://fr.wikipedia.org/wiki/Uniform_Resource_Locator
   "Localisateur uniforme de ressource")
   ```
   :::

   :::{tab-item} LaTeX
   ```{noedit}
   \href{https://fr.wikipedia.org/wiki/Uniform_Resource_Locator}{\emph{Uniform
   Resource Locator}}
   ```
   :::
   ::::
4. Les *liens de référence* définissent la destination séparément dans le
   document et peuvent être utilisés plusieurs fois, ainsi :

   ```{example}
   - [Réseau complet d'archives TeX][ctan].
   - [*Comprehensive TeX Archive Network*][ctan].
   - [CTAN].

   [ctan]: https://ctan.org/
   ```

<!-- :::{seealso} -->
<!-- Cf. la [spécification CommonMark](https://spec.commonmark.org/0.30/#links). -->
<!-- ::: -->

(schemas)=
#### Résolution de la destination par défaut

La destination d'un lien peut être une cible :

- soit **externe**, telle qu'une [URL] vers un autre site web ;
- soit **interne**, telle qu'un fichier, une rubrique ou une figure du même projet.

Par défaut, MyST résout les destinations des liens selon les règles suivantes :

1. Les destinations commençant par un schéma (par exemple `xxx:`) seront traitées selon ce schéma :
   1. Les destinations commençant par `project:` seront traitées comme des
      références internes au projet.
   2. Les destinations commençant par `path:` seront traitées comme des fichiers téléchargeables
   3. Les liens automatiques ou les destinations commençant par `http:`, `https:`, `ftp:`, ou `mailto:` seront traités comme des liens externes [URL].
2. Les destinations qui pointent vers un chemin d'accès à un fichier local sont traitées comme des liens vers ce fichier.
   1. Si la destination est un chemin relatif, elle est résolue par rapport au fichier actuel.
   2. Si la destination est un chemin absolu (c'est-à-dire commençant par `/`), elle est résolue par rapport à la racine du projet (c'est-à-dire le répertoire source).
   3. Si ce chemin se rapporte à un autre document du projet (par exemple un fichier `.md`), il renvoie à la première rubrique de ce document.
   4. Les liens vers les documents du projet peuvent également inclure [un identifiant de fragment]{#cibles-explicites} `#`, pour renvoyer à une rubrique spécifique de ce document.
   5. Si le chemin d'accès est un fichier non source (par exemple un fichier `.png` ou `.pdf`), le lien renverra au fichier lui-même, par exemple pour le télécharger.
3. Les destinations commençant par `#` seront traitées comme des références
   internes avec recherche des cibles selon l'odre suivant :
   1. cibles explicites dans le fichier en cours ;
   2. cibles implicites dans le fichier en cours ;
   3. cibles explicites dans l'ensemble du projet.

   Les cibles non trouvées font l'objet d'avertissements lors de la compilation
   et leurs destinations sont laissées en tant que liens externes.

#### URL propres à cette FAQ personnalisées

La syntaxe des liens récurrents de la présente FAQ est simplifiée.

https://ctan.org/pkg/⟨package⟩ :
: Raccourci :
  ```{example}
  - <ctanpkg:tabularray>
  - [](ctanpkg:tabularray)
  - [le package `tabularray`](ctanpkg:tabularray)
  ```

https://texdoc.net/pkg/⟨package⟩ :
: Raccourci :
  ```{example}
  - <texdoc:tabularray>
  - [](texdoc:tabularray)
  - [la documentation du package `tabularray`](texdoc:tabularray)
  ```

https://texfaq.org/⟨FAQ⟩ :
: Raccourci :
  ```{example}
  [*Getting started*](faquk:FAQ-startup)
  ```

https://fr.wikipedia.org/wiki/Donald_Knuth :
: Raccourci :
  ```{example}
  [Donald Ervin Knuth](wpfr:Donald_Knuth)
  ```

https://en.wikipedia.org/wiki/Donald_Knuth :
: Raccourci :
  ```{example}
  [Donald Ervin Knuth](wp:Donald_Knuth)
  ```

https://isbndb.com/book/⟨ISBN⟩
: Raccourci :
  ```{example}
  [*The LaTeX Companion*](isbn:978-0-13-816648-9)
  ```

https://doi.org/⟨DOI⟩
: Raccourci :
  ```{example}
  [La fonte de ce numéro : *Infini*](doi:10.60028/lettre.vi45.8)
  ```

#### Texte du lien explicite ou implicite

Si le texte du lien est explicitement donné, par exemple `[texte](#dest)`, alors
le texte rendu sera celui-là.  Ce texte peut contenir des balises en ligne
imbriquées, comme `[*accentuation*](#syntaxe/accentuation)`{l=md}.

Si aucun texte n'est donné ou s'il s'agit d'un lien automatique, par exemple
`[](#dest)` ou `<projet:#dest>`, MyST tentera de résoudre un texte implicite.
Par exemple, si la destination est un titre, le texte du titre sera utilisé
comme texte du lien, ou si la destination est une figure ou un tableau, la
légende sera utilisée comme texte du lien.  Dans le cas contraire, le texte du
lien sera la destination elle-même.

#### Lien vers les pages internes de la FAQ

:::{important}
Pour créer un lien vers une page de la FAQ, on pourra utiliser le mécanisme de [liens automatiques](#liens-automatiques)
vers le fichier Markdown cible.
:::

Par exemple, si on veut mettre un lien vers la page
</1_generalites/bases/comment_faire_ses_premiers_pas> dont le fichier
source Markdown se trouve, par rapport au dossier "racine" du projet,
à l’emplacement `1_generalites/bases/comment_faire_ses_premiers_pas.md` de
l’arborescence de la FAQ, il suffira d’écrire le code suivant:

:::{example}
[](/1_generalites/bases/comment_faire_ses_premiers_pas)
:::

:::{important}
Notez :
 - le `/` avant `1_generalites` ;
 - l'affichage automatique du titre de la page visée.
:::

::::{tip} Si la cible n'est pas un [fragment](#cibles-explicites) (une
rubrique autre que le titre) d'une page, on peut omettre l'extension `.md`.

:::{todo} Ces exemples sont à revoir.
```{example}
Ainsi, le lien :
1. [](/1_generalites/bases/comment_faire_ses_premiers_pas.md) est valide ;
2. [](/1_generalites/bases/comment_faire_ses_premiers_pas) est valide ;
3. [](/1_generalites/bases/comment_faire_ses_premiers_pas.md#avec-un-outil-dédié) est valide ;
4. `[](/1_generalites/bases/comment_faire_ses_premiers_pas#avec-un-outil-dédié)`
   **ne serait pas** valide.
```
:::
::::

#### Exemples

##### Liens automatiques

```{example}
URL externe
: <https://example.com> ou https://example.com

Référence cible interne
: <project:#syntaxe/référencement>

Référence à un fichier interne
: <project:/index.md>

Référence à une rubrique de fichier interne
: <project:/index.md#les-questions>

Fichier téléchargeable
: <path:/_static/images/learnlatex.pdf>
```

##### Liens en ligne avec texte implicite

```{example}

Référence cible interne
: [](syntaxe/référencement)

Référence à un fichier interne
: [](/index.md)

Référence à une rubrique de fichier interne
: [](/index.md#les-questions)

Fichier téléchargeable
: [](/_static/images/learnlatex.pdf)
```

##### Liens en ligne avec texte explicite

```{example}
URL externe
: [Texte explicite](https://example.com)

Référence cible interne
: [Texte explicite](syntaxe/référencement)

Référence à un fichier interne
: [Texte explicite](/index.md)

Référence à une rubrique de fichier interne
: [Texte explicite](/index.md#les-questions)

Fichier téléchargeable
: [Texte explicite](/_static/images/learnlatex.pdf)
```


## Admonitions

Les admonitions (également appelées "appels") mettent en évidence un bloc de texte particulier, telles une note ou un avertissement.

Les admonitions sont un cas particulier des extensions {{directive}}.  Il est
conseillé de les utiliser selon la syntaxe suivante :

::::{example}

:::{tip}
Donnons aux lecteurs une astuce utile !
:::

::::

:::{note}
Notez les `:::` en lieu et place des habituels ````  ``` ````. Ces marqueurs,
propres à l'extension MyST Markdown, signifient que le contenu est aussi en MyST
Markdown.
:::

### Types d'admonitions

#### Admonitions de base

Les types d'admonitions classiques disponibles sont illustrés ci-dessous. Notez que (les rendus par défaut de) ces _environnements_ Markdown ont des équivalents LaTeX très proches avec les packages <ctanpkg:awesomebox> et <ctanpkg:alertmessage>.

```{only} latex
Dans ce PDF, les admonitions ont été pour certaines configurées
pour un rendu particulier qui diffère du rendu par défaut.  Voir
la [documentation de Sphinx](https://www.sphinx-doc.org/en/master/latex.html#the-sphinxsetup-configuration-setting),
pour comment ceci est réalisé.
```

::::::{tab-set}

:::::{tab-item} Markdown

```{gut-admonitions} attention, caution, danger, error, hint, important, note, seealso, tip, warning
```
:::::

:::::{tab-item} LaTeX
```{noedit}
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage[utf8]{inputenc}
\usepackage{lmodern}
\usepackage[a4paper]{geometry}
\usepackage{awesomebox}
\usepackage{minted}
\usepackage{babel}

\newcommand{\contenu}[1]{Ceci est une admonition de type \texttt{#1}.}

\begin{document}

\begin{cautionblock}
  \contenu{caution}
\end{cautionblock}

\begin{importantblock}
  \contenu{important}
\end{importantblock}

\begin{noteblock}
  \contenu{note}
\end{noteblock}

\begin{tipblock}
  \contenu{tip}
\end{tipblock}

\begin{warningblock}
  \contenu{warning}
\end{warningblock}

\begin{noteblock}
  De nouveaux environnements peuvent être créés, par exemple ainsi :
  \begin{minted}{latex}
    \definecolor{danger}{RGB}{203, 70, 83}
    \newenvironment{dangerblock}{%
      \begin{awesomeblock}[danger]{2pt}{\faExclamationTriangle}{danger}
    }{
      \end{awesomeblock}
    }
  \end{minted}
\end{noteblock}

\end{document}
```
:::::
::::::

Ces admonitions ne prennent aucun argument, mais peuvent être spécifiées avec des options :

:`class`: liste de classes CSS séparées par des espaces à ajouter à l'admonition.
:`name`: cible de référence pour l'admonition (voir [](syntaxe/référencement)).

::::{example}

:::{tip}
:class: ⟨classe_CSS_1⟩ ⟨classe_CSS_2⟩
:name: label-astuce

Donnons aux lecteurs une astuce utile !
:::

[Référence à mon astuce](#label-astuce).

::::

Au moyen de la directive `admonition`, il est possible de donner un titre
personnalisé à une admonition. On peut alors la styliser selon l'un des types
d'admonition de base avec l'option `class` :

::::{example}

:::{admonition} Mon titre personnalisé avec *Markdown* !
:class: tip

Il s'agit d'un titre personnalisé pour une admonition de type "astuce".
:::

::::

#### "*Todo*"

Si vous remarquez qu'une réponse à une question nécessite d'être actualisée,
révisée ou approfondie, ou bien si vous n'êtes pas sûr de certains aspects de la
réponse que vous être en train de rédiger, vous pouvez attirer l'attention des
autres contributeurs par un "*Todo*" au moyen de l'admonition `todo` :

::::{example}

:::{todo}
Penser à acheter du pain pour ce soir.
:::

::::

#### Source

On dispose aussi de l'admonition `sources` destinée à indiquer des ressources qui
ont servi à la rédaction des réponses à la question de la page (et que nous
tenons à créditer pour leur aide), ou des documents qui permettent d'approfondir
le sujet.

Ainsi, le code suivant :

```md
:::{sources}
- https://www.sphinx-doc.org/
- https://myst-parser.readthedocs.io/en/latest/index.html
:::
```

donnerait-il :

:::{sources}
- https://www.sphinx-doc.org/
- https://myst-parser.readthedocs.io/en/latest/index.html
:::

Une telle admonition est traditionnellement placée en fin de page.

#### Versions

:::{todo}
Les admonitions de versions vont-elles servir pour la présente FAQ ?
:::

On dispose des admonitions suivantes pour indiquer les changements apportés à la documentation :

::::{example}

:::{versionadded} 1.2.3
Explication de la nouvelle fonctionnalité.
:::

:::{versionchanged} 1.2.3
Explication de la modification.
:::

:::{deprecated} 1.2.3
Explication de la dépréciation.
:::

::::

### Admonitions repliables

Il est possible de créer des admonitions repliables, en ajoutant une classe
`dropdown` à l'admonition.

:::::{example}

:::{tip}
:class: dropdown

Une admonition repliée présente l'avantage de pouvoir ajouter un
contenu long, sans qu'il ne prenne trop de place sur la page.

::::{warning}
Mais il faut pas oublier que la FAQ est également produite au format
PDF et que de longs contenus dans de telles admonitions repliables
augmenteront d'autant l'ampleur du document PDF.
::::
:::

:::::

### Autres conteneurs (onglets, "cartes", grilles, etc.)

Il est possible de créer des composants Web adaptés à la taille de l'écran.

::::::{example}

::::{tab-set}

:::{tab-item} Onglet 1
Contenu 1
:::

:::{tab-item} Onglet 2
Contenu 2
:::

::::

::::::


::::{example}
:::{card} Titre de la "carte"
En-tête
^^^
Contenu de la "carte"
+++
Pied de page
:::
::::


:::::{example}
::::{grid} 3
:::{grid-item-card}  Titre 1
A
:::
:::{grid-item-card}  Titre 2
B
:::
:::{grid-item-card}  Titre 3
C
:::
::::
:::::

Les blocs de contenu peuvent être enveloppés dans des conteneurs avec une classe
CSS personnalisée.

::::{example}
:::bg-primary
Il s'agit d'un conteneur doté d'une classe CSS personnalisée.

- Il peut contenir plusieurs blocs
:::
::::


## Tableaux
### Syntaxe Markdown

On peut construire des tableaux en utilisant la [syntaxe Markdown standard adaptée
à Github](https://github.github.com/gfm/#tables-extension-) :

- dans chaque colonne, les lignes en-têtes de colonnes sont à séparer des lignes
ordinaires par au moins trois tirets (`---`) ;
- les colonnes sont séparées par des caractères "*pipe*" (`|`) ;
- chaque extrémité de la ligne doit également être un  caractères "*pipe*".

:::{example}
| Entête 1    | Entête 2    |
|-------------|-------------|
| Cellule 1-1 | Cellule 1-2 |
| Cellule 2-1 | Cellule 2-2 |
:::

Les cellules d'une colonne peuvent être alignées à l'aide du caractère `:` :

:::{example}
| Gauche | Centre | Droite |
|:-------|:------:|-------:|
| a      | b      | c      |
:::

### Tableaux avec légendes

La {{ directive }} `table` peut être utilisée pour créer un tableau avec une légende :

::::{example}
:::{table} Légende du tableau
:widths: auto
:align: center

| Entête 1    | Entête 2    |
|-------------|-------------|
| Cellule 1-1 | Cellule 1-2 |
| Cellule 2-1 | Cellule 2-2 |
:::
::::

Les options suivantes sont reconnues :

:::{admonition} Liste des options du tableau
:class: hint

`align` : `left`, `center`, ou `right`
: Alignement horizontal du tableau.

`width` : `⟨longueur⟩` ou `⟨pourcentage⟩`
: Largeur du tableau égale à la `⟨longueur⟩` spécifiée ou au `⟨pourcentage⟩` de
  la largeur de la ligne (même unités et principe qu'avec LaTeX).
: S'il est omis, le moteur de rendu détermine la largeur du tableau en fonction
  de son contenu ou de la largeur des colonnes.

`widths` : liste d’`⟨entiers⟩`, `auto` ou `grid`
: liste d’`⟨entiers⟩` définit explicitement la largeur des colonnes. Spécifie
  les largeurs relatives si elle est utilisée avec l'option `width`.
: `auto` délègue la détermination de la largeur des colonnes au moteur de rendu du backend.
: `grid` détermine la largeur des colonnes à partir de la largeur des colonnes d'entrée (en caractères).

:::

### Syntaxe de listes

On peut utiliser la {{directive}} `list-table` pour construire des tableaux à partir
des données de listes à puces uniformes à deux niveaux.  "Uniforme" signifie
que chaque sous-liste (liste de second niveau) doit contenir le même nombre
d'items.

```{tabularcolumns} cLL
```

::::{example}
:::{list-table} Unités de longueurs accessibles
:widths: 15 10 30
:header-rows: 1
:stub-columns: 1

* - Unité
  - Nom
  - Définition
* - `mm`
  - millimètre
  - 1 mm = $10^{-3}$ m
* - `cm`
  - centimètre
  - 1 cm = 10 mm
* - `in`
  - pouce
  -  1 in = 2,54 cm = 96 px
* - `px`
  - pixel
  - 1 px = 1/96 in
* - `pt`
  - point
  - 1 pt = 1/72 in
* - `pc`
  - pica
  - 1 pc = 1/6 in = 12 pt
* - `em`
  - unité em
  - taille de la police de l'élément
* - `ex`
  - unité ex
  - hauteur x de la police de l'élément
:::
::::

Les options suivantes sont reconnues :

:::{admonition} Options des tableaux de listes
:class: hint

`align` : `left`, `center`, ou `right`
: Alignement horizontal du tableau.

`header-rows` : `⟨entier⟩`
: Nombre de lignes de données de liste à utiliser dans l'en-tête du tableau. La
  valeur par défaut est 0.

`stub-columns` : `⟨entier⟩`
: Nombre de colonnes du tableau à utiliser en tant que stubs (titres de lignes,
  à gauche). La valeur par défaut est 0.

`width` : `⟨longueur⟩` ou `⟨pourcentage⟩`
: Largeur du tableau égale à la `⟨longueur⟩` spécifiée ou au `⟨pourcentage⟩` de la
  largeur de la ligne (même unités et principe qu'avec LaTeX).
: S'il est omis, le moteur de rendu détermine la largeur du tableau en fonction
  de son contenu ou de la largeur des colonnes.

`widths` : `auto` ou liste d’`⟨entiers⟩`
: liste d’`⟨entiers⟩` définit les largeurs de colonnes relatives. La valeur par
  défaut est la largeur égale des colonnes.
: `auto` délègue la détermination de la largeur des colonnes au constructeur de sortie.

`classe`
: Liste de classes CSS séparées par des espaces à ajouter au tableau.

`name`
: Cible de référence pour le tableau (voir [](syntaxe/référencement)).

:::

:::{note}

Dans l'exemple précédent, on remarque incidemment la possibilité, en utilisant
la syntaxe LaTeX, de faire figurer dans le fichier Markdown des formules de
mathématique.

:::

## Images et figures

Markdown (sauce MyST) permet d’inclure des images et des figures dans les
documents, ainsi que d’y faire référence facilement.

### Images en ligne

La syntaxe Markdown standard est la suivante.

:::::{tab-set}

::::{tab-item} Markdown
```{example}
![logofaq](/_static/logoFAQ-light-theme.*)
```
::::

::::{tab-item} LaTeX
```{noedit}
\includegraphics{/_static/logoFAQ-light-theme}
```
::::
:::::

:::{note}

En LaTeX, il est en général conseillé de ne pas spécifier l'extension du fichier
image à afficher, par exemple :
`\includegraphics{/_static/logoFAQ-light-theme}`. En Markdown, l'équivalent
consiste à recourir à l'extension générique `.*` :
`![logofaq](/_static/logoFAQ-light-theme.*)`.
:::

### Figures

Pour créer une **figure**, utilisez la {{ directive }} `figure` :

:::::{tab-set}

::::{tab-item} Markdown
:::{example}
```{figure} /_static/logoFAQ-light-theme.*
:width: 50%
:alt: Logo FAQ GUTenberg
:name: logo
:align: center
Ceci est la légende (facultative) de la figure. Il s'agit d'un simple paragraphe.
```
:::
::::

::::{tab-item} LaTeX
```{noedit}

\begin{figure}
  \centering
  \includegraphics[width=.5\linewidth]{/_static/logoFAQ-light-theme}
  \caption{Ceci est la légende (facultative) de la figure. Il s'agit d'un simple paragraphe.}
  \label{logo}
\end{figure}
```
::::
:::::

De nombreuses options permettent de modifier une telle figure :

:::{admonition} Options des blocs images
:class: tip

`alt` : `⟨texte⟩`
: Texte alternatif : une courte description de l’image, notamment pour les personnes malvoyantes.

`height` : `⟨longueur⟩`
: Hauteur désirée pour l’image.

`width` : `⟨longueur⟩` ou `⟨pourcentage⟩` de la largeur de la ligne courante
: Largeur désirée pour l’image.

<!-- `figwidth` : `image`, une `⟨longueur⟩` ou un `⟨pourcentage⟩` de la largeur de la ligne actuelle -->
<!-- : Largeur de la figure.  Si la valeur est `image`, la largeur de l'image est utilisée.  est utilisée.  Sinon, la valeur est interprétée comme une longueur ou un pourcentage de la largeur de la ligne courante. -->

`scale` : `⟨pourcentage entier⟩`, compris entre 0 et 100 (le symbole `%` est optionel)
: Le facteur d’échelle uniforme pour l’image. La valeur par défaut est de `100%` (pas de facteur d’échelle).

`align` : `top`, `middle`, `bottom`, `left`, `center`, ou `right`
: Les valeurs :
  - `top`, `middle`, et `bottom` contrôlent  l’alignement vertical de l’image.
  - `left`, `center`, et `right` contrôlent l’alignement horizontale de l’image, et autorise l’image à flotter et à ce que le texte _coule_ autour d’elle.

`target` : `⟨[URI] ou référence⟩`
: Fait de l'image un hyperlien clicable envoyant au lien souhaité.

`name`
: Label en vue de référence croisée.
:::

::::::{seealso}

Il est également de créer des figures qui utilisent la syntaxe Markdown native
pour les images.

:::::{tab-set}
::::{tab-item} Markdown
```{example}
![Notre logo](/_static/logoFAQ-light-theme.*){width=200px align=right}

Ceci est une légende en *Markdown*. Remarquez comment le texte coule autour
de l'image (option `align=right`).

Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed non risus.
Suspendisse lectus tortor, dignissim sit amet, adipiscing nec, ultricies sed,
dolor. Cras elementum ultrices diam. Maecenas ligula massa, varius a, semper
congue, euismod non, mi. Proin porttitor, orci nec nonummy molestie, enim est
eleifend mi, non fermentum diam nisl sit amet erat. Duis semper. Duis arcu
massa, scelerisque vitae, consequat in, pretium a, enim. Pellentesque congue. Ut
in risus volutpat libero pharetra tempor.
```
::::

::::{tab-item} LaTeX
```{noedit}

\documentclass{article}
\usepackage[T1]{fontenc}
\usepackage{lmodern}
\usepackage{graphicx}
\usepackage{wrapfig2}
\begin{document}
\begin{wrapfigure}{r}{50mm}
\centering
\includegraphics[width=5.3cm]{/_static/logoFAQ-light-theme}
\end{wrapfigure}
Ceci est une légende en \emph{Markdown}. Remarquez comment le texte
coule autour de l'image (option \verb|align=right|).

Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed non risus.
Suspendisse lectus tortor, dignissim sit amet, adipiscing nec, ultricies sed,
dolor. Cras elementum ultrices diam. Maecenas ligula massa, varius a, semper
congue, euismod non, mi. Proin porttitor, orci nec nonummy molestie, enim est
eleifend mi, non fermentum diam nisl sit amet erat. Duis semper. Duis arcu
massa, scelerisque vitae, consequat in, pretium a, enim. Pellentesque congue. Ut
in risus volutpat libero pharetra tempor.
\end{document}
```
::::
:::::
::::::

<!-- ## Figures avec plusieurs images -->
<!--  -->
<!-- Voir l'extension [sphinx-subfigure](https://sphinx-subfigure.readthedocs.io) pour créer des figures avec plusieurs images. -->


## Commentaires

Il est possible d'ajouter des commentaires (autrement dit, comme en LaTeX, des
portions du fichier source n'apparaissant pas dans la page HTML générée). Pour
ce faire, deux méthodes :

1. placer le caractère `%` au début d'une ligne à commenter ;
2. recourir à la syntaxe HTML (`<!-- Ceci est un commentaire -->`)


Par exemple, ce qui suit ne figurera pas dans le document final :

::::{tab-set}

:::{tab-item} Markdown
```{example}
% Un commentaire...

<!-- et un autre commentaire. -->
```
:::

:::{tab-item} LaTeX
```{noedit}
% Un commentaire...

% et un autre commentaire.
```
:::
::::

::::{admonition} Les commentaires sont divisés en paragraphes
:class: warning dropdown

Les commentaires étant une entité au niveau du bloc, ils terminent le bloc
précédent. Cela signifie que, contrairement à ce qu'on observe avec LaTeX, les
lignes suivantes entameront un nouveau paragraphe :

:::{example}
une ligne
% un commentaire
une autre ligne
:::

::::

(syntax/notes-de-bas-de-page)=
## Notes de bas de page

Les notes de bas de page utilisent la [spécification `pandoc`](https://pandoc.org/MANUAL.html#footnotes).
Leurs labels **commencent par `^`** et peuvent être n'importe quelle chaîne alphanumérique (sans espace), sans tenir compte des majuscules et des minuscules.

- Si le label est un entier, le libellé affiché est cet entier (numérotation manuelle).
- Sinon, les libellés affichés sont numérotés automatiquement dans l'ordre dans
  lequel les notes sont référencées, indépendamment des labels numérotés manuellement.

Les notes de bas de page sont rassemblées et affichées en bas de page (dans l'ordre où elles sont référencées).
Les notes de bas de page non référencées ne sont pas affichées.

::::{tab-set}

:::{tab-item} Markdown
```{example}
- Voici une note de bas de page numérotée manuellement[^3].
- Voici un renvoi à une note de bas de page automatiquement numérotée[^maref].

[^maref]: Il s'agit d'une définition de note de bas de page auto-numérotée.
[^3]: Il s'agit d'une définition de note de bas de page numérotée manuellement.
```
:::

:::{tab-item} LaTeX
```{noedit}
\begin{itemize}
\item Voici une note de bas de page numérotée manuellement%
  \footnotemark[3]%
  \footnotetext[3]{Il s'agit d'une définition de note de bas de page numérotée
    manuellement.}.
\item Voici un renvoi à une note de bas de page automatiquement
  numérotée\footnote{Il s'agit d'une définition de note de bas de page
    auto-numérotée.}.
\end{itemize}
```
:::
::::

Tout texte suivant une définition de note de bas de page, *indenté de
quatre espaces ou plus*, est également inclus dans la définition de la note de
bas de page.

:::{example}
Une définition de note de bas de page sur plusieurs lignes[^malongueref].

[^malongueref]: Il s'agit de la _**définition de la note de bas de page**_.

    Elle se poursuit pour toutes les lignes indentées

    - même pour les autres éléments du bloc

    Plus toutes les lignes précédentes non indentées,
qui ne sont pas séparées par une ligne vide

Ceci ne fait pas partie de la note de bas de page.
:::

```{important}
À l'intérieur des {{ directive }}s, bien que les notes de bas de page puissent sans
problème être  *référencées* (par exemple[^maref]), il est recommandé de ne pas les
*définir*, à moins qu'elles ne soient référencées qu'à l'intérieur de cette même
{{ directive }} : en effet, sinon, il se peut qu'elles ne soient *référençables qu'à
l'intérieur* de cette {{ directive }} particulière.
```

## Conversions textuelles

Markdown peut convertir certains caractères ou chaînes de caractère
prédéfinis en image, autre texte, ou HTML.

1. Les guillemets standards (*doublequotes*) sont automatiquement convertis en
leurs variantes ouvrante/fermante (conformes à la typographie française) :

    - `"guillemets doubles"` : "guillemets doubles" ;
    - `'guillemets simples'` : 'guillemets simples'.

2. Certains symboles typographiques et ligatures communs peuvent être obtenus
   soit par conversion automatique, soit par saisie directe sous forme de
   caractères Unicode :

| Texte source        | Texte converti |
|---------------------|----------------|
| `(c)`, `(C)`, `©`   | (c)            |
| `(tm)`, `(TM)`, `™` | (tm)           |
| `(r)`, `(R)`, `®`   | (r)            |
| `+-`, `±`           | +-             |
| `...`, `…`          | ...            |
| `--`, `–`           | --             |
| `---`, `—`          | ---            |
<!-- | `?....`             | ?.... ?..      | -->
<!-- | `!....`             | !.... !..      | -->
<!-- | `????????`          | ????????  ???  | -->
<!-- | `!!!!!`             | !!!!!     !!!  | -->
<!-- | `,,,`               | ,,,        ,   | -->

## Logos TeX, LaTeX, etc.

Les logos tels que "TeX" et "LaTeX" sont mis en forme sans peine puisqu'il
suffit de les saisir tels quels : ils sont "logoifiés" automatiquement au cours
de la compilation de la FAQ. Leur liste exhaustive est la suivante :

| Code        | Résultat  |
|-------------|-----------|
| `(La)TeX`   | (La)TeX   |
| `AmS-LaTeX` | AmS-LaTeX |
| `AmS-TeX`   | AmS-TeX   |
| `AmSLaTeX`  | AmSLaTeX  |
| `AmSTeX`    | AmSTeX    |
| `BibTeX`    | BibTeX    |
| `eTeX`      | eTeX      |
| `e-TeX`     | e-TeX     |
| `LaTeX`     | LaTeX     |
| `LaTeX(2e)` | LaTeX(2e) |
| `LaTeX2e`   | LaTeX2e   |
| `LaTeXe`    | LaTeXe    |
| `LuaLaTeX`  | LuaLaTeX  |
| `LuaTeX`    | LuaTeX    |
| `LyX`       | LyX       |
| `Metafont`  | Metafont  |
| `Metapost`  | Metapost  |
| `PiCTeX`    | PiCTeX    |
| `SliTeX`    | SliTeX    |
| `teTeX`     | teTeX     |
| `TeX`       | TeX       |
| `TeXLaTeX`  | TeXLaTeX  |
| `Xe(La)TeX` | Xe(La)TeX |
| `XeLaTeX`   | XeLaTeX   |
| `XeTeX`     | XeTeX     |

## Émoticônes

Les émoticônes *graphiques* peuvent être directement insérés sous forme de
caractères Unicode dans les sources Markdown et sont alors rendus tels quels :

```{example}
Ainsi : 😂, 😉, 🤪, 🎉.
```

En revanche, les émoticônes *typographiques* ne sont pas convertis[^emoticonestypo] :

```{example}
;) ≠ 😉
```

[^emoticonestypo]: Il est possible que cela [change un jour](https://github.com/executablebooks/MyST-Parser/issues/565).

## Citations

Pour signifier que du texte est une réponse ou un commentaire, on peut utiliser
la syntaxe suivante (que la plupart des courrielleurs mettent en œuvre
automatiquement) :

<!-- ```{example} -->
<!-- Je pense que nous devrions le faire. -->
<!-- > Non nous ne devrions pas. -->
<!-- >> Eh bien, je pense que si. -->
<!-- > Vraiment ? -->
<!-- >> Oui ! -->
<!-- >>> Alors faisons-le ! -->
<!-- ``` -->

```{example}
Parce que sinon ça rend la discussion incompréhensible.
> Pourquoi ça ?
>> Je préfère répondre en dessous.
>>> Que faites-vous à la place ?
>>>> Non.
>>>>> Vous n'aimez pas répondre au-dessus ?
```

<!-- ## Agrégation de fils RSS/ATOM -->
<!--  -->
<!-- :::{todo} -->
<!-- Cf. . -->
<!-- ::: -->


## Mots clés

Afin qu'elles soient bien indexées par les moteurs de recherche, les pages de la
FAQ peuvent être enrichies de métadonnées, notamment de mots clés. Cela se fait
au moyen de quelques lignes de code <wpfr:YAML> (dont il n'est pas nécessaire de
maîtriser la syntaxe), à placer obligatoirement en préambule (au début) du
fichier source Markdown entre paire de triples tirets (`---`). Ainsi le fichier
source de la page
[](/3_composition/texte/renvois/references_croisees_entre_documents)
commence-t-il par :

::::{tab-set}

:::{tab-item} Markdown
```yaml
---
myst:
  html_meta:
    keywords: LaTeX,renvois,labels,références
---
```
:::

:::{tab-item} LaTeX
```{noedit}
\usepackage{hyperref}
\hypersetup{
  pdfkeywords={LaTeX,renvois,labels,références},
}
```
:::
::::

## Substitutions

Il est possible de faire usage de substitutions, à la manière des macros
personnelles sous LaTeX. Elles se définissent dans le préambule `YAML` d'un
fichier source au moyen de paires clés/valeurs imbriquées dans la clé
`substitutions`. Ainsi, on pourrait définir la substitution `dek` pour "Donald
Ervin Knuth" qu'on emploierait ensuite dans le fichier Markdown au moyen de
`{{dek}}` :

::::{tab-set}

:::{tab-item} Markdown
```yaml
---
myst:
  substitutions:
    dek: "Donald Ervin Knuth"
---
```
```{example}
À l’origine, {{dek}} a développé TeX (en `WEB`) notamment pour réaliser de beaux
documents et écrire des formules mathématiques.
```
:::

:::{tab-item} LaTeX
```{noedit}
\newcommand{\dek}{Donald Ervin Knuth}
À l’origine, \dek{} a développé \TeX{} (en \texttt{WEB}) notamment pour réaliser
de beaux documents et écrire des formules mathématiques.
```
:::
::::

:::{note} Les substitutions définies dans le préambule `YAML` d'un fichier
source Markdown sont locales à ce fichier. Il est également possible de définir
des substitutions globales à toute la FAQ ; pour l'instant, aucune n'a été ainsi
définie mais, si le besoin s'en fait sentir, n'hésitez pas à nous le signaler
sur [liste dédiée à la FAQ](mailto:faq@gutenberg-asso.fr) ou en ouvrant un
"ticket" [ici](https://gitlab.gutenberg-asso.fr/gutenberg/faq-gut/-/issues/new) et nous
ferons le nécessaire.
:::

## Canevas

Lorsque vous créerez de nouvelles pages pour partager votre expérience avec
LaTeX, vous pourrez vous aider du canevas suivant.

```md
---
myst:
  html_meta:
    keywords: ⟨mot clé 1⟩, ⟨mot clé 2⟩
---
# ⟨Question⟩ ?

⟨Réponse(s)⟩

:::{sources}
⟨Source(s)⟩
:::
```

## Glossaire

{.glossary}
Directive
: Les directives permettent d'étendre de façon illimitée la syntaxe de MyST, en
  interprétant un morceau de texte comme un type spécifique de balisage, en
  fonction de son nom. Elles sont utilisées pour délimiter une certaine partie
  du texte afin de la mettre en évidence, souvent sous forme de bloc. Il peut
  s'agir d'une admonition, de lignes de code, d'une figure (ou d'un tableau)
  avec légende, etc.

:::{sources}
- https://www.sphinx-doc.org/
- https://myst-parser.readthedocs.io/en/latest/index.html
:::

[^1]: Ceci est une note de pied de page

[^2]: Si les proportions de l'image ne sont pas respectées, celle-ci
    sera découpée avant redimensionnement selon les nouvelles
    proportions

[uri]: https://fr.wikipedia.org/wiki/Uniform_Resource_Identifier
[url]: https://fr.wikipedia.org/wiki/Uniform_Resource_Locator
