/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef PUSHBUTTONWIDGET_H
#define PUSHBUTTONWIDGET_H

#include <QWidget>
#include <QFrame>

#include <QHBoxLayout>
#include <QPushButton>

#include "fixlabel.h"
#include "libukcc_global.h"
#include "ukccframe.h"

/**
 * @brief 创建一个带 QPushButton 的 Frame
 *
 */
class LIBUKCC_EXPORT PushButtonWidget : public UkccFrame
{
    Q_OBJECT
public:
    /**
     * @brief 创建一个带 QPushButton 的 Frame
     *
     * @param title:  text of m_settingName
     * @param style:  设置圆角（None:无圆角,Top:上圆角,Bottom:下圆角,Around:四圆角）
     * @param parent
     */
    explicit PushButtonWidget(const QString title, QWidget *parent = nullptr, UkccFrame::BorderRadiusStyle style = UkccFrame::None);
    /**
     * @brief
     *
     */
    ~PushButtonWidget();

    /**
     * @brief 设置 m_pushButton 是否可点击
     *
     * @param checked
     */
    void setEnabled(const bool checked);

    /**
     * @brief 获取 m_pushButton 是否可点击
     *
     * @return bool 是：true，否：false
     */
    bool isEnabled() const;

    /**
     * @brief 设置 m_settingName text
     *
     * @param title
     */
    void setTitle(const QString &title);

    /**
     * @brief 获取 m_settingName text
     *
     * @return QString
     */
    QString title() const;

    /**
     * @brief 设置 m_settingName label 宽度
     *
     * @param w
     */
    void setTitleFixedWidth(int w);

    /**
     * @brief 设置 m_pushButton text
     *
     * @param text
     */
    void setButtonText(const QString & text);

    /**
     * @brief 设置 m_pushButton 宽度
     *
     * @param w
     */
    void setButtonFixedWidth(int w);

    /**
     * @brief 设置 m_iconLabel 图标
     *
     * @param icon
     */
    void setIconLabel(QIcon icon);

    /**
     * @brief 获取 m_pushButton
     *
     * @return QPushButton:  m_pushButton
     */
    QPushButton *pushButton();

private:
    void init();

    QHBoxLayout *mainLayout;
    FixLabel *m_settingName;
    QPushButton *m_pushButton;
    QLabel *m_iconLabel;

private Q_SLOTS:

Q_SIGNALS:
    /**
     * @brief m_pushButton 点击信号
     *
     * @param checked
     */
    void clicked(bool checked = false);
};

#endif // PUSHBUTTONWIDGET_H
