/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class QchemReader
extends MOReader {
    private int calculationNumber = 1;
    private MOInfo[] alphas = null;
    private MOInfo[] betas = null;
    private int nShell = 0;
    private int nBasis = 0;

    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("Standard Nuclear Orientation") >= 0) {
            this.readAtoms();
            this.moData = null;
            return true;
        }
        if (this.line.indexOf("Requested basis set is") >= 0) {
            this.readCalculationType();
            return true;
        }
        if (this.line.indexOf("VIBRATIONAL FREQUENCIES") >= 0) {
            this.readFrequencies();
            return true;
        }
        if (this.line.indexOf("Mulliken Net Atomic Charges") >= 0) {
            this.readPartialCharges();
            return true;
        }
        if (this.line.startsWith("Job ")) {
            ++this.calculationNumber;
            this.moData = null;
            return true;
        }
        if (this.line.indexOf("Basis set in general basis input format") >= 0) {
            if (this.moData == null) {
                this.readBasis();
            }
            return true;
        }
        if (this.moData == null) {
            return true;
        }
        if (this.line.indexOf("Orbital Energies (a.u.) and Symmetries") >= 0) {
            if (this.filterMO()) {
                this.readESym(true);
            }
            return true;
        }
        if (this.line.indexOf("Orbital Energies (a.u.)") >= 0) {
            if (this.filterMO()) {
                this.readESym(false);
            }
            return true;
        }
        if (this.line.indexOf("MOLECULAR ORBITAL COEFFICIENTS") >= 0) {
            if (this.filterMO()) {
                this.readQchemMolecularOrbitals();
            }
            return true;
        }
        return this.checkNboLine();
    }

    private void readCalculationType() {
        this.calculationType = this.line.substring(this.line.indexOf("set is") + 6).trim();
    }

    private void readAtoms() throws Exception {
        this.atomSetCollection.newAtomSet();
        this.discardLines(2);
        while (this.readLine() != null && !this.line.startsWith(" --")) {
            String string;
            String[] stringArray = this.getTokens();
            if (stringArray.length < 5 || JmolAdapter.getElementNumber(string = stringArray[1]) < 1) continue;
            float f = this.parseFloat(stringArray[2]);
            float f2 = this.parseFloat(stringArray[3]);
            float f3 = this.parseFloat(stringArray[4]);
            if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) continue;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = string;
            atom.set(f, f2, f3);
            this.atomSetCollection.setAtomSetProperty(".PATH", "Calculation " + this.calculationNumber);
        }
    }

    private void readFrequencies() throws Exception, IOException {
        while (this.readLine() != null && this.line.indexOf("STANDARD") < 0) {
            if (!this.line.startsWith(" Frequency:")) {
                this.discardLinesUntilStartsWith(" Frequency:");
            }
            String[] stringArray = this.getTokens();
            int n = stringArray.length - 1;
            boolean[] blArray = new boolean[n];
            int n2 = this.atomSetCollection.getLastAtomSetAtomCount();
            int n3 = this.atomSetCollection.getAtomCount();
            for (int i = 0; i < n; ++i) {
                boolean bl = blArray[i] = !this.doGetVibration(++this.vibrationNumber);
                if (blArray[i]) continue;
                this.atomSetCollection.cloneLastAtomSet();
                this.atomSetCollection.setAtomSetName(stringArray[i + 1] + " cm^-1");
                this.atomSetCollection.setAtomSetProperty("Frequency", stringArray[i + 1] + " cm^-1");
                this.atomSetCollection.setAtomSetProperty(".PATH", "Calculation " + this.calculationNumber + SmarterJmolAdapter.PATH_SEPARATOR + "Frequencies");
            }
            this.discardLinesUntilStartsWith("               X");
            this.fillFrequencyData(n3, n2, n2, blArray, true, 0, 0, null);
            this.discardLinesUntilBlank();
        }
    }

    private void readPartialCharges() throws Exception {
        this.discardLines(3);
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        int n = this.atomSetCollection.getLastAtomSetAtomCount();
        for (int i = 0; i < n && this.readLine() != null; ++i) {
            atomArray[i].partialCharge = this.parseFloat(this.getTokens()[2]);
        }
    }

    private void readBasis() throws Exception {
        int n;
        int n2;
        String[] stringArray;
        Object object;
        this.moData = new Hashtable();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Vector<float[][]> vector = new Vector<float[][]>();
        Vector<String[]> vector2 = new Vector<String[]>();
        this.discardLinesUntilStartsWith("$basis");
        this.readLine();
        while (this.readLine() != null) {
            if (this.line.startsWith("****")) {
                ++n3;
                if (this.readLine() == null || !this.line.startsWith("$end")) continue;
                break;
            }
            ++n4;
            object = new int[4];
            stringArray = QchemReader.getTokens(this.line);
            object[0] = (float[])n3;
            object[1] = (float[])JmolAdapter.getQuantumShellTagID(stringArray[0]);
            object[2] = (float[])n5;
            n2 = this.parseInt(stringArray[1]);
            object[3] = (float[])n2;
            vector.addElement((float[][])object);
            n5 += n2;
            for (n = 0; n < n2; ++n) {
                vector2.addElement(QchemReader.getTokens(this.readLine()));
            }
        }
        object = new float[n5][];
        for (n2 = 0; n2 < n5; ++n2) {
            stringArray = (String[])vector2.get(n2);
            object[n2] = new float[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                object[n2][n] = this.parseFloat(stringArray[n]);
            }
        }
        this.moData.put("shells", vector);
        this.moData.put("gaussians", object);
        if (Logger.debugging) {
            Logger.debug(n4 + " slater shells read");
            Logger.debug(n5 + " gaussian primitives read");
        }
        this.discardLinesUntilStartsWith(" There are");
        stringArray = QchemReader.getTokens(this.line);
        this.nShell = this.parseInt(stringArray[2]);
        this.nBasis = this.parseInt(stringArray[5]);
        this.moData.put("calculationType", this.calculationType);
    }

    private void readESym(boolean bl) throws Exception {
        String[] stringArray = new String[]{"A", "B"};
        this.alphas = new MOInfo[this.nBasis];
        this.betas = new MOInfo[this.nBasis];
        int n = 0;
        boolean bl2 = false;
        this.discardLinesUntilStartsWith(" Alpha");
        String[] stringArray2 = QchemReader.getTokens(this.line);
        MOInfo[] mOInfoArray = this.alphas;
        block0: for (int i = 0; i < 2; ++i) {
            int n2 = 0;
            while (this.readLine() != null) {
                if (this.line.startsWith(" -- ")) {
                    n = 0;
                    if (this.line.indexOf("Vacant") < 0 && this.line.indexOf("Occupied") > 0) {
                        n = 1;
                    }
                    this.readLine();
                }
                if (this.line.startsWith(" -------")) {
                    i = 2;
                    continue block0;
                }
                int n3 = QchemReader.getTokens(this.line).length;
                if (n3 == 0 || this.line.startsWith(" Warning")) {
                    this.discardLinesUntilStartsWith(" Beta");
                    bl2 = true;
                    mOInfoArray = this.betas;
                    continue block0;
                }
                if (bl) {
                    stringArray2 = QchemReader.getTokens(this.readLine());
                }
                int n4 = 0;
                int n5 = 0;
                while (n4 < n3) {
                    MOInfo mOInfo = new MOInfo();
                    mOInfo.ne = n;
                    mOInfo.label = stringArray[i];
                    if (bl) {
                        mOInfo.moSymmetry = stringArray2[n5] + stringArray2[n5 + 1];
                    }
                    mOInfoArray[n2] = mOInfo;
                    ++n2;
                    ++n4;
                    n5 += 2;
                }
            }
        }
        if (!bl2) {
            this.betas = this.alphas;
        }
    }

    private void readQchemMolecularOrbitals() throws Exception {
        Object object;
        int n;
        int[] nArray = new int[]{1, 3, 4, 6, 5, 10, 7};
        int[][] nArrayArray = new int[][]{{0}, {0, 1, 2}, {0, 1, 2, 3}, {0, 3, 1, 4, 5, 2}, {4, 2, 0, 1, 3}, {0, 4, 3, 1, 5, 9, 8, 6, 7, 2}, {6, 4, 2, 0, 1, 3, 5}};
        float[] fArray = new float[10];
        Vector vector = new Vector();
        String[] stringArray = new String[this.nBasis];
        String string = QchemReader.getTokens(this.line)[0];
        int n2 = this.readMOs(string.equals("RESTRICTED"), stringArray, vector, this.alphas);
        if (string.equals("ALPHA")) {
            this.discardLinesUntilContains("BETA");
            n2 += this.readMOs(false, stringArray, vector, this.betas);
        }
        int n3 = 0;
        Vector vector2 = (Vector)this.moData.get("shells");
        float[][] fArrayArray = new float[n2][];
        for (n = 0; n < n2; ++n) {
            object = (Hashtable)vector.get(n);
            fArrayArray[n] = (float[])((Hashtable)object).get("coefficients");
        }
        for (n = 0; n < this.nShell; ++n) {
            object = (int[])vector2.get(n);
            if (QchemReader.getTokens(stringArray[n3]).length > 1) {
                Object object2 = object;
                object2[1] = object2[1] + object[1] % 2;
            }
            int n4 = nArray[object[1]];
            if (object[1] >= 3) {
                for (int i = 0; i < n2; ++i) {
                    int[] nArray2 = nArrayArray[object[1]];
                    int n5 = 0;
                    int n6 = n3;
                    while (n5 < n4) {
                        fArray[nArray2[n5]] = fArrayArray[i][n6];
                        ++n5;
                        ++n6;
                    }
                    n5 = 0;
                    n6 = n3;
                    while (n5 < n4) {
                        fArrayArray[i][n6] = fArray[n5];
                        ++n5;
                        ++n6;
                    }
                }
            }
            n3 += n4;
        }
        this.moData.put("mos", vector);
        this.moData.put("energyUnits", "au");
        this.setMOData(this.moData);
    }

    private int readMOs(boolean bl, String[] stringArray, Vector vector, MOInfo[] mOInfoArray) throws Exception {
        Hashtable[] hashtableArray = new Hashtable[6];
        float[][] fArrayArray = new float[6][];
        int[] nArray = new int[6];
        int n = 0;
        while (this.readLine().length() > 2) {
            int n2;
            String[] stringArray2 = QchemReader.getTokens(this.line);
            int n3 = stringArray2.length;
            String[] stringArray3 = QchemReader.getTokens(this.readLine().substring(13));
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = this.parseInt(stringArray2[n2]) - 1;
                fArrayArray[n2] = new float[this.nBasis];
                hashtableArray[n2] = new Hashtable();
            }
            for (n2 = 0; n2 < this.nBasis; ++n2) {
                stringArray2 = QchemReader.getTokens(this.readLine());
                stringArray[n2] = this.line.substring(12, 17);
                int n4 = stringArray2.length - n3;
                for (int i = 0; i < n3; ++i) {
                    fArrayArray[i][n2] = this.parseFloat(stringArray2[n4]);
                    ++n4;
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                MOInfo mOInfo = mOInfoArray[nArray[n2]];
                hashtableArray[n2].put("energy", new Float(stringArray3[n2]));
                hashtableArray[n2].put("coefficients", fArrayArray[n2]);
                String string = mOInfo.label;
                int n5 = mOInfo.ne;
                if (bl) {
                    n5 = this.alphas[nArray[n2]].ne + this.betas[nArray[n2]].ne;
                }
                hashtableArray[n2].put("occupancy", new Float(n5));
                if (n5 == 2) {
                    string = "AB";
                }
                if (n5 == 0) {
                    string = bl ? "V" : "V" + string;
                }
                hashtableArray[n2].put("symmetry", mOInfo.moSymmetry + " " + string + "(" + (nArray[n2] + 1) + ")");
                vector.addElement(hashtableArray[n2]);
            }
            n += n3;
        }
        return n;
    }

    protected class MOInfo {
        int ne = 0;
        String label = "???";
        String moSymmetry = "???";

        protected MOInfo() {
        }
    }
}

