/*
 * Decompiled with CFR 0.152.
 */
package org.dvb.media;

import java.awt.Rectangle;
import org.havi.ui.HScreenPoint;

public class VideoTransformation {
    private Rectangle clip = null;
    private float hscaling;
    private float vscaling;
    private HScreenPoint position;

    public VideoTransformation() {
        this.hscaling = 1.0f;
        this.vscaling = 1.0f;
        this.position = new HScreenPoint(0.0f, 0.0f);
    }

    public VideoTransformation(Rectangle clipRect, float horizontalScalingFactor, float verticalScalingFactor, HScreenPoint location) {
        if (clipRect != null) {
            this.clip = new Rectangle(clipRect);
        }
        this.hscaling = horizontalScalingFactor;
        this.vscaling = verticalScalingFactor;
        this.position = new HScreenPoint(location.x, location.y);
    }

    public void setClipRegion(Rectangle clipRect) {
        this.clip = clipRect != null ? new Rectangle(clipRect) : null;
    }

    public Rectangle getClipRegion() {
        return !this.isPanAndScan() && this.clip != null ? new Rectangle(this.clip) : null;
    }

    public void setScalingFactors(float horizontalScalingFactor, float verticalScalingFactor) {
        this.hscaling = horizontalScalingFactor;
        this.vscaling = verticalScalingFactor;
    }

    public float[] getScalingFactors() {
        return new float[]{this.hscaling, this.vscaling};
    }

    public void setVideoPosition(HScreenPoint location) {
        this.position = new HScreenPoint(location.x, location.y);
    }

    public HScreenPoint getVideoPosition() {
        return new HScreenPoint(this.position.x, this.position.y);
    }

    public boolean isPanAndScan() {
        return false;
    }
}

